; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -global-isel -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32I
; RUN: llc -mtriple=riscv32 -global-isel -mattr=+zbb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32ZBB

declare i32 @llvm.ctlz.i32(i32, i1)

define i32 @ctlz_i32(i32 %a) nounwind {
; RV32I-LABEL: ctlz_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beqz a0, .LBB0_2
; RV32I-NEXT:  # %bb.1: # %cond.false
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    addi a1, a2, 1365
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    srli a2, a0, 8
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    srli a2, a0, 16
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    and a1, a2, a1
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    li a1, 32
; RV32I-NEXT:    sub a0, a1, a0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB0_2:
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: ctlz_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    clz a0, a0
; RV32ZBB-NEXT:    ret
  %1 = call i32 @llvm.ctlz.i32(i32 %a, i1 false)
  ret i32 %1
}

declare i64 @llvm.ctlz.i64(i64, i1)

define i64 @ctlz_i64(i64 %a) nounwind {
; RV32I-LABEL: ctlz_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    lui a6, 61681
; RV32I-NEXT:    addi a5, a2, 1365
; RV32I-NEXT:    addi a4, a3, 819
; RV32I-NEXT:    addi a3, a6, -241
; RV32I-NEXT:    li a2, 32
; RV32I-NEXT:    beqz a1, .LBB1_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    srli a0, a1, 1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    sub a0, a2, a0
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB1_2:
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    sub a2, a2, a0
; RV32I-NEXT:    addi a0, a2, 32
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: ctlz_i64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    beqz a1, .LBB1_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    clz a0, a1
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
; RV32ZBB-NEXT:  .LBB1_2:
; RV32ZBB-NEXT:    clz a0, a0
; RV32ZBB-NEXT:    addi a0, a0, 32
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
  %1 = call i64 @llvm.ctlz.i64(i64 %a, i1 false)
  ret i64 %1
}

declare i32 @llvm.cttz.i32(i32, i1)

define i32 @cttz_i32(i32 %a) nounwind {
; RV32I-LABEL: cttz_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beqz a0, .LBB2_2
; RV32I-NEXT:  # %bb.1: # %cond.false
; RV32I-NEXT:    not a1, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    and a0, a1, a0
; RV32I-NEXT:    addi a1, a2, 1365
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    and a1, a2, a1
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    addi a1, a2, -241
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB2_2:
; RV32I-NEXT:    li a0, 32
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: cttz_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    ctz a0, a0
; RV32ZBB-NEXT:    ret
  %1 = call i32 @llvm.cttz.i32(i32 %a, i1 false)
  ret i32 %1
}

declare i64 @llvm.cttz.i64(i64, i1)

define i64 @cttz_i64(i64 %a) nounwind {
; RV32I-LABEL: cttz_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    lui a5, 61681
; RV32I-NEXT:    addi a4, a2, 1365
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    addi a2, a5, -241
; RV32I-NEXT:    beqz a0, .LBB3_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    not a1, a0
; RV32I-NEXT:    addi a0, a0, -1
; RV32I-NEXT:    and a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB3_2:
; RV32I-NEXT:    not a0, a1
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    addi a0, a0, 32
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: cttz_i64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    beqz a0, .LBB3_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    ctz a0, a0
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
; RV32ZBB-NEXT:  .LBB3_2:
; RV32ZBB-NEXT:    ctz a0, a1
; RV32ZBB-NEXT:    addi a0, a0, 32
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
  %1 = call i64 @llvm.cttz.i64(i64 %a, i1 false)
  ret i64 %1
}

declare i32 @llvm.ctpop.i32(i32)

define i32 @ctpop_i32(i32 %a) nounwind {
; RV32I-LABEL: ctpop_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 2
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    addi a1, a2, -241
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: ctpop_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    cpop a0, a0
; RV32ZBB-NEXT:    ret
  %1 = call i32 @llvm.ctpop.i32(i32 %a)
  ret i32 %1
}

declare i64 @llvm.ctpop.i64(i64)

define i64 @ctpop_i64(i64 %a) nounwind {
; RV32I-LABEL: ctpop_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    srli a5, a1, 1
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    and a3, a5, a3
; RV32I-NEXT:    lui a5, 61681
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    addi a5, a5, -241
; RV32I-NEXT:    sub a0, a0, a2
; RV32I-NEXT:    sub a1, a1, a3
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    srli a3, a1, 2
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    add a1, a3, a1
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    srli a3, a1, 4
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    add a1, a3, a1
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    slli a3, a1, 8
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    add a1, a1, a3
; RV32I-NEXT:    slli a2, a0, 16
; RV32I-NEXT:    slli a3, a1, 16
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    add a1, a1, a3
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    srli a1, a1, 24
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: ctpop_i64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    cpop a0, a0
; RV32ZBB-NEXT:    cpop a1, a1
; RV32ZBB-NEXT:    add a0, a1, a0
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
  %1 = call i64 @llvm.ctpop.i64(i64 %a)
  ret i64 %1
}

define i1 @ctpop_i64_ugt_two(i64 %a) nounwind {
; RV32I-LABEL: ctpop_i64_ugt_two:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beqz zero, .LBB6_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    sltiu a0, zero, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB6_2:
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    srli a5, a1, 1
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    and a3, a5, a3
; RV32I-NEXT:    lui a5, 61681
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    addi a5, a5, -241
; RV32I-NEXT:    sub a0, a0, a2
; RV32I-NEXT:    sub a1, a1, a3
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    srli a3, a1, 2
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    add a1, a3, a1
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    srli a3, a1, 4
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    add a1, a3, a1
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    slli a3, a1, 8
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    add a1, a1, a3
; RV32I-NEXT:    slli a2, a0, 16
; RV32I-NEXT:    slli a3, a1, 16
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    add a1, a1, a3
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    srli a1, a1, 24
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    sltiu a0, a0, 2
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: ctpop_i64_ugt_two:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    beqz zero, .LBB6_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    sltiu a0, zero, 0
; RV32ZBB-NEXT:    ret
; RV32ZBB-NEXT:  .LBB6_2:
; RV32ZBB-NEXT:    cpop a0, a0
; RV32ZBB-NEXT:    cpop a1, a1
; RV32ZBB-NEXT:    add a0, a1, a0
; RV32ZBB-NEXT:    sltiu a0, a0, 2
; RV32ZBB-NEXT:    ret
  %1 = call i64 @llvm.ctpop.i64(i64 %a)
  %2 = icmp ult i64 %1, 2
  ret i1 %2
}

define i1 @ctpop_i64_ugt_one(i64 %a) nounwind {
; RV32I-LABEL: ctpop_i64_ugt_one:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beqz zero, .LBB7_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    snez a0, zero
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB7_2:
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    srli a5, a1, 1
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    and a3, a5, a3
; RV32I-NEXT:    lui a5, 61681
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    addi a5, a5, -241
; RV32I-NEXT:    sub a0, a0, a2
; RV32I-NEXT:    sub a1, a1, a3
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    srli a3, a1, 2
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    add a1, a3, a1
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    srli a3, a1, 4
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    add a1, a3, a1
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    slli a3, a1, 8
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    add a1, a1, a3
; RV32I-NEXT:    slli a2, a0, 16
; RV32I-NEXT:    slli a3, a1, 16
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    add a1, a1, a3
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    srli a1, a1, 24
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    sltiu a0, a0, 2
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: ctpop_i64_ugt_one:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    beqz zero, .LBB7_2
; RV32ZBB-NEXT:  # %bb.1:
; RV32ZBB-NEXT:    snez a0, zero
; RV32ZBB-NEXT:    ret
; RV32ZBB-NEXT:  .LBB7_2:
; RV32ZBB-NEXT:    cpop a0, a0
; RV32ZBB-NEXT:    cpop a1, a1
; RV32ZBB-NEXT:    add a0, a1, a0
; RV32ZBB-NEXT:    sltiu a0, a0, 2
; RV32ZBB-NEXT:    xori a0, a0, 1
; RV32ZBB-NEXT:    ret
  %1 = call i64 @llvm.ctpop.i64(i64 %a)
  %2 = icmp ugt i64 %1, 1
  ret i1 %2
}

define i1 @ctpop_i64_eq_one(i64 %a) nounwind {
; RV32I-LABEL: ctpop_i64_eq_one:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    srli a5, a1, 1
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    and a3, a5, a3
; RV32I-NEXT:    lui a5, 61681
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    addi a5, a5, -241
; RV32I-NEXT:    sub a0, a0, a2
; RV32I-NEXT:    sub a1, a1, a3
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    srli a3, a1, 2
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    add a1, a3, a1
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    srli a3, a1, 4
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    add a1, a3, a1
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    slli a3, a1, 8
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    add a1, a1, a3
; RV32I-NEXT:    slli a2, a0, 16
; RV32I-NEXT:    slli a3, a1, 16
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    add a1, a1, a3
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    srli a1, a1, 24
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    seqz a0, a0
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: ctpop_i64_eq_one:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    cpop a0, a0
; RV32ZBB-NEXT:    cpop a1, a1
; RV32ZBB-NEXT:    add a0, a1, a0
; RV32ZBB-NEXT:    xori a0, a0, 1
; RV32ZBB-NEXT:    seqz a0, a0
; RV32ZBB-NEXT:    ret
  %1 = call i64 @llvm.ctpop.i64(i64 %a)
  %2 = icmp eq i64 %1, 1
  ret i1 %2
}

define i1 @ctpop_i64_ne_one(i64 %a) nounwind {
; RV32I-LABEL: ctpop_i64_ne_one:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    srli a5, a1, 1
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    and a3, a5, a3
; RV32I-NEXT:    lui a5, 61681
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    addi a5, a5, -241
; RV32I-NEXT:    sub a0, a0, a2
; RV32I-NEXT:    sub a1, a1, a3
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    srli a3, a1, 2
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    add a1, a3, a1
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    srli a3, a1, 4
; RV32I-NEXT:    add a0, a2, a0
; RV32I-NEXT:    add a1, a3, a1
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    slli a3, a1, 8
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    add a1, a1, a3
; RV32I-NEXT:    slli a2, a0, 16
; RV32I-NEXT:    slli a3, a1, 16
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    add a1, a1, a3
; RV32I-NEXT:    srli a0, a0, 24
; RV32I-NEXT:    srli a1, a1, 24
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: ctpop_i64_ne_one:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    cpop a0, a0
; RV32ZBB-NEXT:    cpop a1, a1
; RV32ZBB-NEXT:    add a0, a1, a0
; RV32ZBB-NEXT:    xori a0, a0, 1
; RV32ZBB-NEXT:    snez a0, a0
; RV32ZBB-NEXT:    ret
  %1 = call i64 @llvm.ctpop.i64(i64 %a)
  %2 = icmp ne i64 %1, 1
  ret i1 %2
}

define i32 @sextb_i32(i32 %a) nounwind {
; RV32I-LABEL: sextb_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: sextb_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sext.b a0, a0
; RV32ZBB-NEXT:    ret
  %shl = shl i32 %a, 24
  %shr = ashr exact i32 %shl, 24
  ret i32 %shr
}

; FIXME: Combine back to back srai.
define i64 @sextb_i64(i64 %a) nounwind {
; RV32I-LABEL: sextb_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 24
; RV32I-NEXT:    srai a0, a1, 24
; RV32I-NEXT:    srai a1, a1, 31
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: sextb_i64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sext.b a0, a0
; RV32ZBB-NEXT:    srai a1, a0, 31
; RV32ZBB-NEXT:    ret
  %shl = shl i64 %a, 56
  %shr = ashr exact i64 %shl, 56
  ret i64 %shr
}

define i32 @sexth_i32(i32 %a) nounwind {
; RV32I-LABEL: sexth_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srai a0, a0, 16
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: sexth_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sext.h a0, a0
; RV32ZBB-NEXT:    ret
  %shl = shl i32 %a, 16
  %shr = ashr exact i32 %shl, 16
  ret i32 %shr
}

; FIXME: Combine back to back srai.
define i64 @sexth_i64(i64 %a) nounwind {
; RV32I-LABEL: sexth_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    srai a0, a1, 16
; RV32I-NEXT:    srai a1, a1, 31
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: sexth_i64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sext.h a0, a0
; RV32ZBB-NEXT:    srai a1, a0, 31
; RV32ZBB-NEXT:    ret
  %shl = shl i64 %a, 48
  %shr = ashr exact i64 %shl, 48
  ret i64 %shr
}

define i32 @min_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: min_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    blt a0, a1, .LBB14_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:  .LBB14_2:
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: min_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    min a0, a0, a1
; RV32ZBB-NEXT:    ret
  %cmp = icmp slt i32 %a, %b
  %cond = select i1 %cmp, i32 %a, i32 %b
  ret i32 %cond
}

; As we are not matching directly i64 code patterns on RV32 some i64 patterns
; don't have yet any matching bit manipulation instructions on RV32.
; This test is presented here in case future expansions of the Bitmanip
; extensions introduce instructions suitable for this pattern.

define i64 @min_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: min_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    beq a1, a3, .LBB15_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    slt a4, a1, a3
; CHECK-NEXT:    beqz a4, .LBB15_3
; CHECK-NEXT:    j .LBB15_4
; CHECK-NEXT:  .LBB15_2:
; CHECK-NEXT:    sltu a4, a0, a2
; CHECK-NEXT:    bnez a4, .LBB15_4
; CHECK-NEXT:  .LBB15_3:
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:  .LBB15_4:
; CHECK-NEXT:    ret
  %cmp = icmp slt i64 %a, %b
  %cond = select i1 %cmp, i64 %a, i64 %b
  ret i64 %cond
}

define i32 @max_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: max_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    blt a1, a0, .LBB16_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:  .LBB16_2:
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: max_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    max a0, a0, a1
; RV32ZBB-NEXT:    ret
  %cmp = icmp sgt i32 %a, %b
  %cond = select i1 %cmp, i32 %a, i32 %b
  ret i32 %cond
}

; As we are not matching directly i64 code patterns on RV32 some i64 patterns
; don't have yet any matching bit manipulation instructions on RV32.
; This test is presented here in case future expansions of the Bitmanip
; extensions introduce instructions suitable for this pattern.

define i64 @max_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: max_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    beq a1, a3, .LBB17_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    slt a4, a3, a1
; CHECK-NEXT:    beqz a4, .LBB17_3
; CHECK-NEXT:    j .LBB17_4
; CHECK-NEXT:  .LBB17_2:
; CHECK-NEXT:    sltu a4, a2, a0
; CHECK-NEXT:    bnez a4, .LBB17_4
; CHECK-NEXT:  .LBB17_3:
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:  .LBB17_4:
; CHECK-NEXT:    ret
  %cmp = icmp sgt i64 %a, %b
  %cond = select i1 %cmp, i64 %a, i64 %b
  ret i64 %cond
}

define i32 @minu_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: minu_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bltu a0, a1, .LBB18_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:  .LBB18_2:
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: minu_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    minu a0, a0, a1
; RV32ZBB-NEXT:    ret
  %cmp = icmp ult i32 %a, %b
  %cond = select i1 %cmp, i32 %a, i32 %b
  ret i32 %cond
}

; As we are not matching directly i64 code patterns on RV32 some i64 patterns
; don't have yet any matching bit manipulation instructions on RV32.
; This test is presented here in case future expansions of the Bitmanip
; extensions introduce instructions suitable for this pattern.

define i64 @minu_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: minu_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    beq a1, a3, .LBB19_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    sltu a4, a1, a3
; CHECK-NEXT:    beqz a4, .LBB19_3
; CHECK-NEXT:    j .LBB19_4
; CHECK-NEXT:  .LBB19_2:
; CHECK-NEXT:    sltu a4, a0, a2
; CHECK-NEXT:    bnez a4, .LBB19_4
; CHECK-NEXT:  .LBB19_3:
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:  .LBB19_4:
; CHECK-NEXT:    ret
  %cmp = icmp ult i64 %a, %b
  %cond = select i1 %cmp, i64 %a, i64 %b
  ret i64 %cond
}

define i32 @maxu_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: maxu_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    bltu a1, a0, .LBB20_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:  .LBB20_2:
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: maxu_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    maxu a0, a0, a1
; RV32ZBB-NEXT:    ret
  %cmp = icmp ugt i32 %a, %b
  %cond = select i1 %cmp, i32 %a, i32 %b
  ret i32 %cond
}

; As we are not matching directly i64 code patterns on RV32 some i64 patterns
; don't have yet any matching bit manipulation instructions on RV32.
; This test is presented here in case future expansions of the Bitmanip
; extensions introduce instructions suitable for this pattern.

define i64 @maxu_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: maxu_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    beq a1, a3, .LBB21_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    sltu a4, a3, a1
; CHECK-NEXT:    beqz a4, .LBB21_3
; CHECK-NEXT:    j .LBB21_4
; CHECK-NEXT:  .LBB21_2:
; CHECK-NEXT:    sltu a4, a2, a0
; CHECK-NEXT:    bnez a4, .LBB21_4
; CHECK-NEXT:  .LBB21_3:
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    mv a1, a3
; CHECK-NEXT:  .LBB21_4:
; CHECK-NEXT:    ret
  %cmp = icmp ugt i64 %a, %b
  %cond = select i1 %cmp, i64 %a, i64 %b
  ret i64 %cond
}

declare i32 @llvm.abs.i32(i32, i1 immarg)

define i32 @abs_i32(i32 %x) {
; RV32I-LABEL: abs_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srai a1, a0, 31
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: abs_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    neg a1, a0
; RV32ZBB-NEXT:    max a0, a0, a1
; RV32ZBB-NEXT:    ret
  %abs = tail call i32 @llvm.abs.i32(i32 %x, i1 true)
  ret i32 %abs
}

declare i64 @llvm.abs.i64(i64, i1 immarg)

define i64 @abs_i64(i64 %x) {
; CHECK-LABEL: abs_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srai a2, a1, 31
; CHECK-NEXT:    add a0, a0, a2
; CHECK-NEXT:    add a1, a1, a2
; CHECK-NEXT:    sltu a3, a0, a2
; CHECK-NEXT:    add a1, a1, a3
; CHECK-NEXT:    xor a0, a0, a2
; CHECK-NEXT:    xor a1, a1, a2
; CHECK-NEXT:    ret
  %abs = tail call i64 @llvm.abs.i64(i64 %x, i1 true)
  ret i64 %abs
}

define i32 @zexth_i32(i32 %a) nounwind {
; RV32I-LABEL: zexth_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: zexth_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    ret
  %and = and i32 %a, 65535
  ret i32 %and
}

define i64 @zexth_i64(i64 %a) nounwind {
; RV32I-LABEL: zexth_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    li a1, 0
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: zexth_i64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    li a1, 0
; RV32ZBB-NEXT:    ret
  %and = and i64 %a, 65535
  ret i64 %and
}

declare i32 @llvm.bswap.i32(i32)

define i32 @bswap_i32(i32 %a) nounwind {
; RV32I-LABEL: bswap_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 24
; RV32I-NEXT:    srli a2, a0, 24
; RV32I-NEXT:    lui a3, 16
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    srli a2, a0, 8
; RV32I-NEXT:    addi a3, a3, -256
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: bswap_i32:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    rev8 a0, a0
; RV32ZBB-NEXT:    ret
  %1 = tail call i32 @llvm.bswap.i32(i32 %a)
  ret i32 %1
}

declare i64 @llvm.bswap.i64(i64)

define i64 @bswap_i64(i64 %a) {
; RV32I-LABEL: bswap_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 24
; RV32I-NEXT:    srli a3, a1, 24
; RV32I-NEXT:    lui a4, 16
; RV32I-NEXT:    srli a5, a1, 8
; RV32I-NEXT:    slli a6, a0, 24
; RV32I-NEXT:    or a2, a3, a2
; RV32I-NEXT:    srli a3, a0, 24
; RV32I-NEXT:    or a3, a3, a6
; RV32I-NEXT:    srli a6, a0, 8
; RV32I-NEXT:    addi a4, a4, -256
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a5, a5, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a4, a6, a4
; RV32I-NEXT:    or a2, a2, a5
; RV32I-NEXT:    slli a1, a1, 8
; RV32I-NEXT:    slli a5, a0, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    or a0, a2, a1
; RV32I-NEXT:    or a1, a3, a5
; RV32I-NEXT:    ret
;
; RV32ZBB-LABEL: bswap_i64:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    rev8 a2, a1
; RV32ZBB-NEXT:    rev8 a1, a0
; RV32ZBB-NEXT:    mv a0, a2
; RV32ZBB-NEXT:    ret
  %1 = call i64 @llvm.bswap.i64(i64 %a)
  ret i64 %1
}
