; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=i386 < %s | FileCheck %s -check-prefix=SOFT-FLOAT-32
; RUN: llc -mtriple=i386 -mattr +fma < %s | FileCheck %s -check-prefix=SOFT-FLOAT-32-FMA
; RUN: llc -mtriple=i386 -mattr +fma4 < %s | FileCheck %s -check-prefix=SOFT-FLOAT-32-FMA4
; RUN: llc -mtriple=x86_64 < %s | FileCheck %s -check-prefix=SOFT-FLOAT-64
; RUN: llc -mtriple=x86_64 -mattr +fma < %s | FileCheck %s -check-prefix=SOFT-FLOAT-64-FMA
; RUN: llc -mtriple=x86_64 -mattr +fma4 < %s | FileCheck %s -check-prefix=SOFT-FLOAT-64-FMA4

define float @fmuladd_intrinsic_f32(float %a, float %b, float %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_intrinsic_f32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    pushl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-NEXT:    .cfi_offset %esi, -8
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-NEXT:    pushl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %eax
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __addsf3
; SOFT-FLOAT-32-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-NEXT:    popl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    retl
;
; SOFT-FLOAT-32-FMA-LABEL: fmuladd_intrinsic_f32:
; SOFT-FLOAT-32-FMA:       # %bb.0:
; SOFT-FLOAT-32-FMA-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_offset %esi, -8
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %eax
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __addsf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA-NEXT:    popl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    retl
;
; SOFT-FLOAT-32-FMA4-LABEL: fmuladd_intrinsic_f32:
; SOFT-FLOAT-32-FMA4:       # %bb.0:
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_offset %esi, -8
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %eax
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __addsf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA4-NEXT:    popl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    retl
;
; SOFT-FLOAT-64-LABEL: fmuladd_intrinsic_f32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    pushq %rbx
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-NEXT:    .cfi_offset %rbx, -16
; SOFT-FLOAT-64-NEXT:    movl %edx, %ebx
; SOFT-FLOAT-64-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-NEXT:    movl %eax, %edi
; SOFT-FLOAT-64-NEXT:    movl %ebx, %esi
; SOFT-FLOAT-64-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-NEXT:    popq %rbx
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-NEXT:    retq
;
; SOFT-FLOAT-64-FMA-LABEL: fmuladd_intrinsic_f32:
; SOFT-FLOAT-64-FMA:       # %bb.0:
; SOFT-FLOAT-64-FMA-NEXT:    pushq %rbx
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %rbx, -16
; SOFT-FLOAT-64-FMA-NEXT:    movl %edx, %ebx
; SOFT-FLOAT-64-FMA-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movl %eax, %edi
; SOFT-FLOAT-64-FMA-NEXT:    movl %ebx, %esi
; SOFT-FLOAT-64-FMA-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    popq %rbx
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-FMA-NEXT:    retq
;
; SOFT-FLOAT-64-FMA4-LABEL: fmuladd_intrinsic_f32:
; SOFT-FLOAT-64-FMA4:       # %bb.0:
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %rbx, -16
; SOFT-FLOAT-64-FMA4-NEXT:    movl %edx, %ebx
; SOFT-FLOAT-64-FMA4-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movl %eax, %edi
; SOFT-FLOAT-64-FMA4-NEXT:    movl %ebx, %esi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    popq %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-FMA4-NEXT:    retq
  %result = call float @llvm.fmuladd.f32(float %a, float %b, float %c)
  ret float %result
}

define double @fmuladd_intrinsic_f64(double %a, double %b, double %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_intrinsic_f64:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    pushl %edi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-NEXT:    pushl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-NEXT:    .cfi_offset %esi, -12
; SOFT-FLOAT-32-NEXT:    .cfi_offset %edi, -8
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __muldf3
; SOFT-FLOAT-32-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-NEXT:    pushl %edi
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %edx
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %eax
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __adddf3
; SOFT-FLOAT-32-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-NEXT:    popl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-NEXT:    popl %edi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    retl
;
; SOFT-FLOAT-32-FMA-LABEL: fmuladd_intrinsic_f64:
; SOFT-FLOAT-32-FMA:       # %bb.0:
; SOFT-FLOAT-32-FMA-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_offset %esi, -12
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_offset %edi, -8
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %edi
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __muldf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %edx
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %eax
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __adddf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA-NEXT:    popl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA-NEXT:    popl %edi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    retl
;
; SOFT-FLOAT-32-FMA4-LABEL: fmuladd_intrinsic_f64:
; SOFT-FLOAT-32-FMA4:       # %bb.0:
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_offset %esi, -12
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_offset %edi, -8
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %edi
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __muldf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %edx
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %eax
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __adddf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA4-NEXT:    popl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA4-NEXT:    popl %edi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    retl
;
; SOFT-FLOAT-64-LABEL: fmuladd_intrinsic_f64:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    pushq %rbx
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-NEXT:    .cfi_offset %rbx, -16
; SOFT-FLOAT-64-NEXT:    movq %rdx, %rbx
; SOFT-FLOAT-64-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-NEXT:    movq %rax, %rdi
; SOFT-FLOAT-64-NEXT:    movq %rbx, %rsi
; SOFT-FLOAT-64-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-NEXT:    popq %rbx
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-NEXT:    retq
;
; SOFT-FLOAT-64-FMA-LABEL: fmuladd_intrinsic_f64:
; SOFT-FLOAT-64-FMA:       # %bb.0:
; SOFT-FLOAT-64-FMA-NEXT:    pushq %rbx
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %rbx, -16
; SOFT-FLOAT-64-FMA-NEXT:    movq %rdx, %rbx
; SOFT-FLOAT-64-FMA-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movq %rax, %rdi
; SOFT-FLOAT-64-FMA-NEXT:    movq %rbx, %rsi
; SOFT-FLOAT-64-FMA-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    popq %rbx
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-FMA-NEXT:    retq
;
; SOFT-FLOAT-64-FMA4-LABEL: fmuladd_intrinsic_f64:
; SOFT-FLOAT-64-FMA4:       # %bb.0:
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %rbx, -16
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rdx, %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rax, %rdi
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rbx, %rsi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    popq %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-FMA4-NEXT:    retq
  %result = call double @llvm.fmuladd.f64(double %a, double %b, double %c)
  ret double %result
}

define float @fmuladd_contract_f32(float %a, float %b, float %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_contract_f32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    pushl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-NEXT:    .cfi_offset %esi, -8
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-NEXT:    pushl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %eax
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __addsf3
; SOFT-FLOAT-32-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-NEXT:    popl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    retl
;
; SOFT-FLOAT-32-FMA-LABEL: fmuladd_contract_f32:
; SOFT-FLOAT-32-FMA:       # %bb.0:
; SOFT-FLOAT-32-FMA-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_offset %esi, -8
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %eax
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __addsf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA-NEXT:    popl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    retl
;
; SOFT-FLOAT-32-FMA4-LABEL: fmuladd_contract_f32:
; SOFT-FLOAT-32-FMA4:       # %bb.0:
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_offset %esi, -8
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %eax
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __addsf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA4-NEXT:    popl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    retl
;
; SOFT-FLOAT-64-LABEL: fmuladd_contract_f32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    pushq %rbx
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-NEXT:    .cfi_offset %rbx, -16
; SOFT-FLOAT-64-NEXT:    movl %edx, %ebx
; SOFT-FLOAT-64-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-NEXT:    movl %eax, %edi
; SOFT-FLOAT-64-NEXT:    movl %ebx, %esi
; SOFT-FLOAT-64-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-NEXT:    popq %rbx
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-NEXT:    retq
;
; SOFT-FLOAT-64-FMA-LABEL: fmuladd_contract_f32:
; SOFT-FLOAT-64-FMA:       # %bb.0:
; SOFT-FLOAT-64-FMA-NEXT:    pushq %rbx
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %rbx, -16
; SOFT-FLOAT-64-FMA-NEXT:    movl %edx, %ebx
; SOFT-FLOAT-64-FMA-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movl %eax, %edi
; SOFT-FLOAT-64-FMA-NEXT:    movl %ebx, %esi
; SOFT-FLOAT-64-FMA-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    popq %rbx
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-FMA-NEXT:    retq
;
; SOFT-FLOAT-64-FMA4-LABEL: fmuladd_contract_f32:
; SOFT-FLOAT-64-FMA4:       # %bb.0:
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %rbx, -16
; SOFT-FLOAT-64-FMA4-NEXT:    movl %edx, %ebx
; SOFT-FLOAT-64-FMA4-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movl %eax, %edi
; SOFT-FLOAT-64-FMA4-NEXT:    movl %ebx, %esi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    popq %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-FMA4-NEXT:    retq
  %product = fmul contract float %a, %b
  %result = fadd contract float %product, %c
  ret float %result
}

define double @fmuladd_contract_f64(double %a, double %b, double %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_contract_f64:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    pushl %edi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-NEXT:    pushl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-NEXT:    .cfi_offset %esi, -12
; SOFT-FLOAT-32-NEXT:    .cfi_offset %edi, -8
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __muldf3
; SOFT-FLOAT-32-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-NEXT:    pushl %edi
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %edx
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %eax
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __adddf3
; SOFT-FLOAT-32-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-NEXT:    popl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-NEXT:    popl %edi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    retl
;
; SOFT-FLOAT-32-FMA-LABEL: fmuladd_contract_f64:
; SOFT-FLOAT-32-FMA:       # %bb.0:
; SOFT-FLOAT-32-FMA-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_offset %esi, -12
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_offset %edi, -8
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %edi
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __muldf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %edx
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %eax
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __adddf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA-NEXT:    popl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA-NEXT:    popl %edi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    retl
;
; SOFT-FLOAT-32-FMA4-LABEL: fmuladd_contract_f64:
; SOFT-FLOAT-32-FMA4:       # %bb.0:
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_offset %esi, -12
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_offset %edi, -8
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %edi
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __muldf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %edx
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %eax
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __adddf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA4-NEXT:    popl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA4-NEXT:    popl %edi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    retl
;
; SOFT-FLOAT-64-LABEL: fmuladd_contract_f64:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    pushq %rbx
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-NEXT:    .cfi_offset %rbx, -16
; SOFT-FLOAT-64-NEXT:    movq %rdx, %rbx
; SOFT-FLOAT-64-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-NEXT:    movq %rax, %rdi
; SOFT-FLOAT-64-NEXT:    movq %rbx, %rsi
; SOFT-FLOAT-64-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-NEXT:    popq %rbx
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-NEXT:    retq
;
; SOFT-FLOAT-64-FMA-LABEL: fmuladd_contract_f64:
; SOFT-FLOAT-64-FMA:       # %bb.0:
; SOFT-FLOAT-64-FMA-NEXT:    pushq %rbx
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %rbx, -16
; SOFT-FLOAT-64-FMA-NEXT:    movq %rdx, %rbx
; SOFT-FLOAT-64-FMA-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movq %rax, %rdi
; SOFT-FLOAT-64-FMA-NEXT:    movq %rbx, %rsi
; SOFT-FLOAT-64-FMA-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    popq %rbx
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-FMA-NEXT:    retq
;
; SOFT-FLOAT-64-FMA4-LABEL: fmuladd_contract_f64:
; SOFT-FLOAT-64-FMA4:       # %bb.0:
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %rbx, -16
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rdx, %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rax, %rdi
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rbx, %rsi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    popq %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-FMA4-NEXT:    retq
  %product = fmul contract double %a, %b
  %result = fadd contract double %product, %c
  ret double %result
}

define <4 x float> @fmuladd_contract_v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_contract_v4f32:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    pushl %ebp
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-NEXT:    pushl %ebx
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-NEXT:    pushl %edi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-32-NEXT:    pushl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 20
; SOFT-FLOAT-32-NEXT:    pushl %eax
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-32-NEXT:    .cfi_offset %esi, -20
; SOFT-FLOAT-32-NEXT:    .cfi_offset %edi, -16
; SOFT-FLOAT-32-NEXT:    .cfi_offset %ebx, -12
; SOFT-FLOAT-32-NEXT:    .cfi_offset %ebp, -8
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-NEXT:    movl %eax, (%esp) # 4-byte Spill
; SOFT-FLOAT-32-NEXT:    pushl %edi
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %ebx
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-NEXT:    movl %eax, %ebx
; SOFT-FLOAT-32-NEXT:    pushl %ebp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-NEXT:    movl %eax, %edi
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %eax
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __addsf3
; SOFT-FLOAT-32-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-NEXT:    movl %eax, %ebp
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %edi
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __addsf3
; SOFT-FLOAT-32-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-NEXT:    movl %eax, %edi
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %ebx
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __addsf3
; SOFT-FLOAT-32-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-NEXT:    movl %eax, %ebx
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __addsf3
; SOFT-FLOAT-32-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-NEXT:    movl %eax, 12(%esi)
; SOFT-FLOAT-32-NEXT:    movl %ebx, 8(%esi)
; SOFT-FLOAT-32-NEXT:    movl %edi, 4(%esi)
; SOFT-FLOAT-32-NEXT:    movl %ebp, (%esi)
; SOFT-FLOAT-32-NEXT:    movl %esi, %eax
; SOFT-FLOAT-32-NEXT:    addl $4, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 20
; SOFT-FLOAT-32-NEXT:    popl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-32-NEXT:    popl %edi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-NEXT:    popl %ebx
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-NEXT:    popl %ebp
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    retl $4
;
; SOFT-FLOAT-32-FMA-LABEL: fmuladd_contract_v4f32:
; SOFT-FLOAT-32-FMA:       # %bb.0:
; SOFT-FLOAT-32-FMA-NEXT:    pushl %ebp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA-NEXT:    pushl %ebx
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-FMA-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-32-FMA-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 20
; SOFT-FLOAT-32-FMA-NEXT:    pushl %eax
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_offset %esi, -20
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_offset %edi, -16
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_offset %ebx, -12
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_offset %ebp, -8
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %edi
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, (%esp) # 4-byte Spill
; SOFT-FLOAT-32-FMA-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %ebx
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, %ebx
; SOFT-FLOAT-32-FMA-NEXT:    pushl %ebp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, %edi
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %eax
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __addsf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, %ebp
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __addsf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, %edi
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %ebx
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __addsf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, %ebx
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Reload
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __addsf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, 12(%esi)
; SOFT-FLOAT-32-FMA-NEXT:    movl %ebx, 8(%esi)
; SOFT-FLOAT-32-FMA-NEXT:    movl %edi, 4(%esi)
; SOFT-FLOAT-32-FMA-NEXT:    movl %ebp, (%esi)
; SOFT-FLOAT-32-FMA-NEXT:    movl %esi, %eax
; SOFT-FLOAT-32-FMA-NEXT:    addl $4, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 20
; SOFT-FLOAT-32-FMA-NEXT:    popl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-32-FMA-NEXT:    popl %edi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-FMA-NEXT:    popl %ebx
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA-NEXT:    popl %ebp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    retl $4
;
; SOFT-FLOAT-32-FMA4-LABEL: fmuladd_contract_v4f32:
; SOFT-FLOAT-32-FMA4:       # %bb.0:
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %ebp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %ebx
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 20
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %eax
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_offset %esi, -20
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_offset %edi, -16
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_offset %ebx, -12
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_offset %ebp, -8
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %edi
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, (%esp) # 4-byte Spill
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %ebx
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, %ebx
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %ebp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, %edi
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __mulsf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %eax
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __addsf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, %ebp
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __addsf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, %edi
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %ebx
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __addsf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, %ebx
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Reload
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __addsf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $8, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -8
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, 12(%esi)
; SOFT-FLOAT-32-FMA4-NEXT:    movl %ebx, 8(%esi)
; SOFT-FLOAT-32-FMA4-NEXT:    movl %edi, 4(%esi)
; SOFT-FLOAT-32-FMA4-NEXT:    movl %ebp, (%esi)
; SOFT-FLOAT-32-FMA4-NEXT:    movl %esi, %eax
; SOFT-FLOAT-32-FMA4-NEXT:    addl $4, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 20
; SOFT-FLOAT-32-FMA4-NEXT:    popl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-32-FMA4-NEXT:    popl %edi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-FMA4-NEXT:    popl %ebx
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA4-NEXT:    popl %ebp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    retl $4
;
; SOFT-FLOAT-64-LABEL: fmuladd_contract_v4f32:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    pushq %rbp
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-NEXT:    pushq %r15
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-64-NEXT:    pushq %r14
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 32
; SOFT-FLOAT-64-NEXT:    pushq %r13
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 40
; SOFT-FLOAT-64-NEXT:    pushq %r12
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 48
; SOFT-FLOAT-64-NEXT:    pushq %rbx
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 56
; SOFT-FLOAT-64-NEXT:    pushq %rax
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 64
; SOFT-FLOAT-64-NEXT:    .cfi_offset %rbx, -56
; SOFT-FLOAT-64-NEXT:    .cfi_offset %r12, -48
; SOFT-FLOAT-64-NEXT:    .cfi_offset %r13, -40
; SOFT-FLOAT-64-NEXT:    .cfi_offset %r14, -32
; SOFT-FLOAT-64-NEXT:    .cfi_offset %r15, -24
; SOFT-FLOAT-64-NEXT:    .cfi_offset %rbp, -16
; SOFT-FLOAT-64-NEXT:    movl %r9d, %r13d
; SOFT-FLOAT-64-NEXT:    movl %ecx, %ebp
; SOFT-FLOAT-64-NEXT:    movl %edx, %r14d
; SOFT-FLOAT-64-NEXT:    movl %esi, %r12d
; SOFT-FLOAT-64-NEXT:    movq %rdi, %rbx
; SOFT-FLOAT-64-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-NEXT:    movl %r8d, %edi
; SOFT-FLOAT-64-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-NEXT:    movl %eax, %r15d
; SOFT-FLOAT-64-NEXT:    movl %ebp, %edi
; SOFT-FLOAT-64-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-NEXT:    movl %eax, %ebp
; SOFT-FLOAT-64-NEXT:    movl %r14d, %edi
; SOFT-FLOAT-64-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-NEXT:    movl %eax, %r14d
; SOFT-FLOAT-64-NEXT:    movl %r12d, %edi
; SOFT-FLOAT-64-NEXT:    movl %r13d, %esi
; SOFT-FLOAT-64-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-NEXT:    movl %eax, %edi
; SOFT-FLOAT-64-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-NEXT:    movl %eax, %r12d
; SOFT-FLOAT-64-NEXT:    movl %r14d, %edi
; SOFT-FLOAT-64-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-NEXT:    movl %eax, %r14d
; SOFT-FLOAT-64-NEXT:    movl %ebp, %edi
; SOFT-FLOAT-64-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-NEXT:    movl %eax, %ebp
; SOFT-FLOAT-64-NEXT:    movl %r15d, %edi
; SOFT-FLOAT-64-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-NEXT:    movl %eax, 12(%rbx)
; SOFT-FLOAT-64-NEXT:    movl %ebp, 8(%rbx)
; SOFT-FLOAT-64-NEXT:    movl %r14d, 4(%rbx)
; SOFT-FLOAT-64-NEXT:    movl %r12d, (%rbx)
; SOFT-FLOAT-64-NEXT:    movq %rbx, %rax
; SOFT-FLOAT-64-NEXT:    addq $8, %rsp
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 56
; SOFT-FLOAT-64-NEXT:    popq %rbx
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 48
; SOFT-FLOAT-64-NEXT:    popq %r12
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 40
; SOFT-FLOAT-64-NEXT:    popq %r13
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 32
; SOFT-FLOAT-64-NEXT:    popq %r14
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-64-NEXT:    popq %r15
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-NEXT:    popq %rbp
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-NEXT:    retq
;
; SOFT-FLOAT-64-FMA-LABEL: fmuladd_contract_v4f32:
; SOFT-FLOAT-64-FMA:       # %bb.0:
; SOFT-FLOAT-64-FMA-NEXT:    pushq %rbp
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA-NEXT:    pushq %r15
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-64-FMA-NEXT:    pushq %r14
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 32
; SOFT-FLOAT-64-FMA-NEXT:    pushq %r13
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 40
; SOFT-FLOAT-64-FMA-NEXT:    pushq %r12
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 48
; SOFT-FLOAT-64-FMA-NEXT:    pushq %rbx
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 56
; SOFT-FLOAT-64-FMA-NEXT:    pushq %rax
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 64
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %rbx, -56
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %r12, -48
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %r13, -40
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %r14, -32
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %r15, -24
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %rbp, -16
; SOFT-FLOAT-64-FMA-NEXT:    movl %r9d, %r13d
; SOFT-FLOAT-64-FMA-NEXT:    movl %ecx, %ebp
; SOFT-FLOAT-64-FMA-NEXT:    movl %edx, %r14d
; SOFT-FLOAT-64-FMA-NEXT:    movl %esi, %r12d
; SOFT-FLOAT-64-FMA-NEXT:    movq %rdi, %rbx
; SOFT-FLOAT-64-FMA-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-FMA-NEXT:    movl %r8d, %edi
; SOFT-FLOAT-64-FMA-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movl %eax, %r15d
; SOFT-FLOAT-64-FMA-NEXT:    movl %ebp, %edi
; SOFT-FLOAT-64-FMA-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-FMA-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movl %eax, %ebp
; SOFT-FLOAT-64-FMA-NEXT:    movl %r14d, %edi
; SOFT-FLOAT-64-FMA-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-FMA-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movl %eax, %r14d
; SOFT-FLOAT-64-FMA-NEXT:    movl %r12d, %edi
; SOFT-FLOAT-64-FMA-NEXT:    movl %r13d, %esi
; SOFT-FLOAT-64-FMA-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movl %eax, %edi
; SOFT-FLOAT-64-FMA-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-FMA-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movl %eax, %r12d
; SOFT-FLOAT-64-FMA-NEXT:    movl %r14d, %edi
; SOFT-FLOAT-64-FMA-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-FMA-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movl %eax, %r14d
; SOFT-FLOAT-64-FMA-NEXT:    movl %ebp, %edi
; SOFT-FLOAT-64-FMA-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-FMA-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movl %eax, %ebp
; SOFT-FLOAT-64-FMA-NEXT:    movl %r15d, %edi
; SOFT-FLOAT-64-FMA-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-FMA-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movl %eax, 12(%rbx)
; SOFT-FLOAT-64-FMA-NEXT:    movl %ebp, 8(%rbx)
; SOFT-FLOAT-64-FMA-NEXT:    movl %r14d, 4(%rbx)
; SOFT-FLOAT-64-FMA-NEXT:    movl %r12d, (%rbx)
; SOFT-FLOAT-64-FMA-NEXT:    movq %rbx, %rax
; SOFT-FLOAT-64-FMA-NEXT:    addq $8, %rsp
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 56
; SOFT-FLOAT-64-FMA-NEXT:    popq %rbx
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 48
; SOFT-FLOAT-64-FMA-NEXT:    popq %r12
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 40
; SOFT-FLOAT-64-FMA-NEXT:    popq %r13
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 32
; SOFT-FLOAT-64-FMA-NEXT:    popq %r14
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-64-FMA-NEXT:    popq %r15
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA-NEXT:    popq %rbp
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-FMA-NEXT:    retq
;
; SOFT-FLOAT-64-FMA4-LABEL: fmuladd_contract_v4f32:
; SOFT-FLOAT-64-FMA4:       # %bb.0:
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %rbp
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %r15
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %r14
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 32
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %r13
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 40
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %r12
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 48
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 56
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %rax
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 64
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %rbx, -56
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %r12, -48
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %r13, -40
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %r14, -32
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %r15, -24
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %rbp, -16
; SOFT-FLOAT-64-FMA4-NEXT:    movl %r9d, %r13d
; SOFT-FLOAT-64-FMA4-NEXT:    movl %ecx, %ebp
; SOFT-FLOAT-64-FMA4-NEXT:    movl %edx, %r14d
; SOFT-FLOAT-64-FMA4-NEXT:    movl %esi, %r12d
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rdi, %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-FMA4-NEXT:    movl %r8d, %edi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movl %eax, %r15d
; SOFT-FLOAT-64-FMA4-NEXT:    movl %ebp, %edi
; SOFT-FLOAT-64-FMA4-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movl %eax, %ebp
; SOFT-FLOAT-64-FMA4-NEXT:    movl %r14d, %edi
; SOFT-FLOAT-64-FMA4-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movl %eax, %r14d
; SOFT-FLOAT-64-FMA4-NEXT:    movl %r12d, %edi
; SOFT-FLOAT-64-FMA4-NEXT:    movl %r13d, %esi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __mulsf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movl %eax, %edi
; SOFT-FLOAT-64-FMA4-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movl %eax, %r12d
; SOFT-FLOAT-64-FMA4-NEXT:    movl %r14d, %edi
; SOFT-FLOAT-64-FMA4-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movl %eax, %r14d
; SOFT-FLOAT-64-FMA4-NEXT:    movl %ebp, %edi
; SOFT-FLOAT-64-FMA4-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movl %eax, %ebp
; SOFT-FLOAT-64-FMA4-NEXT:    movl %r15d, %edi
; SOFT-FLOAT-64-FMA4-NEXT:    movl {{[0-9]+}}(%rsp), %esi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __addsf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movl %eax, 12(%rbx)
; SOFT-FLOAT-64-FMA4-NEXT:    movl %ebp, 8(%rbx)
; SOFT-FLOAT-64-FMA4-NEXT:    movl %r14d, 4(%rbx)
; SOFT-FLOAT-64-FMA4-NEXT:    movl %r12d, (%rbx)
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rbx, %rax
; SOFT-FLOAT-64-FMA4-NEXT:    addq $8, %rsp
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 56
; SOFT-FLOAT-64-FMA4-NEXT:    popq %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 48
; SOFT-FLOAT-64-FMA4-NEXT:    popq %r12
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 40
; SOFT-FLOAT-64-FMA4-NEXT:    popq %r13
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 32
; SOFT-FLOAT-64-FMA4-NEXT:    popq %r14
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-64-FMA4-NEXT:    popq %r15
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA4-NEXT:    popq %rbp
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-FMA4-NEXT:    retq
  %product = fmul contract <4 x float> %a, %b
  %result = fadd contract <4 x float> %product, %c
  ret <4 x float> %result
}

define <4 x double> @fmuladd_contract_v4f64(<4 x double> %a, <4 x double> %b, <4 x double> %c) #0 {
; SOFT-FLOAT-32-LABEL: fmuladd_contract_v4f64:
; SOFT-FLOAT-32:       # %bb.0:
; SOFT-FLOAT-32-NEXT:    pushl %ebp
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-NEXT:    pushl %ebx
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-NEXT:    pushl %edi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-32-NEXT:    pushl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 20
; SOFT-FLOAT-32-NEXT:    subl $16, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 36
; SOFT-FLOAT-32-NEXT:    .cfi_offset %esi, -20
; SOFT-FLOAT-32-NEXT:    .cfi_offset %edi, -16
; SOFT-FLOAT-32-NEXT:    .cfi_offset %ebx, -12
; SOFT-FLOAT-32-NEXT:    .cfi_offset %ebp, -8
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __muldf3
; SOFT-FLOAT-32-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; SOFT-FLOAT-32-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; SOFT-FLOAT-32-NEXT:    pushl %ebp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %ebx
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %edi
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __muldf3
; SOFT-FLOAT-32-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-NEXT:    movl %eax, %esi
; SOFT-FLOAT-32-NEXT:    movl %edx, %ebp
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __muldf3
; SOFT-FLOAT-32-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-NEXT:    movl %eax, %edi
; SOFT-FLOAT-32-NEXT:    movl %edx, %ebx
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __muldf3
; SOFT-FLOAT-32-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %edx
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %eax
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __adddf3
; SOFT-FLOAT-32-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; SOFT-FLOAT-32-NEXT:    movl %edx, (%esp) # 4-byte Spill
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %ebx
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %edi
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __adddf3
; SOFT-FLOAT-32-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-NEXT:    movl %eax, %edi
; SOFT-FLOAT-32-NEXT:    movl %edx, %ebx
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %ebp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __adddf3
; SOFT-FLOAT-32-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-NEXT:    movl %eax, %ebp
; SOFT-FLOAT-32-NEXT:    movl %edx, %esi
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    pushl {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Reload
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    calll __adddf3
; SOFT-FLOAT-32-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SOFT-FLOAT-32-NEXT:    movl %edx, 28(%ecx)
; SOFT-FLOAT-32-NEXT:    movl %eax, 24(%ecx)
; SOFT-FLOAT-32-NEXT:    movl %esi, 20(%ecx)
; SOFT-FLOAT-32-NEXT:    movl %ebp, 16(%ecx)
; SOFT-FLOAT-32-NEXT:    movl %ebx, 12(%ecx)
; SOFT-FLOAT-32-NEXT:    movl %edi, 8(%ecx)
; SOFT-FLOAT-32-NEXT:    movl (%esp), %eax # 4-byte Reload
; SOFT-FLOAT-32-NEXT:    movl %eax, 4(%ecx)
; SOFT-FLOAT-32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; SOFT-FLOAT-32-NEXT:    movl %eax, (%ecx)
; SOFT-FLOAT-32-NEXT:    movl %ecx, %eax
; SOFT-FLOAT-32-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 20
; SOFT-FLOAT-32-NEXT:    popl %esi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-32-NEXT:    popl %edi
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-NEXT:    popl %ebx
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-NEXT:    popl %ebp
; SOFT-FLOAT-32-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-NEXT:    retl $4
;
; SOFT-FLOAT-32-FMA-LABEL: fmuladd_contract_v4f64:
; SOFT-FLOAT-32-FMA:       # %bb.0:
; SOFT-FLOAT-32-FMA-NEXT:    pushl %ebp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA-NEXT:    pushl %ebx
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-FMA-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-32-FMA-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 20
; SOFT-FLOAT-32-FMA-NEXT:    subl $16, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 36
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_offset %esi, -20
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_offset %edi, -16
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_offset %ebx, -12
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_offset %ebp, -8
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %edi
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __muldf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; SOFT-FLOAT-32-FMA-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; SOFT-FLOAT-32-FMA-NEXT:    pushl %ebp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %ebx
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __muldf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, %esi
; SOFT-FLOAT-32-FMA-NEXT:    movl %edx, %ebp
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __muldf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, %edi
; SOFT-FLOAT-32-FMA-NEXT:    movl %edx, %ebx
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __muldf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %edx
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %eax
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __adddf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; SOFT-FLOAT-32-FMA-NEXT:    movl %edx, (%esp) # 4-byte Spill
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %ebx
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __adddf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, %edi
; SOFT-FLOAT-32-FMA-NEXT:    movl %edx, %ebx
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %ebp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __adddf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, %ebp
; SOFT-FLOAT-32-FMA-NEXT:    movl %edx, %esi
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Reload
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    pushl {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Reload
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    calll __adddf3
; SOFT-FLOAT-32-FMA-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SOFT-FLOAT-32-FMA-NEXT:    movl %edx, 28(%ecx)
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, 24(%ecx)
; SOFT-FLOAT-32-FMA-NEXT:    movl %esi, 20(%ecx)
; SOFT-FLOAT-32-FMA-NEXT:    movl %ebp, 16(%ecx)
; SOFT-FLOAT-32-FMA-NEXT:    movl %ebx, 12(%ecx)
; SOFT-FLOAT-32-FMA-NEXT:    movl %edi, 8(%ecx)
; SOFT-FLOAT-32-FMA-NEXT:    movl (%esp), %eax # 4-byte Reload
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, 4(%ecx)
; SOFT-FLOAT-32-FMA-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; SOFT-FLOAT-32-FMA-NEXT:    movl %eax, (%ecx)
; SOFT-FLOAT-32-FMA-NEXT:    movl %ecx, %eax
; SOFT-FLOAT-32-FMA-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 20
; SOFT-FLOAT-32-FMA-NEXT:    popl %esi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-32-FMA-NEXT:    popl %edi
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-FMA-NEXT:    popl %ebx
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA-NEXT:    popl %ebp
; SOFT-FLOAT-32-FMA-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-FMA-NEXT:    retl $4
;
; SOFT-FLOAT-32-FMA4-LABEL: fmuladd_contract_v4f64:
; SOFT-FLOAT-32-FMA4:       # %bb.0:
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %ebp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %ebx
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 20
; SOFT-FLOAT-32-FMA4-NEXT:    subl $16, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 36
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_offset %esi, -20
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_offset %edi, -16
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_offset %ebx, -12
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_offset %ebp, -8
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %edi
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %esi
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %ebp
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __muldf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; SOFT-FLOAT-32-FMA4-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %ebp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %ebx
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __muldf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, %esi
; SOFT-FLOAT-32-FMA4-NEXT:    movl %edx, %ebp
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __muldf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, %edi
; SOFT-FLOAT-32-FMA4-NEXT:    movl %edx, %ebx
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __muldf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %edx
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %eax
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __adddf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; SOFT-FLOAT-32-FMA4-NEXT:    movl %edx, (%esp) # 4-byte Spill
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %ebx
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %edi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __adddf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, %edi
; SOFT-FLOAT-32-FMA4-NEXT:    movl %edx, %ebx
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %ebp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __adddf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, %ebp
; SOFT-FLOAT-32-FMA4-NEXT:    movl %edx, %esi
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[0-9]+}}(%esp)
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Reload
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    pushl {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Folded Reload
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    calll __adddf3
; SOFT-FLOAT-32-FMA4-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_adjust_cfa_offset -16
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; SOFT-FLOAT-32-FMA4-NEXT:    movl %edx, 28(%ecx)
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, 24(%ecx)
; SOFT-FLOAT-32-FMA4-NEXT:    movl %esi, 20(%ecx)
; SOFT-FLOAT-32-FMA4-NEXT:    movl %ebp, 16(%ecx)
; SOFT-FLOAT-32-FMA4-NEXT:    movl %ebx, 12(%ecx)
; SOFT-FLOAT-32-FMA4-NEXT:    movl %edi, 8(%ecx)
; SOFT-FLOAT-32-FMA4-NEXT:    movl (%esp), %eax # 4-byte Reload
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, 4(%ecx)
; SOFT-FLOAT-32-FMA4-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; SOFT-FLOAT-32-FMA4-NEXT:    movl %eax, (%ecx)
; SOFT-FLOAT-32-FMA4-NEXT:    movl %ecx, %eax
; SOFT-FLOAT-32-FMA4-NEXT:    addl $16, %esp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 20
; SOFT-FLOAT-32-FMA4-NEXT:    popl %esi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-32-FMA4-NEXT:    popl %edi
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 12
; SOFT-FLOAT-32-FMA4-NEXT:    popl %ebx
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-32-FMA4-NEXT:    popl %ebp
; SOFT-FLOAT-32-FMA4-NEXT:    .cfi_def_cfa_offset 4
; SOFT-FLOAT-32-FMA4-NEXT:    retl $4
;
; SOFT-FLOAT-64-LABEL: fmuladd_contract_v4f64:
; SOFT-FLOAT-64:       # %bb.0:
; SOFT-FLOAT-64-NEXT:    pushq %rbp
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-NEXT:    pushq %r15
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-64-NEXT:    pushq %r14
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 32
; SOFT-FLOAT-64-NEXT:    pushq %r13
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 40
; SOFT-FLOAT-64-NEXT:    pushq %r12
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 48
; SOFT-FLOAT-64-NEXT:    pushq %rbx
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 56
; SOFT-FLOAT-64-NEXT:    pushq %rax
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 64
; SOFT-FLOAT-64-NEXT:    .cfi_offset %rbx, -56
; SOFT-FLOAT-64-NEXT:    .cfi_offset %r12, -48
; SOFT-FLOAT-64-NEXT:    .cfi_offset %r13, -40
; SOFT-FLOAT-64-NEXT:    .cfi_offset %r14, -32
; SOFT-FLOAT-64-NEXT:    .cfi_offset %r15, -24
; SOFT-FLOAT-64-NEXT:    .cfi_offset %rbp, -16
; SOFT-FLOAT-64-NEXT:    movq %r9, %rbp
; SOFT-FLOAT-64-NEXT:    movq %rcx, %r14
; SOFT-FLOAT-64-NEXT:    movq %rdx, %r15
; SOFT-FLOAT-64-NEXT:    movq %rsi, %r13
; SOFT-FLOAT-64-NEXT:    movq %rdi, %rbx
; SOFT-FLOAT-64-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-NEXT:    movq %r8, %rdi
; SOFT-FLOAT-64-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-NEXT:    movq %rax, %r12
; SOFT-FLOAT-64-NEXT:    movq %r14, %rdi
; SOFT-FLOAT-64-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-NEXT:    movq %rax, %r14
; SOFT-FLOAT-64-NEXT:    movq %r15, %rdi
; SOFT-FLOAT-64-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-NEXT:    movq %rax, %r15
; SOFT-FLOAT-64-NEXT:    movq %r13, %rdi
; SOFT-FLOAT-64-NEXT:    movq %rbp, %rsi
; SOFT-FLOAT-64-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-NEXT:    movq %rax, %rdi
; SOFT-FLOAT-64-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-NEXT:    movq %rax, %r13
; SOFT-FLOAT-64-NEXT:    movq %r15, %rdi
; SOFT-FLOAT-64-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-NEXT:    movq %rax, %r15
; SOFT-FLOAT-64-NEXT:    movq %r14, %rdi
; SOFT-FLOAT-64-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-NEXT:    movq %rax, %r14
; SOFT-FLOAT-64-NEXT:    movq %r12, %rdi
; SOFT-FLOAT-64-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-NEXT:    movq %rax, 24(%rbx)
; SOFT-FLOAT-64-NEXT:    movq %r14, 16(%rbx)
; SOFT-FLOAT-64-NEXT:    movq %r15, 8(%rbx)
; SOFT-FLOAT-64-NEXT:    movq %r13, (%rbx)
; SOFT-FLOAT-64-NEXT:    movq %rbx, %rax
; SOFT-FLOAT-64-NEXT:    addq $8, %rsp
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 56
; SOFT-FLOAT-64-NEXT:    popq %rbx
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 48
; SOFT-FLOAT-64-NEXT:    popq %r12
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 40
; SOFT-FLOAT-64-NEXT:    popq %r13
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 32
; SOFT-FLOAT-64-NEXT:    popq %r14
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-64-NEXT:    popq %r15
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-NEXT:    popq %rbp
; SOFT-FLOAT-64-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-NEXT:    retq
;
; SOFT-FLOAT-64-FMA-LABEL: fmuladd_contract_v4f64:
; SOFT-FLOAT-64-FMA:       # %bb.0:
; SOFT-FLOAT-64-FMA-NEXT:    pushq %rbp
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA-NEXT:    pushq %r15
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-64-FMA-NEXT:    pushq %r14
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 32
; SOFT-FLOAT-64-FMA-NEXT:    pushq %r13
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 40
; SOFT-FLOAT-64-FMA-NEXT:    pushq %r12
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 48
; SOFT-FLOAT-64-FMA-NEXT:    pushq %rbx
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 56
; SOFT-FLOAT-64-FMA-NEXT:    pushq %rax
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 64
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %rbx, -56
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %r12, -48
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %r13, -40
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %r14, -32
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %r15, -24
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_offset %rbp, -16
; SOFT-FLOAT-64-FMA-NEXT:    movq %r9, %rbp
; SOFT-FLOAT-64-FMA-NEXT:    movq %rcx, %r14
; SOFT-FLOAT-64-FMA-NEXT:    movq %rdx, %r15
; SOFT-FLOAT-64-FMA-NEXT:    movq %rsi, %r13
; SOFT-FLOAT-64-FMA-NEXT:    movq %rdi, %rbx
; SOFT-FLOAT-64-FMA-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-FMA-NEXT:    movq %r8, %rdi
; SOFT-FLOAT-64-FMA-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movq %rax, %r12
; SOFT-FLOAT-64-FMA-NEXT:    movq %r14, %rdi
; SOFT-FLOAT-64-FMA-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-FMA-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movq %rax, %r14
; SOFT-FLOAT-64-FMA-NEXT:    movq %r15, %rdi
; SOFT-FLOAT-64-FMA-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-FMA-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movq %rax, %r15
; SOFT-FLOAT-64-FMA-NEXT:    movq %r13, %rdi
; SOFT-FLOAT-64-FMA-NEXT:    movq %rbp, %rsi
; SOFT-FLOAT-64-FMA-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movq %rax, %rdi
; SOFT-FLOAT-64-FMA-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-FMA-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movq %rax, %r13
; SOFT-FLOAT-64-FMA-NEXT:    movq %r15, %rdi
; SOFT-FLOAT-64-FMA-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-FMA-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movq %rax, %r15
; SOFT-FLOAT-64-FMA-NEXT:    movq %r14, %rdi
; SOFT-FLOAT-64-FMA-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-FMA-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movq %rax, %r14
; SOFT-FLOAT-64-FMA-NEXT:    movq %r12, %rdi
; SOFT-FLOAT-64-FMA-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-FMA-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-FMA-NEXT:    movq %rax, 24(%rbx)
; SOFT-FLOAT-64-FMA-NEXT:    movq %r14, 16(%rbx)
; SOFT-FLOAT-64-FMA-NEXT:    movq %r15, 8(%rbx)
; SOFT-FLOAT-64-FMA-NEXT:    movq %r13, (%rbx)
; SOFT-FLOAT-64-FMA-NEXT:    movq %rbx, %rax
; SOFT-FLOAT-64-FMA-NEXT:    addq $8, %rsp
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 56
; SOFT-FLOAT-64-FMA-NEXT:    popq %rbx
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 48
; SOFT-FLOAT-64-FMA-NEXT:    popq %r12
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 40
; SOFT-FLOAT-64-FMA-NEXT:    popq %r13
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 32
; SOFT-FLOAT-64-FMA-NEXT:    popq %r14
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-64-FMA-NEXT:    popq %r15
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA-NEXT:    popq %rbp
; SOFT-FLOAT-64-FMA-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-FMA-NEXT:    retq
;
; SOFT-FLOAT-64-FMA4-LABEL: fmuladd_contract_v4f64:
; SOFT-FLOAT-64-FMA4:       # %bb.0:
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %rbp
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %r15
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %r14
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 32
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %r13
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 40
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %r12
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 48
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 56
; SOFT-FLOAT-64-FMA4-NEXT:    pushq %rax
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 64
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %rbx, -56
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %r12, -48
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %r13, -40
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %r14, -32
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %r15, -24
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_offset %rbp, -16
; SOFT-FLOAT-64-FMA4-NEXT:    movq %r9, %rbp
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rcx, %r14
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rdx, %r15
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rsi, %r13
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rdi, %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-FMA4-NEXT:    movq %r8, %rdi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rax, %r12
; SOFT-FLOAT-64-FMA4-NEXT:    movq %r14, %rdi
; SOFT-FLOAT-64-FMA4-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rax, %r14
; SOFT-FLOAT-64-FMA4-NEXT:    movq %r15, %rdi
; SOFT-FLOAT-64-FMA4-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rax, %r15
; SOFT-FLOAT-64-FMA4-NEXT:    movq %r13, %rdi
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rbp, %rsi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __muldf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rax, %rdi
; SOFT-FLOAT-64-FMA4-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rax, %r13
; SOFT-FLOAT-64-FMA4-NEXT:    movq %r15, %rdi
; SOFT-FLOAT-64-FMA4-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rax, %r15
; SOFT-FLOAT-64-FMA4-NEXT:    movq %r14, %rdi
; SOFT-FLOAT-64-FMA4-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rax, %r14
; SOFT-FLOAT-64-FMA4-NEXT:    movq %r12, %rdi
; SOFT-FLOAT-64-FMA4-NEXT:    movq {{[0-9]+}}(%rsp), %rsi
; SOFT-FLOAT-64-FMA4-NEXT:    callq __adddf3@PLT
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rax, 24(%rbx)
; SOFT-FLOAT-64-FMA4-NEXT:    movq %r14, 16(%rbx)
; SOFT-FLOAT-64-FMA4-NEXT:    movq %r15, 8(%rbx)
; SOFT-FLOAT-64-FMA4-NEXT:    movq %r13, (%rbx)
; SOFT-FLOAT-64-FMA4-NEXT:    movq %rbx, %rax
; SOFT-FLOAT-64-FMA4-NEXT:    addq $8, %rsp
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 56
; SOFT-FLOAT-64-FMA4-NEXT:    popq %rbx
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 48
; SOFT-FLOAT-64-FMA4-NEXT:    popq %r12
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 40
; SOFT-FLOAT-64-FMA4-NEXT:    popq %r13
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 32
; SOFT-FLOAT-64-FMA4-NEXT:    popq %r14
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 24
; SOFT-FLOAT-64-FMA4-NEXT:    popq %r15
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 16
; SOFT-FLOAT-64-FMA4-NEXT:    popq %rbp
; SOFT-FLOAT-64-FMA4-NEXT:    .cfi_def_cfa_offset 8
; SOFT-FLOAT-64-FMA4-NEXT:    retq
  %product = fmul contract <4 x double> %a, %b
  %result = fadd contract <4 x double> %product, %c
  ret <4 x double> %result
}

attributes #0 = { "use-soft-float"="true" }

declare float @llvm.fmuladd.f32(float %a, float %b, float %c)
declare double @llvm.fmuladd.f64(double %a, double %b, double %c)
