; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck %s -check-prefixes=GCN
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck %s -check-prefixes=GISEL

define amdgpu_gfx i32 @sink_scratch_pointer(ptr addrspace(5) %stack, i32 inreg %flag) {
; GCN-LABEL: sink_scratch_pointer:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_cmp_lg_u32 s4, 0
; GCN-NEXT:    s_cbranch_scc0 .LBB0_2
; GCN-NEXT:  ; %bb.1: ; %bb2
; GCN-NEXT:    scratch_load_b32 v0, v0, off offset:-4
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
; GCN-NEXT:  .LBB0_2: ; %bb1
; GCN-NEXT:    v_mov_b32_e32 v1, 1
; GCN-NEXT:    scratch_store_b32 v0, v1, off offset:-4
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GISEL-LABEL: sink_scratch_pointer:
; GISEL:       ; %bb.0:
; GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GISEL-NEXT:    s_cmp_lg_u32 s4, 0
; GISEL-NEXT:    s_cbranch_scc0 .LBB0_2
; GISEL-NEXT:  ; %bb.1: ; %bb2
; GISEL-NEXT:    scratch_load_b32 v0, v0, off offset:-4
; GISEL-NEXT:    s_waitcnt vmcnt(0)
; GISEL-NEXT:    s_setpc_b64 s[30:31]
; GISEL-NEXT:  .LBB0_2: ; %bb1
; GISEL-NEXT:    v_mov_b32_e32 v1, 1
; GISEL-NEXT:    scratch_store_b32 v0, v1, off offset:-4
; GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-NEXT:    s_setpc_b64 s[30:31]
  %ptr = getelementptr inbounds i32, ptr addrspace(5) %stack, i32 -1
  %cond = icmp eq i32 %flag, 0
  br i1 %cond, label %bb1, label %bb2

bb1:
  store i32 1, ptr addrspace(5) %ptr, align 4
  ret i32 0

bb2:
  %value = load i32, ptr addrspace(5) %ptr, align 4
  ret i32 %value
}
