enable_language(CXX)

cmake_policy(GET CMP0141 cmp0141)
if(cmp0141 STREQUAL "NEW")
  if(NOT CMAKE_MSVC_DEBUG_INFORMATION_FORMAT_DEFAULT)
    message(SEND_ERROR "CMAKE_MSVC_DEBUG_INFORMATION_FORMAT_DEFAULT not set under NEW behavior")
  endif()
else()
  if(CMAKE_MSVC_DEBUG_INFORMATION_FORMAT_DEFAULT)
    message(SEND_ERROR "CMAKE_MSVC_DEBUG_INFORMATION_FORMAT_DEFAULT is set under OLD behavior")
  endif()
endif()

if(cmp0141 STREQUAL "NEW")
  if(CMAKE_CXX_FLAGS_DEBUG MATCHES "[/-]Zi( |$)")
    message(SEND_ERROR "CMAKE_CXX_FLAGS_DEBUG has -Zi flags under NEW behavior.")
  endif()
  if(CMAKE_CXX_FLAGS_RELWITHDEBINFO MATCHES "[/-]Zi( |$)")
    message(SEND_ERROR "CMAKE_CXX_FLAGS_RELWITHDEBINFO has -Zi flags under NEW behavior.")
  endif()
else()
  if(NOT (CMAKE_CXX_FLAGS_DEBUG MATCHES "[/-]Zi( |$)"))
    message(SEND_ERROR "CMAKE_CXX_FLAGS_DEBUG does not have -Zi flags under OLD behavior.")
  endif()
  if(NOT (CMAKE_CXX_FLAGS_RELWITHDEBINFO MATCHES "[/-]Zi( |$)"))
    message(SEND_ERROR "CMAKE_CXX_FLAGS_RELWITHDEBINFO does not have -Zi flags under OLD behavior.")
  endif()
endif()

set(CMAKE_MSVC_DEBUG_INFORMATION_FORMAT BogusValue)
add_library(foo empty.cxx)
