# awk

> Універсальна мова програмування для роботи з файлами.
> Дивіться також: `gawk`.
> Більше інформації: <https://github.com/onetrueawk/awk>.

- Вивести п’ятий стовпець (він же поле) у файлі, розділеному пробілами:

`awk '{print $5}' {{шлях/до/файлу}}`

- Вивести другий стовпець рядків, що містять "foo", у файлі, розділеному пробілами:

`awk '/{{foo}}/ {print $2}' {{шлях/до/файлу}}`

- Вивести останній стовпець кожного рядка у файлі, використовуючи кому (замість пробілу) як роздільник полів:

`awk -F ',' '{print $NF}' {{шлях/до/файлу}}`

- Підсумувати значення в першому стовпці файлу та надрукувати підсумок:

`awk '{s+=$1} END {print s}' {{шлях/до/файлу}}`

- Вивести кожен третій рядок, починаючи з першого:

`awk 'NR%3==1' {{шлях/до/файлу}}`

- Вивести різні значення залежно від умов:

`awk '{if ($1 == "foo") print "Точний збіг foo"; else if ($1 ~ "bar") print "Частковий збіг bar"; else print "Baz"}' {{шлях/до/файлу}}`

- Вивести всі рядки, значення 10-го стовпця яких знаходиться між min і max:

`awk '($10 >= {{min_value}} && $10 <= {{max_value}})'`

- Вивести таблицю користувачів із UID >=1000 із заголовком і форматуванням, використовуючи двокрапку як роздільник ("%-20s" означає: 20 символів рядка з вирівнюванням по лівому краю, "%6s" означає: 6 символів рядка з вирівнюванням по правому краю):

`awk 'BEGIN {FS=":";printf "%-20s %6s %25s\n", "Name", "UID", "Shell"} $4 >= 1000 {printf "%-20s %6d %25s\n", $1, $4, $7}' /etc/passwd`
