# phpmd

> PHP Mess Detector: 일반적인 잠재적 문제를 확인.
> 더 많은 정보: <https://github.com/phpmd/phpmd#command-line-options>.

- 사용 가능한 규칙 세트 및 형식 목록 표시:

`phpmd`

- 쉼표로 구분된 규칙 세트를 사용하여 파일 또는 폴더에서 문제 스캔:

`phpmd {{경로/대상/파일_또는_폴더}} {{xml|text|html}} {{규칙세트1,규칙세트2,...}}`

- 규칙의 최소 우선순위 임계값 지정:

`phpmd {{경로/대상/파일_또는_폴더}} {{xml|text|html}} {{규칙세트1,규칙세트2,...}} --minimumpriority {{우선순위}}`

- 분석에 포함할 확장자 지정:

`phpmd {{경로/대상/파일_또는_폴더}} {{xml|text|html}} {{규칙세트1,규칙세트2,...}} --suffixes {{확장자}}`

- 쉼표로 구분된 특정 폴더 제외:

`phpmd {{경로/대상/파일_또는_폴더1,경로/대상/파일_또는_폴더2,...}} {{xml|text|html}} {{규칙세트1,규칙세트2,...}} --exclude {{폴더_패턴}}`

- 결과를 `stdout` 대신 파일에 출력:

`phpmd {{경로/대상/파일_또는_폴더}} {{xml|text|html}} {{규칙세트1,규칙세트2,...}} --reportfile {{경로/대상/보고서_파일}}`

- 경고 억제 PHPDoc 주석 사용 무시:

`phpmd {{경로/대상/파일_또는_폴더}} {{xml|text|html}} {{규칙세트1,규칙세트2,...}} --strict`
