# git show

> 다양한 종류의 Git 객체 (커밋, 태그 등)을 표시합니다.
> 더 많은 정보: <https://git-scm.com/docs/git-show>.

- 최신 커밋에 대한 정보 표시 (해시, 메시지, 변경 사항 및 기타 메타데이터):

`git show`

- 특정 커밋에 대한 정보 표시:

`git show {{커밋}}`

- 특정 태그와 관련된 커밋에 대한 정보 표시:

`git show {{태그}}`

- 브랜치의 HEAD로부터 3번째 커밋에 대한 정보 표시:

`git show {{브랜치}}~{{3}}`

- 커밋 메시지를 한 줄로 표시하고 diff 출력을 억제:

`git show --oneline -s {{커밋}}`

- 변경된 파일에 대한 추가/제거된 문자의 통계만 표시:

`git show --stat {{커밋}}`

- 추가, 이름 변경 또는 삭제된 파일 목록만 표시:

`git show --summary {{커밋}}`

- 파일의 내용을 특정 리비전 (예: 브랜치, 태그 또는 커밋)에서 표시:

`git show {{리비전}}:{{경로/대상/파일}}`
