Tests
=======

This directory contains compatibility tests for librosa's core features.

The MATLAB script ``makeTestData.m`` generates input/output examples under the ``data/`` directory.

After generating the test data, run ``pytest`` from the top-level source directory to perform tests and verify the outputs.

Note: for testing in isolated environments without network access, you can use ``pytest --librosa-isolation`` to bypass any tests which depend on externally hosted data (example audio files, citation data, etc).


Generating test data
====================

The data files for numerical equivalence tests are generated by the ``makeTestData`` matlab program.  This relies on a variety of matlab functions which can be downloaded from the following URLs:

  - http://www.ee.columbia.edu/~dpwe/resources/matlab/rastamat/
  - http://www.ee.columbia.edu/~dpwe/resources/matlab/chroma-ansyn/

The following [RASTAMAT](http://www.ee.columbia.edu/~dpwe/resources/matlab/rastamat/) functions are required to run the ``makeTestData.m`` matlab program:

  - ``mel2hz.m`` http://www.ee.columbia.edu/~dpwe/resources/matlab/rastamat/mel2hz.m
  - ``hz2mel.m`` http://www.ee.columbia.edu/~dpwe/resources/matlab/rastamat/hz2mel.m
  - ``fft2melmx.m`` http://www.ee.columbia.edu/~dpwe/resources/matlab/rastamat/fft2melmx.m

STFT/ISTFT are compared to those available [here](http://www.ee.columbia.edu/ln/rosa/matlab/pvoc/):
  
  - ``stft.m`` http://www.ee.columbia.edu/ln/rosa/matlab/pvoc/stft.m
  - ``istft.m`` http://www.ee.columbia.edu/ln/rosa/matlab/pvoc/istft.m

Beat tracking implementations are provided [here](http://labrosa.ee.columbia.edu/projects/beattrack/):
  - ``tempo2.m`` http://labrosa.ee.columbia.edu/projects/beattrack/tempo2.m
  - ``beat2.m`` http://labrosa.ee.columbia.edu/projects/beattrack/beat2.m

The [chroma-ansyn](http://www.ee.columbia.edu/~dpwe/resources/matlab/chroma-ansyn/chroma-ansyn.tgz) package provides the remaining functions:

  - ``hz2octs.m`` http://www.ee.columbia.edu/~dpwe/resources/matlab/chroma-ansyn/hz2octs.m
  - ``ifgram.m`` http://www.ee.columbia.edu/~dpwe/resources/matlab/chroma-ansyn/ifgram.m
  - ``fft2chromamx.m`` http://www.ee.columbia.edu/~dpwe/resources/matlab/chroma-ansyn/fft2chromamx.m
