# FastAPI Cloud { #fastapi-cloud }

You can deploy your FastAPI app to <a href="https://fastapicloud.com" class="external-link" target="_blank">FastAPI Cloud</a> with **one command**, go and join the waiting list if you haven't. 🚀

## Login { #login }

Make sure you already have a **FastAPI Cloud** account (we invited you from the waiting list 😉).

Then log in:

<div class="termy">

```console
$ fastapi login

You are logged in to FastAPI Cloud 🚀
```

</div>

## Deploy { #deploy }

Now deploy your app, with **one command**:

<div class="termy">

```console
$ fastapi deploy

Deploying to FastAPI Cloud...

✅ Deployment successful!

🐔 Ready the chicken! Your app is ready at https://myapp.fastapicloud.dev
```

</div>

That's it! Now you can access your app at that URL. ✨

## About FastAPI Cloud { #about-fastapi-cloud }

**<a href="https://fastapicloud.com" class="external-link" target="_blank">FastAPI Cloud</a>** is built by the same author and team behind **FastAPI**.

It streamlines the process of **building**, **deploying**, and **accessing** an API with minimal effort.

It brings the same **developer experience** of building apps with FastAPI to **deploying** them to the cloud. 🎉

It will also take care of most of the things you would need when deploying an app, like:

* HTTPS
* Replication, with autoscaling based on requests
* etc.

FastAPI Cloud is the primary sponsor and funding provider for the *FastAPI and friends* open source projects. ✨

## Deploy to other cloud providers { #deploy-to-other-cloud-providers }

FastAPI is open source and based on standards. You can deploy FastAPI apps to any cloud provider you choose.

Follow your cloud provider's guides to deploy FastAPI apps with them. 🤓

## Deploy your own server { #deploy-your-own-server }

I will also teach you later in this **Deployment** guide all the details, so you can understand what is going on, what needs to happen, or how to deploy FastAPI apps on your own, also with your own servers. 🤓
