import { AsyncContextFrameBinding } from './internalBinding/async_context_frame';
import { AsyncWrapBinding } from './internalBinding/async_wrap';
import { BlobBinding } from './internalBinding/blob';
import { BufferBinding } from './internalBinding/buffer';
import { ConfigBinding } from './internalBinding/config';
import { ConstantsBinding } from './internalBinding/constants';
import { DebugBinding } from './internalBinding/debug';
import { EncodingBinding } from './internalBinding/encoding_binding';
import { HttpParserBinding } from './internalBinding/http_parser';
import { InspectorBinding } from './internalBinding/inspector';
import { FsBinding } from './internalBinding/fs';
import { FsDirBinding } from './internalBinding/fs_dir';
import { ICUBinding } from './internalBinding/icu';
import { LocksBinding } from './internalBinding/locks';
import { MessagingBinding } from './internalBinding/messaging';
import { OptionsBinding } from './internalBinding/options';
import { OSBinding } from './internalBinding/os';
import { ProcessBinding } from './internalBinding/process';
import { SeaBinding } from './internalBinding/sea';
import { SerdesBinding } from './internalBinding/serdes';
import { StringDecoderBinding } from './internalBinding/string_decoder';
import { SymbolsBinding } from './internalBinding/symbols';
import { TimersBinding } from './internalBinding/timers';
import { TypesBinding } from './internalBinding/types';
import { URLBinding } from './internalBinding/url';
import { URLPatternBinding } from "./internalBinding/url_pattern";
import { UtilBinding } from './internalBinding/util';
import { UVBinding } from './internalBinding/uv';
import { WASIBinding } from './internalBinding/wasi';
import { WorkerBinding } from './internalBinding/worker';
import { ModulesBinding } from './internalBinding/modules';
import { ZlibBinding } from './internalBinding/zlib';

interface InternalBindingMap {
  async_context_frame: AsyncContextFrameBinding;
  async_wrap: AsyncWrapBinding;
  blob: BlobBinding;
  buffer: BufferBinding;
  config: ConfigBinding;
  constants: ConstantsBinding;
  debug: DebugBinding;
  encoding_binding: EncodingBinding;
  fs: FsBinding;
  fs_dir: FsDirBinding;
  http_parser: HttpParserBinding;
  icu: ICUBinding;
  inspector: InspectorBinding;
  locks: LocksBinding;
  messaging: MessagingBinding;
  modules: ModulesBinding;
  options: OptionsBinding;
  os: OSBinding;
  process: ProcessBinding;
  sea: SeaBinding;
  serdes: SerdesBinding;
  string_decoder: StringDecoderBinding;
  symbols: SymbolsBinding;
  timers: TimersBinding;
  types: TypesBinding;
  url: URLBinding;
  url_pattern: URLPatternBinding;
  util: UtilBinding;
  uv: UVBinding;
  wasi: WASIBinding;
  worker: WorkerBinding;
  zlib: ZlibBinding;
}

type InternalBindingKeys = keyof InternalBindingMap;

declare function internalBinding<T extends InternalBindingKeys>(binding: T): InternalBindingMap[T]

declare global {
  type TypedArray =
    | Uint8Array
    | Uint8ClampedArray
    | Uint16Array
    | Uint32Array
    | Int8Array
    | Int16Array
    | Int32Array
    | Float16Array
    | Float32Array
    | Float64Array
    | BigUint64Array
    | BigInt64Array;

  namespace NodeJS {
    interface Global {
      internalBinding<T extends InternalBindingKeys>(binding: T): InternalBindingMap[T]
    }
  }
}
