## gflags CMake configuration file

include(CMakeFindDependencyMacro)
if(ON)
  find_dependency(Threads)
endif()

set(gflags_known_comps static shared nothreads_static nothreads_shared)
set(gflags_comp_static NO)
set(gflags_comp_shared NO)
set(gflags_comp_nothreads_static NO)
set(gflags_comp_nothreads_shared NO)
foreach (gflags_comp IN LISTS ${CMAKE_FIND_PACKAGE_NAME}_FIND_COMPONENTS)
    if (gflags_comp IN_LIST gflags_known_comps)
        set(gflags_comp_${gflags_comp} YES)
    else ()
        set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
            "gflags does not recognize component `${gflags_comp}`.")
        set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
        return()
    endif ()
endforeach ()

if (gflags_comp_static AND gflags_comp_shared)
    set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
        "gflags `static` and `shared` components are mutually exclusive.")
    set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
    return()
endif ()

set(gflags_static_targets "${CMAKE_CURRENT_LIST_DIR}/gflags_static-targets.cmake")
set(gflags_shared_targets "${CMAKE_CURRENT_LIST_DIR}/gflags_shared-targets.cmake")
set(gflags_nothreads_static_targets "${CMAKE_CURRENT_LIST_DIR}/gflags_nothreads_static-targets.cmake")
set(gflags_nothreads_shared_targets "${CMAKE_CURRENT_LIST_DIR}/gflags_nothreads_shared-targets.cmake")

macro(gflags_load_targets type)
    if (NOT EXISTS "${gflags_${type}_targets}")
        set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
            "gflags `${type}` libraries were requested but not found.")
        set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
        return()
    endif ()
    include("${gflags_${type}_targets}")
    if(NOT TARGET gflags)
        add_library(gflags ALIAS gflags::gflags)
    endif()
endmacro()

if (gflags_comp_static)
    gflags_load_targets(static)
elseif (gflags_comp_shared)
    gflags_load_targets(shared)
elseif (gflags_comp_nothreads_shared)
    gflags_load_targets(nothreads_shared)
elseif (gflags_comp_nothreads_static)
    gflags_load_targets(nothreads_static)
elseif (DEFINED gflags_SHARED_LIBS AND gflags_SHARED_LIBS)
    gflags_load_targets(shared)
elseif (DEFINED gflags_SHARED_LIBS AND NOT gflags_SHARED_LIBS)
    gflags_load_targets(static)
elseif (BUILD_SHARED_LIBS)
    if (EXISTS "${gflags_shared_targets}")
        gflags_load_targets(shared)
    else ()
        gflags_load_targets(static)
    endif ()
else ()
    if (EXISTS "${gflags_static_targets}")
        gflags_load_targets(static)
    else ()
        gflags_load_targets(shared)
    endif ()
endif ()
