;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt -all             %s -S -o - | filecheck %s

;; RUN: wasm-opt -all --roundtrip %s -S -o - | filecheck %s --check-prefix=RTRIP

;; Check that separate code annotations do not interfere with each other, even
;; in the same function.
(module
  ;; CHECK:      (type $0 (func (param i32)))

  ;; CHECK:      (type $func (func))
  ;; RTRIP:      (type $0 (func (param i32)))

  ;; RTRIP:      (type $func (func))
  (type $func (func))

  ;; CHECK:      (table $table 10 20 funcref)
  ;; RTRIP:      (table $table 10 20 funcref)
  (table $table 10 20 funcref)

  ;; CHECK:      (func $inline (type $func)
  ;; CHECK-NEXT:  (@metadata.code.inline "\00")
  ;; CHECK-NEXT:  (call $inline)
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $inline (type $func)
  ;; RTRIP-NEXT:  (@metadata.code.inline "\00")
  ;; RTRIP-NEXT:  (call $inline)
  ;; RTRIP-NEXT: )
  (func $inline
    (@metadata.code.inline "\00")
    (call $inline)
  )

  ;; CHECK:      (func $branch (type $0) (param $x i32)
  ;; CHECK-NEXT:  (block $out
  ;; CHECK-NEXT:   (@metadata.code.branch_hint "\01")
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $branch (type $0) (param $x i32)
  ;; RTRIP-NEXT:  (block $block
  ;; RTRIP-NEXT:   (@metadata.code.branch_hint "\01")
  ;; RTRIP-NEXT:   (br_if $block
  ;; RTRIP-NEXT:    (local.get $x)
  ;; RTRIP-NEXT:   )
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT: )
  (func $branch (param $x i32)
    (block $out
      (@metadata.code.branch_hint "\01")
      (br_if $out
        (local.get $x)
      )
    )
  )

  ;; CHECK:      (func $both (type $0) (param $x i32)
  ;; CHECK-NEXT:  (block $out
  ;; CHECK-NEXT:   (@metadata.code.inline "\02")
  ;; CHECK-NEXT:   (call $inline)
  ;; CHECK-NEXT:   (@metadata.code.branch_hint "\00")
  ;; CHECK-NEXT:   (br_if $out
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; RTRIP:      (func $both (type $0) (param $x i32)
  ;; RTRIP-NEXT:  (block $block
  ;; RTRIP-NEXT:   (@metadata.code.inline "\02")
  ;; RTRIP-NEXT:   (call $inline)
  ;; RTRIP-NEXT:   (@metadata.code.branch_hint "\00")
  ;; RTRIP-NEXT:   (br_if $block
  ;; RTRIP-NEXT:    (local.get $x)
  ;; RTRIP-NEXT:   )
  ;; RTRIP-NEXT:  )
  ;; RTRIP-NEXT: )
  (func $both (param $x i32)
    (block $out
      (@metadata.code.inline "\02")
      (call $inline)
      (@metadata.code.branch_hint "\00")
      (br_if $out
        (local.get $x)
      )
    )
  )
)
