;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wast -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wast
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wast | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wast | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
  ;; CHECK-TEXT:      (type $0 (func))

  ;; CHECK-TEXT:      (type $1 (func (param i32)))

  ;; CHECK-TEXT:      (type $2 (func (param i64)))

  ;; CHECK-TEXT:      (type $3 (func (param i32 i64)))

  ;; CHECK-TEXT:      (type $4 (func (param eqref)))

  ;; CHECK-TEXT:      (tag $e-i32 (type $1) (param i32))
  ;; CHECK-BIN:      (type $0 (func))

  ;; CHECK-BIN:      (type $1 (func (param i32)))

  ;; CHECK-BIN:      (type $2 (func (param i64)))

  ;; CHECK-BIN:      (type $3 (func (param i32 i64)))

  ;; CHECK-BIN:      (type $4 (func (param eqref)))

  ;; CHECK-BIN:      (tag $e-i32 (type $1) (param i32))
  (tag $e-i32 (param i32))
  ;; CHECK-TEXT:      (tag $e-i64 (type $2) (param i64))
  ;; CHECK-BIN:      (tag $e-i64 (type $2) (param i64))
  (tag $e-i64 (param i64))
  ;; CHECK-TEXT:      (tag $e-i32-i64 (type $3) (param i32 i64))
  ;; CHECK-BIN:      (tag $e-i32-i64 (type $3) (param i32 i64))
  (tag $e-i32-i64 (param i32 i64))
  ;; CHECK-TEXT:      (tag $e-eqref (type $4) (param eqref))
  ;; CHECK-BIN:      (tag $e-eqref (type $4) (param eqref))
  (tag $e-eqref (param (ref null eq)))
  ;; CHECK-TEXT:      (tag $e-empty (type $0))
  ;; CHECK-BIN:      (tag $e-empty (type $0))
  (tag $e-empty)

  ;; CHECK-TEXT:      (func $foo (type $0)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $foo (type $0)
  ;; CHECK-BIN-NEXT: )
  (func $foo)

  ;; CHECK-TEXT:      (func $bar (type $0)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $bar (type $0)
  ;; CHECK-BIN-NEXT: )
  (func $bar)

  ;; ---------------------------------------------------------------------------
  ;; Old Phase 3 exception handling

  ;; CHECK-TEXT:      (func $simple-try-catch (type $0)
  ;; CHECK-TEXT-NEXT:  (try
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (throw $e-i32
  ;; CHECK-TEXT-NEXT:     (i32.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch $e-i32
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (pop i32)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $simple-try-catch (type $0)
  ;; CHECK-BIN-NEXT:  (try
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (throw $e-i32
  ;; CHECK-BIN-NEXT:     (i32.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch $e-i32
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (pop i32)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $simple-try-catch
    (try
      (do
        (throw $e-i32 (i32.const 0))
      )
      (catch $e-i32
        (drop (pop i32))
      )
    )
  )

  ;; CHECK-TEXT:      (func $try-catch-multivalue-tag (type $0)
  ;; CHECK-TEXT-NEXT:  (local $x (tuple i32 i64))
  ;; CHECK-TEXT-NEXT:  (try
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (throw $e-i32-i64
  ;; CHECK-TEXT-NEXT:     (i32.const 0)
  ;; CHECK-TEXT-NEXT:     (i64.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch $e-i32-i64
  ;; CHECK-TEXT-NEXT:    (local.set $x
  ;; CHECK-TEXT-NEXT:     (pop (tuple i32 i64))
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (tuple.extract 2 0
  ;; CHECK-TEXT-NEXT:      (local.get $x)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $try-catch-multivalue-tag (type $0)
  ;; CHECK-BIN-NEXT:  (local $x i32)
  ;; CHECK-BIN-NEXT:  (local $1 i64)
  ;; CHECK-BIN-NEXT:  (local $scratch (tuple i32 i64))
  ;; CHECK-BIN-NEXT:  (local $scratch_3 i32)
  ;; CHECK-BIN-NEXT:  (local $4 (tuple i32 i64))
  ;; CHECK-BIN-NEXT:  (try
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (throw $e-i32-i64
  ;; CHECK-BIN-NEXT:     (i32.const 0)
  ;; CHECK-BIN-NEXT:     (i64.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch $e-i32-i64
  ;; CHECK-BIN-NEXT:    (local.set $4
  ;; CHECK-BIN-NEXT:     (pop (tuple i32 i64))
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (block
  ;; CHECK-BIN-NEXT:     (local.set $x
  ;; CHECK-BIN-NEXT:      (block (result i32)
  ;; CHECK-BIN-NEXT:       (local.set $scratch_3
  ;; CHECK-BIN-NEXT:        (tuple.extract 2 0
  ;; CHECK-BIN-NEXT:         (local.tee $scratch
  ;; CHECK-BIN-NEXT:          (local.get $4)
  ;; CHECK-BIN-NEXT:         )
  ;; CHECK-BIN-NEXT:        )
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:       (local.set $1
  ;; CHECK-BIN-NEXT:        (tuple.extract 2 1
  ;; CHECK-BIN-NEXT:         (local.get $scratch)
  ;; CHECK-BIN-NEXT:        )
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:       (local.get $scratch_3)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (drop
  ;; CHECK-BIN-NEXT:      (local.get $x)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $try-catch-multivalue-tag (local $x (tuple i32 i64))
    (try
      (do
        (throw $e-i32-i64 (i32.const 0) (i64.const 0))
      )
      (catch $e-i32-i64
        (local.set $x (pop (tuple i32 i64)))
        (drop
          (tuple.extract 2 0
            (local.get $x)
          )
        )
      )
    )
  )

  ;; CHECK-TEXT:      (func $try-with-block-label (type $0)
  ;; CHECK-TEXT-NEXT:  (block $label
  ;; CHECK-TEXT-NEXT:   (try $l1
  ;; CHECK-TEXT-NEXT:    (do
  ;; CHECK-TEXT-NEXT:     (br $label)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (catch $e-i32
  ;; CHECK-TEXT-NEXT:     (drop
  ;; CHECK-TEXT-NEXT:      (pop i32)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (br $label)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $try-with-block-label (type $0)
  ;; CHECK-BIN-NEXT:  (block $block
  ;; CHECK-BIN-NEXT:   (try
  ;; CHECK-BIN-NEXT:    (do
  ;; CHECK-BIN-NEXT:     (br $block)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (catch $e-i32
  ;; CHECK-BIN-NEXT:     (drop
  ;; CHECK-BIN-NEXT:      (pop i32)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (br $block)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (unreachable)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $try-with-block-label
    (try $l1
      (do
        (br $l1)
      )
      (catch $e-i32
        (drop (pop i32))
        (br $l1)
      )
    )
  )

  ;; CHECK-TEXT:      (func $empty-try-body (type $0)
  ;; CHECK-TEXT-NEXT:  (try
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch $e-i32
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (pop i32)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $empty-try-body (type $0)
  ;; CHECK-BIN-NEXT:  (try
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch $e-i32
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (pop i32)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $empty-try-body
    (try
      (do)
      (catch $e-i32
        (drop (pop i32))
      )
    )
  )

  ;; CHECK-TEXT:      (func $multiple-insts-within-try-and-catch-bodies (type $0)
  ;; CHECK-TEXT-NEXT:  (try
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (call $foo)
  ;; CHECK-TEXT-NEXT:    (call $bar)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch $e-i32
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (pop i32)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (call $foo)
  ;; CHECK-TEXT-NEXT:    (call $bar)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $multiple-insts-within-try-and-catch-bodies (type $0)
  ;; CHECK-BIN-NEXT:  (try
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (call $foo)
  ;; CHECK-BIN-NEXT:    (call $bar)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch $e-i32
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (pop i32)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (call $foo)
  ;; CHECK-BIN-NEXT:    (call $bar)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $multiple-insts-within-try-and-catch-bodies
    (try
      (do
        (call $foo)
        (call $bar)
      )
      (catch $e-i32
        (drop (pop i32))
        (call $foo)
        (call $bar)
      )
    )
  )

  ;; CHECK-TEXT:      (func $multiple-catches (type $0)
  ;; CHECK-TEXT-NEXT:  (try
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (throw $e-i32
  ;; CHECK-TEXT-NEXT:     (i32.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch $e-i32
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (pop i32)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch $e-i64
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (pop i64)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $multiple-catches (type $0)
  ;; CHECK-BIN-NEXT:  (try
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (throw $e-i32
  ;; CHECK-BIN-NEXT:     (i32.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch $e-i32
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (pop i32)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch $e-i64
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (pop i64)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $multiple-catches
    (try
      (do
        (throw $e-i32 (i32.const 0))
      )
      (catch $e-i32
        (drop (pop i32))
      )
      (catch $e-i64
        (drop (pop i64))
      )
    )
  )

  ;; CHECK-TEXT:      (func $catch-all (type $0)
  ;; CHECK-TEXT-NEXT:  (try
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (throw $e-i32
  ;; CHECK-TEXT-NEXT:     (i32.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch_all
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $catch-all (type $0)
  ;; CHECK-BIN-NEXT:  (try
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (throw $e-i32
  ;; CHECK-BIN-NEXT:     (i32.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch_all
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $catch-all
    (try
      (do
        (throw $e-i32 (i32.const 0))
      )
      (catch_all)
    )
  )

  ;; CHECK-TEXT:      (func $catch-and-catch-all-together (type $0)
  ;; CHECK-TEXT-NEXT:  (try
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (throw $e-i32
  ;; CHECK-TEXT-NEXT:     (i32.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch $e-i32
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (pop i32)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch $e-i64
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (pop i64)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch_all
  ;; CHECK-TEXT-NEXT:    (call $foo)
  ;; CHECK-TEXT-NEXT:    (call $bar)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $catch-and-catch-all-together (type $0)
  ;; CHECK-BIN-NEXT:  (try
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (throw $e-i32
  ;; CHECK-BIN-NEXT:     (i32.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch $e-i32
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (pop i32)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch $e-i64
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (pop i64)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch_all
  ;; CHECK-BIN-NEXT:    (call $foo)
  ;; CHECK-BIN-NEXT:    (call $bar)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $catch-and-catch-all-together
    (try
      (do
        (throw $e-i32 (i32.const 0))
      )
      (catch $e-i32
        (drop (pop i32))
      )
      (catch $e-i64
        (drop (pop i64))
      )
      (catch_all
        (call $foo)
        (call $bar)
      )
    )
  )

  ;; CHECK-TEXT:      (func $nested-try-catch (type $0)
  ;; CHECK-TEXT-NEXT:  (try
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (try
  ;; CHECK-TEXT-NEXT:     (do
  ;; CHECK-TEXT-NEXT:      (throw $e-i32
  ;; CHECK-TEXT-NEXT:       (i32.const 0)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (catch $e-i32
  ;; CHECK-TEXT-NEXT:      (drop
  ;; CHECK-TEXT-NEXT:       (pop i32)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (catch_all
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch $e-i32
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (pop i32)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch_all
  ;; CHECK-TEXT-NEXT:    (try
  ;; CHECK-TEXT-NEXT:     (do
  ;; CHECK-TEXT-NEXT:      (throw $e-i32
  ;; CHECK-TEXT-NEXT:       (i32.const 0)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (catch $e-i32
  ;; CHECK-TEXT-NEXT:      (drop
  ;; CHECK-TEXT-NEXT:       (pop i32)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (catch_all
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $nested-try-catch (type $0)
  ;; CHECK-BIN-NEXT:  (try
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (try
  ;; CHECK-BIN-NEXT:     (do
  ;; CHECK-BIN-NEXT:      (throw $e-i32
  ;; CHECK-BIN-NEXT:       (i32.const 0)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (catch $e-i32
  ;; CHECK-BIN-NEXT:      (drop
  ;; CHECK-BIN-NEXT:       (pop i32)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (catch_all
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch $e-i32
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (pop i32)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch_all
  ;; CHECK-BIN-NEXT:    (try
  ;; CHECK-BIN-NEXT:     (do
  ;; CHECK-BIN-NEXT:      (throw $e-i32
  ;; CHECK-BIN-NEXT:       (i32.const 0)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (catch $e-i32
  ;; CHECK-BIN-NEXT:      (drop
  ;; CHECK-BIN-NEXT:       (pop i32)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (catch_all
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $nested-try-catch
    (try
      (do
        (try
          (do
            (throw $e-i32 (i32.const 0))
          )
          (catch $e-i32
            (drop (pop i32))
          )
          (catch_all)
        )
      )
      (catch $e-i32
        (drop (pop i32))
      )
      (catch_all
        (try
          (do
            (throw $e-i32 (i32.const 0))
          )
          (catch $e-i32
            (drop (pop i32))
          )
          (catch_all)
        )
      )
    )
  )

  ;; CHECK-TEXT:      (func $catchless-delegateless-try (type $0)
  ;; CHECK-TEXT-NEXT:  (try
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (throw $e-i32
  ;; CHECK-TEXT-NEXT:     (i32.const 0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $catchless-delegateless-try (type $0)
  ;; CHECK-BIN-NEXT:  (try
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (throw $e-i32
  ;; CHECK-BIN-NEXT:     (i32.const 0)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (unreachable)
  ;; CHECK-BIN-NEXT: )
  (func $catchless-delegateless-try
    (try
      (do
        (throw $e-i32 (i32.const 0))
      )
    )
  )

  ;; CHECK-TEXT:      (func $inner-delegate-target-outer-catch (type $0)
  ;; CHECK-TEXT-NEXT:  (try $l0
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (try
  ;; CHECK-TEXT-NEXT:     (do
  ;; CHECK-TEXT-NEXT:      (call $foo)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (delegate $l0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (try
  ;; CHECK-TEXT-NEXT:     (do
  ;; CHECK-TEXT-NEXT:      (call $foo)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (delegate $l0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch_all
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $inner-delegate-target-outer-catch (type $0)
  ;; CHECK-BIN-NEXT:  (try $label
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (try
  ;; CHECK-BIN-NEXT:     (do
  ;; CHECK-BIN-NEXT:      (call $foo)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (delegate $label)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (try
  ;; CHECK-BIN-NEXT:     (do
  ;; CHECK-BIN-NEXT:      (call $foo)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (delegate $label)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch_all
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $inner-delegate-target-outer-catch
    (try $l0
      (do
        (try
          (do
            (call $foo)
          )
          (delegate $l0) ;; by label
        )
        (try
          (do
            (call $foo)
          )
          (delegate 0) ;; by depth
        )
      )
      (catch_all)
    )
  )

  ;; CHECK-TEXT:      (func $branch-and-delegate-target-same-try-label (type $0)
  ;; CHECK-TEXT-NEXT:  (block $label
  ;; CHECK-TEXT-NEXT:   (try $l0
  ;; CHECK-TEXT-NEXT:    (do
  ;; CHECK-TEXT-NEXT:     (try
  ;; CHECK-TEXT-NEXT:      (do
  ;; CHECK-TEXT-NEXT:       (br_if $label
  ;; CHECK-TEXT-NEXT:        (i32.const 1)
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:      (delegate $l0)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (try
  ;; CHECK-TEXT-NEXT:      (do
  ;; CHECK-TEXT-NEXT:       (br_if $label
  ;; CHECK-TEXT-NEXT:        (i32.const 1)
  ;; CHECK-TEXT-NEXT:       )
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:      (delegate $l0)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (catch_all
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $branch-and-delegate-target-same-try-label (type $0)
  ;; CHECK-BIN-NEXT:  (block $block
  ;; CHECK-BIN-NEXT:   (try $label
  ;; CHECK-BIN-NEXT:    (do
  ;; CHECK-BIN-NEXT:     (try
  ;; CHECK-BIN-NEXT:      (do
  ;; CHECK-BIN-NEXT:       (br_if $block
  ;; CHECK-BIN-NEXT:        (i32.const 1)
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:      (delegate $label)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (try
  ;; CHECK-BIN-NEXT:      (do
  ;; CHECK-BIN-NEXT:       (br_if $block
  ;; CHECK-BIN-NEXT:        (i32.const 1)
  ;; CHECK-BIN-NEXT:       )
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:      (delegate $label)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (catch_all
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $branch-and-delegate-target-same-try-label
    ;; When there are both a branch and a delegate that target the same try
    ;; label. Because binaryen only allows blocks and loops to be targetted by
    ;; branches, we wrap the try with a block and make branches that block
    ;; instead, resulting in the br and delegate target different labels in the
    ;; output.
    (try $l0
      (do
        (try
          (do
            (br_if $l0 (i32.const 1))
          )
          (delegate $l0) ;; by label
        )
        (try
          (do
            (br_if $l0 (i32.const 1))
          )
          (delegate 0) ;; by depth
        )
      )
      (catch_all)
    )
  )

  ;; CHECK-TEXT:      (func $inner-delegate-target-outer-delegate (type $0)
  ;; CHECK-TEXT-NEXT:  (try $l0
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (try
  ;; CHECK-TEXT-NEXT:     (do
  ;; CHECK-TEXT-NEXT:      (call $foo)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (delegate $l0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (delegate 0)
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $inner-delegate-target-outer-delegate (type $0)
  ;; CHECK-BIN-NEXT:  (try $label
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (try
  ;; CHECK-BIN-NEXT:     (do
  ;; CHECK-BIN-NEXT:      (call $foo)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (delegate $label)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (delegate 0)
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $inner-delegate-target-outer-delegate
    ;; The inner delegate targets the outer delegate, which in turn targets the
    ;; caller.
    (try $l0
      (do
        (try
          (do
            (call $foo)
          )
          (delegate $l0)
        )
      )
      (delegate 0)
    )
  )

  ;; CHECK-TEXT:      (func $empty-catch-body (type $0)
  ;; CHECK-TEXT-NEXT:  (try
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch $e-empty
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $empty-catch-body (type $0)
  ;; CHECK-BIN-NEXT:  (try
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch $e-empty
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $empty-catch-body
    ;; 'catch' body can be empty when the tag's type is none.
    (try
      (do)
      (catch $e-empty)
    )
  )

  ;; CHECK-TEXT:      (func $try-catch-rethrow (type $0)
  ;; CHECK-TEXT-NEXT:  (try $l0
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (call $foo)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch $e-i32
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (pop i32)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (rethrow $l0)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch_all
  ;; CHECK-TEXT-NEXT:    (rethrow $l0)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $try-catch-rethrow (type $0)
  ;; CHECK-BIN-NEXT:  (try $label
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (call $foo)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch $e-i32
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (pop i32)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (rethrow $label)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch_all
  ;; CHECK-BIN-NEXT:    (rethrow $label)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $try-catch-rethrow
    ;; Simple try-catch-rethrow
    (try $l0
      (do
        (call $foo)
      )
      (catch $e-i32
        (drop (pop i32))
        (rethrow $l0) ;; by label
      )
      (catch_all
        (rethrow 0) ;; by depth
      )
    )
  )

  ;; CHECK-TEXT:      (func $branch-and-rethrow-target-same-try-label (type $0)
  ;; CHECK-TEXT-NEXT:  (block $label
  ;; CHECK-TEXT-NEXT:   (try $l0
  ;; CHECK-TEXT-NEXT:    (do
  ;; CHECK-TEXT-NEXT:     (call $foo)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (catch $e-i32
  ;; CHECK-TEXT-NEXT:     (drop
  ;; CHECK-TEXT-NEXT:      (pop i32)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (rethrow $l0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (catch_all
  ;; CHECK-TEXT-NEXT:     (br $label)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $branch-and-rethrow-target-same-try-label (type $0)
  ;; CHECK-BIN-NEXT:  (block $block
  ;; CHECK-BIN-NEXT:   (try $label
  ;; CHECK-BIN-NEXT:    (do
  ;; CHECK-BIN-NEXT:     (call $foo)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (catch $e-i32
  ;; CHECK-BIN-NEXT:     (drop
  ;; CHECK-BIN-NEXT:      (pop i32)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (rethrow $label)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (catch_all
  ;; CHECK-BIN-NEXT:     (br $block)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $branch-and-rethrow-target-same-try-label
    ;; When there are both a branch and a rethrow that target the same try
    ;; label. Because binaryen only allows blocks and loops to be targetted by
    ;; branches, we wrap the try with a block and make branches that block
    ;; instead, resulting in the br and rethrow target different labels in the
    ;; output.
    (try $l0
      (do
        (call $foo)
      )
      (catch $e-i32
        (drop (pop i32))
        (rethrow $l0)
      )
      (catch_all
        (br $l0)
      )
    )
  )

  ;; CHECK-TEXT:      (func $nested-rethrow (type $0)
  ;; CHECK-TEXT-NEXT:  (try $l0
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (call $foo)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch_all
  ;; CHECK-TEXT-NEXT:    (try
  ;; CHECK-TEXT-NEXT:     (do
  ;; CHECK-TEXT-NEXT:      (call $foo)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (catch $e-i32
  ;; CHECK-TEXT-NEXT:      (drop
  ;; CHECK-TEXT-NEXT:       (pop i32)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:      (rethrow $l0)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (catch_all
  ;; CHECK-TEXT-NEXT:      (rethrow $l0)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $nested-rethrow (type $0)
  ;; CHECK-BIN-NEXT:  (try $label
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (call $foo)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch_all
  ;; CHECK-BIN-NEXT:    (try
  ;; CHECK-BIN-NEXT:     (do
  ;; CHECK-BIN-NEXT:      (call $foo)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (catch $e-i32
  ;; CHECK-BIN-NEXT:      (drop
  ;; CHECK-BIN-NEXT:       (pop i32)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:      (rethrow $label)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (catch_all
  ;; CHECK-BIN-NEXT:      (rethrow $label)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $nested-rethrow
    ;; One more level deep
    (try $l0
      (do
        (call $foo)
      )
      (catch_all
        (try
          (do
            (call $foo)
          )
          (catch $e-i32
            (drop (pop i32))
            (rethrow $l0) ;; by label
          )
          (catch_all
            (rethrow 1) ;; by depth
          )
        )
      )
    )
  )

  ;; CHECK-TEXT:      (func $rnested-rethrow-with-interleaving-block (type $0)
  ;; CHECK-TEXT-NEXT:  (try $l0
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (call $foo)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch_all
  ;; CHECK-TEXT-NEXT:    (try
  ;; CHECK-TEXT-NEXT:     (do
  ;; CHECK-TEXT-NEXT:      (call $foo)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (catch $e-i32
  ;; CHECK-TEXT-NEXT:      (drop
  ;; CHECK-TEXT-NEXT:       (pop i32)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:      (block $b0
  ;; CHECK-TEXT-NEXT:       (rethrow $l0)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (catch_all
  ;; CHECK-TEXT-NEXT:      (block $b1
  ;; CHECK-TEXT-NEXT:       (rethrow $l0)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $rnested-rethrow-with-interleaving-block (type $0)
  ;; CHECK-BIN-NEXT:  (try $label
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (call $foo)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch_all
  ;; CHECK-BIN-NEXT:    (try
  ;; CHECK-BIN-NEXT:     (do
  ;; CHECK-BIN-NEXT:      (call $foo)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (catch $e-i32
  ;; CHECK-BIN-NEXT:      (drop
  ;; CHECK-BIN-NEXT:       (pop i32)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:      (block
  ;; CHECK-BIN-NEXT:       (rethrow $label)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:      (unreachable)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (catch_all
  ;; CHECK-BIN-NEXT:      (rethrow $label)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $rnested-rethrow-with-interleaving-block
    ;; Interleaving block
    (try $l0
      (do
        (call $foo)
      )
      (catch_all
        (try
          (do
            (call $foo)
          )
          (catch $e-i32
            (drop (pop i32))
            (block $b0
              (rethrow $l0) ;; by label
            )
          )
          (catch_all
            (block $b1
              (rethrow 2) ;; by depth
            )
          )
        )
      )
    )
  )

  ;; CHECK-TEXT:      (func $rethrow-within-nested-try-part (type $0)
  ;; CHECK-TEXT-NEXT:  (try $l0
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (call $foo)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch_all
  ;; CHECK-TEXT-NEXT:    (try
  ;; CHECK-TEXT-NEXT:     (do
  ;; CHECK-TEXT-NEXT:      (rethrow $l0)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (catch_all
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (try $l00
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (call $foo)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch_all
  ;; CHECK-TEXT-NEXT:    (try
  ;; CHECK-TEXT-NEXT:     (do
  ;; CHECK-TEXT-NEXT:      (rethrow $l00)
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (catch_all
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $rethrow-within-nested-try-part (type $0)
  ;; CHECK-BIN-NEXT:  (try $label
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (call $foo)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch_all
  ;; CHECK-BIN-NEXT:    (try
  ;; CHECK-BIN-NEXT:     (do
  ;; CHECK-BIN-NEXT:      (rethrow $label)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (catch_all
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (try $label1
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (call $foo)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch_all
  ;; CHECK-BIN-NEXT:    (try
  ;; CHECK-BIN-NEXT:     (do
  ;; CHECK-BIN-NEXT:      (rethrow $label1)
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (catch_all
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $rethrow-within-nested-try-part
    ;; Within nested try, but rather in 'try' part and not 'catch'
    (try $l0
      (do
        (call $foo)
      )
      (catch_all
        (try
          (do
            (rethrow $l0) ;; by label
          )
          (catch_all)
        )
      )
    )
    (try $l0
      (do
        (call $foo)
      )
      (catch_all
        (try
          (do
            (rethrow 1) ;; by depth
          )
          (catch_all)
        )
      )
    )
  )

  ;; CHECK-TEXT:      (func $pop-within-if-condition (type $0)
  ;; CHECK-TEXT-NEXT:  (try
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch $e-i32
  ;; CHECK-TEXT-NEXT:    (throw $e-i32
  ;; CHECK-TEXT-NEXT:     (if (result i32)
  ;; CHECK-TEXT-NEXT:      (pop i32)
  ;; CHECK-TEXT-NEXT:      (then
  ;; CHECK-TEXT-NEXT:       (i32.const 0)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:      (else
  ;; CHECK-TEXT-NEXT:       (i32.const 3)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $pop-within-if-condition (type $0)
  ;; CHECK-BIN-NEXT:  (try
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch $e-i32
  ;; CHECK-BIN-NEXT:    (throw $e-i32
  ;; CHECK-BIN-NEXT:     (if (result i32)
  ;; CHECK-BIN-NEXT:      (pop i32)
  ;; CHECK-BIN-NEXT:      (then
  ;; CHECK-BIN-NEXT:       (i32.const 0)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:      (else
  ;; CHECK-BIN-NEXT:       (i32.const 3)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $pop-within-if-condition
    (try
      (do)
      (catch $e-i32
        (throw $e-i32
          (if (result i32)
            ;; pop is within an if condition, so this is OK.
            (pop i32)
            (then
              (i32.const 0)
            )
            (else
              (i32.const 3)
            )
          )
        )
      )
    )
  )

  ;; CHECK-TEXT:      (func $pop-can-be-supertype (type $0)
  ;; CHECK-TEXT-NEXT:  (try
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (catch $e-eqref
  ;; CHECK-TEXT-NEXT:    (drop
  ;; CHECK-TEXT-NEXT:     (pop eqref)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $pop-can-be-supertype (type $0)
  ;; CHECK-BIN-NEXT:  (try
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (catch $e-eqref
  ;; CHECK-BIN-NEXT:    (drop
  ;; CHECK-BIN-NEXT:     (pop eqref)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT: )
  (func $pop-can-be-supertype
    (try
      (do)
      (catch $e-eqref
        (drop
          (pop anyref) ;; pop can be supertype
        )
      )
    )
  )

  ;; CHECK-TEXT:      (func $catchless-try-with-inner-delegate (type $0)
  ;; CHECK-TEXT-NEXT:  (try $label$0
  ;; CHECK-TEXT-NEXT:   (do
  ;; CHECK-TEXT-NEXT:    (try
  ;; CHECK-TEXT-NEXT:     (do
  ;; CHECK-TEXT-NEXT:      (throw $e-i32
  ;; CHECK-TEXT-NEXT:       (i32.const 0)
  ;; CHECK-TEXT-NEXT:      )
  ;; CHECK-TEXT-NEXT:     )
  ;; CHECK-TEXT-NEXT:     (delegate $label$0)
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $catchless-try-with-inner-delegate (type $0)
  ;; CHECK-BIN-NEXT:  (try $label
  ;; CHECK-BIN-NEXT:   (do
  ;; CHECK-BIN-NEXT:    (try
  ;; CHECK-BIN-NEXT:     (do
  ;; CHECK-BIN-NEXT:      (throw $e-i32
  ;; CHECK-BIN-NEXT:       (i32.const 0)
  ;; CHECK-BIN-NEXT:      )
  ;; CHECK-BIN-NEXT:     )
  ;; CHECK-BIN-NEXT:     (delegate $label)
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (unreachable)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (unreachable)
  ;; CHECK-BIN-NEXT: )
  (func $catchless-try-with-inner-delegate
    (try $label$0
      (do
        (try
          (do
            (throw $e-i32
              (i32.const 0)
            )
          )
          (delegate $label$0)
        )
      )
    )
  )

  ;; CHECK-TEXT:      (func $nested-delegate-within-block (type $0)
  ;; CHECK-TEXT-NEXT:  (block $l0
  ;; CHECK-TEXT-NEXT:   (block $l1
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:   (try
  ;; CHECK-TEXT-NEXT:    (do
  ;; CHECK-TEXT-NEXT:    )
  ;; CHECK-TEXT-NEXT:    (delegate 1)
  ;; CHECK-TEXT-NEXT:   )
  ;; CHECK-TEXT-NEXT:  )
  ;; CHECK-TEXT-NEXT:  (nop)
  ;; CHECK-TEXT-NEXT: )
  ;; CHECK-BIN:      (func $nested-delegate-within-block (type $0)
  ;; CHECK-BIN-NEXT:  (block
  ;; CHECK-BIN-NEXT:   (block
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:   (try
  ;; CHECK-BIN-NEXT:    (do
  ;; CHECK-BIN-NEXT:    )
  ;; CHECK-BIN-NEXT:    (delegate 1)
  ;; CHECK-BIN-NEXT:   )
  ;; CHECK-BIN-NEXT:  )
  ;; CHECK-BIN-NEXT:  (nop)
  ;; CHECK-BIN-NEXT: )
  (func $nested-delegate-within-block
    ;; When 'delegate' is next to a nested block, make sure its delegate
    ;; argument is parsed correctly.
    (block $l0
      (block $l1)
      (try
        (do)
        (delegate 1) ;; to caller
      )
    )
    (nop)
  )
)
;; CHECK-BIN-NODEBUG:      (type $0 (func))

;; CHECK-BIN-NODEBUG:      (type $1 (func (param i32)))

;; CHECK-BIN-NODEBUG:      (type $2 (func (param i64)))

;; CHECK-BIN-NODEBUG:      (type $3 (func (param i32 i64)))

;; CHECK-BIN-NODEBUG:      (type $4 (func (param eqref)))

;; CHECK-BIN-NODEBUG:      (tag $tag$0 (type $1) (param i32))

;; CHECK-BIN-NODEBUG:      (tag $tag$1 (type $2) (param i64))

;; CHECK-BIN-NODEBUG:      (tag $tag$2 (type $3) (param i32 i64))

;; CHECK-BIN-NODEBUG:      (tag $tag$3 (type $4) (param eqref))

;; CHECK-BIN-NODEBUG:      (tag $tag$4 (type $0))

;; CHECK-BIN-NODEBUG:      (func $0 (type $0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $1 (type $0)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $2 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (throw $tag$0
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $3 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch (tuple i32 i64))
;; CHECK-BIN-NODEBUG-NEXT:  (local $scratch_3 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $4 (tuple i32 i64))
;; CHECK-BIN-NODEBUG-NEXT:  (try
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (throw $tag$2
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:     (i64.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch $tag$2
;; CHECK-BIN-NODEBUG-NEXT:    (local.set $4
;; CHECK-BIN-NODEBUG-NEXT:     (pop (tuple i32 i64))
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (block
;; CHECK-BIN-NODEBUG-NEXT:     (local.set $0
;; CHECK-BIN-NODEBUG-NEXT:      (block (result i32)
;; CHECK-BIN-NODEBUG-NEXT:       (local.set $scratch_3
;; CHECK-BIN-NODEBUG-NEXT:        (tuple.extract 2 0
;; CHECK-BIN-NODEBUG-NEXT:         (local.tee $scratch
;; CHECK-BIN-NODEBUG-NEXT:          (local.get $4)
;; CHECK-BIN-NODEBUG-NEXT:         )
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:       (local.set $1
;; CHECK-BIN-NODEBUG-NEXT:        (tuple.extract 2 1
;; CHECK-BIN-NODEBUG-NEXT:         (local.get $scratch)
;; CHECK-BIN-NODEBUG-NEXT:        )
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:       (local.get $scratch_3)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (drop
;; CHECK-BIN-NODEBUG-NEXT:      (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $4 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block
;; CHECK-BIN-NODEBUG-NEXT:   (try
;; CHECK-BIN-NODEBUG-NEXT:    (do
;; CHECK-BIN-NODEBUG-NEXT:     (br $block)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:     (drop
;; CHECK-BIN-NODEBUG-NEXT:      (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (br $block)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $5 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $6 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (call $0)
;; CHECK-BIN-NODEBUG-NEXT:    (call $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (call $0)
;; CHECK-BIN-NODEBUG-NEXT:    (call $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $7 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (throw $tag$0
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch $tag$1
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (pop i64)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $8 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (throw $tag$0
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch_all
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $9 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (throw $tag$0
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch $tag$1
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (pop i64)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch_all
;; CHECK-BIN-NODEBUG-NEXT:    (call $0)
;; CHECK-BIN-NODEBUG-NEXT:    (call $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $10 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (try
;; CHECK-BIN-NODEBUG-NEXT:     (do
;; CHECK-BIN-NODEBUG-NEXT:      (throw $tag$0
;; CHECK-BIN-NODEBUG-NEXT:       (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:      (drop
;; CHECK-BIN-NODEBUG-NEXT:       (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (catch_all
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch_all
;; CHECK-BIN-NODEBUG-NEXT:    (try
;; CHECK-BIN-NODEBUG-NEXT:     (do
;; CHECK-BIN-NODEBUG-NEXT:      (throw $tag$0
;; CHECK-BIN-NODEBUG-NEXT:       (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:      (drop
;; CHECK-BIN-NODEBUG-NEXT:       (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (catch_all
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $11 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (throw $tag$0
;; CHECK-BIN-NODEBUG-NEXT:     (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $12 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try $label
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (try
;; CHECK-BIN-NODEBUG-NEXT:     (do
;; CHECK-BIN-NODEBUG-NEXT:      (call $0)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (delegate $label)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (try
;; CHECK-BIN-NODEBUG-NEXT:     (do
;; CHECK-BIN-NODEBUG-NEXT:      (call $0)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (delegate $label)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch_all
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $13 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block
;; CHECK-BIN-NODEBUG-NEXT:   (try $label
;; CHECK-BIN-NODEBUG-NEXT:    (do
;; CHECK-BIN-NODEBUG-NEXT:     (try
;; CHECK-BIN-NODEBUG-NEXT:      (do
;; CHECK-BIN-NODEBUG-NEXT:       (br_if $block
;; CHECK-BIN-NODEBUG-NEXT:        (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:      (delegate $label)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (try
;; CHECK-BIN-NODEBUG-NEXT:      (do
;; CHECK-BIN-NODEBUG-NEXT:       (br_if $block
;; CHECK-BIN-NODEBUG-NEXT:        (i32.const 1)
;; CHECK-BIN-NODEBUG-NEXT:       )
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:      (delegate $label)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (catch_all
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $14 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try $label
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (try
;; CHECK-BIN-NODEBUG-NEXT:     (do
;; CHECK-BIN-NODEBUG-NEXT:      (call $0)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (delegate $label)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (delegate 0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $15 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch $tag$4
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $16 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try $label
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (call $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (rethrow $label)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch_all
;; CHECK-BIN-NODEBUG-NEXT:    (rethrow $label)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $17 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (block $block
;; CHECK-BIN-NODEBUG-NEXT:   (try $label
;; CHECK-BIN-NODEBUG-NEXT:    (do
;; CHECK-BIN-NODEBUG-NEXT:     (call $0)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:     (drop
;; CHECK-BIN-NODEBUG-NEXT:      (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (rethrow $label)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (catch_all
;; CHECK-BIN-NODEBUG-NEXT:     (br $block)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $18 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try $label
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (call $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch_all
;; CHECK-BIN-NODEBUG-NEXT:    (try
;; CHECK-BIN-NODEBUG-NEXT:     (do
;; CHECK-BIN-NODEBUG-NEXT:      (call $0)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:      (drop
;; CHECK-BIN-NODEBUG-NEXT:       (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:      (rethrow $label)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (catch_all
;; CHECK-BIN-NODEBUG-NEXT:      (rethrow $label)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $19 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try $label
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (call $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch_all
;; CHECK-BIN-NODEBUG-NEXT:    (try
;; CHECK-BIN-NODEBUG-NEXT:     (do
;; CHECK-BIN-NODEBUG-NEXT:      (call $0)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:      (drop
;; CHECK-BIN-NODEBUG-NEXT:       (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:      (block
;; CHECK-BIN-NODEBUG-NEXT:       (rethrow $label)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:      (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (catch_all
;; CHECK-BIN-NODEBUG-NEXT:      (rethrow $label)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $20 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try $label
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (call $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch_all
;; CHECK-BIN-NODEBUG-NEXT:    (try
;; CHECK-BIN-NODEBUG-NEXT:     (do
;; CHECK-BIN-NODEBUG-NEXT:      (rethrow $label)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (catch_all
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (try $label1
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (call $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch_all
;; CHECK-BIN-NODEBUG-NEXT:    (try
;; CHECK-BIN-NODEBUG-NEXT:     (do
;; CHECK-BIN-NODEBUG-NEXT:      (rethrow $label1)
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (catch_all
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $21 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch $tag$0
;; CHECK-BIN-NODEBUG-NEXT:    (throw $tag$0
;; CHECK-BIN-NODEBUG-NEXT:     (if (result i32)
;; CHECK-BIN-NODEBUG-NEXT:      (pop i32)
;; CHECK-BIN-NODEBUG-NEXT:      (then
;; CHECK-BIN-NODEBUG-NEXT:       (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:      (else
;; CHECK-BIN-NODEBUG-NEXT:       (i32.const 3)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $22 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (catch $tag$3
;; CHECK-BIN-NODEBUG-NEXT:    (drop
;; CHECK-BIN-NODEBUG-NEXT:     (pop eqref)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $23 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (try $label
;; CHECK-BIN-NODEBUG-NEXT:   (do
;; CHECK-BIN-NODEBUG-NEXT:    (try
;; CHECK-BIN-NODEBUG-NEXT:     (do
;; CHECK-BIN-NODEBUG-NEXT:      (throw $tag$0
;; CHECK-BIN-NODEBUG-NEXT:       (i32.const 0)
;; CHECK-BIN-NODEBUG-NEXT:      )
;; CHECK-BIN-NODEBUG-NEXT:     )
;; CHECK-BIN-NODEBUG-NEXT:     (delegate $label)
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (unreachable)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (unreachable)
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $24 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (block
;; CHECK-BIN-NODEBUG-NEXT:   (block
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:   (try
;; CHECK-BIN-NODEBUG-NEXT:    (do
;; CHECK-BIN-NODEBUG-NEXT:    )
;; CHECK-BIN-NODEBUG-NEXT:    (delegate 1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (nop)
;; CHECK-BIN-NODEBUG-NEXT: )
