/****************************************************************************
 *  (c) Copyright 2006 Wi-Fi Alliance.  All Rights Reserved
 *
 *
 *  LICENSE
 *
 * License is granted only to Wi-Fi Alliance members and designated Wi-Fi
 * contractors ("Authorized Licensees").  Authorized Licensees are hereby
 * granted the limited right to use this software solely for noncommercial
 * applications and solely for testing Wi-Fi equipment. Authorized Licensees
 * may embed this software into their proprietary equipment and distribute this
 * software with such equipment under a license with at least the same
 * restrictions as contained in this License, including, without limitation,
 * the disclaimer of warranty and limitation of liability, below.  Other than
 * expressly granted herein, this License is not transferable or sublicensable,
 * and it does not extend to and may not be used with non-Wi-Fi applications.
 *
 * Commercial derivative works of this software or applications that use the
 * Wi-Fi scripts generated by this software are NOT AUTHORIZED without specific
 * prior written permission from Wi-Fi Alliance.
 *
 * Non-Commercial derivative works of this software for internal use are
 * authorized and are limited by the same restrictions; provided, however,
 * that the Authorized Licensee shall provide Wi-Fi with a copy of such
 * derivative works under a perpetual, payment-free license to use, modify,
 * and distribute such derivative works for purposes of testing Wi-Fi equipment.
 *
 * Neither the name of the author nor "Wi-Fi Alliance" may be used to endorse
 * or promote products that are derived from or that use this software without
 * specific prior written permission from Wi-Fi Alliance.
 *
 * THIS SOFTWARE IS PROVIDED BY WI-FI ALLIANCE "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE,
 * ARE DISCLAIMED. IN NO EVENT SHALL WI-FI ALLIANCE BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, THE COST OF PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************************
 */


/*
 * File: tc_cli.c
 *       This is the main program for sending a text string based command to
 *       Control Agent (see reference document).
 *
 *    Revision History:
 *        06/30/2006 -- 00.10 Release by qhu
 *        09/01/2006 -- 01.01 Release by qhu
 *        03/30/2007 -- 01.41 WPA2 and Official WMM Beta Release by qhu
 *        04/20/2007 -- 02.00 WPA2 and Official WMM Release by qhu
 */
#ifndef WIN32
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "wfa_debug.h"
#include "wfa_main.h"
#include "wfa_types.h"
#include "wfa_tlv.h"
#include "wfa_tg.h"
#include "wfa_ca_resp.h"
#include "wfa_cmds.h"
#include "wfa_miscs.h"
#include "wfa_sock.h"

#define WFA_ENV_TC_IPADDR "WFA_ENV_TC_IPADDR"
#define WFA_ENV_TC_PORT      "WFA_ENV_TC_PORT"

unsigned short wfa_defined_debug = WFA_DEBUG_ERR;

extern int xcCmdProcGetVersion(unsigned char *parms);
int sock;
char gnetIf[32];
int gtgTransac;

int main(int argc, char *argv[])
{
	struct sockaddr_in servAddr;
	unsigned short servPort;
	char *servIP = NULL, *tstr = NULL;
	int bytesRcvd;
	char cmdName[512];
	int isFound = 0;
	int done;
	int byteSent;
	int rspCnt = 0;

	BYTE caCmdBuf[512];

	/* Fixed buffer size by ISAAC EZER in Epson */
	int MAX_MESSAGE = 512;

	int MAX_RECEIVE = 512;

#ifdef WIN32
	WORD wVersionRequested;
	WSADATA wsaData;
	int err;
	memset(caCmdBuf, 0, 512);
	wVersionRequested = MAKEWORD(1, 1);
	err = WSAStartup(wVersionRequested, &wsaData);
	if (err != 0) {
		/* Tell the user that we could not find a usable */
		/* WinSock DLL.                                  */
		return;
	}
#endif


	if ((argc != 2))
	{
		fprintf(stderr, "Usage: %s <command string>\n", argv[0]);
		exit(1);
	}

	if ((tstr = getenv("WFA_ENV_TC_IPADDR")) == NULL)
	{
		printf("Environment variable WFA_ENV_TC_IPADDR not set\n");
		exit(1);
	}

	if (isIpV4Addr(tstr) == FALSE)
		return FALSE;

	servIP = tstr;


	if ((tstr = getenv("WFA_ENV_TC_PORT")) == NULL)
		printf("Environment variable WFA_ENV_TC_PORT not set\n");

	if (isNumber(tstr) == FALSE)
		return FALSE;

	servPort = atoi(tstr);

	if ((sock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
	{
		perror("socket() failed");
		exit(1);
	}

	memset(&servAddr, 0, sizeof(servAddr));
	servAddr.sin_family      = AF_INET;
	servAddr.sin_addr.s_addr = inet_addr(servIP);
	servAddr.sin_port        = htons(servPort);

	if (connect(sock, (struct sockaddr *) &servAddr, sizeof(servAddr)) < 0)
	{
		perror("connect() failed");
		exit(1);
	}

	isFound = 0;

	memcpy(cmdName, argv[1], MAX_MESSAGE);

	/* Fixed by ISAAC - EZER */
	strcat(cmdName, " \r\n");
	byteSent = wfaCtrlSend(sock, (BYTE *)cmdName, MAX_MESSAGE);

	memset(caCmdBuf, '\0', sizeof(caCmdBuf));

	bytesRcvd = recv(sock, caCmdBuf, MAX_RECEIVE, 0);
	done = 1;
	while (done)
	{

		printf("=======Response======\n");
		printf("%s\n", caCmdBuf);

		if (strncmp("status,COMPLETE", (char *)caCmdBuf, 15) == 0 ||
			strncmp("status,INVALID", (char *)caCmdBuf, 14) == 0 ||
			strncmp("status,ERROR", (char *)caCmdBuf, 12) == 0)
			break;

		if (rspCnt == 3)
			break;

		/* ISAAC EZER - I modified this section */

		bytesRcvd = recv(sock, caCmdBuf, MAX_RECEIVE, 0);
		rspCnt++;

		if (bytesRcvd == -1)
		{
			perror("Error receiving message from Test Console.\n");
			break;
		}
	}
	asd_closeSocket(sock);

		/* Tell the user that we could not find a usable */
	/* WinSock DLL.                                  */
#ifdef WIN32
	WSACleanup();
#endif
	exit(0);
}
