// ------------------------------------------------------------------
// Copyright (c) 2004-2007 Atheros Corporation.  All rights reserved.
// 
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//
// ------------------------------------------------------------------
//===================================================================
// Author(s): ="Atheros"
//===================================================================


#ifndef _MBOX_REG_REG_H_
#define _MBOX_REG_REG_H_

#define MBOX_FIFO_ADDRESS                        0x00000000
#define MBOX_FIFO_OFFSET                         0x00000000
#define MBOX_FIFO_DATA_MSB                       19
#define MBOX_FIFO_DATA_LSB                       0
#define MBOX_FIFO_DATA_MASK                      0x000fffff
#define MBOX_FIFO_DATA_GET(x)                    (((x) & MBOX_FIFO_DATA_MASK) >> MBOX_FIFO_DATA_LSB)
#define MBOX_FIFO_DATA_SET(x)                    (((x) << MBOX_FIFO_DATA_LSB) & MBOX_FIFO_DATA_MASK)

#define MBOX_FIFO_STATUS_ADDRESS                 0x00000004
#define MBOX_FIFO_STATUS_OFFSET                  0x00000004
#define MBOX_FIFO_STATUS_EMPTY_MSB               2
#define MBOX_FIFO_STATUS_EMPTY_LSB               2
#define MBOX_FIFO_STATUS_EMPTY_MASK              0x00000004
#define MBOX_FIFO_STATUS_EMPTY_GET(x)            (((x) & MBOX_FIFO_STATUS_EMPTY_MASK) >> MBOX_FIFO_STATUS_EMPTY_LSB)
#define MBOX_FIFO_STATUS_EMPTY_SET(x)            (((x) << MBOX_FIFO_STATUS_EMPTY_LSB) & MBOX_FIFO_STATUS_EMPTY_MASK)
#define MBOX_FIFO_STATUS_FULL_MSB                0
#define MBOX_FIFO_STATUS_FULL_LSB                0
#define MBOX_FIFO_STATUS_FULL_MASK               0x00000001
#define MBOX_FIFO_STATUS_FULL_GET(x)             (((x) & MBOX_FIFO_STATUS_FULL_MASK) >> MBOX_FIFO_STATUS_FULL_LSB)
#define MBOX_FIFO_STATUS_FULL_SET(x)             (((x) << MBOX_FIFO_STATUS_FULL_LSB) & MBOX_FIFO_STATUS_FULL_MASK)

#define MBOX_DMA_POLICY_ADDRESS                  0x00000008
#define MBOX_DMA_POLICY_OFFSET                   0x00000008
#define MBOX_DMA_POLICY_TX_FIFO_THRESH0_MSB      7
#define MBOX_DMA_POLICY_TX_FIFO_THRESH0_LSB      4
#define MBOX_DMA_POLICY_TX_FIFO_THRESH0_MASK     0x000000f0
#define MBOX_DMA_POLICY_TX_FIFO_THRESH0_GET(x)   (((x) & MBOX_DMA_POLICY_TX_FIFO_THRESH0_MASK) >> MBOX_DMA_POLICY_TX_FIFO_THRESH0_LSB)
#define MBOX_DMA_POLICY_TX_FIFO_THRESH0_SET(x)   (((x) << MBOX_DMA_POLICY_TX_FIFO_THRESH0_LSB) & MBOX_DMA_POLICY_TX_FIFO_THRESH0_MASK)
#define MBOX_DMA_POLICY_TX_QUANTUM_MSB           3
#define MBOX_DMA_POLICY_TX_QUANTUM_LSB           3
#define MBOX_DMA_POLICY_TX_QUANTUM_MASK          0x00000008
#define MBOX_DMA_POLICY_TX_QUANTUM_GET(x)        (((x) & MBOX_DMA_POLICY_TX_QUANTUM_MASK) >> MBOX_DMA_POLICY_TX_QUANTUM_LSB)
#define MBOX_DMA_POLICY_TX_QUANTUM_SET(x)        (((x) << MBOX_DMA_POLICY_TX_QUANTUM_LSB) & MBOX_DMA_POLICY_TX_QUANTUM_MASK)
#define MBOX_DMA_POLICY_TX_ORDER_MSB             2
#define MBOX_DMA_POLICY_TX_ORDER_LSB             2
#define MBOX_DMA_POLICY_TX_ORDER_MASK            0x00000004
#define MBOX_DMA_POLICY_TX_ORDER_GET(x)          (((x) & MBOX_DMA_POLICY_TX_ORDER_MASK) >> MBOX_DMA_POLICY_TX_ORDER_LSB)
#define MBOX_DMA_POLICY_TX_ORDER_SET(x)          (((x) << MBOX_DMA_POLICY_TX_ORDER_LSB) & MBOX_DMA_POLICY_TX_ORDER_MASK)
#define MBOX_DMA_POLICY_RX_QUANTUM_MSB           1
#define MBOX_DMA_POLICY_RX_QUANTUM_LSB           1
#define MBOX_DMA_POLICY_RX_QUANTUM_MASK          0x00000002
#define MBOX_DMA_POLICY_RX_QUANTUM_GET(x)        (((x) & MBOX_DMA_POLICY_RX_QUANTUM_MASK) >> MBOX_DMA_POLICY_RX_QUANTUM_LSB)
#define MBOX_DMA_POLICY_RX_QUANTUM_SET(x)        (((x) << MBOX_DMA_POLICY_RX_QUANTUM_LSB) & MBOX_DMA_POLICY_RX_QUANTUM_MASK)
#define MBOX_DMA_POLICY_RX_ORDER_MSB             0
#define MBOX_DMA_POLICY_RX_ORDER_LSB             0
#define MBOX_DMA_POLICY_RX_ORDER_MASK            0x00000001
#define MBOX_DMA_POLICY_RX_ORDER_GET(x)          (((x) & MBOX_DMA_POLICY_RX_ORDER_MASK) >> MBOX_DMA_POLICY_RX_ORDER_LSB)
#define MBOX_DMA_POLICY_RX_ORDER_SET(x)          (((x) << MBOX_DMA_POLICY_RX_ORDER_LSB) & MBOX_DMA_POLICY_RX_ORDER_MASK)

#define MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS     0x0000000c
#define MBOX0_DMA_RX_DESCRIPTOR_BASE_OFFSET      0x0000000c
#define MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MSB 27
#define MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB 2
#define MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK 0x0ffffffc
#define MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_GET(x) (((x) & MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK) >> MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB)
#define MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_SET(x) (((x) << MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB) & MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK)

#define MBOX0_DMA_RX_CONTROL_ADDRESS             0x00000010
#define MBOX0_DMA_RX_CONTROL_OFFSET              0x00000010
#define MBOX0_DMA_RX_CONTROL_RESUME_MSB          2
#define MBOX0_DMA_RX_CONTROL_RESUME_LSB          2
#define MBOX0_DMA_RX_CONTROL_RESUME_MASK         0x00000004
#define MBOX0_DMA_RX_CONTROL_RESUME_GET(x)       (((x) & MBOX0_DMA_RX_CONTROL_RESUME_MASK) >> MBOX0_DMA_RX_CONTROL_RESUME_LSB)
#define MBOX0_DMA_RX_CONTROL_RESUME_SET(x)       (((x) << MBOX0_DMA_RX_CONTROL_RESUME_LSB) & MBOX0_DMA_RX_CONTROL_RESUME_MASK)
#define MBOX0_DMA_RX_CONTROL_START_MSB           1
#define MBOX0_DMA_RX_CONTROL_START_LSB           1
#define MBOX0_DMA_RX_CONTROL_START_MASK          0x00000002
#define MBOX0_DMA_RX_CONTROL_START_GET(x)        (((x) & MBOX0_DMA_RX_CONTROL_START_MASK) >> MBOX0_DMA_RX_CONTROL_START_LSB)
#define MBOX0_DMA_RX_CONTROL_START_SET(x)        (((x) << MBOX0_DMA_RX_CONTROL_START_LSB) & MBOX0_DMA_RX_CONTROL_START_MASK)
#define MBOX0_DMA_RX_CONTROL_STOP_MSB            0
#define MBOX0_DMA_RX_CONTROL_STOP_LSB            0
#define MBOX0_DMA_RX_CONTROL_STOP_MASK           0x00000001
#define MBOX0_DMA_RX_CONTROL_STOP_GET(x)         (((x) & MBOX0_DMA_RX_CONTROL_STOP_MASK) >> MBOX0_DMA_RX_CONTROL_STOP_LSB)
#define MBOX0_DMA_RX_CONTROL_STOP_SET(x)         (((x) << MBOX0_DMA_RX_CONTROL_STOP_LSB) & MBOX0_DMA_RX_CONTROL_STOP_MASK)

#define MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS     0x00000014
#define MBOX0_DMA_TX_DESCRIPTOR_BASE_OFFSET      0x00000014
#define MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MSB 27
#define MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB 2
#define MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK 0x0ffffffc
#define MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_GET(x) (((x) & MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK) >> MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB)
#define MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_SET(x) (((x) << MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB) & MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK)

#define MBOX0_DMA_TX_CONTROL_ADDRESS             0x00000018
#define MBOX0_DMA_TX_CONTROL_OFFSET              0x00000018
#define MBOX0_DMA_TX_CONTROL_RESUME_MSB          2
#define MBOX0_DMA_TX_CONTROL_RESUME_LSB          2
#define MBOX0_DMA_TX_CONTROL_RESUME_MASK         0x00000004
#define MBOX0_DMA_TX_CONTROL_RESUME_GET(x)       (((x) & MBOX0_DMA_TX_CONTROL_RESUME_MASK) >> MBOX0_DMA_TX_CONTROL_RESUME_LSB)
#define MBOX0_DMA_TX_CONTROL_RESUME_SET(x)       (((x) << MBOX0_DMA_TX_CONTROL_RESUME_LSB) & MBOX0_DMA_TX_CONTROL_RESUME_MASK)
#define MBOX0_DMA_TX_CONTROL_START_MSB           1
#define MBOX0_DMA_TX_CONTROL_START_LSB           1
#define MBOX0_DMA_TX_CONTROL_START_MASK          0x00000002
#define MBOX0_DMA_TX_CONTROL_START_GET(x)        (((x) & MBOX0_DMA_TX_CONTROL_START_MASK) >> MBOX0_DMA_TX_CONTROL_START_LSB)
#define MBOX0_DMA_TX_CONTROL_START_SET(x)        (((x) << MBOX0_DMA_TX_CONTROL_START_LSB) & MBOX0_DMA_TX_CONTROL_START_MASK)
#define MBOX0_DMA_TX_CONTROL_STOP_MSB            0
#define MBOX0_DMA_TX_CONTROL_STOP_LSB            0
#define MBOX0_DMA_TX_CONTROL_STOP_MASK           0x00000001
#define MBOX0_DMA_TX_CONTROL_STOP_GET(x)         (((x) & MBOX0_DMA_TX_CONTROL_STOP_MASK) >> MBOX0_DMA_TX_CONTROL_STOP_LSB)
#define MBOX0_DMA_TX_CONTROL_STOP_SET(x)         (((x) << MBOX0_DMA_TX_CONTROL_STOP_LSB) & MBOX0_DMA_TX_CONTROL_STOP_MASK)

#define MBOX_FRAME_ADDRESS                       0x0000001c
#define MBOX_FRAME_OFFSET                        0x0000001c
#define MBOX_FRAME_RX_EOM_MSB                    2
#define MBOX_FRAME_RX_EOM_LSB                    2
#define MBOX_FRAME_RX_EOM_MASK                   0x00000004
#define MBOX_FRAME_RX_EOM_GET(x)                 (((x) & MBOX_FRAME_RX_EOM_MASK) >> MBOX_FRAME_RX_EOM_LSB)
#define MBOX_FRAME_RX_EOM_SET(x)                 (((x) << MBOX_FRAME_RX_EOM_LSB) & MBOX_FRAME_RX_EOM_MASK)
#define MBOX_FRAME_RX_SOM_MSB                    0
#define MBOX_FRAME_RX_SOM_LSB                    0
#define MBOX_FRAME_RX_SOM_MASK                   0x00000001
#define MBOX_FRAME_RX_SOM_GET(x)                 (((x) & MBOX_FRAME_RX_SOM_MASK) >> MBOX_FRAME_RX_SOM_LSB)
#define MBOX_FRAME_RX_SOM_SET(x)                 (((x) << MBOX_FRAME_RX_SOM_LSB) & MBOX_FRAME_RX_SOM_MASK)

#define FIFO_TIMEOUT_ADDRESS                     0x00000020
#define FIFO_TIMEOUT_OFFSET                      0x00000020
#define FIFO_TIMEOUT_ENABLE_MSB                  8
#define FIFO_TIMEOUT_ENABLE_LSB                  8
#define FIFO_TIMEOUT_ENABLE_MASK                 0x00000100
#define FIFO_TIMEOUT_ENABLE_GET(x)               (((x) & FIFO_TIMEOUT_ENABLE_MASK) >> FIFO_TIMEOUT_ENABLE_LSB)
#define FIFO_TIMEOUT_ENABLE_SET(x)               (((x) << FIFO_TIMEOUT_ENABLE_LSB) & FIFO_TIMEOUT_ENABLE_MASK)
#define FIFO_TIMEOUT_VALUE_MSB                   7
#define FIFO_TIMEOUT_VALUE_LSB                   0
#define FIFO_TIMEOUT_VALUE_MASK                  0x000000ff
#define FIFO_TIMEOUT_VALUE_GET(x)                (((x) & FIFO_TIMEOUT_VALUE_MASK) >> FIFO_TIMEOUT_VALUE_LSB)
#define FIFO_TIMEOUT_VALUE_SET(x)                (((x) << FIFO_TIMEOUT_VALUE_LSB) & FIFO_TIMEOUT_VALUE_MASK)

#define MBOX_INT_STATUS_ADDRESS                  0x00000024
#define MBOX_INT_STATUS_OFFSET                   0x00000024
#define MBOX_INT_STATUS_RX_DMA_COMPLETE_MSB      10
#define MBOX_INT_STATUS_RX_DMA_COMPLETE_LSB      10
#define MBOX_INT_STATUS_RX_DMA_COMPLETE_MASK     0x00000400
#define MBOX_INT_STATUS_RX_DMA_COMPLETE_GET(x)   (((x) & MBOX_INT_STATUS_RX_DMA_COMPLETE_MASK) >> MBOX_INT_STATUS_RX_DMA_COMPLETE_LSB)
#define MBOX_INT_STATUS_RX_DMA_COMPLETE_SET(x)   (((x) << MBOX_INT_STATUS_RX_DMA_COMPLETE_LSB) & MBOX_INT_STATUS_RX_DMA_COMPLETE_MASK)
#define MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_MSB  8
#define MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_LSB  8
#define MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_MASK 0x00000100
#define MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_GET(x) (((x) & MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_MASK) >> MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_LSB)
#define MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_SET(x) (((x) << MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_LSB) & MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_MASK)
#define MBOX_INT_STATUS_TX_DMA_COMPLETE_MSB      6
#define MBOX_INT_STATUS_TX_DMA_COMPLETE_LSB      6
#define MBOX_INT_STATUS_TX_DMA_COMPLETE_MASK     0x00000040
#define MBOX_INT_STATUS_TX_DMA_COMPLETE_GET(x)   (((x) & MBOX_INT_STATUS_TX_DMA_COMPLETE_MASK) >> MBOX_INT_STATUS_TX_DMA_COMPLETE_LSB)
#define MBOX_INT_STATUS_TX_DMA_COMPLETE_SET(x)   (((x) << MBOX_INT_STATUS_TX_DMA_COMPLETE_LSB) & MBOX_INT_STATUS_TX_DMA_COMPLETE_MASK)
#define MBOX_INT_STATUS_TX_OVERFLOW_MSB          5
#define MBOX_INT_STATUS_TX_OVERFLOW_LSB          5
#define MBOX_INT_STATUS_TX_OVERFLOW_MASK         0x00000020
#define MBOX_INT_STATUS_TX_OVERFLOW_GET(x)       (((x) & MBOX_INT_STATUS_TX_OVERFLOW_MASK) >> MBOX_INT_STATUS_TX_OVERFLOW_LSB)
#define MBOX_INT_STATUS_TX_OVERFLOW_SET(x)       (((x) << MBOX_INT_STATUS_TX_OVERFLOW_LSB) & MBOX_INT_STATUS_TX_OVERFLOW_MASK)
#define MBOX_INT_STATUS_RX_UNDERFLOW_MSB         4
#define MBOX_INT_STATUS_RX_UNDERFLOW_LSB         4
#define MBOX_INT_STATUS_RX_UNDERFLOW_MASK        0x00000010
#define MBOX_INT_STATUS_RX_UNDERFLOW_GET(x)      (((x) & MBOX_INT_STATUS_RX_UNDERFLOW_MASK) >> MBOX_INT_STATUS_RX_UNDERFLOW_LSB)
#define MBOX_INT_STATUS_RX_UNDERFLOW_SET(x)      (((x) << MBOX_INT_STATUS_RX_UNDERFLOW_LSB) & MBOX_INT_STATUS_RX_UNDERFLOW_MASK)
#define MBOX_INT_STATUS_TX_NOT_EMPTY_MSB         2
#define MBOX_INT_STATUS_TX_NOT_EMPTY_LSB         2
#define MBOX_INT_STATUS_TX_NOT_EMPTY_MASK        0x00000004
#define MBOX_INT_STATUS_TX_NOT_EMPTY_GET(x)      (((x) & MBOX_INT_STATUS_TX_NOT_EMPTY_MASK) >> MBOX_INT_STATUS_TX_NOT_EMPTY_LSB)
#define MBOX_INT_STATUS_TX_NOT_EMPTY_SET(x)      (((x) << MBOX_INT_STATUS_TX_NOT_EMPTY_LSB) & MBOX_INT_STATUS_TX_NOT_EMPTY_MASK)
#define MBOX_INT_STATUS_RX_NOT_FULL_MSB          0
#define MBOX_INT_STATUS_RX_NOT_FULL_LSB          0
#define MBOX_INT_STATUS_RX_NOT_FULL_MASK         0x00000001
#define MBOX_INT_STATUS_RX_NOT_FULL_GET(x)       (((x) & MBOX_INT_STATUS_RX_NOT_FULL_MASK) >> MBOX_INT_STATUS_RX_NOT_FULL_LSB)
#define MBOX_INT_STATUS_RX_NOT_FULL_SET(x)       (((x) << MBOX_INT_STATUS_RX_NOT_FULL_LSB) & MBOX_INT_STATUS_RX_NOT_FULL_MASK)

#define MBOX_INT_ENABLE_ADDRESS                  0x00000028
#define MBOX_INT_ENABLE_OFFSET                   0x00000028
#define MBOX_INT_ENABLE_RX_DMA_COMPLETE_MSB      10
#define MBOX_INT_ENABLE_RX_DMA_COMPLETE_LSB      10
#define MBOX_INT_ENABLE_RX_DMA_COMPLETE_MASK     0x00000400
#define MBOX_INT_ENABLE_RX_DMA_COMPLETE_GET(x)   (((x) & MBOX_INT_ENABLE_RX_DMA_COMPLETE_MASK) >> MBOX_INT_ENABLE_RX_DMA_COMPLETE_LSB)
#define MBOX_INT_ENABLE_RX_DMA_COMPLETE_SET(x)   (((x) << MBOX_INT_ENABLE_RX_DMA_COMPLETE_LSB) & MBOX_INT_ENABLE_RX_DMA_COMPLETE_MASK)
#define MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_MSB  8
#define MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_LSB  8
#define MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_MASK 0x00000100
#define MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_GET(x) (((x) & MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_MASK) >> MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_LSB)
#define MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_SET(x) (((x) << MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_LSB) & MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_MASK)
#define MBOX_INT_ENABLE_TX_DMA_COMPLETE_MSB      6
#define MBOX_INT_ENABLE_TX_DMA_COMPLETE_LSB      6
#define MBOX_INT_ENABLE_TX_DMA_COMPLETE_MASK     0x00000040
#define MBOX_INT_ENABLE_TX_DMA_COMPLETE_GET(x)   (((x) & MBOX_INT_ENABLE_TX_DMA_COMPLETE_MASK) >> MBOX_INT_ENABLE_TX_DMA_COMPLETE_LSB)
#define MBOX_INT_ENABLE_TX_DMA_COMPLETE_SET(x)   (((x) << MBOX_INT_ENABLE_TX_DMA_COMPLETE_LSB) & MBOX_INT_ENABLE_TX_DMA_COMPLETE_MASK)
#define MBOX_INT_ENABLE_TX_OVERFLOW_MSB          5
#define MBOX_INT_ENABLE_TX_OVERFLOW_LSB          5
#define MBOX_INT_ENABLE_TX_OVERFLOW_MASK         0x00000020
#define MBOX_INT_ENABLE_TX_OVERFLOW_GET(x)       (((x) & MBOX_INT_ENABLE_TX_OVERFLOW_MASK) >> MBOX_INT_ENABLE_TX_OVERFLOW_LSB)
#define MBOX_INT_ENABLE_TX_OVERFLOW_SET(x)       (((x) << MBOX_INT_ENABLE_TX_OVERFLOW_LSB) & MBOX_INT_ENABLE_TX_OVERFLOW_MASK)
#define MBOX_INT_ENABLE_RX_UNDERFLOW_MSB         4
#define MBOX_INT_ENABLE_RX_UNDERFLOW_LSB         4
#define MBOX_INT_ENABLE_RX_UNDERFLOW_MASK        0x00000010
#define MBOX_INT_ENABLE_RX_UNDERFLOW_GET(x)      (((x) & MBOX_INT_ENABLE_RX_UNDERFLOW_MASK) >> MBOX_INT_ENABLE_RX_UNDERFLOW_LSB)
#define MBOX_INT_ENABLE_RX_UNDERFLOW_SET(x)      (((x) << MBOX_INT_ENABLE_RX_UNDERFLOW_LSB) & MBOX_INT_ENABLE_RX_UNDERFLOW_MASK)
#define MBOX_INT_ENABLE_TX_NOT_EMPTY_MSB         2
#define MBOX_INT_ENABLE_TX_NOT_EMPTY_LSB         2
#define MBOX_INT_ENABLE_TX_NOT_EMPTY_MASK        0x00000004
#define MBOX_INT_ENABLE_TX_NOT_EMPTY_GET(x)      (((x) & MBOX_INT_ENABLE_TX_NOT_EMPTY_MASK) >> MBOX_INT_ENABLE_TX_NOT_EMPTY_LSB)
#define MBOX_INT_ENABLE_TX_NOT_EMPTY_SET(x)      (((x) << MBOX_INT_ENABLE_TX_NOT_EMPTY_LSB) & MBOX_INT_ENABLE_TX_NOT_EMPTY_MASK)
#define MBOX_INT_ENABLE_RX_NOT_FULL_MSB          0
#define MBOX_INT_ENABLE_RX_NOT_FULL_LSB          0
#define MBOX_INT_ENABLE_RX_NOT_FULL_MASK         0x00000001
#define MBOX_INT_ENABLE_RX_NOT_FULL_GET(x)       (((x) & MBOX_INT_ENABLE_RX_NOT_FULL_MASK) >> MBOX_INT_ENABLE_RX_NOT_FULL_LSB)
#define MBOX_INT_ENABLE_RX_NOT_FULL_SET(x)       (((x) << MBOX_INT_ENABLE_RX_NOT_FULL_LSB) & MBOX_INT_ENABLE_RX_NOT_FULL_MASK)

#define MBOX_FIFO_RESET_ADDRESS                  0x0000002c
#define MBOX_FIFO_RESET_OFFSET                   0x0000002c
#define MBOX_FIFO_RESET_RX_INIT_MSB              2
#define MBOX_FIFO_RESET_RX_INIT_LSB              2
#define MBOX_FIFO_RESET_RX_INIT_MASK             0x00000004
#define MBOX_FIFO_RESET_RX_INIT_GET(x)           (((x) & MBOX_FIFO_RESET_RX_INIT_MASK) >> MBOX_FIFO_RESET_RX_INIT_LSB)
#define MBOX_FIFO_RESET_RX_INIT_SET(x)           (((x) << MBOX_FIFO_RESET_RX_INIT_LSB) & MBOX_FIFO_RESET_RX_INIT_MASK)
#define MBOX_FIFO_RESET_TX_INIT_MSB              0
#define MBOX_FIFO_RESET_TX_INIT_LSB              0
#define MBOX_FIFO_RESET_TX_INIT_MASK             0x00000001
#define MBOX_FIFO_RESET_TX_INIT_GET(x)           (((x) & MBOX_FIFO_RESET_TX_INIT_MASK) >> MBOX_FIFO_RESET_TX_INIT_LSB)
#define MBOX_FIFO_RESET_TX_INIT_SET(x)           (((x) << MBOX_FIFO_RESET_TX_INIT_LSB) & MBOX_FIFO_RESET_TX_INIT_MASK)

#define MBOX_DEBUG_CHAIN0_ADDRESS                0x00000030
#define MBOX_DEBUG_CHAIN0_OFFSET                 0x00000030
#define MBOX_DEBUG_CHAIN0_ADDRESS_MSB            31
#define MBOX_DEBUG_CHAIN0_ADDRESS_LSB            0
#define MBOX_DEBUG_CHAIN0_ADDRESS_MASK           0xffffffff
#define MBOX_DEBUG_CHAIN0_ADDRESS_GET(x)         (((x) & MBOX_DEBUG_CHAIN0_ADDRESS_MASK) >> MBOX_DEBUG_CHAIN0_ADDRESS_LSB)
#define MBOX_DEBUG_CHAIN0_ADDRESS_SET(x)         (((x) << MBOX_DEBUG_CHAIN0_ADDRESS_LSB) & MBOX_DEBUG_CHAIN0_ADDRESS_MASK)

#define MBOX_DEBUG_CHAIN1_ADDRESS                0x00000034
#define MBOX_DEBUG_CHAIN1_OFFSET                 0x00000034
#define MBOX_DEBUG_CHAIN1_ADDRESS_MSB            31
#define MBOX_DEBUG_CHAIN1_ADDRESS_LSB            0
#define MBOX_DEBUG_CHAIN1_ADDRESS_MASK           0xffffffff
#define MBOX_DEBUG_CHAIN1_ADDRESS_GET(x)         (((x) & MBOX_DEBUG_CHAIN1_ADDRESS_MASK) >> MBOX_DEBUG_CHAIN1_ADDRESS_LSB)
#define MBOX_DEBUG_CHAIN1_ADDRESS_SET(x)         (((x) << MBOX_DEBUG_CHAIN1_ADDRESS_LSB) & MBOX_DEBUG_CHAIN1_ADDRESS_MASK)

#define MBOX_DEBUG_CHAIN0_SIGNALS_ADDRESS        0x00000038
#define MBOX_DEBUG_CHAIN0_SIGNALS_OFFSET         0x00000038
#define MBOX_DEBUG_CHAIN0_SIGNALS_COLLECTION_MSB 31
#define MBOX_DEBUG_CHAIN0_SIGNALS_COLLECTION_LSB 0
#define MBOX_DEBUG_CHAIN0_SIGNALS_COLLECTION_MASK 0xffffffff
#define MBOX_DEBUG_CHAIN0_SIGNALS_COLLECTION_GET(x) (((x) & MBOX_DEBUG_CHAIN0_SIGNALS_COLLECTION_MASK) >> MBOX_DEBUG_CHAIN0_SIGNALS_COLLECTION_LSB)
#define MBOX_DEBUG_CHAIN0_SIGNALS_COLLECTION_SET(x) (((x) << MBOX_DEBUG_CHAIN0_SIGNALS_COLLECTION_LSB) & MBOX_DEBUG_CHAIN0_SIGNALS_COLLECTION_MASK)

#define MBOX_DEBUG_CHAIN1_SIGNALS_ADDRESS        0x0000003c
#define MBOX_DEBUG_CHAIN1_SIGNALS_OFFSET         0x0000003c
#define MBOX_DEBUG_CHAIN1_SIGNALS_COLLECTION_MSB 31
#define MBOX_DEBUG_CHAIN1_SIGNALS_COLLECTION_LSB 0
#define MBOX_DEBUG_CHAIN1_SIGNALS_COLLECTION_MASK 0xffffffff
#define MBOX_DEBUG_CHAIN1_SIGNALS_COLLECTION_GET(x) (((x) & MBOX_DEBUG_CHAIN1_SIGNALS_COLLECTION_MASK) >> MBOX_DEBUG_CHAIN1_SIGNALS_COLLECTION_LSB)
#define MBOX_DEBUG_CHAIN1_SIGNALS_COLLECTION_SET(x) (((x) << MBOX_DEBUG_CHAIN1_SIGNALS_COLLECTION_LSB) & MBOX_DEBUG_CHAIN1_SIGNALS_COLLECTION_MASK)


#ifndef __ASSEMBLER__

typedef struct mbox_reg_reg_s {
  volatile unsigned int mbox_fifo[1];
  volatile unsigned int mbox_fifo_status;
  volatile unsigned int mbox_dma_policy;
  volatile unsigned int mbox0_dma_rx_descriptor_base;
  volatile unsigned int mbox0_dma_rx_control;
  volatile unsigned int mbox0_dma_tx_descriptor_base;
  volatile unsigned int mbox0_dma_tx_control;
  volatile unsigned int mbox_frame;
  volatile unsigned int fifo_timeout;
  volatile unsigned int mbox_int_status;
  volatile unsigned int mbox_int_enable;
  volatile unsigned int mbox_fifo_reset;
  volatile unsigned int mbox_debug_chain0;
  volatile unsigned int mbox_debug_chain1;
  volatile unsigned int mbox_debug_chain0_signals;
  volatile unsigned int mbox_debug_chain1_signals;
} mbox_reg_reg_t;

#endif /* __ASSEMBLER__ */

#endif /* _MBOX_REG_H_ */
