VARYING vec2 vTexCoord;

vec2 rotate(vec2 v, float a) {

	float s = sin(a);

	float c = cos(a);

	mat2 m = mat2(c, -s, s, c);

	return m * v;

}

VARYING vec3 worldPos;
VARYING vec3 localPos;

const float PI = 3.14159265359;

void MAIN()
{
	vTexCoord = UV0;
	vec2 animCenter = (vTexCoord * 2.0 - 1.0);
	localPos = VERTEX;
	worldPos = (MODEL_MATRIX * vec4(VERTEX, 1.0)).xyz;
	worldPos.xz += sin(time)*smoothstep(0.0,1000.0,worldPos.y)*5;
	worldPos.xz += sin(time*3)*smoothstep(0.0,1000.0,worldPos.y)*5;
	worldPos.xz += sin(time*7)*smoothstep(0.0,1000.0,worldPos.y)*5;
	worldPos.xy += sin(time*7.0)*animCenter*1.0;
	worldPos.yz += sin(PI+time*11.0)*animCenter*1.0;
	worldPos.zx += sin(PI*3.0+time*13.0)*animCenter*1.0;
	//vertPos.z += sin(worldPos.y)*10.0;
	
	
	POSITION  =  VIEWPROJECTION_MATRIX * vec4(worldPos, 1.0);
}