/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick
import QtQuick.Controls
import QtQuick3D
import Outrun_Cluster 1.0
import QtQuick.Timeline 1.0
import QtQuick 2.15
import QtQuick.Studio.Effects 1.0
import QtQuick3D.Effects 6.2
import Generated.QtQuick3D.Hyperdrive 1.0
import Generated.QtQuick3D.Warp 1.0
import Generated.QtQuick3D.Lanes 1.0
import QtQuick3D.Particles3D 6.2
import Generated.QtQuick3D.Gaugelines 1.0
import Generated.QtQuick3D.AdasPlane 1.0
import Generated.QtQuick3D.Car_Optimized_2 1.0
import Generated.QtQuick3D.Desert_Enviroment 1.0
import Generated.QtQuick3D.Car 1.0

Rectangle {
    id: welcome
    width: 1936
    height: 753
    opacity: 1
    color: "#000000"

    Image {
        id: mask1
        x: 0
        y: 0
        opacity: 1
        source: "../images/Mask1.png"
        fillMode: Image.PreserveAspectFit
    }

    Text {
        id: text1
        x: 339
        y: 236
        width: 1297
        height: 158
        opacity: 1
        color: "#ffffff"
        text: qsTr("Welcome back, Anthony")
        font.pixelSize: 80
        horizontalAlignment: Text.AlignHCenter
        font.styleName: "Bold"
        font.family: "Exo 2"
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                running: true
                loops: 1
                duration: 8000
                to: 8000
                from: 0
            }
        ]
        enabled: true
        startFrame: 0
        endFrame: 8000

        KeyframeGroup {
            target: text1
            property: "opacity"

            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 1430
                value: 0
            }

            Keyframe {
                frame: 2368
                value: 1
            }

            Keyframe {
                frame: 7441
                value: 0
            }

            Keyframe {
                frame: 5305
                value: 0.42105
            }
        }

        KeyframeGroup {
            target: welcome
            property: "opacity"

            Keyframe {
                frame: 5581
                value: 1
            }

            Keyframe {
                frame: 7994
                value: 0
            }

            Keyframe {
                frame: 0
                value: 1
            }
        }

        KeyframeGroup {
            target: mask1
            property: "opacity"

            Keyframe {
                frame: 4983
                value: 1
            }

            Keyframe {
                frame: 7041
                value: 0
            }

            Keyframe {
                frame: 0
                value: 1
            }
        }
    }
}

/*##^##
Designer {
    D{i:0;formeditorZoom:0.5;height:753;width:1936}D{i:1}D{i:2}D{i:3}
}
##^##*/

