/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick
import QtQuick.Controls
import QtQuick3D
import Outrun_Cluster 1.0
import QtQuick.Timeline 1.0
import QtQuick 2.15
import QtQuick.Studio.Effects 1.0
import QtQuick3D.Effects 6.2
import Generated.QtQuick3D.Hyperdrive 1.0
import Generated.QtQuick3D.Warp 1.0
import Generated.QtQuick3D.Lanes 1.0
import QtQuick3D.Particles3D 6.2
import Generated.QtQuick3D.Gaugelines 1.0

PointLight {
    property real anim: 1
    id: gaugelight
    color: "#e5e0fc"
    linearFade: 0
    castsShadow: false
    constantFade: 0
    quadraticFade: 0
    z: -302.35846
    brightness: 2

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                loops: 1
                duration: 500
                running: true
                to: 500
                from: 0
            }
        ]
        enabled: true
        endFrame: 500
        startFrame: 0
        currentFrame: anim

        KeyframeGroup {
            target: gaugelight
            property: "z"

            Keyframe {
                frame: 0
                value: -302.35815
            }

            Keyframe {
                frame: 500
                value: -7400
            }
        }
    }
}
