import QtQuick
import QtQuick3D
import QtQuick.Timeline 1.0
Node {
    id: rootNode
    Model {
        id: warp
        scale.x: 100
        scale.y: 100
        scale.z: 100
        source: "meshes/warp.mesh"
        eulerRotation.z: 90
        eulerRotation.y: -89.99997
        eulerRotation.x: 422.94837

        DefaultMaterial {
            id: defaultMaterial_material
            diffuseMap: texture1
            lighting: DefaultMaterial.NoLighting
            diffuseColor: "#ffcccccc"

            Texture {
                id: texture1
                source: "../../../images/warp.png"
                positionU: 10
                positionV: 0
            }
        }
        materials: [
            defaultMaterial_material
        ]
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                duration: 20000
                running: true
                loops: -1
                to: 20000
                from: 0
            }
        ]
        endFrame: 20000
        enabled: true
        startFrame: 0

        KeyframeGroup {
            target: texture1
            property: "positionV"

            Keyframe {
                frame: 0
                value: 0
            }
        }

        KeyframeGroup {
            target: texture1
            property: "positionU"

            Keyframe {
                frame: 0
                value: 0
            }

            Keyframe {
                frame: 20000
                value: 10
            }
        }

        KeyframeGroup {
            target: warp
            property: "eulerRotation.x"

            Keyframe {
                frame: 0
                value: -38.05163
            }

            Keyframe {
                frame: 20000
                value: 422.94836
            }
        }

        KeyframeGroup {
            target: warp
            property: "eulerRotation.y"

            Keyframe {
                frame: 0
                value: -89.99997
            }

            Keyframe {
                frame: 20000
                value: -89.99997
            }
        }

        KeyframeGroup {
            target: warp
            property: "eulerRotation.z"

            Keyframe {
                frame: 0
                value: 90
            }

            Keyframe {
                frame: 20000
                value: 90
            }
        }
    }
}
