pragma Singleton
import QtQuick 2.12
//import QtWebSockets

QtObject {
    id: values

    signal vehicleModelStateChanged(string state);

    /*!
        Park gear
    */
    readonly property string park: "P"

    /*!
        Reverse gear
    */
    readonly property string reverse: "R"

    /*!
        Neutral gear
    */
    readonly property string neutral: "N"

    /*!
        Primary drive gear
    */
    readonly property string drive: "D"

    /*!
        Manual drive gear
    */
    readonly property string manual: "M"

    /*!
        The speed of the vehicle in kilometers per hour.
    */
    property real speed: 70

    /*!
        The battery level as a percentage.
    */
    property real batteryLevel: .85

    /*!
        The gear of the transmission as a string.
    */
    property string prndlGear: drive

    /*!
        The numerical gear of the transmission when in a forward driving mode e.g. D, M, or L.
        When the vehicle is not in a forward driving mode, this will always return 0.
    */
    property int driveGear: 1

    /*!
        The state of the left turn signal as a boolean.
    */
    property bool leftTurnSignalOn: false

    /*!
        The state of the right turn signal as a boolean.
    */
    property bool rightTurnSignalOn: false

    /*!
        The numer of kilometers on the vehicle odometer.
    */
    property real odometer: 0

    /*!
        The diagnostic trouble code of the vehicle.  E.g. check engine light, low oil pressure.
    */
    property real dtc: 0

    /*property WebSocketServer wss: WebSocketServer
    {
        id: wsServer

        onClientConnected: {
            webSocket.onTextMessageReceived.connect(function(message) {
                console.log(qsTr("Server received message: %1").arg(message));

                if(message === "speedIncrease")
                {
                    speed++
                }
                else if(message === "speedDecrease")
                {
                    if(speed > 0)
                    {
                        speed--
                    }
                    else
                    {
                        console.log("speed is at min")
                    }
                }
                else if(message === "gearShift")
                {
                    shiftGear()
                }
                if(message === "batteryIncrease")
                {
                    if(batteryLevel < 1.0)
                    {
                        batteryLevel = batteryLevel + .01
                    }
                    else
                    {
                        console.log("battery at max")
                    }
                }
                else if(message === "batteryDecrease")
                {
                    if(batteryLevel > 0)
                    {
                        batteryLevel = batteryLevel - .01
                    }
                    else
                    {
                        console.log("battery at min")
                    }
                }
                else
                {
                    vehicleModelStateChanged(message)
                }
            });
        }
        onErrorStringChanged: {
            console.log(qsTr("Server error: %1").arg(errorString));
        }
    }*/

    function openPort()
    {
        //wss.port = "1234"
        //wss.listen = true
    }

    function shiftGear()
    {
        switch(prndlGear)
        {
        case park:
            prndlGear = reverse;
            break;
        case reverse:
            prndlGear = neutral;
            break;
        case neutral:
            prndlGear = drive;
            break;
        case drive:
            prndlGear = park;
            break;
        }
    }
}




/*##^##
Designer {
    D{i:0;autoSize:true;height:480;width:640}
}
##^##*/
