import QtQuick
import QtQuick3D

Node {
    eulerRotation.y: -90
    // Materials
    Texture {
        id: albedo
        source: "maps/Generic_SUV_2019_albedo.png"
    }
    Texture {
        id: normal
        source: "maps/Generic_SUV_2019_normal.png"
    }
    Texture {
        id: specular
        source: "maps/Generic_SUV_2019_specular.png"
    }
    DefaultMaterial {
        id: bodypaint_material
        specularRoughness: 0.5
        specularAmount: 1.0
        bumpAmount: 1.0
        diffuseMap: albedo
        normalMap: normal
        specularMap: specular
    }
    // end of Materials

    Model {
        id: generic_SUV_2019_game_low
        scale: Qt.vector3d(0.08, 0.08, 0.08)
        source: "meshes/generic_SUV_2019_game_low.mesh"
        materials: [
            bodypaint_material
        ]
    }
}
