import QtQuick 2.8
import QtQuick.Studio.Components 1.0
import QtQuick.Timeline 1.0

Rectangle {
    id: cluster_01
    color: "#00000000"
    property alias _25Text: _25.text
    property alias ftText: ft.text
    property alias _500Text: _500.text
    property alias next_turnText: next_turn.text
    property alias emerson_StText: emerson_St.text
    property alias mPHText: mPH.text
    clip: true

    Rectangle {
        id: shape_background___Right
        anchors.right: parent.right
        anchors.bottom: parent.bottom
        width: 489 * eosADAS.scaleFactor
        height: 186 * eosADAS.scaleFactor
        color: "transparent"
        Image {
            id: base
            anchors.left: parent.left
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 36 * eosADAS.scaleFactor
            width: 810 * eosADAS.scaleFactor
            height: 186 * eosADAS.scaleFactor
            source: "assets/base.png"
            antialiasing: true
            layer.samples: 4
            layer.enabled: true
        }
    }

    Gears {
        id: gears
        anchors.right: shape_background___Right.right
        anchors.rightMargin: 72 * eosADAS.scaleFactor
        anchors.top: shape_background___Right.top
        anchors.topMargin: 36 * eosADAS.scaleFactor
        width: 215 * eosADAS.scaleFactor
        height: 80 * eosADAS.scaleFactor
    }

    Rectangle {
        id: shape_background___Left
        anchors.left: parent.left
        anchors.bottom: parent.bottom
        width: 475 * eosADAS.scaleFactor
        height: 186 * eosADAS.scaleFactor
        color: "transparent"
        Image {
            id: base1
            anchors.right: parent.right
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 36 * eosADAS.scaleFactor
            width: 810 * eosADAS.scaleFactor
            height: 186 * eosADAS.scaleFactor
            source: "assets/base_1.png"
            layer.samples: 4
            rotation: 180
            antialiasing: true
            layer.enabled: true
        }
    }

    Battery {
        id: battery
        anchors.left: shape_background___Left.left
        anchors.leftMargin: 72 * eosADAS.scaleFactor
        anchors.top: shape_background___Left.top
        anchors.topMargin: 36 * eosADAS.scaleFactor
        width: 180 * eosADAS.scaleFactor
        height: 80 * eosADAS.scaleFactor
    }

    Rectangle {
        id: arrow
        anchors.left: parent.left
        anchors.leftMargin: 70 * eosADAS.scaleFactor
        anchors.verticalCenter: parent.verticalCenter
        width: 150 * eosADAS.scaleFactor
        height: 150 * eosADAS.scaleFactor
        opacity: 0.9
        color: "#1a1f25"
        radius: 20 * eosADAS.scaleFactor
        clip: true

        Image {
            id: vectorRightTurn2
            anchors.centerIn: arrow
            scale: eosADAS.scaleFactor
            source: "assets/VectorRightTurn2.svg"
            fillMode: Image.PreserveAspectFit
        }
    }

    Text {
        id: emerson_St
        anchors.left: arrow.right
        anchors.top: next_turn.bottom
        anchors.margins: 6 * eosADAS.scaleFactor
        color: "#ffffff"
        text: "Emerson St"
        font.pixelSize: 50 * eosADAS.scaleFactor
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignTop
        wrapMode: Text.Wrap
        font.weight: Font.Normal
        font.family: "Slate For FCA Regular"
    }

    Text {
        id: next_turn
        anchors.left: arrow.right
        anchors.top: arrow.top
        anchors.margins: 6 * eosADAS.scaleFactor
        color: "#6d737a"
        text: "Next turn"
        font.pixelSize: 20 * eosADAS.scaleFactor
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignTop
        wrapMode: Text.Wrap
        font.weight: Font.Normal
        font.family: "Slate For FCA Regular"
    }

    Rectangle {
        id: distance
        anchors.left: arrow.right
        anchors.top: emerson_St.bottom
        anchors.leftMargin: 6 * eosADAS.scaleFactor
        anchors.topMargin: 6 * eosADAS.scaleFactor
        width: 86 * eosADAS.scaleFactor
        height: 40 * eosADAS.scaleFactor
        color: "transparent"
        Text {
            id: _500
            color: "#ffffff"
            text: "500"
            font.pixelSize: 40 * eosADAS.scaleFactor
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            wrapMode: Text.Wrap
            font.weight: Font.Normal
            font.family: "Slate For FCA Light"
        }

        Text {
            id: ft
            anchors.left: _500.right
            anchors.margins: 6 * eosADAS.scaleFactor
            anchors.top: _500.top
            color: "#595f66"
            text: "ft"
            font.pixelSize: 30 * eosADAS.scaleFactor
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            wrapMode: Text.Wrap
            font.weight: Font.Normal
            font.family: "Slate For FCA Regular"
        }
    }

    Rectangle {
        id: speedometer
        anchors.right: parent.right
        anchors.rightMargin: 57 * eosADAS.scaleFactor
        anchors.verticalCenter: parent.verticalCenter
        width: 270 * eosADAS.scaleFactor
        height: 212 * eosADAS.scaleFactor
        color: "transparent"
        Text {
            id: _25
            anchors.left: parent.left
            anchors.leftMargin: 45 * eosADAS.scaleFactor
            color: "#ffffff"
            text: "70"
            font.pixelSize: 180 * eosADAS.scaleFactor
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignTop
            font.weight: Font.Normal
            font.family: "Slate For FCA Light"
        }

        Text {
            id: mPH
            anchors.horizontalCenter: _25.horizontalCenter
            anchors.top: _25.bottom
            color: "#595f66"
            text: "MPH"
            font.pixelSize: 24 * eosADAS.scaleFactor
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignTop
            wrapMode: Text.Wrap
            font.weight: Font.Normal
            font.family: "Slate For FCA Regular"
        }
    }

    Image {
        id: vectorSpeedLimit2
        anchors.right: speedometer.left
        anchors.rightMargin: 12 * eosADAS.scaleFactor
        anchors.verticalCenter: speedometer.verticalCenter
        scale: eosADAS.scaleFactor
        source: "assets/VectorSpeedLimit2.svg"
        fillMode: Image.PreserveAspectFit
    }

    CruiseControl {
        id: cruiseControl
        anchors.horizontalCenter: vectorSpeedLimit2.horizontalCenter
        anchors.bottom: vectorSpeedLimit2.top
        anchors.bottomMargin: 12 * eosADAS.scaleFactor
        width: 96
        height: 48 * eosADAS.scaleFactor
    }

    ADAS_Bar {
        id: aDAS_Bar
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.top: parent.top
        anchors.topMargin: 22 * eosADAS.scaleFactor
        width: 700 * eosADAS.scaleFactor
        height: 68 * eosADAS.scaleFactor
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                duration: 2500
                loops: 1
                running: false
                to: 1000
                from: 0
            }
        ]
        enabled: false
        endFrame: 1000
        startFrame: 0

        KeyframeGroup {
            target: cluster_01
            property: "opacity"

            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 1
                frame: 1000
            }
        }
    }

    states: [
        State {
            name: "Startup"
            PropertyChanges {
                target: timeline
                enabled: true
            }

            PropertyChanges {
                target: timelineAnimation
                running: true
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;formeditorZoom:4;height:240;width:640}
}
##^##*/

