﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMakerRequest.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>

#include <utility>

namespace Aws {
namespace SageMaker {
namespace Model {

/**
 */
class StopOptimizationJobRequest : public SageMakerRequest {
 public:
  AWS_SAGEMAKER_API StopOptimizationJobRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "StopOptimizationJob"; }

  AWS_SAGEMAKER_API Aws::String SerializePayload() const override;

  AWS_SAGEMAKER_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The name that you assigned to the optimization job.</p>
   */
  inline const Aws::String& GetOptimizationJobName() const { return m_optimizationJobName; }
  inline bool OptimizationJobNameHasBeenSet() const { return m_optimizationJobNameHasBeenSet; }
  template <typename OptimizationJobNameT = Aws::String>
  void SetOptimizationJobName(OptimizationJobNameT&& value) {
    m_optimizationJobNameHasBeenSet = true;
    m_optimizationJobName = std::forward<OptimizationJobNameT>(value);
  }
  template <typename OptimizationJobNameT = Aws::String>
  StopOptimizationJobRequest& WithOptimizationJobName(OptimizationJobNameT&& value) {
    SetOptimizationJobName(std::forward<OptimizationJobNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_optimizationJobName;
  bool m_optimizationJobNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
