﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/CustomVocabularyItem.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {
class ListCustomVocabularyItemsResult {
 public:
  AWS_LEXMODELSV2_API ListCustomVocabularyItemsResult() = default;
  AWS_LEXMODELSV2_API ListCustomVocabularyItemsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LEXMODELSV2_API ListCustomVocabularyItemsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The identifier of the bot associated with this custom vocabulary.</p>
   */
  inline const Aws::String& GetBotId() const { return m_botId; }
  template <typename BotIdT = Aws::String>
  void SetBotId(BotIdT&& value) {
    m_botIdHasBeenSet = true;
    m_botId = std::forward<BotIdT>(value);
  }
  template <typename BotIdT = Aws::String>
  ListCustomVocabularyItemsResult& WithBotId(BotIdT&& value) {
    SetBotId(std::forward<BotIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the version of the bot associated with this custom
   * vocabulary.</p>
   */
  inline const Aws::String& GetBotVersion() const { return m_botVersion; }
  template <typename BotVersionT = Aws::String>
  void SetBotVersion(BotVersionT&& value) {
    m_botVersionHasBeenSet = true;
    m_botVersion = std::forward<BotVersionT>(value);
  }
  template <typename BotVersionT = Aws::String>
  ListCustomVocabularyItemsResult& WithBotVersion(BotVersionT&& value) {
    SetBotVersion(std::forward<BotVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the language and locale where this custom vocabulary is
   * used. The string must match one of the supported locales. For more information,
   * see <a href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">
   * Supported Languages </a>.</p>
   */
  inline const Aws::String& GetLocaleId() const { return m_localeId; }
  template <typename LocaleIdT = Aws::String>
  void SetLocaleId(LocaleIdT&& value) {
    m_localeIdHasBeenSet = true;
    m_localeId = std::forward<LocaleIdT>(value);
  }
  template <typename LocaleIdT = Aws::String>
  ListCustomVocabularyItemsResult& WithLocaleId(LocaleIdT&& value) {
    SetLocaleId(std::forward<LocaleIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The custom vocabulary items from the list custom vocabulary response.</p>
   */
  inline const Aws::Vector<CustomVocabularyItem>& GetCustomVocabularyItems() const { return m_customVocabularyItems; }
  template <typename CustomVocabularyItemsT = Aws::Vector<CustomVocabularyItem>>
  void SetCustomVocabularyItems(CustomVocabularyItemsT&& value) {
    m_customVocabularyItemsHasBeenSet = true;
    m_customVocabularyItems = std::forward<CustomVocabularyItemsT>(value);
  }
  template <typename CustomVocabularyItemsT = Aws::Vector<CustomVocabularyItem>>
  ListCustomVocabularyItemsResult& WithCustomVocabularyItems(CustomVocabularyItemsT&& value) {
    SetCustomVocabularyItems(std::forward<CustomVocabularyItemsT>(value));
    return *this;
  }
  template <typename CustomVocabularyItemsT = CustomVocabularyItem>
  ListCustomVocabularyItemsResult& AddCustomVocabularyItems(CustomVocabularyItemsT&& value) {
    m_customVocabularyItemsHasBeenSet = true;
    m_customVocabularyItems.emplace_back(std::forward<CustomVocabularyItemsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The nextToken identifier to the list custom vocabulary response.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListCustomVocabularyItemsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListCustomVocabularyItemsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_botId;

  Aws::String m_botVersion;

  Aws::String m_localeId;

  Aws::Vector<CustomVocabularyItem> m_customVocabularyItems;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_botIdHasBeenSet = false;
  bool m_botVersionHasBeenSet = false;
  bool m_localeIdHasBeenSet = false;
  bool m_customVocabularyItemsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
