/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.AlreadyRegisteredException;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.Logger;
import com.zeroc.Ice.NotRegisteredException;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ServantLocator;
import com.zeroc.Ice.Util;
import com.zeroc.IceInternal.Ex;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceUtilInternal.StringUtil;
import java.util.HashMap;
import java.util.Map;

public final class ServantManager {
    private Instance _instance;
    private final String _adapterName;
    private Map<Identity, Map<String, Object>> _servantMapMap = new HashMap<Identity, Map<String, Object>>();
    private Map<String, Object> _defaultServantMap = new HashMap<String, Object>();
    private Map<String, ServantLocator> _locatorMap = new HashMap<String, ServantLocator>();

    public synchronized void addServant(Object servant, Identity ident, String facet) {
        Map<String, Object> m;
        assert (this._instance != null);
        if (facet == null) {
            facet = "";
        }
        if ((m = this._servantMapMap.get(ident)) == null) {
            m = new HashMap<String, Object>();
            this._servantMapMap.put(ident, m);
        } else if (m.containsKey(facet)) {
            AlreadyRegisteredException ex = new AlreadyRegisteredException();
            ex.id = Util.identityToString(ident, this._instance.toStringMode());
            ex.kindOfObject = "servant";
            if (facet.length() > 0) {
                ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "", this._instance.toStringMode());
            }
            throw ex;
        }
        m.put(facet, servant);
    }

    public synchronized void addDefaultServant(Object servant, String category) {
        assert (this._instance != null);
        Object obj = this._defaultServantMap.get(category);
        if (obj != null) {
            AlreadyRegisteredException ex = new AlreadyRegisteredException();
            ex.kindOfObject = "default servant";
            ex.id = category;
            throw ex;
        }
        this._defaultServantMap.put(category, servant);
    }

    public synchronized Object removeServant(Identity ident, String facet) {
        assert (this._instance != null);
        if (facet == null) {
            facet = "";
        }
        Map<String, Object> m = this._servantMapMap.get(ident);
        Object obj = null;
        if (m == null || (obj = m.remove(facet)) == null) {
            NotRegisteredException ex = new NotRegisteredException();
            ex.id = Util.identityToString(ident, this._instance.toStringMode());
            ex.kindOfObject = "servant";
            if (facet.length() > 0) {
                ex.id = ex.id + " -f " + StringUtil.escapeString(facet, "", this._instance.toStringMode());
            }
            throw ex;
        }
        if (m.isEmpty()) {
            this._servantMapMap.remove(ident);
        }
        return obj;
    }

    public synchronized Object removeDefaultServant(String category) {
        assert (this._instance != null);
        Object obj = this._defaultServantMap.get(category);
        if (obj == null) {
            NotRegisteredException ex = new NotRegisteredException();
            ex.kindOfObject = "default servant";
            ex.id = category;
            throw ex;
        }
        this._defaultServantMap.remove(category);
        return obj;
    }

    public synchronized Map<String, Object> removeAllFacets(Identity ident) {
        assert (this._instance != null);
        Map<String, Object> m = this._servantMapMap.get(ident);
        if (m == null) {
            NotRegisteredException ex = new NotRegisteredException();
            ex.id = Util.identityToString(ident, this._instance.toStringMode());
            ex.kindOfObject = "servant";
            throw ex;
        }
        this._servantMapMap.remove(ident);
        return m;
    }

    public synchronized Object findServant(Identity ident, String facet) {
        if (facet == null) {
            facet = "";
        }
        Map<String, Object> m = this._servantMapMap.get(ident);
        Object obj = null;
        if (m == null) {
            obj = this._defaultServantMap.get(ident.category);
            if (obj == null) {
                obj = this._defaultServantMap.get("");
            }
        } else {
            obj = m.get(facet);
        }
        return obj;
    }

    public synchronized Object findDefaultServant(String category) {
        assert (this._instance != null);
        return this._defaultServantMap.get(category);
    }

    public synchronized Map<String, Object> findAllFacets(Identity ident) {
        assert (this._instance != null);
        Map<String, Object> m = this._servantMapMap.get(ident);
        if (m != null) {
            return new HashMap<String, Object>(m);
        }
        return new HashMap<String, Object>();
    }

    public synchronized boolean hasServant(Identity ident) {
        Map<String, Object> m = this._servantMapMap.get(ident);
        if (m == null) {
            return false;
        }
        assert (!m.isEmpty());
        return true;
    }

    public synchronized void addServantLocator(ServantLocator locator, String category) {
        assert (this._instance != null);
        ServantLocator l = this._locatorMap.get(category);
        if (l != null) {
            AlreadyRegisteredException ex = new AlreadyRegisteredException();
            ex.id = StringUtil.escapeString(category, "", this._instance.toStringMode());
            ex.kindOfObject = "servant locator";
            throw ex;
        }
        this._locatorMap.put(category, locator);
    }

    public synchronized ServantLocator removeServantLocator(String category) {
        ServantLocator l = null;
        assert (this._instance != null);
        l = this._locatorMap.remove(category);
        if (l == null) {
            NotRegisteredException ex = new NotRegisteredException();
            ex.id = StringUtil.escapeString(category, "", this._instance.toStringMode());
            ex.kindOfObject = "servant locator";
            throw ex;
        }
        return l;
    }

    public synchronized ServantLocator findServantLocator(String category) {
        return this._locatorMap.get(category);
    }

    public ServantManager(Instance instance, String adapterName) {
        this._instance = instance;
        this._adapterName = adapterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        HashMap<String, ServantLocator> locatorMap = new HashMap<String, ServantLocator>();
        Logger logger = null;
        ServantManager servantManager = this;
        synchronized (servantManager) {
            if (this._instance == null) {
                return;
            }
            logger = this._instance.initializationData().logger;
            this._servantMapMap.clear();
            this._defaultServantMap.clear();
            locatorMap.putAll(this._locatorMap);
            this._locatorMap.clear();
            this._instance = null;
        }
        for (Map.Entry entry : locatorMap.entrySet()) {
            ServantLocator locator = (ServantLocator)entry.getValue();
            try {
                locator.deactivate((String)entry.getKey());
            }
            catch (Exception ex) {
                String s = "exception during locator deactivation:\nobject adapter: `" + this._adapterName + "'\nlocator category: `" + (String)entry.getKey() + "'\n" + Ex.toString(ex);
                logger.error(s);
            }
        }
    }
}

