'''OpenGL extension EXT.draw_buffers_indexed

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.draw_buffers_indexed to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension builds upon the EXT_draw_buffers extension.
	In EXT_draw_buffers (part of OpenGL ES 3.0), separate values could
	be written to each color buffer, but the blend enable, blend functions,
	blend equations and color write masks are global and apply to all color
	outputs.
	
	This extension provides the ability to independently
	  * enable or disable blending,
	  * set the blend equations,
	  * set the blend functions, and
	  * set the color write masks
	per color output.
	
	This extension introduces indexed versions of the enable,
	blend equation, blend function, and color mask commands, as
	well as associated indexed queries in order to control and
	query these states independently on a per-color output basis.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/draw_buffers_indexed.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.draw_buffers_indexed import *
from OpenGL.raw.GLES2.EXT.draw_buffers_indexed import _EXTENSION_NAME

def glInitDrawBuffersIndexedEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION