/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.notification;

import java.net.InetAddress;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.javafx.FXErrorDialog;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.thrift.NotificationMessage;
import mediathek.tool.notification.thrift.ThriftNotificationCenter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class NativeNotificationCenter
implements INotificationCenter,
ServiceListener {
    private static final Logger logger = LogManager.getLogger(NativeNotificationCenter.class);
    private static final String NOTIFICATION_SERVICE_NAME = "NotificationService";
    private static final int PORT_UNDEFINED = -1;
    private int serverPort;
    private InetAddress serverAddress;

    public NativeNotificationCenter() {
        this.setupJmdnsListener();
    }

    private void setupJmdnsListener() {
        try {
            JmDNS jmdns = JmDNS.create(InetAddress.getLocalHost());
            jmdns.addServiceListener("_mv-notification._tcp.local.", this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void displayNotification(NotificationMessage msg) {
        if (!ApplicationConfiguration.getConfiguration().getBoolean("application.notifications.show", true)) {
            return;
        }
        if (this.serverPort == -1 || this.serverAddress == null) {
            this.showErrorDialog(new IllegalArgumentException("server port or server address not set"));
            return;
        }
        logger.trace("Sending native notification to {} on serverPort {}", (Object)this.serverAddress, (Object)this.serverPort);
        try (TSocket transport = new TSocket(this.serverAddress.getHostAddress(), this.serverPort);){
            ((TTransport)transport).open();
            TBinaryProtocol protocol = new TBinaryProtocol(transport);
            TMultiplexedProtocol mp = new TMultiplexedProtocol(protocol, NOTIFICATION_SERVICE_NAME);
            ThriftNotificationCenter.Client client = new ThriftNotificationCenter.Client(mp);
            client.displayNotification(msg);
        }
        catch (TException e) {
            this.showErrorDialog(e);
        }
    }

    private void showErrorDialog(Exception ex) {
        FXErrorDialog.showErrorDialog("MediathekView", "Native Benachrichtigungen k\u00f6nnen nicht angezeigt werden", "Bitte stellen Sie sicher das das Hilfsprogramm gestartet ist.", ex);
    }

    @Override
    public void serviceAdded(ServiceEvent serviceEvent) {
        this.setServiceInfo(serviceEvent);
    }

    private void setServiceInfo(ServiceEvent serviceEvent) {
        ServiceInfo info = serviceEvent.getInfo();
        InetAddress[] addrs = info.getInetAddresses();
        if (addrs.length > 0) {
            this.serverAddress = addrs[0];
            this.serverPort = info.getPort();
        } else {
            logger.trace("getInetAddresses returned empty list");
            this.serverAddress = null;
            this.serverPort = -1;
        }
    }

    @Override
    public void serviceRemoved(ServiceEvent serviceEvent) {
        this.serverPort = -1;
        this.serverAddress = null;
    }

    @Override
    public void serviceResolved(ServiceEvent serviceEvent) {
        this.setServiceInfo(serviceEvent);
    }
}

