/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.spinner;

import com.jidesoft.spinner.PointFormatter;
import com.jidesoft.spinner.SpinnerPointModel;
import com.jidesoft.spinner.SpinnerWheelSupport;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.text.DefaultFormatterFactory;

public class PointSpinner
extends JSpinner {
    public PointSpinner(SpinnerPointModel spinnerPointModel) {
        super(spinnerPointModel);
        this.customizeSpinner();
    }

    public PointSpinner() {
        this(new SpinnerPointModel());
    }

    @Override
    protected JComponent createEditor(SpinnerModel spinnerModel) {
        return new PointEditor(this);
    }

    private void updateField() {
        JComponent jComponent = this.getEditor();
        if (jComponent instanceof PointEditor && this.getModel() instanceof SpinnerPointModel) {
            JFormattedTextField jFormattedTextField = ((PointEditor)jComponent).getTextField();
            SpinnerPointModel spinnerPointModel = (SpinnerPointModel)this.getModel();
            int n = jFormattedTextField.getText().indexOf(44);
            int n2 = jFormattedTextField.getCaretPosition();
            spinnerPointModel.setField(n2 <= n ? 0 : 1);
        }
    }

    @Override
    public Point getNextValue() {
        this.updateField();
        return (Point)super.getNextValue();
    }

    @Override
    public Point getPreviousValue() {
        this.updateField();
        return (Point)super.getPreviousValue();
    }

    @Override
    public Point getValue() {
        return (Point)super.getValue();
    }

    protected void customizeSpinner() {
        SpinnerWheelSupport.installMouseWheelSupport(this);
    }

    public static class PointEditor
    extends JSpinner.DefaultEditor {
        public PointEditor(JSpinner jSpinner) {
            super(jSpinner);
            if (!(jSpinner.getModel() instanceof SpinnerPointModel)) {
                throw new IllegalArgumentException("model not a SpinnerPointModel");
            }
            final SpinnerPointModel spinnerPointModel = (SpinnerPointModel)jSpinner.getModel();
            JFormattedTextField.AbstractFormatter abstractFormatter = PointFormatter.getInstance();
            DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(abstractFormatter);
            final JFormattedTextField jFormattedTextField = this.getTextField();
            jFormattedTextField.setEditable(true);
            jFormattedTextField.setFormatterFactory(defaultFormatterFactory);
            jFormattedTextField.setHorizontalAlignment(4);
            String string = Integer.toString(Integer.MIN_VALUE);
            jFormattedTextField.setColumns(4 + 2 * string.length());
            jFormattedTextField.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    int n;
                    String string;
                    String string2 = jFormattedTextField.getText();
                    int n2 = string2.indexOf(44);
                    if (spinnerPointModel.getField() == 0) {
                        string = string2.substring(string2.indexOf(40) + 1, n2).trim();
                        n = string2.indexOf(string);
                    } else {
                        string = string2.substring(n2 + 1, string2.indexOf(41)).trim();
                        n = string2.lastIndexOf(string);
                    }
                    jFormattedTextField.select(n, n + string.length());
                }
            });
        }
    }
}

