/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.db.explorer.dlg;

import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author Jiri Rechtacek
 */
public class ViewProcedureDialog extends javax.swing.JPanel {

    /** Creates new form ViewProcedureDialog */
    private ViewProcedureDialog(String name, String params, String body) {
        initComponents();
        tfName.setText(name);
        taParams.setText(params);
        taBody.setText(body);
    }
    
    public static void showProcedure(String name, String params, String body) {
        ViewProcedureDialog panel = new ViewProcedureDialog(name, params, body);
        panel.setName(NbBundle.getMessage(ViewProcedureDialog.class, "ViewProcedureDialog_Title")); // NOI18N
        NotifyDescriptor nd = new NotifyDescriptor.Message(panel);
        DialogDisplayer.getDefault().notify(nd);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lName = new javax.swing.JLabel();
        tfName = new javax.swing.JTextField();
        lParams = new javax.swing.JLabel();
        spParams = new javax.swing.JScrollPane();
        taParams = new javax.swing.JTextArea();
        lBody = new javax.swing.JLabel();
        spBody = new javax.swing.JScrollPane();
        taBody = new javax.swing.JTextArea();

        lName.setLabelFor(tfName);
        org.openide.awt.Mnemonics.setLocalizedText(lName, org.openide.util.NbBundle.getMessage(ViewProcedureDialog.class, "ViewProcedureDialog.lName.text", new Object[] {})); // NOI18N

        tfName.setEditable(false);

        lParams.setLabelFor(taParams);
        org.openide.awt.Mnemonics.setLocalizedText(lParams, org.openide.util.NbBundle.getMessage(ViewProcedureDialog.class, "ViewProcedureDialog.lParams.text", new Object[] {})); // NOI18N

        taParams.setColumns(20);
        taParams.setEditable(false);
        taParams.setRows(5);
        spParams.setViewportView(taParams);
        taParams.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ViewProcedureDialog.class, "ViewProcedureDialog.taParams.ACD")); // NOI18N

        lBody.setLabelFor(taBody);
        org.openide.awt.Mnemonics.setLocalizedText(lBody, org.openide.util.NbBundle.getMessage(ViewProcedureDialog.class, "ViewProcedureDialog.lBody.text", new Object[] {})); // NOI18N

        taBody.setColumns(20);
        taBody.setEditable(false);
        taBody.setRows(5);
        spBody.setViewportView(taBody);
        taBody.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ViewProcedureDialog.class, "ViewProcedureDialog.taBody.ACD")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(spParams, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 826, Short.MAX_VALUE)
                    .addComponent(spBody, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 826, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addComponent(lName)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(tfName, javax.swing.GroupLayout.DEFAULT_SIZE, 756, Short.MAX_VALUE))
                    .addComponent(lParams, javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lBody, javax.swing.GroupLayout.Alignment.LEADING))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lName)
                    .addComponent(tfName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addComponent(lParams)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(spParams, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(lBody)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(spBody, javax.swing.GroupLayout.PREFERRED_SIZE, 262, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        tfName.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ViewProcedureDialog.class, "ViewProcedureDialog.tfName.ACD")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lBody;
    private javax.swing.JLabel lName;
    private javax.swing.JLabel lParams;
    private javax.swing.JScrollPane spBody;
    private javax.swing.JScrollPane spParams;
    private javax.swing.JTextArea taBody;
    private javax.swing.JTextArea taParams;
    private javax.swing.JTextField tfName;
    // End of variables declaration//GEN-END:variables

}
