# Autogenerated by Sphinx on Tue Apr  8 13:35:42 2025
# as part of the release process.

topics = {
    'assert': r'''The "assert" statement
**********************

Assert statements are a convenient way to insert debugging assertions
into a program:

   assert_stmt ::= "assert" expression ["," expression]

The simple form, "assert expression", is equivalent to

   if __debug__:
       if not expression: raise AssertionError

The extended form, "assert expression1, expression2", is equivalent to

   if __debug__:
       if not expression1: raise AssertionError(expression2)

These equivalences assume that "__debug__" and "AssertionError" refer
to the built-in variables with those names.  In the current
implementation, the built-in variable "__debug__" is "True" under
normal circumstances, "False" when optimization is requested (command
line option "-O").  The current code generator emits no code for an
"assert" statement when optimization is requested at compile time.
Note that it is unnecessary to include the source code for the
expression that failed in the error message; it will be displayed as
part of the stack trace.

Assignments to "__debug__" are illegal.  The value for the built-in
variable is determined when the interpreter starts.
''',
    'assignment': r'''Assignment statements
*********************

Assignment statements are used to (re)bind names to values and to
modify attributes or items of mutable objects:

   assignment_stmt ::= (target_list "=")+ (starred_expression | yield_expression)
   target_list     ::= target ("," target)* [","]
   target          ::= identifier
                       | "(" [target_list] ")"
                       | "[" [target_list] "]"
                       | attributeref
                       | subscription
                       | slicing
                       | "*" target

(See section Primaries for the syntax definitions for *attributeref*,
*subscription*, and *slicing*.)

An assignment statement evaluates the expression list (remember that
this can be a single expression or a comma-separated list, the latter
yielding a tuple) and assigns the single resulting object to each of
the target lists, from left to right.

Assignment is defined recursively depending on the form of the target
(list). When a target is part of a mutable object (an attribute
reference, subscription or slicing), the mutable object must
ultimately perform the assignment and decide about its validity, and
may raise an exception if the assignment is unacceptable.  The rules
observed by various types and the exceptions raised are given with the
definition of the object types (see section The standard type
hierarchy).

Assignment of an object to a target list, optionally enclosed in
parentheses or square brackets, is recursively defined as follows.

* If the target list is a single target with no trailing comma,
  optionally in parentheses, the object is assigned to that target.

* Else:

  * If the target list contains one target prefixed with an asterisk,
    called a “starred” target: The object must be an iterable with at
    least as many items as there are targets in the target list, minus
    one.  The first items of the iterable are assigned, from left to
    right, to the targets before the starred target.  The final items
    of the iterable are assigned to the targets after the starred
    target.  A list of the remaining items in the iterable is then
    assigned to the starred target (the list can be empty).

  * Else: The object must be an iterable with the same number of items
    as there are targets in the target list, and the items are
    assigned, from left to right, to the corresponding targets.

Assignment of an object to a single target is recursively defined as
follows.

* If the target is an identifier (name):

  * If the name does not occur in a "global" or "nonlocal" statement
    in the current code block: the name is bound to the object in the
    current local namespace.

  * Otherwise: the name is bound to the object in the global namespace
    or the outer namespace determined by "nonlocal", respectively.

  The name is rebound if it was already bound.  This may cause the
  reference count for the object previously bound to the name to reach
  zero, causing the object to be deallocated and its destructor (if it
  has one) to be called.

* If the target is an attribute reference: The primary expression in
  the reference is evaluated.  It should yield an object with
  assignable attributes; if this is not the case, "TypeError" is
  raised.  That object is then asked to assign the assigned object to
  the given attribute; if it cannot perform the assignment, it raises
  an exception (usually but not necessarily "AttributeError").

  Note: If the object is a class instance and the attribute reference
  occurs on both sides of the assignment operator, the right-hand side
  expression, "a.x" can access either an instance attribute or (if no
  instance attribute exists) a class attribute.  The left-hand side
  target "a.x" is always set as an instance attribute, creating it if
  necessary.  Thus, the two occurrences of "a.x" do not necessarily
  refer to the same attribute: if the right-hand side expression
  refers to a class attribute, the left-hand side creates a new
  instance attribute as the target of the assignment:

     class Cls:
         x = 3             # class variable
     inst = Cls()
     inst.x = inst.x + 1   # writes inst.x as 4 leaving Cls.x as 3

  This description does not necessarily apply to descriptor
  attributes, such as properties created with "property()".

* If the target is a subscription: The primary expression in the
  reference is evaluated.  It should yield either a mutable sequence
  object (such as a list) or a mapping object (such as a dictionary).
  Next, the subscript expression is evaluated.

  If the primary is a mutable sequence object (such as a list), the
  subscript must yield an integer.  If it is negative, the sequence’s
  length is added to it.  The resulting value must be a nonnegative
  integer less than the sequence’s length, and the sequence is asked
  to assign the assigned object to its item with that index.  If the
  index is out of range, "IndexError" is raised (assignment to a
  subscripted sequence cannot add new items to a list).

  If the primary is a mapping object (such as a dictionary), the
  subscript must have a type compatible with the mapping’s key type,
  and the mapping is then asked to create a key/value pair which maps
  the subscript to the assigned object.  This can either replace an
  existing key/value pair with the same key value, or insert a new
  key/value pair (if no key with the same value existed).

  For user-defined objects, the "__setitem__()" method is called with
  appropriate arguments.

* If the target is a slicing: The primary expression in the reference
  is evaluated.  It should yield a mutable sequence object (such as a
  list).  The assigned object should be a sequence object of the same
  type.  Next, the lower and upper bound expressions are evaluated,
  insofar they are present; defaults are zero and the sequence’s
  length.  The bounds should evaluate to integers. If either bound is
  negative, the sequence’s length is added to it.  The resulting
  bounds are clipped to lie between zero and the sequence’s length,
  inclusive.  Finally, the sequence object is asked to replace the
  slice with the items of the assigned sequence.  The length of the
  slice may be different from the length of the assigned sequence,
  thus changing the length of the target sequence, if the target
  sequence allows it.

**CPython implementation detail:** In the current implementation, the
syntax for targets is taken to be the same as for expressions, and
invalid syntax is rejected during the code generation phase, causing
less detailed error messages.

Although the definition of assignment implies that overlaps between
the left-hand side and the right-hand side are ‘simultaneous’ (for
example "a, b = b, a" swaps two variables), overlaps *within* the
collection of assigned-to variables occur left-to-right, sometimes
resulting in confusion.  For instance, the following program prints
"[0, 2]":

   x = [0, 1]
   i = 0
   i, x[i] = 1, 2         # i is updated, then x[i] is updated
   print(x)

See also:

  **PEP 3132** - Extended Iterable Unpacking
     The specification for the "*target" feature.


Augmented assignment statements
===============================

Augmented assignment is the combination, in a single statement, of a
binary operation and an assignment statement:

   augmented_assignment_stmt ::= augtarget augop (expression_list | yield_expression)
   augtarget                 ::= identifier | attributeref | subscription | slicing
   augop                     ::= "+=" | "-=" | "*=" | "@=" | "/=" | "//=" | "%=" | "**="
                                 | ">>=" | "<<=" | "&=" | "^=" | "|="

(See section Primaries for the syntax definitions of the last three
symbols.)

An augmented assignment evaluates the target (which, unlike normal
assignment statements, cannot be an unpacking) and the expression
list, performs the binary operation specific to the type of assignment
on the two operands, and assigns the result to the original target.
The target is only evaluated once.

An augmented assignment statement like "x += 1" can be rewritten as "x
= x + 1" to achieve a similar, but not exactly equal effect. In the
augmented version, "x" is only evaluated once. Also, when possible,
the actual operation is performed *in-place*, meaning that rather than
creating a new object and assigning that to the target, the old object
is modified instead.

Unlike normal assignments, augmented assignments evaluate the left-
hand side *before* evaluating the right-hand side.  For example, "a[i]
+= f(x)" first looks-up "a[i]", then it evaluates "f(x)" and performs
the addition, and lastly, it writes the result back to "a[i]".

With the exception of assigning to tuples and multiple targets in a
single statement, the assignment done by augmented assignment
statements is handled the same way as normal assignments. Similarly,
with the exception of the possible *in-place* behavior, the binary
operation performed by augmented assignment is the same as the normal
binary operations.

For targets which are attribute references, the same caveat about
class and instance attributes applies as for regular assignments.


Annotated assignment statements
===============================

*Annotation* assignment is the combination, in a single statement, of
a variable or attribute annotation and an optional assignment
statement:

   annotated_assignment_stmt ::= augtarget ":" expression
                                 ["=" (starred_expression | yield_expression)]

The difference from normal Assignment statements is that only a single
target is allowed.

The assignment target is considered “simple” if it consists of a
single name that is not enclosed in parentheses. For simple assignment
targets, if in class or module scope, the annotations are evaluated
and stored in a special class or module attribute "__annotations__"
that is a dictionary mapping from variable names (mangled if private)
to evaluated annotations. This attribute is writable and is
automatically created at the start of class or module body execution,
if annotations are found statically.

If the assignment target is not simple (an attribute, subscript node,
or parenthesized name), the annotation is evaluated if in class or
module scope, but not stored.

If a name is annotated in a function scope, then this name is local
for that scope. Annotations are never evaluated and stored in function
scopes.

If the right hand side is present, an annotated assignment performs
the actual assignment before evaluating annotations (where
applicable). If the right hand side is not present for an expression
target, then the interpreter evaluates the target except for the last
"__setitem__()" or "__setattr__()" call.

See also:

  **PEP 526** - Syntax for Variable Annotations
     The proposal that added syntax for annotating the types of
     variables (including class variables and instance variables),
     instead of expressing them through comments.

  **PEP 484** - Type hints
     The proposal that added the "typing" module to provide a standard
     syntax for type annotations that can be used in static analysis
     tools and IDEs.

Changed in version 3.8: Now annotated assignments allow the same
expressions in the right hand side as regular assignments. Previously,
some expressions (like un-parenthesized tuple expressions) caused a
syntax error.
''',
    'async': r'''Coroutines
**********

Added in version 3.5.


Coroutine function definition
=============================

   async_funcdef ::= [decorators] "async" "def" funcname "(" [parameter_list] ")"
                     ["->" expression] ":" suite

Execution of Python coroutines can be suspended and resumed at many
points (see *coroutine*). "await" expressions, "async for" and "async
with" can only be used in the body of a coroutine function.

Functions defined with "async def" syntax are always coroutine
functions, even if they do not contain "await" or "async" keywords.

It is a "SyntaxError" to use a "yield from" expression inside the body
of a coroutine function.

An example of a coroutine function:

   async def func(param1, param2):
       do_stuff()
       await some_coroutine()

Changed in version 3.7: "await" and "async" are now keywords;
previously they were only treated as such inside the body of a
coroutine function.


The "async for" statement
=========================

   async_for_stmt ::= "async" for_stmt

An *asynchronous iterable* provides an "__aiter__" method that
directly returns an *asynchronous iterator*, which can call
asynchronous code in its "__anext__" method.

The "async for" statement allows convenient iteration over
asynchronous iterables.

The following code:

   async for TARGET in ITER:
       SUITE
   else:
       SUITE2

Is semantically equivalent to:

   iter = (ITER)
   iter = type(iter).__aiter__(iter)
   running = True

   while running:
       try:
           TARGET = await type(iter).__anext__(iter)
       except StopAsyncIteration:
           running = False
       else:
           SUITE
   else:
       SUITE2

See also "__aiter__()" and "__anext__()" for details.

It is a "SyntaxError" to use an "async for" statement outside the body
of a coroutine function.


The "async with" statement
==========================

   async_with_stmt ::= "async" with_stmt

An *asynchronous context manager* is a *context manager* that is able
to suspend execution in its *enter* and *exit* methods.

The following code:

   async with EXPRESSION as TARGET:
       SUITE

is semantically equivalent to:

   manager = (EXPRESSION)
   aenter = type(manager).__aenter__
   aexit = type(manager).__aexit__
   value = await aenter(manager)
   hit_except = False

   try:
       TARGET = value
       SUITE
   except:
       hit_except = True
       if not await aexit(manager, *sys.exc_info()):
           raise
   finally:
       if not hit_except:
           await aexit(manager, None, None, None)

See also "__aenter__()" and "__aexit__()" for details.

It is a "SyntaxError" to use an "async with" statement outside the
body of a coroutine function.

See also:

  **PEP 492** - Coroutines with async and await syntax
     The proposal that made coroutines a proper standalone concept in
     Python, and added supporting syntax.
''',
    'atom-identifiers': r'''Identifiers (Names)
*******************

An identifier occurring as an atom is a name.  See section Identifiers
and keywords for lexical definition and section Naming and binding for
documentation of naming and binding.

When the name is bound to an object, evaluation of the atom yields
that object. When a name is not bound, an attempt to evaluate it
raises a "NameError" exception.


Private name mangling
=====================

When an identifier that textually occurs in a class definition begins
with two or more underscore characters and does not end in two or more
underscores, it is considered a *private name* of that class.

See also: The class specifications.

More precisely, private names are transformed to a longer form before
code is generated for them.  If the transformed name is longer than
255 characters, implementation-defined truncation may happen.

The transformation is independent of the syntactical context in which
the identifier is used but only the following private identifiers are
mangled:

* Any name used as the name of a variable that is assigned or read or
  any name of an attribute being accessed.

  The "__name__" attribute of nested functions, classes, and type
  aliases is however not mangled.

* The name of imported modules, e.g., "__spam" in "import __spam". If
  the module is part of a package (i.e., its name contains a dot), the
  name is *not* mangled, e.g., the "__foo" in "import __foo.bar" is
  not mangled.

* The name of an imported member, e.g., "__f" in "from spam import
  __f".

The transformation rule is defined as follows:

* The class name, with leading underscores removed and a single
  leading underscore inserted, is inserted in front of the identifier,
  e.g., the identifier "__spam" occurring in a class named "Foo",
  "_Foo" or "__Foo" is transformed to "_Foo__spam".

* If the class name consists only of underscores, the transformation
  is the identity, e.g., the identifier "__spam" occurring in a class
  named "_" or "__" is left as is.
''',
    'atom-literals': r'''Literals
********

Python supports string and bytes literals and various numeric
literals:

   literal ::= stringliteral | bytesliteral
               | integer | floatnumber | imagnumber

Evaluation of a literal yields an object of the given type (string,
bytes, integer, floating-point number, complex number) with the given
value.  The value may be approximated in the case of floating-point
and imaginary (complex) literals.  See section Literals for details.

All literals correspond to immutable data types, and hence the
object’s identity is less important than its value.  Multiple
evaluations of literals with the same value (either the same
occurrence in the program text or a different occurrence) may obtain
the same object or a different object with the same value.
''',
    'attribute-access': r'''Customizing attribute access
****************************

The following methods can be defined to customize the meaning of
attribute access (use of, assignment to, or deletion of "x.name") for
class instances.

object.__getattr__(self, name)

   Called when the default attribute access fails with an
   "AttributeError" (either "__getattribute__()" raises an
   "AttributeError" because *name* is not an instance attribute or an
   attribute in the class tree for "self"; or "__get__()" of a *name*
   property raises "AttributeError").  This method should either
   return the (computed) attribute value or raise an "AttributeError"
   exception. The "object" class itself does not provide this method.

   Note that if the attribute is found through the normal mechanism,
   "__getattr__()" is not called.  (This is an intentional asymmetry
   between "__getattr__()" and "__setattr__()".) This is done both for
   efficiency reasons and because otherwise "__getattr__()" would have
   no way to access other attributes of the instance.  Note that at
   least for instance variables, you can fake total control by not
   inserting any values in the instance attribute dictionary (but
   instead inserting them in another object).  See the
   "__getattribute__()" method below for a way to actually get total
   control over attribute access.

object.__getattribute__(self, name)

   Called unconditionally to implement attribute accesses for
   instances of the class. If the class also defines "__getattr__()",
   the latter will not be called unless "__getattribute__()" either
   calls it explicitly or raises an "AttributeError". This method
   should return the (computed) attribute value or raise an
   "AttributeError" exception. In order to avoid infinite recursion in
   this method, its implementation should always call the base class
   method with the same name to access any attributes it needs, for
   example, "object.__getattribute__(self, name)".

   Note:

     This method may still be bypassed when looking up special methods
     as the result of implicit invocation via language syntax or
     built-in functions. See Special method lookup.

   For certain sensitive attribute accesses, raises an auditing event
   "object.__getattr__" with arguments "obj" and "name".

object.__setattr__(self, name, value)

   Called when an attribute assignment is attempted.  This is called
   instead of the normal mechanism (i.e. store the value in the
   instance dictionary). *name* is the attribute name, *value* is the
   value to be assigned to it.

   If "__setattr__()" wants to assign to an instance attribute, it
   should call the base class method with the same name, for example,
   "object.__setattr__(self, name, value)".

   For certain sensitive attribute assignments, raises an auditing
   event "object.__setattr__" with arguments "obj", "name", "value".

object.__delattr__(self, name)

   Like "__setattr__()" but for attribute deletion instead of
   assignment.  This should only be implemented if "del obj.name" is
   meaningful for the object.

   For certain sensitive attribute deletions, raises an auditing event
   "object.__delattr__" with arguments "obj" and "name".

object.__dir__(self)

   Called when "dir()" is called on the object. An iterable must be
   returned. "dir()" converts the returned iterable to a list and
   sorts it.


Customizing module attribute access
===================================

Special names "__getattr__" and "__dir__" can be also used to
customize access to module attributes. The "__getattr__" function at
the module level should accept one argument which is the name of an
attribute and return the computed value or raise an "AttributeError".
If an attribute is not found on a module object through the normal
lookup, i.e. "object.__getattribute__()", then "__getattr__" is
searched in the module "__dict__" before raising an "AttributeError".
If found, it is called with the attribute name and the result is
returned.

The "__dir__" function should accept no arguments, and return an
iterable of strings that represents the names accessible on module. If
present, this function overrides the standard "dir()" search on a
module.

For a more fine grained customization of the module behavior (setting
attributes, properties, etc.), one can set the "__class__" attribute
of a module object to a subclass of "types.ModuleType". For example:

   import sys
   from types import ModuleType

   class VerboseModule(ModuleType):
       def __repr__(self):
           return f'Verbose {self.__name__}'

       def __setattr__(self, attr, value):
           print(f'Setting {attr}...')
           super().__setattr__(attr, value)

   sys.modules[__name__].__class__ = VerboseModule

Note:

  Defining module "__getattr__" and setting module "__class__" only
  affect lookups made using the attribute access syntax – directly
  accessing the module globals (whether by code within the module, or
  via a reference to the module’s globals dictionary) is unaffected.

Changed in version 3.5: "__class__" module attribute is now writable.

Added in version 3.7: "__getattr__" and "__dir__" module attributes.

See also:

  **PEP 562** - Module __getattr__ and __dir__
     Describes the "__getattr__" and "__dir__" functions on modules.


Implementing Descriptors
========================

The following methods only apply when an instance of the class
containing the method (a so-called *descriptor* class) appears in an
*owner* class (the descriptor must be in either the owner’s class
dictionary or in the class dictionary for one of its parents).  In the
examples below, “the attribute” refers to the attribute whose name is
the key of the property in the owner class’ "__dict__".  The "object"
class itself does not implement any of these protocols.

object.__get__(self, instance, owner=None)

   Called to get the attribute of the owner class (class attribute
   access) or of an instance of that class (instance attribute
   access). The optional *owner* argument is the owner class, while
   *instance* is the instance that the attribute was accessed through,
   or "None" when the attribute is accessed through the *owner*.

   This method should return the computed attribute value or raise an
   "AttributeError" exception.

   **PEP 252** specifies that "__get__()" is callable with one or two
   arguments.  Python’s own built-in descriptors support this
   specification; however, it is likely that some third-party tools
   have descriptors that require both arguments.  Python’s own
   "__getattribute__()" implementation always passes in both arguments
   whether they are required or not.

object.__set__(self, instance, value)

   Called to set the attribute on an instance *instance* of the owner
   class to a new value, *value*.

   Note, adding "__set__()" or "__delete__()" changes the kind of
   descriptor to a “data descriptor”.  See Invoking Descriptors for
   more details.

object.__delete__(self, instance)

   Called to delete the attribute on an instance *instance* of the
   owner class.

Instances of descriptors may also have the "__objclass__" attribute
present:

object.__objclass__

   The attribute "__objclass__" is interpreted by the "inspect" module
   as specifying the class where this object was defined (setting this
   appropriately can assist in runtime introspection of dynamic class
   attributes). For callables, it may indicate that an instance of the
   given type (or a subclass) is expected or required as the first
   positional argument (for example, CPython sets this attribute for
   unbound methods that are implemented in C).


Invoking Descriptors
====================

In general, a descriptor is an object attribute with “binding
behavior”, one whose attribute access has been overridden by methods
in the descriptor protocol:  "__get__()", "__set__()", and
"__delete__()". If any of those methods are defined for an object, it
is said to be a descriptor.

The default behavior for attribute access is to get, set, or delete
the attribute from an object’s dictionary. For instance, "a.x" has a
lookup chain starting with "a.__dict__['x']", then
"type(a).__dict__['x']", and continuing through the base classes of
"type(a)" excluding metaclasses.

However, if the looked-up value is an object defining one of the
descriptor methods, then Python may override the default behavior and
invoke the descriptor method instead.  Where this occurs in the
precedence chain depends on which descriptor methods were defined and
how they were called.

The starting point for descriptor invocation is a binding, "a.x". How
the arguments are assembled depends on "a":

Direct Call
   The simplest and least common call is when user code directly
   invokes a descriptor method:    "x.__get__(a)".

Instance Binding
   If binding to an object instance, "a.x" is transformed into the
   call: "type(a).__dict__['x'].__get__(a, type(a))".

Class Binding
   If binding to a class, "A.x" is transformed into the call:
   "A.__dict__['x'].__get__(None, A)".

Super Binding
   A dotted lookup such as "super(A, a).x" searches
   "a.__class__.__mro__" for a base class "B" following "A" and then
   returns "B.__dict__['x'].__get__(a, A)".  If not a descriptor, "x"
   is returned unchanged.

For instance bindings, the precedence of descriptor invocation depends
on which descriptor methods are defined.  A descriptor can define any
combination of "__get__()", "__set__()" and "__delete__()".  If it
does not define "__get__()", then accessing the attribute will return
the descriptor object itself unless there is a value in the object’s
instance dictionary.  If the descriptor defines "__set__()" and/or
"__delete__()", it is a data descriptor; if it defines neither, it is
a non-data descriptor.  Normally, data descriptors define both
"__get__()" and "__set__()", while non-data descriptors have just the
"__get__()" method.  Data descriptors with "__get__()" and "__set__()"
(and/or "__delete__()") defined always override a redefinition in an
instance dictionary.  In contrast, non-data descriptors can be
overridden by instances.

Python methods (including those decorated with "@staticmethod" and
"@classmethod") are implemented as non-data descriptors.  Accordingly,
instances can redefine and override methods.  This allows individual
instances to acquire behaviors that differ from other instances of the
same class.

The "property()" function is implemented as a data descriptor.
Accordingly, instances cannot override the behavior of a property.


__slots__
=========

*__slots__* allow us to explicitly declare data members (like
properties) and deny the creation of "__dict__" and *__weakref__*
(unless explicitly declared in *__slots__* or available in a parent.)

The space saved over using "__dict__" can be significant. Attribute
lookup speed can be significantly improved as well.

object.__slots__

   This class variable can be assigned a string, iterable, or sequence
   of strings with variable names used by instances.  *__slots__*
   reserves space for the declared variables and prevents the
   automatic creation of "__dict__" and *__weakref__* for each
   instance.

Notes on using *__slots__*:

* When inheriting from a class without *__slots__*, the "__dict__" and
  *__weakref__* attribute of the instances will always be accessible.

* Without a "__dict__" variable, instances cannot be assigned new
  variables not listed in the *__slots__* definition.  Attempts to
  assign to an unlisted variable name raises "AttributeError". If
  dynamic assignment of new variables is desired, then add
  "'__dict__'" to the sequence of strings in the *__slots__*
  declaration.

* Without a *__weakref__* variable for each instance, classes defining
  *__slots__* do not support "weak references" to its instances. If
  weak reference support is needed, then add "'__weakref__'" to the
  sequence of strings in the *__slots__* declaration.

* *__slots__* are implemented at the class level by creating
  descriptors for each variable name.  As a result, class attributes
  cannot be used to set default values for instance variables defined
  by *__slots__*; otherwise, the class attribute would overwrite the
  descriptor assignment.

* The action of a *__slots__* declaration is not limited to the class
  where it is defined.  *__slots__* declared in parents are available
  in child classes. However, instances of a child subclass will get a
  "__dict__" and *__weakref__* unless the subclass also defines
  *__slots__* (which should only contain names of any *additional*
  slots).

* If a class defines a slot also defined in a base class, the instance
  variable defined by the base class slot is inaccessible (except by
  retrieving its descriptor directly from the base class). This
  renders the meaning of the program undefined.  In the future, a
  check may be added to prevent this.

* "TypeError" will be raised if nonempty *__slots__* are defined for a
  class derived from a ""variable-length" built-in type" such as
  "int", "bytes", and "tuple".

* Any non-string *iterable* may be assigned to *__slots__*.

* If a "dictionary" is used to assign *__slots__*, the dictionary keys
  will be used as the slot names. The values of the dictionary can be
  used to provide per-attribute docstrings that will be recognised by
  "inspect.getdoc()" and displayed in the output of "help()".

* "__class__" assignment works only if both classes have the same
  *__slots__*.

* Multiple inheritance with multiple slotted parent classes can be
  used, but only one parent is allowed to have attributes created by
  slots (the other bases must have empty slot layouts) - violations
  raise "TypeError".

* If an *iterator* is used for *__slots__* then a *descriptor* is
  created for each of the iterator’s values. However, the *__slots__*
  attribute will be an empty iterator.
''',
    'attribute-references': r'''Attribute references
********************

An attribute reference is a primary followed by a period and a name:

   attributeref ::= primary "." identifier

The primary must evaluate to an object of a type that supports
attribute references, which most objects do.  This object is then
asked to produce the attribute whose name is the identifier. The type
and value produced is determined by the object.  Multiple evaluations
of the same attribute reference may yield different objects.

This production can be customized by overriding the
"__getattribute__()" method or the "__getattr__()" method.  The
"__getattribute__()" method is called first and either returns a value
or raises "AttributeError" if the attribute is not available.

If an "AttributeError" is raised and the object has a "__getattr__()"
method, that method is called as a fallback.
''',
    'augassign': r'''Augmented assignment statements
*******************************

Augmented assignment is the combination, in a single statement, of a
binary operation and an assignment statement:

   augmented_assignment_stmt ::= augtarget augop (expression_list | yield_expression)
   augtarget                 ::= identifier | attributeref | subscription | slicing
   augop                     ::= "+=" | "-=" | "*=" | "@=" | "/=" | "//=" | "%=" | "**="
                                 | ">>=" | "<<=" | "&=" | "^=" | "|="

(See section Primaries for the syntax definitions of the last three
symbols.)

An augmented assignment evaluates the target (which, unlike normal
assignment statements, cannot be an unpacking) and the expression
list, performs the binary operation specific to the type of assignment
on the two operands, and assigns the result to the original target.
The target is only evaluated once.

An augmented assignment statement like "x += 1" can be rewritten as "x
= x + 1" to achieve a similar, but not exactly equal effect. In the
augmented version, "x" is only evaluated once. Also, when possible,
the actual operation is performed *in-place*, meaning that rather than
creating a new object and assigning that to the target, the old object
is modified instead.

Unlike normal assignments, augmented assignments evaluate the left-
hand side *before* evaluating the right-hand side.  For example, "a[i]
+= f(x)" first looks-up "a[i]", then it evaluates "f(x)" and performs
the addition, and lastly, it writes the result back to "a[i]".

With the exception of assigning to tuples and multiple targets in a
single statement, the assignment done by augmented assignment
statements is handled the same way as normal assignments. Similarly,
with the exception of the possible *in-place* behavior, the binary
operation performed by augmented assignment is the same as the normal
binary operations.

For targets which are attribute references, the same caveat about
class and instance attributes applies as for regular assignments.
''',
    'await': r'''Await expression
****************

Suspend the execution of *coroutine* on an *awaitable* object. Can
only be used inside a *coroutine function*.

   await_expr ::= "await" primary

Added in version 3.5.
''',
    'binary': r'''Binary arithmetic operations
****************************

The binary arithmetic operations have the conventional priority
levels.  Note that some of these operations also apply to certain non-
numeric types.  Apart from the power operator, there are only two
levels, one for multiplicative operators and one for additive
operators:

   m_expr ::= u_expr | m_expr "*" u_expr | m_expr "@" m_expr |
              m_expr "//" u_expr | m_expr "/" u_expr |
              m_expr "%" u_expr
   a_expr ::= m_expr | a_expr "+" m_expr | a_expr "-" m_expr

The "*" (multiplication) operator yields the product of its arguments.
The arguments must either both be numbers, or one argument must be an
integer and the other must be a sequence. In the former case, the
numbers are converted to a common type and then multiplied together.
In the latter case, sequence repetition is performed; a negative
repetition factor yields an empty sequence.

This operation can be customized using the special "__mul__()" and
"__rmul__()" methods.

The "@" (at) operator is intended to be used for matrix
multiplication.  No builtin Python types implement this operator.

This operation can be customized using the special "__matmul__()" and
"__rmatmul__()" methods.

Added in version 3.5.

The "/" (division) and "//" (floor division) operators yield the
quotient of their arguments.  The numeric arguments are first
converted to a common type. Division of integers yields a float, while
floor division of integers results in an integer; the result is that
of mathematical division with the ‘floor’ function applied to the
result.  Division by zero raises the "ZeroDivisionError" exception.

The division operation can be customized using the special
"__truediv__()" and "__rtruediv__()" methods. The floor division
operation can be customized using the special "__floordiv__()" and
"__rfloordiv__()" methods.

The "%" (modulo) operator yields the remainder from the division of
the first argument by the second.  The numeric arguments are first
converted to a common type.  A zero right argument raises the
"ZeroDivisionError" exception.  The arguments may be floating-point
numbers, e.g., "3.14%0.7" equals "0.34" (since "3.14" equals "4*0.7 +
0.34".)  The modulo operator always yields a result with the same sign
as its second operand (or zero); the absolute value of the result is
strictly smaller than the absolute value of the second operand [1].

The floor division and modulo operators are connected by the following
identity: "x == (x//y)*y + (x%y)".  Floor division and modulo are also
connected with the built-in function "divmod()": "divmod(x, y) ==
(x//y, x%y)". [2].

In addition to performing the modulo operation on numbers, the "%"
operator is also overloaded by string objects to perform old-style
string formatting (also known as interpolation).  The syntax for
string formatting is described in the Python Library Reference,
section printf-style String Formatting.

The *modulo* operation can be customized using the special "__mod__()"
and "__rmod__()" methods.

The floor division operator, the modulo operator, and the "divmod()"
function are not defined for complex numbers.  Instead, convert to a
floating-point number using the "abs()" function if appropriate.

The "+" (addition) operator yields the sum of its arguments.  The
arguments must either both be numbers or both be sequences of the same
type.  In the former case, the numbers are converted to a common type
and then added together. In the latter case, the sequences are
concatenated.

This operation can be customized using the special "__add__()" and
"__radd__()" methods.

The "-" (subtraction) operator yields the difference of its arguments.
The numeric arguments are first converted to a common type.

This operation can be customized using the special "__sub__()" and
"__rsub__()" methods.
''',
    'bitwise': r'''Binary bitwise operations
*************************

Each of the three bitwise operations has a different priority level:

   and_expr ::= shift_expr | and_expr "&" shift_expr
   xor_expr ::= and_expr | xor_expr "^" and_expr
   or_expr  ::= xor_expr | or_expr "|" xor_expr

The "&" operator yields the bitwise AND of its arguments, which must
be integers or one of them must be a custom object overriding
"__and__()" or "__rand__()" special methods.

The "^" operator yields the bitwise XOR (exclusive OR) of its
arguments, which must be integers or one of them must be a custom
object overriding "__xor__()" or "__rxor__()" special methods.

The "|" operator yields the bitwise (inclusive) OR of its arguments,
which must be integers or one of them must be a custom object
overriding "__or__()" or "__ror__()" special methods.
''',
    'bltin-code-objects': r'''Code Objects
************

Code objects are used by the implementation to represent “pseudo-
compiled” executable Python code such as a function body. They differ
from function objects because they don’t contain a reference to their
global execution environment.  Code objects are returned by the built-
in "compile()" function and can be extracted from function objects
through their "__code__" attribute. See also the "code" module.

Accessing "__code__" raises an auditing event "object.__getattr__"
with arguments "obj" and ""__code__"".

A code object can be executed or evaluated by passing it (instead of a
source string) to the "exec()" or "eval()"  built-in functions.

See The standard type hierarchy for more information.
''',
    'bltin-ellipsis-object': r'''The Ellipsis Object
*******************

This object is commonly used by slicing (see Slicings).  It supports
no special operations.  There is exactly one ellipsis object, named
"Ellipsis" (a built-in name).  "type(Ellipsis)()" produces the
"Ellipsis" singleton.

It is written as "Ellipsis" or "...".
''',
    'bltin-null-object': r'''The Null Object
***************

This object is returned by functions that don’t explicitly return a
value.  It supports no special operations.  There is exactly one null
object, named "None" (a built-in name).  "type(None)()" produces the
same singleton.

It is written as "None".
''',
    'bltin-type-objects': r'''Type Objects
************

Type objects represent the various object types.  An object’s type is
accessed by the built-in function "type()".  There are no special
operations on types.  The standard module "types" defines names for
all standard built-in types.

Types are written like this: "<class 'int'>".
''',
    'booleans': r'''Boolean operations
******************

   or_test  ::= and_test | or_test "or" and_test
   and_test ::= not_test | and_test "and" not_test
   not_test ::= comparison | "not" not_test

In the context of Boolean operations, and also when expressions are
used by control flow statements, the following values are interpreted
as false: "False", "None", numeric zero of all types, and empty
strings and containers (including strings, tuples, lists,
dictionaries, sets and frozensets).  All other values are interpreted
as true.  User-defined objects can customize their truth value by
providing a "__bool__()" method.

The operator "not" yields "True" if its argument is false, "False"
otherwise.

The expression "x and y" first evaluates *x*; if *x* is false, its
value is returned; otherwise, *y* is evaluated and the resulting value
is returned.

The expression "x or y" first evaluates *x*; if *x* is true, its value
is returned; otherwise, *y* is evaluated and the resulting value is
returned.

Note that neither "and" nor "or" restrict the value and type they
return to "False" and "True", but rather return the last evaluated
argument.  This is sometimes useful, e.g., if "s" is a string that
should be replaced by a default value if it is empty, the expression
"s or 'foo'" yields the desired value.  Because "not" has to create a
new value, it returns a boolean value regardless of the type of its
argument (for example, "not 'foo'" produces "False" rather than "''".)
''',
    'break': r'''The "break" statement
*********************

   break_stmt ::= "break"

"break" may only occur syntactically nested in a "for" or "while"
loop, but not nested in a function or class definition within that
loop.

It terminates the nearest enclosing loop, skipping the optional "else"
clause if the loop has one.

If a "for" loop is terminated by "break", the loop control target
keeps its current value.

When "break" passes control out of a "try" statement with a "finally"
clause, that "finally" clause is executed before really leaving the
loop.
''',
    'callable-types': r'''Emulating callable objects
**************************

object.__call__(self[, args...])

   Called when the instance is “called” as a function; if this method
   is defined, "x(arg1, arg2, ...)" roughly translates to
   "type(x).__call__(x, arg1, ...)". The "object" class itself does
   not provide this method.
''',
    'calls': r'''Calls
*****

A call calls a callable object (e.g., a *function*) with a possibly
empty series of *arguments*:

   call                 ::= primary "(" [argument_list [","] | comprehension] ")"
   argument_list        ::= positional_arguments ["," starred_and_keywords]
                            ["," keywords_arguments]
                            | starred_and_keywords ["," keywords_arguments]
                            | keywords_arguments
   positional_arguments ::= positional_item ("," positional_item)*
   positional_item      ::= assignment_expression | "*" expression
   starred_and_keywords ::= ("*" expression | keyword_item)
                            ("," "*" expression | "," keyword_item)*
   keywords_arguments   ::= (keyword_item | "**" expression)
                            ("," keyword_item | "," "**" expression)*
   keyword_item         ::= identifier "=" expression

An optional trailing comma may be present after the positional and
keyword arguments but does not affect the semantics.

The primary must evaluate to a callable object (user-defined
functions, built-in functions, methods of built-in objects, class
objects, methods of class instances, and all objects having a
"__call__()" method are callable).  All argument expressions are
evaluated before the call is attempted.  Please refer to section
Function definitions for the syntax of formal *parameter* lists.

If keyword arguments are present, they are first converted to
positional arguments, as follows.  First, a list of unfilled slots is
created for the formal parameters.  If there are N positional
arguments, they are placed in the first N slots.  Next, for each
keyword argument, the identifier is used to determine the
corresponding slot (if the identifier is the same as the first formal
parameter name, the first slot is used, and so on).  If the slot is
already filled, a "TypeError" exception is raised. Otherwise, the
argument is placed in the slot, filling it (even if the expression is
"None", it fills the slot).  When all arguments have been processed,
the slots that are still unfilled are filled with the corresponding
default value from the function definition.  (Default values are
calculated, once, when the function is defined; thus, a mutable object
such as a list or dictionary used as default value will be shared by
all calls that don’t specify an argument value for the corresponding
slot; this should usually be avoided.)  If there are any unfilled
slots for which no default value is specified, a "TypeError" exception
is raised.  Otherwise, the list of filled slots is used as the
argument list for the call.

**CPython implementation detail:** An implementation may provide
built-in functions whose positional parameters do not have names, even
if they are ‘named’ for the purpose of documentation, and which
therefore cannot be supplied by keyword.  In CPython, this is the case
for functions implemented in C that use "PyArg_ParseTuple()" to parse
their arguments.

If there are more positional arguments than there are formal parameter
slots, a "TypeError" exception is raised, unless a formal parameter
using the syntax "*identifier" is present; in this case, that formal
parameter receives a tuple containing the excess positional arguments
(or an empty tuple if there were no excess positional arguments).

If any keyword argument does not correspond to a formal parameter
name, a "TypeError" exception is raised, unless a formal parameter
using the syntax "**identifier" is present; in this case, that formal
parameter receives a dictionary containing the excess keyword
arguments (using the keywords as keys and the argument values as
corresponding values), or a (new) empty dictionary if there were no
excess keyword arguments.

If the syntax "*expression" appears in the function call, "expression"
must evaluate to an *iterable*.  Elements from these iterables are
treated as if they were additional positional arguments.  For the call
"f(x1, x2, *y, x3, x4)", if *y* evaluates to a sequence *y1*, …, *yM*,
this is equivalent to a call with M+4 positional arguments *x1*, *x2*,
*y1*, …, *yM*, *x3*, *x4*.

A consequence of this is that although the "*expression" syntax may
appear *after* explicit keyword arguments, it is processed *before*
the keyword arguments (and any "**expression" arguments – see below).
So:

   >>> def f(a, b):
   ...     print(a, b)
   ...
   >>> f(b=1, *(2,))
   2 1
   >>> f(a=1, *(2,))
   Traceback (most recent call last):
     File "<stdin>", line 1, in <module>
   TypeError: f() got multiple values for keyword argument 'a'
   >>> f(1, *(2,))
   1 2

It is unusual for both keyword arguments and the "*expression" syntax
to be used in the same call, so in practice this confusion does not
often arise.

If the syntax "**expression" appears in the function call,
"expression" must evaluate to a *mapping*, the contents of which are
treated as additional keyword arguments. If a parameter matching a key
has already been given a value (by an explicit keyword argument, or
from another unpacking), a "TypeError" exception is raised.

When "**expression" is used, each key in this mapping must be a
string. Each value from the mapping is assigned to the first formal
parameter eligible for keyword assignment whose name is equal to the
key. A key need not be a Python identifier (e.g. ""max-temp °F"" is
acceptable, although it will not match any formal parameter that could
be declared). If there is no match to a formal parameter the key-value
pair is collected by the "**" parameter, if there is one, or if there
is not, a "TypeError" exception is raised.

Formal parameters using the syntax "*identifier" or "**identifier"
cannot be used as positional argument slots or as keyword argument
names.

Changed in version 3.5: Function calls accept any number of "*" and
"**" unpackings, positional arguments may follow iterable unpackings
("*"), and keyword arguments may follow dictionary unpackings ("**").
Originally proposed by **PEP 448**.

A call always returns some value, possibly "None", unless it raises an
exception.  How this value is computed depends on the type of the
callable object.

If it is—

a user-defined function:
   The code block for the function is executed, passing it the
   argument list.  The first thing the code block will do is bind the
   formal parameters to the arguments; this is described in section
   Function definitions.  When the code block executes a "return"
   statement, this specifies the return value of the function call.
   If execution reaches the end of the code block without executing a
   "return" statement, the return value is "None".

a built-in function or method:
   The result is up to the interpreter; see Built-in Functions for the
   descriptions of built-in functions and methods.

a class object:
   A new instance of that class is returned.

a class instance method:
   The corresponding user-defined function is called, with an argument
   list that is one longer than the argument list of the call: the
   instance becomes the first argument.

a class instance:
   The class must define a "__call__()" method; the effect is then the
   same as if that method was called.
''',
    'class': r'''Class definitions
*****************

A class definition defines a class object (see section The standard
type hierarchy):

   classdef    ::= [decorators] "class" classname [type_params] [inheritance] ":" suite
   inheritance ::= "(" [argument_list] ")"
   classname   ::= identifier

A class definition is an executable statement.  The inheritance list
usually gives a list of base classes (see Metaclasses for more
advanced uses), so each item in the list should evaluate to a class
object which allows subclassing.  Classes without an inheritance list
inherit, by default, from the base class "object"; hence,

   class Foo:
       pass

is equivalent to

   class Foo(object):
       pass

The class’s suite is then executed in a new execution frame (see
Naming and binding), using a newly created local namespace and the
original global namespace. (Usually, the suite contains mostly
function definitions.)  When the class’s suite finishes execution, its
execution frame is discarded but its local namespace is saved. [5] A
class object is then created using the inheritance list for the base
classes and the saved local namespace for the attribute dictionary.
The class name is bound to this class object in the original local
namespace.

The order in which attributes are defined in the class body is
preserved in the new class’s "__dict__".  Note that this is reliable
only right after the class is created and only for classes that were
defined using the definition syntax.

Class creation can be customized heavily using metaclasses.

Classes can also be decorated: just like when decorating functions,

   @f1(arg)
   @f2
   class Foo: pass

is roughly equivalent to

   class Foo: pass
   Foo = f1(arg)(f2(Foo))

The evaluation rules for the decorator expressions are the same as for
function decorators.  The result is then bound to the class name.

Changed in version 3.9: Classes may be decorated with any valid
"assignment_expression". Previously, the grammar was much more
restrictive; see **PEP 614** for details.

A list of type parameters may be given in square brackets immediately
after the class’s name. This indicates to static type checkers that
the class is generic. At runtime, the type parameters can be retrieved
from the class’s "__type_params__" attribute. See Generic classes for
more.

Changed in version 3.12: Type parameter lists are new in Python 3.12.

**Programmer’s note:** Variables defined in the class definition are
class attributes; they are shared by instances.  Instance attributes
can be set in a method with "self.name = value".  Both class and
instance attributes are accessible through the notation “"self.name"”,
and an instance attribute hides a class attribute with the same name
when accessed in this way.  Class attributes can be used as defaults
for instance attributes, but using mutable values there can lead to
unexpected results.  Descriptors can be used to create instance
variables with different implementation details.

See also:

  **PEP 3115** - Metaclasses in Python 3000
     The proposal that changed the declaration of metaclasses to the
     current syntax, and the semantics for how classes with
     metaclasses are constructed.

  **PEP 3129** - Class Decorators
     The proposal that added class decorators.  Function and method
     decorators were introduced in **PEP 318**.
''',
    'comparisons': r'''Comparisons
***********

Unlike C, all comparison operations in Python have the same priority,
which is lower than that of any arithmetic, shifting or bitwise
operation.  Also unlike C, expressions like "a < b < c" have the
interpretation that is conventional in mathematics:

   comparison    ::= or_expr (comp_operator or_expr)*
   comp_operator ::= "<" | ">" | "==" | ">=" | "<=" | "!="
                     | "is" ["not"] | ["not"] "in"

Comparisons yield boolean values: "True" or "False". Custom *rich
comparison methods* may return non-boolean values. In this case Python
will call "bool()" on such value in boolean contexts.

Comparisons can be chained arbitrarily, e.g., "x < y <= z" is
equivalent to "x < y and y <= z", except that "y" is evaluated only
once (but in both cases "z" is not evaluated at all when "x < y" is
found to be false).

Formally, if *a*, *b*, *c*, …, *y*, *z* are expressions and *op1*,
*op2*, …, *opN* are comparison operators, then "a op1 b op2 c ... y
opN z" is equivalent to "a op1 b and b op2 c and ... y opN z", except
that each expression is evaluated at most once.

Note that "a op1 b op2 c" doesn’t imply any kind of comparison between
*a* and *c*, so that, e.g., "x < y > z" is perfectly legal (though
perhaps not pretty).


Value comparisons
=================

The operators "<", ">", "==", ">=", "<=", and "!=" compare the values
of two objects.  The objects do not need to have the same type.

Chapter Objects, values and types states that objects have a value (in
addition to type and identity).  The value of an object is a rather
abstract notion in Python: For example, there is no canonical access
method for an object’s value.  Also, there is no requirement that the
value of an object should be constructed in a particular way, e.g.
comprised of all its data attributes. Comparison operators implement a
particular notion of what the value of an object is.  One can think of
them as defining the value of an object indirectly, by means of their
comparison implementation.

Because all types are (direct or indirect) subtypes of "object", they
inherit the default comparison behavior from "object".  Types can
customize their comparison behavior by implementing *rich comparison
methods* like "__lt__()", described in Basic customization.

The default behavior for equality comparison ("==" and "!=") is based
on the identity of the objects.  Hence, equality comparison of
instances with the same identity results in equality, and equality
comparison of instances with different identities results in
inequality.  A motivation for this default behavior is the desire that
all objects should be reflexive (i.e. "x is y" implies "x == y").

A default order comparison ("<", ">", "<=", and ">=") is not provided;
an attempt raises "TypeError".  A motivation for this default behavior
is the lack of a similar invariant as for equality.

The behavior of the default equality comparison, that instances with
different identities are always unequal, may be in contrast to what
types will need that have a sensible definition of object value and
value-based equality.  Such types will need to customize their
comparison behavior, and in fact, a number of built-in types have done
that.

The following list describes the comparison behavior of the most
important built-in types.

* Numbers of built-in numeric types (Numeric Types — int, float,
  complex) and of the standard library types "fractions.Fraction" and
  "decimal.Decimal" can be compared within and across their types,
  with the restriction that complex numbers do not support order
  comparison.  Within the limits of the types involved, they compare
  mathematically (algorithmically) correct without loss of precision.

  The not-a-number values "float('NaN')" and "decimal.Decimal('NaN')"
  are special.  Any ordered comparison of a number to a not-a-number
  value is false. A counter-intuitive implication is that not-a-number
  values are not equal to themselves.  For example, if "x =
  float('NaN')", "3 < x", "x < 3" and "x == x" are all false, while "x
  != x" is true.  This behavior is compliant with IEEE 754.

* "None" and "NotImplemented" are singletons.  **PEP 8** advises that
  comparisons for singletons should always be done with "is" or "is
  not", never the equality operators.

* Binary sequences (instances of "bytes" or "bytearray") can be
  compared within and across their types.  They compare
  lexicographically using the numeric values of their elements.

* Strings (instances of "str") compare lexicographically using the
  numerical Unicode code points (the result of the built-in function
  "ord()") of their characters. [3]

  Strings and binary sequences cannot be directly compared.

* Sequences (instances of "tuple", "list", or "range") can be compared
  only within each of their types, with the restriction that ranges do
  not support order comparison.  Equality comparison across these
  types results in inequality, and ordering comparison across these
  types raises "TypeError".

  Sequences compare lexicographically using comparison of
  corresponding elements.  The built-in containers typically assume
  identical objects are equal to themselves.  That lets them bypass
  equality tests for identical objects to improve performance and to
  maintain their internal invariants.

  Lexicographical comparison between built-in collections works as
  follows:

  * For two collections to compare equal, they must be of the same
    type, have the same length, and each pair of corresponding
    elements must compare equal (for example, "[1,2] == (1,2)" is
    false because the type is not the same).

  * Collections that support order comparison are ordered the same as
    their first unequal elements (for example, "[1,2,x] <= [1,2,y]"
    has the same value as "x <= y").  If a corresponding element does
    not exist, the shorter collection is ordered first (for example,
    "[1,2] < [1,2,3]" is true).

* Mappings (instances of "dict") compare equal if and only if they
  have equal "(key, value)" pairs. Equality comparison of the keys and
  values enforces reflexivity.

  Order comparisons ("<", ">", "<=", and ">=") raise "TypeError".

* Sets (instances of "set" or "frozenset") can be compared within and
  across their types.

  They define order comparison operators to mean subset and superset
  tests.  Those relations do not define total orderings (for example,
  the two sets "{1,2}" and "{2,3}" are not equal, nor subsets of one
  another, nor supersets of one another).  Accordingly, sets are not
  appropriate arguments for functions which depend on total ordering
  (for example, "min()", "max()", and "sorted()" produce undefined
  results given a list of sets as inputs).

  Comparison of sets enforces reflexivity of its elements.

* Most other built-in types have no comparison methods implemented, so
  they inherit the default comparison behavior.

User-defined classes that customize their comparison behavior should
follow some consistency rules, if possible:

* Equality comparison should be reflexive. In other words, identical
  objects should compare equal:

     "x is y" implies "x == y"

* Comparison should be symmetric. In other words, the following
  expressions should have the same result:

     "x == y" and "y == x"

     "x != y" and "y != x"

     "x < y" and "y > x"

     "x <= y" and "y >= x"

* Comparison should be transitive. The following (non-exhaustive)
  examples illustrate that:

     "x > y and y > z" implies "x > z"

     "x < y and y <= z" implies "x < z"

* Inverse comparison should result in the boolean negation. In other
  words, the following expressions should have the same result:

     "x == y" and "not x != y"

     "x < y" and "not x >= y" (for total ordering)

     "x > y" and "not x <= y" (for total ordering)

  The last two expressions apply to totally ordered collections (e.g.
  to sequences, but not to sets or mappings). See also the
  "total_ordering()" decorator.

* The "hash()" result should be consistent with equality. Objects that
  are equal should either have the same hash value, or be marked as
  unhashable.

Python does not enforce these consistency rules. In fact, the
not-a-number values are an example for not following these rules.


Membership test operations
==========================

The operators "in" and "not in" test for membership.  "x in s"
evaluates to "True" if *x* is a member of *s*, and "False" otherwise.
"x not in s" returns the negation of "x in s".  All built-in sequences
and set types support this as well as dictionary, for which "in" tests
whether the dictionary has a given key. For container types such as
list, tuple, set, frozenset, dict, or collections.deque, the
expression "x in y" is equivalent to "any(x is e or x == e for e in
y)".

For the string and bytes types, "x in y" is "True" if and only if *x*
is a substring of *y*.  An equivalent test is "y.find(x) != -1".
Empty strings are always considered to be a substring of any other
string, so """ in "abc"" will return "True".

For user-defined classes which define the "__contains__()" method, "x
in y" returns "True" if "y.__contains__(x)" returns a true value, and
"False" otherwise.

For user-defined classes which do not define "__contains__()" but do
define "__iter__()", "x in y" is "True" if some value "z", for which
the expression "x is z or x == z" is true, is produced while iterating
over "y". If an exception is raised during the iteration, it is as if
"in" raised that exception.

Lastly, the old-style iteration protocol is tried: if a class defines
"__getitem__()", "x in y" is "True" if and only if there is a non-
negative integer index *i* such that "x is y[i] or x == y[i]", and no
lower integer index raises the "IndexError" exception.  (If any other
exception is raised, it is as if "in" raised that exception).

The operator "not in" is defined to have the inverse truth value of
"in".


Identity comparisons
====================

The operators "is" and "is not" test for an object’s identity: "x is
y" is true if and only if *x* and *y* are the same object.  An
Object’s identity is determined using the "id()" function.  "x is not
y" yields the inverse truth value. [4]
''',
    'compound': r'''Compound statements
*******************

Compound statements contain (groups of) other statements; they affect
or control the execution of those other statements in some way.  In
general, compound statements span multiple lines, although in simple
incarnations a whole compound statement may be contained in one line.

The "if", "while" and "for" statements implement traditional control
flow constructs.  "try" specifies exception handlers and/or cleanup
code for a group of statements, while the "with" statement allows the
execution of initialization and finalization code around a block of
code.  Function and class definitions are also syntactically compound
statements.

A compound statement consists of one or more ‘clauses.’  A clause
consists of a header and a ‘suite.’  The clause headers of a
particular compound statement are all at the same indentation level.
Each clause header begins with a uniquely identifying keyword and ends
with a colon.  A suite is a group of statements controlled by a
clause.  A suite can be one or more semicolon-separated simple
statements on the same line as the header, following the header’s
colon, or it can be one or more indented statements on subsequent
lines.  Only the latter form of a suite can contain nested compound
statements; the following is illegal, mostly because it wouldn’t be
clear to which "if" clause a following "else" clause would belong:

   if test1: if test2: print(x)

Also note that the semicolon binds tighter than the colon in this
context, so that in the following example, either all or none of the
"print()" calls are executed:

   if x < y < z: print(x); print(y); print(z)

Summarizing:

   compound_stmt ::= if_stmt
                     | while_stmt
                     | for_stmt
                     | try_stmt
                     | with_stmt
                     | match_stmt
                     | funcdef
                     | classdef
                     | async_with_stmt
                     | async_for_stmt
                     | async_funcdef
   suite         ::= stmt_list NEWLINE | NEWLINE INDENT statement+ DEDENT
   statement     ::= stmt_list NEWLINE | compound_stmt
   stmt_list     ::= simple_stmt (";" simple_stmt)* [";"]

Note that statements always end in a "NEWLINE" possibly followed by a
"DEDENT".  Also note that optional continuation clauses always begin
with a keyword that cannot start a statement, thus there are no
ambiguities (the ‘dangling "else"’ problem is solved in Python by
requiring nested "if" statements to be indented).

The formatting of the grammar rules in the following sections places
each clause on a separate line for clarity.


The "if" statement
==================

The "if" statement is used for conditional execution:

   if_stmt ::= "if" assignment_expression ":" suite
               ("elif" assignment_expression ":" suite)*
               ["else" ":" suite]

It selects exactly one of the suites by evaluating the expressions one
by one until one is found to be true (see section Boolean operations
for the definition of true and false); then that suite is executed
(and no other part of the "if" statement is executed or evaluated).
If all expressions are false, the suite of the "else" clause, if
present, is executed.


The "while" statement
=====================

The "while" statement is used for repeated execution as long as an
expression is true:

   while_stmt ::= "while" assignment_expression ":" suite
                  ["else" ":" suite]

This repeatedly tests the expression and, if it is true, executes the
first suite; if the expression is false (which may be the first time
it is tested) the suite of the "else" clause, if present, is executed
and the loop terminates.

A "break" statement executed in the first suite terminates the loop
without executing the "else" clause’s suite.  A "continue" statement
executed in the first suite skips the rest of the suite and goes back
to testing the expression.


The "for" statement
===================

The "for" statement is used to iterate over the elements of a sequence
(such as a string, tuple or list) or other iterable object:

   for_stmt ::= "for" target_list "in" starred_list ":" suite
                ["else" ":" suite]

The "starred_list" expression is evaluated once; it should yield an
*iterable* object.  An *iterator* is created for that iterable. The
first item provided by the iterator is then assigned to the target
list using the standard rules for assignments (see Assignment
statements), and the suite is executed.  This repeats for each item
provided by the iterator.  When the iterator is exhausted, the suite
in the "else" clause, if present, is executed, and the loop
terminates.

A "break" statement executed in the first suite terminates the loop
without executing the "else" clause’s suite.  A "continue" statement
executed in the first suite skips the rest of the suite and continues
with the next item, or with the "else" clause if there is no next
item.

The for-loop makes assignments to the variables in the target list.
This overwrites all previous assignments to those variables including
those made in the suite of the for-loop:

   for i in range(10):
       print(i)
       i = 5             # this will not affect the for-loop
                         # because i will be overwritten with the next
                         # index in the range

Names in the target list are not deleted when the loop is finished,
but if the sequence is empty, they will not have been assigned to at
all by the loop.  Hint: the built-in type "range()" represents
immutable arithmetic sequences of integers. For instance, iterating
"range(3)" successively yields 0, 1, and then 2.

Changed in version 3.11: Starred elements are now allowed in the
expression list.


The "try" statement
===================

The "try" statement specifies exception handlers and/or cleanup code
for a group of statements:

   try_stmt  ::= try1_stmt | try2_stmt | try3_stmt
   try1_stmt ::= "try" ":" suite
                 ("except" [expression ["as" identifier]] ":" suite)+
                 ["else" ":" suite]
                 ["finally" ":" suite]
   try2_stmt ::= "try" ":" suite
                 ("except" "*" expression ["as" identifier] ":" suite)+
                 ["else" ":" suite]
                 ["finally" ":" suite]
   try3_stmt ::= "try" ":" suite
                 "finally" ":" suite

Additional information on exceptions can be found in section
Exceptions, and information on using the "raise" statement to generate
exceptions may be found in section The raise statement.


"except" clause
---------------

The "except" clause(s) specify one or more exception handlers. When no
exception occurs in the "try" clause, no exception handler is
executed. When an exception occurs in the "try" suite, a search for an
exception handler is started. This search inspects the "except"
clauses in turn until one is found that matches the exception. An
expression-less "except" clause, if present, must be last; it matches
any exception.

For an "except" clause with an expression, the expression must
evaluate to an exception type or a tuple of exception types. The
raised exception matches an "except" clause whose expression evaluates
to the class or a *non-virtual base class* of the exception object, or
to a tuple that contains such a class.

If no "except" clause matches the exception, the search for an
exception handler continues in the surrounding code and on the
invocation stack.  [1]

If the evaluation of an expression in the header of an "except" clause
raises an exception, the original search for a handler is canceled and
a search starts for the new exception in the surrounding code and on
the call stack (it is treated as if the entire "try" statement raised
the exception).

When a matching "except" clause is found, the exception is assigned to
the target specified after the "as" keyword in that "except" clause,
if present, and the "except" clause’s suite is executed. All "except"
clauses must have an executable block. When the end of this block is
reached, execution continues normally after the entire "try"
statement. (This means that if two nested handlers exist for the same
exception, and the exception occurs in the "try" clause of the inner
handler, the outer handler will not handle the exception.)

When an exception has been assigned using "as target", it is cleared
at the end of the "except" clause.  This is as if

   except E as N:
       foo

was translated to

   except E as N:
       try:
           foo
       finally:
           del N

This means the exception must be assigned to a different name to be
able to refer to it after the "except" clause. Exceptions are cleared
because with the traceback attached to them, they form a reference
cycle with the stack frame, keeping all locals in that frame alive
until the next garbage collection occurs.

Before an "except" clause’s suite is executed, the exception is stored
in the "sys" module, where it can be accessed from within the body of
the "except" clause by calling "sys.exception()". When leaving an
exception handler, the exception stored in the "sys" module is reset
to its previous value:

   >>> print(sys.exception())
   None
   >>> try:
   ...     raise TypeError
   ... except:
   ...     print(repr(sys.exception()))
   ...     try:
   ...          raise ValueError
   ...     except:
   ...         print(repr(sys.exception()))
   ...     print(repr(sys.exception()))
   ...
   TypeError()
   ValueError()
   TypeError()
   >>> print(sys.exception())
   None


"except*" clause
----------------

The "except*" clause(s) are used for handling "ExceptionGroup"s. The
exception type for matching is interpreted as in the case of "except",
but in the case of exception groups we can have partial matches when
the type matches some of the exceptions in the group. This means that
multiple "except*" clauses can execute, each handling part of the
exception group. Each clause executes at most once and handles an
exception group of all matching exceptions.  Each exception in the
group is handled by at most one "except*" clause, the first that
matches it.

   >>> try:
   ...     raise ExceptionGroup("eg",
   ...         [ValueError(1), TypeError(2), OSError(3), OSError(4)])
   ... except* TypeError as e:
   ...     print(f'caught {type(e)} with nested {e.exceptions}')
   ... except* OSError as e:
   ...     print(f'caught {type(e)} with nested {e.exceptions}')
   ...
   caught <class 'ExceptionGroup'> with nested (TypeError(2),)
   caught <class 'ExceptionGroup'> with nested (OSError(3), OSError(4))
     + Exception Group Traceback (most recent call last):
     |   File "<stdin>", line 2, in <module>
     | ExceptionGroup: eg
     +-+---------------- 1 ----------------
       | ValueError: 1
       +------------------------------------

Any remaining exceptions that were not handled by any "except*" clause
are re-raised at the end, along with all exceptions that were raised
from within the "except*" clauses. If this list contains more than one
exception to reraise, they are combined into an exception group.

If the raised exception is not an exception group and its type matches
one of the "except*" clauses, it is caught and wrapped by an exception
group with an empty message string.

   >>> try:
   ...     raise BlockingIOError
   ... except* BlockingIOError as e:
   ...     print(repr(e))
   ...
   ExceptionGroup('', (BlockingIOError()))

An "except*" clause must have a matching expression; it cannot be
"except*:". Furthermore, this expression cannot contain exception
group types, because that would have ambiguous semantics.

It is not possible to mix "except" and "except*" in the same "try".
"break", "continue" and "return" cannot appear in an "except*" clause.


"else" clause
-------------

The optional "else" clause is executed if the control flow leaves the
"try" suite, no exception was raised, and no "return", "continue", or
"break" statement was executed.  Exceptions in the "else" clause are
not handled by the preceding "except" clauses.


"finally" clause
----------------

If "finally" is present, it specifies a ‘cleanup’ handler.  The "try"
clause is executed, including any "except" and "else" clauses.  If an
exception occurs in any of the clauses and is not handled, the
exception is temporarily saved. The "finally" clause is executed.  If
there is a saved exception it is re-raised at the end of the "finally"
clause.  If the "finally" clause raises another exception, the saved
exception is set as the context of the new exception. If the "finally"
clause executes a "return", "break" or "continue" statement, the saved
exception is discarded:

   >>> def f():
   ...     try:
   ...         1/0
   ...     finally:
   ...         return 42
   ...
   >>> f()
   42

The exception information is not available to the program during
execution of the "finally" clause.

When a "return", "break" or "continue" statement is executed in the
"try" suite of a "try"…"finally" statement, the "finally" clause is
also executed ‘on the way out.’

The return value of a function is determined by the last "return"
statement executed.  Since the "finally" clause always executes, a
"return" statement executed in the "finally" clause will always be the
last one executed:

   >>> def foo():
   ...     try:
   ...         return 'try'
   ...     finally:
   ...         return 'finally'
   ...
   >>> foo()
   'finally'

Changed in version 3.8: Prior to Python 3.8, a "continue" statement
was illegal in the "finally" clause due to a problem with the
implementation.


The "with" statement
====================

The "with" statement is used to wrap the execution of a block with
methods defined by a context manager (see section With Statement
Context Managers). This allows common "try"…"except"…"finally" usage
patterns to be encapsulated for convenient reuse.

   with_stmt          ::= "with" ( "(" with_stmt_contents ","? ")" | with_stmt_contents ) ":" suite
   with_stmt_contents ::= with_item ("," with_item)*
   with_item          ::= expression ["as" target]

The execution of the "with" statement with one “item” proceeds as
follows:

1. The context expression (the expression given in the "with_item") is
   evaluated to obtain a context manager.

2. The context manager’s "__enter__()" is loaded for later use.

3. The context manager’s "__exit__()" is loaded for later use.

4. The context manager’s "__enter__()" method is invoked.

5. If a target was included in the "with" statement, the return value
   from "__enter__()" is assigned to it.

   Note:

     The "with" statement guarantees that if the "__enter__()" method
     returns without an error, then "__exit__()" will always be
     called. Thus, if an error occurs during the assignment to the
     target list, it will be treated the same as an error occurring
     within the suite would be. See step 7 below.

6. The suite is executed.

7. The context manager’s "__exit__()" method is invoked.  If an
   exception caused the suite to be exited, its type, value, and
   traceback are passed as arguments to "__exit__()". Otherwise, three
   "None" arguments are supplied.

   If the suite was exited due to an exception, and the return value
   from the "__exit__()" method was false, the exception is reraised.
   If the return value was true, the exception is suppressed, and
   execution continues with the statement following the "with"
   statement.

   If the suite was exited for any reason other than an exception, the
   return value from "__exit__()" is ignored, and execution proceeds
   at the normal location for the kind of exit that was taken.

The following code:

   with EXPRESSION as TARGET:
       SUITE

is semantically equivalent to:

   manager = (EXPRESSION)
   enter = type(manager).__enter__
   exit = type(manager).__exit__
   value = enter(manager)
   hit_except = False

   try:
       TARGET = value
       SUITE
   except:
       hit_except = True
       if not exit(manager, *sys.exc_info()):
           raise
   finally:
       if not hit_except:
           exit(manager, None, None, None)

With more than one item, the context managers are processed as if
multiple "with" statements were nested:

   with A() as a, B() as b:
       SUITE

is semantically equivalent to:

   with A() as a:
       with B() as b:
           SUITE

You can also write multi-item context managers in multiple lines if
the items are surrounded by parentheses. For example:

   with (
       A() as a,
       B() as b,
   ):
       SUITE

Changed in version 3.1: Support for multiple context expressions.

Changed in version 3.10: Support for using grouping parentheses to
break the statement in multiple lines.

See also:

  **PEP 343** - The “with” statement
     The specification, background, and examples for the Python "with"
     statement.


The "match" statement
=====================

Added in version 3.10.

The match statement is used for pattern matching.  Syntax:

   match_stmt   ::= 'match' subject_expr ":" NEWLINE INDENT case_block+ DEDENT
   subject_expr ::= star_named_expression "," star_named_expressions?
                    | named_expression
   case_block   ::= 'case' patterns [guard] ":" block

Note:

  This section uses single quotes to denote soft keywords.

Pattern matching takes a pattern as input (following "case") and a
subject value (following "match").  The pattern (which may contain
subpatterns) is matched against the subject value.  The outcomes are:

* A match success or failure (also termed a pattern success or
  failure).

* Possible binding of matched values to a name.  The prerequisites for
  this are further discussed below.

The "match" and "case" keywords are soft keywords.

See also:

  * **PEP 634** – Structural Pattern Matching: Specification

  * **PEP 636** – Structural Pattern Matching: Tutorial


Overview
--------

Here’s an overview of the logical flow of a match statement:

1. The subject expression "subject_expr" is evaluated and a resulting
   subject value obtained. If the subject expression contains a comma,
   a tuple is constructed using the standard rules.

2. Each pattern in a "case_block" is attempted to match with the
   subject value. The specific rules for success or failure are
   described below. The match attempt can also bind some or all of the
   standalone names within the pattern. The precise pattern binding
   rules vary per pattern type and are specified below.  **Name
   bindings made during a successful pattern match outlive the
   executed block and can be used after the match statement**.

   Note:

     During failed pattern matches, some subpatterns may succeed.  Do
     not rely on bindings being made for a failed match.  Conversely,
     do not rely on variables remaining unchanged after a failed
     match.  The exact behavior is dependent on implementation and may
     vary.  This is an intentional decision made to allow different
     implementations to add optimizations.

3. If the pattern succeeds, the corresponding guard (if present) is
   evaluated. In this case all name bindings are guaranteed to have
   happened.

   * If the guard evaluates as true or is missing, the "block" inside
     "case_block" is executed.

   * Otherwise, the next "case_block" is attempted as described above.

   * If there are no further case blocks, the match statement is
     completed.

Note:

  Users should generally never rely on a pattern being evaluated.
  Depending on implementation, the interpreter may cache values or use
  other optimizations which skip repeated evaluations.

A sample match statement:

   >>> flag = False
   >>> match (100, 200):
   ...    case (100, 300):  # Mismatch: 200 != 300
   ...        print('Case 1')
   ...    case (100, 200) if flag:  # Successful match, but guard fails
   ...        print('Case 2')
   ...    case (100, y):  # Matches and binds y to 200
   ...        print(f'Case 3, y: {y}')
   ...    case _:  # Pattern not attempted
   ...        print('Case 4, I match anything!')
   ...
   Case 3, y: 200

In this case, "if flag" is a guard.  Read more about that in the next
section.


Guards
------

   guard ::= "if" named_expression

A "guard" (which is part of the "case") must succeed for code inside
the "case" block to execute.  It takes the form: "if" followed by an
expression.

The logical flow of a "case" block with a "guard" follows:

1. Check that the pattern in the "case" block succeeded.  If the
   pattern failed, the "guard" is not evaluated and the next "case"
   block is checked.

2. If the pattern succeeded, evaluate the "guard".

   * If the "guard" condition evaluates as true, the case block is
     selected.

   * If the "guard" condition evaluates as false, the case block is
     not selected.

   * If the "guard" raises an exception during evaluation, the
     exception bubbles up.

Guards are allowed to have side effects as they are expressions.
Guard evaluation must proceed from the first to the last case block,
one at a time, skipping case blocks whose pattern(s) don’t all
succeed. (I.e., guard evaluation must happen in order.) Guard
evaluation must stop once a case block is selected.


Irrefutable Case Blocks
-----------------------

An irrefutable case block is a match-all case block.  A match
statement may have at most one irrefutable case block, and it must be
last.

A case block is considered irrefutable if it has no guard and its
pattern is irrefutable.  A pattern is considered irrefutable if we can
prove from its syntax alone that it will always succeed.  Only the
following patterns are irrefutable:

* AS Patterns whose left-hand side is irrefutable

* OR Patterns containing at least one irrefutable pattern

* Capture Patterns

* Wildcard Patterns

* parenthesized irrefutable patterns


Patterns
--------

Note:

  This section uses grammar notations beyond standard EBNF:

  * the notation "SEP.RULE+" is shorthand for "RULE (SEP RULE)*"

  * the notation "!RULE" is shorthand for a negative lookahead
    assertion

The top-level syntax for "patterns" is:

   patterns       ::= open_sequence_pattern | pattern
   pattern        ::= as_pattern | or_pattern
   closed_pattern ::= | literal_pattern
                      | capture_pattern
                      | wildcard_pattern
                      | value_pattern
                      | group_pattern
                      | sequence_pattern
                      | mapping_pattern
                      | class_pattern

The descriptions below will include a description “in simple terms” of
what a pattern does for illustration purposes (credits to Raymond
Hettinger for a document that inspired most of the descriptions). Note
that these descriptions are purely for illustration purposes and **may
not** reflect the underlying implementation.  Furthermore, they do not
cover all valid forms.


OR Patterns
~~~~~~~~~~~

An OR pattern is two or more patterns separated by vertical bars "|".
Syntax:

   or_pattern ::= "|".closed_pattern+

Only the final subpattern may be irrefutable, and each subpattern must
bind the same set of names to avoid ambiguity.

An OR pattern matches each of its subpatterns in turn to the subject
value, until one succeeds.  The OR pattern is then considered
successful.  Otherwise, if none of the subpatterns succeed, the OR
pattern fails.

In simple terms, "P1 | P2 | ..." will try to match "P1", if it fails
it will try to match "P2", succeeding immediately if any succeeds,
failing otherwise.


AS Patterns
~~~~~~~~~~~

An AS pattern matches an OR pattern on the left of the "as" keyword
against a subject.  Syntax:

   as_pattern ::= or_pattern "as" capture_pattern

If the OR pattern fails, the AS pattern fails.  Otherwise, the AS
pattern binds the subject to the name on the right of the as keyword
and succeeds. "capture_pattern" cannot be a "_".

In simple terms "P as NAME" will match with "P", and on success it
will set "NAME = <subject>".


Literal Patterns
~~~~~~~~~~~~~~~~

A literal pattern corresponds to most literals in Python.  Syntax:

   literal_pattern ::= signed_number
                       | signed_number "+" NUMBER
                       | signed_number "-" NUMBER
                       | strings
                       | "None"
                       | "True"
                       | "False"
   signed_number   ::= ["-"] NUMBER

The rule "strings" and the token "NUMBER" are defined in the standard
Python grammar.  Triple-quoted strings are supported.  Raw strings and
byte strings are supported.  f-strings are not supported.

The forms "signed_number '+' NUMBER" and "signed_number '-' NUMBER"
are for expressing complex numbers; they require a real number on the
left and an imaginary number on the right. E.g. "3 + 4j".

In simple terms, "LITERAL" will succeed only if "<subject> ==
LITERAL". For the singletons "None", "True" and "False", the "is"
operator is used.


Capture Patterns
~~~~~~~~~~~~~~~~

A capture pattern binds the subject value to a name. Syntax:

   capture_pattern ::= !'_' NAME

A single underscore "_" is not a capture pattern (this is what "!'_'"
expresses). It is instead treated as a "wildcard_pattern".

In a given pattern, a given name can only be bound once.  E.g. "case
x, x: ..." is invalid while "case [x] | x: ..." is allowed.

Capture patterns always succeed.  The binding follows scoping rules
established by the assignment expression operator in **PEP 572**; the
name becomes a local variable in the closest containing function scope
unless there’s an applicable "global" or "nonlocal" statement.

In simple terms "NAME" will always succeed and it will set "NAME =
<subject>".


Wildcard Patterns
~~~~~~~~~~~~~~~~~

A wildcard pattern always succeeds (matches anything) and binds no
name.  Syntax:

   wildcard_pattern ::= '_'

"_" is a soft keyword within any pattern, but only within patterns.
It is an identifier, as usual, even within "match" subject
expressions, "guard"s, and "case" blocks.

In simple terms, "_" will always succeed.


Value Patterns
~~~~~~~~~~~~~~

A value pattern represents a named value in Python. Syntax:

   value_pattern ::= attr
   attr          ::= name_or_attr "." NAME
   name_or_attr  ::= attr | NAME

The dotted name in the pattern is looked up using standard Python name
resolution rules.  The pattern succeeds if the value found compares
equal to the subject value (using the "==" equality operator).

In simple terms "NAME1.NAME2" will succeed only if "<subject> ==
NAME1.NAME2"

Note:

  If the same value occurs multiple times in the same match statement,
  the interpreter may cache the first value found and reuse it rather
  than repeat the same lookup.  This cache is strictly tied to a given
  execution of a given match statement.


Group Patterns
~~~~~~~~~~~~~~

A group pattern allows users to add parentheses around patterns to
emphasize the intended grouping.  Otherwise, it has no additional
syntax. Syntax:

   group_pattern ::= "(" pattern ")"

In simple terms "(P)" has the same effect as "P".


Sequence Patterns
~~~~~~~~~~~~~~~~~

A sequence pattern contains several subpatterns to be matched against
sequence elements. The syntax is similar to the unpacking of a list or
tuple.

   sequence_pattern       ::= "[" [maybe_sequence_pattern] "]"
                              | "(" [open_sequence_pattern] ")"
   open_sequence_pattern  ::= maybe_star_pattern "," [maybe_sequence_pattern]
   maybe_sequence_pattern ::= ",".maybe_star_pattern+ ","?
   maybe_star_pattern     ::= star_pattern | pattern
   star_pattern           ::= "*" (capture_pattern | wildcard_pattern)

There is no difference if parentheses  or square brackets are used for
sequence patterns (i.e. "(...)" vs "[...]" ).

Note:

  A single pattern enclosed in parentheses without a trailing comma
  (e.g. "(3 | 4)") is a group pattern. While a single pattern enclosed
  in square brackets (e.g. "[3 | 4]") is still a sequence pattern.

At most one star subpattern may be in a sequence pattern.  The star
subpattern may occur in any position. If no star subpattern is
present, the sequence pattern is a fixed-length sequence pattern;
otherwise it is a variable-length sequence pattern.

The following is the logical flow for matching a sequence pattern
against a subject value:

1. If the subject value is not a sequence [2], the sequence pattern
   fails.

2. If the subject value is an instance of "str", "bytes" or
   "bytearray" the sequence pattern fails.

3. The subsequent steps depend on whether the sequence pattern is
   fixed or variable-length.

   If the sequence pattern is fixed-length:

   1. If the length of the subject sequence is not equal to the number
      of subpatterns, the sequence pattern fails

   2. Subpatterns in the sequence pattern are matched to their
      corresponding items in the subject sequence from left to right.
      Matching stops as soon as a subpattern fails.  If all
      subpatterns succeed in matching their corresponding item, the
      sequence pattern succeeds.

   Otherwise, if the sequence pattern is variable-length:

   1. If the length of the subject sequence is less than the number of
      non-star subpatterns, the sequence pattern fails.

   2. The leading non-star subpatterns are matched to their
      corresponding items as for fixed-length sequences.

   3. If the previous step succeeds, the star subpattern matches a
      list formed of the remaining subject items, excluding the
      remaining items corresponding to non-star subpatterns following
      the star subpattern.

   4. Remaining non-star subpatterns are matched to their
      corresponding subject items, as for a fixed-length sequence.

   Note:

     The length of the subject sequence is obtained via "len()" (i.e.
     via the "__len__()" protocol).  This length may be cached by the
     interpreter in a similar manner as value patterns.

In simple terms "[P1, P2, P3," … ", P<N>]" matches only if all the
following happens:

* check "<subject>" is a sequence

* "len(subject) == <N>"

* "P1" matches "<subject>[0]" (note that this match can also bind
  names)

* "P2" matches "<subject>[1]" (note that this match can also bind
  names)

* … and so on for the corresponding pattern/element.


Mapping Patterns
~~~~~~~~~~~~~~~~

A mapping pattern contains one or more key-value patterns.  The syntax
is similar to the construction of a dictionary. Syntax:

   mapping_pattern     ::= "{" [items_pattern] "}"
   items_pattern       ::= ",".key_value_pattern+ ","?
   key_value_pattern   ::= (literal_pattern | value_pattern) ":" pattern
                           | double_star_pattern
   double_star_pattern ::= "**" capture_pattern

At most one double star pattern may be in a mapping pattern.  The
double star pattern must be the last subpattern in the mapping
pattern.

Duplicate keys in mapping patterns are disallowed. Duplicate literal
keys will raise a "SyntaxError". Two keys that otherwise have the same
value will raise a "ValueError" at runtime.

The following is the logical flow for matching a mapping pattern
against a subject value:

1. If the subject value is not a mapping [3],the mapping pattern
   fails.

2. If every key given in the mapping pattern is present in the subject
   mapping, and the pattern for each key matches the corresponding
   item of the subject mapping, the mapping pattern succeeds.

3. If duplicate keys are detected in the mapping pattern, the pattern
   is considered invalid. A "SyntaxError" is raised for duplicate
   literal values; or a "ValueError" for named keys of the same value.

Note:

  Key-value pairs are matched using the two-argument form of the
  mapping subject’s "get()" method.  Matched key-value pairs must
  already be present in the mapping, and not created on-the-fly via
  "__missing__()" or "__getitem__()".

In simple terms "{KEY1: P1, KEY2: P2, ... }" matches only if all the
following happens:

* check "<subject>" is a mapping

* "KEY1 in <subject>"

* "P1" matches "<subject>[KEY1]"

* … and so on for the corresponding KEY/pattern pair.


Class Patterns
~~~~~~~~~~~~~~

A class pattern represents a class and its positional and keyword
arguments (if any).  Syntax:

   class_pattern       ::= name_or_attr "(" [pattern_arguments ","?] ")"
   pattern_arguments   ::= positional_patterns ["," keyword_patterns]
                           | keyword_patterns
   positional_patterns ::= ",".pattern+
   keyword_patterns    ::= ",".keyword_pattern+
   keyword_pattern     ::= NAME "=" pattern

The same keyword should not be repeated in class patterns.

The following is the logical flow for matching a class pattern against
a subject value:

1. If "name_or_attr" is not an instance of the builtin "type" , raise
   "TypeError".

2. If the subject value is not an instance of "name_or_attr" (tested
   via "isinstance()"), the class pattern fails.

3. If no pattern arguments are present, the pattern succeeds.
   Otherwise, the subsequent steps depend on whether keyword or
   positional argument patterns are present.

   For a number of built-in types (specified below), a single
   positional subpattern is accepted which will match the entire
   subject; for these types keyword patterns also work as for other
   types.

   If only keyword patterns are present, they are processed as
   follows, one by one:

   I. The keyword is looked up as an attribute on the subject.

      * If this raises an exception other than "AttributeError", the
        exception bubbles up.

      * If this raises "AttributeError", the class pattern has failed.

      * Else, the subpattern associated with the keyword pattern is
        matched against the subject’s attribute value.  If this fails,
        the class pattern fails; if this succeeds, the match proceeds
        to the next keyword.

   II. If all keyword patterns succeed, the class pattern succeeds.

   If any positional patterns are present, they are converted to
   keyword patterns using the "__match_args__" attribute on the class
   "name_or_attr" before matching:

   I. The equivalent of "getattr(cls, "__match_args__", ())" is
   called.

      * If this raises an exception, the exception bubbles up.

      * If the returned value is not a tuple, the conversion fails and
        "TypeError" is raised.

      * If there are more positional patterns than
        "len(cls.__match_args__)", "TypeError" is raised.

      * Otherwise, positional pattern "i" is converted to a keyword
        pattern using "__match_args__[i]" as the keyword.
        "__match_args__[i]" must be a string; if not "TypeError" is
        raised.

      * If there are duplicate keywords, "TypeError" is raised.

      See also:

        Customizing positional arguments in class pattern matching

   II. Once all positional patterns have been converted to keyword
   patterns,
      the match proceeds as if there were only keyword patterns.

   For the following built-in types the handling of positional
   subpatterns is different:

   * "bool"

   * "bytearray"

   * "bytes"

   * "dict"

   * "float"

   * "frozenset"

   * "int"

   * "list"

   * "set"

   * "str"

   * "tuple"

   These classes accept a single positional argument, and the pattern
   there is matched against the whole object rather than an attribute.
   For example "int(0|1)" matches the value "0", but not the value
   "0.0".

In simple terms "CLS(P1, attr=P2)" matches only if the following
happens:

* "isinstance(<subject>, CLS)"

* convert "P1" to a keyword pattern using "CLS.__match_args__"

* For each keyword argument "attr=P2":

  * "hasattr(<subject>, "attr")"

  * "P2" matches "<subject>.attr"

* … and so on for the corresponding keyword argument/pattern pair.

See also:

  * **PEP 634** – Structural Pattern Matching: Specification

  * **PEP 636** – Structural Pattern Matching: Tutorial


Function definitions
====================

A function definition defines a user-defined function object (see
section The standard type hierarchy):

   funcdef                   ::= [decorators] "def" funcname [type_params] "(" [parameter_list] ")"
                                 ["->" expression] ":" suite
   decorators                ::= decorator+
   decorator                 ::= "@" assignment_expression NEWLINE
   parameter_list            ::= defparameter ("," defparameter)* "," "/" ["," [parameter_list_no_posonly]]
                                 | parameter_list_no_posonly
   parameter_list_no_posonly ::= defparameter ("," defparameter)* ["," [parameter_list_starargs]]
                                 | parameter_list_starargs
   parameter_list_starargs   ::= "*" [star_parameter] ("," defparameter)* ["," [parameter_star_kwargs]]
                                 | "*" ("," defparameter)+ ["," [parameter_star_kwargs]]
                                 | parameter_star_kwargs
   parameter_star_kwargs     ::= "**" parameter [","]
   parameter                 ::= identifier [":" expression]
   star_parameter            ::= identifier [":" ["*"] expression]
   defparameter              ::= parameter ["=" expression]
   funcname                  ::= identifier

A function definition is an executable statement.  Its execution binds
the function name in the current local namespace to a function object
(a wrapper around the executable code for the function).  This
function object contains a reference to the current global namespace
as the global namespace to be used when the function is called.

The function definition does not execute the function body; this gets
executed only when the function is called. [4]

A function definition may be wrapped by one or more *decorator*
expressions. Decorator expressions are evaluated when the function is
defined, in the scope that contains the function definition.  The
result must be a callable, which is invoked with the function object
as the only argument. The returned value is bound to the function name
instead of the function object.  Multiple decorators are applied in
nested fashion. For example, the following code

   @f1(arg)
   @f2
   def func(): pass

is roughly equivalent to

   def func(): pass
   func = f1(arg)(f2(func))

except that the original function is not temporarily bound to the name
"func".

Changed in version 3.9: Functions may be decorated with any valid
"assignment_expression". Previously, the grammar was much more
restrictive; see **PEP 614** for details.

A list of type parameters may be given in square brackets between the
function’s name and the opening parenthesis for its parameter list.
This indicates to static type checkers that the function is generic.
At runtime, the type parameters can be retrieved from the function’s
"__type_params__" attribute. See Generic functions for more.

Changed in version 3.12: Type parameter lists are new in Python 3.12.

When one or more *parameters* have the form *parameter* "="
*expression*, the function is said to have “default parameter values.”
For a parameter with a default value, the corresponding *argument* may
be omitted from a call, in which case the parameter’s default value is
substituted.  If a parameter has a default value, all following
parameters up until the “"*"” must also have a default value — this is
a syntactic restriction that is not expressed by the grammar.

**Default parameter values are evaluated from left to right when the
function definition is executed.** This means that the expression is
evaluated once, when the function is defined, and that the same “pre-
computed” value is used for each call.  This is especially important
to understand when a default parameter value is a mutable object, such
as a list or a dictionary: if the function modifies the object (e.g.
by appending an item to a list), the default parameter value is in
effect modified.  This is generally not what was intended.  A way
around this is to use "None" as the default, and explicitly test for
it in the body of the function, e.g.:

   def whats_on_the_telly(penguin=None):
       if penguin is None:
           penguin = []
       penguin.append("property of the zoo")
       return penguin

Function call semantics are described in more detail in section Calls.
A function call always assigns values to all parameters mentioned in
the parameter list, either from positional arguments, from keyword
arguments, or from default values.  If the form “"*identifier"” is
present, it is initialized to a tuple receiving any excess positional
parameters, defaulting to the empty tuple. If the form
“"**identifier"” is present, it is initialized to a new ordered
mapping receiving any excess keyword arguments, defaulting to a new
empty mapping of the same type.  Parameters after “"*"” or
“"*identifier"” are keyword-only parameters and may only be passed by
keyword arguments.  Parameters before “"/"” are positional-only
parameters and may only be passed by positional arguments.

Changed in version 3.8: The "/" function parameter syntax may be used
to indicate positional-only parameters. See **PEP 570** for details.

Parameters may have an *annotation* of the form “": expression"”
following the parameter name.  Any parameter may have an annotation,
even those of the form "*identifier" or "**identifier". (As a special
case, parameters of the form "*identifier" may have an annotation “":
*expression"”.) Functions may have “return” annotation of the form
“"-> expression"” after the parameter list.  These annotations can be
any valid Python expression.  The presence of annotations does not
change the semantics of a function.  The annotation values are
available as values of a dictionary keyed by the parameters’ names in
the "__annotations__" attribute of the function object.  If the
"annotations" import from "__future__" is used, annotations are
preserved as strings at runtime which enables postponed evaluation.
Otherwise, they are evaluated when the function definition is
executed.  In this case annotations may be evaluated in a different
order than they appear in the source code.

Changed in version 3.11: Parameters of the form “"*identifier"” may
have an annotation “": *expression"”. See **PEP 646**.

It is also possible to create anonymous functions (functions not bound
to a name), for immediate use in expressions.  This uses lambda
expressions, described in section Lambdas.  Note that the lambda
expression is merely a shorthand for a simplified function definition;
a function defined in a “"def"” statement can be passed around or
assigned to another name just like a function defined by a lambda
expression.  The “"def"” form is actually more powerful since it
allows the execution of multiple statements and annotations.

**Programmer’s note:** Functions are first-class objects.  A “"def"”
statement executed inside a function definition defines a local
function that can be returned or passed around.  Free variables used
in the nested function can access the local variables of the function
containing the def.  See section Naming and binding for details.

See also:

  **PEP 3107** - Function Annotations
     The original specification for function annotations.

  **PEP 484** - Type Hints
     Definition of a standard meaning for annotations: type hints.

  **PEP 526** - Syntax for Variable Annotations
     Ability to type hint variable declarations, including class
     variables and instance variables.

  **PEP 563** - Postponed Evaluation of Annotations
     Support for forward references within annotations by preserving
     annotations in a string form at runtime instead of eager
     evaluation.

  **PEP 318** - Decorators for Functions and Methods
     Function and method decorators were introduced. Class decorators
     were introduced in **PEP 3129**.


Class definitions
=================

A class definition defines a class object (see section The standard
type hierarchy):

   classdef    ::= [decorators] "class" classname [type_params] [inheritance] ":" suite
   inheritance ::= "(" [argument_list] ")"
   classname   ::= identifier

A class definition is an executable statement.  The inheritance list
usually gives a list of base classes (see Metaclasses for more
advanced uses), so each item in the list should evaluate to a class
object which allows subclassing.  Classes without an inheritance list
inherit, by default, from the base class "object"; hence,

   class Foo:
       pass

is equivalent to

   class Foo(object):
       pass

The class’s suite is then executed in a new execution frame (see
Naming and binding), using a newly created local namespace and the
original global namespace. (Usually, the suite contains mostly
function definitions.)  When the class’s suite finishes execution, its
execution frame is discarded but its local namespace is saved. [5] A
class object is then created using the inheritance list for the base
classes and the saved local namespace for the attribute dictionary.
The class name is bound to this class object in the original local
namespace.

The order in which attributes are defined in the class body is
preserved in the new class’s "__dict__".  Note that this is reliable
only right after the class is created and only for classes that were
defined using the definition syntax.

Class creation can be customized heavily using metaclasses.

Classes can also be decorated: just like when decorating functions,

   @f1(arg)
   @f2
   class Foo: pass

is roughly equivalent to

   class Foo: pass
   Foo = f1(arg)(f2(Foo))

The evaluation rules for the decorator expressions are the same as for
function decorators.  The result is then bound to the class name.

Changed in version 3.9: Classes may be decorated with any valid
"assignment_expression". Previously, the grammar was much more
restrictive; see **PEP 614** for details.

A list of type parameters may be given in square brackets immediately
after the class’s name. This indicates to static type checkers that
the class is generic. At runtime, the type parameters can be retrieved
from the class’s "__type_params__" attribute. See Generic classes for
more.

Changed in version 3.12: Type parameter lists are new in Python 3.12.

**Programmer’s note:** Variables defined in the class definition are
class attributes; they are shared by instances.  Instance attributes
can be set in a method with "self.name = value".  Both class and
instance attributes are accessible through the notation “"self.name"”,
and an instance attribute hides a class attribute with the same name
when accessed in this way.  Class attributes can be used as defaults
for instance attributes, but using mutable values there can lead to
unexpected results.  Descriptors can be used to create instance
variables with different implementation details.

See also:

  **PEP 3115** - Metaclasses in Python 3000
     The proposal that changed the declaration of metaclasses to the
     current syntax, and the semantics for how classes with
     metaclasses are constructed.

  **PEP 3129** - Class Decorators
     The proposal that added class decorators.  Function and method
     decorators were introduced in **PEP 318**.


Coroutines
==========

Added in version 3.5.


Coroutine function definition
-----------------------------

   async_funcdef ::= [decorators] "async" "def" funcname "(" [parameter_list] ")"
                     ["->" expression] ":" suite

Execution of Python coroutines can be suspended and resumed at many
points (see *coroutine*). "await" expressions, "async for" and "async
with" can only be used in the body of a coroutine function.

Functions defined with "async def" syntax are always coroutine
functions, even if they do not contain "await" or "async" keywords.

It is a "SyntaxError" to use a "yield from" expression inside the body
of a coroutine function.

An example of a coroutine function:

   async def func(param1, param2):
       do_stuff()
       await some_coroutine()

Changed in version 3.7: "await" and "async" are now keywords;
previously they were only treated as such inside the body of a
coroutine function.


The "async for" statement
-------------------------

   async_for_stmt ::= "async" for_stmt

An *asynchronous iterable* provides an "__aiter__" method that
directly returns an *asynchronous iterator*, which can call
asynchronous code in its "__anext__" method.

The "async for" statement allows convenient iteration over
asynchronous iterables.

The following code:

   async for TARGET in ITER:
       SUITE
   else:
       SUITE2

Is semantically equivalent to:

   iter = (ITER)
   iter = type(iter).__aiter__(iter)
   running = True

   while running:
       try:
           TARGET = await type(iter).__anext__(iter)
       except StopAsyncIteration:
           running = False
       else:
           SUITE
   else:
       SUITE2

See also "__aiter__()" and "__anext__()" for details.

It is a "SyntaxError" to use an "async for" statement outside the body
of a coroutine function.


The "async with" statement
--------------------------

   async_with_stmt ::= "async" with_stmt

An *asynchronous context manager* is a *context manager* that is able
to suspend execution in its *enter* and *exit* methods.

The following code:

   async with EXPRESSION as TARGET:
       SUITE

is semantically equivalent to:

   manager = (EXPRESSION)
   aenter = type(manager).__aenter__
   aexit = type(manager).__aexit__
   value = await aenter(manager)
   hit_except = False

   try:
       TARGET = value
       SUITE
   except:
       hit_except = True
       if not await aexit(manager, *sys.exc_info()):
           raise
   finally:
       if not hit_except:
           await aexit(manager, None, None, None)

See also "__aenter__()" and "__aexit__()" for details.

It is a "SyntaxError" to use an "async with" statement outside the
body of a coroutine function.

See also:

  **PEP 492** - Coroutines with async and await syntax
     The proposal that made coroutines a proper standalone concept in
     Python, and added supporting syntax.


Type parameter lists
====================

Added in version 3.12.

   type_params  ::= "[" type_param ("," type_param)* "]"
   type_param   ::= typevar | typevartuple | paramspec
   typevar      ::= identifier (":" expression)?
   typevartuple ::= "*" identifier
   paramspec    ::= "**" identifier

Functions (including coroutines), classes and type aliases may contain
a type parameter list:

   def max[T](args: list[T]) -> T:
       ...

   async def amax[T](args: list[T]) -> T:
       ...

   class Bag[T]:
       def __iter__(self) -> Iterator[T]:
           ...

       def add(self, arg: T) -> None:
           ...

   type ListOrSet[T] = list[T] | set[T]

Semantically, this indicates that the function, class, or type alias
is generic over a type variable. This information is primarily used by
static type checkers, and at runtime, generic objects behave much like
their non-generic counterparts.

Type parameters are declared in square brackets ("[]") immediately
after the name of the function, class, or type alias. The type
parameters are accessible within the scope of the generic object, but
not elsewhere. Thus, after a declaration "def func[T](): pass", the
name "T" is not available in the module scope. Below, the semantics of
generic objects are described with more precision. The scope of type
parameters is modeled with a special function (technically, an
annotation scope) that wraps the creation of the generic object.

Generic functions, classes, and type aliases have a "__type_params__"
attribute listing their type parameters.

Type parameters come in three kinds:

* "typing.TypeVar", introduced by a plain name (e.g., "T").
  Semantically, this represents a single type to a type checker.

* "typing.TypeVarTuple", introduced by a name prefixed with a single
  asterisk (e.g., "*Ts"). Semantically, this stands for a tuple of any
  number of types.

* "typing.ParamSpec", introduced by a name prefixed with two asterisks
  (e.g., "**P"). Semantically, this stands for the parameters of a
  callable.

"typing.TypeVar" declarations can define *bounds* and *constraints*
with a colon (":") followed by an expression. A single expression
after the colon indicates a bound (e.g. "T: int"). Semantically, this
means that the "typing.TypeVar" can only represent types that are a
subtype of this bound. A parenthesized tuple of expressions after the
colon indicates a set of constraints (e.g. "T: (str, bytes)"). Each
member of the tuple should be a type (again, this is not enforced at
runtime). Constrained type variables can only take on one of the types
in the list of constraints.

For "typing.TypeVar"s declared using the type parameter list syntax,
the bound and constraints are not evaluated when the generic object is
created, but only when the value is explicitly accessed through the
attributes "__bound__" and "__constraints__". To accomplish this, the
bounds or constraints are evaluated in a separate annotation scope.

"typing.TypeVarTuple"s and "typing.ParamSpec"s cannot have bounds or
constraints.

The following example indicates the full set of allowed type parameter
declarations:

   def overly_generic[
      SimpleTypeVar,
      TypeVarWithBound: int,
      TypeVarWithConstraints: (str, bytes),
      *SimpleTypeVarTuple,
      **SimpleParamSpec,
   ](
      a: SimpleTypeVar,
      b: TypeVarWithBound,
      c: Callable[SimpleParamSpec, TypeVarWithConstraints],
      *d: SimpleTypeVarTuple,
   ): ...


Generic functions
-----------------

Generic functions are declared as follows:

   def func[T](arg: T): ...

This syntax is equivalent to:

   annotation-def TYPE_PARAMS_OF_func():
       T = typing.TypeVar("T")
       def func(arg: T): ...
       func.__type_params__ = (T,)
       return func
   func = TYPE_PARAMS_OF_func()

Here "annotation-def" indicates an annotation scope, which is not
actually bound to any name at runtime. (One other liberty is taken in
the translation: the syntax does not go through attribute access on
the "typing" module, but creates an instance of "typing.TypeVar"
directly.)

The annotations of generic functions are evaluated within the
annotation scope used for declaring the type parameters, but the
function’s defaults and decorators are not.

The following example illustrates the scoping rules for these cases,
as well as for additional flavors of type parameters:

   @decorator
   def func[T: int, *Ts, **P](*args: *Ts, arg: Callable[P, T] = some_default):
       ...

Except for the lazy evaluation of the "TypeVar" bound, this is
equivalent to:

   DEFAULT_OF_arg = some_default

   annotation-def TYPE_PARAMS_OF_func():

       annotation-def BOUND_OF_T():
           return int
       # In reality, BOUND_OF_T() is evaluated only on demand.
       T = typing.TypeVar("T", bound=BOUND_OF_T())

       Ts = typing.TypeVarTuple("Ts")
       P = typing.ParamSpec("P")

       def func(*args: *Ts, arg: Callable[P, T] = DEFAULT_OF_arg):
           ...

       func.__type_params__ = (T, Ts, P)
       return func
   func = decorator(TYPE_PARAMS_OF_func())

The capitalized names like "DEFAULT_OF_arg" are not actually bound at
runtime.


Generic classes
---------------

Generic classes are declared as follows:

   class Bag[T]: ...

This syntax is equivalent to:

   annotation-def TYPE_PARAMS_OF_Bag():
       T = typing.TypeVar("T")
       class Bag(typing.Generic[T]):
           __type_params__ = (T,)
           ...
       return Bag
   Bag = TYPE_PARAMS_OF_Bag()

Here again "annotation-def" (not a real keyword) indicates an
annotation scope, and the name "TYPE_PARAMS_OF_Bag" is not actually
bound at runtime.

Generic classes implicitly inherit from "typing.Generic". The base
classes and keyword arguments of generic classes are evaluated within
the type scope for the type parameters, and decorators are evaluated
outside that scope. This is illustrated by this example:

   @decorator
   class Bag(Base[T], arg=T): ...

This is equivalent to:

   annotation-def TYPE_PARAMS_OF_Bag():
       T = typing.TypeVar("T")
       class Bag(Base[T], typing.Generic[T], arg=T):
           __type_params__ = (T,)
           ...
       return Bag
   Bag = decorator(TYPE_PARAMS_OF_Bag())


Generic type aliases
--------------------

The "type" statement can also be used to create a generic type alias:

   type ListOrSet[T] = list[T] | set[T]

Except for the lazy evaluation of the value, this is equivalent to:

   annotation-def TYPE_PARAMS_OF_ListOrSet():
       T = typing.TypeVar("T")

       annotation-def VALUE_OF_ListOrSet():
           return list[T] | set[T]
       # In reality, the value is lazily evaluated
       return typing.TypeAliasType("ListOrSet", VALUE_OF_ListOrSet(), type_params=(T,))
   ListOrSet = TYPE_PARAMS_OF_ListOrSet()

Here, "annotation-def" (not a real keyword) indicates an annotation
scope. The capitalized names like "TYPE_PARAMS_OF_ListOrSet" are not
actually bound at runtime.

-[ Footnotes ]-

[1] The exception is propagated to the invocation stack unless there
    is a "finally" clause which happens to raise another exception.
    That new exception causes the old one to be lost.

[2] In pattern matching, a sequence is defined as one of the
    following:

    * a class that inherits from "collections.abc.Sequence"

    * a Python class that has been registered as
      "collections.abc.Sequence"

    * a builtin class that has its (CPython) "Py_TPFLAGS_SEQUENCE" bit
      set

    * a class that inherits from any of the above

    The following standard library classes are sequences:

    * "array.array"

    * "collections.deque"

    * "list"

    * "memoryview"

    * "range"

    * "tuple"

    Note:

      Subject values of type "str", "bytes", and "bytearray" do not
      match sequence patterns.

[3] In pattern matching, a mapping is defined as one of the following:

    * a class that inherits from "collections.abc.Mapping"

    * a Python class that has been registered as
      "collections.abc.Mapping"

    * a builtin class that has its (CPython) "Py_TPFLAGS_MAPPING" bit
      set

    * a class that inherits from any of the above

    The standard library classes "dict" and "types.MappingProxyType"
    are mappings.

[4] A string literal appearing as the first statement in the function
    body is transformed into the function’s "__doc__" attribute and
    therefore the function’s *docstring*.

[5] A string literal appearing as the first statement in the class
    body is transformed into the namespace’s "__doc__" item and
    therefore the class’s *docstring*.
''',
    'context-managers': r'''With Statement Context Managers
*******************************

A *context manager* is an object that defines the runtime context to
be established when executing a "with" statement. The context manager
handles the entry into, and the exit from, the desired runtime context
for the execution of the block of code.  Context managers are normally
invoked using the "with" statement (described in section The with
statement), but can also be used by directly invoking their methods.

Typical uses of context managers include saving and restoring various
kinds of global state, locking and unlocking resources, closing opened
files, etc.

For more information on context managers, see Context Manager Types.
The "object" class itself does not provide the context manager
methods.

object.__enter__(self)

   Enter the runtime context related to this object. The "with"
   statement will bind this method’s return value to the target(s)
   specified in the "as" clause of the statement, if any.

object.__exit__(self, exc_type, exc_value, traceback)

   Exit the runtime context related to this object. The parameters
   describe the exception that caused the context to be exited. If the
   context was exited without an exception, all three arguments will
   be "None".

   If an exception is supplied, and the method wishes to suppress the
   exception (i.e., prevent it from being propagated), it should
   return a true value. Otherwise, the exception will be processed
   normally upon exit from this method.

   Note that "__exit__()" methods should not reraise the passed-in
   exception; this is the caller’s responsibility.

See also:

  **PEP 343** - The “with” statement
     The specification, background, and examples for the Python "with"
     statement.
''',
    'continue': r'''The "continue" statement
************************

   continue_stmt ::= "continue"

"continue" may only occur syntactically nested in a "for" or "while"
loop, but not nested in a function or class definition within that
loop.  It continues with the next cycle of the nearest enclosing loop.

When "continue" passes control out of a "try" statement with a
"finally" clause, that "finally" clause is executed before really
starting the next loop cycle.
''',
    'conversions': r'''Arithmetic conversions
**********************

When a description of an arithmetic operator below uses the phrase
“the numeric arguments are converted to a common type”, this means
that the operator implementation for built-in types works as follows:

* If either argument is a complex number, the other is converted to
  complex;

* otherwise, if either argument is a floating-point number, the other
  is converted to floating point;

* otherwise, both must be integers and no conversion is necessary.

Some additional rules apply for certain operators (e.g., a string as a
left argument to the ‘%’ operator).  Extensions must define their own
conversion behavior.
''',
    'customization': r'''Basic customization
*******************

object.__new__(cls[, ...])

   Called to create a new instance of class *cls*.  "__new__()" is a
   static method (special-cased so you need not declare it as such)
   that takes the class of which an instance was requested as its
   first argument.  The remaining arguments are those passed to the
   object constructor expression (the call to the class).  The return
   value of "__new__()" should be the new object instance (usually an
   instance of *cls*).

   Typical implementations create a new instance of the class by
   invoking the superclass’s "__new__()" method using
   "super().__new__(cls[, ...])" with appropriate arguments and then
   modifying the newly created instance as necessary before returning
   it.

   If "__new__()" is invoked during object construction and it returns
   an instance of *cls*, then the new instance’s "__init__()" method
   will be invoked like "__init__(self[, ...])", where *self* is the
   new instance and the remaining arguments are the same as were
   passed to the object constructor.

   If "__new__()" does not return an instance of *cls*, then the new
   instance’s "__init__()" method will not be invoked.

   "__new__()" is intended mainly to allow subclasses of immutable
   types (like int, str, or tuple) to customize instance creation.  It
   is also commonly overridden in custom metaclasses in order to
   customize class creation.

object.__init__(self[, ...])

   Called after the instance has been created (by "__new__()"), but
   before it is returned to the caller.  The arguments are those
   passed to the class constructor expression.  If a base class has an
   "__init__()" method, the derived class’s "__init__()" method, if
   any, must explicitly call it to ensure proper initialization of the
   base class part of the instance; for example:
   "super().__init__([args...])".

   Because "__new__()" and "__init__()" work together in constructing
   objects ("__new__()" to create it, and "__init__()" to customize
   it), no non-"None" value may be returned by "__init__()"; doing so
   will cause a "TypeError" to be raised at runtime.

object.__del__(self)

   Called when the instance is about to be destroyed.  This is also
   called a finalizer or (improperly) a destructor.  If a base class
   has a "__del__()" method, the derived class’s "__del__()" method,
   if any, must explicitly call it to ensure proper deletion of the
   base class part of the instance.

   It is possible (though not recommended!) for the "__del__()" method
   to postpone destruction of the instance by creating a new reference
   to it.  This is called object *resurrection*.  It is
   implementation-dependent whether "__del__()" is called a second
   time when a resurrected object is about to be destroyed; the
   current *CPython* implementation only calls it once.

   It is not guaranteed that "__del__()" methods are called for
   objects that still exist when the interpreter exits.
   "weakref.finalize" provides a straightforward way to register a
   cleanup function to be called when an object is garbage collected.

   Note:

     "del x" doesn’t directly call "x.__del__()" — the former
     decrements the reference count for "x" by one, and the latter is
     only called when "x"’s reference count reaches zero.

   **CPython implementation detail:** It is possible for a reference
   cycle to prevent the reference count of an object from going to
   zero.  In this case, the cycle will be later detected and deleted
   by the *cyclic garbage collector*.  A common cause of reference
   cycles is when an exception has been caught in a local variable.
   The frame’s locals then reference the exception, which references
   its own traceback, which references the locals of all frames caught
   in the traceback.

   See also: Documentation for the "gc" module.

   Warning:

     Due to the precarious circumstances under which "__del__()"
     methods are invoked, exceptions that occur during their execution
     are ignored, and a warning is printed to "sys.stderr" instead.
     In particular:

     * "__del__()" can be invoked when arbitrary code is being
       executed, including from any arbitrary thread.  If "__del__()"
       needs to take a lock or invoke any other blocking resource, it
       may deadlock as the resource may already be taken by the code
       that gets interrupted to execute "__del__()".

     * "__del__()" can be executed during interpreter shutdown.  As a
       consequence, the global variables it needs to access (including
       other modules) may already have been deleted or set to "None".
       Python guarantees that globals whose name begins with a single
       underscore are deleted from their module before other globals
       are deleted; if no other references to such globals exist, this
       may help in assuring that imported modules are still available
       at the time when the "__del__()" method is called.

object.__repr__(self)

   Called by the "repr()" built-in function to compute the “official”
   string representation of an object.  If at all possible, this
   should look like a valid Python expression that could be used to
   recreate an object with the same value (given an appropriate
   environment).  If this is not possible, a string of the form
   "<...some useful description...>" should be returned. The return
   value must be a string object. If a class defines "__repr__()" but
   not "__str__()", then "__repr__()" is also used when an “informal”
   string representation of instances of that class is required.

   This is typically used for debugging, so it is important that the
   representation is information-rich and unambiguous. A default
   implementation is provided by the "object" class itself.

object.__str__(self)

   Called by "str(object)", the default "__format__()" implementation,
   and the built-in function "print()", to compute the “informal” or
   nicely printable string representation of an object.  The return
   value must be a str object.

   This method differs from "object.__repr__()" in that there is no
   expectation that "__str__()" return a valid Python expression: a
   more convenient or concise representation can be used.

   The default implementation defined by the built-in type "object"
   calls "object.__repr__()".

object.__bytes__(self)

   Called by bytes to compute a byte-string representation of an
   object. This should return a "bytes" object. The "object" class
   itself does not provide this method.

object.__format__(self, format_spec)

   Called by the "format()" built-in function, and by extension,
   evaluation of formatted string literals and the "str.format()"
   method, to produce a “formatted” string representation of an
   object. The *format_spec* argument is a string that contains a
   description of the formatting options desired. The interpretation
   of the *format_spec* argument is up to the type implementing
   "__format__()", however most classes will either delegate
   formatting to one of the built-in types, or use a similar
   formatting option syntax.

   See Format Specification Mini-Language for a description of the
   standard formatting syntax.

   The return value must be a string object.

   The default implementation by the "object" class should be given an
   empty *format_spec* string. It delegates to "__str__()".

   Changed in version 3.4: The __format__ method of "object" itself
   raises a "TypeError" if passed any non-empty string.

   Changed in version 3.7: "object.__format__(x, '')" is now
   equivalent to "str(x)" rather than "format(str(x), '')".

object.__lt__(self, other)
object.__le__(self, other)
object.__eq__(self, other)
object.__ne__(self, other)
object.__gt__(self, other)
object.__ge__(self, other)

   These are the so-called “rich comparison” methods. The
   correspondence between operator symbols and method names is as
   follows: "x<y" calls "x.__lt__(y)", "x<=y" calls "x.__le__(y)",
   "x==y" calls "x.__eq__(y)", "x!=y" calls "x.__ne__(y)", "x>y" calls
   "x.__gt__(y)", and "x>=y" calls "x.__ge__(y)".

   A rich comparison method may return the singleton "NotImplemented"
   if it does not implement the operation for a given pair of
   arguments. By convention, "False" and "True" are returned for a
   successful comparison. However, these methods can return any value,
   so if the comparison operator is used in a Boolean context (e.g.,
   in the condition of an "if" statement), Python will call "bool()"
   on the value to determine if the result is true or false.

   By default, "object" implements "__eq__()" by using "is", returning
   "NotImplemented" in the case of a false comparison: "True if x is y
   else NotImplemented". For "__ne__()", by default it delegates to
   "__eq__()" and inverts the result unless it is "NotImplemented".
   There are no other implied relationships among the comparison
   operators or default implementations; for example, the truth of
   "(x<y or x==y)" does not imply "x<=y". To automatically generate
   ordering operations from a single root operation, see
   "functools.total_ordering()".

   By default, the "object" class provides implementations consistent
   with Value comparisons: equality compares according to object
   identity, and order comparisons raise "TypeError". Each default
   method may generate these results directly, but may also return
   "NotImplemented".

   See the paragraph on "__hash__()" for some important notes on
   creating *hashable* objects which support custom comparison
   operations and are usable as dictionary keys.

   There are no swapped-argument versions of these methods (to be used
   when the left argument does not support the operation but the right
   argument does); rather, "__lt__()" and "__gt__()" are each other’s
   reflection, "__le__()" and "__ge__()" are each other’s reflection,
   and "__eq__()" and "__ne__()" are their own reflection. If the
   operands are of different types, and the right operand’s type is a
   direct or indirect subclass of the left operand’s type, the
   reflected method of the right operand has priority, otherwise the
   left operand’s method has priority.  Virtual subclassing is not
   considered.

   When no appropriate method returns any value other than
   "NotImplemented", the "==" and "!=" operators will fall back to
   "is" and "is not", respectively.

object.__hash__(self)

   Called by built-in function "hash()" and for operations on members
   of hashed collections including "set", "frozenset", and "dict".
   The "__hash__()" method should return an integer. The only required
   property is that objects which compare equal have the same hash
   value; it is advised to mix together the hash values of the
   components of the object that also play a part in comparison of
   objects by packing them into a tuple and hashing the tuple.
   Example:

      def __hash__(self):
          return hash((self.name, self.nick, self.color))

   Note:

     "hash()" truncates the value returned from an object’s custom
     "__hash__()" method to the size of a "Py_ssize_t".  This is
     typically 8 bytes on 64-bit builds and 4 bytes on 32-bit builds.
     If an object’s   "__hash__()" must interoperate on builds of
     different bit sizes, be sure to check the width on all supported
     builds.  An easy way to do this is with "python -c "import sys;
     print(sys.hash_info.width)"".

   If a class does not define an "__eq__()" method it should not
   define a "__hash__()" operation either; if it defines "__eq__()"
   but not "__hash__()", its instances will not be usable as items in
   hashable collections.  If a class defines mutable objects and
   implements an "__eq__()" method, it should not implement
   "__hash__()", since the implementation of *hashable* collections
   requires that a key’s hash value is immutable (if the object’s hash
   value changes, it will be in the wrong hash bucket).

   User-defined classes have "__eq__()" and "__hash__()" methods by
   default (inherited from the "object" class); with them, all objects
   compare unequal (except with themselves) and "x.__hash__()" returns
   an appropriate value such that "x == y" implies both that "x is y"
   and "hash(x) == hash(y)".

   A class that overrides "__eq__()" and does not define "__hash__()"
   will have its "__hash__()" implicitly set to "None".  When the
   "__hash__()" method of a class is "None", instances of the class
   will raise an appropriate "TypeError" when a program attempts to
   retrieve their hash value, and will also be correctly identified as
   unhashable when checking "isinstance(obj,
   collections.abc.Hashable)".

   If a class that overrides "__eq__()" needs to retain the
   implementation of "__hash__()" from a parent class, the interpreter
   must be told this explicitly by setting "__hash__ =
   <ParentClass>.__hash__".

   If a class that does not override "__eq__()" wishes to suppress
   hash support, it should include "__hash__ = None" in the class
   definition. A class which defines its own "__hash__()" that
   explicitly raises a "TypeError" would be incorrectly identified as
   hashable by an "isinstance(obj, collections.abc.Hashable)" call.

   Note:

     By default, the "__hash__()" values of str and bytes objects are
     “salted” with an unpredictable random value.  Although they
     remain constant within an individual Python process, they are not
     predictable between repeated invocations of Python.This is
     intended to provide protection against a denial-of-service caused
     by carefully chosen inputs that exploit the worst case
     performance of a dict insertion, *O*(*n*^2) complexity.  See
     http://ocert.org/advisories/ocert-2011-003.html for
     details.Changing hash values affects the iteration order of sets.
     Python has never made guarantees about this ordering (and it
     typically varies between 32-bit and 64-bit builds).See also
     "PYTHONHASHSEED".

   Changed in version 3.3: Hash randomization is enabled by default.

object.__bool__(self)

   Called to implement truth value testing and the built-in operation
   "bool()"; should return "False" or "True".  When this method is not
   defined, "__len__()" is called, if it is defined, and the object is
   considered true if its result is nonzero.  If a class defines
   neither "__len__()" nor "__bool__()" (which is true of the "object"
   class itself), all its instances are considered true.
''',
    'debugger': r'''"pdb" — The Python Debugger
***************************

**Source code:** Lib/pdb.py

======================================================================

The module "pdb" defines an interactive source code debugger for
Python programs.  It supports setting (conditional) breakpoints and
single stepping at the source line level, inspection of stack frames,
source code listing, and evaluation of arbitrary Python code in the
context of any stack frame.  It also supports post-mortem debugging
and can be called under program control.

The debugger is extensible – it is actually defined as the class
"Pdb". This is currently undocumented but easily understood by reading
the source.  The extension interface uses the modules "bdb" and "cmd".

See also:

  Module "faulthandler"
     Used to dump Python tracebacks explicitly, on a fault, after a
     timeout, or on a user signal.

  Module "traceback"
     Standard interface to extract, format and print stack traces of
     Python programs.

The typical usage to break into the debugger is to insert:

   import pdb; pdb.set_trace()

Or:

   breakpoint()

at the location you want to break into the debugger, and then run the
program. You can then step through the code following this statement,
and continue running without the debugger using the "continue"
command.

Changed in version 3.7: The built-in "breakpoint()", when called with
defaults, can be used instead of "import pdb; pdb.set_trace()".

   def double(x):
      breakpoint()
      return x * 2
   val = 3
   print(f"{val} * 2 is {double(val)}")

The debugger’s prompt is "(Pdb)", which is the indicator that you are
in debug mode:

   > ...(3)double()
   -> return x * 2
   (Pdb) p x
   3
   (Pdb) continue
   3 * 2 is 6

Changed in version 3.3: Tab-completion via the "readline" module is
available for commands and command arguments, e.g. the current global
and local names are offered as arguments of the "p" command.

You can also invoke "pdb" from the command line to debug other
scripts.  For example:

   python -m pdb [-c command] (-m module | pyfile) [args ...]

When invoked as a module, pdb will automatically enter post-mortem
debugging if the program being debugged exits abnormally.  After post-
mortem debugging (or after normal exit of the program), pdb will
restart the program.  Automatic restarting preserves pdb’s state (such
as breakpoints) and in most cases is more useful than quitting the
debugger upon program’s exit.

-c, --command <command>

   To execute commands as if given in a ".pdbrc" file; see Debugger
   Commands.

   Changed in version 3.2: Added the "-c" option.

-m <module>

   To execute modules similar to the way "python -m" does. As with a
   script, the debugger will pause execution just before the first
   line of the module.

   Changed in version 3.7: Added the "-m" option.

Typical usage to execute a statement under control of the debugger is:

   >>> import pdb
   >>> def f(x):
   ...     print(1 / x)
   >>> pdb.run("f(2)")
   > <string>(1)<module>()
   (Pdb) continue
   0.5
   >>>

The typical usage to inspect a crashed program is:

   >>> import pdb
   >>> def f(x):
   ...     print(1 / x)
   ...
   >>> f(0)
   Traceback (most recent call last):
     File "<stdin>", line 1, in <module>
     File "<stdin>", line 2, in f
   ZeroDivisionError: division by zero
   >>> pdb.pm()
   > <stdin>(2)f()
   (Pdb) p x
   0
   (Pdb)

The module defines the following functions; each enters the debugger
in a slightly different way:

pdb.run(statement, globals=None, locals=None)

   Execute the *statement* (given as a string or a code object) under
   debugger control.  The debugger prompt appears before any code is
   executed; you can set breakpoints and type "continue", or you can
   step through the statement using "step" or "next" (all these
   commands are explained below).  The optional *globals* and *locals*
   arguments specify the environment in which the code is executed; by
   default the dictionary of the module "__main__" is used.  (See the
   explanation of the built-in "exec()" or "eval()" functions.)

pdb.runeval(expression, globals=None, locals=None)

   Evaluate the *expression* (given as a string or a code object)
   under debugger control.  When "runeval()" returns, it returns the
   value of the *expression*.  Otherwise this function is similar to
   "run()".

pdb.runcall(function, *args, **kwds)

   Call the *function* (a function or method object, not a string)
   with the given arguments.  When "runcall()" returns, it returns
   whatever the function call returned.  The debugger prompt appears
   as soon as the function is entered.

pdb.set_trace(*, header=None)

   Enter the debugger at the calling stack frame.  This is useful to
   hard-code a breakpoint at a given point in a program, even if the
   code is not otherwise being debugged (e.g. when an assertion
   fails).  If given, *header* is printed to the console just before
   debugging begins.

   Changed in version 3.7: The keyword-only argument *header*.

pdb.post_mortem(traceback=None)

   Enter post-mortem debugging of the given *traceback* object.  If no
   *traceback* is given, it uses the one of the exception that is
   currently being handled (an exception must be being handled if the
   default is to be used).

pdb.pm()

   Enter post-mortem debugging of the traceback found in
   "sys.last_traceback".

The "run*" functions and "set_trace()" are aliases for instantiating
the "Pdb" class and calling the method of the same name.  If you want
to access further features, you have to do this yourself:

class pdb.Pdb(completekey='tab', stdin=None, stdout=None, skip=None, nosigint=False, readrc=True)

   "Pdb" is the debugger class.

   The *completekey*, *stdin* and *stdout* arguments are passed to the
   underlying "cmd.Cmd" class; see the description there.

   The *skip* argument, if given, must be an iterable of glob-style
   module name patterns.  The debugger will not step into frames that
   originate in a module that matches one of these patterns. [1]

   By default, Pdb sets a handler for the SIGINT signal (which is sent
   when the user presses "Ctrl"-"C" on the console) when you give a
   "continue" command. This allows you to break into the debugger
   again by pressing "Ctrl"-"C".  If you want Pdb not to touch the
   SIGINT handler, set *nosigint* to true.

   The *readrc* argument defaults to true and controls whether Pdb
   will load .pdbrc files from the filesystem.

   Example call to enable tracing with *skip*:

      import pdb; pdb.Pdb(skip=['django.*']).set_trace()

   Raises an auditing event "pdb.Pdb" with no arguments.

   Changed in version 3.1: Added the *skip* parameter.

   Changed in version 3.2: Added the *nosigint* parameter. Previously,
   a SIGINT handler was never set by Pdb.

   Changed in version 3.6: The *readrc* argument.

   run(statement, globals=None, locals=None)
   runeval(expression, globals=None, locals=None)
   runcall(function, *args, **kwds)
   set_trace()

      See the documentation for the functions explained above.


Debugger Commands
=================

The commands recognized by the debugger are listed below.  Most
commands can be abbreviated to one or two letters as indicated; e.g.
"h(elp)" means that either "h" or "help" can be used to enter the help
command (but not "he" or "hel", nor "H" or "Help" or "HELP").
Arguments to commands must be separated by whitespace (spaces or
tabs).  Optional arguments are enclosed in square brackets ("[]") in
the command syntax; the square brackets must not be typed.
Alternatives in the command syntax are separated by a vertical bar
("|").

Entering a blank line repeats the last command entered.  Exception: if
the last command was a "list" command, the next 11 lines are listed.

Commands that the debugger doesn’t recognize are assumed to be Python
statements and are executed in the context of the program being
debugged.  Python statements can also be prefixed with an exclamation
point ("!").  This is a powerful way to inspect the program being
debugged; it is even possible to change a variable or call a function.
When an exception occurs in such a statement, the exception name is
printed but the debugger’s state is not changed.

The debugger supports aliases.  Aliases can have parameters which
allows one a certain level of adaptability to the context under
examination.

Multiple commands may be entered on a single line, separated by ";;".
(A single ";" is not used as it is the separator for multiple commands
in a line that is passed to the Python parser.)  No intelligence is
applied to separating the commands; the input is split at the first
";;" pair, even if it is in the middle of a quoted string. A
workaround for strings with double semicolons is to use implicit
string concatenation "';'';'" or "";"";"".

To set a temporary global variable, use a *convenience variable*. A
*convenience variable* is a variable whose name starts with "$".  For
example, "$foo = 1" sets a global variable "$foo" which you can use in
the debugger session.  The *convenience variables* are cleared when
the program resumes execution so it’s less likely to interfere with
your program compared to using normal variables like "foo = 1".

There are three preset *convenience variables*:

* "$_frame": the current frame you are debugging

* "$_retval": the return value if the frame is returning

* "$_exception": the exception if the frame is raising an exception

Added in version 3.12: Added the *convenience variable* feature.

If a file ".pdbrc" exists in the user’s home directory or in the
current directory, it is read with "'utf-8'" encoding and executed as
if it had been typed at the debugger prompt, with the exception that
empty lines and lines starting with "#" are ignored.  This is
particularly useful for aliases.  If both files exist, the one in the
home directory is read first and aliases defined there can be
overridden by the local file.

Changed in version 3.2: ".pdbrc" can now contain commands that
continue debugging, such as "continue" or "next".  Previously, these
commands had no effect.

Changed in version 3.11: ".pdbrc" is now read with "'utf-8'" encoding.
Previously, it was read with the system locale encoding.

h(elp) [command]

   Without argument, print the list of available commands.  With a
   *command* as argument, print help about that command.  "help pdb"
   displays the full documentation (the docstring of the "pdb"
   module).  Since the *command* argument must be an identifier, "help
   exec" must be entered to get help on the "!" command.

w(here)

   Print a stack trace, with the most recent frame at the bottom.  An
   arrow (">") indicates the current frame, which determines the
   context of most commands.

d(own) [count]

   Move the current frame *count* (default one) levels down in the
   stack trace (to a newer frame).

u(p) [count]

   Move the current frame *count* (default one) levels up in the stack
   trace (to an older frame).

b(reak) [([filename:]lineno | function) [, condition]]

   With a *lineno* argument, set a break there in the current file.
   With a *function* argument, set a break at the first executable
   statement within that function.  The line number may be prefixed
   with a filename and a colon, to specify a breakpoint in another
   file (probably one that hasn’t been loaded yet).  The file is
   searched on "sys.path".  Note that each breakpoint is assigned a
   number to which all the other breakpoint commands refer.

   If a second argument is present, it is an expression which must
   evaluate to true before the breakpoint is honored.

   Without argument, list all breaks, including for each breakpoint,
   the number of times that breakpoint has been hit, the current
   ignore count, and the associated condition if any.

tbreak [([filename:]lineno | function) [, condition]]

   Temporary breakpoint, which is removed automatically when it is
   first hit. The arguments are the same as for "break".

cl(ear) [filename:lineno | bpnumber ...]

   With a *filename:lineno* argument, clear all the breakpoints at
   this line. With a space separated list of breakpoint numbers, clear
   those breakpoints. Without argument, clear all breaks (but first
   ask confirmation).

disable bpnumber [bpnumber ...]

   Disable the breakpoints given as a space separated list of
   breakpoint numbers.  Disabling a breakpoint means it cannot cause
   the program to stop execution, but unlike clearing a breakpoint, it
   remains in the list of breakpoints and can be (re-)enabled.

enable bpnumber [bpnumber ...]

   Enable the breakpoints specified.

ignore bpnumber [count]

   Set the ignore count for the given breakpoint number.  If *count*
   is omitted, the ignore count is set to 0.  A breakpoint becomes
   active when the ignore count is zero.  When non-zero, the *count*
   is decremented each time the breakpoint is reached and the
   breakpoint is not disabled and any associated condition evaluates
   to true.

condition bpnumber [condition]

   Set a new *condition* for the breakpoint, an expression which must
   evaluate to true before the breakpoint is honored.  If *condition*
   is absent, any existing condition is removed; i.e., the breakpoint
   is made unconditional.

commands [bpnumber]

   Specify a list of commands for breakpoint number *bpnumber*.  The
   commands themselves appear on the following lines.  Type a line
   containing just "end" to terminate the commands. An example:

      (Pdb) commands 1
      (com) p some_variable
      (com) end
      (Pdb)

   To remove all commands from a breakpoint, type "commands" and
   follow it immediately with "end"; that is, give no commands.

   With no *bpnumber* argument, "commands" refers to the last
   breakpoint set.

   You can use breakpoint commands to start your program up again.
   Simply use the "continue" command, or "step", or any other command
   that resumes execution.

   Specifying any command resuming execution (currently "continue",
   "step", "next", "return", "jump", "quit" and their abbreviations)
   terminates the command list (as if that command was immediately
   followed by end). This is because any time you resume execution
   (even with a simple next or step), you may encounter another
   breakpoint—which could have its own command list, leading to
   ambiguities about which list to execute.

   If you use the "silent" command in the command list, the usual
   message about stopping at a breakpoint is not printed.  This may be
   desirable for breakpoints that are to print a specific message and
   then continue.  If none of the other commands print anything, you
   see no sign that the breakpoint was reached.

s(tep)

   Execute the current line, stop at the first possible occasion
   (either in a function that is called or on the next line in the
   current function).

n(ext)

   Continue execution until the next line in the current function is
   reached or it returns.  (The difference between "next" and "step"
   is that "step" stops inside a called function, while "next"
   executes called functions at (nearly) full speed, only stopping at
   the next line in the current function.)

unt(il) [lineno]

   Without argument, continue execution until the line with a number
   greater than the current one is reached.

   With *lineno*, continue execution until a line with a number
   greater or equal to *lineno* is reached.  In both cases, also stop
   when the current frame returns.

   Changed in version 3.2: Allow giving an explicit line number.

r(eturn)

   Continue execution until the current function returns.

c(ont(inue))

   Continue execution, only stop when a breakpoint is encountered.

j(ump) lineno

   Set the next line that will be executed.  Only available in the
   bottom-most frame.  This lets you jump back and execute code again,
   or jump forward to skip code that you don’t want to run.

   It should be noted that not all jumps are allowed – for instance it
   is not possible to jump into the middle of a "for" loop or out of a
   "finally" clause.

l(ist) [first[, last]]

   List source code for the current file.  Without arguments, list 11
   lines around the current line or continue the previous listing.
   With "." as argument, list 11 lines around the current line.  With
   one argument, list 11 lines around at that line.  With two
   arguments, list the given range; if the second argument is less
   than the first, it is interpreted as a count.

   The current line in the current frame is indicated by "->".  If an
   exception is being debugged, the line where the exception was
   originally raised or propagated is indicated by ">>", if it differs
   from the current line.

   Changed in version 3.2: Added the ">>" marker.

ll | longlist

   List all source code for the current function or frame.
   Interesting lines are marked as for "list".

   Added in version 3.2.

a(rgs)

   Print the arguments of the current function and their current
   values.

p expression

   Evaluate *expression* in the current context and print its value.

   Note:

     "print()" can also be used, but is not a debugger command — this
     executes the Python "print()" function.

pp expression

   Like the "p" command, except the value of *expression* is pretty-
   printed using the "pprint" module.

whatis expression

   Print the type of *expression*.

source expression

   Try to get source code of *expression* and display it.

   Added in version 3.2.

display [expression]

   Display the value of *expression* if it changed, each time
   execution stops in the current frame.

   Without *expression*, list all display expressions for the current
   frame.

   Note:

     Display evaluates *expression* and compares to the result of the
     previous evaluation of *expression*, so when the result is
     mutable, display may not be able to pick up the changes.

   Example:

      lst = []
      breakpoint()
      pass
      lst.append(1)
      print(lst)

   Display won’t realize "lst" has been changed because the result of
   evaluation is modified in place by "lst.append(1)" before being
   compared:

      > example.py(3)<module>()
      -> pass
      (Pdb) display lst
      display lst: []
      (Pdb) n
      > example.py(4)<module>()
      -> lst.append(1)
      (Pdb) n
      > example.py(5)<module>()
      -> print(lst)
      (Pdb)

   You can do some tricks with copy mechanism to make it work:

      > example.py(3)<module>()
      -> pass
      (Pdb) display lst[:]
      display lst[:]: []
      (Pdb) n
      > example.py(4)<module>()
      -> lst.append(1)
      (Pdb) n
      > example.py(5)<module>()
      -> print(lst)
      display lst[:]: [1]  [old: []]
      (Pdb)

   Added in version 3.2.

undisplay [expression]

   Do not display *expression* anymore in the current frame.  Without
   *expression*, clear all display expressions for the current frame.

   Added in version 3.2.

interact

   Start an interactive interpreter (using the "code" module) whose
   global namespace contains all the (global and local) names found in
   the current scope.

   Added in version 3.2.

alias [name [command]]

   Create an alias called *name* that executes *command*.  The
   *command* must *not* be enclosed in quotes.  Replaceable parameters
   can be indicated by "%1", "%2", and so on, while "%*" is replaced
   by all the parameters. If *command* is omitted, the current alias
   for *name* is shown. If no arguments are given, all aliases are
   listed.

   Aliases may be nested and can contain anything that can be legally
   typed at the pdb prompt.  Note that internal pdb commands *can* be
   overridden by aliases.  Such a command is then hidden until the
   alias is removed.  Aliasing is recursively applied to the first
   word of the command line; all other words in the line are left
   alone.

   As an example, here are two useful aliases (especially when placed
   in the ".pdbrc" file):

      # Print instance variables (usage "pi classInst")
      alias pi for k in %1.__dict__.keys(): print(f"%1.{k} = {%1.__dict__[k]}")
      # Print instance variables in self
      alias ps pi self

unalias name

   Delete the specified alias *name*.

! statement

   Execute the (one-line) *statement* in the context of the current
   stack frame. The exclamation point can be omitted unless the first
   word of the statement resembles a debugger command, e.g.:

      (Pdb) ! n=42
      (Pdb)

   To set a global variable, you can prefix the assignment command
   with a "global" statement on the same line, e.g.:

      (Pdb) global list_options; list_options = ['-l']
      (Pdb)

run [args ...]
restart [args ...]

   Restart the debugged Python program.  If *args* is supplied, it is
   split with "shlex" and the result is used as the new "sys.argv".
   History, breakpoints, actions and debugger options are preserved.
   "restart" is an alias for "run".

q(uit)

   Quit from the debugger.  The program being executed is aborted.

debug code

   Enter a recursive debugger that steps through *code* (which is an
   arbitrary expression or statement to be executed in the current
   environment).

retval

   Print the return value for the last return of the current function.

-[ Footnotes ]-

[1] Whether a frame is considered to originate in a certain module is
    determined by the "__name__" in the frame globals.
''',
    'del': r'''The "del" statement
*******************

   del_stmt ::= "del" target_list

Deletion is recursively defined very similar to the way assignment is
defined. Rather than spelling it out in full details, here are some
hints.

Deletion of a target list recursively deletes each target, from left
to right.

Deletion of a name removes the binding of that name from the local or
global namespace, depending on whether the name occurs in a "global"
statement in the same code block.  If the name is unbound, a
"NameError" exception will be raised.

Deletion of attribute references, subscriptions and slicings is passed
to the primary object involved; deletion of a slicing is in general
equivalent to assignment of an empty slice of the right type (but even
this is determined by the sliced object).

Changed in version 3.2: Previously it was illegal to delete a name
from the local namespace if it occurs as a free variable in a nested
block.
''',
    'dict': r'''Dictionary displays
*******************

A dictionary display is a possibly empty series of dict items
(key/value pairs) enclosed in curly braces:

   dict_display       ::= "{" [dict_item_list | dict_comprehension] "}"
   dict_item_list     ::= dict_item ("," dict_item)* [","]
   dict_item          ::= expression ":" expression | "**" or_expr
   dict_comprehension ::= expression ":" expression comp_for

A dictionary display yields a new dictionary object.

If a comma-separated sequence of dict items is given, they are
evaluated from left to right to define the entries of the dictionary:
each key object is used as a key into the dictionary to store the
corresponding value.  This means that you can specify the same key
multiple times in the dict item list, and the final dictionary’s value
for that key will be the last one given.

A double asterisk "**" denotes *dictionary unpacking*. Its operand
must be a *mapping*.  Each mapping item is added to the new
dictionary.  Later values replace values already set by earlier dict
items and earlier dictionary unpackings.

Added in version 3.5: Unpacking into dictionary displays, originally
proposed by **PEP 448**.

A dict comprehension, in contrast to list and set comprehensions,
needs two expressions separated with a colon followed by the usual
“for” and “if” clauses. When the comprehension is run, the resulting
key and value elements are inserted in the new dictionary in the order
they are produced.

Restrictions on the types of the key values are listed earlier in
section The standard type hierarchy.  (To summarize, the key type
should be *hashable*, which excludes all mutable objects.)  Clashes
between duplicate keys are not detected; the last value (textually
rightmost in the display) stored for a given key value prevails.

Changed in version 3.8: Prior to Python 3.8, in dict comprehensions,
the evaluation order of key and value was not well-defined.  In
CPython, the value was evaluated before the key.  Starting with 3.8,
the key is evaluated before the value, as proposed by **PEP 572**.
''',
    'dynamic-features': r'''Interaction with dynamic features
*********************************

Name resolution of free variables occurs at runtime, not at compile
time. This means that the following code will print 42:

   i = 10
   def f():
       print(i)
   i = 42
   f()

The "eval()" and "exec()" functions do not have access to the full
environment for resolving names.  Names may be resolved in the local
and global namespaces of the caller.  Free variables are not resolved
in the nearest enclosing namespace, but in the global namespace.  [1]
The "exec()" and "eval()" functions have optional arguments to
override the global and local namespace.  If only one namespace is
specified, it is used for both.
''',
    'else': r'''The "if" statement
******************

The "if" statement is used for conditional execution:

   if_stmt ::= "if" assignment_expression ":" suite
               ("elif" assignment_expression ":" suite)*
               ["else" ":" suite]

It selects exactly one of the suites by evaluating the expressions one
by one until one is found to be true (see section Boolean operations
for the definition of true and false); then that suite is executed
(and no other part of the "if" statement is executed or evaluated).
If all expressions are false, the suite of the "else" clause, if
present, is executed.
''',
    'exceptions': r'''Exceptions
**********

Exceptions are a means of breaking out of the normal flow of control
of a code block in order to handle errors or other exceptional
conditions.  An exception is *raised* at the point where the error is
detected; it may be *handled* by the surrounding code block or by any
code block that directly or indirectly invoked the code block where
the error occurred.

The Python interpreter raises an exception when it detects a run-time
error (such as division by zero).  A Python program can also
explicitly raise an exception with the "raise" statement. Exception
handlers are specified with the "try" … "except" statement.  The
"finally" clause of such a statement can be used to specify cleanup
code which does not handle the exception, but is executed whether an
exception occurred or not in the preceding code.

Python uses the “termination” model of error handling: an exception
handler can find out what happened and continue execution at an outer
level, but it cannot repair the cause of the error and retry the
failing operation (except by re-entering the offending piece of code
from the top).

When an exception is not handled at all, the interpreter terminates
execution of the program, or returns to its interactive main loop.  In
either case, it prints a stack traceback, except when the exception is
"SystemExit".

Exceptions are identified by class instances.  The "except" clause is
selected depending on the class of the instance: it must reference the
class of the instance or a *non-virtual base class* thereof. The
instance can be received by the handler and can carry additional
information about the exceptional condition.

Note:

  Exception messages are not part of the Python API.  Their contents
  may change from one version of Python to the next without warning
  and should not be relied on by code which will run under multiple
  versions of the interpreter.

See also the description of the "try" statement in section The try
statement and "raise" statement in section The raise statement.

-[ Footnotes ]-

[1] This limitation occurs because the code that is executed by these
    operations is not available at the time the module is compiled.
''',
    'execmodel': r'''Execution model
***************


Structure of a program
======================

A Python program is constructed from code blocks. A *block* is a piece
of Python program text that is executed as a unit. The following are
blocks: a module, a function body, and a class definition. Each
command typed interactively is a block.  A script file (a file given
as standard input to the interpreter or specified as a command line
argument to the interpreter) is a code block.  A script command (a
command specified on the interpreter command line with the "-c"
option) is a code block. A module run as a top level script (as module
"__main__") from the command line using a "-m" argument is also a code
block. The string argument passed to the built-in functions "eval()"
and "exec()" is a code block.

A code block is executed in an *execution frame*.  A frame contains
some administrative information (used for debugging) and determines
where and how execution continues after the code block’s execution has
completed.


Naming and binding
==================


Binding of names
----------------

*Names* refer to objects.  Names are introduced by name binding
operations.

The following constructs bind names:

* formal parameters to functions,

* class definitions,

* function definitions,

* assignment expressions,

* targets that are identifiers if occurring in an assignment:

  * "for" loop header,

  * after "as" in a "with" statement, "except" clause, "except*"
    clause, or in the as-pattern in structural pattern matching,

  * in a capture pattern in structural pattern matching

* "import" statements.

* "type" statements.

* type parameter lists.

The "import" statement of the form "from ... import *" binds all names
defined in the imported module, except those beginning with an
underscore. This form may only be used at the module level.

A target occurring in a "del" statement is also considered bound for
this purpose (though the actual semantics are to unbind the name).

Each assignment or import statement occurs within a block defined by a
class or function definition or at the module level (the top-level
code block).

If a name is bound in a block, it is a local variable of that block,
unless declared as "nonlocal" or "global".  If a name is bound at the
module level, it is a global variable.  (The variables of the module
code block are local and global.)  If a variable is used in a code
block but not defined there, it is a *free variable*.

Each occurrence of a name in the program text refers to the *binding*
of that name established by the following name resolution rules.


Resolution of names
-------------------

A *scope* defines the visibility of a name within a block.  If a local
variable is defined in a block, its scope includes that block.  If the
definition occurs in a function block, the scope extends to any blocks
contained within the defining one, unless a contained block introduces
a different binding for the name.

When a name is used in a code block, it is resolved using the nearest
enclosing scope.  The set of all such scopes visible to a code block
is called the block’s *environment*.

When a name is not found at all, a "NameError" exception is raised. If
the current scope is a function scope, and the name refers to a local
variable that has not yet been bound to a value at the point where the
name is used, an "UnboundLocalError" exception is raised.
"UnboundLocalError" is a subclass of "NameError".

If a name binding operation occurs anywhere within a code block, all
uses of the name within the block are treated as references to the
current block.  This can lead to errors when a name is used within a
block before it is bound.  This rule is subtle.  Python lacks
declarations and allows name binding operations to occur anywhere
within a code block.  The local variables of a code block can be
determined by scanning the entire text of the block for name binding
operations. See the FAQ entry on UnboundLocalError for examples.

If the "global" statement occurs within a block, all uses of the names
specified in the statement refer to the bindings of those names in the
top-level namespace.  Names are resolved in the top-level namespace by
searching the global namespace, i.e. the namespace of the module
containing the code block, and the builtins namespace, the namespace
of the module "builtins".  The global namespace is searched first.  If
the names are not found there, the builtins namespace is searched
next. If the names are also not found in the builtins namespace, new
variables are created in the global namespace. The global statement
must precede all uses of the listed names.

The "global" statement has the same scope as a name binding operation
in the same block.  If the nearest enclosing scope for a free variable
contains a global statement, the free variable is treated as a global.

The "nonlocal" statement causes corresponding names to refer to
previously bound variables in the nearest enclosing function scope.
"SyntaxError" is raised at compile time if the given name does not
exist in any enclosing function scope. Type parameters cannot be
rebound with the "nonlocal" statement.

The namespace for a module is automatically created the first time a
module is imported.  The main module for a script is always called
"__main__".

Class definition blocks and arguments to "exec()" and "eval()" are
special in the context of name resolution. A class definition is an
executable statement that may use and define names. These references
follow the normal rules for name resolution with an exception that
unbound local variables are looked up in the global namespace. The
namespace of the class definition becomes the attribute dictionary of
the class. The scope of names defined in a class block is limited to
the class block; it does not extend to the code blocks of methods.
This includes comprehensions and generator expressions, but it does
not include annotation scopes, which have access to their enclosing
class scopes. This means that the following will fail:

   class A:
       a = 42
       b = list(a + i for i in range(10))

However, the following will succeed:

   class A:
       type Alias = Nested
       class Nested: pass

   print(A.Alias.__value__)  # <type 'A.Nested'>


Annotation scopes
-----------------

Type parameter lists and "type" statements introduce *annotation
scopes*, which behave mostly like function scopes, but with some
exceptions discussed below. *Annotations* currently do not use
annotation scopes, but they are expected to use annotation scopes in
Python 3.13 when **PEP 649** is implemented.

Annotation scopes are used in the following contexts:

* Type parameter lists for generic type aliases.

* Type parameter lists for generic functions. A generic function’s
  annotations are executed within the annotation scope, but its
  defaults and decorators are not.

* Type parameter lists for generic classes. A generic class’s base
  classes and keyword arguments are executed within the annotation
  scope, but its decorators are not.

* The bounds and constraints for type variables (lazily evaluated).

* The value of type aliases (lazily evaluated).

Annotation scopes differ from function scopes in the following ways:

* Annotation scopes have access to their enclosing class namespace. If
  an annotation scope is immediately within a class scope, or within
  another annotation scope that is immediately within a class scope,
  the code in the annotation scope can use names defined in the class
  scope as if it were executed directly within the class body. This
  contrasts with regular functions defined within classes, which
  cannot access names defined in the class scope.

* Expressions in annotation scopes cannot contain "yield", "yield
  from", "await", or ":=" expressions. (These expressions are allowed
  in other scopes contained within the annotation scope.)

* Names defined in annotation scopes cannot be rebound with "nonlocal"
  statements in inner scopes. This includes only type parameters, as
  no other syntactic elements that can appear within annotation scopes
  can introduce new names.

* While annotation scopes have an internal name, that name is not
  reflected in the *qualified name* of objects defined within the
  scope. Instead, the "__qualname__" of such objects is as if the
  object were defined in the enclosing scope.

Added in version 3.12: Annotation scopes were introduced in Python
3.12 as part of **PEP 695**.


Lazy evaluation
---------------

The values of type aliases created through the "type" statement are
*lazily evaluated*. The same applies to the bounds and constraints of
type variables created through the type parameter syntax. This means
that they are not evaluated when the type alias or type variable is
created. Instead, they are only evaluated when doing so is necessary
to resolve an attribute access.

Example:

   >>> type Alias = 1/0
   >>> Alias.__value__
   Traceback (most recent call last):
     ...
   ZeroDivisionError: division by zero
   >>> def func[T: 1/0](): pass
   >>> T = func.__type_params__[0]
   >>> T.__bound__
   Traceback (most recent call last):
     ...
   ZeroDivisionError: division by zero

Here the exception is raised only when the "__value__" attribute of
the type alias or the "__bound__" attribute of the type variable is
accessed.

This behavior is primarily useful for references to types that have
not yet been defined when the type alias or type variable is created.
For example, lazy evaluation enables creation of mutually recursive
type aliases:

   from typing import Literal

   type SimpleExpr = int | Parenthesized
   type Parenthesized = tuple[Literal["("], Expr, Literal[")"]]
   type Expr = SimpleExpr | tuple[SimpleExpr, Literal["+", "-"], Expr]

Lazily evaluated values are evaluated in annotation scope, which means
that names that appear inside the lazily evaluated value are looked up
as if they were used in the immediately enclosing scope.

Added in version 3.12.


Builtins and restricted execution
---------------------------------

**CPython implementation detail:** Users should not touch
"__builtins__"; it is strictly an implementation detail.  Users
wanting to override values in the builtins namespace should "import"
the "builtins" module and modify its attributes appropriately.

The builtins namespace associated with the execution of a code block
is actually found by looking up the name "__builtins__" in its global
namespace; this should be a dictionary or a module (in the latter case
the module’s dictionary is used).  By default, when in the "__main__"
module, "__builtins__" is the built-in module "builtins"; when in any
other module, "__builtins__" is an alias for the dictionary of the
"builtins" module itself.


Interaction with dynamic features
---------------------------------

Name resolution of free variables occurs at runtime, not at compile
time. This means that the following code will print 42:

   i = 10
   def f():
       print(i)
   i = 42
   f()

The "eval()" and "exec()" functions do not have access to the full
environment for resolving names.  Names may be resolved in the local
and global namespaces of the caller.  Free variables are not resolved
in the nearest enclosing namespace, but in the global namespace.  [1]
The "exec()" and "eval()" functions have optional arguments to
override the global and local namespace.  If only one namespace is
specified, it is used for both.


Exceptions
==========

Exceptions are a means of breaking out of the normal flow of control
of a code block in order to handle errors or other exceptional
conditions.  An exception is *raised* at the point where the error is
detected; it may be *handled* by the surrounding code block or by any
code block that directly or indirectly invoked the code block where
the error occurred.

The Python interpreter raises an exception when it detects a run-time
error (such as division by zero).  A Python program can also
explicitly raise an exception with the "raise" statement. Exception
handlers are specified with the "try" … "except" statement.  The
"finally" clause of such a statement can be used to specify cleanup
code which does not handle the exception, but is executed whether an
exception occurred or not in the preceding code.

Python uses the “termination” model of error handling: an exception
handler can find out what happened and continue execution at an outer
level, but it cannot repair the cause of the error and retry the
failing operation (except by re-entering the offending piece of code
from the top).

When an exception is not handled at all, the interpreter terminates
execution of the program, or returns to its interactive main loop.  In
either case, it prints a stack traceback, except when the exception is
"SystemExit".

Exceptions are identified by class instances.  The "except" clause is
selected depending on the class of the instance: it must reference the
class of the instance or a *non-virtual base class* thereof. The
instance can be received by the handler and can carry additional
information about the exceptional condition.

Note:

  Exception messages are not part of the Python API.  Their contents
  may change from one version of Python to the next without warning
  and should not be relied on by code which will run under multiple
  versions of the interpreter.

See also the description of the "try" statement in section The try
statement and "raise" statement in section The raise statement.

-[ Footnotes ]-

[1] This limitation occurs because the code that is executed by these
    operations is not available at the time the module is compiled.
''',
    'exprlists': r'''Expression lists
****************

   starred_expression       ::= ["*"] or_expr
   flexible_expression      ::= assignment_expression | starred_expression
   flexible_expression_list ::= flexible_expression ("," flexible_expression)* [","]
   starred_expression_list  ::= starred_expression ("," starred_expression)* [","]
   expression_list          ::= expression ("," expression)* [","]
   yield_list               ::= expression_list | starred_expression "," [starred_expression_list]

Except when part of a list or set display, an expression list
containing at least one comma yields a tuple.  The length of the tuple
is the number of expressions in the list.  The expressions are
evaluated from left to right.

An asterisk "*" denotes *iterable unpacking*.  Its operand must be an
*iterable*.  The iterable is expanded into a sequence of items, which
are included in the new tuple, list, or set, at the site of the
unpacking.

Added in version 3.5: Iterable unpacking in expression lists,
originally proposed by **PEP 448**.

Added in version 3.11: Any item in an expression list may be starred.
See **PEP 646**.

A trailing comma is required only to create a one-item tuple, such as
"1,"; it is optional in all other cases. A single expression without a
trailing comma doesn’t create a tuple, but rather yields the value of
that expression. (To create an empty tuple, use an empty pair of
parentheses: "()".)
''',
    'floating': r'''Floating-point literals
***********************

Floating-point literals are described by the following lexical
definitions:

   floatnumber   ::= pointfloat | exponentfloat
   pointfloat    ::= [digitpart] fraction | digitpart "."
   exponentfloat ::= (digitpart | pointfloat) exponent
   digitpart     ::= digit (["_"] digit)*
   fraction      ::= "." digitpart
   exponent      ::= ("e" | "E") ["+" | "-"] digitpart

Note that the integer and exponent parts are always interpreted using
radix 10. For example, "077e010" is legal, and denotes the same number
as "77e10". The allowed range of floating-point literals is
implementation-dependent.  As in integer literals, underscores are
supported for digit grouping.

Some examples of floating-point literals:

   3.14    10.    .001    1e100    3.14e-10    0e0    3.14_15_93

Changed in version 3.6: Underscores are now allowed for grouping
purposes in literals.
''',
    'for': r'''The "for" statement
*******************

The "for" statement is used to iterate over the elements of a sequence
(such as a string, tuple or list) or other iterable object:

   for_stmt ::= "for" target_list "in" starred_list ":" suite
                ["else" ":" suite]

The "starred_list" expression is evaluated once; it should yield an
*iterable* object.  An *iterator* is created for that iterable. The
first item provided by the iterator is then assigned to the target
list using the standard rules for assignments (see Assignment
statements), and the suite is executed.  This repeats for each item
provided by the iterator.  When the iterator is exhausted, the suite
in the "else" clause, if present, is executed, and the loop
terminates.

A "break" statement executed in the first suite terminates the loop
without executing the "else" clause’s suite.  A "continue" statement
executed in the first suite skips the rest of the suite and continues
with the next item, or with the "else" clause if there is no next
item.

The for-loop makes assignments to the variables in the target list.
This overwrites all previous assignments to those variables including
those made in the suite of the for-loop:

   for i in range(10):
       print(i)
       i = 5             # this will not affect the for-loop
                         # because i will be overwritten with the next
                         # index in the range

Names in the target list are not deleted when the loop is finished,
but if the sequence is empty, they will not have been assigned to at
all by the loop.  Hint: the built-in type "range()" represents
immutable arithmetic sequences of integers. For instance, iterating
"range(3)" successively yields 0, 1, and then 2.

Changed in version 3.11: Starred elements are now allowed in the
expression list.
''',
    'formatstrings': r'''Format String Syntax
********************

The "str.format()" method and the "Formatter" class share the same
syntax for format strings (although in the case of "Formatter",
subclasses can define their own format string syntax).  The syntax is
related to that of formatted string literals, but it is less
sophisticated and, in particular, does not support arbitrary
expressions.

Format strings contain “replacement fields” surrounded by curly braces
"{}". Anything that is not contained in braces is considered literal
text, which is copied unchanged to the output.  If you need to include
a brace character in the literal text, it can be escaped by doubling:
"{{" and "}}".

The grammar for a replacement field is as follows:

   replacement_field ::= "{" [field_name] ["!" conversion] [":" format_spec] "}"
   field_name        ::= arg_name ("." attribute_name | "[" element_index "]")*
   arg_name          ::= [identifier | digit+]
   attribute_name    ::= identifier
   element_index     ::= digit+ | index_string
   index_string      ::= <any source character except "]"> +
   conversion        ::= "r" | "s" | "a"
   format_spec       ::= format-spec:format_spec

In less formal terms, the replacement field can start with a
*field_name* that specifies the object whose value is to be formatted
and inserted into the output instead of the replacement field. The
*field_name* is optionally followed by a  *conversion* field, which is
preceded by an exclamation point "'!'", and a *format_spec*, which is
preceded by a colon "':'".  These specify a non-default format for the
replacement value.

See also the Format Specification Mini-Language section.

The *field_name* itself begins with an *arg_name* that is either a
number or a keyword.  If it’s a number, it refers to a positional
argument, and if it’s a keyword, it refers to a named keyword
argument. An *arg_name* is treated as a number if a call to
"str.isdecimal()" on the string would return true. If the numerical
arg_names in a format string are 0, 1, 2, … in sequence, they can all
be omitted (not just some) and the numbers 0, 1, 2, … will be
automatically inserted in that order. Because *arg_name* is not quote-
delimited, it is not possible to specify arbitrary dictionary keys
(e.g., the strings "'10'" or "':-]'") within a format string. The
*arg_name* can be followed by any number of index or attribute
expressions. An expression of the form "'.name'" selects the named
attribute using "getattr()", while an expression of the form
"'[index]'" does an index lookup using "__getitem__()".

Changed in version 3.1: The positional argument specifiers can be
omitted for "str.format()", so "'{} {}'.format(a, b)" is equivalent to
"'{0} {1}'.format(a, b)".

Changed in version 3.4: The positional argument specifiers can be
omitted for "Formatter".

Some simple format string examples:

   "First, thou shalt count to {0}"  # References first positional argument
   "Bring me a {}"                   # Implicitly references the first positional argument
   "From {} to {}"                   # Same as "From {0} to {1}"
   "My quest is {name}"              # References keyword argument 'name'
   "Weight in tons {0.weight}"       # 'weight' attribute of first positional arg
   "Units destroyed: {players[0]}"   # First element of keyword argument 'players'.

The *conversion* field causes a type coercion before formatting.
Normally, the job of formatting a value is done by the "__format__()"
method of the value itself.  However, in some cases it is desirable to
force a type to be formatted as a string, overriding its own
definition of formatting.  By converting the value to a string before
calling "__format__()", the normal formatting logic is bypassed.

Three conversion flags are currently supported: "'!s'" which calls
"str()" on the value, "'!r'" which calls "repr()" and "'!a'" which
calls "ascii()".

Some examples:

   "Harold's a clever {0!s}"        # Calls str() on the argument first
   "Bring out the holy {name!r}"    # Calls repr() on the argument first
   "More {!a}"                      # Calls ascii() on the argument first

The *format_spec* field contains a specification of how the value
should be presented, including such details as field width, alignment,
padding, decimal precision and so on.  Each value type can define its
own “formatting mini-language” or interpretation of the *format_spec*.

Most built-in types support a common formatting mini-language, which
is described in the next section.

A *format_spec* field can also include nested replacement fields
within it. These nested replacement fields may contain a field name,
conversion flag and format specification, but deeper nesting is not
allowed.  The replacement fields within the format_spec are
substituted before the *format_spec* string is interpreted. This
allows the formatting of a value to be dynamically specified.

See the Format examples section for some examples.


Format Specification Mini-Language
==================================

“Format specifications” are used within replacement fields contained
within a format string to define how individual values are presented
(see Format String Syntax and f-strings). They can also be passed
directly to the built-in "format()" function.  Each formattable type
may define how the format specification is to be interpreted.

Most built-in types implement the following options for format
specifications, although some of the formatting options are only
supported by the numeric types.

A general convention is that an empty format specification produces
the same result as if you had called "str()" on the value. A non-empty
format specification typically modifies the result.

The general form of a *standard format specifier* is:

   format_spec ::= [options][width][grouping]["." precision][type]
   options     ::= [[fill]align][sign]["z"]["#"]["0"]
   fill        ::= <any character>
   align       ::= "<" | ">" | "=" | "^"
   sign        ::= "+" | "-" | " "
   width       ::= digit+
   grouping    ::= "," | "_"
   precision   ::= digit+
   type        ::= "b" | "c" | "d" | "e" | "E" | "f" | "F" | "g"
                   | "G" | "n" | "o" | "s" | "x" | "X" | "%"

If a valid *align* value is specified, it can be preceded by a *fill*
character that can be any character and defaults to a space if
omitted. It is not possible to use a literal curly brace (”"{"” or
“"}"”) as the *fill* character in a formatted string literal or when
using the "str.format()" method.  However, it is possible to insert a
curly brace with a nested replacement field.  This limitation doesn’t
affect the "format()" function.

The meaning of the various alignment options is as follows:

+-----------+------------------------------------------------------------+
| Option    | Meaning                                                    |
|===========|============================================================|
| "'<'"     | Forces the field to be left-aligned within the available   |
|           | space (this is the default for most objects).              |
+-----------+------------------------------------------------------------+
| "'>'"     | Forces the field to be right-aligned within the available  |
|           | space (this is the default for numbers).                   |
+-----------+------------------------------------------------------------+
| "'='"     | Forces the padding to be placed after the sign (if any)    |
|           | but before the digits.  This is used for printing fields   |
|           | in the form ‘+000000120’. This alignment option is only    |
|           | valid for numeric types, excluding "complex". It becomes   |
|           | the default for numbers when ‘0’ immediately precedes the  |
|           | field width.                                               |
+-----------+------------------------------------------------------------+
| "'^'"     | Forces the field to be centered within the available       |
|           | space.                                                     |
+-----------+------------------------------------------------------------+

Note that unless a minimum field width is defined, the field width
will always be the same size as the data to fill it, so that the
alignment option has no meaning in this case.

The *sign* option is only valid for number types, and can be one of
the following:

+-----------+------------------------------------------------------------+
| Option    | Meaning                                                    |
|===========|============================================================|
| "'+'"     | Indicates that a sign should be used for both positive as  |
|           | well as negative numbers.                                  |
+-----------+------------------------------------------------------------+
| "'-'"     | Indicates that a sign should be used only for negative     |
|           | numbers (this is the default behavior).                    |
+-----------+------------------------------------------------------------+
| space     | Indicates that a leading space should be used on positive  |
|           | numbers, and a minus sign on negative numbers.             |
+-----------+------------------------------------------------------------+

The "'z'" option coerces negative zero floating-point values to
positive zero after rounding to the format precision.  This option is
only valid for floating-point presentation types.

Changed in version 3.11: Added the "'z'" option (see also **PEP
682**).

The "'#'" option causes the “alternate form” to be used for the
conversion.  The alternate form is defined differently for different
types.  This option is only valid for integer, float and complex
types. For integers, when binary, octal, or hexadecimal output is
used, this option adds the respective prefix "'0b'", "'0o'", "'0x'",
or "'0X'" to the output value. For float and complex the alternate
form causes the result of the conversion to always contain a decimal-
point character, even if no digits follow it. Normally, a decimal-
point character appears in the result of these conversions only if a
digit follows it. In addition, for "'g'" and "'G'" conversions,
trailing zeros are not removed from the result.

The *width* is a decimal integer defining the minimum total field
width, including any prefixes, separators, and other formatting
characters. If not specified, then the field width will be determined
by the content.

When no explicit alignment is given, preceding the *width* field by a
zero ("'0'") character enables sign-aware zero-padding for numeric
types, excluding "complex".  This is equivalent to a *fill* character
of "'0'" with an *alignment* type of "'='".

Changed in version 3.10: Preceding the *width* field by "'0'" no
longer affects the default alignment for strings.

The *grouping* option after the *width* field specifies a digit group
separator for the integral part of a number. It can be one of the
following:

+-----------+------------------------------------------------------------+
| Option    | Meaning                                                    |
|===========|============================================================|
| "','"     | Inserts a comma every 3 digits for integer presentation    |
|           | type "'d'" and floating-point presentation types,          |
|           | excluding "'n'". For other presentation types, this option |
|           | is not supported.                                          |
+-----------+------------------------------------------------------------+
| "'_'"     | Inserts an underscore every 3 digits for integer           |
|           | presentation type "'d'" and floating-point presentation    |
|           | types, excluding "'n'". For integer presentation types     |
|           | "'b'", "'o'", "'x'", and "'X'", underscores are inserted   |
|           | every 4 digits. For other presentation types, this option  |
|           | is not supported.                                          |
+-----------+------------------------------------------------------------+

For a locale aware separator, use the "'n'" presentation type instead.

Changed in version 3.1: Added the "','" option (see also **PEP 378**).

Changed in version 3.6: Added the "'_'" option (see also **PEP 515**).

The *precision* is a decimal integer indicating how many digits should
be displayed after the decimal point for presentation types "'f'" and
"'F'", or before and after the decimal point for presentation types
"'g'" or "'G'".  For string presentation types the field indicates the
maximum field size - in other words, how many characters will be used
from the field content.  The *precision* is not allowed for integer
presentation types.

Finally, the *type* determines how the data should be presented.

The available string presentation types are:

   +-----------+------------------------------------------------------------+
   | Type      | Meaning                                                    |
   |===========|============================================================|
   | "'s'"     | String format. This is the default type for strings and    |
   |           | may be omitted.                                            |
   +-----------+------------------------------------------------------------+
   | None      | The same as "'s'".                                         |
   +-----------+------------------------------------------------------------+

The available integer presentation types are:

   +-----------+------------------------------------------------------------+
   | Type      | Meaning                                                    |
   |===========|============================================================|
   | "'b'"     | Binary format. Outputs the number in base 2.               |
   +-----------+------------------------------------------------------------+
   | "'c'"     | Character. Converts the integer to the corresponding       |
   |           | unicode character before printing.                         |
   +-----------+------------------------------------------------------------+
   | "'d'"     | Decimal Integer. Outputs the number in base 10.            |
   +-----------+------------------------------------------------------------+
   | "'o'"     | Octal format. Outputs the number in base 8.                |
   +-----------+------------------------------------------------------------+
   | "'x'"     | Hex format. Outputs the number in base 16, using lower-    |
   |           | case letters for the digits above 9.                       |
   +-----------+------------------------------------------------------------+
   | "'X'"     | Hex format. Outputs the number in base 16, using upper-    |
   |           | case letters for the digits above 9. In case "'#'" is      |
   |           | specified, the prefix "'0x'" will be upper-cased to "'0X'" |
   |           | as well.                                                   |
   +-----------+------------------------------------------------------------+
   | "'n'"     | Number. This is the same as "'d'", except that it uses the |
   |           | current locale setting to insert the appropriate digit     |
   |           | group separators.                                          |
   +-----------+------------------------------------------------------------+
   | None      | The same as "'d'".                                         |
   +-----------+------------------------------------------------------------+

In addition to the above presentation types, integers can be formatted
with the floating-point presentation types listed below (except "'n'"
and "None"). When doing so, "float()" is used to convert the integer
to a floating-point number before formatting.

The available presentation types for "float" and "Decimal" values are:

   +-----------+------------------------------------------------------------+
   | Type      | Meaning                                                    |
   |===========|============================================================|
   | "'e'"     | Scientific notation. For a given precision "p", formats    |
   |           | the number in scientific notation with the letter ‘e’      |
   |           | separating the coefficient from the exponent. The          |
   |           | coefficient has one digit before and "p" digits after the  |
   |           | decimal point, for a total of "p + 1" significant digits.  |
   |           | With no precision given, uses a precision of "6" digits    |
   |           | after the decimal point for "float", and shows all         |
   |           | coefficient digits for "Decimal".  If "p=0", the decimal   |
   |           | point is omitted unless the "#" option is used.            |
   +-----------+------------------------------------------------------------+
   | "'E'"     | Scientific notation. Same as "'e'" except it uses an upper |
   |           | case ‘E’ as the separator character.                       |
   +-----------+------------------------------------------------------------+
   | "'f'"     | Fixed-point notation. For a given precision "p", formats   |
   |           | the number as a decimal number with exactly "p" digits     |
   |           | following the decimal point. With no precision given, uses |
   |           | a precision of "6" digits after the decimal point for      |
   |           | "float", and uses a precision large enough to show all     |
   |           | coefficient digits for "Decimal".  If "p=0", the decimal   |
   |           | point is omitted unless the "#" option is used.            |
   +-----------+------------------------------------------------------------+
   | "'F'"     | Fixed-point notation. Same as "'f'", but converts "nan" to |
   |           | "NAN" and "inf" to "INF".                                  |
   +-----------+------------------------------------------------------------+
   | "'g'"     | General format.  For a given precision "p >= 1", this      |
   |           | rounds the number to "p" significant digits and then       |
   |           | formats the result in either fixed-point format or in      |
   |           | scientific notation, depending on its magnitude. A         |
   |           | precision of "0" is treated as equivalent to a precision   |
   |           | of "1".  The precise rules are as follows: suppose that    |
   |           | the result formatted with presentation type "'e'" and      |
   |           | precision "p-1" would have exponent "exp".  Then, if "m <= |
   |           | exp < p", where "m" is -4 for floats and -6 for            |
   |           | "Decimals", the number is formatted with presentation type |
   |           | "'f'" and precision "p-1-exp".  Otherwise, the number is   |
   |           | formatted with presentation type "'e'" and precision       |
   |           | "p-1". In both cases insignificant trailing zeros are      |
   |           | removed from the significand, and the decimal point is     |
   |           | also removed if there are no remaining digits following    |
   |           | it, unless the "'#'" option is used.  With no precision    |
   |           | given, uses a precision of "6" significant digits for      |
   |           | "float". For "Decimal", the coefficient of the result is   |
   |           | formed from the coefficient digits of the value;           |
   |           | scientific notation is used for values smaller than "1e-6" |
   |           | in absolute value and values where the place value of the  |
   |           | least significant digit is larger than 1, and fixed-point  |
   |           | notation is used otherwise.  Positive and negative         |
   |           | infinity, positive and negative zero, and nans, are        |
   |           | formatted as "inf", "-inf", "0", "-0" and "nan"            |
   |           | respectively, regardless of the precision.                 |
   +-----------+------------------------------------------------------------+
   | "'G'"     | General format. Same as "'g'" except switches to "'E'" if  |
   |           | the number gets too large. The representations of infinity |
   |           | and NaN are uppercased, too.                               |
   +-----------+------------------------------------------------------------+
   | "'n'"     | Number. This is the same as "'g'", except that it uses the |
   |           | current locale setting to insert the appropriate digit     |
   |           | group separators for the integral part of a number.        |
   +-----------+------------------------------------------------------------+
   | "'%'"     | Percentage. Multiplies the number by 100 and displays in   |
   |           | fixed ("'f'") format, followed by a percent sign.          |
   +-----------+------------------------------------------------------------+
   | None      | For "float" this is like the "'g'" type, except that when  |
   |           | fixed- point notation is used to format the result, it     |
   |           | always includes at least one digit past the decimal point, |
   |           | and switches to the scientific notation when "exp >= p -   |
   |           | 1".  When the precision is not specified, the latter will  |
   |           | be as large as needed to represent the given value         |
   |           | faithfully.  For "Decimal", this is the same as either     |
   |           | "'g'" or "'G'" depending on the value of                   |
   |           | "context.capitals" for the current decimal context.  The   |
   |           | overall effect is to match the output of "str()" as        |
   |           | altered by the other format modifiers.                     |
   +-----------+------------------------------------------------------------+

The result should be correctly rounded to a given precision "p" of
digits after the decimal point.  The rounding mode for "float" matches
that of the "round()" builtin.  For "Decimal", the rounding mode of
the current context will be used.

The available presentation types for "complex" are the same as those
for "float" ("'%'" is not allowed).  Both the real and imaginary
components of a complex number are formatted as floating-point
numbers, according to the specified presentation type.  They are
separated by the mandatory sign of the imaginary part, the latter
being terminated by a "j" suffix.  If the presentation type is
missing, the result will match the output of "str()" (complex numbers
with a non-zero real part are also surrounded by parentheses),
possibly altered by other format modifiers.


Format examples
===============

This section contains examples of the "str.format()" syntax and
comparison with the old "%"-formatting.

In most of the cases the syntax is similar to the old "%"-formatting,
with the addition of the "{}" and with ":" used instead of "%". For
example, "'%03.2f'" can be translated to "'{:03.2f}'".

The new format syntax also supports new and different options, shown
in the following examples.

Accessing arguments by position:

   >>> '{0}, {1}, {2}'.format('a', 'b', 'c')
   'a, b, c'
   >>> '{}, {}, {}'.format('a', 'b', 'c')  # 3.1+ only
   'a, b, c'
   >>> '{2}, {1}, {0}'.format('a', 'b', 'c')
   'c, b, a'
   >>> '{2}, {1}, {0}'.format(*'abc')      # unpacking argument sequence
   'c, b, a'
   >>> '{0}{1}{0}'.format('abra', 'cad')   # arguments' indices can be repeated
   'abracadabra'

Accessing arguments by name:

   >>> 'Coordinates: {latitude}, {longitude}'.format(latitude='37.24N', longitude='-115.81W')
   'Coordinates: 37.24N, -115.81W'
   >>> coord = {'latitude': '37.24N', 'longitude': '-115.81W'}
   >>> 'Coordinates: {latitude}, {longitude}'.format(**coord)
   'Coordinates: 37.24N, -115.81W'

Accessing arguments’ attributes:

   >>> c = 3-5j
   >>> ('The complex number {0} is formed from the real part {0.real} '
   ...  'and the imaginary part {0.imag}.').format(c)
   'The complex number (3-5j) is formed from the real part 3.0 and the imaginary part -5.0.'
   >>> class Point:
   ...     def __init__(self, x, y):
   ...         self.x, self.y = x, y
   ...     def __str__(self):
   ...         return 'Point({self.x}, {self.y})'.format(self=self)
   ...
   >>> str(Point(4, 2))
   'Point(4, 2)'

Accessing arguments’ items:

   >>> coord = (3, 5)
   >>> 'X: {0[0]};  Y: {0[1]}'.format(coord)
   'X: 3;  Y: 5'

Replacing "%s" and "%r":

   >>> "repr() shows quotes: {!r}; str() doesn't: {!s}".format('test1', 'test2')
   "repr() shows quotes: 'test1'; str() doesn't: test2"

Aligning the text and specifying a width:

   >>> '{:<30}'.format('left aligned')
   'left aligned                  '
   >>> '{:>30}'.format('right aligned')
   '                 right aligned'
   >>> '{:^30}'.format('centered')
   '           centered           '
   >>> '{:*^30}'.format('centered')  # use '*' as a fill char
   '***********centered***********'

Replacing "%+f", "%-f", and "% f" and specifying a sign:

   >>> '{:+f}; {:+f}'.format(3.14, -3.14)  # show it always
   '+3.140000; -3.140000'
   >>> '{: f}; {: f}'.format(3.14, -3.14)  # show a space for positive numbers
   ' 3.140000; -3.140000'
   >>> '{:-f}; {:-f}'.format(3.14, -3.14)  # show only the minus -- same as '{:f}; {:f}'
   '3.140000; -3.140000'

Replacing "%x" and "%o" and converting the value to different bases:

   >>> # format also supports binary numbers
   >>> "int: {0:d};  hex: {0:x};  oct: {0:o};  bin: {0:b}".format(42)
   'int: 42;  hex: 2a;  oct: 52;  bin: 101010'
   >>> # with 0x, 0o, or 0b as prefix:
   >>> "int: {0:d};  hex: {0:#x};  oct: {0:#o};  bin: {0:#b}".format(42)
   'int: 42;  hex: 0x2a;  oct: 0o52;  bin: 0b101010'

Using the comma or the underscore as a digit group separator:

   >>> '{:,}'.format(1234567890)
   '1,234,567,890'
   >>> '{:_}'.format(1234567890)
   '1_234_567_890'
   >>> '{:_b}'.format(1234567890)
   '100_1001_1001_0110_0000_0010_1101_0010'
   >>> '{:_x}'.format(1234567890)
   '4996_02d2'

Expressing a percentage:

   >>> points = 19
   >>> total = 22
   >>> 'Correct answers: {:.2%}'.format(points/total)
   'Correct answers: 86.36%'

Using type-specific formatting:

   >>> import datetime
   >>> d = datetime.datetime(2010, 7, 4, 12, 15, 58)
   >>> '{:%Y-%m-%d %H:%M:%S}'.format(d)
   '2010-07-04 12:15:58'

Nesting arguments and more complex examples:

   >>> for align, text in zip('<^>', ['left', 'center', 'right']):
   ...     '{0:{fill}{align}16}'.format(text, fill=align, align=align)
   ...
   'left<<<<<<<<<<<<'
   '^^^^^center^^^^^'
   '>>>>>>>>>>>right'
   >>>
   >>> octets = [192, 168, 0, 1]
   >>> '{:02X}{:02X}{:02X}{:02X}'.format(*octets)
   'C0A80001'
   >>> int(_, 16)
   3232235521
   >>>
   >>> width = 5
   >>> for num in range(5,12):
   ...     for base in 'dXob':
   ...         print('{0:{width}{base}}'.format(num, base=base, width=width), end=' ')
   ...     print()
   ...
       5     5     5   101
       6     6     6   110
       7     7     7   111
       8     8    10  1000
       9     9    11  1001
      10     A    12  1010
      11     B    13  1011
''',
    'function': r'''Function definitions
********************

A function definition defines a user-defined function object (see
section The standard type hierarchy):

   funcdef                   ::= [decorators] "def" funcname [type_params] "(" [parameter_list] ")"
                                 ["->" expression] ":" suite
   decorators                ::= decorator+
   decorator                 ::= "@" assignment_expression NEWLINE
   parameter_list            ::= defparameter ("," defparameter)* "," "/" ["," [parameter_list_no_posonly]]
                                 | parameter_list_no_posonly
   parameter_list_no_posonly ::= defparameter ("," defparameter)* ["," [parameter_list_starargs]]
                                 | parameter_list_starargs
   parameter_list_starargs   ::= "*" [star_parameter] ("," defparameter)* ["," [parameter_star_kwargs]]
                                 | "*" ("," defparameter)+ ["," [parameter_star_kwargs]]
                                 | parameter_star_kwargs
   parameter_star_kwargs     ::= "**" parameter [","]
   parameter                 ::= identifier [":" expression]
   star_parameter            ::= identifier [":" ["*"] expression]
   defparameter              ::= parameter ["=" expression]
   funcname                  ::= identifier

A function definition is an executable statement.  Its execution binds
the function name in the current local namespace to a function object
(a wrapper around the executable code for the function).  This
function object contains a reference to the current global namespace
as the global namespace to be used when the function is called.

The function definition does not execute the function body; this gets
executed only when the function is called. [4]

A function definition may be wrapped by one or more *decorator*
expressions. Decorator expressions are evaluated when the function is
defined, in the scope that contains the function definition.  The
result must be a callable, which is invoked with the function object
as the only argument. The returned value is bound to the function name
instead of the function object.  Multiple decorators are applied in
nested fashion. For example, the following code

   @f1(arg)
   @f2
   def func(): pass

is roughly equivalent to

   def func(): pass
   func = f1(arg)(f2(func))

except that the original function is not temporarily bound to the name
"func".

Changed in version 3.9: Functions may be decorated with any valid
"assignment_expression". Previously, the grammar was much more
restrictive; see **PEP 614** for details.

A list of type parameters may be given in square brackets between the
function’s name and the opening parenthesis for its parameter list.
This indicates to static type checkers that the function is generic.
At runtime, the type parameters can be retrieved from the function’s
"__type_params__" attribute. See Generic functions for more.

Changed in version 3.12: Type parameter lists are new in Python 3.12.

When one or more *parameters* have the form *parameter* "="
*expression*, the function is said to have “default parameter values.”
For a parameter with a default value, the corresponding *argument* may
be omitted from a call, in which case the parameter’s default value is
substituted.  If a parameter has a default value, all following
parameters up until the “"*"” must also have a default value — this is
a syntactic restriction that is not expressed by the grammar.

**Default parameter values are evaluated from left to right when the
function definition is executed.** This means that the expression is
evaluated once, when the function is defined, and that the same “pre-
computed” value is used for each call.  This is especially important
to understand when a default parameter value is a mutable object, such
as a list or a dictionary: if the function modifies the object (e.g.
by appending an item to a list), the default parameter value is in
effect modified.  This is generally not what was intended.  A way
around this is to use "None" as the default, and explicitly test for
it in the body of the function, e.g.:

   def whats_on_the_telly(penguin=None):
       if penguin is None:
           penguin = []
       penguin.append("property of the zoo")
       return penguin

Function call semantics are described in more detail in section Calls.
A function call always assigns values to all parameters mentioned in
the parameter list, either from positional arguments, from keyword
arguments, or from default values.  If the form “"*identifier"” is
present, it is initialized to a tuple receiving any excess positional
parameters, defaulting to the empty tuple. If the form
“"**identifier"” is present, it is initialized to a new ordered
mapping receiving any excess keyword arguments, defaulting to a new
empty mapping of the same type.  Parameters after “"*"” or
“"*identifier"” are keyword-only parameters and may only be passed by
keyword arguments.  Parameters before “"/"” are positional-only
parameters and may only be passed by positional arguments.

Changed in version 3.8: The "/" function parameter syntax may be used
to indicate positional-only parameters. See **PEP 570** for details.

Parameters may have an *annotation* of the form “": expression"”
following the parameter name.  Any parameter may have an annotation,
even those of the form "*identifier" or "**identifier". (As a special
case, parameters of the form "*identifier" may have an annotation “":
*expression"”.) Functions may have “return” annotation of the form
“"-> expression"” after the parameter list.  These annotations can be
any valid Python expression.  The presence of annotations does not
change the semantics of a function.  The annotation values are
available as values of a dictionary keyed by the parameters’ names in
the "__annotations__" attribute of the function object.  If the
"annotations" import from "__future__" is used, annotations are
preserved as strings at runtime which enables postponed evaluation.
Otherwise, they are evaluated when the function definition is
executed.  In this case annotations may be evaluated in a different
order than they appear in the source code.

Changed in version 3.11: Parameters of the form “"*identifier"” may
have an annotation “": *expression"”. See **PEP 646**.

It is also possible to create anonymous functions (functions not bound
to a name), for immediate use in expressions.  This uses lambda
expressions, described in section Lambdas.  Note that the lambda
expression is merely a shorthand for a simplified function definition;
a function defined in a “"def"” statement can be passed around or
assigned to another name just like a function defined by a lambda
expression.  The “"def"” form is actually more powerful since it
allows the execution of multiple statements and annotations.

**Programmer’s note:** Functions are first-class objects.  A “"def"”
statement executed inside a function definition defines a local
function that can be returned or passed around.  Free variables used
in the nested function can access the local variables of the function
containing the def.  See section Naming and binding for details.

See also:

  **PEP 3107** - Function Annotations
     The original specification for function annotations.

  **PEP 484** - Type Hints
     Definition of a standard meaning for annotations: type hints.

  **PEP 526** - Syntax for Variable Annotations
     Ability to type hint variable declarations, including class
     variables and instance variables.

  **PEP 563** - Postponed Evaluation of Annotations
     Support for forward references within annotations by preserving
     annotations in a string form at runtime instead of eager
     evaluation.

  **PEP 318** - Decorators for Functions and Methods
     Function and method decorators were introduced. Class decorators
     were introduced in **PEP 3129**.
''',
    'global': r'''The "global" statement
**********************

   global_stmt ::= "global" identifier ("," identifier)*

The "global" statement causes the listed identifiers to be interpreted
as globals. It would be impossible to assign to a global variable
without "global", although free variables may refer to globals without
being declared global.

The "global" statement applies to the entire scope of a function or
class body. A "SyntaxError" is raised if a variable is used or
assigned to prior to its global declaration in the scope.

**Programmer’s note:** "global" is a directive to the parser.  It
applies only to code parsed at the same time as the "global"
statement. In particular, a "global" statement contained in a string
or code object supplied to the built-in "exec()" function does not
affect the code block *containing* the function call, and code
contained in such a string is unaffected by "global" statements in the
code containing the function call.  The same applies to the "eval()"
and "compile()" functions.
''',
    'id-classes': r'''Reserved classes of identifiers
*******************************

Certain classes of identifiers (besides keywords) have special
meanings.  These classes are identified by the patterns of leading and
trailing underscore characters:

"_*"
   Not imported by "from module import *".

"_"
   In a "case" pattern within a "match" statement, "_" is a soft
   keyword that denotes a wildcard.

   Separately, the interactive interpreter makes the result of the
   last evaluation available in the variable "_". (It is stored in the
   "builtins" module, alongside built-in functions like "print".)

   Elsewhere, "_" is a regular identifier. It is often used to name
   “special” items, but it is not special to Python itself.

   Note:

     The name "_" is often used in conjunction with
     internationalization; refer to the documentation for the
     "gettext" module for more information on this convention.It is
     also commonly used for unused variables.

"__*__"
   System-defined names, informally known as “dunder” names. These
   names are defined by the interpreter and its implementation
   (including the standard library). Current system names are
   discussed in the Special method names section and elsewhere. More
   will likely be defined in future versions of Python.  *Any* use of
   "__*__" names, in any context, that does not follow explicitly
   documented use, is subject to breakage without warning.

"__*"
   Class-private names.  Names in this category, when used within the
   context of a class definition, are re-written to use a mangled form
   to help avoid name clashes between “private” attributes of base and
   derived classes. See section Identifiers (Names).
''',
    'identifiers': r'''Identifiers and keywords
************************

Identifiers (also referred to as *names*) are described by the
following lexical definitions.

The syntax of identifiers in Python is based on the Unicode standard
annex UAX-31, with elaboration and changes as defined below; see also
**PEP 3131** for further details.

Within the ASCII range (U+0001..U+007F), the valid characters for
identifiers include the uppercase and lowercase letters "A" through
"Z", the underscore "_" and, except for the first character, the
digits "0" through "9". Python 3.0 introduced additional characters
from outside the ASCII range (see **PEP 3131**).  For these
characters, the classification uses the version of the Unicode
Character Database as included in the "unicodedata" module.

Identifiers are unlimited in length.  Case is significant.

   identifier   ::= xid_start xid_continue*
   id_start     ::= <all characters in general categories Lu, Ll, Lt, Lm, Lo, Nl, the underscore, and characters with the Other_ID_Start property>
   id_continue  ::= <all characters in id_start, plus characters in the categories Mn, Mc, Nd, Pc and others with the Other_ID_Continue property>
   xid_start    ::= <all characters in id_start whose NFKC normalization is in "id_start xid_continue*">
   xid_continue ::= <all characters in id_continue whose NFKC normalization is in "id_continue*">

The Unicode category codes mentioned above stand for:

* *Lu* - uppercase letters

* *Ll* - lowercase letters

* *Lt* - titlecase letters

* *Lm* - modifier letters

* *Lo* - other letters

* *Nl* - letter numbers

* *Mn* - nonspacing marks

* *Mc* - spacing combining marks

* *Nd* - decimal numbers

* *Pc* - connector punctuations

* *Other_ID_Start* - explicit list of characters in PropList.txt to
  support backwards compatibility

* *Other_ID_Continue* - likewise

All identifiers are converted into the normal form NFKC while parsing;
comparison of identifiers is based on NFKC.

A non-normative HTML file listing all valid identifier characters for
Unicode 15.0.0 can be found at
https://www.unicode.org/Public/15.0.0/ucd/DerivedCoreProperties.txt


Keywords
========

The following identifiers are used as reserved words, or *keywords* of
the language, and cannot be used as ordinary identifiers.  They must
be spelled exactly as written here:

   False      await      else       import     pass
   None       break      except     in         raise
   True       class      finally    is         return
   and        continue   for        lambda     try
   as         def        from       nonlocal   while
   assert     del        global     not        with
   async      elif       if         or         yield


Soft Keywords
=============

Added in version 3.10.

Some identifiers are only reserved under specific contexts. These are
known as *soft keywords*.  The identifiers "match", "case", "type" and
"_" can syntactically act as keywords in certain contexts, but this
distinction is done at the parser level, not when tokenizing.

As soft keywords, their use in the grammar is possible while still
preserving compatibility with existing code that uses these names as
identifier names.

"match", "case", and "_" are used in the "match" statement. "type" is
used in the "type" statement.

Changed in version 3.12: "type" is now a soft keyword.


Reserved classes of identifiers
===============================

Certain classes of identifiers (besides keywords) have special
meanings.  These classes are identified by the patterns of leading and
trailing underscore characters:

"_*"
   Not imported by "from module import *".

"_"
   In a "case" pattern within a "match" statement, "_" is a soft
   keyword that denotes a wildcard.

   Separately, the interactive interpreter makes the result of the
   last evaluation available in the variable "_". (It is stored in the
   "builtins" module, alongside built-in functions like "print".)

   Elsewhere, "_" is a regular identifier. It is often used to name
   “special” items, but it is not special to Python itself.

   Note:

     The name "_" is often used in conjunction with
     internationalization; refer to the documentation for the
     "gettext" module for more information on this convention.It is
     also commonly used for unused variables.

"__*__"
   System-defined names, informally known as “dunder” names. These
   names are defined by the interpreter and its implementation
   (including the standard library). Current system names are
   discussed in the Special method names section and elsewhere. More
   will likely be defined in future versions of Python.  *Any* use of
   "__*__" names, in any context, that does not follow explicitly
   documented use, is subject to breakage without warning.

"__*"
   Class-private names.  Names in this category, when used within the
   context of a class definition, are re-written to use a mangled form
   to help avoid name clashes between “private” attributes of base and
   derived classes. See section Identifiers (Names).
''',
    'if': r'''The "if" statement
******************

The "if" statement is used for conditional execution:

   if_stmt ::= "if" assignment_expression ":" suite
               ("elif" assignment_expression ":" suite)*
               ["else" ":" suite]

It selects exactly one of the suites by evaluating the expressions one
by one until one is found to be true (see section Boolean operations
for the definition of true and false); then that suite is executed
(and no other part of the "if" statement is executed or evaluated).
If all expressions are false, the suite of the "else" clause, if
present, is executed.
''',
    'imaginary': r'''Imaginary literals
******************

Imaginary literals are described by the following lexical definitions:

   imagnumber ::= (floatnumber | digitpart) ("j" | "J")

An imaginary literal yields a complex number with a real part of 0.0.
Complex numbers are represented as a pair of floating-point numbers
and have the same restrictions on their range.  To create a complex
number with a nonzero real part, add a floating-point number to it,
e.g., "(3+4j)".  Some examples of imaginary literals:

   3.14j   10.j    10j     .001j   1e100j   3.14e-10j   3.14_15_93j
''',
    'import': r'''The "import" statement
**********************

   import_stmt     ::= "import" module ["as" identifier] ("," module ["as" identifier])*
                       | "from" relative_module "import" identifier ["as" identifier]
                       ("," identifier ["as" identifier])*
                       | "from" relative_module "import" "(" identifier ["as" identifier]
                       ("," identifier ["as" identifier])* [","] ")"
                       | "from" relative_module "import" "*"
   module          ::= (identifier ".")* identifier
   relative_module ::= "."* module | "."+

The basic import statement (no "from" clause) is executed in two
steps:

1. find a module, loading and initializing it if necessary

2. define a name or names in the local namespace for the scope where
   the "import" statement occurs.

When the statement contains multiple clauses (separated by commas) the
two steps are carried out separately for each clause, just as though
the clauses had been separated out into individual import statements.

The details of the first step, finding and loading modules, are
described in greater detail in the section on the import system, which
also describes the various types of packages and modules that can be
imported, as well as all the hooks that can be used to customize the
import system. Note that failures in this step may indicate either
that the module could not be located, *or* that an error occurred
while initializing the module, which includes execution of the
module’s code.

If the requested module is retrieved successfully, it will be made
available in the local namespace in one of three ways:

* If the module name is followed by "as", then the name following "as"
  is bound directly to the imported module.

* If no other name is specified, and the module being imported is a
  top level module, the module’s name is bound in the local namespace
  as a reference to the imported module

* If the module being imported is *not* a top level module, then the
  name of the top level package that contains the module is bound in
  the local namespace as a reference to the top level package. The
  imported module must be accessed using its full qualified name
  rather than directly

The "from" form uses a slightly more complex process:

1. find the module specified in the "from" clause, loading and
   initializing it if necessary;

2. for each of the identifiers specified in the "import" clauses:

   1. check if the imported module has an attribute by that name

   2. if not, attempt to import a submodule with that name and then
      check the imported module again for that attribute

   3. if the attribute is not found, "ImportError" is raised.

   4. otherwise, a reference to that value is stored in the local
      namespace, using the name in the "as" clause if it is present,
      otherwise using the attribute name

Examples:

   import foo                 # foo imported and bound locally
   import foo.bar.baz         # foo, foo.bar, and foo.bar.baz imported, foo bound locally
   import foo.bar.baz as fbb  # foo, foo.bar, and foo.bar.baz imported, foo.bar.baz bound as fbb
   from foo.bar import baz    # foo, foo.bar, and foo.bar.baz imported, foo.bar.baz bound as baz
   from foo import attr       # foo imported and foo.attr bound as attr

If the list of identifiers is replaced by a star ("'*'"), all public
names defined in the module are bound in the local namespace for the
scope where the "import" statement occurs.

The *public names* defined by a module are determined by checking the
module’s namespace for a variable named "__all__"; if defined, it must
be a sequence of strings which are names defined or imported by that
module.  The names given in "__all__" are all considered public and
are required to exist.  If "__all__" is not defined, the set of public
names includes all names found in the module’s namespace which do not
begin with an underscore character ("'_'").  "__all__" should contain
the entire public API. It is intended to avoid accidentally exporting
items that are not part of the API (such as library modules which were
imported and used within the module).

The wild card form of import — "from module import *" — is only
allowed at the module level.  Attempting to use it in class or
function definitions will raise a "SyntaxError".

When specifying what module to import you do not have to specify the
absolute name of the module. When a module or package is contained
within another package it is possible to make a relative import within
the same top package without having to mention the package name. By
using leading dots in the specified module or package after "from" you
can specify how high to traverse up the current package hierarchy
without specifying exact names. One leading dot means the current
package where the module making the import exists. Two dots means up
one package level. Three dots is up two levels, etc. So if you execute
"from . import mod" from a module in the "pkg" package then you will
end up importing "pkg.mod". If you execute "from ..subpkg2 import mod"
from within "pkg.subpkg1" you will import "pkg.subpkg2.mod". The
specification for relative imports is contained in the Package
Relative Imports section.

"importlib.import_module()" is provided to support applications that
determine dynamically the modules to be loaded.

Raises an auditing event "import" with arguments "module", "filename",
"sys.path", "sys.meta_path", "sys.path_hooks".


Future statements
=================

A *future statement* is a directive to the compiler that a particular
module should be compiled using syntax or semantics that will be
available in a specified future release of Python where the feature
becomes standard.

The future statement is intended to ease migration to future versions
of Python that introduce incompatible changes to the language.  It
allows use of the new features on a per-module basis before the
release in which the feature becomes standard.

   future_stmt ::= "from" "__future__" "import" feature ["as" identifier]
                   ("," feature ["as" identifier])*
                   | "from" "__future__" "import" "(" feature ["as" identifier]
                   ("," feature ["as" identifier])* [","] ")"
   feature     ::= identifier

A future statement must appear near the top of the module.  The only
lines that can appear before a future statement are:

* the module docstring (if any),

* comments,

* blank lines, and

* other future statements.

The only feature that requires using the future statement is
"annotations" (see **PEP 563**).

All historical features enabled by the future statement are still
recognized by Python 3.  The list includes "absolute_import",
"division", "generators", "generator_stop", "unicode_literals",
"print_function", "nested_scopes" and "with_statement".  They are all
redundant because they are always enabled, and only kept for backwards
compatibility.

A future statement is recognized and treated specially at compile
time: Changes to the semantics of core constructs are often
implemented by generating different code.  It may even be the case
that a new feature introduces new incompatible syntax (such as a new
reserved word), in which case the compiler may need to parse the
module differently.  Such decisions cannot be pushed off until
runtime.

For any given release, the compiler knows which feature names have
been defined, and raises a compile-time error if a future statement
contains a feature not known to it.

The direct runtime semantics are the same as for any import statement:
there is a standard module "__future__", described later, and it will
be imported in the usual way at the time the future statement is
executed.

The interesting runtime semantics depend on the specific feature
enabled by the future statement.

Note that there is nothing special about the statement:

   import __future__ [as name]

That is not a future statement; it’s an ordinary import statement with
no special semantics or syntax restrictions.

Code compiled by calls to the built-in functions "exec()" and
"compile()" that occur in a module "M" containing a future statement
will, by default, use the new syntax or semantics associated with the
future statement.  This can be controlled by optional arguments to
"compile()" — see the documentation of that function for details.

A future statement typed at an interactive interpreter prompt will
take effect for the rest of the interpreter session.  If an
interpreter is started with the "-i" option, is passed a script name
to execute, and the script includes a future statement, it will be in
effect in the interactive session started after the script is
executed.

See also:

  **PEP 236** - Back to the __future__
     The original proposal for the __future__ mechanism.
''',
    'in': r'''Membership test operations
**************************

The operators "in" and "not in" test for membership.  "x in s"
evaluates to "True" if *x* is a member of *s*, and "False" otherwise.
"x not in s" returns the negation of "x in s".  All built-in sequences
and set types support this as well as dictionary, for which "in" tests
whether the dictionary has a given key. For container types such as
list, tuple, set, frozenset, dict, or collections.deque, the
expression "x in y" is equivalent to "any(x is e or x == e for e in
y)".

For the string and bytes types, "x in y" is "True" if and only if *x*
is a substring of *y*.  An equivalent test is "y.find(x) != -1".
Empty strings are always considered to be a substring of any other
string, so """ in "abc"" will return "True".

For user-defined classes which define the "__contains__()" method, "x
in y" returns "True" if "y.__contains__(x)" returns a true value, and
"False" otherwise.

For user-defined classes which do not define "__contains__()" but do
define "__iter__()", "x in y" is "True" if some value "z", for which
the expression "x is z or x == z" is true, is produced while iterating
over "y". If an exception is raised during the iteration, it is as if
"in" raised that exception.

Lastly, the old-style iteration protocol is tried: if a class defines
"__getitem__()", "x in y" is "True" if and only if there is a non-
negative integer index *i* such that "x is y[i] or x == y[i]", and no
lower integer index raises the "IndexError" exception.  (If any other
exception is raised, it is as if "in" raised that exception).

The operator "not in" is defined to have the inverse truth value of
"in".
''',
    'integers': r'''Integer literals
****************

Integer literals are described by the following lexical definitions:

   integer      ::= decinteger | bininteger | octinteger | hexinteger
   decinteger   ::= nonzerodigit (["_"] digit)* | "0"+ (["_"] "0")*
   bininteger   ::= "0" ("b" | "B") (["_"] bindigit)+
   octinteger   ::= "0" ("o" | "O") (["_"] octdigit)+
   hexinteger   ::= "0" ("x" | "X") (["_"] hexdigit)+
   nonzerodigit ::= "1"..."9"
   digit        ::= "0"..."9"
   bindigit     ::= "0" | "1"
   octdigit     ::= "0"..."7"
   hexdigit     ::= digit | "a"..."f" | "A"..."F"

There is no limit for the length of integer literals apart from what
can be stored in available memory.

Underscores are ignored for determining the numeric value of the
literal.  They can be used to group digits for enhanced readability.
One underscore can occur between digits, and after base specifiers
like "0x".

Note that leading zeros in a non-zero decimal number are not allowed.
This is for disambiguation with C-style octal literals, which Python
used before version 3.0.

Some examples of integer literals:

   7     2147483647                        0o177    0b100110111
   3     79228162514264337593543950336     0o377    0xdeadbeef
         100_000_000_000                   0b_1110_0101

Changed in version 3.6: Underscores are now allowed for grouping
purposes in literals.
''',
    'lambda': r'''Lambdas
*******

   lambda_expr ::= "lambda" [parameter_list] ":" expression

Lambda expressions (sometimes called lambda forms) are used to create
anonymous functions. The expression "lambda parameters: expression"
yields a function object.  The unnamed object behaves like a function
object defined with:

   def <lambda>(parameters):
       return expression

See section Function definitions for the syntax of parameter lists.
Note that functions created with lambda expressions cannot contain
statements or annotations.
''',
    'lists': r'''List displays
*************

A list display is a possibly empty series of expressions enclosed in
square brackets:

   list_display ::= "[" [flexible_expression_list | comprehension] "]"

A list display yields a new list object, the contents being specified
by either a list of expressions or a comprehension.  When a comma-
separated list of expressions is supplied, its elements are evaluated
from left to right and placed into the list object in that order.
When a comprehension is supplied, the list is constructed from the
elements resulting from the comprehension.
''',
    'naming': r'''Naming and binding
******************


Binding of names
================

*Names* refer to objects.  Names are introduced by name binding
operations.

The following constructs bind names:

* formal parameters to functions,

* class definitions,

* function definitions,

* assignment expressions,

* targets that are identifiers if occurring in an assignment:

  * "for" loop header,

  * after "as" in a "with" statement, "except" clause, "except*"
    clause, or in the as-pattern in structural pattern matching,

  * in a capture pattern in structural pattern matching

* "import" statements.

* "type" statements.

* type parameter lists.

The "import" statement of the form "from ... import *" binds all names
defined in the imported module, except those beginning with an
underscore. This form may only be used at the module level.

A target occurring in a "del" statement is also considered bound for
this purpose (though the actual semantics are to unbind the name).

Each assignment or import statement occurs within a block defined by a
class or function definition or at the module level (the top-level
code block).

If a name is bound in a block, it is a local variable of that block,
unless declared as "nonlocal" or "global".  If a name is bound at the
module level, it is a global variable.  (The variables of the module
code block are local and global.)  If a variable is used in a code
block but not defined there, it is a *free variable*.

Each occurrence of a name in the program text refers to the *binding*
of that name established by the following name resolution rules.


Resolution of names
===================

A *scope* defines the visibility of a name within a block.  If a local
variable is defined in a block, its scope includes that block.  If the
definition occurs in a function block, the scope extends to any blocks
contained within the defining one, unless a contained block introduces
a different binding for the name.

When a name is used in a code block, it is resolved using the nearest
enclosing scope.  The set of all such scopes visible to a code block
is called the block’s *environment*.

When a name is not found at all, a "NameError" exception is raised. If
the current scope is a function scope, and the name refers to a local
variable that has not yet been bound to a value at the point where the
name is used, an "UnboundLocalError" exception is raised.
"UnboundLocalError" is a subclass of "NameError".

If a name binding operation occurs anywhere within a code block, all
uses of the name within the block are treated as references to the
current block.  This can lead to errors when a name is used within a
block before it is bound.  This rule is subtle.  Python lacks
declarations and allows name binding operations to occur anywhere
within a code block.  The local variables of a code block can be
determined by scanning the entire text of the block for name binding
operations. See the FAQ entry on UnboundLocalError for examples.

If the "global" statement occurs within a block, all uses of the names
specified in the statement refer to the bindings of those names in the
top-level namespace.  Names are resolved in the top-level namespace by
searching the global namespace, i.e. the namespace of the module
containing the code block, and the builtins namespace, the namespace
of the module "builtins".  The global namespace is searched first.  If
the names are not found there, the builtins namespace is searched
next. If the names are also not found in the builtins namespace, new
variables are created in the global namespace. The global statement
must precede all uses of the listed names.

The "global" statement has the same scope as a name binding operation
in the same block.  If the nearest enclosing scope for a free variable
contains a global statement, the free variable is treated as a global.

The "nonlocal" statement causes corresponding names to refer to
previously bound variables in the nearest enclosing function scope.
"SyntaxError" is raised at compile time if the given name does not
exist in any enclosing function scope. Type parameters cannot be
rebound with the "nonlocal" statement.

The namespace for a module is automatically created the first time a
module is imported.  The main module for a script is always called
"__main__".

Class definition blocks and arguments to "exec()" and "eval()" are
special in the context of name resolution. A class definition is an
executable statement that may use and define names. These references
follow the normal rules for name resolution with an exception that
unbound local variables are looked up in the global namespace. The
namespace of the class definition becomes the attribute dictionary of
the class. The scope of names defined in a class block is limited to
the class block; it does not extend to the code blocks of methods.
This includes comprehensions and generator expressions, but it does
not include annotation scopes, which have access to their enclosing
class scopes. This means that the following will fail:

   class A:
       a = 42
       b = list(a + i for i in range(10))

However, the following will succeed:

   class A:
       type Alias = Nested
       class Nested: pass

   print(A.Alias.__value__)  # <type 'A.Nested'>


Annotation scopes
=================

Type parameter lists and "type" statements introduce *annotation
scopes*, which behave mostly like function scopes, but with some
exceptions discussed below. *Annotations* currently do not use
annotation scopes, but they are expected to use annotation scopes in
Python 3.13 when **PEP 649** is implemented.

Annotation scopes are used in the following contexts:

* Type parameter lists for generic type aliases.

* Type parameter lists for generic functions. A generic function’s
  annotations are executed within the annotation scope, but its
  defaults and decorators are not.

* Type parameter lists for generic classes. A generic class’s base
  classes and keyword arguments are executed within the annotation
  scope, but its decorators are not.

* The bounds and constraints for type variables (lazily evaluated).

* The value of type aliases (lazily evaluated).

Annotation scopes differ from function scopes in the following ways:

* Annotation scopes have access to their enclosing class namespace. If
  an annotation scope is immediately within a class scope, or within
  another annotation scope that is immediately within a class scope,
  the code in the annotation scope can use names defined in the class
  scope as if it were executed directly within the class body. This
  contrasts with regular functions defined within classes, which
  cannot access names defined in the class scope.

* Expressions in annotation scopes cannot contain "yield", "yield
  from", "await", or ":=" expressions. (These expressions are allowed
  in other scopes contained within the annotation scope.)

* Names defined in annotation scopes cannot be rebound with "nonlocal"
  statements in inner scopes. This includes only type parameters, as
  no other syntactic elements that can appear within annotation scopes
  can introduce new names.

* While annotation scopes have an internal name, that name is not
  reflected in the *qualified name* of objects defined within the
  scope. Instead, the "__qualname__" of such objects is as if the
  object were defined in the enclosing scope.

Added in version 3.12: Annotation scopes were introduced in Python
3.12 as part of **PEP 695**.


Lazy evaluation
===============

The values of type aliases created through the "type" statement are
*lazily evaluated*. The same applies to the bounds and constraints of
type variables created through the type parameter syntax. This means
that they are not evaluated when the type alias or type variable is
created. Instead, they are only evaluated when doing so is necessary
to resolve an attribute access.

Example:

   >>> type Alias = 1/0
   >>> Alias.__value__
   Traceback (most recent call last):
     ...
   ZeroDivisionError: division by zero
   >>> def func[T: 1/0](): pass
   >>> T = func.__type_params__[0]
   >>> T.__bound__
   Traceback (most recent call last):
     ...
   ZeroDivisionError: division by zero

Here the exception is raised only when the "__value__" attribute of
the type alias or the "__bound__" attribute of the type variable is
accessed.

This behavior is primarily useful for references to types that have
not yet been defined when the type alias or type variable is created.
For example, lazy evaluation enables creation of mutually recursive
type aliases:

   from typing import Literal

   type SimpleExpr = int | Parenthesized
   type Parenthesized = tuple[Literal["("], Expr, Literal[")"]]
   type Expr = SimpleExpr | tuple[SimpleExpr, Literal["+", "-"], Expr]

Lazily evaluated values are evaluated in annotation scope, which means
that names that appear inside the lazily evaluated value are looked up
as if they were used in the immediately enclosing scope.

Added in version 3.12.


Builtins and restricted execution
=================================

**CPython implementation detail:** Users should not touch
"__builtins__"; it is strictly an implementation detail.  Users
wanting to override values in the builtins namespace should "import"
the "builtins" module and modify its attributes appropriately.

The builtins namespace associated with the execution of a code block
is actually found by looking up the name "__builtins__" in its global
namespace; this should be a dictionary or a module (in the latter case
the module’s dictionary is used).  By default, when in the "__main__"
module, "__builtins__" is the built-in module "builtins"; when in any
other module, "__builtins__" is an alias for the dictionary of the
"builtins" module itself.


Interaction with dynamic features
=================================

Name resolution of free variables occurs at runtime, not at compile
time. This means that the following code will print 42:

   i = 10
   def f():
       print(i)
   i = 42
   f()

The "eval()" and "exec()" functions do not have access to the full
environment for resolving names.  Names may be resolved in the local
and global namespaces of the caller.  Free variables are not resolved
in the nearest enclosing namespace, but in the global namespace.  [1]
The "exec()" and "eval()" functions have optional arguments to
override the global and local namespace.  If only one namespace is
specified, it is used for both.
''',
    'nonlocal': r'''The "nonlocal" statement
************************

   nonlocal_stmt ::= "nonlocal" identifier ("," identifier)*

When the definition of a function or class is nested (enclosed) within
the definitions of other functions, its nonlocal scopes are the local
scopes of the enclosing functions. The "nonlocal" statement causes the
listed identifiers to refer to names previously bound in nonlocal
scopes. It allows encapsulated code to rebind such nonlocal
identifiers.  If a name is bound in more than one nonlocal scope, the
nearest binding is used. If a name is not bound in any nonlocal scope,
or if there is no nonlocal scope, a "SyntaxError" is raised.

The "nonlocal" statement applies to the entire scope of a function or
class body. A "SyntaxError" is raised if a variable is used or
assigned to prior to its nonlocal declaration in the scope.

See also:

  **PEP 3104** - Access to Names in Outer Scopes
     The specification for the "nonlocal" statement.

**Programmer’s note:** "nonlocal" is a directive to the parser and
applies only to code parsed along with it.  See the note for the
"global" statement.
''',
    'numbers': r'''Numeric literals
****************

There are three types of numeric literals: integers, floating-point
numbers, and imaginary numbers.  There are no complex literals
(complex numbers can be formed by adding a real number and an
imaginary number).

Note that numeric literals do not include a sign; a phrase like "-1"
is actually an expression composed of the unary operator ‘"-"’ and the
literal "1".
''',
    'numeric-types': r'''Emulating numeric types
***********************

The following methods can be defined to emulate numeric objects.
Methods corresponding to operations that are not supported by the
particular kind of number implemented (e.g., bitwise operations for
non-integral numbers) should be left undefined.

object.__add__(self, other)
object.__sub__(self, other)
object.__mul__(self, other)
object.__matmul__(self, other)
object.__truediv__(self, other)
object.__floordiv__(self, other)
object.__mod__(self, other)
object.__divmod__(self, other)
object.__pow__(self, other[, modulo])
object.__lshift__(self, other)
object.__rshift__(self, other)
object.__and__(self, other)
object.__xor__(self, other)
object.__or__(self, other)

   These methods are called to implement the binary arithmetic
   operations ("+", "-", "*", "@", "/", "//", "%", "divmod()",
   "pow()", "**", "<<", ">>", "&", "^", "|").  For instance, to
   evaluate the expression "x + y", where *x* is an instance of a
   class that has an "__add__()" method, "type(x).__add__(x, y)" is
   called.  The "__divmod__()" method should be the equivalent to
   using "__floordiv__()" and "__mod__()"; it should not be related to
   "__truediv__()".  Note that "__pow__()" should be defined to accept
   an optional third argument if the ternary version of the built-in
   "pow()" function is to be supported.

   If one of those methods does not support the operation with the
   supplied arguments, it should return "NotImplemented".

object.__radd__(self, other)
object.__rsub__(self, other)
object.__rmul__(self, other)
object.__rmatmul__(self, other)
object.__rtruediv__(self, other)
object.__rfloordiv__(self, other)
object.__rmod__(self, other)
object.__rdivmod__(self, other)
object.__rpow__(self, other[, modulo])
object.__rlshift__(self, other)
object.__rrshift__(self, other)
object.__rand__(self, other)
object.__rxor__(self, other)
object.__ror__(self, other)

   These methods are called to implement the binary arithmetic
   operations ("+", "-", "*", "@", "/", "//", "%", "divmod()",
   "pow()", "**", "<<", ">>", "&", "^", "|") with reflected (swapped)
   operands.  These functions are only called if the left operand does
   not support the corresponding operation [3] and the operands are of
   different types. [4] For instance, to evaluate the expression "x -
   y", where *y* is an instance of a class that has an "__rsub__()"
   method, "type(y).__rsub__(y, x)" is called if "type(x).__sub__(x,
   y)" returns "NotImplemented".

   Note that ternary "pow()" will not try calling "__rpow__()" (the
   coercion rules would become too complicated).

   Note:

     If the right operand’s type is a subclass of the left operand’s
     type and that subclass provides a different implementation of the
     reflected method for the operation, this method will be called
     before the left operand’s non-reflected method. This behavior
     allows subclasses to override their ancestors’ operations.

object.__iadd__(self, other)
object.__isub__(self, other)
object.__imul__(self, other)
object.__imatmul__(self, other)
object.__itruediv__(self, other)
object.__ifloordiv__(self, other)
object.__imod__(self, other)
object.__ipow__(self, other[, modulo])
object.__ilshift__(self, other)
object.__irshift__(self, other)
object.__iand__(self, other)
object.__ixor__(self, other)
object.__ior__(self, other)

   These methods are called to implement the augmented arithmetic
   assignments ("+=", "-=", "*=", "@=", "/=", "//=", "%=", "**=",
   "<<=", ">>=", "&=", "^=", "|=").  These methods should attempt to
   do the operation in-place (modifying *self*) and return the result
   (which could be, but does not have to be, *self*).  If a specific
   method is not defined, or if that method returns "NotImplemented",
   the augmented assignment falls back to the normal methods.  For
   instance, if *x* is an instance of a class with an "__iadd__()"
   method, "x += y" is equivalent to "x = x.__iadd__(y)" . If
   "__iadd__()" does not exist, or if "x.__iadd__(y)" returns
   "NotImplemented", "x.__add__(y)" and "y.__radd__(x)" are
   considered, as with the evaluation of "x + y". In certain
   situations, augmented assignment can result in unexpected errors
   (see Why does a_tuple[i] += [‘item’] raise an exception when the
   addition works?), but this behavior is in fact part of the data
   model.

object.__neg__(self)
object.__pos__(self)
object.__abs__(self)
object.__invert__(self)

   Called to implement the unary arithmetic operations ("-", "+",
   "abs()" and "~").

object.__complex__(self)
object.__int__(self)
object.__float__(self)

   Called to implement the built-in functions "complex()", "int()" and
   "float()".  Should return a value of the appropriate type.

object.__index__(self)

   Called to implement "operator.index()", and whenever Python needs
   to losslessly convert the numeric object to an integer object (such
   as in slicing, or in the built-in "bin()", "hex()" and "oct()"
   functions). Presence of this method indicates that the numeric
   object is an integer type.  Must return an integer.

   If "__int__()", "__float__()" and "__complex__()" are not defined
   then corresponding built-in functions "int()", "float()" and
   "complex()" fall back to "__index__()".

object.__round__(self[, ndigits])
object.__trunc__(self)
object.__floor__(self)
object.__ceil__(self)

   Called to implement the built-in function "round()" and "math"
   functions "trunc()", "floor()" and "ceil()". Unless *ndigits* is
   passed to "__round__()" all these methods should return the value
   of the object truncated to an "Integral" (typically an "int").

   The built-in function "int()" falls back to "__trunc__()" if
   neither "__int__()" nor "__index__()" is defined.

   Changed in version 3.11: The delegation of "int()" to "__trunc__()"
   is deprecated.
''',
    'objects': r'''Objects, values and types
*************************

*Objects* are Python’s abstraction for data.  All data in a Python
program is represented by objects or by relations between objects. (In
a sense, and in conformance to Von Neumann’s model of a “stored
program computer”, code is also represented by objects.)

Every object has an identity, a type and a value.  An object’s
*identity* never changes once it has been created; you may think of it
as the object’s address in memory.  The "is" operator compares the
identity of two objects; the "id()" function returns an integer
representing its identity.

**CPython implementation detail:** For CPython, "id(x)" is the memory
address where "x" is stored.

An object’s type determines the operations that the object supports
(e.g., “does it have a length?”) and also defines the possible values
for objects of that type.  The "type()" function returns an object’s
type (which is an object itself).  Like its identity, an object’s
*type* is also unchangeable. [1]

The *value* of some objects can change.  Objects whose value can
change are said to be *mutable*; objects whose value is unchangeable
once they are created are called *immutable*. (The value of an
immutable container object that contains a reference to a mutable
object can change when the latter’s value is changed; however the
container is still considered immutable, because the collection of
objects it contains cannot be changed.  So, immutability is not
strictly the same as having an unchangeable value, it is more subtle.)
An object’s mutability is determined by its type; for instance,
numbers, strings and tuples are immutable, while dictionaries and
lists are mutable.

Objects are never explicitly destroyed; however, when they become
unreachable they may be garbage-collected.  An implementation is
allowed to postpone garbage collection or omit it altogether — it is a
matter of implementation quality how garbage collection is
implemented, as long as no objects are collected that are still
reachable.

**CPython implementation detail:** CPython currently uses a reference-
counting scheme with (optional) delayed detection of cyclically linked
garbage, which collects most objects as soon as they become
unreachable, but is not guaranteed to collect garbage containing
circular references.  See the documentation of the "gc" module for
information on controlling the collection of cyclic garbage. Other
implementations act differently and CPython may change. Do not depend
on immediate finalization of objects when they become unreachable (so
you should always close files explicitly).

Note that the use of the implementation’s tracing or debugging
facilities may keep objects alive that would normally be collectable.
Also note that catching an exception with a "try"…"except" statement
may keep objects alive.

Some objects contain references to “external” resources such as open
files or windows.  It is understood that these resources are freed
when the object is garbage-collected, but since garbage collection is
not guaranteed to happen, such objects also provide an explicit way to
release the external resource, usually a "close()" method. Programs
are strongly recommended to explicitly close such objects.  The
"try"…"finally" statement and the "with" statement provide convenient
ways to do this.

Some objects contain references to other objects; these are called
*containers*. Examples of containers are tuples, lists and
dictionaries.  The references are part of a container’s value.  In
most cases, when we talk about the value of a container, we imply the
values, not the identities of the contained objects; however, when we
talk about the mutability of a container, only the identities of the
immediately contained objects are implied.  So, if an immutable
container (like a tuple) contains a reference to a mutable object, its
value changes if that mutable object is changed.

Types affect almost all aspects of object behavior.  Even the
importance of object identity is affected in some sense: for immutable
types, operations that compute new values may actually return a
reference to any existing object with the same type and value, while
for mutable objects this is not allowed. For example, after "a = 1; b
= 1", *a* and *b* may or may not refer to the same object with the
value one, depending on the implementation. This is because "int" is
an immutable type, so the reference to "1" can be reused. This
behaviour depends on the implementation used, so should not be relied
upon, but is something to be aware of when making use of object
identity tests. However, after "c = []; d = []", *c* and *d* are
guaranteed to refer to two different, unique, newly created empty
lists. (Note that "e = f = []" assigns the *same* object to both *e*
and *f*.)
''',
    'operator-summary': r'''Operator precedence
*******************

The following table summarizes the operator precedence in Python, from
highest precedence (most binding) to lowest precedence (least
binding).  Operators in the same box have the same precedence.  Unless
the syntax is explicitly given, operators are binary.  Operators in
the same box group left to right (except for exponentiation and
conditional expressions, which group from right to left).

Note that comparisons, membership tests, and identity tests, all have
the same precedence and have a left-to-right chaining feature as
described in the Comparisons section.

+-------------------------------------------------+---------------------------------------+
| Operator                                        | Description                           |
|=================================================|=======================================|
| "(expressions...)",  "[expressions...]", "{key: | Binding or parenthesized expression,  |
| value...}", "{expressions...}"                  | list display, dictionary display, set |
|                                                 | display                               |
+-------------------------------------------------+---------------------------------------+
| "x[index]", "x[index:index]",                   | Subscription, slicing, call,          |
| "x(arguments...)", "x.attribute"                | attribute reference                   |
+-------------------------------------------------+---------------------------------------+
| "await x"                                       | Await expression                      |
+-------------------------------------------------+---------------------------------------+
| "**"                                            | Exponentiation [5]                    |
+-------------------------------------------------+---------------------------------------+
| "+x", "-x", "~x"                                | Positive, negative, bitwise NOT       |
+-------------------------------------------------+---------------------------------------+
| "*", "@", "/", "//", "%"                        | Multiplication, matrix                |
|                                                 | multiplication, division, floor       |
|                                                 | division, remainder [6]               |
+-------------------------------------------------+---------------------------------------+
| "+", "-"                                        | Addition and subtraction              |
+-------------------------------------------------+---------------------------------------+
| "<<", ">>"                                      | Shifts                                |
+-------------------------------------------------+---------------------------------------+
| "&"                                             | Bitwise AND                           |
+-------------------------------------------------+---------------------------------------+
| "^"                                             | Bitwise XOR                           |
+-------------------------------------------------+---------------------------------------+
| "|"                                             | Bitwise OR                            |
+-------------------------------------------------+---------------------------------------+
| "in", "not in", "is", "is not", "<", "<=", ">", | Comparisons, including membership     |
| ">=", "!=", "=="                                | tests and identity tests              |
+-------------------------------------------------+---------------------------------------+
| "not x"                                         | Boolean NOT                           |
+-------------------------------------------------+---------------------------------------+
| "and"                                           | Boolean AND                           |
+-------------------------------------------------+---------------------------------------+
| "or"                                            | Boolean OR                            |
+-------------------------------------------------+---------------------------------------+
| "if" – "else"                                   | Conditional expression                |
+-------------------------------------------------+---------------------------------------+
| "lambda"                                        | Lambda expression                     |
+-------------------------------------------------+---------------------------------------+
| ":="                                            | Assignment expression                 |
+-------------------------------------------------+---------------------------------------+

-[ Footnotes ]-

[1] While "abs(x%y) < abs(y)" is true mathematically, for floats it
    may not be true numerically due to roundoff.  For example, and
    assuming a platform on which a Python float is an IEEE 754 double-
    precision number, in order that "-1e-100 % 1e100" have the same
    sign as "1e100", the computed result is "-1e-100 + 1e100", which
    is numerically exactly equal to "1e100".  The function
    "math.fmod()" returns a result whose sign matches the sign of the
    first argument instead, and so returns "-1e-100" in this case.
    Which approach is more appropriate depends on the application.

[2] If x is very close to an exact integer multiple of y, it’s
    possible for "x//y" to be one larger than "(x-x%y)//y" due to
    rounding.  In such cases, Python returns the latter result, in
    order to preserve that "divmod(x,y)[0] * y + x % y" be very close
    to "x".

[3] The Unicode standard distinguishes between *code points* (e.g.
    U+0041) and *abstract characters* (e.g. “LATIN CAPITAL LETTER A”).
    While most abstract characters in Unicode are only represented
    using one code point, there is a number of abstract characters
    that can in addition be represented using a sequence of more than
    one code point.  For example, the abstract character “LATIN
    CAPITAL LETTER C WITH CEDILLA” can be represented as a single
    *precomposed character* at code position U+00C7, or as a sequence
    of a *base character* at code position U+0043 (LATIN CAPITAL
    LETTER C), followed by a *combining character* at code position
    U+0327 (COMBINING CEDILLA).

    The comparison operators on strings compare at the level of
    Unicode code points. This may be counter-intuitive to humans.  For
    example, ""\u00C7" == "\u0043\u0327"" is "False", even though both
    strings represent the same abstract character “LATIN CAPITAL
    LETTER C WITH CEDILLA”.

    To compare strings at the level of abstract characters (that is,
    in a way intuitive to humans), use "unicodedata.normalize()".

[4] Due to automatic garbage-collection, free lists, and the dynamic
    nature of descriptors, you may notice seemingly unusual behaviour
    in certain uses of the "is" operator, like those involving
    comparisons between instance methods, or constants.  Check their
    documentation for more info.

[5] The power operator "**" binds less tightly than an arithmetic or
    bitwise unary operator on its right, that is, "2**-1" is "0.5".

[6] The "%" operator is also used for string formatting; the same
    precedence applies.
''',
    'pass': r'''The "pass" statement
********************

   pass_stmt ::= "pass"

"pass" is a null operation — when it is executed, nothing happens. It
is useful as a placeholder when a statement is required syntactically,
but no code needs to be executed, for example:

   def f(arg): pass    # a function that does nothing (yet)

   class C: pass       # a class with no methods (yet)
''',
    'power': r'''The power operator
******************

The power operator binds more tightly than unary operators on its
left; it binds less tightly than unary operators on its right.  The
syntax is:

   power ::= (await_expr | primary) ["**" u_expr]

Thus, in an unparenthesized sequence of power and unary operators, the
operators are evaluated from right to left (this does not constrain
the evaluation order for the operands): "-1**2" results in "-1".

The power operator has the same semantics as the built-in "pow()"
function, when called with two arguments: it yields its left argument
raised to the power of its right argument.  The numeric arguments are
first converted to a common type, and the result is of that type.

For int operands, the result has the same type as the operands unless
the second argument is negative; in that case, all arguments are
converted to float and a float result is delivered. For example,
"10**2" returns "100", but "10**-2" returns "0.01".

Raising "0.0" to a negative power results in a "ZeroDivisionError".
Raising a negative number to a fractional power results in a "complex"
number. (In earlier versions it raised a "ValueError".)

This operation can be customized using the special "__pow__()" and
"__rpow__()" methods.
''',
    'raise': r'''The "raise" statement
*********************

   raise_stmt ::= "raise" [expression ["from" expression]]

If no expressions are present, "raise" re-raises the exception that is
currently being handled, which is also known as the *active
exception*. If there isn’t currently an active exception, a
"RuntimeError" exception is raised indicating that this is an error.

Otherwise, "raise" evaluates the first expression as the exception
object.  It must be either a subclass or an instance of
"BaseException". If it is a class, the exception instance will be
obtained when needed by instantiating the class with no arguments.

The *type* of the exception is the exception instance’s class, the
*value* is the instance itself.

A traceback object is normally created automatically when an exception
is raised and attached to it as the "__traceback__" attribute. You can
create an exception and set your own traceback in one step using the
"with_traceback()" exception method (which returns the same exception
instance, with its traceback set to its argument), like so:

   raise Exception("foo occurred").with_traceback(tracebackobj)

The "from" clause is used for exception chaining: if given, the second
*expression* must be another exception class or instance. If the
second expression is an exception instance, it will be attached to the
raised exception as the "__cause__" attribute (which is writable). If
the expression is an exception class, the class will be instantiated
and the resulting exception instance will be attached to the raised
exception as the "__cause__" attribute. If the raised exception is not
handled, both exceptions will be printed:

   >>> try:
   ...     print(1 / 0)
   ... except Exception as exc:
   ...     raise RuntimeError("Something bad happened") from exc
   ...
   Traceback (most recent call last):
     File "<stdin>", line 2, in <module>
       print(1 / 0)
             ~~^~~
   ZeroDivisionError: division by zero

   The above exception was the direct cause of the following exception:

   Traceback (most recent call last):
     File "<stdin>", line 4, in <module>
       raise RuntimeError("Something bad happened") from exc
   RuntimeError: Something bad happened

A similar mechanism works implicitly if a new exception is raised when
an exception is already being handled.  An exception may be handled
when an "except" or "finally" clause, or a "with" statement, is used.
The previous exception is then attached as the new exception’s
"__context__" attribute:

   >>> try:
   ...     print(1 / 0)
   ... except:
   ...     raise RuntimeError("Something bad happened")
   ...
   Traceback (most recent call last):
     File "<stdin>", line 2, in <module>
       print(1 / 0)
             ~~^~~
   ZeroDivisionError: division by zero

   During handling of the above exception, another exception occurred:

   Traceback (most recent call last):
     File "<stdin>", line 4, in <module>
       raise RuntimeError("Something bad happened")
   RuntimeError: Something bad happened

Exception chaining can be explicitly suppressed by specifying "None"
in the "from" clause:

   >>> try:
   ...     print(1 / 0)
   ... except:
   ...     raise RuntimeError("Something bad happened") from None
   ...
   Traceback (most recent call last):
     File "<stdin>", line 4, in <module>
   RuntimeError: Something bad happened

Additional information on exceptions can be found in section
Exceptions, and information about handling exceptions is in section
The try statement.

Changed in version 3.3: "None" is now permitted as "Y" in "raise X
from Y".Added the "__suppress_context__" attribute to suppress
automatic display of the exception context.

Changed in version 3.11: If the traceback of the active exception is
modified in an "except" clause, a subsequent "raise" statement re-
raises the exception with the modified traceback. Previously, the
exception was re-raised with the traceback it had when it was caught.
''',
    'return': r'''The "return" statement
**********************

   return_stmt ::= "return" [expression_list]

"return" may only occur syntactically nested in a function definition,
not within a nested class definition.

If an expression list is present, it is evaluated, else "None" is
substituted.

"return" leaves the current function call with the expression list (or
"None") as return value.

When "return" passes control out of a "try" statement with a "finally"
clause, that "finally" clause is executed before really leaving the
function.

In a generator function, the "return" statement indicates that the
generator is done and will cause "StopIteration" to be raised. The
returned value (if any) is used as an argument to construct
"StopIteration" and becomes the "StopIteration.value" attribute.

In an asynchronous generator function, an empty "return" statement
indicates that the asynchronous generator is done and will cause
"StopAsyncIteration" to be raised.  A non-empty "return" statement is
a syntax error in an asynchronous generator function.
''',
    'sequence-types': r'''Emulating container types
*************************

The following methods can be defined to implement container objects.
None of them are provided by the "object" class itself. Containers
usually are *sequences* (such as "lists" or "tuples") or *mappings*
(like *dictionaries*), but can represent other containers as well.
The first set of methods is used either to emulate a sequence or to
emulate a mapping; the difference is that for a sequence, the
allowable keys should be the integers *k* for which "0 <= k < N" where
*N* is the length of the sequence, or "slice" objects, which define a
range of items.  It is also recommended that mappings provide the
methods "keys()", "values()", "items()", "get()", "clear()",
"setdefault()", "pop()", "popitem()", "copy()", and "update()"
behaving similar to those for Python’s standard "dictionary" objects.
The "collections.abc" module provides a "MutableMapping" *abstract
base class* to help create those methods from a base set of
"__getitem__()", "__setitem__()", "__delitem__()", and "keys()".
Mutable sequences should provide methods "append()", "count()",
"index()", "extend()", "insert()", "pop()", "remove()", "reverse()"
and "sort()", like Python standard "list" objects. Finally, sequence
types should implement addition (meaning concatenation) and
multiplication (meaning repetition) by defining the methods
"__add__()", "__radd__()", "__iadd__()", "__mul__()", "__rmul__()" and
"__imul__()" described below; they should not define other numerical
operators.  It is recommended that both mappings and sequences
implement the "__contains__()" method to allow efficient use of the
"in" operator; for mappings, "in" should search the mapping’s keys;
for sequences, it should search through the values.  It is further
recommended that both mappings and sequences implement the
"__iter__()" method to allow efficient iteration through the
container; for mappings, "__iter__()" should iterate through the
object’s keys; for sequences, it should iterate through the values.

object.__len__(self)

   Called to implement the built-in function "len()".  Should return
   the length of the object, an integer ">=" 0.  Also, an object that
   doesn’t define a "__bool__()" method and whose "__len__()" method
   returns zero is considered to be false in a Boolean context.

   **CPython implementation detail:** In CPython, the length is
   required to be at most "sys.maxsize". If the length is larger than
   "sys.maxsize" some features (such as "len()") may raise
   "OverflowError".  To prevent raising "OverflowError" by truth value
   testing, an object must define a "__bool__()" method.

object.__length_hint__(self)

   Called to implement "operator.length_hint()". Should return an
   estimated length for the object (which may be greater or less than
   the actual length). The length must be an integer ">=" 0. The
   return value may also be "NotImplemented", which is treated the
   same as if the "__length_hint__" method didn’t exist at all. This
   method is purely an optimization and is never required for
   correctness.

   Added in version 3.4.

Note:

  Slicing is done exclusively with the following three methods.  A
  call like

     a[1:2] = b

  is translated to

     a[slice(1, 2, None)] = b

  and so forth.  Missing slice items are always filled in with "None".

object.__getitem__(self, key)

   Called to implement evaluation of "self[key]". For *sequence*
   types, the accepted keys should be integers. Optionally, they may
   support "slice" objects as well.  Negative index support is also
   optional. If *key* is of an inappropriate type, "TypeError" may be
   raised; if *key* is a value outside the set of indexes for the
   sequence (after any special interpretation of negative values),
   "IndexError" should be raised. For *mapping* types, if *key* is
   missing (not in the container), "KeyError" should be raised.

   Note:

     "for" loops expect that an "IndexError" will be raised for
     illegal indexes to allow proper detection of the end of the
     sequence.

   Note:

     When subscripting a *class*, the special class method
     "__class_getitem__()" may be called instead of "__getitem__()".
     See __class_getitem__ versus __getitem__ for more details.

object.__setitem__(self, key, value)

   Called to implement assignment to "self[key]".  Same note as for
   "__getitem__()".  This should only be implemented for mappings if
   the objects support changes to the values for keys, or if new keys
   can be added, or for sequences if elements can be replaced.  The
   same exceptions should be raised for improper *key* values as for
   the "__getitem__()" method.

object.__delitem__(self, key)

   Called to implement deletion of "self[key]".  Same note as for
   "__getitem__()".  This should only be implemented for mappings if
   the objects support removal of keys, or for sequences if elements
   can be removed from the sequence.  The same exceptions should be
   raised for improper *key* values as for the "__getitem__()" method.

object.__missing__(self, key)

   Called by "dict"."__getitem__()" to implement "self[key]" for dict
   subclasses when key is not in the dictionary.

object.__iter__(self)

   This method is called when an *iterator* is required for a
   container. This method should return a new iterator object that can
   iterate over all the objects in the container.  For mappings, it
   should iterate over the keys of the container.

object.__reversed__(self)

   Called (if present) by the "reversed()" built-in to implement
   reverse iteration.  It should return a new iterator object that
   iterates over all the objects in the container in reverse order.

   If the "__reversed__()" method is not provided, the "reversed()"
   built-in will fall back to using the sequence protocol ("__len__()"
   and "__getitem__()").  Objects that support the sequence protocol
   should only provide "__reversed__()" if they can provide an
   implementation that is more efficient than the one provided by
   "reversed()".

The membership test operators ("in" and "not in") are normally
implemented as an iteration through a container. However, container
objects can supply the following special method with a more efficient
implementation, which also does not require the object be iterable.

object.__contains__(self, item)

   Called to implement membership test operators.  Should return true
   if *item* is in *self*, false otherwise.  For mapping objects, this
   should consider the keys of the mapping rather than the values or
   the key-item pairs.

   For objects that don’t define "__contains__()", the membership test
   first tries iteration via "__iter__()", then the old sequence
   iteration protocol via "__getitem__()", see this section in the
   language reference.
''',
    'shifting': r'''Shifting operations
*******************

The shifting operations have lower priority than the arithmetic
operations:

   shift_expr ::= a_expr | shift_expr ("<<" | ">>") a_expr

These operators accept integers as arguments.  They shift the first
argument to the left or right by the number of bits given by the
second argument.

The left shift operation can be customized using the special
"__lshift__()" and "__rlshift__()" methods. The right shift operation
can be customized using the special "__rshift__()" and "__rrshift__()"
methods.

A right shift by *n* bits is defined as floor division by "pow(2,n)".
A left shift by *n* bits is defined as multiplication with "pow(2,n)".
''',
    'slicings': r'''Slicings
********

A slicing selects a range of items in a sequence object (e.g., a
string, tuple or list).  Slicings may be used as expressions or as
targets in assignment or "del" statements.  The syntax for a slicing:

   slicing      ::= primary "[" slice_list "]"
   slice_list   ::= slice_item ("," slice_item)* [","]
   slice_item   ::= expression | proper_slice
   proper_slice ::= [lower_bound] ":" [upper_bound] [ ":" [stride] ]
   lower_bound  ::= expression
   upper_bound  ::= expression
   stride       ::= expression

There is ambiguity in the formal syntax here: anything that looks like
an expression list also looks like a slice list, so any subscription
can be interpreted as a slicing.  Rather than further complicating the
syntax, this is disambiguated by defining that in this case the
interpretation as a subscription takes priority over the
interpretation as a slicing (this is the case if the slice list
contains no proper slice).

The semantics for a slicing are as follows.  The primary is indexed
(using the same "__getitem__()" method as normal subscription) with a
key that is constructed from the slice list, as follows.  If the slice
list contains at least one comma, the key is a tuple containing the
conversion of the slice items; otherwise, the conversion of the lone
slice item is the key.  The conversion of a slice item that is an
expression is that expression.  The conversion of a proper slice is a
slice object (see section The standard type hierarchy) whose "start",
"stop" and "step" attributes are the values of the expressions given
as lower bound, upper bound and stride, respectively, substituting
"None" for missing expressions.
''',
    'specialattrs': r'''Special Attributes
******************

The implementation adds a few special read-only attributes to several
object types, where they are relevant.  Some of these are not reported
by the "dir()" built-in function.

definition.__name__

   The name of the class, function, method, descriptor, or generator
   instance.

definition.__qualname__

   The *qualified name* of the class, function, method, descriptor, or
   generator instance.

   Added in version 3.3.

definition.__module__

   The name of the module in which a class or function was defined.

definition.__doc__

   The documentation string of a class or function, or "None" if
   undefined.

definition.__type_params__

   The type parameters of generic classes, functions, and type
   aliases. For classes and functions that are not generic, this will
   be an empty tuple.

   Added in version 3.12.
''',
    'specialnames': r'''Special method names
********************

A class can implement certain operations that are invoked by special
syntax (such as arithmetic operations or subscripting and slicing) by
defining methods with special names. This is Python’s approach to
*operator overloading*, allowing classes to define their own behavior
with respect to language operators.  For instance, if a class defines
a method named "__getitem__()", and "x" is an instance of this class,
then "x[i]" is roughly equivalent to "type(x).__getitem__(x, i)".
Except where mentioned, attempts to execute an operation raise an
exception when no appropriate method is defined (typically
"AttributeError" or "TypeError").

Setting a special method to "None" indicates that the corresponding
operation is not available.  For example, if a class sets "__iter__()"
to "None", the class is not iterable, so calling "iter()" on its
instances will raise a "TypeError" (without falling back to
"__getitem__()"). [2]

When implementing a class that emulates any built-in type, it is
important that the emulation only be implemented to the degree that it
makes sense for the object being modelled.  For example, some
sequences may work well with retrieval of individual elements, but
extracting a slice may not make sense.  (One example of this is the
"NodeList" interface in the W3C’s Document Object Model.)


Basic customization
===================

object.__new__(cls[, ...])

   Called to create a new instance of class *cls*.  "__new__()" is a
   static method (special-cased so you need not declare it as such)
   that takes the class of which an instance was requested as its
   first argument.  The remaining arguments are those passed to the
   object constructor expression (the call to the class).  The return
   value of "__new__()" should be the new object instance (usually an
   instance of *cls*).

   Typical implementations create a new instance of the class by
   invoking the superclass’s "__new__()" method using
   "super().__new__(cls[, ...])" with appropriate arguments and then
   modifying the newly created instance as necessary before returning
   it.

   If "__new__()" is invoked during object construction and it returns
   an instance of *cls*, then the new instance’s "__init__()" method
   will be invoked like "__init__(self[, ...])", where *self* is the
   new instance and the remaining arguments are the same as were
   passed to the object constructor.

   If "__new__()" does not return an instance of *cls*, then the new
   instance’s "__init__()" method will not be invoked.

   "__new__()" is intended mainly to allow subclasses of immutable
   types (like int, str, or tuple) to customize instance creation.  It
   is also commonly overridden in custom metaclasses in order to
   customize class creation.

object.__init__(self[, ...])

   Called after the instance has been created (by "__new__()"), but
   before it is returned to the caller.  The arguments are those
   passed to the class constructor expression.  If a base class has an
   "__init__()" method, the derived class’s "__init__()" method, if
   any, must explicitly call it to ensure proper initialization of the
   base class part of the instance; for example:
   "super().__init__([args...])".

   Because "__new__()" and "__init__()" work together in constructing
   objects ("__new__()" to create it, and "__init__()" to customize
   it), no non-"None" value may be returned by "__init__()"; doing so
   will cause a "TypeError" to be raised at runtime.

object.__del__(self)

   Called when the instance is about to be destroyed.  This is also
   called a finalizer or (improperly) a destructor.  If a base class
   has a "__del__()" method, the derived class’s "__del__()" method,
   if any, must explicitly call it to ensure proper deletion of the
   base class part of the instance.

   It is possible (though not recommended!) for the "__del__()" method
   to postpone destruction of the instance by creating a new reference
   to it.  This is called object *resurrection*.  It is
   implementation-dependent whether "__del__()" is called a second
   time when a resurrected object is about to be destroyed; the
   current *CPython* implementation only calls it once.

   It is not guaranteed that "__del__()" methods are called for
   objects that still exist when the interpreter exits.
   "weakref.finalize" provides a straightforward way to register a
   cleanup function to be called when an object is garbage collected.

   Note:

     "del x" doesn’t directly call "x.__del__()" — the former
     decrements the reference count for "x" by one, and the latter is
     only called when "x"’s reference count reaches zero.

   **CPython implementation detail:** It is possible for a reference
   cycle to prevent the reference count of an object from going to
   zero.  In this case, the cycle will be later detected and deleted
   by the *cyclic garbage collector*.  A common cause of reference
   cycles is when an exception has been caught in a local variable.
   The frame’s locals then reference the exception, which references
   its own traceback, which references the locals of all frames caught
   in the traceback.

   See also: Documentation for the "gc" module.

   Warning:

     Due to the precarious circumstances under which "__del__()"
     methods are invoked, exceptions that occur during their execution
     are ignored, and a warning is printed to "sys.stderr" instead.
     In particular:

     * "__del__()" can be invoked when arbitrary code is being
       executed, including from any arbitrary thread.  If "__del__()"
       needs to take a lock or invoke any other blocking resource, it
       may deadlock as the resource may already be taken by the code
       that gets interrupted to execute "__del__()".

     * "__del__()" can be executed during interpreter shutdown.  As a
       consequence, the global variables it needs to access (including
       other modules) may already have been deleted or set to "None".
       Python guarantees that globals whose name begins with a single
       underscore are deleted from their module before other globals
       are deleted; if no other references to such globals exist, this
       may help in assuring that imported modules are still available
       at the time when the "__del__()" method is called.

object.__repr__(self)

   Called by the "repr()" built-in function to compute the “official”
   string representation of an object.  If at all possible, this
   should look like a valid Python expression that could be used to
   recreate an object with the same value (given an appropriate
   environment).  If this is not possible, a string of the form
   "<...some useful description...>" should be returned. The return
   value must be a string object. If a class defines "__repr__()" but
   not "__str__()", then "__repr__()" is also used when an “informal”
   string representation of instances of that class is required.

   This is typically used for debugging, so it is important that the
   representation is information-rich and unambiguous. A default
   implementation is provided by the "object" class itself.

object.__str__(self)

   Called by "str(object)", the default "__format__()" implementation,
   and the built-in function "print()", to compute the “informal” or
   nicely printable string representation of an object.  The return
   value must be a str object.

   This method differs from "object.__repr__()" in that there is no
   expectation that "__str__()" return a valid Python expression: a
   more convenient or concise representation can be used.

   The default implementation defined by the built-in type "object"
   calls "object.__repr__()".

object.__bytes__(self)

   Called by bytes to compute a byte-string representation of an
   object. This should return a "bytes" object. The "object" class
   itself does not provide this method.

object.__format__(self, format_spec)

   Called by the "format()" built-in function, and by extension,
   evaluation of formatted string literals and the "str.format()"
   method, to produce a “formatted” string representation of an
   object. The *format_spec* argument is a string that contains a
   description of the formatting options desired. The interpretation
   of the *format_spec* argument is up to the type implementing
   "__format__()", however most classes will either delegate
   formatting to one of the built-in types, or use a similar
   formatting option syntax.

   See Format Specification Mini-Language for a description of the
   standard formatting syntax.

   The return value must be a string object.

   The default implementation by the "object" class should be given an
   empty *format_spec* string. It delegates to "__str__()".

   Changed in version 3.4: The __format__ method of "object" itself
   raises a "TypeError" if passed any non-empty string.

   Changed in version 3.7: "object.__format__(x, '')" is now
   equivalent to "str(x)" rather than "format(str(x), '')".

object.__lt__(self, other)
object.__le__(self, other)
object.__eq__(self, other)
object.__ne__(self, other)
object.__gt__(self, other)
object.__ge__(self, other)

   These are the so-called “rich comparison” methods. The
   correspondence between operator symbols and method names is as
   follows: "x<y" calls "x.__lt__(y)", "x<=y" calls "x.__le__(y)",
   "x==y" calls "x.__eq__(y)", "x!=y" calls "x.__ne__(y)", "x>y" calls
   "x.__gt__(y)", and "x>=y" calls "x.__ge__(y)".

   A rich comparison method may return the singleton "NotImplemented"
   if it does not implement the operation for a given pair of
   arguments. By convention, "False" and "True" are returned for a
   successful comparison. However, these methods can return any value,
   so if the comparison operator is used in a Boolean context (e.g.,
   in the condition of an "if" statement), Python will call "bool()"
   on the value to determine if the result is true or false.

   By default, "object" implements "__eq__()" by using "is", returning
   "NotImplemented" in the case of a false comparison: "True if x is y
   else NotImplemented". For "__ne__()", by default it delegates to
   "__eq__()" and inverts the result unless it is "NotImplemented".
   There are no other implied relationships among the comparison
   operators or default implementations; for example, the truth of
   "(x<y or x==y)" does not imply "x<=y". To automatically generate
   ordering operations from a single root operation, see
   "functools.total_ordering()".

   By default, the "object" class provides implementations consistent
   with Value comparisons: equality compares according to object
   identity, and order comparisons raise "TypeError". Each default
   method may generate these results directly, but may also return
   "NotImplemented".

   See the paragraph on "__hash__()" for some important notes on
   creating *hashable* objects which support custom comparison
   operations and are usable as dictionary keys.

   There are no swapped-argument versions of these methods (to be used
   when the left argument does not support the operation but the right
   argument does); rather, "__lt__()" and "__gt__()" are each other’s
   reflection, "__le__()" and "__ge__()" are each other’s reflection,
   and "__eq__()" and "__ne__()" are their own reflection. If the
   operands are of different types, and the right operand’s type is a
   direct or indirect subclass of the left operand’s type, the
   reflected method of the right operand has priority, otherwise the
   left operand’s method has priority.  Virtual subclassing is not
   considered.

   When no appropriate method returns any value other than
   "NotImplemented", the "==" and "!=" operators will fall back to
   "is" and "is not", respectively.

object.__hash__(self)

   Called by built-in function "hash()" and for operations on members
   of hashed collections including "set", "frozenset", and "dict".
   The "__hash__()" method should return an integer. The only required
   property is that objects which compare equal have the same hash
   value; it is advised to mix together the hash values of the
   components of the object that also play a part in comparison of
   objects by packing them into a tuple and hashing the tuple.
   Example:

      def __hash__(self):
          return hash((self.name, self.nick, self.color))

   Note:

     "hash()" truncates the value returned from an object’s custom
     "__hash__()" method to the size of a "Py_ssize_t".  This is
     typically 8 bytes on 64-bit builds and 4 bytes on 32-bit builds.
     If an object’s   "__hash__()" must interoperate on builds of
     different bit sizes, be sure to check the width on all supported
     builds.  An easy way to do this is with "python -c "import sys;
     print(sys.hash_info.width)"".

   If a class does not define an "__eq__()" method it should not
   define a "__hash__()" operation either; if it defines "__eq__()"
   but not "__hash__()", its instances will not be usable as items in
   hashable collections.  If a class defines mutable objects and
   implements an "__eq__()" method, it should not implement
   "__hash__()", since the implementation of *hashable* collections
   requires that a key’s hash value is immutable (if the object’s hash
   value changes, it will be in the wrong hash bucket).

   User-defined classes have "__eq__()" and "__hash__()" methods by
   default (inherited from the "object" class); with them, all objects
   compare unequal (except with themselves) and "x.__hash__()" returns
   an appropriate value such that "x == y" implies both that "x is y"
   and "hash(x) == hash(y)".

   A class that overrides "__eq__()" and does not define "__hash__()"
   will have its "__hash__()" implicitly set to "None".  When the
   "__hash__()" method of a class is "None", instances of the class
   will raise an appropriate "TypeError" when a program attempts to
   retrieve their hash value, and will also be correctly identified as
   unhashable when checking "isinstance(obj,
   collections.abc.Hashable)".

   If a class that overrides "__eq__()" needs to retain the
   implementation of "__hash__()" from a parent class, the interpreter
   must be told this explicitly by setting "__hash__ =
   <ParentClass>.__hash__".

   If a class that does not override "__eq__()" wishes to suppress
   hash support, it should include "__hash__ = None" in the class
   definition. A class which defines its own "__hash__()" that
   explicitly raises a "TypeError" would be incorrectly identified as
   hashable by an "isinstance(obj, collections.abc.Hashable)" call.

   Note:

     By default, the "__hash__()" values of str and bytes objects are
     “salted” with an unpredictable random value.  Although they
     remain constant within an individual Python process, they are not
     predictable between repeated invocations of Python.This is
     intended to provide protection against a denial-of-service caused
     by carefully chosen inputs that exploit the worst case
     performance of a dict insertion, *O*(*n*^2) complexity.  See
     http://ocert.org/advisories/ocert-2011-003.html for
     details.Changing hash values affects the iteration order of sets.
     Python has never made guarantees about this ordering (and it
     typically varies between 32-bit and 64-bit builds).See also
     "PYTHONHASHSEED".

   Changed in version 3.3: Hash randomization is enabled by default.

object.__bool__(self)

   Called to implement truth value testing and the built-in operation
   "bool()"; should return "False" or "True".  When this method is not
   defined, "__len__()" is called, if it is defined, and the object is
   considered true if its result is nonzero.  If a class defines
   neither "__len__()" nor "__bool__()" (which is true of the "object"
   class itself), all its instances are considered true.


Customizing attribute access
============================

The following methods can be defined to customize the meaning of
attribute access (use of, assignment to, or deletion of "x.name") for
class instances.

object.__getattr__(self, name)

   Called when the default attribute access fails with an
   "AttributeError" (either "__getattribute__()" raises an
   "AttributeError" because *name* is not an instance attribute or an
   attribute in the class tree for "self"; or "__get__()" of a *name*
   property raises "AttributeError").  This method should either
   return the (computed) attribute value or raise an "AttributeError"
   exception. The "object" class itself does not provide this method.

   Note that if the attribute is found through the normal mechanism,
   "__getattr__()" is not called.  (This is an intentional asymmetry
   between "__getattr__()" and "__setattr__()".) This is done both for
   efficiency reasons and because otherwise "__getattr__()" would have
   no way to access other attributes of the instance.  Note that at
   least for instance variables, you can fake total control by not
   inserting any values in the instance attribute dictionary (but
   instead inserting them in another object).  See the
   "__getattribute__()" method below for a way to actually get total
   control over attribute access.

object.__getattribute__(self, name)

   Called unconditionally to implement attribute accesses for
   instances of the class. If the class also defines "__getattr__()",
   the latter will not be called unless "__getattribute__()" either
   calls it explicitly or raises an "AttributeError". This method
   should return the (computed) attribute value or raise an
   "AttributeError" exception. In order to avoid infinite recursion in
   this method, its implementation should always call the base class
   method with the same name to access any attributes it needs, for
   example, "object.__getattribute__(self, name)".

   Note:

     This method may still be bypassed when looking up special methods
     as the result of implicit invocation via language syntax or
     built-in functions. See Special method lookup.

   For certain sensitive attribute accesses, raises an auditing event
   "object.__getattr__" with arguments "obj" and "name".

object.__setattr__(self, name, value)

   Called when an attribute assignment is attempted.  This is called
   instead of the normal mechanism (i.e. store the value in the
   instance dictionary). *name* is the attribute name, *value* is the
   value to be assigned to it.

   If "__setattr__()" wants to assign to an instance attribute, it
   should call the base class method with the same name, for example,
   "object.__setattr__(self, name, value)".

   For certain sensitive attribute assignments, raises an auditing
   event "object.__setattr__" with arguments "obj", "name", "value".

object.__delattr__(self, name)

   Like "__setattr__()" but for attribute deletion instead of
   assignment.  This should only be implemented if "del obj.name" is
   meaningful for the object.

   For certain sensitive attribute deletions, raises an auditing event
   "object.__delattr__" with arguments "obj" and "name".

object.__dir__(self)

   Called when "dir()" is called on the object. An iterable must be
   returned. "dir()" converts the returned iterable to a list and
   sorts it.


Customizing module attribute access
-----------------------------------

Special names "__getattr__" and "__dir__" can be also used to
customize access to module attributes. The "__getattr__" function at
the module level should accept one argument which is the name of an
attribute and return the computed value or raise an "AttributeError".
If an attribute is not found on a module object through the normal
lookup, i.e. "object.__getattribute__()", then "__getattr__" is
searched in the module "__dict__" before raising an "AttributeError".
If found, it is called with the attribute name and the result is
returned.

The "__dir__" function should accept no arguments, and return an
iterable of strings that represents the names accessible on module. If
present, this function overrides the standard "dir()" search on a
module.

For a more fine grained customization of the module behavior (setting
attributes, properties, etc.), one can set the "__class__" attribute
of a module object to a subclass of "types.ModuleType". For example:

   import sys
   from types import ModuleType

   class VerboseModule(ModuleType):
       def __repr__(self):
           return f'Verbose {self.__name__}'

       def __setattr__(self, attr, value):
           print(f'Setting {attr}...')
           super().__setattr__(attr, value)

   sys.modules[__name__].__class__ = VerboseModule

Note:

  Defining module "__getattr__" and setting module "__class__" only
  affect lookups made using the attribute access syntax – directly
  accessing the module globals (whether by code within the module, or
  via a reference to the module’s globals dictionary) is unaffected.

Changed in version 3.5: "__class__" module attribute is now writable.

Added in version 3.7: "__getattr__" and "__dir__" module attributes.

See also:

  **PEP 562** - Module __getattr__ and __dir__
     Describes the "__getattr__" and "__dir__" functions on modules.


Implementing Descriptors
------------------------

The following methods only apply when an instance of the class
containing the method (a so-called *descriptor* class) appears in an
*owner* class (the descriptor must be in either the owner’s class
dictionary or in the class dictionary for one of its parents).  In the
examples below, “the attribute” refers to the attribute whose name is
the key of the property in the owner class’ "__dict__".  The "object"
class itself does not implement any of these protocols.

object.__get__(self, instance, owner=None)

   Called to get the attribute of the owner class (class attribute
   access) or of an instance of that class (instance attribute
   access). The optional *owner* argument is the owner class, while
   *instance* is the instance that the attribute was accessed through,
   or "None" when the attribute is accessed through the *owner*.

   This method should return the computed attribute value or raise an
   "AttributeError" exception.

   **PEP 252** specifies that "__get__()" is callable with one or two
   arguments.  Python’s own built-in descriptors support this
   specification; however, it is likely that some third-party tools
   have descriptors that require both arguments.  Python’s own
   "__getattribute__()" implementation always passes in both arguments
   whether they are required or not.

object.__set__(self, instance, value)

   Called to set the attribute on an instance *instance* of the owner
   class to a new value, *value*.

   Note, adding "__set__()" or "__delete__()" changes the kind of
   descriptor to a “data descriptor”.  See Invoking Descriptors for
   more details.

object.__delete__(self, instance)

   Called to delete the attribute on an instance *instance* of the
   owner class.

Instances of descriptors may also have the "__objclass__" attribute
present:

object.__objclass__

   The attribute "__objclass__" is interpreted by the "inspect" module
   as specifying the class where this object was defined (setting this
   appropriately can assist in runtime introspection of dynamic class
   attributes). For callables, it may indicate that an instance of the
   given type (or a subclass) is expected or required as the first
   positional argument (for example, CPython sets this attribute for
   unbound methods that are implemented in C).


Invoking Descriptors
--------------------

In general, a descriptor is an object attribute with “binding
behavior”, one whose attribute access has been overridden by methods
in the descriptor protocol:  "__get__()", "__set__()", and
"__delete__()". If any of those methods are defined for an object, it
is said to be a descriptor.

The default behavior for attribute access is to get, set, or delete
the attribute from an object’s dictionary. For instance, "a.x" has a
lookup chain starting with "a.__dict__['x']", then
"type(a).__dict__['x']", and continuing through the base classes of
"type(a)" excluding metaclasses.

However, if the looked-up value is an object defining one of the
descriptor methods, then Python may override the default behavior and
invoke the descriptor method instead.  Where this occurs in the
precedence chain depends on which descriptor methods were defined and
how they were called.

The starting point for descriptor invocation is a binding, "a.x". How
the arguments are assembled depends on "a":

Direct Call
   The simplest and least common call is when user code directly
   invokes a descriptor method:    "x.__get__(a)".

Instance Binding
   If binding to an object instance, "a.x" is transformed into the
   call: "type(a).__dict__['x'].__get__(a, type(a))".

Class Binding
   If binding to a class, "A.x" is transformed into the call:
   "A.__dict__['x'].__get__(None, A)".

Super Binding
   A dotted lookup such as "super(A, a).x" searches
   "a.__class__.__mro__" for a base class "B" following "A" and then
   returns "B.__dict__['x'].__get__(a, A)".  If not a descriptor, "x"
   is returned unchanged.

For instance bindings, the precedence of descriptor invocation depends
on which descriptor methods are defined.  A descriptor can define any
combination of "__get__()", "__set__()" and "__delete__()".  If it
does not define "__get__()", then accessing the attribute will return
the descriptor object itself unless there is a value in the object’s
instance dictionary.  If the descriptor defines "__set__()" and/or
"__delete__()", it is a data descriptor; if it defines neither, it is
a non-data descriptor.  Normally, data descriptors define both
"__get__()" and "__set__()", while non-data descriptors have just the
"__get__()" method.  Data descriptors with "__get__()" and "__set__()"
(and/or "__delete__()") defined always override a redefinition in an
instance dictionary.  In contrast, non-data descriptors can be
overridden by instances.

Python methods (including those decorated with "@staticmethod" and
"@classmethod") are implemented as non-data descriptors.  Accordingly,
instances can redefine and override methods.  This allows individual
instances to acquire behaviors that differ from other instances of the
same class.

The "property()" function is implemented as a data descriptor.
Accordingly, instances cannot override the behavior of a property.


__slots__
---------

*__slots__* allow us to explicitly declare data members (like
properties) and deny the creation of "__dict__" and *__weakref__*
(unless explicitly declared in *__slots__* or available in a parent.)

The space saved over using "__dict__" can be significant. Attribute
lookup speed can be significantly improved as well.

object.__slots__

   This class variable can be assigned a string, iterable, or sequence
   of strings with variable names used by instances.  *__slots__*
   reserves space for the declared variables and prevents the
   automatic creation of "__dict__" and *__weakref__* for each
   instance.

Notes on using *__slots__*:

* When inheriting from a class without *__slots__*, the "__dict__" and
  *__weakref__* attribute of the instances will always be accessible.

* Without a "__dict__" variable, instances cannot be assigned new
  variables not listed in the *__slots__* definition.  Attempts to
  assign to an unlisted variable name raises "AttributeError". If
  dynamic assignment of new variables is desired, then add
  "'__dict__'" to the sequence of strings in the *__slots__*
  declaration.

* Without a *__weakref__* variable for each instance, classes defining
  *__slots__* do not support "weak references" to its instances. If
  weak reference support is needed, then add "'__weakref__'" to the
  sequence of strings in the *__slots__* declaration.

* *__slots__* are implemented at the class level by creating
  descriptors for each variable name.  As a result, class attributes
  cannot be used to set default values for instance variables defined
  by *__slots__*; otherwise, the class attribute would overwrite the
  descriptor assignment.

* The action of a *__slots__* declaration is not limited to the class
  where it is defined.  *__slots__* declared in parents are available
  in child classes. However, instances of a child subclass will get a
  "__dict__" and *__weakref__* unless the subclass also defines
  *__slots__* (which should only contain names of any *additional*
  slots).

* If a class defines a slot also defined in a base class, the instance
  variable defined by the base class slot is inaccessible (except by
  retrieving its descriptor directly from the base class). This
  renders the meaning of the program undefined.  In the future, a
  check may be added to prevent this.

* "TypeError" will be raised if nonempty *__slots__* are defined for a
  class derived from a ""variable-length" built-in type" such as
  "int", "bytes", and "tuple".

* Any non-string *iterable* may be assigned to *__slots__*.

* If a "dictionary" is used to assign *__slots__*, the dictionary keys
  will be used as the slot names. The values of the dictionary can be
  used to provide per-attribute docstrings that will be recognised by
  "inspect.getdoc()" and displayed in the output of "help()".

* "__class__" assignment works only if both classes have the same
  *__slots__*.

* Multiple inheritance with multiple slotted parent classes can be
  used, but only one parent is allowed to have attributes created by
  slots (the other bases must have empty slot layouts) - violations
  raise "TypeError".

* If an *iterator* is used for *__slots__* then a *descriptor* is
  created for each of the iterator’s values. However, the *__slots__*
  attribute will be an empty iterator.


Customizing class creation
==========================

Whenever a class inherits from another class, "__init_subclass__()" is
called on the parent class. This way, it is possible to write classes
which change the behavior of subclasses. This is closely related to
class decorators, but where class decorators only affect the specific
class they’re applied to, "__init_subclass__" solely applies to future
subclasses of the class defining the method.

classmethod object.__init_subclass__(cls)

   This method is called whenever the containing class is subclassed.
   *cls* is then the new subclass. If defined as a normal instance
   method, this method is implicitly converted to a class method.

   Keyword arguments which are given to a new class are passed to the
   parent class’s "__init_subclass__". For compatibility with other
   classes using "__init_subclass__", one should take out the needed
   keyword arguments and pass the others over to the base class, as
   in:

      class Philosopher:
          def __init_subclass__(cls, /, default_name, **kwargs):
              super().__init_subclass__(**kwargs)
              cls.default_name = default_name

      class AustralianPhilosopher(Philosopher, default_name="Bruce"):
          pass

   The default implementation "object.__init_subclass__" does nothing,
   but raises an error if it is called with any arguments.

   Note:

     The metaclass hint "metaclass" is consumed by the rest of the
     type machinery, and is never passed to "__init_subclass__"
     implementations. The actual metaclass (rather than the explicit
     hint) can be accessed as "type(cls)".

   Added in version 3.6.

When a class is created, "type.__new__()" scans the class variables
and makes callbacks to those with a "__set_name__()" hook.

object.__set_name__(self, owner, name)

   Automatically called at the time the owning class *owner* is
   created. The object has been assigned to *name* in that class:

      class A:
          x = C()  # Automatically calls: x.__set_name__(A, 'x')

   If the class variable is assigned after the class is created,
   "__set_name__()" will not be called automatically. If needed,
   "__set_name__()" can be called directly:

      class A:
         pass

      c = C()
      A.x = c                  # The hook is not called
      c.__set_name__(A, 'x')   # Manually invoke the hook

   See Creating the class object for more details.

   Added in version 3.6.


Metaclasses
-----------

By default, classes are constructed using "type()". The class body is
executed in a new namespace and the class name is bound locally to the
result of "type(name, bases, namespace)".

The class creation process can be customized by passing the
"metaclass" keyword argument in the class definition line, or by
inheriting from an existing class that included such an argument. In
the following example, both "MyClass" and "MySubclass" are instances
of "Meta":

   class Meta(type):
       pass

   class MyClass(metaclass=Meta):
       pass

   class MySubclass(MyClass):
       pass

Any other keyword arguments that are specified in the class definition
are passed through to all metaclass operations described below.

When a class definition is executed, the following steps occur:

* MRO entries are resolved;

* the appropriate metaclass is determined;

* the class namespace is prepared;

* the class body is executed;

* the class object is created.


Resolving MRO entries
---------------------

object.__mro_entries__(self, bases)

   If a base that appears in a class definition is not an instance of
   "type", then an "__mro_entries__()" method is searched on the base.
   If an "__mro_entries__()" method is found, the base is substituted
   with the result of a call to "__mro_entries__()" when creating the
   class. The method is called with the original bases tuple passed to
   the *bases* parameter, and must return a tuple of classes that will
   be used instead of the base. The returned tuple may be empty: in
   these cases, the original base is ignored.

See also:

  "types.resolve_bases()"
     Dynamically resolve bases that are not instances of "type".

  "types.get_original_bases()"
     Retrieve a class’s “original bases” prior to modifications by
     "__mro_entries__()".

  **PEP 560**
     Core support for typing module and generic types.


Determining the appropriate metaclass
-------------------------------------

The appropriate metaclass for a class definition is determined as
follows:

* if no bases and no explicit metaclass are given, then "type()" is
  used;

* if an explicit metaclass is given and it is *not* an instance of
  "type()", then it is used directly as the metaclass;

* if an instance of "type()" is given as the explicit metaclass, or
  bases are defined, then the most derived metaclass is used.

The most derived metaclass is selected from the explicitly specified
metaclass (if any) and the metaclasses (i.e. "type(cls)") of all
specified base classes. The most derived metaclass is one which is a
subtype of *all* of these candidate metaclasses. If none of the
candidate metaclasses meets that criterion, then the class definition
will fail with "TypeError".


Preparing the class namespace
-----------------------------

Once the appropriate metaclass has been identified, then the class
namespace is prepared. If the metaclass has a "__prepare__" attribute,
it is called as "namespace = metaclass.__prepare__(name, bases,
**kwds)" (where the additional keyword arguments, if any, come from
the class definition). The "__prepare__" method should be implemented
as a "classmethod". The namespace returned by "__prepare__" is passed
in to "__new__", but when the final class object is created the
namespace is copied into a new "dict".

If the metaclass has no "__prepare__" attribute, then the class
namespace is initialised as an empty ordered mapping.

See also:

  **PEP 3115** - Metaclasses in Python 3000
     Introduced the "__prepare__" namespace hook


Executing the class body
------------------------

The class body is executed (approximately) as "exec(body, globals(),
namespace)". The key difference from a normal call to "exec()" is that
lexical scoping allows the class body (including any methods) to
reference names from the current and outer scopes when the class
definition occurs inside a function.

However, even when the class definition occurs inside the function,
methods defined inside the class still cannot see names defined at the
class scope. Class variables must be accessed through the first
parameter of instance or class methods, or through the implicit
lexically scoped "__class__" reference described in the next section.


Creating the class object
-------------------------

Once the class namespace has been populated by executing the class
body, the class object is created by calling "metaclass(name, bases,
namespace, **kwds)" (the additional keywords passed here are the same
as those passed to "__prepare__").

This class object is the one that will be referenced by the zero-
argument form of "super()". "__class__" is an implicit closure
reference created by the compiler if any methods in a class body refer
to either "__class__" or "super". This allows the zero argument form
of "super()" to correctly identify the class being defined based on
lexical scoping, while the class or instance that was used to make the
current call is identified based on the first argument passed to the
method.

**CPython implementation detail:** In CPython 3.6 and later, the
"__class__" cell is passed to the metaclass as a "__classcell__" entry
in the class namespace. If present, this must be propagated up to the
"type.__new__" call in order for the class to be initialised
correctly. Failing to do so will result in a "RuntimeError" in Python
3.8.

When using the default metaclass "type", or any metaclass that
ultimately calls "type.__new__", the following additional
customization steps are invoked after creating the class object:

1. The "type.__new__" method collects all of the attributes in the
   class namespace that define a "__set_name__()" method;

2. Those "__set_name__" methods are called with the class being
   defined and the assigned name of that particular attribute;

3. The "__init_subclass__()" hook is called on the immediate parent of
   the new class in its method resolution order.

After the class object is created, it is passed to the class
decorators included in the class definition (if any) and the resulting
object is bound in the local namespace as the defined class.

When a new class is created by "type.__new__", the object provided as
the namespace parameter is copied to a new ordered mapping and the
original object is discarded. The new copy is wrapped in a read-only
proxy, which becomes the "__dict__" attribute of the class object.

See also:

  **PEP 3135** - New super
     Describes the implicit "__class__" closure reference


Uses for metaclasses
--------------------

The potential uses for metaclasses are boundless. Some ideas that have
been explored include enum, logging, interface checking, automatic
delegation, automatic property creation, proxies, frameworks, and
automatic resource locking/synchronization.


Customizing instance and subclass checks
========================================

The following methods are used to override the default behavior of the
"isinstance()" and "issubclass()" built-in functions.

In particular, the metaclass "abc.ABCMeta" implements these methods in
order to allow the addition of Abstract Base Classes (ABCs) as
“virtual base classes” to any class or type (including built-in
types), including other ABCs.

type.__instancecheck__(self, instance)

   Return true if *instance* should be considered a (direct or
   indirect) instance of *class*. If defined, called to implement
   "isinstance(instance, class)".

type.__subclasscheck__(self, subclass)

   Return true if *subclass* should be considered a (direct or
   indirect) subclass of *class*.  If defined, called to implement
   "issubclass(subclass, class)".

Note that these methods are looked up on the type (metaclass) of a
class.  They cannot be defined as class methods in the actual class.
This is consistent with the lookup of special methods that are called
on instances, only in this case the instance is itself a class.

See also:

  **PEP 3119** - Introducing Abstract Base Classes
     Includes the specification for customizing "isinstance()" and
     "issubclass()" behavior through "__instancecheck__()" and
     "__subclasscheck__()", with motivation for this functionality in
     the context of adding Abstract Base Classes (see the "abc"
     module) to the language.


Emulating generic types
=======================

When using *type annotations*, it is often useful to *parameterize* a
*generic type* using Python’s square-brackets notation. For example,
the annotation "list[int]" might be used to signify a "list" in which
all the elements are of type "int".

See also:

  **PEP 484** - Type Hints
     Introducing Python’s framework for type annotations

  Generic Alias Types
     Documentation for objects representing parameterized generic
     classes

  Generics, user-defined generics and "typing.Generic"
     Documentation on how to implement generic classes that can be
     parameterized at runtime and understood by static type-checkers.

A class can *generally* only be parameterized if it defines the
special class method "__class_getitem__()".

classmethod object.__class_getitem__(cls, key)

   Return an object representing the specialization of a generic class
   by type arguments found in *key*.

   When defined on a class, "__class_getitem__()" is automatically a
   class method. As such, there is no need for it to be decorated with
   "@classmethod" when it is defined.


The purpose of *__class_getitem__*
----------------------------------

The purpose of "__class_getitem__()" is to allow runtime
parameterization of standard-library generic classes in order to more
easily apply *type hints* to these classes.

To implement custom generic classes that can be parameterized at
runtime and understood by static type-checkers, users should either
inherit from a standard library class that already implements
"__class_getitem__()", or inherit from "typing.Generic", which has its
own implementation of "__class_getitem__()".

Custom implementations of "__class_getitem__()" on classes defined
outside of the standard library may not be understood by third-party
type-checkers such as mypy. Using "__class_getitem__()" on any class
for purposes other than type hinting is discouraged.


*__class_getitem__* versus *__getitem__*
----------------------------------------

Usually, the subscription of an object using square brackets will call
the "__getitem__()" instance method defined on the object’s class.
However, if the object being subscribed is itself a class, the class
method "__class_getitem__()" may be called instead.
"__class_getitem__()" should return a GenericAlias object if it is
properly defined.

Presented with the *expression* "obj[x]", the Python interpreter
follows something like the following process to decide whether
"__getitem__()" or "__class_getitem__()" should be called:

   from inspect import isclass

   def subscribe(obj, x):
       """Return the result of the expression 'obj[x]'"""

       class_of_obj = type(obj)

       # If the class of obj defines __getitem__,
       # call class_of_obj.__getitem__(obj, x)
       if hasattr(class_of_obj, '__getitem__'):
           return class_of_obj.__getitem__(obj, x)

       # Else, if obj is a class and defines __class_getitem__,
       # call obj.__class_getitem__(x)
       elif isclass(obj) and hasattr(obj, '__class_getitem__'):
           return obj.__class_getitem__(x)

       # Else, raise an exception
       else:
           raise TypeError(
               f"'{class_of_obj.__name__}' object is not subscriptable"
           )

In Python, all classes are themselves instances of other classes. The
class of a class is known as that class’s *metaclass*, and most
classes have the "type" class as their metaclass. "type" does not
define "__getitem__()", meaning that expressions such as "list[int]",
"dict[str, float]" and "tuple[str, bytes]" all result in
"__class_getitem__()" being called:

   >>> # list has class "type" as its metaclass, like most classes:
   >>> type(list)
   <class 'type'>
   >>> type(dict) == type(list) == type(tuple) == type(str) == type(bytes)
   True
   >>> # "list[int]" calls "list.__class_getitem__(int)"
   >>> list[int]
   list[int]
   >>> # list.__class_getitem__ returns a GenericAlias object:
   >>> type(list[int])
   <class 'types.GenericAlias'>

However, if a class has a custom metaclass that defines
"__getitem__()", subscribing the class may result in different
behaviour. An example of this can be found in the "enum" module:

   >>> from enum import Enum
   >>> class Menu(Enum):
   ...     """A breakfast menu"""
   ...     SPAM = 'spam'
   ...     BACON = 'bacon'
   ...
   >>> # Enum classes have a custom metaclass:
   >>> type(Menu)
   <class 'enum.EnumMeta'>
   >>> # EnumMeta defines __getitem__,
   >>> # so __class_getitem__ is not called,
   >>> # and the result is not a GenericAlias object:
   >>> Menu['SPAM']
   <Menu.SPAM: 'spam'>
   >>> type(Menu['SPAM'])
   <enum 'Menu'>

See also:

  **PEP 560** - Core Support for typing module and generic types
     Introducing "__class_getitem__()", and outlining when a
     subscription results in "__class_getitem__()" being called
     instead of "__getitem__()"


Emulating callable objects
==========================

object.__call__(self[, args...])

   Called when the instance is “called” as a function; if this method
   is defined, "x(arg1, arg2, ...)" roughly translates to
   "type(x).__call__(x, arg1, ...)". The "object" class itself does
   not provide this method.


Emulating container types
=========================

The following methods can be defined to implement container objects.
None of them are provided by the "object" class itself. Containers
usually are *sequences* (such as "lists" or "tuples") or *mappings*
(like *dictionaries*), but can represent other containers as well.
The first set of methods is used either to emulate a sequence or to
emulate a mapping; the difference is that for a sequence, the
allowable keys should be the integers *k* for which "0 <= k < N" where
*N* is the length of the sequence, or "slice" objects, which define a
range of items.  It is also recommended that mappings provide the
methods "keys()", "values()", "items()", "get()", "clear()",
"setdefault()", "pop()", "popitem()", "copy()", and "update()"
behaving similar to those for Python’s standard "dictionary" objects.
The "collections.abc" module provides a "MutableMapping" *abstract
base class* to help create those methods from a base set of
"__getitem__()", "__setitem__()", "__delitem__()", and "keys()".
Mutable sequences should provide methods "append()", "count()",
"index()", "extend()", "insert()", "pop()", "remove()", "reverse()"
and "sort()", like Python standard "list" objects. Finally, sequence
types should implement addition (meaning concatenation) and
multiplication (meaning repetition) by defining the methods
"__add__()", "__radd__()", "__iadd__()", "__mul__()", "__rmul__()" and
"__imul__()" described below; they should not define other numerical
operators.  It is recommended that both mappings and sequences
implement the "__contains__()" method to allow efficient use of the
"in" operator; for mappings, "in" should search the mapping’s keys;
for sequences, it should search through the values.  It is further
recommended that both mappings and sequences implement the
"__iter__()" method to allow efficient iteration through the
container; for mappings, "__iter__()" should iterate through the
object’s keys; for sequences, it should iterate through the values.

object.__len__(self)

   Called to implement the built-in function "len()".  Should return
   the length of the object, an integer ">=" 0.  Also, an object that
   doesn’t define a "__bool__()" method and whose "__len__()" method
   returns zero is considered to be false in a Boolean context.

   **CPython implementation detail:** In CPython, the length is
   required to be at most "sys.maxsize". If the length is larger than
   "sys.maxsize" some features (such as "len()") may raise
   "OverflowError".  To prevent raising "OverflowError" by truth value
   testing, an object must define a "__bool__()" method.

object.__length_hint__(self)

   Called to implement "operator.length_hint()". Should return an
   estimated length for the object (which may be greater or less than
   the actual length). The length must be an integer ">=" 0. The
   return value may also be "NotImplemented", which is treated the
   same as if the "__length_hint__" method didn’t exist at all. This
   method is purely an optimization and is never required for
   correctness.

   Added in version 3.4.

Note:

  Slicing is done exclusively with the following three methods.  A
  call like

     a[1:2] = b

  is translated to

     a[slice(1, 2, None)] = b

  and so forth.  Missing slice items are always filled in with "None".

object.__getitem__(self, key)

   Called to implement evaluation of "self[key]". For *sequence*
   types, the accepted keys should be integers. Optionally, they may
   support "slice" objects as well.  Negative index support is also
   optional. If *key* is of an inappropriate type, "TypeError" may be
   raised; if *key* is a value outside the set of indexes for the
   sequence (after any special interpretation of negative values),
   "IndexError" should be raised. For *mapping* types, if *key* is
   missing (not in the container), "KeyError" should be raised.

   Note:

     "for" loops expect that an "IndexError" will be raised for
     illegal indexes to allow proper detection of the end of the
     sequence.

   Note:

     When subscripting a *class*, the special class method
     "__class_getitem__()" may be called instead of "__getitem__()".
     See __class_getitem__ versus __getitem__ for more details.

object.__setitem__(self, key, value)

   Called to implement assignment to "self[key]".  Same note as for
   "__getitem__()".  This should only be implemented for mappings if
   the objects support changes to the values for keys, or if new keys
   can be added, or for sequences if elements can be replaced.  The
   same exceptions should be raised for improper *key* values as for
   the "__getitem__()" method.

object.__delitem__(self, key)

   Called to implement deletion of "self[key]".  Same note as for
   "__getitem__()".  This should only be implemented for mappings if
   the objects support removal of keys, or for sequences if elements
   can be removed from the sequence.  The same exceptions should be
   raised for improper *key* values as for the "__getitem__()" method.

object.__missing__(self, key)

   Called by "dict"."__getitem__()" to implement "self[key]" for dict
   subclasses when key is not in the dictionary.

object.__iter__(self)

   This method is called when an *iterator* is required for a
   container. This method should return a new iterator object that can
   iterate over all the objects in the container.  For mappings, it
   should iterate over the keys of the container.

object.__reversed__(self)

   Called (if present) by the "reversed()" built-in to implement
   reverse iteration.  It should return a new iterator object that
   iterates over all the objects in the container in reverse order.

   If the "__reversed__()" method is not provided, the "reversed()"
   built-in will fall back to using the sequence protocol ("__len__()"
   and "__getitem__()").  Objects that support the sequence protocol
   should only provide "__reversed__()" if they can provide an
   implementation that is more efficient than the one provided by
   "reversed()".

The membership test operators ("in" and "not in") are normally
implemented as an iteration through a container. However, container
objects can supply the following special method with a more efficient
implementation, which also does not require the object be iterable.

object.__contains__(self, item)

   Called to implement membership test operators.  Should return true
   if *item* is in *self*, false otherwise.  For mapping objects, this
   should consider the keys of the mapping rather than the values or
   the key-item pairs.

   For objects that don’t define "__contains__()", the membership test
   first tries iteration via "__iter__()", then the old sequence
   iteration protocol via "__getitem__()", see this section in the
   language reference.


Emulating numeric types
=======================

The following methods can be defined to emulate numeric objects.
Methods corresponding to operations that are not supported by the
particular kind of number implemented (e.g., bitwise operations for
non-integral numbers) should be left undefined.

object.__add__(self, other)
object.__sub__(self, other)
object.__mul__(self, other)
object.__matmul__(self, other)
object.__truediv__(self, other)
object.__floordiv__(self, other)
object.__mod__(self, other)
object.__divmod__(self, other)
object.__pow__(self, other[, modulo])
object.__lshift__(self, other)
object.__rshift__(self, other)
object.__and__(self, other)
object.__xor__(self, other)
object.__or__(self, other)

   These methods are called to implement the binary arithmetic
   operations ("+", "-", "*", "@", "/", "//", "%", "divmod()",
   "pow()", "**", "<<", ">>", "&", "^", "|").  For instance, to
   evaluate the expression "x + y", where *x* is an instance of a
   class that has an "__add__()" method, "type(x).__add__(x, y)" is
   called.  The "__divmod__()" method should be the equivalent to
   using "__floordiv__()" and "__mod__()"; it should not be related to
   "__truediv__()".  Note that "__pow__()" should be defined to accept
   an optional third argument if the ternary version of the built-in
   "pow()" function is to be supported.

   If one of those methods does not support the operation with the
   supplied arguments, it should return "NotImplemented".

object.__radd__(self, other)
object.__rsub__(self, other)
object.__rmul__(self, other)
object.__rmatmul__(self, other)
object.__rtruediv__(self, other)
object.__rfloordiv__(self, other)
object.__rmod__(self, other)
object.__rdivmod__(self, other)
object.__rpow__(self, other[, modulo])
object.__rlshift__(self, other)
object.__rrshift__(self, other)
object.__rand__(self, other)
object.__rxor__(self, other)
object.__ror__(self, other)

   These methods are called to implement the binary arithmetic
   operations ("+", "-", "*", "@", "/", "//", "%", "divmod()",
   "pow()", "**", "<<", ">>", "&", "^", "|") with reflected (swapped)
   operands.  These functions are only called if the left operand does
   not support the corresponding operation [3] and the operands are of
   different types. [4] For instance, to evaluate the expression "x -
   y", where *y* is an instance of a class that has an "__rsub__()"
   method, "type(y).__rsub__(y, x)" is called if "type(x).__sub__(x,
   y)" returns "NotImplemented".

   Note that ternary "pow()" will not try calling "__rpow__()" (the
   coercion rules would become too complicated).

   Note:

     If the right operand’s type is a subclass of the left operand’s
     type and that subclass provides a different implementation of the
     reflected method for the operation, this method will be called
     before the left operand’s non-reflected method. This behavior
     allows subclasses to override their ancestors’ operations.

object.__iadd__(self, other)
object.__isub__(self, other)
object.__imul__(self, other)
object.__imatmul__(self, other)
object.__itruediv__(self, other)
object.__ifloordiv__(self, other)
object.__imod__(self, other)
object.__ipow__(self, other[, modulo])
object.__ilshift__(self, other)
object.__irshift__(self, other)
object.__iand__(self, other)
object.__ixor__(self, other)
object.__ior__(self, other)

   These methods are called to implement the augmented arithmetic
   assignments ("+=", "-=", "*=", "@=", "/=", "//=", "%=", "**=",
   "<<=", ">>=", "&=", "^=", "|=").  These methods should attempt to
   do the operation in-place (modifying *self*) and return the result
   (which could be, but does not have to be, *self*).  If a specific
   method is not defined, or if that method returns "NotImplemented",
   the augmented assignment falls back to the normal methods.  For
   instance, if *x* is an instance of a class with an "__iadd__()"
   method, "x += y" is equivalent to "x = x.__iadd__(y)" . If
   "__iadd__()" does not exist, or if "x.__iadd__(y)" returns
   "NotImplemented", "x.__add__(y)" and "y.__radd__(x)" are
   considered, as with the evaluation of "x + y". In certain
   situations, augmented assignment can result in unexpected errors
   (see Why does a_tuple[i] += [‘item’] raise an exception when the
   addition works?), but this behavior is in fact part of the data
   model.

object.__neg__(self)
object.__pos__(self)
object.__abs__(self)
object.__invert__(self)

   Called to implement the unary arithmetic operations ("-", "+",
   "abs()" and "~").

object.__complex__(self)
object.__int__(self)
object.__float__(self)

   Called to implement the built-in functions "complex()", "int()" and
   "float()".  Should return a value of the appropriate type.

object.__index__(self)

   Called to implement "operator.index()", and whenever Python needs
   to losslessly convert the numeric object to an integer object (such
   as in slicing, or in the built-in "bin()", "hex()" and "oct()"
   functions). Presence of this method indicates that the numeric
   object is an integer type.  Must return an integer.

   If "__int__()", "__float__()" and "__complex__()" are not defined
   then corresponding built-in functions "int()", "float()" and
   "complex()" fall back to "__index__()".

object.__round__(self[, ndigits])
object.__trunc__(self)
object.__floor__(self)
object.__ceil__(self)

   Called to implement the built-in function "round()" and "math"
   functions "trunc()", "floor()" and "ceil()". Unless *ndigits* is
   passed to "__round__()" all these methods should return the value
   of the object truncated to an "Integral" (typically an "int").

   The built-in function "int()" falls back to "__trunc__()" if
   neither "__int__()" nor "__index__()" is defined.

   Changed in version 3.11: The delegation of "int()" to "__trunc__()"
   is deprecated.


With Statement Context Managers
===============================

A *context manager* is an object that defines the runtime context to
be established when executing a "with" statement. The context manager
handles the entry into, and the exit from, the desired runtime context
for the execution of the block of code.  Context managers are normally
invoked using the "with" statement (described in section The with
statement), but can also be used by directly invoking their methods.

Typical uses of context managers include saving and restoring various
kinds of global state, locking and unlocking resources, closing opened
files, etc.

For more information on context managers, see Context Manager Types.
The "object" class itself does not provide the context manager
methods.

object.__enter__(self)

   Enter the runtime context related to this object. The "with"
   statement will bind this method’s return value to the target(s)
   specified in the "as" clause of the statement, if any.

object.__exit__(self, exc_type, exc_value, traceback)

   Exit the runtime context related to this object. The parameters
   describe the exception that caused the context to be exited. If the
   context was exited without an exception, all three arguments will
   be "None".

   If an exception is supplied, and the method wishes to suppress the
   exception (i.e., prevent it from being propagated), it should
   return a true value. Otherwise, the exception will be processed
   normally upon exit from this method.

   Note that "__exit__()" methods should not reraise the passed-in
   exception; this is the caller’s responsibility.

See also:

  **PEP 343** - The “with” statement
     The specification, background, and examples for the Python "with"
     statement.


Customizing positional arguments in class pattern matching
==========================================================

When using a class name in a pattern, positional arguments in the
pattern are not allowed by default, i.e. "case MyClass(x, y)" is
typically invalid without special support in "MyClass". To be able to
use that kind of pattern, the class needs to define a *__match_args__*
attribute.

object.__match_args__

   This class variable can be assigned a tuple of strings. When this
   class is used in a class pattern with positional arguments, each
   positional argument will be converted into a keyword argument,
   using the corresponding value in *__match_args__* as the keyword.
   The absence of this attribute is equivalent to setting it to "()".

For example, if "MyClass.__match_args__" is "("left", "center",
"right")" that means that "case MyClass(x, y)" is equivalent to "case
MyClass(left=x, center=y)". Note that the number of arguments in the
pattern must be smaller than or equal to the number of elements in
*__match_args__*; if it is larger, the pattern match attempt will
raise a "TypeError".

Added in version 3.10.

See also:

  **PEP 634** - Structural Pattern Matching
     The specification for the Python "match" statement.


Emulating buffer types
======================

The buffer protocol provides a way for Python objects to expose
efficient access to a low-level memory array. This protocol is
implemented by builtin types such as "bytes" and "memoryview", and
third-party libraries may define additional buffer types.

While buffer types are usually implemented in C, it is also possible
to implement the protocol in Python.

object.__buffer__(self, flags)

   Called when a buffer is requested from *self* (for example, by the
   "memoryview" constructor). The *flags* argument is an integer
   representing the kind of buffer requested, affecting for example
   whether the returned buffer is read-only or writable.
   "inspect.BufferFlags" provides a convenient way to interpret the
   flags. The method must return a "memoryview" object.

object.__release_buffer__(self, buffer)

   Called when a buffer is no longer needed. The *buffer* argument is
   a "memoryview" object that was previously returned by
   "__buffer__()". The method must release any resources associated
   with the buffer. This method should return "None". Buffer objects
   that do not need to perform any cleanup are not required to
   implement this method.

Added in version 3.12.

See also:

  **PEP 688** - Making the buffer protocol accessible in Python
     Introduces the Python "__buffer__" and "__release_buffer__"
     methods.

  "collections.abc.Buffer"
     ABC for buffer types.


Special method lookup
=====================

For custom classes, implicit invocations of special methods are only
guaranteed to work correctly if defined on an object’s type, not in
the object’s instance dictionary.  That behaviour is the reason why
the following code raises an exception:

   >>> class C:
   ...     pass
   ...
   >>> c = C()
   >>> c.__len__ = lambda: 5
   >>> len(c)
   Traceback (most recent call last):
     File "<stdin>", line 1, in <module>
   TypeError: object of type 'C' has no len()

The rationale behind this behaviour lies with a number of special
methods such as "__hash__()" and "__repr__()" that are implemented by
all objects, including type objects. If the implicit lookup of these
methods used the conventional lookup process, they would fail when
invoked on the type object itself:

   >>> 1 .__hash__() == hash(1)
   True
   >>> int.__hash__() == hash(int)
   Traceback (most recent call last):
     File "<stdin>", line 1, in <module>
   TypeError: descriptor '__hash__' of 'int' object needs an argument

Incorrectly attempting to invoke an unbound method of a class in this
way is sometimes referred to as ‘metaclass confusion’, and is avoided
by bypassing the instance when looking up special methods:

   >>> type(1).__hash__(1) == hash(1)
   True
   >>> type(int).__hash__(int) == hash(int)
   True

In addition to bypassing any instance attributes in the interest of
correctness, implicit special method lookup generally also bypasses
the "__getattribute__()" method even of the object’s metaclass:

   >>> class Meta(type):
   ...     def __getattribute__(*args):
   ...         print("Metaclass getattribute invoked")
   ...         return type.__getattribute__(*args)
   ...
   >>> class C(object, metaclass=Meta):
   ...     def __len__(self):
   ...         return 10
   ...     def __getattribute__(*args):
   ...         print("Class getattribute invoked")
   ...         return object.__getattribute__(*args)
   ...
   >>> c = C()
   >>> c.__len__()                 # Explicit lookup via instance
   Class getattribute invoked
   10
   >>> type(c).__len__(c)          # Explicit lookup via type
   Metaclass getattribute invoked
   10
   >>> len(c)                      # Implicit lookup
   10

Bypassing the "__getattribute__()" machinery in this fashion provides
significant scope for speed optimisations within the interpreter, at
the cost of some flexibility in the handling of special methods (the
special method *must* be set on the class object itself in order to be
consistently invoked by the interpreter).
''',
    'string-methods': r'''String Methods
**************

Strings implement all of the common sequence operations, along with
the additional methods described below.

Strings also support two styles of string formatting, one providing a
large degree of flexibility and customization (see "str.format()",
Format String Syntax and Custom String Formatting) and the other based
on C "printf" style formatting that handles a narrower range of types
and is slightly harder to use correctly, but is often faster for the
cases it can handle (printf-style String Formatting).

The Text Processing Services section of the standard library covers a
number of other modules that provide various text related utilities
(including regular expression support in the "re" module).

str.capitalize()

   Return a copy of the string with its first character capitalized
   and the rest lowercased.

   Changed in version 3.8: The first character is now put into
   titlecase rather than uppercase. This means that characters like
   digraphs will only have their first letter capitalized, instead of
   the full character.

str.casefold()

   Return a casefolded copy of the string. Casefolded strings may be
   used for caseless matching.

   Casefolding is similar to lowercasing but more aggressive because
   it is intended to remove all case distinctions in a string. For
   example, the German lowercase letter "'ß'" is equivalent to ""ss"".
   Since it is already lowercase, "lower()" would do nothing to "'ß'";
   "casefold()" converts it to ""ss"".

   The casefolding algorithm is described in section 3.13 ‘Default
   Case Folding’ of the Unicode Standard.

   Added in version 3.3.

str.center(width[, fillchar])

   Return centered in a string of length *width*. Padding is done
   using the specified *fillchar* (default is an ASCII space). The
   original string is returned if *width* is less than or equal to
   "len(s)".

str.count(sub[, start[, end]])

   Return the number of non-overlapping occurrences of substring *sub*
   in the range [*start*, *end*].  Optional arguments *start* and
   *end* are interpreted as in slice notation.

   If *sub* is empty, returns the number of empty strings between
   characters which is the length of the string plus one.

str.encode(encoding='utf-8', errors='strict')

   Return the string encoded to "bytes".

   *encoding* defaults to "'utf-8'"; see Standard Encodings for
   possible values.

   *errors* controls how encoding errors are handled. If "'strict'"
   (the default), a "UnicodeError" exception is raised. Other possible
   values are "'ignore'", "'replace'", "'xmlcharrefreplace'",
   "'backslashreplace'" and any other name registered via
   "codecs.register_error()". See Error Handlers for details.

   For performance reasons, the value of *errors* is not checked for
   validity unless an encoding error actually occurs, Python
   Development Mode is enabled or a debug build is used.

   Changed in version 3.1: Added support for keyword arguments.

   Changed in version 3.9: The value of the *errors* argument is now
   checked in Python Development Mode and in debug mode.

str.endswith(suffix[, start[, end]])

   Return "True" if the string ends with the specified *suffix*,
   otherwise return "False".  *suffix* can also be a tuple of suffixes
   to look for.  With optional *start*, test beginning at that
   position.  With optional *end*, stop comparing at that position.

str.expandtabs(tabsize=8)

   Return a copy of the string where all tab characters are replaced
   by one or more spaces, depending on the current column and the
   given tab size.  Tab positions occur every *tabsize* characters
   (default is 8, giving tab positions at columns 0, 8, 16 and so on).
   To expand the string, the current column is set to zero and the
   string is examined character by character.  If the character is a
   tab ("\t"), one or more space characters are inserted in the result
   until the current column is equal to the next tab position. (The
   tab character itself is not copied.)  If the character is a newline
   ("\n") or return ("\r"), it is copied and the current column is
   reset to zero.  Any other character is copied unchanged and the
   current column is incremented by one regardless of how the
   character is represented when printed.

   >>> '01\t012\t0123\t01234'.expandtabs()
   '01      012     0123    01234'
   >>> '01\t012\t0123\t01234'.expandtabs(4)
   '01  012 0123    01234'

str.find(sub[, start[, end]])

   Return the lowest index in the string where substring *sub* is
   found within the slice "s[start:end]".  Optional arguments *start*
   and *end* are interpreted as in slice notation.  Return "-1" if
   *sub* is not found.

   Note:

     The "find()" method should be used only if you need to know the
     position of *sub*.  To check if *sub* is a substring or not, use
     the "in" operator:

        >>> 'Py' in 'Python'
        True

str.format(*args, **kwargs)

   Perform a string formatting operation.  The string on which this
   method is called can contain literal text or replacement fields
   delimited by braces "{}".  Each replacement field contains either
   the numeric index of a positional argument, or the name of a
   keyword argument.  Returns a copy of the string where each
   replacement field is replaced with the string value of the
   corresponding argument.

   >>> "The sum of 1 + 2 is {0}".format(1+2)
   'The sum of 1 + 2 is 3'

   See Format String Syntax for a description of the various
   formatting options that can be specified in format strings.

   Note:

     When formatting a number ("int", "float", "complex",
     "decimal.Decimal" and subclasses) with the "n" type (ex:
     "'{:n}'.format(1234)"), the function temporarily sets the
     "LC_CTYPE" locale to the "LC_NUMERIC" locale to decode
     "decimal_point" and "thousands_sep" fields of "localeconv()" if
     they are non-ASCII or longer than 1 byte, and the "LC_NUMERIC"
     locale is different than the "LC_CTYPE" locale.  This temporary
     change affects other threads.

   Changed in version 3.7: When formatting a number with the "n" type,
   the function sets temporarily the "LC_CTYPE" locale to the
   "LC_NUMERIC" locale in some cases.

str.format_map(mapping)

   Similar to "str.format(**mapping)", except that "mapping" is used
   directly and not copied to a "dict".  This is useful if for example
   "mapping" is a dict subclass:

   >>> class Default(dict):
   ...     def __missing__(self, key):
   ...         return key
   ...
   >>> '{name} was born in {country}'.format_map(Default(name='Guido'))
   'Guido was born in country'

   Added in version 3.2.

str.index(sub[, start[, end]])

   Like "find()", but raise "ValueError" when the substring is not
   found.

str.isalnum()

   Return "True" if all characters in the string are alphanumeric and
   there is at least one character, "False" otherwise.  A character
   "c" is alphanumeric if one of the following returns "True":
   "c.isalpha()", "c.isdecimal()", "c.isdigit()", or "c.isnumeric()".

str.isalpha()

   Return "True" if all characters in the string are alphabetic and
   there is at least one character, "False" otherwise.  Alphabetic
   characters are those characters defined in the Unicode character
   database as “Letter”, i.e., those with general category property
   being one of “Lm”, “Lt”, “Lu”, “Ll”, or “Lo”.  Note that this is
   different from the Alphabetic property defined in the section 4.10
   ‘Letters, Alphabetic, and Ideographic’ of the Unicode Standard.

str.isascii()

   Return "True" if the string is empty or all characters in the
   string are ASCII, "False" otherwise. ASCII characters have code
   points in the range U+0000-U+007F.

   Added in version 3.7.

str.isdecimal()

   Return "True" if all characters in the string are decimal
   characters and there is at least one character, "False" otherwise.
   Decimal characters are those that can be used to form numbers in
   base 10, e.g. U+0660, ARABIC-INDIC DIGIT ZERO.  Formally a decimal
   character is a character in the Unicode General Category “Nd”.

str.isdigit()

   Return "True" if all characters in the string are digits and there
   is at least one character, "False" otherwise.  Digits include
   decimal characters and digits that need special handling, such as
   the compatibility superscript digits. This covers digits which
   cannot be used to form numbers in base 10, like the Kharosthi
   numbers.  Formally, a digit is a character that has the property
   value Numeric_Type=Digit or Numeric_Type=Decimal.

str.isidentifier()

   Return "True" if the string is a valid identifier according to the
   language definition, section Identifiers and keywords.

   "keyword.iskeyword()" can be used to test whether string "s" is a
   reserved identifier, such as "def" and "class".

   Example:

      >>> from keyword import iskeyword

      >>> 'hello'.isidentifier(), iskeyword('hello')
      (True, False)
      >>> 'def'.isidentifier(), iskeyword('def')
      (True, True)

str.islower()

   Return "True" if all cased characters [4] in the string are
   lowercase and there is at least one cased character, "False"
   otherwise.

str.isnumeric()

   Return "True" if all characters in the string are numeric
   characters, and there is at least one character, "False" otherwise.
   Numeric characters include digit characters, and all characters
   that have the Unicode numeric value property, e.g. U+2155, VULGAR
   FRACTION ONE FIFTH.  Formally, numeric characters are those with
   the property value Numeric_Type=Digit, Numeric_Type=Decimal or
   Numeric_Type=Numeric.

str.isprintable()

   Return true if all characters in the string are printable, false if
   it contains at least one non-printable character.

   Here “printable” means the character is suitable for "repr()" to
   use in its output; “non-printable” means that "repr()" on built-in
   types will hex-escape the character.  It has no bearing on the
   handling of strings written to "sys.stdout" or "sys.stderr".

   The printable characters are those which in the Unicode character
   database (see "unicodedata") have a general category in group
   Letter, Mark, Number, Punctuation, or Symbol (L, M, N, P, or S);
   plus the ASCII space 0x20. Nonprintable characters are those in
   group Separator or Other (Z or C), except the ASCII space.

str.isspace()

   Return "True" if there are only whitespace characters in the string
   and there is at least one character, "False" otherwise.

   A character is *whitespace* if in the Unicode character database
   (see "unicodedata"), either its general category is "Zs"
   (“Separator, space”), or its bidirectional class is one of "WS",
   "B", or "S".

str.istitle()

   Return "True" if the string is a titlecased string and there is at
   least one character, for example uppercase characters may only
   follow uncased characters and lowercase characters only cased ones.
   Return "False" otherwise.

str.isupper()

   Return "True" if all cased characters [4] in the string are
   uppercase and there is at least one cased character, "False"
   otherwise.

   >>> 'BANANA'.isupper()
   True
   >>> 'banana'.isupper()
   False
   >>> 'baNana'.isupper()
   False
   >>> ' '.isupper()
   False

str.join(iterable)

   Return a string which is the concatenation of the strings in
   *iterable*. A "TypeError" will be raised if there are any non-
   string values in *iterable*, including "bytes" objects.  The
   separator between elements is the string providing this method.

str.ljust(width[, fillchar])

   Return the string left justified in a string of length *width*.
   Padding is done using the specified *fillchar* (default is an ASCII
   space). The original string is returned if *width* is less than or
   equal to "len(s)".

str.lower()

   Return a copy of the string with all the cased characters [4]
   converted to lowercase.

   The lowercasing algorithm used is described in section 3.13
   ‘Default Case Folding’ of the Unicode Standard.

str.lstrip([chars])

   Return a copy of the string with leading characters removed.  The
   *chars* argument is a string specifying the set of characters to be
   removed.  If omitted or "None", the *chars* argument defaults to
   removing whitespace.  The *chars* argument is not a prefix; rather,
   all combinations of its values are stripped:

      >>> '   spacious   '.lstrip()
      'spacious   '
      >>> 'www.example.com'.lstrip('cmowz.')
      'example.com'

   See "str.removeprefix()" for a method that will remove a single
   prefix string rather than all of a set of characters.  For example:

      >>> 'Arthur: three!'.lstrip('Arthur: ')
      'ee!'
      >>> 'Arthur: three!'.removeprefix('Arthur: ')
      'three!'

static str.maketrans(x[, y[, z]])

   This static method returns a translation table usable for
   "str.translate()".

   If there is only one argument, it must be a dictionary mapping
   Unicode ordinals (integers) or characters (strings of length 1) to
   Unicode ordinals, strings (of arbitrary lengths) or "None".
   Character keys will then be converted to ordinals.

   If there are two arguments, they must be strings of equal length,
   and in the resulting dictionary, each character in x will be mapped
   to the character at the same position in y.  If there is a third
   argument, it must be a string, whose characters will be mapped to
   "None" in the result.

str.partition(sep)

   Split the string at the first occurrence of *sep*, and return a
   3-tuple containing the part before the separator, the separator
   itself, and the part after the separator.  If the separator is not
   found, return a 3-tuple containing the string itself, followed by
   two empty strings.

str.removeprefix(prefix, /)

   If the string starts with the *prefix* string, return
   "string[len(prefix):]". Otherwise, return a copy of the original
   string:

      >>> 'TestHook'.removeprefix('Test')
      'Hook'
      >>> 'BaseTestCase'.removeprefix('Test')
      'BaseTestCase'

   Added in version 3.9.

str.removesuffix(suffix, /)

   If the string ends with the *suffix* string and that *suffix* is
   not empty, return "string[:-len(suffix)]". Otherwise, return a copy
   of the original string:

      >>> 'MiscTests'.removesuffix('Tests')
      'Misc'
      >>> 'TmpDirMixin'.removesuffix('Tests')
      'TmpDirMixin'

   Added in version 3.9.

str.replace(old, new[, count])

   Return a copy of the string with all occurrences of substring *old*
   replaced by *new*.  If the optional argument *count* is given, only
   the first *count* occurrences are replaced.

str.rfind(sub[, start[, end]])

   Return the highest index in the string where substring *sub* is
   found, such that *sub* is contained within "s[start:end]".
   Optional arguments *start* and *end* are interpreted as in slice
   notation.  Return "-1" on failure.

str.rindex(sub[, start[, end]])

   Like "rfind()" but raises "ValueError" when the substring *sub* is
   not found.

str.rjust(width[, fillchar])

   Return the string right justified in a string of length *width*.
   Padding is done using the specified *fillchar* (default is an ASCII
   space). The original string is returned if *width* is less than or
   equal to "len(s)".

str.rpartition(sep)

   Split the string at the last occurrence of *sep*, and return a
   3-tuple containing the part before the separator, the separator
   itself, and the part after the separator.  If the separator is not
   found, return a 3-tuple containing two empty strings, followed by
   the string itself.

str.rsplit(sep=None, maxsplit=-1)

   Return a list of the words in the string, using *sep* as the
   delimiter string. If *maxsplit* is given, at most *maxsplit* splits
   are done, the *rightmost* ones.  If *sep* is not specified or
   "None", any whitespace string is a separator.  Except for splitting
   from the right, "rsplit()" behaves like "split()" which is
   described in detail below.

str.rstrip([chars])

   Return a copy of the string with trailing characters removed.  The
   *chars* argument is a string specifying the set of characters to be
   removed.  If omitted or "None", the *chars* argument defaults to
   removing whitespace.  The *chars* argument is not a suffix; rather,
   all combinations of its values are stripped:

      >>> '   spacious   '.rstrip()
      '   spacious'
      >>> 'mississippi'.rstrip('ipz')
      'mississ'

   See "str.removesuffix()" for a method that will remove a single
   suffix string rather than all of a set of characters.  For example:

      >>> 'Monty Python'.rstrip(' Python')
      'M'
      >>> 'Monty Python'.removesuffix(' Python')
      'Monty'

str.split(sep=None, maxsplit=-1)

   Return a list of the words in the string, using *sep* as the
   delimiter string.  If *maxsplit* is given, at most *maxsplit*
   splits are done (thus, the list will have at most "maxsplit+1"
   elements).  If *maxsplit* is not specified or "-1", then there is
   no limit on the number of splits (all possible splits are made).

   If *sep* is given, consecutive delimiters are not grouped together
   and are deemed to delimit empty strings (for example,
   "'1,,2'.split(',')" returns "['1', '', '2']").  The *sep* argument
   may consist of multiple characters as a single delimiter (to split
   with multiple delimiters, use "re.split()"). Splitting an empty
   string with a specified separator returns "['']".

   For example:

      >>> '1,2,3'.split(',')
      ['1', '2', '3']
      >>> '1,2,3'.split(',', maxsplit=1)
      ['1', '2,3']
      >>> '1,2,,3,'.split(',')
      ['1', '2', '', '3', '']
      >>> '1<>2<>3<4'.split('<>')
      ['1', '2', '3<4']

   If *sep* is not specified or is "None", a different splitting
   algorithm is applied: runs of consecutive whitespace are regarded
   as a single separator, and the result will contain no empty strings
   at the start or end if the string has leading or trailing
   whitespace.  Consequently, splitting an empty string or a string
   consisting of just whitespace with a "None" separator returns "[]".

   For example:

      >>> '1 2 3'.split()
      ['1', '2', '3']
      >>> '1 2 3'.split(maxsplit=1)
      ['1', '2 3']
      >>> '   1   2   3   '.split()
      ['1', '2', '3']

str.splitlines(keepends=False)

   Return a list of the lines in the string, breaking at line
   boundaries.  Line breaks are not included in the resulting list
   unless *keepends* is given and true.

   This method splits on the following line boundaries.  In
   particular, the boundaries are a superset of *universal newlines*.

   +-------------------------+-------------------------------+
   | Representation          | Description                   |
   |=========================|===============================|
   | "\n"                    | Line Feed                     |
   +-------------------------+-------------------------------+
   | "\r"                    | Carriage Return               |
   +-------------------------+-------------------------------+
   | "\r\n"                  | Carriage Return + Line Feed   |
   +-------------------------+-------------------------------+
   | "\v" or "\x0b"          | Line Tabulation               |
   +-------------------------+-------------------------------+
   | "\f" or "\x0c"          | Form Feed                     |
   +-------------------------+-------------------------------+
   | "\x1c"                  | File Separator                |
   +-------------------------+-------------------------------+
   | "\x1d"                  | Group Separator               |
   +-------------------------+-------------------------------+
   | "\x1e"                  | Record Separator              |
   +-------------------------+-------------------------------+
   | "\x85"                  | Next Line (C1 Control Code)   |
   +-------------------------+-------------------------------+
   | "\u2028"                | Line Separator                |
   +-------------------------+-------------------------------+
   | "\u2029"                | Paragraph Separator           |
   +-------------------------+-------------------------------+

   Changed in version 3.2: "\v" and "\f" added to list of line
   boundaries.

   For example:

      >>> 'ab c\n\nde fg\rkl\r\n'.splitlines()
      ['ab c', '', 'de fg', 'kl']
      >>> 'ab c\n\nde fg\rkl\r\n'.splitlines(keepends=True)
      ['ab c\n', '\n', 'de fg\r', 'kl\r\n']

   Unlike "split()" when a delimiter string *sep* is given, this
   method returns an empty list for the empty string, and a terminal
   line break does not result in an extra line:

      >>> "".splitlines()
      []
      >>> "One line\n".splitlines()
      ['One line']

   For comparison, "split('\n')" gives:

      >>> ''.split('\n')
      ['']
      >>> 'Two lines\n'.split('\n')
      ['Two lines', '']

str.startswith(prefix[, start[, end]])

   Return "True" if string starts with the *prefix*, otherwise return
   "False". *prefix* can also be a tuple of prefixes to look for.
   With optional *start*, test string beginning at that position.
   With optional *end*, stop comparing string at that position.

str.strip([chars])

   Return a copy of the string with the leading and trailing
   characters removed. The *chars* argument is a string specifying the
   set of characters to be removed. If omitted or "None", the *chars*
   argument defaults to removing whitespace. The *chars* argument is
   not a prefix or suffix; rather, all combinations of its values are
   stripped:

      >>> '   spacious   '.strip()
      'spacious'
      >>> 'www.example.com'.strip('cmowz.')
      'example'

   The outermost leading and trailing *chars* argument values are
   stripped from the string. Characters are removed from the leading
   end until reaching a string character that is not contained in the
   set of characters in *chars*. A similar action takes place on the
   trailing end. For example:

      >>> comment_string = '#....... Section 3.2.1 Issue #32 .......'
      >>> comment_string.strip('.#! ')
      'Section 3.2.1 Issue #32'

str.swapcase()

   Return a copy of the string with uppercase characters converted to
   lowercase and vice versa. Note that it is not necessarily true that
   "s.swapcase().swapcase() == s".

str.title()

   Return a titlecased version of the string where words start with an
   uppercase character and the remaining characters are lowercase.

   For example:

      >>> 'Hello world'.title()
      'Hello World'

   The algorithm uses a simple language-independent definition of a
   word as groups of consecutive letters.  The definition works in
   many contexts but it means that apostrophes in contractions and
   possessives form word boundaries, which may not be the desired
   result:

      >>> "they're bill's friends from the UK".title()
      "They'Re Bill'S Friends From The Uk"

   The "string.capwords()" function does not have this problem, as it
   splits words on spaces only.

   Alternatively, a workaround for apostrophes can be constructed
   using regular expressions:

      >>> import re
      >>> def titlecase(s):
      ...     return re.sub(r"[A-Za-z]+('[A-Za-z]+)?",
      ...                   lambda mo: mo.group(0).capitalize(),
      ...                   s)
      ...
      >>> titlecase("they're bill's friends.")
      "They're Bill's Friends."

str.translate(table)

   Return a copy of the string in which each character has been mapped
   through the given translation table.  The table must be an object
   that implements indexing via "__getitem__()", typically a *mapping*
   or *sequence*.  When indexed by a Unicode ordinal (an integer), the
   table object can do any of the following: return a Unicode ordinal
   or a string, to map the character to one or more other characters;
   return "None", to delete the character from the return string; or
   raise a "LookupError" exception, to map the character to itself.

   You can use "str.maketrans()" to create a translation map from
   character-to-character mappings in different formats.

   See also the "codecs" module for a more flexible approach to custom
   character mappings.

str.upper()

   Return a copy of the string with all the cased characters [4]
   converted to uppercase.  Note that "s.upper().isupper()" might be
   "False" if "s" contains uncased characters or if the Unicode
   category of the resulting character(s) is not “Lu” (Letter,
   uppercase), but e.g. “Lt” (Letter, titlecase).

   The uppercasing algorithm used is described in section 3.13
   ‘Default Case Folding’ of the Unicode Standard.

str.zfill(width)

   Return a copy of the string left filled with ASCII "'0'" digits to
   make a string of length *width*. A leading sign prefix
   ("'+'"/"'-'") is handled by inserting the padding *after* the sign
   character rather than before. The original string is returned if
   *width* is less than or equal to "len(s)".

   For example:

      >>> "42".zfill(5)
      '00042'
      >>> "-42".zfill(5)
      '-0042'
''',
    'strings': '''String and Bytes literals
*************************

String literals are described by the following lexical definitions:

   stringliteral   ::= [stringprefix](shortstring | longstring)
   stringprefix    ::= "r" | "u" | "R" | "U" | "f" | "F"
                       | "fr" | "Fr" | "fR" | "FR" | "rf" | "rF" | "Rf" | "RF"
   shortstring     ::= "'" shortstringitem* "'" | '"' shortstringitem* '"'
   longstring      ::= "\'\'\'" longstringitem* "\'\'\'" | '"""' longstringitem* '"""'
   shortstringitem ::= shortstringchar | stringescapeseq
   longstringitem  ::= longstringchar | stringescapeseq
   shortstringchar ::= <any source character except "\\" or newline or the quote>
   longstringchar  ::= <any source character except "\\">
   stringescapeseq ::= "\\" <any source character>

   bytesliteral   ::= bytesprefix(shortbytes | longbytes)
   bytesprefix    ::= "b" | "B" | "br" | "Br" | "bR" | "BR" | "rb" | "rB" | "Rb" | "RB"
   shortbytes     ::= "'" shortbytesitem* "'" | '"' shortbytesitem* '"'
   longbytes      ::= "\'\'\'" longbytesitem* "\'\'\'" | '"""' longbytesitem* '"""'
   shortbytesitem ::= shortbyteschar | bytesescapeseq
   longbytesitem  ::= longbyteschar | bytesescapeseq
   shortbyteschar ::= <any ASCII character except "\\" or newline or the quote>
   longbyteschar  ::= <any ASCII character except "\\">
   bytesescapeseq ::= "\\" <any ASCII character>

One syntactic restriction not indicated by these productions is that
whitespace is not allowed between the "stringprefix" or "bytesprefix"
and the rest of the literal. The source character set is defined by
the encoding declaration; it is UTF-8 if no encoding declaration is
given in the source file; see section Encoding declarations.

In plain English: Both types of literals can be enclosed in matching
single quotes ("'") or double quotes (""").  They can also be enclosed
in matching groups of three single or double quotes (these are
generally referred to as *triple-quoted strings*). The backslash ("\\")
character is used to give special meaning to otherwise ordinary
characters like "n", which means ‘newline’ when escaped ("\\n"). It can
also be used to escape characters that otherwise have a special
meaning, such as newline, backslash itself, or the quote character.
See escape sequences below for examples.

Bytes literals are always prefixed with "'b'" or "'B'"; they produce
an instance of the "bytes" type instead of the "str" type.  They may
only contain ASCII characters; bytes with a numeric value of 128 or
greater must be expressed with escapes.

Both string and bytes literals may optionally be prefixed with a
letter "'r'" or "'R'"; such constructs are called *raw string
literals* and *raw bytes literals* respectively and treat backslashes
as literal characters.  As a result, in raw string literals, "'\\U'"
and "'\\u'" escapes are not treated specially.

Added in version 3.3: The "'rb'" prefix of raw bytes literals has been
added as a synonym of "'br'".Support for the unicode legacy literal
("u'value'") was reintroduced to simplify the maintenance of dual
Python 2.x and 3.x codebases. See **PEP 414** for more information.

A string literal with "'f'" or "'F'" in its prefix is a *formatted
string literal*; see f-strings.  The "'f'" may be combined with "'r'",
but not with "'b'" or "'u'", therefore raw formatted strings are
possible, but formatted bytes literals are not.

In triple-quoted literals, unescaped newlines and quotes are allowed
(and are retained), except that three unescaped quotes in a row
terminate the literal.  (A “quote” is the character used to open the
literal, i.e. either "'" or """.)


Escape sequences
================

Unless an "'r'" or "'R'" prefix is present, escape sequences in string
and bytes literals are interpreted according to rules similar to those
used by Standard C.  The recognized escape sequences are:

+---------------------------+-----------------------------------+---------+
| Escape Sequence           | Meaning                           | Notes   |
|===========================|===================================|=========|
| "\\"<newline>              | Backslash and newline ignored     | (1)     |
+---------------------------+-----------------------------------+---------+
| "\\\\"                      | Backslash ("\\")                   |         |
+---------------------------+-----------------------------------+---------+
| "\\'"                      | Single quote ("'")                |         |
+---------------------------+-----------------------------------+---------+
| "\\""                      | Double quote (""")                |         |
+---------------------------+-----------------------------------+---------+
| "\\a"                      | ASCII Bell (BEL)                  |         |
+---------------------------+-----------------------------------+---------+
| "\\b"                      | ASCII Backspace (BS)              |         |
+---------------------------+-----------------------------------+---------+
| "\\f"                      | ASCII Formfeed (FF)               |         |
+---------------------------+-----------------------------------+---------+
| "\\n"                      | ASCII Linefeed (LF)               |         |
+---------------------------+-----------------------------------+---------+
| "\\r"                      | ASCII Carriage Return (CR)        |         |
+---------------------------+-----------------------------------+---------+
| "\\t"                      | ASCII Horizontal Tab (TAB)        |         |
+---------------------------+-----------------------------------+---------+
| "\\v"                      | ASCII Vertical Tab (VT)           |         |
+---------------------------+-----------------------------------+---------+
| "\\*ooo*"                  | Character with octal value *ooo*  | (2,4)   |
+---------------------------+-----------------------------------+---------+
| "\\x*hh*"                  | Character with hex value *hh*     | (3,4)   |
+---------------------------+-----------------------------------+---------+

Escape sequences only recognized in string literals are:

+---------------------------+-----------------------------------+---------+
| Escape Sequence           | Meaning                           | Notes   |
|===========================|===================================|=========|
| "\\N{*name*}"              | Character named *name* in the     | (5)     |
|                           | Unicode database                  |         |
+---------------------------+-----------------------------------+---------+
| "\\u*xxxx*"                | Character with 16-bit hex value   | (6)     |
|                           | *xxxx*                            |         |
+---------------------------+-----------------------------------+---------+
| "\\U*xxxxxxxx*"            | Character with 32-bit hex value   | (7)     |
|                           | *xxxxxxxx*                        |         |
+---------------------------+-----------------------------------+---------+

Notes:

1. A backslash can be added at the end of a line to ignore the
   newline:

      >>> 'This string will not include \\
      ... backslashes or newline characters.'
      'This string will not include backslashes or newline characters.'

   The same result can be achieved using triple-quoted strings, or
   parentheses and string literal concatenation.

2. As in Standard C, up to three octal digits are accepted.

   Changed in version 3.11: Octal escapes with value larger than
   "0o377" produce a "DeprecationWarning".

   Changed in version 3.12: Octal escapes with value larger than
   "0o377" produce a "SyntaxWarning". In a future Python version they
   will be eventually a "SyntaxError".

3. Unlike in Standard C, exactly two hex digits are required.

4. In a bytes literal, hexadecimal and octal escapes denote the byte
   with the given value. In a string literal, these escapes denote a
   Unicode character with the given value.

5. Changed in version 3.3: Support for name aliases [1] has been
   added.

6. Exactly four hex digits are required.

7. Any Unicode character can be encoded this way.  Exactly eight hex
   digits are required.

Unlike Standard C, all unrecognized escape sequences are left in the
string unchanged, i.e., *the backslash is left in the result*.  (This
behavior is useful when debugging: if an escape sequence is mistyped,
the resulting output is more easily recognized as broken.)  It is also
important to note that the escape sequences only recognized in string
literals fall into the category of unrecognized escapes for bytes
literals.

Changed in version 3.6: Unrecognized escape sequences produce a
"DeprecationWarning".

Changed in version 3.12: Unrecognized escape sequences produce a
"SyntaxWarning". In a future Python version they will be eventually a
"SyntaxError".

Even in a raw literal, quotes can be escaped with a backslash, but the
backslash remains in the result; for example, "r"\\""" is a valid
string literal consisting of two characters: a backslash and a double
quote; "r"\\"" is not a valid string literal (even a raw string cannot
end in an odd number of backslashes).  Specifically, *a raw literal
cannot end in a single backslash* (since the backslash would escape
the following quote character).  Note also that a single backslash
followed by a newline is interpreted as those two characters as part
of the literal, *not* as a line continuation.
''',
    'subscriptions': r'''Subscriptions
*************

The subscription of an instance of a container class will generally
select an element from the container. The subscription of a *generic
class* will generally return a GenericAlias object.

   subscription ::= primary "[" flexible_expression_list "]"

When an object is subscripted, the interpreter will evaluate the
primary and the expression list.

The primary must evaluate to an object that supports subscription. An
object may support subscription through defining one or both of
"__getitem__()" and "__class_getitem__()". When the primary is
subscripted, the evaluated result of the expression list will be
passed to one of these methods. For more details on when
"__class_getitem__" is called instead of "__getitem__", see
__class_getitem__ versus __getitem__.

If the expression list contains at least one comma, or if any of the
expressions are starred, the expression list will evaluate to a
"tuple" containing the items of the expression list. Otherwise, the
expression list will evaluate to the value of the list’s sole member.

Changed in version 3.11: Expressions in an expression list may be
starred. See **PEP 646**.

For built-in objects, there are two types of objects that support
subscription via "__getitem__()":

1. Mappings. If the primary is a *mapping*, the expression list must
   evaluate to an object whose value is one of the keys of the
   mapping, and the subscription selects the value in the mapping that
   corresponds to that key. An example of a builtin mapping class is
   the "dict" class.

2. Sequences. If the primary is a *sequence*, the expression list must
   evaluate to an "int" or a "slice" (as discussed in the following
   section). Examples of builtin sequence classes include the "str",
   "list" and "tuple" classes.

The formal syntax makes no special provision for negative indices in
*sequences*. However, built-in sequences all provide a "__getitem__()"
method that interprets negative indices by adding the length of the
sequence to the index so that, for example, "x[-1]" selects the last
item of "x". The resulting value must be a nonnegative integer less
than the number of items in the sequence, and the subscription selects
the item whose index is that value (counting from zero). Since the
support for negative indices and slicing occurs in the object’s
"__getitem__()" method, subclasses overriding this method will need to
explicitly add that support.

A "string" is a special kind of sequence whose items are *characters*.
A character is not a separate data type but a string of exactly one
character.
''',
    'truth': r'''Truth Value Testing
*******************

Any object can be tested for truth value, for use in an "if" or
"while" condition or as operand of the Boolean operations below.

By default, an object is considered true unless its class defines
either a "__bool__()" method that returns "False" or a "__len__()"
method that returns zero, when called with the object. [1]  Here are
most of the built-in objects considered false:

* constants defined to be false: "None" and "False"

* zero of any numeric type: "0", "0.0", "0j", "Decimal(0)",
  "Fraction(0, 1)"

* empty sequences and collections: "''", "()", "[]", "{}", "set()",
  "range(0)"

Operations and built-in functions that have a Boolean result always
return "0" or "False" for false and "1" or "True" for true, unless
otherwise stated. (Important exception: the Boolean operations "or"
and "and" always return one of their operands.)
''',
    'try': r'''The "try" statement
*******************

The "try" statement specifies exception handlers and/or cleanup code
for a group of statements:

   try_stmt  ::= try1_stmt | try2_stmt | try3_stmt
   try1_stmt ::= "try" ":" suite
                 ("except" [expression ["as" identifier]] ":" suite)+
                 ["else" ":" suite]
                 ["finally" ":" suite]
   try2_stmt ::= "try" ":" suite
                 ("except" "*" expression ["as" identifier] ":" suite)+
                 ["else" ":" suite]
                 ["finally" ":" suite]
   try3_stmt ::= "try" ":" suite
                 "finally" ":" suite

Additional information on exceptions can be found in section
Exceptions, and information on using the "raise" statement to generate
exceptions may be found in section The raise statement.


"except" clause
===============

The "except" clause(s) specify one or more exception handlers. When no
exception occurs in the "try" clause, no exception handler is
executed. When an exception occurs in the "try" suite, a search for an
exception handler is started. This search inspects the "except"
clauses in turn until one is found that matches the exception. An
expression-less "except" clause, if present, must be last; it matches
any exception.

For an "except" clause with an expression, the expression must
evaluate to an exception type or a tuple of exception types. The
raised exception matches an "except" clause whose expression evaluates
to the class or a *non-virtual base class* of the exception object, or
to a tuple that contains such a class.

If no "except" clause matches the exception, the search for an
exception handler continues in the surrounding code and on the
invocation stack.  [1]

If the evaluation of an expression in the header of an "except" clause
raises an exception, the original search for a handler is canceled and
a search starts for the new exception in the surrounding code and on
the call stack (it is treated as if the entire "try" statement raised
the exception).

When a matching "except" clause is found, the exception is assigned to
the target specified after the "as" keyword in that "except" clause,
if present, and the "except" clause’s suite is executed. All "except"
clauses must have an executable block. When the end of this block is
reached, execution continues normally after the entire "try"
statement. (This means that if two nested handlers exist for the same
exception, and the exception occurs in the "try" clause of the inner
handler, the outer handler will not handle the exception.)

When an exception has been assigned using "as target", it is cleared
at the end of the "except" clause.  This is as if

   except E as N:
       foo

was translated to

   except E as N:
       try:
           foo
       finally:
           del N

This means the exception must be assigned to a different name to be
able to refer to it after the "except" clause. Exceptions are cleared
because with the traceback attached to them, they form a reference
cycle with the stack frame, keeping all locals in that frame alive
until the next garbage collection occurs.

Before an "except" clause’s suite is executed, the exception is stored
in the "sys" module, where it can be accessed from within the body of
the "except" clause by calling "sys.exception()". When leaving an
exception handler, the exception stored in the "sys" module is reset
to its previous value:

   >>> print(sys.exception())
   None
   >>> try:
   ...     raise TypeError
   ... except:
   ...     print(repr(sys.exception()))
   ...     try:
   ...          raise ValueError
   ...     except:
   ...         print(repr(sys.exception()))
   ...     print(repr(sys.exception()))
   ...
   TypeError()
   ValueError()
   TypeError()
   >>> print(sys.exception())
   None


"except*" clause
================

The "except*" clause(s) are used for handling "ExceptionGroup"s. The
exception type for matching is interpreted as in the case of "except",
but in the case of exception groups we can have partial matches when
the type matches some of the exceptions in the group. This means that
multiple "except*" clauses can execute, each handling part of the
exception group. Each clause executes at most once and handles an
exception group of all matching exceptions.  Each exception in the
group is handled by at most one "except*" clause, the first that
matches it.

   >>> try:
   ...     raise ExceptionGroup("eg",
   ...         [ValueError(1), TypeError(2), OSError(3), OSError(4)])
   ... except* TypeError as e:
   ...     print(f'caught {type(e)} with nested {e.exceptions}')
   ... except* OSError as e:
   ...     print(f'caught {type(e)} with nested {e.exceptions}')
   ...
   caught <class 'ExceptionGroup'> with nested (TypeError(2),)
   caught <class 'ExceptionGroup'> with nested (OSError(3), OSError(4))
     + Exception Group Traceback (most recent call last):
     |   File "<stdin>", line 2, in <module>
     | ExceptionGroup: eg
     +-+---------------- 1 ----------------
       | ValueError: 1
       +------------------------------------

Any remaining exceptions that were not handled by any "except*" clause
are re-raised at the end, along with all exceptions that were raised
from within the "except*" clauses. If this list contains more than one
exception to reraise, they are combined into an exception group.

If the raised exception is not an exception group and its type matches
one of the "except*" clauses, it is caught and wrapped by an exception
group with an empty message string.

   >>> try:
   ...     raise BlockingIOError
   ... except* BlockingIOError as e:
   ...     print(repr(e))
   ...
   ExceptionGroup('', (BlockingIOError()))

An "except*" clause must have a matching expression; it cannot be
"except*:". Furthermore, this expression cannot contain exception
group types, because that would have ambiguous semantics.

It is not possible to mix "except" and "except*" in the same "try".
"break", "continue" and "return" cannot appear in an "except*" clause.


"else" clause
=============

The optional "else" clause is executed if the control flow leaves the
"try" suite, no exception was raised, and no "return", "continue", or
"break" statement was executed.  Exceptions in the "else" clause are
not handled by the preceding "except" clauses.


"finally" clause
================

If "finally" is present, it specifies a ‘cleanup’ handler.  The "try"
clause is executed, including any "except" and "else" clauses.  If an
exception occurs in any of the clauses and is not handled, the
exception is temporarily saved. The "finally" clause is executed.  If
there is a saved exception it is re-raised at the end of the "finally"
clause.  If the "finally" clause raises another exception, the saved
exception is set as the context of the new exception. If the "finally"
clause executes a "return", "break" or "continue" statement, the saved
exception is discarded:

   >>> def f():
   ...     try:
   ...         1/0
   ...     finally:
   ...         return 42
   ...
   >>> f()
   42

The exception information is not available to the program during
execution of the "finally" clause.

When a "return", "break" or "continue" statement is executed in the
"try" suite of a "try"…"finally" statement, the "finally" clause is
also executed ‘on the way out.’

The return value of a function is determined by the last "return"
statement executed.  Since the "finally" clause always executes, a
"return" statement executed in the "finally" clause will always be the
last one executed:

   >>> def foo():
   ...     try:
   ...         return 'try'
   ...     finally:
   ...         return 'finally'
   ...
   >>> foo()
   'finally'

Changed in version 3.8: Prior to Python 3.8, a "continue" statement
was illegal in the "finally" clause due to a problem with the
implementation.
''',
    'types': r'''The standard type hierarchy
***************************

Below is a list of the types that are built into Python.  Extension
modules (written in C, Java, or other languages, depending on the
implementation) can define additional types.  Future versions of
Python may add types to the type hierarchy (e.g., rational numbers,
efficiently stored arrays of integers, etc.), although such additions
will often be provided via the standard library instead.

Some of the type descriptions below contain a paragraph listing
‘special attributes.’  These are attributes that provide access to the
implementation and are not intended for general use.  Their definition
may change in the future.


None
====

This type has a single value.  There is a single object with this
value. This object is accessed through the built-in name "None". It is
used to signify the absence of a value in many situations, e.g., it is
returned from functions that don’t explicitly return anything. Its
truth value is false.


NotImplemented
==============

This type has a single value.  There is a single object with this
value. This object is accessed through the built-in name
"NotImplemented". Numeric methods and rich comparison methods should
return this value if they do not implement the operation for the
operands provided.  (The interpreter will then try the reflected
operation, or some other fallback, depending on the operator.)  It
should not be evaluated in a boolean context.

See Implementing the arithmetic operations for more details.

Changed in version 3.9: Evaluating "NotImplemented" in a boolean
context is deprecated. While it currently evaluates as true, it will
emit a "DeprecationWarning". It will raise a "TypeError" in a future
version of Python.


Ellipsis
========

This type has a single value.  There is a single object with this
value. This object is accessed through the literal "..." or the built-
in name "Ellipsis".  Its truth value is true.


"numbers.Number"
================

These are created by numeric literals and returned as results by
arithmetic operators and arithmetic built-in functions.  Numeric
objects are immutable; once created their value never changes.  Python
numbers are of course strongly related to mathematical numbers, but
subject to the limitations of numerical representation in computers.

The string representations of the numeric classes, computed by
"__repr__()" and "__str__()", have the following properties:

* They are valid numeric literals which, when passed to their class
  constructor, produce an object having the value of the original
  numeric.

* The representation is in base 10, when possible.

* Leading zeros, possibly excepting a single zero before a decimal
  point, are not shown.

* Trailing zeros, possibly excepting a single zero after a decimal
  point, are not shown.

* A sign is shown only when the number is negative.

Python distinguishes between integers, floating-point numbers, and
complex numbers:


"numbers.Integral"
------------------

These represent elements from the mathematical set of integers
(positive and negative).

Note:

  The rules for integer representation are intended to give the most
  meaningful interpretation of shift and mask operations involving
  negative integers.

There are two types of integers:

Integers ("int")
   These represent numbers in an unlimited range, subject to available
   (virtual) memory only.  For the purpose of shift and mask
   operations, a binary representation is assumed, and negative
   numbers are represented in a variant of 2’s complement which gives
   the illusion of an infinite string of sign bits extending to the
   left.

Booleans ("bool")
   These represent the truth values False and True.  The two objects
   representing the values "False" and "True" are the only Boolean
   objects. The Boolean type is a subtype of the integer type, and
   Boolean values behave like the values 0 and 1, respectively, in
   almost all contexts, the exception being that when converted to a
   string, the strings ""False"" or ""True"" are returned,
   respectively.


"numbers.Real" ("float")
------------------------

These represent machine-level double precision floating-point numbers.
You are at the mercy of the underlying machine architecture (and C or
Java implementation) for the accepted range and handling of overflow.
Python does not support single-precision floating-point numbers; the
savings in processor and memory usage that are usually the reason for
using these are dwarfed by the overhead of using objects in Python, so
there is no reason to complicate the language with two kinds of
floating-point numbers.


"numbers.Complex" ("complex")
-----------------------------

These represent complex numbers as a pair of machine-level double
precision floating-point numbers.  The same caveats apply as for
floating-point numbers. The real and imaginary parts of a complex
number "z" can be retrieved through the read-only attributes "z.real"
and "z.imag".


Sequences
=========

These represent finite ordered sets indexed by non-negative numbers.
The built-in function "len()" returns the number of items of a
sequence. When the length of a sequence is *n*, the index set contains
the numbers 0, 1, …, *n*-1.  Item *i* of sequence *a* is selected by
"a[i]". Some sequences, including built-in sequences, interpret
negative subscripts by adding the sequence length. For example,
"a[-2]" equals "a[n-2]", the second to last item of sequence a with
length "n".

Sequences also support slicing: "a[i:j]" selects all items with index
*k* such that *i* "<=" *k* "<" *j*.  When used as an expression, a
slice is a sequence of the same type. The comment above about negative
indexes also applies to negative slice positions.

Some sequences also support “extended slicing” with a third “step”
parameter: "a[i:j:k]" selects all items of *a* with index *x* where "x
= i + n*k", *n* ">=" "0" and *i* "<=" *x* "<" *j*.

Sequences are distinguished according to their mutability:


Immutable sequences
-------------------

An object of an immutable sequence type cannot change once it is
created.  (If the object contains references to other objects, these
other objects may be mutable and may be changed; however, the
collection of objects directly referenced by an immutable object
cannot change.)

The following types are immutable sequences:

Strings
   A string is a sequence of values that represent Unicode code
   points. All the code points in the range "U+0000 - U+10FFFF" can be
   represented in a string.  Python doesn’t have a char type; instead,
   every code point in the string is represented as a string object
   with length "1".  The built-in function "ord()" converts a code
   point from its string form to an integer in the range "0 - 10FFFF";
   "chr()" converts an integer in the range "0 - 10FFFF" to the
   corresponding length "1" string object. "str.encode()" can be used
   to convert a "str" to "bytes" using the given text encoding, and
   "bytes.decode()" can be used to achieve the opposite.

Tuples
   The items of a tuple are arbitrary Python objects. Tuples of two or
   more items are formed by comma-separated lists of expressions.  A
   tuple of one item (a ‘singleton’) can be formed by affixing a comma
   to an expression (an expression by itself does not create a tuple,
   since parentheses must be usable for grouping of expressions).  An
   empty tuple can be formed by an empty pair of parentheses.

Bytes
   A bytes object is an immutable array.  The items are 8-bit bytes,
   represented by integers in the range 0 <= x < 256.  Bytes literals
   (like "b'abc'") and the built-in "bytes()" constructor can be used
   to create bytes objects.  Also, bytes objects can be decoded to
   strings via the "decode()" method.


Mutable sequences
-----------------

Mutable sequences can be changed after they are created.  The
subscription and slicing notations can be used as the target of
assignment and "del" (delete) statements.

Note:

  The "collections" and "array" module provide additional examples of
  mutable sequence types.

There are currently two intrinsic mutable sequence types:

Lists
   The items of a list are arbitrary Python objects.  Lists are formed
   by placing a comma-separated list of expressions in square
   brackets. (Note that there are no special cases needed to form
   lists of length 0 or 1.)

Byte Arrays
   A bytearray object is a mutable array. They are created by the
   built-in "bytearray()" constructor.  Aside from being mutable (and
   hence unhashable), byte arrays otherwise provide the same interface
   and functionality as immutable "bytes" objects.


Set types
=========

These represent unordered, finite sets of unique, immutable objects.
As such, they cannot be indexed by any subscript. However, they can be
iterated over, and the built-in function "len()" returns the number of
items in a set. Common uses for sets are fast membership testing,
removing duplicates from a sequence, and computing mathematical
operations such as intersection, union, difference, and symmetric
difference.

For set elements, the same immutability rules apply as for dictionary
keys. Note that numeric types obey the normal rules for numeric
comparison: if two numbers compare equal (e.g., "1" and "1.0"), only
one of them can be contained in a set.

There are currently two intrinsic set types:

Sets
   These represent a mutable set. They are created by the built-in
   "set()" constructor and can be modified afterwards by several
   methods, such as "add()".

Frozen sets
   These represent an immutable set.  They are created by the built-in
   "frozenset()" constructor.  As a frozenset is immutable and
   *hashable*, it can be used again as an element of another set, or
   as a dictionary key.


Mappings
========

These represent finite sets of objects indexed by arbitrary index
sets. The subscript notation "a[k]" selects the item indexed by "k"
from the mapping "a"; this can be used in expressions and as the
target of assignments or "del" statements. The built-in function
"len()" returns the number of items in a mapping.

There is currently a single intrinsic mapping type:


Dictionaries
------------

These represent finite sets of objects indexed by nearly arbitrary
values.  The only types of values not acceptable as keys are values
containing lists or dictionaries or other mutable types that are
compared by value rather than by object identity, the reason being
that the efficient implementation of dictionaries requires a key’s
hash value to remain constant. Numeric types used for keys obey the
normal rules for numeric comparison: if two numbers compare equal
(e.g., "1" and "1.0") then they can be used interchangeably to index
the same dictionary entry.

Dictionaries preserve insertion order, meaning that keys will be
produced in the same order they were added sequentially over the
dictionary. Replacing an existing key does not change the order,
however removing a key and re-inserting it will add it to the end
instead of keeping its old place.

Dictionaries are mutable; they can be created by the "{}" notation
(see section Dictionary displays).

The extension modules "dbm.ndbm" and "dbm.gnu" provide additional
examples of mapping types, as does the "collections" module.

Changed in version 3.7: Dictionaries did not preserve insertion order
in versions of Python before 3.6. In CPython 3.6, insertion order was
preserved, but it was considered an implementation detail at that time
rather than a language guarantee.


Callable types
==============

These are the types to which the function call operation (see section
Calls) can be applied:


User-defined functions
----------------------

A user-defined function object is created by a function definition
(see section Function definitions).  It should be called with an
argument list containing the same number of items as the function’s
formal parameter list.


Special read-only attributes
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

+----------------------------------------------------+----------------------------------------------------+
| Attribute                                          | Meaning                                            |
|====================================================|====================================================|
| function.__globals__                               | A reference to the "dictionary" that holds the     |
|                                                    | function’s global variables – the global namespace |
|                                                    | of the module in which the function was defined.   |
+----------------------------------------------------+----------------------------------------------------+
| function.__closure__                               | "None" or a "tuple" of cells that contain bindings |
|                                                    | for the function’s free variables.  A cell object  |
|                                                    | has the attribute "cell_contents". This can be     |
|                                                    | used to get the value of the cell, as well as set  |
|                                                    | the value.                                         |
+----------------------------------------------------+----------------------------------------------------+


Special writable attributes
~~~~~~~~~~~~~~~~~~~~~~~~~~~

Most of these attributes check the type of the assigned value:

+----------------------------------------------------+----------------------------------------------------+
| Attribute                                          | Meaning                                            |
|====================================================|====================================================|
| function.__doc__                                   | The function’s documentation string, or "None" if  |
|                                                    | unavailable.                                       |
+----------------------------------------------------+----------------------------------------------------+
| function.__name__                                  | The function’s name. See also: "__name__           |
|                                                    | attributes".                                       |
+----------------------------------------------------+----------------------------------------------------+
| function.__qualname__                              | The function’s *qualified name*. See also:         |
|                                                    | "__qualname__ attributes".  Added in version 3.3.  |
+----------------------------------------------------+----------------------------------------------------+
| function.__module__                                | The name of the module the function was defined    |
|                                                    | in, or "None" if unavailable.                      |
+----------------------------------------------------+----------------------------------------------------+
| function.__defaults__                              | A "tuple" containing default *parameter* values    |
|                                                    | for those parameters that have defaults, or "None" |
|                                                    | if no parameters have a default value.             |
+----------------------------------------------------+----------------------------------------------------+
| function.__code__                                  | The code object representing the compiled function |
|                                                    | body.                                              |
+----------------------------------------------------+----------------------------------------------------+
| function.__dict__                                  | The namespace supporting arbitrary function        |
|                                                    | attributes. See also: "__dict__ attributes".       |
+----------------------------------------------------+----------------------------------------------------+
| function.__annotations__                           | A "dictionary" containing annotations of           |
|                                                    | *parameters*. The keys of the dictionary are the   |
|                                                    | parameter names, and "'return'" for the return     |
|                                                    | annotation, if provided. See also: Annotations     |
|                                                    | Best Practices.                                    |
+----------------------------------------------------+----------------------------------------------------+
| function.__kwdefaults__                            | A "dictionary" containing defaults for keyword-    |
|                                                    | only *parameters*.                                 |
+----------------------------------------------------+----------------------------------------------------+
| function.__type_params__                           | A "tuple" containing the type parameters of a      |
|                                                    | generic function.  Added in version 3.12.          |
+----------------------------------------------------+----------------------------------------------------+

Function objects also support getting and setting arbitrary
attributes, which can be used, for example, to attach metadata to
functions.  Regular attribute dot-notation is used to get and set such
attributes.

**CPython implementation detail:** CPython’s current implementation
only supports function attributes on user-defined functions. Function
attributes on built-in functions may be supported in the future.

Additional information about a function’s definition can be retrieved
from its code object (accessible via the "__code__" attribute).


Instance methods
----------------

An instance method object combines a class, a class instance and any
callable object (normally a user-defined function).

Special read-only attributes:

+----------------------------------------------------+----------------------------------------------------+
| method.__self__                                    | Refers to the class instance object to which the   |
|                                                    | method is bound                                    |
+----------------------------------------------------+----------------------------------------------------+
| method.__func__                                    | Refers to the original function object             |
+----------------------------------------------------+----------------------------------------------------+
| method.__doc__                                     | The method’s documentation (same as                |
|                                                    | "method.__func__.__doc__"). A "string" if the      |
|                                                    | original function had a docstring, else "None".    |
+----------------------------------------------------+----------------------------------------------------+
| method.__name__                                    | The name of the method (same as                    |
|                                                    | "method.__func__.__name__")                        |
+----------------------------------------------------+----------------------------------------------------+
| method.__module__                                  | The name of the module the method was defined in,  |
|                                                    | or "None" if unavailable.                          |
+----------------------------------------------------+----------------------------------------------------+

Methods also support accessing (but not setting) the arbitrary
function attributes on the underlying function object.

User-defined method objects may be created when getting an attribute
of a class (perhaps via an instance of that class), if that attribute
is a user-defined function object or a "classmethod" object.

When an instance method object is created by retrieving a user-defined
function object from a class via one of its instances, its "__self__"
attribute is the instance, and the method object is said to be
*bound*.  The new method’s "__func__" attribute is the original
function object.

When an instance method object is created by retrieving a
"classmethod" object from a class or instance, its "__self__"
attribute is the class itself, and its "__func__" attribute is the
function object underlying the class method.

When an instance method object is called, the underlying function
("__func__") is called, inserting the class instance ("__self__") in
front of the argument list.  For instance, when "C" is a class which
contains a definition for a function "f()", and "x" is an instance of
"C", calling "x.f(1)" is equivalent to calling "C.f(x, 1)".

When an instance method object is derived from a "classmethod" object,
the “class instance” stored in "__self__" will actually be the class
itself, so that calling either "x.f(1)" or "C.f(1)" is equivalent to
calling "f(C,1)" where "f" is the underlying function.

It is important to note that user-defined functions which are
attributes of a class instance are not converted to bound methods;
this *only* happens when the function is an attribute of the class.


Generator functions
-------------------

A function or method which uses the "yield" statement (see section The
yield statement) is called a *generator function*.  Such a function,
when called, always returns an *iterator* object which can be used to
execute the body of the function:  calling the iterator’s
"iterator.__next__()" method will cause the function to execute until
it provides a value using the "yield" statement.  When the function
executes a "return" statement or falls off the end, a "StopIteration"
exception is raised and the iterator will have reached the end of the
set of values to be returned.


Coroutine functions
-------------------

A function or method which is defined using "async def" is called a
*coroutine function*.  Such a function, when called, returns a
*coroutine* object.  It may contain "await" expressions, as well as
"async with" and "async for" statements. See also the Coroutine
Objects section.


Asynchronous generator functions
--------------------------------

A function or method which is defined using "async def" and which uses
the "yield" statement is called a *asynchronous generator function*.
Such a function, when called, returns an *asynchronous iterator*
object which can be used in an "async for" statement to execute the
body of the function.

Calling the asynchronous iterator’s "aiterator.__anext__" method will
return an *awaitable* which when awaited will execute until it
provides a value using the "yield" expression.  When the function
executes an empty "return" statement or falls off the end, a
"StopAsyncIteration" exception is raised and the asynchronous iterator
will have reached the end of the set of values to be yielded.


Built-in functions
------------------

A built-in function object is a wrapper around a C function.  Examples
of built-in functions are "len()" and "math.sin()" ("math" is a
standard built-in module). The number and type of the arguments are
determined by the C function. Special read-only attributes:

* "__doc__" is the function’s documentation string, or "None" if
  unavailable. See "function.__doc__".

* "__name__" is the function’s name. See "function.__name__".

* "__self__" is set to "None" (but see the next item).

* "__module__" is the name of the module the function was defined in
  or "None" if unavailable. See "function.__module__".


Built-in methods
----------------

This is really a different disguise of a built-in function, this time
containing an object passed to the C function as an implicit extra
argument.  An example of a built-in method is "alist.append()",
assuming *alist* is a list object. In this case, the special read-only
attribute "__self__" is set to the object denoted by *alist*. (The
attribute has the same semantics as it does with "other instance
methods".)


Classes
-------

Classes are callable.  These objects normally act as factories for new
instances of themselves, but variations are possible for class types
that override "__new__()".  The arguments of the call are passed to
"__new__()" and, in the typical case, to "__init__()" to initialize
the new instance.


Class Instances
---------------

Instances of arbitrary classes can be made callable by defining a
"__call__()" method in their class.


Modules
=======

Modules are a basic organizational unit of Python code, and are
created by the import system as invoked either by the "import"
statement, or by calling functions such as "importlib.import_module()"
and built-in "__import__()".  A module object has a namespace
implemented by a "dictionary" object (this is the dictionary
referenced by the "__globals__" attribute of functions defined in the
module).  Attribute references are translated to lookups in this
dictionary, e.g., "m.x" is equivalent to "m.__dict__["x"]". A module
object does not contain the code object used to initialize the module
(since it isn’t needed once the initialization is done).

Attribute assignment updates the module’s namespace dictionary, e.g.,
"m.x = 1" is equivalent to "m.__dict__["x"] = 1".


Import-related attributes on module objects
-------------------------------------------

Module objects have the following attributes that relate to the import
system. When a module is created using the machinery associated with
the import system, these attributes are filled in based on the
module’s *spec*, before the *loader* executes and loads the module.

To create a module dynamically rather than using the import system,
it’s recommended to use "importlib.util.module_from_spec()", which
will set the various import-controlled attributes to appropriate
values. It’s also possible to use the "types.ModuleType" constructor
to create modules directly, but this technique is more error-prone, as
most attributes must be manually set on the module object after it has
been created when using this approach.

Caution:

  With the exception of "__name__", it is **strongly** recommended
  that you rely on "__spec__" and its attributes instead of any of the
  other individual attributes listed in this subsection. Note that
  updating an attribute on "__spec__" will not update the
  corresponding attribute on the module itself:

     >>> import typing
     >>> typing.__name__, typing.__spec__.name
     ('typing', 'typing')
     >>> typing.__spec__.name = 'spelling'
     >>> typing.__name__, typing.__spec__.name
     ('typing', 'spelling')
     >>> typing.__name__ = 'keyboard_smashing'
     >>> typing.__name__, typing.__spec__.name
     ('keyboard_smashing', 'spelling')

module.__name__

   The name used to uniquely identify the module in the import system.
   For a directly executed module, this will be set to ""__main__"".

   This attribute must be set to the fully qualified name of the
   module. It is expected to match the value of
   "module.__spec__.name".

module.__spec__

   A record of the module’s import-system-related state.

   Set to the "module spec" that was used when importing the module.
   See Module specs for more details.

   Added in version 3.4.

module.__package__

   The *package* a module belongs to.

   If the module is top-level (that is, not a part of any specific
   package) then the attribute should be set to "''" (the empty
   string). Otherwise, it should be set to the name of the module’s
   package (which can be equal to "module.__name__" if the module
   itself is a package). See **PEP 366** for further details.

   This attribute is used instead of "__name__" to calculate explicit
   relative imports for main modules. It defaults to "None" for
   modules created dynamically using the "types.ModuleType"
   constructor; use "importlib.util.module_from_spec()" instead to
   ensure the attribute is set to a "str".

   It is **strongly** recommended that you use
   "module.__spec__.parent" instead of "module.__package__".
   "__package__" is now only used as a fallback if "__spec__.parent"
   is not set, and this fallback path is deprecated.

   Changed in version 3.4: This attribute now defaults to "None" for
   modules created dynamically using the "types.ModuleType"
   constructor. Previously the attribute was optional.

   Changed in version 3.6: The value of "__package__" is expected to
   be the same as "__spec__.parent". "__package__" is now only used as
   a fallback during import resolution if "__spec__.parent" is not
   defined.

   Changed in version 3.10: "ImportWarning" is raised if an import
   resolution falls back to "__package__" instead of
   "__spec__.parent".

   Changed in version 3.12: Raise "DeprecationWarning" instead of
   "ImportWarning" when falling back to "__package__" during import
   resolution.

module.__loader__

   The *loader* object that the import machinery used to load the
   module.

   This attribute is mostly useful for introspection, but can be used
   for additional loader-specific functionality, for example getting
   data associated with a loader.

   "__loader__" defaults to "None" for modules created dynamically
   using the "types.ModuleType" constructor; use
   "importlib.util.module_from_spec()" instead to ensure the attribute
   is set to a *loader* object.

   It is **strongly** recommended that you use
   "module.__spec__.loader" instead of "module.__loader__".

   Changed in version 3.4: This attribute now defaults to "None" for
   modules created dynamically using the "types.ModuleType"
   constructor. Previously the attribute was optional.

   Deprecated since version 3.12, will be removed in version 3.16:
   Setting "__loader__" on a module while failing to set
   "__spec__.loader" is deprecated. In Python 3.16, "__loader__" will
   cease to be set or taken into consideration by the import system or
   the standard library.

module.__path__

   A (possibly empty) *sequence* of strings enumerating the locations
   where the package’s submodules will be found. Non-package modules
   should not have a "__path__" attribute. See __path__ attributes on
   modules for more details.

   It is **strongly** recommended that you use
   "module.__spec__.submodule_search_locations" instead of
   "module.__path__".

module.__file__

module.__cached__

   "__file__" and "__cached__" are both optional attributes that may
   or may not be set. Both attributes should be a "str" when they are
   available.

   "__file__" indicates the pathname of the file from which the module
   was loaded (if loaded from a file), or the pathname of the shared
   library file for extension modules loaded dynamically from a shared
   library. It might be missing for certain types of modules, such as
   C modules that are statically linked into the interpreter, and the
   import system may opt to leave it unset if it has no semantic
   meaning (for example, a module loaded from a database).

   If "__file__" is set then the "__cached__" attribute might also be
   set,  which is the path to any compiled version of the code (for
   example, a byte-compiled file). The file does not need to exist to
   set this attribute; the path can simply point to where the compiled
   file *would* exist (see **PEP 3147**).

   Note that "__cached__" may be set even if "__file__" is not set.
   However, that scenario is quite atypical.  Ultimately, the *loader*
   is what makes use of the module spec provided by the *finder* (from
   which "__file__" and "__cached__" are derived).  So if a loader can
   load from a cached module but otherwise does not load from a file,
   that atypical scenario may be appropriate.

   It is **strongly** recommended that you use
   "module.__spec__.cached" instead of "module.__cached__".


Other writable attributes on module objects
-------------------------------------------

As well as the import-related attributes listed above, module objects
also have the following writable attributes:

module.__doc__

   The module’s documentation string, or "None" if unavailable. See
   also: "__doc__ attributes".

module.__annotations__

   A dictionary containing *variable annotations* collected during
   module body execution.  For best practices on working with
   "__annotations__", please see Annotations Best Practices.


Module dictionaries
-------------------

Module objects also have the following special read-only attribute:

module.__dict__

   The module’s namespace as a dictionary object. Uniquely among the
   attributes listed here, "__dict__" cannot be accessed as a global
   variable from within a module; it can only be accessed as an
   attribute on module objects.

   **CPython implementation detail:** Because of the way CPython
   clears module dictionaries, the module dictionary will be cleared
   when the module falls out of scope even if the dictionary still has
   live references.  To avoid this, copy the dictionary or keep the
   module around while using its dictionary directly.


Custom classes
==============

Custom class types are typically created by class definitions (see
section Class definitions).  A class has a namespace implemented by a
dictionary object. Class attribute references are translated to
lookups in this dictionary, e.g., "C.x" is translated to
"C.__dict__["x"]" (although there are a number of hooks which allow
for other means of locating attributes). When the attribute name is
not found there, the attribute search continues in the base classes.
This search of the base classes uses the C3 method resolution order
which behaves correctly even in the presence of ‘diamond’ inheritance
structures where there are multiple inheritance paths leading back to
a common ancestor. Additional details on the C3 MRO used by Python can
be found at The Python 2.3 Method Resolution Order.

When a class attribute reference (for class "C", say) would yield a
class method object, it is transformed into an instance method object
whose "__self__" attribute is "C". When it would yield a
"staticmethod" object, it is transformed into the object wrapped by
the static method object. See section Implementing Descriptors for
another way in which attributes retrieved from a class may differ from
those actually contained in its "__dict__".

Class attribute assignments update the class’s dictionary, never the
dictionary of a base class.

A class object can be called (see above) to yield a class instance
(see below).


Special attributes
------------------

+----------------------------------------------------+----------------------------------------------------+
| Attribute                                          | Meaning                                            |
|====================================================|====================================================|
| type.__name__                                      | The class’s name. See also: "__name__ attributes". |
+----------------------------------------------------+----------------------------------------------------+
| type.__qualname__                                  | The class’s *qualified name*. See also:            |
|                                                    | "__qualname__ attributes".                         |
+----------------------------------------------------+----------------------------------------------------+
| type.__module__                                    | The name of the module in which the class was      |
|                                                    | defined.                                           |
+----------------------------------------------------+----------------------------------------------------+
| type.__dict__                                      | A "mapping proxy" providing a read-only view of    |
|                                                    | the class’s namespace. See also: "__dict__         |
|                                                    | attributes".                                       |
+----------------------------------------------------+----------------------------------------------------+
| type.__bases__                                     | A "tuple" containing the class’s bases. In most    |
|                                                    | cases, for a class defined as "class X(A, B, C)",  |
|                                                    | "X.__bases__" will be exactly equal to "(A, B,     |
|                                                    | C)".                                               |
+----------------------------------------------------+----------------------------------------------------+
| type.__doc__                                       | The class’s documentation string, or "None" if     |
|                                                    | undefined. Not inherited by subclasses.            |
+----------------------------------------------------+----------------------------------------------------+
| type.__annotations__                               | A dictionary containing *variable annotations*     |
|                                                    | collected during class body execution. For best    |
|                                                    | practices on working with "__annotations__",       |
|                                                    | please see Annotations Best Practices.  Caution:   |
|                                                    | Accessing the "__annotations__" attribute of a     |
|                                                    | class object directly may yield incorrect results  |
|                                                    | in the presence of metaclasses. In addition, the   |
|                                                    | attribute may not exist for some classes. Use      |
|                                                    | "inspect.get_annotations()" to retrieve class      |
|                                                    | annotations safely.                                |
+----------------------------------------------------+----------------------------------------------------+
| type.__type_params__                               | A "tuple" containing the type parameters of a      |
|                                                    | generic class.  Added in version 3.12.             |
+----------------------------------------------------+----------------------------------------------------+
| type.__mro__                                       | The "tuple" of classes that are considered when    |
|                                                    | looking for base classes during method resolution. |
+----------------------------------------------------+----------------------------------------------------+


Special methods
---------------

In addition to the special attributes described above, all Python
classes also have the following two methods available:

type.mro()

   This method can be overridden by a metaclass to customize the
   method resolution order for its instances.  It is called at class
   instantiation, and its result is stored in "__mro__".

type.__subclasses__()

   Each class keeps a list of weak references to its immediate
   subclasses. This method returns a list of all those references
   still alive. The list is in definition order. Example:

      >>> class A: pass
      >>> class B(A): pass
      >>> A.__subclasses__()
      [<class 'B'>]


Class instances
===============

A class instance is created by calling a class object (see above).  A
class instance has a namespace implemented as a dictionary which is
the first place in which attribute references are searched.  When an
attribute is not found there, and the instance’s class has an
attribute by that name, the search continues with the class
attributes.  If a class attribute is found that is a user-defined
function object, it is transformed into an instance method object
whose "__self__" attribute is the instance.  Static method and class
method objects are also transformed; see above under “Classes”.  See
section Implementing Descriptors for another way in which attributes
of a class retrieved via its instances may differ from the objects
actually stored in the class’s "__dict__".  If no class attribute is
found, and the object’s class has a "__getattr__()" method, that is
called to satisfy the lookup.

Attribute assignments and deletions update the instance’s dictionary,
never a class’s dictionary.  If the class has a "__setattr__()" or
"__delattr__()" method, this is called instead of updating the
instance dictionary directly.

Class instances can pretend to be numbers, sequences, or mappings if
they have methods with certain special names.  See section Special
method names.


Special attributes
------------------

object.__class__

   The class to which a class instance belongs.

object.__dict__

   A dictionary or other mapping object used to store an object’s
   (writable) attributes. Not all instances have a "__dict__"
   attribute; see the section on __slots__ for more details.


I/O objects (also known as file objects)
========================================

A *file object* represents an open file.  Various shortcuts are
available to create file objects: the "open()" built-in function, and
also "os.popen()", "os.fdopen()", and the "makefile()" method of
socket objects (and perhaps by other functions or methods provided by
extension modules).

The objects "sys.stdin", "sys.stdout" and "sys.stderr" are initialized
to file objects corresponding to the interpreter’s standard input,
output and error streams; they are all open in text mode and therefore
follow the interface defined by the "io.TextIOBase" abstract class.


Internal types
==============

A few types used internally by the interpreter are exposed to the
user. Their definitions may change with future versions of the
interpreter, but they are mentioned here for completeness.


Code objects
------------

Code objects represent *byte-compiled* executable Python code, or
*bytecode*. The difference between a code object and a function object
is that the function object contains an explicit reference to the
function’s globals (the module in which it was defined), while a code
object contains no context; also the default argument values are
stored in the function object, not in the code object (because they
represent values calculated at run-time).  Unlike function objects,
code objects are immutable and contain no references (directly or
indirectly) to mutable objects.


Special read-only attributes
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_name                                 | The function name                                  |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_qualname                             | The fully qualified function name  Added in        |
|                                                    | version 3.11.                                      |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_argcount                             | The total number of positional *parameters*        |
|                                                    | (including positional-only parameters and          |
|                                                    | parameters with default values) that the function  |
|                                                    | has                                                |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_posonlyargcount                      | The number of positional-only *parameters*         |
|                                                    | (including arguments with default values) that the |
|                                                    | function has                                       |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_kwonlyargcount                       | The number of keyword-only *parameters* (including |
|                                                    | arguments with default values) that the function   |
|                                                    | has                                                |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_nlocals                              | The number of local variables used by the function |
|                                                    | (including parameters)                             |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_varnames                             | A "tuple" containing the names of the local        |
|                                                    | variables in the function (starting with the       |
|                                                    | parameter names)                                   |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_cellvars                             | A "tuple" containing the names of local variables  |
|                                                    | that are referenced by nested functions inside the |
|                                                    | function                                           |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_freevars                             | A "tuple" containing the names of free variables   |
|                                                    | in the function                                    |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_code                                 | A string representing the sequence of *bytecode*   |
|                                                    | instructions in the function                       |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_consts                               | A "tuple" containing the literals used by the      |
|                                                    | *bytecode* in the function                         |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_names                                | A "tuple" containing the names used by the         |
|                                                    | *bytecode* in the function                         |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_filename                             | The name of the file from which the code was       |
|                                                    | compiled                                           |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_firstlineno                          | The line number of the first line of the function  |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_lnotab                               | A string encoding the mapping from *bytecode*      |
|                                                    | offsets to line numbers. For details, see the      |
|                                                    | source code of the interpreter.  Deprecated since  |
|                                                    | version 3.12: This attribute of code objects is    |
|                                                    | deprecated, and may be removed in Python 3.15.     |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_stacksize                            | The required stack size of the code object         |
+----------------------------------------------------+----------------------------------------------------+
| codeobject.co_flags                                | An "integer" encoding a number of flags for the    |
|                                                    | interpreter.                                       |
+----------------------------------------------------+----------------------------------------------------+

The following flag bits are defined for "co_flags": bit "0x04" is set
if the function uses the "*arguments" syntax to accept an arbitrary
number of positional arguments; bit "0x08" is set if the function uses
the "**keywords" syntax to accept arbitrary keyword arguments; bit
"0x20" is set if the function is a generator. See Code Objects Bit
Flags for details on the semantics of each flags that might be
present.

Future feature declarations ("from __future__ import division") also
use bits in "co_flags" to indicate whether a code object was compiled
with a particular feature enabled: bit "0x2000" is set if the function
was compiled with future division enabled; bits "0x10" and "0x1000"
were used in earlier versions of Python.

Other bits in "co_flags" are reserved for internal use.

If a code object represents a function, the first item in "co_consts"
is the documentation string of the function, or "None" if undefined.


Methods on code objects
~~~~~~~~~~~~~~~~~~~~~~~

codeobject.co_positions()

   Returns an iterable over the source code positions of each
   *bytecode* instruction in the code object.

   The iterator returns "tuple"s containing the "(start_line,
   end_line, start_column, end_column)". The *i-th* tuple corresponds
   to the position of the source code that compiled to the *i-th* code
   unit. Column information is 0-indexed utf-8 byte offsets on the
   given source line.

   This positional information can be missing. A non-exhaustive lists
   of cases where this may happen:

   * Running the interpreter with "-X" "no_debug_ranges".

   * Loading a pyc file compiled while using "-X" "no_debug_ranges".

   * Position tuples corresponding to artificial instructions.

   * Line and column numbers that can’t be represented due to
     implementation specific limitations.

   When this occurs, some or all of the tuple elements can be "None".

   Added in version 3.11.

   Note:

     This feature requires storing column positions in code objects
     which may result in a small increase of disk usage of compiled
     Python files or interpreter memory usage. To avoid storing the
     extra information and/or deactivate printing the extra traceback
     information, the "-X" "no_debug_ranges" command line flag or the
     "PYTHONNODEBUGRANGES" environment variable can be used.

codeobject.co_lines()

   Returns an iterator that yields information about successive ranges
   of *bytecode*s. Each item yielded is a "(start, end, lineno)"
   "tuple":

   * "start" (an "int") represents the offset (inclusive) of the start
     of the *bytecode* range

   * "end" (an "int") represents the offset (exclusive) of the end of
     the *bytecode* range

   * "lineno" is an "int" representing the line number of the
     *bytecode* range, or "None" if the bytecodes in the given range
     have no line number

   The items yielded will have the following properties:

   * The first range yielded will have a "start" of 0.

   * The "(start, end)" ranges will be non-decreasing and consecutive.
     That is, for any pair of "tuple"s, the "start" of the second will
     be equal to the "end" of the first.

   * No range will be backwards: "end >= start" for all triples.

   * The last "tuple" yielded will have "end" equal to the size of the
     *bytecode*.

   Zero-width ranges, where "start == end", are allowed. Zero-width
   ranges are used for lines that are present in the source code, but
   have been eliminated by the *bytecode* compiler.

   Added in version 3.10.

   See also:

     **PEP 626** - Precise line numbers for debugging and other tools.
        The PEP that introduced the "co_lines()" method.

codeobject.replace(**kwargs)

   Return a copy of the code object with new values for the specified
   fields.

   Added in version 3.8.


Frame objects
-------------

Frame objects represent execution frames.  They may occur in traceback
objects, and are also passed to registered trace functions.


Special read-only attributes
~~~~~~~~~~~~~~~~~~~~~~~~~~~~

+----------------------------------------------------+----------------------------------------------------+
| frame.f_back                                       | Points to the previous stack frame (towards the    |
|                                                    | caller), or "None" if this is the bottom stack     |
|                                                    | frame                                              |
+----------------------------------------------------+----------------------------------------------------+
| frame.f_code                                       | The code object being executed in this frame.      |
|                                                    | Accessing this attribute raises an auditing event  |
|                                                    | "object.__getattr__" with arguments "obj" and      |
|                                                    | ""f_code"".                                        |
+----------------------------------------------------+----------------------------------------------------+
| frame.f_locals                                     | The dictionary used by the frame to look up local  |
|                                                    | variables                                          |
+----------------------------------------------------+----------------------------------------------------+
| frame.f_globals                                    | The dictionary used by the frame to look up global |
|                                                    | variables                                          |
+----------------------------------------------------+----------------------------------------------------+
| frame.f_builtins                                   | The dictionary used by the frame to look up built- |
|                                                    | in (intrinsic) names                               |
+----------------------------------------------------+----------------------------------------------------+
| frame.f_lasti                                      | The “precise instruction” of the frame object      |
|                                                    | (this is an index into the *bytecode* string of    |
|                                                    | the code object)                                   |
+----------------------------------------------------+----------------------------------------------------+


Special writable attributes
~~~~~~~~~~~~~~~~~~~~~~~~~~~

+----------------------------------------------------+----------------------------------------------------+
| frame.f_trace                                      | If not "None", this is a function called for       |
|                                                    | various events during code execution (this is used |
|                                                    | by debuggers). Normally an event is triggered for  |
|                                                    | each new source line (see "f_trace_lines").        |
+----------------------------------------------------+----------------------------------------------------+
| frame.f_trace_lines                                | Set this attribute to "False" to disable           |
|                                                    | triggering a tracing event for each source line.   |
+----------------------------------------------------+----------------------------------------------------+
| frame.f_trace_opcodes                              | Set this attribute to "True" to allow per-opcode   |
|                                                    | events to be requested. Note that this may lead to |
|                                                    | undefined interpreter behaviour if exceptions      |
|                                                    | raised by the trace function escape to the         |
|                                                    | function being traced.                             |
+----------------------------------------------------+----------------------------------------------------+
| frame.f_lineno                                     | The current line number of the frame – writing to  |
|                                                    | this from within a trace function jumps to the     |
|                                                    | given line (only for the bottom-most frame).  A    |
|                                                    | debugger can implement a Jump command (aka Set     |
|                                                    | Next Statement) by writing to this attribute.      |
+----------------------------------------------------+----------------------------------------------------+


Frame object methods
~~~~~~~~~~~~~~~~~~~~

Frame objects support one method:

frame.clear()

   This method clears all references to local variables held by the
   frame.  Also, if the frame belonged to a *generator*, the generator
   is finalized.  This helps break reference cycles involving frame
   objects (for example when catching an exception and storing its
   traceback for later use).

   "RuntimeError" is raised if the frame is currently executing.

   Added in version 3.4.


Traceback objects
-----------------

Traceback objects represent the stack trace of an exception. A
traceback object is implicitly created when an exception occurs, and
may also be explicitly created by calling "types.TracebackType".

Changed in version 3.7: Traceback objects can now be explicitly
instantiated from Python code.

For implicitly created tracebacks, when the search for an exception
handler unwinds the execution stack, at each unwound level a traceback
object is inserted in front of the current traceback.  When an
exception handler is entered, the stack trace is made available to the
program. (See section The try statement.) It is accessible as the
third item of the tuple returned by "sys.exc_info()", and as the
"__traceback__" attribute of the caught exception.

When the program contains no suitable handler, the stack trace is
written (nicely formatted) to the standard error stream; if the
interpreter is interactive, it is also made available to the user as
"sys.last_traceback".

For explicitly created tracebacks, it is up to the creator of the
traceback to determine how the "tb_next" attributes should be linked
to form a full stack trace.

Special read-only attributes:

+----------------------------------------------------+----------------------------------------------------+
| traceback.tb_frame                                 | Points to the execution frame of the current       |
|                                                    | level.  Accessing this attribute raises an         |
|                                                    | auditing event "object.__getattr__" with arguments |
|                                                    | "obj" and ""tb_frame"".                            |
+----------------------------------------------------+----------------------------------------------------+
| traceback.tb_lineno                                | Gives the line number where the exception occurred |
+----------------------------------------------------+----------------------------------------------------+
| traceback.tb_lasti                                 | Indicates the “precise instruction”.               |
+----------------------------------------------------+----------------------------------------------------+

The line number and last instruction in the traceback may differ from
the line number of its frame object if the exception occurred in a
"try" statement with no matching except clause or with a "finally"
clause.

traceback.tb_next

   The special writable attribute "tb_next" is the next level in the
   stack trace (towards the frame where the exception occurred), or
   "None" if there is no next level.

   Changed in version 3.7: This attribute is now writable


Slice objects
-------------

Slice objects are used to represent slices for "__getitem__()"
methods.  They are also created by the built-in "slice()" function.

Special read-only attributes: "start" is the lower bound; "stop" is
the upper bound; "step" is the step value; each is "None" if omitted.
These attributes can have any type.

Slice objects support one method:

slice.indices(self, length)

   This method takes a single integer argument *length* and computes
   information about the slice that the slice object would describe if
   applied to a sequence of *length* items.  It returns a tuple of
   three integers; respectively these are the *start* and *stop*
   indices and the *step* or stride length of the slice. Missing or
   out-of-bounds indices are handled in a manner consistent with
   regular slices.


Static method objects
---------------------

Static method objects provide a way of defeating the transformation of
function objects to method objects described above. A static method
object is a wrapper around any other object, usually a user-defined
method object. When a static method object is retrieved from a class
or a class instance, the object actually returned is the wrapped
object, which is not subject to any further transformation. Static
method objects are also callable. Static method objects are created by
the built-in "staticmethod()" constructor.


Class method objects
--------------------

A class method object, like a static method object, is a wrapper
around another object that alters the way in which that object is
retrieved from classes and class instances. The behaviour of class
method objects upon such retrieval is described above, under “instance
methods”. Class method objects are created by the built-in
"classmethod()" constructor.
''',
    'typesfunctions': r'''Functions
*********

Function objects are created by function definitions.  The only
operation on a function object is to call it: "func(argument-list)".

There are really two flavors of function objects: built-in functions
and user-defined functions.  Both support the same operation (to call
the function), but the implementation is different, hence the
different object types.

See Function definitions for more information.
''',
    'typesmapping': r'''Mapping Types — "dict"
**********************

A *mapping* object maps *hashable* values to arbitrary objects.
Mappings are mutable objects.  There is currently only one standard
mapping type, the *dictionary*.  (For other containers see the built-
in "list", "set", and "tuple" classes, and the "collections" module.)

A dictionary’s keys are *almost* arbitrary values.  Values that are
not *hashable*, that is, values containing lists, dictionaries or
other mutable types (that are compared by value rather than by object
identity) may not be used as keys. Values that compare equal (such as
"1", "1.0", and "True") can be used interchangeably to index the same
dictionary entry.

class dict(**kwargs)
class dict(mapping, **kwargs)
class dict(iterable, **kwargs)

   Return a new dictionary initialized from an optional positional
   argument and a possibly empty set of keyword arguments.

   Dictionaries can be created by several means:

   * Use a comma-separated list of "key: value" pairs within braces:
     "{'jack': 4098, 'sjoerd': 4127}" or "{4098: 'jack', 4127:
     'sjoerd'}"

   * Use a dict comprehension: "{}", "{x: x ** 2 for x in range(10)}"

   * Use the type constructor: "dict()", "dict([('foo', 100), ('bar',
     200)])", "dict(foo=100, bar=200)"

   If no positional argument is given, an empty dictionary is created.
   If a positional argument is given and it defines a "keys()" method,
   a dictionary is created by calling "__getitem__()" on the argument
   with each returned key from the method.  Otherwise, the positional
   argument must be an *iterable* object.  Each item in the iterable
   must itself be an iterable with exactly two elements.  The first
   element of each item becomes a key in the new dictionary, and the
   second element the corresponding value.  If a key occurs more than
   once, the last value for that key becomes the corresponding value
   in the new dictionary.

   If keyword arguments are given, the keyword arguments and their
   values are added to the dictionary created from the positional
   argument.  If a key being added is already present, the value from
   the keyword argument replaces the value from the positional
   argument.

   To illustrate, the following examples all return a dictionary equal
   to "{"one": 1, "two": 2, "three": 3}":

      >>> a = dict(one=1, two=2, three=3)
      >>> b = {'one': 1, 'two': 2, 'three': 3}
      >>> c = dict(zip(['one', 'two', 'three'], [1, 2, 3]))
      >>> d = dict([('two', 2), ('one', 1), ('three', 3)])
      >>> e = dict({'three': 3, 'one': 1, 'two': 2})
      >>> f = dict({'one': 1, 'three': 3}, two=2)
      >>> a == b == c == d == e == f
      True

   Providing keyword arguments as in the first example only works for
   keys that are valid Python identifiers.  Otherwise, any valid keys
   can be used.

   These are the operations that dictionaries support (and therefore,
   custom mapping types should support too):

   list(d)

      Return a list of all the keys used in the dictionary *d*.

   len(d)

      Return the number of items in the dictionary *d*.

   d[key]

      Return the item of *d* with key *key*.  Raises a "KeyError" if
      *key* is not in the map.

      If a subclass of dict defines a method "__missing__()" and *key*
      is not present, the "d[key]" operation calls that method with
      the key *key* as argument.  The "d[key]" operation then returns
      or raises whatever is returned or raised by the
      "__missing__(key)" call. No other operations or methods invoke
      "__missing__()". If "__missing__()" is not defined, "KeyError"
      is raised. "__missing__()" must be a method; it cannot be an
      instance variable:

         >>> class Counter(dict):
         ...     def __missing__(self, key):
         ...         return 0
         ...
         >>> c = Counter()
         >>> c['red']
         0
         >>> c['red'] += 1
         >>> c['red']
         1

      The example above shows part of the implementation of
      "collections.Counter".  A different "__missing__" method is used
      by "collections.defaultdict".

   d[key] = value

      Set "d[key]" to *value*.

   del d[key]

      Remove "d[key]" from *d*.  Raises a "KeyError" if *key* is not
      in the map.

   key in d

      Return "True" if *d* has a key *key*, else "False".

   key not in d

      Equivalent to "not key in d".

   iter(d)

      Return an iterator over the keys of the dictionary.  This is a
      shortcut for "iter(d.keys())".

   clear()

      Remove all items from the dictionary.

   copy()

      Return a shallow copy of the dictionary.

   classmethod fromkeys(iterable, value=None, /)

      Create a new dictionary with keys from *iterable* and values set
      to *value*.

      "fromkeys()" is a class method that returns a new dictionary.
      *value* defaults to "None".  All of the values refer to just a
      single instance, so it generally doesn’t make sense for *value*
      to be a mutable object such as an empty list.  To get distinct
      values, use a dict comprehension instead.

   get(key, default=None, /)

      Return the value for *key* if *key* is in the dictionary, else
      *default*. If *default* is not given, it defaults to "None", so
      that this method never raises a "KeyError".

   items()

      Return a new view of the dictionary’s items ("(key, value)"
      pairs). See the documentation of view objects.

   keys()

      Return a new view of the dictionary’s keys.  See the
      documentation of view objects.

   pop(key[, default])

      If *key* is in the dictionary, remove it and return its value,
      else return *default*.  If *default* is not given and *key* is
      not in the dictionary, a "KeyError" is raised.

   popitem()

      Remove and return a "(key, value)" pair from the dictionary.
      Pairs are returned in LIFO (last-in, first-out) order.

      "popitem()" is useful to destructively iterate over a
      dictionary, as often used in set algorithms.  If the dictionary
      is empty, calling "popitem()" raises a "KeyError".

      Changed in version 3.7: LIFO order is now guaranteed. In prior
      versions, "popitem()" would return an arbitrary key/value pair.

   reversed(d)

      Return a reverse iterator over the keys of the dictionary. This
      is a shortcut for "reversed(d.keys())".

      Added in version 3.8.

   setdefault(key, default=None, /)

      If *key* is in the dictionary, return its value.  If not, insert
      *key* with a value of *default* and return *default*.  *default*
      defaults to "None".

   update([other])

      Update the dictionary with the key/value pairs from *other*,
      overwriting existing keys.  Return "None".

      "update()" accepts either another object with a "keys()" method
      (in which case "__getitem__()" is called with every key returned
      from the method) or an iterable of key/value pairs (as tuples or
      other iterables of length two). If keyword arguments are
      specified, the dictionary is then updated with those key/value
      pairs: "d.update(red=1, blue=2)".

   values()

      Return a new view of the dictionary’s values.  See the
      documentation of view objects.

      An equality comparison between one "dict.values()" view and
      another will always return "False". This also applies when
      comparing "dict.values()" to itself:

         >>> d = {'a': 1}
         >>> d.values() == d.values()
         False

   d | other

      Create a new dictionary with the merged keys and values of *d*
      and *other*, which must both be dictionaries. The values of
      *other* take priority when *d* and *other* share keys.

      Added in version 3.9.

   d |= other

      Update the dictionary *d* with keys and values from *other*,
      which may be either a *mapping* or an *iterable* of key/value
      pairs. The values of *other* take priority when *d* and *other*
      share keys.

      Added in version 3.9.

   Dictionaries compare equal if and only if they have the same "(key,
   value)" pairs (regardless of ordering). Order comparisons (‘<’,
   ‘<=’, ‘>=’, ‘>’) raise "TypeError".

   Dictionaries preserve insertion order.  Note that updating a key
   does not affect the order.  Keys added after deletion are inserted
   at the end.

      >>> d = {"one": 1, "two": 2, "three": 3, "four": 4}
      >>> d
      {'one': 1, 'two': 2, 'three': 3, 'four': 4}
      >>> list(d)
      ['one', 'two', 'three', 'four']
      >>> list(d.values())
      [1, 2, 3, 4]
      >>> d["one"] = 42
      >>> d
      {'one': 42, 'two': 2, 'three': 3, 'four': 4}
      >>> del d["two"]
      >>> d["two"] = None
      >>> d
      {'one': 42, 'three': 3, 'four': 4, 'two': None}

   Changed in version 3.7: Dictionary order is guaranteed to be
   insertion order.  This behavior was an implementation detail of
   CPython from 3.6.

   Dictionaries and dictionary views are reversible.

      >>> d = {"one": 1, "two": 2, "three": 3, "four": 4}
      >>> d
      {'one': 1, 'two': 2, 'three': 3, 'four': 4}
      >>> list(reversed(d))
      ['four', 'three', 'two', 'one']
      >>> list(reversed(d.values()))
      [4, 3, 2, 1]
      >>> list(reversed(d.items()))
      [('four', 4), ('three', 3), ('two', 2), ('one', 1)]

   Changed in version 3.8: Dictionaries are now reversible.

See also:

  "types.MappingProxyType" can be used to create a read-only view of a
  "dict".


Dictionary view objects
=======================

The objects returned by "dict.keys()", "dict.values()" and
"dict.items()" are *view objects*.  They provide a dynamic view on the
dictionary’s entries, which means that when the dictionary changes,
the view reflects these changes.

Dictionary views can be iterated over to yield their respective data,
and support membership tests:

len(dictview)

   Return the number of entries in the dictionary.

iter(dictview)

   Return an iterator over the keys, values or items (represented as
   tuples of "(key, value)") in the dictionary.

   Keys and values are iterated over in insertion order. This allows
   the creation of "(value, key)" pairs using "zip()": "pairs =
   zip(d.values(), d.keys())".  Another way to create the same list is
   "pairs = [(v, k) for (k, v) in d.items()]".

   Iterating views while adding or deleting entries in the dictionary
   may raise a "RuntimeError" or fail to iterate over all entries.

   Changed in version 3.7: Dictionary order is guaranteed to be
   insertion order.

x in dictview

   Return "True" if *x* is in the underlying dictionary’s keys, values
   or items (in the latter case, *x* should be a "(key, value)"
   tuple).

reversed(dictview)

   Return a reverse iterator over the keys, values or items of the
   dictionary. The view will be iterated in reverse order of the
   insertion.

   Changed in version 3.8: Dictionary views are now reversible.

dictview.mapping

   Return a "types.MappingProxyType" that wraps the original
   dictionary to which the view refers.

   Added in version 3.10.

Keys views are set-like since their entries are unique and *hashable*.
Items views also have set-like operations since the (key, value) pairs
are unique and the keys are hashable. If all values in an items view
are hashable as well, then the items view can interoperate with other
sets. (Values views are not treated as set-like since the entries are
generally not unique.)  For set-like views, all of the operations
defined for the abstract base class "collections.abc.Set" are
available (for example, "==", "<", or "^").  While using set
operators, set-like views accept any iterable as the other operand,
unlike sets which only accept sets as the input.

An example of dictionary view usage:

   >>> dishes = {'eggs': 2, 'sausage': 1, 'bacon': 1, 'spam': 500}
   >>> keys = dishes.keys()
   >>> values = dishes.values()

   >>> # iteration
   >>> n = 0
   >>> for val in values:
   ...     n += val
   ...
   >>> print(n)
   504

   >>> # keys and values are iterated over in the same order (insertion order)
   >>> list(keys)
   ['eggs', 'sausage', 'bacon', 'spam']
   >>> list(values)
   [2, 1, 1, 500]

   >>> # view objects are dynamic and reflect dict changes
   >>> del dishes['eggs']
   >>> del dishes['sausage']
   >>> list(keys)
   ['bacon', 'spam']

   >>> # set operations
   >>> keys & {'eggs', 'bacon', 'salad'}
   {'bacon'}
   >>> keys ^ {'sausage', 'juice'} == {'juice', 'sausage', 'bacon', 'spam'}
   True
   >>> keys | ['juice', 'juice', 'juice'] == {'bacon', 'spam', 'juice'}
   True

   >>> # get back a read-only proxy for the original dictionary
   >>> values.mapping
   mappingproxy({'bacon': 1, 'spam': 500})
   >>> values.mapping['spam']
   500
''',
    'typesmethods': r'''Methods
*******

Methods are functions that are called using the attribute notation.
There are two flavors: built-in methods (such as "append()" on lists)
and class instance method. Built-in methods are described with the
types that support them.

If you access a method (a function defined in a class namespace)
through an instance, you get a special object: a *bound method* (also
called instance method) object. When called, it will add the "self"
argument to the argument list.  Bound methods have two special read-
only attributes: "m.__self__" is the object on which the method
operates, and "m.__func__" is the function implementing the method.
Calling "m(arg-1, arg-2, ..., arg-n)" is completely equivalent to
calling "m.__func__(m.__self__, arg-1, arg-2, ..., arg-n)".

Like function objects, bound method objects support getting arbitrary
attributes.  However, since method attributes are actually stored on
the underlying function object ("method.__func__"), setting method
attributes on bound methods is disallowed.  Attempting to set an
attribute on a method results in an "AttributeError" being raised.  In
order to set a method attribute, you need to explicitly set it on the
underlying function object:

   >>> class C:
   ...     def method(self):
   ...         pass
   ...
   >>> c = C()
   >>> c.method.whoami = 'my name is method'  # can't set on the method
   Traceback (most recent call last):
     File "<stdin>", line 1, in <module>
   AttributeError: 'method' object has no attribute 'whoami'
   >>> c.method.__func__.whoami = 'my name is method'
   >>> c.method.whoami
   'my name is method'

See Instance methods for more information.
''',
    'typesmodules': r'''Modules
*******

The only special operation on a module is attribute access: "m.name",
where *m* is a module and *name* accesses a name defined in *m*’s
symbol table. Module attributes can be assigned to.  (Note that the
"import" statement is not, strictly speaking, an operation on a module
object; "import foo" does not require a module object named *foo* to
exist, rather it requires an (external) *definition* for a module
named *foo* somewhere.)

A special attribute of every module is "__dict__". This is the
dictionary containing the module’s symbol table. Modifying this
dictionary will actually change the module’s symbol table, but direct
assignment to the "__dict__" attribute is not possible (you can write
"m.__dict__['a'] = 1", which defines "m.a" to be "1", but you can’t
write "m.__dict__ = {}").  Modifying "__dict__" directly is not
recommended.

Modules built into the interpreter are written like this: "<module
'sys' (built-in)>".  If loaded from a file, they are written as
"<module 'os' from '/usr/local/lib/pythonX.Y/os.pyc'>".
''',
    'typesseq': r'''Sequence Types — "list", "tuple", "range"
*****************************************

There are three basic sequence types: lists, tuples, and range
objects. Additional sequence types tailored for processing of binary
data and text strings are described in dedicated sections.


Common Sequence Operations
==========================

The operations in the following table are supported by most sequence
types, both mutable and immutable. The "collections.abc.Sequence" ABC
is provided to make it easier to correctly implement these operations
on custom sequence types.

This table lists the sequence operations sorted in ascending priority.
In the table, *s* and *t* are sequences of the same type, *n*, *i*,
*j* and *k* are integers and *x* is an arbitrary object that meets any
type and value restrictions imposed by *s*.

The "in" and "not in" operations have the same priorities as the
comparison operations. The "+" (concatenation) and "*" (repetition)
operations have the same priority as the corresponding numeric
operations. [3]

+----------------------------+----------------------------------+------------+
| Operation                  | Result                           | Notes      |
|============================|==================================|============|
| "x in s"                   | "True" if an item of *s* is      | (1)        |
|                            | equal to *x*, else "False"       |            |
+----------------------------+----------------------------------+------------+
| "x not in s"               | "False" if an item of *s* is     | (1)        |
|                            | equal to *x*, else "True"        |            |
+----------------------------+----------------------------------+------------+
| "s + t"                    | the concatenation of *s* and *t* | (6)(7)     |
+----------------------------+----------------------------------+------------+
| "s * n" or "n * s"         | equivalent to adding *s* to      | (2)(7)     |
|                            | itself *n* times                 |            |
+----------------------------+----------------------------------+------------+
| "s[i]"                     | *i*th item of *s*, origin 0      | (3)        |
+----------------------------+----------------------------------+------------+
| "s[i:j]"                   | slice of *s* from *i* to *j*     | (3)(4)     |
+----------------------------+----------------------------------+------------+
| "s[i:j:k]"                 | slice of *s* from *i* to *j*     | (3)(5)     |
|                            | with step *k*                    |            |
+----------------------------+----------------------------------+------------+
| "len(s)"                   | length of *s*                    |            |
+----------------------------+----------------------------------+------------+
| "min(s)"                   | smallest item of *s*             |            |
+----------------------------+----------------------------------+------------+
| "max(s)"                   | largest item of *s*              |            |
+----------------------------+----------------------------------+------------+
| "s.index(x[, i[, j]])"     | index of the first occurrence of | (8)        |
|                            | *x* in *s* (at or after index    |            |
|                            | *i* and before index *j*)        |            |
+----------------------------+----------------------------------+------------+
| "s.count(x)"               | total number of occurrences of   |            |
|                            | *x* in *s*                       |            |
+----------------------------+----------------------------------+------------+

Sequences of the same type also support comparisons.  In particular,
tuples and lists are compared lexicographically by comparing
corresponding elements. This means that to compare equal, every
element must compare equal and the two sequences must be of the same
type and have the same length.  (For full details see Comparisons in
the language reference.)

Forward and reversed iterators over mutable sequences access values
using an index.  That index will continue to march forward (or
backward) even if the underlying sequence is mutated.  The iterator
terminates only when an "IndexError" or a "StopIteration" is
encountered (or when the index drops below zero).

Notes:

1. While the "in" and "not in" operations are used only for simple
   containment testing in the general case, some specialised sequences
   (such as "str", "bytes" and "bytearray") also use them for
   subsequence testing:

      >>> "gg" in "eggs"
      True

2. Values of *n* less than "0" are treated as "0" (which yields an
   empty sequence of the same type as *s*).  Note that items in the
   sequence *s* are not copied; they are referenced multiple times.
   This often haunts new Python programmers; consider:

      >>> lists = [[]] * 3
      >>> lists
      [[], [], []]
      >>> lists[0].append(3)
      >>> lists
      [[3], [3], [3]]

   What has happened is that "[[]]" is a one-element list containing
   an empty list, so all three elements of "[[]] * 3" are references
   to this single empty list.  Modifying any of the elements of
   "lists" modifies this single list. You can create a list of
   different lists this way:

      >>> lists = [[] for i in range(3)]
      >>> lists[0].append(3)
      >>> lists[1].append(5)
      >>> lists[2].append(7)
      >>> lists
      [[3], [5], [7]]

   Further explanation is available in the FAQ entry How do I create a
   multidimensional list?.

3. If *i* or *j* is negative, the index is relative to the end of
   sequence *s*: "len(s) + i" or "len(s) + j" is substituted.  But
   note that "-0" is still "0".

4. The slice of *s* from *i* to *j* is defined as the sequence of
   items with index *k* such that "i <= k < j".  If *i* or *j* is
   greater than "len(s)", use "len(s)".  If *i* is omitted or "None",
   use "0".  If *j* is omitted or "None", use "len(s)".  If *i* is
   greater than or equal to *j*, the slice is empty.

5. The slice of *s* from *i* to *j* with step *k* is defined as the
   sequence of items with index  "x = i + n*k" such that "0 <= n <
   (j-i)/k".  In other words, the indices are "i", "i+k", "i+2*k",
   "i+3*k" and so on, stopping when *j* is reached (but never
   including *j*).  When *k* is positive, *i* and *j* are reduced to
   "len(s)" if they are greater. When *k* is negative, *i* and *j* are
   reduced to "len(s) - 1" if they are greater.  If *i* or *j* are
   omitted or "None", they become “end” values (which end depends on
   the sign of *k*).  Note, *k* cannot be zero. If *k* is "None", it
   is treated like "1".

6. Concatenating immutable sequences always results in a new object.
   This means that building up a sequence by repeated concatenation
   will have a quadratic runtime cost in the total sequence length.
   To get a linear runtime cost, you must switch to one of the
   alternatives below:

   * if concatenating "str" objects, you can build a list and use
     "str.join()" at the end or else write to an "io.StringIO"
     instance and retrieve its value when complete

   * if concatenating "bytes" objects, you can similarly use
     "bytes.join()" or "io.BytesIO", or you can do in-place
     concatenation with a "bytearray" object.  "bytearray" objects are
     mutable and have an efficient overallocation mechanism

   * if concatenating "tuple" objects, extend a "list" instead

   * for other types, investigate the relevant class documentation

7. Some sequence types (such as "range") only support item sequences
   that follow specific patterns, and hence don’t support sequence
   concatenation or repetition.

8. "index" raises "ValueError" when *x* is not found in *s*. Not all
   implementations support passing the additional arguments *i* and
   *j*. These arguments allow efficient searching of subsections of
   the sequence. Passing the extra arguments is roughly equivalent to
   using "s[i:j].index(x)", only without copying any data and with the
   returned index being relative to the start of the sequence rather
   than the start of the slice.


Immutable Sequence Types
========================

The only operation that immutable sequence types generally implement
that is not also implemented by mutable sequence types is support for
the "hash()" built-in.

This support allows immutable sequences, such as "tuple" instances, to
be used as "dict" keys and stored in "set" and "frozenset" instances.

Attempting to hash an immutable sequence that contains unhashable
values will result in "TypeError".


Mutable Sequence Types
======================

The operations in the following table are defined on mutable sequence
types. The "collections.abc.MutableSequence" ABC is provided to make
it easier to correctly implement these operations on custom sequence
types.

In the table *s* is an instance of a mutable sequence type, *t* is any
iterable object and *x* is an arbitrary object that meets any type and
value restrictions imposed by *s* (for example, "bytearray" only
accepts integers that meet the value restriction "0 <= x <= 255").

+--------------------------------+----------------------------------+-----------------------+
| Operation                      | Result                           | Notes                 |
|================================|==================================|=======================|
| "s[i] = x"                     | item *i* of *s* is replaced by   |                       |
|                                | *x*                              |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s[i:j] = t"                   | slice of *s* from *i* to *j* is  |                       |
|                                | replaced by the contents of the  |                       |
|                                | iterable *t*                     |                       |
+--------------------------------+----------------------------------+-----------------------+
| "del s[i:j]"                   | same as "s[i:j] = []"            |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s[i:j:k] = t"                 | the elements of "s[i:j:k]" are   | (1)                   |
|                                | replaced by those of *t*         |                       |
+--------------------------------+----------------------------------+-----------------------+
| "del s[i:j:k]"                 | removes the elements of          |                       |
|                                | "s[i:j:k]" from the list         |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.append(x)"                  | appends *x* to the end of the    |                       |
|                                | sequence (same as                |                       |
|                                | "s[len(s):len(s)] = [x]")        |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.clear()"                    | removes all items from *s* (same | (5)                   |
|                                | as "del s[:]")                   |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.copy()"                     | creates a shallow copy of *s*    | (5)                   |
|                                | (same as "s[:]")                 |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.extend(t)" or "s += t"      | extends *s* with the contents of |                       |
|                                | *t* (for the most part the same  |                       |
|                                | as "s[len(s):len(s)] = t")       |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s *= n"                       | updates *s* with its contents    | (6)                   |
|                                | repeated *n* times               |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.insert(i, x)"               | inserts *x* into *s* at the      |                       |
|                                | index given by *i* (same as      |                       |
|                                | "s[i:i] = [x]")                  |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.pop()" or "s.pop(i)"        | retrieves the item at *i* and    | (2)                   |
|                                | also removes it from *s*         |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.remove(x)"                  | removes the first item from *s*  | (3)                   |
|                                | where "s[i]" is equal to *x*     |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.reverse()"                  | reverses the items of *s* in     | (4)                   |
|                                | place                            |                       |
+--------------------------------+----------------------------------+-----------------------+

Notes:

1. If *k* is not equal to "1", *t* must have the same length as the
   slice it is replacing.

2. The optional argument *i* defaults to "-1", so that by default the
   last item is removed and returned.

3. "remove()" raises "ValueError" when *x* is not found in *s*.

4. The "reverse()" method modifies the sequence in place for economy
   of space when reversing a large sequence.  To remind users that it
   operates by side effect, it does not return the reversed sequence.

5. "clear()" and "copy()" are included for consistency with the
   interfaces of mutable containers that don’t support slicing
   operations (such as "dict" and "set"). "copy()" is not part of the
   "collections.abc.MutableSequence" ABC, but most concrete mutable
   sequence classes provide it.

   Added in version 3.3: "clear()" and "copy()" methods.

6. The value *n* is an integer, or an object implementing
   "__index__()".  Zero and negative values of *n* clear the sequence.
   Items in the sequence are not copied; they are referenced multiple
   times, as explained for "s * n" under Common Sequence Operations.


Lists
=====

Lists are mutable sequences, typically used to store collections of
homogeneous items (where the precise degree of similarity will vary by
application).

class list([iterable])

   Lists may be constructed in several ways:

   * Using a pair of square brackets to denote the empty list: "[]"

   * Using square brackets, separating items with commas: "[a]", "[a,
     b, c]"

   * Using a list comprehension: "[x for x in iterable]"

   * Using the type constructor: "list()" or "list(iterable)"

   The constructor builds a list whose items are the same and in the
   same order as *iterable*’s items.  *iterable* may be either a
   sequence, a container that supports iteration, or an iterator
   object.  If *iterable* is already a list, a copy is made and
   returned, similar to "iterable[:]". For example, "list('abc')"
   returns "['a', 'b', 'c']" and "list( (1, 2, 3) )" returns "[1, 2,
   3]". If no argument is given, the constructor creates a new empty
   list, "[]".

   Many other operations also produce lists, including the "sorted()"
   built-in.

   Lists implement all of the common and mutable sequence operations.
   Lists also provide the following additional method:

   sort(*, key=None, reverse=False)

      This method sorts the list in place, using only "<" comparisons
      between items. Exceptions are not suppressed - if any comparison
      operations fail, the entire sort operation will fail (and the
      list will likely be left in a partially modified state).

      "sort()" accepts two arguments that can only be passed by
      keyword (keyword-only arguments):

      *key* specifies a function of one argument that is used to
      extract a comparison key from each list element (for example,
      "key=str.lower"). The key corresponding to each item in the list
      is calculated once and then used for the entire sorting process.
      The default value of "None" means that list items are sorted
      directly without calculating a separate key value.

      The "functools.cmp_to_key()" utility is available to convert a
      2.x style *cmp* function to a *key* function.

      *reverse* is a boolean value.  If set to "True", then the list
      elements are sorted as if each comparison were reversed.

      This method modifies the sequence in place for economy of space
      when sorting a large sequence.  To remind users that it operates
      by side effect, it does not return the sorted sequence (use
      "sorted()" to explicitly request a new sorted list instance).

      The "sort()" method is guaranteed to be stable.  A sort is
      stable if it guarantees not to change the relative order of
      elements that compare equal — this is helpful for sorting in
      multiple passes (for example, sort by department, then by salary
      grade).

      For sorting examples and a brief sorting tutorial, see Sorting
      Techniques.

      **CPython implementation detail:** While a list is being sorted,
      the effect of attempting to mutate, or even inspect, the list is
      undefined.  The C implementation of Python makes the list appear
      empty for the duration, and raises "ValueError" if it can detect
      that the list has been mutated during a sort.


Tuples
======

Tuples are immutable sequences, typically used to store collections of
heterogeneous data (such as the 2-tuples produced by the "enumerate()"
built-in). Tuples are also used for cases where an immutable sequence
of homogeneous data is needed (such as allowing storage in a "set" or
"dict" instance).

class tuple([iterable])

   Tuples may be constructed in a number of ways:

   * Using a pair of parentheses to denote the empty tuple: "()"

   * Using a trailing comma for a singleton tuple: "a," or "(a,)"

   * Separating items with commas: "a, b, c" or "(a, b, c)"

   * Using the "tuple()" built-in: "tuple()" or "tuple(iterable)"

   The constructor builds a tuple whose items are the same and in the
   same order as *iterable*’s items.  *iterable* may be either a
   sequence, a container that supports iteration, or an iterator
   object.  If *iterable* is already a tuple, it is returned
   unchanged. For example, "tuple('abc')" returns "('a', 'b', 'c')"
   and "tuple( [1, 2, 3] )" returns "(1, 2, 3)". If no argument is
   given, the constructor creates a new empty tuple, "()".

   Note that it is actually the comma which makes a tuple, not the
   parentheses. The parentheses are optional, except in the empty
   tuple case, or when they are needed to avoid syntactic ambiguity.
   For example, "f(a, b, c)" is a function call with three arguments,
   while "f((a, b, c))" is a function call with a 3-tuple as the sole
   argument.

   Tuples implement all of the common sequence operations.

For heterogeneous collections of data where access by name is clearer
than access by index, "collections.namedtuple()" may be a more
appropriate choice than a simple tuple object.


Ranges
======

The "range" type represents an immutable sequence of numbers and is
commonly used for looping a specific number of times in "for" loops.

class range(stop)
class range(start, stop[, step])

   The arguments to the range constructor must be integers (either
   built-in "int" or any object that implements the "__index__()"
   special method).  If the *step* argument is omitted, it defaults to
   "1". If the *start* argument is omitted, it defaults to "0". If
   *step* is zero, "ValueError" is raised.

   For a positive *step*, the contents of a range "r" are determined
   by the formula "r[i] = start + step*i" where "i >= 0" and "r[i] <
   stop".

   For a negative *step*, the contents of the range are still
   determined by the formula "r[i] = start + step*i", but the
   constraints are "i >= 0" and "r[i] > stop".

   A range object will be empty if "r[0]" does not meet the value
   constraint. Ranges do support negative indices, but these are
   interpreted as indexing from the end of the sequence determined by
   the positive indices.

   Ranges containing absolute values larger than "sys.maxsize" are
   permitted but some features (such as "len()") may raise
   "OverflowError".

   Range examples:

      >>> list(range(10))
      [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
      >>> list(range(1, 11))
      [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
      >>> list(range(0, 30, 5))
      [0, 5, 10, 15, 20, 25]
      >>> list(range(0, 10, 3))
      [0, 3, 6, 9]
      >>> list(range(0, -10, -1))
      [0, -1, -2, -3, -4, -5, -6, -7, -8, -9]
      >>> list(range(0))
      []
      >>> list(range(1, 0))
      []

   Ranges implement all of the common sequence operations except
   concatenation and repetition (due to the fact that range objects
   can only represent sequences that follow a strict pattern and
   repetition and concatenation will usually violate that pattern).

   start

      The value of the *start* parameter (or "0" if the parameter was
      not supplied)

   stop

      The value of the *stop* parameter

   step

      The value of the *step* parameter (or "1" if the parameter was
      not supplied)

The advantage of the "range" type over a regular "list" or "tuple" is
that a "range" object will always take the same (small) amount of
memory, no matter the size of the range it represents (as it only
stores the "start", "stop" and "step" values, calculating individual
items and subranges as needed).

Range objects implement the "collections.abc.Sequence" ABC, and
provide features such as containment tests, element index lookup,
slicing and support for negative indices (see Sequence Types — list,
tuple, range):

>>> r = range(0, 20, 2)
>>> r
range(0, 20, 2)
>>> 11 in r
False
>>> 10 in r
True
>>> r.index(10)
5
>>> r[5]
10
>>> r[:5]
range(0, 10, 2)
>>> r[-1]
18

Testing range objects for equality with "==" and "!=" compares them as
sequences.  That is, two range objects are considered equal if they
represent the same sequence of values.  (Note that two range objects
that compare equal might have different "start", "stop" and "step"
attributes, for example "range(0) == range(2, 1, 3)" or "range(0, 3,
2) == range(0, 4, 2)".)

Changed in version 3.2: Implement the Sequence ABC. Support slicing
and negative indices. Test "int" objects for membership in constant
time instead of iterating through all items.

Changed in version 3.3: Define ‘==’ and ‘!=’ to compare range objects
based on the sequence of values they define (instead of comparing
based on object identity).Added the "start", "stop" and "step"
attributes.

See also:

  * The linspace recipe shows how to implement a lazy version of range
    suitable for floating-point applications.
''',
    'typesseq-mutable': r'''Mutable Sequence Types
**********************

The operations in the following table are defined on mutable sequence
types. The "collections.abc.MutableSequence" ABC is provided to make
it easier to correctly implement these operations on custom sequence
types.

In the table *s* is an instance of a mutable sequence type, *t* is any
iterable object and *x* is an arbitrary object that meets any type and
value restrictions imposed by *s* (for example, "bytearray" only
accepts integers that meet the value restriction "0 <= x <= 255").

+--------------------------------+----------------------------------+-----------------------+
| Operation                      | Result                           | Notes                 |
|================================|==================================|=======================|
| "s[i] = x"                     | item *i* of *s* is replaced by   |                       |
|                                | *x*                              |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s[i:j] = t"                   | slice of *s* from *i* to *j* is  |                       |
|                                | replaced by the contents of the  |                       |
|                                | iterable *t*                     |                       |
+--------------------------------+----------------------------------+-----------------------+
| "del s[i:j]"                   | same as "s[i:j] = []"            |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s[i:j:k] = t"                 | the elements of "s[i:j:k]" are   | (1)                   |
|                                | replaced by those of *t*         |                       |
+--------------------------------+----------------------------------+-----------------------+
| "del s[i:j:k]"                 | removes the elements of          |                       |
|                                | "s[i:j:k]" from the list         |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.append(x)"                  | appends *x* to the end of the    |                       |
|                                | sequence (same as                |                       |
|                                | "s[len(s):len(s)] = [x]")        |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.clear()"                    | removes all items from *s* (same | (5)                   |
|                                | as "del s[:]")                   |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.copy()"                     | creates a shallow copy of *s*    | (5)                   |
|                                | (same as "s[:]")                 |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.extend(t)" or "s += t"      | extends *s* with the contents of |                       |
|                                | *t* (for the most part the same  |                       |
|                                | as "s[len(s):len(s)] = t")       |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s *= n"                       | updates *s* with its contents    | (6)                   |
|                                | repeated *n* times               |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.insert(i, x)"               | inserts *x* into *s* at the      |                       |
|                                | index given by *i* (same as      |                       |
|                                | "s[i:i] = [x]")                  |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.pop()" or "s.pop(i)"        | retrieves the item at *i* and    | (2)                   |
|                                | also removes it from *s*         |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.remove(x)"                  | removes the first item from *s*  | (3)                   |
|                                | where "s[i]" is equal to *x*     |                       |
+--------------------------------+----------------------------------+-----------------------+
| "s.reverse()"                  | reverses the items of *s* in     | (4)                   |
|                                | place                            |                       |
+--------------------------------+----------------------------------+-----------------------+

Notes:

1. If *k* is not equal to "1", *t* must have the same length as the
   slice it is replacing.

2. The optional argument *i* defaults to "-1", so that by default the
   last item is removed and returned.

3. "remove()" raises "ValueError" when *x* is not found in *s*.

4. The "reverse()" method modifies the sequence in place for economy
   of space when reversing a large sequence.  To remind users that it
   operates by side effect, it does not return the reversed sequence.

5. "clear()" and "copy()" are included for consistency with the
   interfaces of mutable containers that don’t support slicing
   operations (such as "dict" and "set"). "copy()" is not part of the
   "collections.abc.MutableSequence" ABC, but most concrete mutable
   sequence classes provide it.

   Added in version 3.3: "clear()" and "copy()" methods.

6. The value *n* is an integer, or an object implementing
   "__index__()".  Zero and negative values of *n* clear the sequence.
   Items in the sequence are not copied; they are referenced multiple
   times, as explained for "s * n" under Common Sequence Operations.
''',
    'unary': r'''Unary arithmetic and bitwise operations
***************************************

All unary arithmetic and bitwise operations have the same priority:

   u_expr ::= power | "-" u_expr | "+" u_expr | "~" u_expr

The unary "-" (minus) operator yields the negation of its numeric
argument; the operation can be overridden with the "__neg__()" special
method.

The unary "+" (plus) operator yields its numeric argument unchanged;
the operation can be overridden with the "__pos__()" special method.

The unary "~" (invert) operator yields the bitwise inversion of its
integer argument.  The bitwise inversion of "x" is defined as
"-(x+1)".  It only applies to integral numbers or to custom objects
that override the "__invert__()" special method.

In all three cases, if the argument does not have the proper type, a
"TypeError" exception is raised.
''',
    'while': r'''The "while" statement
*********************

The "while" statement is used for repeated execution as long as an
expression is true:

   while_stmt ::= "while" assignment_expression ":" suite
                  ["else" ":" suite]

This repeatedly tests the expression and, if it is true, executes the
first suite; if the expression is false (which may be the first time
it is tested) the suite of the "else" clause, if present, is executed
and the loop terminates.

A "break" statement executed in the first suite terminates the loop
without executing the "else" clause’s suite.  A "continue" statement
executed in the first suite skips the rest of the suite and goes back
to testing the expression.
''',
    'with': r'''The "with" statement
********************

The "with" statement is used to wrap the execution of a block with
methods defined by a context manager (see section With Statement
Context Managers). This allows common "try"…"except"…"finally" usage
patterns to be encapsulated for convenient reuse.

   with_stmt          ::= "with" ( "(" with_stmt_contents ","? ")" | with_stmt_contents ) ":" suite
   with_stmt_contents ::= with_item ("," with_item)*
   with_item          ::= expression ["as" target]

The execution of the "with" statement with one “item” proceeds as
follows:

1. The context expression (the expression given in the "with_item") is
   evaluated to obtain a context manager.

2. The context manager’s "__enter__()" is loaded for later use.

3. The context manager’s "__exit__()" is loaded for later use.

4. The context manager’s "__enter__()" method is invoked.

5. If a target was included in the "with" statement, the return value
   from "__enter__()" is assigned to it.

   Note:

     The "with" statement guarantees that if the "__enter__()" method
     returns without an error, then "__exit__()" will always be
     called. Thus, if an error occurs during the assignment to the
     target list, it will be treated the same as an error occurring
     within the suite would be. See step 7 below.

6. The suite is executed.

7. The context manager’s "__exit__()" method is invoked.  If an
   exception caused the suite to be exited, its type, value, and
   traceback are passed as arguments to "__exit__()". Otherwise, three
   "None" arguments are supplied.

   If the suite was exited due to an exception, and the return value
   from the "__exit__()" method was false, the exception is reraised.
   If the return value was true, the exception is suppressed, and
   execution continues with the statement following the "with"
   statement.

   If the suite was exited for any reason other than an exception, the
   return value from "__exit__()" is ignored, and execution proceeds
   at the normal location for the kind of exit that was taken.

The following code:

   with EXPRESSION as TARGET:
       SUITE

is semantically equivalent to:

   manager = (EXPRESSION)
   enter = type(manager).__enter__
   exit = type(manager).__exit__
   value = enter(manager)
   hit_except = False

   try:
       TARGET = value
       SUITE
   except:
       hit_except = True
       if not exit(manager, *sys.exc_info()):
           raise
   finally:
       if not hit_except:
           exit(manager, None, None, None)

With more than one item, the context managers are processed as if
multiple "with" statements were nested:

   with A() as a, B() as b:
       SUITE

is semantically equivalent to:

   with A() as a:
       with B() as b:
           SUITE

You can also write multi-item context managers in multiple lines if
the items are surrounded by parentheses. For example:

   with (
       A() as a,
       B() as b,
   ):
       SUITE

Changed in version 3.1: Support for multiple context expressions.

Changed in version 3.10: Support for using grouping parentheses to
break the statement in multiple lines.

See also:

  **PEP 343** - The “with” statement
     The specification, background, and examples for the Python "with"
     statement.
''',
    'yield': r'''The "yield" statement
*********************

   yield_stmt ::= yield_expression

A "yield" statement is semantically equivalent to a yield expression.
The "yield" statement can be used to omit the parentheses that would
otherwise be required in the equivalent yield expression statement.
For example, the yield statements

   yield <expr>
   yield from <expr>

are equivalent to the yield expression statements

   (yield <expr>)
   (yield from <expr>)

Yield expressions and statements are only used when defining a
*generator* function, and are only used in the body of the generator
function.  Using "yield" in a function definition is sufficient to
cause that definition to create a generator function instead of a
normal function.

For full details of "yield" semantics, refer to the Yield expressions
section.
''',
}
