; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefix=RV32
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefix=RV64

declare void @foo()

define void @test_m1(ptr %p, ptr %p2) {
; RV32-LABEL: test_m1:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -48
; RV32-NEXT:    .cfi_def_cfa_offset 48
; RV32-NEXT:    sw ra, 44(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s0, 40(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s1, 36(sp) # 4-byte Folded Spill
; RV32-NEXT:    .cfi_offset ra, -4
; RV32-NEXT:    .cfi_offset s0, -8
; RV32-NEXT:    .cfi_offset s1, -12
; RV32-NEXT:    csrr a2, vlenb
; RV32-NEXT:    sub sp, sp, a2
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x30, 0x22, 0x11, 0x01, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 48 + 1 * vlenb
; RV32-NEXT:    mv s0, a0
; RV32-NEXT:    vl1r.v v8, (a0)
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vs1r.v v8, (a0) # vscale x 8-byte Folded Spill
; RV32-NEXT:    mv s1, a1
; RV32-NEXT:    call foo
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vl1r.v v8, (a0) # vscale x 8-byte Folded Reload
; RV32-NEXT:    vs1r.v v8, (s0)
; RV32-NEXT:    vl1r.v v8, (s1)
; RV32-NEXT:    vs1r.v v8, (a0) # vscale x 8-byte Folded Spill
; RV32-NEXT:    call foo
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vl1r.v v8, (a0) # vscale x 8-byte Folded Reload
; RV32-NEXT:    vs1r.v v8, (s1)
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    .cfi_def_cfa sp, 48
; RV32-NEXT:    lw ra, 44(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s0, 40(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s1, 36(sp) # 4-byte Folded Reload
; RV32-NEXT:    .cfi_restore ra
; RV32-NEXT:    .cfi_restore s0
; RV32-NEXT:    .cfi_restore s1
; RV32-NEXT:    addi sp, sp, 48
; RV32-NEXT:    .cfi_def_cfa_offset 0
; RV32-NEXT:    ret
;
; RV64-LABEL: test_m1:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -64
; RV64-NEXT:    .cfi_def_cfa_offset 64
; RV64-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; RV64-NEXT:    .cfi_offset ra, -8
; RV64-NEXT:    .cfi_offset s0, -16
; RV64-NEXT:    .cfi_offset s1, -24
; RV64-NEXT:    csrr a2, vlenb
; RV64-NEXT:    sub sp, sp, a2
; RV64-NEXT:    .cfi_escape 0x0f, 0x0e, 0x72, 0x00, 0x11, 0xc0, 0x00, 0x22, 0x11, 0x01, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 64 + 1 * vlenb
; RV64-NEXT:    mv s0, a0
; RV64-NEXT:    vl1r.v v8, (a0)
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vs1r.v v8, (a0) # vscale x 8-byte Folded Spill
; RV64-NEXT:    mv s1, a1
; RV64-NEXT:    call foo
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vl1r.v v8, (a0) # vscale x 8-byte Folded Reload
; RV64-NEXT:    vs1r.v v8, (s0)
; RV64-NEXT:    vl1r.v v8, (s1)
; RV64-NEXT:    vs1r.v v8, (a0) # vscale x 8-byte Folded Spill
; RV64-NEXT:    call foo
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vl1r.v v8, (a0) # vscale x 8-byte Folded Reload
; RV64-NEXT:    vs1r.v v8, (s1)
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    .cfi_def_cfa sp, 64
; RV64-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; RV64-NEXT:    .cfi_restore ra
; RV64-NEXT:    .cfi_restore s0
; RV64-NEXT:    .cfi_restore s1
; RV64-NEXT:    addi sp, sp, 64
; RV64-NEXT:    .cfi_def_cfa_offset 0
; RV64-NEXT:    ret
  %v1 = load <vscale x 8 x i8>, ptr %p
  call void @foo();
  store <vscale x 8 x i8> %v1, ptr %p
  %v2 = load <vscale x 8 x i8>, ptr %p2
  call void @foo();
  store <vscale x 8 x i8> %v2, ptr %p2
  ret void
}

define void @test_m2(ptr %p, ptr %p2) {
; RV32-LABEL: test_m2:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -48
; RV32-NEXT:    .cfi_def_cfa_offset 48
; RV32-NEXT:    sw ra, 44(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s0, 40(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s1, 36(sp) # 4-byte Folded Spill
; RV32-NEXT:    .cfi_offset ra, -4
; RV32-NEXT:    .cfi_offset s0, -8
; RV32-NEXT:    .cfi_offset s1, -12
; RV32-NEXT:    csrr a2, vlenb
; RV32-NEXT:    slli a2, a2, 1
; RV32-NEXT:    sub sp, sp, a2
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x30, 0x22, 0x11, 0x02, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 48 + 2 * vlenb
; RV32-NEXT:    mv s0, a0
; RV32-NEXT:    vl2r.v v8, (a0)
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vs2r.v v8, (a0) # vscale x 16-byte Folded Spill
; RV32-NEXT:    mv s1, a1
; RV32-NEXT:    call foo
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vl2r.v v8, (a0) # vscale x 16-byte Folded Reload
; RV32-NEXT:    vs2r.v v8, (s0)
; RV32-NEXT:    vl2r.v v8, (s1)
; RV32-NEXT:    vs2r.v v8, (a0) # vscale x 16-byte Folded Spill
; RV32-NEXT:    call foo
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vl2r.v v8, (a0) # vscale x 16-byte Folded Reload
; RV32-NEXT:    vs2r.v v8, (s1)
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 1
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    .cfi_def_cfa sp, 48
; RV32-NEXT:    lw ra, 44(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s0, 40(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s1, 36(sp) # 4-byte Folded Reload
; RV32-NEXT:    .cfi_restore ra
; RV32-NEXT:    .cfi_restore s0
; RV32-NEXT:    .cfi_restore s1
; RV32-NEXT:    addi sp, sp, 48
; RV32-NEXT:    .cfi_def_cfa_offset 0
; RV32-NEXT:    ret
;
; RV64-LABEL: test_m2:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -64
; RV64-NEXT:    .cfi_def_cfa_offset 64
; RV64-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; RV64-NEXT:    .cfi_offset ra, -8
; RV64-NEXT:    .cfi_offset s0, -16
; RV64-NEXT:    .cfi_offset s1, -24
; RV64-NEXT:    csrr a2, vlenb
; RV64-NEXT:    slli a2, a2, 1
; RV64-NEXT:    sub sp, sp, a2
; RV64-NEXT:    .cfi_escape 0x0f, 0x0e, 0x72, 0x00, 0x11, 0xc0, 0x00, 0x22, 0x11, 0x02, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 64 + 2 * vlenb
; RV64-NEXT:    mv s0, a0
; RV64-NEXT:    vl2r.v v8, (a0)
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vs2r.v v8, (a0) # vscale x 16-byte Folded Spill
; RV64-NEXT:    mv s1, a1
; RV64-NEXT:    call foo
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vl2r.v v8, (a0) # vscale x 16-byte Folded Reload
; RV64-NEXT:    vs2r.v v8, (s0)
; RV64-NEXT:    vl2r.v v8, (s1)
; RV64-NEXT:    vs2r.v v8, (a0) # vscale x 16-byte Folded Spill
; RV64-NEXT:    call foo
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vl2r.v v8, (a0) # vscale x 16-byte Folded Reload
; RV64-NEXT:    vs2r.v v8, (s1)
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    slli a0, a0, 1
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    .cfi_def_cfa sp, 64
; RV64-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; RV64-NEXT:    .cfi_restore ra
; RV64-NEXT:    .cfi_restore s0
; RV64-NEXT:    .cfi_restore s1
; RV64-NEXT:    addi sp, sp, 64
; RV64-NEXT:    .cfi_def_cfa_offset 0
; RV64-NEXT:    ret
  %v1 = load <vscale x 16 x i8>, ptr %p
  call void @foo();
  store <vscale x 16 x i8> %v1, ptr %p
  %v2 = load <vscale x 16 x i8>, ptr %p2
  call void @foo();
  store <vscale x 16 x i8> %v2, ptr %p2
  ret void
}

define void @test_m8(ptr %p, ptr %p2) {
; RV32-LABEL: test_m8:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -48
; RV32-NEXT:    .cfi_def_cfa_offset 48
; RV32-NEXT:    sw ra, 44(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s0, 40(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s1, 36(sp) # 4-byte Folded Spill
; RV32-NEXT:    .cfi_offset ra, -4
; RV32-NEXT:    .cfi_offset s0, -8
; RV32-NEXT:    .cfi_offset s1, -12
; RV32-NEXT:    csrr a2, vlenb
; RV32-NEXT:    slli a2, a2, 3
; RV32-NEXT:    sub sp, sp, a2
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x30, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 48 + 8 * vlenb
; RV32-NEXT:    mv s0, a0
; RV32-NEXT:    vl8r.v v8, (a0)
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vs8r.v v8, (a0) # vscale x 64-byte Folded Spill
; RV32-NEXT:    mv s1, a1
; RV32-NEXT:    call foo
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vl8r.v v8, (a0) # vscale x 64-byte Folded Reload
; RV32-NEXT:    vs8r.v v8, (s0)
; RV32-NEXT:    vl8r.v v8, (s1)
; RV32-NEXT:    vs8r.v v8, (a0) # vscale x 64-byte Folded Spill
; RV32-NEXT:    call foo
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vl8r.v v8, (a0) # vscale x 64-byte Folded Reload
; RV32-NEXT:    vs8r.v v8, (s1)
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 3
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    .cfi_def_cfa sp, 48
; RV32-NEXT:    lw ra, 44(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s0, 40(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s1, 36(sp) # 4-byte Folded Reload
; RV32-NEXT:    .cfi_restore ra
; RV32-NEXT:    .cfi_restore s0
; RV32-NEXT:    .cfi_restore s1
; RV32-NEXT:    addi sp, sp, 48
; RV32-NEXT:    .cfi_def_cfa_offset 0
; RV32-NEXT:    ret
;
; RV64-LABEL: test_m8:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -64
; RV64-NEXT:    .cfi_def_cfa_offset 64
; RV64-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; RV64-NEXT:    .cfi_offset ra, -8
; RV64-NEXT:    .cfi_offset s0, -16
; RV64-NEXT:    .cfi_offset s1, -24
; RV64-NEXT:    csrr a2, vlenb
; RV64-NEXT:    slli a2, a2, 3
; RV64-NEXT:    sub sp, sp, a2
; RV64-NEXT:    .cfi_escape 0x0f, 0x0e, 0x72, 0x00, 0x11, 0xc0, 0x00, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 64 + 8 * vlenb
; RV64-NEXT:    mv s0, a0
; RV64-NEXT:    vl8r.v v8, (a0)
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vs8r.v v8, (a0) # vscale x 64-byte Folded Spill
; RV64-NEXT:    mv s1, a1
; RV64-NEXT:    call foo
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vl8r.v v8, (a0) # vscale x 64-byte Folded Reload
; RV64-NEXT:    vs8r.v v8, (s0)
; RV64-NEXT:    vl8r.v v8, (s1)
; RV64-NEXT:    vs8r.v v8, (a0) # vscale x 64-byte Folded Spill
; RV64-NEXT:    call foo
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vl8r.v v8, (a0) # vscale x 64-byte Folded Reload
; RV64-NEXT:    vs8r.v v8, (s1)
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    slli a0, a0, 3
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    .cfi_def_cfa sp, 64
; RV64-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; RV64-NEXT:    .cfi_restore ra
; RV64-NEXT:    .cfi_restore s0
; RV64-NEXT:    .cfi_restore s1
; RV64-NEXT:    addi sp, sp, 64
; RV64-NEXT:    .cfi_def_cfa_offset 0
; RV64-NEXT:    ret
  %v1 = load <vscale x 64 x i8>, ptr %p
  call void @foo();
  store <vscale x 64 x i8> %v1, ptr %p
  %v2 = load <vscale x 64 x i8>, ptr %p2
  call void @foo();
  store <vscale x 64 x i8> %v2, ptr %p2
  ret void
}

define void @test_m1_then_m1(ptr %p, ptr %p2) {
; RV32-LABEL: test_m1_then_m1:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -48
; RV32-NEXT:    .cfi_def_cfa_offset 48
; RV32-NEXT:    sw ra, 44(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s0, 40(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s1, 36(sp) # 4-byte Folded Spill
; RV32-NEXT:    .cfi_offset ra, -4
; RV32-NEXT:    .cfi_offset s0, -8
; RV32-NEXT:    .cfi_offset s1, -12
; RV32-NEXT:    csrr a2, vlenb
; RV32-NEXT:    slli a2, a2, 1
; RV32-NEXT:    sub sp, sp, a2
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x30, 0x22, 0x11, 0x02, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 48 + 2 * vlenb
; RV32-NEXT:    mv s0, a0
; RV32-NEXT:    vl2r.v v8, (a0)
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vs2r.v v8, (a0) # vscale x 16-byte Folded Spill
; RV32-NEXT:    mv s1, a1
; RV32-NEXT:    call foo
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vl2r.v v8, (a0) # vscale x 16-byte Folded Reload
; RV32-NEXT:    vs2r.v v8, (s0)
; RV32-NEXT:    vl1r.v v8, (s1)
; RV32-NEXT:    vs1r.v v8, (a0) # vscale x 8-byte Folded Spill
; RV32-NEXT:    call foo
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vl1r.v v8, (a0) # vscale x 8-byte Folded Reload
; RV32-NEXT:    vs1r.v v8, (s1)
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 1
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    .cfi_def_cfa sp, 48
; RV32-NEXT:    lw ra, 44(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s0, 40(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s1, 36(sp) # 4-byte Folded Reload
; RV32-NEXT:    .cfi_restore ra
; RV32-NEXT:    .cfi_restore s0
; RV32-NEXT:    .cfi_restore s1
; RV32-NEXT:    addi sp, sp, 48
; RV32-NEXT:    .cfi_def_cfa_offset 0
; RV32-NEXT:    ret
;
; RV64-LABEL: test_m1_then_m1:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -64
; RV64-NEXT:    .cfi_def_cfa_offset 64
; RV64-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; RV64-NEXT:    .cfi_offset ra, -8
; RV64-NEXT:    .cfi_offset s0, -16
; RV64-NEXT:    .cfi_offset s1, -24
; RV64-NEXT:    csrr a2, vlenb
; RV64-NEXT:    slli a2, a2, 1
; RV64-NEXT:    sub sp, sp, a2
; RV64-NEXT:    .cfi_escape 0x0f, 0x0e, 0x72, 0x00, 0x11, 0xc0, 0x00, 0x22, 0x11, 0x02, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 64 + 2 * vlenb
; RV64-NEXT:    mv s0, a0
; RV64-NEXT:    vl2r.v v8, (a0)
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vs2r.v v8, (a0) # vscale x 16-byte Folded Spill
; RV64-NEXT:    mv s1, a1
; RV64-NEXT:    call foo
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vl2r.v v8, (a0) # vscale x 16-byte Folded Reload
; RV64-NEXT:    vs2r.v v8, (s0)
; RV64-NEXT:    vl1r.v v8, (s1)
; RV64-NEXT:    vs1r.v v8, (a0) # vscale x 8-byte Folded Spill
; RV64-NEXT:    call foo
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vl1r.v v8, (a0) # vscale x 8-byte Folded Reload
; RV64-NEXT:    vs1r.v v8, (s1)
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    slli a0, a0, 1
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    .cfi_def_cfa sp, 64
; RV64-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; RV64-NEXT:    .cfi_restore ra
; RV64-NEXT:    .cfi_restore s0
; RV64-NEXT:    .cfi_restore s1
; RV64-NEXT:    addi sp, sp, 64
; RV64-NEXT:    .cfi_def_cfa_offset 0
; RV64-NEXT:    ret
  %v1 = load <vscale x 16 x i8>, ptr %p
  call void @foo();
  store <vscale x 16 x i8> %v1, ptr %p
  %v2 = load <vscale x 8 x i8>, ptr %p2
  call void @foo();
  store <vscale x 8 x i8> %v2, ptr %p2
  ret void
}

define void @test_m1_then_m2(ptr %p, ptr %p2) {
; RV32-LABEL: test_m1_then_m2:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -48
; RV32-NEXT:    .cfi_def_cfa_offset 48
; RV32-NEXT:    sw ra, 44(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s0, 40(sp) # 4-byte Folded Spill
; RV32-NEXT:    sw s1, 36(sp) # 4-byte Folded Spill
; RV32-NEXT:    .cfi_offset ra, -4
; RV32-NEXT:    .cfi_offset s0, -8
; RV32-NEXT:    .cfi_offset s1, -12
; RV32-NEXT:    csrr a2, vlenb
; RV32-NEXT:    slli a2, a2, 1
; RV32-NEXT:    sub sp, sp, a2
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x30, 0x22, 0x11, 0x02, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 48 + 2 * vlenb
; RV32-NEXT:    mv s0, a0
; RV32-NEXT:    vl1r.v v8, (a0)
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vs1r.v v8, (a0) # vscale x 8-byte Folded Spill
; RV32-NEXT:    mv s1, a1
; RV32-NEXT:    call foo
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vl1r.v v8, (a0) # vscale x 8-byte Folded Reload
; RV32-NEXT:    vs1r.v v8, (s0)
; RV32-NEXT:    vl2r.v v8, (s1)
; RV32-NEXT:    vs2r.v v8, (a0) # vscale x 16-byte Folded Spill
; RV32-NEXT:    call foo
; RV32-NEXT:    addi a0, sp, 32
; RV32-NEXT:    vl2r.v v8, (a0) # vscale x 16-byte Folded Reload
; RV32-NEXT:    vs2r.v v8, (s1)
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 1
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    .cfi_def_cfa sp, 48
; RV32-NEXT:    lw ra, 44(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s0, 40(sp) # 4-byte Folded Reload
; RV32-NEXT:    lw s1, 36(sp) # 4-byte Folded Reload
; RV32-NEXT:    .cfi_restore ra
; RV32-NEXT:    .cfi_restore s0
; RV32-NEXT:    .cfi_restore s1
; RV32-NEXT:    addi sp, sp, 48
; RV32-NEXT:    .cfi_def_cfa_offset 0
; RV32-NEXT:    ret
;
; RV64-LABEL: test_m1_then_m2:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -64
; RV64-NEXT:    .cfi_def_cfa_offset 64
; RV64-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; RV64-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; RV64-NEXT:    .cfi_offset ra, -8
; RV64-NEXT:    .cfi_offset s0, -16
; RV64-NEXT:    .cfi_offset s1, -24
; RV64-NEXT:    csrr a2, vlenb
; RV64-NEXT:    slli a2, a2, 1
; RV64-NEXT:    sub sp, sp, a2
; RV64-NEXT:    .cfi_escape 0x0f, 0x0e, 0x72, 0x00, 0x11, 0xc0, 0x00, 0x22, 0x11, 0x02, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 64 + 2 * vlenb
; RV64-NEXT:    mv s0, a0
; RV64-NEXT:    vl1r.v v8, (a0)
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vs1r.v v8, (a0) # vscale x 8-byte Folded Spill
; RV64-NEXT:    mv s1, a1
; RV64-NEXT:    call foo
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vl1r.v v8, (a0) # vscale x 8-byte Folded Reload
; RV64-NEXT:    vs1r.v v8, (s0)
; RV64-NEXT:    vl2r.v v8, (s1)
; RV64-NEXT:    vs2r.v v8, (a0) # vscale x 16-byte Folded Spill
; RV64-NEXT:    call foo
; RV64-NEXT:    addi a0, sp, 32
; RV64-NEXT:    vl2r.v v8, (a0) # vscale x 16-byte Folded Reload
; RV64-NEXT:    vs2r.v v8, (s1)
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    slli a0, a0, 1
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    .cfi_def_cfa sp, 64
; RV64-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; RV64-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; RV64-NEXT:    .cfi_restore ra
; RV64-NEXT:    .cfi_restore s0
; RV64-NEXT:    .cfi_restore s1
; RV64-NEXT:    addi sp, sp, 64
; RV64-NEXT:    .cfi_def_cfa_offset 0
; RV64-NEXT:    ret
  %v1 = load <vscale x 8 x i8>, ptr %p
  call void @foo();
  store <vscale x 8 x i8> %v1, ptr %p
  %v2 = load <vscale x 16 x i8>, ptr %p2
  call void @foo();
  store <vscale x 16 x i8> %v2, ptr %p2
  ret void
}
