# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=sapphirerapids -instruction-tables < %s | FileCheck %s

andn        %eax, %ebx, %ecx
andn        (%rax), %ebx, %ecx

andn        %rax, %rbx, %rcx
andn        (%rax), %rbx, %rcx

bextr       %eax, %ebx, %ecx
bextr       %eax, (%rbx), %ecx

bextr       %rax, %rbx, %rcx
bextr       %rax, (%rbx), %rcx

blsi        %eax, %ecx
blsi        (%rax), %ecx

blsi        %rax, %rcx
blsi        (%rax), %rcx

blsmsk      %eax, %ecx
blsmsk      (%rax), %ecx

blsmsk      %rax, %rcx
blsmsk      (%rax), %rcx

blsr        %eax, %ecx
blsr        (%rax), %ecx

blsr        %rax, %rcx
blsr        (%rax), %rcx

tzcnt       %ax, %cx
tzcnt       (%rax), %cx

tzcnt       %eax, %ecx
tzcnt       (%rax), %ecx

tzcnt       %rax, %rcx
tzcnt       (%rax), %rcx

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      2     0.33                        andnl	%eax, %ebx, %ecx
# CHECK-NEXT:  2      7     0.33    *                   andnl	(%rax), %ebx, %ecx
# CHECK-NEXT:  1      2     0.33                        andnq	%rax, %rbx, %rcx
# CHECK-NEXT:  2      7     0.33    *                   andnq	(%rax), %rbx, %rcx
# CHECK-NEXT:  2      6     1.00                        bextrl	%eax, %ebx, %ecx
# CHECK-NEXT:  3      11    1.00    *                   bextrl	%eax, (%rbx), %ecx
# CHECK-NEXT:  2      6     1.00                        bextrq	%rax, %rbx, %rcx
# CHECK-NEXT:  3      11    1.00    *                   bextrq	%rax, (%rbx), %rcx
# CHECK-NEXT:  1      2     0.33                        blsil	%eax, %ecx
# CHECK-NEXT:  2      7     0.33    *                   blsil	(%rax), %ecx
# CHECK-NEXT:  1      2     0.33                        blsiq	%rax, %rcx
# CHECK-NEXT:  2      7     0.33    *                   blsiq	(%rax), %rcx
# CHECK-NEXT:  1      2     0.33                        blsmskl	%eax, %ecx
# CHECK-NEXT:  2      7     0.33    *                   blsmskl	(%rax), %ecx
# CHECK-NEXT:  1      2     0.33                        blsmskq	%rax, %rcx
# CHECK-NEXT:  2      7     0.33    *                   blsmskq	(%rax), %rcx
# CHECK-NEXT:  1      2     0.33                        blsrl	%eax, %ecx
# CHECK-NEXT:  2      7     0.33    *                   blsrl	(%rax), %ecx
# CHECK-NEXT:  1      2     0.33                        blsrq	%rax, %rcx
# CHECK-NEXT:  2      7     0.33    *                   blsrq	(%rax), %rcx
# CHECK-NEXT:  1      3     1.00                        tzcntw	%ax, %cx
# CHECK-NEXT:  2      8     1.00    *                   tzcntw	(%rax), %cx
# CHECK-NEXT:  1      3     1.00                        tzcntl	%eax, %ecx
# CHECK-NEXT:  2      8     1.00    *                   tzcntl	(%rax), %ecx
# CHECK-NEXT:  1      3     1.00                        tzcntq	%rax, %rcx
# CHECK-NEXT:  2      8     1.00    *                   tzcntq	(%rax), %rcx

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SPRPort00
# CHECK-NEXT: [1]   - SPRPort01
# CHECK-NEXT: [2]   - SPRPort02
# CHECK-NEXT: [3]   - SPRPort03
# CHECK-NEXT: [4]   - SPRPort04
# CHECK-NEXT: [5]   - SPRPort05
# CHECK-NEXT: [6]   - SPRPort06
# CHECK-NEXT: [7]   - SPRPort07
# CHECK-NEXT: [8]   - SPRPort08
# CHECK-NEXT: [9]   - SPRPort09
# CHECK-NEXT: [10]  - SPRPort10
# CHECK-NEXT: [11]  - SPRPort11
# CHECK-NEXT: [12]  - SPRPortInvalid

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]
# CHECK-NEXT: 2.00   15.33  4.33   4.33    -     5.33   2.00    -      -      -     4.33   5.33    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   Instructions:
# CHECK-NEXT:  -     0.33    -      -      -     0.33    -      -      -      -      -     0.33    -     andnl	%eax, %ebx, %ecx
# CHECK-NEXT:  -     0.33   0.33   0.33    -     0.33    -      -      -      -     0.33   0.33    -     andnl	(%rax), %ebx, %ecx
# CHECK-NEXT:  -     0.33    -      -      -     0.33    -      -      -      -      -     0.33    -     andnq	%rax, %rbx, %rcx
# CHECK-NEXT:  -     0.33   0.33   0.33    -     0.33    -      -      -      -     0.33   0.33    -     andnq	(%rax), %rbx, %rcx
# CHECK-NEXT: 0.50   1.00    -      -      -      -     0.50    -      -      -      -      -      -     bextrl	%eax, %ebx, %ecx
# CHECK-NEXT: 0.50   1.00   0.33   0.33    -      -     0.50    -      -      -     0.33    -      -     bextrl	%eax, (%rbx), %ecx
# CHECK-NEXT: 0.50   1.00    -      -      -      -     0.50    -      -      -      -      -      -     bextrq	%rax, %rbx, %rcx
# CHECK-NEXT: 0.50   1.00   0.33   0.33    -      -     0.50    -      -      -     0.33    -      -     bextrq	%rax, (%rbx), %rcx
# CHECK-NEXT:  -     0.33    -      -      -     0.33    -      -      -      -      -     0.33    -     blsil	%eax, %ecx
# CHECK-NEXT:  -     0.33   0.33   0.33    -     0.33    -      -      -      -     0.33   0.33    -     blsil	(%rax), %ecx
# CHECK-NEXT:  -     0.33    -      -      -     0.33    -      -      -      -      -     0.33    -     blsiq	%rax, %rcx
# CHECK-NEXT:  -     0.33   0.33   0.33    -     0.33    -      -      -      -     0.33   0.33    -     blsiq	(%rax), %rcx
# CHECK-NEXT:  -     0.33    -      -      -     0.33    -      -      -      -      -     0.33    -     blsmskl	%eax, %ecx
# CHECK-NEXT:  -     0.33   0.33   0.33    -     0.33    -      -      -      -     0.33   0.33    -     blsmskl	(%rax), %ecx
# CHECK-NEXT:  -     0.33    -      -      -     0.33    -      -      -      -      -     0.33    -     blsmskq	%rax, %rcx
# CHECK-NEXT:  -     0.33   0.33   0.33    -     0.33    -      -      -      -     0.33   0.33    -     blsmskq	(%rax), %rcx
# CHECK-NEXT:  -     0.33    -      -      -     0.33    -      -      -      -      -     0.33    -     blsrl	%eax, %ecx
# CHECK-NEXT:  -     0.33   0.33   0.33    -     0.33    -      -      -      -     0.33   0.33    -     blsrl	(%rax), %ecx
# CHECK-NEXT:  -     0.33    -      -      -     0.33    -      -      -      -      -     0.33    -     blsrq	%rax, %rcx
# CHECK-NEXT:  -     0.33   0.33   0.33    -     0.33    -      -      -      -     0.33   0.33    -     blsrq	(%rax), %rcx
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -      -      -      -      -     tzcntw	%ax, %cx
# CHECK-NEXT:  -     1.00   0.33   0.33    -      -      -      -      -      -     0.33    -      -     tzcntw	(%rax), %cx
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -      -      -      -      -     tzcntl	%eax, %ecx
# CHECK-NEXT:  -     1.00   0.33   0.33    -      -      -      -      -      -     0.33    -      -     tzcntl	(%rax), %ecx
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -      -      -      -      -     tzcntq	%rax, %rcx
# CHECK-NEXT:  -     1.00   0.33   0.33    -      -      -      -      -      -     0.33    -      -     tzcntq	(%rax), %rcx
