// RUN: llvm-mc -triple x86_64 --show-encoding %s | FileCheck %s

// CHECK: vcvttsd2sis %xmm22, %ecx
// CHECK: encoding: [0x62,0xb5,0x7f,0x08,0x6d,0xce]
          vcvttsd2sis %xmm22, %ecx

// CHECK: vcvttsd2sis {sae}, %xmm22, %ecx
// CHECK: encoding: [0x62,0xb5,0x7f,0x18,0x6d,0xce]
          vcvttsd2sis {sae}, %xmm22, %ecx

// CHECK: vcvttsd2sis %xmm22, %r9
// CHECK: encoding: [0x62,0x35,0xff,0x08,0x6d,0xce]
          vcvttsd2sis %xmm22, %r9

// CHECK: vcvttsd2sis {sae}, %xmm22, %r9
// CHECK: encoding: [0x62,0x35,0xff,0x18,0x6d,0xce]
          vcvttsd2sis {sae}, %xmm22, %r9

// CHECK: vcvttsd2sis  268435456(%rbp,%r14,8), %ecx
// CHECK: encoding: [0x62,0xb5,0x7f,0x08,0x6d,0x8c,0xf5,0x00,0x00,0x00,0x10]
          vcvttsd2sis  268435456(%rbp,%r14,8), %ecx

// CHECK: vcvttsd2sis  291(%r8,%rax,4), %ecx
// CHECK: encoding: [0x62,0xd5,0x7f,0x08,0x6d,0x8c,0x80,0x23,0x01,0x00,0x00]
          vcvttsd2sis  291(%r8,%rax,4), %ecx

// CHECK: vcvttsd2sis  (%rip), %ecx
// CHECK: encoding: [0x62,0xf5,0x7f,0x08,0x6d,0x0d,0x00,0x00,0x00,0x00]
          vcvttsd2sis  (%rip), %ecx

// CHECK: vcvttsd2sis  -256(,%rbp,2), %ecx
// CHECK: encoding: [0x62,0xf5,0x7f,0x08,0x6d,0x0c,0x6d,0x00,0xff,0xff,0xff]
          vcvttsd2sis  -256(,%rbp,2), %ecx

// CHECK: vcvttsd2sis  1016(%rcx), %ecx
// CHECK: encoding: [0x62,0xf5,0x7f,0x08,0x6d,0x49,0x7f]
          vcvttsd2sis  1016(%rcx), %ecx

// CHECK: vcvttsd2sis  -1024(%rdx), %ecx
// CHECK: encoding: [0x62,0xf5,0x7f,0x08,0x6d,0x4a,0x80]
          vcvttsd2sis  -1024(%rdx), %ecx

// CHECK: vcvttsd2sis  268435456(%rbp,%r14,8), %r9
// CHECK: encoding: [0x62,0x35,0xff,0x08,0x6d,0x8c,0xf5,0x00,0x00,0x00,0x10]
          vcvttsd2sis  268435456(%rbp,%r14,8), %r9

// CHECK: vcvttsd2sis  291(%r8,%rax,4), %r9
// CHECK: encoding: [0x62,0x55,0xff,0x08,0x6d,0x8c,0x80,0x23,0x01,0x00,0x00]
          vcvttsd2sis  291(%r8,%rax,4), %r9

// CHECK: vcvttsd2sis  (%rip), %r9
// CHECK: encoding: [0x62,0x75,0xff,0x08,0x6d,0x0d,0x00,0x00,0x00,0x00]
          vcvttsd2sis  (%rip), %r9

// CHECK: vcvttsd2sis  -256(,%rbp,2), %r9
// CHECK: encoding: [0x62,0x75,0xff,0x08,0x6d,0x0c,0x6d,0x00,0xff,0xff,0xff]
          vcvttsd2sis  -256(,%rbp,2), %r9

// CHECK: vcvttsd2sis  1016(%rcx), %r9
// CHECK: encoding: [0x62,0x75,0xff,0x08,0x6d,0x49,0x7f]
          vcvttsd2sis  1016(%rcx), %r9

// CHECK: vcvttsd2sis  -1024(%rdx), %r9
// CHECK: encoding: [0x62,0x75,0xff,0x08,0x6d,0x4a,0x80]
          vcvttsd2sis  -1024(%rdx), %r9

// CHECK: vcvttsd2usis %xmm22, %ecx
// CHECK: encoding: [0x62,0xb5,0x7f,0x08,0x6c,0xce]
          vcvttsd2usis %xmm22, %ecx

// CHECK: vcvttsd2usis {sae}, %xmm22, %ecx
// CHECK: encoding: [0x62,0xb5,0x7f,0x18,0x6c,0xce]
          vcvttsd2usis {sae}, %xmm22, %ecx

// CHECK: vcvttsd2usis %xmm22, %r9
// CHECK: encoding: [0x62,0x35,0xff,0x08,0x6c,0xce]
          vcvttsd2usis %xmm22, %r9

// CHECK: vcvttsd2usis {sae}, %xmm22, %r9
// CHECK: encoding: [0x62,0x35,0xff,0x18,0x6c,0xce]
          vcvttsd2usis {sae}, %xmm22, %r9

// CHECK: vcvttsd2usis  268435456(%rbp,%r14,8), %ecx
// CHECK: encoding: [0x62,0xb5,0x7f,0x08,0x6c,0x8c,0xf5,0x00,0x00,0x00,0x10]
          vcvttsd2usis  268435456(%rbp,%r14,8), %ecx

// CHECK: vcvttsd2usis  291(%r8,%rax,4), %ecx
// CHECK: encoding: [0x62,0xd5,0x7f,0x08,0x6c,0x8c,0x80,0x23,0x01,0x00,0x00]
          vcvttsd2usis  291(%r8,%rax,4), %ecx

// CHECK: vcvttsd2usis  (%rip), %ecx
// CHECK: encoding: [0x62,0xf5,0x7f,0x08,0x6c,0x0d,0x00,0x00,0x00,0x00]
          vcvttsd2usis  (%rip), %ecx

// CHECK: vcvttsd2usis  -256(,%rbp,2), %ecx
// CHECK: encoding: [0x62,0xf5,0x7f,0x08,0x6c,0x0c,0x6d,0x00,0xff,0xff,0xff]
          vcvttsd2usis  -256(,%rbp,2), %ecx

// CHECK: vcvttsd2usis  1016(%rcx), %ecx
// CHECK: encoding: [0x62,0xf5,0x7f,0x08,0x6c,0x49,0x7f]
          vcvttsd2usis  1016(%rcx), %ecx

// CHECK: vcvttsd2usis  -1024(%rdx), %ecx
// CHECK: encoding: [0x62,0xf5,0x7f,0x08,0x6c,0x4a,0x80]
          vcvttsd2usis  -1024(%rdx), %ecx

// CHECK: vcvttsd2usis  268435456(%rbp,%r14,8), %r9
// CHECK: encoding: [0x62,0x35,0xff,0x08,0x6c,0x8c,0xf5,0x00,0x00,0x00,0x10]
          vcvttsd2usis  268435456(%rbp,%r14,8), %r9

// CHECK: vcvttsd2usis  291(%r8,%rax,4), %r9
// CHECK: encoding: [0x62,0x55,0xff,0x08,0x6c,0x8c,0x80,0x23,0x01,0x00,0x00]
          vcvttsd2usis  291(%r8,%rax,4), %r9

// CHECK: vcvttsd2usis  (%rip), %r9
// CHECK: encoding: [0x62,0x75,0xff,0x08,0x6c,0x0d,0x00,0x00,0x00,0x00]
          vcvttsd2usis  (%rip), %r9

// CHECK: vcvttsd2usis  -256(,%rbp,2), %r9
// CHECK: encoding: [0x62,0x75,0xff,0x08,0x6c,0x0c,0x6d,0x00,0xff,0xff,0xff]
          vcvttsd2usis  -256(,%rbp,2), %r9

// CHECK: vcvttsd2usis  1016(%rcx), %r9
// CHECK: encoding: [0x62,0x75,0xff,0x08,0x6c,0x49,0x7f]
          vcvttsd2usis  1016(%rcx), %r9

// CHECK: vcvttsd2usis  -1024(%rdx), %r9
// CHECK: encoding: [0x62,0x75,0xff,0x08,0x6c,0x4a,0x80]
          vcvttsd2usis  -1024(%rdx), %r9

// CHECK: vcvttss2sis %xmm22, %ecx
// CHECK: encoding: [0x62,0xb5,0x7e,0x08,0x6d,0xce]
          vcvttss2sis %xmm22, %ecx

// CHECK: vcvttss2sis {sae}, %xmm22, %ecx
// CHECK: encoding: [0x62,0xb5,0x7e,0x18,0x6d,0xce]
          vcvttss2sis {sae}, %xmm22, %ecx

// CHECK: vcvttss2sis %xmm22, %r9
// CHECK: encoding: [0x62,0x35,0xfe,0x08,0x6d,0xce]
          vcvttss2sis %xmm22, %r9

// CHECK: vcvttss2sis {sae}, %xmm22, %r9
// CHECK: encoding: [0x62,0x35,0xfe,0x18,0x6d,0xce]
          vcvttss2sis {sae}, %xmm22, %r9

// CHECK: vcvttss2sis  268435456(%rbp,%r14,8), %ecx
// CHECK: encoding: [0x62,0xb5,0x7e,0x08,0x6d,0x8c,0xf5,0x00,0x00,0x00,0x10]
          vcvttss2sis  268435456(%rbp,%r14,8), %ecx

// CHECK: vcvttss2sis  291(%r8,%rax,4), %ecx
// CHECK: encoding: [0x62,0xd5,0x7e,0x08,0x6d,0x8c,0x80,0x23,0x01,0x00,0x00]
          vcvttss2sis  291(%r8,%rax,4), %ecx

// CHECK: vcvttss2sis  (%rip), %ecx
// CHECK: encoding: [0x62,0xf5,0x7e,0x08,0x6d,0x0d,0x00,0x00,0x00,0x00]
          vcvttss2sis  (%rip), %ecx

// CHECK: vcvttss2sis  -128(,%rbp,2), %ecx
// CHECK: encoding: [0x62,0xf5,0x7e,0x08,0x6d,0x0c,0x6d,0x80,0xff,0xff,0xff]
          vcvttss2sis  -128(,%rbp,2), %ecx

// CHECK: vcvttss2sis  508(%rcx), %ecx
// CHECK: encoding: [0x62,0xf5,0x7e,0x08,0x6d,0x49,0x7f]
          vcvttss2sis  508(%rcx), %ecx

// CHECK: vcvttss2sis  -512(%rdx), %ecx
// CHECK: encoding: [0x62,0xf5,0x7e,0x08,0x6d,0x4a,0x80]
          vcvttss2sis  -512(%rdx), %ecx

// CHECK: vcvttss2sis  268435456(%rbp,%r14,8), %r9
// CHECK: encoding: [0x62,0x35,0xfe,0x08,0x6d,0x8c,0xf5,0x00,0x00,0x00,0x10]
          vcvttss2sis  268435456(%rbp,%r14,8), %r9

// CHECK: vcvttss2sis  291(%r8,%rax,4), %r9
// CHECK: encoding: [0x62,0x55,0xfe,0x08,0x6d,0x8c,0x80,0x23,0x01,0x00,0x00]
          vcvttss2sis  291(%r8,%rax,4), %r9

// CHECK: vcvttss2sis  (%rip), %r9
// CHECK: encoding: [0x62,0x75,0xfe,0x08,0x6d,0x0d,0x00,0x00,0x00,0x00]
          vcvttss2sis  (%rip), %r9

// CHECK: vcvttss2sis  -128(,%rbp,2), %r9
// CHECK: encoding: [0x62,0x75,0xfe,0x08,0x6d,0x0c,0x6d,0x80,0xff,0xff,0xff]
          vcvttss2sis  -128(,%rbp,2), %r9

// CHECK: vcvttss2sis  508(%rcx), %r9
// CHECK: encoding: [0x62,0x75,0xfe,0x08,0x6d,0x49,0x7f]
          vcvttss2sis  508(%rcx), %r9

// CHECK: vcvttss2sis  -512(%rdx), %r9
// CHECK: encoding: [0x62,0x75,0xfe,0x08,0x6d,0x4a,0x80]
          vcvttss2sis  -512(%rdx), %r9

// CHECK: vcvttss2usis %xmm22, %ecx
// CHECK: encoding: [0x62,0xb5,0x7e,0x08,0x6c,0xce]
          vcvttss2usis %xmm22, %ecx

// CHECK: vcvttss2usis {sae}, %xmm22, %ecx
// CHECK: encoding: [0x62,0xb5,0x7e,0x18,0x6c,0xce]
          vcvttss2usis {sae}, %xmm22, %ecx

// CHECK: vcvttss2usis %xmm22, %r9
// CHECK: encoding: [0x62,0x35,0xfe,0x08,0x6c,0xce]
          vcvttss2usis %xmm22, %r9

// CHECK: vcvttss2usis {sae}, %xmm22, %r9
// CHECK: encoding: [0x62,0x35,0xfe,0x18,0x6c,0xce]
          vcvttss2usis {sae}, %xmm22, %r9

// CHECK: vcvttss2usis  268435456(%rbp,%r14,8), %ecx
// CHECK: encoding: [0x62,0xb5,0x7e,0x08,0x6c,0x8c,0xf5,0x00,0x00,0x00,0x10]
          vcvttss2usis  268435456(%rbp,%r14,8), %ecx

// CHECK: vcvttss2usis  291(%r8,%rax,4), %ecx
// CHECK: encoding: [0x62,0xd5,0x7e,0x08,0x6c,0x8c,0x80,0x23,0x01,0x00,0x00]
          vcvttss2usis  291(%r8,%rax,4), %ecx

// CHECK: vcvttss2usis  (%rip), %ecx
// CHECK: encoding: [0x62,0xf5,0x7e,0x08,0x6c,0x0d,0x00,0x00,0x00,0x00]
          vcvttss2usis  (%rip), %ecx

// CHECK: vcvttss2usis  -128(,%rbp,2), %ecx
// CHECK: encoding: [0x62,0xf5,0x7e,0x08,0x6c,0x0c,0x6d,0x80,0xff,0xff,0xff]
          vcvttss2usis  -128(,%rbp,2), %ecx

// CHECK: vcvttss2usis  508(%rcx), %ecx
// CHECK: encoding: [0x62,0xf5,0x7e,0x08,0x6c,0x49,0x7f]
          vcvttss2usis  508(%rcx), %ecx

// CHECK: vcvttss2usis  -512(%rdx), %ecx
// CHECK: encoding: [0x62,0xf5,0x7e,0x08,0x6c,0x4a,0x80]
          vcvttss2usis  -512(%rdx), %ecx

// CHECK: vcvttss2usis  268435456(%rbp,%r14,8), %r9
// CHECK: encoding: [0x62,0x35,0xfe,0x08,0x6c,0x8c,0xf5,0x00,0x00,0x00,0x10]
          vcvttss2usis  268435456(%rbp,%r14,8), %r9

// CHECK: vcvttss2usis  291(%r8,%rax,4), %r9
// CHECK: encoding: [0x62,0x55,0xfe,0x08,0x6c,0x8c,0x80,0x23,0x01,0x00,0x00]
          vcvttss2usis  291(%r8,%rax,4), %r9

// CHECK: vcvttss2usis  (%rip), %r9
// CHECK: encoding: [0x62,0x75,0xfe,0x08,0x6c,0x0d,0x00,0x00,0x00,0x00]
          vcvttss2usis  (%rip), %r9

// CHECK: vcvttss2usis  -128(,%rbp,2), %r9
// CHECK: encoding: [0x62,0x75,0xfe,0x08,0x6c,0x0c,0x6d,0x80,0xff,0xff,0xff]
          vcvttss2usis  -128(,%rbp,2), %r9

// CHECK: vcvttss2usis  508(%rcx), %r9
// CHECK: encoding: [0x62,0x75,0xfe,0x08,0x6c,0x49,0x7f]
          vcvttss2usis  508(%rcx), %r9

// CHECK: vcvttss2usis  -512(%rdx), %r9
// CHECK: encoding: [0x62,0x75,0xfe,0x08,0x6c,0x4a,0x80]
          vcvttss2usis  -512(%rdx), %r9

// CHECK: vcvttpd2dqs %xmm23, %xmm22
// CHECK: encoding: [0x62,0xa5,0xfc,0x08,0x6d,0xf7]
          vcvttpd2dqs %xmm23, %xmm22

// CHECK: vcvttpd2dqs %xmm23, %xmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0xfc,0x0f,0x6d,0xf7]
          vcvttpd2dqs %xmm23, %xmm22 {%k7}

// CHECK: vcvttpd2dqs %xmm23, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0xfc,0x8f,0x6d,0xf7]
          vcvttpd2dqs %xmm23, %xmm22 {%k7} {z}

// CHECK: vcvttpd2dqs %ymm23, %xmm22
// CHECK: encoding: [0x62,0xa5,0xfc,0x28,0x6d,0xf7]
          vcvttpd2dqs %ymm23, %xmm22

// CHECK: vcvttpd2dqs %ymm23, %xmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0xfc,0x2f,0x6d,0xf7]
          vcvttpd2dqs %ymm23, %xmm22 {%k7}

// CHECK: vcvttpd2dqs %zmm23, %ymm22
// CHECK: encoding: [0x62,0xa5,0xfc,0x48,0x6d,0xf7]
          vcvttpd2dqs %zmm23, %ymm22

// CHECK: vcvttpd2dqs {sae}, %zmm23, %ymm22
// CHECK: encoding: [0x62,0xa5,0xfc,0x18,0x6d,0xf7]
          vcvttpd2dqs {sae}, %zmm23, %ymm22

// CHECK: vcvttpd2dqs %zmm23, %ymm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0xfc,0x4f,0x6d,0xf7]
          vcvttpd2dqs %zmm23, %ymm22 {%k7}

// CHECK: vcvttpd2dqs {sae}, %zmm23, %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0xfc,0x9f,0x6d,0xf7]
          vcvttpd2dqs {sae}, %zmm23, %ymm22 {%k7} {z}

// CHECK: vcvttpd2dqsx  268435456(%rbp,%r14,8), %xmm22
// CHECK: encoding: [0x62,0xa5,0xfc,0x08,0x6d,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttpd2dqsx  268435456(%rbp,%r14,8), %xmm22

// CHECK: vcvttpd2dqsx  291(%r8,%rax,4), %xmm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0xfc,0x0f,0x6d,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttpd2dqsx  291(%r8,%rax,4), %xmm22 {%k7}

// CHECK: vcvttpd2dqs  (%rip){1to2}, %xmm22
// CHECK: encoding: [0x62,0xe5,0xfc,0x18,0x6d,0x35,0x00,0x00,0x00,0x00]
          vcvttpd2dqs  (%rip){1to2}, %xmm22

// CHECK: vcvttpd2dqsx  -512(,%rbp,2), %xmm22
// CHECK: encoding: [0x62,0xe5,0xfc,0x08,0x6d,0x34,0x6d,0x00,0xfe,0xff,0xff]
          vcvttpd2dqsx  -512(,%rbp,2), %xmm22

// CHECK: vcvttpd2dqsx  2032(%rcx), %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfc,0x8f,0x6d,0x71,0x7f]
          vcvttpd2dqsx  2032(%rcx), %xmm22 {%k7} {z}

// CHECK: vcvttpd2dqs  -1024(%rdx){1to2}, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfc,0x9f,0x6d,0x72,0x80]
          vcvttpd2dqs  -1024(%rdx){1to2}, %xmm22 {%k7} {z}

// CHECK: vcvttpd2dqs  (%rip){1to4}, %xmm22
// CHECK: encoding: [0x62,0xe5,0xfc,0x38,0x6d,0x35,0x00,0x00,0x00,0x00]
          vcvttpd2dqs  (%rip){1to4}, %xmm22

// CHECK: vcvttpd2dqsy  -1024(,%rbp,2), %xmm22
// CHECK: encoding: [0x62,0xe5,0xfc,0x28,0x6d,0x34,0x6d,0x00,0xfc,0xff,0xff]
          vcvttpd2dqsy  -1024(,%rbp,2), %xmm22

// CHECK: vcvttpd2dqsy  4064(%rcx), %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfc,0xaf,0x6d,0x71,0x7f]
          vcvttpd2dqsy  4064(%rcx), %xmm22 {%k7} {z}

// CHECK: vcvttpd2dqs  -1024(%rdx){1to4}, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfc,0xbf,0x6d,0x72,0x80]
          vcvttpd2dqs  -1024(%rdx){1to4}, %xmm22 {%k7} {z}

// CHECK: vcvttpd2dqs  268435456(%rbp,%r14,8), %ymm22
// CHECK: encoding: [0x62,0xa5,0xfc,0x48,0x6d,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttpd2dqs  268435456(%rbp,%r14,8), %ymm22

// CHECK: vcvttpd2dqs  291(%r8,%rax,4), %ymm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0xfc,0x4f,0x6d,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttpd2dqs  291(%r8,%rax,4), %ymm22 {%k7}

// CHECK: vcvttpd2dqs  (%rip){1to8}, %ymm22
// CHECK: encoding: [0x62,0xe5,0xfc,0x58,0x6d,0x35,0x00,0x00,0x00,0x00]
          vcvttpd2dqs  (%rip){1to8}, %ymm22

// CHECK: vcvttpd2dqs  -2048(,%rbp,2), %ymm22
// CHECK: encoding: [0x62,0xe5,0xfc,0x48,0x6d,0x34,0x6d,0x00,0xf8,0xff,0xff]
          vcvttpd2dqs  -2048(,%rbp,2), %ymm22

// CHECK: vcvttpd2dqs  8128(%rcx), %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfc,0xcf,0x6d,0x71,0x7f]
          vcvttpd2dqs  8128(%rcx), %ymm22 {%k7} {z}

// CHECK: vcvttpd2dqs  -1024(%rdx){1to8}, %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfc,0xdf,0x6d,0x72,0x80]
          vcvttpd2dqs  -1024(%rdx){1to8}, %ymm22 {%k7} {z}

// CHECK: vcvttpd2qqs %xmm23, %xmm22
// CHECK: encoding: [0x62,0xa5,0xfd,0x08,0x6d,0xf7]
          vcvttpd2qqs %xmm23, %xmm22

// CHECK: vcvttpd2qqs %xmm23, %xmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0xfd,0x0f,0x6d,0xf7]
          vcvttpd2qqs %xmm23, %xmm22 {%k7}

// CHECK: vcvttpd2qqs %xmm23, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0xfd,0x8f,0x6d,0xf7]
          vcvttpd2qqs %xmm23, %xmm22 {%k7} {z}

// CHECK: vcvttpd2qqs %ymm23, %ymm22
// CHECK: encoding: [0x62,0xa5,0xfd,0x28,0x6d,0xf7]
          vcvttpd2qqs %ymm23, %ymm22

// CHECK: vcvttpd2qqs %ymm23, %ymm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0xfd,0x2f,0x6d,0xf7]
          vcvttpd2qqs %ymm23, %ymm22 {%k7}

// CHECK: vcvttpd2qqs %zmm23, %zmm22
// CHECK: encoding: [0x62,0xa5,0xfd,0x48,0x6d,0xf7]
          vcvttpd2qqs %zmm23, %zmm22

// CHECK: vcvttpd2qqs {sae}, %zmm23, %zmm22
// CHECK: encoding: [0x62,0xa5,0xfd,0x18,0x6d,0xf7]
          vcvttpd2qqs {sae}, %zmm23, %zmm22

// CHECK: vcvttpd2qqs %zmm23, %zmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0xfd,0x4f,0x6d,0xf7]
          vcvttpd2qqs %zmm23, %zmm22 {%k7}

// CHECK: vcvttpd2qqs {sae}, %zmm23, %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0xfd,0x9f,0x6d,0xf7]
          vcvttpd2qqs {sae}, %zmm23, %zmm22 {%k7} {z}

// CHECK: vcvttpd2qqs  268435456(%rbp,%r14,8), %xmm22
// CHECK: encoding: [0x62,0xa5,0xfd,0x08,0x6d,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttpd2qqs  268435456(%rbp,%r14,8), %xmm22

// CHECK: vcvttpd2qqs  291(%r8,%rax,4), %xmm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0xfd,0x0f,0x6d,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttpd2qqs  291(%r8,%rax,4), %xmm22 {%k7}

// CHECK: vcvttpd2qqs  (%rip){1to2}, %xmm22
// CHECK: encoding: [0x62,0xe5,0xfd,0x18,0x6d,0x35,0x00,0x00,0x00,0x00]
          vcvttpd2qqs  (%rip){1to2}, %xmm22

// CHECK: vcvttpd2qqs  -512(,%rbp,2), %xmm22
// CHECK: encoding: [0x62,0xe5,0xfd,0x08,0x6d,0x34,0x6d,0x00,0xfe,0xff,0xff]
          vcvttpd2qqs  -512(,%rbp,2), %xmm22

// CHECK: vcvttpd2qqs  2032(%rcx), %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfd,0x8f,0x6d,0x71,0x7f]
          vcvttpd2qqs  2032(%rcx), %xmm22 {%k7} {z}

// CHECK: vcvttpd2qqs  -1024(%rdx){1to2}, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfd,0x9f,0x6d,0x72,0x80]
          vcvttpd2qqs  -1024(%rdx){1to2}, %xmm22 {%k7} {z}

// CHECK: vcvttpd2qqs  268435456(%rbp,%r14,8), %ymm22
// CHECK: encoding: [0x62,0xa5,0xfd,0x28,0x6d,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttpd2qqs  268435456(%rbp,%r14,8), %ymm22

// CHECK: vcvttpd2qqs  291(%r8,%rax,4), %ymm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0xfd,0x2f,0x6d,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttpd2qqs  291(%r8,%rax,4), %ymm22 {%k7}

// CHECK: vcvttpd2qqs  (%rip){1to4}, %ymm22
// CHECK: encoding: [0x62,0xe5,0xfd,0x38,0x6d,0x35,0x00,0x00,0x00,0x00]
          vcvttpd2qqs  (%rip){1to4}, %ymm22

// CHECK: vcvttpd2qqs  -1024(,%rbp,2), %ymm22
// CHECK: encoding: [0x62,0xe5,0xfd,0x28,0x6d,0x34,0x6d,0x00,0xfc,0xff,0xff]
          vcvttpd2qqs  -1024(,%rbp,2), %ymm22

// CHECK: vcvttpd2qqs  4064(%rcx), %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfd,0xaf,0x6d,0x71,0x7f]
          vcvttpd2qqs  4064(%rcx), %ymm22 {%k7} {z}

// CHECK: vcvttpd2qqs  -1024(%rdx){1to4}, %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfd,0xbf,0x6d,0x72,0x80]
          vcvttpd2qqs  -1024(%rdx){1to4}, %ymm22 {%k7} {z}

// CHECK: vcvttpd2qqs  268435456(%rbp,%r14,8), %zmm22
// CHECK: encoding: [0x62,0xa5,0xfd,0x48,0x6d,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttpd2qqs  268435456(%rbp,%r14,8), %zmm22

// CHECK: vcvttpd2qqs  291(%r8,%rax,4), %zmm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0xfd,0x4f,0x6d,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttpd2qqs  291(%r8,%rax,4), %zmm22 {%k7}

// CHECK: vcvttpd2qqs  (%rip){1to8}, %zmm22
// CHECK: encoding: [0x62,0xe5,0xfd,0x58,0x6d,0x35,0x00,0x00,0x00,0x00]
          vcvttpd2qqs  (%rip){1to8}, %zmm22

// CHECK: vcvttpd2qqs  -2048(,%rbp,2), %zmm22
// CHECK: encoding: [0x62,0xe5,0xfd,0x48,0x6d,0x34,0x6d,0x00,0xf8,0xff,0xff]
          vcvttpd2qqs  -2048(,%rbp,2), %zmm22

// CHECK: vcvttpd2qqs  8128(%rcx), %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfd,0xcf,0x6d,0x71,0x7f]
          vcvttpd2qqs  8128(%rcx), %zmm22 {%k7} {z}

// CHECK: vcvttpd2qqs  -1024(%rdx){1to8}, %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfd,0xdf,0x6d,0x72,0x80]
          vcvttpd2qqs  -1024(%rdx){1to8}, %zmm22 {%k7} {z}

// CHECK: vcvttpd2udqs %xmm23, %xmm22
// CHECK: encoding: [0x62,0xa5,0xfc,0x08,0x6c,0xf7]
          vcvttpd2udqs %xmm23, %xmm22

// CHECK: vcvttpd2udqs %xmm23, %xmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0xfc,0x0f,0x6c,0xf7]
          vcvttpd2udqs %xmm23, %xmm22 {%k7}

// CHECK: vcvttpd2udqs %xmm23, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0xfc,0x8f,0x6c,0xf7]
          vcvttpd2udqs %xmm23, %xmm22 {%k7} {z}

// CHECK: vcvttpd2udqs %ymm23, %xmm22
// CHECK: encoding: [0x62,0xa5,0xfc,0x28,0x6c,0xf7]
          vcvttpd2udqs %ymm23, %xmm22

// CHECK: vcvttpd2udqs %ymm23, %xmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0xfc,0x2f,0x6c,0xf7]
          vcvttpd2udqs %ymm23, %xmm22 {%k7}

// CHECK: vcvttpd2udqs %zmm23, %ymm22
// CHECK: encoding: [0x62,0xa5,0xfc,0x48,0x6c,0xf7]
          vcvttpd2udqs %zmm23, %ymm22

// CHECK: vcvttpd2udqs {sae}, %zmm23, %ymm22
// CHECK: encoding: [0x62,0xa5,0xfc,0x18,0x6c,0xf7]
          vcvttpd2udqs {sae}, %zmm23, %ymm22

// CHECK: vcvttpd2udqs %zmm23, %ymm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0xfc,0x4f,0x6c,0xf7]
          vcvttpd2udqs %zmm23, %ymm22 {%k7}

// CHECK: vcvttpd2udqs {sae}, %zmm23, %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0xfc,0x9f,0x6c,0xf7]
          vcvttpd2udqs {sae}, %zmm23, %ymm22 {%k7} {z}

// CHECK: vcvttpd2udqsx  268435456(%rbp,%r14,8), %xmm22
// CHECK: encoding: [0x62,0xa5,0xfc,0x08,0x6c,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttpd2udqsx  268435456(%rbp,%r14,8), %xmm22

// CHECK: vcvttpd2udqsx  291(%r8,%rax,4), %xmm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0xfc,0x0f,0x6c,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttpd2udqsx  291(%r8,%rax,4), %xmm22 {%k7}

// CHECK: vcvttpd2udqs  (%rip){1to2}, %xmm22
// CHECK: encoding: [0x62,0xe5,0xfc,0x18,0x6c,0x35,0x00,0x00,0x00,0x00]
          vcvttpd2udqs  (%rip){1to2}, %xmm22

// CHECK: vcvttpd2udqsx  -512(,%rbp,2), %xmm22
// CHECK: encoding: [0x62,0xe5,0xfc,0x08,0x6c,0x34,0x6d,0x00,0xfe,0xff,0xff]
          vcvttpd2udqsx  -512(,%rbp,2), %xmm22

// CHECK: vcvttpd2udqsx  2032(%rcx), %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfc,0x8f,0x6c,0x71,0x7f]
          vcvttpd2udqsx  2032(%rcx), %xmm22 {%k7} {z}

// CHECK: vcvttpd2udqs  -1024(%rdx){1to2}, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfc,0x9f,0x6c,0x72,0x80]
          vcvttpd2udqs  -1024(%rdx){1to2}, %xmm22 {%k7} {z}

// CHECK: vcvttpd2udqs  (%rip){1to4}, %xmm22
// CHECK: encoding: [0x62,0xe5,0xfc,0x38,0x6c,0x35,0x00,0x00,0x00,0x00]
          vcvttpd2udqs  (%rip){1to4}, %xmm22

// CHECK: vcvttpd2udqsy  -1024(,%rbp,2), %xmm22
// CHECK: encoding: [0x62,0xe5,0xfc,0x28,0x6c,0x34,0x6d,0x00,0xfc,0xff,0xff]
          vcvttpd2udqsy  -1024(,%rbp,2), %xmm22

// CHECK: vcvttpd2udqsy  4064(%rcx), %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfc,0xaf,0x6c,0x71,0x7f]
          vcvttpd2udqsy  4064(%rcx), %xmm22 {%k7} {z}

// CHECK: vcvttpd2udqs  -1024(%rdx){1to4}, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfc,0xbf,0x6c,0x72,0x80]
          vcvttpd2udqs  -1024(%rdx){1to4}, %xmm22 {%k7} {z}

// CHECK: vcvttpd2udqs  268435456(%rbp,%r14,8), %ymm22
// CHECK: encoding: [0x62,0xa5,0xfc,0x48,0x6c,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttpd2udqs  268435456(%rbp,%r14,8), %ymm22

// CHECK: vcvttpd2udqs  291(%r8,%rax,4), %ymm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0xfc,0x4f,0x6c,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttpd2udqs  291(%r8,%rax,4), %ymm22 {%k7}

// CHECK: vcvttpd2udqs  (%rip){1to8}, %ymm22
// CHECK: encoding: [0x62,0xe5,0xfc,0x58,0x6c,0x35,0x00,0x00,0x00,0x00]
          vcvttpd2udqs  (%rip){1to8}, %ymm22

// CHECK: vcvttpd2udqs  -2048(,%rbp,2), %ymm22
// CHECK: encoding: [0x62,0xe5,0xfc,0x48,0x6c,0x34,0x6d,0x00,0xf8,0xff,0xff]
          vcvttpd2udqs  -2048(,%rbp,2), %ymm22

// CHECK: vcvttpd2udqs  8128(%rcx), %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfc,0xcf,0x6c,0x71,0x7f]
          vcvttpd2udqs  8128(%rcx), %ymm22 {%k7} {z}

// CHECK: vcvttpd2udqs  -1024(%rdx){1to8}, %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfc,0xdf,0x6c,0x72,0x80]
          vcvttpd2udqs  -1024(%rdx){1to8}, %ymm22 {%k7} {z}

// CHECK: vcvttpd2uqqs %xmm23, %xmm22
// CHECK: encoding: [0x62,0xa5,0xfd,0x08,0x6c,0xf7]
          vcvttpd2uqqs %xmm23, %xmm22

// CHECK: vcvttpd2uqqs %xmm23, %xmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0xfd,0x0f,0x6c,0xf7]
          vcvttpd2uqqs %xmm23, %xmm22 {%k7}

// CHECK: vcvttpd2uqqs %xmm23, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0xfd,0x8f,0x6c,0xf7]
          vcvttpd2uqqs %xmm23, %xmm22 {%k7} {z}

// CHECK: vcvttpd2uqqs %ymm23, %ymm22
// CHECK: encoding: [0x62,0xa5,0xfd,0x28,0x6c,0xf7]
          vcvttpd2uqqs %ymm23, %ymm22

// CHECK: vcvttpd2uqqs %ymm23, %ymm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0xfd,0x2f,0x6c,0xf7]
          vcvttpd2uqqs %ymm23, %ymm22 {%k7}

// CHECK: vcvttpd2uqqs %zmm23, %zmm22
// CHECK: encoding: [0x62,0xa5,0xfd,0x48,0x6c,0xf7]
          vcvttpd2uqqs %zmm23, %zmm22

// CHECK: vcvttpd2uqqs {sae}, %zmm23, %zmm22
// CHECK: encoding: [0x62,0xa5,0xfd,0x18,0x6c,0xf7]
          vcvttpd2uqqs {sae}, %zmm23, %zmm22

// CHECK: vcvttpd2uqqs %zmm23, %zmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0xfd,0x4f,0x6c,0xf7]
          vcvttpd2uqqs %zmm23, %zmm22 {%k7}

// CHECK: vcvttpd2uqqs {sae}, %zmm23, %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0xfd,0x9f,0x6c,0xf7]
          vcvttpd2uqqs {sae}, %zmm23, %zmm22 {%k7} {z}

// CHECK: vcvttpd2uqqs  268435456(%rbp,%r14,8), %xmm22
// CHECK: encoding: [0x62,0xa5,0xfd,0x08,0x6c,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttpd2uqqs  268435456(%rbp,%r14,8), %xmm22

// CHECK: vcvttpd2uqqs  291(%r8,%rax,4), %xmm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0xfd,0x0f,0x6c,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttpd2uqqs  291(%r8,%rax,4), %xmm22 {%k7}

// CHECK: vcvttpd2uqqs  (%rip){1to2}, %xmm22
// CHECK: encoding: [0x62,0xe5,0xfd,0x18,0x6c,0x35,0x00,0x00,0x00,0x00]
          vcvttpd2uqqs  (%rip){1to2}, %xmm22

// CHECK: vcvttpd2uqqs  -512(,%rbp,2), %xmm22
// CHECK: encoding: [0x62,0xe5,0xfd,0x08,0x6c,0x34,0x6d,0x00,0xfe,0xff,0xff]
          vcvttpd2uqqs  -512(,%rbp,2), %xmm22

// CHECK: vcvttpd2uqqs  2032(%rcx), %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfd,0x8f,0x6c,0x71,0x7f]
          vcvttpd2uqqs  2032(%rcx), %xmm22 {%k7} {z}

// CHECK: vcvttpd2uqqs  -1024(%rdx){1to2}, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfd,0x9f,0x6c,0x72,0x80]
          vcvttpd2uqqs  -1024(%rdx){1to2}, %xmm22 {%k7} {z}

// CHECK: vcvttpd2uqqs  268435456(%rbp,%r14,8), %ymm22
// CHECK: encoding: [0x62,0xa5,0xfd,0x28,0x6c,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttpd2uqqs  268435456(%rbp,%r14,8), %ymm22

// CHECK: vcvttpd2uqqs  291(%r8,%rax,4), %ymm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0xfd,0x2f,0x6c,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttpd2uqqs  291(%r8,%rax,4), %ymm22 {%k7}

// CHECK: vcvttpd2uqqs  (%rip){1to4}, %ymm22
// CHECK: encoding: [0x62,0xe5,0xfd,0x38,0x6c,0x35,0x00,0x00,0x00,0x00]
          vcvttpd2uqqs  (%rip){1to4}, %ymm22

// CHECK: vcvttpd2uqqs  -1024(,%rbp,2), %ymm22
// CHECK: encoding: [0x62,0xe5,0xfd,0x28,0x6c,0x34,0x6d,0x00,0xfc,0xff,0xff]
          vcvttpd2uqqs  -1024(,%rbp,2), %ymm22

// CHECK: vcvttpd2uqqs  4064(%rcx), %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfd,0xaf,0x6c,0x71,0x7f]
          vcvttpd2uqqs  4064(%rcx), %ymm22 {%k7} {z}

// CHECK: vcvttpd2uqqs  -1024(%rdx){1to4}, %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfd,0xbf,0x6c,0x72,0x80]
          vcvttpd2uqqs  -1024(%rdx){1to4}, %ymm22 {%k7} {z}

// CHECK: vcvttpd2uqqs  268435456(%rbp,%r14,8), %zmm22
// CHECK: encoding: [0x62,0xa5,0xfd,0x48,0x6c,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttpd2uqqs  268435456(%rbp,%r14,8), %zmm22

// CHECK: vcvttpd2uqqs  291(%r8,%rax,4), %zmm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0xfd,0x4f,0x6c,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttpd2uqqs  291(%r8,%rax,4), %zmm22 {%k7}

// CHECK: vcvttpd2uqqs  (%rip){1to8}, %zmm22
// CHECK: encoding: [0x62,0xe5,0xfd,0x58,0x6c,0x35,0x00,0x00,0x00,0x00]
          vcvttpd2uqqs  (%rip){1to8}, %zmm22

// CHECK: vcvttpd2uqqs  -2048(,%rbp,2), %zmm22
// CHECK: encoding: [0x62,0xe5,0xfd,0x48,0x6c,0x34,0x6d,0x00,0xf8,0xff,0xff]
          vcvttpd2uqqs  -2048(,%rbp,2), %zmm22

// CHECK: vcvttpd2uqqs  8128(%rcx), %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfd,0xcf,0x6c,0x71,0x7f]
          vcvttpd2uqqs  8128(%rcx), %zmm22 {%k7} {z}

// CHECK: vcvttpd2uqqs  -1024(%rdx){1to8}, %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0xfd,0xdf,0x6c,0x72,0x80]
          vcvttpd2uqqs  -1024(%rdx){1to8}, %zmm22 {%k7} {z}

// CHECK: vcvttps2dqs %xmm23, %xmm22
// CHECK: encoding: [0x62,0xa5,0x7c,0x08,0x6d,0xf7]
          vcvttps2dqs %xmm23, %xmm22

// CHECK: vcvttps2dqs %xmm23, %xmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0x7c,0x0f,0x6d,0xf7]
          vcvttps2dqs %xmm23, %xmm22 {%k7}

// CHECK: vcvttps2dqs %xmm23, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0x7c,0x8f,0x6d,0xf7]
          vcvttps2dqs %xmm23, %xmm22 {%k7} {z}

// CHECK: vcvttps2dqs %ymm23, %ymm22
// CHECK: encoding: [0x62,0xa5,0x7c,0x28,0x6d,0xf7]
          vcvttps2dqs %ymm23, %ymm22

// CHECK: vcvttps2dqs %ymm23, %ymm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0x7c,0x2f,0x6d,0xf7]
          vcvttps2dqs %ymm23, %ymm22 {%k7}

// CHECK: vcvttps2dqs %zmm23, %zmm22
// CHECK: encoding: [0x62,0xa5,0x7c,0x48,0x6d,0xf7]
          vcvttps2dqs %zmm23, %zmm22

// CHECK: vcvttps2dqs {sae}, %zmm23, %zmm22
// CHECK: encoding: [0x62,0xa5,0x7c,0x18,0x6d,0xf7]
          vcvttps2dqs {sae}, %zmm23, %zmm22

// CHECK: vcvttps2dqs %zmm23, %zmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0x7c,0x4f,0x6d,0xf7]
          vcvttps2dqs %zmm23, %zmm22 {%k7}

// CHECK: vcvttps2dqs {sae}, %zmm23, %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0x7c,0x9f,0x6d,0xf7]
          vcvttps2dqs {sae}, %zmm23, %zmm22 {%k7} {z}

// CHECK: vcvttps2dqs  268435456(%rbp,%r14,8), %xmm22
// CHECK: encoding: [0x62,0xa5,0x7c,0x08,0x6d,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttps2dqs  268435456(%rbp,%r14,8), %xmm22

// CHECK: vcvttps2dqs  291(%r8,%rax,4), %xmm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0x7c,0x0f,0x6d,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttps2dqs  291(%r8,%rax,4), %xmm22 {%k7}

// CHECK: vcvttps2dqs  (%rip){1to4}, %xmm22
// CHECK: encoding: [0x62,0xe5,0x7c,0x18,0x6d,0x35,0x00,0x00,0x00,0x00]
          vcvttps2dqs  (%rip){1to4}, %xmm22

// CHECK: vcvttps2dqs  -512(,%rbp,2), %xmm22
// CHECK: encoding: [0x62,0xe5,0x7c,0x08,0x6d,0x34,0x6d,0x00,0xfe,0xff,0xff]
          vcvttps2dqs  -512(,%rbp,2), %xmm22

// CHECK: vcvttps2dqs  2032(%rcx), %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7c,0x8f,0x6d,0x71,0x7f]
          vcvttps2dqs  2032(%rcx), %xmm22 {%k7} {z}

// CHECK: vcvttps2dqs  -512(%rdx){1to4}, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7c,0x9f,0x6d,0x72,0x80]
          vcvttps2dqs  -512(%rdx){1to4}, %xmm22 {%k7} {z}

// CHECK: vcvttps2dqs  268435456(%rbp,%r14,8), %ymm22
// CHECK: encoding: [0x62,0xa5,0x7c,0x28,0x6d,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttps2dqs  268435456(%rbp,%r14,8), %ymm22

// CHECK: vcvttps2dqs  291(%r8,%rax,4), %ymm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0x7c,0x2f,0x6d,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttps2dqs  291(%r8,%rax,4), %ymm22 {%k7}

// CHECK: vcvttps2dqs  (%rip){1to8}, %ymm22
// CHECK: encoding: [0x62,0xe5,0x7c,0x38,0x6d,0x35,0x00,0x00,0x00,0x00]
          vcvttps2dqs  (%rip){1to8}, %ymm22

// CHECK: vcvttps2dqs  -1024(,%rbp,2), %ymm22
// CHECK: encoding: [0x62,0xe5,0x7c,0x28,0x6d,0x34,0x6d,0x00,0xfc,0xff,0xff]
          vcvttps2dqs  -1024(,%rbp,2), %ymm22

// CHECK: vcvttps2dqs  4064(%rcx), %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7c,0xaf,0x6d,0x71,0x7f]
          vcvttps2dqs  4064(%rcx), %ymm22 {%k7} {z}

// CHECK: vcvttps2dqs  -512(%rdx){1to8}, %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7c,0xbf,0x6d,0x72,0x80]
          vcvttps2dqs  -512(%rdx){1to8}, %ymm22 {%k7} {z}

// CHECK: vcvttps2dqs  268435456(%rbp,%r14,8), %zmm22
// CHECK: encoding: [0x62,0xa5,0x7c,0x48,0x6d,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttps2dqs  268435456(%rbp,%r14,8), %zmm22

// CHECK: vcvttps2dqs  291(%r8,%rax,4), %zmm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0x7c,0x4f,0x6d,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttps2dqs  291(%r8,%rax,4), %zmm22 {%k7}

// CHECK: vcvttps2dqs  (%rip){1to16}, %zmm22
// CHECK: encoding: [0x62,0xe5,0x7c,0x58,0x6d,0x35,0x00,0x00,0x00,0x00]
          vcvttps2dqs  (%rip){1to16}, %zmm22

// CHECK: vcvttps2dqs  -2048(,%rbp,2), %zmm22
// CHECK: encoding: [0x62,0xe5,0x7c,0x48,0x6d,0x34,0x6d,0x00,0xf8,0xff,0xff]
          vcvttps2dqs  -2048(,%rbp,2), %zmm22

// CHECK: vcvttps2dqs  8128(%rcx), %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7c,0xcf,0x6d,0x71,0x7f]
          vcvttps2dqs  8128(%rcx), %zmm22 {%k7} {z}

// CHECK: vcvttps2dqs  -512(%rdx){1to16}, %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7c,0xdf,0x6d,0x72,0x80]
          vcvttps2dqs  -512(%rdx){1to16}, %zmm22 {%k7} {z}

// CHECK: vcvttps2qqs %xmm23, %xmm22
// CHECK: encoding: [0x62,0xa5,0x7d,0x08,0x6d,0xf7]
          vcvttps2qqs %xmm23, %xmm22

// CHECK: vcvttps2qqs %xmm23, %xmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0x7d,0x0f,0x6d,0xf7]
          vcvttps2qqs %xmm23, %xmm22 {%k7}

// CHECK: vcvttps2qqs %xmm23, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0x7d,0x8f,0x6d,0xf7]
          vcvttps2qqs %xmm23, %xmm22 {%k7} {z}

// CHECK: vcvttps2qqs %xmm23, %ymm22
// CHECK: encoding: [0x62,0xa5,0x7d,0x28,0x6d,0xf7]
          vcvttps2qqs %xmm23, %ymm22

// CHECK: vcvttps2qqs {sae}, %xmm23, %ymm22
// CHECK: encoding: [0x62,0xa5,0x79,0x18,0x6d,0xf7]
          vcvttps2qqs {sae}, %xmm23, %ymm22

// CHECK: vcvttps2qqs %xmm23, %ymm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0x7d,0x2f,0x6d,0xf7]
          vcvttps2qqs %xmm23, %ymm22 {%k7}

// CHECK: vcvttps2qqs {sae}, %xmm23, %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0x79,0x9f,0x6d,0xf7]
          vcvttps2qqs {sae}, %xmm23, %ymm22 {%k7} {z}

// CHECK: vcvttps2qqs %ymm23, %zmm22
// CHECK: encoding: [0x62,0xa5,0x7d,0x48,0x6d,0xf7]
          vcvttps2qqs %ymm23, %zmm22

// CHECK: vcvttps2qqs {sae}, %ymm23, %zmm22
// CHECK: encoding: [0x62,0xa5,0x7d,0x18,0x6d,0xf7]
          vcvttps2qqs {sae}, %ymm23, %zmm22

// CHECK: vcvttps2qqs %ymm23, %zmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0x7d,0x4f,0x6d,0xf7]
          vcvttps2qqs %ymm23, %zmm22 {%k7}

// CHECK: vcvttps2qqs {sae}, %ymm23, %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0x7d,0x9f,0x6d,0xf7]
          vcvttps2qqs {sae}, %ymm23, %zmm22 {%k7} {z}

// CHECK: vcvttps2qqs  268435456(%rbp,%r14,8), %xmm22
// CHECK: encoding: [0x62,0xa5,0x7d,0x08,0x6d,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttps2qqs  268435456(%rbp,%r14,8), %xmm22

// CHECK: vcvttps2qqs  291(%r8,%rax,4), %xmm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0x7d,0x0f,0x6d,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttps2qqs  291(%r8,%rax,4), %xmm22 {%k7}

// CHECK: vcvttps2qqs  (%rip){1to2}, %xmm22
// CHECK: encoding: [0x62,0xe5,0x7d,0x18,0x6d,0x35,0x00,0x00,0x00,0x00]
          vcvttps2qqs  (%rip){1to2}, %xmm22

// CHECK: vcvttps2qqs  -256(,%rbp,2), %xmm22
// CHECK: encoding: [0x62,0xe5,0x7d,0x08,0x6d,0x34,0x6d,0x00,0xff,0xff,0xff]
          vcvttps2qqs  -256(,%rbp,2), %xmm22

// CHECK: vcvttps2qqs  1016(%rcx), %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7d,0x8f,0x6d,0x71,0x7f]
          vcvttps2qqs  1016(%rcx), %xmm22 {%k7} {z}

// CHECK: vcvttps2qqs  -512(%rdx){1to2}, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7d,0x9f,0x6d,0x72,0x80]
          vcvttps2qqs  -512(%rdx){1to2}, %xmm22 {%k7} {z}

// CHECK: vcvttps2qqs  268435456(%rbp,%r14,8), %ymm22
// CHECK: encoding: [0x62,0xa5,0x7d,0x28,0x6d,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttps2qqs  268435456(%rbp,%r14,8), %ymm22

// CHECK: vcvttps2qqs  291(%r8,%rax,4), %ymm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0x7d,0x2f,0x6d,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttps2qqs  291(%r8,%rax,4), %ymm22 {%k7}

// CHECK: vcvttps2qqs  (%rip){1to4}, %ymm22
// CHECK: encoding: [0x62,0xe5,0x7d,0x38,0x6d,0x35,0x00,0x00,0x00,0x00]
          vcvttps2qqs  (%rip){1to4}, %ymm22

// CHECK: vcvttps2qqs  -512(,%rbp,2), %ymm22
// CHECK: encoding: [0x62,0xe5,0x7d,0x28,0x6d,0x34,0x6d,0x00,0xfe,0xff,0xff]
          vcvttps2qqs  -512(,%rbp,2), %ymm22

// CHECK: vcvttps2qqs  2032(%rcx), %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7d,0xaf,0x6d,0x71,0x7f]
          vcvttps2qqs  2032(%rcx), %ymm22 {%k7} {z}

// CHECK: vcvttps2qqs  -512(%rdx){1to4}, %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7d,0xbf,0x6d,0x72,0x80]
          vcvttps2qqs  -512(%rdx){1to4}, %ymm22 {%k7} {z}

// CHECK: vcvttps2qqs  268435456(%rbp,%r14,8), %zmm22
// CHECK: encoding: [0x62,0xa5,0x7d,0x48,0x6d,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttps2qqs  268435456(%rbp,%r14,8), %zmm22

// CHECK: vcvttps2qqs  291(%r8,%rax,4), %zmm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0x7d,0x4f,0x6d,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttps2qqs  291(%r8,%rax,4), %zmm22 {%k7}

// CHECK: vcvttps2qqs  (%rip){1to8}, %zmm22
// CHECK: encoding: [0x62,0xe5,0x7d,0x58,0x6d,0x35,0x00,0x00,0x00,0x00]
          vcvttps2qqs  (%rip){1to8}, %zmm22

// CHECK: vcvttps2qqs  -1024(,%rbp,2), %zmm22
// CHECK: encoding: [0x62,0xe5,0x7d,0x48,0x6d,0x34,0x6d,0x00,0xfc,0xff,0xff]
          vcvttps2qqs  -1024(,%rbp,2), %zmm22

// CHECK: vcvttps2qqs  4064(%rcx), %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7d,0xcf,0x6d,0x71,0x7f]
          vcvttps2qqs  4064(%rcx), %zmm22 {%k7} {z}

// CHECK: vcvttps2qqs  -512(%rdx){1to8}, %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7d,0xdf,0x6d,0x72,0x80]
          vcvttps2qqs  -512(%rdx){1to8}, %zmm22 {%k7} {z}

// CHECK: vcvttps2udqs %xmm23, %xmm22
// CHECK: encoding: [0x62,0xa5,0x7c,0x08,0x6c,0xf7]
          vcvttps2udqs %xmm23, %xmm22

// CHECK: vcvttps2udqs %xmm23, %xmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0x7c,0x0f,0x6c,0xf7]
          vcvttps2udqs %xmm23, %xmm22 {%k7}

// CHECK: vcvttps2udqs %xmm23, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0x7c,0x8f,0x6c,0xf7]
          vcvttps2udqs %xmm23, %xmm22 {%k7} {z}

// CHECK: vcvttps2udqs %ymm23, %ymm22
// CHECK: encoding: [0x62,0xa5,0x7c,0x28,0x6c,0xf7]
          vcvttps2udqs %ymm23, %ymm22

// CHECK: vcvttps2udqs %ymm23, %ymm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0x7c,0x2f,0x6c,0xf7]
          vcvttps2udqs %ymm23, %ymm22 {%k7}

// CHECK: vcvttps2udqs %zmm23, %zmm22
// CHECK: encoding: [0x62,0xa5,0x7c,0x48,0x6c,0xf7]
          vcvttps2udqs %zmm23, %zmm22

// CHECK: vcvttps2udqs {sae}, %zmm23, %zmm22
// CHECK: encoding: [0x62,0xa5,0x7c,0x18,0x6c,0xf7]
          vcvttps2udqs {sae}, %zmm23, %zmm22

// CHECK: vcvttps2udqs %zmm23, %zmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0x7c,0x4f,0x6c,0xf7]
          vcvttps2udqs %zmm23, %zmm22 {%k7}

// CHECK: vcvttps2udqs {sae}, %zmm23, %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0x7c,0x9f,0x6c,0xf7]
          vcvttps2udqs {sae}, %zmm23, %zmm22 {%k7} {z}

// CHECK: vcvttps2udqs  268435456(%rbp,%r14,8), %xmm22
// CHECK: encoding: [0x62,0xa5,0x7c,0x08,0x6c,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttps2udqs  268435456(%rbp,%r14,8), %xmm22

// CHECK: vcvttps2udqs  291(%r8,%rax,4), %xmm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0x7c,0x0f,0x6c,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttps2udqs  291(%r8,%rax,4), %xmm22 {%k7}

// CHECK: vcvttps2udqs  (%rip){1to4}, %xmm22
// CHECK: encoding: [0x62,0xe5,0x7c,0x18,0x6c,0x35,0x00,0x00,0x00,0x00]
          vcvttps2udqs  (%rip){1to4}, %xmm22

// CHECK: vcvttps2udqs  -512(,%rbp,2), %xmm22
// CHECK: encoding: [0x62,0xe5,0x7c,0x08,0x6c,0x34,0x6d,0x00,0xfe,0xff,0xff]
          vcvttps2udqs  -512(,%rbp,2), %xmm22

// CHECK: vcvttps2udqs  2032(%rcx), %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7c,0x8f,0x6c,0x71,0x7f]
          vcvttps2udqs  2032(%rcx), %xmm22 {%k7} {z}

// CHECK: vcvttps2udqs  -512(%rdx){1to4}, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7c,0x9f,0x6c,0x72,0x80]
          vcvttps2udqs  -512(%rdx){1to4}, %xmm22 {%k7} {z}

// CHECK: vcvttps2udqs  268435456(%rbp,%r14,8), %ymm22
// CHECK: encoding: [0x62,0xa5,0x7c,0x28,0x6c,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttps2udqs  268435456(%rbp,%r14,8), %ymm22

// CHECK: vcvttps2udqs  291(%r8,%rax,4), %ymm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0x7c,0x2f,0x6c,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttps2udqs  291(%r8,%rax,4), %ymm22 {%k7}

// CHECK: vcvttps2udqs  (%rip){1to8}, %ymm22
// CHECK: encoding: [0x62,0xe5,0x7c,0x38,0x6c,0x35,0x00,0x00,0x00,0x00]
          vcvttps2udqs  (%rip){1to8}, %ymm22

// CHECK: vcvttps2udqs  -1024(,%rbp,2), %ymm22
// CHECK: encoding: [0x62,0xe5,0x7c,0x28,0x6c,0x34,0x6d,0x00,0xfc,0xff,0xff]
          vcvttps2udqs  -1024(,%rbp,2), %ymm22

// CHECK: vcvttps2udqs  4064(%rcx), %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7c,0xaf,0x6c,0x71,0x7f]
          vcvttps2udqs  4064(%rcx), %ymm22 {%k7} {z}

// CHECK: vcvttps2udqs  -512(%rdx){1to8}, %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7c,0xbf,0x6c,0x72,0x80]
          vcvttps2udqs  -512(%rdx){1to8}, %ymm22 {%k7} {z}

// CHECK: vcvttps2udqs  268435456(%rbp,%r14,8), %zmm22
// CHECK: encoding: [0x62,0xa5,0x7c,0x48,0x6c,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttps2udqs  268435456(%rbp,%r14,8), %zmm22

// CHECK: vcvttps2udqs  291(%r8,%rax,4), %zmm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0x7c,0x4f,0x6c,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttps2udqs  291(%r8,%rax,4), %zmm22 {%k7}

// CHECK: vcvttps2udqs  (%rip){1to16}, %zmm22
// CHECK: encoding: [0x62,0xe5,0x7c,0x58,0x6c,0x35,0x00,0x00,0x00,0x00]
          vcvttps2udqs  (%rip){1to16}, %zmm22

// CHECK: vcvttps2udqs  -2048(,%rbp,2), %zmm22
// CHECK: encoding: [0x62,0xe5,0x7c,0x48,0x6c,0x34,0x6d,0x00,0xf8,0xff,0xff]
          vcvttps2udqs  -2048(,%rbp,2), %zmm22

// CHECK: vcvttps2udqs  8128(%rcx), %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7c,0xcf,0x6c,0x71,0x7f]
          vcvttps2udqs  8128(%rcx), %zmm22 {%k7} {z}

// CHECK: vcvttps2udqs  -512(%rdx){1to16}, %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7c,0xdf,0x6c,0x72,0x80]
          vcvttps2udqs  -512(%rdx){1to16}, %zmm22 {%k7} {z}

// CHECK: vcvttps2uqqs %xmm23, %xmm22
// CHECK: encoding: [0x62,0xa5,0x7d,0x08,0x6c,0xf7]
          vcvttps2uqqs %xmm23, %xmm22

// CHECK: vcvttps2uqqs %xmm23, %xmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0x7d,0x0f,0x6c,0xf7]
          vcvttps2uqqs %xmm23, %xmm22 {%k7}

// CHECK: vcvttps2uqqs %xmm23, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0x7d,0x8f,0x6c,0xf7]
          vcvttps2uqqs %xmm23, %xmm22 {%k7} {z}

// CHECK: vcvttps2uqqs %xmm23, %ymm22
// CHECK: encoding: [0x62,0xa5,0x7d,0x28,0x6c,0xf7]
          vcvttps2uqqs %xmm23, %ymm22

// CHECK: vcvttps2uqqs {sae}, %xmm23, %ymm22
// CHECK: encoding: [0x62,0xa5,0x79,0x18,0x6c,0xf7]
          vcvttps2uqqs {sae}, %xmm23, %ymm22

// CHECK: vcvttps2uqqs %xmm23, %ymm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0x7d,0x2f,0x6c,0xf7]
          vcvttps2uqqs %xmm23, %ymm22 {%k7}

// CHECK: vcvttps2uqqs {sae}, %xmm23, %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0x79,0x9f,0x6c,0xf7]
          vcvttps2uqqs {sae}, %xmm23, %ymm22 {%k7} {z}

// CHECK: vcvttps2uqqs %ymm23, %zmm22
// CHECK: encoding: [0x62,0xa5,0x7d,0x48,0x6c,0xf7]
          vcvttps2uqqs %ymm23, %zmm22

// CHECK: vcvttps2uqqs {sae}, %ymm23, %zmm22
// CHECK: encoding: [0x62,0xa5,0x7d,0x18,0x6c,0xf7]
          vcvttps2uqqs {sae}, %ymm23, %zmm22

// CHECK: vcvttps2uqqs %ymm23, %zmm22 {%k7}
// CHECK: encoding: [0x62,0xa5,0x7d,0x4f,0x6c,0xf7]
          vcvttps2uqqs %ymm23, %zmm22 {%k7}

// CHECK: vcvttps2uqqs {sae}, %ymm23, %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xa5,0x7d,0x9f,0x6c,0xf7]
          vcvttps2uqqs {sae}, %ymm23, %zmm22 {%k7} {z}

// CHECK: vcvttps2uqqs  268435456(%rbp,%r14,8), %xmm22
// CHECK: encoding: [0x62,0xa5,0x7d,0x08,0x6c,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttps2uqqs  268435456(%rbp,%r14,8), %xmm22

// CHECK: vcvttps2uqqs  291(%r8,%rax,4), %xmm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0x7d,0x0f,0x6c,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttps2uqqs  291(%r8,%rax,4), %xmm22 {%k7}

// CHECK: vcvttps2uqqs  (%rip){1to2}, %xmm22
// CHECK: encoding: [0x62,0xe5,0x7d,0x18,0x6c,0x35,0x00,0x00,0x00,0x00]
          vcvttps2uqqs  (%rip){1to2}, %xmm22

// CHECK: vcvttps2uqqs  -256(,%rbp,2), %xmm22
// CHECK: encoding: [0x62,0xe5,0x7d,0x08,0x6c,0x34,0x6d,0x00,0xff,0xff,0xff]
          vcvttps2uqqs  -256(,%rbp,2), %xmm22

// CHECK: vcvttps2uqqs  1016(%rcx), %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7d,0x8f,0x6c,0x71,0x7f]
          vcvttps2uqqs  1016(%rcx), %xmm22 {%k7} {z}

// CHECK: vcvttps2uqqs  -512(%rdx){1to2}, %xmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7d,0x9f,0x6c,0x72,0x80]
          vcvttps2uqqs  -512(%rdx){1to2}, %xmm22 {%k7} {z}

// CHECK: vcvttps2uqqs  268435456(%rbp,%r14,8), %ymm22
// CHECK: encoding: [0x62,0xa5,0x7d,0x28,0x6c,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttps2uqqs  268435456(%rbp,%r14,8), %ymm22

// CHECK: vcvttps2uqqs  291(%r8,%rax,4), %ymm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0x7d,0x2f,0x6c,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttps2uqqs  291(%r8,%rax,4), %ymm22 {%k7}

// CHECK: vcvttps2uqqs  (%rip){1to4}, %ymm22
// CHECK: encoding: [0x62,0xe5,0x7d,0x38,0x6c,0x35,0x00,0x00,0x00,0x00]
          vcvttps2uqqs  (%rip){1to4}, %ymm22

// CHECK: vcvttps2uqqs  -512(,%rbp,2), %ymm22
// CHECK: encoding: [0x62,0xe5,0x7d,0x28,0x6c,0x34,0x6d,0x00,0xfe,0xff,0xff]
          vcvttps2uqqs  -512(,%rbp,2), %ymm22

// CHECK: vcvttps2uqqs  2032(%rcx), %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7d,0xaf,0x6c,0x71,0x7f]
          vcvttps2uqqs  2032(%rcx), %ymm22 {%k7} {z}

// CHECK: vcvttps2uqqs  -512(%rdx){1to4}, %ymm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7d,0xbf,0x6c,0x72,0x80]
          vcvttps2uqqs  -512(%rdx){1to4}, %ymm22 {%k7} {z}

// CHECK: vcvttps2uqqs  268435456(%rbp,%r14,8), %zmm22
// CHECK: encoding: [0x62,0xa5,0x7d,0x48,0x6c,0xb4,0xf5,0x00,0x00,0x00,0x10]
          vcvttps2uqqs  268435456(%rbp,%r14,8), %zmm22

// CHECK: vcvttps2uqqs  291(%r8,%rax,4), %zmm22 {%k7}
// CHECK: encoding: [0x62,0xc5,0x7d,0x4f,0x6c,0xb4,0x80,0x23,0x01,0x00,0x00]
          vcvttps2uqqs  291(%r8,%rax,4), %zmm22 {%k7}

// CHECK: vcvttps2uqqs  (%rip){1to8}, %zmm22
// CHECK: encoding: [0x62,0xe5,0x7d,0x58,0x6c,0x35,0x00,0x00,0x00,0x00]
          vcvttps2uqqs  (%rip){1to8}, %zmm22

// CHECK: vcvttps2uqqs  -1024(,%rbp,2), %zmm22
// CHECK: encoding: [0x62,0xe5,0x7d,0x48,0x6c,0x34,0x6d,0x00,0xfc,0xff,0xff]
          vcvttps2uqqs  -1024(,%rbp,2), %zmm22

// CHECK: vcvttps2uqqs  4064(%rcx), %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7d,0xcf,0x6c,0x71,0x7f]
          vcvttps2uqqs  4064(%rcx), %zmm22 {%k7} {z}

// CHECK: vcvttps2uqqs  -512(%rdx){1to8}, %zmm22 {%k7} {z}
// CHECK: encoding: [0x62,0xe5,0x7d,0xdf,0x6c,0x72,0x80]
          vcvttps2uqqs  -512(%rdx){1to8}, %zmm22 {%k7} {z}

