; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

; TODO: the instructions having poison operands should be folded to poison

declare i3 @llvm.uadd.sat.i3(i3, i3)
declare i8 @llvm.uadd.sat.i8(i8, i8)
declare <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8>, <2 x i8>)
declare <2 x i9> @llvm.uadd.sat.v2i9(<2 x i9>, <2 x i9>)

declare i8 @llvm.sadd.sat.i8(i8, i8)
declare <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8>, <2 x i8>)

declare i8 @llvm.usub.sat.i8(i8, i8)
declare i8 @llvm.ssub.sat.i8(i8, i8)
declare <2 x i8> @llvm.usub.sat.v2i8(<2 x i8>, <2 x i8>)
declare <2 x i8> @llvm.ssub.sat.v2i8(<2 x i8>, <2 x i8>)

define i8 @uadd_scalar_0(i8 %a) {
; CHECK-LABEL: @uadd_scalar_0(
; CHECK-NEXT:    ret i8 [[A:%.*]]
;
  %x1 = call i8 @llvm.uadd.sat.i8(i8 %a, i8 0)
  ret i8 %x1
}

define <2 x i8> @uadd_vector_0(<2 x i8> %a) {
; CHECK-LABEL: @uadd_vector_0(
; CHECK-NEXT:    ret <2 x i8> [[A:%.*]]
;
  %x1v = call <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8> %a, <2 x i8> zeroinitializer)
  ret <2 x i8> %x1v
}

define i3 @uadd_scalar_0_commute(i3 %a) {
; CHECK-LABEL: @uadd_scalar_0_commute(
; CHECK-NEXT:    ret i3 [[A:%.*]]
;
  %x2 = call i3 @llvm.uadd.sat.i3(i3 0, i3 %a)
  ret i3 %x2
}

define <2 x i8> @uadd_vector_0_commute(<2 x i8> %a) {
; CHECK-LABEL: @uadd_vector_0_commute(
; CHECK-NEXT:    ret <2 x i8> [[A:%.*]]
;
  %x2v = call <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8> <i8 0, i8 poison>, <2 x i8> %a)
  ret <2 x i8> %x2v
}

define i8 @uadd_scalar_maxval(i8 %a) {
; CHECK-LABEL: @uadd_scalar_maxval(
; CHECK-NEXT:    ret i8 -1
;
  %x3 = call i8 @llvm.uadd.sat.i8(i8 %a, i8 255)
  ret i8 %x3
}

define <2 x i9> @uadd_vector_maxval(<2 x i9> %a) {
; CHECK-LABEL: @uadd_vector_maxval(
; CHECK-NEXT:    ret <2 x i9> splat (i9 -1)
;
  %x3v = call <2 x i9> @llvm.uadd.sat.v2i9(<2 x i9> %a, <2 x i9> <i9 511, i9 511>)
  ret <2 x i9> %x3v
}

define i3 @uadd_scalar_maxval_commute(i3 %a) {
; CHECK-LABEL: @uadd_scalar_maxval_commute(
; CHECK-NEXT:    ret i3 -1
;
  %x4 = call i3 @llvm.uadd.sat.i3(i3 7, i3 %a)
  ret i3 %x4
}

define <2 x i8> @uadd_vector_maxval_commute(<2 x i8> %a) {
; CHECK-LABEL: @uadd_vector_maxval_commute(
; CHECK-NEXT:    ret <2 x i8> splat (i8 -1)
;
  %x4v = call <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8> <i8 255, i8 255>, <2 x i8> %a)
  ret <2 x i8> %x4v
}

define i8 @uadd_scalar_undef(i8 %a) {
; CHECK-LABEL: @uadd_scalar_undef(
; CHECK-NEXT:    ret i8 -1
;
  %x5 = call i8 @llvm.uadd.sat.i8(i8 %a, i8 undef)
  ret i8 %x5
}

define i8 @uadd_scalar_poison(i8 %a) {
; CHECK-LABEL: @uadd_scalar_poison(
; CHECK-NEXT:    ret i8 -1
;
  %x5 = call i8 @llvm.uadd.sat.i8(i8 %a, i8 poison)
  ret i8 %x5
}

define <2 x i8> @uadd_vector_undef(<2 x i8> %a) {
; CHECK-LABEL: @uadd_vector_undef(
; CHECK-NEXT:    ret <2 x i8> splat (i8 -1)
;
  %x5v = call <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8> %a, <2 x i8> <i8 undef, i8 undef>)
  ret <2 x i8> %x5v
}

define <2 x i8> @uadd_vector_poison(<2 x i8> %a) {
; CHECK-LABEL: @uadd_vector_poison(
; CHECK-NEXT:    ret <2 x i8> splat (i8 -1)
;
  %x5v = call <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8> %a, <2 x i8> <i8 poison, i8 poison>)
  ret <2 x i8> %x5v
}

define i8 @uadd_scalar_undef_commute(i8 %a) {
; CHECK-LABEL: @uadd_scalar_undef_commute(
; CHECK-NEXT:    ret i8 -1
;
  %x6 = call i8 @llvm.uadd.sat.i8(i8 undef, i8 %a)
  ret i8 %x6
}

define i8 @uadd_scalar_poison_commute(i8 %a) {
; CHECK-LABEL: @uadd_scalar_poison_commute(
; CHECK-NEXT:    ret i8 -1
;
  %x6 = call i8 @llvm.uadd.sat.i8(i8 poison, i8 %a)
  ret i8 %x6
}

define <2 x i8> @uadd_vector_undef_commute(<2 x i8> %a) {
; CHECK-LABEL: @uadd_vector_undef_commute(
; CHECK-NEXT:    ret <2 x i8> splat (i8 -1)
;
  %x5v = call <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8> undef, <2 x i8> %a)
  ret <2 x i8> %x5v
}

define <2 x i8> @uadd_vector_poison_commute(<2 x i8> %a) {
; CHECK-LABEL: @uadd_vector_poison_commute(
; CHECK-NEXT:    ret <2 x i8> splat (i8 -1)
;
  %x5v = call <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8> poison, <2 x i8> %a)
  ret <2 x i8> %x5v
}

define i8 @sadd_scalar_0(i8 %a) {
; CHECK-LABEL: @sadd_scalar_0(
; CHECK-NEXT:    ret i8 [[A:%.*]]
;
  %y1 = call i8 @llvm.sadd.sat.i8(i8 %a, i8 0)
  ret i8 %y1
}

define <2 x i8> @sadd_vector_0(<2 x i8> %a) {
; CHECK-LABEL: @sadd_vector_0(
; CHECK-NEXT:    ret <2 x i8> [[A:%.*]]
;
  %y1v = call <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8> %a, <2 x i8> <i8 poison, i8 0>)
  ret <2 x i8> %y1v
}

define i8 @sadd_scalar_0_commute(i8 %a) {
; CHECK-LABEL: @sadd_scalar_0_commute(
; CHECK-NEXT:    ret i8 [[A:%.*]]
;
  %y2 = call i8 @llvm.sadd.sat.i8(i8 0, i8 %a)
  ret i8 %y2
}

define <2 x i8> @sadd_vector_0_commute(<2 x i8> %a) {
; CHECK-LABEL: @sadd_vector_0_commute(
; CHECK-NEXT:    ret <2 x i8> [[A:%.*]]
;
  %y2v = call <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8> zeroinitializer, <2 x i8> %a)
  ret <2 x i8> %y2v
}

define i8 @sadd_scalar_maxval(i8 %a) {
; CHECK-LABEL: @sadd_scalar_maxval(
; CHECK-NEXT:    [[Y3:%.*]] = call i8 @llvm.sadd.sat.i8(i8 [[A:%.*]], i8 127)
; CHECK-NEXT:    ret i8 [[Y3]]
;
  %y3 = call i8 @llvm.sadd.sat.i8(i8 %a, i8 127)
  ret i8 %y3
}

define <2 x i8> @sadd_vector_maxval(<2 x i8> %a) {
; CHECK-LABEL: @sadd_vector_maxval(
; CHECK-NEXT:    [[Y3V:%.*]] = call <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8> [[A:%.*]], <2 x i8> splat (i8 127))
; CHECK-NEXT:    ret <2 x i8> [[Y3V]]
;
  %y3v = call <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8> %a, <2 x i8> <i8 127, i8 127>)
  ret <2 x i8> %y3v
}

define i8 @sadd_scalar_maxval_commute(i8 %a) {
; CHECK-LABEL: @sadd_scalar_maxval_commute(
; CHECK-NEXT:    [[Y4:%.*]] = call i8 @llvm.sadd.sat.i8(i8 127, i8 [[A:%.*]])
; CHECK-NEXT:    ret i8 [[Y4]]
;
  %y4 = call i8 @llvm.sadd.sat.i8(i8 127, i8 %a)
  ret i8 %y4
}

define <2 x i8> @sadd_vector_maxval_commute(<2 x i8> %a) {
; CHECK-LABEL: @sadd_vector_maxval_commute(
; CHECK-NEXT:    [[Y4V:%.*]] = call <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8> <i8 poison, i8 127>, <2 x i8> [[A:%.*]])
; CHECK-NEXT:    ret <2 x i8> [[Y4V]]
;
  %y4v = call <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8> <i8 poison, i8 127>, <2 x i8> %a)
  ret <2 x i8> %y4v
}

define i8 @sadd_scalar_undef(i8 %a) {
; CHECK-LABEL: @sadd_scalar_undef(
; CHECK-NEXT:    ret i8 -1
;
  %y5 = call i8 @llvm.sadd.sat.i8(i8 %a, i8 undef)
  ret i8 %y5
}

define i8 @sadd_scalar_poison(i8 %a) {
; CHECK-LABEL: @sadd_scalar_poison(
; CHECK-NEXT:    ret i8 -1
;
  %y5 = call i8 @llvm.sadd.sat.i8(i8 %a, i8 poison)
  ret i8 %y5
}

define <2 x i8> @sadd_vector_undef(<2 x i8> %a) {
; CHECK-LABEL: @sadd_vector_undef(
; CHECK-NEXT:    ret <2 x i8> splat (i8 -1)
;
  %y5v = call <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8> %a, <2 x i8> undef)
  ret <2 x i8> %y5v
}

define <2 x i8> @sadd_vector_poison(<2 x i8> %a) {
; CHECK-LABEL: @sadd_vector_poison(
; CHECK-NEXT:    ret <2 x i8> splat (i8 -1)
;
  %y5v = call <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8> %a, <2 x i8> poison)
  ret <2 x i8> %y5v
}

define i8 @sadd_scalar_undef_commute(i8 %a) {
; CHECK-LABEL: @sadd_scalar_undef_commute(
; CHECK-NEXT:    ret i8 -1
;
  %y6 = call i8 @llvm.sadd.sat.i8(i8 undef, i8 %a)
  ret i8 %y6
}

define i8 @sadd_scalar_poison_commute(i8 %a) {
; CHECK-LABEL: @sadd_scalar_poison_commute(
; CHECK-NEXT:    ret i8 -1
;
  %y6 = call i8 @llvm.sadd.sat.i8(i8 poison, i8 %a)
  ret i8 %y6
}

define <2 x i8> @sadd_vector_undef_commute(<2 x i8> %a) {
; CHECK-LABEL: @sadd_vector_undef_commute(
; CHECK-NEXT:    ret <2 x i8> splat (i8 -1)
;
  %y6v = call <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8> undef, <2 x i8> %a)
  ret <2 x i8> %y6v
}

define <2 x i8> @sadd_vector_poison_commute(<2 x i8> %a) {
; CHECK-LABEL: @sadd_vector_poison_commute(
; CHECK-NEXT:    ret <2 x i8> splat (i8 -1)
;
  %y6v = call <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8> poison, <2 x i8> %a)
  ret <2 x i8> %y6v
}

define i8 @usub_scalar_0(i8 %a) {
; CHECK-LABEL: @usub_scalar_0(
; CHECK-NEXT:    ret i8 [[A:%.*]]
;
  %x1 = call i8 @llvm.usub.sat.i8(i8 %a, i8 0)
  ret i8 %x1
}

define <2 x i8> @usub_vector_0(<2 x i8> %a) {
; CHECK-LABEL: @usub_vector_0(
; CHECK-NEXT:    ret <2 x i8> [[A:%.*]]
;
  %x1v = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> %a, <2 x i8> <i8 0, i8 0>)
  ret <2 x i8> %x1v
}

define i8 @usub_scalar_0_commute(i8 %a) {
; CHECK-LABEL: @usub_scalar_0_commute(
; CHECK-NEXT:    ret i8 0
;
  %x2 = call i8 @llvm.usub.sat.i8(i8 0, i8 %a)
  ret i8 %x2
}

define <2 x i8> @usub_vector_0_commute(<2 x i8> %a) {
; CHECK-LABEL: @usub_vector_0_commute(
; CHECK-NEXT:    ret <2 x i8> zeroinitializer
;
  %x2v = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> <i8 0, i8 0>, <2 x i8> %a)
  ret <2 x i8> %x2v
}

define i8 @usub_scalar_maxval(i8 %a) {
; CHECK-LABEL: @usub_scalar_maxval(
; CHECK-NEXT:    ret i8 0
;
  %x3 = call i8 @llvm.usub.sat.i8(i8 %a, i8 255)
  ret i8 %x3
}

define <2 x i8> @usub_vector_maxval(<2 x i8> %a) {
; CHECK-LABEL: @usub_vector_maxval(
; CHECK-NEXT:    ret <2 x i8> zeroinitializer
;
  %x3v = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> %a, <2 x i8> <i8 255, i8 255>)
  ret <2 x i8> %x3v
}

define i8 @usub_scalar_undef(i8 %a) {
; CHECK-LABEL: @usub_scalar_undef(
; CHECK-NEXT:    ret i8 0
;
  %x4 = call i8 @llvm.usub.sat.i8(i8 %a, i8 undef)
  ret i8 %x4
}

define i8 @usub_scalar_poison(i8 %a) {
; CHECK-LABEL: @usub_scalar_poison(
; CHECK-NEXT:    ret i8 0
;
  %x4 = call i8 @llvm.usub.sat.i8(i8 %a, i8 poison)
  ret i8 %x4
}

define <2 x i8> @usub_vector_undef(<2 x i8> %a) {
; CHECK-LABEL: @usub_vector_undef(
; CHECK-NEXT:    ret <2 x i8> zeroinitializer
;
  %x4v = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> %a, <2 x i8> <i8 undef, i8 undef>)
  ret <2 x i8> %x4v
}

define <2 x i8> @usub_vector_poison(<2 x i8> %a) {
; CHECK-LABEL: @usub_vector_poison(
; CHECK-NEXT:    ret <2 x i8> zeroinitializer
;
  %x4v = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> %a, <2 x i8> <i8 poison, i8 poison>)
  ret <2 x i8> %x4v
}

define i8 @usub_scalar_undef_commute(i8 %a) {
; CHECK-LABEL: @usub_scalar_undef_commute(
; CHECK-NEXT:    ret i8 0
;
  %x5 = call i8 @llvm.usub.sat.i8(i8 undef, i8 %a)
  ret i8 %x5
}

define i8 @usub_scalar_poison_commute(i8 %a) {
; CHECK-LABEL: @usub_scalar_poison_commute(
; CHECK-NEXT:    ret i8 0
;
  %x5 = call i8 @llvm.usub.sat.i8(i8 poison, i8 %a)
  ret i8 %x5
}

define <2 x i8> @usub_vector_undef_commute(<2 x i8> %a) {
; CHECK-LABEL: @usub_vector_undef_commute(
; CHECK-NEXT:    ret <2 x i8> zeroinitializer
;
  %x5v = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> <i8 undef, i8 undef>, <2 x i8> %a)
  ret <2 x i8> %x5v
}

define <2 x i8> @usub_vector_poison_commute(<2 x i8> %a) {
; CHECK-LABEL: @usub_vector_poison_commute(
; CHECK-NEXT:    ret <2 x i8> zeroinitializer
;
  %x5v = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> <i8 poison, i8 poison>, <2 x i8> %a)
  ret <2 x i8> %x5v
}

define i8 @usub_scalar_same(i8 %a) {
; CHECK-LABEL: @usub_scalar_same(
; CHECK-NEXT:    ret i8 0
;
  %x6 = call i8 @llvm.usub.sat.i8(i8 %a, i8 %a)
  ret i8 %x6
}

define <2 x i8> @usub_vector_same(<2 x i8> %a) {
; CHECK-LABEL: @usub_vector_same(
; CHECK-NEXT:    ret <2 x i8> zeroinitializer
;
  %x6v = call <2 x i8> @llvm.usub.sat.v2i8(<2 x i8> %a, <2 x i8> %a)
  ret <2 x i8> %x6v
}

define i8 @ssub_scalar_0(i8 %a) {
; CHECK-LABEL: @ssub_scalar_0(
; CHECK-NEXT:    ret i8 [[A:%.*]]
;
  %y1 = call i8 @llvm.ssub.sat.i8(i8 %a, i8 0)
  ret i8 %y1
}

define <2 x i8> @ssub_vector_0(<2 x i8> %a) {
; CHECK-LABEL: @ssub_vector_0(
; CHECK-NEXT:    ret <2 x i8> [[A:%.*]]
;
  %y1v = call <2 x i8> @llvm.ssub.sat.v2i8(<2 x i8> %a, <2 x i8> <i8 0, i8 0>)
  ret <2 x i8> %y1v
}

define i8 @ssub_scalar_0_commute(i8 %a) {
; CHECK-LABEL: @ssub_scalar_0_commute(
; CHECK-NEXT:    [[Y2:%.*]] = call i8 @llvm.ssub.sat.i8(i8 0, i8 [[A:%.*]])
; CHECK-NEXT:    ret i8 [[Y2]]
;
  %y2 = call i8 @llvm.ssub.sat.i8(i8 0, i8 %a)
  ret i8 %y2
}

define <2 x i8> @ssub_vector_0_commute(<2 x i8> %a) {
; CHECK-LABEL: @ssub_vector_0_commute(
; CHECK-NEXT:    [[Y2V:%.*]] = call <2 x i8> @llvm.ssub.sat.v2i8(<2 x i8> zeroinitializer, <2 x i8> [[A:%.*]])
; CHECK-NEXT:    ret <2 x i8> [[Y2V]]
;
  %y2v = call <2 x i8> @llvm.ssub.sat.v2i8(<2 x i8> <i8 0, i8 0>, <2 x i8> %a)
  ret <2 x i8> %y2v
}

define i8 @ssub_scalar_maxval(i8 %a) {
; CHECK-LABEL: @ssub_scalar_maxval(
; CHECK-NEXT:    [[Y3:%.*]] = call i8 @llvm.ssub.sat.i8(i8 [[A:%.*]], i8 127)
; CHECK-NEXT:    ret i8 [[Y3]]
;
  %y3 = call i8 @llvm.ssub.sat.i8(i8 %a, i8 127)
  ret i8 %y3
}

define <2 x i8> @ssub_vector_maxval(<2 x i8> %a) {
; CHECK-LABEL: @ssub_vector_maxval(
; CHECK-NEXT:    [[Y3V:%.*]] = call <2 x i8> @llvm.ssub.sat.v2i8(<2 x i8> [[A:%.*]], <2 x i8> splat (i8 127))
; CHECK-NEXT:    ret <2 x i8> [[Y3V]]
;
  %y3v = call <2 x i8> @llvm.ssub.sat.v2i8(<2 x i8> %a, <2 x i8> <i8 127, i8 127>)
  ret <2 x i8> %y3v
}

define i8 @ssub_scalar_undef(i8 %a) {
; CHECK-LABEL: @ssub_scalar_undef(
; CHECK-NEXT:    ret i8 0
;
  %y4 = call i8 @llvm.ssub.sat.i8(i8 %a, i8 undef)
  ret i8 %y4
}

define i8 @ssub_scalar_poison(i8 %a) {
; CHECK-LABEL: @ssub_scalar_poison(
; CHECK-NEXT:    ret i8 0
;
  %y4 = call i8 @llvm.ssub.sat.i8(i8 %a, i8 poison)
  ret i8 %y4
}

define <2 x i8> @ssub_vector_undef(<2 x i8> %a) {
; CHECK-LABEL: @ssub_vector_undef(
; CHECK-NEXT:    ret <2 x i8> zeroinitializer
;
  %y4v = call <2 x i8> @llvm.ssub.sat.v2i8(<2 x i8> %a, <2 x i8> undef)
  ret <2 x i8> %y4v
}

define <2 x i8> @ssub_vector_poison(<2 x i8> %a) {
; CHECK-LABEL: @ssub_vector_poison(
; CHECK-NEXT:    ret <2 x i8> zeroinitializer
;
  %y4v = call <2 x i8> @llvm.ssub.sat.v2i8(<2 x i8> %a, <2 x i8> poison)
  ret <2 x i8> %y4v
}

define i8 @ssub_scalar_undef_commute(i8 %a) {
; CHECK-LABEL: @ssub_scalar_undef_commute(
; CHECK-NEXT:    ret i8 0
;
  %y5 = call i8 @llvm.ssub.sat.i8(i8 undef, i8 %a)
  ret i8 %y5
}

define i8 @ssub_scalar_poison_commute(i8 %a) {
; CHECK-LABEL: @ssub_scalar_poison_commute(
; CHECK-NEXT:    ret i8 0
;
  %y5 = call i8 @llvm.ssub.sat.i8(i8 poison, i8 %a)
  ret i8 %y5
}

define <2 x i8> @ssub_vector_undef_commute(<2 x i8> %a) {
; CHECK-LABEL: @ssub_vector_undef_commute(
; CHECK-NEXT:    ret <2 x i8> zeroinitializer
;
  %y5v = call <2 x i8> @llvm.ssub.sat.v2i8(<2 x i8> <i8 undef, i8 undef>, <2 x i8> %a)
  ret <2 x i8> %y5v
}

define <2 x i8> @ssub_vector_poison_commute(<2 x i8> %a) {
; CHECK-LABEL: @ssub_vector_poison_commute(
; CHECK-NEXT:    ret <2 x i8> zeroinitializer
;
  %y5v = call <2 x i8> @llvm.ssub.sat.v2i8(<2 x i8> <i8 poison, i8 poison>, <2 x i8> %a)
  ret <2 x i8> %y5v
}

define i8 @ssub_scalar_same(i8 %a) {
; CHECK-LABEL: @ssub_scalar_same(
; CHECK-NEXT:    ret i8 0
;
  %y6 = call i8 @llvm.ssub.sat.i8(i8 %a, i8 %a)
  ret i8 %y6
}

define <2 x i8> @ssub_vector_same(<2 x i8> %a) {
; CHECK-LABEL: @ssub_vector_same(
; CHECK-NEXT:    ret <2 x i8> zeroinitializer
;
  %y6v = call <2 x i8> @llvm.ssub.sat.v2i8(<2 x i8> %a, <2 x i8> %a)
  ret <2 x i8> %y6v
}

define i1 @uadd_icmp_op0_known(i8 %a) {
; CHECK-LABEL: @uadd_icmp_op0_known(
; CHECK-NEXT:    ret i1 true
;
  %b = call i8 @llvm.uadd.sat.i8(i8 10, i8 %a)
  %c = icmp uge i8 %b, 10
  ret i1 %c
}

define i1 @uadd_icmp_op0_unknown(i8 %a) {
; CHECK-LABEL: @uadd_icmp_op0_unknown(
; CHECK-NEXT:    [[B:%.*]] = call i8 @llvm.uadd.sat.i8(i8 10, i8 [[A:%.*]])
; CHECK-NEXT:    [[C:%.*]] = icmp ugt i8 [[B]], 10
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = call i8 @llvm.uadd.sat.i8(i8 10, i8 %a)
  %c = icmp ugt i8 %b, 10
  ret i1 %c
}

define i1 @uadd_icmp_op1_known(i8 %a) {
; CHECK-LABEL: @uadd_icmp_op1_known(
; CHECK-NEXT:    ret i1 true
;
  %b = call i8 @llvm.uadd.sat.i8(i8 %a, i8 10)
  %c = icmp uge i8 %b, 10
  ret i1 %c
}

define i1 @uadd_icmp_op1_unknown(i8 %a) {
; CHECK-LABEL: @uadd_icmp_op1_unknown(
; CHECK-NEXT:    [[B:%.*]] = call i8 @llvm.uadd.sat.i8(i8 [[A:%.*]], i8 10)
; CHECK-NEXT:    [[C:%.*]] = icmp ugt i8 [[B]], 10
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = call i8 @llvm.uadd.sat.i8(i8 %a, i8 10)
  %c = icmp ugt i8 %b, 10
  ret i1 %c
}

define i1 @sadd_icmp_op0_pos_known(i8 %a) {
; CHECK-LABEL: @sadd_icmp_op0_pos_known(
; CHECK-NEXT:    ret i1 true
;
  %b = call i8 @llvm.sadd.sat.i8(i8 10, i8 %a)
  %c = icmp sge i8 %b, -118
  ret i1 %c
}

define i1 @sadd_icmp_op0_pos_unknown(i8 %a) {
; CHECK-LABEL: @sadd_icmp_op0_pos_unknown(
; CHECK-NEXT:    [[B:%.*]] = call i8 @llvm.sadd.sat.i8(i8 10, i8 [[A:%.*]])
; CHECK-NEXT:    [[C:%.*]] = icmp sgt i8 [[B]], -118
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = call i8 @llvm.sadd.sat.i8(i8 10, i8 %a)
  %c = icmp sgt i8 %b, -118
  ret i1 %c
}

define i1 @sadd_icmp_op0_neg_known(i8 %a) {
; CHECK-LABEL: @sadd_icmp_op0_neg_known(
; CHECK-NEXT:    ret i1 true
;
  %b = call i8 @llvm.sadd.sat.i8(i8 -10, i8 %a)
  %c = icmp sle i8 %b, 117
  ret i1 %c
}

define i1 @sadd_icmp_op0_neg_unknown(i8 %a) {
; CHECK-LABEL: @sadd_icmp_op0_neg_unknown(
; CHECK-NEXT:    [[B:%.*]] = call i8 @llvm.sadd.sat.i8(i8 -10, i8 [[A:%.*]])
; CHECK-NEXT:    [[C:%.*]] = icmp slt i8 [[B]], 117
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = call i8 @llvm.sadd.sat.i8(i8 -10, i8 %a)
  %c = icmp slt i8 %b, 117
  ret i1 %c
}

define i1 @sadd_icmp_op1_pos_known(i8 %a) {
; CHECK-LABEL: @sadd_icmp_op1_pos_known(
; CHECK-NEXT:    ret i1 true
;
  %b = call i8 @llvm.sadd.sat.i8(i8 %a, i8 10)
  %c = icmp sge i8 %b, -118
  ret i1 %c
}

define i1 @sadd_icmp_op1_pos_unknown(i8 %a) {
; CHECK-LABEL: @sadd_icmp_op1_pos_unknown(
; CHECK-NEXT:    [[B:%.*]] = call i8 @llvm.sadd.sat.i8(i8 [[A:%.*]], i8 10)
; CHECK-NEXT:    [[C:%.*]] = icmp sgt i8 [[B]], -118
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = call i8 @llvm.sadd.sat.i8(i8 %a, i8 10)
  %c = icmp sgt i8 %b, -118
  ret i1 %c
}

define i1 @sadd_icmp_op1_neg_known(i8 %a) {
; CHECK-LABEL: @sadd_icmp_op1_neg_known(
; CHECK-NEXT:    ret i1 true
;
  %b = call i8 @llvm.sadd.sat.i8(i8 %a, i8 -10)
  %c = icmp sle i8 %b, 117
  ret i1 %c
}

define i1 @sadd_icmp_op1_neg_unknown(i8 %a) {
; CHECK-LABEL: @sadd_icmp_op1_neg_unknown(
; CHECK-NEXT:    [[B:%.*]] = call i8 @llvm.sadd.sat.i8(i8 [[A:%.*]], i8 -10)
; CHECK-NEXT:    [[C:%.*]] = icmp slt i8 [[B]], 117
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = call i8 @llvm.sadd.sat.i8(i8 %a, i8 -10)
  %c = icmp slt i8 %b, 117
  ret i1 %c
}

define i1 @usub_icmp_op0_known(i8 %a) {
; CHECK-LABEL: @usub_icmp_op0_known(
; CHECK-NEXT:    ret i1 true
;
  %b = call i8 @llvm.usub.sat.i8(i8 10, i8 %a)
  %c = icmp ule i8 %b, 10
  ret i1 %c
}

define i1 @usub_icmp_op0_unknown(i8 %a) {
; CHECK-LABEL: @usub_icmp_op0_unknown(
; CHECK-NEXT:    [[B:%.*]] = call i8 @llvm.usub.sat.i8(i8 10, i8 [[A:%.*]])
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[B]], 10
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = call i8 @llvm.usub.sat.i8(i8 10, i8 %a)
  %c = icmp ult i8 %b, 10
  ret i1 %c
}

define i1 @usub_icmp_op1_known(i8 %a) {
; CHECK-LABEL: @usub_icmp_op1_known(
; CHECK-NEXT:    ret i1 true
;
  %b = call i8 @llvm.usub.sat.i8(i8 %a, i8 10)
  %c = icmp ule i8 %b, 245
  ret i1 %c
}

define i1 @usub_icmp_op1_unknown(i8 %a) {
; CHECK-LABEL: @usub_icmp_op1_unknown(
; CHECK-NEXT:    [[B:%.*]] = call i8 @llvm.usub.sat.i8(i8 [[A:%.*]], i8 10)
; CHECK-NEXT:    [[C:%.*]] = icmp ult i8 [[B]], -11
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = call i8 @llvm.usub.sat.i8(i8 %a, i8 10)
  %c = icmp ult i8 %b, 245
  ret i1 %c
}

define i1 @ssub_icmp_op0_pos_known(i8 %a) {
; CHECK-LABEL: @ssub_icmp_op0_pos_known(
; CHECK-NEXT:    ret i1 true
;
  %b = call i8 @llvm.ssub.sat.i8(i8 10, i8 %a)
  %c = icmp sge i8 %b, -117
  ret i1 %c
}

define i1 @ssub_icmp_op0_pos_unknown(i8 %a) {
; CHECK-LABEL: @ssub_icmp_op0_pos_unknown(
; CHECK-NEXT:    [[B:%.*]] = call i8 @llvm.ssub.sat.i8(i8 10, i8 [[A:%.*]])
; CHECK-NEXT:    [[C:%.*]] = icmp sgt i8 [[B]], -117
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = call i8 @llvm.ssub.sat.i8(i8 10, i8 %a)
  %c = icmp sgt i8 %b, -117
  ret i1 %c
}

define i1 @ssub_icmp_op0_neg_known(i8 %a) {
; CHECK-LABEL: @ssub_icmp_op0_neg_known(
; CHECK-NEXT:    ret i1 true
;
  %b = call i8 @llvm.ssub.sat.i8(i8 -10, i8 %a)
  %c = icmp sle i8 %b, 118
  ret i1 %c
}

define i1 @ssub_icmp_op0_neg_unknown(i8 %a) {
; CHECK-LABEL: @ssub_icmp_op0_neg_unknown(
; CHECK-NEXT:    [[B:%.*]] = call i8 @llvm.ssub.sat.i8(i8 -10, i8 [[A:%.*]])
; CHECK-NEXT:    [[C:%.*]] = icmp slt i8 [[B]], 118
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = call i8 @llvm.ssub.sat.i8(i8 -10, i8 %a)
  %c = icmp slt i8 %b, 118
  ret i1 %c
}

; Peculiar case: ssub.sat(0, x) is never signed min.
define i1 @ssub_icmp_op0_zero(i8 %a) {
; CHECK-LABEL: @ssub_icmp_op0_zero(
; CHECK-NEXT:    ret i1 true
;
  %b = call i8 @llvm.ssub.sat.i8(i8 0, i8 %a)
  %c = icmp ne i8 %b, -128
  ret i1 %c
}

define i1 @ssub_icmp_op1_pos_known(i8 %a) {
; CHECK-LABEL: @ssub_icmp_op1_pos_known(
; CHECK-NEXT:    ret i1 true
;
  %b = call i8 @llvm.ssub.sat.i8(i8 %a, i8 10)
  %c = icmp sle i8 %b, 117
  ret i1 %c
}

define i1 @ssub_icmp_op1_pos_unknown(i8 %a) {
; CHECK-LABEL: @ssub_icmp_op1_pos_unknown(
; CHECK-NEXT:    [[B:%.*]] = call i8 @llvm.ssub.sat.i8(i8 [[A:%.*]], i8 10)
; CHECK-NEXT:    [[C:%.*]] = icmp slt i8 [[B]], 117
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = call i8 @llvm.ssub.sat.i8(i8 %a, i8 10)
  %c = icmp slt i8 %b, 117
  ret i1 %c
}

define i1 @ssub_icmp_op1_neg_known(i8 %a) {
; CHECK-LABEL: @ssub_icmp_op1_neg_known(
; CHECK-NEXT:    ret i1 true
;
  %b = call i8 @llvm.ssub.sat.i8(i8 %a, i8 -10)
  %c = icmp sge i8 %b, -118
  ret i1 %c
}

define i1 @ssub_icmp_op1_neg_unknown(i8 %a) {
; CHECK-LABEL: @ssub_icmp_op1_neg_unknown(
; CHECK-NEXT:    [[B:%.*]] = call i8 @llvm.ssub.sat.i8(i8 [[A:%.*]], i8 -10)
; CHECK-NEXT:    [[C:%.*]] = icmp sgt i8 [[B]], -118
; CHECK-NEXT:    ret i1 [[C]]
;
  %b = call i8 @llvm.ssub.sat.i8(i8 %a, i8 -10)
  %c = icmp sgt i8 %b, -118
  ret i1 %c
}

define i1 @ssub_icmp_op1_smin(i8 %a) {
; CHECK-LABEL: @ssub_icmp_op1_smin(
; CHECK-NEXT:    ret i1 true
;
  %b = call i8 @llvm.ssub.sat.i8(i8 %a, i8 -128)
  %c = icmp sge i8 %b, 0
  ret i1 %c
}

define i1 @uadd_uge(i8 %x, i8 %y) {
; CHECK-LABEL: @uadd_uge(
; CHECK-NEXT:    ret i1 true
;
  %sat = call i8 @llvm.uadd.sat.i8(i8 %x, i8 %y)
  %cmp = icmp uge i8 %sat, %x
  ret i1 %cmp
}

define i1 @uadd_uge_rhs(i8 %x, i8 %y) {
; CHECK-LABEL: @uadd_uge_rhs(
; CHECK-NEXT:    ret i1 true
;
  %sat = call i8 @llvm.uadd.sat.i8(i8 %x, i8 %y)
  %cmp = icmp uge i8 %sat, %y
  ret i1 %cmp
}

define i1 @uadd_uge_commuted(i8 %x, i8 %y) {
; CHECK-LABEL: @uadd_uge_commuted(
; CHECK-NEXT:    ret i1 true
;
  %sat = call i8 @llvm.uadd.sat.i8(i8 %x, i8 %y)
  %cmp = icmp ule i8 %x, %sat
  ret i1 %cmp
}

define i1 @uadd_ult(i8 %x, i8 %y) {
; CHECK-LABEL: @uadd_ult(
; CHECK-NEXT:    ret i1 false
;
  %sat = call i8 @llvm.uadd.sat.i8(i8 %x, i8 %y)
  %cmp = icmp ult i8 %sat, %x
  ret i1 %cmp
}

define <2 x i1> @uadd_uge_vec(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @uadd_uge_vec(
; CHECK-NEXT:    ret <2 x i1> splat (i1 true)
;
  %sat = call <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8> %x, <2 x i8> %y)
  %cmp = icmp uge <2 x i8> %sat, %x
  ret <2 x i1> %cmp
}

define i1 @uadd_ugt_fail(i8 %x, i8 %y) {
; CHECK-LABEL: @uadd_ugt_fail(
; CHECK-NEXT:    [[SAT:%.*]] = call i8 @llvm.uadd.sat.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[SAT]], [[X]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sat = call i8 @llvm.uadd.sat.i8(i8 %x, i8 %y)
  %cmp = icmp ugt i8 %sat, %x
  ret i1 %cmp
}

define i1 @uadd_ule_fail(i8 %x, i8 %y) {
; CHECK-LABEL: @uadd_ule_fail(
; CHECK-NEXT:    [[SAT:%.*]] = call i8 @llvm.uadd.sat.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i8 [[SAT]], [[X]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sat = call i8 @llvm.uadd.sat.i8(i8 %x, i8 %y)
  %cmp = icmp ule i8 %sat, %x
  ret i1 %cmp
}

define i1 @uadd_uge_unrelated_op_fail(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @uadd_uge_unrelated_op_fail(
; CHECK-NEXT:    [[SAT:%.*]] = call i8 @llvm.uadd.sat.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp uge i8 [[SAT]], [[Z:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sat = call i8 @llvm.uadd.sat.i8(i8 %x, i8 %y)
  %cmp = icmp uge i8 %sat, %z
  ret i1 %cmp
}

define i1 @usub_ule(i8 %x, i8 %y) {
; CHECK-LABEL: @usub_ule(
; CHECK-NEXT:    ret i1 true
;
  %sat = call i8 @llvm.usub.sat.i8(i8 %x, i8 %y)
  %cmp = icmp ule i8 %sat, %x
  ret i1 %cmp
}

define i1 @usub_ule_rhs_fail(i8 %x, i8 %y) {
; CHECK-LABEL: @usub_ule_rhs_fail(
; CHECK-NEXT:    [[SAT:%.*]] = call i8 @llvm.usub.sat.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i8 [[SAT]], [[Y]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sat = call i8 @llvm.usub.sat.i8(i8 %x, i8 %y)
  %cmp = icmp ule i8 %sat, %y
  ret i1 %cmp
}

define i1 @usub_ule_commuted(i8 %x, i8 %y) {
; CHECK-LABEL: @usub_ule_commuted(
; CHECK-NEXT:    ret i1 true
;
  %sat = call i8 @llvm.usub.sat.i8(i8 %x, i8 %y)
  %cmp = icmp uge i8 %x, %sat
  ret i1 %cmp
}

define i1 @usub_ugt(i8 %x, i8 %y) {
; CHECK-LABEL: @usub_ugt(
; CHECK-NEXT:    ret i1 false
;
  %sat = call i8 @llvm.usub.sat.i8(i8 %x, i8 %y)
  %cmp = icmp ugt i8 %sat, %x
  ret i1 %cmp
}

define i1 @usub_ult_fail(i8 %x, i8 %y) {
; CHECK-LABEL: @usub_ult_fail(
; CHECK-NEXT:    [[SAT:%.*]] = call i8 @llvm.usub.sat.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[SAT]], [[X]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sat = call i8 @llvm.usub.sat.i8(i8 %x, i8 %y)
  %cmp = icmp ult i8 %sat, %x
  ret i1 %cmp
}

define i1 @usub_uge_fail(i8 %x, i8 %y) {
; CHECK-LABEL: @usub_uge_fail(
; CHECK-NEXT:    [[SAT:%.*]] = call i8 @llvm.usub.sat.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    [[CMP:%.*]] = icmp uge i8 [[SAT]], [[X]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sat = call i8 @llvm.usub.sat.i8(i8 %x, i8 %y)
  %cmp = icmp uge i8 %sat, %x
  ret i1 %cmp
}

define i1 @icmp_ult_uaddsat_add(i32 %x, i32 %y) {
; CHECK-LABEL: @icmp_ult_uaddsat_add(
; CHECK-NEXT:    ret i1 false
;
  %uaddsat = call i32 @llvm.uadd.sat.i32(i32 %x, i32 %y)
  %add = add i32 %x, %y
  %cmp = icmp ult i32 %uaddsat, %add
  ret i1 %cmp
}

define i1 @icmp_uge_uaddsat_add(i32 %x, i32 %y) {
; CHECK-LABEL: @icmp_uge_uaddsat_add(
; CHECK-NEXT:    ret i1 true
;
  %uaddsat = call i32 @llvm.uadd.sat.i32(i32 %x, i32 %y)
  %add = add i32 %x, %y
  %cmp = icmp uge i32 %uaddsat, %add
  ret i1 %cmp
}

define i1 @icmp_ugt_uaddsat_add_commuted1(i32 %x, i32 %y) {
; CHECK-LABEL: @icmp_ugt_uaddsat_add_commuted1(
; CHECK-NEXT:    ret i1 false
;
  %uaddsat = call i32 @llvm.uadd.sat.i32(i32 %x, i32 %y)
  %add = add i32 %x, %y
  %cmp = icmp ugt i32 %add, %uaddsat
  ret i1 %cmp
}

define i1 @icmp_ult_uaddsat_add_commuted2(i32 %x, i32 %y) {
; CHECK-LABEL: @icmp_ult_uaddsat_add_commuted2(
; CHECK-NEXT:    ret i1 false
;
  %xx = mul i32 %x, 998244353
  %yy = mul i32 %y, 998244353
  %uaddsat = call i32 @llvm.uadd.sat.i32(i32 %xx, i32 %yy)
  %add = add i32 %yy, %xx ; thwart complexity-based canonicalization
  %cmp = icmp ult i32 %uaddsat, %add
  ret i1 %cmp
}

define i1 @icmp_ule_usubsat_sub(i32 %x, i32 %y) {
; CHECK-LABEL: @icmp_ule_usubsat_sub(
; CHECK-NEXT:    ret i1 true
;
  %usubsat = call i32 @llvm.usub.sat.i32(i32 %x, i32 %y)
  %add = sub i32 %x, %y
  %cmp = icmp ule i32 %usubsat, %add
  ret i1 %cmp
}

define i1 @icmp_ugt_usubsat_sub(i32 %x, i32 %y) {
; CHECK-LABEL: @icmp_ugt_usubsat_sub(
; CHECK-NEXT:    ret i1 false
;
  %usubsat = call i32 @llvm.usub.sat.i32(i32 %x, i32 %y)
  %add = sub i32 %x, %y
  %cmp = icmp ugt i32 %usubsat, %add
  ret i1 %cmp
}

; Negative tests

define i1 @icmp_ult_uaddsat_add_mismatch(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @icmp_ult_uaddsat_add_mismatch(
; CHECK-NEXT:    [[UADDSAT:%.*]] = call i32 @llvm.uadd.sat.i32(i32 [[X:%.*]], i32 [[Z:%.*]])
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[X]], [[Y:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[UADDSAT]], [[ADD]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uaddsat = call i32 @llvm.uadd.sat.i32(i32 %x, i32 %z)
  %add = add i32 %x, %y
  %cmp = icmp ult i32 %uaddsat, %add
  ret i1 %cmp
}

define i1 @icmp_ult_uaddsat_add_wrong_pred(i32 %x, i32 %y) {
; CHECK-LABEL: @icmp_ult_uaddsat_add_wrong_pred(
; CHECK-NEXT:    [[UADDSAT:%.*]] = call i32 @llvm.uadd.sat.i32(i32 [[X:%.*]], i32 [[Y:%.*]])
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[X]], [[Y]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[UADDSAT]], [[ADD]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uaddsat = call i32 @llvm.uadd.sat.i32(i32 %x, i32 %y)
  %add = add i32 %x, %y
  %cmp = icmp ule i32 %uaddsat, %add
  ret i1 %cmp
}

define i1 @icmp_ult_uaddsat_add_wrong_op(i32 %x, i32 %y) {
; CHECK-LABEL: @icmp_ult_uaddsat_add_wrong_op(
; CHECK-NEXT:    [[UADDSAT:%.*]] = call i32 @llvm.uadd.sat.i32(i32 [[X:%.*]], i32 [[Y:%.*]])
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[X]], [[Y]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i32 [[UADDSAT]], [[SUB]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %uaddsat = call i32 @llvm.uadd.sat.i32(i32 %x, i32 %y)
  %sub = sub i32 %x, %y
  %cmp = icmp ult i32 %uaddsat, %sub
  ret i1 %cmp
}

define i1 @icmp_ule_usubsat_sub_commuted(i32 %x, i32 %y) {
; CHECK-LABEL: @icmp_ule_usubsat_sub_commuted(
; CHECK-NEXT:    [[USUBSAT:%.*]] = call i32 @llvm.usub.sat.i32(i32 [[X:%.*]], i32 [[Y:%.*]])
; CHECK-NEXT:    [[ADD:%.*]] = sub i32 [[Y]], [[X]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i32 [[USUBSAT]], [[ADD]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %usubsat = call i32 @llvm.usub.sat.i32(i32 %x, i32 %y)
  %add = sub i32 %y, %x
  %cmp = icmp ule i32 %usubsat, %add
  ret i1 %cmp
}
