; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

declare half @llvm.amdgcn.sin.f16(half) #0
declare float @llvm.amdgcn.sin.f32(float) #0
declare double @llvm.amdgcn.sin.f64(double) #0

define void @test_f16(ptr %p) {
; CHECK-LABEL: @test_f16(
; CHECK-NEXT:    store volatile half 0xH0000, ptr [[P:%.*]], align 2
; CHECK-NEXT:    store volatile half 0xH0000, ptr [[P]], align 2
; CHECK-NEXT:    store volatile half 0xH39A8, ptr [[P]], align 2
; CHECK-NEXT:    store volatile half 0xHB9A8, ptr [[P]], align 2
; CHECK-NEXT:    store volatile half 0xH3C00, ptr [[P]], align 2
; CHECK-NEXT:    store volatile half 0xHBC00, ptr [[P]], align 2
; CHECK-NEXT:    store volatile half 0xH0000, ptr [[P]], align 2
; CHECK-NEXT:    store volatile half 0xH0000, ptr [[P]], align 2
; CHECK-NEXT:    store volatile half 0xH0000, ptr [[P]], align 2
; CHECK-NEXT:    store volatile half 0xH0000, ptr [[P]], align 2
; CHECK-NEXT:    store volatile half 0xH0000, ptr [[P]], align 2
; CHECK-NEXT:    store volatile half 0xH0000, ptr [[P]], align 2
; CHECK-NEXT:    [[P1000:%.*]] = call half @llvm.amdgcn.sin.f16(half 0xH63D0)
; CHECK-NEXT:    store volatile half [[P1000]], ptr [[P]], align 2
; CHECK-NEXT:    [[N1000:%.*]] = call half @llvm.amdgcn.sin.f16(half 0xHE3D0)
; CHECK-NEXT:    store volatile half [[N1000]], ptr [[P]], align 2
; CHECK-NEXT:    [[PINF:%.*]] = call half @llvm.amdgcn.sin.f16(half 0xH7C00)
; CHECK-NEXT:    store volatile half [[PINF]], ptr [[P]], align 2
; CHECK-NEXT:    [[NINF:%.*]] = call half @llvm.amdgcn.sin.f16(half 0xHFC00)
; CHECK-NEXT:    store volatile half [[NINF]], ptr [[P]], align 2
; CHECK-NEXT:    [[NAN:%.*]] = call half @llvm.amdgcn.sin.f16(half 0xH7E00)
; CHECK-NEXT:    store volatile half [[NAN]], ptr [[P]], align 2
; CHECK-NEXT:    ret void
;
  %p0 = call half @llvm.amdgcn.sin.f16(half +0.0)
  store volatile half %p0, ptr %p
  %n0 = call half @llvm.amdgcn.sin.f16(half -0.0)
  store volatile half %n0, ptr %p
  %p0125 = call half @llvm.amdgcn.sin.f16(half +0.125)
  store volatile half %p0125, ptr %p
  %n0125 = call half @llvm.amdgcn.sin.f16(half -0.125)
  store volatile half %n0125, ptr %p
  %p025 = call half @llvm.amdgcn.sin.f16(half +0.25)
  store volatile half %p025, ptr %p
  %n025 = call half @llvm.amdgcn.sin.f16(half -0.25)
  store volatile half %n025, ptr %p
  %p05 = call half @llvm.amdgcn.sin.f16(half +0.5)
  store volatile half %p05, ptr %p
  %n05 = call half @llvm.amdgcn.sin.f16(half -0.5)
  store volatile half %n05, ptr %p
  %p1 = call half @llvm.amdgcn.sin.f16(half +1.0)
  store volatile half %p1, ptr %p
  %n1 = call half @llvm.amdgcn.sin.f16(half -1.0)
  store volatile half %n1, ptr %p
  %p256 = call half @llvm.amdgcn.sin.f16(half +256.0)
  store volatile half %p256, ptr %p
  %n256 = call half @llvm.amdgcn.sin.f16(half -256.0)
  store volatile half %n256, ptr %p
  %p1000 = call half @llvm.amdgcn.sin.f16(half +1000.0)
  store volatile half %p1000, ptr %p
  %n1000 = call half @llvm.amdgcn.sin.f16(half -1000.0)
  store volatile half %n1000, ptr %p
  %pinf = call half @llvm.amdgcn.sin.f16(half 0xH7C00) ; +inf
  store volatile half %pinf, ptr %p
  %ninf = call half @llvm.amdgcn.sin.f16(half 0xHFC00) ; -inf
  store volatile half %ninf, ptr %p
  %nan = call half @llvm.amdgcn.sin.f16(half 0xH7E00) ; nan
  store volatile half %nan, ptr %p
  ret void
}

define void @test_f32(ptr %p) {
; CHECK-LABEL: @test_f32(
; CHECK-NEXT:    store volatile float 0.000000e+00, ptr [[P:%.*]], align 4
; CHECK-NEXT:    store volatile float 0.000000e+00, ptr [[P]], align 4
; CHECK-NEXT:    store volatile float 0x3FE6A09E60000000, ptr [[P]], align 4
; CHECK-NEXT:    store volatile float 0xBFE6A09E60000000, ptr [[P]], align 4
; CHECK-NEXT:    store volatile float 1.000000e+00, ptr [[P]], align 4
; CHECK-NEXT:    store volatile float -1.000000e+00, ptr [[P]], align 4
; CHECK-NEXT:    store volatile float 0.000000e+00, ptr [[P]], align 4
; CHECK-NEXT:    store volatile float 0.000000e+00, ptr [[P]], align 4
; CHECK-NEXT:    store volatile float 0.000000e+00, ptr [[P]], align 4
; CHECK-NEXT:    store volatile float 0.000000e+00, ptr [[P]], align 4
; CHECK-NEXT:    store volatile float 0.000000e+00, ptr [[P]], align 4
; CHECK-NEXT:    store volatile float 0.000000e+00, ptr [[P]], align 4
; CHECK-NEXT:    [[P1000:%.*]] = call float @llvm.amdgcn.sin.f32(float 1.000000e+03)
; CHECK-NEXT:    store volatile float [[P1000]], ptr [[P]], align 4
; CHECK-NEXT:    [[N1000:%.*]] = call float @llvm.amdgcn.sin.f32(float -1.000000e+03)
; CHECK-NEXT:    store volatile float [[N1000]], ptr [[P]], align 4
; CHECK-NEXT:    [[PINF:%.*]] = call float @llvm.amdgcn.sin.f32(float 0x7FF0000000000000)
; CHECK-NEXT:    store volatile float [[PINF]], ptr [[P]], align 4
; CHECK-NEXT:    [[NINF:%.*]] = call float @llvm.amdgcn.sin.f32(float 0xFFF0000000000000)
; CHECK-NEXT:    store volatile float [[NINF]], ptr [[P]], align 4
; CHECK-NEXT:    [[NAN:%.*]] = call float @llvm.amdgcn.sin.f32(float 0x7FF8000000000000)
; CHECK-NEXT:    store volatile float [[NAN]], ptr [[P]], align 4
; CHECK-NEXT:    ret void
;
  %p0 = call float @llvm.amdgcn.sin.f32(float +0.0)
  store volatile float %p0, ptr %p
  %n0 = call float @llvm.amdgcn.sin.f32(float -0.0)
  store volatile float %n0, ptr %p
  %p0125 = call float @llvm.amdgcn.sin.f32(float +0.125)
  store volatile float %p0125, ptr %p
  %n0125 = call float @llvm.amdgcn.sin.f32(float -0.125)
  store volatile float %n0125, ptr %p
  %p025 = call float @llvm.amdgcn.sin.f32(float +0.25)
  store volatile float %p025, ptr %p
  %n025 = call float @llvm.amdgcn.sin.f32(float -0.25)
  store volatile float %n025, ptr %p
  %p05 = call float @llvm.amdgcn.sin.f32(float +0.5)
  store volatile float %p05, ptr %p
  %n05 = call float @llvm.amdgcn.sin.f32(float -0.5)
  store volatile float %n05, ptr %p
  %p1 = call float @llvm.amdgcn.sin.f32(float +1.0)
  store volatile float %p1, ptr %p
  %n1 = call float @llvm.amdgcn.sin.f32(float -1.0)
  store volatile float %n1, ptr %p
  %p256 = call float @llvm.amdgcn.sin.f32(float +256.0)
  store volatile float %p256, ptr %p
  %n256 = call float @llvm.amdgcn.sin.f32(float -256.0)
  store volatile float %n256, ptr %p
  %p1000 = call float @llvm.amdgcn.sin.f32(float +1000.0)
  store volatile float %p1000, ptr %p
  %n1000 = call float @llvm.amdgcn.sin.f32(float -1000.0)
  store volatile float %n1000, ptr %p
  %pinf = call float @llvm.amdgcn.sin.f32(float 0x7FF0000000000000) ; +inf
  store volatile float %pinf, ptr %p
  %ninf = call float @llvm.amdgcn.sin.f32(float 0xFFF0000000000000) ; -inf
  store volatile float %ninf, ptr %p
  %nan = call float @llvm.amdgcn.sin.f32(float 0x7FF8000000000000) ; nan
  store volatile float %nan, ptr %p
  ret void
}

define void @test_f64(ptr %p) {
; CHECK-LABEL: @test_f64(
; CHECK-NEXT:    store volatile double 0.000000e+00, ptr [[P:%.*]], align 8
; CHECK-NEXT:    store volatile double 0.000000e+00, ptr [[P]], align 8
; CHECK-NEXT:    store volatile double 0x3FE6A09E667F3B{{.*}}, ptr [[P]], align 8
; CHECK-NEXT:    store volatile double 0xBFE6A09E667F3B{{.*}}, ptr [[P]], align 8
; CHECK-NEXT:    store volatile double 1.000000e+00, ptr [[P]], align 8
; CHECK-NEXT:    store volatile double -1.000000e+00, ptr [[P]], align 8
; CHECK-NEXT:    store volatile double 0.000000e+00, ptr [[P]], align 8
; CHECK-NEXT:    store volatile double 0.000000e+00, ptr [[P]], align 8
; CHECK-NEXT:    store volatile double 0.000000e+00, ptr [[P]], align 8
; CHECK-NEXT:    store volatile double 0.000000e+00, ptr [[P]], align 8
; CHECK-NEXT:    store volatile double 0.000000e+00, ptr [[P]], align 8
; CHECK-NEXT:    store volatile double 0.000000e+00, ptr [[P]], align 8
; CHECK-NEXT:    [[P1000:%.*]] = call double @llvm.amdgcn.sin.f64(double 1.000000e+03)
; CHECK-NEXT:    store volatile double [[P1000]], ptr [[P]], align 8
; CHECK-NEXT:    [[N1000:%.*]] = call double @llvm.amdgcn.sin.f64(double -1.000000e+03)
; CHECK-NEXT:    store volatile double [[N1000]], ptr [[P]], align 8
; CHECK-NEXT:    [[PINF:%.*]] = call double @llvm.amdgcn.sin.f64(double 0x7FF0000000000000)
; CHECK-NEXT:    store volatile double [[PINF]], ptr [[P]], align 8
; CHECK-NEXT:    [[NINF:%.*]] = call double @llvm.amdgcn.sin.f64(double 0xFFF0000000000000)
; CHECK-NEXT:    store volatile double [[NINF]], ptr [[P]], align 8
; CHECK-NEXT:    [[NAN:%.*]] = call double @llvm.amdgcn.sin.f64(double 0x7FF8000000000000)
; CHECK-NEXT:    store volatile double [[NAN]], ptr [[P]], align 8
; CHECK-NEXT:    ret void
;
  %p0 = call double @llvm.amdgcn.sin.f64(double +0.0)
  store volatile double %p0, ptr %p
  %n0 = call double @llvm.amdgcn.sin.f64(double -0.0)
  store volatile double %n0, ptr %p
  %p0125 = call double @llvm.amdgcn.sin.f64(double +0.125)
  store volatile double %p0125, ptr %p
  %n0125 = call double @llvm.amdgcn.sin.f64(double -0.125)
  store volatile double %n0125, ptr %p
  %p025 = call double @llvm.amdgcn.sin.f64(double +0.25)
  store volatile double %p025, ptr %p
  %n025 = call double @llvm.amdgcn.sin.f64(double -0.25)
  store volatile double %n025, ptr %p
  %p05 = call double @llvm.amdgcn.sin.f64(double +0.5)
  store volatile double %p05, ptr %p
  %n05 = call double @llvm.amdgcn.sin.f64(double -0.5)
  store volatile double %n05, ptr %p
  %p1 = call double @llvm.amdgcn.sin.f64(double +1.0)
  store volatile double %p1, ptr %p
  %n1 = call double @llvm.amdgcn.sin.f64(double -1.0)
  store volatile double %n1, ptr %p
  %p256 = call double @llvm.amdgcn.sin.f64(double +256.0)
  store volatile double %p256, ptr %p
  %n256 = call double @llvm.amdgcn.sin.f64(double -256.0)
  store volatile double %n256, ptr %p
  %p1000 = call double @llvm.amdgcn.sin.f64(double +1000.0)
  store volatile double %p1000, ptr %p
  %n1000 = call double @llvm.amdgcn.sin.f64(double -1000.0)
  store volatile double %n1000, ptr %p
  %pinf = call double @llvm.amdgcn.sin.f64(double 0x7FF0000000000000) ; +inf
  store volatile double %pinf, ptr %p
  %ninf = call double @llvm.amdgcn.sin.f64(double 0xFFF0000000000000) ; -inf
  store volatile double %ninf, ptr %p
  %nan = call double @llvm.amdgcn.sin.f64(double 0x7FF8000000000000) ; nan
  store volatile double %nan, ptr %p
  ret void
}

define void @test_f16_strictfp (ptr %p) #1 {
; CHECK-LABEL: @test_f16_strictfp(
; CHECK-NEXT:    [[P0:%.*]] = call half @llvm.amdgcn.sin.f16(half 0xH0000) #1
; CHECK-NEXT:    store volatile half [[P0]], ptr [[P:%.*]], align 2
; CHECK-NEXT:    [[P025:%.*]] = call half @llvm.amdgcn.sin.f16(half 0xH3400) #1
; CHECK-NEXT:    store volatile half [[P025]], ptr [[P]], align 2
; CHECK-NEXT:    ret void
;
  %p0 = call half @llvm.amdgcn.sin.f16(half +0.0) #1
  store volatile half %p0, ptr %p
  %p025 = call half @llvm.amdgcn.sin.f16(half +0.25) #1
  store volatile half %p025, ptr %p
  ret void
}

define void @test_f32_strictfp(ptr %p) #1 {
; CHECK-LABEL: @test_f32_strictfp(
; CHECK-NEXT:    [[P0:%.*]] = call float @llvm.amdgcn.sin.f32(float 0.000000e+00) #1
; CHECK-NEXT:    store volatile float [[P0]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[P025:%.*]] = call float @llvm.amdgcn.sin.f32(float 2.500000e-01) #1
; CHECK-NEXT:    store volatile float [[P025]], ptr [[P]], align 4
; CHECK-NEXT:    ret void
;
  %p0 = call float @llvm.amdgcn.sin.f32(float +0.0) #1
  store volatile float %p0, ptr %p
  %p025 = call float @llvm.amdgcn.sin.f32(float +0.25) #1
  store volatile float %p025, ptr %p
  ret void
}

define void @test_f64_strictfp(ptr %p) #1 {
; CHECK-LABEL: @test_f64_strictfp(
; CHECK-NEXT:    [[P0:%.*]] = call double @llvm.amdgcn.sin.f64(double 0.000000e+00) #1
; CHECK-NEXT:    store volatile double [[P0]], ptr [[P:%.*]], align 8
; CHECK-NEXT:    [[P025:%.*]] = call double @llvm.amdgcn.sin.f64(double 2.500000e-01) #1
; CHECK-NEXT:    store volatile double [[P025]], ptr [[P]], align 8
; CHECK-NEXT:    ret void
;
  %p0 = call double @llvm.amdgcn.sin.f64(double +0.0) #1
  store volatile double %p0, ptr %p
  %p025 = call double @llvm.amdgcn.sin.f64(double +0.25) #1
  store volatile double %p025, ptr %p
  ret void
}

attributes #0 = { nounwind readnone speculatable }
attributes #1 = { strictfp }
