; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d -target-abi=ilp32 -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefix=RV32F %s
; RUN: llc -mtriple=riscv64 -mattr=+d -target-abi=lp64 -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefix=RV64F %s

;; `.insn 0x4, 0x02000053 | (${0:N} << 7) | (${1:N} << 15) | (${2:N} << 20)` is
;; the raw encoding for `fadd.d`

@gd = external global double

define double @constraint_f_double(double %a) nounwind {
; RV32F-LABEL: constraint_f_double:
; RV32F:       # %bb.0:
; RV32F-NEXT:    addi sp, sp, -16
; RV32F-NEXT:    sw a0, 8(sp)
; RV32F-NEXT:    sw a1, 12(sp)
; RV32F-NEXT:    lui a0, %hi(gd)
; RV32F-NEXT:    fld fa5, 8(sp)
; RV32F-NEXT:    fld fa4, %lo(gd)(a0)
; RV32F-NEXT:    #APP
; RV32F-NEXT:    .insn 0x4, 0x02000053 | (15 << 7) | (15 << 15) | (14 << 20)
; RV32F-NEXT:    #NO_APP
; RV32F-NEXT:    fsd fa5, 8(sp)
; RV32F-NEXT:    lw a0, 8(sp)
; RV32F-NEXT:    lw a1, 12(sp)
; RV32F-NEXT:    addi sp, sp, 16
; RV32F-NEXT:    ret
;
; RV64F-LABEL: constraint_f_double:
; RV64F:       # %bb.0:
; RV64F-NEXT:    lui a1, %hi(gd)
; RV64F-NEXT:    fld fa5, %lo(gd)(a1)
; RV64F-NEXT:    fmv.d.x fa4, a0
; RV64F-NEXT:    #APP
; RV64F-NEXT:    .insn 0x4, 0x02000053 | (15 << 7) | (14 << 15) | (15 << 20)
; RV64F-NEXT:    #NO_APP
; RV64F-NEXT:    fmv.x.d a0, fa5
; RV64F-NEXT:    ret
  %1 = load double, ptr @gd
  %2 = tail call double asm ".insn 0x4, 0x02000053 | (${0:N} << 7) | (${1:N} << 15) | (${2:N} << 20)", "=f,f,f"(double %a, double %1)
  ret double %2
}

define double @constraint_cf_double(double %a) nounwind {
; RV32F-LABEL: constraint_cf_double:
; RV32F:       # %bb.0:
; RV32F-NEXT:    addi sp, sp, -16
; RV32F-NEXT:    sw a0, 8(sp)
; RV32F-NEXT:    sw a1, 12(sp)
; RV32F-NEXT:    lui a0, %hi(gd)
; RV32F-NEXT:    fld fa5, 8(sp)
; RV32F-NEXT:    fld fa4, %lo(gd)(a0)
; RV32F-NEXT:    #APP
; RV32F-NEXT:    .insn 0x4, 0x02000053 | (15 << 7) | (15 << 15) | (14 << 20)
; RV32F-NEXT:    #NO_APP
; RV32F-NEXT:    fsd fa5, 8(sp)
; RV32F-NEXT:    lw a0, 8(sp)
; RV32F-NEXT:    lw a1, 12(sp)
; RV32F-NEXT:    addi sp, sp, 16
; RV32F-NEXT:    ret
;
; RV64F-LABEL: constraint_cf_double:
; RV64F:       # %bb.0:
; RV64F-NEXT:    lui a1, %hi(gd)
; RV64F-NEXT:    fld fa5, %lo(gd)(a1)
; RV64F-NEXT:    fmv.d.x fa4, a0
; RV64F-NEXT:    #APP
; RV64F-NEXT:    .insn 0x4, 0x02000053 | (15 << 7) | (14 << 15) | (15 << 20)
; RV64F-NEXT:    #NO_APP
; RV64F-NEXT:    fmv.x.d a0, fa5
; RV64F-NEXT:    ret
  %1 = load double, ptr @gd
  %2 = tail call double asm ".insn 0x4, 0x02000053 | (${0:N} << 7) | (${1:N} << 15) | (${2:N} << 20)", "=^cf,^cf,^cf"(double %a, double %1)
  ret double %2
}

define double @constraint_f_double_abi_name(double %a) nounwind {
; RV32F-LABEL: constraint_f_double_abi_name:
; RV32F:       # %bb.0:
; RV32F-NEXT:    addi sp, sp, -16
; RV32F-NEXT:    sw a0, 8(sp)
; RV32F-NEXT:    sw a1, 12(sp)
; RV32F-NEXT:    lui a0, %hi(gd)
; RV32F-NEXT:    fld fa1, 8(sp)
; RV32F-NEXT:    fld fs0, %lo(gd)(a0)
; RV32F-NEXT:    #APP
; RV32F-NEXT:    .insn 0x4, 0x02000053 | (0 << 7) | (11 << 15) | (8 << 20)
; RV32F-NEXT:    #NO_APP
; RV32F-NEXT:    fsd ft0, 8(sp)
; RV32F-NEXT:    lw a0, 8(sp)
; RV32F-NEXT:    lw a1, 12(sp)
; RV32F-NEXT:    addi sp, sp, 16
; RV32F-NEXT:    ret
;
; RV64F-LABEL: constraint_f_double_abi_name:
; RV64F:       # %bb.0:
; RV64F-NEXT:    lui a1, %hi(gd)
; RV64F-NEXT:    fld fs0, %lo(gd)(a1)
; RV64F-NEXT:    fmv.d.x fa1, a0
; RV64F-NEXT:    #APP
; RV64F-NEXT:    .insn 0x4, 0x02000053 | (0 << 7) | (11 << 15) | (8 << 20)
; RV64F-NEXT:    #NO_APP
; RV64F-NEXT:    fmv.x.d a0, ft0
; RV64F-NEXT:    ret
  %1 = load double, ptr @gd
  %2 = tail call double asm ".insn 0x4, 0x02000053 | (${0:N} << 7) | (${1:N} << 15) | (${2:N} << 20)", "={ft0},{fa1},{fs0}"(double %a, double %1)
  ret double %2
}
