// RUN: %clang_cc1 -triple x86_64-pc-linux -Wno-unused-value -ast-dump=json %s | FileCheck %s

int foo(int * ptr) {
  return __atomic_load_n(ptr, __ATOMIC_SEQ_CST);
}

// NOTE: CHECK lines have *not* been autogenerated by gen_ast_dump_json_test.py
// as its output is not portable for AtomicExpr across platforms. Instead rely
// on loose CHECKS.


// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "AtomicExpr",
// CHECK:  "type": {
// CHECK:   "qualType": "int"
// CHECK:  },
// CHECK:  "valueCategory": "prvalue",
// CHECK:  "name": "__atomic_load_n",
// CHECK:  "inner": [
// CHECK:   {
// CHECK:    "id": "0x{{.*}}",
// CHECK:    "kind": "ImplicitCastExpr",
// CHECK:    },
// CHECK:    "type": {
// CHECK:     "qualType": "int *"
// CHECK:    },
// CHECK:    "valueCategory": "prvalue",
// CHECK:    "castKind": "LValueToRValue",
// CHECK:    "inner": [
// CHECK:     {
// CHECK:      "id": "0x{{.*}}",
// CHECK:      "kind": "DeclRefExpr",
// CHECK:      },
// CHECK:      "type": {
// CHECK:       "qualType": "int *"
// CHECK:      },
// CHECK:      "valueCategory": "lvalue",
// CHECK:      "referencedDecl": {
// CHECK:       "id": "0x{{.*}}",
// CHECK:       "kind": "ParmVarDecl",
// CHECK:       "name": "ptr",
// CHECK:       "type": {
// CHECK:        "qualType": "int *"
// CHECK:       }
// CHECK:      }
// CHECK:     }
// CHECK:    ]
// CHECK:   },
// CHECK:   {
// CHECK:    "id": "0x{{.*}}",
// CHECK:    "kind": "IntegerLiteral",
// CHECK:    },
// CHECK:    "type": {
// CHECK:     "qualType": "int"
// CHECK:    },
// CHECK:    "valueCategory": "prvalue",
// CHECK:    "value": "5"
// CHECK:   }
// CHECK:  ]
// CHECK: }
