#include "asm/aarch64/init.hpp"

#include "LIEF/asm/aarch64/opcodes.hpp"

namespace LIEF::assembly::aarch64::py {
template<>
void create<LIEF::assembly::aarch64::OPCODE>(nb::module_& m) {
  nb::enum_<LIEF::assembly::aarch64::OPCODE> opcodes(m, "OPCODE");
  opcodes.value("PHI", LIEF::assembly::aarch64::OPCODE::PHI)
  .value("INLINEASM", LIEF::assembly::aarch64::OPCODE::INLINEASM)
  .value("INLINEASM_BR", LIEF::assembly::aarch64::OPCODE::INLINEASM_BR)
  .value("CFI_INSTRUCTION", LIEF::assembly::aarch64::OPCODE::CFI_INSTRUCTION)
  .value("EH_LABEL", LIEF::assembly::aarch64::OPCODE::EH_LABEL)
  .value("GC_LABEL", LIEF::assembly::aarch64::OPCODE::GC_LABEL)
  .value("ANNOTATION_LABEL", LIEF::assembly::aarch64::OPCODE::ANNOTATION_LABEL)
  .value("KILL", LIEF::assembly::aarch64::OPCODE::KILL)
  .value("EXTRACT_SUBREG", LIEF::assembly::aarch64::OPCODE::EXTRACT_SUBREG)
  .value("INSERT_SUBREG", LIEF::assembly::aarch64::OPCODE::INSERT_SUBREG)
  .value("IMPLICIT_DEF", LIEF::assembly::aarch64::OPCODE::IMPLICIT_DEF)
  .value("INIT_UNDEF", LIEF::assembly::aarch64::OPCODE::INIT_UNDEF)
  .value("SUBREG_TO_REG", LIEF::assembly::aarch64::OPCODE::SUBREG_TO_REG)
  .value("COPY_TO_REGCLASS", LIEF::assembly::aarch64::OPCODE::COPY_TO_REGCLASS)
  .value("DBG_VALUE", LIEF::assembly::aarch64::OPCODE::DBG_VALUE)
  .value("DBG_VALUE_LIST", LIEF::assembly::aarch64::OPCODE::DBG_VALUE_LIST)
  .value("DBG_INSTR_REF", LIEF::assembly::aarch64::OPCODE::DBG_INSTR_REF)
  .value("DBG_PHI", LIEF::assembly::aarch64::OPCODE::DBG_PHI)
  .value("DBG_LABEL", LIEF::assembly::aarch64::OPCODE::DBG_LABEL)
  .value("REG_SEQUENCE", LIEF::assembly::aarch64::OPCODE::REG_SEQUENCE)
  .value("COPY", LIEF::assembly::aarch64::OPCODE::COPY)
  .value("BUNDLE", LIEF::assembly::aarch64::OPCODE::BUNDLE)
  .value("LIFETIME_START", LIEF::assembly::aarch64::OPCODE::LIFETIME_START)
  .value("LIFETIME_END", LIEF::assembly::aarch64::OPCODE::LIFETIME_END)
  .value("PSEUDO_PROBE", LIEF::assembly::aarch64::OPCODE::PSEUDO_PROBE)
  .value("ARITH_FENCE", LIEF::assembly::aarch64::OPCODE::ARITH_FENCE)
  .value("STACKMAP", LIEF::assembly::aarch64::OPCODE::STACKMAP)
  .value("FENTRY_CALL", LIEF::assembly::aarch64::OPCODE::FENTRY_CALL)
  .value("PATCHPOINT", LIEF::assembly::aarch64::OPCODE::PATCHPOINT)
  .value("LOAD_STACK_GUARD", LIEF::assembly::aarch64::OPCODE::LOAD_STACK_GUARD)
  .value("PREALLOCATED_SETUP", LIEF::assembly::aarch64::OPCODE::PREALLOCATED_SETUP)
  .value("PREALLOCATED_ARG", LIEF::assembly::aarch64::OPCODE::PREALLOCATED_ARG)
  .value("STATEPOINT", LIEF::assembly::aarch64::OPCODE::STATEPOINT)
  .value("LOCAL_ESCAPE", LIEF::assembly::aarch64::OPCODE::LOCAL_ESCAPE)
  .value("FAULTING_OP", LIEF::assembly::aarch64::OPCODE::FAULTING_OP)
  .value("PATCHABLE_OP", LIEF::assembly::aarch64::OPCODE::PATCHABLE_OP)
  .value("PATCHABLE_FUNCTION_ENTER", LIEF::assembly::aarch64::OPCODE::PATCHABLE_FUNCTION_ENTER)
  .value("PATCHABLE_RET", LIEF::assembly::aarch64::OPCODE::PATCHABLE_RET)
  .value("PATCHABLE_FUNCTION_EXIT", LIEF::assembly::aarch64::OPCODE::PATCHABLE_FUNCTION_EXIT)
  .value("PATCHABLE_TAIL_CALL", LIEF::assembly::aarch64::OPCODE::PATCHABLE_TAIL_CALL)
  .value("PATCHABLE_EVENT_CALL", LIEF::assembly::aarch64::OPCODE::PATCHABLE_EVENT_CALL)
  .value("PATCHABLE_TYPED_EVENT_CALL", LIEF::assembly::aarch64::OPCODE::PATCHABLE_TYPED_EVENT_CALL)
  .value("ICALL_BRANCH_FUNNEL", LIEF::assembly::aarch64::OPCODE::ICALL_BRANCH_FUNNEL)
  .value("FAKE_USE", LIEF::assembly::aarch64::OPCODE::FAKE_USE)
  .value("MEMBARRIER", LIEF::assembly::aarch64::OPCODE::MEMBARRIER)
  .value("JUMP_TABLE_DEBUG_INFO", LIEF::assembly::aarch64::OPCODE::JUMP_TABLE_DEBUG_INFO)
  .value("CONVERGENCECTRL_ENTRY", LIEF::assembly::aarch64::OPCODE::CONVERGENCECTRL_ENTRY)
  .value("CONVERGENCECTRL_ANCHOR", LIEF::assembly::aarch64::OPCODE::CONVERGENCECTRL_ANCHOR)
  .value("CONVERGENCECTRL_LOOP", LIEF::assembly::aarch64::OPCODE::CONVERGENCECTRL_LOOP)
  .value("CONVERGENCECTRL_GLUE", LIEF::assembly::aarch64::OPCODE::CONVERGENCECTRL_GLUE)
  .value("G_ASSERT_SEXT", LIEF::assembly::aarch64::OPCODE::G_ASSERT_SEXT)
  .value("G_ASSERT_ZEXT", LIEF::assembly::aarch64::OPCODE::G_ASSERT_ZEXT)
  .value("G_ASSERT_ALIGN", LIEF::assembly::aarch64::OPCODE::G_ASSERT_ALIGN)
  .value("G_ADD", LIEF::assembly::aarch64::OPCODE::G_ADD)
  .value("G_SUB", LIEF::assembly::aarch64::OPCODE::G_SUB)
  .value("G_MUL", LIEF::assembly::aarch64::OPCODE::G_MUL)
  .value("G_SDIV", LIEF::assembly::aarch64::OPCODE::G_SDIV)
  .value("G_UDIV", LIEF::assembly::aarch64::OPCODE::G_UDIV)
  .value("G_SREM", LIEF::assembly::aarch64::OPCODE::G_SREM)
  .value("G_UREM", LIEF::assembly::aarch64::OPCODE::G_UREM)
  .value("G_SDIVREM", LIEF::assembly::aarch64::OPCODE::G_SDIVREM)
  .value("G_UDIVREM", LIEF::assembly::aarch64::OPCODE::G_UDIVREM)
  .value("G_AND", LIEF::assembly::aarch64::OPCODE::G_AND)
  .value("G_OR", LIEF::assembly::aarch64::OPCODE::G_OR)
  .value("G_XOR", LIEF::assembly::aarch64::OPCODE::G_XOR)
  .value("G_ABDS", LIEF::assembly::aarch64::OPCODE::G_ABDS)
  .value("G_ABDU", LIEF::assembly::aarch64::OPCODE::G_ABDU)
  .value("G_IMPLICIT_DEF", LIEF::assembly::aarch64::OPCODE::G_IMPLICIT_DEF)
  .value("G_PHI", LIEF::assembly::aarch64::OPCODE::G_PHI)
  .value("G_FRAME_INDEX", LIEF::assembly::aarch64::OPCODE::G_FRAME_INDEX)
  .value("G_GLOBAL_VALUE", LIEF::assembly::aarch64::OPCODE::G_GLOBAL_VALUE)
  .value("G_PTRAUTH_GLOBAL_VALUE", LIEF::assembly::aarch64::OPCODE::G_PTRAUTH_GLOBAL_VALUE)
  .value("G_CONSTANT_POOL", LIEF::assembly::aarch64::OPCODE::G_CONSTANT_POOL)
  .value("G_EXTRACT", LIEF::assembly::aarch64::OPCODE::G_EXTRACT)
  .value("G_UNMERGE_VALUES", LIEF::assembly::aarch64::OPCODE::G_UNMERGE_VALUES)
  .value("G_INSERT", LIEF::assembly::aarch64::OPCODE::G_INSERT)
  .value("G_MERGE_VALUES", LIEF::assembly::aarch64::OPCODE::G_MERGE_VALUES)
  .value("G_BUILD_VECTOR", LIEF::assembly::aarch64::OPCODE::G_BUILD_VECTOR)
  .value("G_BUILD_VECTOR_TRUNC", LIEF::assembly::aarch64::OPCODE::G_BUILD_VECTOR_TRUNC)
  .value("G_CONCAT_VECTORS", LIEF::assembly::aarch64::OPCODE::G_CONCAT_VECTORS)
  .value("G_PTRTOINT", LIEF::assembly::aarch64::OPCODE::G_PTRTOINT)
  .value("G_INTTOPTR", LIEF::assembly::aarch64::OPCODE::G_INTTOPTR)
  .value("G_BITCAST", LIEF::assembly::aarch64::OPCODE::G_BITCAST)
  .value("G_FREEZE", LIEF::assembly::aarch64::OPCODE::G_FREEZE)
  .value("G_CONSTANT_FOLD_BARRIER", LIEF::assembly::aarch64::OPCODE::G_CONSTANT_FOLD_BARRIER)
  .value("G_INTRINSIC_FPTRUNC_ROUND", LIEF::assembly::aarch64::OPCODE::G_INTRINSIC_FPTRUNC_ROUND)
  .value("G_INTRINSIC_TRUNC", LIEF::assembly::aarch64::OPCODE::G_INTRINSIC_TRUNC)
  .value("G_INTRINSIC_ROUND", LIEF::assembly::aarch64::OPCODE::G_INTRINSIC_ROUND)
  .value("G_INTRINSIC_LRINT", LIEF::assembly::aarch64::OPCODE::G_INTRINSIC_LRINT)
  .value("G_INTRINSIC_LLRINT", LIEF::assembly::aarch64::OPCODE::G_INTRINSIC_LLRINT)
  .value("G_INTRINSIC_ROUNDEVEN", LIEF::assembly::aarch64::OPCODE::G_INTRINSIC_ROUNDEVEN)
  .value("G_READCYCLECOUNTER", LIEF::assembly::aarch64::OPCODE::G_READCYCLECOUNTER)
  .value("G_READSTEADYCOUNTER", LIEF::assembly::aarch64::OPCODE::G_READSTEADYCOUNTER)
  .value("G_LOAD", LIEF::assembly::aarch64::OPCODE::G_LOAD)
  .value("G_SEXTLOAD", LIEF::assembly::aarch64::OPCODE::G_SEXTLOAD)
  .value("G_ZEXTLOAD", LIEF::assembly::aarch64::OPCODE::G_ZEXTLOAD)
  .value("G_INDEXED_LOAD", LIEF::assembly::aarch64::OPCODE::G_INDEXED_LOAD)
  .value("G_INDEXED_SEXTLOAD", LIEF::assembly::aarch64::OPCODE::G_INDEXED_SEXTLOAD)
  .value("G_INDEXED_ZEXTLOAD", LIEF::assembly::aarch64::OPCODE::G_INDEXED_ZEXTLOAD)
  .value("G_STORE", LIEF::assembly::aarch64::OPCODE::G_STORE)
  .value("G_INDEXED_STORE", LIEF::assembly::aarch64::OPCODE::G_INDEXED_STORE)
  .value("G_ATOMIC_CMPXCHG_WITH_SUCCESS", LIEF::assembly::aarch64::OPCODE::G_ATOMIC_CMPXCHG_WITH_SUCCESS)
  .value("G_ATOMIC_CMPXCHG", LIEF::assembly::aarch64::OPCODE::G_ATOMIC_CMPXCHG)
  .value("G_ATOMICRMW_XCHG", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_XCHG)
  .value("G_ATOMICRMW_ADD", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_ADD)
  .value("G_ATOMICRMW_SUB", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_SUB)
  .value("G_ATOMICRMW_AND", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_AND)
  .value("G_ATOMICRMW_NAND", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_NAND)
  .value("G_ATOMICRMW_OR", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_OR)
  .value("G_ATOMICRMW_XOR", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_XOR)
  .value("G_ATOMICRMW_MAX", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_MAX)
  .value("G_ATOMICRMW_MIN", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_MIN)
  .value("G_ATOMICRMW_UMAX", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_UMAX)
  .value("G_ATOMICRMW_UMIN", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_UMIN)
  .value("G_ATOMICRMW_FADD", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_FADD)
  .value("G_ATOMICRMW_FSUB", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_FSUB)
  .value("G_ATOMICRMW_FMAX", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_FMAX)
  .value("G_ATOMICRMW_FMIN", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_FMIN)
  .value("G_ATOMICRMW_FMAXIMUM", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_FMAXIMUM)
  .value("G_ATOMICRMW_FMINIMUM", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_FMINIMUM)
  .value("G_ATOMICRMW_UINC_WRAP", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_UINC_WRAP)
  .value("G_ATOMICRMW_UDEC_WRAP", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_UDEC_WRAP)
  .value("G_ATOMICRMW_USUB_COND", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_USUB_COND)
  .value("G_ATOMICRMW_USUB_SAT", LIEF::assembly::aarch64::OPCODE::G_ATOMICRMW_USUB_SAT)
  .value("G_FENCE", LIEF::assembly::aarch64::OPCODE::G_FENCE)
  .value("G_PREFETCH", LIEF::assembly::aarch64::OPCODE::G_PREFETCH)
  .value("G_BRCOND", LIEF::assembly::aarch64::OPCODE::G_BRCOND)
  .value("G_BRINDIRECT", LIEF::assembly::aarch64::OPCODE::G_BRINDIRECT)
  .value("G_INVOKE_REGION_START", LIEF::assembly::aarch64::OPCODE::G_INVOKE_REGION_START)
  .value("G_INTRINSIC", LIEF::assembly::aarch64::OPCODE::G_INTRINSIC)
  .value("G_INTRINSIC_W_SIDE_EFFECTS", LIEF::assembly::aarch64::OPCODE::G_INTRINSIC_W_SIDE_EFFECTS)
  .value("G_INTRINSIC_CONVERGENT", LIEF::assembly::aarch64::OPCODE::G_INTRINSIC_CONVERGENT)
  .value("G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS", LIEF::assembly::aarch64::OPCODE::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS)
  .value("G_ANYEXT", LIEF::assembly::aarch64::OPCODE::G_ANYEXT)
  .value("G_TRUNC", LIEF::assembly::aarch64::OPCODE::G_TRUNC)
  .value("G_TRUNC_SSAT_S", LIEF::assembly::aarch64::OPCODE::G_TRUNC_SSAT_S)
  .value("G_TRUNC_SSAT_U", LIEF::assembly::aarch64::OPCODE::G_TRUNC_SSAT_U)
  .value("G_TRUNC_USAT_U", LIEF::assembly::aarch64::OPCODE::G_TRUNC_USAT_U)
  .value("G_CONSTANT", LIEF::assembly::aarch64::OPCODE::G_CONSTANT)
  .value("G_FCONSTANT", LIEF::assembly::aarch64::OPCODE::G_FCONSTANT)
  .value("G_VASTART", LIEF::assembly::aarch64::OPCODE::G_VASTART)
  .value("G_VAARG", LIEF::assembly::aarch64::OPCODE::G_VAARG)
  .value("G_SEXT", LIEF::assembly::aarch64::OPCODE::G_SEXT)
  .value("G_SEXT_INREG", LIEF::assembly::aarch64::OPCODE::G_SEXT_INREG)
  .value("G_ZEXT", LIEF::assembly::aarch64::OPCODE::G_ZEXT)
  .value("G_SHL", LIEF::assembly::aarch64::OPCODE::G_SHL)
  .value("G_LSHR", LIEF::assembly::aarch64::OPCODE::G_LSHR)
  .value("G_ASHR", LIEF::assembly::aarch64::OPCODE::G_ASHR)
  .value("G_FSHL", LIEF::assembly::aarch64::OPCODE::G_FSHL)
  .value("G_FSHR", LIEF::assembly::aarch64::OPCODE::G_FSHR)
  .value("G_ROTR", LIEF::assembly::aarch64::OPCODE::G_ROTR)
  .value("G_ROTL", LIEF::assembly::aarch64::OPCODE::G_ROTL)
  .value("G_ICMP", LIEF::assembly::aarch64::OPCODE::G_ICMP)
  .value("G_FCMP", LIEF::assembly::aarch64::OPCODE::G_FCMP)
  .value("G_SCMP", LIEF::assembly::aarch64::OPCODE::G_SCMP)
  .value("G_UCMP", LIEF::assembly::aarch64::OPCODE::G_UCMP)
  .value("G_SELECT", LIEF::assembly::aarch64::OPCODE::G_SELECT)
  .value("G_UADDO", LIEF::assembly::aarch64::OPCODE::G_UADDO)
  .value("G_UADDE", LIEF::assembly::aarch64::OPCODE::G_UADDE)
  .value("G_USUBO", LIEF::assembly::aarch64::OPCODE::G_USUBO)
  .value("G_USUBE", LIEF::assembly::aarch64::OPCODE::G_USUBE)
  .value("G_SADDO", LIEF::assembly::aarch64::OPCODE::G_SADDO)
  .value("G_SADDE", LIEF::assembly::aarch64::OPCODE::G_SADDE)
  .value("G_SSUBO", LIEF::assembly::aarch64::OPCODE::G_SSUBO)
  .value("G_SSUBE", LIEF::assembly::aarch64::OPCODE::G_SSUBE)
  .value("G_UMULO", LIEF::assembly::aarch64::OPCODE::G_UMULO)
  .value("G_SMULO", LIEF::assembly::aarch64::OPCODE::G_SMULO)
  .value("G_UMULH", LIEF::assembly::aarch64::OPCODE::G_UMULH)
  .value("G_SMULH", LIEF::assembly::aarch64::OPCODE::G_SMULH)
  .value("G_UADDSAT", LIEF::assembly::aarch64::OPCODE::G_UADDSAT)
  .value("G_SADDSAT", LIEF::assembly::aarch64::OPCODE::G_SADDSAT)
  .value("G_USUBSAT", LIEF::assembly::aarch64::OPCODE::G_USUBSAT)
  .value("G_SSUBSAT", LIEF::assembly::aarch64::OPCODE::G_SSUBSAT)
  .value("G_USHLSAT", LIEF::assembly::aarch64::OPCODE::G_USHLSAT)
  .value("G_SSHLSAT", LIEF::assembly::aarch64::OPCODE::G_SSHLSAT)
  .value("G_SMULFIX", LIEF::assembly::aarch64::OPCODE::G_SMULFIX)
  .value("G_UMULFIX", LIEF::assembly::aarch64::OPCODE::G_UMULFIX)
  .value("G_SMULFIXSAT", LIEF::assembly::aarch64::OPCODE::G_SMULFIXSAT)
  .value("G_UMULFIXSAT", LIEF::assembly::aarch64::OPCODE::G_UMULFIXSAT)
  .value("G_SDIVFIX", LIEF::assembly::aarch64::OPCODE::G_SDIVFIX)
  .value("G_UDIVFIX", LIEF::assembly::aarch64::OPCODE::G_UDIVFIX)
  .value("G_SDIVFIXSAT", LIEF::assembly::aarch64::OPCODE::G_SDIVFIXSAT)
  .value("G_UDIVFIXSAT", LIEF::assembly::aarch64::OPCODE::G_UDIVFIXSAT)
  .value("G_FADD", LIEF::assembly::aarch64::OPCODE::G_FADD)
  .value("G_FSUB", LIEF::assembly::aarch64::OPCODE::G_FSUB)
  .value("G_FMUL", LIEF::assembly::aarch64::OPCODE::G_FMUL)
  .value("G_FMA", LIEF::assembly::aarch64::OPCODE::G_FMA)
  .value("G_FMAD", LIEF::assembly::aarch64::OPCODE::G_FMAD)
  .value("G_FDIV", LIEF::assembly::aarch64::OPCODE::G_FDIV)
  .value("G_FREM", LIEF::assembly::aarch64::OPCODE::G_FREM)
  .value("G_FPOW", LIEF::assembly::aarch64::OPCODE::G_FPOW)
  .value("G_FPOWI", LIEF::assembly::aarch64::OPCODE::G_FPOWI)
  .value("G_FEXP", LIEF::assembly::aarch64::OPCODE::G_FEXP)
  .value("G_FEXP2", LIEF::assembly::aarch64::OPCODE::G_FEXP2)
  .value("G_FEXP10", LIEF::assembly::aarch64::OPCODE::G_FEXP10)
  .value("G_FLOG", LIEF::assembly::aarch64::OPCODE::G_FLOG)
  .value("G_FLOG2", LIEF::assembly::aarch64::OPCODE::G_FLOG2)
  .value("G_FLOG10", LIEF::assembly::aarch64::OPCODE::G_FLOG10)
  .value("G_FLDEXP", LIEF::assembly::aarch64::OPCODE::G_FLDEXP)
  .value("G_FFREXP", LIEF::assembly::aarch64::OPCODE::G_FFREXP)
  .value("G_FNEG", LIEF::assembly::aarch64::OPCODE::G_FNEG)
  .value("G_FPEXT", LIEF::assembly::aarch64::OPCODE::G_FPEXT)
  .value("G_FPTRUNC", LIEF::assembly::aarch64::OPCODE::G_FPTRUNC)
  .value("G_FPTOSI", LIEF::assembly::aarch64::OPCODE::G_FPTOSI)
  .value("G_FPTOUI", LIEF::assembly::aarch64::OPCODE::G_FPTOUI)
  .value("G_SITOFP", LIEF::assembly::aarch64::OPCODE::G_SITOFP)
  .value("G_UITOFP", LIEF::assembly::aarch64::OPCODE::G_UITOFP)
  .value("G_FPTOSI_SAT", LIEF::assembly::aarch64::OPCODE::G_FPTOSI_SAT)
  .value("G_FPTOUI_SAT", LIEF::assembly::aarch64::OPCODE::G_FPTOUI_SAT)
  .value("G_FABS", LIEF::assembly::aarch64::OPCODE::G_FABS)
  .value("G_FCOPYSIGN", LIEF::assembly::aarch64::OPCODE::G_FCOPYSIGN)
  .value("G_IS_FPCLASS", LIEF::assembly::aarch64::OPCODE::G_IS_FPCLASS)
  .value("G_FCANONICALIZE", LIEF::assembly::aarch64::OPCODE::G_FCANONICALIZE)
  .value("G_FMINNUM", LIEF::assembly::aarch64::OPCODE::G_FMINNUM)
  .value("G_FMAXNUM", LIEF::assembly::aarch64::OPCODE::G_FMAXNUM)
  .value("G_FMINNUM_IEEE", LIEF::assembly::aarch64::OPCODE::G_FMINNUM_IEEE)
  .value("G_FMAXNUM_IEEE", LIEF::assembly::aarch64::OPCODE::G_FMAXNUM_IEEE)
  .value("G_FMINIMUM", LIEF::assembly::aarch64::OPCODE::G_FMINIMUM)
  .value("G_FMAXIMUM", LIEF::assembly::aarch64::OPCODE::G_FMAXIMUM)
  .value("G_FMINIMUMNUM", LIEF::assembly::aarch64::OPCODE::G_FMINIMUMNUM)
  .value("G_FMAXIMUMNUM", LIEF::assembly::aarch64::OPCODE::G_FMAXIMUMNUM)
  .value("G_GET_FPENV", LIEF::assembly::aarch64::OPCODE::G_GET_FPENV)
  .value("G_SET_FPENV", LIEF::assembly::aarch64::OPCODE::G_SET_FPENV)
  .value("G_RESET_FPENV", LIEF::assembly::aarch64::OPCODE::G_RESET_FPENV)
  .value("G_GET_FPMODE", LIEF::assembly::aarch64::OPCODE::G_GET_FPMODE)
  .value("G_SET_FPMODE", LIEF::assembly::aarch64::OPCODE::G_SET_FPMODE)
  .value("G_RESET_FPMODE", LIEF::assembly::aarch64::OPCODE::G_RESET_FPMODE)
  .value("G_GET_ROUNDING", LIEF::assembly::aarch64::OPCODE::G_GET_ROUNDING)
  .value("G_PTR_ADD", LIEF::assembly::aarch64::OPCODE::G_PTR_ADD)
  .value("G_PTRMASK", LIEF::assembly::aarch64::OPCODE::G_PTRMASK)
  .value("G_SMIN", LIEF::assembly::aarch64::OPCODE::G_SMIN)
  .value("G_SMAX", LIEF::assembly::aarch64::OPCODE::G_SMAX)
  .value("G_UMIN", LIEF::assembly::aarch64::OPCODE::G_UMIN)
  .value("G_UMAX", LIEF::assembly::aarch64::OPCODE::G_UMAX)
  .value("G_ABS", LIEF::assembly::aarch64::OPCODE::G_ABS)
  .value("G_LROUND", LIEF::assembly::aarch64::OPCODE::G_LROUND)
  .value("G_LLROUND", LIEF::assembly::aarch64::OPCODE::G_LLROUND)
  .value("G_BR", LIEF::assembly::aarch64::OPCODE::G_BR)
  .value("G_BRJT", LIEF::assembly::aarch64::OPCODE::G_BRJT)
  .value("G_VSCALE", LIEF::assembly::aarch64::OPCODE::G_VSCALE)
  .value("G_INSERT_SUBVECTOR", LIEF::assembly::aarch64::OPCODE::G_INSERT_SUBVECTOR)
  .value("G_EXTRACT_SUBVECTOR", LIEF::assembly::aarch64::OPCODE::G_EXTRACT_SUBVECTOR)
  .value("G_INSERT_VECTOR_ELT", LIEF::assembly::aarch64::OPCODE::G_INSERT_VECTOR_ELT)
  .value("G_EXTRACT_VECTOR_ELT", LIEF::assembly::aarch64::OPCODE::G_EXTRACT_VECTOR_ELT)
  .value("G_SHUFFLE_VECTOR", LIEF::assembly::aarch64::OPCODE::G_SHUFFLE_VECTOR)
  .value("G_SPLAT_VECTOR", LIEF::assembly::aarch64::OPCODE::G_SPLAT_VECTOR)
  .value("G_STEP_VECTOR", LIEF::assembly::aarch64::OPCODE::G_STEP_VECTOR)
  .value("G_VECTOR_COMPRESS", LIEF::assembly::aarch64::OPCODE::G_VECTOR_COMPRESS)
  .value("G_CTTZ", LIEF::assembly::aarch64::OPCODE::G_CTTZ)
  .value("G_CTTZ_ZERO_UNDEF", LIEF::assembly::aarch64::OPCODE::G_CTTZ_ZERO_UNDEF)
  .value("G_CTLZ", LIEF::assembly::aarch64::OPCODE::G_CTLZ)
  .value("G_CTLZ_ZERO_UNDEF", LIEF::assembly::aarch64::OPCODE::G_CTLZ_ZERO_UNDEF)
  .value("G_CTPOP", LIEF::assembly::aarch64::OPCODE::G_CTPOP)
  .value("G_BSWAP", LIEF::assembly::aarch64::OPCODE::G_BSWAP)
  .value("G_BITREVERSE", LIEF::assembly::aarch64::OPCODE::G_BITREVERSE)
  .value("G_FCEIL", LIEF::assembly::aarch64::OPCODE::G_FCEIL)
  .value("G_FCOS", LIEF::assembly::aarch64::OPCODE::G_FCOS)
  .value("G_FSIN", LIEF::assembly::aarch64::OPCODE::G_FSIN)
  .value("G_FSINCOS", LIEF::assembly::aarch64::OPCODE::G_FSINCOS)
  .value("G_FTAN", LIEF::assembly::aarch64::OPCODE::G_FTAN)
  .value("G_FACOS", LIEF::assembly::aarch64::OPCODE::G_FACOS)
  .value("G_FASIN", LIEF::assembly::aarch64::OPCODE::G_FASIN)
  .value("G_FATAN", LIEF::assembly::aarch64::OPCODE::G_FATAN)
  .value("G_FATAN2", LIEF::assembly::aarch64::OPCODE::G_FATAN2)
  .value("G_FCOSH", LIEF::assembly::aarch64::OPCODE::G_FCOSH)
  .value("G_FSINH", LIEF::assembly::aarch64::OPCODE::G_FSINH)
  .value("G_FTANH", LIEF::assembly::aarch64::OPCODE::G_FTANH)
  .value("G_FSQRT", LIEF::assembly::aarch64::OPCODE::G_FSQRT)
  .value("G_FFLOOR", LIEF::assembly::aarch64::OPCODE::G_FFLOOR)
  .value("G_FRINT", LIEF::assembly::aarch64::OPCODE::G_FRINT)
  .value("G_FNEARBYINT", LIEF::assembly::aarch64::OPCODE::G_FNEARBYINT)
  .value("G_ADDRSPACE_CAST", LIEF::assembly::aarch64::OPCODE::G_ADDRSPACE_CAST)
  .value("G_BLOCK_ADDR", LIEF::assembly::aarch64::OPCODE::G_BLOCK_ADDR)
  .value("G_JUMP_TABLE", LIEF::assembly::aarch64::OPCODE::G_JUMP_TABLE)
  .value("G_DYN_STACKALLOC", LIEF::assembly::aarch64::OPCODE::G_DYN_STACKALLOC)
  .value("G_STACKSAVE", LIEF::assembly::aarch64::OPCODE::G_STACKSAVE)
  .value("G_STACKRESTORE", LIEF::assembly::aarch64::OPCODE::G_STACKRESTORE)
  .value("G_STRICT_FADD", LIEF::assembly::aarch64::OPCODE::G_STRICT_FADD)
  .value("G_STRICT_FSUB", LIEF::assembly::aarch64::OPCODE::G_STRICT_FSUB)
  .value("G_STRICT_FMUL", LIEF::assembly::aarch64::OPCODE::G_STRICT_FMUL)
  .value("G_STRICT_FDIV", LIEF::assembly::aarch64::OPCODE::G_STRICT_FDIV)
  .value("G_STRICT_FREM", LIEF::assembly::aarch64::OPCODE::G_STRICT_FREM)
  .value("G_STRICT_FMA", LIEF::assembly::aarch64::OPCODE::G_STRICT_FMA)
  .value("G_STRICT_FSQRT", LIEF::assembly::aarch64::OPCODE::G_STRICT_FSQRT)
  .value("G_STRICT_FLDEXP", LIEF::assembly::aarch64::OPCODE::G_STRICT_FLDEXP)
  .value("G_READ_REGISTER", LIEF::assembly::aarch64::OPCODE::G_READ_REGISTER)
  .value("G_WRITE_REGISTER", LIEF::assembly::aarch64::OPCODE::G_WRITE_REGISTER)
  .value("G_MEMCPY", LIEF::assembly::aarch64::OPCODE::G_MEMCPY)
  .value("G_MEMCPY_INLINE", LIEF::assembly::aarch64::OPCODE::G_MEMCPY_INLINE)
  .value("G_MEMMOVE", LIEF::assembly::aarch64::OPCODE::G_MEMMOVE)
  .value("G_MEMSET", LIEF::assembly::aarch64::OPCODE::G_MEMSET)
  .value("G_BZERO", LIEF::assembly::aarch64::OPCODE::G_BZERO)
  .value("G_TRAP", LIEF::assembly::aarch64::OPCODE::G_TRAP)
  .value("G_DEBUGTRAP", LIEF::assembly::aarch64::OPCODE::G_DEBUGTRAP)
  .value("G_UBSANTRAP", LIEF::assembly::aarch64::OPCODE::G_UBSANTRAP)
  .value("G_VECREDUCE_SEQ_FADD", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_SEQ_FADD)
  .value("G_VECREDUCE_SEQ_FMUL", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_SEQ_FMUL)
  .value("G_VECREDUCE_FADD", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_FADD)
  .value("G_VECREDUCE_FMUL", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_FMUL)
  .value("G_VECREDUCE_FMAX", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_FMAX);
  opcodes.value("G_VECREDUCE_FMIN", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_FMIN)
  .value("G_VECREDUCE_FMAXIMUM", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_FMAXIMUM)
  .value("G_VECREDUCE_FMINIMUM", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_FMINIMUM)
  .value("G_VECREDUCE_ADD", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_ADD)
  .value("G_VECREDUCE_MUL", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_MUL)
  .value("G_VECREDUCE_AND", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_AND)
  .value("G_VECREDUCE_OR", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_OR)
  .value("G_VECREDUCE_XOR", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_XOR)
  .value("G_VECREDUCE_SMAX", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_SMAX)
  .value("G_VECREDUCE_SMIN", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_SMIN)
  .value("G_VECREDUCE_UMAX", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_UMAX)
  .value("G_VECREDUCE_UMIN", LIEF::assembly::aarch64::OPCODE::G_VECREDUCE_UMIN)
  .value("G_SBFX", LIEF::assembly::aarch64::OPCODE::G_SBFX)
  .value("G_UBFX", LIEF::assembly::aarch64::OPCODE::G_UBFX)
  .value("ABS_ZPmZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::ABS_ZPmZ_B_UNDEF)
  .value("ABS_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::ABS_ZPmZ_D_UNDEF)
  .value("ABS_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::ABS_ZPmZ_H_UNDEF)
  .value("ABS_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::ABS_ZPmZ_S_UNDEF)
  .value("ADDHA_MPPZ_D_PSEUDO_D", LIEF::assembly::aarch64::OPCODE::ADDHA_MPPZ_D_PSEUDO_D)
  .value("ADDHA_MPPZ_S_PSEUDO_S", LIEF::assembly::aarch64::OPCODE::ADDHA_MPPZ_S_PSEUDO_S)
  .value("ADDSWrr", LIEF::assembly::aarch64::OPCODE::ADDSWrr)
  .value("ADDSXrr", LIEF::assembly::aarch64::OPCODE::ADDSXrr)
  .value("ADDVA_MPPZ_D_PSEUDO_D", LIEF::assembly::aarch64::OPCODE::ADDVA_MPPZ_D_PSEUDO_D)
  .value("ADDVA_MPPZ_S_PSEUDO_S", LIEF::assembly::aarch64::OPCODE::ADDVA_MPPZ_S_PSEUDO_S)
  .value("ADDWrr", LIEF::assembly::aarch64::OPCODE::ADDWrr)
  .value("ADDXrr", LIEF::assembly::aarch64::OPCODE::ADDXrr)
  .value("ADD_VG2_M2Z2Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::ADD_VG2_M2Z2Z_D_PSEUDO)
  .value("ADD_VG2_M2Z2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::ADD_VG2_M2Z2Z_S_PSEUDO)
  .value("ADD_VG2_M2ZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::ADD_VG2_M2ZZ_D_PSEUDO)
  .value("ADD_VG2_M2ZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::ADD_VG2_M2ZZ_S_PSEUDO)
  .value("ADD_VG2_M2Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::ADD_VG2_M2Z_D_PSEUDO)
  .value("ADD_VG2_M2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::ADD_VG2_M2Z_S_PSEUDO)
  .value("ADD_VG4_M4Z4Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::ADD_VG4_M4Z4Z_D_PSEUDO)
  .value("ADD_VG4_M4Z4Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::ADD_VG4_M4Z4Z_S_PSEUDO)
  .value("ADD_VG4_M4ZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::ADD_VG4_M4ZZ_D_PSEUDO)
  .value("ADD_VG4_M4ZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::ADD_VG4_M4ZZ_S_PSEUDO)
  .value("ADD_VG4_M4Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::ADD_VG4_M4Z_D_PSEUDO)
  .value("ADD_VG4_M4Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::ADD_VG4_M4Z_S_PSEUDO)
  .value("ADD_ZPZZ_B_ZERO", LIEF::assembly::aarch64::OPCODE::ADD_ZPZZ_B_ZERO)
  .value("ADD_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::ADD_ZPZZ_D_ZERO)
  .value("ADD_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::ADD_ZPZZ_H_ZERO)
  .value("ADD_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::ADD_ZPZZ_S_ZERO)
  .value("ADDlowTLS", LIEF::assembly::aarch64::OPCODE::ADDlowTLS)
  .value("ADJCALLSTACKDOWN", LIEF::assembly::aarch64::OPCODE::ADJCALLSTACKDOWN)
  .value("ADJCALLSTACKUP", LIEF::assembly::aarch64::OPCODE::ADJCALLSTACKUP)
  .value("AESIMCrrTied", LIEF::assembly::aarch64::OPCODE::AESIMCrrTied)
  .value("AESMCrrTied", LIEF::assembly::aarch64::OPCODE::AESMCrrTied)
  .value("ANDSWrr", LIEF::assembly::aarch64::OPCODE::ANDSWrr)
  .value("ANDSXrr", LIEF::assembly::aarch64::OPCODE::ANDSXrr)
  .value("ANDWrr", LIEF::assembly::aarch64::OPCODE::ANDWrr)
  .value("ANDXrr", LIEF::assembly::aarch64::OPCODE::ANDXrr)
  .value("AND_ZPZZ_B_ZERO", LIEF::assembly::aarch64::OPCODE::AND_ZPZZ_B_ZERO)
  .value("AND_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::AND_ZPZZ_D_ZERO)
  .value("AND_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::AND_ZPZZ_H_ZERO)
  .value("AND_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::AND_ZPZZ_S_ZERO)
  .value("ASRD_ZPZI_B_ZERO", LIEF::assembly::aarch64::OPCODE::ASRD_ZPZI_B_ZERO)
  .value("ASRD_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::ASRD_ZPZI_D_ZERO)
  .value("ASRD_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::ASRD_ZPZI_H_ZERO)
  .value("ASRD_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::ASRD_ZPZI_S_ZERO)
  .value("ASR_ZPZI_B_UNDEF", LIEF::assembly::aarch64::OPCODE::ASR_ZPZI_B_UNDEF)
  .value("ASR_ZPZI_B_ZERO", LIEF::assembly::aarch64::OPCODE::ASR_ZPZI_B_ZERO)
  .value("ASR_ZPZI_D_UNDEF", LIEF::assembly::aarch64::OPCODE::ASR_ZPZI_D_UNDEF)
  .value("ASR_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::ASR_ZPZI_D_ZERO)
  .value("ASR_ZPZI_H_UNDEF", LIEF::assembly::aarch64::OPCODE::ASR_ZPZI_H_UNDEF)
  .value("ASR_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::ASR_ZPZI_H_ZERO)
  .value("ASR_ZPZI_S_UNDEF", LIEF::assembly::aarch64::OPCODE::ASR_ZPZI_S_UNDEF)
  .value("ASR_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::ASR_ZPZI_S_ZERO)
  .value("ASR_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::ASR_ZPZZ_B_UNDEF)
  .value("ASR_ZPZZ_B_ZERO", LIEF::assembly::aarch64::OPCODE::ASR_ZPZZ_B_ZERO)
  .value("ASR_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::ASR_ZPZZ_D_UNDEF)
  .value("ASR_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::ASR_ZPZZ_D_ZERO)
  .value("ASR_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::ASR_ZPZZ_H_UNDEF)
  .value("ASR_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::ASR_ZPZZ_H_ZERO)
  .value("ASR_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::ASR_ZPZZ_S_UNDEF)
  .value("ASR_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::ASR_ZPZZ_S_ZERO)
  .value("AUTH_TCRETURN", LIEF::assembly::aarch64::OPCODE::AUTH_TCRETURN)
  .value("AUTH_TCRETURN_BTI", LIEF::assembly::aarch64::OPCODE::AUTH_TCRETURN_BTI)
  .value("AUTPAC", LIEF::assembly::aarch64::OPCODE::AUTPAC)
  .value("AUTx16x17", LIEF::assembly::aarch64::OPCODE::AUTx16x17)
  .value("AUTxMxN", LIEF::assembly::aarch64::OPCODE::AUTxMxN)
  .value("AllocateSMESaveBuffer", LIEF::assembly::aarch64::OPCODE::AllocateSMESaveBuffer)
  .value("AllocateZABuffer", LIEF::assembly::aarch64::OPCODE::AllocateZABuffer)
  .value("BFADD_VG2_M2Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFADD_VG2_M2Z_H_PSEUDO)
  .value("BFADD_VG4_M4Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFADD_VG4_M4Z_H_PSEUDO)
  .value("BFADD_ZPZZ_UNDEF", LIEF::assembly::aarch64::OPCODE::BFADD_ZPZZ_UNDEF)
  .value("BFADD_ZPZZ_ZERO", LIEF::assembly::aarch64::OPCODE::BFADD_ZPZZ_ZERO)
  .value("BFDOT_VG2_M2Z2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFDOT_VG2_M2Z2Z_HtoS_PSEUDO)
  .value("BFDOT_VG2_M2ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFDOT_VG2_M2ZZI_HtoS_PSEUDO)
  .value("BFDOT_VG2_M2ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFDOT_VG2_M2ZZ_HtoS_PSEUDO)
  .value("BFDOT_VG4_M4Z4Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFDOT_VG4_M4Z4Z_HtoS_PSEUDO)
  .value("BFDOT_VG4_M4ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFDOT_VG4_M4ZZI_HtoS_PSEUDO)
  .value("BFDOT_VG4_M4ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFDOT_VG4_M4ZZ_HtoS_PSEUDO)
  .value("BFMAXNM_ZPZZ_UNDEF", LIEF::assembly::aarch64::OPCODE::BFMAXNM_ZPZZ_UNDEF)
  .value("BFMAXNM_ZPZZ_ZERO", LIEF::assembly::aarch64::OPCODE::BFMAXNM_ZPZZ_ZERO)
  .value("BFMAX_ZPZZ_UNDEF", LIEF::assembly::aarch64::OPCODE::BFMAX_ZPZZ_UNDEF)
  .value("BFMAX_ZPZZ_ZERO", LIEF::assembly::aarch64::OPCODE::BFMAX_ZPZZ_ZERO)
  .value("BFMINNM_ZPZZ_UNDEF", LIEF::assembly::aarch64::OPCODE::BFMINNM_ZPZZ_UNDEF)
  .value("BFMINNM_ZPZZ_ZERO", LIEF::assembly::aarch64::OPCODE::BFMINNM_ZPZZ_ZERO)
  .value("BFMIN_ZPZZ_UNDEF", LIEF::assembly::aarch64::OPCODE::BFMIN_ZPZZ_UNDEF)
  .value("BFMIN_ZPZZ_ZERO", LIEF::assembly::aarch64::OPCODE::BFMIN_ZPZZ_ZERO)
  .value("BFMLAL_MZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLAL_MZZI_HtoS_PSEUDO)
  .value("BFMLAL_MZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLAL_MZZ_HtoS_PSEUDO)
  .value("BFMLAL_VG2_M2Z2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLAL_VG2_M2Z2Z_HtoS_PSEUDO)
  .value("BFMLAL_VG2_M2ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLAL_VG2_M2ZZI_HtoS_PSEUDO)
  .value("BFMLAL_VG2_M2ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLAL_VG2_M2ZZ_HtoS_PSEUDO)
  .value("BFMLAL_VG4_M4Z4Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLAL_VG4_M4Z4Z_HtoS_PSEUDO)
  .value("BFMLAL_VG4_M4ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLAL_VG4_M4ZZI_HtoS_PSEUDO)
  .value("BFMLAL_VG4_M4ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLAL_VG4_M4ZZ_HtoS_PSEUDO)
  .value("BFMLA_VG2_M2Z2Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLA_VG2_M2Z2Z_PSEUDO)
  .value("BFMLA_VG2_M2ZZI_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLA_VG2_M2ZZI_PSEUDO)
  .value("BFMLA_VG2_M2ZZ_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLA_VG2_M2ZZ_PSEUDO)
  .value("BFMLA_VG4_M4Z4Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLA_VG4_M4Z4Z_PSEUDO)
  .value("BFMLA_VG4_M4ZZI_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLA_VG4_M4ZZI_PSEUDO)
  .value("BFMLA_VG4_M4ZZ_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLA_VG4_M4ZZ_PSEUDO)
  .value("BFMLA_ZPZZZ_UNDEF", LIEF::assembly::aarch64::OPCODE::BFMLA_ZPZZZ_UNDEF)
  .value("BFMLSL_MZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLSL_MZZI_HtoS_PSEUDO)
  .value("BFMLSL_MZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLSL_MZZ_HtoS_PSEUDO)
  .value("BFMLSL_VG2_M2Z2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLSL_VG2_M2Z2Z_HtoS_PSEUDO)
  .value("BFMLSL_VG2_M2ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLSL_VG2_M2ZZI_HtoS_PSEUDO)
  .value("BFMLSL_VG2_M2ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLSL_VG2_M2ZZ_HtoS_PSEUDO)
  .value("BFMLSL_VG4_M4Z4Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLSL_VG4_M4Z4Z_HtoS_PSEUDO)
  .value("BFMLSL_VG4_M4ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLSL_VG4_M4ZZI_HtoS_PSEUDO)
  .value("BFMLSL_VG4_M4ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLSL_VG4_M4ZZ_HtoS_PSEUDO)
  .value("BFMLS_VG2_M2Z2Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLS_VG2_M2Z2Z_PSEUDO)
  .value("BFMLS_VG2_M2ZZI_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLS_VG2_M2ZZI_PSEUDO)
  .value("BFMLS_VG2_M2ZZ_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLS_VG2_M2ZZ_PSEUDO)
  .value("BFMLS_VG4_M4Z4Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLS_VG4_M4Z4Z_PSEUDO)
  .value("BFMLS_VG4_M4ZZI_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLS_VG4_M4ZZI_PSEUDO)
  .value("BFMLS_VG4_M4ZZ_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMLS_VG4_M4ZZ_PSEUDO)
  .value("BFMLS_ZPZZZ_UNDEF", LIEF::assembly::aarch64::OPCODE::BFMLS_ZPZZZ_UNDEF)
  .value("BFMOP4A_M2Z2Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4A_M2Z2Z_H_PSEUDO)
  .value("BFMOP4A_M2Z2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4A_M2Z2Z_S_PSEUDO)
  .value("BFMOP4A_M2ZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4A_M2ZZ_H_PSEUDO)
  .value("BFMOP4A_M2ZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4A_M2ZZ_S_PSEUDO)
  .value("BFMOP4A_MZ2Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4A_MZ2Z_H_PSEUDO)
  .value("BFMOP4A_MZ2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4A_MZ2Z_S_PSEUDO)
  .value("BFMOP4A_MZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4A_MZZ_H_PSEUDO)
  .value("BFMOP4A_MZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4A_MZZ_S_PSEUDO)
  .value("BFMOP4S_M2Z2Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4S_M2Z2Z_H_PSEUDO)
  .value("BFMOP4S_M2Z2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4S_M2Z2Z_S_PSEUDO)
  .value("BFMOP4S_M2ZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4S_M2ZZ_H_PSEUDO)
  .value("BFMOP4S_M2ZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4S_M2ZZ_S_PSEUDO)
  .value("BFMOP4S_MZ2Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4S_MZ2Z_H_PSEUDO)
  .value("BFMOP4S_MZ2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4S_MZ2Z_S_PSEUDO)
  .value("BFMOP4S_MZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4S_MZZ_H_PSEUDO)
  .value("BFMOP4S_MZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOP4S_MZZ_S_PSEUDO)
  .value("BFMOPA_MPPZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOPA_MPPZZ_H_PSEUDO)
  .value("BFMOPA_MPPZZ_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOPA_MPPZZ_PSEUDO)
  .value("BFMOPS_MPPZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOPS_MPPZZ_H_PSEUDO)
  .value("BFMOPS_MPPZZ_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFMOPS_MPPZZ_PSEUDO)
  .value("BFMUL_ZPZZ_UNDEF", LIEF::assembly::aarch64::OPCODE::BFMUL_ZPZZ_UNDEF)
  .value("BFMUL_ZPZZ_ZERO", LIEF::assembly::aarch64::OPCODE::BFMUL_ZPZZ_ZERO)
  .value("BFSUB_VG2_M2Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFSUB_VG2_M2Z_H_PSEUDO)
  .value("BFSUB_VG4_M4Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFSUB_VG4_M4Z_H_PSEUDO)
  .value("BFSUB_ZPZZ_UNDEF", LIEF::assembly::aarch64::OPCODE::BFSUB_ZPZZ_UNDEF)
  .value("BFSUB_ZPZZ_ZERO", LIEF::assembly::aarch64::OPCODE::BFSUB_ZPZZ_ZERO)
  .value("BFTMOPA_M2ZZZI_HtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFTMOPA_M2ZZZI_HtoH_PSEUDO)
  .value("BFTMOPA_M2ZZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFTMOPA_M2ZZZI_HtoS_PSEUDO)
  .value("BFVDOT_VG2_M2ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::BFVDOT_VG2_M2ZZI_HtoS_PSEUDO)
  .value("BICSWrr", LIEF::assembly::aarch64::OPCODE::BICSWrr)
  .value("BICSXrr", LIEF::assembly::aarch64::OPCODE::BICSXrr)
  .value("BICWrr", LIEF::assembly::aarch64::OPCODE::BICWrr)
  .value("BICXrr", LIEF::assembly::aarch64::OPCODE::BICXrr)
  .value("BIC_ZPZZ_B_ZERO", LIEF::assembly::aarch64::OPCODE::BIC_ZPZZ_B_ZERO)
  .value("BIC_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::BIC_ZPZZ_D_ZERO)
  .value("BIC_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::BIC_ZPZZ_H_ZERO)
  .value("BIC_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::BIC_ZPZZ_S_ZERO)
  .value("BLRA", LIEF::assembly::aarch64::OPCODE::BLRA)
  .value("BLRA_RVMARKER", LIEF::assembly::aarch64::OPCODE::BLRA_RVMARKER)
  .value("BLRNoIP", LIEF::assembly::aarch64::OPCODE::BLRNoIP)
  .value("BLR_BTI", LIEF::assembly::aarch64::OPCODE::BLR_BTI)
  .value("BLR_RVMARKER", LIEF::assembly::aarch64::OPCODE::BLR_RVMARKER)
  .value("BLR_X16", LIEF::assembly::aarch64::OPCODE::BLR_X16)
  .value("BMOPA_MPPZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::BMOPA_MPPZZ_S_PSEUDO)
  .value("BMOPS_MPPZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::BMOPS_MPPZZ_S_PSEUDO)
  .value("BRA", LIEF::assembly::aarch64::OPCODE::BRA)
  .value("BR_JumpTable", LIEF::assembly::aarch64::OPCODE::BR_JumpTable)
  .value("BSPv16i8", LIEF::assembly::aarch64::OPCODE::BSPv16i8)
  .value("BSPv8i8", LIEF::assembly::aarch64::OPCODE::BSPv8i8)
  .value("CATCHRET", LIEF::assembly::aarch64::OPCODE::CATCHRET)
  .value("CBWPri", LIEF::assembly::aarch64::OPCODE::CBWPri)
  .value("CBWPrr", LIEF::assembly::aarch64::OPCODE::CBWPrr)
  .value("CBXPri", LIEF::assembly::aarch64::OPCODE::CBXPri)
  .value("CBXPrr", LIEF::assembly::aarch64::OPCODE::CBXPrr)
  .value("CLEANUPRET", LIEF::assembly::aarch64::OPCODE::CLEANUPRET)
  .value("CLS_ZPmZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::CLS_ZPmZ_B_UNDEF)
  .value("CLS_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::CLS_ZPmZ_D_UNDEF)
  .value("CLS_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::CLS_ZPmZ_H_UNDEF)
  .value("CLS_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::CLS_ZPmZ_S_UNDEF)
  .value("CLZ_ZPmZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::CLZ_ZPmZ_B_UNDEF)
  .value("CLZ_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::CLZ_ZPmZ_D_UNDEF)
  .value("CLZ_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::CLZ_ZPmZ_H_UNDEF)
  .value("CLZ_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::CLZ_ZPmZ_S_UNDEF)
  .value("CMP_SWAP_128", LIEF::assembly::aarch64::OPCODE::CMP_SWAP_128)
  .value("CMP_SWAP_128_ACQUIRE", LIEF::assembly::aarch64::OPCODE::CMP_SWAP_128_ACQUIRE)
  .value("CMP_SWAP_128_MONOTONIC", LIEF::assembly::aarch64::OPCODE::CMP_SWAP_128_MONOTONIC)
  .value("CMP_SWAP_128_RELEASE", LIEF::assembly::aarch64::OPCODE::CMP_SWAP_128_RELEASE)
  .value("CMP_SWAP_16", LIEF::assembly::aarch64::OPCODE::CMP_SWAP_16)
  .value("CMP_SWAP_32", LIEF::assembly::aarch64::OPCODE::CMP_SWAP_32)
  .value("CMP_SWAP_64", LIEF::assembly::aarch64::OPCODE::CMP_SWAP_64)
  .value("CMP_SWAP_8", LIEF::assembly::aarch64::OPCODE::CMP_SWAP_8)
  .value("CNOT_ZPmZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::CNOT_ZPmZ_B_UNDEF)
  .value("CNOT_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::CNOT_ZPmZ_D_UNDEF)
  .value("CNOT_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::CNOT_ZPmZ_H_UNDEF)
  .value("CNOT_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::CNOT_ZPmZ_S_UNDEF)
  .value("CNT_ZPmZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::CNT_ZPmZ_B_UNDEF)
  .value("CNT_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::CNT_ZPmZ_D_UNDEF)
  .value("CNT_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::CNT_ZPmZ_H_UNDEF)
  .value("CNT_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::CNT_ZPmZ_S_UNDEF)
  .value("COALESCER_BARRIER_FPR128", LIEF::assembly::aarch64::OPCODE::COALESCER_BARRIER_FPR128)
  .value("COALESCER_BARRIER_FPR16", LIEF::assembly::aarch64::OPCODE::COALESCER_BARRIER_FPR16)
  .value("COALESCER_BARRIER_FPR32", LIEF::assembly::aarch64::OPCODE::COALESCER_BARRIER_FPR32)
  .value("COALESCER_BARRIER_FPR64", LIEF::assembly::aarch64::OPCODE::COALESCER_BARRIER_FPR64)
  .value("EMITBKEY", LIEF::assembly::aarch64::OPCODE::EMITBKEY)
  .value("EMITMTETAGGED", LIEF::assembly::aarch64::OPCODE::EMITMTETAGGED)
  .value("EONWrr", LIEF::assembly::aarch64::OPCODE::EONWrr)
  .value("EONXrr", LIEF::assembly::aarch64::OPCODE::EONXrr)
  .value("EORWrr", LIEF::assembly::aarch64::OPCODE::EORWrr)
  .value("EORXrr", LIEF::assembly::aarch64::OPCODE::EORXrr)
  .value("EOR_ZPZZ_B_ZERO", LIEF::assembly::aarch64::OPCODE::EOR_ZPZZ_B_ZERO)
  .value("EOR_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::EOR_ZPZZ_D_ZERO)
  .value("EOR_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::EOR_ZPZZ_H_ZERO)
  .value("EOR_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::EOR_ZPZZ_S_ZERO)
  .value("F128CSEL", LIEF::assembly::aarch64::OPCODE::F128CSEL)
  .value("FABD_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FABD_ZPZZ_D_UNDEF)
  .value("FABD_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::FABD_ZPZZ_D_ZERO)
  .value("FABD_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FABD_ZPZZ_H_UNDEF)
  .value("FABD_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::FABD_ZPZZ_H_ZERO)
  .value("FABD_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FABD_ZPZZ_S_UNDEF)
  .value("FABD_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::FABD_ZPZZ_S_ZERO)
  .value("FABS_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FABS_ZPmZ_D_UNDEF)
  .value("FABS_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FABS_ZPmZ_H_UNDEF)
  .value("FABS_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FABS_ZPmZ_S_UNDEF)
  .value("FADD_VG2_M2Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FADD_VG2_M2Z_D_PSEUDO)
  .value("FADD_VG2_M2Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FADD_VG2_M2Z_H_PSEUDO)
  .value("FADD_VG2_M2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FADD_VG2_M2Z_S_PSEUDO)
  .value("FADD_VG4_M4Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FADD_VG4_M4Z_D_PSEUDO)
  .value("FADD_VG4_M4Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FADD_VG4_M4Z_H_PSEUDO)
  .value("FADD_VG4_M4Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FADD_VG4_M4Z_S_PSEUDO)
  .value("FADD_ZPZI_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FADD_ZPZI_D_UNDEF)
  .value("FADD_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::FADD_ZPZI_D_ZERO)
  .value("FADD_ZPZI_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FADD_ZPZI_H_UNDEF)
  .value("FADD_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::FADD_ZPZI_H_ZERO)
  .value("FADD_ZPZI_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FADD_ZPZI_S_UNDEF)
  .value("FADD_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::FADD_ZPZI_S_ZERO)
  .value("FADD_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FADD_ZPZZ_D_UNDEF)
  .value("FADD_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::FADD_ZPZZ_D_ZERO)
  .value("FADD_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FADD_ZPZZ_H_UNDEF)
  .value("FADD_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::FADD_ZPZZ_H_ZERO)
  .value("FADD_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FADD_ZPZZ_S_UNDEF)
  .value("FADD_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::FADD_ZPZZ_S_ZERO)
  .value("FAMAX_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FAMAX_ZPZZ_D_UNDEF)
  .value("FAMAX_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FAMAX_ZPZZ_H_UNDEF)
  .value("FAMAX_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FAMAX_ZPZZ_S_UNDEF)
  .value("FAMIN_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FAMIN_ZPZZ_D_UNDEF)
  .value("FAMIN_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FAMIN_ZPZZ_H_UNDEF)
  .value("FAMIN_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FAMIN_ZPZZ_S_UNDEF)
  .value("FCVTZS_ZPmZ_DtoD_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPmZ_DtoD_UNDEF)
  .value("FCVTZS_ZPmZ_DtoS_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPmZ_DtoS_UNDEF)
  .value("FCVTZS_ZPmZ_HtoD_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPmZ_HtoD_UNDEF)
  .value("FCVTZS_ZPmZ_HtoH_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPmZ_HtoH_UNDEF)
  .value("FCVTZS_ZPmZ_HtoS_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPmZ_HtoS_UNDEF)
  .value("FCVTZS_ZPmZ_StoD_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPmZ_StoD_UNDEF)
  .value("FCVTZS_ZPmZ_StoS_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPmZ_StoS_UNDEF)
  .value("FCVTZU_ZPmZ_DtoD_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPmZ_DtoD_UNDEF)
  .value("FCVTZU_ZPmZ_DtoS_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPmZ_DtoS_UNDEF)
  .value("FCVTZU_ZPmZ_HtoD_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPmZ_HtoD_UNDEF)
  .value("FCVTZU_ZPmZ_HtoH_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPmZ_HtoH_UNDEF)
  .value("FCVTZU_ZPmZ_HtoS_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPmZ_HtoS_UNDEF)
  .value("FCVTZU_ZPmZ_StoD_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPmZ_StoD_UNDEF)
  .value("FCVTZU_ZPmZ_StoS_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPmZ_StoS_UNDEF)
  .value("FCVT_ZPmZ_DtoH_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVT_ZPmZ_DtoH_UNDEF)
  .value("FCVT_ZPmZ_DtoS_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVT_ZPmZ_DtoS_UNDEF)
  .value("FCVT_ZPmZ_HtoD_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVT_ZPmZ_HtoD_UNDEF)
  .value("FCVT_ZPmZ_HtoS_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVT_ZPmZ_HtoS_UNDEF)
  .value("FCVT_ZPmZ_StoD_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVT_ZPmZ_StoD_UNDEF)
  .value("FCVT_ZPmZ_StoH_UNDEF", LIEF::assembly::aarch64::OPCODE::FCVT_ZPmZ_StoH_UNDEF)
  .value("FDIVR_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::FDIVR_ZPZZ_D_ZERO)
  .value("FDIVR_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::FDIVR_ZPZZ_H_ZERO)
  .value("FDIVR_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::FDIVR_ZPZZ_S_ZERO)
  .value("FDIV_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FDIV_ZPZZ_D_UNDEF)
  .value("FDIV_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::FDIV_ZPZZ_D_ZERO)
  .value("FDIV_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FDIV_ZPZZ_H_UNDEF)
  .value("FDIV_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::FDIV_ZPZZ_H_ZERO)
  .value("FDIV_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FDIV_ZPZZ_S_UNDEF)
  .value("FDIV_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::FDIV_ZPZZ_S_ZERO)
  .value("FDOT_VG2_M2Z2Z_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2Z2Z_BtoH_PSEUDO)
  .value("FDOT_VG2_M2Z2Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2Z2Z_BtoS_PSEUDO)
  .value("FDOT_VG2_M2Z2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2Z2Z_HtoS_PSEUDO)
  .value("FDOT_VG2_M2ZZI_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2ZZI_BtoH_PSEUDO)
  .value("FDOT_VG2_M2ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2ZZI_BtoS_PSEUDO)
  .value("FDOT_VG2_M2ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2ZZI_HtoS_PSEUDO)
  .value("FDOT_VG2_M2ZZ_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2ZZ_BtoH_PSEUDO)
  .value("FDOT_VG2_M2ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2ZZ_BtoS_PSEUDO)
  .value("FDOT_VG2_M2ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2ZZ_HtoS_PSEUDO)
  .value("FDOT_VG4_M4Z4Z_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4Z4Z_BtoH_PSEUDO)
  .value("FDOT_VG4_M4Z4Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4Z4Z_BtoS_PSEUDO)
  .value("FDOT_VG4_M4Z4Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4Z4Z_HtoS_PSEUDO)
  .value("FDOT_VG4_M4ZZI_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4ZZI_BtoH_PSEUDO)
  .value("FDOT_VG4_M4ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4ZZI_BtoS_PSEUDO);
  opcodes.value("FDOT_VG4_M4ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4ZZI_HtoS_PSEUDO)
  .value("FDOT_VG4_M4ZZ_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4ZZ_BtoH_PSEUDO)
  .value("FDOT_VG4_M4ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4ZZ_BtoS_PSEUDO)
  .value("FDOT_VG4_M4ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4ZZ_HtoS_PSEUDO)
  .value("FILL_PPR_FROM_ZPR_SLOT_PSEUDO", LIEF::assembly::aarch64::OPCODE::FILL_PPR_FROM_ZPR_SLOT_PSEUDO)
  .value("FLOGB_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::FLOGB_ZPZZ_D_ZERO)
  .value("FLOGB_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::FLOGB_ZPZZ_H_ZERO)
  .value("FLOGB_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::FLOGB_ZPZZ_S_ZERO)
  .value("FMAXNM_ZPZI_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPZI_D_UNDEF)
  .value("FMAXNM_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPZI_D_ZERO)
  .value("FMAXNM_ZPZI_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPZI_H_UNDEF)
  .value("FMAXNM_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPZI_H_ZERO)
  .value("FMAXNM_ZPZI_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPZI_S_UNDEF)
  .value("FMAXNM_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPZI_S_ZERO)
  .value("FMAXNM_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPZZ_D_UNDEF)
  .value("FMAXNM_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPZZ_D_ZERO)
  .value("FMAXNM_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPZZ_H_UNDEF)
  .value("FMAXNM_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPZZ_H_ZERO)
  .value("FMAXNM_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPZZ_S_UNDEF)
  .value("FMAXNM_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPZZ_S_ZERO)
  .value("FMAX_ZPZI_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FMAX_ZPZI_D_UNDEF)
  .value("FMAX_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::FMAX_ZPZI_D_ZERO)
  .value("FMAX_ZPZI_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FMAX_ZPZI_H_UNDEF)
  .value("FMAX_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::FMAX_ZPZI_H_ZERO)
  .value("FMAX_ZPZI_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FMAX_ZPZI_S_UNDEF)
  .value("FMAX_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::FMAX_ZPZI_S_ZERO)
  .value("FMAX_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FMAX_ZPZZ_D_UNDEF)
  .value("FMAX_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::FMAX_ZPZZ_D_ZERO)
  .value("FMAX_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FMAX_ZPZZ_H_UNDEF)
  .value("FMAX_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::FMAX_ZPZZ_H_ZERO)
  .value("FMAX_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FMAX_ZPZZ_S_UNDEF)
  .value("FMAX_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::FMAX_ZPZZ_S_ZERO)
  .value("FMINNM_ZPZI_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPZI_D_UNDEF)
  .value("FMINNM_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPZI_D_ZERO)
  .value("FMINNM_ZPZI_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPZI_H_UNDEF)
  .value("FMINNM_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPZI_H_ZERO)
  .value("FMINNM_ZPZI_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPZI_S_UNDEF)
  .value("FMINNM_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPZI_S_ZERO)
  .value("FMINNM_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPZZ_D_UNDEF)
  .value("FMINNM_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPZZ_D_ZERO)
  .value("FMINNM_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPZZ_H_UNDEF)
  .value("FMINNM_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPZZ_H_ZERO)
  .value("FMINNM_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPZZ_S_UNDEF)
  .value("FMINNM_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPZZ_S_ZERO)
  .value("FMIN_ZPZI_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FMIN_ZPZI_D_UNDEF)
  .value("FMIN_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::FMIN_ZPZI_D_ZERO)
  .value("FMIN_ZPZI_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FMIN_ZPZI_H_UNDEF)
  .value("FMIN_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::FMIN_ZPZI_H_ZERO)
  .value("FMIN_ZPZI_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FMIN_ZPZI_S_UNDEF)
  .value("FMIN_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::FMIN_ZPZI_S_ZERO)
  .value("FMIN_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FMIN_ZPZZ_D_UNDEF)
  .value("FMIN_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::FMIN_ZPZZ_D_ZERO)
  .value("FMIN_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FMIN_ZPZZ_H_UNDEF)
  .value("FMIN_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::FMIN_ZPZZ_H_ZERO)
  .value("FMIN_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FMIN_ZPZZ_S_UNDEF)
  .value("FMIN_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::FMIN_ZPZZ_S_ZERO)
  .value("FMLALL_MZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLALL_MZZI_BtoS_PSEUDO)
  .value("FMLALL_MZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLALL_MZZ_BtoS_PSEUDO)
  .value("FMLALL_VG2_M2Z2Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLALL_VG2_M2Z2Z_BtoS_PSEUDO)
  .value("FMLALL_VG2_M2ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLALL_VG2_M2ZZI_BtoS_PSEUDO)
  .value("FMLALL_VG2_M2ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLALL_VG2_M2ZZ_BtoS_PSEUDO)
  .value("FMLALL_VG4_M4Z4Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLALL_VG4_M4Z4Z_BtoS_PSEUDO)
  .value("FMLALL_VG4_M4ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLALL_VG4_M4ZZI_BtoS_PSEUDO)
  .value("FMLALL_VG4_M4ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLALL_VG4_M4ZZ_BtoS_PSEUDO)
  .value("FMLAL_MZZI_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_MZZI_BtoH_PSEUDO)
  .value("FMLAL_MZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_MZZI_HtoS_PSEUDO)
  .value("FMLAL_MZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_MZZ_HtoS_PSEUDO)
  .value("FMLAL_VG2_M2Z2Z_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_VG2_M2Z2Z_BtoH_PSEUDO)
  .value("FMLAL_VG2_M2Z2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_VG2_M2Z2Z_HtoS_PSEUDO)
  .value("FMLAL_VG2_M2ZZI_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_VG2_M2ZZI_BtoH_PSEUDO)
  .value("FMLAL_VG2_M2ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_VG2_M2ZZI_HtoS_PSEUDO)
  .value("FMLAL_VG2_M2ZZ_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_VG2_M2ZZ_BtoH_PSEUDO)
  .value("FMLAL_VG2_M2ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_VG2_M2ZZ_HtoS_PSEUDO)
  .value("FMLAL_VG2_MZZ_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_VG2_MZZ_BtoH_PSEUDO)
  .value("FMLAL_VG4_M4Z4Z_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_VG4_M4Z4Z_BtoH_PSEUDO)
  .value("FMLAL_VG4_M4Z4Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_VG4_M4Z4Z_HtoS_PSEUDO)
  .value("FMLAL_VG4_M4ZZI_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_VG4_M4ZZI_BtoH_PSEUDO)
  .value("FMLAL_VG4_M4ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_VG4_M4ZZI_HtoS_PSEUDO)
  .value("FMLAL_VG4_M4ZZ_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_VG4_M4ZZ_BtoH_PSEUDO)
  .value("FMLAL_VG4_M4ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLAL_VG4_M4ZZ_HtoS_PSEUDO)
  .value("FMLA_VG2_M2Z2Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2Z2Z_D_PSEUDO)
  .value("FMLA_VG2_M2Z2Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2Z2Z_H_PSEUDO)
  .value("FMLA_VG2_M2Z2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2Z2Z_S_PSEUDO)
  .value("FMLA_VG2_M2ZZI_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2ZZI_D_PSEUDO)
  .value("FMLA_VG2_M2ZZI_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2ZZI_H_PSEUDO)
  .value("FMLA_VG2_M2ZZI_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2ZZI_S_PSEUDO)
  .value("FMLA_VG2_M2ZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2ZZ_D_PSEUDO)
  .value("FMLA_VG2_M2ZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2ZZ_H_PSEUDO)
  .value("FMLA_VG2_M2ZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2ZZ_S_PSEUDO)
  .value("FMLA_VG4_M4Z4Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4Z4Z_D_PSEUDO)
  .value("FMLA_VG4_M4Z4Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4Z4Z_H_PSEUDO)
  .value("FMLA_VG4_M4Z4Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4Z4Z_S_PSEUDO)
  .value("FMLA_VG4_M4ZZI_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4ZZI_D_PSEUDO)
  .value("FMLA_VG4_M4ZZI_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4ZZI_H_PSEUDO)
  .value("FMLA_VG4_M4ZZI_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4ZZI_S_PSEUDO)
  .value("FMLA_VG4_M4ZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4ZZ_D_PSEUDO)
  .value("FMLA_VG4_M4ZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4ZZ_H_PSEUDO)
  .value("FMLA_VG4_M4ZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4ZZ_S_PSEUDO)
  .value("FMLA_ZPZZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FMLA_ZPZZZ_D_UNDEF)
  .value("FMLA_ZPZZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FMLA_ZPZZZ_H_UNDEF)
  .value("FMLA_ZPZZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FMLA_ZPZZZ_S_UNDEF)
  .value("FMLSL_MZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLSL_MZZI_HtoS_PSEUDO)
  .value("FMLSL_MZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLSL_MZZ_HtoS_PSEUDO)
  .value("FMLSL_VG2_M2Z2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLSL_VG2_M2Z2Z_HtoS_PSEUDO)
  .value("FMLSL_VG2_M2ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLSL_VG2_M2ZZI_HtoS_PSEUDO)
  .value("FMLSL_VG2_M2ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLSL_VG2_M2ZZ_HtoS_PSEUDO)
  .value("FMLSL_VG4_M4Z4Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLSL_VG4_M4Z4Z_HtoS_PSEUDO)
  .value("FMLSL_VG4_M4ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLSL_VG4_M4ZZI_HtoS_PSEUDO)
  .value("FMLSL_VG4_M4ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLSL_VG4_M4ZZ_HtoS_PSEUDO)
  .value("FMLS_VG2_M2Z2Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2Z2Z_D_PSEUDO)
  .value("FMLS_VG2_M2Z2Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2Z2Z_H_PSEUDO)
  .value("FMLS_VG2_M2Z2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2Z2Z_S_PSEUDO)
  .value("FMLS_VG2_M2ZZI_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2ZZI_D_PSEUDO)
  .value("FMLS_VG2_M2ZZI_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2ZZI_H_PSEUDO)
  .value("FMLS_VG2_M2ZZI_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2ZZI_S_PSEUDO)
  .value("FMLS_VG2_M2ZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2ZZ_D_PSEUDO)
  .value("FMLS_VG2_M2ZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2ZZ_H_PSEUDO)
  .value("FMLS_VG2_M2ZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2ZZ_S_PSEUDO)
  .value("FMLS_VG4_M4Z4Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4Z4Z_D_PSEUDO)
  .value("FMLS_VG4_M4Z4Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4Z4Z_H_PSEUDO)
  .value("FMLS_VG4_M4Z4Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4Z4Z_S_PSEUDO)
  .value("FMLS_VG4_M4ZZI_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4ZZI_D_PSEUDO)
  .value("FMLS_VG4_M4ZZI_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4ZZI_H_PSEUDO)
  .value("FMLS_VG4_M4ZZI_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4ZZI_S_PSEUDO)
  .value("FMLS_VG4_M4ZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4ZZ_D_PSEUDO)
  .value("FMLS_VG4_M4ZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4ZZ_H_PSEUDO)
  .value("FMLS_VG4_M4ZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4ZZ_S_PSEUDO)
  .value("FMLS_ZPZZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FMLS_ZPZZZ_D_UNDEF)
  .value("FMLS_ZPZZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FMLS_ZPZZZ_H_UNDEF)
  .value("FMLS_ZPZZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FMLS_ZPZZZ_S_UNDEF)
  .value("FMOP4A_M2Z2Z_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2Z2Z_BtoH_PSEUDO)
  .value("FMOP4A_M2Z2Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2Z2Z_BtoS_PSEUDO)
  .value("FMOP4A_M2Z2Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2Z2Z_D_PSEUDO)
  .value("FMOP4A_M2Z2Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2Z2Z_H_PSEUDO)
  .value("FMOP4A_M2Z2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2Z2Z_HtoS_PSEUDO)
  .value("FMOP4A_M2Z2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2Z2Z_S_PSEUDO)
  .value("FMOP4A_M2ZZ_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2ZZ_BtoH_PSEUDO)
  .value("FMOP4A_M2ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2ZZ_BtoS_PSEUDO)
  .value("FMOP4A_M2ZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2ZZ_D_PSEUDO)
  .value("FMOP4A_M2ZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2ZZ_H_PSEUDO)
  .value("FMOP4A_M2ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2ZZ_HtoS_PSEUDO)
  .value("FMOP4A_M2ZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2ZZ_S_PSEUDO)
  .value("FMOP4A_MZ2Z_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZ2Z_BtoH_PSEUDO)
  .value("FMOP4A_MZ2Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZ2Z_BtoS_PSEUDO)
  .value("FMOP4A_MZ2Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZ2Z_D_PSEUDO)
  .value("FMOP4A_MZ2Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZ2Z_H_PSEUDO)
  .value("FMOP4A_MZ2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZ2Z_HtoS_PSEUDO)
  .value("FMOP4A_MZ2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZ2Z_S_PSEUDO)
  .value("FMOP4A_MZZ_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZZ_BtoH_PSEUDO)
  .value("FMOP4A_MZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZZ_BtoS_PSEUDO)
  .value("FMOP4A_MZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZZ_D_PSEUDO)
  .value("FMOP4A_MZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZZ_H_PSEUDO)
  .value("FMOP4A_MZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZZ_HtoS_PSEUDO)
  .value("FMOP4A_MZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZZ_S_PSEUDO)
  .value("FMOP4S_M2Z2Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2Z2Z_D_PSEUDO)
  .value("FMOP4S_M2Z2Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2Z2Z_H_PSEUDO)
  .value("FMOP4S_M2Z2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2Z2Z_HtoS_PSEUDO)
  .value("FMOP4S_M2Z2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2Z2Z_S_PSEUDO)
  .value("FMOP4S_M2ZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2ZZ_D_PSEUDO)
  .value("FMOP4S_M2ZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2ZZ_H_PSEUDO)
  .value("FMOP4S_M2ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2ZZ_HtoS_PSEUDO)
  .value("FMOP4S_M2ZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2ZZ_S_PSEUDO)
  .value("FMOP4S_MZ2Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZ2Z_D_PSEUDO)
  .value("FMOP4S_MZ2Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZ2Z_H_PSEUDO)
  .value("FMOP4S_MZ2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZ2Z_HtoS_PSEUDO)
  .value("FMOP4S_MZ2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZ2Z_S_PSEUDO)
  .value("FMOP4S_MZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZZ_D_PSEUDO)
  .value("FMOP4S_MZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZZ_H_PSEUDO)
  .value("FMOP4S_MZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZZ_HtoS_PSEUDO)
  .value("FMOP4S_MZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZZ_S_PSEUDO)
  .value("FMOPAL_MPPZZ_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOPAL_MPPZZ_PSEUDO)
  .value("FMOPA_MPPZZ_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOPA_MPPZZ_BtoH_PSEUDO)
  .value("FMOPA_MPPZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOPA_MPPZZ_BtoS_PSEUDO)
  .value("FMOPA_MPPZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOPA_MPPZZ_D_PSEUDO)
  .value("FMOPA_MPPZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOPA_MPPZZ_H_PSEUDO)
  .value("FMOPA_MPPZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOPA_MPPZZ_S_PSEUDO)
  .value("FMOPSL_MPPZZ_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOPSL_MPPZZ_PSEUDO)
  .value("FMOPS_MPPZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOPS_MPPZZ_D_PSEUDO)
  .value("FMOPS_MPPZZ_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOPS_MPPZZ_H_PSEUDO)
  .value("FMOPS_MPPZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FMOPS_MPPZZ_S_PSEUDO)
  .value("FMOVD0", LIEF::assembly::aarch64::OPCODE::FMOVD0)
  .value("FMOVH0", LIEF::assembly::aarch64::OPCODE::FMOVH0)
  .value("FMOVS0", LIEF::assembly::aarch64::OPCODE::FMOVS0)
  .value("FMULX_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FMULX_ZPZZ_D_UNDEF)
  .value("FMULX_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::FMULX_ZPZZ_D_ZERO)
  .value("FMULX_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FMULX_ZPZZ_H_UNDEF)
  .value("FMULX_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::FMULX_ZPZZ_H_ZERO)
  .value("FMULX_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FMULX_ZPZZ_S_UNDEF)
  .value("FMULX_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::FMULX_ZPZZ_S_ZERO)
  .value("FMUL_ZPZI_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FMUL_ZPZI_D_UNDEF)
  .value("FMUL_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::FMUL_ZPZI_D_ZERO)
  .value("FMUL_ZPZI_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FMUL_ZPZI_H_UNDEF)
  .value("FMUL_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::FMUL_ZPZI_H_ZERO)
  .value("FMUL_ZPZI_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FMUL_ZPZI_S_UNDEF)
  .value("FMUL_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::FMUL_ZPZI_S_ZERO)
  .value("FMUL_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FMUL_ZPZZ_D_UNDEF)
  .value("FMUL_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::FMUL_ZPZZ_D_ZERO)
  .value("FMUL_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FMUL_ZPZZ_H_UNDEF)
  .value("FMUL_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::FMUL_ZPZZ_H_ZERO)
  .value("FMUL_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FMUL_ZPZZ_S_UNDEF)
  .value("FMUL_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::FMUL_ZPZZ_S_ZERO)
  .value("FNEG_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FNEG_ZPmZ_D_UNDEF)
  .value("FNEG_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FNEG_ZPmZ_H_UNDEF)
  .value("FNEG_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FNEG_ZPmZ_S_UNDEF)
  .value("FNMLA_ZPZZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FNMLA_ZPZZZ_D_UNDEF)
  .value("FNMLA_ZPZZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FNMLA_ZPZZZ_H_UNDEF)
  .value("FNMLA_ZPZZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FNMLA_ZPZZZ_S_UNDEF)
  .value("FNMLS_ZPZZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FNMLS_ZPZZZ_D_UNDEF)
  .value("FNMLS_ZPZZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FNMLS_ZPZZZ_H_UNDEF)
  .value("FNMLS_ZPZZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FNMLS_ZPZZZ_S_UNDEF)
  .value("FORM_TRANSPOSED_REG_TUPLE_X2_PSEUDO", LIEF::assembly::aarch64::OPCODE::FORM_TRANSPOSED_REG_TUPLE_X2_PSEUDO)
  .value("FORM_TRANSPOSED_REG_TUPLE_X4_PSEUDO", LIEF::assembly::aarch64::OPCODE::FORM_TRANSPOSED_REG_TUPLE_X4_PSEUDO)
  .value("FRECPX_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FRECPX_ZPmZ_D_UNDEF)
  .value("FRECPX_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FRECPX_ZPmZ_H_UNDEF)
  .value("FRECPX_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FRECPX_ZPmZ_S_UNDEF)
  .value("FRINTA_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTA_ZPmZ_D_UNDEF)
  .value("FRINTA_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTA_ZPmZ_H_UNDEF)
  .value("FRINTA_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTA_ZPmZ_S_UNDEF)
  .value("FRINTI_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTI_ZPmZ_D_UNDEF)
  .value("FRINTI_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTI_ZPmZ_H_UNDEF)
  .value("FRINTI_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTI_ZPmZ_S_UNDEF)
  .value("FRINTM_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTM_ZPmZ_D_UNDEF)
  .value("FRINTM_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTM_ZPmZ_H_UNDEF)
  .value("FRINTM_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTM_ZPmZ_S_UNDEF)
  .value("FRINTN_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTN_ZPmZ_D_UNDEF)
  .value("FRINTN_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTN_ZPmZ_H_UNDEF)
  .value("FRINTN_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTN_ZPmZ_S_UNDEF)
  .value("FRINTP_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTP_ZPmZ_D_UNDEF)
  .value("FRINTP_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTP_ZPmZ_H_UNDEF)
  .value("FRINTP_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTP_ZPmZ_S_UNDEF)
  .value("FRINTX_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTX_ZPmZ_D_UNDEF)
  .value("FRINTX_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTX_ZPmZ_H_UNDEF)
  .value("FRINTX_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTX_ZPmZ_S_UNDEF)
  .value("FRINTZ_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTZ_ZPmZ_D_UNDEF)
  .value("FRINTZ_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTZ_ZPmZ_H_UNDEF)
  .value("FRINTZ_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FRINTZ_ZPmZ_S_UNDEF)
  .value("FSQRT_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FSQRT_ZPmZ_D_UNDEF)
  .value("FSQRT_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FSQRT_ZPmZ_H_UNDEF)
  .value("FSQRT_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FSQRT_ZPmZ_S_UNDEF)
  .value("FSUBR_ZPZI_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPZI_D_UNDEF)
  .value("FSUBR_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPZI_D_ZERO)
  .value("FSUBR_ZPZI_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPZI_H_UNDEF)
  .value("FSUBR_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPZI_H_ZERO)
  .value("FSUBR_ZPZI_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPZI_S_UNDEF)
  .value("FSUBR_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPZI_S_ZERO)
  .value("FSUBR_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPZZ_D_ZERO)
  .value("FSUBR_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPZZ_H_ZERO)
  .value("FSUBR_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPZZ_S_ZERO)
  .value("FSUB_VG2_M2Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FSUB_VG2_M2Z_D_PSEUDO)
  .value("FSUB_VG2_M2Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FSUB_VG2_M2Z_H_PSEUDO)
  .value("FSUB_VG2_M2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FSUB_VG2_M2Z_S_PSEUDO)
  .value("FSUB_VG4_M4Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::FSUB_VG4_M4Z_D_PSEUDO)
  .value("FSUB_VG4_M4Z_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::FSUB_VG4_M4Z_H_PSEUDO)
  .value("FSUB_VG4_M4Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::FSUB_VG4_M4Z_S_PSEUDO)
  .value("FSUB_ZPZI_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FSUB_ZPZI_D_UNDEF)
  .value("FSUB_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::FSUB_ZPZI_D_ZERO)
  .value("FSUB_ZPZI_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FSUB_ZPZI_H_UNDEF)
  .value("FSUB_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::FSUB_ZPZI_H_ZERO)
  .value("FSUB_ZPZI_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FSUB_ZPZI_S_UNDEF)
  .value("FSUB_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::FSUB_ZPZI_S_ZERO)
  .value("FSUB_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::FSUB_ZPZZ_D_UNDEF)
  .value("FSUB_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::FSUB_ZPZZ_D_ZERO)
  .value("FSUB_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::FSUB_ZPZZ_H_UNDEF)
  .value("FSUB_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::FSUB_ZPZZ_H_ZERO)
  .value("FSUB_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::FSUB_ZPZZ_S_UNDEF)
  .value("FSUB_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::FSUB_ZPZZ_S_ZERO)
  .value("FTMOPA_M2ZZZI_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FTMOPA_M2ZZZI_BtoH_PSEUDO)
  .value("FTMOPA_M2ZZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FTMOPA_M2ZZZI_BtoS_PSEUDO)
  .value("FTMOPA_M2ZZZI_HtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FTMOPA_M2ZZZI_HtoH_PSEUDO)
  .value("FTMOPA_M2ZZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FTMOPA_M2ZZZI_HtoS_PSEUDO)
  .value("FTMOPA_M2ZZZI_StoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FTMOPA_M2ZZZI_StoS_PSEUDO)
  .value("FVDOTB_VG4_M2ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FVDOTB_VG4_M2ZZI_BtoS_PSEUDO)
  .value("FVDOTT_VG4_M2ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FVDOTT_VG4_M2ZZI_BtoS_PSEUDO)
  .value("FVDOT_VG2_M2ZZI_BtoH_PSEUDO", LIEF::assembly::aarch64::OPCODE::FVDOT_VG2_M2ZZI_BtoH_PSEUDO)
  .value("FVDOT_VG2_M2ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::FVDOT_VG2_M2ZZI_HtoS_PSEUDO)
  .value("G_AARCH64_PREFETCH", LIEF::assembly::aarch64::OPCODE::G_AARCH64_PREFETCH)
  .value("G_ADD_LOW", LIEF::assembly::aarch64::OPCODE::G_ADD_LOW)
  .value("G_BSP", LIEF::assembly::aarch64::OPCODE::G_BSP)
  .value("G_DUP", LIEF::assembly::aarch64::OPCODE::G_DUP)
  .value("G_DUPLANE16", LIEF::assembly::aarch64::OPCODE::G_DUPLANE16)
  .value("G_DUPLANE32", LIEF::assembly::aarch64::OPCODE::G_DUPLANE32)
  .value("G_DUPLANE64", LIEF::assembly::aarch64::OPCODE::G_DUPLANE64)
  .value("G_DUPLANE8", LIEF::assembly::aarch64::OPCODE::G_DUPLANE8)
  .value("G_EXT", LIEF::assembly::aarch64::OPCODE::G_EXT)
  .value("G_FCMEQ", LIEF::assembly::aarch64::OPCODE::G_FCMEQ)
  .value("G_FCMGE", LIEF::assembly::aarch64::OPCODE::G_FCMGE)
  .value("G_FCMGT", LIEF::assembly::aarch64::OPCODE::G_FCMGT)
  .value("G_REV16", LIEF::assembly::aarch64::OPCODE::G_REV16)
  .value("G_REV32", LIEF::assembly::aarch64::OPCODE::G_REV32)
  .value("G_REV64", LIEF::assembly::aarch64::OPCODE::G_REV64)
  .value("G_SADDLP", LIEF::assembly::aarch64::OPCODE::G_SADDLP)
  .value("G_SADDLV", LIEF::assembly::aarch64::OPCODE::G_SADDLV)
  .value("G_SDOT", LIEF::assembly::aarch64::OPCODE::G_SDOT)
  .value("G_SITOF", LIEF::assembly::aarch64::OPCODE::G_SITOF)
  .value("G_SMULL", LIEF::assembly::aarch64::OPCODE::G_SMULL)
  .value("G_TRN1", LIEF::assembly::aarch64::OPCODE::G_TRN1)
  .value("G_TRN2", LIEF::assembly::aarch64::OPCODE::G_TRN2)
  .value("G_UADDLP", LIEF::assembly::aarch64::OPCODE::G_UADDLP)
  .value("G_UADDLV", LIEF::assembly::aarch64::OPCODE::G_UADDLV)
  .value("G_UDOT", LIEF::assembly::aarch64::OPCODE::G_UDOT);
  opcodes.value("G_UITOF", LIEF::assembly::aarch64::OPCODE::G_UITOF)
  .value("G_UMULL", LIEF::assembly::aarch64::OPCODE::G_UMULL)
  .value("G_UZP1", LIEF::assembly::aarch64::OPCODE::G_UZP1)
  .value("G_UZP2", LIEF::assembly::aarch64::OPCODE::G_UZP2)
  .value("G_VASHR", LIEF::assembly::aarch64::OPCODE::G_VASHR)
  .value("G_VLSHR", LIEF::assembly::aarch64::OPCODE::G_VLSHR)
  .value("G_ZIP1", LIEF::assembly::aarch64::OPCODE::G_ZIP1)
  .value("G_ZIP2", LIEF::assembly::aarch64::OPCODE::G_ZIP2)
  .value("GetSMESaveSize", LIEF::assembly::aarch64::OPCODE::GetSMESaveSize)
  .value("HOM_Epilog", LIEF::assembly::aarch64::OPCODE::HOM_Epilog)
  .value("HOM_Prolog", LIEF::assembly::aarch64::OPCODE::HOM_Prolog)
  .value("HWASAN_CHECK_MEMACCESS", LIEF::assembly::aarch64::OPCODE::HWASAN_CHECK_MEMACCESS)
  .value("HWASAN_CHECK_MEMACCESS_FIXEDSHADOW", LIEF::assembly::aarch64::OPCODE::HWASAN_CHECK_MEMACCESS_FIXEDSHADOW)
  .value("HWASAN_CHECK_MEMACCESS_SHORTGRANULES", LIEF::assembly::aarch64::OPCODE::HWASAN_CHECK_MEMACCESS_SHORTGRANULES)
  .value("HWASAN_CHECK_MEMACCESS_SHORTGRANULES_FIXEDSHADOW", LIEF::assembly::aarch64::OPCODE::HWASAN_CHECK_MEMACCESS_SHORTGRANULES_FIXEDSHADOW)
  .value("INSERT_MXIPZ_H_PSEUDO_B", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_H_PSEUDO_B)
  .value("INSERT_MXIPZ_H_PSEUDO_D", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_H_PSEUDO_D)
  .value("INSERT_MXIPZ_H_PSEUDO_H", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_H_PSEUDO_H)
  .value("INSERT_MXIPZ_H_PSEUDO_Q", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_H_PSEUDO_Q)
  .value("INSERT_MXIPZ_H_PSEUDO_S", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_H_PSEUDO_S)
  .value("INSERT_MXIPZ_V_PSEUDO_B", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_V_PSEUDO_B)
  .value("INSERT_MXIPZ_V_PSEUDO_D", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_V_PSEUDO_D)
  .value("INSERT_MXIPZ_V_PSEUDO_H", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_V_PSEUDO_H)
  .value("INSERT_MXIPZ_V_PSEUDO_Q", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_V_PSEUDO_Q)
  .value("INSERT_MXIPZ_V_PSEUDO_S", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_V_PSEUDO_S)
  .value("IRGstack", LIEF::assembly::aarch64::OPCODE::IRGstack)
  .value("InitTPIDR2Obj", LIEF::assembly::aarch64::OPCODE::InitTPIDR2Obj)
  .value("JumpTableDest16", LIEF::assembly::aarch64::OPCODE::JumpTableDest16)
  .value("JumpTableDest32", LIEF::assembly::aarch64::OPCODE::JumpTableDest32)
  .value("JumpTableDest8", LIEF::assembly::aarch64::OPCODE::JumpTableDest8)
  .value("KCFI_CHECK", LIEF::assembly::aarch64::OPCODE::KCFI_CHECK)
  .value("LD1B_2Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1B_2Z_IMM_PSEUDO)
  .value("LD1B_2Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1B_2Z_PSEUDO)
  .value("LD1B_4Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1B_4Z_IMM_PSEUDO)
  .value("LD1B_4Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1B_4Z_PSEUDO)
  .value("LD1D_2Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1D_2Z_IMM_PSEUDO)
  .value("LD1D_2Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1D_2Z_PSEUDO)
  .value("LD1D_4Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1D_4Z_IMM_PSEUDO)
  .value("LD1D_4Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1D_4Z_PSEUDO)
  .value("LD1H_2Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1H_2Z_IMM_PSEUDO)
  .value("LD1H_2Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1H_2Z_PSEUDO)
  .value("LD1H_4Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1H_4Z_IMM_PSEUDO)
  .value("LD1H_4Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1H_4Z_PSEUDO)
  .value("LD1W_2Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1W_2Z_IMM_PSEUDO)
  .value("LD1W_2Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1W_2Z_PSEUDO)
  .value("LD1W_4Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1W_4Z_IMM_PSEUDO)
  .value("LD1W_4Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LD1W_4Z_PSEUDO)
  .value("LD1_MXIPXX_H_PSEUDO_B", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_H_PSEUDO_B)
  .value("LD1_MXIPXX_H_PSEUDO_D", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_H_PSEUDO_D)
  .value("LD1_MXIPXX_H_PSEUDO_H", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_H_PSEUDO_H)
  .value("LD1_MXIPXX_H_PSEUDO_Q", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_H_PSEUDO_Q)
  .value("LD1_MXIPXX_H_PSEUDO_S", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_H_PSEUDO_S)
  .value("LD1_MXIPXX_V_PSEUDO_B", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_V_PSEUDO_B)
  .value("LD1_MXIPXX_V_PSEUDO_D", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_V_PSEUDO_D)
  .value("LD1_MXIPXX_V_PSEUDO_H", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_V_PSEUDO_H)
  .value("LD1_MXIPXX_V_PSEUDO_Q", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_V_PSEUDO_Q)
  .value("LD1_MXIPXX_V_PSEUDO_S", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_V_PSEUDO_S)
  .value("LDNT1B_2Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1B_2Z_IMM_PSEUDO)
  .value("LDNT1B_2Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1B_2Z_PSEUDO)
  .value("LDNT1B_4Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1B_4Z_IMM_PSEUDO)
  .value("LDNT1B_4Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1B_4Z_PSEUDO)
  .value("LDNT1D_2Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1D_2Z_IMM_PSEUDO)
  .value("LDNT1D_2Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1D_2Z_PSEUDO)
  .value("LDNT1D_4Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1D_4Z_IMM_PSEUDO)
  .value("LDNT1D_4Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1D_4Z_PSEUDO)
  .value("LDNT1H_2Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1H_2Z_IMM_PSEUDO)
  .value("LDNT1H_2Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1H_2Z_PSEUDO)
  .value("LDNT1H_4Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1H_4Z_IMM_PSEUDO)
  .value("LDNT1H_4Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1H_4Z_PSEUDO)
  .value("LDNT1W_2Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1W_2Z_IMM_PSEUDO)
  .value("LDNT1W_2Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1W_2Z_PSEUDO)
  .value("LDNT1W_4Z_IMM_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1W_4Z_IMM_PSEUDO)
  .value("LDNT1W_4Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDNT1W_4Z_PSEUDO)
  .value("LDR_PPXI", LIEF::assembly::aarch64::OPCODE::LDR_PPXI)
  .value("LDR_TX_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDR_TX_PSEUDO)
  .value("LDR_ZA_PSEUDO", LIEF::assembly::aarch64::OPCODE::LDR_ZA_PSEUDO)
  .value("LDR_ZZXI", LIEF::assembly::aarch64::OPCODE::LDR_ZZXI)
  .value("LDR_ZZXI_STRIDED_CONTIGUOUS", LIEF::assembly::aarch64::OPCODE::LDR_ZZXI_STRIDED_CONTIGUOUS)
  .value("LDR_ZZZXI", LIEF::assembly::aarch64::OPCODE::LDR_ZZZXI)
  .value("LDR_ZZZZXI", LIEF::assembly::aarch64::OPCODE::LDR_ZZZZXI)
  .value("LDR_ZZZZXI_STRIDED_CONTIGUOUS", LIEF::assembly::aarch64::OPCODE::LDR_ZZZZXI_STRIDED_CONTIGUOUS)
  .value("LOADauthptrstatic", LIEF::assembly::aarch64::OPCODE::LOADauthptrstatic)
  .value("LOADgot", LIEF::assembly::aarch64::OPCODE::LOADgot)
  .value("LOADgotAUTH", LIEF::assembly::aarch64::OPCODE::LOADgotAUTH)
  .value("LOADgotPAC", LIEF::assembly::aarch64::OPCODE::LOADgotPAC)
  .value("LSL_ZPZI_B_UNDEF", LIEF::assembly::aarch64::OPCODE::LSL_ZPZI_B_UNDEF)
  .value("LSL_ZPZI_B_ZERO", LIEF::assembly::aarch64::OPCODE::LSL_ZPZI_B_ZERO)
  .value("LSL_ZPZI_D_UNDEF", LIEF::assembly::aarch64::OPCODE::LSL_ZPZI_D_UNDEF)
  .value("LSL_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::LSL_ZPZI_D_ZERO)
  .value("LSL_ZPZI_H_UNDEF", LIEF::assembly::aarch64::OPCODE::LSL_ZPZI_H_UNDEF)
  .value("LSL_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::LSL_ZPZI_H_ZERO)
  .value("LSL_ZPZI_S_UNDEF", LIEF::assembly::aarch64::OPCODE::LSL_ZPZI_S_UNDEF)
  .value("LSL_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::LSL_ZPZI_S_ZERO)
  .value("LSL_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::LSL_ZPZZ_B_UNDEF)
  .value("LSL_ZPZZ_B_ZERO", LIEF::assembly::aarch64::OPCODE::LSL_ZPZZ_B_ZERO)
  .value("LSL_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::LSL_ZPZZ_D_UNDEF)
  .value("LSL_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::LSL_ZPZZ_D_ZERO)
  .value("LSL_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::LSL_ZPZZ_H_UNDEF)
  .value("LSL_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::LSL_ZPZZ_H_ZERO)
  .value("LSL_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::LSL_ZPZZ_S_UNDEF)
  .value("LSL_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::LSL_ZPZZ_S_ZERO)
  .value("LSR_ZPZI_B_UNDEF", LIEF::assembly::aarch64::OPCODE::LSR_ZPZI_B_UNDEF)
  .value("LSR_ZPZI_B_ZERO", LIEF::assembly::aarch64::OPCODE::LSR_ZPZI_B_ZERO)
  .value("LSR_ZPZI_D_UNDEF", LIEF::assembly::aarch64::OPCODE::LSR_ZPZI_D_UNDEF)
  .value("LSR_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::LSR_ZPZI_D_ZERO)
  .value("LSR_ZPZI_H_UNDEF", LIEF::assembly::aarch64::OPCODE::LSR_ZPZI_H_UNDEF)
  .value("LSR_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::LSR_ZPZI_H_ZERO)
  .value("LSR_ZPZI_S_UNDEF", LIEF::assembly::aarch64::OPCODE::LSR_ZPZI_S_UNDEF)
  .value("LSR_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::LSR_ZPZI_S_ZERO)
  .value("LSR_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::LSR_ZPZZ_B_UNDEF)
  .value("LSR_ZPZZ_B_ZERO", LIEF::assembly::aarch64::OPCODE::LSR_ZPZZ_B_ZERO)
  .value("LSR_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::LSR_ZPZZ_D_UNDEF)
  .value("LSR_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::LSR_ZPZZ_D_ZERO)
  .value("LSR_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::LSR_ZPZZ_H_UNDEF)
  .value("LSR_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::LSR_ZPZZ_H_ZERO)
  .value("LSR_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::LSR_ZPZZ_S_UNDEF)
  .value("LSR_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::LSR_ZPZZ_S_ZERO)
  .value("MLA_ZPZZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::MLA_ZPZZZ_B_UNDEF)
  .value("MLA_ZPZZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::MLA_ZPZZZ_D_UNDEF)
  .value("MLA_ZPZZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::MLA_ZPZZZ_H_UNDEF)
  .value("MLA_ZPZZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::MLA_ZPZZZ_S_UNDEF)
  .value("MLS_ZPZZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::MLS_ZPZZZ_B_UNDEF)
  .value("MLS_ZPZZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::MLS_ZPZZZ_D_UNDEF)
  .value("MLS_ZPZZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::MLS_ZPZZZ_H_UNDEF)
  .value("MLS_ZPZZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::MLS_ZPZZZ_S_UNDEF)
  .value("MOPSMemoryCopyPseudo", LIEF::assembly::aarch64::OPCODE::MOPSMemoryCopyPseudo)
  .value("MOPSMemoryMovePseudo", LIEF::assembly::aarch64::OPCODE::MOPSMemoryMovePseudo)
  .value("MOPSMemorySetPseudo", LIEF::assembly::aarch64::OPCODE::MOPSMemorySetPseudo)
  .value("MOPSMemorySetTaggingPseudo", LIEF::assembly::aarch64::OPCODE::MOPSMemorySetTaggingPseudo)
  .value("MOVAZ_2ZMI_H_B_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_H_B_PSEUDO)
  .value("MOVAZ_2ZMI_H_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_H_D_PSEUDO)
  .value("MOVAZ_2ZMI_H_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_H_H_PSEUDO)
  .value("MOVAZ_2ZMI_H_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_H_S_PSEUDO)
  .value("MOVAZ_2ZMI_V_B_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_V_B_PSEUDO)
  .value("MOVAZ_2ZMI_V_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_V_D_PSEUDO)
  .value("MOVAZ_2ZMI_V_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_V_H_PSEUDO)
  .value("MOVAZ_2ZMI_V_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_V_S_PSEUDO)
  .value("MOVAZ_4ZMI_H_B_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_H_B_PSEUDO)
  .value("MOVAZ_4ZMI_H_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_H_D_PSEUDO)
  .value("MOVAZ_4ZMI_H_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_H_H_PSEUDO)
  .value("MOVAZ_4ZMI_H_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_H_S_PSEUDO)
  .value("MOVAZ_4ZMI_V_B_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_V_B_PSEUDO)
  .value("MOVAZ_4ZMI_V_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_V_D_PSEUDO)
  .value("MOVAZ_4ZMI_V_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_V_H_PSEUDO)
  .value("MOVAZ_4ZMI_V_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_V_S_PSEUDO)
  .value("MOVAZ_VG2_2ZMXI_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_VG2_2ZMXI_PSEUDO)
  .value("MOVAZ_VG4_4ZMXI_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_VG4_4ZMXI_PSEUDO)
  .value("MOVAZ_ZMI_H_B_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_H_B_PSEUDO)
  .value("MOVAZ_ZMI_H_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_H_D_PSEUDO)
  .value("MOVAZ_ZMI_H_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_H_H_PSEUDO)
  .value("MOVAZ_ZMI_H_Q_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_H_Q_PSEUDO)
  .value("MOVAZ_ZMI_H_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_H_S_PSEUDO)
  .value("MOVAZ_ZMI_V_B_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_V_B_PSEUDO)
  .value("MOVAZ_ZMI_V_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_V_D_PSEUDO)
  .value("MOVAZ_ZMI_V_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_V_H_PSEUDO)
  .value("MOVAZ_ZMI_V_Q_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_V_Q_PSEUDO)
  .value("MOVAZ_ZMI_V_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_V_S_PSEUDO)
  .value("MOVA_MXI2Z_H_B_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_H_B_PSEUDO)
  .value("MOVA_MXI2Z_H_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_H_D_PSEUDO)
  .value("MOVA_MXI2Z_H_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_H_H_PSEUDO)
  .value("MOVA_MXI2Z_H_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_H_S_PSEUDO)
  .value("MOVA_MXI2Z_V_B_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_V_B_PSEUDO)
  .value("MOVA_MXI2Z_V_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_V_D_PSEUDO)
  .value("MOVA_MXI2Z_V_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_V_H_PSEUDO)
  .value("MOVA_MXI2Z_V_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_V_S_PSEUDO)
  .value("MOVA_MXI4Z_H_B_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_H_B_PSEUDO)
  .value("MOVA_MXI4Z_H_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_H_D_PSEUDO)
  .value("MOVA_MXI4Z_H_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_H_H_PSEUDO)
  .value("MOVA_MXI4Z_H_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_H_S_PSEUDO)
  .value("MOVA_MXI4Z_V_B_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_V_B_PSEUDO)
  .value("MOVA_MXI4Z_V_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_V_D_PSEUDO)
  .value("MOVA_MXI4Z_V_H_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_V_H_PSEUDO)
  .value("MOVA_MXI4Z_V_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_V_S_PSEUDO)
  .value("MOVA_VG2_MXI2Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_VG2_MXI2Z_PSEUDO)
  .value("MOVA_VG4_MXI4Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVA_VG4_MXI4Z_PSEUDO)
  .value("MOVMCSym", LIEF::assembly::aarch64::OPCODE::MOVMCSym)
  .value("MOVT_TIZ_PSEUDO", LIEF::assembly::aarch64::OPCODE::MOVT_TIZ_PSEUDO)
  .value("MOVaddr", LIEF::assembly::aarch64::OPCODE::MOVaddr)
  .value("MOVaddrBA", LIEF::assembly::aarch64::OPCODE::MOVaddrBA)
  .value("MOVaddrCP", LIEF::assembly::aarch64::OPCODE::MOVaddrCP)
  .value("MOVaddrEXT", LIEF::assembly::aarch64::OPCODE::MOVaddrEXT)
  .value("MOVaddrJT", LIEF::assembly::aarch64::OPCODE::MOVaddrJT)
  .value("MOVaddrPAC", LIEF::assembly::aarch64::OPCODE::MOVaddrPAC)
  .value("MOVaddrTLS", LIEF::assembly::aarch64::OPCODE::MOVaddrTLS)
  .value("MOVbaseTLS", LIEF::assembly::aarch64::OPCODE::MOVbaseTLS)
  .value("MOVi32imm", LIEF::assembly::aarch64::OPCODE::MOVi32imm)
  .value("MOVi64imm", LIEF::assembly::aarch64::OPCODE::MOVi64imm)
  .value("MRS_FPCR", LIEF::assembly::aarch64::OPCODE::MRS_FPCR)
  .value("MRS_FPSR", LIEF::assembly::aarch64::OPCODE::MRS_FPSR)
  .value("MSR_FPCR", LIEF::assembly::aarch64::OPCODE::MSR_FPCR)
  .value("MSR_FPMR", LIEF::assembly::aarch64::OPCODE::MSR_FPMR)
  .value("MSR_FPSR", LIEF::assembly::aarch64::OPCODE::MSR_FPSR)
  .value("MSRpstatePseudo", LIEF::assembly::aarch64::OPCODE::MSRpstatePseudo)
  .value("MUL_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::MUL_ZPZZ_B_UNDEF)
  .value("MUL_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::MUL_ZPZZ_D_UNDEF)
  .value("MUL_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::MUL_ZPZZ_H_UNDEF)
  .value("MUL_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::MUL_ZPZZ_S_UNDEF)
  .value("NEG_ZPmZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::NEG_ZPmZ_B_UNDEF)
  .value("NEG_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::NEG_ZPmZ_D_UNDEF)
  .value("NEG_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::NEG_ZPmZ_H_UNDEF)
  .value("NEG_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::NEG_ZPmZ_S_UNDEF)
  .value("NOT_ZPmZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::NOT_ZPmZ_B_UNDEF)
  .value("NOT_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::NOT_ZPmZ_D_UNDEF)
  .value("NOT_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::NOT_ZPmZ_H_UNDEF)
  .value("NOT_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::NOT_ZPmZ_S_UNDEF)
  .value("ORNWrr", LIEF::assembly::aarch64::OPCODE::ORNWrr)
  .value("ORNXrr", LIEF::assembly::aarch64::OPCODE::ORNXrr)
  .value("ORRWrr", LIEF::assembly::aarch64::OPCODE::ORRWrr)
  .value("ORRXrr", LIEF::assembly::aarch64::OPCODE::ORRXrr)
  .value("ORR_ZPZZ_B_ZERO", LIEF::assembly::aarch64::OPCODE::ORR_ZPZZ_B_ZERO)
  .value("ORR_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::ORR_ZPZZ_D_ZERO)
  .value("ORR_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::ORR_ZPZZ_H_ZERO)
  .value("ORR_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::ORR_ZPZZ_S_ZERO)
  .value("PAUTH_EPILOGUE", LIEF::assembly::aarch64::OPCODE::PAUTH_EPILOGUE)
  .value("PAUTH_PROLOGUE", LIEF::assembly::aarch64::OPCODE::PAUTH_PROLOGUE)
  .value("PROBED_STACKALLOC", LIEF::assembly::aarch64::OPCODE::PROBED_STACKALLOC)
  .value("PROBED_STACKALLOC_DYN", LIEF::assembly::aarch64::OPCODE::PROBED_STACKALLOC_DYN)
  .value("PROBED_STACKALLOC_VAR", LIEF::assembly::aarch64::OPCODE::PROBED_STACKALLOC_VAR)
  .value("PTEST_PP_ANY", LIEF::assembly::aarch64::OPCODE::PTEST_PP_ANY)
  .value("RET_ReallyLR", LIEF::assembly::aarch64::OPCODE::RET_ReallyLR)
  .value("RestoreZAPseudo", LIEF::assembly::aarch64::OPCODE::RestoreZAPseudo)
  .value("SABD_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::SABD_ZPZZ_B_UNDEF)
  .value("SABD_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::SABD_ZPZZ_D_UNDEF)
  .value("SABD_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::SABD_ZPZZ_H_UNDEF)
  .value("SABD_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::SABD_ZPZZ_S_UNDEF)
  .value("SCVTF_ZPmZ_DtoD_UNDEF", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPmZ_DtoD_UNDEF)
  .value("SCVTF_ZPmZ_DtoH_UNDEF", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPmZ_DtoH_UNDEF)
  .value("SCVTF_ZPmZ_DtoS_UNDEF", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPmZ_DtoS_UNDEF)
  .value("SCVTF_ZPmZ_HtoH_UNDEF", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPmZ_HtoH_UNDEF)
  .value("SCVTF_ZPmZ_StoD_UNDEF", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPmZ_StoD_UNDEF)
  .value("SCVTF_ZPmZ_StoH_UNDEF", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPmZ_StoH_UNDEF)
  .value("SCVTF_ZPmZ_StoS_UNDEF", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPmZ_StoS_UNDEF)
  .value("SDIV_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::SDIV_ZPZZ_D_UNDEF)
  .value("SDIV_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::SDIV_ZPZZ_S_UNDEF)
  .value("SDOT_VG2_M2Z2Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2Z2Z_BtoS_PSEUDO)
  .value("SDOT_VG2_M2Z2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2Z2Z_HtoD_PSEUDO)
  .value("SDOT_VG2_M2Z2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2Z2Z_HtoS_PSEUDO)
  .value("SDOT_VG2_M2ZZI_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2ZZI_BToS_PSEUDO)
  .value("SDOT_VG2_M2ZZI_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2ZZI_HToS_PSEUDO)
  .value("SDOT_VG2_M2ZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2ZZI_HtoD_PSEUDO)
  .value("SDOT_VG2_M2ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2ZZ_BtoS_PSEUDO)
  .value("SDOT_VG2_M2ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2ZZ_HtoD_PSEUDO)
  .value("SDOT_VG2_M2ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2ZZ_HtoS_PSEUDO)
  .value("SDOT_VG4_M4Z4Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4Z4Z_BtoS_PSEUDO)
  .value("SDOT_VG4_M4Z4Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4Z4Z_HtoD_PSEUDO)
  .value("SDOT_VG4_M4Z4Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4Z4Z_HtoS_PSEUDO)
  .value("SDOT_VG4_M4ZZI_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4ZZI_BToS_PSEUDO)
  .value("SDOT_VG4_M4ZZI_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4ZZI_HToS_PSEUDO)
  .value("SDOT_VG4_M4ZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4ZZI_HtoD_PSEUDO)
  .value("SDOT_VG4_M4ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4ZZ_BtoS_PSEUDO)
  .value("SDOT_VG4_M4ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4ZZ_HtoD_PSEUDO)
  .value("SDOT_VG4_M4ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4ZZ_HtoS_PSEUDO)
  .value("SEH_AddFP", LIEF::assembly::aarch64::OPCODE::SEH_AddFP)
  .value("SEH_AllocZ", LIEF::assembly::aarch64::OPCODE::SEH_AllocZ)
  .value("SEH_EpilogEnd", LIEF::assembly::aarch64::OPCODE::SEH_EpilogEnd)
  .value("SEH_EpilogStart", LIEF::assembly::aarch64::OPCODE::SEH_EpilogStart)
  .value("SEH_Nop", LIEF::assembly::aarch64::OPCODE::SEH_Nop)
  .value("SEH_PACSignLR", LIEF::assembly::aarch64::OPCODE::SEH_PACSignLR)
  .value("SEH_PrologEnd", LIEF::assembly::aarch64::OPCODE::SEH_PrologEnd)
  .value("SEH_SaveAnyRegQP", LIEF::assembly::aarch64::OPCODE::SEH_SaveAnyRegQP)
  .value("SEH_SaveAnyRegQPX", LIEF::assembly::aarch64::OPCODE::SEH_SaveAnyRegQPX)
  .value("SEH_SaveFPLR", LIEF::assembly::aarch64::OPCODE::SEH_SaveFPLR)
  .value("SEH_SaveFPLR_X", LIEF::assembly::aarch64::OPCODE::SEH_SaveFPLR_X)
  .value("SEH_SaveFReg", LIEF::assembly::aarch64::OPCODE::SEH_SaveFReg)
  .value("SEH_SaveFRegP", LIEF::assembly::aarch64::OPCODE::SEH_SaveFRegP)
  .value("SEH_SaveFRegP_X", LIEF::assembly::aarch64::OPCODE::SEH_SaveFRegP_X)
  .value("SEH_SaveFReg_X", LIEF::assembly::aarch64::OPCODE::SEH_SaveFReg_X)
  .value("SEH_SavePReg", LIEF::assembly::aarch64::OPCODE::SEH_SavePReg)
  .value("SEH_SaveReg", LIEF::assembly::aarch64::OPCODE::SEH_SaveReg)
  .value("SEH_SaveRegP", LIEF::assembly::aarch64::OPCODE::SEH_SaveRegP)
  .value("SEH_SaveRegP_X", LIEF::assembly::aarch64::OPCODE::SEH_SaveRegP_X)
  .value("SEH_SaveReg_X", LIEF::assembly::aarch64::OPCODE::SEH_SaveReg_X)
  .value("SEH_SaveZReg", LIEF::assembly::aarch64::OPCODE::SEH_SaveZReg)
  .value("SEH_SetFP", LIEF::assembly::aarch64::OPCODE::SEH_SetFP)
  .value("SEH_StackAlloc", LIEF::assembly::aarch64::OPCODE::SEH_StackAlloc)
  .value("SMAX_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::SMAX_ZPZZ_B_UNDEF)
  .value("SMAX_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::SMAX_ZPZZ_D_UNDEF)
  .value("SMAX_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::SMAX_ZPZZ_H_UNDEF)
  .value("SMAX_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::SMAX_ZPZZ_S_UNDEF)
  .value("SMIN_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::SMIN_ZPZZ_B_UNDEF)
  .value("SMIN_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::SMIN_ZPZZ_D_UNDEF)
  .value("SMIN_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::SMIN_ZPZZ_H_UNDEF)
  .value("SMIN_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::SMIN_ZPZZ_S_UNDEF)
  .value("SMLALL_MZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_MZZI_BtoS_PSEUDO)
  .value("SMLALL_MZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_MZZI_HtoD_PSEUDO)
  .value("SMLALL_MZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_MZZ_BtoS_PSEUDO)
  .value("SMLALL_MZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_MZZ_HtoD_PSEUDO)
  .value("SMLALL_VG2_M2Z2Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_VG2_M2Z2Z_BtoS_PSEUDO)
  .value("SMLALL_VG2_M2Z2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_VG2_M2Z2Z_HtoD_PSEUDO)
  .value("SMLALL_VG2_M2ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_VG2_M2ZZI_BtoS_PSEUDO)
  .value("SMLALL_VG2_M2ZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_VG2_M2ZZI_HtoD_PSEUDO)
  .value("SMLALL_VG2_M2ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_VG2_M2ZZ_BtoS_PSEUDO)
  .value("SMLALL_VG2_M2ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_VG2_M2ZZ_HtoD_PSEUDO)
  .value("SMLALL_VG4_M4Z4Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_VG4_M4Z4Z_BtoS_PSEUDO)
  .value("SMLALL_VG4_M4Z4Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_VG4_M4Z4Z_HtoD_PSEUDO)
  .value("SMLALL_VG4_M4ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_VG4_M4ZZI_BtoS_PSEUDO)
  .value("SMLALL_VG4_M4ZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_VG4_M4ZZI_HtoD_PSEUDO)
  .value("SMLALL_VG4_M4ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_VG4_M4ZZ_BtoS_PSEUDO)
  .value("SMLALL_VG4_M4ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLALL_VG4_M4ZZ_HtoD_PSEUDO)
  .value("SMLAL_MZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLAL_MZZI_HtoS_PSEUDO);
  opcodes.value("SMLAL_MZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLAL_MZZ_HtoS_PSEUDO)
  .value("SMLAL_VG2_M2Z2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLAL_VG2_M2Z2Z_HtoS_PSEUDO)
  .value("SMLAL_VG2_M2ZZI_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLAL_VG2_M2ZZI_S_PSEUDO)
  .value("SMLAL_VG2_M2ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLAL_VG2_M2ZZ_HtoS_PSEUDO)
  .value("SMLAL_VG4_M4Z4Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLAL_VG4_M4Z4Z_HtoS_PSEUDO)
  .value("SMLAL_VG4_M4ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLAL_VG4_M4ZZI_HtoS_PSEUDO)
  .value("SMLAL_VG4_M4ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLAL_VG4_M4ZZ_HtoS_PSEUDO)
  .value("SMLSLL_MZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_MZZI_BtoS_PSEUDO)
  .value("SMLSLL_MZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_MZZI_HtoD_PSEUDO)
  .value("SMLSLL_MZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_MZZ_BtoS_PSEUDO)
  .value("SMLSLL_MZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_MZZ_HtoD_PSEUDO)
  .value("SMLSLL_VG2_M2Z2Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG2_M2Z2Z_BtoS_PSEUDO)
  .value("SMLSLL_VG2_M2Z2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG2_M2Z2Z_HtoD_PSEUDO)
  .value("SMLSLL_VG2_M2ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG2_M2ZZI_BtoS_PSEUDO)
  .value("SMLSLL_VG2_M2ZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG2_M2ZZI_HtoD_PSEUDO)
  .value("SMLSLL_VG2_M2ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG2_M2ZZ_BtoS_PSEUDO)
  .value("SMLSLL_VG2_M2ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG2_M2ZZ_HtoD_PSEUDO)
  .value("SMLSLL_VG4_M4Z4Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG4_M4Z4Z_BtoS_PSEUDO)
  .value("SMLSLL_VG4_M4Z4Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG4_M4Z4Z_HtoD_PSEUDO)
  .value("SMLSLL_VG4_M4ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG4_M4ZZI_BtoS_PSEUDO)
  .value("SMLSLL_VG4_M4ZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG4_M4ZZI_HtoD_PSEUDO)
  .value("SMLSLL_VG4_M4ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG4_M4ZZ_BtoS_PSEUDO)
  .value("SMLSLL_VG4_M4ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG4_M4ZZ_HtoD_PSEUDO)
  .value("SMLSL_MZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSL_MZZI_HtoS_PSEUDO)
  .value("SMLSL_MZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSL_MZZ_HtoS_PSEUDO)
  .value("SMLSL_VG2_M2Z2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSL_VG2_M2Z2Z_HtoS_PSEUDO)
  .value("SMLSL_VG2_M2ZZI_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSL_VG2_M2ZZI_S_PSEUDO)
  .value("SMLSL_VG2_M2ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSL_VG2_M2ZZ_HtoS_PSEUDO)
  .value("SMLSL_VG4_M4Z4Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSL_VG4_M4Z4Z_HtoS_PSEUDO)
  .value("SMLSL_VG4_M4ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSL_VG4_M4ZZI_HtoS_PSEUDO)
  .value("SMLSL_VG4_M4ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMLSL_VG4_M4ZZ_HtoS_PSEUDO)
  .value("SMOP4A_M2Z2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4A_M2Z2Z_BToS_PSEUDO)
  .value("SMOP4A_M2Z2Z_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4A_M2Z2Z_HToS_PSEUDO)
  .value("SMOP4A_M2Z2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4A_M2Z2Z_HtoD_PSEUDO)
  .value("SMOP4A_M2ZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4A_M2ZZ_BToS_PSEUDO)
  .value("SMOP4A_M2ZZ_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4A_M2ZZ_HToS_PSEUDO)
  .value("SMOP4A_M2ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4A_M2ZZ_HtoD_PSEUDO)
  .value("SMOP4A_MZ2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4A_MZ2Z_BToS_PSEUDO)
  .value("SMOP4A_MZ2Z_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4A_MZ2Z_HToS_PSEUDO)
  .value("SMOP4A_MZ2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4A_MZ2Z_HtoD_PSEUDO)
  .value("SMOP4A_MZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4A_MZZ_BToS_PSEUDO)
  .value("SMOP4A_MZZ_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4A_MZZ_HToS_PSEUDO)
  .value("SMOP4A_MZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4A_MZZ_HtoD_PSEUDO)
  .value("SMOP4S_M2Z2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4S_M2Z2Z_BToS_PSEUDO)
  .value("SMOP4S_M2Z2Z_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4S_M2Z2Z_HToS_PSEUDO)
  .value("SMOP4S_M2Z2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4S_M2Z2Z_HtoD_PSEUDO)
  .value("SMOP4S_M2ZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4S_M2ZZ_BToS_PSEUDO)
  .value("SMOP4S_M2ZZ_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4S_M2ZZ_HToS_PSEUDO)
  .value("SMOP4S_M2ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4S_M2ZZ_HtoD_PSEUDO)
  .value("SMOP4S_MZ2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4S_MZ2Z_BToS_PSEUDO)
  .value("SMOP4S_MZ2Z_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4S_MZ2Z_HToS_PSEUDO)
  .value("SMOP4S_MZ2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4S_MZ2Z_HtoD_PSEUDO)
  .value("SMOP4S_MZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4S_MZZ_BToS_PSEUDO)
  .value("SMOP4S_MZZ_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4S_MZZ_HToS_PSEUDO)
  .value("SMOP4S_MZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOP4S_MZZ_HtoD_PSEUDO)
  .value("SMOPA_MPPZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOPA_MPPZZ_D_PSEUDO)
  .value("SMOPA_MPPZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOPA_MPPZZ_HtoS_PSEUDO)
  .value("SMOPA_MPPZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOPA_MPPZZ_S_PSEUDO)
  .value("SMOPS_MPPZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOPS_MPPZZ_D_PSEUDO)
  .value("SMOPS_MPPZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOPS_MPPZZ_HtoS_PSEUDO)
  .value("SMOPS_MPPZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::SMOPS_MPPZZ_S_PSEUDO)
  .value("SMULH_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::SMULH_ZPZZ_B_UNDEF)
  .value("SMULH_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::SMULH_ZPZZ_D_UNDEF)
  .value("SMULH_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::SMULH_ZPZZ_H_UNDEF)
  .value("SMULH_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::SMULH_ZPZZ_S_UNDEF)
  .value("SPACE", LIEF::assembly::aarch64::OPCODE::SPACE)
  .value("SPILL_PPR_TO_ZPR_SLOT_PSEUDO", LIEF::assembly::aarch64::OPCODE::SPILL_PPR_TO_ZPR_SLOT_PSEUDO)
  .value("SQABS_ZPmZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::SQABS_ZPmZ_B_UNDEF)
  .value("SQABS_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::SQABS_ZPmZ_D_UNDEF)
  .value("SQABS_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::SQABS_ZPmZ_H_UNDEF)
  .value("SQABS_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::SQABS_ZPmZ_S_UNDEF)
  .value("SQNEG_ZPmZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::SQNEG_ZPmZ_B_UNDEF)
  .value("SQNEG_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::SQNEG_ZPmZ_D_UNDEF)
  .value("SQNEG_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::SQNEG_ZPmZ_H_UNDEF)
  .value("SQNEG_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::SQNEG_ZPmZ_S_UNDEF)
  .value("SQRSHL_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::SQRSHL_ZPZZ_B_UNDEF)
  .value("SQRSHL_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::SQRSHL_ZPZZ_D_UNDEF)
  .value("SQRSHL_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::SQRSHL_ZPZZ_H_UNDEF)
  .value("SQRSHL_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::SQRSHL_ZPZZ_S_UNDEF)
  .value("SQSHLU_ZPZI_B_ZERO", LIEF::assembly::aarch64::OPCODE::SQSHLU_ZPZI_B_ZERO)
  .value("SQSHLU_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::SQSHLU_ZPZI_D_ZERO)
  .value("SQSHLU_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::SQSHLU_ZPZI_H_ZERO)
  .value("SQSHLU_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::SQSHLU_ZPZI_S_ZERO)
  .value("SQSHL_ZPZI_B_ZERO", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPZI_B_ZERO)
  .value("SQSHL_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPZI_D_ZERO)
  .value("SQSHL_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPZI_H_ZERO)
  .value("SQSHL_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPZI_S_ZERO)
  .value("SQSHL_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPZZ_B_UNDEF)
  .value("SQSHL_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPZZ_D_UNDEF)
  .value("SQSHL_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPZZ_H_UNDEF)
  .value("SQSHL_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPZZ_S_UNDEF)
  .value("SRSHL_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::SRSHL_ZPZZ_B_UNDEF)
  .value("SRSHL_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::SRSHL_ZPZZ_D_UNDEF)
  .value("SRSHL_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::SRSHL_ZPZZ_H_UNDEF)
  .value("SRSHL_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::SRSHL_ZPZZ_S_UNDEF)
  .value("SRSHR_ZPZI_B_ZERO", LIEF::assembly::aarch64::OPCODE::SRSHR_ZPZI_B_ZERO)
  .value("SRSHR_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::SRSHR_ZPZI_D_ZERO)
  .value("SRSHR_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::SRSHR_ZPZI_H_ZERO)
  .value("SRSHR_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::SRSHR_ZPZI_S_ZERO)
  .value("STGloop", LIEF::assembly::aarch64::OPCODE::STGloop)
  .value("STGloop_wback", LIEF::assembly::aarch64::OPCODE::STGloop_wback)
  .value("STMOPA_M2ZZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::STMOPA_M2ZZZI_BtoS_PSEUDO)
  .value("STMOPA_M2ZZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::STMOPA_M2ZZZI_HtoS_PSEUDO)
  .value("STR_PPXI", LIEF::assembly::aarch64::OPCODE::STR_PPXI)
  .value("STR_TX_PSEUDO", LIEF::assembly::aarch64::OPCODE::STR_TX_PSEUDO)
  .value("STR_ZZXI", LIEF::assembly::aarch64::OPCODE::STR_ZZXI)
  .value("STR_ZZXI_STRIDED_CONTIGUOUS", LIEF::assembly::aarch64::OPCODE::STR_ZZXI_STRIDED_CONTIGUOUS)
  .value("STR_ZZZXI", LIEF::assembly::aarch64::OPCODE::STR_ZZZXI)
  .value("STR_ZZZZXI", LIEF::assembly::aarch64::OPCODE::STR_ZZZZXI)
  .value("STR_ZZZZXI_STRIDED_CONTIGUOUS", LIEF::assembly::aarch64::OPCODE::STR_ZZZZXI_STRIDED_CONTIGUOUS)
  .value("STZGloop", LIEF::assembly::aarch64::OPCODE::STZGloop)
  .value("STZGloop_wback", LIEF::assembly::aarch64::OPCODE::STZGloop_wback)
  .value("SUBR_ZPZZ_B_ZERO", LIEF::assembly::aarch64::OPCODE::SUBR_ZPZZ_B_ZERO)
  .value("SUBR_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::SUBR_ZPZZ_D_ZERO)
  .value("SUBR_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::SUBR_ZPZZ_H_ZERO)
  .value("SUBR_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::SUBR_ZPZZ_S_ZERO)
  .value("SUBSWrr", LIEF::assembly::aarch64::OPCODE::SUBSWrr)
  .value("SUBSXrr", LIEF::assembly::aarch64::OPCODE::SUBSXrr)
  .value("SUBWrr", LIEF::assembly::aarch64::OPCODE::SUBWrr)
  .value("SUBXrr", LIEF::assembly::aarch64::OPCODE::SUBXrr)
  .value("SUB_VG2_M2Z2Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUB_VG2_M2Z2Z_D_PSEUDO)
  .value("SUB_VG2_M2Z2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUB_VG2_M2Z2Z_S_PSEUDO)
  .value("SUB_VG2_M2ZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUB_VG2_M2ZZ_D_PSEUDO)
  .value("SUB_VG2_M2ZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUB_VG2_M2ZZ_S_PSEUDO)
  .value("SUB_VG2_M2Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUB_VG2_M2Z_D_PSEUDO)
  .value("SUB_VG2_M2Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUB_VG2_M2Z_S_PSEUDO)
  .value("SUB_VG4_M4Z4Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUB_VG4_M4Z4Z_D_PSEUDO)
  .value("SUB_VG4_M4Z4Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUB_VG4_M4Z4Z_S_PSEUDO)
  .value("SUB_VG4_M4ZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUB_VG4_M4ZZ_D_PSEUDO)
  .value("SUB_VG4_M4ZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUB_VG4_M4ZZ_S_PSEUDO)
  .value("SUB_VG4_M4Z_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUB_VG4_M4Z_D_PSEUDO)
  .value("SUB_VG4_M4Z_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUB_VG4_M4Z_S_PSEUDO)
  .value("SUB_ZPZZ_B_ZERO", LIEF::assembly::aarch64::OPCODE::SUB_ZPZZ_B_ZERO)
  .value("SUB_ZPZZ_D_ZERO", LIEF::assembly::aarch64::OPCODE::SUB_ZPZZ_D_ZERO)
  .value("SUB_ZPZZ_H_ZERO", LIEF::assembly::aarch64::OPCODE::SUB_ZPZZ_H_ZERO)
  .value("SUB_ZPZZ_S_ZERO", LIEF::assembly::aarch64::OPCODE::SUB_ZPZZ_S_ZERO)
  .value("SUDOT_VG2_M2ZZI_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUDOT_VG2_M2ZZI_BToS_PSEUDO)
  .value("SUDOT_VG2_M2ZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUDOT_VG2_M2ZZ_BToS_PSEUDO)
  .value("SUDOT_VG4_M4ZZI_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUDOT_VG4_M4ZZI_BToS_PSEUDO)
  .value("SUDOT_VG4_M4ZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUDOT_VG4_M4ZZ_BToS_PSEUDO)
  .value("SUMLALL_MZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMLALL_MZZI_BtoS_PSEUDO)
  .value("SUMLALL_VG2_M2ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMLALL_VG2_M2ZZI_BtoS_PSEUDO)
  .value("SUMLALL_VG2_M2ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMLALL_VG2_M2ZZ_BtoS_PSEUDO)
  .value("SUMLALL_VG4_M4ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMLALL_VG4_M4ZZI_BtoS_PSEUDO)
  .value("SUMLALL_VG4_M4ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMLALL_VG4_M4ZZ_BtoS_PSEUDO)
  .value("SUMOP4A_M2Z2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4A_M2Z2Z_BToS_PSEUDO)
  .value("SUMOP4A_M2Z2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4A_M2Z2Z_HtoD_PSEUDO)
  .value("SUMOP4A_M2ZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4A_M2ZZ_BToS_PSEUDO)
  .value("SUMOP4A_M2ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4A_M2ZZ_HtoD_PSEUDO)
  .value("SUMOP4A_MZ2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4A_MZ2Z_BToS_PSEUDO)
  .value("SUMOP4A_MZ2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4A_MZ2Z_HtoD_PSEUDO)
  .value("SUMOP4A_MZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4A_MZZ_BToS_PSEUDO)
  .value("SUMOP4A_MZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4A_MZZ_HtoD_PSEUDO)
  .value("SUMOP4S_M2Z2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4S_M2Z2Z_BToS_PSEUDO)
  .value("SUMOP4S_M2Z2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4S_M2Z2Z_HtoD_PSEUDO)
  .value("SUMOP4S_M2ZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4S_M2ZZ_BToS_PSEUDO)
  .value("SUMOP4S_M2ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4S_M2ZZ_HtoD_PSEUDO)
  .value("SUMOP4S_MZ2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4S_MZ2Z_BToS_PSEUDO)
  .value("SUMOP4S_MZ2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4S_MZ2Z_HtoD_PSEUDO)
  .value("SUMOP4S_MZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4S_MZZ_BToS_PSEUDO)
  .value("SUMOP4S_MZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOP4S_MZZ_HtoD_PSEUDO)
  .value("SUMOPA_MPPZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOPA_MPPZZ_D_PSEUDO)
  .value("SUMOPA_MPPZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOPA_MPPZZ_S_PSEUDO)
  .value("SUMOPS_MPPZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOPS_MPPZZ_D_PSEUDO)
  .value("SUMOPS_MPPZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUMOPS_MPPZZ_S_PSEUDO)
  .value("SUTMOPA_M2ZZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUTMOPA_M2ZZZI_BtoS_PSEUDO)
  .value("SUVDOT_VG4_M4ZZI_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SUVDOT_VG4_M4ZZI_BToS_PSEUDO)
  .value("SVDOT_VG2_M2ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SVDOT_VG2_M2ZZI_HtoS_PSEUDO)
  .value("SVDOT_VG4_M4ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::SVDOT_VG4_M4ZZI_BtoS_PSEUDO)
  .value("SVDOT_VG4_M4ZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::SVDOT_VG4_M4ZZI_HtoD_PSEUDO)
  .value("SXTB_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::SXTB_ZPmZ_D_UNDEF)
  .value("SXTB_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::SXTB_ZPmZ_H_UNDEF)
  .value("SXTB_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::SXTB_ZPmZ_S_UNDEF)
  .value("SXTH_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::SXTH_ZPmZ_D_UNDEF)
  .value("SXTH_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::SXTH_ZPmZ_S_UNDEF)
  .value("SXTW_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::SXTW_ZPmZ_D_UNDEF)
  .value("SpeculationBarrierISBDSBEndBB", LIEF::assembly::aarch64::OPCODE::SpeculationBarrierISBDSBEndBB)
  .value("SpeculationBarrierSBEndBB", LIEF::assembly::aarch64::OPCODE::SpeculationBarrierSBEndBB)
  .value("SpeculationSafeValueW", LIEF::assembly::aarch64::OPCODE::SpeculationSafeValueW)
  .value("SpeculationSafeValueX", LIEF::assembly::aarch64::OPCODE::SpeculationSafeValueX)
  .value("StoreSwiftAsyncContext", LIEF::assembly::aarch64::OPCODE::StoreSwiftAsyncContext)
  .value("TAGPstack", LIEF::assembly::aarch64::OPCODE::TAGPstack)
  .value("TCRETURNdi", LIEF::assembly::aarch64::OPCODE::TCRETURNdi)
  .value("TCRETURNri", LIEF::assembly::aarch64::OPCODE::TCRETURNri)
  .value("TCRETURNriALL", LIEF::assembly::aarch64::OPCODE::TCRETURNriALL)
  .value("TCRETURNrinotx16", LIEF::assembly::aarch64::OPCODE::TCRETURNrinotx16)
  .value("TCRETURNrix16x17", LIEF::assembly::aarch64::OPCODE::TCRETURNrix16x17)
  .value("TCRETURNrix17", LIEF::assembly::aarch64::OPCODE::TCRETURNrix17)
  .value("TLSDESCCALL", LIEF::assembly::aarch64::OPCODE::TLSDESCCALL)
  .value("TLSDESC_AUTH_CALLSEQ", LIEF::assembly::aarch64::OPCODE::TLSDESC_AUTH_CALLSEQ)
  .value("TLSDESC_CALLSEQ", LIEF::assembly::aarch64::OPCODE::TLSDESC_CALLSEQ)
  .value("UABD_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::UABD_ZPZZ_B_UNDEF)
  .value("UABD_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::UABD_ZPZZ_D_UNDEF)
  .value("UABD_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::UABD_ZPZZ_H_UNDEF)
  .value("UABD_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::UABD_ZPZZ_S_UNDEF)
  .value("UCVTF_ZPmZ_DtoD_UNDEF", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPmZ_DtoD_UNDEF)
  .value("UCVTF_ZPmZ_DtoH_UNDEF", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPmZ_DtoH_UNDEF)
  .value("UCVTF_ZPmZ_DtoS_UNDEF", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPmZ_DtoS_UNDEF)
  .value("UCVTF_ZPmZ_HtoH_UNDEF", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPmZ_HtoH_UNDEF)
  .value("UCVTF_ZPmZ_StoD_UNDEF", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPmZ_StoD_UNDEF)
  .value("UCVTF_ZPmZ_StoH_UNDEF", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPmZ_StoH_UNDEF)
  .value("UCVTF_ZPmZ_StoS_UNDEF", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPmZ_StoS_UNDEF)
  .value("UDIV_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::UDIV_ZPZZ_D_UNDEF)
  .value("UDIV_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::UDIV_ZPZZ_S_UNDEF)
  .value("UDOT_VG2_M2Z2Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2Z2Z_BtoS_PSEUDO)
  .value("UDOT_VG2_M2Z2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2Z2Z_HtoD_PSEUDO)
  .value("UDOT_VG2_M2Z2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2Z2Z_HtoS_PSEUDO)
  .value("UDOT_VG2_M2ZZI_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2ZZI_BToS_PSEUDO)
  .value("UDOT_VG2_M2ZZI_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2ZZI_HToS_PSEUDO)
  .value("UDOT_VG2_M2ZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2ZZI_HtoD_PSEUDO)
  .value("UDOT_VG2_M2ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2ZZ_BtoS_PSEUDO)
  .value("UDOT_VG2_M2ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2ZZ_HtoD_PSEUDO)
  .value("UDOT_VG2_M2ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2ZZ_HtoS_PSEUDO)
  .value("UDOT_VG4_M4Z4Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4Z4Z_BtoS_PSEUDO)
  .value("UDOT_VG4_M4Z4Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4Z4Z_HtoD_PSEUDO)
  .value("UDOT_VG4_M4Z4Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4Z4Z_HtoS_PSEUDO)
  .value("UDOT_VG4_M4ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4ZZI_BtoS_PSEUDO)
  .value("UDOT_VG4_M4ZZI_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4ZZI_HToS_PSEUDO)
  .value("UDOT_VG4_M4ZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4ZZI_HtoD_PSEUDO)
  .value("UDOT_VG4_M4ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4ZZ_BtoS_PSEUDO)
  .value("UDOT_VG4_M4ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4ZZ_HtoD_PSEUDO)
  .value("UDOT_VG4_M4ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4ZZ_HtoS_PSEUDO)
  .value("UMAX_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::UMAX_ZPZZ_B_UNDEF)
  .value("UMAX_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::UMAX_ZPZZ_D_UNDEF)
  .value("UMAX_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::UMAX_ZPZZ_H_UNDEF)
  .value("UMAX_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::UMAX_ZPZZ_S_UNDEF)
  .value("UMIN_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::UMIN_ZPZZ_B_UNDEF)
  .value("UMIN_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::UMIN_ZPZZ_D_UNDEF)
  .value("UMIN_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::UMIN_ZPZZ_H_UNDEF)
  .value("UMIN_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::UMIN_ZPZZ_S_UNDEF)
  .value("UMLALL_MZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_MZZI_BtoS_PSEUDO)
  .value("UMLALL_MZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_MZZI_HtoD_PSEUDO)
  .value("UMLALL_MZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_MZZ_BtoS_PSEUDO)
  .value("UMLALL_MZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_MZZ_HtoD_PSEUDO)
  .value("UMLALL_VG2_M2Z2Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_VG2_M2Z2Z_BtoS_PSEUDO)
  .value("UMLALL_VG2_M2Z2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_VG2_M2Z2Z_HtoD_PSEUDO)
  .value("UMLALL_VG2_M2ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_VG2_M2ZZI_BtoS_PSEUDO)
  .value("UMLALL_VG2_M2ZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_VG2_M2ZZI_HtoD_PSEUDO)
  .value("UMLALL_VG2_M2ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_VG2_M2ZZ_BtoS_PSEUDO)
  .value("UMLALL_VG2_M2ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_VG2_M2ZZ_HtoD_PSEUDO)
  .value("UMLALL_VG4_M4Z4Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_VG4_M4Z4Z_BtoS_PSEUDO)
  .value("UMLALL_VG4_M4Z4Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_VG4_M4Z4Z_HtoD_PSEUDO)
  .value("UMLALL_VG4_M4ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_VG4_M4ZZI_BtoS_PSEUDO)
  .value("UMLALL_VG4_M4ZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_VG4_M4ZZI_HtoD_PSEUDO)
  .value("UMLALL_VG4_M4ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_VG4_M4ZZ_BtoS_PSEUDO)
  .value("UMLALL_VG4_M4ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLALL_VG4_M4ZZ_HtoD_PSEUDO)
  .value("UMLAL_MZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLAL_MZZI_HtoS_PSEUDO)
  .value("UMLAL_MZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLAL_MZZ_HtoS_PSEUDO)
  .value("UMLAL_VG2_M2Z2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLAL_VG2_M2Z2Z_HtoS_PSEUDO)
  .value("UMLAL_VG2_M2ZZI_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLAL_VG2_M2ZZI_S_PSEUDO)
  .value("UMLAL_VG2_M2ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLAL_VG2_M2ZZ_HtoS_PSEUDO)
  .value("UMLAL_VG4_M4Z4Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLAL_VG4_M4Z4Z_HtoS_PSEUDO)
  .value("UMLAL_VG4_M4ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLAL_VG4_M4ZZI_HtoS_PSEUDO)
  .value("UMLAL_VG4_M4ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLAL_VG4_M4ZZ_HtoS_PSEUDO)
  .value("UMLSLL_MZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_MZZI_BtoS_PSEUDO)
  .value("UMLSLL_MZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_MZZI_HtoD_PSEUDO)
  .value("UMLSLL_MZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_MZZ_BtoS_PSEUDO)
  .value("UMLSLL_MZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_MZZ_HtoD_PSEUDO)
  .value("UMLSLL_VG2_M2Z2Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG2_M2Z2Z_BtoS_PSEUDO)
  .value("UMLSLL_VG2_M2Z2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG2_M2Z2Z_HtoD_PSEUDO)
  .value("UMLSLL_VG2_M2ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG2_M2ZZI_BtoS_PSEUDO)
  .value("UMLSLL_VG2_M2ZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG2_M2ZZI_HtoD_PSEUDO)
  .value("UMLSLL_VG2_M2ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG2_M2ZZ_BtoS_PSEUDO)
  .value("UMLSLL_VG2_M2ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG2_M2ZZ_HtoD_PSEUDO)
  .value("UMLSLL_VG4_M4Z4Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG4_M4Z4Z_BtoS_PSEUDO)
  .value("UMLSLL_VG4_M4Z4Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG4_M4Z4Z_HtoD_PSEUDO)
  .value("UMLSLL_VG4_M4ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG4_M4ZZI_BtoS_PSEUDO)
  .value("UMLSLL_VG4_M4ZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG4_M4ZZI_HtoD_PSEUDO)
  .value("UMLSLL_VG4_M4ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG4_M4ZZ_BtoS_PSEUDO)
  .value("UMLSLL_VG4_M4ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG4_M4ZZ_HtoD_PSEUDO)
  .value("UMLSL_MZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSL_MZZI_HtoS_PSEUDO)
  .value("UMLSL_MZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSL_MZZ_HtoS_PSEUDO)
  .value("UMLSL_VG2_M2Z2Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSL_VG2_M2Z2Z_HtoS_PSEUDO)
  .value("UMLSL_VG2_M2ZZI_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSL_VG2_M2ZZI_S_PSEUDO)
  .value("UMLSL_VG2_M2ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSL_VG2_M2ZZ_HtoS_PSEUDO)
  .value("UMLSL_VG4_M4Z4Z_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSL_VG4_M4Z4Z_HtoS_PSEUDO)
  .value("UMLSL_VG4_M4ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSL_VG4_M4ZZI_HtoS_PSEUDO)
  .value("UMLSL_VG4_M4ZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMLSL_VG4_M4ZZ_HtoS_PSEUDO)
  .value("UMOP4A_M2Z2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4A_M2Z2Z_BToS_PSEUDO)
  .value("UMOP4A_M2Z2Z_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4A_M2Z2Z_HToS_PSEUDO)
  .value("UMOP4A_M2Z2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4A_M2Z2Z_HtoD_PSEUDO)
  .value("UMOP4A_M2ZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4A_M2ZZ_BToS_PSEUDO)
  .value("UMOP4A_M2ZZ_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4A_M2ZZ_HToS_PSEUDO)
  .value("UMOP4A_M2ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4A_M2ZZ_HtoD_PSEUDO)
  .value("UMOP4A_MZ2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4A_MZ2Z_BToS_PSEUDO)
  .value("UMOP4A_MZ2Z_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4A_MZ2Z_HToS_PSEUDO)
  .value("UMOP4A_MZ2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4A_MZ2Z_HtoD_PSEUDO)
  .value("UMOP4A_MZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4A_MZZ_BToS_PSEUDO)
  .value("UMOP4A_MZZ_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4A_MZZ_HToS_PSEUDO)
  .value("UMOP4A_MZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4A_MZZ_HtoD_PSEUDO)
  .value("UMOP4S_M2Z2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4S_M2Z2Z_BToS_PSEUDO)
  .value("UMOP4S_M2Z2Z_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4S_M2Z2Z_HToS_PSEUDO)
  .value("UMOP4S_M2Z2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4S_M2Z2Z_HtoD_PSEUDO)
  .value("UMOP4S_M2ZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4S_M2ZZ_BToS_PSEUDO)
  .value("UMOP4S_M2ZZ_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4S_M2ZZ_HToS_PSEUDO)
  .value("UMOP4S_M2ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4S_M2ZZ_HtoD_PSEUDO)
  .value("UMOP4S_MZ2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4S_MZ2Z_BToS_PSEUDO)
  .value("UMOP4S_MZ2Z_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4S_MZ2Z_HToS_PSEUDO)
  .value("UMOP4S_MZ2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4S_MZ2Z_HtoD_PSEUDO)
  .value("UMOP4S_MZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4S_MZZ_BToS_PSEUDO);
  opcodes.value("UMOP4S_MZZ_HToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4S_MZZ_HToS_PSEUDO)
  .value("UMOP4S_MZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOP4S_MZZ_HtoD_PSEUDO)
  .value("UMOPA_MPPZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOPA_MPPZZ_D_PSEUDO)
  .value("UMOPA_MPPZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOPA_MPPZZ_HtoS_PSEUDO)
  .value("UMOPA_MPPZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOPA_MPPZZ_S_PSEUDO)
  .value("UMOPS_MPPZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOPS_MPPZZ_D_PSEUDO)
  .value("UMOPS_MPPZZ_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOPS_MPPZZ_HtoS_PSEUDO)
  .value("UMOPS_MPPZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::UMOPS_MPPZZ_S_PSEUDO)
  .value("UMULH_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::UMULH_ZPZZ_B_UNDEF)
  .value("UMULH_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::UMULH_ZPZZ_D_UNDEF)
  .value("UMULH_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::UMULH_ZPZZ_H_UNDEF)
  .value("UMULH_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::UMULH_ZPZZ_S_UNDEF)
  .value("UQRSHL_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::UQRSHL_ZPZZ_B_UNDEF)
  .value("UQRSHL_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::UQRSHL_ZPZZ_D_UNDEF)
  .value("UQRSHL_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::UQRSHL_ZPZZ_H_UNDEF)
  .value("UQRSHL_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::UQRSHL_ZPZZ_S_UNDEF)
  .value("UQSHL_ZPZI_B_ZERO", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPZI_B_ZERO)
  .value("UQSHL_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPZI_D_ZERO)
  .value("UQSHL_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPZI_H_ZERO)
  .value("UQSHL_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPZI_S_ZERO)
  .value("UQSHL_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPZZ_B_UNDEF)
  .value("UQSHL_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPZZ_D_UNDEF)
  .value("UQSHL_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPZZ_H_UNDEF)
  .value("UQSHL_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPZZ_S_UNDEF)
  .value("URECPE_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::URECPE_ZPmZ_S_UNDEF)
  .value("URSHL_ZPZZ_B_UNDEF", LIEF::assembly::aarch64::OPCODE::URSHL_ZPZZ_B_UNDEF)
  .value("URSHL_ZPZZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::URSHL_ZPZZ_D_UNDEF)
  .value("URSHL_ZPZZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::URSHL_ZPZZ_H_UNDEF)
  .value("URSHL_ZPZZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::URSHL_ZPZZ_S_UNDEF)
  .value("URSHR_ZPZI_B_ZERO", LIEF::assembly::aarch64::OPCODE::URSHR_ZPZI_B_ZERO)
  .value("URSHR_ZPZI_D_ZERO", LIEF::assembly::aarch64::OPCODE::URSHR_ZPZI_D_ZERO)
  .value("URSHR_ZPZI_H_ZERO", LIEF::assembly::aarch64::OPCODE::URSHR_ZPZI_H_ZERO)
  .value("URSHR_ZPZI_S_ZERO", LIEF::assembly::aarch64::OPCODE::URSHR_ZPZI_S_ZERO)
  .value("URSQRTE_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::URSQRTE_ZPmZ_S_UNDEF)
  .value("USDOT_VG2_M2Z2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USDOT_VG2_M2Z2Z_BToS_PSEUDO)
  .value("USDOT_VG2_M2ZZI_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USDOT_VG2_M2ZZI_BToS_PSEUDO)
  .value("USDOT_VG2_M2ZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USDOT_VG2_M2ZZ_BToS_PSEUDO)
  .value("USDOT_VG4_M4Z4Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USDOT_VG4_M4Z4Z_BToS_PSEUDO)
  .value("USDOT_VG4_M4ZZI_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USDOT_VG4_M4ZZI_BToS_PSEUDO)
  .value("USDOT_VG4_M4ZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USDOT_VG4_M4ZZ_BToS_PSEUDO)
  .value("USMLALL_MZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMLALL_MZZI_BtoS_PSEUDO)
  .value("USMLALL_MZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMLALL_MZZ_BtoS_PSEUDO)
  .value("USMLALL_VG2_M2Z2Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMLALL_VG2_M2Z2Z_BtoS_PSEUDO)
  .value("USMLALL_VG2_M2ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMLALL_VG2_M2ZZI_BtoS_PSEUDO)
  .value("USMLALL_VG2_M2ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMLALL_VG2_M2ZZ_BtoS_PSEUDO)
  .value("USMLALL_VG4_M4Z4Z_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMLALL_VG4_M4Z4Z_BtoS_PSEUDO)
  .value("USMLALL_VG4_M4ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMLALL_VG4_M4ZZI_BtoS_PSEUDO)
  .value("USMLALL_VG4_M4ZZ_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMLALL_VG4_M4ZZ_BtoS_PSEUDO)
  .value("USMOP4A_M2Z2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4A_M2Z2Z_BToS_PSEUDO)
  .value("USMOP4A_M2Z2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4A_M2Z2Z_HtoD_PSEUDO)
  .value("USMOP4A_M2ZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4A_M2ZZ_BToS_PSEUDO)
  .value("USMOP4A_M2ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4A_M2ZZ_HtoD_PSEUDO)
  .value("USMOP4A_MZ2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4A_MZ2Z_BToS_PSEUDO)
  .value("USMOP4A_MZ2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4A_MZ2Z_HtoD_PSEUDO)
  .value("USMOP4A_MZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4A_MZZ_BToS_PSEUDO)
  .value("USMOP4A_MZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4A_MZZ_HtoD_PSEUDO)
  .value("USMOP4S_M2Z2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4S_M2Z2Z_BToS_PSEUDO)
  .value("USMOP4S_M2Z2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4S_M2Z2Z_HtoD_PSEUDO)
  .value("USMOP4S_M2ZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4S_M2ZZ_BToS_PSEUDO)
  .value("USMOP4S_M2ZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4S_M2ZZ_HtoD_PSEUDO)
  .value("USMOP4S_MZ2Z_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4S_MZ2Z_BToS_PSEUDO)
  .value("USMOP4S_MZ2Z_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4S_MZ2Z_HtoD_PSEUDO)
  .value("USMOP4S_MZZ_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4S_MZZ_BToS_PSEUDO)
  .value("USMOP4S_MZZ_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOP4S_MZZ_HtoD_PSEUDO)
  .value("USMOPA_MPPZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOPA_MPPZZ_D_PSEUDO)
  .value("USMOPA_MPPZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOPA_MPPZZ_S_PSEUDO)
  .value("USMOPS_MPPZZ_D_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOPS_MPPZZ_D_PSEUDO)
  .value("USMOPS_MPPZZ_S_PSEUDO", LIEF::assembly::aarch64::OPCODE::USMOPS_MPPZZ_S_PSEUDO)
  .value("USTMOPA_M2ZZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USTMOPA_M2ZZZI_BtoS_PSEUDO)
  .value("USVDOT_VG4_M4ZZI_BToS_PSEUDO", LIEF::assembly::aarch64::OPCODE::USVDOT_VG4_M4ZZI_BToS_PSEUDO)
  .value("UTMOPA_M2ZZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UTMOPA_M2ZZZI_BtoS_PSEUDO)
  .value("UTMOPA_M2ZZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UTMOPA_M2ZZZI_HtoS_PSEUDO)
  .value("UVDOT_VG2_M2ZZI_HtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UVDOT_VG2_M2ZZI_HtoS_PSEUDO)
  .value("UVDOT_VG4_M4ZZI_BtoS_PSEUDO", LIEF::assembly::aarch64::OPCODE::UVDOT_VG4_M4ZZI_BtoS_PSEUDO)
  .value("UVDOT_VG4_M4ZZI_HtoD_PSEUDO", LIEF::assembly::aarch64::OPCODE::UVDOT_VG4_M4ZZI_HtoD_PSEUDO)
  .value("UXTB_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::UXTB_ZPmZ_D_UNDEF)
  .value("UXTB_ZPmZ_H_UNDEF", LIEF::assembly::aarch64::OPCODE::UXTB_ZPmZ_H_UNDEF)
  .value("UXTB_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::UXTB_ZPmZ_S_UNDEF)
  .value("UXTH_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::UXTH_ZPmZ_D_UNDEF)
  .value("UXTH_ZPmZ_S_UNDEF", LIEF::assembly::aarch64::OPCODE::UXTH_ZPmZ_S_UNDEF)
  .value("UXTW_ZPmZ_D_UNDEF", LIEF::assembly::aarch64::OPCODE::UXTW_ZPmZ_D_UNDEF)
  .value("VGRestorePseudo", LIEF::assembly::aarch64::OPCODE::VGRestorePseudo)
  .value("VGSavePseudo", LIEF::assembly::aarch64::OPCODE::VGSavePseudo)
  .value("ZERO_MXI_2Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_2Z_PSEUDO)
  .value("ZERO_MXI_4Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_4Z_PSEUDO)
  .value("ZERO_MXI_VG2_2Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_VG2_2Z_PSEUDO)
  .value("ZERO_MXI_VG2_4Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_VG2_4Z_PSEUDO)
  .value("ZERO_MXI_VG2_Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_VG2_Z_PSEUDO)
  .value("ZERO_MXI_VG4_2Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_VG4_2Z_PSEUDO)
  .value("ZERO_MXI_VG4_4Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_VG4_4Z_PSEUDO)
  .value("ZERO_MXI_VG4_Z_PSEUDO", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_VG4_Z_PSEUDO)
  .value("ZERO_M_PSEUDO", LIEF::assembly::aarch64::OPCODE::ZERO_M_PSEUDO)
  .value("ZERO_T_PSEUDO", LIEF::assembly::aarch64::OPCODE::ZERO_T_PSEUDO)
  .value("ABSWr", LIEF::assembly::aarch64::OPCODE::ABSWr)
  .value("ABSXr", LIEF::assembly::aarch64::OPCODE::ABSXr)
  .value("ABS_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::ABS_ZPmZ_B)
  .value("ABS_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::ABS_ZPmZ_D)
  .value("ABS_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::ABS_ZPmZ_H)
  .value("ABS_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::ABS_ZPmZ_S)
  .value("ABS_ZPzZ_B", LIEF::assembly::aarch64::OPCODE::ABS_ZPzZ_B)
  .value("ABS_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::ABS_ZPzZ_D)
  .value("ABS_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::ABS_ZPzZ_H)
  .value("ABS_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::ABS_ZPzZ_S)
  .value("ABSv16i8", LIEF::assembly::aarch64::OPCODE::ABSv16i8)
  .value("ABSv1i64", LIEF::assembly::aarch64::OPCODE::ABSv1i64)
  .value("ABSv2i32", LIEF::assembly::aarch64::OPCODE::ABSv2i32)
  .value("ABSv2i64", LIEF::assembly::aarch64::OPCODE::ABSv2i64)
  .value("ABSv4i16", LIEF::assembly::aarch64::OPCODE::ABSv4i16)
  .value("ABSv4i32", LIEF::assembly::aarch64::OPCODE::ABSv4i32)
  .value("ABSv8i16", LIEF::assembly::aarch64::OPCODE::ABSv8i16)
  .value("ABSv8i8", LIEF::assembly::aarch64::OPCODE::ABSv8i8)
  .value("ADCLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::ADCLB_ZZZ_D)
  .value("ADCLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::ADCLB_ZZZ_S)
  .value("ADCLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::ADCLT_ZZZ_D)
  .value("ADCLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::ADCLT_ZZZ_S)
  .value("ADCSWr", LIEF::assembly::aarch64::OPCODE::ADCSWr)
  .value("ADCSXr", LIEF::assembly::aarch64::OPCODE::ADCSXr)
  .value("ADCWr", LIEF::assembly::aarch64::OPCODE::ADCWr)
  .value("ADCXr", LIEF::assembly::aarch64::OPCODE::ADCXr)
  .value("ADDG", LIEF::assembly::aarch64::OPCODE::ADDG)
  .value("ADDHA_MPPZ_D", LIEF::assembly::aarch64::OPCODE::ADDHA_MPPZ_D)
  .value("ADDHA_MPPZ_S", LIEF::assembly::aarch64::OPCODE::ADDHA_MPPZ_S)
  .value("ADDHNB_ZZZ_B", LIEF::assembly::aarch64::OPCODE::ADDHNB_ZZZ_B)
  .value("ADDHNB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::ADDHNB_ZZZ_H)
  .value("ADDHNB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::ADDHNB_ZZZ_S)
  .value("ADDHNT_ZZZ_B", LIEF::assembly::aarch64::OPCODE::ADDHNT_ZZZ_B)
  .value("ADDHNT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::ADDHNT_ZZZ_H)
  .value("ADDHNT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::ADDHNT_ZZZ_S)
  .value("ADDHNv2i64_v2i32", LIEF::assembly::aarch64::OPCODE::ADDHNv2i64_v2i32)
  .value("ADDHNv2i64_v4i32", LIEF::assembly::aarch64::OPCODE::ADDHNv2i64_v4i32)
  .value("ADDHNv4i32_v4i16", LIEF::assembly::aarch64::OPCODE::ADDHNv4i32_v4i16)
  .value("ADDHNv4i32_v8i16", LIEF::assembly::aarch64::OPCODE::ADDHNv4i32_v8i16)
  .value("ADDHNv8i16_v16i8", LIEF::assembly::aarch64::OPCODE::ADDHNv8i16_v16i8)
  .value("ADDHNv8i16_v8i8", LIEF::assembly::aarch64::OPCODE::ADDHNv8i16_v8i8)
  .value("ADDPL_XXI", LIEF::assembly::aarch64::OPCODE::ADDPL_XXI)
  .value("ADDPT_shift", LIEF::assembly::aarch64::OPCODE::ADDPT_shift)
  .value("ADDP_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::ADDP_ZPmZ_B)
  .value("ADDP_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::ADDP_ZPmZ_D)
  .value("ADDP_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::ADDP_ZPmZ_H)
  .value("ADDP_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::ADDP_ZPmZ_S)
  .value("ADDPv16i8", LIEF::assembly::aarch64::OPCODE::ADDPv16i8)
  .value("ADDPv2i32", LIEF::assembly::aarch64::OPCODE::ADDPv2i32)
  .value("ADDPv2i64", LIEF::assembly::aarch64::OPCODE::ADDPv2i64)
  .value("ADDPv2i64p", LIEF::assembly::aarch64::OPCODE::ADDPv2i64p)
  .value("ADDPv4i16", LIEF::assembly::aarch64::OPCODE::ADDPv4i16)
  .value("ADDPv4i32", LIEF::assembly::aarch64::OPCODE::ADDPv4i32)
  .value("ADDPv8i16", LIEF::assembly::aarch64::OPCODE::ADDPv8i16)
  .value("ADDPv8i8", LIEF::assembly::aarch64::OPCODE::ADDPv8i8)
  .value("ADDQV_VPZ_B", LIEF::assembly::aarch64::OPCODE::ADDQV_VPZ_B)
  .value("ADDQV_VPZ_D", LIEF::assembly::aarch64::OPCODE::ADDQV_VPZ_D)
  .value("ADDQV_VPZ_H", LIEF::assembly::aarch64::OPCODE::ADDQV_VPZ_H)
  .value("ADDQV_VPZ_S", LIEF::assembly::aarch64::OPCODE::ADDQV_VPZ_S)
  .value("ADDSPL_XXI", LIEF::assembly::aarch64::OPCODE::ADDSPL_XXI)
  .value("ADDSVL_XXI", LIEF::assembly::aarch64::OPCODE::ADDSVL_XXI)
  .value("ADDSWri", LIEF::assembly::aarch64::OPCODE::ADDSWri)
  .value("ADDSWrs", LIEF::assembly::aarch64::OPCODE::ADDSWrs)
  .value("ADDSWrx", LIEF::assembly::aarch64::OPCODE::ADDSWrx)
  .value("ADDSXri", LIEF::assembly::aarch64::OPCODE::ADDSXri)
  .value("ADDSXrs", LIEF::assembly::aarch64::OPCODE::ADDSXrs)
  .value("ADDSXrx", LIEF::assembly::aarch64::OPCODE::ADDSXrx)
  .value("ADDSXrx64", LIEF::assembly::aarch64::OPCODE::ADDSXrx64)
  .value("ADDVA_MPPZ_D", LIEF::assembly::aarch64::OPCODE::ADDVA_MPPZ_D)
  .value("ADDVA_MPPZ_S", LIEF::assembly::aarch64::OPCODE::ADDVA_MPPZ_S)
  .value("ADDVL_XXI", LIEF::assembly::aarch64::OPCODE::ADDVL_XXI)
  .value("ADDVv16i8v", LIEF::assembly::aarch64::OPCODE::ADDVv16i8v)
  .value("ADDVv4i16v", LIEF::assembly::aarch64::OPCODE::ADDVv4i16v)
  .value("ADDVv4i32v", LIEF::assembly::aarch64::OPCODE::ADDVv4i32v)
  .value("ADDVv8i16v", LIEF::assembly::aarch64::OPCODE::ADDVv8i16v)
  .value("ADDVv8i8v", LIEF::assembly::aarch64::OPCODE::ADDVv8i8v)
  .value("ADDWri", LIEF::assembly::aarch64::OPCODE::ADDWri)
  .value("ADDWrs", LIEF::assembly::aarch64::OPCODE::ADDWrs)
  .value("ADDWrx", LIEF::assembly::aarch64::OPCODE::ADDWrx)
  .value("ADDXri", LIEF::assembly::aarch64::OPCODE::ADDXri)
  .value("ADDXrs", LIEF::assembly::aarch64::OPCODE::ADDXrs)
  .value("ADDXrx", LIEF::assembly::aarch64::OPCODE::ADDXrx)
  .value("ADDXrx64", LIEF::assembly::aarch64::OPCODE::ADDXrx64)
  .value("ADD_VG2_2ZZ_B", LIEF::assembly::aarch64::OPCODE::ADD_VG2_2ZZ_B)
  .value("ADD_VG2_2ZZ_D", LIEF::assembly::aarch64::OPCODE::ADD_VG2_2ZZ_D)
  .value("ADD_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::ADD_VG2_2ZZ_H)
  .value("ADD_VG2_2ZZ_S", LIEF::assembly::aarch64::OPCODE::ADD_VG2_2ZZ_S)
  .value("ADD_VG2_M2Z2Z_D", LIEF::assembly::aarch64::OPCODE::ADD_VG2_M2Z2Z_D)
  .value("ADD_VG2_M2Z2Z_S", LIEF::assembly::aarch64::OPCODE::ADD_VG2_M2Z2Z_S)
  .value("ADD_VG2_M2ZZ_D", LIEF::assembly::aarch64::OPCODE::ADD_VG2_M2ZZ_D)
  .value("ADD_VG2_M2ZZ_S", LIEF::assembly::aarch64::OPCODE::ADD_VG2_M2ZZ_S)
  .value("ADD_VG2_M2Z_D", LIEF::assembly::aarch64::OPCODE::ADD_VG2_M2Z_D)
  .value("ADD_VG2_M2Z_S", LIEF::assembly::aarch64::OPCODE::ADD_VG2_M2Z_S)
  .value("ADD_VG4_4ZZ_B", LIEF::assembly::aarch64::OPCODE::ADD_VG4_4ZZ_B)
  .value("ADD_VG4_4ZZ_D", LIEF::assembly::aarch64::OPCODE::ADD_VG4_4ZZ_D)
  .value("ADD_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::ADD_VG4_4ZZ_H)
  .value("ADD_VG4_4ZZ_S", LIEF::assembly::aarch64::OPCODE::ADD_VG4_4ZZ_S)
  .value("ADD_VG4_M4Z4Z_D", LIEF::assembly::aarch64::OPCODE::ADD_VG4_M4Z4Z_D)
  .value("ADD_VG4_M4Z4Z_S", LIEF::assembly::aarch64::OPCODE::ADD_VG4_M4Z4Z_S)
  .value("ADD_VG4_M4ZZ_D", LIEF::assembly::aarch64::OPCODE::ADD_VG4_M4ZZ_D)
  .value("ADD_VG4_M4ZZ_S", LIEF::assembly::aarch64::OPCODE::ADD_VG4_M4ZZ_S)
  .value("ADD_VG4_M4Z_D", LIEF::assembly::aarch64::OPCODE::ADD_VG4_M4Z_D)
  .value("ADD_VG4_M4Z_S", LIEF::assembly::aarch64::OPCODE::ADD_VG4_M4Z_S)
  .value("ADD_ZI_B", LIEF::assembly::aarch64::OPCODE::ADD_ZI_B)
  .value("ADD_ZI_D", LIEF::assembly::aarch64::OPCODE::ADD_ZI_D)
  .value("ADD_ZI_H", LIEF::assembly::aarch64::OPCODE::ADD_ZI_H)
  .value("ADD_ZI_S", LIEF::assembly::aarch64::OPCODE::ADD_ZI_S)
  .value("ADD_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::ADD_ZPmZ_B)
  .value("ADD_ZPmZ_CPA", LIEF::assembly::aarch64::OPCODE::ADD_ZPmZ_CPA)
  .value("ADD_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::ADD_ZPmZ_D)
  .value("ADD_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::ADD_ZPmZ_H)
  .value("ADD_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::ADD_ZPmZ_S)
  .value("ADD_ZZZ_B", LIEF::assembly::aarch64::OPCODE::ADD_ZZZ_B)
  .value("ADD_ZZZ_CPA", LIEF::assembly::aarch64::OPCODE::ADD_ZZZ_CPA)
  .value("ADD_ZZZ_D", LIEF::assembly::aarch64::OPCODE::ADD_ZZZ_D)
  .value("ADD_ZZZ_H", LIEF::assembly::aarch64::OPCODE::ADD_ZZZ_H)
  .value("ADD_ZZZ_S", LIEF::assembly::aarch64::OPCODE::ADD_ZZZ_S)
  .value("ADDv16i8", LIEF::assembly::aarch64::OPCODE::ADDv16i8)
  .value("ADDv1i64", LIEF::assembly::aarch64::OPCODE::ADDv1i64)
  .value("ADDv2i32", LIEF::assembly::aarch64::OPCODE::ADDv2i32)
  .value("ADDv2i64", LIEF::assembly::aarch64::OPCODE::ADDv2i64)
  .value("ADDv4i16", LIEF::assembly::aarch64::OPCODE::ADDv4i16)
  .value("ADDv4i32", LIEF::assembly::aarch64::OPCODE::ADDv4i32)
  .value("ADDv8i16", LIEF::assembly::aarch64::OPCODE::ADDv8i16)
  .value("ADDv8i8", LIEF::assembly::aarch64::OPCODE::ADDv8i8)
  .value("ADR", LIEF::assembly::aarch64::OPCODE::ADR)
  .value("ADRP", LIEF::assembly::aarch64::OPCODE::ADRP)
  .value("ADR_LSL_ZZZ_D_0", LIEF::assembly::aarch64::OPCODE::ADR_LSL_ZZZ_D_0)
  .value("ADR_LSL_ZZZ_D_1", LIEF::assembly::aarch64::OPCODE::ADR_LSL_ZZZ_D_1)
  .value("ADR_LSL_ZZZ_D_2", LIEF::assembly::aarch64::OPCODE::ADR_LSL_ZZZ_D_2)
  .value("ADR_LSL_ZZZ_D_3", LIEF::assembly::aarch64::OPCODE::ADR_LSL_ZZZ_D_3)
  .value("ADR_LSL_ZZZ_S_0", LIEF::assembly::aarch64::OPCODE::ADR_LSL_ZZZ_S_0)
  .value("ADR_LSL_ZZZ_S_1", LIEF::assembly::aarch64::OPCODE::ADR_LSL_ZZZ_S_1)
  .value("ADR_LSL_ZZZ_S_2", LIEF::assembly::aarch64::OPCODE::ADR_LSL_ZZZ_S_2)
  .value("ADR_LSL_ZZZ_S_3", LIEF::assembly::aarch64::OPCODE::ADR_LSL_ZZZ_S_3)
  .value("ADR_SXTW_ZZZ_D_0", LIEF::assembly::aarch64::OPCODE::ADR_SXTW_ZZZ_D_0)
  .value("ADR_SXTW_ZZZ_D_1", LIEF::assembly::aarch64::OPCODE::ADR_SXTW_ZZZ_D_1)
  .value("ADR_SXTW_ZZZ_D_2", LIEF::assembly::aarch64::OPCODE::ADR_SXTW_ZZZ_D_2)
  .value("ADR_SXTW_ZZZ_D_3", LIEF::assembly::aarch64::OPCODE::ADR_SXTW_ZZZ_D_3)
  .value("ADR_UXTW_ZZZ_D_0", LIEF::assembly::aarch64::OPCODE::ADR_UXTW_ZZZ_D_0)
  .value("ADR_UXTW_ZZZ_D_1", LIEF::assembly::aarch64::OPCODE::ADR_UXTW_ZZZ_D_1)
  .value("ADR_UXTW_ZZZ_D_2", LIEF::assembly::aarch64::OPCODE::ADR_UXTW_ZZZ_D_2)
  .value("ADR_UXTW_ZZZ_D_3", LIEF::assembly::aarch64::OPCODE::ADR_UXTW_ZZZ_D_3)
  .value("AESDMIC_2ZZI_B", LIEF::assembly::aarch64::OPCODE::AESDMIC_2ZZI_B)
  .value("AESDMIC_4ZZI_B", LIEF::assembly::aarch64::OPCODE::AESDMIC_4ZZI_B)
  .value("AESD_2ZZI_B", LIEF::assembly::aarch64::OPCODE::AESD_2ZZI_B)
  .value("AESD_4ZZI_B", LIEF::assembly::aarch64::OPCODE::AESD_4ZZI_B)
  .value("AESD_ZZZ_B", LIEF::assembly::aarch64::OPCODE::AESD_ZZZ_B)
  .value("AESDrr", LIEF::assembly::aarch64::OPCODE::AESDrr)
  .value("AESEMC_2ZZI_B", LIEF::assembly::aarch64::OPCODE::AESEMC_2ZZI_B)
  .value("AESEMC_4ZZI_B", LIEF::assembly::aarch64::OPCODE::AESEMC_4ZZI_B)
  .value("AESE_2ZZI_B", LIEF::assembly::aarch64::OPCODE::AESE_2ZZI_B)
  .value("AESE_4ZZI_B", LIEF::assembly::aarch64::OPCODE::AESE_4ZZI_B)
  .value("AESE_ZZZ_B", LIEF::assembly::aarch64::OPCODE::AESE_ZZZ_B)
  .value("AESErr", LIEF::assembly::aarch64::OPCODE::AESErr)
  .value("AESIMC_ZZ_B", LIEF::assembly::aarch64::OPCODE::AESIMC_ZZ_B)
  .value("AESIMCrr", LIEF::assembly::aarch64::OPCODE::AESIMCrr)
  .value("AESMC_ZZ_B", LIEF::assembly::aarch64::OPCODE::AESMC_ZZ_B)
  .value("AESMCrr", LIEF::assembly::aarch64::OPCODE::AESMCrr)
  .value("ANDQV_VPZ_B", LIEF::assembly::aarch64::OPCODE::ANDQV_VPZ_B)
  .value("ANDQV_VPZ_D", LIEF::assembly::aarch64::OPCODE::ANDQV_VPZ_D)
  .value("ANDQV_VPZ_H", LIEF::assembly::aarch64::OPCODE::ANDQV_VPZ_H)
  .value("ANDQV_VPZ_S", LIEF::assembly::aarch64::OPCODE::ANDQV_VPZ_S)
  .value("ANDSWri", LIEF::assembly::aarch64::OPCODE::ANDSWri)
  .value("ANDSWrs", LIEF::assembly::aarch64::OPCODE::ANDSWrs)
  .value("ANDSXri", LIEF::assembly::aarch64::OPCODE::ANDSXri)
  .value("ANDSXrs", LIEF::assembly::aarch64::OPCODE::ANDSXrs)
  .value("ANDS_PPzPP", LIEF::assembly::aarch64::OPCODE::ANDS_PPzPP)
  .value("ANDV_VPZ_B", LIEF::assembly::aarch64::OPCODE::ANDV_VPZ_B)
  .value("ANDV_VPZ_D", LIEF::assembly::aarch64::OPCODE::ANDV_VPZ_D)
  .value("ANDV_VPZ_H", LIEF::assembly::aarch64::OPCODE::ANDV_VPZ_H)
  .value("ANDV_VPZ_S", LIEF::assembly::aarch64::OPCODE::ANDV_VPZ_S)
  .value("ANDWri", LIEF::assembly::aarch64::OPCODE::ANDWri)
  .value("ANDWrs", LIEF::assembly::aarch64::OPCODE::ANDWrs)
  .value("ANDXri", LIEF::assembly::aarch64::OPCODE::ANDXri)
  .value("ANDXrs", LIEF::assembly::aarch64::OPCODE::ANDXrs)
  .value("AND_PPzPP", LIEF::assembly::aarch64::OPCODE::AND_PPzPP)
  .value("AND_ZI", LIEF::assembly::aarch64::OPCODE::AND_ZI)
  .value("AND_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::AND_ZPmZ_B)
  .value("AND_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::AND_ZPmZ_D)
  .value("AND_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::AND_ZPmZ_H)
  .value("AND_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::AND_ZPmZ_S)
  .value("AND_ZZZ", LIEF::assembly::aarch64::OPCODE::AND_ZZZ)
  .value("ANDv16i8", LIEF::assembly::aarch64::OPCODE::ANDv16i8)
  .value("ANDv8i8", LIEF::assembly::aarch64::OPCODE::ANDv8i8)
  .value("APAS", LIEF::assembly::aarch64::OPCODE::APAS)
  .value("ASRD_ZPmI_B", LIEF::assembly::aarch64::OPCODE::ASRD_ZPmI_B)
  .value("ASRD_ZPmI_D", LIEF::assembly::aarch64::OPCODE::ASRD_ZPmI_D)
  .value("ASRD_ZPmI_H", LIEF::assembly::aarch64::OPCODE::ASRD_ZPmI_H)
  .value("ASRD_ZPmI_S", LIEF::assembly::aarch64::OPCODE::ASRD_ZPmI_S)
  .value("ASRR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::ASRR_ZPmZ_B)
  .value("ASRR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::ASRR_ZPmZ_D)
  .value("ASRR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::ASRR_ZPmZ_H)
  .value("ASRR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::ASRR_ZPmZ_S)
  .value("ASRVWr", LIEF::assembly::aarch64::OPCODE::ASRVWr)
  .value("ASRVXr", LIEF::assembly::aarch64::OPCODE::ASRVXr)
  .value("ASR_WIDE_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::ASR_WIDE_ZPmZ_B)
  .value("ASR_WIDE_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::ASR_WIDE_ZPmZ_H)
  .value("ASR_WIDE_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::ASR_WIDE_ZPmZ_S)
  .value("ASR_WIDE_ZZZ_B", LIEF::assembly::aarch64::OPCODE::ASR_WIDE_ZZZ_B)
  .value("ASR_WIDE_ZZZ_H", LIEF::assembly::aarch64::OPCODE::ASR_WIDE_ZZZ_H)
  .value("ASR_WIDE_ZZZ_S", LIEF::assembly::aarch64::OPCODE::ASR_WIDE_ZZZ_S)
  .value("ASR_ZPmI_B", LIEF::assembly::aarch64::OPCODE::ASR_ZPmI_B)
  .value("ASR_ZPmI_D", LIEF::assembly::aarch64::OPCODE::ASR_ZPmI_D)
  .value("ASR_ZPmI_H", LIEF::assembly::aarch64::OPCODE::ASR_ZPmI_H)
  .value("ASR_ZPmI_S", LIEF::assembly::aarch64::OPCODE::ASR_ZPmI_S)
  .value("ASR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::ASR_ZPmZ_B);
  opcodes.value("ASR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::ASR_ZPmZ_D)
  .value("ASR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::ASR_ZPmZ_H)
  .value("ASR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::ASR_ZPmZ_S)
  .value("ASR_ZZI_B", LIEF::assembly::aarch64::OPCODE::ASR_ZZI_B)
  .value("ASR_ZZI_D", LIEF::assembly::aarch64::OPCODE::ASR_ZZI_D)
  .value("ASR_ZZI_H", LIEF::assembly::aarch64::OPCODE::ASR_ZZI_H)
  .value("ASR_ZZI_S", LIEF::assembly::aarch64::OPCODE::ASR_ZZI_S)
  .value("AUTDA", LIEF::assembly::aarch64::OPCODE::AUTDA)
  .value("AUTDB", LIEF::assembly::aarch64::OPCODE::AUTDB)
  .value("AUTDZA", LIEF::assembly::aarch64::OPCODE::AUTDZA)
  .value("AUTDZB", LIEF::assembly::aarch64::OPCODE::AUTDZB)
  .value("AUTIA", LIEF::assembly::aarch64::OPCODE::AUTIA)
  .value("AUTIA1716", LIEF::assembly::aarch64::OPCODE::AUTIA1716)
  .value("AUTIA171615", LIEF::assembly::aarch64::OPCODE::AUTIA171615)
  .value("AUTIASP", LIEF::assembly::aarch64::OPCODE::AUTIASP)
  .value("AUTIASPPCi", LIEF::assembly::aarch64::OPCODE::AUTIASPPCi)
  .value("AUTIASPPCr", LIEF::assembly::aarch64::OPCODE::AUTIASPPCr)
  .value("AUTIAZ", LIEF::assembly::aarch64::OPCODE::AUTIAZ)
  .value("AUTIB", LIEF::assembly::aarch64::OPCODE::AUTIB)
  .value("AUTIB1716", LIEF::assembly::aarch64::OPCODE::AUTIB1716)
  .value("AUTIB171615", LIEF::assembly::aarch64::OPCODE::AUTIB171615)
  .value("AUTIBSP", LIEF::assembly::aarch64::OPCODE::AUTIBSP)
  .value("AUTIBSPPCi", LIEF::assembly::aarch64::OPCODE::AUTIBSPPCi)
  .value("AUTIBSPPCr", LIEF::assembly::aarch64::OPCODE::AUTIBSPPCr)
  .value("AUTIBZ", LIEF::assembly::aarch64::OPCODE::AUTIBZ)
  .value("AUTIZA", LIEF::assembly::aarch64::OPCODE::AUTIZA)
  .value("AUTIZB", LIEF::assembly::aarch64::OPCODE::AUTIZB)
  .value("AXFLAG", LIEF::assembly::aarch64::OPCODE::AXFLAG)
  .value("B", LIEF::assembly::aarch64::OPCODE::B)
  .value("BCAX", LIEF::assembly::aarch64::OPCODE::BCAX)
  .value("BCAX_ZZZZ", LIEF::assembly::aarch64::OPCODE::BCAX_ZZZZ)
  .value("BCcc", LIEF::assembly::aarch64::OPCODE::BCcc)
  .value("BDEP_ZZZ_B", LIEF::assembly::aarch64::OPCODE::BDEP_ZZZ_B)
  .value("BDEP_ZZZ_D", LIEF::assembly::aarch64::OPCODE::BDEP_ZZZ_D)
  .value("BDEP_ZZZ_H", LIEF::assembly::aarch64::OPCODE::BDEP_ZZZ_H)
  .value("BDEP_ZZZ_S", LIEF::assembly::aarch64::OPCODE::BDEP_ZZZ_S)
  .value("BEXT_ZZZ_B", LIEF::assembly::aarch64::OPCODE::BEXT_ZZZ_B)
  .value("BEXT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::BEXT_ZZZ_D)
  .value("BEXT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::BEXT_ZZZ_H)
  .value("BEXT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::BEXT_ZZZ_S)
  .value("BF16DOTlanev4bf16", LIEF::assembly::aarch64::OPCODE::BF16DOTlanev4bf16)
  .value("BF16DOTlanev8bf16", LIEF::assembly::aarch64::OPCODE::BF16DOTlanev8bf16)
  .value("BF1CVTL", LIEF::assembly::aarch64::OPCODE::BF1CVTL)
  .value("BF1CVTL2", LIEF::assembly::aarch64::OPCODE::BF1CVTL2)
  .value("BF1CVTLT_ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::BF1CVTLT_ZZ_BtoH)
  .value("BF1CVTL_2ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::BF1CVTL_2ZZ_BtoH)
  .value("BF1CVT_2ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::BF1CVT_2ZZ_BtoH)
  .value("BF1CVT_ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::BF1CVT_ZZ_BtoH)
  .value("BF2CVTL", LIEF::assembly::aarch64::OPCODE::BF2CVTL)
  .value("BF2CVTL2", LIEF::assembly::aarch64::OPCODE::BF2CVTL2)
  .value("BF2CVTLT_ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::BF2CVTLT_ZZ_BtoH)
  .value("BF2CVTL_2ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::BF2CVTL_2ZZ_BtoH)
  .value("BF2CVT_2ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::BF2CVT_2ZZ_BtoH)
  .value("BF2CVT_ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::BF2CVT_ZZ_BtoH)
  .value("BFADD_VG2_M2Z_H", LIEF::assembly::aarch64::OPCODE::BFADD_VG2_M2Z_H)
  .value("BFADD_VG4_M4Z_H", LIEF::assembly::aarch64::OPCODE::BFADD_VG4_M4Z_H)
  .value("BFADD_ZPmZZ", LIEF::assembly::aarch64::OPCODE::BFADD_ZPmZZ)
  .value("BFADD_ZZZ", LIEF::assembly::aarch64::OPCODE::BFADD_ZZZ)
  .value("BFCLAMP_VG2_2ZZZ_H", LIEF::assembly::aarch64::OPCODE::BFCLAMP_VG2_2ZZZ_H)
  .value("BFCLAMP_VG4_4ZZZ_H", LIEF::assembly::aarch64::OPCODE::BFCLAMP_VG4_4ZZZ_H)
  .value("BFCLAMP_ZZZ", LIEF::assembly::aarch64::OPCODE::BFCLAMP_ZZZ)
  .value("BFCVT", LIEF::assembly::aarch64::OPCODE::BFCVT)
  .value("BFCVTN", LIEF::assembly::aarch64::OPCODE::BFCVTN)
  .value("BFCVTN2", LIEF::assembly::aarch64::OPCODE::BFCVTN2)
  .value("BFCVTNT_ZPmZ", LIEF::assembly::aarch64::OPCODE::BFCVTNT_ZPmZ)
  .value("BFCVTNT_ZPzZ", LIEF::assembly::aarch64::OPCODE::BFCVTNT_ZPzZ)
  .value("BFCVTN_Z2Z_HtoB", LIEF::assembly::aarch64::OPCODE::BFCVTN_Z2Z_HtoB)
  .value("BFCVTN_Z2Z_StoH", LIEF::assembly::aarch64::OPCODE::BFCVTN_Z2Z_StoH)
  .value("BFCVT_Z2Z_HtoB", LIEF::assembly::aarch64::OPCODE::BFCVT_Z2Z_HtoB)
  .value("BFCVT_Z2Z_StoH", LIEF::assembly::aarch64::OPCODE::BFCVT_Z2Z_StoH)
  .value("BFCVT_ZPmZ", LIEF::assembly::aarch64::OPCODE::BFCVT_ZPmZ)
  .value("BFCVT_ZPzZ_StoH", LIEF::assembly::aarch64::OPCODE::BFCVT_ZPzZ_StoH)
  .value("BFDOT_VG2_M2Z2Z_HtoS", LIEF::assembly::aarch64::OPCODE::BFDOT_VG2_M2Z2Z_HtoS)
  .value("BFDOT_VG2_M2ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::BFDOT_VG2_M2ZZI_HtoS)
  .value("BFDOT_VG2_M2ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::BFDOT_VG2_M2ZZ_HtoS)
  .value("BFDOT_VG4_M4Z4Z_HtoS", LIEF::assembly::aarch64::OPCODE::BFDOT_VG4_M4Z4Z_HtoS)
  .value("BFDOT_VG4_M4ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::BFDOT_VG4_M4ZZI_HtoS)
  .value("BFDOT_VG4_M4ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::BFDOT_VG4_M4ZZ_HtoS)
  .value("BFDOT_ZZI", LIEF::assembly::aarch64::OPCODE::BFDOT_ZZI)
  .value("BFDOT_ZZZ", LIEF::assembly::aarch64::OPCODE::BFDOT_ZZZ)
  .value("BFDOTv4bf16", LIEF::assembly::aarch64::OPCODE::BFDOTv4bf16)
  .value("BFDOTv8bf16", LIEF::assembly::aarch64::OPCODE::BFDOTv8bf16)
  .value("BFMAXNM_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::BFMAXNM_VG2_2Z2Z_H)
  .value("BFMAXNM_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::BFMAXNM_VG2_2ZZ_H)
  .value("BFMAXNM_VG4_4Z2Z_H", LIEF::assembly::aarch64::OPCODE::BFMAXNM_VG4_4Z2Z_H)
  .value("BFMAXNM_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::BFMAXNM_VG4_4ZZ_H)
  .value("BFMAXNM_ZPmZZ", LIEF::assembly::aarch64::OPCODE::BFMAXNM_ZPmZZ)
  .value("BFMAX_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::BFMAX_VG2_2Z2Z_H)
  .value("BFMAX_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::BFMAX_VG2_2ZZ_H)
  .value("BFMAX_VG4_4Z2Z_H", LIEF::assembly::aarch64::OPCODE::BFMAX_VG4_4Z2Z_H)
  .value("BFMAX_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::BFMAX_VG4_4ZZ_H)
  .value("BFMAX_ZPmZZ", LIEF::assembly::aarch64::OPCODE::BFMAX_ZPmZZ)
  .value("BFMINNM_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::BFMINNM_VG2_2Z2Z_H)
  .value("BFMINNM_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::BFMINNM_VG2_2ZZ_H)
  .value("BFMINNM_VG4_4Z2Z_H", LIEF::assembly::aarch64::OPCODE::BFMINNM_VG4_4Z2Z_H)
  .value("BFMINNM_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::BFMINNM_VG4_4ZZ_H)
  .value("BFMINNM_ZPmZZ", LIEF::assembly::aarch64::OPCODE::BFMINNM_ZPmZZ)
  .value("BFMIN_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::BFMIN_VG2_2Z2Z_H)
  .value("BFMIN_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::BFMIN_VG2_2ZZ_H)
  .value("BFMIN_VG4_4Z2Z_H", LIEF::assembly::aarch64::OPCODE::BFMIN_VG4_4Z2Z_H)
  .value("BFMIN_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::BFMIN_VG4_4ZZ_H)
  .value("BFMIN_ZPmZZ", LIEF::assembly::aarch64::OPCODE::BFMIN_ZPmZZ)
  .value("BFMLALB", LIEF::assembly::aarch64::OPCODE::BFMLALB)
  .value("BFMLALBIdx", LIEF::assembly::aarch64::OPCODE::BFMLALBIdx)
  .value("BFMLALB_ZZZ", LIEF::assembly::aarch64::OPCODE::BFMLALB_ZZZ)
  .value("BFMLALB_ZZZI", LIEF::assembly::aarch64::OPCODE::BFMLALB_ZZZI)
  .value("BFMLALT", LIEF::assembly::aarch64::OPCODE::BFMLALT)
  .value("BFMLALTIdx", LIEF::assembly::aarch64::OPCODE::BFMLALTIdx)
  .value("BFMLALT_ZZZ", LIEF::assembly::aarch64::OPCODE::BFMLALT_ZZZ)
  .value("BFMLALT_ZZZI", LIEF::assembly::aarch64::OPCODE::BFMLALT_ZZZI)
  .value("BFMLAL_MZZI_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLAL_MZZI_HtoS)
  .value("BFMLAL_MZZ_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLAL_MZZ_HtoS)
  .value("BFMLAL_VG2_M2Z2Z_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLAL_VG2_M2Z2Z_HtoS)
  .value("BFMLAL_VG2_M2ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLAL_VG2_M2ZZI_HtoS)
  .value("BFMLAL_VG2_M2ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLAL_VG2_M2ZZ_HtoS)
  .value("BFMLAL_VG4_M4Z4Z_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLAL_VG4_M4Z4Z_HtoS)
  .value("BFMLAL_VG4_M4ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLAL_VG4_M4ZZI_HtoS)
  .value("BFMLAL_VG4_M4ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLAL_VG4_M4ZZ_HtoS)
  .value("BFMLA_VG2_M2Z2Z", LIEF::assembly::aarch64::OPCODE::BFMLA_VG2_M2Z2Z)
  .value("BFMLA_VG2_M2ZZ", LIEF::assembly::aarch64::OPCODE::BFMLA_VG2_M2ZZ)
  .value("BFMLA_VG2_M2ZZI", LIEF::assembly::aarch64::OPCODE::BFMLA_VG2_M2ZZI)
  .value("BFMLA_VG4_M4Z4Z", LIEF::assembly::aarch64::OPCODE::BFMLA_VG4_M4Z4Z)
  .value("BFMLA_VG4_M4ZZ", LIEF::assembly::aarch64::OPCODE::BFMLA_VG4_M4ZZ)
  .value("BFMLA_VG4_M4ZZI", LIEF::assembly::aarch64::OPCODE::BFMLA_VG4_M4ZZI)
  .value("BFMLA_ZPmZZ", LIEF::assembly::aarch64::OPCODE::BFMLA_ZPmZZ)
  .value("BFMLA_ZZZI", LIEF::assembly::aarch64::OPCODE::BFMLA_ZZZI)
  .value("BFMLSLB_ZZZI_S", LIEF::assembly::aarch64::OPCODE::BFMLSLB_ZZZI_S)
  .value("BFMLSLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::BFMLSLB_ZZZ_S)
  .value("BFMLSLT_ZZZI_S", LIEF::assembly::aarch64::OPCODE::BFMLSLT_ZZZI_S)
  .value("BFMLSLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::BFMLSLT_ZZZ_S)
  .value("BFMLSL_MZZI_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLSL_MZZI_HtoS)
  .value("BFMLSL_MZZ_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLSL_MZZ_HtoS)
  .value("BFMLSL_VG2_M2Z2Z_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLSL_VG2_M2Z2Z_HtoS)
  .value("BFMLSL_VG2_M2ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLSL_VG2_M2ZZI_HtoS)
  .value("BFMLSL_VG2_M2ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLSL_VG2_M2ZZ_HtoS)
  .value("BFMLSL_VG4_M4Z4Z_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLSL_VG4_M4Z4Z_HtoS)
  .value("BFMLSL_VG4_M4ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLSL_VG4_M4ZZI_HtoS)
  .value("BFMLSL_VG4_M4ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::BFMLSL_VG4_M4ZZ_HtoS)
  .value("BFMLS_VG2_M2Z2Z", LIEF::assembly::aarch64::OPCODE::BFMLS_VG2_M2Z2Z)
  .value("BFMLS_VG2_M2ZZ", LIEF::assembly::aarch64::OPCODE::BFMLS_VG2_M2ZZ)
  .value("BFMLS_VG2_M2ZZI", LIEF::assembly::aarch64::OPCODE::BFMLS_VG2_M2ZZI)
  .value("BFMLS_VG4_M4Z4Z", LIEF::assembly::aarch64::OPCODE::BFMLS_VG4_M4Z4Z)
  .value("BFMLS_VG4_M4ZZ", LIEF::assembly::aarch64::OPCODE::BFMLS_VG4_M4ZZ)
  .value("BFMLS_VG4_M4ZZI", LIEF::assembly::aarch64::OPCODE::BFMLS_VG4_M4ZZI)
  .value("BFMLS_ZPmZZ", LIEF::assembly::aarch64::OPCODE::BFMLS_ZPmZZ)
  .value("BFMLS_ZZZI", LIEF::assembly::aarch64::OPCODE::BFMLS_ZZZI)
  .value("BFMMLA", LIEF::assembly::aarch64::OPCODE::BFMMLA)
  .value("BFMMLA_ZZZ", LIEF::assembly::aarch64::OPCODE::BFMMLA_ZZZ)
  .value("BFMOP4A_M2Z2Z_H", LIEF::assembly::aarch64::OPCODE::BFMOP4A_M2Z2Z_H)
  .value("BFMOP4A_M2Z2Z_S", LIEF::assembly::aarch64::OPCODE::BFMOP4A_M2Z2Z_S)
  .value("BFMOP4A_M2ZZ_H", LIEF::assembly::aarch64::OPCODE::BFMOP4A_M2ZZ_H)
  .value("BFMOP4A_M2ZZ_S", LIEF::assembly::aarch64::OPCODE::BFMOP4A_M2ZZ_S)
  .value("BFMOP4A_MZ2Z_H", LIEF::assembly::aarch64::OPCODE::BFMOP4A_MZ2Z_H)
  .value("BFMOP4A_MZ2Z_S", LIEF::assembly::aarch64::OPCODE::BFMOP4A_MZ2Z_S)
  .value("BFMOP4A_MZZ_H", LIEF::assembly::aarch64::OPCODE::BFMOP4A_MZZ_H)
  .value("BFMOP4A_MZZ_S", LIEF::assembly::aarch64::OPCODE::BFMOP4A_MZZ_S)
  .value("BFMOP4S_M2Z2Z_H", LIEF::assembly::aarch64::OPCODE::BFMOP4S_M2Z2Z_H)
  .value("BFMOP4S_M2Z2Z_S", LIEF::assembly::aarch64::OPCODE::BFMOP4S_M2Z2Z_S)
  .value("BFMOP4S_M2ZZ_H", LIEF::assembly::aarch64::OPCODE::BFMOP4S_M2ZZ_H)
  .value("BFMOP4S_M2ZZ_S", LIEF::assembly::aarch64::OPCODE::BFMOP4S_M2ZZ_S)
  .value("BFMOP4S_MZ2Z_H", LIEF::assembly::aarch64::OPCODE::BFMOP4S_MZ2Z_H)
  .value("BFMOP4S_MZ2Z_S", LIEF::assembly::aarch64::OPCODE::BFMOP4S_MZ2Z_S)
  .value("BFMOP4S_MZZ_H", LIEF::assembly::aarch64::OPCODE::BFMOP4S_MZZ_H)
  .value("BFMOP4S_MZZ_S", LIEF::assembly::aarch64::OPCODE::BFMOP4S_MZZ_S)
  .value("BFMOPA_MPPZZ", LIEF::assembly::aarch64::OPCODE::BFMOPA_MPPZZ)
  .value("BFMOPA_MPPZZ_H", LIEF::assembly::aarch64::OPCODE::BFMOPA_MPPZZ_H)
  .value("BFMOPS_MPPZZ", LIEF::assembly::aarch64::OPCODE::BFMOPS_MPPZZ)
  .value("BFMOPS_MPPZZ_H", LIEF::assembly::aarch64::OPCODE::BFMOPS_MPPZZ_H)
  .value("BFMUL_2Z2Z", LIEF::assembly::aarch64::OPCODE::BFMUL_2Z2Z)
  .value("BFMUL_2ZZ", LIEF::assembly::aarch64::OPCODE::BFMUL_2ZZ)
  .value("BFMUL_4Z4Z", LIEF::assembly::aarch64::OPCODE::BFMUL_4Z4Z)
  .value("BFMUL_4ZZ", LIEF::assembly::aarch64::OPCODE::BFMUL_4ZZ)
  .value("BFMUL_ZPmZZ", LIEF::assembly::aarch64::OPCODE::BFMUL_ZPmZZ)
  .value("BFMUL_ZZZ", LIEF::assembly::aarch64::OPCODE::BFMUL_ZZZ)
  .value("BFMUL_ZZZI", LIEF::assembly::aarch64::OPCODE::BFMUL_ZZZI)
  .value("BFMWri", LIEF::assembly::aarch64::OPCODE::BFMWri)
  .value("BFMXri", LIEF::assembly::aarch64::OPCODE::BFMXri)
  .value("BFSCALE_2Z2Z", LIEF::assembly::aarch64::OPCODE::BFSCALE_2Z2Z)
  .value("BFSCALE_2ZZ", LIEF::assembly::aarch64::OPCODE::BFSCALE_2ZZ)
  .value("BFSCALE_4Z4Z", LIEF::assembly::aarch64::OPCODE::BFSCALE_4Z4Z)
  .value("BFSCALE_4ZZ", LIEF::assembly::aarch64::OPCODE::BFSCALE_4ZZ)
  .value("BFSCALE_ZPZZ", LIEF::assembly::aarch64::OPCODE::BFSCALE_ZPZZ)
  .value("BFSUB_VG2_M2Z_H", LIEF::assembly::aarch64::OPCODE::BFSUB_VG2_M2Z_H)
  .value("BFSUB_VG4_M4Z_H", LIEF::assembly::aarch64::OPCODE::BFSUB_VG4_M4Z_H)
  .value("BFSUB_ZPmZZ", LIEF::assembly::aarch64::OPCODE::BFSUB_ZPmZZ)
  .value("BFSUB_ZZZ", LIEF::assembly::aarch64::OPCODE::BFSUB_ZZZ)
  .value("BFTMOPA_M2ZZZI_HtoH", LIEF::assembly::aarch64::OPCODE::BFTMOPA_M2ZZZI_HtoH)
  .value("BFTMOPA_M2ZZZI_HtoS", LIEF::assembly::aarch64::OPCODE::BFTMOPA_M2ZZZI_HtoS)
  .value("BFVDOT_VG2_M2ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::BFVDOT_VG2_M2ZZI_HtoS)
  .value("BGRP_ZZZ_B", LIEF::assembly::aarch64::OPCODE::BGRP_ZZZ_B)
  .value("BGRP_ZZZ_D", LIEF::assembly::aarch64::OPCODE::BGRP_ZZZ_D)
  .value("BGRP_ZZZ_H", LIEF::assembly::aarch64::OPCODE::BGRP_ZZZ_H)
  .value("BGRP_ZZZ_S", LIEF::assembly::aarch64::OPCODE::BGRP_ZZZ_S)
  .value("BICSWrs", LIEF::assembly::aarch64::OPCODE::BICSWrs)
  .value("BICSXrs", LIEF::assembly::aarch64::OPCODE::BICSXrs)
  .value("BICS_PPzPP", LIEF::assembly::aarch64::OPCODE::BICS_PPzPP)
  .value("BICWrs", LIEF::assembly::aarch64::OPCODE::BICWrs)
  .value("BICXrs", LIEF::assembly::aarch64::OPCODE::BICXrs)
  .value("BIC_PPzPP", LIEF::assembly::aarch64::OPCODE::BIC_PPzPP)
  .value("BIC_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::BIC_ZPmZ_B)
  .value("BIC_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::BIC_ZPmZ_D)
  .value("BIC_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::BIC_ZPmZ_H)
  .value("BIC_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::BIC_ZPmZ_S)
  .value("BIC_ZZZ", LIEF::assembly::aarch64::OPCODE::BIC_ZZZ)
  .value("BICv16i8", LIEF::assembly::aarch64::OPCODE::BICv16i8)
  .value("BICv2i32", LIEF::assembly::aarch64::OPCODE::BICv2i32)
  .value("BICv4i16", LIEF::assembly::aarch64::OPCODE::BICv4i16)
  .value("BICv4i32", LIEF::assembly::aarch64::OPCODE::BICv4i32)
  .value("BICv8i16", LIEF::assembly::aarch64::OPCODE::BICv8i16)
  .value("BICv8i8", LIEF::assembly::aarch64::OPCODE::BICv8i8)
  .value("BIFv16i8", LIEF::assembly::aarch64::OPCODE::BIFv16i8)
  .value("BIFv8i8", LIEF::assembly::aarch64::OPCODE::BIFv8i8)
  .value("BITv16i8", LIEF::assembly::aarch64::OPCODE::BITv16i8)
  .value("BITv8i8", LIEF::assembly::aarch64::OPCODE::BITv8i8)
  .value("BL", LIEF::assembly::aarch64::OPCODE::BL)
  .value("BLR", LIEF::assembly::aarch64::OPCODE::BLR)
  .value("BLRAA", LIEF::assembly::aarch64::OPCODE::BLRAA)
  .value("BLRAAZ", LIEF::assembly::aarch64::OPCODE::BLRAAZ)
  .value("BLRAB", LIEF::assembly::aarch64::OPCODE::BLRAB)
  .value("BLRABZ", LIEF::assembly::aarch64::OPCODE::BLRABZ)
  .value("BMOPA_MPPZZ_S", LIEF::assembly::aarch64::OPCODE::BMOPA_MPPZZ_S)
  .value("BMOPS_MPPZZ_S", LIEF::assembly::aarch64::OPCODE::BMOPS_MPPZZ_S)
  .value("BR", LIEF::assembly::aarch64::OPCODE::BR)
  .value("BRAA", LIEF::assembly::aarch64::OPCODE::BRAA)
  .value("BRAAZ", LIEF::assembly::aarch64::OPCODE::BRAAZ)
  .value("BRAB", LIEF::assembly::aarch64::OPCODE::BRAB)
  .value("BRABZ", LIEF::assembly::aarch64::OPCODE::BRABZ)
  .value("BRB_IALL", LIEF::assembly::aarch64::OPCODE::BRB_IALL)
  .value("BRB_INJ", LIEF::assembly::aarch64::OPCODE::BRB_INJ)
  .value("BRK", LIEF::assembly::aarch64::OPCODE::BRK)
  .value("BRKAS_PPzP", LIEF::assembly::aarch64::OPCODE::BRKAS_PPzP)
  .value("BRKA_PPmP", LIEF::assembly::aarch64::OPCODE::BRKA_PPmP)
  .value("BRKA_PPzP", LIEF::assembly::aarch64::OPCODE::BRKA_PPzP)
  .value("BRKBS_PPzP", LIEF::assembly::aarch64::OPCODE::BRKBS_PPzP)
  .value("BRKB_PPmP", LIEF::assembly::aarch64::OPCODE::BRKB_PPmP)
  .value("BRKB_PPzP", LIEF::assembly::aarch64::OPCODE::BRKB_PPzP)
  .value("BRKNS_PPzP", LIEF::assembly::aarch64::OPCODE::BRKNS_PPzP)
  .value("BRKN_PPzP", LIEF::assembly::aarch64::OPCODE::BRKN_PPzP)
  .value("BRKPAS_PPzPP", LIEF::assembly::aarch64::OPCODE::BRKPAS_PPzPP)
  .value("BRKPA_PPzPP", LIEF::assembly::aarch64::OPCODE::BRKPA_PPzPP)
  .value("BRKPBS_PPzPP", LIEF::assembly::aarch64::OPCODE::BRKPBS_PPzPP)
  .value("BRKPB_PPzPP", LIEF::assembly::aarch64::OPCODE::BRKPB_PPzPP)
  .value("BSL1N_ZZZZ", LIEF::assembly::aarch64::OPCODE::BSL1N_ZZZZ)
  .value("BSL2N_ZZZZ", LIEF::assembly::aarch64::OPCODE::BSL2N_ZZZZ)
  .value("BSL_ZZZZ", LIEF::assembly::aarch64::OPCODE::BSL_ZZZZ)
  .value("BSLv16i8", LIEF::assembly::aarch64::OPCODE::BSLv16i8)
  .value("BSLv8i8", LIEF::assembly::aarch64::OPCODE::BSLv8i8)
  .value("Bcc", LIEF::assembly::aarch64::OPCODE::Bcc)
  .value("CADD_ZZI_B", LIEF::assembly::aarch64::OPCODE::CADD_ZZI_B)
  .value("CADD_ZZI_D", LIEF::assembly::aarch64::OPCODE::CADD_ZZI_D)
  .value("CADD_ZZI_H", LIEF::assembly::aarch64::OPCODE::CADD_ZZI_H)
  .value("CADD_ZZI_S", LIEF::assembly::aarch64::OPCODE::CADD_ZZI_S)
  .value("CASAB", LIEF::assembly::aarch64::OPCODE::CASAB)
  .value("CASAH", LIEF::assembly::aarch64::OPCODE::CASAH)
  .value("CASALB", LIEF::assembly::aarch64::OPCODE::CASALB)
  .value("CASALH", LIEF::assembly::aarch64::OPCODE::CASALH)
  .value("CASALTX", LIEF::assembly::aarch64::OPCODE::CASALTX)
  .value("CASALW", LIEF::assembly::aarch64::OPCODE::CASALW)
  .value("CASALX", LIEF::assembly::aarch64::OPCODE::CASALX)
  .value("CASATX", LIEF::assembly::aarch64::OPCODE::CASATX)
  .value("CASAW", LIEF::assembly::aarch64::OPCODE::CASAW)
  .value("CASAX", LIEF::assembly::aarch64::OPCODE::CASAX)
  .value("CASB", LIEF::assembly::aarch64::OPCODE::CASB)
  .value("CASH", LIEF::assembly::aarch64::OPCODE::CASH)
  .value("CASLB", LIEF::assembly::aarch64::OPCODE::CASLB)
  .value("CASLH", LIEF::assembly::aarch64::OPCODE::CASLH)
  .value("CASLTX", LIEF::assembly::aarch64::OPCODE::CASLTX)
  .value("CASLW", LIEF::assembly::aarch64::OPCODE::CASLW)
  .value("CASLX", LIEF::assembly::aarch64::OPCODE::CASLX)
  .value("CASPALTX", LIEF::assembly::aarch64::OPCODE::CASPALTX)
  .value("CASPALW", LIEF::assembly::aarch64::OPCODE::CASPALW)
  .value("CASPALX", LIEF::assembly::aarch64::OPCODE::CASPALX)
  .value("CASPATX", LIEF::assembly::aarch64::OPCODE::CASPATX)
  .value("CASPAW", LIEF::assembly::aarch64::OPCODE::CASPAW)
  .value("CASPAX", LIEF::assembly::aarch64::OPCODE::CASPAX)
  .value("CASPLTX", LIEF::assembly::aarch64::OPCODE::CASPLTX)
  .value("CASPLW", LIEF::assembly::aarch64::OPCODE::CASPLW)
  .value("CASPLX", LIEF::assembly::aarch64::OPCODE::CASPLX)
  .value("CASPTX", LIEF::assembly::aarch64::OPCODE::CASPTX)
  .value("CASPW", LIEF::assembly::aarch64::OPCODE::CASPW)
  .value("CASPX", LIEF::assembly::aarch64::OPCODE::CASPX)
  .value("CASTX", LIEF::assembly::aarch64::OPCODE::CASTX)
  .value("CASW", LIEF::assembly::aarch64::OPCODE::CASW)
  .value("CASX", LIEF::assembly::aarch64::OPCODE::CASX)
  .value("CBBEQWrr", LIEF::assembly::aarch64::OPCODE::CBBEQWrr)
  .value("CBBGEWrr", LIEF::assembly::aarch64::OPCODE::CBBGEWrr)
  .value("CBBGTWrr", LIEF::assembly::aarch64::OPCODE::CBBGTWrr)
  .value("CBBHIWrr", LIEF::assembly::aarch64::OPCODE::CBBHIWrr)
  .value("CBBHSWrr", LIEF::assembly::aarch64::OPCODE::CBBHSWrr)
  .value("CBBNEWrr", LIEF::assembly::aarch64::OPCODE::CBBNEWrr)
  .value("CBEQWri", LIEF::assembly::aarch64::OPCODE::CBEQWri)
  .value("CBEQWrr", LIEF::assembly::aarch64::OPCODE::CBEQWrr)
  .value("CBEQXri", LIEF::assembly::aarch64::OPCODE::CBEQXri)
  .value("CBEQXrr", LIEF::assembly::aarch64::OPCODE::CBEQXrr)
  .value("CBGEWrr", LIEF::assembly::aarch64::OPCODE::CBGEWrr)
  .value("CBGEXrr", LIEF::assembly::aarch64::OPCODE::CBGEXrr)
  .value("CBGTWri", LIEF::assembly::aarch64::OPCODE::CBGTWri)
  .value("CBGTWrr", LIEF::assembly::aarch64::OPCODE::CBGTWrr)
  .value("CBGTXri", LIEF::assembly::aarch64::OPCODE::CBGTXri)
  .value("CBGTXrr", LIEF::assembly::aarch64::OPCODE::CBGTXrr);
  opcodes.value("CBHEQWrr", LIEF::assembly::aarch64::OPCODE::CBHEQWrr)
  .value("CBHGEWrr", LIEF::assembly::aarch64::OPCODE::CBHGEWrr)
  .value("CBHGTWrr", LIEF::assembly::aarch64::OPCODE::CBHGTWrr)
  .value("CBHHIWrr", LIEF::assembly::aarch64::OPCODE::CBHHIWrr)
  .value("CBHHSWrr", LIEF::assembly::aarch64::OPCODE::CBHHSWrr)
  .value("CBHIWri", LIEF::assembly::aarch64::OPCODE::CBHIWri)
  .value("CBHIWrr", LIEF::assembly::aarch64::OPCODE::CBHIWrr)
  .value("CBHIXri", LIEF::assembly::aarch64::OPCODE::CBHIXri)
  .value("CBHIXrr", LIEF::assembly::aarch64::OPCODE::CBHIXrr)
  .value("CBHNEWrr", LIEF::assembly::aarch64::OPCODE::CBHNEWrr)
  .value("CBHSWrr", LIEF::assembly::aarch64::OPCODE::CBHSWrr)
  .value("CBHSXrr", LIEF::assembly::aarch64::OPCODE::CBHSXrr)
  .value("CBLOWri", LIEF::assembly::aarch64::OPCODE::CBLOWri)
  .value("CBLOXri", LIEF::assembly::aarch64::OPCODE::CBLOXri)
  .value("CBLTWri", LIEF::assembly::aarch64::OPCODE::CBLTWri)
  .value("CBLTXri", LIEF::assembly::aarch64::OPCODE::CBLTXri)
  .value("CBNEWri", LIEF::assembly::aarch64::OPCODE::CBNEWri)
  .value("CBNEWrr", LIEF::assembly::aarch64::OPCODE::CBNEWrr)
  .value("CBNEXri", LIEF::assembly::aarch64::OPCODE::CBNEXri)
  .value("CBNEXrr", LIEF::assembly::aarch64::OPCODE::CBNEXrr)
  .value("CBNZW", LIEF::assembly::aarch64::OPCODE::CBNZW)
  .value("CBNZX", LIEF::assembly::aarch64::OPCODE::CBNZX)
  .value("CBZW", LIEF::assembly::aarch64::OPCODE::CBZW)
  .value("CBZX", LIEF::assembly::aarch64::OPCODE::CBZX)
  .value("CCMNWi", LIEF::assembly::aarch64::OPCODE::CCMNWi)
  .value("CCMNWr", LIEF::assembly::aarch64::OPCODE::CCMNWr)
  .value("CCMNXi", LIEF::assembly::aarch64::OPCODE::CCMNXi)
  .value("CCMNXr", LIEF::assembly::aarch64::OPCODE::CCMNXr)
  .value("CCMPWi", LIEF::assembly::aarch64::OPCODE::CCMPWi)
  .value("CCMPWr", LIEF::assembly::aarch64::OPCODE::CCMPWr)
  .value("CCMPXi", LIEF::assembly::aarch64::OPCODE::CCMPXi)
  .value("CCMPXr", LIEF::assembly::aarch64::OPCODE::CCMPXr)
  .value("CDOT_ZZZI_D", LIEF::assembly::aarch64::OPCODE::CDOT_ZZZI_D)
  .value("CDOT_ZZZI_S", LIEF::assembly::aarch64::OPCODE::CDOT_ZZZI_S)
  .value("CDOT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::CDOT_ZZZ_D)
  .value("CDOT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::CDOT_ZZZ_S)
  .value("CFINV", LIEF::assembly::aarch64::OPCODE::CFINV)
  .value("CHKFEAT", LIEF::assembly::aarch64::OPCODE::CHKFEAT)
  .value("CLASTA_RPZ_B", LIEF::assembly::aarch64::OPCODE::CLASTA_RPZ_B)
  .value("CLASTA_RPZ_D", LIEF::assembly::aarch64::OPCODE::CLASTA_RPZ_D)
  .value("CLASTA_RPZ_H", LIEF::assembly::aarch64::OPCODE::CLASTA_RPZ_H)
  .value("CLASTA_RPZ_S", LIEF::assembly::aarch64::OPCODE::CLASTA_RPZ_S)
  .value("CLASTA_VPZ_B", LIEF::assembly::aarch64::OPCODE::CLASTA_VPZ_B)
  .value("CLASTA_VPZ_D", LIEF::assembly::aarch64::OPCODE::CLASTA_VPZ_D)
  .value("CLASTA_VPZ_H", LIEF::assembly::aarch64::OPCODE::CLASTA_VPZ_H)
  .value("CLASTA_VPZ_S", LIEF::assembly::aarch64::OPCODE::CLASTA_VPZ_S)
  .value("CLASTA_ZPZ_B", LIEF::assembly::aarch64::OPCODE::CLASTA_ZPZ_B)
  .value("CLASTA_ZPZ_D", LIEF::assembly::aarch64::OPCODE::CLASTA_ZPZ_D)
  .value("CLASTA_ZPZ_H", LIEF::assembly::aarch64::OPCODE::CLASTA_ZPZ_H)
  .value("CLASTA_ZPZ_S", LIEF::assembly::aarch64::OPCODE::CLASTA_ZPZ_S)
  .value("CLASTB_RPZ_B", LIEF::assembly::aarch64::OPCODE::CLASTB_RPZ_B)
  .value("CLASTB_RPZ_D", LIEF::assembly::aarch64::OPCODE::CLASTB_RPZ_D)
  .value("CLASTB_RPZ_H", LIEF::assembly::aarch64::OPCODE::CLASTB_RPZ_H)
  .value("CLASTB_RPZ_S", LIEF::assembly::aarch64::OPCODE::CLASTB_RPZ_S)
  .value("CLASTB_VPZ_B", LIEF::assembly::aarch64::OPCODE::CLASTB_VPZ_B)
  .value("CLASTB_VPZ_D", LIEF::assembly::aarch64::OPCODE::CLASTB_VPZ_D)
  .value("CLASTB_VPZ_H", LIEF::assembly::aarch64::OPCODE::CLASTB_VPZ_H)
  .value("CLASTB_VPZ_S", LIEF::assembly::aarch64::OPCODE::CLASTB_VPZ_S)
  .value("CLASTB_ZPZ_B", LIEF::assembly::aarch64::OPCODE::CLASTB_ZPZ_B)
  .value("CLASTB_ZPZ_D", LIEF::assembly::aarch64::OPCODE::CLASTB_ZPZ_D)
  .value("CLASTB_ZPZ_H", LIEF::assembly::aarch64::OPCODE::CLASTB_ZPZ_H)
  .value("CLASTB_ZPZ_S", LIEF::assembly::aarch64::OPCODE::CLASTB_ZPZ_S)
  .value("CLREX", LIEF::assembly::aarch64::OPCODE::CLREX)
  .value("CLSWr", LIEF::assembly::aarch64::OPCODE::CLSWr)
  .value("CLSXr", LIEF::assembly::aarch64::OPCODE::CLSXr)
  .value("CLS_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::CLS_ZPmZ_B)
  .value("CLS_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::CLS_ZPmZ_D)
  .value("CLS_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::CLS_ZPmZ_H)
  .value("CLS_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::CLS_ZPmZ_S)
  .value("CLS_ZPzZ_B", LIEF::assembly::aarch64::OPCODE::CLS_ZPzZ_B)
  .value("CLS_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::CLS_ZPzZ_D)
  .value("CLS_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::CLS_ZPzZ_H)
  .value("CLS_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::CLS_ZPzZ_S)
  .value("CLSv16i8", LIEF::assembly::aarch64::OPCODE::CLSv16i8)
  .value("CLSv2i32", LIEF::assembly::aarch64::OPCODE::CLSv2i32)
  .value("CLSv4i16", LIEF::assembly::aarch64::OPCODE::CLSv4i16)
  .value("CLSv4i32", LIEF::assembly::aarch64::OPCODE::CLSv4i32)
  .value("CLSv8i16", LIEF::assembly::aarch64::OPCODE::CLSv8i16)
  .value("CLSv8i8", LIEF::assembly::aarch64::OPCODE::CLSv8i8)
  .value("CLZWr", LIEF::assembly::aarch64::OPCODE::CLZWr)
  .value("CLZXr", LIEF::assembly::aarch64::OPCODE::CLZXr)
  .value("CLZ_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::CLZ_ZPmZ_B)
  .value("CLZ_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::CLZ_ZPmZ_D)
  .value("CLZ_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::CLZ_ZPmZ_H)
  .value("CLZ_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::CLZ_ZPmZ_S)
  .value("CLZ_ZPzZ_B", LIEF::assembly::aarch64::OPCODE::CLZ_ZPzZ_B)
  .value("CLZ_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::CLZ_ZPzZ_D)
  .value("CLZ_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::CLZ_ZPzZ_H)
  .value("CLZ_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::CLZ_ZPzZ_S)
  .value("CLZv16i8", LIEF::assembly::aarch64::OPCODE::CLZv16i8)
  .value("CLZv2i32", LIEF::assembly::aarch64::OPCODE::CLZv2i32)
  .value("CLZv4i16", LIEF::assembly::aarch64::OPCODE::CLZv4i16)
  .value("CLZv4i32", LIEF::assembly::aarch64::OPCODE::CLZv4i32)
  .value("CLZv8i16", LIEF::assembly::aarch64::OPCODE::CLZv8i16)
  .value("CLZv8i8", LIEF::assembly::aarch64::OPCODE::CLZv8i8)
  .value("CMEQv16i8", LIEF::assembly::aarch64::OPCODE::CMEQv16i8)
  .value("CMEQv16i8rz", LIEF::assembly::aarch64::OPCODE::CMEQv16i8rz)
  .value("CMEQv1i64", LIEF::assembly::aarch64::OPCODE::CMEQv1i64)
  .value("CMEQv1i64rz", LIEF::assembly::aarch64::OPCODE::CMEQv1i64rz)
  .value("CMEQv2i32", LIEF::assembly::aarch64::OPCODE::CMEQv2i32)
  .value("CMEQv2i32rz", LIEF::assembly::aarch64::OPCODE::CMEQv2i32rz)
  .value("CMEQv2i64", LIEF::assembly::aarch64::OPCODE::CMEQv2i64)
  .value("CMEQv2i64rz", LIEF::assembly::aarch64::OPCODE::CMEQv2i64rz)
  .value("CMEQv4i16", LIEF::assembly::aarch64::OPCODE::CMEQv4i16)
  .value("CMEQv4i16rz", LIEF::assembly::aarch64::OPCODE::CMEQv4i16rz)
  .value("CMEQv4i32", LIEF::assembly::aarch64::OPCODE::CMEQv4i32)
  .value("CMEQv4i32rz", LIEF::assembly::aarch64::OPCODE::CMEQv4i32rz)
  .value("CMEQv8i16", LIEF::assembly::aarch64::OPCODE::CMEQv8i16)
  .value("CMEQv8i16rz", LIEF::assembly::aarch64::OPCODE::CMEQv8i16rz)
  .value("CMEQv8i8", LIEF::assembly::aarch64::OPCODE::CMEQv8i8)
  .value("CMEQv8i8rz", LIEF::assembly::aarch64::OPCODE::CMEQv8i8rz)
  .value("CMGEv16i8", LIEF::assembly::aarch64::OPCODE::CMGEv16i8)
  .value("CMGEv16i8rz", LIEF::assembly::aarch64::OPCODE::CMGEv16i8rz)
  .value("CMGEv1i64", LIEF::assembly::aarch64::OPCODE::CMGEv1i64)
  .value("CMGEv1i64rz", LIEF::assembly::aarch64::OPCODE::CMGEv1i64rz)
  .value("CMGEv2i32", LIEF::assembly::aarch64::OPCODE::CMGEv2i32)
  .value("CMGEv2i32rz", LIEF::assembly::aarch64::OPCODE::CMGEv2i32rz)
  .value("CMGEv2i64", LIEF::assembly::aarch64::OPCODE::CMGEv2i64)
  .value("CMGEv2i64rz", LIEF::assembly::aarch64::OPCODE::CMGEv2i64rz)
  .value("CMGEv4i16", LIEF::assembly::aarch64::OPCODE::CMGEv4i16)
  .value("CMGEv4i16rz", LIEF::assembly::aarch64::OPCODE::CMGEv4i16rz)
  .value("CMGEv4i32", LIEF::assembly::aarch64::OPCODE::CMGEv4i32)
  .value("CMGEv4i32rz", LIEF::assembly::aarch64::OPCODE::CMGEv4i32rz)
  .value("CMGEv8i16", LIEF::assembly::aarch64::OPCODE::CMGEv8i16)
  .value("CMGEv8i16rz", LIEF::assembly::aarch64::OPCODE::CMGEv8i16rz)
  .value("CMGEv8i8", LIEF::assembly::aarch64::OPCODE::CMGEv8i8)
  .value("CMGEv8i8rz", LIEF::assembly::aarch64::OPCODE::CMGEv8i8rz)
  .value("CMGTv16i8", LIEF::assembly::aarch64::OPCODE::CMGTv16i8)
  .value("CMGTv16i8rz", LIEF::assembly::aarch64::OPCODE::CMGTv16i8rz)
  .value("CMGTv1i64", LIEF::assembly::aarch64::OPCODE::CMGTv1i64)
  .value("CMGTv1i64rz", LIEF::assembly::aarch64::OPCODE::CMGTv1i64rz)
  .value("CMGTv2i32", LIEF::assembly::aarch64::OPCODE::CMGTv2i32)
  .value("CMGTv2i32rz", LIEF::assembly::aarch64::OPCODE::CMGTv2i32rz)
  .value("CMGTv2i64", LIEF::assembly::aarch64::OPCODE::CMGTv2i64)
  .value("CMGTv2i64rz", LIEF::assembly::aarch64::OPCODE::CMGTv2i64rz)
  .value("CMGTv4i16", LIEF::assembly::aarch64::OPCODE::CMGTv4i16)
  .value("CMGTv4i16rz", LIEF::assembly::aarch64::OPCODE::CMGTv4i16rz)
  .value("CMGTv4i32", LIEF::assembly::aarch64::OPCODE::CMGTv4i32)
  .value("CMGTv4i32rz", LIEF::assembly::aarch64::OPCODE::CMGTv4i32rz)
  .value("CMGTv8i16", LIEF::assembly::aarch64::OPCODE::CMGTv8i16)
  .value("CMGTv8i16rz", LIEF::assembly::aarch64::OPCODE::CMGTv8i16rz)
  .value("CMGTv8i8", LIEF::assembly::aarch64::OPCODE::CMGTv8i8)
  .value("CMGTv8i8rz", LIEF::assembly::aarch64::OPCODE::CMGTv8i8rz)
  .value("CMHIv16i8", LIEF::assembly::aarch64::OPCODE::CMHIv16i8)
  .value("CMHIv1i64", LIEF::assembly::aarch64::OPCODE::CMHIv1i64)
  .value("CMHIv2i32", LIEF::assembly::aarch64::OPCODE::CMHIv2i32)
  .value("CMHIv2i64", LIEF::assembly::aarch64::OPCODE::CMHIv2i64)
  .value("CMHIv4i16", LIEF::assembly::aarch64::OPCODE::CMHIv4i16)
  .value("CMHIv4i32", LIEF::assembly::aarch64::OPCODE::CMHIv4i32)
  .value("CMHIv8i16", LIEF::assembly::aarch64::OPCODE::CMHIv8i16)
  .value("CMHIv8i8", LIEF::assembly::aarch64::OPCODE::CMHIv8i8)
  .value("CMHSv16i8", LIEF::assembly::aarch64::OPCODE::CMHSv16i8)
  .value("CMHSv1i64", LIEF::assembly::aarch64::OPCODE::CMHSv1i64)
  .value("CMHSv2i32", LIEF::assembly::aarch64::OPCODE::CMHSv2i32)
  .value("CMHSv2i64", LIEF::assembly::aarch64::OPCODE::CMHSv2i64)
  .value("CMHSv4i16", LIEF::assembly::aarch64::OPCODE::CMHSv4i16)
  .value("CMHSv4i32", LIEF::assembly::aarch64::OPCODE::CMHSv4i32)
  .value("CMHSv8i16", LIEF::assembly::aarch64::OPCODE::CMHSv8i16)
  .value("CMHSv8i8", LIEF::assembly::aarch64::OPCODE::CMHSv8i8)
  .value("CMLA_ZZZI_H", LIEF::assembly::aarch64::OPCODE::CMLA_ZZZI_H)
  .value("CMLA_ZZZI_S", LIEF::assembly::aarch64::OPCODE::CMLA_ZZZI_S)
  .value("CMLA_ZZZ_B", LIEF::assembly::aarch64::OPCODE::CMLA_ZZZ_B)
  .value("CMLA_ZZZ_D", LIEF::assembly::aarch64::OPCODE::CMLA_ZZZ_D)
  .value("CMLA_ZZZ_H", LIEF::assembly::aarch64::OPCODE::CMLA_ZZZ_H)
  .value("CMLA_ZZZ_S", LIEF::assembly::aarch64::OPCODE::CMLA_ZZZ_S)
  .value("CMLEv16i8rz", LIEF::assembly::aarch64::OPCODE::CMLEv16i8rz)
  .value("CMLEv1i64rz", LIEF::assembly::aarch64::OPCODE::CMLEv1i64rz)
  .value("CMLEv2i32rz", LIEF::assembly::aarch64::OPCODE::CMLEv2i32rz)
  .value("CMLEv2i64rz", LIEF::assembly::aarch64::OPCODE::CMLEv2i64rz)
  .value("CMLEv4i16rz", LIEF::assembly::aarch64::OPCODE::CMLEv4i16rz)
  .value("CMLEv4i32rz", LIEF::assembly::aarch64::OPCODE::CMLEv4i32rz)
  .value("CMLEv8i16rz", LIEF::assembly::aarch64::OPCODE::CMLEv8i16rz)
  .value("CMLEv8i8rz", LIEF::assembly::aarch64::OPCODE::CMLEv8i8rz)
  .value("CMLTv16i8rz", LIEF::assembly::aarch64::OPCODE::CMLTv16i8rz)
  .value("CMLTv1i64rz", LIEF::assembly::aarch64::OPCODE::CMLTv1i64rz)
  .value("CMLTv2i32rz", LIEF::assembly::aarch64::OPCODE::CMLTv2i32rz)
  .value("CMLTv2i64rz", LIEF::assembly::aarch64::OPCODE::CMLTv2i64rz)
  .value("CMLTv4i16rz", LIEF::assembly::aarch64::OPCODE::CMLTv4i16rz)
  .value("CMLTv4i32rz", LIEF::assembly::aarch64::OPCODE::CMLTv4i32rz)
  .value("CMLTv8i16rz", LIEF::assembly::aarch64::OPCODE::CMLTv8i16rz)
  .value("CMLTv8i8rz", LIEF::assembly::aarch64::OPCODE::CMLTv8i8rz)
  .value("CMPEQ_PPzZI_B", LIEF::assembly::aarch64::OPCODE::CMPEQ_PPzZI_B)
  .value("CMPEQ_PPzZI_D", LIEF::assembly::aarch64::OPCODE::CMPEQ_PPzZI_D)
  .value("CMPEQ_PPzZI_H", LIEF::assembly::aarch64::OPCODE::CMPEQ_PPzZI_H)
  .value("CMPEQ_PPzZI_S", LIEF::assembly::aarch64::OPCODE::CMPEQ_PPzZI_S)
  .value("CMPEQ_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPEQ_PPzZZ_B)
  .value("CMPEQ_PPzZZ_D", LIEF::assembly::aarch64::OPCODE::CMPEQ_PPzZZ_D)
  .value("CMPEQ_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPEQ_PPzZZ_H)
  .value("CMPEQ_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPEQ_PPzZZ_S)
  .value("CMPEQ_WIDE_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPEQ_WIDE_PPzZZ_B)
  .value("CMPEQ_WIDE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPEQ_WIDE_PPzZZ_H)
  .value("CMPEQ_WIDE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPEQ_WIDE_PPzZZ_S)
  .value("CMPGE_PPzZI_B", LIEF::assembly::aarch64::OPCODE::CMPGE_PPzZI_B)
  .value("CMPGE_PPzZI_D", LIEF::assembly::aarch64::OPCODE::CMPGE_PPzZI_D)
  .value("CMPGE_PPzZI_H", LIEF::assembly::aarch64::OPCODE::CMPGE_PPzZI_H)
  .value("CMPGE_PPzZI_S", LIEF::assembly::aarch64::OPCODE::CMPGE_PPzZI_S)
  .value("CMPGE_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPGE_PPzZZ_B)
  .value("CMPGE_PPzZZ_D", LIEF::assembly::aarch64::OPCODE::CMPGE_PPzZZ_D)
  .value("CMPGE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPGE_PPzZZ_H)
  .value("CMPGE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPGE_PPzZZ_S)
  .value("CMPGE_WIDE_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPGE_WIDE_PPzZZ_B)
  .value("CMPGE_WIDE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPGE_WIDE_PPzZZ_H)
  .value("CMPGE_WIDE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPGE_WIDE_PPzZZ_S)
  .value("CMPGT_PPzZI_B", LIEF::assembly::aarch64::OPCODE::CMPGT_PPzZI_B)
  .value("CMPGT_PPzZI_D", LIEF::assembly::aarch64::OPCODE::CMPGT_PPzZI_D)
  .value("CMPGT_PPzZI_H", LIEF::assembly::aarch64::OPCODE::CMPGT_PPzZI_H)
  .value("CMPGT_PPzZI_S", LIEF::assembly::aarch64::OPCODE::CMPGT_PPzZI_S)
  .value("CMPGT_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPGT_PPzZZ_B)
  .value("CMPGT_PPzZZ_D", LIEF::assembly::aarch64::OPCODE::CMPGT_PPzZZ_D)
  .value("CMPGT_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPGT_PPzZZ_H)
  .value("CMPGT_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPGT_PPzZZ_S)
  .value("CMPGT_WIDE_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPGT_WIDE_PPzZZ_B)
  .value("CMPGT_WIDE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPGT_WIDE_PPzZZ_H)
  .value("CMPGT_WIDE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPGT_WIDE_PPzZZ_S)
  .value("CMPHI_PPzZI_B", LIEF::assembly::aarch64::OPCODE::CMPHI_PPzZI_B)
  .value("CMPHI_PPzZI_D", LIEF::assembly::aarch64::OPCODE::CMPHI_PPzZI_D)
  .value("CMPHI_PPzZI_H", LIEF::assembly::aarch64::OPCODE::CMPHI_PPzZI_H)
  .value("CMPHI_PPzZI_S", LIEF::assembly::aarch64::OPCODE::CMPHI_PPzZI_S)
  .value("CMPHI_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPHI_PPzZZ_B)
  .value("CMPHI_PPzZZ_D", LIEF::assembly::aarch64::OPCODE::CMPHI_PPzZZ_D)
  .value("CMPHI_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPHI_PPzZZ_H)
  .value("CMPHI_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPHI_PPzZZ_S)
  .value("CMPHI_WIDE_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPHI_WIDE_PPzZZ_B)
  .value("CMPHI_WIDE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPHI_WIDE_PPzZZ_H)
  .value("CMPHI_WIDE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPHI_WIDE_PPzZZ_S)
  .value("CMPHS_PPzZI_B", LIEF::assembly::aarch64::OPCODE::CMPHS_PPzZI_B)
  .value("CMPHS_PPzZI_D", LIEF::assembly::aarch64::OPCODE::CMPHS_PPzZI_D)
  .value("CMPHS_PPzZI_H", LIEF::assembly::aarch64::OPCODE::CMPHS_PPzZI_H)
  .value("CMPHS_PPzZI_S", LIEF::assembly::aarch64::OPCODE::CMPHS_PPzZI_S)
  .value("CMPHS_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPHS_PPzZZ_B)
  .value("CMPHS_PPzZZ_D", LIEF::assembly::aarch64::OPCODE::CMPHS_PPzZZ_D)
  .value("CMPHS_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPHS_PPzZZ_H)
  .value("CMPHS_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPHS_PPzZZ_S)
  .value("CMPHS_WIDE_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPHS_WIDE_PPzZZ_B)
  .value("CMPHS_WIDE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPHS_WIDE_PPzZZ_H)
  .value("CMPHS_WIDE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPHS_WIDE_PPzZZ_S)
  .value("CMPLE_PPzZI_B", LIEF::assembly::aarch64::OPCODE::CMPLE_PPzZI_B)
  .value("CMPLE_PPzZI_D", LIEF::assembly::aarch64::OPCODE::CMPLE_PPzZI_D)
  .value("CMPLE_PPzZI_H", LIEF::assembly::aarch64::OPCODE::CMPLE_PPzZI_H)
  .value("CMPLE_PPzZI_S", LIEF::assembly::aarch64::OPCODE::CMPLE_PPzZI_S)
  .value("CMPLE_WIDE_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPLE_WIDE_PPzZZ_B)
  .value("CMPLE_WIDE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPLE_WIDE_PPzZZ_H)
  .value("CMPLE_WIDE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPLE_WIDE_PPzZZ_S)
  .value("CMPLO_PPzZI_B", LIEF::assembly::aarch64::OPCODE::CMPLO_PPzZI_B)
  .value("CMPLO_PPzZI_D", LIEF::assembly::aarch64::OPCODE::CMPLO_PPzZI_D)
  .value("CMPLO_PPzZI_H", LIEF::assembly::aarch64::OPCODE::CMPLO_PPzZI_H)
  .value("CMPLO_PPzZI_S", LIEF::assembly::aarch64::OPCODE::CMPLO_PPzZI_S)
  .value("CMPLO_WIDE_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPLO_WIDE_PPzZZ_B)
  .value("CMPLO_WIDE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPLO_WIDE_PPzZZ_H)
  .value("CMPLO_WIDE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPLO_WIDE_PPzZZ_S)
  .value("CMPLS_PPzZI_B", LIEF::assembly::aarch64::OPCODE::CMPLS_PPzZI_B)
  .value("CMPLS_PPzZI_D", LIEF::assembly::aarch64::OPCODE::CMPLS_PPzZI_D)
  .value("CMPLS_PPzZI_H", LIEF::assembly::aarch64::OPCODE::CMPLS_PPzZI_H)
  .value("CMPLS_PPzZI_S", LIEF::assembly::aarch64::OPCODE::CMPLS_PPzZI_S)
  .value("CMPLS_WIDE_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPLS_WIDE_PPzZZ_B)
  .value("CMPLS_WIDE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPLS_WIDE_PPzZZ_H)
  .value("CMPLS_WIDE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPLS_WIDE_PPzZZ_S)
  .value("CMPLT_PPzZI_B", LIEF::assembly::aarch64::OPCODE::CMPLT_PPzZI_B)
  .value("CMPLT_PPzZI_D", LIEF::assembly::aarch64::OPCODE::CMPLT_PPzZI_D)
  .value("CMPLT_PPzZI_H", LIEF::assembly::aarch64::OPCODE::CMPLT_PPzZI_H)
  .value("CMPLT_PPzZI_S", LIEF::assembly::aarch64::OPCODE::CMPLT_PPzZI_S)
  .value("CMPLT_WIDE_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPLT_WIDE_PPzZZ_B)
  .value("CMPLT_WIDE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPLT_WIDE_PPzZZ_H)
  .value("CMPLT_WIDE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPLT_WIDE_PPzZZ_S)
  .value("CMPNE_PPzZI_B", LIEF::assembly::aarch64::OPCODE::CMPNE_PPzZI_B)
  .value("CMPNE_PPzZI_D", LIEF::assembly::aarch64::OPCODE::CMPNE_PPzZI_D)
  .value("CMPNE_PPzZI_H", LIEF::assembly::aarch64::OPCODE::CMPNE_PPzZI_H)
  .value("CMPNE_PPzZI_S", LIEF::assembly::aarch64::OPCODE::CMPNE_PPzZI_S)
  .value("CMPNE_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPNE_PPzZZ_B)
  .value("CMPNE_PPzZZ_D", LIEF::assembly::aarch64::OPCODE::CMPNE_PPzZZ_D)
  .value("CMPNE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPNE_PPzZZ_H)
  .value("CMPNE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPNE_PPzZZ_S)
  .value("CMPNE_WIDE_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::CMPNE_WIDE_PPzZZ_B)
  .value("CMPNE_WIDE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::CMPNE_WIDE_PPzZZ_H)
  .value("CMPNE_WIDE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::CMPNE_WIDE_PPzZZ_S)
  .value("CMTSTv16i8", LIEF::assembly::aarch64::OPCODE::CMTSTv16i8)
  .value("CMTSTv1i64", LIEF::assembly::aarch64::OPCODE::CMTSTv1i64)
  .value("CMTSTv2i32", LIEF::assembly::aarch64::OPCODE::CMTSTv2i32)
  .value("CMTSTv2i64", LIEF::assembly::aarch64::OPCODE::CMTSTv2i64)
  .value("CMTSTv4i16", LIEF::assembly::aarch64::OPCODE::CMTSTv4i16)
  .value("CMTSTv4i32", LIEF::assembly::aarch64::OPCODE::CMTSTv4i32)
  .value("CMTSTv8i16", LIEF::assembly::aarch64::OPCODE::CMTSTv8i16)
  .value("CMTSTv8i8", LIEF::assembly::aarch64::OPCODE::CMTSTv8i8)
  .value("CNOT_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::CNOT_ZPmZ_B)
  .value("CNOT_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::CNOT_ZPmZ_D)
  .value("CNOT_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::CNOT_ZPmZ_H)
  .value("CNOT_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::CNOT_ZPmZ_S)
  .value("CNOT_ZPzZ_B", LIEF::assembly::aarch64::OPCODE::CNOT_ZPzZ_B)
  .value("CNOT_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::CNOT_ZPzZ_D)
  .value("CNOT_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::CNOT_ZPzZ_H)
  .value("CNOT_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::CNOT_ZPzZ_S)
  .value("CNTB_XPiI", LIEF::assembly::aarch64::OPCODE::CNTB_XPiI)
  .value("CNTD_XPiI", LIEF::assembly::aarch64::OPCODE::CNTD_XPiI)
  .value("CNTH_XPiI", LIEF::assembly::aarch64::OPCODE::CNTH_XPiI)
  .value("CNTP_XCI_B", LIEF::assembly::aarch64::OPCODE::CNTP_XCI_B)
  .value("CNTP_XCI_D", LIEF::assembly::aarch64::OPCODE::CNTP_XCI_D)
  .value("CNTP_XCI_H", LIEF::assembly::aarch64::OPCODE::CNTP_XCI_H)
  .value("CNTP_XCI_S", LIEF::assembly::aarch64::OPCODE::CNTP_XCI_S)
  .value("CNTP_XPP_B", LIEF::assembly::aarch64::OPCODE::CNTP_XPP_B)
  .value("CNTP_XPP_D", LIEF::assembly::aarch64::OPCODE::CNTP_XPP_D);
  opcodes.value("CNTP_XPP_H", LIEF::assembly::aarch64::OPCODE::CNTP_XPP_H)
  .value("CNTP_XPP_S", LIEF::assembly::aarch64::OPCODE::CNTP_XPP_S)
  .value("CNTW_XPiI", LIEF::assembly::aarch64::OPCODE::CNTW_XPiI)
  .value("CNTWr", LIEF::assembly::aarch64::OPCODE::CNTWr)
  .value("CNTXr", LIEF::assembly::aarch64::OPCODE::CNTXr)
  .value("CNT_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::CNT_ZPmZ_B)
  .value("CNT_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::CNT_ZPmZ_D)
  .value("CNT_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::CNT_ZPmZ_H)
  .value("CNT_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::CNT_ZPmZ_S)
  .value("CNT_ZPzZ_B", LIEF::assembly::aarch64::OPCODE::CNT_ZPzZ_B)
  .value("CNT_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::CNT_ZPzZ_D)
  .value("CNT_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::CNT_ZPzZ_H)
  .value("CNT_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::CNT_ZPzZ_S)
  .value("CNTv16i8", LIEF::assembly::aarch64::OPCODE::CNTv16i8)
  .value("CNTv8i8", LIEF::assembly::aarch64::OPCODE::CNTv8i8)
  .value("COMPACT_ZPZ_B", LIEF::assembly::aarch64::OPCODE::COMPACT_ZPZ_B)
  .value("COMPACT_ZPZ_D", LIEF::assembly::aarch64::OPCODE::COMPACT_ZPZ_D)
  .value("COMPACT_ZPZ_H", LIEF::assembly::aarch64::OPCODE::COMPACT_ZPZ_H)
  .value("COMPACT_ZPZ_S", LIEF::assembly::aarch64::OPCODE::COMPACT_ZPZ_S)
  .value("CPYE", LIEF::assembly::aarch64::OPCODE::CPYE)
  .value("CPYEN", LIEF::assembly::aarch64::OPCODE::CPYEN)
  .value("CPYERN", LIEF::assembly::aarch64::OPCODE::CPYERN)
  .value("CPYERT", LIEF::assembly::aarch64::OPCODE::CPYERT)
  .value("CPYERTN", LIEF::assembly::aarch64::OPCODE::CPYERTN)
  .value("CPYERTRN", LIEF::assembly::aarch64::OPCODE::CPYERTRN)
  .value("CPYERTWN", LIEF::assembly::aarch64::OPCODE::CPYERTWN)
  .value("CPYET", LIEF::assembly::aarch64::OPCODE::CPYET)
  .value("CPYETN", LIEF::assembly::aarch64::OPCODE::CPYETN)
  .value("CPYETRN", LIEF::assembly::aarch64::OPCODE::CPYETRN)
  .value("CPYETWN", LIEF::assembly::aarch64::OPCODE::CPYETWN)
  .value("CPYEWN", LIEF::assembly::aarch64::OPCODE::CPYEWN)
  .value("CPYEWT", LIEF::assembly::aarch64::OPCODE::CPYEWT)
  .value("CPYEWTN", LIEF::assembly::aarch64::OPCODE::CPYEWTN)
  .value("CPYEWTRN", LIEF::assembly::aarch64::OPCODE::CPYEWTRN)
  .value("CPYEWTWN", LIEF::assembly::aarch64::OPCODE::CPYEWTWN)
  .value("CPYFE", LIEF::assembly::aarch64::OPCODE::CPYFE)
  .value("CPYFEN", LIEF::assembly::aarch64::OPCODE::CPYFEN)
  .value("CPYFERN", LIEF::assembly::aarch64::OPCODE::CPYFERN)
  .value("CPYFERT", LIEF::assembly::aarch64::OPCODE::CPYFERT)
  .value("CPYFERTN", LIEF::assembly::aarch64::OPCODE::CPYFERTN)
  .value("CPYFERTRN", LIEF::assembly::aarch64::OPCODE::CPYFERTRN)
  .value("CPYFERTWN", LIEF::assembly::aarch64::OPCODE::CPYFERTWN)
  .value("CPYFET", LIEF::assembly::aarch64::OPCODE::CPYFET)
  .value("CPYFETN", LIEF::assembly::aarch64::OPCODE::CPYFETN)
  .value("CPYFETRN", LIEF::assembly::aarch64::OPCODE::CPYFETRN)
  .value("CPYFETWN", LIEF::assembly::aarch64::OPCODE::CPYFETWN)
  .value("CPYFEWN", LIEF::assembly::aarch64::OPCODE::CPYFEWN)
  .value("CPYFEWT", LIEF::assembly::aarch64::OPCODE::CPYFEWT)
  .value("CPYFEWTN", LIEF::assembly::aarch64::OPCODE::CPYFEWTN)
  .value("CPYFEWTRN", LIEF::assembly::aarch64::OPCODE::CPYFEWTRN)
  .value("CPYFEWTWN", LIEF::assembly::aarch64::OPCODE::CPYFEWTWN)
  .value("CPYFM", LIEF::assembly::aarch64::OPCODE::CPYFM)
  .value("CPYFMN", LIEF::assembly::aarch64::OPCODE::CPYFMN)
  .value("CPYFMRN", LIEF::assembly::aarch64::OPCODE::CPYFMRN)
  .value("CPYFMRT", LIEF::assembly::aarch64::OPCODE::CPYFMRT)
  .value("CPYFMRTN", LIEF::assembly::aarch64::OPCODE::CPYFMRTN)
  .value("CPYFMRTRN", LIEF::assembly::aarch64::OPCODE::CPYFMRTRN)
  .value("CPYFMRTWN", LIEF::assembly::aarch64::OPCODE::CPYFMRTWN)
  .value("CPYFMT", LIEF::assembly::aarch64::OPCODE::CPYFMT)
  .value("CPYFMTN", LIEF::assembly::aarch64::OPCODE::CPYFMTN)
  .value("CPYFMTRN", LIEF::assembly::aarch64::OPCODE::CPYFMTRN)
  .value("CPYFMTWN", LIEF::assembly::aarch64::OPCODE::CPYFMTWN)
  .value("CPYFMWN", LIEF::assembly::aarch64::OPCODE::CPYFMWN)
  .value("CPYFMWT", LIEF::assembly::aarch64::OPCODE::CPYFMWT)
  .value("CPYFMWTN", LIEF::assembly::aarch64::OPCODE::CPYFMWTN)
  .value("CPYFMWTRN", LIEF::assembly::aarch64::OPCODE::CPYFMWTRN)
  .value("CPYFMWTWN", LIEF::assembly::aarch64::OPCODE::CPYFMWTWN)
  .value("CPYFP", LIEF::assembly::aarch64::OPCODE::CPYFP)
  .value("CPYFPN", LIEF::assembly::aarch64::OPCODE::CPYFPN)
  .value("CPYFPRN", LIEF::assembly::aarch64::OPCODE::CPYFPRN)
  .value("CPYFPRT", LIEF::assembly::aarch64::OPCODE::CPYFPRT)
  .value("CPYFPRTN", LIEF::assembly::aarch64::OPCODE::CPYFPRTN)
  .value("CPYFPRTRN", LIEF::assembly::aarch64::OPCODE::CPYFPRTRN)
  .value("CPYFPRTWN", LIEF::assembly::aarch64::OPCODE::CPYFPRTWN)
  .value("CPYFPT", LIEF::assembly::aarch64::OPCODE::CPYFPT)
  .value("CPYFPTN", LIEF::assembly::aarch64::OPCODE::CPYFPTN)
  .value("CPYFPTRN", LIEF::assembly::aarch64::OPCODE::CPYFPTRN)
  .value("CPYFPTWN", LIEF::assembly::aarch64::OPCODE::CPYFPTWN)
  .value("CPYFPWN", LIEF::assembly::aarch64::OPCODE::CPYFPWN)
  .value("CPYFPWT", LIEF::assembly::aarch64::OPCODE::CPYFPWT)
  .value("CPYFPWTN", LIEF::assembly::aarch64::OPCODE::CPYFPWTN)
  .value("CPYFPWTRN", LIEF::assembly::aarch64::OPCODE::CPYFPWTRN)
  .value("CPYFPWTWN", LIEF::assembly::aarch64::OPCODE::CPYFPWTWN)
  .value("CPYM", LIEF::assembly::aarch64::OPCODE::CPYM)
  .value("CPYMN", LIEF::assembly::aarch64::OPCODE::CPYMN)
  .value("CPYMRN", LIEF::assembly::aarch64::OPCODE::CPYMRN)
  .value("CPYMRT", LIEF::assembly::aarch64::OPCODE::CPYMRT)
  .value("CPYMRTN", LIEF::assembly::aarch64::OPCODE::CPYMRTN)
  .value("CPYMRTRN", LIEF::assembly::aarch64::OPCODE::CPYMRTRN)
  .value("CPYMRTWN", LIEF::assembly::aarch64::OPCODE::CPYMRTWN)
  .value("CPYMT", LIEF::assembly::aarch64::OPCODE::CPYMT)
  .value("CPYMTN", LIEF::assembly::aarch64::OPCODE::CPYMTN)
  .value("CPYMTRN", LIEF::assembly::aarch64::OPCODE::CPYMTRN)
  .value("CPYMTWN", LIEF::assembly::aarch64::OPCODE::CPYMTWN)
  .value("CPYMWN", LIEF::assembly::aarch64::OPCODE::CPYMWN)
  .value("CPYMWT", LIEF::assembly::aarch64::OPCODE::CPYMWT)
  .value("CPYMWTN", LIEF::assembly::aarch64::OPCODE::CPYMWTN)
  .value("CPYMWTRN", LIEF::assembly::aarch64::OPCODE::CPYMWTRN)
  .value("CPYMWTWN", LIEF::assembly::aarch64::OPCODE::CPYMWTWN)
  .value("CPYP", LIEF::assembly::aarch64::OPCODE::CPYP)
  .value("CPYPN", LIEF::assembly::aarch64::OPCODE::CPYPN)
  .value("CPYPRN", LIEF::assembly::aarch64::OPCODE::CPYPRN)
  .value("CPYPRT", LIEF::assembly::aarch64::OPCODE::CPYPRT)
  .value("CPYPRTN", LIEF::assembly::aarch64::OPCODE::CPYPRTN)
  .value("CPYPRTRN", LIEF::assembly::aarch64::OPCODE::CPYPRTRN)
  .value("CPYPRTWN", LIEF::assembly::aarch64::OPCODE::CPYPRTWN)
  .value("CPYPT", LIEF::assembly::aarch64::OPCODE::CPYPT)
  .value("CPYPTN", LIEF::assembly::aarch64::OPCODE::CPYPTN)
  .value("CPYPTRN", LIEF::assembly::aarch64::OPCODE::CPYPTRN)
  .value("CPYPTWN", LIEF::assembly::aarch64::OPCODE::CPYPTWN)
  .value("CPYPWN", LIEF::assembly::aarch64::OPCODE::CPYPWN)
  .value("CPYPWT", LIEF::assembly::aarch64::OPCODE::CPYPWT)
  .value("CPYPWTN", LIEF::assembly::aarch64::OPCODE::CPYPWTN)
  .value("CPYPWTRN", LIEF::assembly::aarch64::OPCODE::CPYPWTRN)
  .value("CPYPWTWN", LIEF::assembly::aarch64::OPCODE::CPYPWTWN)
  .value("CPY_ZPmI_B", LIEF::assembly::aarch64::OPCODE::CPY_ZPmI_B)
  .value("CPY_ZPmI_D", LIEF::assembly::aarch64::OPCODE::CPY_ZPmI_D)
  .value("CPY_ZPmI_H", LIEF::assembly::aarch64::OPCODE::CPY_ZPmI_H)
  .value("CPY_ZPmI_S", LIEF::assembly::aarch64::OPCODE::CPY_ZPmI_S)
  .value("CPY_ZPmR_B", LIEF::assembly::aarch64::OPCODE::CPY_ZPmR_B)
  .value("CPY_ZPmR_D", LIEF::assembly::aarch64::OPCODE::CPY_ZPmR_D)
  .value("CPY_ZPmR_H", LIEF::assembly::aarch64::OPCODE::CPY_ZPmR_H)
  .value("CPY_ZPmR_S", LIEF::assembly::aarch64::OPCODE::CPY_ZPmR_S)
  .value("CPY_ZPmV_B", LIEF::assembly::aarch64::OPCODE::CPY_ZPmV_B)
  .value("CPY_ZPmV_D", LIEF::assembly::aarch64::OPCODE::CPY_ZPmV_D)
  .value("CPY_ZPmV_H", LIEF::assembly::aarch64::OPCODE::CPY_ZPmV_H)
  .value("CPY_ZPmV_S", LIEF::assembly::aarch64::OPCODE::CPY_ZPmV_S)
  .value("CPY_ZPzI_B", LIEF::assembly::aarch64::OPCODE::CPY_ZPzI_B)
  .value("CPY_ZPzI_D", LIEF::assembly::aarch64::OPCODE::CPY_ZPzI_D)
  .value("CPY_ZPzI_H", LIEF::assembly::aarch64::OPCODE::CPY_ZPzI_H)
  .value("CPY_ZPzI_S", LIEF::assembly::aarch64::OPCODE::CPY_ZPzI_S)
  .value("CRC32Brr", LIEF::assembly::aarch64::OPCODE::CRC32Brr)
  .value("CRC32CBrr", LIEF::assembly::aarch64::OPCODE::CRC32CBrr)
  .value("CRC32CHrr", LIEF::assembly::aarch64::OPCODE::CRC32CHrr)
  .value("CRC32CWrr", LIEF::assembly::aarch64::OPCODE::CRC32CWrr)
  .value("CRC32CXrr", LIEF::assembly::aarch64::OPCODE::CRC32CXrr)
  .value("CRC32Hrr", LIEF::assembly::aarch64::OPCODE::CRC32Hrr)
  .value("CRC32Wrr", LIEF::assembly::aarch64::OPCODE::CRC32Wrr)
  .value("CRC32Xrr", LIEF::assembly::aarch64::OPCODE::CRC32Xrr)
  .value("CSELWr", LIEF::assembly::aarch64::OPCODE::CSELWr)
  .value("CSELXr", LIEF::assembly::aarch64::OPCODE::CSELXr)
  .value("CSINCWr", LIEF::assembly::aarch64::OPCODE::CSINCWr)
  .value("CSINCXr", LIEF::assembly::aarch64::OPCODE::CSINCXr)
  .value("CSINVWr", LIEF::assembly::aarch64::OPCODE::CSINVWr)
  .value("CSINVXr", LIEF::assembly::aarch64::OPCODE::CSINVXr)
  .value("CSNEGWr", LIEF::assembly::aarch64::OPCODE::CSNEGWr)
  .value("CSNEGXr", LIEF::assembly::aarch64::OPCODE::CSNEGXr)
  .value("CTERMEQ_WW", LIEF::assembly::aarch64::OPCODE::CTERMEQ_WW)
  .value("CTERMEQ_XX", LIEF::assembly::aarch64::OPCODE::CTERMEQ_XX)
  .value("CTERMNE_WW", LIEF::assembly::aarch64::OPCODE::CTERMNE_WW)
  .value("CTERMNE_XX", LIEF::assembly::aarch64::OPCODE::CTERMNE_XX)
  .value("CTZWr", LIEF::assembly::aarch64::OPCODE::CTZWr)
  .value("CTZXr", LIEF::assembly::aarch64::OPCODE::CTZXr)
  .value("DCPS1", LIEF::assembly::aarch64::OPCODE::DCPS1)
  .value("DCPS2", LIEF::assembly::aarch64::OPCODE::DCPS2)
  .value("DCPS3", LIEF::assembly::aarch64::OPCODE::DCPS3)
  .value("DECB_XPiI", LIEF::assembly::aarch64::OPCODE::DECB_XPiI)
  .value("DECD_XPiI", LIEF::assembly::aarch64::OPCODE::DECD_XPiI)
  .value("DECD_ZPiI", LIEF::assembly::aarch64::OPCODE::DECD_ZPiI)
  .value("DECH_XPiI", LIEF::assembly::aarch64::OPCODE::DECH_XPiI)
  .value("DECH_ZPiI", LIEF::assembly::aarch64::OPCODE::DECH_ZPiI)
  .value("DECP_XP_B", LIEF::assembly::aarch64::OPCODE::DECP_XP_B)
  .value("DECP_XP_D", LIEF::assembly::aarch64::OPCODE::DECP_XP_D)
  .value("DECP_XP_H", LIEF::assembly::aarch64::OPCODE::DECP_XP_H)
  .value("DECP_XP_S", LIEF::assembly::aarch64::OPCODE::DECP_XP_S)
  .value("DECP_ZP_D", LIEF::assembly::aarch64::OPCODE::DECP_ZP_D)
  .value("DECP_ZP_H", LIEF::assembly::aarch64::OPCODE::DECP_ZP_H)
  .value("DECP_ZP_S", LIEF::assembly::aarch64::OPCODE::DECP_ZP_S)
  .value("DECW_XPiI", LIEF::assembly::aarch64::OPCODE::DECW_XPiI)
  .value("DECW_ZPiI", LIEF::assembly::aarch64::OPCODE::DECW_ZPiI)
  .value("DMB", LIEF::assembly::aarch64::OPCODE::DMB)
  .value("DRPS", LIEF::assembly::aarch64::OPCODE::DRPS)
  .value("DSB", LIEF::assembly::aarch64::OPCODE::DSB)
  .value("DSBnXS", LIEF::assembly::aarch64::OPCODE::DSBnXS)
  .value("DUPM_ZI", LIEF::assembly::aarch64::OPCODE::DUPM_ZI)
  .value("DUPQ_ZZI_B", LIEF::assembly::aarch64::OPCODE::DUPQ_ZZI_B)
  .value("DUPQ_ZZI_D", LIEF::assembly::aarch64::OPCODE::DUPQ_ZZI_D)
  .value("DUPQ_ZZI_H", LIEF::assembly::aarch64::OPCODE::DUPQ_ZZI_H)
  .value("DUPQ_ZZI_S", LIEF::assembly::aarch64::OPCODE::DUPQ_ZZI_S)
  .value("DUP_ZI_B", LIEF::assembly::aarch64::OPCODE::DUP_ZI_B)
  .value("DUP_ZI_D", LIEF::assembly::aarch64::OPCODE::DUP_ZI_D)
  .value("DUP_ZI_H", LIEF::assembly::aarch64::OPCODE::DUP_ZI_H)
  .value("DUP_ZI_S", LIEF::assembly::aarch64::OPCODE::DUP_ZI_S)
  .value("DUP_ZR_B", LIEF::assembly::aarch64::OPCODE::DUP_ZR_B)
  .value("DUP_ZR_D", LIEF::assembly::aarch64::OPCODE::DUP_ZR_D)
  .value("DUP_ZR_H", LIEF::assembly::aarch64::OPCODE::DUP_ZR_H)
  .value("DUP_ZR_S", LIEF::assembly::aarch64::OPCODE::DUP_ZR_S)
  .value("DUP_ZZI_B", LIEF::assembly::aarch64::OPCODE::DUP_ZZI_B)
  .value("DUP_ZZI_D", LIEF::assembly::aarch64::OPCODE::DUP_ZZI_D)
  .value("DUP_ZZI_H", LIEF::assembly::aarch64::OPCODE::DUP_ZZI_H)
  .value("DUP_ZZI_Q", LIEF::assembly::aarch64::OPCODE::DUP_ZZI_Q)
  .value("DUP_ZZI_S", LIEF::assembly::aarch64::OPCODE::DUP_ZZI_S)
  .value("DUPi16", LIEF::assembly::aarch64::OPCODE::DUPi16)
  .value("DUPi32", LIEF::assembly::aarch64::OPCODE::DUPi32)
  .value("DUPi64", LIEF::assembly::aarch64::OPCODE::DUPi64)
  .value("DUPi8", LIEF::assembly::aarch64::OPCODE::DUPi8)
  .value("DUPv16i8gpr", LIEF::assembly::aarch64::OPCODE::DUPv16i8gpr)
  .value("DUPv16i8lane", LIEF::assembly::aarch64::OPCODE::DUPv16i8lane)
  .value("DUPv2i32gpr", LIEF::assembly::aarch64::OPCODE::DUPv2i32gpr)
  .value("DUPv2i32lane", LIEF::assembly::aarch64::OPCODE::DUPv2i32lane)
  .value("DUPv2i64gpr", LIEF::assembly::aarch64::OPCODE::DUPv2i64gpr)
  .value("DUPv2i64lane", LIEF::assembly::aarch64::OPCODE::DUPv2i64lane)
  .value("DUPv4i16gpr", LIEF::assembly::aarch64::OPCODE::DUPv4i16gpr)
  .value("DUPv4i16lane", LIEF::assembly::aarch64::OPCODE::DUPv4i16lane)
  .value("DUPv4i32gpr", LIEF::assembly::aarch64::OPCODE::DUPv4i32gpr)
  .value("DUPv4i32lane", LIEF::assembly::aarch64::OPCODE::DUPv4i32lane)
  .value("DUPv8i16gpr", LIEF::assembly::aarch64::OPCODE::DUPv8i16gpr)
  .value("DUPv8i16lane", LIEF::assembly::aarch64::OPCODE::DUPv8i16lane)
  .value("DUPv8i8gpr", LIEF::assembly::aarch64::OPCODE::DUPv8i8gpr)
  .value("DUPv8i8lane", LIEF::assembly::aarch64::OPCODE::DUPv8i8lane)
  .value("EONWrs", LIEF::assembly::aarch64::OPCODE::EONWrs)
  .value("EONXrs", LIEF::assembly::aarch64::OPCODE::EONXrs)
  .value("EOR3", LIEF::assembly::aarch64::OPCODE::EOR3)
  .value("EOR3_ZZZZ", LIEF::assembly::aarch64::OPCODE::EOR3_ZZZZ)
  .value("EORBT_ZZZ_B", LIEF::assembly::aarch64::OPCODE::EORBT_ZZZ_B)
  .value("EORBT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::EORBT_ZZZ_D)
  .value("EORBT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::EORBT_ZZZ_H)
  .value("EORBT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::EORBT_ZZZ_S)
  .value("EORQV_VPZ_B", LIEF::assembly::aarch64::OPCODE::EORQV_VPZ_B)
  .value("EORQV_VPZ_D", LIEF::assembly::aarch64::OPCODE::EORQV_VPZ_D)
  .value("EORQV_VPZ_H", LIEF::assembly::aarch64::OPCODE::EORQV_VPZ_H)
  .value("EORQV_VPZ_S", LIEF::assembly::aarch64::OPCODE::EORQV_VPZ_S)
  .value("EORS_PPzPP", LIEF::assembly::aarch64::OPCODE::EORS_PPzPP)
  .value("EORTB_ZZZ_B", LIEF::assembly::aarch64::OPCODE::EORTB_ZZZ_B)
  .value("EORTB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::EORTB_ZZZ_D)
  .value("EORTB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::EORTB_ZZZ_H)
  .value("EORTB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::EORTB_ZZZ_S)
  .value("EORV_VPZ_B", LIEF::assembly::aarch64::OPCODE::EORV_VPZ_B)
  .value("EORV_VPZ_D", LIEF::assembly::aarch64::OPCODE::EORV_VPZ_D)
  .value("EORV_VPZ_H", LIEF::assembly::aarch64::OPCODE::EORV_VPZ_H)
  .value("EORV_VPZ_S", LIEF::assembly::aarch64::OPCODE::EORV_VPZ_S)
  .value("EORWri", LIEF::assembly::aarch64::OPCODE::EORWri)
  .value("EORWrs", LIEF::assembly::aarch64::OPCODE::EORWrs)
  .value("EORXri", LIEF::assembly::aarch64::OPCODE::EORXri)
  .value("EORXrs", LIEF::assembly::aarch64::OPCODE::EORXrs)
  .value("EOR_PPzPP", LIEF::assembly::aarch64::OPCODE::EOR_PPzPP)
  .value("EOR_ZI", LIEF::assembly::aarch64::OPCODE::EOR_ZI)
  .value("EOR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::EOR_ZPmZ_B)
  .value("EOR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::EOR_ZPmZ_D)
  .value("EOR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::EOR_ZPmZ_H)
  .value("EOR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::EOR_ZPmZ_S)
  .value("EOR_ZZZ", LIEF::assembly::aarch64::OPCODE::EOR_ZZZ)
  .value("EORv16i8", LIEF::assembly::aarch64::OPCODE::EORv16i8)
  .value("EORv8i8", LIEF::assembly::aarch64::OPCODE::EORv8i8)
  .value("ERET", LIEF::assembly::aarch64::OPCODE::ERET)
  .value("ERETAA", LIEF::assembly::aarch64::OPCODE::ERETAA)
  .value("ERETAB", LIEF::assembly::aarch64::OPCODE::ERETAB)
  .value("EXPAND_ZPZ_B", LIEF::assembly::aarch64::OPCODE::EXPAND_ZPZ_B)
  .value("EXPAND_ZPZ_D", LIEF::assembly::aarch64::OPCODE::EXPAND_ZPZ_D)
  .value("EXPAND_ZPZ_H", LIEF::assembly::aarch64::OPCODE::EXPAND_ZPZ_H)
  .value("EXPAND_ZPZ_S", LIEF::assembly::aarch64::OPCODE::EXPAND_ZPZ_S)
  .value("EXTQ_ZZI", LIEF::assembly::aarch64::OPCODE::EXTQ_ZZI)
  .value("EXTRACT_ZPMXI_H_B", LIEF::assembly::aarch64::OPCODE::EXTRACT_ZPMXI_H_B)
  .value("EXTRACT_ZPMXI_H_D", LIEF::assembly::aarch64::OPCODE::EXTRACT_ZPMXI_H_D)
  .value("EXTRACT_ZPMXI_H_H", LIEF::assembly::aarch64::OPCODE::EXTRACT_ZPMXI_H_H)
  .value("EXTRACT_ZPMXI_H_Q", LIEF::assembly::aarch64::OPCODE::EXTRACT_ZPMXI_H_Q)
  .value("EXTRACT_ZPMXI_H_S", LIEF::assembly::aarch64::OPCODE::EXTRACT_ZPMXI_H_S)
  .value("EXTRACT_ZPMXI_V_B", LIEF::assembly::aarch64::OPCODE::EXTRACT_ZPMXI_V_B)
  .value("EXTRACT_ZPMXI_V_D", LIEF::assembly::aarch64::OPCODE::EXTRACT_ZPMXI_V_D)
  .value("EXTRACT_ZPMXI_V_H", LIEF::assembly::aarch64::OPCODE::EXTRACT_ZPMXI_V_H)
  .value("EXTRACT_ZPMXI_V_Q", LIEF::assembly::aarch64::OPCODE::EXTRACT_ZPMXI_V_Q)
  .value("EXTRACT_ZPMXI_V_S", LIEF::assembly::aarch64::OPCODE::EXTRACT_ZPMXI_V_S)
  .value("EXTRWrri", LIEF::assembly::aarch64::OPCODE::EXTRWrri)
  .value("EXTRXrri", LIEF::assembly::aarch64::OPCODE::EXTRXrri)
  .value("EXT_ZZI", LIEF::assembly::aarch64::OPCODE::EXT_ZZI)
  .value("EXT_ZZI_B", LIEF::assembly::aarch64::OPCODE::EXT_ZZI_B)
  .value("EXTv16i8", LIEF::assembly::aarch64::OPCODE::EXTv16i8)
  .value("EXTv8i8", LIEF::assembly::aarch64::OPCODE::EXTv8i8)
  .value("F1CVTL", LIEF::assembly::aarch64::OPCODE::F1CVTL)
  .value("F1CVTL2", LIEF::assembly::aarch64::OPCODE::F1CVTL2)
  .value("F1CVTLT_ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::F1CVTLT_ZZ_BtoH)
  .value("F1CVTL_2ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::F1CVTL_2ZZ_BtoH)
  .value("F1CVT_2ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::F1CVT_2ZZ_BtoH)
  .value("F1CVT_ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::F1CVT_ZZ_BtoH)
  .value("F2CVTL", LIEF::assembly::aarch64::OPCODE::F2CVTL)
  .value("F2CVTL2", LIEF::assembly::aarch64::OPCODE::F2CVTL2)
  .value("F2CVTLT_ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::F2CVTLT_ZZ_BtoH)
  .value("F2CVTL_2ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::F2CVTL_2ZZ_BtoH)
  .value("F2CVT_2ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::F2CVT_2ZZ_BtoH)
  .value("F2CVT_ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::F2CVT_ZZ_BtoH)
  .value("FABD16", LIEF::assembly::aarch64::OPCODE::FABD16)
  .value("FABD32", LIEF::assembly::aarch64::OPCODE::FABD32)
  .value("FABD64", LIEF::assembly::aarch64::OPCODE::FABD64)
  .value("FABD_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FABD_ZPmZ_D)
  .value("FABD_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FABD_ZPmZ_H)
  .value("FABD_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FABD_ZPmZ_S)
  .value("FABDv2f32", LIEF::assembly::aarch64::OPCODE::FABDv2f32)
  .value("FABDv2f64", LIEF::assembly::aarch64::OPCODE::FABDv2f64)
  .value("FABDv4f16", LIEF::assembly::aarch64::OPCODE::FABDv4f16)
  .value("FABDv4f32", LIEF::assembly::aarch64::OPCODE::FABDv4f32)
  .value("FABDv8f16", LIEF::assembly::aarch64::OPCODE::FABDv8f16)
  .value("FABSDr", LIEF::assembly::aarch64::OPCODE::FABSDr)
  .value("FABSHr", LIEF::assembly::aarch64::OPCODE::FABSHr)
  .value("FABSSr", LIEF::assembly::aarch64::OPCODE::FABSSr)
  .value("FABS_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FABS_ZPmZ_D)
  .value("FABS_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FABS_ZPmZ_H)
  .value("FABS_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FABS_ZPmZ_S)
  .value("FABS_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FABS_ZPzZ_D)
  .value("FABS_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::FABS_ZPzZ_H)
  .value("FABS_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FABS_ZPzZ_S);
  opcodes.value("FABSv2f32", LIEF::assembly::aarch64::OPCODE::FABSv2f32)
  .value("FABSv2f64", LIEF::assembly::aarch64::OPCODE::FABSv2f64)
  .value("FABSv4f16", LIEF::assembly::aarch64::OPCODE::FABSv4f16)
  .value("FABSv4f32", LIEF::assembly::aarch64::OPCODE::FABSv4f32)
  .value("FABSv8f16", LIEF::assembly::aarch64::OPCODE::FABSv8f16)
  .value("FACGE16", LIEF::assembly::aarch64::OPCODE::FACGE16)
  .value("FACGE32", LIEF::assembly::aarch64::OPCODE::FACGE32)
  .value("FACGE64", LIEF::assembly::aarch64::OPCODE::FACGE64)
  .value("FACGE_PPzZZ_D", LIEF::assembly::aarch64::OPCODE::FACGE_PPzZZ_D)
  .value("FACGE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::FACGE_PPzZZ_H)
  .value("FACGE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::FACGE_PPzZZ_S)
  .value("FACGEv2f32", LIEF::assembly::aarch64::OPCODE::FACGEv2f32)
  .value("FACGEv2f64", LIEF::assembly::aarch64::OPCODE::FACGEv2f64)
  .value("FACGEv4f16", LIEF::assembly::aarch64::OPCODE::FACGEv4f16)
  .value("FACGEv4f32", LIEF::assembly::aarch64::OPCODE::FACGEv4f32)
  .value("FACGEv8f16", LIEF::assembly::aarch64::OPCODE::FACGEv8f16)
  .value("FACGT16", LIEF::assembly::aarch64::OPCODE::FACGT16)
  .value("FACGT32", LIEF::assembly::aarch64::OPCODE::FACGT32)
  .value("FACGT64", LIEF::assembly::aarch64::OPCODE::FACGT64)
  .value("FACGT_PPzZZ_D", LIEF::assembly::aarch64::OPCODE::FACGT_PPzZZ_D)
  .value("FACGT_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::FACGT_PPzZZ_H)
  .value("FACGT_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::FACGT_PPzZZ_S)
  .value("FACGTv2f32", LIEF::assembly::aarch64::OPCODE::FACGTv2f32)
  .value("FACGTv2f64", LIEF::assembly::aarch64::OPCODE::FACGTv2f64)
  .value("FACGTv4f16", LIEF::assembly::aarch64::OPCODE::FACGTv4f16)
  .value("FACGTv4f32", LIEF::assembly::aarch64::OPCODE::FACGTv4f32)
  .value("FACGTv8f16", LIEF::assembly::aarch64::OPCODE::FACGTv8f16)
  .value("FADDA_VPZ_D", LIEF::assembly::aarch64::OPCODE::FADDA_VPZ_D)
  .value("FADDA_VPZ_H", LIEF::assembly::aarch64::OPCODE::FADDA_VPZ_H)
  .value("FADDA_VPZ_S", LIEF::assembly::aarch64::OPCODE::FADDA_VPZ_S)
  .value("FADDDrr", LIEF::assembly::aarch64::OPCODE::FADDDrr)
  .value("FADDHrr", LIEF::assembly::aarch64::OPCODE::FADDHrr)
  .value("FADDP_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::FADDP_ZPmZZ_D)
  .value("FADDP_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::FADDP_ZPmZZ_H)
  .value("FADDP_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::FADDP_ZPmZZ_S)
  .value("FADDPv2f32", LIEF::assembly::aarch64::OPCODE::FADDPv2f32)
  .value("FADDPv2f64", LIEF::assembly::aarch64::OPCODE::FADDPv2f64)
  .value("FADDPv2i16p", LIEF::assembly::aarch64::OPCODE::FADDPv2i16p)
  .value("FADDPv2i32p", LIEF::assembly::aarch64::OPCODE::FADDPv2i32p)
  .value("FADDPv2i64p", LIEF::assembly::aarch64::OPCODE::FADDPv2i64p)
  .value("FADDPv4f16", LIEF::assembly::aarch64::OPCODE::FADDPv4f16)
  .value("FADDPv4f32", LIEF::assembly::aarch64::OPCODE::FADDPv4f32)
  .value("FADDPv8f16", LIEF::assembly::aarch64::OPCODE::FADDPv8f16)
  .value("FADDQV_D", LIEF::assembly::aarch64::OPCODE::FADDQV_D)
  .value("FADDQV_H", LIEF::assembly::aarch64::OPCODE::FADDQV_H)
  .value("FADDQV_S", LIEF::assembly::aarch64::OPCODE::FADDQV_S)
  .value("FADDSrr", LIEF::assembly::aarch64::OPCODE::FADDSrr)
  .value("FADDV_VPZ_D", LIEF::assembly::aarch64::OPCODE::FADDV_VPZ_D)
  .value("FADDV_VPZ_H", LIEF::assembly::aarch64::OPCODE::FADDV_VPZ_H)
  .value("FADDV_VPZ_S", LIEF::assembly::aarch64::OPCODE::FADDV_VPZ_S)
  .value("FADD_VG2_M2Z_D", LIEF::assembly::aarch64::OPCODE::FADD_VG2_M2Z_D)
  .value("FADD_VG2_M2Z_H", LIEF::assembly::aarch64::OPCODE::FADD_VG2_M2Z_H)
  .value("FADD_VG2_M2Z_S", LIEF::assembly::aarch64::OPCODE::FADD_VG2_M2Z_S)
  .value("FADD_VG4_M4Z_D", LIEF::assembly::aarch64::OPCODE::FADD_VG4_M4Z_D)
  .value("FADD_VG4_M4Z_H", LIEF::assembly::aarch64::OPCODE::FADD_VG4_M4Z_H)
  .value("FADD_VG4_M4Z_S", LIEF::assembly::aarch64::OPCODE::FADD_VG4_M4Z_S)
  .value("FADD_ZPmI_D", LIEF::assembly::aarch64::OPCODE::FADD_ZPmI_D)
  .value("FADD_ZPmI_H", LIEF::assembly::aarch64::OPCODE::FADD_ZPmI_H)
  .value("FADD_ZPmI_S", LIEF::assembly::aarch64::OPCODE::FADD_ZPmI_S)
  .value("FADD_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FADD_ZPmZ_D)
  .value("FADD_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FADD_ZPmZ_H)
  .value("FADD_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FADD_ZPmZ_S)
  .value("FADD_ZZZ_D", LIEF::assembly::aarch64::OPCODE::FADD_ZZZ_D)
  .value("FADD_ZZZ_H", LIEF::assembly::aarch64::OPCODE::FADD_ZZZ_H)
  .value("FADD_ZZZ_S", LIEF::assembly::aarch64::OPCODE::FADD_ZZZ_S)
  .value("FADDv2f32", LIEF::assembly::aarch64::OPCODE::FADDv2f32)
  .value("FADDv2f64", LIEF::assembly::aarch64::OPCODE::FADDv2f64)
  .value("FADDv4f16", LIEF::assembly::aarch64::OPCODE::FADDv4f16)
  .value("FADDv4f32", LIEF::assembly::aarch64::OPCODE::FADDv4f32)
  .value("FADDv8f16", LIEF::assembly::aarch64::OPCODE::FADDv8f16)
  .value("FAMAX_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::FAMAX_2Z2Z_D)
  .value("FAMAX_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::FAMAX_2Z2Z_H)
  .value("FAMAX_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FAMAX_2Z2Z_S)
  .value("FAMAX_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::FAMAX_4Z4Z_D)
  .value("FAMAX_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::FAMAX_4Z4Z_H)
  .value("FAMAX_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FAMAX_4Z4Z_S)
  .value("FAMAX_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FAMAX_ZPmZ_D)
  .value("FAMAX_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FAMAX_ZPmZ_H)
  .value("FAMAX_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FAMAX_ZPmZ_S)
  .value("FAMAXv2f32", LIEF::assembly::aarch64::OPCODE::FAMAXv2f32)
  .value("FAMAXv2f64", LIEF::assembly::aarch64::OPCODE::FAMAXv2f64)
  .value("FAMAXv4f16", LIEF::assembly::aarch64::OPCODE::FAMAXv4f16)
  .value("FAMAXv4f32", LIEF::assembly::aarch64::OPCODE::FAMAXv4f32)
  .value("FAMAXv8f16", LIEF::assembly::aarch64::OPCODE::FAMAXv8f16)
  .value("FAMIN_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::FAMIN_2Z2Z_D)
  .value("FAMIN_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::FAMIN_2Z2Z_H)
  .value("FAMIN_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FAMIN_2Z2Z_S)
  .value("FAMIN_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::FAMIN_4Z4Z_D)
  .value("FAMIN_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::FAMIN_4Z4Z_H)
  .value("FAMIN_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FAMIN_4Z4Z_S)
  .value("FAMIN_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FAMIN_ZPmZ_D)
  .value("FAMIN_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FAMIN_ZPmZ_H)
  .value("FAMIN_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FAMIN_ZPmZ_S)
  .value("FAMINv2f32", LIEF::assembly::aarch64::OPCODE::FAMINv2f32)
  .value("FAMINv2f64", LIEF::assembly::aarch64::OPCODE::FAMINv2f64)
  .value("FAMINv4f16", LIEF::assembly::aarch64::OPCODE::FAMINv4f16)
  .value("FAMINv4f32", LIEF::assembly::aarch64::OPCODE::FAMINv4f32)
  .value("FAMINv8f16", LIEF::assembly::aarch64::OPCODE::FAMINv8f16)
  .value("FCADD_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FCADD_ZPmZ_D)
  .value("FCADD_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FCADD_ZPmZ_H)
  .value("FCADD_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FCADD_ZPmZ_S)
  .value("FCADDv2f32", LIEF::assembly::aarch64::OPCODE::FCADDv2f32)
  .value("FCADDv2f64", LIEF::assembly::aarch64::OPCODE::FCADDv2f64)
  .value("FCADDv4f16", LIEF::assembly::aarch64::OPCODE::FCADDv4f16)
  .value("FCADDv4f32", LIEF::assembly::aarch64::OPCODE::FCADDv4f32)
  .value("FCADDv8f16", LIEF::assembly::aarch64::OPCODE::FCADDv8f16)
  .value("FCCMPDrr", LIEF::assembly::aarch64::OPCODE::FCCMPDrr)
  .value("FCCMPEDrr", LIEF::assembly::aarch64::OPCODE::FCCMPEDrr)
  .value("FCCMPEHrr", LIEF::assembly::aarch64::OPCODE::FCCMPEHrr)
  .value("FCCMPESrr", LIEF::assembly::aarch64::OPCODE::FCCMPESrr)
  .value("FCCMPHrr", LIEF::assembly::aarch64::OPCODE::FCCMPHrr)
  .value("FCCMPSrr", LIEF::assembly::aarch64::OPCODE::FCCMPSrr)
  .value("FCLAMP_VG2_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::FCLAMP_VG2_2Z2Z_D)
  .value("FCLAMP_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::FCLAMP_VG2_2Z2Z_H)
  .value("FCLAMP_VG2_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FCLAMP_VG2_2Z2Z_S)
  .value("FCLAMP_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::FCLAMP_VG4_4Z4Z_D)
  .value("FCLAMP_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::FCLAMP_VG4_4Z4Z_H)
  .value("FCLAMP_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FCLAMP_VG4_4Z4Z_S)
  .value("FCLAMP_ZZZ_D", LIEF::assembly::aarch64::OPCODE::FCLAMP_ZZZ_D)
  .value("FCLAMP_ZZZ_H", LIEF::assembly::aarch64::OPCODE::FCLAMP_ZZZ_H)
  .value("FCLAMP_ZZZ_S", LIEF::assembly::aarch64::OPCODE::FCLAMP_ZZZ_S)
  .value("FCMEQ16", LIEF::assembly::aarch64::OPCODE::FCMEQ16)
  .value("FCMEQ32", LIEF::assembly::aarch64::OPCODE::FCMEQ32)
  .value("FCMEQ64", LIEF::assembly::aarch64::OPCODE::FCMEQ64)
  .value("FCMEQ_PPzZ0_D", LIEF::assembly::aarch64::OPCODE::FCMEQ_PPzZ0_D)
  .value("FCMEQ_PPzZ0_H", LIEF::assembly::aarch64::OPCODE::FCMEQ_PPzZ0_H)
  .value("FCMEQ_PPzZ0_S", LIEF::assembly::aarch64::OPCODE::FCMEQ_PPzZ0_S)
  .value("FCMEQ_PPzZZ_D", LIEF::assembly::aarch64::OPCODE::FCMEQ_PPzZZ_D)
  .value("FCMEQ_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::FCMEQ_PPzZZ_H)
  .value("FCMEQ_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::FCMEQ_PPzZZ_S)
  .value("FCMEQv1i16rz", LIEF::assembly::aarch64::OPCODE::FCMEQv1i16rz)
  .value("FCMEQv1i32rz", LIEF::assembly::aarch64::OPCODE::FCMEQv1i32rz)
  .value("FCMEQv1i64rz", LIEF::assembly::aarch64::OPCODE::FCMEQv1i64rz)
  .value("FCMEQv2f32", LIEF::assembly::aarch64::OPCODE::FCMEQv2f32)
  .value("FCMEQv2f64", LIEF::assembly::aarch64::OPCODE::FCMEQv2f64)
  .value("FCMEQv2i32rz", LIEF::assembly::aarch64::OPCODE::FCMEQv2i32rz)
  .value("FCMEQv2i64rz", LIEF::assembly::aarch64::OPCODE::FCMEQv2i64rz)
  .value("FCMEQv4f16", LIEF::assembly::aarch64::OPCODE::FCMEQv4f16)
  .value("FCMEQv4f32", LIEF::assembly::aarch64::OPCODE::FCMEQv4f32)
  .value("FCMEQv4i16rz", LIEF::assembly::aarch64::OPCODE::FCMEQv4i16rz)
  .value("FCMEQv4i32rz", LIEF::assembly::aarch64::OPCODE::FCMEQv4i32rz)
  .value("FCMEQv8f16", LIEF::assembly::aarch64::OPCODE::FCMEQv8f16)
  .value("FCMEQv8i16rz", LIEF::assembly::aarch64::OPCODE::FCMEQv8i16rz)
  .value("FCMGE16", LIEF::assembly::aarch64::OPCODE::FCMGE16)
  .value("FCMGE32", LIEF::assembly::aarch64::OPCODE::FCMGE32)
  .value("FCMGE64", LIEF::assembly::aarch64::OPCODE::FCMGE64)
  .value("FCMGE_PPzZ0_D", LIEF::assembly::aarch64::OPCODE::FCMGE_PPzZ0_D)
  .value("FCMGE_PPzZ0_H", LIEF::assembly::aarch64::OPCODE::FCMGE_PPzZ0_H)
  .value("FCMGE_PPzZ0_S", LIEF::assembly::aarch64::OPCODE::FCMGE_PPzZ0_S)
  .value("FCMGE_PPzZZ_D", LIEF::assembly::aarch64::OPCODE::FCMGE_PPzZZ_D)
  .value("FCMGE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::FCMGE_PPzZZ_H)
  .value("FCMGE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::FCMGE_PPzZZ_S)
  .value("FCMGEv1i16rz", LIEF::assembly::aarch64::OPCODE::FCMGEv1i16rz)
  .value("FCMGEv1i32rz", LIEF::assembly::aarch64::OPCODE::FCMGEv1i32rz)
  .value("FCMGEv1i64rz", LIEF::assembly::aarch64::OPCODE::FCMGEv1i64rz)
  .value("FCMGEv2f32", LIEF::assembly::aarch64::OPCODE::FCMGEv2f32)
  .value("FCMGEv2f64", LIEF::assembly::aarch64::OPCODE::FCMGEv2f64)
  .value("FCMGEv2i32rz", LIEF::assembly::aarch64::OPCODE::FCMGEv2i32rz)
  .value("FCMGEv2i64rz", LIEF::assembly::aarch64::OPCODE::FCMGEv2i64rz)
  .value("FCMGEv4f16", LIEF::assembly::aarch64::OPCODE::FCMGEv4f16)
  .value("FCMGEv4f32", LIEF::assembly::aarch64::OPCODE::FCMGEv4f32)
  .value("FCMGEv4i16rz", LIEF::assembly::aarch64::OPCODE::FCMGEv4i16rz)
  .value("FCMGEv4i32rz", LIEF::assembly::aarch64::OPCODE::FCMGEv4i32rz)
  .value("FCMGEv8f16", LIEF::assembly::aarch64::OPCODE::FCMGEv8f16)
  .value("FCMGEv8i16rz", LIEF::assembly::aarch64::OPCODE::FCMGEv8i16rz)
  .value("FCMGT16", LIEF::assembly::aarch64::OPCODE::FCMGT16)
  .value("FCMGT32", LIEF::assembly::aarch64::OPCODE::FCMGT32)
  .value("FCMGT64", LIEF::assembly::aarch64::OPCODE::FCMGT64)
  .value("FCMGT_PPzZ0_D", LIEF::assembly::aarch64::OPCODE::FCMGT_PPzZ0_D)
  .value("FCMGT_PPzZ0_H", LIEF::assembly::aarch64::OPCODE::FCMGT_PPzZ0_H)
  .value("FCMGT_PPzZ0_S", LIEF::assembly::aarch64::OPCODE::FCMGT_PPzZ0_S)
  .value("FCMGT_PPzZZ_D", LIEF::assembly::aarch64::OPCODE::FCMGT_PPzZZ_D)
  .value("FCMGT_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::FCMGT_PPzZZ_H)
  .value("FCMGT_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::FCMGT_PPzZZ_S)
  .value("FCMGTv1i16rz", LIEF::assembly::aarch64::OPCODE::FCMGTv1i16rz)
  .value("FCMGTv1i32rz", LIEF::assembly::aarch64::OPCODE::FCMGTv1i32rz)
  .value("FCMGTv1i64rz", LIEF::assembly::aarch64::OPCODE::FCMGTv1i64rz)
  .value("FCMGTv2f32", LIEF::assembly::aarch64::OPCODE::FCMGTv2f32)
  .value("FCMGTv2f64", LIEF::assembly::aarch64::OPCODE::FCMGTv2f64)
  .value("FCMGTv2i32rz", LIEF::assembly::aarch64::OPCODE::FCMGTv2i32rz)
  .value("FCMGTv2i64rz", LIEF::assembly::aarch64::OPCODE::FCMGTv2i64rz)
  .value("FCMGTv4f16", LIEF::assembly::aarch64::OPCODE::FCMGTv4f16)
  .value("FCMGTv4f32", LIEF::assembly::aarch64::OPCODE::FCMGTv4f32)
  .value("FCMGTv4i16rz", LIEF::assembly::aarch64::OPCODE::FCMGTv4i16rz)
  .value("FCMGTv4i32rz", LIEF::assembly::aarch64::OPCODE::FCMGTv4i32rz)
  .value("FCMGTv8f16", LIEF::assembly::aarch64::OPCODE::FCMGTv8f16)
  .value("FCMGTv8i16rz", LIEF::assembly::aarch64::OPCODE::FCMGTv8i16rz)
  .value("FCMLA_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::FCMLA_ZPmZZ_D)
  .value("FCMLA_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::FCMLA_ZPmZZ_H)
  .value("FCMLA_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::FCMLA_ZPmZZ_S)
  .value("FCMLA_ZZZI_H", LIEF::assembly::aarch64::OPCODE::FCMLA_ZZZI_H)
  .value("FCMLA_ZZZI_S", LIEF::assembly::aarch64::OPCODE::FCMLA_ZZZI_S)
  .value("FCMLAv2f32", LIEF::assembly::aarch64::OPCODE::FCMLAv2f32)
  .value("FCMLAv2f64", LIEF::assembly::aarch64::OPCODE::FCMLAv2f64)
  .value("FCMLAv4f16", LIEF::assembly::aarch64::OPCODE::FCMLAv4f16)
  .value("FCMLAv4f16_indexed", LIEF::assembly::aarch64::OPCODE::FCMLAv4f16_indexed)
  .value("FCMLAv4f32", LIEF::assembly::aarch64::OPCODE::FCMLAv4f32)
  .value("FCMLAv4f32_indexed", LIEF::assembly::aarch64::OPCODE::FCMLAv4f32_indexed)
  .value("FCMLAv8f16", LIEF::assembly::aarch64::OPCODE::FCMLAv8f16)
  .value("FCMLAv8f16_indexed", LIEF::assembly::aarch64::OPCODE::FCMLAv8f16_indexed)
  .value("FCMLE_PPzZ0_D", LIEF::assembly::aarch64::OPCODE::FCMLE_PPzZ0_D)
  .value("FCMLE_PPzZ0_H", LIEF::assembly::aarch64::OPCODE::FCMLE_PPzZ0_H)
  .value("FCMLE_PPzZ0_S", LIEF::assembly::aarch64::OPCODE::FCMLE_PPzZ0_S)
  .value("FCMLEv1i16rz", LIEF::assembly::aarch64::OPCODE::FCMLEv1i16rz)
  .value("FCMLEv1i32rz", LIEF::assembly::aarch64::OPCODE::FCMLEv1i32rz)
  .value("FCMLEv1i64rz", LIEF::assembly::aarch64::OPCODE::FCMLEv1i64rz)
  .value("FCMLEv2i32rz", LIEF::assembly::aarch64::OPCODE::FCMLEv2i32rz)
  .value("FCMLEv2i64rz", LIEF::assembly::aarch64::OPCODE::FCMLEv2i64rz)
  .value("FCMLEv4i16rz", LIEF::assembly::aarch64::OPCODE::FCMLEv4i16rz)
  .value("FCMLEv4i32rz", LIEF::assembly::aarch64::OPCODE::FCMLEv4i32rz)
  .value("FCMLEv8i16rz", LIEF::assembly::aarch64::OPCODE::FCMLEv8i16rz)
  .value("FCMLT_PPzZ0_D", LIEF::assembly::aarch64::OPCODE::FCMLT_PPzZ0_D)
  .value("FCMLT_PPzZ0_H", LIEF::assembly::aarch64::OPCODE::FCMLT_PPzZ0_H)
  .value("FCMLT_PPzZ0_S", LIEF::assembly::aarch64::OPCODE::FCMLT_PPzZ0_S)
  .value("FCMLTv1i16rz", LIEF::assembly::aarch64::OPCODE::FCMLTv1i16rz)
  .value("FCMLTv1i32rz", LIEF::assembly::aarch64::OPCODE::FCMLTv1i32rz)
  .value("FCMLTv1i64rz", LIEF::assembly::aarch64::OPCODE::FCMLTv1i64rz)
  .value("FCMLTv2i32rz", LIEF::assembly::aarch64::OPCODE::FCMLTv2i32rz)
  .value("FCMLTv2i64rz", LIEF::assembly::aarch64::OPCODE::FCMLTv2i64rz)
  .value("FCMLTv4i16rz", LIEF::assembly::aarch64::OPCODE::FCMLTv4i16rz)
  .value("FCMLTv4i32rz", LIEF::assembly::aarch64::OPCODE::FCMLTv4i32rz)
  .value("FCMLTv8i16rz", LIEF::assembly::aarch64::OPCODE::FCMLTv8i16rz)
  .value("FCMNE_PPzZ0_D", LIEF::assembly::aarch64::OPCODE::FCMNE_PPzZ0_D)
  .value("FCMNE_PPzZ0_H", LIEF::assembly::aarch64::OPCODE::FCMNE_PPzZ0_H)
  .value("FCMNE_PPzZ0_S", LIEF::assembly::aarch64::OPCODE::FCMNE_PPzZ0_S)
  .value("FCMNE_PPzZZ_D", LIEF::assembly::aarch64::OPCODE::FCMNE_PPzZZ_D)
  .value("FCMNE_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::FCMNE_PPzZZ_H)
  .value("FCMNE_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::FCMNE_PPzZZ_S)
  .value("FCMPDri", LIEF::assembly::aarch64::OPCODE::FCMPDri)
  .value("FCMPDrr", LIEF::assembly::aarch64::OPCODE::FCMPDrr)
  .value("FCMPEDri", LIEF::assembly::aarch64::OPCODE::FCMPEDri)
  .value("FCMPEDrr", LIEF::assembly::aarch64::OPCODE::FCMPEDrr)
  .value("FCMPEHri", LIEF::assembly::aarch64::OPCODE::FCMPEHri)
  .value("FCMPEHrr", LIEF::assembly::aarch64::OPCODE::FCMPEHrr)
  .value("FCMPESri", LIEF::assembly::aarch64::OPCODE::FCMPESri)
  .value("FCMPESrr", LIEF::assembly::aarch64::OPCODE::FCMPESrr)
  .value("FCMPHri", LIEF::assembly::aarch64::OPCODE::FCMPHri)
  .value("FCMPHrr", LIEF::assembly::aarch64::OPCODE::FCMPHrr)
  .value("FCMPSri", LIEF::assembly::aarch64::OPCODE::FCMPSri)
  .value("FCMPSrr", LIEF::assembly::aarch64::OPCODE::FCMPSrr)
  .value("FCMUO_PPzZZ_D", LIEF::assembly::aarch64::OPCODE::FCMUO_PPzZZ_D)
  .value("FCMUO_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::FCMUO_PPzZZ_H)
  .value("FCMUO_PPzZZ_S", LIEF::assembly::aarch64::OPCODE::FCMUO_PPzZZ_S)
  .value("FCPY_ZPmI_D", LIEF::assembly::aarch64::OPCODE::FCPY_ZPmI_D)
  .value("FCPY_ZPmI_H", LIEF::assembly::aarch64::OPCODE::FCPY_ZPmI_H)
  .value("FCPY_ZPmI_S", LIEF::assembly::aarch64::OPCODE::FCPY_ZPmI_S)
  .value("FCSELDrrr", LIEF::assembly::aarch64::OPCODE::FCSELDrrr)
  .value("FCSELHrrr", LIEF::assembly::aarch64::OPCODE::FCSELHrrr)
  .value("FCSELSrrr", LIEF::assembly::aarch64::OPCODE::FCSELSrrr)
  .value("FCVTASDHr", LIEF::assembly::aarch64::OPCODE::FCVTASDHr)
  .value("FCVTASDSr", LIEF::assembly::aarch64::OPCODE::FCVTASDSr)
  .value("FCVTASSDr", LIEF::assembly::aarch64::OPCODE::FCVTASSDr)
  .value("FCVTASSHr", LIEF::assembly::aarch64::OPCODE::FCVTASSHr)
  .value("FCVTASUWDr", LIEF::assembly::aarch64::OPCODE::FCVTASUWDr)
  .value("FCVTASUWHr", LIEF::assembly::aarch64::OPCODE::FCVTASUWHr)
  .value("FCVTASUWSr", LIEF::assembly::aarch64::OPCODE::FCVTASUWSr)
  .value("FCVTASUXDr", LIEF::assembly::aarch64::OPCODE::FCVTASUXDr)
  .value("FCVTASUXHr", LIEF::assembly::aarch64::OPCODE::FCVTASUXHr)
  .value("FCVTASUXSr", LIEF::assembly::aarch64::OPCODE::FCVTASUXSr)
  .value("FCVTASv1f16", LIEF::assembly::aarch64::OPCODE::FCVTASv1f16)
  .value("FCVTASv1i32", LIEF::assembly::aarch64::OPCODE::FCVTASv1i32)
  .value("FCVTASv1i64", LIEF::assembly::aarch64::OPCODE::FCVTASv1i64)
  .value("FCVTASv2f32", LIEF::assembly::aarch64::OPCODE::FCVTASv2f32)
  .value("FCVTASv2f64", LIEF::assembly::aarch64::OPCODE::FCVTASv2f64)
  .value("FCVTASv4f16", LIEF::assembly::aarch64::OPCODE::FCVTASv4f16)
  .value("FCVTASv4f32", LIEF::assembly::aarch64::OPCODE::FCVTASv4f32)
  .value("FCVTASv8f16", LIEF::assembly::aarch64::OPCODE::FCVTASv8f16)
  .value("FCVTAUDHr", LIEF::assembly::aarch64::OPCODE::FCVTAUDHr)
  .value("FCVTAUDSr", LIEF::assembly::aarch64::OPCODE::FCVTAUDSr)
  .value("FCVTAUSDr", LIEF::assembly::aarch64::OPCODE::FCVTAUSDr)
  .value("FCVTAUSHr", LIEF::assembly::aarch64::OPCODE::FCVTAUSHr)
  .value("FCVTAUUWDr", LIEF::assembly::aarch64::OPCODE::FCVTAUUWDr)
  .value("FCVTAUUWHr", LIEF::assembly::aarch64::OPCODE::FCVTAUUWHr)
  .value("FCVTAUUWSr", LIEF::assembly::aarch64::OPCODE::FCVTAUUWSr)
  .value("FCVTAUUXDr", LIEF::assembly::aarch64::OPCODE::FCVTAUUXDr)
  .value("FCVTAUUXHr", LIEF::assembly::aarch64::OPCODE::FCVTAUUXHr)
  .value("FCVTAUUXSr", LIEF::assembly::aarch64::OPCODE::FCVTAUUXSr)
  .value("FCVTAUv1f16", LIEF::assembly::aarch64::OPCODE::FCVTAUv1f16)
  .value("FCVTAUv1i32", LIEF::assembly::aarch64::OPCODE::FCVTAUv1i32)
  .value("FCVTAUv1i64", LIEF::assembly::aarch64::OPCODE::FCVTAUv1i64)
  .value("FCVTAUv2f32", LIEF::assembly::aarch64::OPCODE::FCVTAUv2f32)
  .value("FCVTAUv2f64", LIEF::assembly::aarch64::OPCODE::FCVTAUv2f64)
  .value("FCVTAUv4f16", LIEF::assembly::aarch64::OPCODE::FCVTAUv4f16)
  .value("FCVTAUv4f32", LIEF::assembly::aarch64::OPCODE::FCVTAUv4f32)
  .value("FCVTAUv8f16", LIEF::assembly::aarch64::OPCODE::FCVTAUv8f16)
  .value("FCVTDHr", LIEF::assembly::aarch64::OPCODE::FCVTDHr)
  .value("FCVTDSr", LIEF::assembly::aarch64::OPCODE::FCVTDSr)
  .value("FCVTHDr", LIEF::assembly::aarch64::OPCODE::FCVTHDr)
  .value("FCVTHSr", LIEF::assembly::aarch64::OPCODE::FCVTHSr)
  .value("FCVTLT_ZPmZ_HtoS", LIEF::assembly::aarch64::OPCODE::FCVTLT_ZPmZ_HtoS)
  .value("FCVTLT_ZPmZ_StoD", LIEF::assembly::aarch64::OPCODE::FCVTLT_ZPmZ_StoD)
  .value("FCVTLT_ZPzZ_HtoS", LIEF::assembly::aarch64::OPCODE::FCVTLT_ZPzZ_HtoS)
  .value("FCVTLT_ZPzZ_StoD", LIEF::assembly::aarch64::OPCODE::FCVTLT_ZPzZ_StoD)
  .value("FCVTL_2ZZ_H_S", LIEF::assembly::aarch64::OPCODE::FCVTL_2ZZ_H_S)
  .value("FCVTLv2i32", LIEF::assembly::aarch64::OPCODE::FCVTLv2i32)
  .value("FCVTLv4i16", LIEF::assembly::aarch64::OPCODE::FCVTLv4i16)
  .value("FCVTLv4i32", LIEF::assembly::aarch64::OPCODE::FCVTLv4i32)
  .value("FCVTLv8i16", LIEF::assembly::aarch64::OPCODE::FCVTLv8i16)
  .value("FCVTMSDHr", LIEF::assembly::aarch64::OPCODE::FCVTMSDHr)
  .value("FCVTMSDSr", LIEF::assembly::aarch64::OPCODE::FCVTMSDSr);
  opcodes.value("FCVTMSSDr", LIEF::assembly::aarch64::OPCODE::FCVTMSSDr)
  .value("FCVTMSSHr", LIEF::assembly::aarch64::OPCODE::FCVTMSSHr)
  .value("FCVTMSUWDr", LIEF::assembly::aarch64::OPCODE::FCVTMSUWDr)
  .value("FCVTMSUWHr", LIEF::assembly::aarch64::OPCODE::FCVTMSUWHr)
  .value("FCVTMSUWSr", LIEF::assembly::aarch64::OPCODE::FCVTMSUWSr)
  .value("FCVTMSUXDr", LIEF::assembly::aarch64::OPCODE::FCVTMSUXDr)
  .value("FCVTMSUXHr", LIEF::assembly::aarch64::OPCODE::FCVTMSUXHr)
  .value("FCVTMSUXSr", LIEF::assembly::aarch64::OPCODE::FCVTMSUXSr)
  .value("FCVTMSv1f16", LIEF::assembly::aarch64::OPCODE::FCVTMSv1f16)
  .value("FCVTMSv1i32", LIEF::assembly::aarch64::OPCODE::FCVTMSv1i32)
  .value("FCVTMSv1i64", LIEF::assembly::aarch64::OPCODE::FCVTMSv1i64)
  .value("FCVTMSv2f32", LIEF::assembly::aarch64::OPCODE::FCVTMSv2f32)
  .value("FCVTMSv2f64", LIEF::assembly::aarch64::OPCODE::FCVTMSv2f64)
  .value("FCVTMSv4f16", LIEF::assembly::aarch64::OPCODE::FCVTMSv4f16)
  .value("FCVTMSv4f32", LIEF::assembly::aarch64::OPCODE::FCVTMSv4f32)
  .value("FCVTMSv8f16", LIEF::assembly::aarch64::OPCODE::FCVTMSv8f16)
  .value("FCVTMUDHr", LIEF::assembly::aarch64::OPCODE::FCVTMUDHr)
  .value("FCVTMUDSr", LIEF::assembly::aarch64::OPCODE::FCVTMUDSr)
  .value("FCVTMUSDr", LIEF::assembly::aarch64::OPCODE::FCVTMUSDr)
  .value("FCVTMUSHr", LIEF::assembly::aarch64::OPCODE::FCVTMUSHr)
  .value("FCVTMUUWDr", LIEF::assembly::aarch64::OPCODE::FCVTMUUWDr)
  .value("FCVTMUUWHr", LIEF::assembly::aarch64::OPCODE::FCVTMUUWHr)
  .value("FCVTMUUWSr", LIEF::assembly::aarch64::OPCODE::FCVTMUUWSr)
  .value("FCVTMUUXDr", LIEF::assembly::aarch64::OPCODE::FCVTMUUXDr)
  .value("FCVTMUUXHr", LIEF::assembly::aarch64::OPCODE::FCVTMUUXHr)
  .value("FCVTMUUXSr", LIEF::assembly::aarch64::OPCODE::FCVTMUUXSr)
  .value("FCVTMUv1f16", LIEF::assembly::aarch64::OPCODE::FCVTMUv1f16)
  .value("FCVTMUv1i32", LIEF::assembly::aarch64::OPCODE::FCVTMUv1i32)
  .value("FCVTMUv1i64", LIEF::assembly::aarch64::OPCODE::FCVTMUv1i64)
  .value("FCVTMUv2f32", LIEF::assembly::aarch64::OPCODE::FCVTMUv2f32)
  .value("FCVTMUv2f64", LIEF::assembly::aarch64::OPCODE::FCVTMUv2f64)
  .value("FCVTMUv4f16", LIEF::assembly::aarch64::OPCODE::FCVTMUv4f16)
  .value("FCVTMUv4f32", LIEF::assembly::aarch64::OPCODE::FCVTMUv4f32)
  .value("FCVTMUv8f16", LIEF::assembly::aarch64::OPCODE::FCVTMUv8f16)
  .value("FCVTNB_Z2Z_StoB", LIEF::assembly::aarch64::OPCODE::FCVTNB_Z2Z_StoB)
  .value("FCVTNSDHr", LIEF::assembly::aarch64::OPCODE::FCVTNSDHr)
  .value("FCVTNSDSr", LIEF::assembly::aarch64::OPCODE::FCVTNSDSr)
  .value("FCVTNSSDr", LIEF::assembly::aarch64::OPCODE::FCVTNSSDr)
  .value("FCVTNSSHr", LIEF::assembly::aarch64::OPCODE::FCVTNSSHr)
  .value("FCVTNSUWDr", LIEF::assembly::aarch64::OPCODE::FCVTNSUWDr)
  .value("FCVTNSUWHr", LIEF::assembly::aarch64::OPCODE::FCVTNSUWHr)
  .value("FCVTNSUWSr", LIEF::assembly::aarch64::OPCODE::FCVTNSUWSr)
  .value("FCVTNSUXDr", LIEF::assembly::aarch64::OPCODE::FCVTNSUXDr)
  .value("FCVTNSUXHr", LIEF::assembly::aarch64::OPCODE::FCVTNSUXHr)
  .value("FCVTNSUXSr", LIEF::assembly::aarch64::OPCODE::FCVTNSUXSr)
  .value("FCVTNSv1f16", LIEF::assembly::aarch64::OPCODE::FCVTNSv1f16)
  .value("FCVTNSv1i32", LIEF::assembly::aarch64::OPCODE::FCVTNSv1i32)
  .value("FCVTNSv1i64", LIEF::assembly::aarch64::OPCODE::FCVTNSv1i64)
  .value("FCVTNSv2f32", LIEF::assembly::aarch64::OPCODE::FCVTNSv2f32)
  .value("FCVTNSv2f64", LIEF::assembly::aarch64::OPCODE::FCVTNSv2f64)
  .value("FCVTNSv4f16", LIEF::assembly::aarch64::OPCODE::FCVTNSv4f16)
  .value("FCVTNSv4f32", LIEF::assembly::aarch64::OPCODE::FCVTNSv4f32)
  .value("FCVTNSv8f16", LIEF::assembly::aarch64::OPCODE::FCVTNSv8f16)
  .value("FCVTNT_Z2Z_StoB", LIEF::assembly::aarch64::OPCODE::FCVTNT_Z2Z_StoB)
  .value("FCVTNT_ZPmZ_DtoS", LIEF::assembly::aarch64::OPCODE::FCVTNT_ZPmZ_DtoS)
  .value("FCVTNT_ZPmZ_StoH", LIEF::assembly::aarch64::OPCODE::FCVTNT_ZPmZ_StoH)
  .value("FCVTNT_ZPzZ_DtoS", LIEF::assembly::aarch64::OPCODE::FCVTNT_ZPzZ_DtoS)
  .value("FCVTNT_ZPzZ_StoH", LIEF::assembly::aarch64::OPCODE::FCVTNT_ZPzZ_StoH)
  .value("FCVTNUDHr", LIEF::assembly::aarch64::OPCODE::FCVTNUDHr)
  .value("FCVTNUDSr", LIEF::assembly::aarch64::OPCODE::FCVTNUDSr)
  .value("FCVTNUSDr", LIEF::assembly::aarch64::OPCODE::FCVTNUSDr)
  .value("FCVTNUSHr", LIEF::assembly::aarch64::OPCODE::FCVTNUSHr)
  .value("FCVTNUUWDr", LIEF::assembly::aarch64::OPCODE::FCVTNUUWDr)
  .value("FCVTNUUWHr", LIEF::assembly::aarch64::OPCODE::FCVTNUUWHr)
  .value("FCVTNUUWSr", LIEF::assembly::aarch64::OPCODE::FCVTNUUWSr)
  .value("FCVTNUUXDr", LIEF::assembly::aarch64::OPCODE::FCVTNUUXDr)
  .value("FCVTNUUXHr", LIEF::assembly::aarch64::OPCODE::FCVTNUUXHr)
  .value("FCVTNUUXSr", LIEF::assembly::aarch64::OPCODE::FCVTNUUXSr)
  .value("FCVTNUv1f16", LIEF::assembly::aarch64::OPCODE::FCVTNUv1f16)
  .value("FCVTNUv1i32", LIEF::assembly::aarch64::OPCODE::FCVTNUv1i32)
  .value("FCVTNUv1i64", LIEF::assembly::aarch64::OPCODE::FCVTNUv1i64)
  .value("FCVTNUv2f32", LIEF::assembly::aarch64::OPCODE::FCVTNUv2f32)
  .value("FCVTNUv2f64", LIEF::assembly::aarch64::OPCODE::FCVTNUv2f64)
  .value("FCVTNUv4f16", LIEF::assembly::aarch64::OPCODE::FCVTNUv4f16)
  .value("FCVTNUv4f32", LIEF::assembly::aarch64::OPCODE::FCVTNUv4f32)
  .value("FCVTNUv8f16", LIEF::assembly::aarch64::OPCODE::FCVTNUv8f16)
  .value("FCVTN_F16v16f8", LIEF::assembly::aarch64::OPCODE::FCVTN_F16v16f8)
  .value("FCVTN_F16v8f8", LIEF::assembly::aarch64::OPCODE::FCVTN_F16v8f8)
  .value("FCVTN_F322v16f8", LIEF::assembly::aarch64::OPCODE::FCVTN_F322v16f8)
  .value("FCVTN_F32v8f8", LIEF::assembly::aarch64::OPCODE::FCVTN_F32v8f8)
  .value("FCVTN_Z2Z_HtoB", LIEF::assembly::aarch64::OPCODE::FCVTN_Z2Z_HtoB)
  .value("FCVTN_Z2Z_StoH", LIEF::assembly::aarch64::OPCODE::FCVTN_Z2Z_StoH)
  .value("FCVTN_Z4Z_StoB", LIEF::assembly::aarch64::OPCODE::FCVTN_Z4Z_StoB)
  .value("FCVTNv2i32", LIEF::assembly::aarch64::OPCODE::FCVTNv2i32)
  .value("FCVTNv4i16", LIEF::assembly::aarch64::OPCODE::FCVTNv4i16)
  .value("FCVTNv4i32", LIEF::assembly::aarch64::OPCODE::FCVTNv4i32)
  .value("FCVTNv8i16", LIEF::assembly::aarch64::OPCODE::FCVTNv8i16)
  .value("FCVTPSDHr", LIEF::assembly::aarch64::OPCODE::FCVTPSDHr)
  .value("FCVTPSDSr", LIEF::assembly::aarch64::OPCODE::FCVTPSDSr)
  .value("FCVTPSSDr", LIEF::assembly::aarch64::OPCODE::FCVTPSSDr)
  .value("FCVTPSSHr", LIEF::assembly::aarch64::OPCODE::FCVTPSSHr)
  .value("FCVTPSUWDr", LIEF::assembly::aarch64::OPCODE::FCVTPSUWDr)
  .value("FCVTPSUWHr", LIEF::assembly::aarch64::OPCODE::FCVTPSUWHr)
  .value("FCVTPSUWSr", LIEF::assembly::aarch64::OPCODE::FCVTPSUWSr)
  .value("FCVTPSUXDr", LIEF::assembly::aarch64::OPCODE::FCVTPSUXDr)
  .value("FCVTPSUXHr", LIEF::assembly::aarch64::OPCODE::FCVTPSUXHr)
  .value("FCVTPSUXSr", LIEF::assembly::aarch64::OPCODE::FCVTPSUXSr)
  .value("FCVTPSv1f16", LIEF::assembly::aarch64::OPCODE::FCVTPSv1f16)
  .value("FCVTPSv1i32", LIEF::assembly::aarch64::OPCODE::FCVTPSv1i32)
  .value("FCVTPSv1i64", LIEF::assembly::aarch64::OPCODE::FCVTPSv1i64)
  .value("FCVTPSv2f32", LIEF::assembly::aarch64::OPCODE::FCVTPSv2f32)
  .value("FCVTPSv2f64", LIEF::assembly::aarch64::OPCODE::FCVTPSv2f64)
  .value("FCVTPSv4f16", LIEF::assembly::aarch64::OPCODE::FCVTPSv4f16)
  .value("FCVTPSv4f32", LIEF::assembly::aarch64::OPCODE::FCVTPSv4f32)
  .value("FCVTPSv8f16", LIEF::assembly::aarch64::OPCODE::FCVTPSv8f16)
  .value("FCVTPUDHr", LIEF::assembly::aarch64::OPCODE::FCVTPUDHr)
  .value("FCVTPUDSr", LIEF::assembly::aarch64::OPCODE::FCVTPUDSr)
  .value("FCVTPUSDr", LIEF::assembly::aarch64::OPCODE::FCVTPUSDr)
  .value("FCVTPUSHr", LIEF::assembly::aarch64::OPCODE::FCVTPUSHr)
  .value("FCVTPUUWDr", LIEF::assembly::aarch64::OPCODE::FCVTPUUWDr)
  .value("FCVTPUUWHr", LIEF::assembly::aarch64::OPCODE::FCVTPUUWHr)
  .value("FCVTPUUWSr", LIEF::assembly::aarch64::OPCODE::FCVTPUUWSr)
  .value("FCVTPUUXDr", LIEF::assembly::aarch64::OPCODE::FCVTPUUXDr)
  .value("FCVTPUUXHr", LIEF::assembly::aarch64::OPCODE::FCVTPUUXHr)
  .value("FCVTPUUXSr", LIEF::assembly::aarch64::OPCODE::FCVTPUUXSr)
  .value("FCVTPUv1f16", LIEF::assembly::aarch64::OPCODE::FCVTPUv1f16)
  .value("FCVTPUv1i32", LIEF::assembly::aarch64::OPCODE::FCVTPUv1i32)
  .value("FCVTPUv1i64", LIEF::assembly::aarch64::OPCODE::FCVTPUv1i64)
  .value("FCVTPUv2f32", LIEF::assembly::aarch64::OPCODE::FCVTPUv2f32)
  .value("FCVTPUv2f64", LIEF::assembly::aarch64::OPCODE::FCVTPUv2f64)
  .value("FCVTPUv4f16", LIEF::assembly::aarch64::OPCODE::FCVTPUv4f16)
  .value("FCVTPUv4f32", LIEF::assembly::aarch64::OPCODE::FCVTPUv4f32)
  .value("FCVTPUv8f16", LIEF::assembly::aarch64::OPCODE::FCVTPUv8f16)
  .value("FCVTSDr", LIEF::assembly::aarch64::OPCODE::FCVTSDr)
  .value("FCVTSHr", LIEF::assembly::aarch64::OPCODE::FCVTSHr)
  .value("FCVTXNT_ZPmZ_DtoS", LIEF::assembly::aarch64::OPCODE::FCVTXNT_ZPmZ_DtoS)
  .value("FCVTXNT_ZPzZ", LIEF::assembly::aarch64::OPCODE::FCVTXNT_ZPzZ)
  .value("FCVTXNv1i64", LIEF::assembly::aarch64::OPCODE::FCVTXNv1i64)
  .value("FCVTXNv2f32", LIEF::assembly::aarch64::OPCODE::FCVTXNv2f32)
  .value("FCVTXNv4f32", LIEF::assembly::aarch64::OPCODE::FCVTXNv4f32)
  .value("FCVTX_ZPmZ_DtoS", LIEF::assembly::aarch64::OPCODE::FCVTX_ZPmZ_DtoS)
  .value("FCVTX_ZPzZ_DtoS", LIEF::assembly::aarch64::OPCODE::FCVTX_ZPzZ_DtoS)
  .value("FCVTZSDHr", LIEF::assembly::aarch64::OPCODE::FCVTZSDHr)
  .value("FCVTZSDSr", LIEF::assembly::aarch64::OPCODE::FCVTZSDSr)
  .value("FCVTZSSDr", LIEF::assembly::aarch64::OPCODE::FCVTZSSDr)
  .value("FCVTZSSHr", LIEF::assembly::aarch64::OPCODE::FCVTZSSHr)
  .value("FCVTZSSWDri", LIEF::assembly::aarch64::OPCODE::FCVTZSSWDri)
  .value("FCVTZSSWHri", LIEF::assembly::aarch64::OPCODE::FCVTZSSWHri)
  .value("FCVTZSSWSri", LIEF::assembly::aarch64::OPCODE::FCVTZSSWSri)
  .value("FCVTZSSXDri", LIEF::assembly::aarch64::OPCODE::FCVTZSSXDri)
  .value("FCVTZSSXHri", LIEF::assembly::aarch64::OPCODE::FCVTZSSXHri)
  .value("FCVTZSSXSri", LIEF::assembly::aarch64::OPCODE::FCVTZSSXSri)
  .value("FCVTZSUWDr", LIEF::assembly::aarch64::OPCODE::FCVTZSUWDr)
  .value("FCVTZSUWHr", LIEF::assembly::aarch64::OPCODE::FCVTZSUWHr)
  .value("FCVTZSUWSr", LIEF::assembly::aarch64::OPCODE::FCVTZSUWSr)
  .value("FCVTZSUXDr", LIEF::assembly::aarch64::OPCODE::FCVTZSUXDr)
  .value("FCVTZSUXHr", LIEF::assembly::aarch64::OPCODE::FCVTZSUXHr)
  .value("FCVTZSUXSr", LIEF::assembly::aarch64::OPCODE::FCVTZSUXSr)
  .value("FCVTZS_2Z2Z_StoS", LIEF::assembly::aarch64::OPCODE::FCVTZS_2Z2Z_StoS)
  .value("FCVTZS_4Z4Z_StoS", LIEF::assembly::aarch64::OPCODE::FCVTZS_4Z4Z_StoS)
  .value("FCVTZS_ZPmZ_DtoD", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPmZ_DtoD)
  .value("FCVTZS_ZPmZ_DtoS", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPmZ_DtoS)
  .value("FCVTZS_ZPmZ_HtoD", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPmZ_HtoD)
  .value("FCVTZS_ZPmZ_HtoH", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPmZ_HtoH)
  .value("FCVTZS_ZPmZ_HtoS", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPmZ_HtoS)
  .value("FCVTZS_ZPmZ_StoD", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPmZ_StoD)
  .value("FCVTZS_ZPmZ_StoS", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPmZ_StoS)
  .value("FCVTZS_ZPzZ_DtoD", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPzZ_DtoD)
  .value("FCVTZS_ZPzZ_DtoS", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPzZ_DtoS)
  .value("FCVTZS_ZPzZ_HtoD", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPzZ_HtoD)
  .value("FCVTZS_ZPzZ_HtoH", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPzZ_HtoH)
  .value("FCVTZS_ZPzZ_HtoS", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPzZ_HtoS)
  .value("FCVTZS_ZPzZ_StoD", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPzZ_StoD)
  .value("FCVTZS_ZPzZ_StoS", LIEF::assembly::aarch64::OPCODE::FCVTZS_ZPzZ_StoS)
  .value("FCVTZSd", LIEF::assembly::aarch64::OPCODE::FCVTZSd)
  .value("FCVTZSh", LIEF::assembly::aarch64::OPCODE::FCVTZSh)
  .value("FCVTZSs", LIEF::assembly::aarch64::OPCODE::FCVTZSs)
  .value("FCVTZSv1f16", LIEF::assembly::aarch64::OPCODE::FCVTZSv1f16)
  .value("FCVTZSv1i32", LIEF::assembly::aarch64::OPCODE::FCVTZSv1i32)
  .value("FCVTZSv1i64", LIEF::assembly::aarch64::OPCODE::FCVTZSv1i64)
  .value("FCVTZSv2f32", LIEF::assembly::aarch64::OPCODE::FCVTZSv2f32)
  .value("FCVTZSv2f64", LIEF::assembly::aarch64::OPCODE::FCVTZSv2f64)
  .value("FCVTZSv2i32_shift", LIEF::assembly::aarch64::OPCODE::FCVTZSv2i32_shift)
  .value("FCVTZSv2i64_shift", LIEF::assembly::aarch64::OPCODE::FCVTZSv2i64_shift)
  .value("FCVTZSv4f16", LIEF::assembly::aarch64::OPCODE::FCVTZSv4f16)
  .value("FCVTZSv4f32", LIEF::assembly::aarch64::OPCODE::FCVTZSv4f32)
  .value("FCVTZSv4i16_shift", LIEF::assembly::aarch64::OPCODE::FCVTZSv4i16_shift)
  .value("FCVTZSv4i32_shift", LIEF::assembly::aarch64::OPCODE::FCVTZSv4i32_shift)
  .value("FCVTZSv8f16", LIEF::assembly::aarch64::OPCODE::FCVTZSv8f16)
  .value("FCVTZSv8i16_shift", LIEF::assembly::aarch64::OPCODE::FCVTZSv8i16_shift)
  .value("FCVTZUDHr", LIEF::assembly::aarch64::OPCODE::FCVTZUDHr)
  .value("FCVTZUDSr", LIEF::assembly::aarch64::OPCODE::FCVTZUDSr)
  .value("FCVTZUSDr", LIEF::assembly::aarch64::OPCODE::FCVTZUSDr)
  .value("FCVTZUSHr", LIEF::assembly::aarch64::OPCODE::FCVTZUSHr)
  .value("FCVTZUSWDri", LIEF::assembly::aarch64::OPCODE::FCVTZUSWDri)
  .value("FCVTZUSWHri", LIEF::assembly::aarch64::OPCODE::FCVTZUSWHri)
  .value("FCVTZUSWSri", LIEF::assembly::aarch64::OPCODE::FCVTZUSWSri)
  .value("FCVTZUSXDri", LIEF::assembly::aarch64::OPCODE::FCVTZUSXDri)
  .value("FCVTZUSXHri", LIEF::assembly::aarch64::OPCODE::FCVTZUSXHri)
  .value("FCVTZUSXSri", LIEF::assembly::aarch64::OPCODE::FCVTZUSXSri)
  .value("FCVTZUUWDr", LIEF::assembly::aarch64::OPCODE::FCVTZUUWDr)
  .value("FCVTZUUWHr", LIEF::assembly::aarch64::OPCODE::FCVTZUUWHr)
  .value("FCVTZUUWSr", LIEF::assembly::aarch64::OPCODE::FCVTZUUWSr)
  .value("FCVTZUUXDr", LIEF::assembly::aarch64::OPCODE::FCVTZUUXDr)
  .value("FCVTZUUXHr", LIEF::assembly::aarch64::OPCODE::FCVTZUUXHr)
  .value("FCVTZUUXSr", LIEF::assembly::aarch64::OPCODE::FCVTZUUXSr)
  .value("FCVTZU_2Z2Z_StoS", LIEF::assembly::aarch64::OPCODE::FCVTZU_2Z2Z_StoS)
  .value("FCVTZU_4Z4Z_StoS", LIEF::assembly::aarch64::OPCODE::FCVTZU_4Z4Z_StoS)
  .value("FCVTZU_ZPmZ_DtoD", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPmZ_DtoD)
  .value("FCVTZU_ZPmZ_DtoS", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPmZ_DtoS)
  .value("FCVTZU_ZPmZ_HtoD", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPmZ_HtoD)
  .value("FCVTZU_ZPmZ_HtoH", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPmZ_HtoH)
  .value("FCVTZU_ZPmZ_HtoS", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPmZ_HtoS)
  .value("FCVTZU_ZPmZ_StoD", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPmZ_StoD)
  .value("FCVTZU_ZPmZ_StoS", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPmZ_StoS)
  .value("FCVTZU_ZPzZ_DtoD", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPzZ_DtoD)
  .value("FCVTZU_ZPzZ_DtoS", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPzZ_DtoS)
  .value("FCVTZU_ZPzZ_HtoD", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPzZ_HtoD)
  .value("FCVTZU_ZPzZ_HtoH", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPzZ_HtoH)
  .value("FCVTZU_ZPzZ_HtoS", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPzZ_HtoS)
  .value("FCVTZU_ZPzZ_StoD", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPzZ_StoD)
  .value("FCVTZU_ZPzZ_StoS", LIEF::assembly::aarch64::OPCODE::FCVTZU_ZPzZ_StoS)
  .value("FCVTZUd", LIEF::assembly::aarch64::OPCODE::FCVTZUd)
  .value("FCVTZUh", LIEF::assembly::aarch64::OPCODE::FCVTZUh)
  .value("FCVTZUs", LIEF::assembly::aarch64::OPCODE::FCVTZUs)
  .value("FCVTZUv1f16", LIEF::assembly::aarch64::OPCODE::FCVTZUv1f16)
  .value("FCVTZUv1i32", LIEF::assembly::aarch64::OPCODE::FCVTZUv1i32)
  .value("FCVTZUv1i64", LIEF::assembly::aarch64::OPCODE::FCVTZUv1i64)
  .value("FCVTZUv2f32", LIEF::assembly::aarch64::OPCODE::FCVTZUv2f32)
  .value("FCVTZUv2f64", LIEF::assembly::aarch64::OPCODE::FCVTZUv2f64)
  .value("FCVTZUv2i32_shift", LIEF::assembly::aarch64::OPCODE::FCVTZUv2i32_shift)
  .value("FCVTZUv2i64_shift", LIEF::assembly::aarch64::OPCODE::FCVTZUv2i64_shift)
  .value("FCVTZUv4f16", LIEF::assembly::aarch64::OPCODE::FCVTZUv4f16)
  .value("FCVTZUv4f32", LIEF::assembly::aarch64::OPCODE::FCVTZUv4f32)
  .value("FCVTZUv4i16_shift", LIEF::assembly::aarch64::OPCODE::FCVTZUv4i16_shift)
  .value("FCVTZUv4i32_shift", LIEF::assembly::aarch64::OPCODE::FCVTZUv4i32_shift)
  .value("FCVTZUv8f16", LIEF::assembly::aarch64::OPCODE::FCVTZUv8f16)
  .value("FCVTZUv8i16_shift", LIEF::assembly::aarch64::OPCODE::FCVTZUv8i16_shift)
  .value("FCVT_2ZZ_H_S", LIEF::assembly::aarch64::OPCODE::FCVT_2ZZ_H_S)
  .value("FCVT_Z2Z_HtoB", LIEF::assembly::aarch64::OPCODE::FCVT_Z2Z_HtoB)
  .value("FCVT_Z2Z_StoH", LIEF::assembly::aarch64::OPCODE::FCVT_Z2Z_StoH)
  .value("FCVT_Z4Z_StoB", LIEF::assembly::aarch64::OPCODE::FCVT_Z4Z_StoB)
  .value("FCVT_ZPmZ_DtoH", LIEF::assembly::aarch64::OPCODE::FCVT_ZPmZ_DtoH)
  .value("FCVT_ZPmZ_DtoS", LIEF::assembly::aarch64::OPCODE::FCVT_ZPmZ_DtoS)
  .value("FCVT_ZPmZ_HtoD", LIEF::assembly::aarch64::OPCODE::FCVT_ZPmZ_HtoD)
  .value("FCVT_ZPmZ_HtoS", LIEF::assembly::aarch64::OPCODE::FCVT_ZPmZ_HtoS)
  .value("FCVT_ZPmZ_StoD", LIEF::assembly::aarch64::OPCODE::FCVT_ZPmZ_StoD)
  .value("FCVT_ZPmZ_StoH", LIEF::assembly::aarch64::OPCODE::FCVT_ZPmZ_StoH)
  .value("FCVT_ZPzZ_DtoH", LIEF::assembly::aarch64::OPCODE::FCVT_ZPzZ_DtoH)
  .value("FCVT_ZPzZ_DtoS", LIEF::assembly::aarch64::OPCODE::FCVT_ZPzZ_DtoS)
  .value("FCVT_ZPzZ_HtoD", LIEF::assembly::aarch64::OPCODE::FCVT_ZPzZ_HtoD)
  .value("FCVT_ZPzZ_HtoS", LIEF::assembly::aarch64::OPCODE::FCVT_ZPzZ_HtoS)
  .value("FCVT_ZPzZ_StoD", LIEF::assembly::aarch64::OPCODE::FCVT_ZPzZ_StoD)
  .value("FCVT_ZPzZ_StoH", LIEF::assembly::aarch64::OPCODE::FCVT_ZPzZ_StoH)
  .value("FDIVDrr", LIEF::assembly::aarch64::OPCODE::FDIVDrr)
  .value("FDIVHrr", LIEF::assembly::aarch64::OPCODE::FDIVHrr)
  .value("FDIVR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FDIVR_ZPmZ_D)
  .value("FDIVR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FDIVR_ZPmZ_H)
  .value("FDIVR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FDIVR_ZPmZ_S)
  .value("FDIVSrr", LIEF::assembly::aarch64::OPCODE::FDIVSrr)
  .value("FDIV_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FDIV_ZPmZ_D)
  .value("FDIV_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FDIV_ZPmZ_H)
  .value("FDIV_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FDIV_ZPmZ_S)
  .value("FDIVv2f32", LIEF::assembly::aarch64::OPCODE::FDIVv2f32)
  .value("FDIVv2f64", LIEF::assembly::aarch64::OPCODE::FDIVv2f64)
  .value("FDIVv4f16", LIEF::assembly::aarch64::OPCODE::FDIVv4f16)
  .value("FDIVv4f32", LIEF::assembly::aarch64::OPCODE::FDIVv4f32)
  .value("FDIVv8f16", LIEF::assembly::aarch64::OPCODE::FDIVv8f16)
  .value("FDOT_VG2_M2Z2Z_BtoH", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2Z2Z_BtoH)
  .value("FDOT_VG2_M2Z2Z_BtoS", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2Z2Z_BtoS)
  .value("FDOT_VG2_M2Z2Z_HtoS", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2Z2Z_HtoS)
  .value("FDOT_VG2_M2ZZI_BtoH", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2ZZI_BtoH)
  .value("FDOT_VG2_M2ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2ZZI_BtoS)
  .value("FDOT_VG2_M2ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2ZZI_HtoS)
  .value("FDOT_VG2_M2ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2ZZ_BtoH)
  .value("FDOT_VG2_M2ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2ZZ_BtoS)
  .value("FDOT_VG2_M2ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::FDOT_VG2_M2ZZ_HtoS)
  .value("FDOT_VG4_M4Z4Z_BtoH", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4Z4Z_BtoH)
  .value("FDOT_VG4_M4Z4Z_BtoS", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4Z4Z_BtoS)
  .value("FDOT_VG4_M4Z4Z_HtoS", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4Z4Z_HtoS)
  .value("FDOT_VG4_M4ZZI_BtoH", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4ZZI_BtoH)
  .value("FDOT_VG4_M4ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4ZZI_BtoS)
  .value("FDOT_VG4_M4ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4ZZI_HtoS)
  .value("FDOT_VG4_M4ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4ZZ_BtoH)
  .value("FDOT_VG4_M4ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4ZZ_BtoS)
  .value("FDOT_VG4_M4ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::FDOT_VG4_M4ZZ_HtoS)
  .value("FDOT_ZZZI_BtoH", LIEF::assembly::aarch64::OPCODE::FDOT_ZZZI_BtoH)
  .value("FDOT_ZZZI_BtoS", LIEF::assembly::aarch64::OPCODE::FDOT_ZZZI_BtoS)
  .value("FDOT_ZZZI_S", LIEF::assembly::aarch64::OPCODE::FDOT_ZZZI_S)
  .value("FDOT_ZZZ_BtoH", LIEF::assembly::aarch64::OPCODE::FDOT_ZZZ_BtoH)
  .value("FDOT_ZZZ_BtoS", LIEF::assembly::aarch64::OPCODE::FDOT_ZZZ_BtoS)
  .value("FDOT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::FDOT_ZZZ_S)
  .value("FDOTlanev2f32", LIEF::assembly::aarch64::OPCODE::FDOTlanev2f32)
  .value("FDOTlanev4f16", LIEF::assembly::aarch64::OPCODE::FDOTlanev4f16)
  .value("FDOTlanev4f32", LIEF::assembly::aarch64::OPCODE::FDOTlanev4f32)
  .value("FDOTlanev8f16", LIEF::assembly::aarch64::OPCODE::FDOTlanev8f16)
  .value("FDOTv2f32", LIEF::assembly::aarch64::OPCODE::FDOTv2f32)
  .value("FDOTv4f16", LIEF::assembly::aarch64::OPCODE::FDOTv4f16)
  .value("FDOTv4f32", LIEF::assembly::aarch64::OPCODE::FDOTv4f32)
  .value("FDOTv8f16", LIEF::assembly::aarch64::OPCODE::FDOTv8f16)
  .value("FDUP_ZI_D", LIEF::assembly::aarch64::OPCODE::FDUP_ZI_D)
  .value("FDUP_ZI_H", LIEF::assembly::aarch64::OPCODE::FDUP_ZI_H)
  .value("FDUP_ZI_S", LIEF::assembly::aarch64::OPCODE::FDUP_ZI_S)
  .value("FEXPA_ZZ_D", LIEF::assembly::aarch64::OPCODE::FEXPA_ZZ_D)
  .value("FEXPA_ZZ_H", LIEF::assembly::aarch64::OPCODE::FEXPA_ZZ_H)
  .value("FEXPA_ZZ_S", LIEF::assembly::aarch64::OPCODE::FEXPA_ZZ_S)
  .value("FIRSTP_XPP_B", LIEF::assembly::aarch64::OPCODE::FIRSTP_XPP_B)
  .value("FIRSTP_XPP_D", LIEF::assembly::aarch64::OPCODE::FIRSTP_XPP_D)
  .value("FIRSTP_XPP_H", LIEF::assembly::aarch64::OPCODE::FIRSTP_XPP_H)
  .value("FIRSTP_XPP_S", LIEF::assembly::aarch64::OPCODE::FIRSTP_XPP_S);
  opcodes.value("FJCVTZS", LIEF::assembly::aarch64::OPCODE::FJCVTZS)
  .value("FLOGB_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FLOGB_ZPmZ_D)
  .value("FLOGB_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FLOGB_ZPmZ_H)
  .value("FLOGB_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FLOGB_ZPmZ_S)
  .value("FLOGB_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FLOGB_ZPzZ_D)
  .value("FLOGB_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::FLOGB_ZPzZ_H)
  .value("FLOGB_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FLOGB_ZPzZ_S)
  .value("FMADDDrrr", LIEF::assembly::aarch64::OPCODE::FMADDDrrr)
  .value("FMADDHrrr", LIEF::assembly::aarch64::OPCODE::FMADDHrrr)
  .value("FMADDSrrr", LIEF::assembly::aarch64::OPCODE::FMADDSrrr)
  .value("FMAD_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::FMAD_ZPmZZ_D)
  .value("FMAD_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::FMAD_ZPmZZ_H)
  .value("FMAD_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::FMAD_ZPmZZ_S)
  .value("FMAXDrr", LIEF::assembly::aarch64::OPCODE::FMAXDrr)
  .value("FMAXHrr", LIEF::assembly::aarch64::OPCODE::FMAXHrr)
  .value("FMAXNMDrr", LIEF::assembly::aarch64::OPCODE::FMAXNMDrr)
  .value("FMAXNMHrr", LIEF::assembly::aarch64::OPCODE::FMAXNMHrr)
  .value("FMAXNMP_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::FMAXNMP_ZPmZZ_D)
  .value("FMAXNMP_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::FMAXNMP_ZPmZZ_H)
  .value("FMAXNMP_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::FMAXNMP_ZPmZZ_S)
  .value("FMAXNMPv2f32", LIEF::assembly::aarch64::OPCODE::FMAXNMPv2f32)
  .value("FMAXNMPv2f64", LIEF::assembly::aarch64::OPCODE::FMAXNMPv2f64)
  .value("FMAXNMPv2i16p", LIEF::assembly::aarch64::OPCODE::FMAXNMPv2i16p)
  .value("FMAXNMPv2i32p", LIEF::assembly::aarch64::OPCODE::FMAXNMPv2i32p)
  .value("FMAXNMPv2i64p", LIEF::assembly::aarch64::OPCODE::FMAXNMPv2i64p)
  .value("FMAXNMPv4f16", LIEF::assembly::aarch64::OPCODE::FMAXNMPv4f16)
  .value("FMAXNMPv4f32", LIEF::assembly::aarch64::OPCODE::FMAXNMPv4f32)
  .value("FMAXNMPv8f16", LIEF::assembly::aarch64::OPCODE::FMAXNMPv8f16)
  .value("FMAXNMQV_D", LIEF::assembly::aarch64::OPCODE::FMAXNMQV_D)
  .value("FMAXNMQV_H", LIEF::assembly::aarch64::OPCODE::FMAXNMQV_H)
  .value("FMAXNMQV_S", LIEF::assembly::aarch64::OPCODE::FMAXNMQV_S)
  .value("FMAXNMSrr", LIEF::assembly::aarch64::OPCODE::FMAXNMSrr)
  .value("FMAXNMV_VPZ_D", LIEF::assembly::aarch64::OPCODE::FMAXNMV_VPZ_D)
  .value("FMAXNMV_VPZ_H", LIEF::assembly::aarch64::OPCODE::FMAXNMV_VPZ_H)
  .value("FMAXNMV_VPZ_S", LIEF::assembly::aarch64::OPCODE::FMAXNMV_VPZ_S)
  .value("FMAXNMVv4i16v", LIEF::assembly::aarch64::OPCODE::FMAXNMVv4i16v)
  .value("FMAXNMVv4i32v", LIEF::assembly::aarch64::OPCODE::FMAXNMVv4i32v)
  .value("FMAXNMVv8i16v", LIEF::assembly::aarch64::OPCODE::FMAXNMVv8i16v)
  .value("FMAXNM_VG2_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::FMAXNM_VG2_2Z2Z_D)
  .value("FMAXNM_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::FMAXNM_VG2_2Z2Z_H)
  .value("FMAXNM_VG2_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FMAXNM_VG2_2Z2Z_S)
  .value("FMAXNM_VG2_2ZZ_D", LIEF::assembly::aarch64::OPCODE::FMAXNM_VG2_2ZZ_D)
  .value("FMAXNM_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::FMAXNM_VG2_2ZZ_H)
  .value("FMAXNM_VG2_2ZZ_S", LIEF::assembly::aarch64::OPCODE::FMAXNM_VG2_2ZZ_S)
  .value("FMAXNM_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::FMAXNM_VG4_4Z4Z_D)
  .value("FMAXNM_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::FMAXNM_VG4_4Z4Z_H)
  .value("FMAXNM_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FMAXNM_VG4_4Z4Z_S)
  .value("FMAXNM_VG4_4ZZ_D", LIEF::assembly::aarch64::OPCODE::FMAXNM_VG4_4ZZ_D)
  .value("FMAXNM_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::FMAXNM_VG4_4ZZ_H)
  .value("FMAXNM_VG4_4ZZ_S", LIEF::assembly::aarch64::OPCODE::FMAXNM_VG4_4ZZ_S)
  .value("FMAXNM_ZPmI_D", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPmI_D)
  .value("FMAXNM_ZPmI_H", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPmI_H)
  .value("FMAXNM_ZPmI_S", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPmI_S)
  .value("FMAXNM_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPmZ_D)
  .value("FMAXNM_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPmZ_H)
  .value("FMAXNM_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FMAXNM_ZPmZ_S)
  .value("FMAXNMv2f32", LIEF::assembly::aarch64::OPCODE::FMAXNMv2f32)
  .value("FMAXNMv2f64", LIEF::assembly::aarch64::OPCODE::FMAXNMv2f64)
  .value("FMAXNMv4f16", LIEF::assembly::aarch64::OPCODE::FMAXNMv4f16)
  .value("FMAXNMv4f32", LIEF::assembly::aarch64::OPCODE::FMAXNMv4f32)
  .value("FMAXNMv8f16", LIEF::assembly::aarch64::OPCODE::FMAXNMv8f16)
  .value("FMAXP_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::FMAXP_ZPmZZ_D)
  .value("FMAXP_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::FMAXP_ZPmZZ_H)
  .value("FMAXP_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::FMAXP_ZPmZZ_S)
  .value("FMAXPv2f32", LIEF::assembly::aarch64::OPCODE::FMAXPv2f32)
  .value("FMAXPv2f64", LIEF::assembly::aarch64::OPCODE::FMAXPv2f64)
  .value("FMAXPv2i16p", LIEF::assembly::aarch64::OPCODE::FMAXPv2i16p)
  .value("FMAXPv2i32p", LIEF::assembly::aarch64::OPCODE::FMAXPv2i32p)
  .value("FMAXPv2i64p", LIEF::assembly::aarch64::OPCODE::FMAXPv2i64p)
  .value("FMAXPv4f16", LIEF::assembly::aarch64::OPCODE::FMAXPv4f16)
  .value("FMAXPv4f32", LIEF::assembly::aarch64::OPCODE::FMAXPv4f32)
  .value("FMAXPv8f16", LIEF::assembly::aarch64::OPCODE::FMAXPv8f16)
  .value("FMAXQV_D", LIEF::assembly::aarch64::OPCODE::FMAXQV_D)
  .value("FMAXQV_H", LIEF::assembly::aarch64::OPCODE::FMAXQV_H)
  .value("FMAXQV_S", LIEF::assembly::aarch64::OPCODE::FMAXQV_S)
  .value("FMAXSrr", LIEF::assembly::aarch64::OPCODE::FMAXSrr)
  .value("FMAXV_VPZ_D", LIEF::assembly::aarch64::OPCODE::FMAXV_VPZ_D)
  .value("FMAXV_VPZ_H", LIEF::assembly::aarch64::OPCODE::FMAXV_VPZ_H)
  .value("FMAXV_VPZ_S", LIEF::assembly::aarch64::OPCODE::FMAXV_VPZ_S)
  .value("FMAXVv4i16v", LIEF::assembly::aarch64::OPCODE::FMAXVv4i16v)
  .value("FMAXVv4i32v", LIEF::assembly::aarch64::OPCODE::FMAXVv4i32v)
  .value("FMAXVv8i16v", LIEF::assembly::aarch64::OPCODE::FMAXVv8i16v)
  .value("FMAX_VG2_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::FMAX_VG2_2Z2Z_D)
  .value("FMAX_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::FMAX_VG2_2Z2Z_H)
  .value("FMAX_VG2_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FMAX_VG2_2Z2Z_S)
  .value("FMAX_VG2_2ZZ_D", LIEF::assembly::aarch64::OPCODE::FMAX_VG2_2ZZ_D)
  .value("FMAX_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::FMAX_VG2_2ZZ_H)
  .value("FMAX_VG2_2ZZ_S", LIEF::assembly::aarch64::OPCODE::FMAX_VG2_2ZZ_S)
  .value("FMAX_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::FMAX_VG4_4Z4Z_D)
  .value("FMAX_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::FMAX_VG4_4Z4Z_H)
  .value("FMAX_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FMAX_VG4_4Z4Z_S)
  .value("FMAX_VG4_4ZZ_D", LIEF::assembly::aarch64::OPCODE::FMAX_VG4_4ZZ_D)
  .value("FMAX_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::FMAX_VG4_4ZZ_H)
  .value("FMAX_VG4_4ZZ_S", LIEF::assembly::aarch64::OPCODE::FMAX_VG4_4ZZ_S)
  .value("FMAX_ZPmI_D", LIEF::assembly::aarch64::OPCODE::FMAX_ZPmI_D)
  .value("FMAX_ZPmI_H", LIEF::assembly::aarch64::OPCODE::FMAX_ZPmI_H)
  .value("FMAX_ZPmI_S", LIEF::assembly::aarch64::OPCODE::FMAX_ZPmI_S)
  .value("FMAX_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FMAX_ZPmZ_D)
  .value("FMAX_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FMAX_ZPmZ_H)
  .value("FMAX_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FMAX_ZPmZ_S)
  .value("FMAXv2f32", LIEF::assembly::aarch64::OPCODE::FMAXv2f32)
  .value("FMAXv2f64", LIEF::assembly::aarch64::OPCODE::FMAXv2f64)
  .value("FMAXv4f16", LIEF::assembly::aarch64::OPCODE::FMAXv4f16)
  .value("FMAXv4f32", LIEF::assembly::aarch64::OPCODE::FMAXv4f32)
  .value("FMAXv8f16", LIEF::assembly::aarch64::OPCODE::FMAXv8f16)
  .value("FMINDrr", LIEF::assembly::aarch64::OPCODE::FMINDrr)
  .value("FMINHrr", LIEF::assembly::aarch64::OPCODE::FMINHrr)
  .value("FMINNMDrr", LIEF::assembly::aarch64::OPCODE::FMINNMDrr)
  .value("FMINNMHrr", LIEF::assembly::aarch64::OPCODE::FMINNMHrr)
  .value("FMINNMP_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::FMINNMP_ZPmZZ_D)
  .value("FMINNMP_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::FMINNMP_ZPmZZ_H)
  .value("FMINNMP_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::FMINNMP_ZPmZZ_S)
  .value("FMINNMPv2f32", LIEF::assembly::aarch64::OPCODE::FMINNMPv2f32)
  .value("FMINNMPv2f64", LIEF::assembly::aarch64::OPCODE::FMINNMPv2f64)
  .value("FMINNMPv2i16p", LIEF::assembly::aarch64::OPCODE::FMINNMPv2i16p)
  .value("FMINNMPv2i32p", LIEF::assembly::aarch64::OPCODE::FMINNMPv2i32p)
  .value("FMINNMPv2i64p", LIEF::assembly::aarch64::OPCODE::FMINNMPv2i64p)
  .value("FMINNMPv4f16", LIEF::assembly::aarch64::OPCODE::FMINNMPv4f16)
  .value("FMINNMPv4f32", LIEF::assembly::aarch64::OPCODE::FMINNMPv4f32)
  .value("FMINNMPv8f16", LIEF::assembly::aarch64::OPCODE::FMINNMPv8f16)
  .value("FMINNMQV_D", LIEF::assembly::aarch64::OPCODE::FMINNMQV_D)
  .value("FMINNMQV_H", LIEF::assembly::aarch64::OPCODE::FMINNMQV_H)
  .value("FMINNMQV_S", LIEF::assembly::aarch64::OPCODE::FMINNMQV_S)
  .value("FMINNMSrr", LIEF::assembly::aarch64::OPCODE::FMINNMSrr)
  .value("FMINNMV_VPZ_D", LIEF::assembly::aarch64::OPCODE::FMINNMV_VPZ_D)
  .value("FMINNMV_VPZ_H", LIEF::assembly::aarch64::OPCODE::FMINNMV_VPZ_H)
  .value("FMINNMV_VPZ_S", LIEF::assembly::aarch64::OPCODE::FMINNMV_VPZ_S)
  .value("FMINNMVv4i16v", LIEF::assembly::aarch64::OPCODE::FMINNMVv4i16v)
  .value("FMINNMVv4i32v", LIEF::assembly::aarch64::OPCODE::FMINNMVv4i32v)
  .value("FMINNMVv8i16v", LIEF::assembly::aarch64::OPCODE::FMINNMVv8i16v)
  .value("FMINNM_VG2_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::FMINNM_VG2_2Z2Z_D)
  .value("FMINNM_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::FMINNM_VG2_2Z2Z_H)
  .value("FMINNM_VG2_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FMINNM_VG2_2Z2Z_S)
  .value("FMINNM_VG2_2ZZ_D", LIEF::assembly::aarch64::OPCODE::FMINNM_VG2_2ZZ_D)
  .value("FMINNM_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::FMINNM_VG2_2ZZ_H)
  .value("FMINNM_VG2_2ZZ_S", LIEF::assembly::aarch64::OPCODE::FMINNM_VG2_2ZZ_S)
  .value("FMINNM_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::FMINNM_VG4_4Z4Z_D)
  .value("FMINNM_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::FMINNM_VG4_4Z4Z_H)
  .value("FMINNM_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FMINNM_VG4_4Z4Z_S)
  .value("FMINNM_VG4_4ZZ_D", LIEF::assembly::aarch64::OPCODE::FMINNM_VG4_4ZZ_D)
  .value("FMINNM_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::FMINNM_VG4_4ZZ_H)
  .value("FMINNM_VG4_4ZZ_S", LIEF::assembly::aarch64::OPCODE::FMINNM_VG4_4ZZ_S)
  .value("FMINNM_ZPmI_D", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPmI_D)
  .value("FMINNM_ZPmI_H", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPmI_H)
  .value("FMINNM_ZPmI_S", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPmI_S)
  .value("FMINNM_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPmZ_D)
  .value("FMINNM_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPmZ_H)
  .value("FMINNM_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FMINNM_ZPmZ_S)
  .value("FMINNMv2f32", LIEF::assembly::aarch64::OPCODE::FMINNMv2f32)
  .value("FMINNMv2f64", LIEF::assembly::aarch64::OPCODE::FMINNMv2f64)
  .value("FMINNMv4f16", LIEF::assembly::aarch64::OPCODE::FMINNMv4f16)
  .value("FMINNMv4f32", LIEF::assembly::aarch64::OPCODE::FMINNMv4f32)
  .value("FMINNMv8f16", LIEF::assembly::aarch64::OPCODE::FMINNMv8f16)
  .value("FMINP_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::FMINP_ZPmZZ_D)
  .value("FMINP_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::FMINP_ZPmZZ_H)
  .value("FMINP_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::FMINP_ZPmZZ_S)
  .value("FMINPv2f32", LIEF::assembly::aarch64::OPCODE::FMINPv2f32)
  .value("FMINPv2f64", LIEF::assembly::aarch64::OPCODE::FMINPv2f64)
  .value("FMINPv2i16p", LIEF::assembly::aarch64::OPCODE::FMINPv2i16p)
  .value("FMINPv2i32p", LIEF::assembly::aarch64::OPCODE::FMINPv2i32p)
  .value("FMINPv2i64p", LIEF::assembly::aarch64::OPCODE::FMINPv2i64p)
  .value("FMINPv4f16", LIEF::assembly::aarch64::OPCODE::FMINPv4f16)
  .value("FMINPv4f32", LIEF::assembly::aarch64::OPCODE::FMINPv4f32)
  .value("FMINPv8f16", LIEF::assembly::aarch64::OPCODE::FMINPv8f16)
  .value("FMINQV_D", LIEF::assembly::aarch64::OPCODE::FMINQV_D)
  .value("FMINQV_H", LIEF::assembly::aarch64::OPCODE::FMINQV_H)
  .value("FMINQV_S", LIEF::assembly::aarch64::OPCODE::FMINQV_S)
  .value("FMINSrr", LIEF::assembly::aarch64::OPCODE::FMINSrr)
  .value("FMINV_VPZ_D", LIEF::assembly::aarch64::OPCODE::FMINV_VPZ_D)
  .value("FMINV_VPZ_H", LIEF::assembly::aarch64::OPCODE::FMINV_VPZ_H)
  .value("FMINV_VPZ_S", LIEF::assembly::aarch64::OPCODE::FMINV_VPZ_S)
  .value("FMINVv4i16v", LIEF::assembly::aarch64::OPCODE::FMINVv4i16v)
  .value("FMINVv4i32v", LIEF::assembly::aarch64::OPCODE::FMINVv4i32v)
  .value("FMINVv8i16v", LIEF::assembly::aarch64::OPCODE::FMINVv8i16v)
  .value("FMIN_VG2_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::FMIN_VG2_2Z2Z_D)
  .value("FMIN_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::FMIN_VG2_2Z2Z_H)
  .value("FMIN_VG2_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FMIN_VG2_2Z2Z_S)
  .value("FMIN_VG2_2ZZ_D", LIEF::assembly::aarch64::OPCODE::FMIN_VG2_2ZZ_D)
  .value("FMIN_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::FMIN_VG2_2ZZ_H)
  .value("FMIN_VG2_2ZZ_S", LIEF::assembly::aarch64::OPCODE::FMIN_VG2_2ZZ_S)
  .value("FMIN_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::FMIN_VG4_4Z4Z_D)
  .value("FMIN_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::FMIN_VG4_4Z4Z_H)
  .value("FMIN_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FMIN_VG4_4Z4Z_S)
  .value("FMIN_VG4_4ZZ_D", LIEF::assembly::aarch64::OPCODE::FMIN_VG4_4ZZ_D)
  .value("FMIN_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::FMIN_VG4_4ZZ_H)
  .value("FMIN_VG4_4ZZ_S", LIEF::assembly::aarch64::OPCODE::FMIN_VG4_4ZZ_S)
  .value("FMIN_ZPmI_D", LIEF::assembly::aarch64::OPCODE::FMIN_ZPmI_D)
  .value("FMIN_ZPmI_H", LIEF::assembly::aarch64::OPCODE::FMIN_ZPmI_H)
  .value("FMIN_ZPmI_S", LIEF::assembly::aarch64::OPCODE::FMIN_ZPmI_S)
  .value("FMIN_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FMIN_ZPmZ_D)
  .value("FMIN_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FMIN_ZPmZ_H)
  .value("FMIN_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FMIN_ZPmZ_S)
  .value("FMINv2f32", LIEF::assembly::aarch64::OPCODE::FMINv2f32)
  .value("FMINv2f64", LIEF::assembly::aarch64::OPCODE::FMINv2f64)
  .value("FMINv4f16", LIEF::assembly::aarch64::OPCODE::FMINv4f16)
  .value("FMINv4f32", LIEF::assembly::aarch64::OPCODE::FMINv4f32)
  .value("FMINv8f16", LIEF::assembly::aarch64::OPCODE::FMINv8f16)
  .value("FMLAL2lanev4f16", LIEF::assembly::aarch64::OPCODE::FMLAL2lanev4f16)
  .value("FMLAL2lanev8f16", LIEF::assembly::aarch64::OPCODE::FMLAL2lanev8f16)
  .value("FMLAL2v4f16", LIEF::assembly::aarch64::OPCODE::FMLAL2v4f16)
  .value("FMLAL2v8f16", LIEF::assembly::aarch64::OPCODE::FMLAL2v8f16)
  .value("FMLALB_ZZZ", LIEF::assembly::aarch64::OPCODE::FMLALB_ZZZ)
  .value("FMLALB_ZZZI", LIEF::assembly::aarch64::OPCODE::FMLALB_ZZZI)
  .value("FMLALB_ZZZI_SHH", LIEF::assembly::aarch64::OPCODE::FMLALB_ZZZI_SHH)
  .value("FMLALB_ZZZ_SHH", LIEF::assembly::aarch64::OPCODE::FMLALB_ZZZ_SHH)
  .value("FMLALBlanev8f16", LIEF::assembly::aarch64::OPCODE::FMLALBlanev8f16)
  .value("FMLALBv8f16", LIEF::assembly::aarch64::OPCODE::FMLALBv8f16)
  .value("FMLALLBB_ZZZ", LIEF::assembly::aarch64::OPCODE::FMLALLBB_ZZZ)
  .value("FMLALLBB_ZZZI", LIEF::assembly::aarch64::OPCODE::FMLALLBB_ZZZI)
  .value("FMLALLBBlanev4f32", LIEF::assembly::aarch64::OPCODE::FMLALLBBlanev4f32)
  .value("FMLALLBBv4f32", LIEF::assembly::aarch64::OPCODE::FMLALLBBv4f32)
  .value("FMLALLBT_ZZZ", LIEF::assembly::aarch64::OPCODE::FMLALLBT_ZZZ)
  .value("FMLALLBT_ZZZI", LIEF::assembly::aarch64::OPCODE::FMLALLBT_ZZZI)
  .value("FMLALLBTlanev4f32", LIEF::assembly::aarch64::OPCODE::FMLALLBTlanev4f32)
  .value("FMLALLBTv4f32", LIEF::assembly::aarch64::OPCODE::FMLALLBTv4f32)
  .value("FMLALLTB_ZZZ", LIEF::assembly::aarch64::OPCODE::FMLALLTB_ZZZ)
  .value("FMLALLTB_ZZZI", LIEF::assembly::aarch64::OPCODE::FMLALLTB_ZZZI)
  .value("FMLALLTBlanev4f32", LIEF::assembly::aarch64::OPCODE::FMLALLTBlanev4f32)
  .value("FMLALLTBv4f32", LIEF::assembly::aarch64::OPCODE::FMLALLTBv4f32)
  .value("FMLALLTT_ZZZ", LIEF::assembly::aarch64::OPCODE::FMLALLTT_ZZZ)
  .value("FMLALLTT_ZZZI", LIEF::assembly::aarch64::OPCODE::FMLALLTT_ZZZI)
  .value("FMLALLTTlanev4f32", LIEF::assembly::aarch64::OPCODE::FMLALLTTlanev4f32)
  .value("FMLALLTTv4f32", LIEF::assembly::aarch64::OPCODE::FMLALLTTv4f32)
  .value("FMLALL_MZZI_BtoS", LIEF::assembly::aarch64::OPCODE::FMLALL_MZZI_BtoS)
  .value("FMLALL_MZZ_BtoS", LIEF::assembly::aarch64::OPCODE::FMLALL_MZZ_BtoS)
  .value("FMLALL_VG2_M2Z2Z_BtoS", LIEF::assembly::aarch64::OPCODE::FMLALL_VG2_M2Z2Z_BtoS)
  .value("FMLALL_VG2_M2ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::FMLALL_VG2_M2ZZI_BtoS)
  .value("FMLALL_VG2_M2ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::FMLALL_VG2_M2ZZ_BtoS)
  .value("FMLALL_VG4_M4Z4Z_BtoS", LIEF::assembly::aarch64::OPCODE::FMLALL_VG4_M4Z4Z_BtoS)
  .value("FMLALL_VG4_M4ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::FMLALL_VG4_M4ZZI_BtoS)
  .value("FMLALL_VG4_M4ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::FMLALL_VG4_M4ZZ_BtoS)
  .value("FMLALT_ZZZ", LIEF::assembly::aarch64::OPCODE::FMLALT_ZZZ)
  .value("FMLALT_ZZZI", LIEF::assembly::aarch64::OPCODE::FMLALT_ZZZI)
  .value("FMLALT_ZZZI_SHH", LIEF::assembly::aarch64::OPCODE::FMLALT_ZZZI_SHH)
  .value("FMLALT_ZZZ_SHH", LIEF::assembly::aarch64::OPCODE::FMLALT_ZZZ_SHH)
  .value("FMLALTlanev8f16", LIEF::assembly::aarch64::OPCODE::FMLALTlanev8f16)
  .value("FMLALTv8f16", LIEF::assembly::aarch64::OPCODE::FMLALTv8f16)
  .value("FMLAL_MZZI_BtoH", LIEF::assembly::aarch64::OPCODE::FMLAL_MZZI_BtoH)
  .value("FMLAL_MZZI_HtoS", LIEF::assembly::aarch64::OPCODE::FMLAL_MZZI_HtoS)
  .value("FMLAL_MZZ_HtoS", LIEF::assembly::aarch64::OPCODE::FMLAL_MZZ_HtoS)
  .value("FMLAL_VG2_M2Z2Z_BtoH", LIEF::assembly::aarch64::OPCODE::FMLAL_VG2_M2Z2Z_BtoH)
  .value("FMLAL_VG2_M2Z2Z_HtoS", LIEF::assembly::aarch64::OPCODE::FMLAL_VG2_M2Z2Z_HtoS)
  .value("FMLAL_VG2_M2ZZI_BtoH", LIEF::assembly::aarch64::OPCODE::FMLAL_VG2_M2ZZI_BtoH)
  .value("FMLAL_VG2_M2ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::FMLAL_VG2_M2ZZI_HtoS)
  .value("FMLAL_VG2_M2ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::FMLAL_VG2_M2ZZ_BtoH)
  .value("FMLAL_VG2_M2ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::FMLAL_VG2_M2ZZ_HtoS)
  .value("FMLAL_VG2_MZZ_BtoH", LIEF::assembly::aarch64::OPCODE::FMLAL_VG2_MZZ_BtoH)
  .value("FMLAL_VG4_M4Z4Z_BtoH", LIEF::assembly::aarch64::OPCODE::FMLAL_VG4_M4Z4Z_BtoH)
  .value("FMLAL_VG4_M4Z4Z_HtoS", LIEF::assembly::aarch64::OPCODE::FMLAL_VG4_M4Z4Z_HtoS)
  .value("FMLAL_VG4_M4ZZI_BtoH", LIEF::assembly::aarch64::OPCODE::FMLAL_VG4_M4ZZI_BtoH)
  .value("FMLAL_VG4_M4ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::FMLAL_VG4_M4ZZI_HtoS)
  .value("FMLAL_VG4_M4ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::FMLAL_VG4_M4ZZ_BtoH)
  .value("FMLAL_VG4_M4ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::FMLAL_VG4_M4ZZ_HtoS)
  .value("FMLALlanev4f16", LIEF::assembly::aarch64::OPCODE::FMLALlanev4f16)
  .value("FMLALlanev8f16", LIEF::assembly::aarch64::OPCODE::FMLALlanev8f16)
  .value("FMLALv4f16", LIEF::assembly::aarch64::OPCODE::FMLALv4f16)
  .value("FMLALv8f16", LIEF::assembly::aarch64::OPCODE::FMLALv8f16)
  .value("FMLA_VG2_M2Z2Z_D", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2Z2Z_D)
  .value("FMLA_VG2_M2Z2Z_H", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2Z2Z_H)
  .value("FMLA_VG2_M2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2Z2Z_S)
  .value("FMLA_VG2_M2ZZI_D", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2ZZI_D)
  .value("FMLA_VG2_M2ZZI_H", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2ZZI_H)
  .value("FMLA_VG2_M2ZZI_S", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2ZZI_S)
  .value("FMLA_VG2_M2ZZ_D", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2ZZ_D)
  .value("FMLA_VG2_M2ZZ_H", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2ZZ_H)
  .value("FMLA_VG2_M2ZZ_S", LIEF::assembly::aarch64::OPCODE::FMLA_VG2_M2ZZ_S)
  .value("FMLA_VG4_M4Z4Z_D", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4Z4Z_D)
  .value("FMLA_VG4_M4Z4Z_H", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4Z4Z_H)
  .value("FMLA_VG4_M4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4Z4Z_S)
  .value("FMLA_VG4_M4ZZI_D", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4ZZI_D)
  .value("FMLA_VG4_M4ZZI_H", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4ZZI_H)
  .value("FMLA_VG4_M4ZZI_S", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4ZZI_S)
  .value("FMLA_VG4_M4ZZ_D", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4ZZ_D)
  .value("FMLA_VG4_M4ZZ_H", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4ZZ_H)
  .value("FMLA_VG4_M4ZZ_S", LIEF::assembly::aarch64::OPCODE::FMLA_VG4_M4ZZ_S)
  .value("FMLA_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::FMLA_ZPmZZ_D)
  .value("FMLA_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::FMLA_ZPmZZ_H)
  .value("FMLA_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::FMLA_ZPmZZ_S)
  .value("FMLA_ZZZI_D", LIEF::assembly::aarch64::OPCODE::FMLA_ZZZI_D)
  .value("FMLA_ZZZI_H", LIEF::assembly::aarch64::OPCODE::FMLA_ZZZI_H)
  .value("FMLA_ZZZI_S", LIEF::assembly::aarch64::OPCODE::FMLA_ZZZI_S)
  .value("FMLAv1i16_indexed", LIEF::assembly::aarch64::OPCODE::FMLAv1i16_indexed)
  .value("FMLAv1i32_indexed", LIEF::assembly::aarch64::OPCODE::FMLAv1i32_indexed)
  .value("FMLAv1i64_indexed", LIEF::assembly::aarch64::OPCODE::FMLAv1i64_indexed)
  .value("FMLAv2f32", LIEF::assembly::aarch64::OPCODE::FMLAv2f32)
  .value("FMLAv2f64", LIEF::assembly::aarch64::OPCODE::FMLAv2f64)
  .value("FMLAv2i32_indexed", LIEF::assembly::aarch64::OPCODE::FMLAv2i32_indexed)
  .value("FMLAv2i64_indexed", LIEF::assembly::aarch64::OPCODE::FMLAv2i64_indexed)
  .value("FMLAv4f16", LIEF::assembly::aarch64::OPCODE::FMLAv4f16)
  .value("FMLAv4f32", LIEF::assembly::aarch64::OPCODE::FMLAv4f32)
  .value("FMLAv4i16_indexed", LIEF::assembly::aarch64::OPCODE::FMLAv4i16_indexed)
  .value("FMLAv4i32_indexed", LIEF::assembly::aarch64::OPCODE::FMLAv4i32_indexed)
  .value("FMLAv8f16", LIEF::assembly::aarch64::OPCODE::FMLAv8f16)
  .value("FMLAv8i16_indexed", LIEF::assembly::aarch64::OPCODE::FMLAv8i16_indexed)
  .value("FMLLA_ZZZ_HtoS", LIEF::assembly::aarch64::OPCODE::FMLLA_ZZZ_HtoS)
  .value("FMLSL2lanev4f16", LIEF::assembly::aarch64::OPCODE::FMLSL2lanev4f16)
  .value("FMLSL2lanev8f16", LIEF::assembly::aarch64::OPCODE::FMLSL2lanev8f16)
  .value("FMLSL2v4f16", LIEF::assembly::aarch64::OPCODE::FMLSL2v4f16)
  .value("FMLSL2v8f16", LIEF::assembly::aarch64::OPCODE::FMLSL2v8f16)
  .value("FMLSLB_ZZZI_SHH", LIEF::assembly::aarch64::OPCODE::FMLSLB_ZZZI_SHH);
  opcodes.value("FMLSLB_ZZZ_SHH", LIEF::assembly::aarch64::OPCODE::FMLSLB_ZZZ_SHH)
  .value("FMLSLT_ZZZI_SHH", LIEF::assembly::aarch64::OPCODE::FMLSLT_ZZZI_SHH)
  .value("FMLSLT_ZZZ_SHH", LIEF::assembly::aarch64::OPCODE::FMLSLT_ZZZ_SHH)
  .value("FMLSL_MZZI_HtoS", LIEF::assembly::aarch64::OPCODE::FMLSL_MZZI_HtoS)
  .value("FMLSL_MZZ_HtoS", LIEF::assembly::aarch64::OPCODE::FMLSL_MZZ_HtoS)
  .value("FMLSL_VG2_M2Z2Z_HtoS", LIEF::assembly::aarch64::OPCODE::FMLSL_VG2_M2Z2Z_HtoS)
  .value("FMLSL_VG2_M2ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::FMLSL_VG2_M2ZZI_HtoS)
  .value("FMLSL_VG2_M2ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::FMLSL_VG2_M2ZZ_HtoS)
  .value("FMLSL_VG4_M4Z4Z_HtoS", LIEF::assembly::aarch64::OPCODE::FMLSL_VG4_M4Z4Z_HtoS)
  .value("FMLSL_VG4_M4ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::FMLSL_VG4_M4ZZI_HtoS)
  .value("FMLSL_VG4_M4ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::FMLSL_VG4_M4ZZ_HtoS)
  .value("FMLSLlanev4f16", LIEF::assembly::aarch64::OPCODE::FMLSLlanev4f16)
  .value("FMLSLlanev8f16", LIEF::assembly::aarch64::OPCODE::FMLSLlanev8f16)
  .value("FMLSLv4f16", LIEF::assembly::aarch64::OPCODE::FMLSLv4f16)
  .value("FMLSLv8f16", LIEF::assembly::aarch64::OPCODE::FMLSLv8f16)
  .value("FMLS_VG2_M2Z2Z_D", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2Z2Z_D)
  .value("FMLS_VG2_M2Z2Z_H", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2Z2Z_H)
  .value("FMLS_VG2_M2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2Z2Z_S)
  .value("FMLS_VG2_M2ZZI_D", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2ZZI_D)
  .value("FMLS_VG2_M2ZZI_H", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2ZZI_H)
  .value("FMLS_VG2_M2ZZI_S", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2ZZI_S)
  .value("FMLS_VG2_M2ZZ_D", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2ZZ_D)
  .value("FMLS_VG2_M2ZZ_H", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2ZZ_H)
  .value("FMLS_VG2_M2ZZ_S", LIEF::assembly::aarch64::OPCODE::FMLS_VG2_M2ZZ_S)
  .value("FMLS_VG4_M4Z4Z_D", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4Z4Z_D)
  .value("FMLS_VG4_M4Z4Z_H", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4Z4Z_H)
  .value("FMLS_VG4_M4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4Z4Z_S)
  .value("FMLS_VG4_M4ZZI_D", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4ZZI_D)
  .value("FMLS_VG4_M4ZZI_H", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4ZZI_H)
  .value("FMLS_VG4_M4ZZI_S", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4ZZI_S)
  .value("FMLS_VG4_M4ZZ_D", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4ZZ_D)
  .value("FMLS_VG4_M4ZZ_H", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4ZZ_H)
  .value("FMLS_VG4_M4ZZ_S", LIEF::assembly::aarch64::OPCODE::FMLS_VG4_M4ZZ_S)
  .value("FMLS_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::FMLS_ZPmZZ_D)
  .value("FMLS_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::FMLS_ZPmZZ_H)
  .value("FMLS_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::FMLS_ZPmZZ_S)
  .value("FMLS_ZZZI_D", LIEF::assembly::aarch64::OPCODE::FMLS_ZZZI_D)
  .value("FMLS_ZZZI_H", LIEF::assembly::aarch64::OPCODE::FMLS_ZZZI_H)
  .value("FMLS_ZZZI_S", LIEF::assembly::aarch64::OPCODE::FMLS_ZZZI_S)
  .value("FMLSv1i16_indexed", LIEF::assembly::aarch64::OPCODE::FMLSv1i16_indexed)
  .value("FMLSv1i32_indexed", LIEF::assembly::aarch64::OPCODE::FMLSv1i32_indexed)
  .value("FMLSv1i64_indexed", LIEF::assembly::aarch64::OPCODE::FMLSv1i64_indexed)
  .value("FMLSv2f32", LIEF::assembly::aarch64::OPCODE::FMLSv2f32)
  .value("FMLSv2f64", LIEF::assembly::aarch64::OPCODE::FMLSv2f64)
  .value("FMLSv2i32_indexed", LIEF::assembly::aarch64::OPCODE::FMLSv2i32_indexed)
  .value("FMLSv2i64_indexed", LIEF::assembly::aarch64::OPCODE::FMLSv2i64_indexed)
  .value("FMLSv4f16", LIEF::assembly::aarch64::OPCODE::FMLSv4f16)
  .value("FMLSv4f32", LIEF::assembly::aarch64::OPCODE::FMLSv4f32)
  .value("FMLSv4i16_indexed", LIEF::assembly::aarch64::OPCODE::FMLSv4i16_indexed)
  .value("FMLSv4i32_indexed", LIEF::assembly::aarch64::OPCODE::FMLSv4i32_indexed)
  .value("FMLSv8f16", LIEF::assembly::aarch64::OPCODE::FMLSv8f16)
  .value("FMLSv8i16_indexed", LIEF::assembly::aarch64::OPCODE::FMLSv8i16_indexed)
  .value("FMMLA_ZZZ_BtoH", LIEF::assembly::aarch64::OPCODE::FMMLA_ZZZ_BtoH)
  .value("FMMLA_ZZZ_BtoS", LIEF::assembly::aarch64::OPCODE::FMMLA_ZZZ_BtoS)
  .value("FMMLA_ZZZ_D", LIEF::assembly::aarch64::OPCODE::FMMLA_ZZZ_D)
  .value("FMMLA_ZZZ_S", LIEF::assembly::aarch64::OPCODE::FMMLA_ZZZ_S)
  .value("FMMLAv4f32", LIEF::assembly::aarch64::OPCODE::FMMLAv4f32)
  .value("FMMLAv8f16", LIEF::assembly::aarch64::OPCODE::FMMLAv8f16)
  .value("FMOP4A_M2Z2Z_BtoH", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2Z2Z_BtoH)
  .value("FMOP4A_M2Z2Z_BtoS", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2Z2Z_BtoS)
  .value("FMOP4A_M2Z2Z_D", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2Z2Z_D)
  .value("FMOP4A_M2Z2Z_H", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2Z2Z_H)
  .value("FMOP4A_M2Z2Z_HtoS", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2Z2Z_HtoS)
  .value("FMOP4A_M2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2Z2Z_S)
  .value("FMOP4A_M2ZZ_BtoH", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2ZZ_BtoH)
  .value("FMOP4A_M2ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2ZZ_BtoS)
  .value("FMOP4A_M2ZZ_D", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2ZZ_D)
  .value("FMOP4A_M2ZZ_H", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2ZZ_H)
  .value("FMOP4A_M2ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2ZZ_HtoS)
  .value("FMOP4A_M2ZZ_S", LIEF::assembly::aarch64::OPCODE::FMOP4A_M2ZZ_S)
  .value("FMOP4A_MZ2Z_BtoH", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZ2Z_BtoH)
  .value("FMOP4A_MZ2Z_BtoS", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZ2Z_BtoS)
  .value("FMOP4A_MZ2Z_D", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZ2Z_D)
  .value("FMOP4A_MZ2Z_H", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZ2Z_H)
  .value("FMOP4A_MZ2Z_HtoS", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZ2Z_HtoS)
  .value("FMOP4A_MZ2Z_S", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZ2Z_S)
  .value("FMOP4A_MZZ_BtoH", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZZ_BtoH)
  .value("FMOP4A_MZZ_BtoS", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZZ_BtoS)
  .value("FMOP4A_MZZ_D", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZZ_D)
  .value("FMOP4A_MZZ_H", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZZ_H)
  .value("FMOP4A_MZZ_HtoS", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZZ_HtoS)
  .value("FMOP4A_MZZ_S", LIEF::assembly::aarch64::OPCODE::FMOP4A_MZZ_S)
  .value("FMOP4S_M2Z2Z_D", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2Z2Z_D)
  .value("FMOP4S_M2Z2Z_H", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2Z2Z_H)
  .value("FMOP4S_M2Z2Z_HtoS", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2Z2Z_HtoS)
  .value("FMOP4S_M2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2Z2Z_S)
  .value("FMOP4S_M2ZZ_D", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2ZZ_D)
  .value("FMOP4S_M2ZZ_H", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2ZZ_H)
  .value("FMOP4S_M2ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2ZZ_HtoS)
  .value("FMOP4S_M2ZZ_S", LIEF::assembly::aarch64::OPCODE::FMOP4S_M2ZZ_S)
  .value("FMOP4S_MZ2Z_D", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZ2Z_D)
  .value("FMOP4S_MZ2Z_H", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZ2Z_H)
  .value("FMOP4S_MZ2Z_HtoS", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZ2Z_HtoS)
  .value("FMOP4S_MZ2Z_S", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZ2Z_S)
  .value("FMOP4S_MZZ_D", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZZ_D)
  .value("FMOP4S_MZZ_H", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZZ_H)
  .value("FMOP4S_MZZ_HtoS", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZZ_HtoS)
  .value("FMOP4S_MZZ_S", LIEF::assembly::aarch64::OPCODE::FMOP4S_MZZ_S)
  .value("FMOPAL_MPPZZ", LIEF::assembly::aarch64::OPCODE::FMOPAL_MPPZZ)
  .value("FMOPA_MPPZZ_BtoH", LIEF::assembly::aarch64::OPCODE::FMOPA_MPPZZ_BtoH)
  .value("FMOPA_MPPZZ_BtoS", LIEF::assembly::aarch64::OPCODE::FMOPA_MPPZZ_BtoS)
  .value("FMOPA_MPPZZ_D", LIEF::assembly::aarch64::OPCODE::FMOPA_MPPZZ_D)
  .value("FMOPA_MPPZZ_H", LIEF::assembly::aarch64::OPCODE::FMOPA_MPPZZ_H)
  .value("FMOPA_MPPZZ_S", LIEF::assembly::aarch64::OPCODE::FMOPA_MPPZZ_S)
  .value("FMOPSL_MPPZZ", LIEF::assembly::aarch64::OPCODE::FMOPSL_MPPZZ)
  .value("FMOPS_MPPZZ_D", LIEF::assembly::aarch64::OPCODE::FMOPS_MPPZZ_D)
  .value("FMOPS_MPPZZ_H", LIEF::assembly::aarch64::OPCODE::FMOPS_MPPZZ_H)
  .value("FMOPS_MPPZZ_S", LIEF::assembly::aarch64::OPCODE::FMOPS_MPPZZ_S)
  .value("FMOVDXHighr", LIEF::assembly::aarch64::OPCODE::FMOVDXHighr)
  .value("FMOVDXr", LIEF::assembly::aarch64::OPCODE::FMOVDXr)
  .value("FMOVDi", LIEF::assembly::aarch64::OPCODE::FMOVDi)
  .value("FMOVDr", LIEF::assembly::aarch64::OPCODE::FMOVDr)
  .value("FMOVHWr", LIEF::assembly::aarch64::OPCODE::FMOVHWr)
  .value("FMOVHXr", LIEF::assembly::aarch64::OPCODE::FMOVHXr)
  .value("FMOVHi", LIEF::assembly::aarch64::OPCODE::FMOVHi)
  .value("FMOVHr", LIEF::assembly::aarch64::OPCODE::FMOVHr)
  .value("FMOVSWr", LIEF::assembly::aarch64::OPCODE::FMOVSWr)
  .value("FMOVSi", LIEF::assembly::aarch64::OPCODE::FMOVSi)
  .value("FMOVSr", LIEF::assembly::aarch64::OPCODE::FMOVSr)
  .value("FMOVWHr", LIEF::assembly::aarch64::OPCODE::FMOVWHr)
  .value("FMOVWSr", LIEF::assembly::aarch64::OPCODE::FMOVWSr)
  .value("FMOVXDHighr", LIEF::assembly::aarch64::OPCODE::FMOVXDHighr)
  .value("FMOVXDr", LIEF::assembly::aarch64::OPCODE::FMOVXDr)
  .value("FMOVXHr", LIEF::assembly::aarch64::OPCODE::FMOVXHr)
  .value("FMOVv2f32_ns", LIEF::assembly::aarch64::OPCODE::FMOVv2f32_ns)
  .value("FMOVv2f64_ns", LIEF::assembly::aarch64::OPCODE::FMOVv2f64_ns)
  .value("FMOVv4f16_ns", LIEF::assembly::aarch64::OPCODE::FMOVv4f16_ns)
  .value("FMOVv4f32_ns", LIEF::assembly::aarch64::OPCODE::FMOVv4f32_ns)
  .value("FMOVv8f16_ns", LIEF::assembly::aarch64::OPCODE::FMOVv8f16_ns)
  .value("FMSB_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::FMSB_ZPmZZ_D)
  .value("FMSB_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::FMSB_ZPmZZ_H)
  .value("FMSB_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::FMSB_ZPmZZ_S)
  .value("FMSUBDrrr", LIEF::assembly::aarch64::OPCODE::FMSUBDrrr)
  .value("FMSUBHrrr", LIEF::assembly::aarch64::OPCODE::FMSUBHrrr)
  .value("FMSUBSrrr", LIEF::assembly::aarch64::OPCODE::FMSUBSrrr)
  .value("FMULDrr", LIEF::assembly::aarch64::OPCODE::FMULDrr)
  .value("FMULHrr", LIEF::assembly::aarch64::OPCODE::FMULHrr)
  .value("FMULSrr", LIEF::assembly::aarch64::OPCODE::FMULSrr)
  .value("FMULX16", LIEF::assembly::aarch64::OPCODE::FMULX16)
  .value("FMULX32", LIEF::assembly::aarch64::OPCODE::FMULX32)
  .value("FMULX64", LIEF::assembly::aarch64::OPCODE::FMULX64)
  .value("FMULX_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FMULX_ZPmZ_D)
  .value("FMULX_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FMULX_ZPmZ_H)
  .value("FMULX_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FMULX_ZPmZ_S)
  .value("FMULXv1i16_indexed", LIEF::assembly::aarch64::OPCODE::FMULXv1i16_indexed)
  .value("FMULXv1i32_indexed", LIEF::assembly::aarch64::OPCODE::FMULXv1i32_indexed)
  .value("FMULXv1i64_indexed", LIEF::assembly::aarch64::OPCODE::FMULXv1i64_indexed)
  .value("FMULXv2f32", LIEF::assembly::aarch64::OPCODE::FMULXv2f32)
  .value("FMULXv2f64", LIEF::assembly::aarch64::OPCODE::FMULXv2f64)
  .value("FMULXv2i32_indexed", LIEF::assembly::aarch64::OPCODE::FMULXv2i32_indexed)
  .value("FMULXv2i64_indexed", LIEF::assembly::aarch64::OPCODE::FMULXv2i64_indexed)
  .value("FMULXv4f16", LIEF::assembly::aarch64::OPCODE::FMULXv4f16)
  .value("FMULXv4f32", LIEF::assembly::aarch64::OPCODE::FMULXv4f32)
  .value("FMULXv4i16_indexed", LIEF::assembly::aarch64::OPCODE::FMULXv4i16_indexed)
  .value("FMULXv4i32_indexed", LIEF::assembly::aarch64::OPCODE::FMULXv4i32_indexed)
  .value("FMULXv8f16", LIEF::assembly::aarch64::OPCODE::FMULXv8f16)
  .value("FMULXv8i16_indexed", LIEF::assembly::aarch64::OPCODE::FMULXv8i16_indexed)
  .value("FMUL_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::FMUL_2Z2Z_D)
  .value("FMUL_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::FMUL_2Z2Z_H)
  .value("FMUL_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FMUL_2Z2Z_S)
  .value("FMUL_2ZZ_D", LIEF::assembly::aarch64::OPCODE::FMUL_2ZZ_D)
  .value("FMUL_2ZZ_H", LIEF::assembly::aarch64::OPCODE::FMUL_2ZZ_H)
  .value("FMUL_2ZZ_S", LIEF::assembly::aarch64::OPCODE::FMUL_2ZZ_S)
  .value("FMUL_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::FMUL_4Z4Z_D)
  .value("FMUL_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::FMUL_4Z4Z_H)
  .value("FMUL_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FMUL_4Z4Z_S)
  .value("FMUL_4ZZ_D", LIEF::assembly::aarch64::OPCODE::FMUL_4ZZ_D)
  .value("FMUL_4ZZ_H", LIEF::assembly::aarch64::OPCODE::FMUL_4ZZ_H)
  .value("FMUL_4ZZ_S", LIEF::assembly::aarch64::OPCODE::FMUL_4ZZ_S)
  .value("FMUL_ZPmI_D", LIEF::assembly::aarch64::OPCODE::FMUL_ZPmI_D)
  .value("FMUL_ZPmI_H", LIEF::assembly::aarch64::OPCODE::FMUL_ZPmI_H)
  .value("FMUL_ZPmI_S", LIEF::assembly::aarch64::OPCODE::FMUL_ZPmI_S)
  .value("FMUL_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FMUL_ZPmZ_D)
  .value("FMUL_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FMUL_ZPmZ_H)
  .value("FMUL_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FMUL_ZPmZ_S)
  .value("FMUL_ZZZI_D", LIEF::assembly::aarch64::OPCODE::FMUL_ZZZI_D)
  .value("FMUL_ZZZI_H", LIEF::assembly::aarch64::OPCODE::FMUL_ZZZI_H)
  .value("FMUL_ZZZI_S", LIEF::assembly::aarch64::OPCODE::FMUL_ZZZI_S)
  .value("FMUL_ZZZ_D", LIEF::assembly::aarch64::OPCODE::FMUL_ZZZ_D)
  .value("FMUL_ZZZ_H", LIEF::assembly::aarch64::OPCODE::FMUL_ZZZ_H)
  .value("FMUL_ZZZ_S", LIEF::assembly::aarch64::OPCODE::FMUL_ZZZ_S)
  .value("FMULv1i16_indexed", LIEF::assembly::aarch64::OPCODE::FMULv1i16_indexed)
  .value("FMULv1i32_indexed", LIEF::assembly::aarch64::OPCODE::FMULv1i32_indexed)
  .value("FMULv1i64_indexed", LIEF::assembly::aarch64::OPCODE::FMULv1i64_indexed)
  .value("FMULv2f32", LIEF::assembly::aarch64::OPCODE::FMULv2f32)
  .value("FMULv2f64", LIEF::assembly::aarch64::OPCODE::FMULv2f64)
  .value("FMULv2i32_indexed", LIEF::assembly::aarch64::OPCODE::FMULv2i32_indexed)
  .value("FMULv2i64_indexed", LIEF::assembly::aarch64::OPCODE::FMULv2i64_indexed)
  .value("FMULv4f16", LIEF::assembly::aarch64::OPCODE::FMULv4f16)
  .value("FMULv4f32", LIEF::assembly::aarch64::OPCODE::FMULv4f32)
  .value("FMULv4i16_indexed", LIEF::assembly::aarch64::OPCODE::FMULv4i16_indexed)
  .value("FMULv4i32_indexed", LIEF::assembly::aarch64::OPCODE::FMULv4i32_indexed)
  .value("FMULv8f16", LIEF::assembly::aarch64::OPCODE::FMULv8f16)
  .value("FMULv8i16_indexed", LIEF::assembly::aarch64::OPCODE::FMULv8i16_indexed)
  .value("FNEGDr", LIEF::assembly::aarch64::OPCODE::FNEGDr)
  .value("FNEGHr", LIEF::assembly::aarch64::OPCODE::FNEGHr)
  .value("FNEGSr", LIEF::assembly::aarch64::OPCODE::FNEGSr)
  .value("FNEG_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FNEG_ZPmZ_D)
  .value("FNEG_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FNEG_ZPmZ_H)
  .value("FNEG_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FNEG_ZPmZ_S)
  .value("FNEG_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FNEG_ZPzZ_D)
  .value("FNEG_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::FNEG_ZPzZ_H)
  .value("FNEG_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FNEG_ZPzZ_S)
  .value("FNEGv2f32", LIEF::assembly::aarch64::OPCODE::FNEGv2f32)
  .value("FNEGv2f64", LIEF::assembly::aarch64::OPCODE::FNEGv2f64)
  .value("FNEGv4f16", LIEF::assembly::aarch64::OPCODE::FNEGv4f16)
  .value("FNEGv4f32", LIEF::assembly::aarch64::OPCODE::FNEGv4f32)
  .value("FNEGv8f16", LIEF::assembly::aarch64::OPCODE::FNEGv8f16)
  .value("FNMADDDrrr", LIEF::assembly::aarch64::OPCODE::FNMADDDrrr)
  .value("FNMADDHrrr", LIEF::assembly::aarch64::OPCODE::FNMADDHrrr)
  .value("FNMADDSrrr", LIEF::assembly::aarch64::OPCODE::FNMADDSrrr)
  .value("FNMAD_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::FNMAD_ZPmZZ_D)
  .value("FNMAD_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::FNMAD_ZPmZZ_H)
  .value("FNMAD_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::FNMAD_ZPmZZ_S)
  .value("FNMLA_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::FNMLA_ZPmZZ_D)
  .value("FNMLA_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::FNMLA_ZPmZZ_H)
  .value("FNMLA_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::FNMLA_ZPmZZ_S)
  .value("FNMLS_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::FNMLS_ZPmZZ_D)
  .value("FNMLS_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::FNMLS_ZPmZZ_H)
  .value("FNMLS_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::FNMLS_ZPmZZ_S)
  .value("FNMSB_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::FNMSB_ZPmZZ_D)
  .value("FNMSB_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::FNMSB_ZPmZZ_H)
  .value("FNMSB_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::FNMSB_ZPmZZ_S)
  .value("FNMSUBDrrr", LIEF::assembly::aarch64::OPCODE::FNMSUBDrrr)
  .value("FNMSUBHrrr", LIEF::assembly::aarch64::OPCODE::FNMSUBHrrr)
  .value("FNMSUBSrrr", LIEF::assembly::aarch64::OPCODE::FNMSUBSrrr)
  .value("FNMULDrr", LIEF::assembly::aarch64::OPCODE::FNMULDrr)
  .value("FNMULHrr", LIEF::assembly::aarch64::OPCODE::FNMULHrr)
  .value("FNMULSrr", LIEF::assembly::aarch64::OPCODE::FNMULSrr)
  .value("FRECPE_ZZ_D", LIEF::assembly::aarch64::OPCODE::FRECPE_ZZ_D)
  .value("FRECPE_ZZ_H", LIEF::assembly::aarch64::OPCODE::FRECPE_ZZ_H)
  .value("FRECPE_ZZ_S", LIEF::assembly::aarch64::OPCODE::FRECPE_ZZ_S)
  .value("FRECPEv1f16", LIEF::assembly::aarch64::OPCODE::FRECPEv1f16)
  .value("FRECPEv1i32", LIEF::assembly::aarch64::OPCODE::FRECPEv1i32)
  .value("FRECPEv1i64", LIEF::assembly::aarch64::OPCODE::FRECPEv1i64)
  .value("FRECPEv2f32", LIEF::assembly::aarch64::OPCODE::FRECPEv2f32)
  .value("FRECPEv2f64", LIEF::assembly::aarch64::OPCODE::FRECPEv2f64)
  .value("FRECPEv4f16", LIEF::assembly::aarch64::OPCODE::FRECPEv4f16)
  .value("FRECPEv4f32", LIEF::assembly::aarch64::OPCODE::FRECPEv4f32)
  .value("FRECPEv8f16", LIEF::assembly::aarch64::OPCODE::FRECPEv8f16)
  .value("FRECPS16", LIEF::assembly::aarch64::OPCODE::FRECPS16)
  .value("FRECPS32", LIEF::assembly::aarch64::OPCODE::FRECPS32)
  .value("FRECPS64", LIEF::assembly::aarch64::OPCODE::FRECPS64)
  .value("FRECPS_ZZZ_D", LIEF::assembly::aarch64::OPCODE::FRECPS_ZZZ_D)
  .value("FRECPS_ZZZ_H", LIEF::assembly::aarch64::OPCODE::FRECPS_ZZZ_H)
  .value("FRECPS_ZZZ_S", LIEF::assembly::aarch64::OPCODE::FRECPS_ZZZ_S)
  .value("FRECPSv2f32", LIEF::assembly::aarch64::OPCODE::FRECPSv2f32)
  .value("FRECPSv2f64", LIEF::assembly::aarch64::OPCODE::FRECPSv2f64)
  .value("FRECPSv4f16", LIEF::assembly::aarch64::OPCODE::FRECPSv4f16)
  .value("FRECPSv4f32", LIEF::assembly::aarch64::OPCODE::FRECPSv4f32)
  .value("FRECPSv8f16", LIEF::assembly::aarch64::OPCODE::FRECPSv8f16)
  .value("FRECPX_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FRECPX_ZPmZ_D)
  .value("FRECPX_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FRECPX_ZPmZ_H)
  .value("FRECPX_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FRECPX_ZPmZ_S)
  .value("FRECPX_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FRECPX_ZPzZ_D)
  .value("FRECPX_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::FRECPX_ZPzZ_H)
  .value("FRECPX_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FRECPX_ZPzZ_S)
  .value("FRECPXv1f16", LIEF::assembly::aarch64::OPCODE::FRECPXv1f16)
  .value("FRECPXv1i32", LIEF::assembly::aarch64::OPCODE::FRECPXv1i32)
  .value("FRECPXv1i64", LIEF::assembly::aarch64::OPCODE::FRECPXv1i64)
  .value("FRINT32XDr", LIEF::assembly::aarch64::OPCODE::FRINT32XDr)
  .value("FRINT32XSr", LIEF::assembly::aarch64::OPCODE::FRINT32XSr)
  .value("FRINT32X_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FRINT32X_ZPmZ_D)
  .value("FRINT32X_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FRINT32X_ZPmZ_S)
  .value("FRINT32X_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FRINT32X_ZPzZ_D)
  .value("FRINT32X_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FRINT32X_ZPzZ_S)
  .value("FRINT32Xv2f32", LIEF::assembly::aarch64::OPCODE::FRINT32Xv2f32)
  .value("FRINT32Xv2f64", LIEF::assembly::aarch64::OPCODE::FRINT32Xv2f64)
  .value("FRINT32Xv4f32", LIEF::assembly::aarch64::OPCODE::FRINT32Xv4f32)
  .value("FRINT32ZDr", LIEF::assembly::aarch64::OPCODE::FRINT32ZDr)
  .value("FRINT32ZSr", LIEF::assembly::aarch64::OPCODE::FRINT32ZSr)
  .value("FRINT32Z_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FRINT32Z_ZPmZ_D)
  .value("FRINT32Z_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FRINT32Z_ZPmZ_S)
  .value("FRINT32Z_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FRINT32Z_ZPzZ_D)
  .value("FRINT32Z_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FRINT32Z_ZPzZ_S)
  .value("FRINT32Zv2f32", LIEF::assembly::aarch64::OPCODE::FRINT32Zv2f32)
  .value("FRINT32Zv2f64", LIEF::assembly::aarch64::OPCODE::FRINT32Zv2f64)
  .value("FRINT32Zv4f32", LIEF::assembly::aarch64::OPCODE::FRINT32Zv4f32)
  .value("FRINT64XDr", LIEF::assembly::aarch64::OPCODE::FRINT64XDr)
  .value("FRINT64XSr", LIEF::assembly::aarch64::OPCODE::FRINT64XSr)
  .value("FRINT64X_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FRINT64X_ZPmZ_D)
  .value("FRINT64X_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FRINT64X_ZPmZ_S)
  .value("FRINT64X_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FRINT64X_ZPzZ_D)
  .value("FRINT64X_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FRINT64X_ZPzZ_S)
  .value("FRINT64Xv2f32", LIEF::assembly::aarch64::OPCODE::FRINT64Xv2f32)
  .value("FRINT64Xv2f64", LIEF::assembly::aarch64::OPCODE::FRINT64Xv2f64)
  .value("FRINT64Xv4f32", LIEF::assembly::aarch64::OPCODE::FRINT64Xv4f32)
  .value("FRINT64ZDr", LIEF::assembly::aarch64::OPCODE::FRINT64ZDr)
  .value("FRINT64ZSr", LIEF::assembly::aarch64::OPCODE::FRINT64ZSr)
  .value("FRINT64Z_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FRINT64Z_ZPmZ_D)
  .value("FRINT64Z_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FRINT64Z_ZPmZ_S)
  .value("FRINT64Z_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FRINT64Z_ZPzZ_D)
  .value("FRINT64Z_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FRINT64Z_ZPzZ_S)
  .value("FRINT64Zv2f32", LIEF::assembly::aarch64::OPCODE::FRINT64Zv2f32)
  .value("FRINT64Zv2f64", LIEF::assembly::aarch64::OPCODE::FRINT64Zv2f64)
  .value("FRINT64Zv4f32", LIEF::assembly::aarch64::OPCODE::FRINT64Zv4f32)
  .value("FRINTADr", LIEF::assembly::aarch64::OPCODE::FRINTADr)
  .value("FRINTAHr", LIEF::assembly::aarch64::OPCODE::FRINTAHr)
  .value("FRINTASr", LIEF::assembly::aarch64::OPCODE::FRINTASr)
  .value("FRINTA_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FRINTA_2Z2Z_S);
  opcodes.value("FRINTA_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FRINTA_4Z4Z_S)
  .value("FRINTA_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FRINTA_ZPmZ_D)
  .value("FRINTA_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FRINTA_ZPmZ_H)
  .value("FRINTA_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FRINTA_ZPmZ_S)
  .value("FRINTA_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FRINTA_ZPzZ_D)
  .value("FRINTA_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::FRINTA_ZPzZ_H)
  .value("FRINTA_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FRINTA_ZPzZ_S)
  .value("FRINTAv2f32", LIEF::assembly::aarch64::OPCODE::FRINTAv2f32)
  .value("FRINTAv2f64", LIEF::assembly::aarch64::OPCODE::FRINTAv2f64)
  .value("FRINTAv4f16", LIEF::assembly::aarch64::OPCODE::FRINTAv4f16)
  .value("FRINTAv4f32", LIEF::assembly::aarch64::OPCODE::FRINTAv4f32)
  .value("FRINTAv8f16", LIEF::assembly::aarch64::OPCODE::FRINTAv8f16)
  .value("FRINTIDr", LIEF::assembly::aarch64::OPCODE::FRINTIDr)
  .value("FRINTIHr", LIEF::assembly::aarch64::OPCODE::FRINTIHr)
  .value("FRINTISr", LIEF::assembly::aarch64::OPCODE::FRINTISr)
  .value("FRINTI_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FRINTI_ZPmZ_D)
  .value("FRINTI_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FRINTI_ZPmZ_H)
  .value("FRINTI_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FRINTI_ZPmZ_S)
  .value("FRINTI_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FRINTI_ZPzZ_D)
  .value("FRINTI_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::FRINTI_ZPzZ_H)
  .value("FRINTI_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FRINTI_ZPzZ_S)
  .value("FRINTIv2f32", LIEF::assembly::aarch64::OPCODE::FRINTIv2f32)
  .value("FRINTIv2f64", LIEF::assembly::aarch64::OPCODE::FRINTIv2f64)
  .value("FRINTIv4f16", LIEF::assembly::aarch64::OPCODE::FRINTIv4f16)
  .value("FRINTIv4f32", LIEF::assembly::aarch64::OPCODE::FRINTIv4f32)
  .value("FRINTIv8f16", LIEF::assembly::aarch64::OPCODE::FRINTIv8f16)
  .value("FRINTMDr", LIEF::assembly::aarch64::OPCODE::FRINTMDr)
  .value("FRINTMHr", LIEF::assembly::aarch64::OPCODE::FRINTMHr)
  .value("FRINTMSr", LIEF::assembly::aarch64::OPCODE::FRINTMSr)
  .value("FRINTM_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FRINTM_2Z2Z_S)
  .value("FRINTM_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FRINTM_4Z4Z_S)
  .value("FRINTM_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FRINTM_ZPmZ_D)
  .value("FRINTM_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FRINTM_ZPmZ_H)
  .value("FRINTM_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FRINTM_ZPmZ_S)
  .value("FRINTM_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FRINTM_ZPzZ_D)
  .value("FRINTM_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::FRINTM_ZPzZ_H)
  .value("FRINTM_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FRINTM_ZPzZ_S)
  .value("FRINTMv2f32", LIEF::assembly::aarch64::OPCODE::FRINTMv2f32)
  .value("FRINTMv2f64", LIEF::assembly::aarch64::OPCODE::FRINTMv2f64)
  .value("FRINTMv4f16", LIEF::assembly::aarch64::OPCODE::FRINTMv4f16)
  .value("FRINTMv4f32", LIEF::assembly::aarch64::OPCODE::FRINTMv4f32)
  .value("FRINTMv8f16", LIEF::assembly::aarch64::OPCODE::FRINTMv8f16)
  .value("FRINTNDr", LIEF::assembly::aarch64::OPCODE::FRINTNDr)
  .value("FRINTNHr", LIEF::assembly::aarch64::OPCODE::FRINTNHr)
  .value("FRINTNSr", LIEF::assembly::aarch64::OPCODE::FRINTNSr)
  .value("FRINTN_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FRINTN_2Z2Z_S)
  .value("FRINTN_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FRINTN_4Z4Z_S)
  .value("FRINTN_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FRINTN_ZPmZ_D)
  .value("FRINTN_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FRINTN_ZPmZ_H)
  .value("FRINTN_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FRINTN_ZPmZ_S)
  .value("FRINTN_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FRINTN_ZPzZ_D)
  .value("FRINTN_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::FRINTN_ZPzZ_H)
  .value("FRINTN_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FRINTN_ZPzZ_S)
  .value("FRINTNv2f32", LIEF::assembly::aarch64::OPCODE::FRINTNv2f32)
  .value("FRINTNv2f64", LIEF::assembly::aarch64::OPCODE::FRINTNv2f64)
  .value("FRINTNv4f16", LIEF::assembly::aarch64::OPCODE::FRINTNv4f16)
  .value("FRINTNv4f32", LIEF::assembly::aarch64::OPCODE::FRINTNv4f32)
  .value("FRINTNv8f16", LIEF::assembly::aarch64::OPCODE::FRINTNv8f16)
  .value("FRINTPDr", LIEF::assembly::aarch64::OPCODE::FRINTPDr)
  .value("FRINTPHr", LIEF::assembly::aarch64::OPCODE::FRINTPHr)
  .value("FRINTPSr", LIEF::assembly::aarch64::OPCODE::FRINTPSr)
  .value("FRINTP_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FRINTP_2Z2Z_S)
  .value("FRINTP_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FRINTP_4Z4Z_S)
  .value("FRINTP_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FRINTP_ZPmZ_D)
  .value("FRINTP_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FRINTP_ZPmZ_H)
  .value("FRINTP_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FRINTP_ZPmZ_S)
  .value("FRINTP_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FRINTP_ZPzZ_D)
  .value("FRINTP_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::FRINTP_ZPzZ_H)
  .value("FRINTP_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FRINTP_ZPzZ_S)
  .value("FRINTPv2f32", LIEF::assembly::aarch64::OPCODE::FRINTPv2f32)
  .value("FRINTPv2f64", LIEF::assembly::aarch64::OPCODE::FRINTPv2f64)
  .value("FRINTPv4f16", LIEF::assembly::aarch64::OPCODE::FRINTPv4f16)
  .value("FRINTPv4f32", LIEF::assembly::aarch64::OPCODE::FRINTPv4f32)
  .value("FRINTPv8f16", LIEF::assembly::aarch64::OPCODE::FRINTPv8f16)
  .value("FRINTXDr", LIEF::assembly::aarch64::OPCODE::FRINTXDr)
  .value("FRINTXHr", LIEF::assembly::aarch64::OPCODE::FRINTXHr)
  .value("FRINTXSr", LIEF::assembly::aarch64::OPCODE::FRINTXSr)
  .value("FRINTX_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FRINTX_ZPmZ_D)
  .value("FRINTX_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FRINTX_ZPmZ_H)
  .value("FRINTX_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FRINTX_ZPmZ_S)
  .value("FRINTX_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FRINTX_ZPzZ_D)
  .value("FRINTX_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::FRINTX_ZPzZ_H)
  .value("FRINTX_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FRINTX_ZPzZ_S)
  .value("FRINTXv2f32", LIEF::assembly::aarch64::OPCODE::FRINTXv2f32)
  .value("FRINTXv2f64", LIEF::assembly::aarch64::OPCODE::FRINTXv2f64)
  .value("FRINTXv4f16", LIEF::assembly::aarch64::OPCODE::FRINTXv4f16)
  .value("FRINTXv4f32", LIEF::assembly::aarch64::OPCODE::FRINTXv4f32)
  .value("FRINTXv8f16", LIEF::assembly::aarch64::OPCODE::FRINTXv8f16)
  .value("FRINTZDr", LIEF::assembly::aarch64::OPCODE::FRINTZDr)
  .value("FRINTZHr", LIEF::assembly::aarch64::OPCODE::FRINTZHr)
  .value("FRINTZSr", LIEF::assembly::aarch64::OPCODE::FRINTZSr)
  .value("FRINTZ_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FRINTZ_ZPmZ_D)
  .value("FRINTZ_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FRINTZ_ZPmZ_H)
  .value("FRINTZ_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FRINTZ_ZPmZ_S)
  .value("FRINTZ_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::FRINTZ_ZPzZ_D)
  .value("FRINTZ_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::FRINTZ_ZPzZ_H)
  .value("FRINTZ_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::FRINTZ_ZPzZ_S)
  .value("FRINTZv2f32", LIEF::assembly::aarch64::OPCODE::FRINTZv2f32)
  .value("FRINTZv2f64", LIEF::assembly::aarch64::OPCODE::FRINTZv2f64)
  .value("FRINTZv4f16", LIEF::assembly::aarch64::OPCODE::FRINTZv4f16)
  .value("FRINTZv4f32", LIEF::assembly::aarch64::OPCODE::FRINTZv4f32)
  .value("FRINTZv8f16", LIEF::assembly::aarch64::OPCODE::FRINTZv8f16)
  .value("FRSQRTE_ZZ_D", LIEF::assembly::aarch64::OPCODE::FRSQRTE_ZZ_D)
  .value("FRSQRTE_ZZ_H", LIEF::assembly::aarch64::OPCODE::FRSQRTE_ZZ_H)
  .value("FRSQRTE_ZZ_S", LIEF::assembly::aarch64::OPCODE::FRSQRTE_ZZ_S)
  .value("FRSQRTEv1f16", LIEF::assembly::aarch64::OPCODE::FRSQRTEv1f16)
  .value("FRSQRTEv1i32", LIEF::assembly::aarch64::OPCODE::FRSQRTEv1i32)
  .value("FRSQRTEv1i64", LIEF::assembly::aarch64::OPCODE::FRSQRTEv1i64)
  .value("FRSQRTEv2f32", LIEF::assembly::aarch64::OPCODE::FRSQRTEv2f32)
  .value("FRSQRTEv2f64", LIEF::assembly::aarch64::OPCODE::FRSQRTEv2f64)
  .value("FRSQRTEv4f16", LIEF::assembly::aarch64::OPCODE::FRSQRTEv4f16)
  .value("FRSQRTEv4f32", LIEF::assembly::aarch64::OPCODE::FRSQRTEv4f32)
  .value("FRSQRTEv8f16", LIEF::assembly::aarch64::OPCODE::FRSQRTEv8f16)
  .value("FRSQRTS16", LIEF::assembly::aarch64::OPCODE::FRSQRTS16)
  .value("FRSQRTS32", LIEF::assembly::aarch64::OPCODE::FRSQRTS32)
  .value("FRSQRTS64", LIEF::assembly::aarch64::OPCODE::FRSQRTS64)
  .value("FRSQRTS_ZZZ_D", LIEF::assembly::aarch64::OPCODE::FRSQRTS_ZZZ_D)
  .value("FRSQRTS_ZZZ_H", LIEF::assembly::aarch64::OPCODE::FRSQRTS_ZZZ_H)
  .value("FRSQRTS_ZZZ_S", LIEF::assembly::aarch64::OPCODE::FRSQRTS_ZZZ_S)
  .value("FRSQRTSv2f32", LIEF::assembly::aarch64::OPCODE::FRSQRTSv2f32)
  .value("FRSQRTSv2f64", LIEF::assembly::aarch64::OPCODE::FRSQRTSv2f64)
  .value("FRSQRTSv4f16", LIEF::assembly::aarch64::OPCODE::FRSQRTSv4f16)
  .value("FRSQRTSv4f32", LIEF::assembly::aarch64::OPCODE::FRSQRTSv4f32)
  .value("FRSQRTSv8f16", LIEF::assembly::aarch64::OPCODE::FRSQRTSv8f16)
  .value("FSCALE_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::FSCALE_2Z2Z_D)
  .value("FSCALE_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::FSCALE_2Z2Z_H)
  .value("FSCALE_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::FSCALE_2Z2Z_S)
  .value("FSCALE_2ZZ_D", LIEF::assembly::aarch64::OPCODE::FSCALE_2ZZ_D)
  .value("FSCALE_2ZZ_H", LIEF::assembly::aarch64::OPCODE::FSCALE_2ZZ_H)
  .value("FSCALE_2ZZ_S", LIEF::assembly::aarch64::OPCODE::FSCALE_2ZZ_S)
  .value("FSCALE_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::FSCALE_4Z4Z_D)
  .value("FSCALE_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::FSCALE_4Z4Z_H)
  .value("FSCALE_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::FSCALE_4Z4Z_S)
  .value("FSCALE_4ZZ_D", LIEF::assembly::aarch64::OPCODE::FSCALE_4ZZ_D)
  .value("FSCALE_4ZZ_H", LIEF::assembly::aarch64::OPCODE::FSCALE_4ZZ_H)
  .value("FSCALE_4ZZ_S", LIEF::assembly::aarch64::OPCODE::FSCALE_4ZZ_S)
  .value("FSCALE_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FSCALE_ZPmZ_D)
  .value("FSCALE_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FSCALE_ZPmZ_H)
  .value("FSCALE_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FSCALE_ZPmZ_S)
  .value("FSCALEv2f32", LIEF::assembly::aarch64::OPCODE::FSCALEv2f32)
  .value("FSCALEv2f64", LIEF::assembly::aarch64::OPCODE::FSCALEv2f64)
  .value("FSCALEv4f16", LIEF::assembly::aarch64::OPCODE::FSCALEv4f16)
  .value("FSCALEv4f32", LIEF::assembly::aarch64::OPCODE::FSCALEv4f32)
  .value("FSCALEv8f16", LIEF::assembly::aarch64::OPCODE::FSCALEv8f16)
  .value("FSQRTDr", LIEF::assembly::aarch64::OPCODE::FSQRTDr)
  .value("FSQRTHr", LIEF::assembly::aarch64::OPCODE::FSQRTHr)
  .value("FSQRTSr", LIEF::assembly::aarch64::OPCODE::FSQRTSr)
  .value("FSQRT_ZPZz_D", LIEF::assembly::aarch64::OPCODE::FSQRT_ZPZz_D)
  .value("FSQRT_ZPZz_H", LIEF::assembly::aarch64::OPCODE::FSQRT_ZPZz_H)
  .value("FSQRT_ZPZz_S", LIEF::assembly::aarch64::OPCODE::FSQRT_ZPZz_S)
  .value("FSQRT_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FSQRT_ZPmZ_D)
  .value("FSQRT_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FSQRT_ZPmZ_H)
  .value("FSQRT_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FSQRT_ZPmZ_S)
  .value("FSQRTv2f32", LIEF::assembly::aarch64::OPCODE::FSQRTv2f32)
  .value("FSQRTv2f64", LIEF::assembly::aarch64::OPCODE::FSQRTv2f64)
  .value("FSQRTv4f16", LIEF::assembly::aarch64::OPCODE::FSQRTv4f16)
  .value("FSQRTv4f32", LIEF::assembly::aarch64::OPCODE::FSQRTv4f32)
  .value("FSQRTv8f16", LIEF::assembly::aarch64::OPCODE::FSQRTv8f16)
  .value("FSUBDrr", LIEF::assembly::aarch64::OPCODE::FSUBDrr)
  .value("FSUBHrr", LIEF::assembly::aarch64::OPCODE::FSUBHrr)
  .value("FSUBR_ZPmI_D", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPmI_D)
  .value("FSUBR_ZPmI_H", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPmI_H)
  .value("FSUBR_ZPmI_S", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPmI_S)
  .value("FSUBR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPmZ_D)
  .value("FSUBR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPmZ_H)
  .value("FSUBR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FSUBR_ZPmZ_S)
  .value("FSUBSrr", LIEF::assembly::aarch64::OPCODE::FSUBSrr)
  .value("FSUB_VG2_M2Z_D", LIEF::assembly::aarch64::OPCODE::FSUB_VG2_M2Z_D)
  .value("FSUB_VG2_M2Z_H", LIEF::assembly::aarch64::OPCODE::FSUB_VG2_M2Z_H)
  .value("FSUB_VG2_M2Z_S", LIEF::assembly::aarch64::OPCODE::FSUB_VG2_M2Z_S)
  .value("FSUB_VG4_M4Z_D", LIEF::assembly::aarch64::OPCODE::FSUB_VG4_M4Z_D)
  .value("FSUB_VG4_M4Z_H", LIEF::assembly::aarch64::OPCODE::FSUB_VG4_M4Z_H)
  .value("FSUB_VG4_M4Z_S", LIEF::assembly::aarch64::OPCODE::FSUB_VG4_M4Z_S)
  .value("FSUB_ZPmI_D", LIEF::assembly::aarch64::OPCODE::FSUB_ZPmI_D)
  .value("FSUB_ZPmI_H", LIEF::assembly::aarch64::OPCODE::FSUB_ZPmI_H)
  .value("FSUB_ZPmI_S", LIEF::assembly::aarch64::OPCODE::FSUB_ZPmI_S)
  .value("FSUB_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::FSUB_ZPmZ_D)
  .value("FSUB_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::FSUB_ZPmZ_H)
  .value("FSUB_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::FSUB_ZPmZ_S)
  .value("FSUB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::FSUB_ZZZ_D)
  .value("FSUB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::FSUB_ZZZ_H)
  .value("FSUB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::FSUB_ZZZ_S)
  .value("FSUBv2f32", LIEF::assembly::aarch64::OPCODE::FSUBv2f32)
  .value("FSUBv2f64", LIEF::assembly::aarch64::OPCODE::FSUBv2f64)
  .value("FSUBv4f16", LIEF::assembly::aarch64::OPCODE::FSUBv4f16)
  .value("FSUBv4f32", LIEF::assembly::aarch64::OPCODE::FSUBv4f32)
  .value("FSUBv8f16", LIEF::assembly::aarch64::OPCODE::FSUBv8f16)
  .value("FTMAD_ZZI_D", LIEF::assembly::aarch64::OPCODE::FTMAD_ZZI_D)
  .value("FTMAD_ZZI_H", LIEF::assembly::aarch64::OPCODE::FTMAD_ZZI_H)
  .value("FTMAD_ZZI_S", LIEF::assembly::aarch64::OPCODE::FTMAD_ZZI_S)
  .value("FTMOPA_M2ZZZI_BtoH", LIEF::assembly::aarch64::OPCODE::FTMOPA_M2ZZZI_BtoH)
  .value("FTMOPA_M2ZZZI_BtoS", LIEF::assembly::aarch64::OPCODE::FTMOPA_M2ZZZI_BtoS)
  .value("FTMOPA_M2ZZZI_HtoH", LIEF::assembly::aarch64::OPCODE::FTMOPA_M2ZZZI_HtoH)
  .value("FTMOPA_M2ZZZI_HtoS", LIEF::assembly::aarch64::OPCODE::FTMOPA_M2ZZZI_HtoS)
  .value("FTMOPA_M2ZZZI_StoS", LIEF::assembly::aarch64::OPCODE::FTMOPA_M2ZZZI_StoS)
  .value("FTSMUL_ZZZ_D", LIEF::assembly::aarch64::OPCODE::FTSMUL_ZZZ_D)
  .value("FTSMUL_ZZZ_H", LIEF::assembly::aarch64::OPCODE::FTSMUL_ZZZ_H)
  .value("FTSMUL_ZZZ_S", LIEF::assembly::aarch64::OPCODE::FTSMUL_ZZZ_S)
  .value("FTSSEL_ZZZ_D", LIEF::assembly::aarch64::OPCODE::FTSSEL_ZZZ_D)
  .value("FTSSEL_ZZZ_H", LIEF::assembly::aarch64::OPCODE::FTSSEL_ZZZ_H)
  .value("FTSSEL_ZZZ_S", LIEF::assembly::aarch64::OPCODE::FTSSEL_ZZZ_S)
  .value("FVDOTB_VG4_M2ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::FVDOTB_VG4_M2ZZI_BtoS)
  .value("FVDOTT_VG4_M2ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::FVDOTT_VG4_M2ZZI_BtoS)
  .value("FVDOT_VG2_M2ZZI_BtoH", LIEF::assembly::aarch64::OPCODE::FVDOT_VG2_M2ZZI_BtoH)
  .value("FVDOT_VG2_M2ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::FVDOT_VG2_M2ZZI_HtoS)
  .value("GCSPOPCX", LIEF::assembly::aarch64::OPCODE::GCSPOPCX)
  .value("GCSPOPM", LIEF::assembly::aarch64::OPCODE::GCSPOPM)
  .value("GCSPOPX", LIEF::assembly::aarch64::OPCODE::GCSPOPX)
  .value("GCSPUSHM", LIEF::assembly::aarch64::OPCODE::GCSPUSHM)
  .value("GCSPUSHX", LIEF::assembly::aarch64::OPCODE::GCSPUSHX)
  .value("GCSSS1", LIEF::assembly::aarch64::OPCODE::GCSSS1)
  .value("GCSSS2", LIEF::assembly::aarch64::OPCODE::GCSSS2)
  .value("GCSSTR", LIEF::assembly::aarch64::OPCODE::GCSSTR)
  .value("GCSSTTR", LIEF::assembly::aarch64::OPCODE::GCSSTTR)
  .value("GLD1B_D", LIEF::assembly::aarch64::OPCODE::GLD1B_D)
  .value("GLD1B_D_IMM", LIEF::assembly::aarch64::OPCODE::GLD1B_D_IMM)
  .value("GLD1B_D_SXTW", LIEF::assembly::aarch64::OPCODE::GLD1B_D_SXTW)
  .value("GLD1B_D_UXTW", LIEF::assembly::aarch64::OPCODE::GLD1B_D_UXTW)
  .value("GLD1B_S_IMM", LIEF::assembly::aarch64::OPCODE::GLD1B_S_IMM)
  .value("GLD1B_S_SXTW", LIEF::assembly::aarch64::OPCODE::GLD1B_S_SXTW)
  .value("GLD1B_S_UXTW", LIEF::assembly::aarch64::OPCODE::GLD1B_S_UXTW)
  .value("GLD1D", LIEF::assembly::aarch64::OPCODE::GLD1D)
  .value("GLD1D_IMM", LIEF::assembly::aarch64::OPCODE::GLD1D_IMM)
  .value("GLD1D_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1D_SCALED)
  .value("GLD1D_SXTW", LIEF::assembly::aarch64::OPCODE::GLD1D_SXTW)
  .value("GLD1D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1D_SXTW_SCALED)
  .value("GLD1D_UXTW", LIEF::assembly::aarch64::OPCODE::GLD1D_UXTW)
  .value("GLD1D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1D_UXTW_SCALED)
  .value("GLD1H_D", LIEF::assembly::aarch64::OPCODE::GLD1H_D)
  .value("GLD1H_D_IMM", LIEF::assembly::aarch64::OPCODE::GLD1H_D_IMM)
  .value("GLD1H_D_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1H_D_SCALED)
  .value("GLD1H_D_SXTW", LIEF::assembly::aarch64::OPCODE::GLD1H_D_SXTW)
  .value("GLD1H_D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1H_D_SXTW_SCALED)
  .value("GLD1H_D_UXTW", LIEF::assembly::aarch64::OPCODE::GLD1H_D_UXTW)
  .value("GLD1H_D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1H_D_UXTW_SCALED)
  .value("GLD1H_S_IMM", LIEF::assembly::aarch64::OPCODE::GLD1H_S_IMM)
  .value("GLD1H_S_SXTW", LIEF::assembly::aarch64::OPCODE::GLD1H_S_SXTW)
  .value("GLD1H_S_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1H_S_SXTW_SCALED)
  .value("GLD1H_S_UXTW", LIEF::assembly::aarch64::OPCODE::GLD1H_S_UXTW)
  .value("GLD1H_S_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1H_S_UXTW_SCALED)
  .value("GLD1Q", LIEF::assembly::aarch64::OPCODE::GLD1Q)
  .value("GLD1SB_D", LIEF::assembly::aarch64::OPCODE::GLD1SB_D)
  .value("GLD1SB_D_IMM", LIEF::assembly::aarch64::OPCODE::GLD1SB_D_IMM)
  .value("GLD1SB_D_SXTW", LIEF::assembly::aarch64::OPCODE::GLD1SB_D_SXTW)
  .value("GLD1SB_D_UXTW", LIEF::assembly::aarch64::OPCODE::GLD1SB_D_UXTW)
  .value("GLD1SB_S_IMM", LIEF::assembly::aarch64::OPCODE::GLD1SB_S_IMM)
  .value("GLD1SB_S_SXTW", LIEF::assembly::aarch64::OPCODE::GLD1SB_S_SXTW)
  .value("GLD1SB_S_UXTW", LIEF::assembly::aarch64::OPCODE::GLD1SB_S_UXTW)
  .value("GLD1SH_D", LIEF::assembly::aarch64::OPCODE::GLD1SH_D)
  .value("GLD1SH_D_IMM", LIEF::assembly::aarch64::OPCODE::GLD1SH_D_IMM)
  .value("GLD1SH_D_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1SH_D_SCALED)
  .value("GLD1SH_D_SXTW", LIEF::assembly::aarch64::OPCODE::GLD1SH_D_SXTW)
  .value("GLD1SH_D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1SH_D_SXTW_SCALED)
  .value("GLD1SH_D_UXTW", LIEF::assembly::aarch64::OPCODE::GLD1SH_D_UXTW)
  .value("GLD1SH_D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1SH_D_UXTW_SCALED)
  .value("GLD1SH_S_IMM", LIEF::assembly::aarch64::OPCODE::GLD1SH_S_IMM)
  .value("GLD1SH_S_SXTW", LIEF::assembly::aarch64::OPCODE::GLD1SH_S_SXTW)
  .value("GLD1SH_S_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1SH_S_SXTW_SCALED)
  .value("GLD1SH_S_UXTW", LIEF::assembly::aarch64::OPCODE::GLD1SH_S_UXTW)
  .value("GLD1SH_S_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1SH_S_UXTW_SCALED)
  .value("GLD1SW_D", LIEF::assembly::aarch64::OPCODE::GLD1SW_D)
  .value("GLD1SW_D_IMM", LIEF::assembly::aarch64::OPCODE::GLD1SW_D_IMM)
  .value("GLD1SW_D_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1SW_D_SCALED)
  .value("GLD1SW_D_SXTW", LIEF::assembly::aarch64::OPCODE::GLD1SW_D_SXTW)
  .value("GLD1SW_D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1SW_D_SXTW_SCALED)
  .value("GLD1SW_D_UXTW", LIEF::assembly::aarch64::OPCODE::GLD1SW_D_UXTW)
  .value("GLD1SW_D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1SW_D_UXTW_SCALED)
  .value("GLD1W_D", LIEF::assembly::aarch64::OPCODE::GLD1W_D)
  .value("GLD1W_D_IMM", LIEF::assembly::aarch64::OPCODE::GLD1W_D_IMM)
  .value("GLD1W_D_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1W_D_SCALED)
  .value("GLD1W_D_SXTW", LIEF::assembly::aarch64::OPCODE::GLD1W_D_SXTW)
  .value("GLD1W_D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1W_D_SXTW_SCALED)
  .value("GLD1W_D_UXTW", LIEF::assembly::aarch64::OPCODE::GLD1W_D_UXTW)
  .value("GLD1W_D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1W_D_UXTW_SCALED)
  .value("GLD1W_IMM", LIEF::assembly::aarch64::OPCODE::GLD1W_IMM)
  .value("GLD1W_SXTW", LIEF::assembly::aarch64::OPCODE::GLD1W_SXTW)
  .value("GLD1W_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1W_SXTW_SCALED)
  .value("GLD1W_UXTW", LIEF::assembly::aarch64::OPCODE::GLD1W_UXTW)
  .value("GLD1W_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLD1W_UXTW_SCALED)
  .value("GLDFF1B_D", LIEF::assembly::aarch64::OPCODE::GLDFF1B_D)
  .value("GLDFF1B_D_IMM", LIEF::assembly::aarch64::OPCODE::GLDFF1B_D_IMM)
  .value("GLDFF1B_D_SXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1B_D_SXTW)
  .value("GLDFF1B_D_UXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1B_D_UXTW)
  .value("GLDFF1B_S_IMM", LIEF::assembly::aarch64::OPCODE::GLDFF1B_S_IMM)
  .value("GLDFF1B_S_SXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1B_S_SXTW)
  .value("GLDFF1B_S_UXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1B_S_UXTW)
  .value("GLDFF1D", LIEF::assembly::aarch64::OPCODE::GLDFF1D)
  .value("GLDFF1D_IMM", LIEF::assembly::aarch64::OPCODE::GLDFF1D_IMM)
  .value("GLDFF1D_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1D_SCALED)
  .value("GLDFF1D_SXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1D_SXTW)
  .value("GLDFF1D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1D_SXTW_SCALED)
  .value("GLDFF1D_UXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1D_UXTW)
  .value("GLDFF1D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1D_UXTW_SCALED)
  .value("GLDFF1H_D", LIEF::assembly::aarch64::OPCODE::GLDFF1H_D)
  .value("GLDFF1H_D_IMM", LIEF::assembly::aarch64::OPCODE::GLDFF1H_D_IMM)
  .value("GLDFF1H_D_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1H_D_SCALED)
  .value("GLDFF1H_D_SXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1H_D_SXTW)
  .value("GLDFF1H_D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1H_D_SXTW_SCALED)
  .value("GLDFF1H_D_UXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1H_D_UXTW)
  .value("GLDFF1H_D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1H_D_UXTW_SCALED);
  opcodes.value("GLDFF1H_S_IMM", LIEF::assembly::aarch64::OPCODE::GLDFF1H_S_IMM)
  .value("GLDFF1H_S_SXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1H_S_SXTW)
  .value("GLDFF1H_S_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1H_S_SXTW_SCALED)
  .value("GLDFF1H_S_UXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1H_S_UXTW)
  .value("GLDFF1H_S_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1H_S_UXTW_SCALED)
  .value("GLDFF1SB_D", LIEF::assembly::aarch64::OPCODE::GLDFF1SB_D)
  .value("GLDFF1SB_D_IMM", LIEF::assembly::aarch64::OPCODE::GLDFF1SB_D_IMM)
  .value("GLDFF1SB_D_SXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1SB_D_SXTW)
  .value("GLDFF1SB_D_UXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1SB_D_UXTW)
  .value("GLDFF1SB_S_IMM", LIEF::assembly::aarch64::OPCODE::GLDFF1SB_S_IMM)
  .value("GLDFF1SB_S_SXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1SB_S_SXTW)
  .value("GLDFF1SB_S_UXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1SB_S_UXTW)
  .value("GLDFF1SH_D", LIEF::assembly::aarch64::OPCODE::GLDFF1SH_D)
  .value("GLDFF1SH_D_IMM", LIEF::assembly::aarch64::OPCODE::GLDFF1SH_D_IMM)
  .value("GLDFF1SH_D_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1SH_D_SCALED)
  .value("GLDFF1SH_D_SXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1SH_D_SXTW)
  .value("GLDFF1SH_D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1SH_D_SXTW_SCALED)
  .value("GLDFF1SH_D_UXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1SH_D_UXTW)
  .value("GLDFF1SH_D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1SH_D_UXTW_SCALED)
  .value("GLDFF1SH_S_IMM", LIEF::assembly::aarch64::OPCODE::GLDFF1SH_S_IMM)
  .value("GLDFF1SH_S_SXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1SH_S_SXTW)
  .value("GLDFF1SH_S_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1SH_S_SXTW_SCALED)
  .value("GLDFF1SH_S_UXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1SH_S_UXTW)
  .value("GLDFF1SH_S_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1SH_S_UXTW_SCALED)
  .value("GLDFF1SW_D", LIEF::assembly::aarch64::OPCODE::GLDFF1SW_D)
  .value("GLDFF1SW_D_IMM", LIEF::assembly::aarch64::OPCODE::GLDFF1SW_D_IMM)
  .value("GLDFF1SW_D_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1SW_D_SCALED)
  .value("GLDFF1SW_D_SXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1SW_D_SXTW)
  .value("GLDFF1SW_D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1SW_D_SXTW_SCALED)
  .value("GLDFF1SW_D_UXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1SW_D_UXTW)
  .value("GLDFF1SW_D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1SW_D_UXTW_SCALED)
  .value("GLDFF1W_D", LIEF::assembly::aarch64::OPCODE::GLDFF1W_D)
  .value("GLDFF1W_D_IMM", LIEF::assembly::aarch64::OPCODE::GLDFF1W_D_IMM)
  .value("GLDFF1W_D_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1W_D_SCALED)
  .value("GLDFF1W_D_SXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1W_D_SXTW)
  .value("GLDFF1W_D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1W_D_SXTW_SCALED)
  .value("GLDFF1W_D_UXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1W_D_UXTW)
  .value("GLDFF1W_D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1W_D_UXTW_SCALED)
  .value("GLDFF1W_IMM", LIEF::assembly::aarch64::OPCODE::GLDFF1W_IMM)
  .value("GLDFF1W_SXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1W_SXTW)
  .value("GLDFF1W_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1W_SXTW_SCALED)
  .value("GLDFF1W_UXTW", LIEF::assembly::aarch64::OPCODE::GLDFF1W_UXTW)
  .value("GLDFF1W_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::GLDFF1W_UXTW_SCALED)
  .value("GMI", LIEF::assembly::aarch64::OPCODE::GMI)
  .value("HINT", LIEF::assembly::aarch64::OPCODE::HINT)
  .value("HISTCNT_ZPzZZ_D", LIEF::assembly::aarch64::OPCODE::HISTCNT_ZPzZZ_D)
  .value("HISTCNT_ZPzZZ_S", LIEF::assembly::aarch64::OPCODE::HISTCNT_ZPzZZ_S)
  .value("HISTSEG_ZZZ", LIEF::assembly::aarch64::OPCODE::HISTSEG_ZZZ)
  .value("HLT", LIEF::assembly::aarch64::OPCODE::HLT)
  .value("HVC", LIEF::assembly::aarch64::OPCODE::HVC)
  .value("INCB_XPiI", LIEF::assembly::aarch64::OPCODE::INCB_XPiI)
  .value("INCD_XPiI", LIEF::assembly::aarch64::OPCODE::INCD_XPiI)
  .value("INCD_ZPiI", LIEF::assembly::aarch64::OPCODE::INCD_ZPiI)
  .value("INCH_XPiI", LIEF::assembly::aarch64::OPCODE::INCH_XPiI)
  .value("INCH_ZPiI", LIEF::assembly::aarch64::OPCODE::INCH_ZPiI)
  .value("INCP_XP_B", LIEF::assembly::aarch64::OPCODE::INCP_XP_B)
  .value("INCP_XP_D", LIEF::assembly::aarch64::OPCODE::INCP_XP_D)
  .value("INCP_XP_H", LIEF::assembly::aarch64::OPCODE::INCP_XP_H)
  .value("INCP_XP_S", LIEF::assembly::aarch64::OPCODE::INCP_XP_S)
  .value("INCP_ZP_D", LIEF::assembly::aarch64::OPCODE::INCP_ZP_D)
  .value("INCP_ZP_H", LIEF::assembly::aarch64::OPCODE::INCP_ZP_H)
  .value("INCP_ZP_S", LIEF::assembly::aarch64::OPCODE::INCP_ZP_S)
  .value("INCW_XPiI", LIEF::assembly::aarch64::OPCODE::INCW_XPiI)
  .value("INCW_ZPiI", LIEF::assembly::aarch64::OPCODE::INCW_ZPiI)
  .value("INDEX_II_B", LIEF::assembly::aarch64::OPCODE::INDEX_II_B)
  .value("INDEX_II_D", LIEF::assembly::aarch64::OPCODE::INDEX_II_D)
  .value("INDEX_II_H", LIEF::assembly::aarch64::OPCODE::INDEX_II_H)
  .value("INDEX_II_S", LIEF::assembly::aarch64::OPCODE::INDEX_II_S)
  .value("INDEX_IR_B", LIEF::assembly::aarch64::OPCODE::INDEX_IR_B)
  .value("INDEX_IR_D", LIEF::assembly::aarch64::OPCODE::INDEX_IR_D)
  .value("INDEX_IR_H", LIEF::assembly::aarch64::OPCODE::INDEX_IR_H)
  .value("INDEX_IR_S", LIEF::assembly::aarch64::OPCODE::INDEX_IR_S)
  .value("INDEX_RI_B", LIEF::assembly::aarch64::OPCODE::INDEX_RI_B)
  .value("INDEX_RI_D", LIEF::assembly::aarch64::OPCODE::INDEX_RI_D)
  .value("INDEX_RI_H", LIEF::assembly::aarch64::OPCODE::INDEX_RI_H)
  .value("INDEX_RI_S", LIEF::assembly::aarch64::OPCODE::INDEX_RI_S)
  .value("INDEX_RR_B", LIEF::assembly::aarch64::OPCODE::INDEX_RR_B)
  .value("INDEX_RR_D", LIEF::assembly::aarch64::OPCODE::INDEX_RR_D)
  .value("INDEX_RR_H", LIEF::assembly::aarch64::OPCODE::INDEX_RR_H)
  .value("INDEX_RR_S", LIEF::assembly::aarch64::OPCODE::INDEX_RR_S)
  .value("INSERT_MXIPZ_H_B", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_H_B)
  .value("INSERT_MXIPZ_H_D", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_H_D)
  .value("INSERT_MXIPZ_H_H", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_H_H)
  .value("INSERT_MXIPZ_H_Q", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_H_Q)
  .value("INSERT_MXIPZ_H_S", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_H_S)
  .value("INSERT_MXIPZ_V_B", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_V_B)
  .value("INSERT_MXIPZ_V_D", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_V_D)
  .value("INSERT_MXIPZ_V_H", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_V_H)
  .value("INSERT_MXIPZ_V_Q", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_V_Q)
  .value("INSERT_MXIPZ_V_S", LIEF::assembly::aarch64::OPCODE::INSERT_MXIPZ_V_S)
  .value("INSR_ZR_B", LIEF::assembly::aarch64::OPCODE::INSR_ZR_B)
  .value("INSR_ZR_D", LIEF::assembly::aarch64::OPCODE::INSR_ZR_D)
  .value("INSR_ZR_H", LIEF::assembly::aarch64::OPCODE::INSR_ZR_H)
  .value("INSR_ZR_S", LIEF::assembly::aarch64::OPCODE::INSR_ZR_S)
  .value("INSR_ZV_B", LIEF::assembly::aarch64::OPCODE::INSR_ZV_B)
  .value("INSR_ZV_D", LIEF::assembly::aarch64::OPCODE::INSR_ZV_D)
  .value("INSR_ZV_H", LIEF::assembly::aarch64::OPCODE::INSR_ZV_H)
  .value("INSR_ZV_S", LIEF::assembly::aarch64::OPCODE::INSR_ZV_S)
  .value("INSvi16gpr", LIEF::assembly::aarch64::OPCODE::INSvi16gpr)
  .value("INSvi16lane", LIEF::assembly::aarch64::OPCODE::INSvi16lane)
  .value("INSvi32gpr", LIEF::assembly::aarch64::OPCODE::INSvi32gpr)
  .value("INSvi32lane", LIEF::assembly::aarch64::OPCODE::INSvi32lane)
  .value("INSvi64gpr", LIEF::assembly::aarch64::OPCODE::INSvi64gpr)
  .value("INSvi64lane", LIEF::assembly::aarch64::OPCODE::INSvi64lane)
  .value("INSvi8gpr", LIEF::assembly::aarch64::OPCODE::INSvi8gpr)
  .value("INSvi8lane", LIEF::assembly::aarch64::OPCODE::INSvi8lane)
  .value("IRG", LIEF::assembly::aarch64::OPCODE::IRG)
  .value("ISB", LIEF::assembly::aarch64::OPCODE::ISB)
  .value("LASTA_RPZ_B", LIEF::assembly::aarch64::OPCODE::LASTA_RPZ_B)
  .value("LASTA_RPZ_D", LIEF::assembly::aarch64::OPCODE::LASTA_RPZ_D)
  .value("LASTA_RPZ_H", LIEF::assembly::aarch64::OPCODE::LASTA_RPZ_H)
  .value("LASTA_RPZ_S", LIEF::assembly::aarch64::OPCODE::LASTA_RPZ_S)
  .value("LASTA_VPZ_B", LIEF::assembly::aarch64::OPCODE::LASTA_VPZ_B)
  .value("LASTA_VPZ_D", LIEF::assembly::aarch64::OPCODE::LASTA_VPZ_D)
  .value("LASTA_VPZ_H", LIEF::assembly::aarch64::OPCODE::LASTA_VPZ_H)
  .value("LASTA_VPZ_S", LIEF::assembly::aarch64::OPCODE::LASTA_VPZ_S)
  .value("LASTB_RPZ_B", LIEF::assembly::aarch64::OPCODE::LASTB_RPZ_B)
  .value("LASTB_RPZ_D", LIEF::assembly::aarch64::OPCODE::LASTB_RPZ_D)
  .value("LASTB_RPZ_H", LIEF::assembly::aarch64::OPCODE::LASTB_RPZ_H)
  .value("LASTB_RPZ_S", LIEF::assembly::aarch64::OPCODE::LASTB_RPZ_S)
  .value("LASTB_VPZ_B", LIEF::assembly::aarch64::OPCODE::LASTB_VPZ_B)
  .value("LASTB_VPZ_D", LIEF::assembly::aarch64::OPCODE::LASTB_VPZ_D)
  .value("LASTB_VPZ_H", LIEF::assembly::aarch64::OPCODE::LASTB_VPZ_H)
  .value("LASTB_VPZ_S", LIEF::assembly::aarch64::OPCODE::LASTB_VPZ_S)
  .value("LASTP_XPP_B", LIEF::assembly::aarch64::OPCODE::LASTP_XPP_B)
  .value("LASTP_XPP_D", LIEF::assembly::aarch64::OPCODE::LASTP_XPP_D)
  .value("LASTP_XPP_H", LIEF::assembly::aarch64::OPCODE::LASTP_XPP_H)
  .value("LASTP_XPP_S", LIEF::assembly::aarch64::OPCODE::LASTP_XPP_S)
  .value("LD1B", LIEF::assembly::aarch64::OPCODE::LD1B)
  .value("LD1B_2Z", LIEF::assembly::aarch64::OPCODE::LD1B_2Z)
  .value("LD1B_2Z_IMM", LIEF::assembly::aarch64::OPCODE::LD1B_2Z_IMM)
  .value("LD1B_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LD1B_2Z_STRIDED)
  .value("LD1B_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LD1B_2Z_STRIDED_IMM)
  .value("LD1B_4Z", LIEF::assembly::aarch64::OPCODE::LD1B_4Z)
  .value("LD1B_4Z_IMM", LIEF::assembly::aarch64::OPCODE::LD1B_4Z_IMM)
  .value("LD1B_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LD1B_4Z_STRIDED)
  .value("LD1B_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LD1B_4Z_STRIDED_IMM)
  .value("LD1B_D", LIEF::assembly::aarch64::OPCODE::LD1B_D)
  .value("LD1B_D_IMM", LIEF::assembly::aarch64::OPCODE::LD1B_D_IMM)
  .value("LD1B_H", LIEF::assembly::aarch64::OPCODE::LD1B_H)
  .value("LD1B_H_IMM", LIEF::assembly::aarch64::OPCODE::LD1B_H_IMM)
  .value("LD1B_IMM", LIEF::assembly::aarch64::OPCODE::LD1B_IMM)
  .value("LD1B_S", LIEF::assembly::aarch64::OPCODE::LD1B_S)
  .value("LD1B_S_IMM", LIEF::assembly::aarch64::OPCODE::LD1B_S_IMM)
  .value("LD1D", LIEF::assembly::aarch64::OPCODE::LD1D)
  .value("LD1D_2Z", LIEF::assembly::aarch64::OPCODE::LD1D_2Z)
  .value("LD1D_2Z_IMM", LIEF::assembly::aarch64::OPCODE::LD1D_2Z_IMM)
  .value("LD1D_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LD1D_2Z_STRIDED)
  .value("LD1D_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LD1D_2Z_STRIDED_IMM)
  .value("LD1D_4Z", LIEF::assembly::aarch64::OPCODE::LD1D_4Z)
  .value("LD1D_4Z_IMM", LIEF::assembly::aarch64::OPCODE::LD1D_4Z_IMM)
  .value("LD1D_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LD1D_4Z_STRIDED)
  .value("LD1D_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LD1D_4Z_STRIDED_IMM)
  .value("LD1D_IMM", LIEF::assembly::aarch64::OPCODE::LD1D_IMM)
  .value("LD1D_Q", LIEF::assembly::aarch64::OPCODE::LD1D_Q)
  .value("LD1D_Q_IMM", LIEF::assembly::aarch64::OPCODE::LD1D_Q_IMM)
  .value("LD1Fourv16b", LIEF::assembly::aarch64::OPCODE::LD1Fourv16b)
  .value("LD1Fourv16b_POST", LIEF::assembly::aarch64::OPCODE::LD1Fourv16b_POST)
  .value("LD1Fourv1d", LIEF::assembly::aarch64::OPCODE::LD1Fourv1d)
  .value("LD1Fourv1d_POST", LIEF::assembly::aarch64::OPCODE::LD1Fourv1d_POST)
  .value("LD1Fourv2d", LIEF::assembly::aarch64::OPCODE::LD1Fourv2d)
  .value("LD1Fourv2d_POST", LIEF::assembly::aarch64::OPCODE::LD1Fourv2d_POST)
  .value("LD1Fourv2s", LIEF::assembly::aarch64::OPCODE::LD1Fourv2s)
  .value("LD1Fourv2s_POST", LIEF::assembly::aarch64::OPCODE::LD1Fourv2s_POST)
  .value("LD1Fourv4h", LIEF::assembly::aarch64::OPCODE::LD1Fourv4h)
  .value("LD1Fourv4h_POST", LIEF::assembly::aarch64::OPCODE::LD1Fourv4h_POST)
  .value("LD1Fourv4s", LIEF::assembly::aarch64::OPCODE::LD1Fourv4s)
  .value("LD1Fourv4s_POST", LIEF::assembly::aarch64::OPCODE::LD1Fourv4s_POST)
  .value("LD1Fourv8b", LIEF::assembly::aarch64::OPCODE::LD1Fourv8b)
  .value("LD1Fourv8b_POST", LIEF::assembly::aarch64::OPCODE::LD1Fourv8b_POST)
  .value("LD1Fourv8h", LIEF::assembly::aarch64::OPCODE::LD1Fourv8h)
  .value("LD1Fourv8h_POST", LIEF::assembly::aarch64::OPCODE::LD1Fourv8h_POST)
  .value("LD1H", LIEF::assembly::aarch64::OPCODE::LD1H)
  .value("LD1H_2Z", LIEF::assembly::aarch64::OPCODE::LD1H_2Z)
  .value("LD1H_2Z_IMM", LIEF::assembly::aarch64::OPCODE::LD1H_2Z_IMM)
  .value("LD1H_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LD1H_2Z_STRIDED)
  .value("LD1H_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LD1H_2Z_STRIDED_IMM)
  .value("LD1H_4Z", LIEF::assembly::aarch64::OPCODE::LD1H_4Z)
  .value("LD1H_4Z_IMM", LIEF::assembly::aarch64::OPCODE::LD1H_4Z_IMM)
  .value("LD1H_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LD1H_4Z_STRIDED)
  .value("LD1H_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LD1H_4Z_STRIDED_IMM)
  .value("LD1H_D", LIEF::assembly::aarch64::OPCODE::LD1H_D)
  .value("LD1H_D_IMM", LIEF::assembly::aarch64::OPCODE::LD1H_D_IMM)
  .value("LD1H_IMM", LIEF::assembly::aarch64::OPCODE::LD1H_IMM)
  .value("LD1H_S", LIEF::assembly::aarch64::OPCODE::LD1H_S)
  .value("LD1H_S_IMM", LIEF::assembly::aarch64::OPCODE::LD1H_S_IMM)
  .value("LD1Onev16b", LIEF::assembly::aarch64::OPCODE::LD1Onev16b)
  .value("LD1Onev16b_POST", LIEF::assembly::aarch64::OPCODE::LD1Onev16b_POST)
  .value("LD1Onev1d", LIEF::assembly::aarch64::OPCODE::LD1Onev1d)
  .value("LD1Onev1d_POST", LIEF::assembly::aarch64::OPCODE::LD1Onev1d_POST)
  .value("LD1Onev2d", LIEF::assembly::aarch64::OPCODE::LD1Onev2d)
  .value("LD1Onev2d_POST", LIEF::assembly::aarch64::OPCODE::LD1Onev2d_POST)
  .value("LD1Onev2s", LIEF::assembly::aarch64::OPCODE::LD1Onev2s)
  .value("LD1Onev2s_POST", LIEF::assembly::aarch64::OPCODE::LD1Onev2s_POST)
  .value("LD1Onev4h", LIEF::assembly::aarch64::OPCODE::LD1Onev4h)
  .value("LD1Onev4h_POST", LIEF::assembly::aarch64::OPCODE::LD1Onev4h_POST)
  .value("LD1Onev4s", LIEF::assembly::aarch64::OPCODE::LD1Onev4s)
  .value("LD1Onev4s_POST", LIEF::assembly::aarch64::OPCODE::LD1Onev4s_POST)
  .value("LD1Onev8b", LIEF::assembly::aarch64::OPCODE::LD1Onev8b)
  .value("LD1Onev8b_POST", LIEF::assembly::aarch64::OPCODE::LD1Onev8b_POST)
  .value("LD1Onev8h", LIEF::assembly::aarch64::OPCODE::LD1Onev8h)
  .value("LD1Onev8h_POST", LIEF::assembly::aarch64::OPCODE::LD1Onev8h_POST)
  .value("LD1RB_D_IMM", LIEF::assembly::aarch64::OPCODE::LD1RB_D_IMM)
  .value("LD1RB_H_IMM", LIEF::assembly::aarch64::OPCODE::LD1RB_H_IMM)
  .value("LD1RB_IMM", LIEF::assembly::aarch64::OPCODE::LD1RB_IMM)
  .value("LD1RB_S_IMM", LIEF::assembly::aarch64::OPCODE::LD1RB_S_IMM)
  .value("LD1RD_IMM", LIEF::assembly::aarch64::OPCODE::LD1RD_IMM)
  .value("LD1RH_D_IMM", LIEF::assembly::aarch64::OPCODE::LD1RH_D_IMM)
  .value("LD1RH_IMM", LIEF::assembly::aarch64::OPCODE::LD1RH_IMM)
  .value("LD1RH_S_IMM", LIEF::assembly::aarch64::OPCODE::LD1RH_S_IMM)
  .value("LD1RO_B", LIEF::assembly::aarch64::OPCODE::LD1RO_B)
  .value("LD1RO_B_IMM", LIEF::assembly::aarch64::OPCODE::LD1RO_B_IMM)
  .value("LD1RO_D", LIEF::assembly::aarch64::OPCODE::LD1RO_D)
  .value("LD1RO_D_IMM", LIEF::assembly::aarch64::OPCODE::LD1RO_D_IMM)
  .value("LD1RO_H", LIEF::assembly::aarch64::OPCODE::LD1RO_H)
  .value("LD1RO_H_IMM", LIEF::assembly::aarch64::OPCODE::LD1RO_H_IMM)
  .value("LD1RO_W", LIEF::assembly::aarch64::OPCODE::LD1RO_W)
  .value("LD1RO_W_IMM", LIEF::assembly::aarch64::OPCODE::LD1RO_W_IMM)
  .value("LD1RQ_B", LIEF::assembly::aarch64::OPCODE::LD1RQ_B)
  .value("LD1RQ_B_IMM", LIEF::assembly::aarch64::OPCODE::LD1RQ_B_IMM)
  .value("LD1RQ_D", LIEF::assembly::aarch64::OPCODE::LD1RQ_D)
  .value("LD1RQ_D_IMM", LIEF::assembly::aarch64::OPCODE::LD1RQ_D_IMM)
  .value("LD1RQ_H", LIEF::assembly::aarch64::OPCODE::LD1RQ_H)
  .value("LD1RQ_H_IMM", LIEF::assembly::aarch64::OPCODE::LD1RQ_H_IMM)
  .value("LD1RQ_W", LIEF::assembly::aarch64::OPCODE::LD1RQ_W)
  .value("LD1RQ_W_IMM", LIEF::assembly::aarch64::OPCODE::LD1RQ_W_IMM)
  .value("LD1RSB_D_IMM", LIEF::assembly::aarch64::OPCODE::LD1RSB_D_IMM)
  .value("LD1RSB_H_IMM", LIEF::assembly::aarch64::OPCODE::LD1RSB_H_IMM)
  .value("LD1RSB_S_IMM", LIEF::assembly::aarch64::OPCODE::LD1RSB_S_IMM)
  .value("LD1RSH_D_IMM", LIEF::assembly::aarch64::OPCODE::LD1RSH_D_IMM)
  .value("LD1RSH_S_IMM", LIEF::assembly::aarch64::OPCODE::LD1RSH_S_IMM)
  .value("LD1RSW_IMM", LIEF::assembly::aarch64::OPCODE::LD1RSW_IMM)
  .value("LD1RW_D_IMM", LIEF::assembly::aarch64::OPCODE::LD1RW_D_IMM)
  .value("LD1RW_IMM", LIEF::assembly::aarch64::OPCODE::LD1RW_IMM)
  .value("LD1Rv16b", LIEF::assembly::aarch64::OPCODE::LD1Rv16b)
  .value("LD1Rv16b_POST", LIEF::assembly::aarch64::OPCODE::LD1Rv16b_POST)
  .value("LD1Rv1d", LIEF::assembly::aarch64::OPCODE::LD1Rv1d)
  .value("LD1Rv1d_POST", LIEF::assembly::aarch64::OPCODE::LD1Rv1d_POST)
  .value("LD1Rv2d", LIEF::assembly::aarch64::OPCODE::LD1Rv2d)
  .value("LD1Rv2d_POST", LIEF::assembly::aarch64::OPCODE::LD1Rv2d_POST)
  .value("LD1Rv2s", LIEF::assembly::aarch64::OPCODE::LD1Rv2s)
  .value("LD1Rv2s_POST", LIEF::assembly::aarch64::OPCODE::LD1Rv2s_POST)
  .value("LD1Rv4h", LIEF::assembly::aarch64::OPCODE::LD1Rv4h)
  .value("LD1Rv4h_POST", LIEF::assembly::aarch64::OPCODE::LD1Rv4h_POST)
  .value("LD1Rv4s", LIEF::assembly::aarch64::OPCODE::LD1Rv4s)
  .value("LD1Rv4s_POST", LIEF::assembly::aarch64::OPCODE::LD1Rv4s_POST)
  .value("LD1Rv8b", LIEF::assembly::aarch64::OPCODE::LD1Rv8b)
  .value("LD1Rv8b_POST", LIEF::assembly::aarch64::OPCODE::LD1Rv8b_POST)
  .value("LD1Rv8h", LIEF::assembly::aarch64::OPCODE::LD1Rv8h)
  .value("LD1Rv8h_POST", LIEF::assembly::aarch64::OPCODE::LD1Rv8h_POST)
  .value("LD1SB_D", LIEF::assembly::aarch64::OPCODE::LD1SB_D)
  .value("LD1SB_D_IMM", LIEF::assembly::aarch64::OPCODE::LD1SB_D_IMM)
  .value("LD1SB_H", LIEF::assembly::aarch64::OPCODE::LD1SB_H)
  .value("LD1SB_H_IMM", LIEF::assembly::aarch64::OPCODE::LD1SB_H_IMM)
  .value("LD1SB_S", LIEF::assembly::aarch64::OPCODE::LD1SB_S)
  .value("LD1SB_S_IMM", LIEF::assembly::aarch64::OPCODE::LD1SB_S_IMM)
  .value("LD1SH_D", LIEF::assembly::aarch64::OPCODE::LD1SH_D)
  .value("LD1SH_D_IMM", LIEF::assembly::aarch64::OPCODE::LD1SH_D_IMM)
  .value("LD1SH_S", LIEF::assembly::aarch64::OPCODE::LD1SH_S)
  .value("LD1SH_S_IMM", LIEF::assembly::aarch64::OPCODE::LD1SH_S_IMM)
  .value("LD1SW_D", LIEF::assembly::aarch64::OPCODE::LD1SW_D)
  .value("LD1SW_D_IMM", LIEF::assembly::aarch64::OPCODE::LD1SW_D_IMM)
  .value("LD1Threev16b", LIEF::assembly::aarch64::OPCODE::LD1Threev16b)
  .value("LD1Threev16b_POST", LIEF::assembly::aarch64::OPCODE::LD1Threev16b_POST)
  .value("LD1Threev1d", LIEF::assembly::aarch64::OPCODE::LD1Threev1d)
  .value("LD1Threev1d_POST", LIEF::assembly::aarch64::OPCODE::LD1Threev1d_POST)
  .value("LD1Threev2d", LIEF::assembly::aarch64::OPCODE::LD1Threev2d)
  .value("LD1Threev2d_POST", LIEF::assembly::aarch64::OPCODE::LD1Threev2d_POST)
  .value("LD1Threev2s", LIEF::assembly::aarch64::OPCODE::LD1Threev2s)
  .value("LD1Threev2s_POST", LIEF::assembly::aarch64::OPCODE::LD1Threev2s_POST)
  .value("LD1Threev4h", LIEF::assembly::aarch64::OPCODE::LD1Threev4h)
  .value("LD1Threev4h_POST", LIEF::assembly::aarch64::OPCODE::LD1Threev4h_POST)
  .value("LD1Threev4s", LIEF::assembly::aarch64::OPCODE::LD1Threev4s)
  .value("LD1Threev4s_POST", LIEF::assembly::aarch64::OPCODE::LD1Threev4s_POST)
  .value("LD1Threev8b", LIEF::assembly::aarch64::OPCODE::LD1Threev8b)
  .value("LD1Threev8b_POST", LIEF::assembly::aarch64::OPCODE::LD1Threev8b_POST)
  .value("LD1Threev8h", LIEF::assembly::aarch64::OPCODE::LD1Threev8h)
  .value("LD1Threev8h_POST", LIEF::assembly::aarch64::OPCODE::LD1Threev8h_POST)
  .value("LD1Twov16b", LIEF::assembly::aarch64::OPCODE::LD1Twov16b)
  .value("LD1Twov16b_POST", LIEF::assembly::aarch64::OPCODE::LD1Twov16b_POST)
  .value("LD1Twov1d", LIEF::assembly::aarch64::OPCODE::LD1Twov1d)
  .value("LD1Twov1d_POST", LIEF::assembly::aarch64::OPCODE::LD1Twov1d_POST)
  .value("LD1Twov2d", LIEF::assembly::aarch64::OPCODE::LD1Twov2d)
  .value("LD1Twov2d_POST", LIEF::assembly::aarch64::OPCODE::LD1Twov2d_POST)
  .value("LD1Twov2s", LIEF::assembly::aarch64::OPCODE::LD1Twov2s)
  .value("LD1Twov2s_POST", LIEF::assembly::aarch64::OPCODE::LD1Twov2s_POST)
  .value("LD1Twov4h", LIEF::assembly::aarch64::OPCODE::LD1Twov4h)
  .value("LD1Twov4h_POST", LIEF::assembly::aarch64::OPCODE::LD1Twov4h_POST)
  .value("LD1Twov4s", LIEF::assembly::aarch64::OPCODE::LD1Twov4s)
  .value("LD1Twov4s_POST", LIEF::assembly::aarch64::OPCODE::LD1Twov4s_POST)
  .value("LD1Twov8b", LIEF::assembly::aarch64::OPCODE::LD1Twov8b)
  .value("LD1Twov8b_POST", LIEF::assembly::aarch64::OPCODE::LD1Twov8b_POST)
  .value("LD1Twov8h", LIEF::assembly::aarch64::OPCODE::LD1Twov8h)
  .value("LD1Twov8h_POST", LIEF::assembly::aarch64::OPCODE::LD1Twov8h_POST)
  .value("LD1W", LIEF::assembly::aarch64::OPCODE::LD1W)
  .value("LD1W_2Z", LIEF::assembly::aarch64::OPCODE::LD1W_2Z)
  .value("LD1W_2Z_IMM", LIEF::assembly::aarch64::OPCODE::LD1W_2Z_IMM)
  .value("LD1W_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LD1W_2Z_STRIDED)
  .value("LD1W_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LD1W_2Z_STRIDED_IMM)
  .value("LD1W_4Z", LIEF::assembly::aarch64::OPCODE::LD1W_4Z);
  opcodes.value("LD1W_4Z_IMM", LIEF::assembly::aarch64::OPCODE::LD1W_4Z_IMM)
  .value("LD1W_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LD1W_4Z_STRIDED)
  .value("LD1W_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LD1W_4Z_STRIDED_IMM)
  .value("LD1W_D", LIEF::assembly::aarch64::OPCODE::LD1W_D)
  .value("LD1W_D_IMM", LIEF::assembly::aarch64::OPCODE::LD1W_D_IMM)
  .value("LD1W_IMM", LIEF::assembly::aarch64::OPCODE::LD1W_IMM)
  .value("LD1W_Q", LIEF::assembly::aarch64::OPCODE::LD1W_Q)
  .value("LD1W_Q_IMM", LIEF::assembly::aarch64::OPCODE::LD1W_Q_IMM)
  .value("LD1_MXIPXX_H_B", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_H_B)
  .value("LD1_MXIPXX_H_D", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_H_D)
  .value("LD1_MXIPXX_H_H", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_H_H)
  .value("LD1_MXIPXX_H_Q", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_H_Q)
  .value("LD1_MXIPXX_H_S", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_H_S)
  .value("LD1_MXIPXX_V_B", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_V_B)
  .value("LD1_MXIPXX_V_D", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_V_D)
  .value("LD1_MXIPXX_V_H", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_V_H)
  .value("LD1_MXIPXX_V_Q", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_V_Q)
  .value("LD1_MXIPXX_V_S", LIEF::assembly::aarch64::OPCODE::LD1_MXIPXX_V_S)
  .value("LD1i16", LIEF::assembly::aarch64::OPCODE::LD1i16)
  .value("LD1i16_POST", LIEF::assembly::aarch64::OPCODE::LD1i16_POST)
  .value("LD1i32", LIEF::assembly::aarch64::OPCODE::LD1i32)
  .value("LD1i32_POST", LIEF::assembly::aarch64::OPCODE::LD1i32_POST)
  .value("LD1i64", LIEF::assembly::aarch64::OPCODE::LD1i64)
  .value("LD1i64_POST", LIEF::assembly::aarch64::OPCODE::LD1i64_POST)
  .value("LD1i8", LIEF::assembly::aarch64::OPCODE::LD1i8)
  .value("LD1i8_POST", LIEF::assembly::aarch64::OPCODE::LD1i8_POST)
  .value("LD2B", LIEF::assembly::aarch64::OPCODE::LD2B)
  .value("LD2B_IMM", LIEF::assembly::aarch64::OPCODE::LD2B_IMM)
  .value("LD2D", LIEF::assembly::aarch64::OPCODE::LD2D)
  .value("LD2D_IMM", LIEF::assembly::aarch64::OPCODE::LD2D_IMM)
  .value("LD2H", LIEF::assembly::aarch64::OPCODE::LD2H)
  .value("LD2H_IMM", LIEF::assembly::aarch64::OPCODE::LD2H_IMM)
  .value("LD2Q", LIEF::assembly::aarch64::OPCODE::LD2Q)
  .value("LD2Q_IMM", LIEF::assembly::aarch64::OPCODE::LD2Q_IMM)
  .value("LD2Rv16b", LIEF::assembly::aarch64::OPCODE::LD2Rv16b)
  .value("LD2Rv16b_POST", LIEF::assembly::aarch64::OPCODE::LD2Rv16b_POST)
  .value("LD2Rv1d", LIEF::assembly::aarch64::OPCODE::LD2Rv1d)
  .value("LD2Rv1d_POST", LIEF::assembly::aarch64::OPCODE::LD2Rv1d_POST)
  .value("LD2Rv2d", LIEF::assembly::aarch64::OPCODE::LD2Rv2d)
  .value("LD2Rv2d_POST", LIEF::assembly::aarch64::OPCODE::LD2Rv2d_POST)
  .value("LD2Rv2s", LIEF::assembly::aarch64::OPCODE::LD2Rv2s)
  .value("LD2Rv2s_POST", LIEF::assembly::aarch64::OPCODE::LD2Rv2s_POST)
  .value("LD2Rv4h", LIEF::assembly::aarch64::OPCODE::LD2Rv4h)
  .value("LD2Rv4h_POST", LIEF::assembly::aarch64::OPCODE::LD2Rv4h_POST)
  .value("LD2Rv4s", LIEF::assembly::aarch64::OPCODE::LD2Rv4s)
  .value("LD2Rv4s_POST", LIEF::assembly::aarch64::OPCODE::LD2Rv4s_POST)
  .value("LD2Rv8b", LIEF::assembly::aarch64::OPCODE::LD2Rv8b)
  .value("LD2Rv8b_POST", LIEF::assembly::aarch64::OPCODE::LD2Rv8b_POST)
  .value("LD2Rv8h", LIEF::assembly::aarch64::OPCODE::LD2Rv8h)
  .value("LD2Rv8h_POST", LIEF::assembly::aarch64::OPCODE::LD2Rv8h_POST)
  .value("LD2Twov16b", LIEF::assembly::aarch64::OPCODE::LD2Twov16b)
  .value("LD2Twov16b_POST", LIEF::assembly::aarch64::OPCODE::LD2Twov16b_POST)
  .value("LD2Twov2d", LIEF::assembly::aarch64::OPCODE::LD2Twov2d)
  .value("LD2Twov2d_POST", LIEF::assembly::aarch64::OPCODE::LD2Twov2d_POST)
  .value("LD2Twov2s", LIEF::assembly::aarch64::OPCODE::LD2Twov2s)
  .value("LD2Twov2s_POST", LIEF::assembly::aarch64::OPCODE::LD2Twov2s_POST)
  .value("LD2Twov4h", LIEF::assembly::aarch64::OPCODE::LD2Twov4h)
  .value("LD2Twov4h_POST", LIEF::assembly::aarch64::OPCODE::LD2Twov4h_POST)
  .value("LD2Twov4s", LIEF::assembly::aarch64::OPCODE::LD2Twov4s)
  .value("LD2Twov4s_POST", LIEF::assembly::aarch64::OPCODE::LD2Twov4s_POST)
  .value("LD2Twov8b", LIEF::assembly::aarch64::OPCODE::LD2Twov8b)
  .value("LD2Twov8b_POST", LIEF::assembly::aarch64::OPCODE::LD2Twov8b_POST)
  .value("LD2Twov8h", LIEF::assembly::aarch64::OPCODE::LD2Twov8h)
  .value("LD2Twov8h_POST", LIEF::assembly::aarch64::OPCODE::LD2Twov8h_POST)
  .value("LD2W", LIEF::assembly::aarch64::OPCODE::LD2W)
  .value("LD2W_IMM", LIEF::assembly::aarch64::OPCODE::LD2W_IMM)
  .value("LD2i16", LIEF::assembly::aarch64::OPCODE::LD2i16)
  .value("LD2i16_POST", LIEF::assembly::aarch64::OPCODE::LD2i16_POST)
  .value("LD2i32", LIEF::assembly::aarch64::OPCODE::LD2i32)
  .value("LD2i32_POST", LIEF::assembly::aarch64::OPCODE::LD2i32_POST)
  .value("LD2i64", LIEF::assembly::aarch64::OPCODE::LD2i64)
  .value("LD2i64_POST", LIEF::assembly::aarch64::OPCODE::LD2i64_POST)
  .value("LD2i8", LIEF::assembly::aarch64::OPCODE::LD2i8)
  .value("LD2i8_POST", LIEF::assembly::aarch64::OPCODE::LD2i8_POST)
  .value("LD3B", LIEF::assembly::aarch64::OPCODE::LD3B)
  .value("LD3B_IMM", LIEF::assembly::aarch64::OPCODE::LD3B_IMM)
  .value("LD3D", LIEF::assembly::aarch64::OPCODE::LD3D)
  .value("LD3D_IMM", LIEF::assembly::aarch64::OPCODE::LD3D_IMM)
  .value("LD3H", LIEF::assembly::aarch64::OPCODE::LD3H)
  .value("LD3H_IMM", LIEF::assembly::aarch64::OPCODE::LD3H_IMM)
  .value("LD3Q", LIEF::assembly::aarch64::OPCODE::LD3Q)
  .value("LD3Q_IMM", LIEF::assembly::aarch64::OPCODE::LD3Q_IMM)
  .value("LD3Rv16b", LIEF::assembly::aarch64::OPCODE::LD3Rv16b)
  .value("LD3Rv16b_POST", LIEF::assembly::aarch64::OPCODE::LD3Rv16b_POST)
  .value("LD3Rv1d", LIEF::assembly::aarch64::OPCODE::LD3Rv1d)
  .value("LD3Rv1d_POST", LIEF::assembly::aarch64::OPCODE::LD3Rv1d_POST)
  .value("LD3Rv2d", LIEF::assembly::aarch64::OPCODE::LD3Rv2d)
  .value("LD3Rv2d_POST", LIEF::assembly::aarch64::OPCODE::LD3Rv2d_POST)
  .value("LD3Rv2s", LIEF::assembly::aarch64::OPCODE::LD3Rv2s)
  .value("LD3Rv2s_POST", LIEF::assembly::aarch64::OPCODE::LD3Rv2s_POST)
  .value("LD3Rv4h", LIEF::assembly::aarch64::OPCODE::LD3Rv4h)
  .value("LD3Rv4h_POST", LIEF::assembly::aarch64::OPCODE::LD3Rv4h_POST)
  .value("LD3Rv4s", LIEF::assembly::aarch64::OPCODE::LD3Rv4s)
  .value("LD3Rv4s_POST", LIEF::assembly::aarch64::OPCODE::LD3Rv4s_POST)
  .value("LD3Rv8b", LIEF::assembly::aarch64::OPCODE::LD3Rv8b)
  .value("LD3Rv8b_POST", LIEF::assembly::aarch64::OPCODE::LD3Rv8b_POST)
  .value("LD3Rv8h", LIEF::assembly::aarch64::OPCODE::LD3Rv8h)
  .value("LD3Rv8h_POST", LIEF::assembly::aarch64::OPCODE::LD3Rv8h_POST)
  .value("LD3Threev16b", LIEF::assembly::aarch64::OPCODE::LD3Threev16b)
  .value("LD3Threev16b_POST", LIEF::assembly::aarch64::OPCODE::LD3Threev16b_POST)
  .value("LD3Threev2d", LIEF::assembly::aarch64::OPCODE::LD3Threev2d)
  .value("LD3Threev2d_POST", LIEF::assembly::aarch64::OPCODE::LD3Threev2d_POST)
  .value("LD3Threev2s", LIEF::assembly::aarch64::OPCODE::LD3Threev2s)
  .value("LD3Threev2s_POST", LIEF::assembly::aarch64::OPCODE::LD3Threev2s_POST)
  .value("LD3Threev4h", LIEF::assembly::aarch64::OPCODE::LD3Threev4h)
  .value("LD3Threev4h_POST", LIEF::assembly::aarch64::OPCODE::LD3Threev4h_POST)
  .value("LD3Threev4s", LIEF::assembly::aarch64::OPCODE::LD3Threev4s)
  .value("LD3Threev4s_POST", LIEF::assembly::aarch64::OPCODE::LD3Threev4s_POST)
  .value("LD3Threev8b", LIEF::assembly::aarch64::OPCODE::LD3Threev8b)
  .value("LD3Threev8b_POST", LIEF::assembly::aarch64::OPCODE::LD3Threev8b_POST)
  .value("LD3Threev8h", LIEF::assembly::aarch64::OPCODE::LD3Threev8h)
  .value("LD3Threev8h_POST", LIEF::assembly::aarch64::OPCODE::LD3Threev8h_POST)
  .value("LD3W", LIEF::assembly::aarch64::OPCODE::LD3W)
  .value("LD3W_IMM", LIEF::assembly::aarch64::OPCODE::LD3W_IMM)
  .value("LD3i16", LIEF::assembly::aarch64::OPCODE::LD3i16)
  .value("LD3i16_POST", LIEF::assembly::aarch64::OPCODE::LD3i16_POST)
  .value("LD3i32", LIEF::assembly::aarch64::OPCODE::LD3i32)
  .value("LD3i32_POST", LIEF::assembly::aarch64::OPCODE::LD3i32_POST)
  .value("LD3i64", LIEF::assembly::aarch64::OPCODE::LD3i64)
  .value("LD3i64_POST", LIEF::assembly::aarch64::OPCODE::LD3i64_POST)
  .value("LD3i8", LIEF::assembly::aarch64::OPCODE::LD3i8)
  .value("LD3i8_POST", LIEF::assembly::aarch64::OPCODE::LD3i8_POST)
  .value("LD4B", LIEF::assembly::aarch64::OPCODE::LD4B)
  .value("LD4B_IMM", LIEF::assembly::aarch64::OPCODE::LD4B_IMM)
  .value("LD4D", LIEF::assembly::aarch64::OPCODE::LD4D)
  .value("LD4D_IMM", LIEF::assembly::aarch64::OPCODE::LD4D_IMM)
  .value("LD4Fourv16b", LIEF::assembly::aarch64::OPCODE::LD4Fourv16b)
  .value("LD4Fourv16b_POST", LIEF::assembly::aarch64::OPCODE::LD4Fourv16b_POST)
  .value("LD4Fourv2d", LIEF::assembly::aarch64::OPCODE::LD4Fourv2d)
  .value("LD4Fourv2d_POST", LIEF::assembly::aarch64::OPCODE::LD4Fourv2d_POST)
  .value("LD4Fourv2s", LIEF::assembly::aarch64::OPCODE::LD4Fourv2s)
  .value("LD4Fourv2s_POST", LIEF::assembly::aarch64::OPCODE::LD4Fourv2s_POST)
  .value("LD4Fourv4h", LIEF::assembly::aarch64::OPCODE::LD4Fourv4h)
  .value("LD4Fourv4h_POST", LIEF::assembly::aarch64::OPCODE::LD4Fourv4h_POST)
  .value("LD4Fourv4s", LIEF::assembly::aarch64::OPCODE::LD4Fourv4s)
  .value("LD4Fourv4s_POST", LIEF::assembly::aarch64::OPCODE::LD4Fourv4s_POST)
  .value("LD4Fourv8b", LIEF::assembly::aarch64::OPCODE::LD4Fourv8b)
  .value("LD4Fourv8b_POST", LIEF::assembly::aarch64::OPCODE::LD4Fourv8b_POST)
  .value("LD4Fourv8h", LIEF::assembly::aarch64::OPCODE::LD4Fourv8h)
  .value("LD4Fourv8h_POST", LIEF::assembly::aarch64::OPCODE::LD4Fourv8h_POST)
  .value("LD4H", LIEF::assembly::aarch64::OPCODE::LD4H)
  .value("LD4H_IMM", LIEF::assembly::aarch64::OPCODE::LD4H_IMM)
  .value("LD4Q", LIEF::assembly::aarch64::OPCODE::LD4Q)
  .value("LD4Q_IMM", LIEF::assembly::aarch64::OPCODE::LD4Q_IMM)
  .value("LD4Rv16b", LIEF::assembly::aarch64::OPCODE::LD4Rv16b)
  .value("LD4Rv16b_POST", LIEF::assembly::aarch64::OPCODE::LD4Rv16b_POST)
  .value("LD4Rv1d", LIEF::assembly::aarch64::OPCODE::LD4Rv1d)
  .value("LD4Rv1d_POST", LIEF::assembly::aarch64::OPCODE::LD4Rv1d_POST)
  .value("LD4Rv2d", LIEF::assembly::aarch64::OPCODE::LD4Rv2d)
  .value("LD4Rv2d_POST", LIEF::assembly::aarch64::OPCODE::LD4Rv2d_POST)
  .value("LD4Rv2s", LIEF::assembly::aarch64::OPCODE::LD4Rv2s)
  .value("LD4Rv2s_POST", LIEF::assembly::aarch64::OPCODE::LD4Rv2s_POST)
  .value("LD4Rv4h", LIEF::assembly::aarch64::OPCODE::LD4Rv4h)
  .value("LD4Rv4h_POST", LIEF::assembly::aarch64::OPCODE::LD4Rv4h_POST)
  .value("LD4Rv4s", LIEF::assembly::aarch64::OPCODE::LD4Rv4s)
  .value("LD4Rv4s_POST", LIEF::assembly::aarch64::OPCODE::LD4Rv4s_POST)
  .value("LD4Rv8b", LIEF::assembly::aarch64::OPCODE::LD4Rv8b)
  .value("LD4Rv8b_POST", LIEF::assembly::aarch64::OPCODE::LD4Rv8b_POST)
  .value("LD4Rv8h", LIEF::assembly::aarch64::OPCODE::LD4Rv8h)
  .value("LD4Rv8h_POST", LIEF::assembly::aarch64::OPCODE::LD4Rv8h_POST)
  .value("LD4W", LIEF::assembly::aarch64::OPCODE::LD4W)
  .value("LD4W_IMM", LIEF::assembly::aarch64::OPCODE::LD4W_IMM)
  .value("LD4i16", LIEF::assembly::aarch64::OPCODE::LD4i16)
  .value("LD4i16_POST", LIEF::assembly::aarch64::OPCODE::LD4i16_POST)
  .value("LD4i32", LIEF::assembly::aarch64::OPCODE::LD4i32)
  .value("LD4i32_POST", LIEF::assembly::aarch64::OPCODE::LD4i32_POST)
  .value("LD4i64", LIEF::assembly::aarch64::OPCODE::LD4i64)
  .value("LD4i64_POST", LIEF::assembly::aarch64::OPCODE::LD4i64_POST)
  .value("LD4i8", LIEF::assembly::aarch64::OPCODE::LD4i8)
  .value("LD4i8_POST", LIEF::assembly::aarch64::OPCODE::LD4i8_POST)
  .value("LD64B", LIEF::assembly::aarch64::OPCODE::LD64B)
  .value("LDADDAB", LIEF::assembly::aarch64::OPCODE::LDADDAB)
  .value("LDADDAH", LIEF::assembly::aarch64::OPCODE::LDADDAH)
  .value("LDADDALB", LIEF::assembly::aarch64::OPCODE::LDADDALB)
  .value("LDADDALH", LIEF::assembly::aarch64::OPCODE::LDADDALH)
  .value("LDADDALW", LIEF::assembly::aarch64::OPCODE::LDADDALW)
  .value("LDADDALX", LIEF::assembly::aarch64::OPCODE::LDADDALX)
  .value("LDADDAW", LIEF::assembly::aarch64::OPCODE::LDADDAW)
  .value("LDADDAX", LIEF::assembly::aarch64::OPCODE::LDADDAX)
  .value("LDADDB", LIEF::assembly::aarch64::OPCODE::LDADDB)
  .value("LDADDH", LIEF::assembly::aarch64::OPCODE::LDADDH)
  .value("LDADDLB", LIEF::assembly::aarch64::OPCODE::LDADDLB)
  .value("LDADDLH", LIEF::assembly::aarch64::OPCODE::LDADDLH)
  .value("LDADDLW", LIEF::assembly::aarch64::OPCODE::LDADDLW)
  .value("LDADDLX", LIEF::assembly::aarch64::OPCODE::LDADDLX)
  .value("LDADDW", LIEF::assembly::aarch64::OPCODE::LDADDW)
  .value("LDADDX", LIEF::assembly::aarch64::OPCODE::LDADDX)
  .value("LDAP1", LIEF::assembly::aarch64::OPCODE::LDAP1)
  .value("LDAPRB", LIEF::assembly::aarch64::OPCODE::LDAPRB)
  .value("LDAPRH", LIEF::assembly::aarch64::OPCODE::LDAPRH)
  .value("LDAPRW", LIEF::assembly::aarch64::OPCODE::LDAPRW)
  .value("LDAPRWpost", LIEF::assembly::aarch64::OPCODE::LDAPRWpost)
  .value("LDAPRX", LIEF::assembly::aarch64::OPCODE::LDAPRX)
  .value("LDAPRXpost", LIEF::assembly::aarch64::OPCODE::LDAPRXpost)
  .value("LDAPURBi", LIEF::assembly::aarch64::OPCODE::LDAPURBi)
  .value("LDAPURHi", LIEF::assembly::aarch64::OPCODE::LDAPURHi)
  .value("LDAPURSBWi", LIEF::assembly::aarch64::OPCODE::LDAPURSBWi)
  .value("LDAPURSBXi", LIEF::assembly::aarch64::OPCODE::LDAPURSBXi)
  .value("LDAPURSHWi", LIEF::assembly::aarch64::OPCODE::LDAPURSHWi)
  .value("LDAPURSHXi", LIEF::assembly::aarch64::OPCODE::LDAPURSHXi)
  .value("LDAPURSWi", LIEF::assembly::aarch64::OPCODE::LDAPURSWi)
  .value("LDAPURXi", LIEF::assembly::aarch64::OPCODE::LDAPURXi)
  .value("LDAPURbi", LIEF::assembly::aarch64::OPCODE::LDAPURbi)
  .value("LDAPURdi", LIEF::assembly::aarch64::OPCODE::LDAPURdi)
  .value("LDAPURhi", LIEF::assembly::aarch64::OPCODE::LDAPURhi)
  .value("LDAPURi", LIEF::assembly::aarch64::OPCODE::LDAPURi)
  .value("LDAPURqi", LIEF::assembly::aarch64::OPCODE::LDAPURqi)
  .value("LDAPURsi", LIEF::assembly::aarch64::OPCODE::LDAPURsi)
  .value("LDARB", LIEF::assembly::aarch64::OPCODE::LDARB)
  .value("LDARH", LIEF::assembly::aarch64::OPCODE::LDARH)
  .value("LDARW", LIEF::assembly::aarch64::OPCODE::LDARW)
  .value("LDARX", LIEF::assembly::aarch64::OPCODE::LDARX)
  .value("LDATXRW", LIEF::assembly::aarch64::OPCODE::LDATXRW)
  .value("LDATXRX", LIEF::assembly::aarch64::OPCODE::LDATXRX)
  .value("LDAXPW", LIEF::assembly::aarch64::OPCODE::LDAXPW)
  .value("LDAXPX", LIEF::assembly::aarch64::OPCODE::LDAXPX)
  .value("LDAXRB", LIEF::assembly::aarch64::OPCODE::LDAXRB)
  .value("LDAXRH", LIEF::assembly::aarch64::OPCODE::LDAXRH)
  .value("LDAXRW", LIEF::assembly::aarch64::OPCODE::LDAXRW)
  .value("LDAXRX", LIEF::assembly::aarch64::OPCODE::LDAXRX)
  .value("LDBFADD", LIEF::assembly::aarch64::OPCODE::LDBFADD)
  .value("LDBFADDA", LIEF::assembly::aarch64::OPCODE::LDBFADDA)
  .value("LDBFADDAL", LIEF::assembly::aarch64::OPCODE::LDBFADDAL)
  .value("LDBFADDL", LIEF::assembly::aarch64::OPCODE::LDBFADDL)
  .value("LDBFMAX", LIEF::assembly::aarch64::OPCODE::LDBFMAX)
  .value("LDBFMAXA", LIEF::assembly::aarch64::OPCODE::LDBFMAXA)
  .value("LDBFMAXAL", LIEF::assembly::aarch64::OPCODE::LDBFMAXAL)
  .value("LDBFMAXL", LIEF::assembly::aarch64::OPCODE::LDBFMAXL)
  .value("LDBFMAXNM", LIEF::assembly::aarch64::OPCODE::LDBFMAXNM)
  .value("LDBFMAXNMA", LIEF::assembly::aarch64::OPCODE::LDBFMAXNMA)
  .value("LDBFMAXNMAL", LIEF::assembly::aarch64::OPCODE::LDBFMAXNMAL)
  .value("LDBFMAXNML", LIEF::assembly::aarch64::OPCODE::LDBFMAXNML)
  .value("LDBFMIN", LIEF::assembly::aarch64::OPCODE::LDBFMIN)
  .value("LDBFMINA", LIEF::assembly::aarch64::OPCODE::LDBFMINA)
  .value("LDBFMINAL", LIEF::assembly::aarch64::OPCODE::LDBFMINAL)
  .value("LDBFMINL", LIEF::assembly::aarch64::OPCODE::LDBFMINL)
  .value("LDBFMINNM", LIEF::assembly::aarch64::OPCODE::LDBFMINNM)
  .value("LDBFMINNMA", LIEF::assembly::aarch64::OPCODE::LDBFMINNMA)
  .value("LDBFMINNMAL", LIEF::assembly::aarch64::OPCODE::LDBFMINNMAL)
  .value("LDBFMINNML", LIEF::assembly::aarch64::OPCODE::LDBFMINNML)
  .value("LDCLRAB", LIEF::assembly::aarch64::OPCODE::LDCLRAB)
  .value("LDCLRAH", LIEF::assembly::aarch64::OPCODE::LDCLRAH)
  .value("LDCLRALB", LIEF::assembly::aarch64::OPCODE::LDCLRALB)
  .value("LDCLRALH", LIEF::assembly::aarch64::OPCODE::LDCLRALH)
  .value("LDCLRALW", LIEF::assembly::aarch64::OPCODE::LDCLRALW)
  .value("LDCLRALX", LIEF::assembly::aarch64::OPCODE::LDCLRALX)
  .value("LDCLRAW", LIEF::assembly::aarch64::OPCODE::LDCLRAW)
  .value("LDCLRAX", LIEF::assembly::aarch64::OPCODE::LDCLRAX)
  .value("LDCLRB", LIEF::assembly::aarch64::OPCODE::LDCLRB)
  .value("LDCLRH", LIEF::assembly::aarch64::OPCODE::LDCLRH)
  .value("LDCLRLB", LIEF::assembly::aarch64::OPCODE::LDCLRLB)
  .value("LDCLRLH", LIEF::assembly::aarch64::OPCODE::LDCLRLH)
  .value("LDCLRLW", LIEF::assembly::aarch64::OPCODE::LDCLRLW)
  .value("LDCLRLX", LIEF::assembly::aarch64::OPCODE::LDCLRLX)
  .value("LDCLRP", LIEF::assembly::aarch64::OPCODE::LDCLRP)
  .value("LDCLRPA", LIEF::assembly::aarch64::OPCODE::LDCLRPA)
  .value("LDCLRPAL", LIEF::assembly::aarch64::OPCODE::LDCLRPAL)
  .value("LDCLRPL", LIEF::assembly::aarch64::OPCODE::LDCLRPL)
  .value("LDCLRW", LIEF::assembly::aarch64::OPCODE::LDCLRW)
  .value("LDCLRX", LIEF::assembly::aarch64::OPCODE::LDCLRX)
  .value("LDEORAB", LIEF::assembly::aarch64::OPCODE::LDEORAB)
  .value("LDEORAH", LIEF::assembly::aarch64::OPCODE::LDEORAH)
  .value("LDEORALB", LIEF::assembly::aarch64::OPCODE::LDEORALB)
  .value("LDEORALH", LIEF::assembly::aarch64::OPCODE::LDEORALH)
  .value("LDEORALW", LIEF::assembly::aarch64::OPCODE::LDEORALW)
  .value("LDEORALX", LIEF::assembly::aarch64::OPCODE::LDEORALX)
  .value("LDEORAW", LIEF::assembly::aarch64::OPCODE::LDEORAW)
  .value("LDEORAX", LIEF::assembly::aarch64::OPCODE::LDEORAX)
  .value("LDEORB", LIEF::assembly::aarch64::OPCODE::LDEORB)
  .value("LDEORH", LIEF::assembly::aarch64::OPCODE::LDEORH)
  .value("LDEORLB", LIEF::assembly::aarch64::OPCODE::LDEORLB)
  .value("LDEORLH", LIEF::assembly::aarch64::OPCODE::LDEORLH)
  .value("LDEORLW", LIEF::assembly::aarch64::OPCODE::LDEORLW)
  .value("LDEORLX", LIEF::assembly::aarch64::OPCODE::LDEORLX)
  .value("LDEORW", LIEF::assembly::aarch64::OPCODE::LDEORW)
  .value("LDEORX", LIEF::assembly::aarch64::OPCODE::LDEORX)
  .value("LDFADDAD", LIEF::assembly::aarch64::OPCODE::LDFADDAD)
  .value("LDFADDAH", LIEF::assembly::aarch64::OPCODE::LDFADDAH)
  .value("LDFADDALD", LIEF::assembly::aarch64::OPCODE::LDFADDALD)
  .value("LDFADDALH", LIEF::assembly::aarch64::OPCODE::LDFADDALH)
  .value("LDFADDALS", LIEF::assembly::aarch64::OPCODE::LDFADDALS)
  .value("LDFADDAS", LIEF::assembly::aarch64::OPCODE::LDFADDAS)
  .value("LDFADDD", LIEF::assembly::aarch64::OPCODE::LDFADDD)
  .value("LDFADDH", LIEF::assembly::aarch64::OPCODE::LDFADDH)
  .value("LDFADDLD", LIEF::assembly::aarch64::OPCODE::LDFADDLD)
  .value("LDFADDLH", LIEF::assembly::aarch64::OPCODE::LDFADDLH)
  .value("LDFADDLS", LIEF::assembly::aarch64::OPCODE::LDFADDLS)
  .value("LDFADDS", LIEF::assembly::aarch64::OPCODE::LDFADDS)
  .value("LDFF1B", LIEF::assembly::aarch64::OPCODE::LDFF1B)
  .value("LDFF1B_D", LIEF::assembly::aarch64::OPCODE::LDFF1B_D)
  .value("LDFF1B_H", LIEF::assembly::aarch64::OPCODE::LDFF1B_H)
  .value("LDFF1B_S", LIEF::assembly::aarch64::OPCODE::LDFF1B_S)
  .value("LDFF1D", LIEF::assembly::aarch64::OPCODE::LDFF1D)
  .value("LDFF1H", LIEF::assembly::aarch64::OPCODE::LDFF1H)
  .value("LDFF1H_D", LIEF::assembly::aarch64::OPCODE::LDFF1H_D)
  .value("LDFF1H_S", LIEF::assembly::aarch64::OPCODE::LDFF1H_S)
  .value("LDFF1SB_D", LIEF::assembly::aarch64::OPCODE::LDFF1SB_D)
  .value("LDFF1SB_H", LIEF::assembly::aarch64::OPCODE::LDFF1SB_H)
  .value("LDFF1SB_S", LIEF::assembly::aarch64::OPCODE::LDFF1SB_S)
  .value("LDFF1SH_D", LIEF::assembly::aarch64::OPCODE::LDFF1SH_D);
  opcodes.value("LDFF1SH_S", LIEF::assembly::aarch64::OPCODE::LDFF1SH_S)
  .value("LDFF1SW_D", LIEF::assembly::aarch64::OPCODE::LDFF1SW_D)
  .value("LDFF1W", LIEF::assembly::aarch64::OPCODE::LDFF1W)
  .value("LDFF1W_D", LIEF::assembly::aarch64::OPCODE::LDFF1W_D)
  .value("LDFMAXAD", LIEF::assembly::aarch64::OPCODE::LDFMAXAD)
  .value("LDFMAXAH", LIEF::assembly::aarch64::OPCODE::LDFMAXAH)
  .value("LDFMAXALD", LIEF::assembly::aarch64::OPCODE::LDFMAXALD)
  .value("LDFMAXALH", LIEF::assembly::aarch64::OPCODE::LDFMAXALH)
  .value("LDFMAXALS", LIEF::assembly::aarch64::OPCODE::LDFMAXALS)
  .value("LDFMAXAS", LIEF::assembly::aarch64::OPCODE::LDFMAXAS)
  .value("LDFMAXD", LIEF::assembly::aarch64::OPCODE::LDFMAXD)
  .value("LDFMAXH", LIEF::assembly::aarch64::OPCODE::LDFMAXH)
  .value("LDFMAXLD", LIEF::assembly::aarch64::OPCODE::LDFMAXLD)
  .value("LDFMAXLH", LIEF::assembly::aarch64::OPCODE::LDFMAXLH)
  .value("LDFMAXLS", LIEF::assembly::aarch64::OPCODE::LDFMAXLS)
  .value("LDFMAXNMAD", LIEF::assembly::aarch64::OPCODE::LDFMAXNMAD)
  .value("LDFMAXNMAH", LIEF::assembly::aarch64::OPCODE::LDFMAXNMAH)
  .value("LDFMAXNMALD", LIEF::assembly::aarch64::OPCODE::LDFMAXNMALD)
  .value("LDFMAXNMALH", LIEF::assembly::aarch64::OPCODE::LDFMAXNMALH)
  .value("LDFMAXNMALS", LIEF::assembly::aarch64::OPCODE::LDFMAXNMALS)
  .value("LDFMAXNMAS", LIEF::assembly::aarch64::OPCODE::LDFMAXNMAS)
  .value("LDFMAXNMD", LIEF::assembly::aarch64::OPCODE::LDFMAXNMD)
  .value("LDFMAXNMH", LIEF::assembly::aarch64::OPCODE::LDFMAXNMH)
  .value("LDFMAXNMLD", LIEF::assembly::aarch64::OPCODE::LDFMAXNMLD)
  .value("LDFMAXNMLH", LIEF::assembly::aarch64::OPCODE::LDFMAXNMLH)
  .value("LDFMAXNMLS", LIEF::assembly::aarch64::OPCODE::LDFMAXNMLS)
  .value("LDFMAXNMS", LIEF::assembly::aarch64::OPCODE::LDFMAXNMS)
  .value("LDFMAXS", LIEF::assembly::aarch64::OPCODE::LDFMAXS)
  .value("LDFMINAD", LIEF::assembly::aarch64::OPCODE::LDFMINAD)
  .value("LDFMINAH", LIEF::assembly::aarch64::OPCODE::LDFMINAH)
  .value("LDFMINALD", LIEF::assembly::aarch64::OPCODE::LDFMINALD)
  .value("LDFMINALH", LIEF::assembly::aarch64::OPCODE::LDFMINALH)
  .value("LDFMINALS", LIEF::assembly::aarch64::OPCODE::LDFMINALS)
  .value("LDFMINAS", LIEF::assembly::aarch64::OPCODE::LDFMINAS)
  .value("LDFMIND", LIEF::assembly::aarch64::OPCODE::LDFMIND)
  .value("LDFMINH", LIEF::assembly::aarch64::OPCODE::LDFMINH)
  .value("LDFMINLD", LIEF::assembly::aarch64::OPCODE::LDFMINLD)
  .value("LDFMINLH", LIEF::assembly::aarch64::OPCODE::LDFMINLH)
  .value("LDFMINLS", LIEF::assembly::aarch64::OPCODE::LDFMINLS)
  .value("LDFMINNMAD", LIEF::assembly::aarch64::OPCODE::LDFMINNMAD)
  .value("LDFMINNMAH", LIEF::assembly::aarch64::OPCODE::LDFMINNMAH)
  .value("LDFMINNMALD", LIEF::assembly::aarch64::OPCODE::LDFMINNMALD)
  .value("LDFMINNMALH", LIEF::assembly::aarch64::OPCODE::LDFMINNMALH)
  .value("LDFMINNMALS", LIEF::assembly::aarch64::OPCODE::LDFMINNMALS)
  .value("LDFMINNMAS", LIEF::assembly::aarch64::OPCODE::LDFMINNMAS)
  .value("LDFMINNMD", LIEF::assembly::aarch64::OPCODE::LDFMINNMD)
  .value("LDFMINNMH", LIEF::assembly::aarch64::OPCODE::LDFMINNMH)
  .value("LDFMINNMLD", LIEF::assembly::aarch64::OPCODE::LDFMINNMLD)
  .value("LDFMINNMLH", LIEF::assembly::aarch64::OPCODE::LDFMINNMLH)
  .value("LDFMINNMLS", LIEF::assembly::aarch64::OPCODE::LDFMINNMLS)
  .value("LDFMINNMS", LIEF::assembly::aarch64::OPCODE::LDFMINNMS)
  .value("LDFMINS", LIEF::assembly::aarch64::OPCODE::LDFMINS)
  .value("LDG", LIEF::assembly::aarch64::OPCODE::LDG)
  .value("LDGM", LIEF::assembly::aarch64::OPCODE::LDGM)
  .value("LDIAPPW", LIEF::assembly::aarch64::OPCODE::LDIAPPW)
  .value("LDIAPPWpost", LIEF::assembly::aarch64::OPCODE::LDIAPPWpost)
  .value("LDIAPPX", LIEF::assembly::aarch64::OPCODE::LDIAPPX)
  .value("LDIAPPXpost", LIEF::assembly::aarch64::OPCODE::LDIAPPXpost)
  .value("LDLARB", LIEF::assembly::aarch64::OPCODE::LDLARB)
  .value("LDLARH", LIEF::assembly::aarch64::OPCODE::LDLARH)
  .value("LDLARW", LIEF::assembly::aarch64::OPCODE::LDLARW)
  .value("LDLARX", LIEF::assembly::aarch64::OPCODE::LDLARX)
  .value("LDNF1B_D_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1B_D_IMM)
  .value("LDNF1B_H_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1B_H_IMM)
  .value("LDNF1B_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1B_IMM)
  .value("LDNF1B_S_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1B_S_IMM)
  .value("LDNF1D_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1D_IMM)
  .value("LDNF1H_D_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1H_D_IMM)
  .value("LDNF1H_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1H_IMM)
  .value("LDNF1H_S_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1H_S_IMM)
  .value("LDNF1SB_D_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1SB_D_IMM)
  .value("LDNF1SB_H_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1SB_H_IMM)
  .value("LDNF1SB_S_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1SB_S_IMM)
  .value("LDNF1SH_D_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1SH_D_IMM)
  .value("LDNF1SH_S_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1SH_S_IMM)
  .value("LDNF1SW_D_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1SW_D_IMM)
  .value("LDNF1W_D_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1W_D_IMM)
  .value("LDNF1W_IMM", LIEF::assembly::aarch64::OPCODE::LDNF1W_IMM)
  .value("LDNPDi", LIEF::assembly::aarch64::OPCODE::LDNPDi)
  .value("LDNPQi", LIEF::assembly::aarch64::OPCODE::LDNPQi)
  .value("LDNPSi", LIEF::assembly::aarch64::OPCODE::LDNPSi)
  .value("LDNPWi", LIEF::assembly::aarch64::OPCODE::LDNPWi)
  .value("LDNPXi", LIEF::assembly::aarch64::OPCODE::LDNPXi)
  .value("LDNT1B_2Z", LIEF::assembly::aarch64::OPCODE::LDNT1B_2Z)
  .value("LDNT1B_2Z_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1B_2Z_IMM)
  .value("LDNT1B_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LDNT1B_2Z_STRIDED)
  .value("LDNT1B_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1B_2Z_STRIDED_IMM)
  .value("LDNT1B_4Z", LIEF::assembly::aarch64::OPCODE::LDNT1B_4Z)
  .value("LDNT1B_4Z_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1B_4Z_IMM)
  .value("LDNT1B_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LDNT1B_4Z_STRIDED)
  .value("LDNT1B_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1B_4Z_STRIDED_IMM)
  .value("LDNT1B_ZRI", LIEF::assembly::aarch64::OPCODE::LDNT1B_ZRI)
  .value("LDNT1B_ZRR", LIEF::assembly::aarch64::OPCODE::LDNT1B_ZRR)
  .value("LDNT1B_ZZR_D", LIEF::assembly::aarch64::OPCODE::LDNT1B_ZZR_D)
  .value("LDNT1B_ZZR_S", LIEF::assembly::aarch64::OPCODE::LDNT1B_ZZR_S)
  .value("LDNT1D_2Z", LIEF::assembly::aarch64::OPCODE::LDNT1D_2Z)
  .value("LDNT1D_2Z_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1D_2Z_IMM)
  .value("LDNT1D_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LDNT1D_2Z_STRIDED)
  .value("LDNT1D_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1D_2Z_STRIDED_IMM)
  .value("LDNT1D_4Z", LIEF::assembly::aarch64::OPCODE::LDNT1D_4Z)
  .value("LDNT1D_4Z_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1D_4Z_IMM)
  .value("LDNT1D_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LDNT1D_4Z_STRIDED)
  .value("LDNT1D_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1D_4Z_STRIDED_IMM)
  .value("LDNT1D_ZRI", LIEF::assembly::aarch64::OPCODE::LDNT1D_ZRI)
  .value("LDNT1D_ZRR", LIEF::assembly::aarch64::OPCODE::LDNT1D_ZRR)
  .value("LDNT1D_ZZR_D", LIEF::assembly::aarch64::OPCODE::LDNT1D_ZZR_D)
  .value("LDNT1H_2Z", LIEF::assembly::aarch64::OPCODE::LDNT1H_2Z)
  .value("LDNT1H_2Z_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1H_2Z_IMM)
  .value("LDNT1H_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LDNT1H_2Z_STRIDED)
  .value("LDNT1H_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1H_2Z_STRIDED_IMM)
  .value("LDNT1H_4Z", LIEF::assembly::aarch64::OPCODE::LDNT1H_4Z)
  .value("LDNT1H_4Z_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1H_4Z_IMM)
  .value("LDNT1H_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LDNT1H_4Z_STRIDED)
  .value("LDNT1H_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1H_4Z_STRIDED_IMM)
  .value("LDNT1H_ZRI", LIEF::assembly::aarch64::OPCODE::LDNT1H_ZRI)
  .value("LDNT1H_ZRR", LIEF::assembly::aarch64::OPCODE::LDNT1H_ZRR)
  .value("LDNT1H_ZZR_D", LIEF::assembly::aarch64::OPCODE::LDNT1H_ZZR_D)
  .value("LDNT1H_ZZR_S", LIEF::assembly::aarch64::OPCODE::LDNT1H_ZZR_S)
  .value("LDNT1SB_ZZR_D", LIEF::assembly::aarch64::OPCODE::LDNT1SB_ZZR_D)
  .value("LDNT1SB_ZZR_S", LIEF::assembly::aarch64::OPCODE::LDNT1SB_ZZR_S)
  .value("LDNT1SH_ZZR_D", LIEF::assembly::aarch64::OPCODE::LDNT1SH_ZZR_D)
  .value("LDNT1SH_ZZR_S", LIEF::assembly::aarch64::OPCODE::LDNT1SH_ZZR_S)
  .value("LDNT1SW_ZZR_D", LIEF::assembly::aarch64::OPCODE::LDNT1SW_ZZR_D)
  .value("LDNT1W_2Z", LIEF::assembly::aarch64::OPCODE::LDNT1W_2Z)
  .value("LDNT1W_2Z_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1W_2Z_IMM)
  .value("LDNT1W_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LDNT1W_2Z_STRIDED)
  .value("LDNT1W_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1W_2Z_STRIDED_IMM)
  .value("LDNT1W_4Z", LIEF::assembly::aarch64::OPCODE::LDNT1W_4Z)
  .value("LDNT1W_4Z_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1W_4Z_IMM)
  .value("LDNT1W_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::LDNT1W_4Z_STRIDED)
  .value("LDNT1W_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::LDNT1W_4Z_STRIDED_IMM)
  .value("LDNT1W_ZRI", LIEF::assembly::aarch64::OPCODE::LDNT1W_ZRI)
  .value("LDNT1W_ZRR", LIEF::assembly::aarch64::OPCODE::LDNT1W_ZRR)
  .value("LDNT1W_ZZR_D", LIEF::assembly::aarch64::OPCODE::LDNT1W_ZZR_D)
  .value("LDNT1W_ZZR_S", LIEF::assembly::aarch64::OPCODE::LDNT1W_ZZR_S)
  .value("LDPDi", LIEF::assembly::aarch64::OPCODE::LDPDi)
  .value("LDPDpost", LIEF::assembly::aarch64::OPCODE::LDPDpost)
  .value("LDPDpre", LIEF::assembly::aarch64::OPCODE::LDPDpre)
  .value("LDPQi", LIEF::assembly::aarch64::OPCODE::LDPQi)
  .value("LDPQpost", LIEF::assembly::aarch64::OPCODE::LDPQpost)
  .value("LDPQpre", LIEF::assembly::aarch64::OPCODE::LDPQpre)
  .value("LDPSWi", LIEF::assembly::aarch64::OPCODE::LDPSWi)
  .value("LDPSWpost", LIEF::assembly::aarch64::OPCODE::LDPSWpost)
  .value("LDPSWpre", LIEF::assembly::aarch64::OPCODE::LDPSWpre)
  .value("LDPSi", LIEF::assembly::aarch64::OPCODE::LDPSi)
  .value("LDPSpost", LIEF::assembly::aarch64::OPCODE::LDPSpost)
  .value("LDPSpre", LIEF::assembly::aarch64::OPCODE::LDPSpre)
  .value("LDPWi", LIEF::assembly::aarch64::OPCODE::LDPWi)
  .value("LDPWpost", LIEF::assembly::aarch64::OPCODE::LDPWpost)
  .value("LDPWpre", LIEF::assembly::aarch64::OPCODE::LDPWpre)
  .value("LDPXi", LIEF::assembly::aarch64::OPCODE::LDPXi)
  .value("LDPXpost", LIEF::assembly::aarch64::OPCODE::LDPXpost)
  .value("LDPXpre", LIEF::assembly::aarch64::OPCODE::LDPXpre)
  .value("LDRAAindexed", LIEF::assembly::aarch64::OPCODE::LDRAAindexed)
  .value("LDRAAwriteback", LIEF::assembly::aarch64::OPCODE::LDRAAwriteback)
  .value("LDRABindexed", LIEF::assembly::aarch64::OPCODE::LDRABindexed)
  .value("LDRABwriteback", LIEF::assembly::aarch64::OPCODE::LDRABwriteback)
  .value("LDRBBpost", LIEF::assembly::aarch64::OPCODE::LDRBBpost)
  .value("LDRBBpre", LIEF::assembly::aarch64::OPCODE::LDRBBpre)
  .value("LDRBBroW", LIEF::assembly::aarch64::OPCODE::LDRBBroW)
  .value("LDRBBroX", LIEF::assembly::aarch64::OPCODE::LDRBBroX)
  .value("LDRBBui", LIEF::assembly::aarch64::OPCODE::LDRBBui)
  .value("LDRBpost", LIEF::assembly::aarch64::OPCODE::LDRBpost)
  .value("LDRBpre", LIEF::assembly::aarch64::OPCODE::LDRBpre)
  .value("LDRBroW", LIEF::assembly::aarch64::OPCODE::LDRBroW)
  .value("LDRBroX", LIEF::assembly::aarch64::OPCODE::LDRBroX)
  .value("LDRBui", LIEF::assembly::aarch64::OPCODE::LDRBui)
  .value("LDRDl", LIEF::assembly::aarch64::OPCODE::LDRDl)
  .value("LDRDpost", LIEF::assembly::aarch64::OPCODE::LDRDpost)
  .value("LDRDpre", LIEF::assembly::aarch64::OPCODE::LDRDpre)
  .value("LDRDroW", LIEF::assembly::aarch64::OPCODE::LDRDroW)
  .value("LDRDroX", LIEF::assembly::aarch64::OPCODE::LDRDroX)
  .value("LDRDui", LIEF::assembly::aarch64::OPCODE::LDRDui)
  .value("LDRHHpost", LIEF::assembly::aarch64::OPCODE::LDRHHpost)
  .value("LDRHHpre", LIEF::assembly::aarch64::OPCODE::LDRHHpre)
  .value("LDRHHroW", LIEF::assembly::aarch64::OPCODE::LDRHHroW)
  .value("LDRHHroX", LIEF::assembly::aarch64::OPCODE::LDRHHroX)
  .value("LDRHHui", LIEF::assembly::aarch64::OPCODE::LDRHHui)
  .value("LDRHpost", LIEF::assembly::aarch64::OPCODE::LDRHpost)
  .value("LDRHpre", LIEF::assembly::aarch64::OPCODE::LDRHpre)
  .value("LDRHroW", LIEF::assembly::aarch64::OPCODE::LDRHroW)
  .value("LDRHroX", LIEF::assembly::aarch64::OPCODE::LDRHroX)
  .value("LDRHui", LIEF::assembly::aarch64::OPCODE::LDRHui)
  .value("LDRQl", LIEF::assembly::aarch64::OPCODE::LDRQl)
  .value("LDRQpost", LIEF::assembly::aarch64::OPCODE::LDRQpost)
  .value("LDRQpre", LIEF::assembly::aarch64::OPCODE::LDRQpre)
  .value("LDRQroW", LIEF::assembly::aarch64::OPCODE::LDRQroW)
  .value("LDRQroX", LIEF::assembly::aarch64::OPCODE::LDRQroX)
  .value("LDRQui", LIEF::assembly::aarch64::OPCODE::LDRQui)
  .value("LDRSBWpost", LIEF::assembly::aarch64::OPCODE::LDRSBWpost)
  .value("LDRSBWpre", LIEF::assembly::aarch64::OPCODE::LDRSBWpre)
  .value("LDRSBWroW", LIEF::assembly::aarch64::OPCODE::LDRSBWroW)
  .value("LDRSBWroX", LIEF::assembly::aarch64::OPCODE::LDRSBWroX)
  .value("LDRSBWui", LIEF::assembly::aarch64::OPCODE::LDRSBWui)
  .value("LDRSBXpost", LIEF::assembly::aarch64::OPCODE::LDRSBXpost)
  .value("LDRSBXpre", LIEF::assembly::aarch64::OPCODE::LDRSBXpre)
  .value("LDRSBXroW", LIEF::assembly::aarch64::OPCODE::LDRSBXroW)
  .value("LDRSBXroX", LIEF::assembly::aarch64::OPCODE::LDRSBXroX)
  .value("LDRSBXui", LIEF::assembly::aarch64::OPCODE::LDRSBXui)
  .value("LDRSHWpost", LIEF::assembly::aarch64::OPCODE::LDRSHWpost)
  .value("LDRSHWpre", LIEF::assembly::aarch64::OPCODE::LDRSHWpre)
  .value("LDRSHWroW", LIEF::assembly::aarch64::OPCODE::LDRSHWroW)
  .value("LDRSHWroX", LIEF::assembly::aarch64::OPCODE::LDRSHWroX)
  .value("LDRSHWui", LIEF::assembly::aarch64::OPCODE::LDRSHWui)
  .value("LDRSHXpost", LIEF::assembly::aarch64::OPCODE::LDRSHXpost)
  .value("LDRSHXpre", LIEF::assembly::aarch64::OPCODE::LDRSHXpre)
  .value("LDRSHXroW", LIEF::assembly::aarch64::OPCODE::LDRSHXroW)
  .value("LDRSHXroX", LIEF::assembly::aarch64::OPCODE::LDRSHXroX)
  .value("LDRSHXui", LIEF::assembly::aarch64::OPCODE::LDRSHXui)
  .value("LDRSWl", LIEF::assembly::aarch64::OPCODE::LDRSWl)
  .value("LDRSWpost", LIEF::assembly::aarch64::OPCODE::LDRSWpost)
  .value("LDRSWpre", LIEF::assembly::aarch64::OPCODE::LDRSWpre)
  .value("LDRSWroW", LIEF::assembly::aarch64::OPCODE::LDRSWroW)
  .value("LDRSWroX", LIEF::assembly::aarch64::OPCODE::LDRSWroX)
  .value("LDRSWui", LIEF::assembly::aarch64::OPCODE::LDRSWui)
  .value("LDRSl", LIEF::assembly::aarch64::OPCODE::LDRSl)
  .value("LDRSpost", LIEF::assembly::aarch64::OPCODE::LDRSpost)
  .value("LDRSpre", LIEF::assembly::aarch64::OPCODE::LDRSpre)
  .value("LDRSroW", LIEF::assembly::aarch64::OPCODE::LDRSroW)
  .value("LDRSroX", LIEF::assembly::aarch64::OPCODE::LDRSroX)
  .value("LDRSui", LIEF::assembly::aarch64::OPCODE::LDRSui)
  .value("LDRWl", LIEF::assembly::aarch64::OPCODE::LDRWl)
  .value("LDRWpost", LIEF::assembly::aarch64::OPCODE::LDRWpost)
  .value("LDRWpre", LIEF::assembly::aarch64::OPCODE::LDRWpre)
  .value("LDRWroW", LIEF::assembly::aarch64::OPCODE::LDRWroW)
  .value("LDRWroX", LIEF::assembly::aarch64::OPCODE::LDRWroX)
  .value("LDRWui", LIEF::assembly::aarch64::OPCODE::LDRWui)
  .value("LDRXl", LIEF::assembly::aarch64::OPCODE::LDRXl)
  .value("LDRXpost", LIEF::assembly::aarch64::OPCODE::LDRXpost)
  .value("LDRXpre", LIEF::assembly::aarch64::OPCODE::LDRXpre)
  .value("LDRXroW", LIEF::assembly::aarch64::OPCODE::LDRXroW)
  .value("LDRXroX", LIEF::assembly::aarch64::OPCODE::LDRXroX)
  .value("LDRXui", LIEF::assembly::aarch64::OPCODE::LDRXui)
  .value("LDR_PXI", LIEF::assembly::aarch64::OPCODE::LDR_PXI)
  .value("LDR_TX", LIEF::assembly::aarch64::OPCODE::LDR_TX)
  .value("LDR_ZA", LIEF::assembly::aarch64::OPCODE::LDR_ZA)
  .value("LDR_ZXI", LIEF::assembly::aarch64::OPCODE::LDR_ZXI)
  .value("LDSETAB", LIEF::assembly::aarch64::OPCODE::LDSETAB)
  .value("LDSETAH", LIEF::assembly::aarch64::OPCODE::LDSETAH)
  .value("LDSETALB", LIEF::assembly::aarch64::OPCODE::LDSETALB)
  .value("LDSETALH", LIEF::assembly::aarch64::OPCODE::LDSETALH)
  .value("LDSETALW", LIEF::assembly::aarch64::OPCODE::LDSETALW)
  .value("LDSETALX", LIEF::assembly::aarch64::OPCODE::LDSETALX)
  .value("LDSETAW", LIEF::assembly::aarch64::OPCODE::LDSETAW)
  .value("LDSETAX", LIEF::assembly::aarch64::OPCODE::LDSETAX)
  .value("LDSETB", LIEF::assembly::aarch64::OPCODE::LDSETB)
  .value("LDSETH", LIEF::assembly::aarch64::OPCODE::LDSETH)
  .value("LDSETLB", LIEF::assembly::aarch64::OPCODE::LDSETLB)
  .value("LDSETLH", LIEF::assembly::aarch64::OPCODE::LDSETLH)
  .value("LDSETLW", LIEF::assembly::aarch64::OPCODE::LDSETLW)
  .value("LDSETLX", LIEF::assembly::aarch64::OPCODE::LDSETLX)
  .value("LDSETP", LIEF::assembly::aarch64::OPCODE::LDSETP)
  .value("LDSETPA", LIEF::assembly::aarch64::OPCODE::LDSETPA)
  .value("LDSETPAL", LIEF::assembly::aarch64::OPCODE::LDSETPAL)
  .value("LDSETPL", LIEF::assembly::aarch64::OPCODE::LDSETPL)
  .value("LDSETW", LIEF::assembly::aarch64::OPCODE::LDSETW)
  .value("LDSETX", LIEF::assembly::aarch64::OPCODE::LDSETX)
  .value("LDSMAXAB", LIEF::assembly::aarch64::OPCODE::LDSMAXAB)
  .value("LDSMAXAH", LIEF::assembly::aarch64::OPCODE::LDSMAXAH)
  .value("LDSMAXALB", LIEF::assembly::aarch64::OPCODE::LDSMAXALB)
  .value("LDSMAXALH", LIEF::assembly::aarch64::OPCODE::LDSMAXALH)
  .value("LDSMAXALW", LIEF::assembly::aarch64::OPCODE::LDSMAXALW)
  .value("LDSMAXALX", LIEF::assembly::aarch64::OPCODE::LDSMAXALX)
  .value("LDSMAXAW", LIEF::assembly::aarch64::OPCODE::LDSMAXAW)
  .value("LDSMAXAX", LIEF::assembly::aarch64::OPCODE::LDSMAXAX)
  .value("LDSMAXB", LIEF::assembly::aarch64::OPCODE::LDSMAXB)
  .value("LDSMAXH", LIEF::assembly::aarch64::OPCODE::LDSMAXH)
  .value("LDSMAXLB", LIEF::assembly::aarch64::OPCODE::LDSMAXLB)
  .value("LDSMAXLH", LIEF::assembly::aarch64::OPCODE::LDSMAXLH)
  .value("LDSMAXLW", LIEF::assembly::aarch64::OPCODE::LDSMAXLW)
  .value("LDSMAXLX", LIEF::assembly::aarch64::OPCODE::LDSMAXLX)
  .value("LDSMAXW", LIEF::assembly::aarch64::OPCODE::LDSMAXW)
  .value("LDSMAXX", LIEF::assembly::aarch64::OPCODE::LDSMAXX)
  .value("LDSMINAB", LIEF::assembly::aarch64::OPCODE::LDSMINAB)
  .value("LDSMINAH", LIEF::assembly::aarch64::OPCODE::LDSMINAH)
  .value("LDSMINALB", LIEF::assembly::aarch64::OPCODE::LDSMINALB)
  .value("LDSMINALH", LIEF::assembly::aarch64::OPCODE::LDSMINALH)
  .value("LDSMINALW", LIEF::assembly::aarch64::OPCODE::LDSMINALW)
  .value("LDSMINALX", LIEF::assembly::aarch64::OPCODE::LDSMINALX)
  .value("LDSMINAW", LIEF::assembly::aarch64::OPCODE::LDSMINAW)
  .value("LDSMINAX", LIEF::assembly::aarch64::OPCODE::LDSMINAX)
  .value("LDSMINB", LIEF::assembly::aarch64::OPCODE::LDSMINB)
  .value("LDSMINH", LIEF::assembly::aarch64::OPCODE::LDSMINH)
  .value("LDSMINLB", LIEF::assembly::aarch64::OPCODE::LDSMINLB)
  .value("LDSMINLH", LIEF::assembly::aarch64::OPCODE::LDSMINLH)
  .value("LDSMINLW", LIEF::assembly::aarch64::OPCODE::LDSMINLW)
  .value("LDSMINLX", LIEF::assembly::aarch64::OPCODE::LDSMINLX)
  .value("LDSMINW", LIEF::assembly::aarch64::OPCODE::LDSMINW)
  .value("LDSMINX", LIEF::assembly::aarch64::OPCODE::LDSMINX)
  .value("LDTADDALW", LIEF::assembly::aarch64::OPCODE::LDTADDALW)
  .value("LDTADDALX", LIEF::assembly::aarch64::OPCODE::LDTADDALX)
  .value("LDTADDAW", LIEF::assembly::aarch64::OPCODE::LDTADDAW)
  .value("LDTADDAX", LIEF::assembly::aarch64::OPCODE::LDTADDAX)
  .value("LDTADDLW", LIEF::assembly::aarch64::OPCODE::LDTADDLW)
  .value("LDTADDLX", LIEF::assembly::aarch64::OPCODE::LDTADDLX)
  .value("LDTADDW", LIEF::assembly::aarch64::OPCODE::LDTADDW)
  .value("LDTADDX", LIEF::assembly::aarch64::OPCODE::LDTADDX)
  .value("LDTCLRALW", LIEF::assembly::aarch64::OPCODE::LDTCLRALW)
  .value("LDTCLRALX", LIEF::assembly::aarch64::OPCODE::LDTCLRALX)
  .value("LDTCLRAW", LIEF::assembly::aarch64::OPCODE::LDTCLRAW);
  opcodes.value("LDTCLRAX", LIEF::assembly::aarch64::OPCODE::LDTCLRAX)
  .value("LDTCLRLW", LIEF::assembly::aarch64::OPCODE::LDTCLRLW)
  .value("LDTCLRLX", LIEF::assembly::aarch64::OPCODE::LDTCLRLX)
  .value("LDTCLRW", LIEF::assembly::aarch64::OPCODE::LDTCLRW)
  .value("LDTCLRX", LIEF::assembly::aarch64::OPCODE::LDTCLRX)
  .value("LDTNPQi", LIEF::assembly::aarch64::OPCODE::LDTNPQi)
  .value("LDTNPXi", LIEF::assembly::aarch64::OPCODE::LDTNPXi)
  .value("LDTPQi", LIEF::assembly::aarch64::OPCODE::LDTPQi)
  .value("LDTPQpost", LIEF::assembly::aarch64::OPCODE::LDTPQpost)
  .value("LDTPQpre", LIEF::assembly::aarch64::OPCODE::LDTPQpre)
  .value("LDTPi", LIEF::assembly::aarch64::OPCODE::LDTPi)
  .value("LDTPpost", LIEF::assembly::aarch64::OPCODE::LDTPpost)
  .value("LDTPpre", LIEF::assembly::aarch64::OPCODE::LDTPpre)
  .value("LDTRBi", LIEF::assembly::aarch64::OPCODE::LDTRBi)
  .value("LDTRHi", LIEF::assembly::aarch64::OPCODE::LDTRHi)
  .value("LDTRSBWi", LIEF::assembly::aarch64::OPCODE::LDTRSBWi)
  .value("LDTRSBXi", LIEF::assembly::aarch64::OPCODE::LDTRSBXi)
  .value("LDTRSHWi", LIEF::assembly::aarch64::OPCODE::LDTRSHWi)
  .value("LDTRSHXi", LIEF::assembly::aarch64::OPCODE::LDTRSHXi)
  .value("LDTRSWi", LIEF::assembly::aarch64::OPCODE::LDTRSWi)
  .value("LDTRWi", LIEF::assembly::aarch64::OPCODE::LDTRWi)
  .value("LDTRXi", LIEF::assembly::aarch64::OPCODE::LDTRXi)
  .value("LDTSETALW", LIEF::assembly::aarch64::OPCODE::LDTSETALW)
  .value("LDTSETALX", LIEF::assembly::aarch64::OPCODE::LDTSETALX)
  .value("LDTSETAW", LIEF::assembly::aarch64::OPCODE::LDTSETAW)
  .value("LDTSETAX", LIEF::assembly::aarch64::OPCODE::LDTSETAX)
  .value("LDTSETLW", LIEF::assembly::aarch64::OPCODE::LDTSETLW)
  .value("LDTSETLX", LIEF::assembly::aarch64::OPCODE::LDTSETLX)
  .value("LDTSETW", LIEF::assembly::aarch64::OPCODE::LDTSETW)
  .value("LDTSETX", LIEF::assembly::aarch64::OPCODE::LDTSETX)
  .value("LDTXRWr", LIEF::assembly::aarch64::OPCODE::LDTXRWr)
  .value("LDTXRXr", LIEF::assembly::aarch64::OPCODE::LDTXRXr)
  .value("LDUMAXAB", LIEF::assembly::aarch64::OPCODE::LDUMAXAB)
  .value("LDUMAXAH", LIEF::assembly::aarch64::OPCODE::LDUMAXAH)
  .value("LDUMAXALB", LIEF::assembly::aarch64::OPCODE::LDUMAXALB)
  .value("LDUMAXALH", LIEF::assembly::aarch64::OPCODE::LDUMAXALH)
  .value("LDUMAXALW", LIEF::assembly::aarch64::OPCODE::LDUMAXALW)
  .value("LDUMAXALX", LIEF::assembly::aarch64::OPCODE::LDUMAXALX)
  .value("LDUMAXAW", LIEF::assembly::aarch64::OPCODE::LDUMAXAW)
  .value("LDUMAXAX", LIEF::assembly::aarch64::OPCODE::LDUMAXAX)
  .value("LDUMAXB", LIEF::assembly::aarch64::OPCODE::LDUMAXB)
  .value("LDUMAXH", LIEF::assembly::aarch64::OPCODE::LDUMAXH)
  .value("LDUMAXLB", LIEF::assembly::aarch64::OPCODE::LDUMAXLB)
  .value("LDUMAXLH", LIEF::assembly::aarch64::OPCODE::LDUMAXLH)
  .value("LDUMAXLW", LIEF::assembly::aarch64::OPCODE::LDUMAXLW)
  .value("LDUMAXLX", LIEF::assembly::aarch64::OPCODE::LDUMAXLX)
  .value("LDUMAXW", LIEF::assembly::aarch64::OPCODE::LDUMAXW)
  .value("LDUMAXX", LIEF::assembly::aarch64::OPCODE::LDUMAXX)
  .value("LDUMINAB", LIEF::assembly::aarch64::OPCODE::LDUMINAB)
  .value("LDUMINAH", LIEF::assembly::aarch64::OPCODE::LDUMINAH)
  .value("LDUMINALB", LIEF::assembly::aarch64::OPCODE::LDUMINALB)
  .value("LDUMINALH", LIEF::assembly::aarch64::OPCODE::LDUMINALH)
  .value("LDUMINALW", LIEF::assembly::aarch64::OPCODE::LDUMINALW)
  .value("LDUMINALX", LIEF::assembly::aarch64::OPCODE::LDUMINALX)
  .value("LDUMINAW", LIEF::assembly::aarch64::OPCODE::LDUMINAW)
  .value("LDUMINAX", LIEF::assembly::aarch64::OPCODE::LDUMINAX)
  .value("LDUMINB", LIEF::assembly::aarch64::OPCODE::LDUMINB)
  .value("LDUMINH", LIEF::assembly::aarch64::OPCODE::LDUMINH)
  .value("LDUMINLB", LIEF::assembly::aarch64::OPCODE::LDUMINLB)
  .value("LDUMINLH", LIEF::assembly::aarch64::OPCODE::LDUMINLH)
  .value("LDUMINLW", LIEF::assembly::aarch64::OPCODE::LDUMINLW)
  .value("LDUMINLX", LIEF::assembly::aarch64::OPCODE::LDUMINLX)
  .value("LDUMINW", LIEF::assembly::aarch64::OPCODE::LDUMINW)
  .value("LDUMINX", LIEF::assembly::aarch64::OPCODE::LDUMINX)
  .value("LDURBBi", LIEF::assembly::aarch64::OPCODE::LDURBBi)
  .value("LDURBi", LIEF::assembly::aarch64::OPCODE::LDURBi)
  .value("LDURDi", LIEF::assembly::aarch64::OPCODE::LDURDi)
  .value("LDURHHi", LIEF::assembly::aarch64::OPCODE::LDURHHi)
  .value("LDURHi", LIEF::assembly::aarch64::OPCODE::LDURHi)
  .value("LDURQi", LIEF::assembly::aarch64::OPCODE::LDURQi)
  .value("LDURSBWi", LIEF::assembly::aarch64::OPCODE::LDURSBWi)
  .value("LDURSBXi", LIEF::assembly::aarch64::OPCODE::LDURSBXi)
  .value("LDURSHWi", LIEF::assembly::aarch64::OPCODE::LDURSHWi)
  .value("LDURSHXi", LIEF::assembly::aarch64::OPCODE::LDURSHXi)
  .value("LDURSWi", LIEF::assembly::aarch64::OPCODE::LDURSWi)
  .value("LDURSi", LIEF::assembly::aarch64::OPCODE::LDURSi)
  .value("LDURWi", LIEF::assembly::aarch64::OPCODE::LDURWi)
  .value("LDURXi", LIEF::assembly::aarch64::OPCODE::LDURXi)
  .value("LDXPW", LIEF::assembly::aarch64::OPCODE::LDXPW)
  .value("LDXPX", LIEF::assembly::aarch64::OPCODE::LDXPX)
  .value("LDXRB", LIEF::assembly::aarch64::OPCODE::LDXRB)
  .value("LDXRH", LIEF::assembly::aarch64::OPCODE::LDXRH)
  .value("LDXRW", LIEF::assembly::aarch64::OPCODE::LDXRW)
  .value("LDXRX", LIEF::assembly::aarch64::OPCODE::LDXRX)
  .value("LSLR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::LSLR_ZPmZ_B)
  .value("LSLR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::LSLR_ZPmZ_D)
  .value("LSLR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::LSLR_ZPmZ_H)
  .value("LSLR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::LSLR_ZPmZ_S)
  .value("LSLVWr", LIEF::assembly::aarch64::OPCODE::LSLVWr)
  .value("LSLVXr", LIEF::assembly::aarch64::OPCODE::LSLVXr)
  .value("LSL_WIDE_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::LSL_WIDE_ZPmZ_B)
  .value("LSL_WIDE_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::LSL_WIDE_ZPmZ_H)
  .value("LSL_WIDE_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::LSL_WIDE_ZPmZ_S)
  .value("LSL_WIDE_ZZZ_B", LIEF::assembly::aarch64::OPCODE::LSL_WIDE_ZZZ_B)
  .value("LSL_WIDE_ZZZ_H", LIEF::assembly::aarch64::OPCODE::LSL_WIDE_ZZZ_H)
  .value("LSL_WIDE_ZZZ_S", LIEF::assembly::aarch64::OPCODE::LSL_WIDE_ZZZ_S)
  .value("LSL_ZPmI_B", LIEF::assembly::aarch64::OPCODE::LSL_ZPmI_B)
  .value("LSL_ZPmI_D", LIEF::assembly::aarch64::OPCODE::LSL_ZPmI_D)
  .value("LSL_ZPmI_H", LIEF::assembly::aarch64::OPCODE::LSL_ZPmI_H)
  .value("LSL_ZPmI_S", LIEF::assembly::aarch64::OPCODE::LSL_ZPmI_S)
  .value("LSL_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::LSL_ZPmZ_B)
  .value("LSL_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::LSL_ZPmZ_D)
  .value("LSL_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::LSL_ZPmZ_H)
  .value("LSL_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::LSL_ZPmZ_S)
  .value("LSL_ZZI_B", LIEF::assembly::aarch64::OPCODE::LSL_ZZI_B)
  .value("LSL_ZZI_D", LIEF::assembly::aarch64::OPCODE::LSL_ZZI_D)
  .value("LSL_ZZI_H", LIEF::assembly::aarch64::OPCODE::LSL_ZZI_H)
  .value("LSL_ZZI_S", LIEF::assembly::aarch64::OPCODE::LSL_ZZI_S)
  .value("LSRR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::LSRR_ZPmZ_B)
  .value("LSRR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::LSRR_ZPmZ_D)
  .value("LSRR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::LSRR_ZPmZ_H)
  .value("LSRR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::LSRR_ZPmZ_S)
  .value("LSRVWr", LIEF::assembly::aarch64::OPCODE::LSRVWr)
  .value("LSRVXr", LIEF::assembly::aarch64::OPCODE::LSRVXr)
  .value("LSR_WIDE_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::LSR_WIDE_ZPmZ_B)
  .value("LSR_WIDE_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::LSR_WIDE_ZPmZ_H)
  .value("LSR_WIDE_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::LSR_WIDE_ZPmZ_S)
  .value("LSR_WIDE_ZZZ_B", LIEF::assembly::aarch64::OPCODE::LSR_WIDE_ZZZ_B)
  .value("LSR_WIDE_ZZZ_H", LIEF::assembly::aarch64::OPCODE::LSR_WIDE_ZZZ_H)
  .value("LSR_WIDE_ZZZ_S", LIEF::assembly::aarch64::OPCODE::LSR_WIDE_ZZZ_S)
  .value("LSR_ZPmI_B", LIEF::assembly::aarch64::OPCODE::LSR_ZPmI_B)
  .value("LSR_ZPmI_D", LIEF::assembly::aarch64::OPCODE::LSR_ZPmI_D)
  .value("LSR_ZPmI_H", LIEF::assembly::aarch64::OPCODE::LSR_ZPmI_H)
  .value("LSR_ZPmI_S", LIEF::assembly::aarch64::OPCODE::LSR_ZPmI_S)
  .value("LSR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::LSR_ZPmZ_B)
  .value("LSR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::LSR_ZPmZ_D)
  .value("LSR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::LSR_ZPmZ_H)
  .value("LSR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::LSR_ZPmZ_S)
  .value("LSR_ZZI_B", LIEF::assembly::aarch64::OPCODE::LSR_ZZI_B)
  .value("LSR_ZZI_D", LIEF::assembly::aarch64::OPCODE::LSR_ZZI_D)
  .value("LSR_ZZI_H", LIEF::assembly::aarch64::OPCODE::LSR_ZZI_H)
  .value("LSR_ZZI_S", LIEF::assembly::aarch64::OPCODE::LSR_ZZI_S)
  .value("LUT2_B", LIEF::assembly::aarch64::OPCODE::LUT2_B)
  .value("LUT2_H", LIEF::assembly::aarch64::OPCODE::LUT2_H)
  .value("LUT4_B", LIEF::assembly::aarch64::OPCODE::LUT4_B)
  .value("LUT4_H", LIEF::assembly::aarch64::OPCODE::LUT4_H)
  .value("LUTI2_2ZTZI_B", LIEF::assembly::aarch64::OPCODE::LUTI2_2ZTZI_B)
  .value("LUTI2_2ZTZI_H", LIEF::assembly::aarch64::OPCODE::LUTI2_2ZTZI_H)
  .value("LUTI2_2ZTZI_S", LIEF::assembly::aarch64::OPCODE::LUTI2_2ZTZI_S)
  .value("LUTI2_4ZTZI_B", LIEF::assembly::aarch64::OPCODE::LUTI2_4ZTZI_B)
  .value("LUTI2_4ZTZI_H", LIEF::assembly::aarch64::OPCODE::LUTI2_4ZTZI_H)
  .value("LUTI2_4ZTZI_S", LIEF::assembly::aarch64::OPCODE::LUTI2_4ZTZI_S)
  .value("LUTI2_S_2ZTZI_B", LIEF::assembly::aarch64::OPCODE::LUTI2_S_2ZTZI_B)
  .value("LUTI2_S_2ZTZI_H", LIEF::assembly::aarch64::OPCODE::LUTI2_S_2ZTZI_H)
  .value("LUTI2_S_4ZTZI_B", LIEF::assembly::aarch64::OPCODE::LUTI2_S_4ZTZI_B)
  .value("LUTI2_S_4ZTZI_H", LIEF::assembly::aarch64::OPCODE::LUTI2_S_4ZTZI_H)
  .value("LUTI2_ZTZI_B", LIEF::assembly::aarch64::OPCODE::LUTI2_ZTZI_B)
  .value("LUTI2_ZTZI_H", LIEF::assembly::aarch64::OPCODE::LUTI2_ZTZI_H)
  .value("LUTI2_ZTZI_S", LIEF::assembly::aarch64::OPCODE::LUTI2_ZTZI_S)
  .value("LUTI2_ZZZI_B", LIEF::assembly::aarch64::OPCODE::LUTI2_ZZZI_B)
  .value("LUTI2_ZZZI_H", LIEF::assembly::aarch64::OPCODE::LUTI2_ZZZI_H)
  .value("LUTI4_2ZTZI_B", LIEF::assembly::aarch64::OPCODE::LUTI4_2ZTZI_B)
  .value("LUTI4_2ZTZI_H", LIEF::assembly::aarch64::OPCODE::LUTI4_2ZTZI_H)
  .value("LUTI4_2ZTZI_S", LIEF::assembly::aarch64::OPCODE::LUTI4_2ZTZI_S)
  .value("LUTI4_4ZTZI_H", LIEF::assembly::aarch64::OPCODE::LUTI4_4ZTZI_H)
  .value("LUTI4_4ZTZI_S", LIEF::assembly::aarch64::OPCODE::LUTI4_4ZTZI_S)
  .value("LUTI4_4ZZT2Z", LIEF::assembly::aarch64::OPCODE::LUTI4_4ZZT2Z)
  .value("LUTI4_S_2ZTZI_B", LIEF::assembly::aarch64::OPCODE::LUTI4_S_2ZTZI_B)
  .value("LUTI4_S_2ZTZI_H", LIEF::assembly::aarch64::OPCODE::LUTI4_S_2ZTZI_H)
  .value("LUTI4_S_4ZTZI_H", LIEF::assembly::aarch64::OPCODE::LUTI4_S_4ZTZI_H)
  .value("LUTI4_S_4ZZT2Z", LIEF::assembly::aarch64::OPCODE::LUTI4_S_4ZZT2Z)
  .value("LUTI4_Z2ZZI", LIEF::assembly::aarch64::OPCODE::LUTI4_Z2ZZI)
  .value("LUTI4_ZTZI_B", LIEF::assembly::aarch64::OPCODE::LUTI4_ZTZI_B)
  .value("LUTI4_ZTZI_H", LIEF::assembly::aarch64::OPCODE::LUTI4_ZTZI_H)
  .value("LUTI4_ZTZI_S", LIEF::assembly::aarch64::OPCODE::LUTI4_ZTZI_S)
  .value("LUTI4_ZZZI_B", LIEF::assembly::aarch64::OPCODE::LUTI4_ZZZI_B)
  .value("LUTI4_ZZZI_H", LIEF::assembly::aarch64::OPCODE::LUTI4_ZZZI_H)
  .value("MADDPT", LIEF::assembly::aarch64::OPCODE::MADDPT)
  .value("MADDWrrr", LIEF::assembly::aarch64::OPCODE::MADDWrrr)
  .value("MADDXrrr", LIEF::assembly::aarch64::OPCODE::MADDXrrr)
  .value("MAD_CPA", LIEF::assembly::aarch64::OPCODE::MAD_CPA)
  .value("MAD_ZPmZZ_B", LIEF::assembly::aarch64::OPCODE::MAD_ZPmZZ_B)
  .value("MAD_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::MAD_ZPmZZ_D)
  .value("MAD_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::MAD_ZPmZZ_H)
  .value("MAD_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::MAD_ZPmZZ_S)
  .value("MATCH_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::MATCH_PPzZZ_B)
  .value("MATCH_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::MATCH_PPzZZ_H)
  .value("MLA_CPA", LIEF::assembly::aarch64::OPCODE::MLA_CPA)
  .value("MLA_ZPmZZ_B", LIEF::assembly::aarch64::OPCODE::MLA_ZPmZZ_B)
  .value("MLA_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::MLA_ZPmZZ_D)
  .value("MLA_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::MLA_ZPmZZ_H)
  .value("MLA_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::MLA_ZPmZZ_S)
  .value("MLA_ZZZI_D", LIEF::assembly::aarch64::OPCODE::MLA_ZZZI_D)
  .value("MLA_ZZZI_H", LIEF::assembly::aarch64::OPCODE::MLA_ZZZI_H)
  .value("MLA_ZZZI_S", LIEF::assembly::aarch64::OPCODE::MLA_ZZZI_S)
  .value("MLAv16i8", LIEF::assembly::aarch64::OPCODE::MLAv16i8)
  .value("MLAv2i32", LIEF::assembly::aarch64::OPCODE::MLAv2i32)
  .value("MLAv2i32_indexed", LIEF::assembly::aarch64::OPCODE::MLAv2i32_indexed)
  .value("MLAv4i16", LIEF::assembly::aarch64::OPCODE::MLAv4i16)
  .value("MLAv4i16_indexed", LIEF::assembly::aarch64::OPCODE::MLAv4i16_indexed)
  .value("MLAv4i32", LIEF::assembly::aarch64::OPCODE::MLAv4i32)
  .value("MLAv4i32_indexed", LIEF::assembly::aarch64::OPCODE::MLAv4i32_indexed)
  .value("MLAv8i16", LIEF::assembly::aarch64::OPCODE::MLAv8i16)
  .value("MLAv8i16_indexed", LIEF::assembly::aarch64::OPCODE::MLAv8i16_indexed)
  .value("MLAv8i8", LIEF::assembly::aarch64::OPCODE::MLAv8i8)
  .value("MLS_ZPmZZ_B", LIEF::assembly::aarch64::OPCODE::MLS_ZPmZZ_B)
  .value("MLS_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::MLS_ZPmZZ_D)
  .value("MLS_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::MLS_ZPmZZ_H)
  .value("MLS_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::MLS_ZPmZZ_S)
  .value("MLS_ZZZI_D", LIEF::assembly::aarch64::OPCODE::MLS_ZZZI_D)
  .value("MLS_ZZZI_H", LIEF::assembly::aarch64::OPCODE::MLS_ZZZI_H)
  .value("MLS_ZZZI_S", LIEF::assembly::aarch64::OPCODE::MLS_ZZZI_S)
  .value("MLSv16i8", LIEF::assembly::aarch64::OPCODE::MLSv16i8)
  .value("MLSv2i32", LIEF::assembly::aarch64::OPCODE::MLSv2i32)
  .value("MLSv2i32_indexed", LIEF::assembly::aarch64::OPCODE::MLSv2i32_indexed)
  .value("MLSv4i16", LIEF::assembly::aarch64::OPCODE::MLSv4i16)
  .value("MLSv4i16_indexed", LIEF::assembly::aarch64::OPCODE::MLSv4i16_indexed)
  .value("MLSv4i32", LIEF::assembly::aarch64::OPCODE::MLSv4i32)
  .value("MLSv4i32_indexed", LIEF::assembly::aarch64::OPCODE::MLSv4i32_indexed)
  .value("MLSv8i16", LIEF::assembly::aarch64::OPCODE::MLSv8i16)
  .value("MLSv8i16_indexed", LIEF::assembly::aarch64::OPCODE::MLSv8i16_indexed)
  .value("MLSv8i8", LIEF::assembly::aarch64::OPCODE::MLSv8i8)
  .value("MOPSSETGE", LIEF::assembly::aarch64::OPCODE::MOPSSETGE)
  .value("MOPSSETGEN", LIEF::assembly::aarch64::OPCODE::MOPSSETGEN)
  .value("MOPSSETGET", LIEF::assembly::aarch64::OPCODE::MOPSSETGET)
  .value("MOPSSETGETN", LIEF::assembly::aarch64::OPCODE::MOPSSETGETN)
  .value("MOVAZ_2ZMI_H_B", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_H_B)
  .value("MOVAZ_2ZMI_H_D", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_H_D)
  .value("MOVAZ_2ZMI_H_H", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_H_H)
  .value("MOVAZ_2ZMI_H_S", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_H_S)
  .value("MOVAZ_2ZMI_V_B", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_V_B)
  .value("MOVAZ_2ZMI_V_D", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_V_D)
  .value("MOVAZ_2ZMI_V_H", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_V_H)
  .value("MOVAZ_2ZMI_V_S", LIEF::assembly::aarch64::OPCODE::MOVAZ_2ZMI_V_S)
  .value("MOVAZ_4ZMI_H_B", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_H_B)
  .value("MOVAZ_4ZMI_H_D", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_H_D)
  .value("MOVAZ_4ZMI_H_H", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_H_H)
  .value("MOVAZ_4ZMI_H_S", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_H_S)
  .value("MOVAZ_4ZMI_V_B", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_V_B)
  .value("MOVAZ_4ZMI_V_D", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_V_D)
  .value("MOVAZ_4ZMI_V_H", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_V_H)
  .value("MOVAZ_4ZMI_V_S", LIEF::assembly::aarch64::OPCODE::MOVAZ_4ZMI_V_S)
  .value("MOVAZ_VG2_2ZMXI", LIEF::assembly::aarch64::OPCODE::MOVAZ_VG2_2ZMXI)
  .value("MOVAZ_VG4_4ZMXI", LIEF::assembly::aarch64::OPCODE::MOVAZ_VG4_4ZMXI)
  .value("MOVAZ_ZMI_H_B", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_H_B)
  .value("MOVAZ_ZMI_H_D", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_H_D)
  .value("MOVAZ_ZMI_H_H", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_H_H)
  .value("MOVAZ_ZMI_H_Q", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_H_Q)
  .value("MOVAZ_ZMI_H_S", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_H_S)
  .value("MOVAZ_ZMI_V_B", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_V_B)
  .value("MOVAZ_ZMI_V_D", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_V_D)
  .value("MOVAZ_ZMI_V_H", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_V_H)
  .value("MOVAZ_ZMI_V_Q", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_V_Q)
  .value("MOVAZ_ZMI_V_S", LIEF::assembly::aarch64::OPCODE::MOVAZ_ZMI_V_S)
  .value("MOVA_2ZMXI_H_B", LIEF::assembly::aarch64::OPCODE::MOVA_2ZMXI_H_B)
  .value("MOVA_2ZMXI_H_D", LIEF::assembly::aarch64::OPCODE::MOVA_2ZMXI_H_D)
  .value("MOVA_2ZMXI_H_H", LIEF::assembly::aarch64::OPCODE::MOVA_2ZMXI_H_H)
  .value("MOVA_2ZMXI_H_S", LIEF::assembly::aarch64::OPCODE::MOVA_2ZMXI_H_S)
  .value("MOVA_2ZMXI_V_B", LIEF::assembly::aarch64::OPCODE::MOVA_2ZMXI_V_B)
  .value("MOVA_2ZMXI_V_D", LIEF::assembly::aarch64::OPCODE::MOVA_2ZMXI_V_D)
  .value("MOVA_2ZMXI_V_H", LIEF::assembly::aarch64::OPCODE::MOVA_2ZMXI_V_H)
  .value("MOVA_2ZMXI_V_S", LIEF::assembly::aarch64::OPCODE::MOVA_2ZMXI_V_S)
  .value("MOVA_4ZMXI_H_B", LIEF::assembly::aarch64::OPCODE::MOVA_4ZMXI_H_B)
  .value("MOVA_4ZMXI_H_D", LIEF::assembly::aarch64::OPCODE::MOVA_4ZMXI_H_D)
  .value("MOVA_4ZMXI_H_H", LIEF::assembly::aarch64::OPCODE::MOVA_4ZMXI_H_H)
  .value("MOVA_4ZMXI_H_S", LIEF::assembly::aarch64::OPCODE::MOVA_4ZMXI_H_S)
  .value("MOVA_4ZMXI_V_B", LIEF::assembly::aarch64::OPCODE::MOVA_4ZMXI_V_B)
  .value("MOVA_4ZMXI_V_D", LIEF::assembly::aarch64::OPCODE::MOVA_4ZMXI_V_D)
  .value("MOVA_4ZMXI_V_H", LIEF::assembly::aarch64::OPCODE::MOVA_4ZMXI_V_H)
  .value("MOVA_4ZMXI_V_S", LIEF::assembly::aarch64::OPCODE::MOVA_4ZMXI_V_S)
  .value("MOVA_MXI2Z_H_B", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_H_B)
  .value("MOVA_MXI2Z_H_D", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_H_D)
  .value("MOVA_MXI2Z_H_H", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_H_H)
  .value("MOVA_MXI2Z_H_S", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_H_S)
  .value("MOVA_MXI2Z_V_B", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_V_B)
  .value("MOVA_MXI2Z_V_D", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_V_D)
  .value("MOVA_MXI2Z_V_H", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_V_H)
  .value("MOVA_MXI2Z_V_S", LIEF::assembly::aarch64::OPCODE::MOVA_MXI2Z_V_S)
  .value("MOVA_MXI4Z_H_B", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_H_B)
  .value("MOVA_MXI4Z_H_D", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_H_D)
  .value("MOVA_MXI4Z_H_H", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_H_H)
  .value("MOVA_MXI4Z_H_S", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_H_S)
  .value("MOVA_MXI4Z_V_B", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_V_B)
  .value("MOVA_MXI4Z_V_D", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_V_D)
  .value("MOVA_MXI4Z_V_H", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_V_H)
  .value("MOVA_MXI4Z_V_S", LIEF::assembly::aarch64::OPCODE::MOVA_MXI4Z_V_S)
  .value("MOVA_VG2_2ZMXI", LIEF::assembly::aarch64::OPCODE::MOVA_VG2_2ZMXI)
  .value("MOVA_VG2_MXI2Z", LIEF::assembly::aarch64::OPCODE::MOVA_VG2_MXI2Z)
  .value("MOVA_VG4_4ZMXI", LIEF::assembly::aarch64::OPCODE::MOVA_VG4_4ZMXI)
  .value("MOVA_VG4_MXI4Z", LIEF::assembly::aarch64::OPCODE::MOVA_VG4_MXI4Z)
  .value("MOVID", LIEF::assembly::aarch64::OPCODE::MOVID)
  .value("MOVIv16b_ns", LIEF::assembly::aarch64::OPCODE::MOVIv16b_ns)
  .value("MOVIv2d_ns", LIEF::assembly::aarch64::OPCODE::MOVIv2d_ns)
  .value("MOVIv2i32", LIEF::assembly::aarch64::OPCODE::MOVIv2i32)
  .value("MOVIv2s_msl", LIEF::assembly::aarch64::OPCODE::MOVIv2s_msl)
  .value("MOVIv4i16", LIEF::assembly::aarch64::OPCODE::MOVIv4i16)
  .value("MOVIv4i32", LIEF::assembly::aarch64::OPCODE::MOVIv4i32)
  .value("MOVIv4s_msl", LIEF::assembly::aarch64::OPCODE::MOVIv4s_msl)
  .value("MOVIv8b_ns", LIEF::assembly::aarch64::OPCODE::MOVIv8b_ns)
  .value("MOVIv8i16", LIEF::assembly::aarch64::OPCODE::MOVIv8i16)
  .value("MOVKWi", LIEF::assembly::aarch64::OPCODE::MOVKWi)
  .value("MOVKXi", LIEF::assembly::aarch64::OPCODE::MOVKXi)
  .value("MOVNWi", LIEF::assembly::aarch64::OPCODE::MOVNWi)
  .value("MOVNXi", LIEF::assembly::aarch64::OPCODE::MOVNXi)
  .value("MOVPRFX_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::MOVPRFX_ZPmZ_B)
  .value("MOVPRFX_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::MOVPRFX_ZPmZ_D)
  .value("MOVPRFX_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::MOVPRFX_ZPmZ_H)
  .value("MOVPRFX_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::MOVPRFX_ZPmZ_S)
  .value("MOVPRFX_ZPzZ_B", LIEF::assembly::aarch64::OPCODE::MOVPRFX_ZPzZ_B)
  .value("MOVPRFX_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::MOVPRFX_ZPzZ_D);
  opcodes.value("MOVPRFX_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::MOVPRFX_ZPzZ_H)
  .value("MOVPRFX_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::MOVPRFX_ZPzZ_S)
  .value("MOVPRFX_ZZ", LIEF::assembly::aarch64::OPCODE::MOVPRFX_ZZ)
  .value("MOVT_TIX", LIEF::assembly::aarch64::OPCODE::MOVT_TIX)
  .value("MOVT_TIZ", LIEF::assembly::aarch64::OPCODE::MOVT_TIZ)
  .value("MOVT_XTI", LIEF::assembly::aarch64::OPCODE::MOVT_XTI)
  .value("MOVZWi", LIEF::assembly::aarch64::OPCODE::MOVZWi)
  .value("MOVZXi", LIEF::assembly::aarch64::OPCODE::MOVZXi)
  .value("MRRS", LIEF::assembly::aarch64::OPCODE::MRRS)
  .value("MRS", LIEF::assembly::aarch64::OPCODE::MRS)
  .value("MSB_ZPmZZ_B", LIEF::assembly::aarch64::OPCODE::MSB_ZPmZZ_B)
  .value("MSB_ZPmZZ_D", LIEF::assembly::aarch64::OPCODE::MSB_ZPmZZ_D)
  .value("MSB_ZPmZZ_H", LIEF::assembly::aarch64::OPCODE::MSB_ZPmZZ_H)
  .value("MSB_ZPmZZ_S", LIEF::assembly::aarch64::OPCODE::MSB_ZPmZZ_S)
  .value("MSR", LIEF::assembly::aarch64::OPCODE::MSR)
  .value("MSRR", LIEF::assembly::aarch64::OPCODE::MSRR)
  .value("MSRpstateImm1", LIEF::assembly::aarch64::OPCODE::MSRpstateImm1)
  .value("MSRpstateImm4", LIEF::assembly::aarch64::OPCODE::MSRpstateImm4)
  .value("MSRpstatesvcrImm1", LIEF::assembly::aarch64::OPCODE::MSRpstatesvcrImm1)
  .value("MSUBPT", LIEF::assembly::aarch64::OPCODE::MSUBPT)
  .value("MSUBWrrr", LIEF::assembly::aarch64::OPCODE::MSUBWrrr)
  .value("MSUBXrrr", LIEF::assembly::aarch64::OPCODE::MSUBXrrr)
  .value("MUL_ZI_B", LIEF::assembly::aarch64::OPCODE::MUL_ZI_B)
  .value("MUL_ZI_D", LIEF::assembly::aarch64::OPCODE::MUL_ZI_D)
  .value("MUL_ZI_H", LIEF::assembly::aarch64::OPCODE::MUL_ZI_H)
  .value("MUL_ZI_S", LIEF::assembly::aarch64::OPCODE::MUL_ZI_S)
  .value("MUL_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::MUL_ZPmZ_B)
  .value("MUL_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::MUL_ZPmZ_D)
  .value("MUL_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::MUL_ZPmZ_H)
  .value("MUL_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::MUL_ZPmZ_S)
  .value("MUL_ZZZI_D", LIEF::assembly::aarch64::OPCODE::MUL_ZZZI_D)
  .value("MUL_ZZZI_H", LIEF::assembly::aarch64::OPCODE::MUL_ZZZI_H)
  .value("MUL_ZZZI_S", LIEF::assembly::aarch64::OPCODE::MUL_ZZZI_S)
  .value("MUL_ZZZ_B", LIEF::assembly::aarch64::OPCODE::MUL_ZZZ_B)
  .value("MUL_ZZZ_D", LIEF::assembly::aarch64::OPCODE::MUL_ZZZ_D)
  .value("MUL_ZZZ_H", LIEF::assembly::aarch64::OPCODE::MUL_ZZZ_H)
  .value("MUL_ZZZ_S", LIEF::assembly::aarch64::OPCODE::MUL_ZZZ_S)
  .value("MULv16i8", LIEF::assembly::aarch64::OPCODE::MULv16i8)
  .value("MULv2i32", LIEF::assembly::aarch64::OPCODE::MULv2i32)
  .value("MULv2i32_indexed", LIEF::assembly::aarch64::OPCODE::MULv2i32_indexed)
  .value("MULv4i16", LIEF::assembly::aarch64::OPCODE::MULv4i16)
  .value("MULv4i16_indexed", LIEF::assembly::aarch64::OPCODE::MULv4i16_indexed)
  .value("MULv4i32", LIEF::assembly::aarch64::OPCODE::MULv4i32)
  .value("MULv4i32_indexed", LIEF::assembly::aarch64::OPCODE::MULv4i32_indexed)
  .value("MULv8i16", LIEF::assembly::aarch64::OPCODE::MULv8i16)
  .value("MULv8i16_indexed", LIEF::assembly::aarch64::OPCODE::MULv8i16_indexed)
  .value("MULv8i8", LIEF::assembly::aarch64::OPCODE::MULv8i8)
  .value("MVNIv2i32", LIEF::assembly::aarch64::OPCODE::MVNIv2i32)
  .value("MVNIv2s_msl", LIEF::assembly::aarch64::OPCODE::MVNIv2s_msl)
  .value("MVNIv4i16", LIEF::assembly::aarch64::OPCODE::MVNIv4i16)
  .value("MVNIv4i32", LIEF::assembly::aarch64::OPCODE::MVNIv4i32)
  .value("MVNIv4s_msl", LIEF::assembly::aarch64::OPCODE::MVNIv4s_msl)
  .value("MVNIv8i16", LIEF::assembly::aarch64::OPCODE::MVNIv8i16)
  .value("NANDS_PPzPP", LIEF::assembly::aarch64::OPCODE::NANDS_PPzPP)
  .value("NAND_PPzPP", LIEF::assembly::aarch64::OPCODE::NAND_PPzPP)
  .value("NBSL_ZZZZ", LIEF::assembly::aarch64::OPCODE::NBSL_ZZZZ)
  .value("NEG_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::NEG_ZPmZ_B)
  .value("NEG_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::NEG_ZPmZ_D)
  .value("NEG_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::NEG_ZPmZ_H)
  .value("NEG_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::NEG_ZPmZ_S)
  .value("NEG_ZPzZ_B", LIEF::assembly::aarch64::OPCODE::NEG_ZPzZ_B)
  .value("NEG_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::NEG_ZPzZ_D)
  .value("NEG_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::NEG_ZPzZ_H)
  .value("NEG_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::NEG_ZPzZ_S)
  .value("NEGv16i8", LIEF::assembly::aarch64::OPCODE::NEGv16i8)
  .value("NEGv1i64", LIEF::assembly::aarch64::OPCODE::NEGv1i64)
  .value("NEGv2i32", LIEF::assembly::aarch64::OPCODE::NEGv2i32)
  .value("NEGv2i64", LIEF::assembly::aarch64::OPCODE::NEGv2i64)
  .value("NEGv4i16", LIEF::assembly::aarch64::OPCODE::NEGv4i16)
  .value("NEGv4i32", LIEF::assembly::aarch64::OPCODE::NEGv4i32)
  .value("NEGv8i16", LIEF::assembly::aarch64::OPCODE::NEGv8i16)
  .value("NEGv8i8", LIEF::assembly::aarch64::OPCODE::NEGv8i8)
  .value("NMATCH_PPzZZ_B", LIEF::assembly::aarch64::OPCODE::NMATCH_PPzZZ_B)
  .value("NMATCH_PPzZZ_H", LIEF::assembly::aarch64::OPCODE::NMATCH_PPzZZ_H)
  .value("NORS_PPzPP", LIEF::assembly::aarch64::OPCODE::NORS_PPzPP)
  .value("NOR_PPzPP", LIEF::assembly::aarch64::OPCODE::NOR_PPzPP)
  .value("NOT_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::NOT_ZPmZ_B)
  .value("NOT_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::NOT_ZPmZ_D)
  .value("NOT_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::NOT_ZPmZ_H)
  .value("NOT_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::NOT_ZPmZ_S)
  .value("NOT_ZPzZ_B", LIEF::assembly::aarch64::OPCODE::NOT_ZPzZ_B)
  .value("NOT_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::NOT_ZPzZ_D)
  .value("NOT_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::NOT_ZPzZ_H)
  .value("NOT_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::NOT_ZPzZ_S)
  .value("NOTv16i8", LIEF::assembly::aarch64::OPCODE::NOTv16i8)
  .value("NOTv8i8", LIEF::assembly::aarch64::OPCODE::NOTv8i8)
  .value("ORNS_PPzPP", LIEF::assembly::aarch64::OPCODE::ORNS_PPzPP)
  .value("ORNWrs", LIEF::assembly::aarch64::OPCODE::ORNWrs)
  .value("ORNXrs", LIEF::assembly::aarch64::OPCODE::ORNXrs)
  .value("ORN_PPzPP", LIEF::assembly::aarch64::OPCODE::ORN_PPzPP)
  .value("ORNv16i8", LIEF::assembly::aarch64::OPCODE::ORNv16i8)
  .value("ORNv8i8", LIEF::assembly::aarch64::OPCODE::ORNv8i8)
  .value("ORQV_VPZ_B", LIEF::assembly::aarch64::OPCODE::ORQV_VPZ_B)
  .value("ORQV_VPZ_D", LIEF::assembly::aarch64::OPCODE::ORQV_VPZ_D)
  .value("ORQV_VPZ_H", LIEF::assembly::aarch64::OPCODE::ORQV_VPZ_H)
  .value("ORQV_VPZ_S", LIEF::assembly::aarch64::OPCODE::ORQV_VPZ_S)
  .value("ORRS_PPzPP", LIEF::assembly::aarch64::OPCODE::ORRS_PPzPP)
  .value("ORRWri", LIEF::assembly::aarch64::OPCODE::ORRWri)
  .value("ORRWrs", LIEF::assembly::aarch64::OPCODE::ORRWrs)
  .value("ORRXri", LIEF::assembly::aarch64::OPCODE::ORRXri)
  .value("ORRXrs", LIEF::assembly::aarch64::OPCODE::ORRXrs)
  .value("ORR_PPzPP", LIEF::assembly::aarch64::OPCODE::ORR_PPzPP)
  .value("ORR_ZI", LIEF::assembly::aarch64::OPCODE::ORR_ZI)
  .value("ORR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::ORR_ZPmZ_B)
  .value("ORR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::ORR_ZPmZ_D)
  .value("ORR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::ORR_ZPmZ_H)
  .value("ORR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::ORR_ZPmZ_S)
  .value("ORR_ZZZ", LIEF::assembly::aarch64::OPCODE::ORR_ZZZ)
  .value("ORRv16i8", LIEF::assembly::aarch64::OPCODE::ORRv16i8)
  .value("ORRv2i32", LIEF::assembly::aarch64::OPCODE::ORRv2i32)
  .value("ORRv4i16", LIEF::assembly::aarch64::OPCODE::ORRv4i16)
  .value("ORRv4i32", LIEF::assembly::aarch64::OPCODE::ORRv4i32)
  .value("ORRv8i16", LIEF::assembly::aarch64::OPCODE::ORRv8i16)
  .value("ORRv8i8", LIEF::assembly::aarch64::OPCODE::ORRv8i8)
  .value("ORV_VPZ_B", LIEF::assembly::aarch64::OPCODE::ORV_VPZ_B)
  .value("ORV_VPZ_D", LIEF::assembly::aarch64::OPCODE::ORV_VPZ_D)
  .value("ORV_VPZ_H", LIEF::assembly::aarch64::OPCODE::ORV_VPZ_H)
  .value("ORV_VPZ_S", LIEF::assembly::aarch64::OPCODE::ORV_VPZ_S)
  .value("PACDA", LIEF::assembly::aarch64::OPCODE::PACDA)
  .value("PACDB", LIEF::assembly::aarch64::OPCODE::PACDB)
  .value("PACDZA", LIEF::assembly::aarch64::OPCODE::PACDZA)
  .value("PACDZB", LIEF::assembly::aarch64::OPCODE::PACDZB)
  .value("PACGA", LIEF::assembly::aarch64::OPCODE::PACGA)
  .value("PACIA", LIEF::assembly::aarch64::OPCODE::PACIA)
  .value("PACIA1716", LIEF::assembly::aarch64::OPCODE::PACIA1716)
  .value("PACIA171615", LIEF::assembly::aarch64::OPCODE::PACIA171615)
  .value("PACIASP", LIEF::assembly::aarch64::OPCODE::PACIASP)
  .value("PACIASPPC", LIEF::assembly::aarch64::OPCODE::PACIASPPC)
  .value("PACIAZ", LIEF::assembly::aarch64::OPCODE::PACIAZ)
  .value("PACIB", LIEF::assembly::aarch64::OPCODE::PACIB)
  .value("PACIB1716", LIEF::assembly::aarch64::OPCODE::PACIB1716)
  .value("PACIB171615", LIEF::assembly::aarch64::OPCODE::PACIB171615)
  .value("PACIBSP", LIEF::assembly::aarch64::OPCODE::PACIBSP)
  .value("PACIBSPPC", LIEF::assembly::aarch64::OPCODE::PACIBSPPC)
  .value("PACIBZ", LIEF::assembly::aarch64::OPCODE::PACIBZ)
  .value("PACIZA", LIEF::assembly::aarch64::OPCODE::PACIZA)
  .value("PACIZB", LIEF::assembly::aarch64::OPCODE::PACIZB)
  .value("PACM", LIEF::assembly::aarch64::OPCODE::PACM)
  .value("PACNBIASPPC", LIEF::assembly::aarch64::OPCODE::PACNBIASPPC)
  .value("PACNBIBSPPC", LIEF::assembly::aarch64::OPCODE::PACNBIBSPPC)
  .value("PEXT_2PCI_B", LIEF::assembly::aarch64::OPCODE::PEXT_2PCI_B)
  .value("PEXT_2PCI_D", LIEF::assembly::aarch64::OPCODE::PEXT_2PCI_D)
  .value("PEXT_2PCI_H", LIEF::assembly::aarch64::OPCODE::PEXT_2PCI_H)
  .value("PEXT_2PCI_S", LIEF::assembly::aarch64::OPCODE::PEXT_2PCI_S)
  .value("PEXT_PCI_B", LIEF::assembly::aarch64::OPCODE::PEXT_PCI_B)
  .value("PEXT_PCI_D", LIEF::assembly::aarch64::OPCODE::PEXT_PCI_D)
  .value("PEXT_PCI_H", LIEF::assembly::aarch64::OPCODE::PEXT_PCI_H)
  .value("PEXT_PCI_S", LIEF::assembly::aarch64::OPCODE::PEXT_PCI_S)
  .value("PFALSE", LIEF::assembly::aarch64::OPCODE::PFALSE)
  .value("PFIRST_B", LIEF::assembly::aarch64::OPCODE::PFIRST_B)
  .value("PMLAL_2ZZZ_Q", LIEF::assembly::aarch64::OPCODE::PMLAL_2ZZZ_Q)
  .value("PMOV_PZI_B", LIEF::assembly::aarch64::OPCODE::PMOV_PZI_B)
  .value("PMOV_PZI_D", LIEF::assembly::aarch64::OPCODE::PMOV_PZI_D)
  .value("PMOV_PZI_H", LIEF::assembly::aarch64::OPCODE::PMOV_PZI_H)
  .value("PMOV_PZI_S", LIEF::assembly::aarch64::OPCODE::PMOV_PZI_S)
  .value("PMOV_ZIP_B", LIEF::assembly::aarch64::OPCODE::PMOV_ZIP_B)
  .value("PMOV_ZIP_D", LIEF::assembly::aarch64::OPCODE::PMOV_ZIP_D)
  .value("PMOV_ZIP_H", LIEF::assembly::aarch64::OPCODE::PMOV_ZIP_H)
  .value("PMOV_ZIP_S", LIEF::assembly::aarch64::OPCODE::PMOV_ZIP_S)
  .value("PMULLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::PMULLB_ZZZ_D)
  .value("PMULLB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::PMULLB_ZZZ_H)
  .value("PMULLB_ZZZ_Q", LIEF::assembly::aarch64::OPCODE::PMULLB_ZZZ_Q)
  .value("PMULLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::PMULLT_ZZZ_D)
  .value("PMULLT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::PMULLT_ZZZ_H)
  .value("PMULLT_ZZZ_Q", LIEF::assembly::aarch64::OPCODE::PMULLT_ZZZ_Q)
  .value("PMULL_2ZZZ_Q", LIEF::assembly::aarch64::OPCODE::PMULL_2ZZZ_Q)
  .value("PMULLv16i8", LIEF::assembly::aarch64::OPCODE::PMULLv16i8)
  .value("PMULLv1i64", LIEF::assembly::aarch64::OPCODE::PMULLv1i64)
  .value("PMULLv2i64", LIEF::assembly::aarch64::OPCODE::PMULLv2i64)
  .value("PMULLv8i8", LIEF::assembly::aarch64::OPCODE::PMULLv8i8)
  .value("PMUL_ZZZ_B", LIEF::assembly::aarch64::OPCODE::PMUL_ZZZ_B)
  .value("PMULv16i8", LIEF::assembly::aarch64::OPCODE::PMULv16i8)
  .value("PMULv8i8", LIEF::assembly::aarch64::OPCODE::PMULv8i8)
  .value("PNEXT_B", LIEF::assembly::aarch64::OPCODE::PNEXT_B)
  .value("PNEXT_D", LIEF::assembly::aarch64::OPCODE::PNEXT_D)
  .value("PNEXT_H", LIEF::assembly::aarch64::OPCODE::PNEXT_H)
  .value("PNEXT_S", LIEF::assembly::aarch64::OPCODE::PNEXT_S)
  .value("PRFB_D_PZI", LIEF::assembly::aarch64::OPCODE::PRFB_D_PZI)
  .value("PRFB_D_SCALED", LIEF::assembly::aarch64::OPCODE::PRFB_D_SCALED)
  .value("PRFB_D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFB_D_SXTW_SCALED)
  .value("PRFB_D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFB_D_UXTW_SCALED)
  .value("PRFB_PRI", LIEF::assembly::aarch64::OPCODE::PRFB_PRI)
  .value("PRFB_PRR", LIEF::assembly::aarch64::OPCODE::PRFB_PRR)
  .value("PRFB_S_PZI", LIEF::assembly::aarch64::OPCODE::PRFB_S_PZI)
  .value("PRFB_S_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFB_S_SXTW_SCALED)
  .value("PRFB_S_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFB_S_UXTW_SCALED)
  .value("PRFD_D_PZI", LIEF::assembly::aarch64::OPCODE::PRFD_D_PZI)
  .value("PRFD_D_SCALED", LIEF::assembly::aarch64::OPCODE::PRFD_D_SCALED)
  .value("PRFD_D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFD_D_SXTW_SCALED)
  .value("PRFD_D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFD_D_UXTW_SCALED)
  .value("PRFD_PRI", LIEF::assembly::aarch64::OPCODE::PRFD_PRI)
  .value("PRFD_PRR", LIEF::assembly::aarch64::OPCODE::PRFD_PRR)
  .value("PRFD_S_PZI", LIEF::assembly::aarch64::OPCODE::PRFD_S_PZI)
  .value("PRFD_S_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFD_S_SXTW_SCALED)
  .value("PRFD_S_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFD_S_UXTW_SCALED)
  .value("PRFH_D_PZI", LIEF::assembly::aarch64::OPCODE::PRFH_D_PZI)
  .value("PRFH_D_SCALED", LIEF::assembly::aarch64::OPCODE::PRFH_D_SCALED)
  .value("PRFH_D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFH_D_SXTW_SCALED)
  .value("PRFH_D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFH_D_UXTW_SCALED)
  .value("PRFH_PRI", LIEF::assembly::aarch64::OPCODE::PRFH_PRI)
  .value("PRFH_PRR", LIEF::assembly::aarch64::OPCODE::PRFH_PRR)
  .value("PRFH_S_PZI", LIEF::assembly::aarch64::OPCODE::PRFH_S_PZI)
  .value("PRFH_S_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFH_S_SXTW_SCALED)
  .value("PRFH_S_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFH_S_UXTW_SCALED)
  .value("PRFMl", LIEF::assembly::aarch64::OPCODE::PRFMl)
  .value("PRFMroW", LIEF::assembly::aarch64::OPCODE::PRFMroW)
  .value("PRFMroX", LIEF::assembly::aarch64::OPCODE::PRFMroX)
  .value("PRFMui", LIEF::assembly::aarch64::OPCODE::PRFMui)
  .value("PRFUMi", LIEF::assembly::aarch64::OPCODE::PRFUMi)
  .value("PRFW_D_PZI", LIEF::assembly::aarch64::OPCODE::PRFW_D_PZI)
  .value("PRFW_D_SCALED", LIEF::assembly::aarch64::OPCODE::PRFW_D_SCALED)
  .value("PRFW_D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFW_D_SXTW_SCALED)
  .value("PRFW_D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFW_D_UXTW_SCALED)
  .value("PRFW_PRI", LIEF::assembly::aarch64::OPCODE::PRFW_PRI)
  .value("PRFW_PRR", LIEF::assembly::aarch64::OPCODE::PRFW_PRR)
  .value("PRFW_S_PZI", LIEF::assembly::aarch64::OPCODE::PRFW_S_PZI)
  .value("PRFW_S_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFW_S_SXTW_SCALED)
  .value("PRFW_S_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::PRFW_S_UXTW_SCALED)
  .value("PSEL_PPPRI_B", LIEF::assembly::aarch64::OPCODE::PSEL_PPPRI_B)
  .value("PSEL_PPPRI_D", LIEF::assembly::aarch64::OPCODE::PSEL_PPPRI_D)
  .value("PSEL_PPPRI_H", LIEF::assembly::aarch64::OPCODE::PSEL_PPPRI_H)
  .value("PSEL_PPPRI_S", LIEF::assembly::aarch64::OPCODE::PSEL_PPPRI_S)
  .value("PTEST_PP", LIEF::assembly::aarch64::OPCODE::PTEST_PP)
  .value("PTRUES_B", LIEF::assembly::aarch64::OPCODE::PTRUES_B)
  .value("PTRUES_D", LIEF::assembly::aarch64::OPCODE::PTRUES_D)
  .value("PTRUES_H", LIEF::assembly::aarch64::OPCODE::PTRUES_H)
  .value("PTRUES_S", LIEF::assembly::aarch64::OPCODE::PTRUES_S)
  .value("PTRUE_B", LIEF::assembly::aarch64::OPCODE::PTRUE_B)
  .value("PTRUE_C_B", LIEF::assembly::aarch64::OPCODE::PTRUE_C_B)
  .value("PTRUE_C_D", LIEF::assembly::aarch64::OPCODE::PTRUE_C_D)
  .value("PTRUE_C_H", LIEF::assembly::aarch64::OPCODE::PTRUE_C_H)
  .value("PTRUE_C_S", LIEF::assembly::aarch64::OPCODE::PTRUE_C_S)
  .value("PTRUE_D", LIEF::assembly::aarch64::OPCODE::PTRUE_D)
  .value("PTRUE_H", LIEF::assembly::aarch64::OPCODE::PTRUE_H)
  .value("PTRUE_S", LIEF::assembly::aarch64::OPCODE::PTRUE_S)
  .value("PUNPKHI_PP", LIEF::assembly::aarch64::OPCODE::PUNPKHI_PP)
  .value("PUNPKLO_PP", LIEF::assembly::aarch64::OPCODE::PUNPKLO_PP)
  .value("RADDHNB_ZZZ_B", LIEF::assembly::aarch64::OPCODE::RADDHNB_ZZZ_B)
  .value("RADDHNB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::RADDHNB_ZZZ_H)
  .value("RADDHNB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::RADDHNB_ZZZ_S)
  .value("RADDHNT_ZZZ_B", LIEF::assembly::aarch64::OPCODE::RADDHNT_ZZZ_B)
  .value("RADDHNT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::RADDHNT_ZZZ_H)
  .value("RADDHNT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::RADDHNT_ZZZ_S)
  .value("RADDHNv2i64_v2i32", LIEF::assembly::aarch64::OPCODE::RADDHNv2i64_v2i32)
  .value("RADDHNv2i64_v4i32", LIEF::assembly::aarch64::OPCODE::RADDHNv2i64_v4i32)
  .value("RADDHNv4i32_v4i16", LIEF::assembly::aarch64::OPCODE::RADDHNv4i32_v4i16)
  .value("RADDHNv4i32_v8i16", LIEF::assembly::aarch64::OPCODE::RADDHNv4i32_v8i16)
  .value("RADDHNv8i16_v16i8", LIEF::assembly::aarch64::OPCODE::RADDHNv8i16_v16i8)
  .value("RADDHNv8i16_v8i8", LIEF::assembly::aarch64::OPCODE::RADDHNv8i16_v8i8)
  .value("RAX1", LIEF::assembly::aarch64::OPCODE::RAX1)
  .value("RAX1_ZZZ_D", LIEF::assembly::aarch64::OPCODE::RAX1_ZZZ_D)
  .value("RBITWr", LIEF::assembly::aarch64::OPCODE::RBITWr)
  .value("RBITXr", LIEF::assembly::aarch64::OPCODE::RBITXr)
  .value("RBIT_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::RBIT_ZPmZ_B)
  .value("RBIT_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::RBIT_ZPmZ_D)
  .value("RBIT_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::RBIT_ZPmZ_H)
  .value("RBIT_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::RBIT_ZPmZ_S)
  .value("RBIT_ZPzZ_B", LIEF::assembly::aarch64::OPCODE::RBIT_ZPzZ_B)
  .value("RBIT_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::RBIT_ZPzZ_D)
  .value("RBIT_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::RBIT_ZPzZ_H)
  .value("RBIT_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::RBIT_ZPzZ_S)
  .value("RBITv16i8", LIEF::assembly::aarch64::OPCODE::RBITv16i8)
  .value("RBITv8i8", LIEF::assembly::aarch64::OPCODE::RBITv8i8)
  .value("RCWCAS", LIEF::assembly::aarch64::OPCODE::RCWCAS)
  .value("RCWCASA", LIEF::assembly::aarch64::OPCODE::RCWCASA)
  .value("RCWCASAL", LIEF::assembly::aarch64::OPCODE::RCWCASAL)
  .value("RCWCASL", LIEF::assembly::aarch64::OPCODE::RCWCASL)
  .value("RCWCASP", LIEF::assembly::aarch64::OPCODE::RCWCASP)
  .value("RCWCASPA", LIEF::assembly::aarch64::OPCODE::RCWCASPA)
  .value("RCWCASPAL", LIEF::assembly::aarch64::OPCODE::RCWCASPAL)
  .value("RCWCASPL", LIEF::assembly::aarch64::OPCODE::RCWCASPL)
  .value("RCWCLR", LIEF::assembly::aarch64::OPCODE::RCWCLR)
  .value("RCWCLRA", LIEF::assembly::aarch64::OPCODE::RCWCLRA)
  .value("RCWCLRAL", LIEF::assembly::aarch64::OPCODE::RCWCLRAL)
  .value("RCWCLRL", LIEF::assembly::aarch64::OPCODE::RCWCLRL)
  .value("RCWCLRP", LIEF::assembly::aarch64::OPCODE::RCWCLRP)
  .value("RCWCLRPA", LIEF::assembly::aarch64::OPCODE::RCWCLRPA)
  .value("RCWCLRPAL", LIEF::assembly::aarch64::OPCODE::RCWCLRPAL)
  .value("RCWCLRPL", LIEF::assembly::aarch64::OPCODE::RCWCLRPL)
  .value("RCWCLRS", LIEF::assembly::aarch64::OPCODE::RCWCLRS)
  .value("RCWCLRSA", LIEF::assembly::aarch64::OPCODE::RCWCLRSA)
  .value("RCWCLRSAL", LIEF::assembly::aarch64::OPCODE::RCWCLRSAL)
  .value("RCWCLRSL", LIEF::assembly::aarch64::OPCODE::RCWCLRSL)
  .value("RCWCLRSP", LIEF::assembly::aarch64::OPCODE::RCWCLRSP)
  .value("RCWCLRSPA", LIEF::assembly::aarch64::OPCODE::RCWCLRSPA)
  .value("RCWCLRSPAL", LIEF::assembly::aarch64::OPCODE::RCWCLRSPAL)
  .value("RCWCLRSPL", LIEF::assembly::aarch64::OPCODE::RCWCLRSPL)
  .value("RCWSCAS", LIEF::assembly::aarch64::OPCODE::RCWSCAS)
  .value("RCWSCASA", LIEF::assembly::aarch64::OPCODE::RCWSCASA)
  .value("RCWSCASAL", LIEF::assembly::aarch64::OPCODE::RCWSCASAL)
  .value("RCWSCASL", LIEF::assembly::aarch64::OPCODE::RCWSCASL)
  .value("RCWSCASP", LIEF::assembly::aarch64::OPCODE::RCWSCASP)
  .value("RCWSCASPA", LIEF::assembly::aarch64::OPCODE::RCWSCASPA)
  .value("RCWSCASPAL", LIEF::assembly::aarch64::OPCODE::RCWSCASPAL)
  .value("RCWSCASPL", LIEF::assembly::aarch64::OPCODE::RCWSCASPL)
  .value("RCWSET", LIEF::assembly::aarch64::OPCODE::RCWSET)
  .value("RCWSETA", LIEF::assembly::aarch64::OPCODE::RCWSETA)
  .value("RCWSETAL", LIEF::assembly::aarch64::OPCODE::RCWSETAL)
  .value("RCWSETL", LIEF::assembly::aarch64::OPCODE::RCWSETL)
  .value("RCWSETP", LIEF::assembly::aarch64::OPCODE::RCWSETP);
  opcodes.value("RCWSETPA", LIEF::assembly::aarch64::OPCODE::RCWSETPA)
  .value("RCWSETPAL", LIEF::assembly::aarch64::OPCODE::RCWSETPAL)
  .value("RCWSETPL", LIEF::assembly::aarch64::OPCODE::RCWSETPL)
  .value("RCWSETS", LIEF::assembly::aarch64::OPCODE::RCWSETS)
  .value("RCWSETSA", LIEF::assembly::aarch64::OPCODE::RCWSETSA)
  .value("RCWSETSAL", LIEF::assembly::aarch64::OPCODE::RCWSETSAL)
  .value("RCWSETSL", LIEF::assembly::aarch64::OPCODE::RCWSETSL)
  .value("RCWSETSP", LIEF::assembly::aarch64::OPCODE::RCWSETSP)
  .value("RCWSETSPA", LIEF::assembly::aarch64::OPCODE::RCWSETSPA)
  .value("RCWSETSPAL", LIEF::assembly::aarch64::OPCODE::RCWSETSPAL)
  .value("RCWSETSPL", LIEF::assembly::aarch64::OPCODE::RCWSETSPL)
  .value("RCWSWP", LIEF::assembly::aarch64::OPCODE::RCWSWP)
  .value("RCWSWPA", LIEF::assembly::aarch64::OPCODE::RCWSWPA)
  .value("RCWSWPAL", LIEF::assembly::aarch64::OPCODE::RCWSWPAL)
  .value("RCWSWPL", LIEF::assembly::aarch64::OPCODE::RCWSWPL)
  .value("RCWSWPP", LIEF::assembly::aarch64::OPCODE::RCWSWPP)
  .value("RCWSWPPA", LIEF::assembly::aarch64::OPCODE::RCWSWPPA)
  .value("RCWSWPPAL", LIEF::assembly::aarch64::OPCODE::RCWSWPPAL)
  .value("RCWSWPPL", LIEF::assembly::aarch64::OPCODE::RCWSWPPL)
  .value("RCWSWPS", LIEF::assembly::aarch64::OPCODE::RCWSWPS)
  .value("RCWSWPSA", LIEF::assembly::aarch64::OPCODE::RCWSWPSA)
  .value("RCWSWPSAL", LIEF::assembly::aarch64::OPCODE::RCWSWPSAL)
  .value("RCWSWPSL", LIEF::assembly::aarch64::OPCODE::RCWSWPSL)
  .value("RCWSWPSP", LIEF::assembly::aarch64::OPCODE::RCWSWPSP)
  .value("RCWSWPSPA", LIEF::assembly::aarch64::OPCODE::RCWSWPSPA)
  .value("RCWSWPSPAL", LIEF::assembly::aarch64::OPCODE::RCWSWPSPAL)
  .value("RCWSWPSPL", LIEF::assembly::aarch64::OPCODE::RCWSWPSPL)
  .value("RDFFRS_PPz", LIEF::assembly::aarch64::OPCODE::RDFFRS_PPz)
  .value("RDFFR_P", LIEF::assembly::aarch64::OPCODE::RDFFR_P)
  .value("RDFFR_PPz", LIEF::assembly::aarch64::OPCODE::RDFFR_PPz)
  .value("RDSVLI_XI", LIEF::assembly::aarch64::OPCODE::RDSVLI_XI)
  .value("RDVLI_XI", LIEF::assembly::aarch64::OPCODE::RDVLI_XI)
  .value("RET", LIEF::assembly::aarch64::OPCODE::RET)
  .value("RETAA", LIEF::assembly::aarch64::OPCODE::RETAA)
  .value("RETAASPPCi", LIEF::assembly::aarch64::OPCODE::RETAASPPCi)
  .value("RETAASPPCr", LIEF::assembly::aarch64::OPCODE::RETAASPPCr)
  .value("RETAB", LIEF::assembly::aarch64::OPCODE::RETAB)
  .value("RETABSPPCi", LIEF::assembly::aarch64::OPCODE::RETABSPPCi)
  .value("RETABSPPCr", LIEF::assembly::aarch64::OPCODE::RETABSPPCr)
  .value("REV16Wr", LIEF::assembly::aarch64::OPCODE::REV16Wr)
  .value("REV16Xr", LIEF::assembly::aarch64::OPCODE::REV16Xr)
  .value("REV16v16i8", LIEF::assembly::aarch64::OPCODE::REV16v16i8)
  .value("REV16v8i8", LIEF::assembly::aarch64::OPCODE::REV16v8i8)
  .value("REV32Xr", LIEF::assembly::aarch64::OPCODE::REV32Xr)
  .value("REV32v16i8", LIEF::assembly::aarch64::OPCODE::REV32v16i8)
  .value("REV32v4i16", LIEF::assembly::aarch64::OPCODE::REV32v4i16)
  .value("REV32v8i16", LIEF::assembly::aarch64::OPCODE::REV32v8i16)
  .value("REV32v8i8", LIEF::assembly::aarch64::OPCODE::REV32v8i8)
  .value("REV64v16i8", LIEF::assembly::aarch64::OPCODE::REV64v16i8)
  .value("REV64v2i32", LIEF::assembly::aarch64::OPCODE::REV64v2i32)
  .value("REV64v4i16", LIEF::assembly::aarch64::OPCODE::REV64v4i16)
  .value("REV64v4i32", LIEF::assembly::aarch64::OPCODE::REV64v4i32)
  .value("REV64v8i16", LIEF::assembly::aarch64::OPCODE::REV64v8i16)
  .value("REV64v8i8", LIEF::assembly::aarch64::OPCODE::REV64v8i8)
  .value("REVB_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::REVB_ZPmZ_D)
  .value("REVB_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::REVB_ZPmZ_H)
  .value("REVB_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::REVB_ZPmZ_S)
  .value("REVB_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::REVB_ZPzZ_D)
  .value("REVB_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::REVB_ZPzZ_H)
  .value("REVB_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::REVB_ZPzZ_S)
  .value("REVD_ZPmZ", LIEF::assembly::aarch64::OPCODE::REVD_ZPmZ)
  .value("REVD_ZPzZ", LIEF::assembly::aarch64::OPCODE::REVD_ZPzZ)
  .value("REVH_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::REVH_ZPmZ_D)
  .value("REVH_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::REVH_ZPmZ_S)
  .value("REVH_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::REVH_ZPzZ_D)
  .value("REVH_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::REVH_ZPzZ_S)
  .value("REVW_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::REVW_ZPmZ_D)
  .value("REVW_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::REVW_ZPzZ_D)
  .value("REVWr", LIEF::assembly::aarch64::OPCODE::REVWr)
  .value("REVXr", LIEF::assembly::aarch64::OPCODE::REVXr)
  .value("REV_PP_B", LIEF::assembly::aarch64::OPCODE::REV_PP_B)
  .value("REV_PP_D", LIEF::assembly::aarch64::OPCODE::REV_PP_D)
  .value("REV_PP_H", LIEF::assembly::aarch64::OPCODE::REV_PP_H)
  .value("REV_PP_S", LIEF::assembly::aarch64::OPCODE::REV_PP_S)
  .value("REV_ZZ_B", LIEF::assembly::aarch64::OPCODE::REV_ZZ_B)
  .value("REV_ZZ_D", LIEF::assembly::aarch64::OPCODE::REV_ZZ_D)
  .value("REV_ZZ_H", LIEF::assembly::aarch64::OPCODE::REV_ZZ_H)
  .value("REV_ZZ_S", LIEF::assembly::aarch64::OPCODE::REV_ZZ_S)
  .value("RMIF", LIEF::assembly::aarch64::OPCODE::RMIF)
  .value("RORVWr", LIEF::assembly::aarch64::OPCODE::RORVWr)
  .value("RORVXr", LIEF::assembly::aarch64::OPCODE::RORVXr)
  .value("RPRFM", LIEF::assembly::aarch64::OPCODE::RPRFM)
  .value("RSHRNB_ZZI_B", LIEF::assembly::aarch64::OPCODE::RSHRNB_ZZI_B)
  .value("RSHRNB_ZZI_H", LIEF::assembly::aarch64::OPCODE::RSHRNB_ZZI_H)
  .value("RSHRNB_ZZI_S", LIEF::assembly::aarch64::OPCODE::RSHRNB_ZZI_S)
  .value("RSHRNT_ZZI_B", LIEF::assembly::aarch64::OPCODE::RSHRNT_ZZI_B)
  .value("RSHRNT_ZZI_H", LIEF::assembly::aarch64::OPCODE::RSHRNT_ZZI_H)
  .value("RSHRNT_ZZI_S", LIEF::assembly::aarch64::OPCODE::RSHRNT_ZZI_S)
  .value("RSHRNv16i8_shift", LIEF::assembly::aarch64::OPCODE::RSHRNv16i8_shift)
  .value("RSHRNv2i32_shift", LIEF::assembly::aarch64::OPCODE::RSHRNv2i32_shift)
  .value("RSHRNv4i16_shift", LIEF::assembly::aarch64::OPCODE::RSHRNv4i16_shift)
  .value("RSHRNv4i32_shift", LIEF::assembly::aarch64::OPCODE::RSHRNv4i32_shift)
  .value("RSHRNv8i16_shift", LIEF::assembly::aarch64::OPCODE::RSHRNv8i16_shift)
  .value("RSHRNv8i8_shift", LIEF::assembly::aarch64::OPCODE::RSHRNv8i8_shift)
  .value("RSUBHNB_ZZZ_B", LIEF::assembly::aarch64::OPCODE::RSUBHNB_ZZZ_B)
  .value("RSUBHNB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::RSUBHNB_ZZZ_H)
  .value("RSUBHNB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::RSUBHNB_ZZZ_S)
  .value("RSUBHNT_ZZZ_B", LIEF::assembly::aarch64::OPCODE::RSUBHNT_ZZZ_B)
  .value("RSUBHNT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::RSUBHNT_ZZZ_H)
  .value("RSUBHNT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::RSUBHNT_ZZZ_S)
  .value("RSUBHNv2i64_v2i32", LIEF::assembly::aarch64::OPCODE::RSUBHNv2i64_v2i32)
  .value("RSUBHNv2i64_v4i32", LIEF::assembly::aarch64::OPCODE::RSUBHNv2i64_v4i32)
  .value("RSUBHNv4i32_v4i16", LIEF::assembly::aarch64::OPCODE::RSUBHNv4i32_v4i16)
  .value("RSUBHNv4i32_v8i16", LIEF::assembly::aarch64::OPCODE::RSUBHNv4i32_v8i16)
  .value("RSUBHNv8i16_v16i8", LIEF::assembly::aarch64::OPCODE::RSUBHNv8i16_v16i8)
  .value("RSUBHNv8i16_v8i8", LIEF::assembly::aarch64::OPCODE::RSUBHNv8i16_v8i8)
  .value("SABALB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SABALB_ZZZ_D)
  .value("SABALB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SABALB_ZZZ_H)
  .value("SABALB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SABALB_ZZZ_S)
  .value("SABALT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SABALT_ZZZ_D)
  .value("SABALT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SABALT_ZZZ_H)
  .value("SABALT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SABALT_ZZZ_S)
  .value("SABALv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::SABALv16i8_v8i16)
  .value("SABALv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::SABALv2i32_v2i64)
  .value("SABALv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::SABALv4i16_v4i32)
  .value("SABALv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::SABALv4i32_v2i64)
  .value("SABALv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::SABALv8i16_v4i32)
  .value("SABALv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::SABALv8i8_v8i16)
  .value("SABA_ZZZ_B", LIEF::assembly::aarch64::OPCODE::SABA_ZZZ_B)
  .value("SABA_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SABA_ZZZ_D)
  .value("SABA_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SABA_ZZZ_H)
  .value("SABA_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SABA_ZZZ_S)
  .value("SABAv16i8", LIEF::assembly::aarch64::OPCODE::SABAv16i8)
  .value("SABAv2i32", LIEF::assembly::aarch64::OPCODE::SABAv2i32)
  .value("SABAv4i16", LIEF::assembly::aarch64::OPCODE::SABAv4i16)
  .value("SABAv4i32", LIEF::assembly::aarch64::OPCODE::SABAv4i32)
  .value("SABAv8i16", LIEF::assembly::aarch64::OPCODE::SABAv8i16)
  .value("SABAv8i8", LIEF::assembly::aarch64::OPCODE::SABAv8i8)
  .value("SABDLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SABDLB_ZZZ_D)
  .value("SABDLB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SABDLB_ZZZ_H)
  .value("SABDLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SABDLB_ZZZ_S)
  .value("SABDLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SABDLT_ZZZ_D)
  .value("SABDLT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SABDLT_ZZZ_H)
  .value("SABDLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SABDLT_ZZZ_S)
  .value("SABDLv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::SABDLv16i8_v8i16)
  .value("SABDLv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::SABDLv2i32_v2i64)
  .value("SABDLv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::SABDLv4i16_v4i32)
  .value("SABDLv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::SABDLv4i32_v2i64)
  .value("SABDLv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::SABDLv8i16_v4i32)
  .value("SABDLv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::SABDLv8i8_v8i16)
  .value("SABD_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SABD_ZPmZ_B)
  .value("SABD_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SABD_ZPmZ_D)
  .value("SABD_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SABD_ZPmZ_H)
  .value("SABD_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SABD_ZPmZ_S)
  .value("SABDv16i8", LIEF::assembly::aarch64::OPCODE::SABDv16i8)
  .value("SABDv2i32", LIEF::assembly::aarch64::OPCODE::SABDv2i32)
  .value("SABDv4i16", LIEF::assembly::aarch64::OPCODE::SABDv4i16)
  .value("SABDv4i32", LIEF::assembly::aarch64::OPCODE::SABDv4i32)
  .value("SABDv8i16", LIEF::assembly::aarch64::OPCODE::SABDv8i16)
  .value("SABDv8i8", LIEF::assembly::aarch64::OPCODE::SABDv8i8)
  .value("SADALP_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SADALP_ZPmZ_D)
  .value("SADALP_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SADALP_ZPmZ_H)
  .value("SADALP_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SADALP_ZPmZ_S)
  .value("SADALPv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::SADALPv16i8_v8i16)
  .value("SADALPv2i32_v1i64", LIEF::assembly::aarch64::OPCODE::SADALPv2i32_v1i64)
  .value("SADALPv4i16_v2i32", LIEF::assembly::aarch64::OPCODE::SADALPv4i16_v2i32)
  .value("SADALPv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::SADALPv4i32_v2i64)
  .value("SADALPv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::SADALPv8i16_v4i32)
  .value("SADALPv8i8_v4i16", LIEF::assembly::aarch64::OPCODE::SADALPv8i8_v4i16)
  .value("SADDLBT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SADDLBT_ZZZ_D)
  .value("SADDLBT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SADDLBT_ZZZ_H)
  .value("SADDLBT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SADDLBT_ZZZ_S)
  .value("SADDLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SADDLB_ZZZ_D)
  .value("SADDLB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SADDLB_ZZZ_H)
  .value("SADDLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SADDLB_ZZZ_S)
  .value("SADDLPv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::SADDLPv16i8_v8i16)
  .value("SADDLPv2i32_v1i64", LIEF::assembly::aarch64::OPCODE::SADDLPv2i32_v1i64)
  .value("SADDLPv4i16_v2i32", LIEF::assembly::aarch64::OPCODE::SADDLPv4i16_v2i32)
  .value("SADDLPv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::SADDLPv4i32_v2i64)
  .value("SADDLPv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::SADDLPv8i16_v4i32)
  .value("SADDLPv8i8_v4i16", LIEF::assembly::aarch64::OPCODE::SADDLPv8i8_v4i16)
  .value("SADDLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SADDLT_ZZZ_D)
  .value("SADDLT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SADDLT_ZZZ_H)
  .value("SADDLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SADDLT_ZZZ_S)
  .value("SADDLVv16i8v", LIEF::assembly::aarch64::OPCODE::SADDLVv16i8v)
  .value("SADDLVv4i16v", LIEF::assembly::aarch64::OPCODE::SADDLVv4i16v)
  .value("SADDLVv4i32v", LIEF::assembly::aarch64::OPCODE::SADDLVv4i32v)
  .value("SADDLVv8i16v", LIEF::assembly::aarch64::OPCODE::SADDLVv8i16v)
  .value("SADDLVv8i8v", LIEF::assembly::aarch64::OPCODE::SADDLVv8i8v)
  .value("SADDLv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::SADDLv16i8_v8i16)
  .value("SADDLv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::SADDLv2i32_v2i64)
  .value("SADDLv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::SADDLv4i16_v4i32)
  .value("SADDLv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::SADDLv4i32_v2i64)
  .value("SADDLv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::SADDLv8i16_v4i32)
  .value("SADDLv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::SADDLv8i8_v8i16)
  .value("SADDV_VPZ_B", LIEF::assembly::aarch64::OPCODE::SADDV_VPZ_B)
  .value("SADDV_VPZ_H", LIEF::assembly::aarch64::OPCODE::SADDV_VPZ_H)
  .value("SADDV_VPZ_S", LIEF::assembly::aarch64::OPCODE::SADDV_VPZ_S)
  .value("SADDWB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SADDWB_ZZZ_D)
  .value("SADDWB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SADDWB_ZZZ_H)
  .value("SADDWB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SADDWB_ZZZ_S)
  .value("SADDWT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SADDWT_ZZZ_D)
  .value("SADDWT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SADDWT_ZZZ_H)
  .value("SADDWT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SADDWT_ZZZ_S)
  .value("SADDWv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::SADDWv16i8_v8i16)
  .value("SADDWv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::SADDWv2i32_v2i64)
  .value("SADDWv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::SADDWv4i16_v4i32)
  .value("SADDWv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::SADDWv4i32_v2i64)
  .value("SADDWv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::SADDWv8i16_v4i32)
  .value("SADDWv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::SADDWv8i8_v8i16)
  .value("SB", LIEF::assembly::aarch64::OPCODE::SB)
  .value("SBCLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SBCLB_ZZZ_D)
  .value("SBCLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SBCLB_ZZZ_S)
  .value("SBCLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SBCLT_ZZZ_D)
  .value("SBCLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SBCLT_ZZZ_S)
  .value("SBCSWr", LIEF::assembly::aarch64::OPCODE::SBCSWr)
  .value("SBCSXr", LIEF::assembly::aarch64::OPCODE::SBCSXr)
  .value("SBCWr", LIEF::assembly::aarch64::OPCODE::SBCWr)
  .value("SBCXr", LIEF::assembly::aarch64::OPCODE::SBCXr)
  .value("SBFMWri", LIEF::assembly::aarch64::OPCODE::SBFMWri)
  .value("SBFMXri", LIEF::assembly::aarch64::OPCODE::SBFMXri)
  .value("SCLAMP_VG2_2Z2Z_B", LIEF::assembly::aarch64::OPCODE::SCLAMP_VG2_2Z2Z_B)
  .value("SCLAMP_VG2_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::SCLAMP_VG2_2Z2Z_D)
  .value("SCLAMP_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::SCLAMP_VG2_2Z2Z_H)
  .value("SCLAMP_VG2_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::SCLAMP_VG2_2Z2Z_S)
  .value("SCLAMP_VG4_4Z4Z_B", LIEF::assembly::aarch64::OPCODE::SCLAMP_VG4_4Z4Z_B)
  .value("SCLAMP_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::SCLAMP_VG4_4Z4Z_D)
  .value("SCLAMP_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::SCLAMP_VG4_4Z4Z_H)
  .value("SCLAMP_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::SCLAMP_VG4_4Z4Z_S)
  .value("SCLAMP_ZZZ_B", LIEF::assembly::aarch64::OPCODE::SCLAMP_ZZZ_B)
  .value("SCLAMP_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SCLAMP_ZZZ_D)
  .value("SCLAMP_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SCLAMP_ZZZ_H)
  .value("SCLAMP_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SCLAMP_ZZZ_S)
  .value("SCVTFDSr", LIEF::assembly::aarch64::OPCODE::SCVTFDSr)
  .value("SCVTFHDr", LIEF::assembly::aarch64::OPCODE::SCVTFHDr)
  .value("SCVTFHSr", LIEF::assembly::aarch64::OPCODE::SCVTFHSr)
  .value("SCVTFSDr", LIEF::assembly::aarch64::OPCODE::SCVTFSDr)
  .value("SCVTFSWDri", LIEF::assembly::aarch64::OPCODE::SCVTFSWDri)
  .value("SCVTFSWHri", LIEF::assembly::aarch64::OPCODE::SCVTFSWHri)
  .value("SCVTFSWSri", LIEF::assembly::aarch64::OPCODE::SCVTFSWSri)
  .value("SCVTFSXDri", LIEF::assembly::aarch64::OPCODE::SCVTFSXDri)
  .value("SCVTFSXHri", LIEF::assembly::aarch64::OPCODE::SCVTFSXHri)
  .value("SCVTFSXSri", LIEF::assembly::aarch64::OPCODE::SCVTFSXSri)
  .value("SCVTFUWDri", LIEF::assembly::aarch64::OPCODE::SCVTFUWDri)
  .value("SCVTFUWHri", LIEF::assembly::aarch64::OPCODE::SCVTFUWHri)
  .value("SCVTFUWSri", LIEF::assembly::aarch64::OPCODE::SCVTFUWSri)
  .value("SCVTFUXDri", LIEF::assembly::aarch64::OPCODE::SCVTFUXDri)
  .value("SCVTFUXHri", LIEF::assembly::aarch64::OPCODE::SCVTFUXHri)
  .value("SCVTFUXSri", LIEF::assembly::aarch64::OPCODE::SCVTFUXSri)
  .value("SCVTF_2Z2Z_StoS", LIEF::assembly::aarch64::OPCODE::SCVTF_2Z2Z_StoS)
  .value("SCVTF_4Z4Z_StoS", LIEF::assembly::aarch64::OPCODE::SCVTF_4Z4Z_StoS)
  .value("SCVTF_ZPmZ_DtoD", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPmZ_DtoD)
  .value("SCVTF_ZPmZ_DtoH", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPmZ_DtoH)
  .value("SCVTF_ZPmZ_DtoS", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPmZ_DtoS)
  .value("SCVTF_ZPmZ_HtoH", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPmZ_HtoH)
  .value("SCVTF_ZPmZ_StoD", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPmZ_StoD)
  .value("SCVTF_ZPmZ_StoH", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPmZ_StoH)
  .value("SCVTF_ZPmZ_StoS", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPmZ_StoS)
  .value("SCVTF_ZPzZ_DtoD", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPzZ_DtoD)
  .value("SCVTF_ZPzZ_DtoH", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPzZ_DtoH)
  .value("SCVTF_ZPzZ_DtoS", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPzZ_DtoS)
  .value("SCVTF_ZPzZ_HtoH", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPzZ_HtoH)
  .value("SCVTF_ZPzZ_StoD", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPzZ_StoD)
  .value("SCVTF_ZPzZ_StoH", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPzZ_StoH)
  .value("SCVTF_ZPzZ_StoS", LIEF::assembly::aarch64::OPCODE::SCVTF_ZPzZ_StoS)
  .value("SCVTFd", LIEF::assembly::aarch64::OPCODE::SCVTFd)
  .value("SCVTFh", LIEF::assembly::aarch64::OPCODE::SCVTFh)
  .value("SCVTFs", LIEF::assembly::aarch64::OPCODE::SCVTFs)
  .value("SCVTFv1i16", LIEF::assembly::aarch64::OPCODE::SCVTFv1i16)
  .value("SCVTFv1i32", LIEF::assembly::aarch64::OPCODE::SCVTFv1i32)
  .value("SCVTFv1i64", LIEF::assembly::aarch64::OPCODE::SCVTFv1i64)
  .value("SCVTFv2f32", LIEF::assembly::aarch64::OPCODE::SCVTFv2f32)
  .value("SCVTFv2f64", LIEF::assembly::aarch64::OPCODE::SCVTFv2f64)
  .value("SCVTFv2i32_shift", LIEF::assembly::aarch64::OPCODE::SCVTFv2i32_shift)
  .value("SCVTFv2i64_shift", LIEF::assembly::aarch64::OPCODE::SCVTFv2i64_shift)
  .value("SCVTFv4f16", LIEF::assembly::aarch64::OPCODE::SCVTFv4f16)
  .value("SCVTFv4f32", LIEF::assembly::aarch64::OPCODE::SCVTFv4f32)
  .value("SCVTFv4i16_shift", LIEF::assembly::aarch64::OPCODE::SCVTFv4i16_shift)
  .value("SCVTFv4i32_shift", LIEF::assembly::aarch64::OPCODE::SCVTFv4i32_shift)
  .value("SCVTFv8f16", LIEF::assembly::aarch64::OPCODE::SCVTFv8f16)
  .value("SCVTFv8i16_shift", LIEF::assembly::aarch64::OPCODE::SCVTFv8i16_shift)
  .value("SDIVR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SDIVR_ZPmZ_D)
  .value("SDIVR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SDIVR_ZPmZ_S)
  .value("SDIVWr", LIEF::assembly::aarch64::OPCODE::SDIVWr)
  .value("SDIVXr", LIEF::assembly::aarch64::OPCODE::SDIVXr)
  .value("SDIV_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SDIV_ZPmZ_D)
  .value("SDIV_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SDIV_ZPmZ_S)
  .value("SDOT_VG2_M2Z2Z_BtoS", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2Z2Z_BtoS)
  .value("SDOT_VG2_M2Z2Z_HtoD", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2Z2Z_HtoD)
  .value("SDOT_VG2_M2Z2Z_HtoS", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2Z2Z_HtoS)
  .value("SDOT_VG2_M2ZZI_BToS", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2ZZI_BToS)
  .value("SDOT_VG2_M2ZZI_HToS", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2ZZI_HToS)
  .value("SDOT_VG2_M2ZZI_HtoD", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2ZZI_HtoD)
  .value("SDOT_VG2_M2ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2ZZ_BtoS)
  .value("SDOT_VG2_M2ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2ZZ_HtoD)
  .value("SDOT_VG2_M2ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::SDOT_VG2_M2ZZ_HtoS)
  .value("SDOT_VG4_M4Z4Z_BtoS", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4Z4Z_BtoS)
  .value("SDOT_VG4_M4Z4Z_HtoD", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4Z4Z_HtoD)
  .value("SDOT_VG4_M4Z4Z_HtoS", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4Z4Z_HtoS)
  .value("SDOT_VG4_M4ZZI_BToS", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4ZZI_BToS)
  .value("SDOT_VG4_M4ZZI_HToS", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4ZZI_HToS)
  .value("SDOT_VG4_M4ZZI_HtoD", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4ZZI_HtoD)
  .value("SDOT_VG4_M4ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4ZZ_BtoS)
  .value("SDOT_VG4_M4ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4ZZ_HtoD)
  .value("SDOT_VG4_M4ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::SDOT_VG4_M4ZZ_HtoS)
  .value("SDOT_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SDOT_ZZZI_D)
  .value("SDOT_ZZZI_HtoS", LIEF::assembly::aarch64::OPCODE::SDOT_ZZZI_HtoS)
  .value("SDOT_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SDOT_ZZZI_S)
  .value("SDOT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SDOT_ZZZ_D)
  .value("SDOT_ZZZ_HtoS", LIEF::assembly::aarch64::OPCODE::SDOT_ZZZ_HtoS);
  opcodes.value("SDOT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SDOT_ZZZ_S)
  .value("SDOTlanev16i8", LIEF::assembly::aarch64::OPCODE::SDOTlanev16i8)
  .value("SDOTlanev8i8", LIEF::assembly::aarch64::OPCODE::SDOTlanev8i8)
  .value("SDOTv16i8", LIEF::assembly::aarch64::OPCODE::SDOTv16i8)
  .value("SDOTv8i8", LIEF::assembly::aarch64::OPCODE::SDOTv8i8)
  .value("SEL_PPPP", LIEF::assembly::aarch64::OPCODE::SEL_PPPP)
  .value("SEL_VG2_2ZC2Z2Z_B", LIEF::assembly::aarch64::OPCODE::SEL_VG2_2ZC2Z2Z_B)
  .value("SEL_VG2_2ZC2Z2Z_D", LIEF::assembly::aarch64::OPCODE::SEL_VG2_2ZC2Z2Z_D)
  .value("SEL_VG2_2ZC2Z2Z_H", LIEF::assembly::aarch64::OPCODE::SEL_VG2_2ZC2Z2Z_H)
  .value("SEL_VG2_2ZC2Z2Z_S", LIEF::assembly::aarch64::OPCODE::SEL_VG2_2ZC2Z2Z_S)
  .value("SEL_VG4_4ZC4Z4Z_B", LIEF::assembly::aarch64::OPCODE::SEL_VG4_4ZC4Z4Z_B)
  .value("SEL_VG4_4ZC4Z4Z_D", LIEF::assembly::aarch64::OPCODE::SEL_VG4_4ZC4Z4Z_D)
  .value("SEL_VG4_4ZC4Z4Z_H", LIEF::assembly::aarch64::OPCODE::SEL_VG4_4ZC4Z4Z_H)
  .value("SEL_VG4_4ZC4Z4Z_S", LIEF::assembly::aarch64::OPCODE::SEL_VG4_4ZC4Z4Z_S)
  .value("SEL_ZPZZ_B", LIEF::assembly::aarch64::OPCODE::SEL_ZPZZ_B)
  .value("SEL_ZPZZ_D", LIEF::assembly::aarch64::OPCODE::SEL_ZPZZ_D)
  .value("SEL_ZPZZ_H", LIEF::assembly::aarch64::OPCODE::SEL_ZPZZ_H)
  .value("SEL_ZPZZ_S", LIEF::assembly::aarch64::OPCODE::SEL_ZPZZ_S)
  .value("SETE", LIEF::assembly::aarch64::OPCODE::SETE)
  .value("SETEN", LIEF::assembly::aarch64::OPCODE::SETEN)
  .value("SETET", LIEF::assembly::aarch64::OPCODE::SETET)
  .value("SETETN", LIEF::assembly::aarch64::OPCODE::SETETN)
  .value("SETF16", LIEF::assembly::aarch64::OPCODE::SETF16)
  .value("SETF8", LIEF::assembly::aarch64::OPCODE::SETF8)
  .value("SETFFR", LIEF::assembly::aarch64::OPCODE::SETFFR)
  .value("SETGM", LIEF::assembly::aarch64::OPCODE::SETGM)
  .value("SETGMN", LIEF::assembly::aarch64::OPCODE::SETGMN)
  .value("SETGMT", LIEF::assembly::aarch64::OPCODE::SETGMT)
  .value("SETGMTN", LIEF::assembly::aarch64::OPCODE::SETGMTN)
  .value("SETGP", LIEF::assembly::aarch64::OPCODE::SETGP)
  .value("SETGPN", LIEF::assembly::aarch64::OPCODE::SETGPN)
  .value("SETGPT", LIEF::assembly::aarch64::OPCODE::SETGPT)
  .value("SETGPTN", LIEF::assembly::aarch64::OPCODE::SETGPTN)
  .value("SETM", LIEF::assembly::aarch64::OPCODE::SETM)
  .value("SETMN", LIEF::assembly::aarch64::OPCODE::SETMN)
  .value("SETMT", LIEF::assembly::aarch64::OPCODE::SETMT)
  .value("SETMTN", LIEF::assembly::aarch64::OPCODE::SETMTN)
  .value("SETP", LIEF::assembly::aarch64::OPCODE::SETP)
  .value("SETPN", LIEF::assembly::aarch64::OPCODE::SETPN)
  .value("SETPT", LIEF::assembly::aarch64::OPCODE::SETPT)
  .value("SETPTN", LIEF::assembly::aarch64::OPCODE::SETPTN)
  .value("SHA1Crrr", LIEF::assembly::aarch64::OPCODE::SHA1Crrr)
  .value("SHA1Hrr", LIEF::assembly::aarch64::OPCODE::SHA1Hrr)
  .value("SHA1Mrrr", LIEF::assembly::aarch64::OPCODE::SHA1Mrrr)
  .value("SHA1Prrr", LIEF::assembly::aarch64::OPCODE::SHA1Prrr)
  .value("SHA1SU0rrr", LIEF::assembly::aarch64::OPCODE::SHA1SU0rrr)
  .value("SHA1SU1rr", LIEF::assembly::aarch64::OPCODE::SHA1SU1rr)
  .value("SHA256H2rrr", LIEF::assembly::aarch64::OPCODE::SHA256H2rrr)
  .value("SHA256Hrrr", LIEF::assembly::aarch64::OPCODE::SHA256Hrrr)
  .value("SHA256SU0rr", LIEF::assembly::aarch64::OPCODE::SHA256SU0rr)
  .value("SHA256SU1rrr", LIEF::assembly::aarch64::OPCODE::SHA256SU1rrr)
  .value("SHA512H", LIEF::assembly::aarch64::OPCODE::SHA512H)
  .value("SHA512H2", LIEF::assembly::aarch64::OPCODE::SHA512H2)
  .value("SHA512SU0", LIEF::assembly::aarch64::OPCODE::SHA512SU0)
  .value("SHA512SU1", LIEF::assembly::aarch64::OPCODE::SHA512SU1)
  .value("SHADD_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SHADD_ZPmZ_B)
  .value("SHADD_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SHADD_ZPmZ_D)
  .value("SHADD_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SHADD_ZPmZ_H)
  .value("SHADD_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SHADD_ZPmZ_S)
  .value("SHADDv16i8", LIEF::assembly::aarch64::OPCODE::SHADDv16i8)
  .value("SHADDv2i32", LIEF::assembly::aarch64::OPCODE::SHADDv2i32)
  .value("SHADDv4i16", LIEF::assembly::aarch64::OPCODE::SHADDv4i16)
  .value("SHADDv4i32", LIEF::assembly::aarch64::OPCODE::SHADDv4i32)
  .value("SHADDv8i16", LIEF::assembly::aarch64::OPCODE::SHADDv8i16)
  .value("SHADDv8i8", LIEF::assembly::aarch64::OPCODE::SHADDv8i8)
  .value("SHLLv16i8", LIEF::assembly::aarch64::OPCODE::SHLLv16i8)
  .value("SHLLv2i32", LIEF::assembly::aarch64::OPCODE::SHLLv2i32)
  .value("SHLLv4i16", LIEF::assembly::aarch64::OPCODE::SHLLv4i16)
  .value("SHLLv4i32", LIEF::assembly::aarch64::OPCODE::SHLLv4i32)
  .value("SHLLv8i16", LIEF::assembly::aarch64::OPCODE::SHLLv8i16)
  .value("SHLLv8i8", LIEF::assembly::aarch64::OPCODE::SHLLv8i8)
  .value("SHLd", LIEF::assembly::aarch64::OPCODE::SHLd)
  .value("SHLv16i8_shift", LIEF::assembly::aarch64::OPCODE::SHLv16i8_shift)
  .value("SHLv2i32_shift", LIEF::assembly::aarch64::OPCODE::SHLv2i32_shift)
  .value("SHLv2i64_shift", LIEF::assembly::aarch64::OPCODE::SHLv2i64_shift)
  .value("SHLv4i16_shift", LIEF::assembly::aarch64::OPCODE::SHLv4i16_shift)
  .value("SHLv4i32_shift", LIEF::assembly::aarch64::OPCODE::SHLv4i32_shift)
  .value("SHLv8i16_shift", LIEF::assembly::aarch64::OPCODE::SHLv8i16_shift)
  .value("SHLv8i8_shift", LIEF::assembly::aarch64::OPCODE::SHLv8i8_shift)
  .value("SHRNB_ZZI_B", LIEF::assembly::aarch64::OPCODE::SHRNB_ZZI_B)
  .value("SHRNB_ZZI_H", LIEF::assembly::aarch64::OPCODE::SHRNB_ZZI_H)
  .value("SHRNB_ZZI_S", LIEF::assembly::aarch64::OPCODE::SHRNB_ZZI_S)
  .value("SHRNT_ZZI_B", LIEF::assembly::aarch64::OPCODE::SHRNT_ZZI_B)
  .value("SHRNT_ZZI_H", LIEF::assembly::aarch64::OPCODE::SHRNT_ZZI_H)
  .value("SHRNT_ZZI_S", LIEF::assembly::aarch64::OPCODE::SHRNT_ZZI_S)
  .value("SHRNv16i8_shift", LIEF::assembly::aarch64::OPCODE::SHRNv16i8_shift)
  .value("SHRNv2i32_shift", LIEF::assembly::aarch64::OPCODE::SHRNv2i32_shift)
  .value("SHRNv4i16_shift", LIEF::assembly::aarch64::OPCODE::SHRNv4i16_shift)
  .value("SHRNv4i32_shift", LIEF::assembly::aarch64::OPCODE::SHRNv4i32_shift)
  .value("SHRNv8i16_shift", LIEF::assembly::aarch64::OPCODE::SHRNv8i16_shift)
  .value("SHRNv8i8_shift", LIEF::assembly::aarch64::OPCODE::SHRNv8i8_shift)
  .value("SHSUBR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SHSUBR_ZPmZ_B)
  .value("SHSUBR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SHSUBR_ZPmZ_D)
  .value("SHSUBR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SHSUBR_ZPmZ_H)
  .value("SHSUBR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SHSUBR_ZPmZ_S)
  .value("SHSUB_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SHSUB_ZPmZ_B)
  .value("SHSUB_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SHSUB_ZPmZ_D)
  .value("SHSUB_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SHSUB_ZPmZ_H)
  .value("SHSUB_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SHSUB_ZPmZ_S)
  .value("SHSUBv16i8", LIEF::assembly::aarch64::OPCODE::SHSUBv16i8)
  .value("SHSUBv2i32", LIEF::assembly::aarch64::OPCODE::SHSUBv2i32)
  .value("SHSUBv4i16", LIEF::assembly::aarch64::OPCODE::SHSUBv4i16)
  .value("SHSUBv4i32", LIEF::assembly::aarch64::OPCODE::SHSUBv4i32)
  .value("SHSUBv8i16", LIEF::assembly::aarch64::OPCODE::SHSUBv8i16)
  .value("SHSUBv8i8", LIEF::assembly::aarch64::OPCODE::SHSUBv8i8)
  .value("SLI_ZZI_B", LIEF::assembly::aarch64::OPCODE::SLI_ZZI_B)
  .value("SLI_ZZI_D", LIEF::assembly::aarch64::OPCODE::SLI_ZZI_D)
  .value("SLI_ZZI_H", LIEF::assembly::aarch64::OPCODE::SLI_ZZI_H)
  .value("SLI_ZZI_S", LIEF::assembly::aarch64::OPCODE::SLI_ZZI_S)
  .value("SLId", LIEF::assembly::aarch64::OPCODE::SLId)
  .value("SLIv16i8_shift", LIEF::assembly::aarch64::OPCODE::SLIv16i8_shift)
  .value("SLIv2i32_shift", LIEF::assembly::aarch64::OPCODE::SLIv2i32_shift)
  .value("SLIv2i64_shift", LIEF::assembly::aarch64::OPCODE::SLIv2i64_shift)
  .value("SLIv4i16_shift", LIEF::assembly::aarch64::OPCODE::SLIv4i16_shift)
  .value("SLIv4i32_shift", LIEF::assembly::aarch64::OPCODE::SLIv4i32_shift)
  .value("SLIv8i16_shift", LIEF::assembly::aarch64::OPCODE::SLIv8i16_shift)
  .value("SLIv8i8_shift", LIEF::assembly::aarch64::OPCODE::SLIv8i8_shift)
  .value("SM3PARTW1", LIEF::assembly::aarch64::OPCODE::SM3PARTW1)
  .value("SM3PARTW2", LIEF::assembly::aarch64::OPCODE::SM3PARTW2)
  .value("SM3SS1", LIEF::assembly::aarch64::OPCODE::SM3SS1)
  .value("SM3TT1A", LIEF::assembly::aarch64::OPCODE::SM3TT1A)
  .value("SM3TT1B", LIEF::assembly::aarch64::OPCODE::SM3TT1B)
  .value("SM3TT2A", LIEF::assembly::aarch64::OPCODE::SM3TT2A)
  .value("SM3TT2B", LIEF::assembly::aarch64::OPCODE::SM3TT2B)
  .value("SM4E", LIEF::assembly::aarch64::OPCODE::SM4E)
  .value("SM4EKEY_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SM4EKEY_ZZZ_S)
  .value("SM4ENCKEY", LIEF::assembly::aarch64::OPCODE::SM4ENCKEY)
  .value("SM4E_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SM4E_ZZZ_S)
  .value("SMADDLrrr", LIEF::assembly::aarch64::OPCODE::SMADDLrrr)
  .value("SMAXP_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SMAXP_ZPmZ_B)
  .value("SMAXP_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SMAXP_ZPmZ_D)
  .value("SMAXP_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SMAXP_ZPmZ_H)
  .value("SMAXP_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SMAXP_ZPmZ_S)
  .value("SMAXPv16i8", LIEF::assembly::aarch64::OPCODE::SMAXPv16i8)
  .value("SMAXPv2i32", LIEF::assembly::aarch64::OPCODE::SMAXPv2i32)
  .value("SMAXPv4i16", LIEF::assembly::aarch64::OPCODE::SMAXPv4i16)
  .value("SMAXPv4i32", LIEF::assembly::aarch64::OPCODE::SMAXPv4i32)
  .value("SMAXPv8i16", LIEF::assembly::aarch64::OPCODE::SMAXPv8i16)
  .value("SMAXPv8i8", LIEF::assembly::aarch64::OPCODE::SMAXPv8i8)
  .value("SMAXQV_VPZ_B", LIEF::assembly::aarch64::OPCODE::SMAXQV_VPZ_B)
  .value("SMAXQV_VPZ_D", LIEF::assembly::aarch64::OPCODE::SMAXQV_VPZ_D)
  .value("SMAXQV_VPZ_H", LIEF::assembly::aarch64::OPCODE::SMAXQV_VPZ_H)
  .value("SMAXQV_VPZ_S", LIEF::assembly::aarch64::OPCODE::SMAXQV_VPZ_S)
  .value("SMAXV_VPZ_B", LIEF::assembly::aarch64::OPCODE::SMAXV_VPZ_B)
  .value("SMAXV_VPZ_D", LIEF::assembly::aarch64::OPCODE::SMAXV_VPZ_D)
  .value("SMAXV_VPZ_H", LIEF::assembly::aarch64::OPCODE::SMAXV_VPZ_H)
  .value("SMAXV_VPZ_S", LIEF::assembly::aarch64::OPCODE::SMAXV_VPZ_S)
  .value("SMAXVv16i8v", LIEF::assembly::aarch64::OPCODE::SMAXVv16i8v)
  .value("SMAXVv4i16v", LIEF::assembly::aarch64::OPCODE::SMAXVv4i16v)
  .value("SMAXVv4i32v", LIEF::assembly::aarch64::OPCODE::SMAXVv4i32v)
  .value("SMAXVv8i16v", LIEF::assembly::aarch64::OPCODE::SMAXVv8i16v)
  .value("SMAXVv8i8v", LIEF::assembly::aarch64::OPCODE::SMAXVv8i8v)
  .value("SMAXWri", LIEF::assembly::aarch64::OPCODE::SMAXWri)
  .value("SMAXWrr", LIEF::assembly::aarch64::OPCODE::SMAXWrr)
  .value("SMAXXri", LIEF::assembly::aarch64::OPCODE::SMAXXri)
  .value("SMAXXrr", LIEF::assembly::aarch64::OPCODE::SMAXXrr)
  .value("SMAX_VG2_2Z2Z_B", LIEF::assembly::aarch64::OPCODE::SMAX_VG2_2Z2Z_B)
  .value("SMAX_VG2_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::SMAX_VG2_2Z2Z_D)
  .value("SMAX_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::SMAX_VG2_2Z2Z_H)
  .value("SMAX_VG2_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::SMAX_VG2_2Z2Z_S)
  .value("SMAX_VG2_2ZZ_B", LIEF::assembly::aarch64::OPCODE::SMAX_VG2_2ZZ_B)
  .value("SMAX_VG2_2ZZ_D", LIEF::assembly::aarch64::OPCODE::SMAX_VG2_2ZZ_D)
  .value("SMAX_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::SMAX_VG2_2ZZ_H)
  .value("SMAX_VG2_2ZZ_S", LIEF::assembly::aarch64::OPCODE::SMAX_VG2_2ZZ_S)
  .value("SMAX_VG4_4Z4Z_B", LIEF::assembly::aarch64::OPCODE::SMAX_VG4_4Z4Z_B)
  .value("SMAX_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::SMAX_VG4_4Z4Z_D)
  .value("SMAX_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::SMAX_VG4_4Z4Z_H)
  .value("SMAX_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::SMAX_VG4_4Z4Z_S)
  .value("SMAX_VG4_4ZZ_B", LIEF::assembly::aarch64::OPCODE::SMAX_VG4_4ZZ_B)
  .value("SMAX_VG4_4ZZ_D", LIEF::assembly::aarch64::OPCODE::SMAX_VG4_4ZZ_D)
  .value("SMAX_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::SMAX_VG4_4ZZ_H)
  .value("SMAX_VG4_4ZZ_S", LIEF::assembly::aarch64::OPCODE::SMAX_VG4_4ZZ_S)
  .value("SMAX_ZI_B", LIEF::assembly::aarch64::OPCODE::SMAX_ZI_B)
  .value("SMAX_ZI_D", LIEF::assembly::aarch64::OPCODE::SMAX_ZI_D)
  .value("SMAX_ZI_H", LIEF::assembly::aarch64::OPCODE::SMAX_ZI_H)
  .value("SMAX_ZI_S", LIEF::assembly::aarch64::OPCODE::SMAX_ZI_S)
  .value("SMAX_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SMAX_ZPmZ_B)
  .value("SMAX_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SMAX_ZPmZ_D)
  .value("SMAX_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SMAX_ZPmZ_H)
  .value("SMAX_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SMAX_ZPmZ_S)
  .value("SMAXv16i8", LIEF::assembly::aarch64::OPCODE::SMAXv16i8)
  .value("SMAXv2i32", LIEF::assembly::aarch64::OPCODE::SMAXv2i32)
  .value("SMAXv4i16", LIEF::assembly::aarch64::OPCODE::SMAXv4i16)
  .value("SMAXv4i32", LIEF::assembly::aarch64::OPCODE::SMAXv4i32)
  .value("SMAXv8i16", LIEF::assembly::aarch64::OPCODE::SMAXv8i16)
  .value("SMAXv8i8", LIEF::assembly::aarch64::OPCODE::SMAXv8i8)
  .value("SMC", LIEF::assembly::aarch64::OPCODE::SMC)
  .value("SMINP_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SMINP_ZPmZ_B)
  .value("SMINP_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SMINP_ZPmZ_D)
  .value("SMINP_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SMINP_ZPmZ_H)
  .value("SMINP_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SMINP_ZPmZ_S)
  .value("SMINPv16i8", LIEF::assembly::aarch64::OPCODE::SMINPv16i8)
  .value("SMINPv2i32", LIEF::assembly::aarch64::OPCODE::SMINPv2i32)
  .value("SMINPv4i16", LIEF::assembly::aarch64::OPCODE::SMINPv4i16)
  .value("SMINPv4i32", LIEF::assembly::aarch64::OPCODE::SMINPv4i32)
  .value("SMINPv8i16", LIEF::assembly::aarch64::OPCODE::SMINPv8i16)
  .value("SMINPv8i8", LIEF::assembly::aarch64::OPCODE::SMINPv8i8)
  .value("SMINQV_VPZ_B", LIEF::assembly::aarch64::OPCODE::SMINQV_VPZ_B)
  .value("SMINQV_VPZ_D", LIEF::assembly::aarch64::OPCODE::SMINQV_VPZ_D)
  .value("SMINQV_VPZ_H", LIEF::assembly::aarch64::OPCODE::SMINQV_VPZ_H)
  .value("SMINQV_VPZ_S", LIEF::assembly::aarch64::OPCODE::SMINQV_VPZ_S)
  .value("SMINV_VPZ_B", LIEF::assembly::aarch64::OPCODE::SMINV_VPZ_B)
  .value("SMINV_VPZ_D", LIEF::assembly::aarch64::OPCODE::SMINV_VPZ_D)
  .value("SMINV_VPZ_H", LIEF::assembly::aarch64::OPCODE::SMINV_VPZ_H)
  .value("SMINV_VPZ_S", LIEF::assembly::aarch64::OPCODE::SMINV_VPZ_S)
  .value("SMINVv16i8v", LIEF::assembly::aarch64::OPCODE::SMINVv16i8v)
  .value("SMINVv4i16v", LIEF::assembly::aarch64::OPCODE::SMINVv4i16v)
  .value("SMINVv4i32v", LIEF::assembly::aarch64::OPCODE::SMINVv4i32v)
  .value("SMINVv8i16v", LIEF::assembly::aarch64::OPCODE::SMINVv8i16v)
  .value("SMINVv8i8v", LIEF::assembly::aarch64::OPCODE::SMINVv8i8v)
  .value("SMINWri", LIEF::assembly::aarch64::OPCODE::SMINWri)
  .value("SMINWrr", LIEF::assembly::aarch64::OPCODE::SMINWrr)
  .value("SMINXri", LIEF::assembly::aarch64::OPCODE::SMINXri)
  .value("SMINXrr", LIEF::assembly::aarch64::OPCODE::SMINXrr)
  .value("SMIN_VG2_2Z2Z_B", LIEF::assembly::aarch64::OPCODE::SMIN_VG2_2Z2Z_B)
  .value("SMIN_VG2_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::SMIN_VG2_2Z2Z_D)
  .value("SMIN_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::SMIN_VG2_2Z2Z_H)
  .value("SMIN_VG2_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::SMIN_VG2_2Z2Z_S)
  .value("SMIN_VG2_2ZZ_B", LIEF::assembly::aarch64::OPCODE::SMIN_VG2_2ZZ_B)
  .value("SMIN_VG2_2ZZ_D", LIEF::assembly::aarch64::OPCODE::SMIN_VG2_2ZZ_D)
  .value("SMIN_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::SMIN_VG2_2ZZ_H)
  .value("SMIN_VG2_2ZZ_S", LIEF::assembly::aarch64::OPCODE::SMIN_VG2_2ZZ_S)
  .value("SMIN_VG4_4Z4Z_B", LIEF::assembly::aarch64::OPCODE::SMIN_VG4_4Z4Z_B)
  .value("SMIN_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::SMIN_VG4_4Z4Z_D)
  .value("SMIN_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::SMIN_VG4_4Z4Z_H)
  .value("SMIN_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::SMIN_VG4_4Z4Z_S)
  .value("SMIN_VG4_4ZZ_B", LIEF::assembly::aarch64::OPCODE::SMIN_VG4_4ZZ_B)
  .value("SMIN_VG4_4ZZ_D", LIEF::assembly::aarch64::OPCODE::SMIN_VG4_4ZZ_D)
  .value("SMIN_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::SMIN_VG4_4ZZ_H)
  .value("SMIN_VG4_4ZZ_S", LIEF::assembly::aarch64::OPCODE::SMIN_VG4_4ZZ_S)
  .value("SMIN_ZI_B", LIEF::assembly::aarch64::OPCODE::SMIN_ZI_B)
  .value("SMIN_ZI_D", LIEF::assembly::aarch64::OPCODE::SMIN_ZI_D)
  .value("SMIN_ZI_H", LIEF::assembly::aarch64::OPCODE::SMIN_ZI_H)
  .value("SMIN_ZI_S", LIEF::assembly::aarch64::OPCODE::SMIN_ZI_S)
  .value("SMIN_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SMIN_ZPmZ_B)
  .value("SMIN_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SMIN_ZPmZ_D)
  .value("SMIN_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SMIN_ZPmZ_H)
  .value("SMIN_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SMIN_ZPmZ_S)
  .value("SMINv16i8", LIEF::assembly::aarch64::OPCODE::SMINv16i8)
  .value("SMINv2i32", LIEF::assembly::aarch64::OPCODE::SMINv2i32)
  .value("SMINv4i16", LIEF::assembly::aarch64::OPCODE::SMINv4i16)
  .value("SMINv4i32", LIEF::assembly::aarch64::OPCODE::SMINv4i32)
  .value("SMINv8i16", LIEF::assembly::aarch64::OPCODE::SMINv8i16)
  .value("SMINv8i8", LIEF::assembly::aarch64::OPCODE::SMINv8i8)
  .value("SMLALB_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SMLALB_ZZZI_D)
  .value("SMLALB_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SMLALB_ZZZI_S)
  .value("SMLALB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SMLALB_ZZZ_D)
  .value("SMLALB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SMLALB_ZZZ_H)
  .value("SMLALB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SMLALB_ZZZ_S)
  .value("SMLALL_MZZI_BtoS", LIEF::assembly::aarch64::OPCODE::SMLALL_MZZI_BtoS)
  .value("SMLALL_MZZI_HtoD", LIEF::assembly::aarch64::OPCODE::SMLALL_MZZI_HtoD)
  .value("SMLALL_MZZ_BtoS", LIEF::assembly::aarch64::OPCODE::SMLALL_MZZ_BtoS)
  .value("SMLALL_MZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SMLALL_MZZ_HtoD)
  .value("SMLALL_VG2_M2Z2Z_BtoS", LIEF::assembly::aarch64::OPCODE::SMLALL_VG2_M2Z2Z_BtoS)
  .value("SMLALL_VG2_M2Z2Z_HtoD", LIEF::assembly::aarch64::OPCODE::SMLALL_VG2_M2Z2Z_HtoD)
  .value("SMLALL_VG2_M2ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::SMLALL_VG2_M2ZZI_BtoS)
  .value("SMLALL_VG2_M2ZZI_HtoD", LIEF::assembly::aarch64::OPCODE::SMLALL_VG2_M2ZZI_HtoD)
  .value("SMLALL_VG2_M2ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::SMLALL_VG2_M2ZZ_BtoS)
  .value("SMLALL_VG2_M2ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SMLALL_VG2_M2ZZ_HtoD)
  .value("SMLALL_VG4_M4Z4Z_BtoS", LIEF::assembly::aarch64::OPCODE::SMLALL_VG4_M4Z4Z_BtoS)
  .value("SMLALL_VG4_M4Z4Z_HtoD", LIEF::assembly::aarch64::OPCODE::SMLALL_VG4_M4Z4Z_HtoD)
  .value("SMLALL_VG4_M4ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::SMLALL_VG4_M4ZZI_BtoS)
  .value("SMLALL_VG4_M4ZZI_HtoD", LIEF::assembly::aarch64::OPCODE::SMLALL_VG4_M4ZZI_HtoD)
  .value("SMLALL_VG4_M4ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::SMLALL_VG4_M4ZZ_BtoS)
  .value("SMLALL_VG4_M4ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SMLALL_VG4_M4ZZ_HtoD)
  .value("SMLALT_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SMLALT_ZZZI_D)
  .value("SMLALT_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SMLALT_ZZZI_S)
  .value("SMLALT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SMLALT_ZZZ_D)
  .value("SMLALT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SMLALT_ZZZ_H)
  .value("SMLALT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SMLALT_ZZZ_S)
  .value("SMLAL_MZZI_HtoS", LIEF::assembly::aarch64::OPCODE::SMLAL_MZZI_HtoS)
  .value("SMLAL_MZZ_HtoS", LIEF::assembly::aarch64::OPCODE::SMLAL_MZZ_HtoS)
  .value("SMLAL_VG2_M2Z2Z_HtoS", LIEF::assembly::aarch64::OPCODE::SMLAL_VG2_M2Z2Z_HtoS)
  .value("SMLAL_VG2_M2ZZI_S", LIEF::assembly::aarch64::OPCODE::SMLAL_VG2_M2ZZI_S)
  .value("SMLAL_VG2_M2ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::SMLAL_VG2_M2ZZ_HtoS)
  .value("SMLAL_VG4_M4Z4Z_HtoS", LIEF::assembly::aarch64::OPCODE::SMLAL_VG4_M4Z4Z_HtoS)
  .value("SMLAL_VG4_M4ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::SMLAL_VG4_M4ZZI_HtoS)
  .value("SMLAL_VG4_M4ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::SMLAL_VG4_M4ZZ_HtoS)
  .value("SMLALv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::SMLALv16i8_v8i16)
  .value("SMLALv2i32_indexed", LIEF::assembly::aarch64::OPCODE::SMLALv2i32_indexed)
  .value("SMLALv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::SMLALv2i32_v2i64)
  .value("SMLALv4i16_indexed", LIEF::assembly::aarch64::OPCODE::SMLALv4i16_indexed)
  .value("SMLALv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::SMLALv4i16_v4i32)
  .value("SMLALv4i32_indexed", LIEF::assembly::aarch64::OPCODE::SMLALv4i32_indexed)
  .value("SMLALv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::SMLALv4i32_v2i64)
  .value("SMLALv8i16_indexed", LIEF::assembly::aarch64::OPCODE::SMLALv8i16_indexed)
  .value("SMLALv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::SMLALv8i16_v4i32)
  .value("SMLALv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::SMLALv8i8_v8i16)
  .value("SMLSLB_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SMLSLB_ZZZI_D)
  .value("SMLSLB_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SMLSLB_ZZZI_S)
  .value("SMLSLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SMLSLB_ZZZ_D)
  .value("SMLSLB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SMLSLB_ZZZ_H)
  .value("SMLSLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SMLSLB_ZZZ_S)
  .value("SMLSLL_MZZI_BtoS", LIEF::assembly::aarch64::OPCODE::SMLSLL_MZZI_BtoS)
  .value("SMLSLL_MZZI_HtoD", LIEF::assembly::aarch64::OPCODE::SMLSLL_MZZI_HtoD)
  .value("SMLSLL_MZZ_BtoS", LIEF::assembly::aarch64::OPCODE::SMLSLL_MZZ_BtoS)
  .value("SMLSLL_MZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SMLSLL_MZZ_HtoD)
  .value("SMLSLL_VG2_M2Z2Z_BtoS", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG2_M2Z2Z_BtoS)
  .value("SMLSLL_VG2_M2Z2Z_HtoD", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG2_M2Z2Z_HtoD)
  .value("SMLSLL_VG2_M2ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG2_M2ZZI_BtoS);
  opcodes.value("SMLSLL_VG2_M2ZZI_HtoD", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG2_M2ZZI_HtoD)
  .value("SMLSLL_VG2_M2ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG2_M2ZZ_BtoS)
  .value("SMLSLL_VG2_M2ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG2_M2ZZ_HtoD)
  .value("SMLSLL_VG4_M4Z4Z_BtoS", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG4_M4Z4Z_BtoS)
  .value("SMLSLL_VG4_M4Z4Z_HtoD", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG4_M4Z4Z_HtoD)
  .value("SMLSLL_VG4_M4ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG4_M4ZZI_BtoS)
  .value("SMLSLL_VG4_M4ZZI_HtoD", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG4_M4ZZI_HtoD)
  .value("SMLSLL_VG4_M4ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG4_M4ZZ_BtoS)
  .value("SMLSLL_VG4_M4ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SMLSLL_VG4_M4ZZ_HtoD)
  .value("SMLSLT_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SMLSLT_ZZZI_D)
  .value("SMLSLT_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SMLSLT_ZZZI_S)
  .value("SMLSLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SMLSLT_ZZZ_D)
  .value("SMLSLT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SMLSLT_ZZZ_H)
  .value("SMLSLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SMLSLT_ZZZ_S)
  .value("SMLSL_MZZI_HtoS", LIEF::assembly::aarch64::OPCODE::SMLSL_MZZI_HtoS)
  .value("SMLSL_MZZ_HtoS", LIEF::assembly::aarch64::OPCODE::SMLSL_MZZ_HtoS)
  .value("SMLSL_VG2_M2Z2Z_HtoS", LIEF::assembly::aarch64::OPCODE::SMLSL_VG2_M2Z2Z_HtoS)
  .value("SMLSL_VG2_M2ZZI_S", LIEF::assembly::aarch64::OPCODE::SMLSL_VG2_M2ZZI_S)
  .value("SMLSL_VG2_M2ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::SMLSL_VG2_M2ZZ_HtoS)
  .value("SMLSL_VG4_M4Z4Z_HtoS", LIEF::assembly::aarch64::OPCODE::SMLSL_VG4_M4Z4Z_HtoS)
  .value("SMLSL_VG4_M4ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::SMLSL_VG4_M4ZZI_HtoS)
  .value("SMLSL_VG4_M4ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::SMLSL_VG4_M4ZZ_HtoS)
  .value("SMLSLv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::SMLSLv16i8_v8i16)
  .value("SMLSLv2i32_indexed", LIEF::assembly::aarch64::OPCODE::SMLSLv2i32_indexed)
  .value("SMLSLv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::SMLSLv2i32_v2i64)
  .value("SMLSLv4i16_indexed", LIEF::assembly::aarch64::OPCODE::SMLSLv4i16_indexed)
  .value("SMLSLv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::SMLSLv4i16_v4i32)
  .value("SMLSLv4i32_indexed", LIEF::assembly::aarch64::OPCODE::SMLSLv4i32_indexed)
  .value("SMLSLv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::SMLSLv4i32_v2i64)
  .value("SMLSLv8i16_indexed", LIEF::assembly::aarch64::OPCODE::SMLSLv8i16_indexed)
  .value("SMLSLv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::SMLSLv8i16_v4i32)
  .value("SMLSLv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::SMLSLv8i8_v8i16)
  .value("SMMLA", LIEF::assembly::aarch64::OPCODE::SMMLA)
  .value("SMMLA_ZZZ", LIEF::assembly::aarch64::OPCODE::SMMLA_ZZZ)
  .value("SMOP4A_M2Z2Z_BToS", LIEF::assembly::aarch64::OPCODE::SMOP4A_M2Z2Z_BToS)
  .value("SMOP4A_M2Z2Z_HToS", LIEF::assembly::aarch64::OPCODE::SMOP4A_M2Z2Z_HToS)
  .value("SMOP4A_M2Z2Z_HtoD", LIEF::assembly::aarch64::OPCODE::SMOP4A_M2Z2Z_HtoD)
  .value("SMOP4A_M2ZZ_BToS", LIEF::assembly::aarch64::OPCODE::SMOP4A_M2ZZ_BToS)
  .value("SMOP4A_M2ZZ_HToS", LIEF::assembly::aarch64::OPCODE::SMOP4A_M2ZZ_HToS)
  .value("SMOP4A_M2ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SMOP4A_M2ZZ_HtoD)
  .value("SMOP4A_MZ2Z_BToS", LIEF::assembly::aarch64::OPCODE::SMOP4A_MZ2Z_BToS)
  .value("SMOP4A_MZ2Z_HToS", LIEF::assembly::aarch64::OPCODE::SMOP4A_MZ2Z_HToS)
  .value("SMOP4A_MZ2Z_HtoD", LIEF::assembly::aarch64::OPCODE::SMOP4A_MZ2Z_HtoD)
  .value("SMOP4A_MZZ_BToS", LIEF::assembly::aarch64::OPCODE::SMOP4A_MZZ_BToS)
  .value("SMOP4A_MZZ_HToS", LIEF::assembly::aarch64::OPCODE::SMOP4A_MZZ_HToS)
  .value("SMOP4A_MZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SMOP4A_MZZ_HtoD)
  .value("SMOP4S_M2Z2Z_BToS", LIEF::assembly::aarch64::OPCODE::SMOP4S_M2Z2Z_BToS)
  .value("SMOP4S_M2Z2Z_HToS", LIEF::assembly::aarch64::OPCODE::SMOP4S_M2Z2Z_HToS)
  .value("SMOP4S_M2Z2Z_HtoD", LIEF::assembly::aarch64::OPCODE::SMOP4S_M2Z2Z_HtoD)
  .value("SMOP4S_M2ZZ_BToS", LIEF::assembly::aarch64::OPCODE::SMOP4S_M2ZZ_BToS)
  .value("SMOP4S_M2ZZ_HToS", LIEF::assembly::aarch64::OPCODE::SMOP4S_M2ZZ_HToS)
  .value("SMOP4S_M2ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SMOP4S_M2ZZ_HtoD)
  .value("SMOP4S_MZ2Z_BToS", LIEF::assembly::aarch64::OPCODE::SMOP4S_MZ2Z_BToS)
  .value("SMOP4S_MZ2Z_HToS", LIEF::assembly::aarch64::OPCODE::SMOP4S_MZ2Z_HToS)
  .value("SMOP4S_MZ2Z_HtoD", LIEF::assembly::aarch64::OPCODE::SMOP4S_MZ2Z_HtoD)
  .value("SMOP4S_MZZ_BToS", LIEF::assembly::aarch64::OPCODE::SMOP4S_MZZ_BToS)
  .value("SMOP4S_MZZ_HToS", LIEF::assembly::aarch64::OPCODE::SMOP4S_MZZ_HToS)
  .value("SMOP4S_MZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SMOP4S_MZZ_HtoD)
  .value("SMOPA_MPPZZ_D", LIEF::assembly::aarch64::OPCODE::SMOPA_MPPZZ_D)
  .value("SMOPA_MPPZZ_HtoS", LIEF::assembly::aarch64::OPCODE::SMOPA_MPPZZ_HtoS)
  .value("SMOPA_MPPZZ_S", LIEF::assembly::aarch64::OPCODE::SMOPA_MPPZZ_S)
  .value("SMOPS_MPPZZ_D", LIEF::assembly::aarch64::OPCODE::SMOPS_MPPZZ_D)
  .value("SMOPS_MPPZZ_HtoS", LIEF::assembly::aarch64::OPCODE::SMOPS_MPPZZ_HtoS)
  .value("SMOPS_MPPZZ_S", LIEF::assembly::aarch64::OPCODE::SMOPS_MPPZZ_S)
  .value("SMOVvi16to32", LIEF::assembly::aarch64::OPCODE::SMOVvi16to32)
  .value("SMOVvi16to32_idx0", LIEF::assembly::aarch64::OPCODE::SMOVvi16to32_idx0)
  .value("SMOVvi16to64", LIEF::assembly::aarch64::OPCODE::SMOVvi16to64)
  .value("SMOVvi16to64_idx0", LIEF::assembly::aarch64::OPCODE::SMOVvi16to64_idx0)
  .value("SMOVvi32to64", LIEF::assembly::aarch64::OPCODE::SMOVvi32to64)
  .value("SMOVvi32to64_idx0", LIEF::assembly::aarch64::OPCODE::SMOVvi32to64_idx0)
  .value("SMOVvi8to32", LIEF::assembly::aarch64::OPCODE::SMOVvi8to32)
  .value("SMOVvi8to32_idx0", LIEF::assembly::aarch64::OPCODE::SMOVvi8to32_idx0)
  .value("SMOVvi8to64", LIEF::assembly::aarch64::OPCODE::SMOVvi8to64)
  .value("SMOVvi8to64_idx0", LIEF::assembly::aarch64::OPCODE::SMOVvi8to64_idx0)
  .value("SMSUBLrrr", LIEF::assembly::aarch64::OPCODE::SMSUBLrrr)
  .value("SMULH_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SMULH_ZPmZ_B)
  .value("SMULH_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SMULH_ZPmZ_D)
  .value("SMULH_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SMULH_ZPmZ_H)
  .value("SMULH_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SMULH_ZPmZ_S)
  .value("SMULH_ZZZ_B", LIEF::assembly::aarch64::OPCODE::SMULH_ZZZ_B)
  .value("SMULH_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SMULH_ZZZ_D)
  .value("SMULH_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SMULH_ZZZ_H)
  .value("SMULH_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SMULH_ZZZ_S)
  .value("SMULHrr", LIEF::assembly::aarch64::OPCODE::SMULHrr)
  .value("SMULLB_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SMULLB_ZZZI_D)
  .value("SMULLB_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SMULLB_ZZZI_S)
  .value("SMULLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SMULLB_ZZZ_D)
  .value("SMULLB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SMULLB_ZZZ_H)
  .value("SMULLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SMULLB_ZZZ_S)
  .value("SMULLT_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SMULLT_ZZZI_D)
  .value("SMULLT_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SMULLT_ZZZI_S)
  .value("SMULLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SMULLT_ZZZ_D)
  .value("SMULLT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SMULLT_ZZZ_H)
  .value("SMULLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SMULLT_ZZZ_S)
  .value("SMULLv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::SMULLv16i8_v8i16)
  .value("SMULLv2i32_indexed", LIEF::assembly::aarch64::OPCODE::SMULLv2i32_indexed)
  .value("SMULLv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::SMULLv2i32_v2i64)
  .value("SMULLv4i16_indexed", LIEF::assembly::aarch64::OPCODE::SMULLv4i16_indexed)
  .value("SMULLv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::SMULLv4i16_v4i32)
  .value("SMULLv4i32_indexed", LIEF::assembly::aarch64::OPCODE::SMULLv4i32_indexed)
  .value("SMULLv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::SMULLv4i32_v2i64)
  .value("SMULLv8i16_indexed", LIEF::assembly::aarch64::OPCODE::SMULLv8i16_indexed)
  .value("SMULLv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::SMULLv8i16_v4i32)
  .value("SMULLv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::SMULLv8i8_v8i16)
  .value("SPLICE_ZPZZ_B", LIEF::assembly::aarch64::OPCODE::SPLICE_ZPZZ_B)
  .value("SPLICE_ZPZZ_D", LIEF::assembly::aarch64::OPCODE::SPLICE_ZPZZ_D)
  .value("SPLICE_ZPZZ_H", LIEF::assembly::aarch64::OPCODE::SPLICE_ZPZZ_H)
  .value("SPLICE_ZPZZ_S", LIEF::assembly::aarch64::OPCODE::SPLICE_ZPZZ_S)
  .value("SPLICE_ZPZ_B", LIEF::assembly::aarch64::OPCODE::SPLICE_ZPZ_B)
  .value("SPLICE_ZPZ_D", LIEF::assembly::aarch64::OPCODE::SPLICE_ZPZ_D)
  .value("SPLICE_ZPZ_H", LIEF::assembly::aarch64::OPCODE::SPLICE_ZPZ_H)
  .value("SPLICE_ZPZ_S", LIEF::assembly::aarch64::OPCODE::SPLICE_ZPZ_S)
  .value("SQABS_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SQABS_ZPmZ_B)
  .value("SQABS_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SQABS_ZPmZ_D)
  .value("SQABS_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SQABS_ZPmZ_H)
  .value("SQABS_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SQABS_ZPmZ_S)
  .value("SQABS_ZPzZ_B", LIEF::assembly::aarch64::OPCODE::SQABS_ZPzZ_B)
  .value("SQABS_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::SQABS_ZPzZ_D)
  .value("SQABS_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::SQABS_ZPzZ_H)
  .value("SQABS_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::SQABS_ZPzZ_S)
  .value("SQABSv16i8", LIEF::assembly::aarch64::OPCODE::SQABSv16i8)
  .value("SQABSv1i16", LIEF::assembly::aarch64::OPCODE::SQABSv1i16)
  .value("SQABSv1i32", LIEF::assembly::aarch64::OPCODE::SQABSv1i32)
  .value("SQABSv1i64", LIEF::assembly::aarch64::OPCODE::SQABSv1i64)
  .value("SQABSv1i8", LIEF::assembly::aarch64::OPCODE::SQABSv1i8)
  .value("SQABSv2i32", LIEF::assembly::aarch64::OPCODE::SQABSv2i32)
  .value("SQABSv2i64", LIEF::assembly::aarch64::OPCODE::SQABSv2i64)
  .value("SQABSv4i16", LIEF::assembly::aarch64::OPCODE::SQABSv4i16)
  .value("SQABSv4i32", LIEF::assembly::aarch64::OPCODE::SQABSv4i32)
  .value("SQABSv8i16", LIEF::assembly::aarch64::OPCODE::SQABSv8i16)
  .value("SQABSv8i8", LIEF::assembly::aarch64::OPCODE::SQABSv8i8)
  .value("SQADD_ZI_B", LIEF::assembly::aarch64::OPCODE::SQADD_ZI_B)
  .value("SQADD_ZI_D", LIEF::assembly::aarch64::OPCODE::SQADD_ZI_D)
  .value("SQADD_ZI_H", LIEF::assembly::aarch64::OPCODE::SQADD_ZI_H)
  .value("SQADD_ZI_S", LIEF::assembly::aarch64::OPCODE::SQADD_ZI_S)
  .value("SQADD_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SQADD_ZPmZ_B)
  .value("SQADD_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SQADD_ZPmZ_D)
  .value("SQADD_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SQADD_ZPmZ_H)
  .value("SQADD_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SQADD_ZPmZ_S)
  .value("SQADD_ZZZ_B", LIEF::assembly::aarch64::OPCODE::SQADD_ZZZ_B)
  .value("SQADD_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQADD_ZZZ_D)
  .value("SQADD_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQADD_ZZZ_H)
  .value("SQADD_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQADD_ZZZ_S)
  .value("SQADDv16i8", LIEF::assembly::aarch64::OPCODE::SQADDv16i8)
  .value("SQADDv1i16", LIEF::assembly::aarch64::OPCODE::SQADDv1i16)
  .value("SQADDv1i32", LIEF::assembly::aarch64::OPCODE::SQADDv1i32)
  .value("SQADDv1i64", LIEF::assembly::aarch64::OPCODE::SQADDv1i64)
  .value("SQADDv1i8", LIEF::assembly::aarch64::OPCODE::SQADDv1i8)
  .value("SQADDv2i32", LIEF::assembly::aarch64::OPCODE::SQADDv2i32)
  .value("SQADDv2i64", LIEF::assembly::aarch64::OPCODE::SQADDv2i64)
  .value("SQADDv4i16", LIEF::assembly::aarch64::OPCODE::SQADDv4i16)
  .value("SQADDv4i32", LIEF::assembly::aarch64::OPCODE::SQADDv4i32)
  .value("SQADDv8i16", LIEF::assembly::aarch64::OPCODE::SQADDv8i16)
  .value("SQADDv8i8", LIEF::assembly::aarch64::OPCODE::SQADDv8i8)
  .value("SQCADD_ZZI_B", LIEF::assembly::aarch64::OPCODE::SQCADD_ZZI_B)
  .value("SQCADD_ZZI_D", LIEF::assembly::aarch64::OPCODE::SQCADD_ZZI_D)
  .value("SQCADD_ZZI_H", LIEF::assembly::aarch64::OPCODE::SQCADD_ZZI_H)
  .value("SQCADD_ZZI_S", LIEF::assembly::aarch64::OPCODE::SQCADD_ZZI_S)
  .value("SQCVTN_Z2Z_StoH", LIEF::assembly::aarch64::OPCODE::SQCVTN_Z2Z_StoH)
  .value("SQCVTN_Z4Z_DtoH", LIEF::assembly::aarch64::OPCODE::SQCVTN_Z4Z_DtoH)
  .value("SQCVTN_Z4Z_StoB", LIEF::assembly::aarch64::OPCODE::SQCVTN_Z4Z_StoB)
  .value("SQCVTUN_Z2Z_StoH", LIEF::assembly::aarch64::OPCODE::SQCVTUN_Z2Z_StoH)
  .value("SQCVTUN_Z4Z_DtoH", LIEF::assembly::aarch64::OPCODE::SQCVTUN_Z4Z_DtoH)
  .value("SQCVTUN_Z4Z_StoB", LIEF::assembly::aarch64::OPCODE::SQCVTUN_Z4Z_StoB)
  .value("SQCVTU_Z2Z_StoH", LIEF::assembly::aarch64::OPCODE::SQCVTU_Z2Z_StoH)
  .value("SQCVTU_Z4Z_DtoH", LIEF::assembly::aarch64::OPCODE::SQCVTU_Z4Z_DtoH)
  .value("SQCVTU_Z4Z_StoB", LIEF::assembly::aarch64::OPCODE::SQCVTU_Z4Z_StoB)
  .value("SQCVT_Z2Z_StoH", LIEF::assembly::aarch64::OPCODE::SQCVT_Z2Z_StoH)
  .value("SQCVT_Z4Z_DtoH", LIEF::assembly::aarch64::OPCODE::SQCVT_Z4Z_DtoH)
  .value("SQCVT_Z4Z_StoB", LIEF::assembly::aarch64::OPCODE::SQCVT_Z4Z_StoB)
  .value("SQDECB_XPiI", LIEF::assembly::aarch64::OPCODE::SQDECB_XPiI)
  .value("SQDECB_XPiWdI", LIEF::assembly::aarch64::OPCODE::SQDECB_XPiWdI)
  .value("SQDECD_XPiI", LIEF::assembly::aarch64::OPCODE::SQDECD_XPiI)
  .value("SQDECD_XPiWdI", LIEF::assembly::aarch64::OPCODE::SQDECD_XPiWdI)
  .value("SQDECD_ZPiI", LIEF::assembly::aarch64::OPCODE::SQDECD_ZPiI)
  .value("SQDECH_XPiI", LIEF::assembly::aarch64::OPCODE::SQDECH_XPiI)
  .value("SQDECH_XPiWdI", LIEF::assembly::aarch64::OPCODE::SQDECH_XPiWdI)
  .value("SQDECH_ZPiI", LIEF::assembly::aarch64::OPCODE::SQDECH_ZPiI)
  .value("SQDECP_XPWd_B", LIEF::assembly::aarch64::OPCODE::SQDECP_XPWd_B)
  .value("SQDECP_XPWd_D", LIEF::assembly::aarch64::OPCODE::SQDECP_XPWd_D)
  .value("SQDECP_XPWd_H", LIEF::assembly::aarch64::OPCODE::SQDECP_XPWd_H)
  .value("SQDECP_XPWd_S", LIEF::assembly::aarch64::OPCODE::SQDECP_XPWd_S)
  .value("SQDECP_XP_B", LIEF::assembly::aarch64::OPCODE::SQDECP_XP_B)
  .value("SQDECP_XP_D", LIEF::assembly::aarch64::OPCODE::SQDECP_XP_D)
  .value("SQDECP_XP_H", LIEF::assembly::aarch64::OPCODE::SQDECP_XP_H)
  .value("SQDECP_XP_S", LIEF::assembly::aarch64::OPCODE::SQDECP_XP_S)
  .value("SQDECP_ZP_D", LIEF::assembly::aarch64::OPCODE::SQDECP_ZP_D)
  .value("SQDECP_ZP_H", LIEF::assembly::aarch64::OPCODE::SQDECP_ZP_H)
  .value("SQDECP_ZP_S", LIEF::assembly::aarch64::OPCODE::SQDECP_ZP_S)
  .value("SQDECW_XPiI", LIEF::assembly::aarch64::OPCODE::SQDECW_XPiI)
  .value("SQDECW_XPiWdI", LIEF::assembly::aarch64::OPCODE::SQDECW_XPiWdI)
  .value("SQDECW_ZPiI", LIEF::assembly::aarch64::OPCODE::SQDECW_ZPiI)
  .value("SQDMLALBT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQDMLALBT_ZZZ_D)
  .value("SQDMLALBT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQDMLALBT_ZZZ_H)
  .value("SQDMLALBT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQDMLALBT_ZZZ_S)
  .value("SQDMLALB_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SQDMLALB_ZZZI_D)
  .value("SQDMLALB_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SQDMLALB_ZZZI_S)
  .value("SQDMLALB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQDMLALB_ZZZ_D)
  .value("SQDMLALB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQDMLALB_ZZZ_H)
  .value("SQDMLALB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQDMLALB_ZZZ_S)
  .value("SQDMLALT_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SQDMLALT_ZZZI_D)
  .value("SQDMLALT_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SQDMLALT_ZZZI_S)
  .value("SQDMLALT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQDMLALT_ZZZ_D)
  .value("SQDMLALT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQDMLALT_ZZZ_H)
  .value("SQDMLALT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQDMLALT_ZZZ_S)
  .value("SQDMLALi16", LIEF::assembly::aarch64::OPCODE::SQDMLALi16)
  .value("SQDMLALi32", LIEF::assembly::aarch64::OPCODE::SQDMLALi32)
  .value("SQDMLALv1i32_indexed", LIEF::assembly::aarch64::OPCODE::SQDMLALv1i32_indexed)
  .value("SQDMLALv1i64_indexed", LIEF::assembly::aarch64::OPCODE::SQDMLALv1i64_indexed)
  .value("SQDMLALv2i32_indexed", LIEF::assembly::aarch64::OPCODE::SQDMLALv2i32_indexed)
  .value("SQDMLALv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::SQDMLALv2i32_v2i64)
  .value("SQDMLALv4i16_indexed", LIEF::assembly::aarch64::OPCODE::SQDMLALv4i16_indexed)
  .value("SQDMLALv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::SQDMLALv4i16_v4i32)
  .value("SQDMLALv4i32_indexed", LIEF::assembly::aarch64::OPCODE::SQDMLALv4i32_indexed)
  .value("SQDMLALv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::SQDMLALv4i32_v2i64)
  .value("SQDMLALv8i16_indexed", LIEF::assembly::aarch64::OPCODE::SQDMLALv8i16_indexed)
  .value("SQDMLALv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::SQDMLALv8i16_v4i32)
  .value("SQDMLSLBT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQDMLSLBT_ZZZ_D)
  .value("SQDMLSLBT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQDMLSLBT_ZZZ_H)
  .value("SQDMLSLBT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQDMLSLBT_ZZZ_S)
  .value("SQDMLSLB_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SQDMLSLB_ZZZI_D)
  .value("SQDMLSLB_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SQDMLSLB_ZZZI_S)
  .value("SQDMLSLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQDMLSLB_ZZZ_D)
  .value("SQDMLSLB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQDMLSLB_ZZZ_H)
  .value("SQDMLSLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQDMLSLB_ZZZ_S)
  .value("SQDMLSLT_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SQDMLSLT_ZZZI_D)
  .value("SQDMLSLT_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SQDMLSLT_ZZZI_S)
  .value("SQDMLSLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQDMLSLT_ZZZ_D)
  .value("SQDMLSLT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQDMLSLT_ZZZ_H)
  .value("SQDMLSLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQDMLSLT_ZZZ_S)
  .value("SQDMLSLi16", LIEF::assembly::aarch64::OPCODE::SQDMLSLi16)
  .value("SQDMLSLi32", LIEF::assembly::aarch64::OPCODE::SQDMLSLi32)
  .value("SQDMLSLv1i32_indexed", LIEF::assembly::aarch64::OPCODE::SQDMLSLv1i32_indexed)
  .value("SQDMLSLv1i64_indexed", LIEF::assembly::aarch64::OPCODE::SQDMLSLv1i64_indexed)
  .value("SQDMLSLv2i32_indexed", LIEF::assembly::aarch64::OPCODE::SQDMLSLv2i32_indexed)
  .value("SQDMLSLv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::SQDMLSLv2i32_v2i64)
  .value("SQDMLSLv4i16_indexed", LIEF::assembly::aarch64::OPCODE::SQDMLSLv4i16_indexed)
  .value("SQDMLSLv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::SQDMLSLv4i16_v4i32)
  .value("SQDMLSLv4i32_indexed", LIEF::assembly::aarch64::OPCODE::SQDMLSLv4i32_indexed)
  .value("SQDMLSLv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::SQDMLSLv4i32_v2i64)
  .value("SQDMLSLv8i16_indexed", LIEF::assembly::aarch64::OPCODE::SQDMLSLv8i16_indexed)
  .value("SQDMLSLv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::SQDMLSLv8i16_v4i32)
  .value("SQDMULH_VG2_2Z2Z_B", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG2_2Z2Z_B)
  .value("SQDMULH_VG2_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG2_2Z2Z_D)
  .value("SQDMULH_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG2_2Z2Z_H)
  .value("SQDMULH_VG2_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG2_2Z2Z_S)
  .value("SQDMULH_VG2_2ZZ_B", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG2_2ZZ_B)
  .value("SQDMULH_VG2_2ZZ_D", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG2_2ZZ_D)
  .value("SQDMULH_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG2_2ZZ_H)
  .value("SQDMULH_VG2_2ZZ_S", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG2_2ZZ_S)
  .value("SQDMULH_VG4_4Z4Z_B", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG4_4Z4Z_B)
  .value("SQDMULH_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG4_4Z4Z_D)
  .value("SQDMULH_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG4_4Z4Z_H)
  .value("SQDMULH_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG4_4Z4Z_S)
  .value("SQDMULH_VG4_4ZZ_B", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG4_4ZZ_B)
  .value("SQDMULH_VG4_4ZZ_D", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG4_4ZZ_D)
  .value("SQDMULH_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG4_4ZZ_H)
  .value("SQDMULH_VG4_4ZZ_S", LIEF::assembly::aarch64::OPCODE::SQDMULH_VG4_4ZZ_S)
  .value("SQDMULH_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SQDMULH_ZZZI_D)
  .value("SQDMULH_ZZZI_H", LIEF::assembly::aarch64::OPCODE::SQDMULH_ZZZI_H)
  .value("SQDMULH_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SQDMULH_ZZZI_S)
  .value("SQDMULH_ZZZ_B", LIEF::assembly::aarch64::OPCODE::SQDMULH_ZZZ_B)
  .value("SQDMULH_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQDMULH_ZZZ_D)
  .value("SQDMULH_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQDMULH_ZZZ_H)
  .value("SQDMULH_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQDMULH_ZZZ_S)
  .value("SQDMULHv1i16", LIEF::assembly::aarch64::OPCODE::SQDMULHv1i16)
  .value("SQDMULHv1i16_indexed", LIEF::assembly::aarch64::OPCODE::SQDMULHv1i16_indexed)
  .value("SQDMULHv1i32", LIEF::assembly::aarch64::OPCODE::SQDMULHv1i32)
  .value("SQDMULHv1i32_indexed", LIEF::assembly::aarch64::OPCODE::SQDMULHv1i32_indexed)
  .value("SQDMULHv2i32", LIEF::assembly::aarch64::OPCODE::SQDMULHv2i32)
  .value("SQDMULHv2i32_indexed", LIEF::assembly::aarch64::OPCODE::SQDMULHv2i32_indexed)
  .value("SQDMULHv4i16", LIEF::assembly::aarch64::OPCODE::SQDMULHv4i16)
  .value("SQDMULHv4i16_indexed", LIEF::assembly::aarch64::OPCODE::SQDMULHv4i16_indexed)
  .value("SQDMULHv4i32", LIEF::assembly::aarch64::OPCODE::SQDMULHv4i32)
  .value("SQDMULHv4i32_indexed", LIEF::assembly::aarch64::OPCODE::SQDMULHv4i32_indexed)
  .value("SQDMULHv8i16", LIEF::assembly::aarch64::OPCODE::SQDMULHv8i16)
  .value("SQDMULHv8i16_indexed", LIEF::assembly::aarch64::OPCODE::SQDMULHv8i16_indexed)
  .value("SQDMULLB_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SQDMULLB_ZZZI_D)
  .value("SQDMULLB_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SQDMULLB_ZZZI_S)
  .value("SQDMULLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQDMULLB_ZZZ_D)
  .value("SQDMULLB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQDMULLB_ZZZ_H)
  .value("SQDMULLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQDMULLB_ZZZ_S)
  .value("SQDMULLT_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SQDMULLT_ZZZI_D)
  .value("SQDMULLT_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SQDMULLT_ZZZI_S)
  .value("SQDMULLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQDMULLT_ZZZ_D)
  .value("SQDMULLT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQDMULLT_ZZZ_H)
  .value("SQDMULLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQDMULLT_ZZZ_S)
  .value("SQDMULLi16", LIEF::assembly::aarch64::OPCODE::SQDMULLi16)
  .value("SQDMULLi32", LIEF::assembly::aarch64::OPCODE::SQDMULLi32)
  .value("SQDMULLv1i32_indexed", LIEF::assembly::aarch64::OPCODE::SQDMULLv1i32_indexed)
  .value("SQDMULLv1i64_indexed", LIEF::assembly::aarch64::OPCODE::SQDMULLv1i64_indexed)
  .value("SQDMULLv2i32_indexed", LIEF::assembly::aarch64::OPCODE::SQDMULLv2i32_indexed)
  .value("SQDMULLv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::SQDMULLv2i32_v2i64)
  .value("SQDMULLv4i16_indexed", LIEF::assembly::aarch64::OPCODE::SQDMULLv4i16_indexed)
  .value("SQDMULLv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::SQDMULLv4i16_v4i32)
  .value("SQDMULLv4i32_indexed", LIEF::assembly::aarch64::OPCODE::SQDMULLv4i32_indexed)
  .value("SQDMULLv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::SQDMULLv4i32_v2i64)
  .value("SQDMULLv8i16_indexed", LIEF::assembly::aarch64::OPCODE::SQDMULLv8i16_indexed)
  .value("SQDMULLv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::SQDMULLv8i16_v4i32)
  .value("SQINCB_XPiI", LIEF::assembly::aarch64::OPCODE::SQINCB_XPiI);
  opcodes.value("SQINCB_XPiWdI", LIEF::assembly::aarch64::OPCODE::SQINCB_XPiWdI)
  .value("SQINCD_XPiI", LIEF::assembly::aarch64::OPCODE::SQINCD_XPiI)
  .value("SQINCD_XPiWdI", LIEF::assembly::aarch64::OPCODE::SQINCD_XPiWdI)
  .value("SQINCD_ZPiI", LIEF::assembly::aarch64::OPCODE::SQINCD_ZPiI)
  .value("SQINCH_XPiI", LIEF::assembly::aarch64::OPCODE::SQINCH_XPiI)
  .value("SQINCH_XPiWdI", LIEF::assembly::aarch64::OPCODE::SQINCH_XPiWdI)
  .value("SQINCH_ZPiI", LIEF::assembly::aarch64::OPCODE::SQINCH_ZPiI)
  .value("SQINCP_XPWd_B", LIEF::assembly::aarch64::OPCODE::SQINCP_XPWd_B)
  .value("SQINCP_XPWd_D", LIEF::assembly::aarch64::OPCODE::SQINCP_XPWd_D)
  .value("SQINCP_XPWd_H", LIEF::assembly::aarch64::OPCODE::SQINCP_XPWd_H)
  .value("SQINCP_XPWd_S", LIEF::assembly::aarch64::OPCODE::SQINCP_XPWd_S)
  .value("SQINCP_XP_B", LIEF::assembly::aarch64::OPCODE::SQINCP_XP_B)
  .value("SQINCP_XP_D", LIEF::assembly::aarch64::OPCODE::SQINCP_XP_D)
  .value("SQINCP_XP_H", LIEF::assembly::aarch64::OPCODE::SQINCP_XP_H)
  .value("SQINCP_XP_S", LIEF::assembly::aarch64::OPCODE::SQINCP_XP_S)
  .value("SQINCP_ZP_D", LIEF::assembly::aarch64::OPCODE::SQINCP_ZP_D)
  .value("SQINCP_ZP_H", LIEF::assembly::aarch64::OPCODE::SQINCP_ZP_H)
  .value("SQINCP_ZP_S", LIEF::assembly::aarch64::OPCODE::SQINCP_ZP_S)
  .value("SQINCW_XPiI", LIEF::assembly::aarch64::OPCODE::SQINCW_XPiI)
  .value("SQINCW_XPiWdI", LIEF::assembly::aarch64::OPCODE::SQINCW_XPiWdI)
  .value("SQINCW_ZPiI", LIEF::assembly::aarch64::OPCODE::SQINCW_ZPiI)
  .value("SQNEG_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SQNEG_ZPmZ_B)
  .value("SQNEG_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SQNEG_ZPmZ_D)
  .value("SQNEG_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SQNEG_ZPmZ_H)
  .value("SQNEG_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SQNEG_ZPmZ_S)
  .value("SQNEG_ZPzZ_B", LIEF::assembly::aarch64::OPCODE::SQNEG_ZPzZ_B)
  .value("SQNEG_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::SQNEG_ZPzZ_D)
  .value("SQNEG_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::SQNEG_ZPzZ_H)
  .value("SQNEG_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::SQNEG_ZPzZ_S)
  .value("SQNEGv16i8", LIEF::assembly::aarch64::OPCODE::SQNEGv16i8)
  .value("SQNEGv1i16", LIEF::assembly::aarch64::OPCODE::SQNEGv1i16)
  .value("SQNEGv1i32", LIEF::assembly::aarch64::OPCODE::SQNEGv1i32)
  .value("SQNEGv1i64", LIEF::assembly::aarch64::OPCODE::SQNEGv1i64)
  .value("SQNEGv1i8", LIEF::assembly::aarch64::OPCODE::SQNEGv1i8)
  .value("SQNEGv2i32", LIEF::assembly::aarch64::OPCODE::SQNEGv2i32)
  .value("SQNEGv2i64", LIEF::assembly::aarch64::OPCODE::SQNEGv2i64)
  .value("SQNEGv4i16", LIEF::assembly::aarch64::OPCODE::SQNEGv4i16)
  .value("SQNEGv4i32", LIEF::assembly::aarch64::OPCODE::SQNEGv4i32)
  .value("SQNEGv8i16", LIEF::assembly::aarch64::OPCODE::SQNEGv8i16)
  .value("SQNEGv8i8", LIEF::assembly::aarch64::OPCODE::SQNEGv8i8)
  .value("SQRDCMLAH_ZZZI_H", LIEF::assembly::aarch64::OPCODE::SQRDCMLAH_ZZZI_H)
  .value("SQRDCMLAH_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SQRDCMLAH_ZZZI_S)
  .value("SQRDCMLAH_ZZZ_B", LIEF::assembly::aarch64::OPCODE::SQRDCMLAH_ZZZ_B)
  .value("SQRDCMLAH_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQRDCMLAH_ZZZ_D)
  .value("SQRDCMLAH_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQRDCMLAH_ZZZ_H)
  .value("SQRDCMLAH_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQRDCMLAH_ZZZ_S)
  .value("SQRDMLAH_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SQRDMLAH_ZZZI_D)
  .value("SQRDMLAH_ZZZI_H", LIEF::assembly::aarch64::OPCODE::SQRDMLAH_ZZZI_H)
  .value("SQRDMLAH_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SQRDMLAH_ZZZI_S)
  .value("SQRDMLAH_ZZZ_B", LIEF::assembly::aarch64::OPCODE::SQRDMLAH_ZZZ_B)
  .value("SQRDMLAH_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQRDMLAH_ZZZ_D)
  .value("SQRDMLAH_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQRDMLAH_ZZZ_H)
  .value("SQRDMLAH_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQRDMLAH_ZZZ_S)
  .value("SQRDMLAHv1i16", LIEF::assembly::aarch64::OPCODE::SQRDMLAHv1i16)
  .value("SQRDMLAHv1i16_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMLAHv1i16_indexed)
  .value("SQRDMLAHv1i32", LIEF::assembly::aarch64::OPCODE::SQRDMLAHv1i32)
  .value("SQRDMLAHv1i32_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMLAHv1i32_indexed)
  .value("SQRDMLAHv2i32", LIEF::assembly::aarch64::OPCODE::SQRDMLAHv2i32)
  .value("SQRDMLAHv2i32_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMLAHv2i32_indexed)
  .value("SQRDMLAHv4i16", LIEF::assembly::aarch64::OPCODE::SQRDMLAHv4i16)
  .value("SQRDMLAHv4i16_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMLAHv4i16_indexed)
  .value("SQRDMLAHv4i32", LIEF::assembly::aarch64::OPCODE::SQRDMLAHv4i32)
  .value("SQRDMLAHv4i32_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMLAHv4i32_indexed)
  .value("SQRDMLAHv8i16", LIEF::assembly::aarch64::OPCODE::SQRDMLAHv8i16)
  .value("SQRDMLAHv8i16_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMLAHv8i16_indexed)
  .value("SQRDMLSH_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SQRDMLSH_ZZZI_D)
  .value("SQRDMLSH_ZZZI_H", LIEF::assembly::aarch64::OPCODE::SQRDMLSH_ZZZI_H)
  .value("SQRDMLSH_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SQRDMLSH_ZZZI_S)
  .value("SQRDMLSH_ZZZ_B", LIEF::assembly::aarch64::OPCODE::SQRDMLSH_ZZZ_B)
  .value("SQRDMLSH_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQRDMLSH_ZZZ_D)
  .value("SQRDMLSH_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQRDMLSH_ZZZ_H)
  .value("SQRDMLSH_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQRDMLSH_ZZZ_S)
  .value("SQRDMLSHv1i16", LIEF::assembly::aarch64::OPCODE::SQRDMLSHv1i16)
  .value("SQRDMLSHv1i16_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMLSHv1i16_indexed)
  .value("SQRDMLSHv1i32", LIEF::assembly::aarch64::OPCODE::SQRDMLSHv1i32)
  .value("SQRDMLSHv1i32_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMLSHv1i32_indexed)
  .value("SQRDMLSHv2i32", LIEF::assembly::aarch64::OPCODE::SQRDMLSHv2i32)
  .value("SQRDMLSHv2i32_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMLSHv2i32_indexed)
  .value("SQRDMLSHv4i16", LIEF::assembly::aarch64::OPCODE::SQRDMLSHv4i16)
  .value("SQRDMLSHv4i16_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMLSHv4i16_indexed)
  .value("SQRDMLSHv4i32", LIEF::assembly::aarch64::OPCODE::SQRDMLSHv4i32)
  .value("SQRDMLSHv4i32_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMLSHv4i32_indexed)
  .value("SQRDMLSHv8i16", LIEF::assembly::aarch64::OPCODE::SQRDMLSHv8i16)
  .value("SQRDMLSHv8i16_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMLSHv8i16_indexed)
  .value("SQRDMULH_ZZZI_D", LIEF::assembly::aarch64::OPCODE::SQRDMULH_ZZZI_D)
  .value("SQRDMULH_ZZZI_H", LIEF::assembly::aarch64::OPCODE::SQRDMULH_ZZZI_H)
  .value("SQRDMULH_ZZZI_S", LIEF::assembly::aarch64::OPCODE::SQRDMULH_ZZZI_S)
  .value("SQRDMULH_ZZZ_B", LIEF::assembly::aarch64::OPCODE::SQRDMULH_ZZZ_B)
  .value("SQRDMULH_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQRDMULH_ZZZ_D)
  .value("SQRDMULH_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQRDMULH_ZZZ_H)
  .value("SQRDMULH_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQRDMULH_ZZZ_S)
  .value("SQRDMULHv1i16", LIEF::assembly::aarch64::OPCODE::SQRDMULHv1i16)
  .value("SQRDMULHv1i16_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMULHv1i16_indexed)
  .value("SQRDMULHv1i32", LIEF::assembly::aarch64::OPCODE::SQRDMULHv1i32)
  .value("SQRDMULHv1i32_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMULHv1i32_indexed)
  .value("SQRDMULHv2i32", LIEF::assembly::aarch64::OPCODE::SQRDMULHv2i32)
  .value("SQRDMULHv2i32_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMULHv2i32_indexed)
  .value("SQRDMULHv4i16", LIEF::assembly::aarch64::OPCODE::SQRDMULHv4i16)
  .value("SQRDMULHv4i16_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMULHv4i16_indexed)
  .value("SQRDMULHv4i32", LIEF::assembly::aarch64::OPCODE::SQRDMULHv4i32)
  .value("SQRDMULHv4i32_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMULHv4i32_indexed)
  .value("SQRDMULHv8i16", LIEF::assembly::aarch64::OPCODE::SQRDMULHv8i16)
  .value("SQRDMULHv8i16_indexed", LIEF::assembly::aarch64::OPCODE::SQRDMULHv8i16_indexed)
  .value("SQRSHLR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SQRSHLR_ZPmZ_B)
  .value("SQRSHLR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SQRSHLR_ZPmZ_D)
  .value("SQRSHLR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SQRSHLR_ZPmZ_H)
  .value("SQRSHLR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SQRSHLR_ZPmZ_S)
  .value("SQRSHL_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SQRSHL_ZPmZ_B)
  .value("SQRSHL_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SQRSHL_ZPmZ_D)
  .value("SQRSHL_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SQRSHL_ZPmZ_H)
  .value("SQRSHL_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SQRSHL_ZPmZ_S)
  .value("SQRSHLv16i8", LIEF::assembly::aarch64::OPCODE::SQRSHLv16i8)
  .value("SQRSHLv1i16", LIEF::assembly::aarch64::OPCODE::SQRSHLv1i16)
  .value("SQRSHLv1i32", LIEF::assembly::aarch64::OPCODE::SQRSHLv1i32)
  .value("SQRSHLv1i64", LIEF::assembly::aarch64::OPCODE::SQRSHLv1i64)
  .value("SQRSHLv1i8", LIEF::assembly::aarch64::OPCODE::SQRSHLv1i8)
  .value("SQRSHLv2i32", LIEF::assembly::aarch64::OPCODE::SQRSHLv2i32)
  .value("SQRSHLv2i64", LIEF::assembly::aarch64::OPCODE::SQRSHLv2i64)
  .value("SQRSHLv4i16", LIEF::assembly::aarch64::OPCODE::SQRSHLv4i16)
  .value("SQRSHLv4i32", LIEF::assembly::aarch64::OPCODE::SQRSHLv4i32)
  .value("SQRSHLv8i16", LIEF::assembly::aarch64::OPCODE::SQRSHLv8i16)
  .value("SQRSHLv8i8", LIEF::assembly::aarch64::OPCODE::SQRSHLv8i8)
  .value("SQRSHRNB_ZZI_B", LIEF::assembly::aarch64::OPCODE::SQRSHRNB_ZZI_B)
  .value("SQRSHRNB_ZZI_H", LIEF::assembly::aarch64::OPCODE::SQRSHRNB_ZZI_H)
  .value("SQRSHRNB_ZZI_S", LIEF::assembly::aarch64::OPCODE::SQRSHRNB_ZZI_S)
  .value("SQRSHRNT_ZZI_B", LIEF::assembly::aarch64::OPCODE::SQRSHRNT_ZZI_B)
  .value("SQRSHRNT_ZZI_H", LIEF::assembly::aarch64::OPCODE::SQRSHRNT_ZZI_H)
  .value("SQRSHRNT_ZZI_S", LIEF::assembly::aarch64::OPCODE::SQRSHRNT_ZZI_S)
  .value("SQRSHRN_VG4_Z4ZI_B", LIEF::assembly::aarch64::OPCODE::SQRSHRN_VG4_Z4ZI_B)
  .value("SQRSHRN_VG4_Z4ZI_H", LIEF::assembly::aarch64::OPCODE::SQRSHRN_VG4_Z4ZI_H)
  .value("SQRSHRN_Z2ZI_StoH", LIEF::assembly::aarch64::OPCODE::SQRSHRN_Z2ZI_StoH)
  .value("SQRSHRNb", LIEF::assembly::aarch64::OPCODE::SQRSHRNb)
  .value("SQRSHRNh", LIEF::assembly::aarch64::OPCODE::SQRSHRNh)
  .value("SQRSHRNs", LIEF::assembly::aarch64::OPCODE::SQRSHRNs)
  .value("SQRSHRNv16i8_shift", LIEF::assembly::aarch64::OPCODE::SQRSHRNv16i8_shift)
  .value("SQRSHRNv2i32_shift", LIEF::assembly::aarch64::OPCODE::SQRSHRNv2i32_shift)
  .value("SQRSHRNv4i16_shift", LIEF::assembly::aarch64::OPCODE::SQRSHRNv4i16_shift)
  .value("SQRSHRNv4i32_shift", LIEF::assembly::aarch64::OPCODE::SQRSHRNv4i32_shift)
  .value("SQRSHRNv8i16_shift", LIEF::assembly::aarch64::OPCODE::SQRSHRNv8i16_shift)
  .value("SQRSHRNv8i8_shift", LIEF::assembly::aarch64::OPCODE::SQRSHRNv8i8_shift)
  .value("SQRSHRUNB_ZZI_B", LIEF::assembly::aarch64::OPCODE::SQRSHRUNB_ZZI_B)
  .value("SQRSHRUNB_ZZI_H", LIEF::assembly::aarch64::OPCODE::SQRSHRUNB_ZZI_H)
  .value("SQRSHRUNB_ZZI_S", LIEF::assembly::aarch64::OPCODE::SQRSHRUNB_ZZI_S)
  .value("SQRSHRUNT_ZZI_B", LIEF::assembly::aarch64::OPCODE::SQRSHRUNT_ZZI_B)
  .value("SQRSHRUNT_ZZI_H", LIEF::assembly::aarch64::OPCODE::SQRSHRUNT_ZZI_H)
  .value("SQRSHRUNT_ZZI_S", LIEF::assembly::aarch64::OPCODE::SQRSHRUNT_ZZI_S)
  .value("SQRSHRUN_VG4_Z4ZI_B", LIEF::assembly::aarch64::OPCODE::SQRSHRUN_VG4_Z4ZI_B)
  .value("SQRSHRUN_VG4_Z4ZI_H", LIEF::assembly::aarch64::OPCODE::SQRSHRUN_VG4_Z4ZI_H)
  .value("SQRSHRUN_Z2ZI_StoH", LIEF::assembly::aarch64::OPCODE::SQRSHRUN_Z2ZI_StoH)
  .value("SQRSHRUNb", LIEF::assembly::aarch64::OPCODE::SQRSHRUNb)
  .value("SQRSHRUNh", LIEF::assembly::aarch64::OPCODE::SQRSHRUNh)
  .value("SQRSHRUNs", LIEF::assembly::aarch64::OPCODE::SQRSHRUNs)
  .value("SQRSHRUNv16i8_shift", LIEF::assembly::aarch64::OPCODE::SQRSHRUNv16i8_shift)
  .value("SQRSHRUNv2i32_shift", LIEF::assembly::aarch64::OPCODE::SQRSHRUNv2i32_shift)
  .value("SQRSHRUNv4i16_shift", LIEF::assembly::aarch64::OPCODE::SQRSHRUNv4i16_shift)
  .value("SQRSHRUNv4i32_shift", LIEF::assembly::aarch64::OPCODE::SQRSHRUNv4i32_shift)
  .value("SQRSHRUNv8i16_shift", LIEF::assembly::aarch64::OPCODE::SQRSHRUNv8i16_shift)
  .value("SQRSHRUNv8i8_shift", LIEF::assembly::aarch64::OPCODE::SQRSHRUNv8i8_shift)
  .value("SQRSHRU_VG2_Z2ZI_H", LIEF::assembly::aarch64::OPCODE::SQRSHRU_VG2_Z2ZI_H)
  .value("SQRSHRU_VG4_Z4ZI_B", LIEF::assembly::aarch64::OPCODE::SQRSHRU_VG4_Z4ZI_B)
  .value("SQRSHRU_VG4_Z4ZI_H", LIEF::assembly::aarch64::OPCODE::SQRSHRU_VG4_Z4ZI_H)
  .value("SQRSHR_VG2_Z2ZI_H", LIEF::assembly::aarch64::OPCODE::SQRSHR_VG2_Z2ZI_H)
  .value("SQRSHR_VG4_Z4ZI_B", LIEF::assembly::aarch64::OPCODE::SQRSHR_VG4_Z4ZI_B)
  .value("SQRSHR_VG4_Z4ZI_H", LIEF::assembly::aarch64::OPCODE::SQRSHR_VG4_Z4ZI_H)
  .value("SQSHLR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SQSHLR_ZPmZ_B)
  .value("SQSHLR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SQSHLR_ZPmZ_D)
  .value("SQSHLR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SQSHLR_ZPmZ_H)
  .value("SQSHLR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SQSHLR_ZPmZ_S)
  .value("SQSHLU_ZPmI_B", LIEF::assembly::aarch64::OPCODE::SQSHLU_ZPmI_B)
  .value("SQSHLU_ZPmI_D", LIEF::assembly::aarch64::OPCODE::SQSHLU_ZPmI_D)
  .value("SQSHLU_ZPmI_H", LIEF::assembly::aarch64::OPCODE::SQSHLU_ZPmI_H)
  .value("SQSHLU_ZPmI_S", LIEF::assembly::aarch64::OPCODE::SQSHLU_ZPmI_S)
  .value("SQSHLUb", LIEF::assembly::aarch64::OPCODE::SQSHLUb)
  .value("SQSHLUd", LIEF::assembly::aarch64::OPCODE::SQSHLUd)
  .value("SQSHLUh", LIEF::assembly::aarch64::OPCODE::SQSHLUh)
  .value("SQSHLUs", LIEF::assembly::aarch64::OPCODE::SQSHLUs)
  .value("SQSHLUv16i8_shift", LIEF::assembly::aarch64::OPCODE::SQSHLUv16i8_shift)
  .value("SQSHLUv2i32_shift", LIEF::assembly::aarch64::OPCODE::SQSHLUv2i32_shift)
  .value("SQSHLUv2i64_shift", LIEF::assembly::aarch64::OPCODE::SQSHLUv2i64_shift)
  .value("SQSHLUv4i16_shift", LIEF::assembly::aarch64::OPCODE::SQSHLUv4i16_shift)
  .value("SQSHLUv4i32_shift", LIEF::assembly::aarch64::OPCODE::SQSHLUv4i32_shift)
  .value("SQSHLUv8i16_shift", LIEF::assembly::aarch64::OPCODE::SQSHLUv8i16_shift)
  .value("SQSHLUv8i8_shift", LIEF::assembly::aarch64::OPCODE::SQSHLUv8i8_shift)
  .value("SQSHL_ZPmI_B", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPmI_B)
  .value("SQSHL_ZPmI_D", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPmI_D)
  .value("SQSHL_ZPmI_H", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPmI_H)
  .value("SQSHL_ZPmI_S", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPmI_S)
  .value("SQSHL_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPmZ_B)
  .value("SQSHL_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPmZ_D)
  .value("SQSHL_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPmZ_H)
  .value("SQSHL_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SQSHL_ZPmZ_S)
  .value("SQSHLb", LIEF::assembly::aarch64::OPCODE::SQSHLb)
  .value("SQSHLd", LIEF::assembly::aarch64::OPCODE::SQSHLd)
  .value("SQSHLh", LIEF::assembly::aarch64::OPCODE::SQSHLh)
  .value("SQSHLs", LIEF::assembly::aarch64::OPCODE::SQSHLs)
  .value("SQSHLv16i8", LIEF::assembly::aarch64::OPCODE::SQSHLv16i8)
  .value("SQSHLv16i8_shift", LIEF::assembly::aarch64::OPCODE::SQSHLv16i8_shift)
  .value("SQSHLv1i16", LIEF::assembly::aarch64::OPCODE::SQSHLv1i16)
  .value("SQSHLv1i32", LIEF::assembly::aarch64::OPCODE::SQSHLv1i32)
  .value("SQSHLv1i64", LIEF::assembly::aarch64::OPCODE::SQSHLv1i64)
  .value("SQSHLv1i8", LIEF::assembly::aarch64::OPCODE::SQSHLv1i8)
  .value("SQSHLv2i32", LIEF::assembly::aarch64::OPCODE::SQSHLv2i32)
  .value("SQSHLv2i32_shift", LIEF::assembly::aarch64::OPCODE::SQSHLv2i32_shift)
  .value("SQSHLv2i64", LIEF::assembly::aarch64::OPCODE::SQSHLv2i64)
  .value("SQSHLv2i64_shift", LIEF::assembly::aarch64::OPCODE::SQSHLv2i64_shift)
  .value("SQSHLv4i16", LIEF::assembly::aarch64::OPCODE::SQSHLv4i16)
  .value("SQSHLv4i16_shift", LIEF::assembly::aarch64::OPCODE::SQSHLv4i16_shift)
  .value("SQSHLv4i32", LIEF::assembly::aarch64::OPCODE::SQSHLv4i32)
  .value("SQSHLv4i32_shift", LIEF::assembly::aarch64::OPCODE::SQSHLv4i32_shift)
  .value("SQSHLv8i16", LIEF::assembly::aarch64::OPCODE::SQSHLv8i16)
  .value("SQSHLv8i16_shift", LIEF::assembly::aarch64::OPCODE::SQSHLv8i16_shift)
  .value("SQSHLv8i8", LIEF::assembly::aarch64::OPCODE::SQSHLv8i8)
  .value("SQSHLv8i8_shift", LIEF::assembly::aarch64::OPCODE::SQSHLv8i8_shift)
  .value("SQSHRNB_ZZI_B", LIEF::assembly::aarch64::OPCODE::SQSHRNB_ZZI_B)
  .value("SQSHRNB_ZZI_H", LIEF::assembly::aarch64::OPCODE::SQSHRNB_ZZI_H)
  .value("SQSHRNB_ZZI_S", LIEF::assembly::aarch64::OPCODE::SQSHRNB_ZZI_S)
  .value("SQSHRNT_ZZI_B", LIEF::assembly::aarch64::OPCODE::SQSHRNT_ZZI_B)
  .value("SQSHRNT_ZZI_H", LIEF::assembly::aarch64::OPCODE::SQSHRNT_ZZI_H)
  .value("SQSHRNT_ZZI_S", LIEF::assembly::aarch64::OPCODE::SQSHRNT_ZZI_S)
  .value("SQSHRNb", LIEF::assembly::aarch64::OPCODE::SQSHRNb)
  .value("SQSHRNh", LIEF::assembly::aarch64::OPCODE::SQSHRNh)
  .value("SQSHRNs", LIEF::assembly::aarch64::OPCODE::SQSHRNs)
  .value("SQSHRNv16i8_shift", LIEF::assembly::aarch64::OPCODE::SQSHRNv16i8_shift)
  .value("SQSHRNv2i32_shift", LIEF::assembly::aarch64::OPCODE::SQSHRNv2i32_shift)
  .value("SQSHRNv4i16_shift", LIEF::assembly::aarch64::OPCODE::SQSHRNv4i16_shift)
  .value("SQSHRNv4i32_shift", LIEF::assembly::aarch64::OPCODE::SQSHRNv4i32_shift)
  .value("SQSHRNv8i16_shift", LIEF::assembly::aarch64::OPCODE::SQSHRNv8i16_shift)
  .value("SQSHRNv8i8_shift", LIEF::assembly::aarch64::OPCODE::SQSHRNv8i8_shift)
  .value("SQSHRUNB_ZZI_B", LIEF::assembly::aarch64::OPCODE::SQSHRUNB_ZZI_B)
  .value("SQSHRUNB_ZZI_H", LIEF::assembly::aarch64::OPCODE::SQSHRUNB_ZZI_H)
  .value("SQSHRUNB_ZZI_S", LIEF::assembly::aarch64::OPCODE::SQSHRUNB_ZZI_S)
  .value("SQSHRUNT_ZZI_B", LIEF::assembly::aarch64::OPCODE::SQSHRUNT_ZZI_B)
  .value("SQSHRUNT_ZZI_H", LIEF::assembly::aarch64::OPCODE::SQSHRUNT_ZZI_H)
  .value("SQSHRUNT_ZZI_S", LIEF::assembly::aarch64::OPCODE::SQSHRUNT_ZZI_S)
  .value("SQSHRUNb", LIEF::assembly::aarch64::OPCODE::SQSHRUNb)
  .value("SQSHRUNh", LIEF::assembly::aarch64::OPCODE::SQSHRUNh)
  .value("SQSHRUNs", LIEF::assembly::aarch64::OPCODE::SQSHRUNs)
  .value("SQSHRUNv16i8_shift", LIEF::assembly::aarch64::OPCODE::SQSHRUNv16i8_shift)
  .value("SQSHRUNv2i32_shift", LIEF::assembly::aarch64::OPCODE::SQSHRUNv2i32_shift)
  .value("SQSHRUNv4i16_shift", LIEF::assembly::aarch64::OPCODE::SQSHRUNv4i16_shift)
  .value("SQSHRUNv4i32_shift", LIEF::assembly::aarch64::OPCODE::SQSHRUNv4i32_shift)
  .value("SQSHRUNv8i16_shift", LIEF::assembly::aarch64::OPCODE::SQSHRUNv8i16_shift)
  .value("SQSHRUNv8i8_shift", LIEF::assembly::aarch64::OPCODE::SQSHRUNv8i8_shift)
  .value("SQSUBR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SQSUBR_ZPmZ_B)
  .value("SQSUBR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SQSUBR_ZPmZ_D)
  .value("SQSUBR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SQSUBR_ZPmZ_H)
  .value("SQSUBR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SQSUBR_ZPmZ_S)
  .value("SQSUB_ZI_B", LIEF::assembly::aarch64::OPCODE::SQSUB_ZI_B)
  .value("SQSUB_ZI_D", LIEF::assembly::aarch64::OPCODE::SQSUB_ZI_D)
  .value("SQSUB_ZI_H", LIEF::assembly::aarch64::OPCODE::SQSUB_ZI_H)
  .value("SQSUB_ZI_S", LIEF::assembly::aarch64::OPCODE::SQSUB_ZI_S)
  .value("SQSUB_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SQSUB_ZPmZ_B)
  .value("SQSUB_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SQSUB_ZPmZ_D)
  .value("SQSUB_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SQSUB_ZPmZ_H)
  .value("SQSUB_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SQSUB_ZPmZ_S)
  .value("SQSUB_ZZZ_B", LIEF::assembly::aarch64::OPCODE::SQSUB_ZZZ_B)
  .value("SQSUB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SQSUB_ZZZ_D)
  .value("SQSUB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SQSUB_ZZZ_H)
  .value("SQSUB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SQSUB_ZZZ_S)
  .value("SQSUBv16i8", LIEF::assembly::aarch64::OPCODE::SQSUBv16i8)
  .value("SQSUBv1i16", LIEF::assembly::aarch64::OPCODE::SQSUBv1i16)
  .value("SQSUBv1i32", LIEF::assembly::aarch64::OPCODE::SQSUBv1i32)
  .value("SQSUBv1i64", LIEF::assembly::aarch64::OPCODE::SQSUBv1i64)
  .value("SQSUBv1i8", LIEF::assembly::aarch64::OPCODE::SQSUBv1i8)
  .value("SQSUBv2i32", LIEF::assembly::aarch64::OPCODE::SQSUBv2i32)
  .value("SQSUBv2i64", LIEF::assembly::aarch64::OPCODE::SQSUBv2i64)
  .value("SQSUBv4i16", LIEF::assembly::aarch64::OPCODE::SQSUBv4i16)
  .value("SQSUBv4i32", LIEF::assembly::aarch64::OPCODE::SQSUBv4i32)
  .value("SQSUBv8i16", LIEF::assembly::aarch64::OPCODE::SQSUBv8i16)
  .value("SQSUBv8i8", LIEF::assembly::aarch64::OPCODE::SQSUBv8i8)
  .value("SQXTNB_ZZ_B", LIEF::assembly::aarch64::OPCODE::SQXTNB_ZZ_B)
  .value("SQXTNB_ZZ_H", LIEF::assembly::aarch64::OPCODE::SQXTNB_ZZ_H)
  .value("SQXTNB_ZZ_S", LIEF::assembly::aarch64::OPCODE::SQXTNB_ZZ_S)
  .value("SQXTNT_ZZ_B", LIEF::assembly::aarch64::OPCODE::SQXTNT_ZZ_B)
  .value("SQXTNT_ZZ_H", LIEF::assembly::aarch64::OPCODE::SQXTNT_ZZ_H)
  .value("SQXTNT_ZZ_S", LIEF::assembly::aarch64::OPCODE::SQXTNT_ZZ_S)
  .value("SQXTNv16i8", LIEF::assembly::aarch64::OPCODE::SQXTNv16i8)
  .value("SQXTNv1i16", LIEF::assembly::aarch64::OPCODE::SQXTNv1i16)
  .value("SQXTNv1i32", LIEF::assembly::aarch64::OPCODE::SQXTNv1i32)
  .value("SQXTNv1i8", LIEF::assembly::aarch64::OPCODE::SQXTNv1i8)
  .value("SQXTNv2i32", LIEF::assembly::aarch64::OPCODE::SQXTNv2i32)
  .value("SQXTNv4i16", LIEF::assembly::aarch64::OPCODE::SQXTNv4i16)
  .value("SQXTNv4i32", LIEF::assembly::aarch64::OPCODE::SQXTNv4i32)
  .value("SQXTNv8i16", LIEF::assembly::aarch64::OPCODE::SQXTNv8i16)
  .value("SQXTNv8i8", LIEF::assembly::aarch64::OPCODE::SQXTNv8i8)
  .value("SQXTUNB_ZZ_B", LIEF::assembly::aarch64::OPCODE::SQXTUNB_ZZ_B)
  .value("SQXTUNB_ZZ_H", LIEF::assembly::aarch64::OPCODE::SQXTUNB_ZZ_H)
  .value("SQXTUNB_ZZ_S", LIEF::assembly::aarch64::OPCODE::SQXTUNB_ZZ_S)
  .value("SQXTUNT_ZZ_B", LIEF::assembly::aarch64::OPCODE::SQXTUNT_ZZ_B)
  .value("SQXTUNT_ZZ_H", LIEF::assembly::aarch64::OPCODE::SQXTUNT_ZZ_H)
  .value("SQXTUNT_ZZ_S", LIEF::assembly::aarch64::OPCODE::SQXTUNT_ZZ_S)
  .value("SQXTUNv16i8", LIEF::assembly::aarch64::OPCODE::SQXTUNv16i8)
  .value("SQXTUNv1i16", LIEF::assembly::aarch64::OPCODE::SQXTUNv1i16)
  .value("SQXTUNv1i32", LIEF::assembly::aarch64::OPCODE::SQXTUNv1i32)
  .value("SQXTUNv1i8", LIEF::assembly::aarch64::OPCODE::SQXTUNv1i8)
  .value("SQXTUNv2i32", LIEF::assembly::aarch64::OPCODE::SQXTUNv2i32)
  .value("SQXTUNv4i16", LIEF::assembly::aarch64::OPCODE::SQXTUNv4i16)
  .value("SQXTUNv4i32", LIEF::assembly::aarch64::OPCODE::SQXTUNv4i32)
  .value("SQXTUNv8i16", LIEF::assembly::aarch64::OPCODE::SQXTUNv8i16)
  .value("SQXTUNv8i8", LIEF::assembly::aarch64::OPCODE::SQXTUNv8i8);
  opcodes.value("SRHADD_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SRHADD_ZPmZ_B)
  .value("SRHADD_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SRHADD_ZPmZ_D)
  .value("SRHADD_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SRHADD_ZPmZ_H)
  .value("SRHADD_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SRHADD_ZPmZ_S)
  .value("SRHADDv16i8", LIEF::assembly::aarch64::OPCODE::SRHADDv16i8)
  .value("SRHADDv2i32", LIEF::assembly::aarch64::OPCODE::SRHADDv2i32)
  .value("SRHADDv4i16", LIEF::assembly::aarch64::OPCODE::SRHADDv4i16)
  .value("SRHADDv4i32", LIEF::assembly::aarch64::OPCODE::SRHADDv4i32)
  .value("SRHADDv8i16", LIEF::assembly::aarch64::OPCODE::SRHADDv8i16)
  .value("SRHADDv8i8", LIEF::assembly::aarch64::OPCODE::SRHADDv8i8)
  .value("SRI_ZZI_B", LIEF::assembly::aarch64::OPCODE::SRI_ZZI_B)
  .value("SRI_ZZI_D", LIEF::assembly::aarch64::OPCODE::SRI_ZZI_D)
  .value("SRI_ZZI_H", LIEF::assembly::aarch64::OPCODE::SRI_ZZI_H)
  .value("SRI_ZZI_S", LIEF::assembly::aarch64::OPCODE::SRI_ZZI_S)
  .value("SRId", LIEF::assembly::aarch64::OPCODE::SRId)
  .value("SRIv16i8_shift", LIEF::assembly::aarch64::OPCODE::SRIv16i8_shift)
  .value("SRIv2i32_shift", LIEF::assembly::aarch64::OPCODE::SRIv2i32_shift)
  .value("SRIv2i64_shift", LIEF::assembly::aarch64::OPCODE::SRIv2i64_shift)
  .value("SRIv4i16_shift", LIEF::assembly::aarch64::OPCODE::SRIv4i16_shift)
  .value("SRIv4i32_shift", LIEF::assembly::aarch64::OPCODE::SRIv4i32_shift)
  .value("SRIv8i16_shift", LIEF::assembly::aarch64::OPCODE::SRIv8i16_shift)
  .value("SRIv8i8_shift", LIEF::assembly::aarch64::OPCODE::SRIv8i8_shift)
  .value("SRSHLR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SRSHLR_ZPmZ_B)
  .value("SRSHLR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SRSHLR_ZPmZ_D)
  .value("SRSHLR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SRSHLR_ZPmZ_H)
  .value("SRSHLR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SRSHLR_ZPmZ_S)
  .value("SRSHL_VG2_2Z2Z_B", LIEF::assembly::aarch64::OPCODE::SRSHL_VG2_2Z2Z_B)
  .value("SRSHL_VG2_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::SRSHL_VG2_2Z2Z_D)
  .value("SRSHL_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::SRSHL_VG2_2Z2Z_H)
  .value("SRSHL_VG2_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::SRSHL_VG2_2Z2Z_S)
  .value("SRSHL_VG2_2ZZ_B", LIEF::assembly::aarch64::OPCODE::SRSHL_VG2_2ZZ_B)
  .value("SRSHL_VG2_2ZZ_D", LIEF::assembly::aarch64::OPCODE::SRSHL_VG2_2ZZ_D)
  .value("SRSHL_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::SRSHL_VG2_2ZZ_H)
  .value("SRSHL_VG2_2ZZ_S", LIEF::assembly::aarch64::OPCODE::SRSHL_VG2_2ZZ_S)
  .value("SRSHL_VG4_4Z4Z_B", LIEF::assembly::aarch64::OPCODE::SRSHL_VG4_4Z4Z_B)
  .value("SRSHL_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::SRSHL_VG4_4Z4Z_D)
  .value("SRSHL_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::SRSHL_VG4_4Z4Z_H)
  .value("SRSHL_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::SRSHL_VG4_4Z4Z_S)
  .value("SRSHL_VG4_4ZZ_B", LIEF::assembly::aarch64::OPCODE::SRSHL_VG4_4ZZ_B)
  .value("SRSHL_VG4_4ZZ_D", LIEF::assembly::aarch64::OPCODE::SRSHL_VG4_4ZZ_D)
  .value("SRSHL_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::SRSHL_VG4_4ZZ_H)
  .value("SRSHL_VG4_4ZZ_S", LIEF::assembly::aarch64::OPCODE::SRSHL_VG4_4ZZ_S)
  .value("SRSHL_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SRSHL_ZPmZ_B)
  .value("SRSHL_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SRSHL_ZPmZ_D)
  .value("SRSHL_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SRSHL_ZPmZ_H)
  .value("SRSHL_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SRSHL_ZPmZ_S)
  .value("SRSHLv16i8", LIEF::assembly::aarch64::OPCODE::SRSHLv16i8)
  .value("SRSHLv1i64", LIEF::assembly::aarch64::OPCODE::SRSHLv1i64)
  .value("SRSHLv2i32", LIEF::assembly::aarch64::OPCODE::SRSHLv2i32)
  .value("SRSHLv2i64", LIEF::assembly::aarch64::OPCODE::SRSHLv2i64)
  .value("SRSHLv4i16", LIEF::assembly::aarch64::OPCODE::SRSHLv4i16)
  .value("SRSHLv4i32", LIEF::assembly::aarch64::OPCODE::SRSHLv4i32)
  .value("SRSHLv8i16", LIEF::assembly::aarch64::OPCODE::SRSHLv8i16)
  .value("SRSHLv8i8", LIEF::assembly::aarch64::OPCODE::SRSHLv8i8)
  .value("SRSHR_ZPmI_B", LIEF::assembly::aarch64::OPCODE::SRSHR_ZPmI_B)
  .value("SRSHR_ZPmI_D", LIEF::assembly::aarch64::OPCODE::SRSHR_ZPmI_D)
  .value("SRSHR_ZPmI_H", LIEF::assembly::aarch64::OPCODE::SRSHR_ZPmI_H)
  .value("SRSHR_ZPmI_S", LIEF::assembly::aarch64::OPCODE::SRSHR_ZPmI_S)
  .value("SRSHRd", LIEF::assembly::aarch64::OPCODE::SRSHRd)
  .value("SRSHRv16i8_shift", LIEF::assembly::aarch64::OPCODE::SRSHRv16i8_shift)
  .value("SRSHRv2i32_shift", LIEF::assembly::aarch64::OPCODE::SRSHRv2i32_shift)
  .value("SRSHRv2i64_shift", LIEF::assembly::aarch64::OPCODE::SRSHRv2i64_shift)
  .value("SRSHRv4i16_shift", LIEF::assembly::aarch64::OPCODE::SRSHRv4i16_shift)
  .value("SRSHRv4i32_shift", LIEF::assembly::aarch64::OPCODE::SRSHRv4i32_shift)
  .value("SRSHRv8i16_shift", LIEF::assembly::aarch64::OPCODE::SRSHRv8i16_shift)
  .value("SRSHRv8i8_shift", LIEF::assembly::aarch64::OPCODE::SRSHRv8i8_shift)
  .value("SRSRA_ZZI_B", LIEF::assembly::aarch64::OPCODE::SRSRA_ZZI_B)
  .value("SRSRA_ZZI_D", LIEF::assembly::aarch64::OPCODE::SRSRA_ZZI_D)
  .value("SRSRA_ZZI_H", LIEF::assembly::aarch64::OPCODE::SRSRA_ZZI_H)
  .value("SRSRA_ZZI_S", LIEF::assembly::aarch64::OPCODE::SRSRA_ZZI_S)
  .value("SRSRAd", LIEF::assembly::aarch64::OPCODE::SRSRAd)
  .value("SRSRAv16i8_shift", LIEF::assembly::aarch64::OPCODE::SRSRAv16i8_shift)
  .value("SRSRAv2i32_shift", LIEF::assembly::aarch64::OPCODE::SRSRAv2i32_shift)
  .value("SRSRAv2i64_shift", LIEF::assembly::aarch64::OPCODE::SRSRAv2i64_shift)
  .value("SRSRAv4i16_shift", LIEF::assembly::aarch64::OPCODE::SRSRAv4i16_shift)
  .value("SRSRAv4i32_shift", LIEF::assembly::aarch64::OPCODE::SRSRAv4i32_shift)
  .value("SRSRAv8i16_shift", LIEF::assembly::aarch64::OPCODE::SRSRAv8i16_shift)
  .value("SRSRAv8i8_shift", LIEF::assembly::aarch64::OPCODE::SRSRAv8i8_shift)
  .value("SSHLLB_ZZI_D", LIEF::assembly::aarch64::OPCODE::SSHLLB_ZZI_D)
  .value("SSHLLB_ZZI_H", LIEF::assembly::aarch64::OPCODE::SSHLLB_ZZI_H)
  .value("SSHLLB_ZZI_S", LIEF::assembly::aarch64::OPCODE::SSHLLB_ZZI_S)
  .value("SSHLLT_ZZI_D", LIEF::assembly::aarch64::OPCODE::SSHLLT_ZZI_D)
  .value("SSHLLT_ZZI_H", LIEF::assembly::aarch64::OPCODE::SSHLLT_ZZI_H)
  .value("SSHLLT_ZZI_S", LIEF::assembly::aarch64::OPCODE::SSHLLT_ZZI_S)
  .value("SSHLLv16i8_shift", LIEF::assembly::aarch64::OPCODE::SSHLLv16i8_shift)
  .value("SSHLLv2i32_shift", LIEF::assembly::aarch64::OPCODE::SSHLLv2i32_shift)
  .value("SSHLLv4i16_shift", LIEF::assembly::aarch64::OPCODE::SSHLLv4i16_shift)
  .value("SSHLLv4i32_shift", LIEF::assembly::aarch64::OPCODE::SSHLLv4i32_shift)
  .value("SSHLLv8i16_shift", LIEF::assembly::aarch64::OPCODE::SSHLLv8i16_shift)
  .value("SSHLLv8i8_shift", LIEF::assembly::aarch64::OPCODE::SSHLLv8i8_shift)
  .value("SSHLv16i8", LIEF::assembly::aarch64::OPCODE::SSHLv16i8)
  .value("SSHLv1i64", LIEF::assembly::aarch64::OPCODE::SSHLv1i64)
  .value("SSHLv2i32", LIEF::assembly::aarch64::OPCODE::SSHLv2i32)
  .value("SSHLv2i64", LIEF::assembly::aarch64::OPCODE::SSHLv2i64)
  .value("SSHLv4i16", LIEF::assembly::aarch64::OPCODE::SSHLv4i16)
  .value("SSHLv4i32", LIEF::assembly::aarch64::OPCODE::SSHLv4i32)
  .value("SSHLv8i16", LIEF::assembly::aarch64::OPCODE::SSHLv8i16)
  .value("SSHLv8i8", LIEF::assembly::aarch64::OPCODE::SSHLv8i8)
  .value("SSHRd", LIEF::assembly::aarch64::OPCODE::SSHRd)
  .value("SSHRv16i8_shift", LIEF::assembly::aarch64::OPCODE::SSHRv16i8_shift)
  .value("SSHRv2i32_shift", LIEF::assembly::aarch64::OPCODE::SSHRv2i32_shift)
  .value("SSHRv2i64_shift", LIEF::assembly::aarch64::OPCODE::SSHRv2i64_shift)
  .value("SSHRv4i16_shift", LIEF::assembly::aarch64::OPCODE::SSHRv4i16_shift)
  .value("SSHRv4i32_shift", LIEF::assembly::aarch64::OPCODE::SSHRv4i32_shift)
  .value("SSHRv8i16_shift", LIEF::assembly::aarch64::OPCODE::SSHRv8i16_shift)
  .value("SSHRv8i8_shift", LIEF::assembly::aarch64::OPCODE::SSHRv8i8_shift)
  .value("SSRA_ZZI_B", LIEF::assembly::aarch64::OPCODE::SSRA_ZZI_B)
  .value("SSRA_ZZI_D", LIEF::assembly::aarch64::OPCODE::SSRA_ZZI_D)
  .value("SSRA_ZZI_H", LIEF::assembly::aarch64::OPCODE::SSRA_ZZI_H)
  .value("SSRA_ZZI_S", LIEF::assembly::aarch64::OPCODE::SSRA_ZZI_S)
  .value("SSRAd", LIEF::assembly::aarch64::OPCODE::SSRAd)
  .value("SSRAv16i8_shift", LIEF::assembly::aarch64::OPCODE::SSRAv16i8_shift)
  .value("SSRAv2i32_shift", LIEF::assembly::aarch64::OPCODE::SSRAv2i32_shift)
  .value("SSRAv2i64_shift", LIEF::assembly::aarch64::OPCODE::SSRAv2i64_shift)
  .value("SSRAv4i16_shift", LIEF::assembly::aarch64::OPCODE::SSRAv4i16_shift)
  .value("SSRAv4i32_shift", LIEF::assembly::aarch64::OPCODE::SSRAv4i32_shift)
  .value("SSRAv8i16_shift", LIEF::assembly::aarch64::OPCODE::SSRAv8i16_shift)
  .value("SSRAv8i8_shift", LIEF::assembly::aarch64::OPCODE::SSRAv8i8_shift)
  .value("SST1B_D", LIEF::assembly::aarch64::OPCODE::SST1B_D)
  .value("SST1B_D_IMM", LIEF::assembly::aarch64::OPCODE::SST1B_D_IMM)
  .value("SST1B_D_SXTW", LIEF::assembly::aarch64::OPCODE::SST1B_D_SXTW)
  .value("SST1B_D_UXTW", LIEF::assembly::aarch64::OPCODE::SST1B_D_UXTW)
  .value("SST1B_S_IMM", LIEF::assembly::aarch64::OPCODE::SST1B_S_IMM)
  .value("SST1B_S_SXTW", LIEF::assembly::aarch64::OPCODE::SST1B_S_SXTW)
  .value("SST1B_S_UXTW", LIEF::assembly::aarch64::OPCODE::SST1B_S_UXTW)
  .value("SST1D", LIEF::assembly::aarch64::OPCODE::SST1D)
  .value("SST1D_IMM", LIEF::assembly::aarch64::OPCODE::SST1D_IMM)
  .value("SST1D_SCALED", LIEF::assembly::aarch64::OPCODE::SST1D_SCALED)
  .value("SST1D_SXTW", LIEF::assembly::aarch64::OPCODE::SST1D_SXTW)
  .value("SST1D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::SST1D_SXTW_SCALED)
  .value("SST1D_UXTW", LIEF::assembly::aarch64::OPCODE::SST1D_UXTW)
  .value("SST1D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::SST1D_UXTW_SCALED)
  .value("SST1H_D", LIEF::assembly::aarch64::OPCODE::SST1H_D)
  .value("SST1H_D_IMM", LIEF::assembly::aarch64::OPCODE::SST1H_D_IMM)
  .value("SST1H_D_SCALED", LIEF::assembly::aarch64::OPCODE::SST1H_D_SCALED)
  .value("SST1H_D_SXTW", LIEF::assembly::aarch64::OPCODE::SST1H_D_SXTW)
  .value("SST1H_D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::SST1H_D_SXTW_SCALED)
  .value("SST1H_D_UXTW", LIEF::assembly::aarch64::OPCODE::SST1H_D_UXTW)
  .value("SST1H_D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::SST1H_D_UXTW_SCALED)
  .value("SST1H_S_IMM", LIEF::assembly::aarch64::OPCODE::SST1H_S_IMM)
  .value("SST1H_S_SXTW", LIEF::assembly::aarch64::OPCODE::SST1H_S_SXTW)
  .value("SST1H_S_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::SST1H_S_SXTW_SCALED)
  .value("SST1H_S_UXTW", LIEF::assembly::aarch64::OPCODE::SST1H_S_UXTW)
  .value("SST1H_S_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::SST1H_S_UXTW_SCALED)
  .value("SST1Q", LIEF::assembly::aarch64::OPCODE::SST1Q)
  .value("SST1W_D", LIEF::assembly::aarch64::OPCODE::SST1W_D)
  .value("SST1W_D_IMM", LIEF::assembly::aarch64::OPCODE::SST1W_D_IMM)
  .value("SST1W_D_SCALED", LIEF::assembly::aarch64::OPCODE::SST1W_D_SCALED)
  .value("SST1W_D_SXTW", LIEF::assembly::aarch64::OPCODE::SST1W_D_SXTW)
  .value("SST1W_D_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::SST1W_D_SXTW_SCALED)
  .value("SST1W_D_UXTW", LIEF::assembly::aarch64::OPCODE::SST1W_D_UXTW)
  .value("SST1W_D_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::SST1W_D_UXTW_SCALED)
  .value("SST1W_IMM", LIEF::assembly::aarch64::OPCODE::SST1W_IMM)
  .value("SST1W_SXTW", LIEF::assembly::aarch64::OPCODE::SST1W_SXTW)
  .value("SST1W_SXTW_SCALED", LIEF::assembly::aarch64::OPCODE::SST1W_SXTW_SCALED)
  .value("SST1W_UXTW", LIEF::assembly::aarch64::OPCODE::SST1W_UXTW)
  .value("SST1W_UXTW_SCALED", LIEF::assembly::aarch64::OPCODE::SST1W_UXTW_SCALED)
  .value("SSUBLBT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SSUBLBT_ZZZ_D)
  .value("SSUBLBT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SSUBLBT_ZZZ_H)
  .value("SSUBLBT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SSUBLBT_ZZZ_S)
  .value("SSUBLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SSUBLB_ZZZ_D)
  .value("SSUBLB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SSUBLB_ZZZ_H)
  .value("SSUBLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SSUBLB_ZZZ_S)
  .value("SSUBLTB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SSUBLTB_ZZZ_D)
  .value("SSUBLTB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SSUBLTB_ZZZ_H)
  .value("SSUBLTB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SSUBLTB_ZZZ_S)
  .value("SSUBLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SSUBLT_ZZZ_D)
  .value("SSUBLT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SSUBLT_ZZZ_H)
  .value("SSUBLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SSUBLT_ZZZ_S)
  .value("SSUBLv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::SSUBLv16i8_v8i16)
  .value("SSUBLv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::SSUBLv2i32_v2i64)
  .value("SSUBLv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::SSUBLv4i16_v4i32)
  .value("SSUBLv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::SSUBLv4i32_v2i64)
  .value("SSUBLv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::SSUBLv8i16_v4i32)
  .value("SSUBLv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::SSUBLv8i8_v8i16)
  .value("SSUBWB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SSUBWB_ZZZ_D)
  .value("SSUBWB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SSUBWB_ZZZ_H)
  .value("SSUBWB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SSUBWB_ZZZ_S)
  .value("SSUBWT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SSUBWT_ZZZ_D)
  .value("SSUBWT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SSUBWT_ZZZ_H)
  .value("SSUBWT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SSUBWT_ZZZ_S)
  .value("SSUBWv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::SSUBWv16i8_v8i16)
  .value("SSUBWv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::SSUBWv2i32_v2i64)
  .value("SSUBWv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::SSUBWv4i16_v4i32)
  .value("SSUBWv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::SSUBWv4i32_v2i64)
  .value("SSUBWv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::SSUBWv8i16_v4i32)
  .value("SSUBWv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::SSUBWv8i8_v8i16)
  .value("ST1B", LIEF::assembly::aarch64::OPCODE::ST1B)
  .value("ST1B_2Z", LIEF::assembly::aarch64::OPCODE::ST1B_2Z)
  .value("ST1B_2Z_IMM", LIEF::assembly::aarch64::OPCODE::ST1B_2Z_IMM)
  .value("ST1B_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::ST1B_2Z_STRIDED)
  .value("ST1B_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::ST1B_2Z_STRIDED_IMM)
  .value("ST1B_4Z", LIEF::assembly::aarch64::OPCODE::ST1B_4Z)
  .value("ST1B_4Z_IMM", LIEF::assembly::aarch64::OPCODE::ST1B_4Z_IMM)
  .value("ST1B_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::ST1B_4Z_STRIDED)
  .value("ST1B_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::ST1B_4Z_STRIDED_IMM)
  .value("ST1B_D", LIEF::assembly::aarch64::OPCODE::ST1B_D)
  .value("ST1B_D_IMM", LIEF::assembly::aarch64::OPCODE::ST1B_D_IMM)
  .value("ST1B_H", LIEF::assembly::aarch64::OPCODE::ST1B_H)
  .value("ST1B_H_IMM", LIEF::assembly::aarch64::OPCODE::ST1B_H_IMM)
  .value("ST1B_IMM", LIEF::assembly::aarch64::OPCODE::ST1B_IMM)
  .value("ST1B_S", LIEF::assembly::aarch64::OPCODE::ST1B_S)
  .value("ST1B_S_IMM", LIEF::assembly::aarch64::OPCODE::ST1B_S_IMM)
  .value("ST1D", LIEF::assembly::aarch64::OPCODE::ST1D)
  .value("ST1D_2Z", LIEF::assembly::aarch64::OPCODE::ST1D_2Z)
  .value("ST1D_2Z_IMM", LIEF::assembly::aarch64::OPCODE::ST1D_2Z_IMM)
  .value("ST1D_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::ST1D_2Z_STRIDED)
  .value("ST1D_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::ST1D_2Z_STRIDED_IMM)
  .value("ST1D_4Z", LIEF::assembly::aarch64::OPCODE::ST1D_4Z)
  .value("ST1D_4Z_IMM", LIEF::assembly::aarch64::OPCODE::ST1D_4Z_IMM)
  .value("ST1D_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::ST1D_4Z_STRIDED)
  .value("ST1D_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::ST1D_4Z_STRIDED_IMM)
  .value("ST1D_IMM", LIEF::assembly::aarch64::OPCODE::ST1D_IMM)
  .value("ST1D_Q", LIEF::assembly::aarch64::OPCODE::ST1D_Q)
  .value("ST1D_Q_IMM", LIEF::assembly::aarch64::OPCODE::ST1D_Q_IMM)
  .value("ST1Fourv16b", LIEF::assembly::aarch64::OPCODE::ST1Fourv16b)
  .value("ST1Fourv16b_POST", LIEF::assembly::aarch64::OPCODE::ST1Fourv16b_POST)
  .value("ST1Fourv1d", LIEF::assembly::aarch64::OPCODE::ST1Fourv1d)
  .value("ST1Fourv1d_POST", LIEF::assembly::aarch64::OPCODE::ST1Fourv1d_POST)
  .value("ST1Fourv2d", LIEF::assembly::aarch64::OPCODE::ST1Fourv2d)
  .value("ST1Fourv2d_POST", LIEF::assembly::aarch64::OPCODE::ST1Fourv2d_POST)
  .value("ST1Fourv2s", LIEF::assembly::aarch64::OPCODE::ST1Fourv2s)
  .value("ST1Fourv2s_POST", LIEF::assembly::aarch64::OPCODE::ST1Fourv2s_POST)
  .value("ST1Fourv4h", LIEF::assembly::aarch64::OPCODE::ST1Fourv4h)
  .value("ST1Fourv4h_POST", LIEF::assembly::aarch64::OPCODE::ST1Fourv4h_POST)
  .value("ST1Fourv4s", LIEF::assembly::aarch64::OPCODE::ST1Fourv4s)
  .value("ST1Fourv4s_POST", LIEF::assembly::aarch64::OPCODE::ST1Fourv4s_POST)
  .value("ST1Fourv8b", LIEF::assembly::aarch64::OPCODE::ST1Fourv8b)
  .value("ST1Fourv8b_POST", LIEF::assembly::aarch64::OPCODE::ST1Fourv8b_POST)
  .value("ST1Fourv8h", LIEF::assembly::aarch64::OPCODE::ST1Fourv8h)
  .value("ST1Fourv8h_POST", LIEF::assembly::aarch64::OPCODE::ST1Fourv8h_POST)
  .value("ST1H", LIEF::assembly::aarch64::OPCODE::ST1H)
  .value("ST1H_2Z", LIEF::assembly::aarch64::OPCODE::ST1H_2Z)
  .value("ST1H_2Z_IMM", LIEF::assembly::aarch64::OPCODE::ST1H_2Z_IMM)
  .value("ST1H_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::ST1H_2Z_STRIDED)
  .value("ST1H_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::ST1H_2Z_STRIDED_IMM)
  .value("ST1H_4Z", LIEF::assembly::aarch64::OPCODE::ST1H_4Z)
  .value("ST1H_4Z_IMM", LIEF::assembly::aarch64::OPCODE::ST1H_4Z_IMM)
  .value("ST1H_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::ST1H_4Z_STRIDED)
  .value("ST1H_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::ST1H_4Z_STRIDED_IMM)
  .value("ST1H_D", LIEF::assembly::aarch64::OPCODE::ST1H_D)
  .value("ST1H_D_IMM", LIEF::assembly::aarch64::OPCODE::ST1H_D_IMM)
  .value("ST1H_IMM", LIEF::assembly::aarch64::OPCODE::ST1H_IMM)
  .value("ST1H_S", LIEF::assembly::aarch64::OPCODE::ST1H_S)
  .value("ST1H_S_IMM", LIEF::assembly::aarch64::OPCODE::ST1H_S_IMM)
  .value("ST1Onev16b", LIEF::assembly::aarch64::OPCODE::ST1Onev16b)
  .value("ST1Onev16b_POST", LIEF::assembly::aarch64::OPCODE::ST1Onev16b_POST)
  .value("ST1Onev1d", LIEF::assembly::aarch64::OPCODE::ST1Onev1d)
  .value("ST1Onev1d_POST", LIEF::assembly::aarch64::OPCODE::ST1Onev1d_POST)
  .value("ST1Onev2d", LIEF::assembly::aarch64::OPCODE::ST1Onev2d)
  .value("ST1Onev2d_POST", LIEF::assembly::aarch64::OPCODE::ST1Onev2d_POST)
  .value("ST1Onev2s", LIEF::assembly::aarch64::OPCODE::ST1Onev2s)
  .value("ST1Onev2s_POST", LIEF::assembly::aarch64::OPCODE::ST1Onev2s_POST)
  .value("ST1Onev4h", LIEF::assembly::aarch64::OPCODE::ST1Onev4h)
  .value("ST1Onev4h_POST", LIEF::assembly::aarch64::OPCODE::ST1Onev4h_POST)
  .value("ST1Onev4s", LIEF::assembly::aarch64::OPCODE::ST1Onev4s)
  .value("ST1Onev4s_POST", LIEF::assembly::aarch64::OPCODE::ST1Onev4s_POST)
  .value("ST1Onev8b", LIEF::assembly::aarch64::OPCODE::ST1Onev8b)
  .value("ST1Onev8b_POST", LIEF::assembly::aarch64::OPCODE::ST1Onev8b_POST)
  .value("ST1Onev8h", LIEF::assembly::aarch64::OPCODE::ST1Onev8h)
  .value("ST1Onev8h_POST", LIEF::assembly::aarch64::OPCODE::ST1Onev8h_POST)
  .value("ST1Threev16b", LIEF::assembly::aarch64::OPCODE::ST1Threev16b)
  .value("ST1Threev16b_POST", LIEF::assembly::aarch64::OPCODE::ST1Threev16b_POST)
  .value("ST1Threev1d", LIEF::assembly::aarch64::OPCODE::ST1Threev1d)
  .value("ST1Threev1d_POST", LIEF::assembly::aarch64::OPCODE::ST1Threev1d_POST)
  .value("ST1Threev2d", LIEF::assembly::aarch64::OPCODE::ST1Threev2d)
  .value("ST1Threev2d_POST", LIEF::assembly::aarch64::OPCODE::ST1Threev2d_POST)
  .value("ST1Threev2s", LIEF::assembly::aarch64::OPCODE::ST1Threev2s)
  .value("ST1Threev2s_POST", LIEF::assembly::aarch64::OPCODE::ST1Threev2s_POST)
  .value("ST1Threev4h", LIEF::assembly::aarch64::OPCODE::ST1Threev4h)
  .value("ST1Threev4h_POST", LIEF::assembly::aarch64::OPCODE::ST1Threev4h_POST)
  .value("ST1Threev4s", LIEF::assembly::aarch64::OPCODE::ST1Threev4s)
  .value("ST1Threev4s_POST", LIEF::assembly::aarch64::OPCODE::ST1Threev4s_POST)
  .value("ST1Threev8b", LIEF::assembly::aarch64::OPCODE::ST1Threev8b)
  .value("ST1Threev8b_POST", LIEF::assembly::aarch64::OPCODE::ST1Threev8b_POST)
  .value("ST1Threev8h", LIEF::assembly::aarch64::OPCODE::ST1Threev8h)
  .value("ST1Threev8h_POST", LIEF::assembly::aarch64::OPCODE::ST1Threev8h_POST)
  .value("ST1Twov16b", LIEF::assembly::aarch64::OPCODE::ST1Twov16b)
  .value("ST1Twov16b_POST", LIEF::assembly::aarch64::OPCODE::ST1Twov16b_POST)
  .value("ST1Twov1d", LIEF::assembly::aarch64::OPCODE::ST1Twov1d)
  .value("ST1Twov1d_POST", LIEF::assembly::aarch64::OPCODE::ST1Twov1d_POST)
  .value("ST1Twov2d", LIEF::assembly::aarch64::OPCODE::ST1Twov2d)
  .value("ST1Twov2d_POST", LIEF::assembly::aarch64::OPCODE::ST1Twov2d_POST)
  .value("ST1Twov2s", LIEF::assembly::aarch64::OPCODE::ST1Twov2s)
  .value("ST1Twov2s_POST", LIEF::assembly::aarch64::OPCODE::ST1Twov2s_POST)
  .value("ST1Twov4h", LIEF::assembly::aarch64::OPCODE::ST1Twov4h)
  .value("ST1Twov4h_POST", LIEF::assembly::aarch64::OPCODE::ST1Twov4h_POST)
  .value("ST1Twov4s", LIEF::assembly::aarch64::OPCODE::ST1Twov4s)
  .value("ST1Twov4s_POST", LIEF::assembly::aarch64::OPCODE::ST1Twov4s_POST)
  .value("ST1Twov8b", LIEF::assembly::aarch64::OPCODE::ST1Twov8b)
  .value("ST1Twov8b_POST", LIEF::assembly::aarch64::OPCODE::ST1Twov8b_POST)
  .value("ST1Twov8h", LIEF::assembly::aarch64::OPCODE::ST1Twov8h)
  .value("ST1Twov8h_POST", LIEF::assembly::aarch64::OPCODE::ST1Twov8h_POST)
  .value("ST1W", LIEF::assembly::aarch64::OPCODE::ST1W)
  .value("ST1W_2Z", LIEF::assembly::aarch64::OPCODE::ST1W_2Z)
  .value("ST1W_2Z_IMM", LIEF::assembly::aarch64::OPCODE::ST1W_2Z_IMM)
  .value("ST1W_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::ST1W_2Z_STRIDED)
  .value("ST1W_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::ST1W_2Z_STRIDED_IMM)
  .value("ST1W_4Z", LIEF::assembly::aarch64::OPCODE::ST1W_4Z)
  .value("ST1W_4Z_IMM", LIEF::assembly::aarch64::OPCODE::ST1W_4Z_IMM);
  opcodes.value("ST1W_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::ST1W_4Z_STRIDED)
  .value("ST1W_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::ST1W_4Z_STRIDED_IMM)
  .value("ST1W_D", LIEF::assembly::aarch64::OPCODE::ST1W_D)
  .value("ST1W_D_IMM", LIEF::assembly::aarch64::OPCODE::ST1W_D_IMM)
  .value("ST1W_IMM", LIEF::assembly::aarch64::OPCODE::ST1W_IMM)
  .value("ST1W_Q", LIEF::assembly::aarch64::OPCODE::ST1W_Q)
  .value("ST1W_Q_IMM", LIEF::assembly::aarch64::OPCODE::ST1W_Q_IMM)
  .value("ST1_MXIPXX_H_B", LIEF::assembly::aarch64::OPCODE::ST1_MXIPXX_H_B)
  .value("ST1_MXIPXX_H_D", LIEF::assembly::aarch64::OPCODE::ST1_MXIPXX_H_D)
  .value("ST1_MXIPXX_H_H", LIEF::assembly::aarch64::OPCODE::ST1_MXIPXX_H_H)
  .value("ST1_MXIPXX_H_Q", LIEF::assembly::aarch64::OPCODE::ST1_MXIPXX_H_Q)
  .value("ST1_MXIPXX_H_S", LIEF::assembly::aarch64::OPCODE::ST1_MXIPXX_H_S)
  .value("ST1_MXIPXX_V_B", LIEF::assembly::aarch64::OPCODE::ST1_MXIPXX_V_B)
  .value("ST1_MXIPXX_V_D", LIEF::assembly::aarch64::OPCODE::ST1_MXIPXX_V_D)
  .value("ST1_MXIPXX_V_H", LIEF::assembly::aarch64::OPCODE::ST1_MXIPXX_V_H)
  .value("ST1_MXIPXX_V_Q", LIEF::assembly::aarch64::OPCODE::ST1_MXIPXX_V_Q)
  .value("ST1_MXIPXX_V_S", LIEF::assembly::aarch64::OPCODE::ST1_MXIPXX_V_S)
  .value("ST1i16", LIEF::assembly::aarch64::OPCODE::ST1i16)
  .value("ST1i16_POST", LIEF::assembly::aarch64::OPCODE::ST1i16_POST)
  .value("ST1i32", LIEF::assembly::aarch64::OPCODE::ST1i32)
  .value("ST1i32_POST", LIEF::assembly::aarch64::OPCODE::ST1i32_POST)
  .value("ST1i64", LIEF::assembly::aarch64::OPCODE::ST1i64)
  .value("ST1i64_POST", LIEF::assembly::aarch64::OPCODE::ST1i64_POST)
  .value("ST1i8", LIEF::assembly::aarch64::OPCODE::ST1i8)
  .value("ST1i8_POST", LIEF::assembly::aarch64::OPCODE::ST1i8_POST)
  .value("ST2B", LIEF::assembly::aarch64::OPCODE::ST2B)
  .value("ST2B_IMM", LIEF::assembly::aarch64::OPCODE::ST2B_IMM)
  .value("ST2D", LIEF::assembly::aarch64::OPCODE::ST2D)
  .value("ST2D_IMM", LIEF::assembly::aarch64::OPCODE::ST2D_IMM)
  .value("ST2GPostIndex", LIEF::assembly::aarch64::OPCODE::ST2GPostIndex)
  .value("ST2GPreIndex", LIEF::assembly::aarch64::OPCODE::ST2GPreIndex)
  .value("ST2Gi", LIEF::assembly::aarch64::OPCODE::ST2Gi)
  .value("ST2H", LIEF::assembly::aarch64::OPCODE::ST2H)
  .value("ST2H_IMM", LIEF::assembly::aarch64::OPCODE::ST2H_IMM)
  .value("ST2Q", LIEF::assembly::aarch64::OPCODE::ST2Q)
  .value("ST2Q_IMM", LIEF::assembly::aarch64::OPCODE::ST2Q_IMM)
  .value("ST2Twov16b", LIEF::assembly::aarch64::OPCODE::ST2Twov16b)
  .value("ST2Twov16b_POST", LIEF::assembly::aarch64::OPCODE::ST2Twov16b_POST)
  .value("ST2Twov2d", LIEF::assembly::aarch64::OPCODE::ST2Twov2d)
  .value("ST2Twov2d_POST", LIEF::assembly::aarch64::OPCODE::ST2Twov2d_POST)
  .value("ST2Twov2s", LIEF::assembly::aarch64::OPCODE::ST2Twov2s)
  .value("ST2Twov2s_POST", LIEF::assembly::aarch64::OPCODE::ST2Twov2s_POST)
  .value("ST2Twov4h", LIEF::assembly::aarch64::OPCODE::ST2Twov4h)
  .value("ST2Twov4h_POST", LIEF::assembly::aarch64::OPCODE::ST2Twov4h_POST)
  .value("ST2Twov4s", LIEF::assembly::aarch64::OPCODE::ST2Twov4s)
  .value("ST2Twov4s_POST", LIEF::assembly::aarch64::OPCODE::ST2Twov4s_POST)
  .value("ST2Twov8b", LIEF::assembly::aarch64::OPCODE::ST2Twov8b)
  .value("ST2Twov8b_POST", LIEF::assembly::aarch64::OPCODE::ST2Twov8b_POST)
  .value("ST2Twov8h", LIEF::assembly::aarch64::OPCODE::ST2Twov8h)
  .value("ST2Twov8h_POST", LIEF::assembly::aarch64::OPCODE::ST2Twov8h_POST)
  .value("ST2W", LIEF::assembly::aarch64::OPCODE::ST2W)
  .value("ST2W_IMM", LIEF::assembly::aarch64::OPCODE::ST2W_IMM)
  .value("ST2i16", LIEF::assembly::aarch64::OPCODE::ST2i16)
  .value("ST2i16_POST", LIEF::assembly::aarch64::OPCODE::ST2i16_POST)
  .value("ST2i32", LIEF::assembly::aarch64::OPCODE::ST2i32)
  .value("ST2i32_POST", LIEF::assembly::aarch64::OPCODE::ST2i32_POST)
  .value("ST2i64", LIEF::assembly::aarch64::OPCODE::ST2i64)
  .value("ST2i64_POST", LIEF::assembly::aarch64::OPCODE::ST2i64_POST)
  .value("ST2i8", LIEF::assembly::aarch64::OPCODE::ST2i8)
  .value("ST2i8_POST", LIEF::assembly::aarch64::OPCODE::ST2i8_POST)
  .value("ST3B", LIEF::assembly::aarch64::OPCODE::ST3B)
  .value("ST3B_IMM", LIEF::assembly::aarch64::OPCODE::ST3B_IMM)
  .value("ST3D", LIEF::assembly::aarch64::OPCODE::ST3D)
  .value("ST3D_IMM", LIEF::assembly::aarch64::OPCODE::ST3D_IMM)
  .value("ST3H", LIEF::assembly::aarch64::OPCODE::ST3H)
  .value("ST3H_IMM", LIEF::assembly::aarch64::OPCODE::ST3H_IMM)
  .value("ST3Q", LIEF::assembly::aarch64::OPCODE::ST3Q)
  .value("ST3Q_IMM", LIEF::assembly::aarch64::OPCODE::ST3Q_IMM)
  .value("ST3Threev16b", LIEF::assembly::aarch64::OPCODE::ST3Threev16b)
  .value("ST3Threev16b_POST", LIEF::assembly::aarch64::OPCODE::ST3Threev16b_POST)
  .value("ST3Threev2d", LIEF::assembly::aarch64::OPCODE::ST3Threev2d)
  .value("ST3Threev2d_POST", LIEF::assembly::aarch64::OPCODE::ST3Threev2d_POST)
  .value("ST3Threev2s", LIEF::assembly::aarch64::OPCODE::ST3Threev2s)
  .value("ST3Threev2s_POST", LIEF::assembly::aarch64::OPCODE::ST3Threev2s_POST)
  .value("ST3Threev4h", LIEF::assembly::aarch64::OPCODE::ST3Threev4h)
  .value("ST3Threev4h_POST", LIEF::assembly::aarch64::OPCODE::ST3Threev4h_POST)
  .value("ST3Threev4s", LIEF::assembly::aarch64::OPCODE::ST3Threev4s)
  .value("ST3Threev4s_POST", LIEF::assembly::aarch64::OPCODE::ST3Threev4s_POST)
  .value("ST3Threev8b", LIEF::assembly::aarch64::OPCODE::ST3Threev8b)
  .value("ST3Threev8b_POST", LIEF::assembly::aarch64::OPCODE::ST3Threev8b_POST)
  .value("ST3Threev8h", LIEF::assembly::aarch64::OPCODE::ST3Threev8h)
  .value("ST3Threev8h_POST", LIEF::assembly::aarch64::OPCODE::ST3Threev8h_POST)
  .value("ST3W", LIEF::assembly::aarch64::OPCODE::ST3W)
  .value("ST3W_IMM", LIEF::assembly::aarch64::OPCODE::ST3W_IMM)
  .value("ST3i16", LIEF::assembly::aarch64::OPCODE::ST3i16)
  .value("ST3i16_POST", LIEF::assembly::aarch64::OPCODE::ST3i16_POST)
  .value("ST3i32", LIEF::assembly::aarch64::OPCODE::ST3i32)
  .value("ST3i32_POST", LIEF::assembly::aarch64::OPCODE::ST3i32_POST)
  .value("ST3i64", LIEF::assembly::aarch64::OPCODE::ST3i64)
  .value("ST3i64_POST", LIEF::assembly::aarch64::OPCODE::ST3i64_POST)
  .value("ST3i8", LIEF::assembly::aarch64::OPCODE::ST3i8)
  .value("ST3i8_POST", LIEF::assembly::aarch64::OPCODE::ST3i8_POST)
  .value("ST4B", LIEF::assembly::aarch64::OPCODE::ST4B)
  .value("ST4B_IMM", LIEF::assembly::aarch64::OPCODE::ST4B_IMM)
  .value("ST4D", LIEF::assembly::aarch64::OPCODE::ST4D)
  .value("ST4D_IMM", LIEF::assembly::aarch64::OPCODE::ST4D_IMM)
  .value("ST4Fourv16b", LIEF::assembly::aarch64::OPCODE::ST4Fourv16b)
  .value("ST4Fourv16b_POST", LIEF::assembly::aarch64::OPCODE::ST4Fourv16b_POST)
  .value("ST4Fourv2d", LIEF::assembly::aarch64::OPCODE::ST4Fourv2d)
  .value("ST4Fourv2d_POST", LIEF::assembly::aarch64::OPCODE::ST4Fourv2d_POST)
  .value("ST4Fourv2s", LIEF::assembly::aarch64::OPCODE::ST4Fourv2s)
  .value("ST4Fourv2s_POST", LIEF::assembly::aarch64::OPCODE::ST4Fourv2s_POST)
  .value("ST4Fourv4h", LIEF::assembly::aarch64::OPCODE::ST4Fourv4h)
  .value("ST4Fourv4h_POST", LIEF::assembly::aarch64::OPCODE::ST4Fourv4h_POST)
  .value("ST4Fourv4s", LIEF::assembly::aarch64::OPCODE::ST4Fourv4s)
  .value("ST4Fourv4s_POST", LIEF::assembly::aarch64::OPCODE::ST4Fourv4s_POST)
  .value("ST4Fourv8b", LIEF::assembly::aarch64::OPCODE::ST4Fourv8b)
  .value("ST4Fourv8b_POST", LIEF::assembly::aarch64::OPCODE::ST4Fourv8b_POST)
  .value("ST4Fourv8h", LIEF::assembly::aarch64::OPCODE::ST4Fourv8h)
  .value("ST4Fourv8h_POST", LIEF::assembly::aarch64::OPCODE::ST4Fourv8h_POST)
  .value("ST4H", LIEF::assembly::aarch64::OPCODE::ST4H)
  .value("ST4H_IMM", LIEF::assembly::aarch64::OPCODE::ST4H_IMM)
  .value("ST4Q", LIEF::assembly::aarch64::OPCODE::ST4Q)
  .value("ST4Q_IMM", LIEF::assembly::aarch64::OPCODE::ST4Q_IMM)
  .value("ST4W", LIEF::assembly::aarch64::OPCODE::ST4W)
  .value("ST4W_IMM", LIEF::assembly::aarch64::OPCODE::ST4W_IMM)
  .value("ST4i16", LIEF::assembly::aarch64::OPCODE::ST4i16)
  .value("ST4i16_POST", LIEF::assembly::aarch64::OPCODE::ST4i16_POST)
  .value("ST4i32", LIEF::assembly::aarch64::OPCODE::ST4i32)
  .value("ST4i32_POST", LIEF::assembly::aarch64::OPCODE::ST4i32_POST)
  .value("ST4i64", LIEF::assembly::aarch64::OPCODE::ST4i64)
  .value("ST4i64_POST", LIEF::assembly::aarch64::OPCODE::ST4i64_POST)
  .value("ST4i8", LIEF::assembly::aarch64::OPCODE::ST4i8)
  .value("ST4i8_POST", LIEF::assembly::aarch64::OPCODE::ST4i8_POST)
  .value("ST64B", LIEF::assembly::aarch64::OPCODE::ST64B)
  .value("ST64BV", LIEF::assembly::aarch64::OPCODE::ST64BV)
  .value("ST64BV0", LIEF::assembly::aarch64::OPCODE::ST64BV0)
  .value("STBFADD", LIEF::assembly::aarch64::OPCODE::STBFADD)
  .value("STBFADDL", LIEF::assembly::aarch64::OPCODE::STBFADDL)
  .value("STBFMAX", LIEF::assembly::aarch64::OPCODE::STBFMAX)
  .value("STBFMAXL", LIEF::assembly::aarch64::OPCODE::STBFMAXL)
  .value("STBFMAXNM", LIEF::assembly::aarch64::OPCODE::STBFMAXNM)
  .value("STBFMAXNML", LIEF::assembly::aarch64::OPCODE::STBFMAXNML)
  .value("STBFMIN", LIEF::assembly::aarch64::OPCODE::STBFMIN)
  .value("STBFMINL", LIEF::assembly::aarch64::OPCODE::STBFMINL)
  .value("STBFMINNM", LIEF::assembly::aarch64::OPCODE::STBFMINNM)
  .value("STBFMINNML", LIEF::assembly::aarch64::OPCODE::STBFMINNML)
  .value("STFADDD", LIEF::assembly::aarch64::OPCODE::STFADDD)
  .value("STFADDH", LIEF::assembly::aarch64::OPCODE::STFADDH)
  .value("STFADDLD", LIEF::assembly::aarch64::OPCODE::STFADDLD)
  .value("STFADDLH", LIEF::assembly::aarch64::OPCODE::STFADDLH)
  .value("STFADDLS", LIEF::assembly::aarch64::OPCODE::STFADDLS)
  .value("STFADDS", LIEF::assembly::aarch64::OPCODE::STFADDS)
  .value("STFMAXD", LIEF::assembly::aarch64::OPCODE::STFMAXD)
  .value("STFMAXH", LIEF::assembly::aarch64::OPCODE::STFMAXH)
  .value("STFMAXLD", LIEF::assembly::aarch64::OPCODE::STFMAXLD)
  .value("STFMAXLH", LIEF::assembly::aarch64::OPCODE::STFMAXLH)
  .value("STFMAXLS", LIEF::assembly::aarch64::OPCODE::STFMAXLS)
  .value("STFMAXNMD", LIEF::assembly::aarch64::OPCODE::STFMAXNMD)
  .value("STFMAXNMH", LIEF::assembly::aarch64::OPCODE::STFMAXNMH)
  .value("STFMAXNMLD", LIEF::assembly::aarch64::OPCODE::STFMAXNMLD)
  .value("STFMAXNMLH", LIEF::assembly::aarch64::OPCODE::STFMAXNMLH)
  .value("STFMAXNMLS", LIEF::assembly::aarch64::OPCODE::STFMAXNMLS)
  .value("STFMAXNMS", LIEF::assembly::aarch64::OPCODE::STFMAXNMS)
  .value("STFMAXS", LIEF::assembly::aarch64::OPCODE::STFMAXS)
  .value("STFMIND", LIEF::assembly::aarch64::OPCODE::STFMIND)
  .value("STFMINH", LIEF::assembly::aarch64::OPCODE::STFMINH)
  .value("STFMINLD", LIEF::assembly::aarch64::OPCODE::STFMINLD)
  .value("STFMINLH", LIEF::assembly::aarch64::OPCODE::STFMINLH)
  .value("STFMINLS", LIEF::assembly::aarch64::OPCODE::STFMINLS)
  .value("STFMINNMD", LIEF::assembly::aarch64::OPCODE::STFMINNMD)
  .value("STFMINNMH", LIEF::assembly::aarch64::OPCODE::STFMINNMH)
  .value("STFMINNMLD", LIEF::assembly::aarch64::OPCODE::STFMINNMLD)
  .value("STFMINNMLH", LIEF::assembly::aarch64::OPCODE::STFMINNMLH)
  .value("STFMINNMLS", LIEF::assembly::aarch64::OPCODE::STFMINNMLS)
  .value("STFMINNMS", LIEF::assembly::aarch64::OPCODE::STFMINNMS)
  .value("STFMINS", LIEF::assembly::aarch64::OPCODE::STFMINS)
  .value("STGM", LIEF::assembly::aarch64::OPCODE::STGM)
  .value("STGPi", LIEF::assembly::aarch64::OPCODE::STGPi)
  .value("STGPostIndex", LIEF::assembly::aarch64::OPCODE::STGPostIndex)
  .value("STGPpost", LIEF::assembly::aarch64::OPCODE::STGPpost)
  .value("STGPpre", LIEF::assembly::aarch64::OPCODE::STGPpre)
  .value("STGPreIndex", LIEF::assembly::aarch64::OPCODE::STGPreIndex)
  .value("STGi", LIEF::assembly::aarch64::OPCODE::STGi)
  .value("STILPW", LIEF::assembly::aarch64::OPCODE::STILPW)
  .value("STILPWpre", LIEF::assembly::aarch64::OPCODE::STILPWpre)
  .value("STILPX", LIEF::assembly::aarch64::OPCODE::STILPX)
  .value("STILPXpre", LIEF::assembly::aarch64::OPCODE::STILPXpre)
  .value("STL1", LIEF::assembly::aarch64::OPCODE::STL1)
  .value("STLLRB", LIEF::assembly::aarch64::OPCODE::STLLRB)
  .value("STLLRH", LIEF::assembly::aarch64::OPCODE::STLLRH)
  .value("STLLRW", LIEF::assembly::aarch64::OPCODE::STLLRW)
  .value("STLLRX", LIEF::assembly::aarch64::OPCODE::STLLRX)
  .value("STLRB", LIEF::assembly::aarch64::OPCODE::STLRB)
  .value("STLRH", LIEF::assembly::aarch64::OPCODE::STLRH)
  .value("STLRW", LIEF::assembly::aarch64::OPCODE::STLRW)
  .value("STLRWpre", LIEF::assembly::aarch64::OPCODE::STLRWpre)
  .value("STLRX", LIEF::assembly::aarch64::OPCODE::STLRX)
  .value("STLRXpre", LIEF::assembly::aarch64::OPCODE::STLRXpre)
  .value("STLTXRW", LIEF::assembly::aarch64::OPCODE::STLTXRW)
  .value("STLTXRX", LIEF::assembly::aarch64::OPCODE::STLTXRX)
  .value("STLURBi", LIEF::assembly::aarch64::OPCODE::STLURBi)
  .value("STLURHi", LIEF::assembly::aarch64::OPCODE::STLURHi)
  .value("STLURWi", LIEF::assembly::aarch64::OPCODE::STLURWi)
  .value("STLURXi", LIEF::assembly::aarch64::OPCODE::STLURXi)
  .value("STLURbi", LIEF::assembly::aarch64::OPCODE::STLURbi)
  .value("STLURdi", LIEF::assembly::aarch64::OPCODE::STLURdi)
  .value("STLURhi", LIEF::assembly::aarch64::OPCODE::STLURhi)
  .value("STLURqi", LIEF::assembly::aarch64::OPCODE::STLURqi)
  .value("STLURsi", LIEF::assembly::aarch64::OPCODE::STLURsi)
  .value("STLXPW", LIEF::assembly::aarch64::OPCODE::STLXPW)
  .value("STLXPX", LIEF::assembly::aarch64::OPCODE::STLXPX)
  .value("STLXRB", LIEF::assembly::aarch64::OPCODE::STLXRB)
  .value("STLXRH", LIEF::assembly::aarch64::OPCODE::STLXRH)
  .value("STLXRW", LIEF::assembly::aarch64::OPCODE::STLXRW)
  .value("STLXRX", LIEF::assembly::aarch64::OPCODE::STLXRX)
  .value("STMOPA_M2ZZZI_BtoS", LIEF::assembly::aarch64::OPCODE::STMOPA_M2ZZZI_BtoS)
  .value("STMOPA_M2ZZZI_HtoS", LIEF::assembly::aarch64::OPCODE::STMOPA_M2ZZZI_HtoS)
  .value("STNPDi", LIEF::assembly::aarch64::OPCODE::STNPDi)
  .value("STNPQi", LIEF::assembly::aarch64::OPCODE::STNPQi)
  .value("STNPSi", LIEF::assembly::aarch64::OPCODE::STNPSi)
  .value("STNPWi", LIEF::assembly::aarch64::OPCODE::STNPWi)
  .value("STNPXi", LIEF::assembly::aarch64::OPCODE::STNPXi)
  .value("STNT1B_2Z", LIEF::assembly::aarch64::OPCODE::STNT1B_2Z)
  .value("STNT1B_2Z_IMM", LIEF::assembly::aarch64::OPCODE::STNT1B_2Z_IMM)
  .value("STNT1B_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::STNT1B_2Z_STRIDED)
  .value("STNT1B_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::STNT1B_2Z_STRIDED_IMM)
  .value("STNT1B_4Z", LIEF::assembly::aarch64::OPCODE::STNT1B_4Z)
  .value("STNT1B_4Z_IMM", LIEF::assembly::aarch64::OPCODE::STNT1B_4Z_IMM)
  .value("STNT1B_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::STNT1B_4Z_STRIDED)
  .value("STNT1B_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::STNT1B_4Z_STRIDED_IMM)
  .value("STNT1B_ZRI", LIEF::assembly::aarch64::OPCODE::STNT1B_ZRI)
  .value("STNT1B_ZRR", LIEF::assembly::aarch64::OPCODE::STNT1B_ZRR)
  .value("STNT1B_ZZR_D", LIEF::assembly::aarch64::OPCODE::STNT1B_ZZR_D)
  .value("STNT1B_ZZR_S", LIEF::assembly::aarch64::OPCODE::STNT1B_ZZR_S)
  .value("STNT1D_2Z", LIEF::assembly::aarch64::OPCODE::STNT1D_2Z)
  .value("STNT1D_2Z_IMM", LIEF::assembly::aarch64::OPCODE::STNT1D_2Z_IMM)
  .value("STNT1D_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::STNT1D_2Z_STRIDED)
  .value("STNT1D_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::STNT1D_2Z_STRIDED_IMM)
  .value("STNT1D_4Z", LIEF::assembly::aarch64::OPCODE::STNT1D_4Z)
  .value("STNT1D_4Z_IMM", LIEF::assembly::aarch64::OPCODE::STNT1D_4Z_IMM)
  .value("STNT1D_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::STNT1D_4Z_STRIDED)
  .value("STNT1D_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::STNT1D_4Z_STRIDED_IMM)
  .value("STNT1D_ZRI", LIEF::assembly::aarch64::OPCODE::STNT1D_ZRI)
  .value("STNT1D_ZRR", LIEF::assembly::aarch64::OPCODE::STNT1D_ZRR)
  .value("STNT1D_ZZR_D", LIEF::assembly::aarch64::OPCODE::STNT1D_ZZR_D)
  .value("STNT1H_2Z", LIEF::assembly::aarch64::OPCODE::STNT1H_2Z)
  .value("STNT1H_2Z_IMM", LIEF::assembly::aarch64::OPCODE::STNT1H_2Z_IMM)
  .value("STNT1H_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::STNT1H_2Z_STRIDED)
  .value("STNT1H_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::STNT1H_2Z_STRIDED_IMM)
  .value("STNT1H_4Z", LIEF::assembly::aarch64::OPCODE::STNT1H_4Z)
  .value("STNT1H_4Z_IMM", LIEF::assembly::aarch64::OPCODE::STNT1H_4Z_IMM)
  .value("STNT1H_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::STNT1H_4Z_STRIDED)
  .value("STNT1H_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::STNT1H_4Z_STRIDED_IMM)
  .value("STNT1H_ZRI", LIEF::assembly::aarch64::OPCODE::STNT1H_ZRI)
  .value("STNT1H_ZRR", LIEF::assembly::aarch64::OPCODE::STNT1H_ZRR)
  .value("STNT1H_ZZR_D", LIEF::assembly::aarch64::OPCODE::STNT1H_ZZR_D)
  .value("STNT1H_ZZR_S", LIEF::assembly::aarch64::OPCODE::STNT1H_ZZR_S)
  .value("STNT1W_2Z", LIEF::assembly::aarch64::OPCODE::STNT1W_2Z)
  .value("STNT1W_2Z_IMM", LIEF::assembly::aarch64::OPCODE::STNT1W_2Z_IMM)
  .value("STNT1W_2Z_STRIDED", LIEF::assembly::aarch64::OPCODE::STNT1W_2Z_STRIDED)
  .value("STNT1W_2Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::STNT1W_2Z_STRIDED_IMM)
  .value("STNT1W_4Z", LIEF::assembly::aarch64::OPCODE::STNT1W_4Z)
  .value("STNT1W_4Z_IMM", LIEF::assembly::aarch64::OPCODE::STNT1W_4Z_IMM)
  .value("STNT1W_4Z_STRIDED", LIEF::assembly::aarch64::OPCODE::STNT1W_4Z_STRIDED)
  .value("STNT1W_4Z_STRIDED_IMM", LIEF::assembly::aarch64::OPCODE::STNT1W_4Z_STRIDED_IMM)
  .value("STNT1W_ZRI", LIEF::assembly::aarch64::OPCODE::STNT1W_ZRI)
  .value("STNT1W_ZRR", LIEF::assembly::aarch64::OPCODE::STNT1W_ZRR)
  .value("STNT1W_ZZR_D", LIEF::assembly::aarch64::OPCODE::STNT1W_ZZR_D)
  .value("STNT1W_ZZR_S", LIEF::assembly::aarch64::OPCODE::STNT1W_ZZR_S)
  .value("STPDi", LIEF::assembly::aarch64::OPCODE::STPDi)
  .value("STPDpost", LIEF::assembly::aarch64::OPCODE::STPDpost)
  .value("STPDpre", LIEF::assembly::aarch64::OPCODE::STPDpre)
  .value("STPQi", LIEF::assembly::aarch64::OPCODE::STPQi)
  .value("STPQpost", LIEF::assembly::aarch64::OPCODE::STPQpost)
  .value("STPQpre", LIEF::assembly::aarch64::OPCODE::STPQpre)
  .value("STPSi", LIEF::assembly::aarch64::OPCODE::STPSi)
  .value("STPSpost", LIEF::assembly::aarch64::OPCODE::STPSpost)
  .value("STPSpre", LIEF::assembly::aarch64::OPCODE::STPSpre)
  .value("STPWi", LIEF::assembly::aarch64::OPCODE::STPWi)
  .value("STPWpost", LIEF::assembly::aarch64::OPCODE::STPWpost)
  .value("STPWpre", LIEF::assembly::aarch64::OPCODE::STPWpre)
  .value("STPXi", LIEF::assembly::aarch64::OPCODE::STPXi)
  .value("STPXpost", LIEF::assembly::aarch64::OPCODE::STPXpost)
  .value("STPXpre", LIEF::assembly::aarch64::OPCODE::STPXpre)
  .value("STRBBpost", LIEF::assembly::aarch64::OPCODE::STRBBpost)
  .value("STRBBpre", LIEF::assembly::aarch64::OPCODE::STRBBpre)
  .value("STRBBroW", LIEF::assembly::aarch64::OPCODE::STRBBroW)
  .value("STRBBroX", LIEF::assembly::aarch64::OPCODE::STRBBroX)
  .value("STRBBui", LIEF::assembly::aarch64::OPCODE::STRBBui)
  .value("STRBpost", LIEF::assembly::aarch64::OPCODE::STRBpost)
  .value("STRBpre", LIEF::assembly::aarch64::OPCODE::STRBpre)
  .value("STRBroW", LIEF::assembly::aarch64::OPCODE::STRBroW)
  .value("STRBroX", LIEF::assembly::aarch64::OPCODE::STRBroX)
  .value("STRBui", LIEF::assembly::aarch64::OPCODE::STRBui)
  .value("STRDpost", LIEF::assembly::aarch64::OPCODE::STRDpost)
  .value("STRDpre", LIEF::assembly::aarch64::OPCODE::STRDpre)
  .value("STRDroW", LIEF::assembly::aarch64::OPCODE::STRDroW)
  .value("STRDroX", LIEF::assembly::aarch64::OPCODE::STRDroX)
  .value("STRDui", LIEF::assembly::aarch64::OPCODE::STRDui)
  .value("STRHHpost", LIEF::assembly::aarch64::OPCODE::STRHHpost)
  .value("STRHHpre", LIEF::assembly::aarch64::OPCODE::STRHHpre)
  .value("STRHHroW", LIEF::assembly::aarch64::OPCODE::STRHHroW)
  .value("STRHHroX", LIEF::assembly::aarch64::OPCODE::STRHHroX)
  .value("STRHHui", LIEF::assembly::aarch64::OPCODE::STRHHui)
  .value("STRHpost", LIEF::assembly::aarch64::OPCODE::STRHpost)
  .value("STRHpre", LIEF::assembly::aarch64::OPCODE::STRHpre)
  .value("STRHroW", LIEF::assembly::aarch64::OPCODE::STRHroW)
  .value("STRHroX", LIEF::assembly::aarch64::OPCODE::STRHroX)
  .value("STRHui", LIEF::assembly::aarch64::OPCODE::STRHui);
  opcodes.value("STRQpost", LIEF::assembly::aarch64::OPCODE::STRQpost)
  .value("STRQpre", LIEF::assembly::aarch64::OPCODE::STRQpre)
  .value("STRQroW", LIEF::assembly::aarch64::OPCODE::STRQroW)
  .value("STRQroX", LIEF::assembly::aarch64::OPCODE::STRQroX)
  .value("STRQui", LIEF::assembly::aarch64::OPCODE::STRQui)
  .value("STRSpost", LIEF::assembly::aarch64::OPCODE::STRSpost)
  .value("STRSpre", LIEF::assembly::aarch64::OPCODE::STRSpre)
  .value("STRSroW", LIEF::assembly::aarch64::OPCODE::STRSroW)
  .value("STRSroX", LIEF::assembly::aarch64::OPCODE::STRSroX)
  .value("STRSui", LIEF::assembly::aarch64::OPCODE::STRSui)
  .value("STRWpost", LIEF::assembly::aarch64::OPCODE::STRWpost)
  .value("STRWpre", LIEF::assembly::aarch64::OPCODE::STRWpre)
  .value("STRWroW", LIEF::assembly::aarch64::OPCODE::STRWroW)
  .value("STRWroX", LIEF::assembly::aarch64::OPCODE::STRWroX)
  .value("STRWui", LIEF::assembly::aarch64::OPCODE::STRWui)
  .value("STRXpost", LIEF::assembly::aarch64::OPCODE::STRXpost)
  .value("STRXpre", LIEF::assembly::aarch64::OPCODE::STRXpre)
  .value("STRXroW", LIEF::assembly::aarch64::OPCODE::STRXroW)
  .value("STRXroX", LIEF::assembly::aarch64::OPCODE::STRXroX)
  .value("STRXui", LIEF::assembly::aarch64::OPCODE::STRXui)
  .value("STR_PXI", LIEF::assembly::aarch64::OPCODE::STR_PXI)
  .value("STR_TX", LIEF::assembly::aarch64::OPCODE::STR_TX)
  .value("STR_ZA", LIEF::assembly::aarch64::OPCODE::STR_ZA)
  .value("STR_ZXI", LIEF::assembly::aarch64::OPCODE::STR_ZXI)
  .value("STSHH", LIEF::assembly::aarch64::OPCODE::STSHH)
  .value("STTNPQi", LIEF::assembly::aarch64::OPCODE::STTNPQi)
  .value("STTNPXi", LIEF::assembly::aarch64::OPCODE::STTNPXi)
  .value("STTPQi", LIEF::assembly::aarch64::OPCODE::STTPQi)
  .value("STTPQpost", LIEF::assembly::aarch64::OPCODE::STTPQpost)
  .value("STTPQpre", LIEF::assembly::aarch64::OPCODE::STTPQpre)
  .value("STTPi", LIEF::assembly::aarch64::OPCODE::STTPi)
  .value("STTPpost", LIEF::assembly::aarch64::OPCODE::STTPpost)
  .value("STTPpre", LIEF::assembly::aarch64::OPCODE::STTPpre)
  .value("STTRBi", LIEF::assembly::aarch64::OPCODE::STTRBi)
  .value("STTRHi", LIEF::assembly::aarch64::OPCODE::STTRHi)
  .value("STTRWi", LIEF::assembly::aarch64::OPCODE::STTRWi)
  .value("STTRXi", LIEF::assembly::aarch64::OPCODE::STTRXi)
  .value("STTXRWr", LIEF::assembly::aarch64::OPCODE::STTXRWr)
  .value("STTXRXr", LIEF::assembly::aarch64::OPCODE::STTXRXr)
  .value("STURBBi", LIEF::assembly::aarch64::OPCODE::STURBBi)
  .value("STURBi", LIEF::assembly::aarch64::OPCODE::STURBi)
  .value("STURDi", LIEF::assembly::aarch64::OPCODE::STURDi)
  .value("STURHHi", LIEF::assembly::aarch64::OPCODE::STURHHi)
  .value("STURHi", LIEF::assembly::aarch64::OPCODE::STURHi)
  .value("STURQi", LIEF::assembly::aarch64::OPCODE::STURQi)
  .value("STURSi", LIEF::assembly::aarch64::OPCODE::STURSi)
  .value("STURWi", LIEF::assembly::aarch64::OPCODE::STURWi)
  .value("STURXi", LIEF::assembly::aarch64::OPCODE::STURXi)
  .value("STXPW", LIEF::assembly::aarch64::OPCODE::STXPW)
  .value("STXPX", LIEF::assembly::aarch64::OPCODE::STXPX)
  .value("STXRB", LIEF::assembly::aarch64::OPCODE::STXRB)
  .value("STXRH", LIEF::assembly::aarch64::OPCODE::STXRH)
  .value("STXRW", LIEF::assembly::aarch64::OPCODE::STXRW)
  .value("STXRX", LIEF::assembly::aarch64::OPCODE::STXRX)
  .value("STZ2GPostIndex", LIEF::assembly::aarch64::OPCODE::STZ2GPostIndex)
  .value("STZ2GPreIndex", LIEF::assembly::aarch64::OPCODE::STZ2GPreIndex)
  .value("STZ2Gi", LIEF::assembly::aarch64::OPCODE::STZ2Gi)
  .value("STZGM", LIEF::assembly::aarch64::OPCODE::STZGM)
  .value("STZGPostIndex", LIEF::assembly::aarch64::OPCODE::STZGPostIndex)
  .value("STZGPreIndex", LIEF::assembly::aarch64::OPCODE::STZGPreIndex)
  .value("STZGi", LIEF::assembly::aarch64::OPCODE::STZGi)
  .value("SUBG", LIEF::assembly::aarch64::OPCODE::SUBG)
  .value("SUBHNB_ZZZ_B", LIEF::assembly::aarch64::OPCODE::SUBHNB_ZZZ_B)
  .value("SUBHNB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SUBHNB_ZZZ_H)
  .value("SUBHNB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SUBHNB_ZZZ_S)
  .value("SUBHNT_ZZZ_B", LIEF::assembly::aarch64::OPCODE::SUBHNT_ZZZ_B)
  .value("SUBHNT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SUBHNT_ZZZ_H)
  .value("SUBHNT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SUBHNT_ZZZ_S)
  .value("SUBHNv2i64_v2i32", LIEF::assembly::aarch64::OPCODE::SUBHNv2i64_v2i32)
  .value("SUBHNv2i64_v4i32", LIEF::assembly::aarch64::OPCODE::SUBHNv2i64_v4i32)
  .value("SUBHNv4i32_v4i16", LIEF::assembly::aarch64::OPCODE::SUBHNv4i32_v4i16)
  .value("SUBHNv4i32_v8i16", LIEF::assembly::aarch64::OPCODE::SUBHNv4i32_v8i16)
  .value("SUBHNv8i16_v16i8", LIEF::assembly::aarch64::OPCODE::SUBHNv8i16_v16i8)
  .value("SUBHNv8i16_v8i8", LIEF::assembly::aarch64::OPCODE::SUBHNv8i16_v8i8)
  .value("SUBP", LIEF::assembly::aarch64::OPCODE::SUBP)
  .value("SUBPS", LIEF::assembly::aarch64::OPCODE::SUBPS)
  .value("SUBPT_shift", LIEF::assembly::aarch64::OPCODE::SUBPT_shift)
  .value("SUBR_ZI_B", LIEF::assembly::aarch64::OPCODE::SUBR_ZI_B)
  .value("SUBR_ZI_D", LIEF::assembly::aarch64::OPCODE::SUBR_ZI_D)
  .value("SUBR_ZI_H", LIEF::assembly::aarch64::OPCODE::SUBR_ZI_H)
  .value("SUBR_ZI_S", LIEF::assembly::aarch64::OPCODE::SUBR_ZI_S)
  .value("SUBR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SUBR_ZPmZ_B)
  .value("SUBR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SUBR_ZPmZ_D)
  .value("SUBR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SUBR_ZPmZ_H)
  .value("SUBR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SUBR_ZPmZ_S)
  .value("SUBSWri", LIEF::assembly::aarch64::OPCODE::SUBSWri)
  .value("SUBSWrs", LIEF::assembly::aarch64::OPCODE::SUBSWrs)
  .value("SUBSWrx", LIEF::assembly::aarch64::OPCODE::SUBSWrx)
  .value("SUBSXri", LIEF::assembly::aarch64::OPCODE::SUBSXri)
  .value("SUBSXrs", LIEF::assembly::aarch64::OPCODE::SUBSXrs)
  .value("SUBSXrx", LIEF::assembly::aarch64::OPCODE::SUBSXrx)
  .value("SUBSXrx64", LIEF::assembly::aarch64::OPCODE::SUBSXrx64)
  .value("SUBWri", LIEF::assembly::aarch64::OPCODE::SUBWri)
  .value("SUBWrs", LIEF::assembly::aarch64::OPCODE::SUBWrs)
  .value("SUBWrx", LIEF::assembly::aarch64::OPCODE::SUBWrx)
  .value("SUBXri", LIEF::assembly::aarch64::OPCODE::SUBXri)
  .value("SUBXrs", LIEF::assembly::aarch64::OPCODE::SUBXrs)
  .value("SUBXrx", LIEF::assembly::aarch64::OPCODE::SUBXrx)
  .value("SUBXrx64", LIEF::assembly::aarch64::OPCODE::SUBXrx64)
  .value("SUB_VG2_M2Z2Z_D", LIEF::assembly::aarch64::OPCODE::SUB_VG2_M2Z2Z_D)
  .value("SUB_VG2_M2Z2Z_S", LIEF::assembly::aarch64::OPCODE::SUB_VG2_M2Z2Z_S)
  .value("SUB_VG2_M2ZZ_D", LIEF::assembly::aarch64::OPCODE::SUB_VG2_M2ZZ_D)
  .value("SUB_VG2_M2ZZ_S", LIEF::assembly::aarch64::OPCODE::SUB_VG2_M2ZZ_S)
  .value("SUB_VG2_M2Z_D", LIEF::assembly::aarch64::OPCODE::SUB_VG2_M2Z_D)
  .value("SUB_VG2_M2Z_S", LIEF::assembly::aarch64::OPCODE::SUB_VG2_M2Z_S)
  .value("SUB_VG4_M4Z4Z_D", LIEF::assembly::aarch64::OPCODE::SUB_VG4_M4Z4Z_D)
  .value("SUB_VG4_M4Z4Z_S", LIEF::assembly::aarch64::OPCODE::SUB_VG4_M4Z4Z_S)
  .value("SUB_VG4_M4ZZ_D", LIEF::assembly::aarch64::OPCODE::SUB_VG4_M4ZZ_D)
  .value("SUB_VG4_M4ZZ_S", LIEF::assembly::aarch64::OPCODE::SUB_VG4_M4ZZ_S)
  .value("SUB_VG4_M4Z_D", LIEF::assembly::aarch64::OPCODE::SUB_VG4_M4Z_D)
  .value("SUB_VG4_M4Z_S", LIEF::assembly::aarch64::OPCODE::SUB_VG4_M4Z_S)
  .value("SUB_ZI_B", LIEF::assembly::aarch64::OPCODE::SUB_ZI_B)
  .value("SUB_ZI_D", LIEF::assembly::aarch64::OPCODE::SUB_ZI_D)
  .value("SUB_ZI_H", LIEF::assembly::aarch64::OPCODE::SUB_ZI_H)
  .value("SUB_ZI_S", LIEF::assembly::aarch64::OPCODE::SUB_ZI_S)
  .value("SUB_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SUB_ZPmZ_B)
  .value("SUB_ZPmZ_CPA", LIEF::assembly::aarch64::OPCODE::SUB_ZPmZ_CPA)
  .value("SUB_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SUB_ZPmZ_D)
  .value("SUB_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SUB_ZPmZ_H)
  .value("SUB_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SUB_ZPmZ_S)
  .value("SUB_ZZZ_B", LIEF::assembly::aarch64::OPCODE::SUB_ZZZ_B)
  .value("SUB_ZZZ_CPA", LIEF::assembly::aarch64::OPCODE::SUB_ZZZ_CPA)
  .value("SUB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::SUB_ZZZ_D)
  .value("SUB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::SUB_ZZZ_H)
  .value("SUB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::SUB_ZZZ_S)
  .value("SUBv16i8", LIEF::assembly::aarch64::OPCODE::SUBv16i8)
  .value("SUBv1i64", LIEF::assembly::aarch64::OPCODE::SUBv1i64)
  .value("SUBv2i32", LIEF::assembly::aarch64::OPCODE::SUBv2i32)
  .value("SUBv2i64", LIEF::assembly::aarch64::OPCODE::SUBv2i64)
  .value("SUBv4i16", LIEF::assembly::aarch64::OPCODE::SUBv4i16)
  .value("SUBv4i32", LIEF::assembly::aarch64::OPCODE::SUBv4i32)
  .value("SUBv8i16", LIEF::assembly::aarch64::OPCODE::SUBv8i16)
  .value("SUBv8i8", LIEF::assembly::aarch64::OPCODE::SUBv8i8)
  .value("SUDOT_VG2_M2ZZI_BToS", LIEF::assembly::aarch64::OPCODE::SUDOT_VG2_M2ZZI_BToS)
  .value("SUDOT_VG2_M2ZZ_BToS", LIEF::assembly::aarch64::OPCODE::SUDOT_VG2_M2ZZ_BToS)
  .value("SUDOT_VG4_M4ZZI_BToS", LIEF::assembly::aarch64::OPCODE::SUDOT_VG4_M4ZZI_BToS)
  .value("SUDOT_VG4_M4ZZ_BToS", LIEF::assembly::aarch64::OPCODE::SUDOT_VG4_M4ZZ_BToS)
  .value("SUDOT_ZZZI", LIEF::assembly::aarch64::OPCODE::SUDOT_ZZZI)
  .value("SUDOTlanev16i8", LIEF::assembly::aarch64::OPCODE::SUDOTlanev16i8)
  .value("SUDOTlanev8i8", LIEF::assembly::aarch64::OPCODE::SUDOTlanev8i8)
  .value("SUMLALL_MZZI_BtoS", LIEF::assembly::aarch64::OPCODE::SUMLALL_MZZI_BtoS)
  .value("SUMLALL_VG2_M2ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::SUMLALL_VG2_M2ZZI_BtoS)
  .value("SUMLALL_VG2_M2ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::SUMLALL_VG2_M2ZZ_BtoS)
  .value("SUMLALL_VG4_M4ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::SUMLALL_VG4_M4ZZI_BtoS)
  .value("SUMLALL_VG4_M4ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::SUMLALL_VG4_M4ZZ_BtoS)
  .value("SUMOP4A_M2Z2Z_BToS", LIEF::assembly::aarch64::OPCODE::SUMOP4A_M2Z2Z_BToS)
  .value("SUMOP4A_M2Z2Z_HtoD", LIEF::assembly::aarch64::OPCODE::SUMOP4A_M2Z2Z_HtoD)
  .value("SUMOP4A_M2ZZ_BToS", LIEF::assembly::aarch64::OPCODE::SUMOP4A_M2ZZ_BToS)
  .value("SUMOP4A_M2ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SUMOP4A_M2ZZ_HtoD)
  .value("SUMOP4A_MZ2Z_BToS", LIEF::assembly::aarch64::OPCODE::SUMOP4A_MZ2Z_BToS)
  .value("SUMOP4A_MZ2Z_HtoD", LIEF::assembly::aarch64::OPCODE::SUMOP4A_MZ2Z_HtoD)
  .value("SUMOP4A_MZZ_BToS", LIEF::assembly::aarch64::OPCODE::SUMOP4A_MZZ_BToS)
  .value("SUMOP4A_MZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SUMOP4A_MZZ_HtoD)
  .value("SUMOP4S_M2Z2Z_BToS", LIEF::assembly::aarch64::OPCODE::SUMOP4S_M2Z2Z_BToS)
  .value("SUMOP4S_M2Z2Z_HtoD", LIEF::assembly::aarch64::OPCODE::SUMOP4S_M2Z2Z_HtoD)
  .value("SUMOP4S_M2ZZ_BToS", LIEF::assembly::aarch64::OPCODE::SUMOP4S_M2ZZ_BToS)
  .value("SUMOP4S_M2ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SUMOP4S_M2ZZ_HtoD)
  .value("SUMOP4S_MZ2Z_BToS", LIEF::assembly::aarch64::OPCODE::SUMOP4S_MZ2Z_BToS)
  .value("SUMOP4S_MZ2Z_HtoD", LIEF::assembly::aarch64::OPCODE::SUMOP4S_MZ2Z_HtoD)
  .value("SUMOP4S_MZZ_BToS", LIEF::assembly::aarch64::OPCODE::SUMOP4S_MZZ_BToS)
  .value("SUMOP4S_MZZ_HtoD", LIEF::assembly::aarch64::OPCODE::SUMOP4S_MZZ_HtoD)
  .value("SUMOPA_MPPZZ_D", LIEF::assembly::aarch64::OPCODE::SUMOPA_MPPZZ_D)
  .value("SUMOPA_MPPZZ_S", LIEF::assembly::aarch64::OPCODE::SUMOPA_MPPZZ_S)
  .value("SUMOPS_MPPZZ_D", LIEF::assembly::aarch64::OPCODE::SUMOPS_MPPZZ_D)
  .value("SUMOPS_MPPZZ_S", LIEF::assembly::aarch64::OPCODE::SUMOPS_MPPZZ_S)
  .value("SUNPKHI_ZZ_D", LIEF::assembly::aarch64::OPCODE::SUNPKHI_ZZ_D)
  .value("SUNPKHI_ZZ_H", LIEF::assembly::aarch64::OPCODE::SUNPKHI_ZZ_H)
  .value("SUNPKHI_ZZ_S", LIEF::assembly::aarch64::OPCODE::SUNPKHI_ZZ_S)
  .value("SUNPKLO_ZZ_D", LIEF::assembly::aarch64::OPCODE::SUNPKLO_ZZ_D)
  .value("SUNPKLO_ZZ_H", LIEF::assembly::aarch64::OPCODE::SUNPKLO_ZZ_H)
  .value("SUNPKLO_ZZ_S", LIEF::assembly::aarch64::OPCODE::SUNPKLO_ZZ_S)
  .value("SUNPK_VG2_2ZZ_D", LIEF::assembly::aarch64::OPCODE::SUNPK_VG2_2ZZ_D)
  .value("SUNPK_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::SUNPK_VG2_2ZZ_H)
  .value("SUNPK_VG2_2ZZ_S", LIEF::assembly::aarch64::OPCODE::SUNPK_VG2_2ZZ_S)
  .value("SUNPK_VG4_4Z2Z_D", LIEF::assembly::aarch64::OPCODE::SUNPK_VG4_4Z2Z_D)
  .value("SUNPK_VG4_4Z2Z_H", LIEF::assembly::aarch64::OPCODE::SUNPK_VG4_4Z2Z_H)
  .value("SUNPK_VG4_4Z2Z_S", LIEF::assembly::aarch64::OPCODE::SUNPK_VG4_4Z2Z_S)
  .value("SUQADD_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::SUQADD_ZPmZ_B)
  .value("SUQADD_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SUQADD_ZPmZ_D)
  .value("SUQADD_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SUQADD_ZPmZ_H)
  .value("SUQADD_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SUQADD_ZPmZ_S)
  .value("SUQADDv16i8", LIEF::assembly::aarch64::OPCODE::SUQADDv16i8)
  .value("SUQADDv1i16", LIEF::assembly::aarch64::OPCODE::SUQADDv1i16)
  .value("SUQADDv1i32", LIEF::assembly::aarch64::OPCODE::SUQADDv1i32)
  .value("SUQADDv1i64", LIEF::assembly::aarch64::OPCODE::SUQADDv1i64)
  .value("SUQADDv1i8", LIEF::assembly::aarch64::OPCODE::SUQADDv1i8)
  .value("SUQADDv2i32", LIEF::assembly::aarch64::OPCODE::SUQADDv2i32)
  .value("SUQADDv2i64", LIEF::assembly::aarch64::OPCODE::SUQADDv2i64)
  .value("SUQADDv4i16", LIEF::assembly::aarch64::OPCODE::SUQADDv4i16)
  .value("SUQADDv4i32", LIEF::assembly::aarch64::OPCODE::SUQADDv4i32)
  .value("SUQADDv8i16", LIEF::assembly::aarch64::OPCODE::SUQADDv8i16)
  .value("SUQADDv8i8", LIEF::assembly::aarch64::OPCODE::SUQADDv8i8)
  .value("SUTMOPA_M2ZZZI_BtoS", LIEF::assembly::aarch64::OPCODE::SUTMOPA_M2ZZZI_BtoS)
  .value("SUVDOT_VG4_M4ZZI_BToS", LIEF::assembly::aarch64::OPCODE::SUVDOT_VG4_M4ZZI_BToS)
  .value("SVC", LIEF::assembly::aarch64::OPCODE::SVC)
  .value("SVDOT_VG2_M2ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::SVDOT_VG2_M2ZZI_HtoS)
  .value("SVDOT_VG4_M4ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::SVDOT_VG4_M4ZZI_BtoS)
  .value("SVDOT_VG4_M4ZZI_HtoD", LIEF::assembly::aarch64::OPCODE::SVDOT_VG4_M4ZZI_HtoD)
  .value("SWPAB", LIEF::assembly::aarch64::OPCODE::SWPAB)
  .value("SWPAH", LIEF::assembly::aarch64::OPCODE::SWPAH)
  .value("SWPALB", LIEF::assembly::aarch64::OPCODE::SWPALB)
  .value("SWPALH", LIEF::assembly::aarch64::OPCODE::SWPALH)
  .value("SWPALW", LIEF::assembly::aarch64::OPCODE::SWPALW)
  .value("SWPALX", LIEF::assembly::aarch64::OPCODE::SWPALX)
  .value("SWPAW", LIEF::assembly::aarch64::OPCODE::SWPAW)
  .value("SWPAX", LIEF::assembly::aarch64::OPCODE::SWPAX)
  .value("SWPB", LIEF::assembly::aarch64::OPCODE::SWPB)
  .value("SWPH", LIEF::assembly::aarch64::OPCODE::SWPH)
  .value("SWPLB", LIEF::assembly::aarch64::OPCODE::SWPLB)
  .value("SWPLH", LIEF::assembly::aarch64::OPCODE::SWPLH)
  .value("SWPLW", LIEF::assembly::aarch64::OPCODE::SWPLW)
  .value("SWPLX", LIEF::assembly::aarch64::OPCODE::SWPLX)
  .value("SWPP", LIEF::assembly::aarch64::OPCODE::SWPP)
  .value("SWPPA", LIEF::assembly::aarch64::OPCODE::SWPPA)
  .value("SWPPAL", LIEF::assembly::aarch64::OPCODE::SWPPAL)
  .value("SWPPL", LIEF::assembly::aarch64::OPCODE::SWPPL)
  .value("SWPTALW", LIEF::assembly::aarch64::OPCODE::SWPTALW)
  .value("SWPTALX", LIEF::assembly::aarch64::OPCODE::SWPTALX)
  .value("SWPTAW", LIEF::assembly::aarch64::OPCODE::SWPTAW)
  .value("SWPTAX", LIEF::assembly::aarch64::OPCODE::SWPTAX)
  .value("SWPTLW", LIEF::assembly::aarch64::OPCODE::SWPTLW)
  .value("SWPTLX", LIEF::assembly::aarch64::OPCODE::SWPTLX)
  .value("SWPTW", LIEF::assembly::aarch64::OPCODE::SWPTW)
  .value("SWPTX", LIEF::assembly::aarch64::OPCODE::SWPTX)
  .value("SWPW", LIEF::assembly::aarch64::OPCODE::SWPW)
  .value("SWPX", LIEF::assembly::aarch64::OPCODE::SWPX)
  .value("SXTB_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SXTB_ZPmZ_D)
  .value("SXTB_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::SXTB_ZPmZ_H)
  .value("SXTB_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SXTB_ZPmZ_S)
  .value("SXTB_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::SXTB_ZPzZ_D)
  .value("SXTB_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::SXTB_ZPzZ_H)
  .value("SXTB_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::SXTB_ZPzZ_S)
  .value("SXTH_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SXTH_ZPmZ_D)
  .value("SXTH_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::SXTH_ZPmZ_S)
  .value("SXTH_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::SXTH_ZPzZ_D)
  .value("SXTH_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::SXTH_ZPzZ_S)
  .value("SXTW_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::SXTW_ZPmZ_D)
  .value("SXTW_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::SXTW_ZPzZ_D)
  .value("SYSLxt", LIEF::assembly::aarch64::OPCODE::SYSLxt)
  .value("SYSPxt", LIEF::assembly::aarch64::OPCODE::SYSPxt)
  .value("SYSPxt_XZR", LIEF::assembly::aarch64::OPCODE::SYSPxt_XZR)
  .value("SYSxt", LIEF::assembly::aarch64::OPCODE::SYSxt)
  .value("TBLQ_ZZZ_B", LIEF::assembly::aarch64::OPCODE::TBLQ_ZZZ_B)
  .value("TBLQ_ZZZ_D", LIEF::assembly::aarch64::OPCODE::TBLQ_ZZZ_D)
  .value("TBLQ_ZZZ_H", LIEF::assembly::aarch64::OPCODE::TBLQ_ZZZ_H)
  .value("TBLQ_ZZZ_S", LIEF::assembly::aarch64::OPCODE::TBLQ_ZZZ_S)
  .value("TBL_ZZZZ_B", LIEF::assembly::aarch64::OPCODE::TBL_ZZZZ_B)
  .value("TBL_ZZZZ_D", LIEF::assembly::aarch64::OPCODE::TBL_ZZZZ_D)
  .value("TBL_ZZZZ_H", LIEF::assembly::aarch64::OPCODE::TBL_ZZZZ_H)
  .value("TBL_ZZZZ_S", LIEF::assembly::aarch64::OPCODE::TBL_ZZZZ_S)
  .value("TBL_ZZZ_B", LIEF::assembly::aarch64::OPCODE::TBL_ZZZ_B)
  .value("TBL_ZZZ_D", LIEF::assembly::aarch64::OPCODE::TBL_ZZZ_D)
  .value("TBL_ZZZ_H", LIEF::assembly::aarch64::OPCODE::TBL_ZZZ_H)
  .value("TBL_ZZZ_S", LIEF::assembly::aarch64::OPCODE::TBL_ZZZ_S)
  .value("TBLv16i8Four", LIEF::assembly::aarch64::OPCODE::TBLv16i8Four)
  .value("TBLv16i8One", LIEF::assembly::aarch64::OPCODE::TBLv16i8One)
  .value("TBLv16i8Three", LIEF::assembly::aarch64::OPCODE::TBLv16i8Three)
  .value("TBLv16i8Two", LIEF::assembly::aarch64::OPCODE::TBLv16i8Two)
  .value("TBLv8i8Four", LIEF::assembly::aarch64::OPCODE::TBLv8i8Four)
  .value("TBLv8i8One", LIEF::assembly::aarch64::OPCODE::TBLv8i8One)
  .value("TBLv8i8Three", LIEF::assembly::aarch64::OPCODE::TBLv8i8Three)
  .value("TBLv8i8Two", LIEF::assembly::aarch64::OPCODE::TBLv8i8Two)
  .value("TBNZW", LIEF::assembly::aarch64::OPCODE::TBNZW)
  .value("TBNZX", LIEF::assembly::aarch64::OPCODE::TBNZX)
  .value("TBXQ_ZZZ_B", LIEF::assembly::aarch64::OPCODE::TBXQ_ZZZ_B)
  .value("TBXQ_ZZZ_D", LIEF::assembly::aarch64::OPCODE::TBXQ_ZZZ_D)
  .value("TBXQ_ZZZ_H", LIEF::assembly::aarch64::OPCODE::TBXQ_ZZZ_H)
  .value("TBXQ_ZZZ_S", LIEF::assembly::aarch64::OPCODE::TBXQ_ZZZ_S)
  .value("TBX_ZZZ_B", LIEF::assembly::aarch64::OPCODE::TBX_ZZZ_B)
  .value("TBX_ZZZ_D", LIEF::assembly::aarch64::OPCODE::TBX_ZZZ_D)
  .value("TBX_ZZZ_H", LIEF::assembly::aarch64::OPCODE::TBX_ZZZ_H)
  .value("TBX_ZZZ_S", LIEF::assembly::aarch64::OPCODE::TBX_ZZZ_S)
  .value("TBXv16i8Four", LIEF::assembly::aarch64::OPCODE::TBXv16i8Four)
  .value("TBXv16i8One", LIEF::assembly::aarch64::OPCODE::TBXv16i8One)
  .value("TBXv16i8Three", LIEF::assembly::aarch64::OPCODE::TBXv16i8Three)
  .value("TBXv16i8Two", LIEF::assembly::aarch64::OPCODE::TBXv16i8Two)
  .value("TBXv8i8Four", LIEF::assembly::aarch64::OPCODE::TBXv8i8Four)
  .value("TBXv8i8One", LIEF::assembly::aarch64::OPCODE::TBXv8i8One)
  .value("TBXv8i8Three", LIEF::assembly::aarch64::OPCODE::TBXv8i8Three)
  .value("TBXv8i8Two", LIEF::assembly::aarch64::OPCODE::TBXv8i8Two)
  .value("TBZW", LIEF::assembly::aarch64::OPCODE::TBZW)
  .value("TBZX", LIEF::assembly::aarch64::OPCODE::TBZX)
  .value("TCANCEL", LIEF::assembly::aarch64::OPCODE::TCANCEL)
  .value("TCOMMIT", LIEF::assembly::aarch64::OPCODE::TCOMMIT)
  .value("TRCIT", LIEF::assembly::aarch64::OPCODE::TRCIT)
  .value("TRN1_PPP_B", LIEF::assembly::aarch64::OPCODE::TRN1_PPP_B)
  .value("TRN1_PPP_D", LIEF::assembly::aarch64::OPCODE::TRN1_PPP_D)
  .value("TRN1_PPP_H", LIEF::assembly::aarch64::OPCODE::TRN1_PPP_H)
  .value("TRN1_PPP_S", LIEF::assembly::aarch64::OPCODE::TRN1_PPP_S)
  .value("TRN1_ZZZ_B", LIEF::assembly::aarch64::OPCODE::TRN1_ZZZ_B)
  .value("TRN1_ZZZ_D", LIEF::assembly::aarch64::OPCODE::TRN1_ZZZ_D)
  .value("TRN1_ZZZ_H", LIEF::assembly::aarch64::OPCODE::TRN1_ZZZ_H)
  .value("TRN1_ZZZ_Q", LIEF::assembly::aarch64::OPCODE::TRN1_ZZZ_Q)
  .value("TRN1_ZZZ_S", LIEF::assembly::aarch64::OPCODE::TRN1_ZZZ_S)
  .value("TRN1v16i8", LIEF::assembly::aarch64::OPCODE::TRN1v16i8)
  .value("TRN1v2i32", LIEF::assembly::aarch64::OPCODE::TRN1v2i32)
  .value("TRN1v2i64", LIEF::assembly::aarch64::OPCODE::TRN1v2i64)
  .value("TRN1v4i16", LIEF::assembly::aarch64::OPCODE::TRN1v4i16)
  .value("TRN1v4i32", LIEF::assembly::aarch64::OPCODE::TRN1v4i32)
  .value("TRN1v8i16", LIEF::assembly::aarch64::OPCODE::TRN1v8i16);
  opcodes.value("TRN1v8i8", LIEF::assembly::aarch64::OPCODE::TRN1v8i8)
  .value("TRN2_PPP_B", LIEF::assembly::aarch64::OPCODE::TRN2_PPP_B)
  .value("TRN2_PPP_D", LIEF::assembly::aarch64::OPCODE::TRN2_PPP_D)
  .value("TRN2_PPP_H", LIEF::assembly::aarch64::OPCODE::TRN2_PPP_H)
  .value("TRN2_PPP_S", LIEF::assembly::aarch64::OPCODE::TRN2_PPP_S)
  .value("TRN2_ZZZ_B", LIEF::assembly::aarch64::OPCODE::TRN2_ZZZ_B)
  .value("TRN2_ZZZ_D", LIEF::assembly::aarch64::OPCODE::TRN2_ZZZ_D)
  .value("TRN2_ZZZ_H", LIEF::assembly::aarch64::OPCODE::TRN2_ZZZ_H)
  .value("TRN2_ZZZ_Q", LIEF::assembly::aarch64::OPCODE::TRN2_ZZZ_Q)
  .value("TRN2_ZZZ_S", LIEF::assembly::aarch64::OPCODE::TRN2_ZZZ_S)
  .value("TRN2v16i8", LIEF::assembly::aarch64::OPCODE::TRN2v16i8)
  .value("TRN2v2i32", LIEF::assembly::aarch64::OPCODE::TRN2v2i32)
  .value("TRN2v2i64", LIEF::assembly::aarch64::OPCODE::TRN2v2i64)
  .value("TRN2v4i16", LIEF::assembly::aarch64::OPCODE::TRN2v4i16)
  .value("TRN2v4i32", LIEF::assembly::aarch64::OPCODE::TRN2v4i32)
  .value("TRN2v8i16", LIEF::assembly::aarch64::OPCODE::TRN2v8i16)
  .value("TRN2v8i8", LIEF::assembly::aarch64::OPCODE::TRN2v8i8)
  .value("TSB", LIEF::assembly::aarch64::OPCODE::TSB)
  .value("TSTART", LIEF::assembly::aarch64::OPCODE::TSTART)
  .value("TTEST", LIEF::assembly::aarch64::OPCODE::TTEST)
  .value("UABALB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UABALB_ZZZ_D)
  .value("UABALB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UABALB_ZZZ_H)
  .value("UABALB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UABALB_ZZZ_S)
  .value("UABALT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UABALT_ZZZ_D)
  .value("UABALT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UABALT_ZZZ_H)
  .value("UABALT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UABALT_ZZZ_S)
  .value("UABALv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::UABALv16i8_v8i16)
  .value("UABALv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::UABALv2i32_v2i64)
  .value("UABALv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::UABALv4i16_v4i32)
  .value("UABALv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::UABALv4i32_v2i64)
  .value("UABALv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::UABALv8i16_v4i32)
  .value("UABALv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::UABALv8i8_v8i16)
  .value("UABA_ZZZ_B", LIEF::assembly::aarch64::OPCODE::UABA_ZZZ_B)
  .value("UABA_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UABA_ZZZ_D)
  .value("UABA_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UABA_ZZZ_H)
  .value("UABA_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UABA_ZZZ_S)
  .value("UABAv16i8", LIEF::assembly::aarch64::OPCODE::UABAv16i8)
  .value("UABAv2i32", LIEF::assembly::aarch64::OPCODE::UABAv2i32)
  .value("UABAv4i16", LIEF::assembly::aarch64::OPCODE::UABAv4i16)
  .value("UABAv4i32", LIEF::assembly::aarch64::OPCODE::UABAv4i32)
  .value("UABAv8i16", LIEF::assembly::aarch64::OPCODE::UABAv8i16)
  .value("UABAv8i8", LIEF::assembly::aarch64::OPCODE::UABAv8i8)
  .value("UABDLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UABDLB_ZZZ_D)
  .value("UABDLB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UABDLB_ZZZ_H)
  .value("UABDLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UABDLB_ZZZ_S)
  .value("UABDLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UABDLT_ZZZ_D)
  .value("UABDLT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UABDLT_ZZZ_H)
  .value("UABDLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UABDLT_ZZZ_S)
  .value("UABDLv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::UABDLv16i8_v8i16)
  .value("UABDLv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::UABDLv2i32_v2i64)
  .value("UABDLv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::UABDLv4i16_v4i32)
  .value("UABDLv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::UABDLv4i32_v2i64)
  .value("UABDLv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::UABDLv8i16_v4i32)
  .value("UABDLv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::UABDLv8i8_v8i16)
  .value("UABD_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UABD_ZPmZ_B)
  .value("UABD_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UABD_ZPmZ_D)
  .value("UABD_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UABD_ZPmZ_H)
  .value("UABD_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UABD_ZPmZ_S)
  .value("UABDv16i8", LIEF::assembly::aarch64::OPCODE::UABDv16i8)
  .value("UABDv2i32", LIEF::assembly::aarch64::OPCODE::UABDv2i32)
  .value("UABDv4i16", LIEF::assembly::aarch64::OPCODE::UABDv4i16)
  .value("UABDv4i32", LIEF::assembly::aarch64::OPCODE::UABDv4i32)
  .value("UABDv8i16", LIEF::assembly::aarch64::OPCODE::UABDv8i16)
  .value("UABDv8i8", LIEF::assembly::aarch64::OPCODE::UABDv8i8)
  .value("UADALP_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UADALP_ZPmZ_D)
  .value("UADALP_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UADALP_ZPmZ_H)
  .value("UADALP_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UADALP_ZPmZ_S)
  .value("UADALPv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::UADALPv16i8_v8i16)
  .value("UADALPv2i32_v1i64", LIEF::assembly::aarch64::OPCODE::UADALPv2i32_v1i64)
  .value("UADALPv4i16_v2i32", LIEF::assembly::aarch64::OPCODE::UADALPv4i16_v2i32)
  .value("UADALPv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::UADALPv4i32_v2i64)
  .value("UADALPv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::UADALPv8i16_v4i32)
  .value("UADALPv8i8_v4i16", LIEF::assembly::aarch64::OPCODE::UADALPv8i8_v4i16)
  .value("UADDLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UADDLB_ZZZ_D)
  .value("UADDLB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UADDLB_ZZZ_H)
  .value("UADDLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UADDLB_ZZZ_S)
  .value("UADDLPv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::UADDLPv16i8_v8i16)
  .value("UADDLPv2i32_v1i64", LIEF::assembly::aarch64::OPCODE::UADDLPv2i32_v1i64)
  .value("UADDLPv4i16_v2i32", LIEF::assembly::aarch64::OPCODE::UADDLPv4i16_v2i32)
  .value("UADDLPv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::UADDLPv4i32_v2i64)
  .value("UADDLPv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::UADDLPv8i16_v4i32)
  .value("UADDLPv8i8_v4i16", LIEF::assembly::aarch64::OPCODE::UADDLPv8i8_v4i16)
  .value("UADDLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UADDLT_ZZZ_D)
  .value("UADDLT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UADDLT_ZZZ_H)
  .value("UADDLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UADDLT_ZZZ_S)
  .value("UADDLVv16i8v", LIEF::assembly::aarch64::OPCODE::UADDLVv16i8v)
  .value("UADDLVv4i16v", LIEF::assembly::aarch64::OPCODE::UADDLVv4i16v)
  .value("UADDLVv4i32v", LIEF::assembly::aarch64::OPCODE::UADDLVv4i32v)
  .value("UADDLVv8i16v", LIEF::assembly::aarch64::OPCODE::UADDLVv8i16v)
  .value("UADDLVv8i8v", LIEF::assembly::aarch64::OPCODE::UADDLVv8i8v)
  .value("UADDLv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::UADDLv16i8_v8i16)
  .value("UADDLv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::UADDLv2i32_v2i64)
  .value("UADDLv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::UADDLv4i16_v4i32)
  .value("UADDLv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::UADDLv4i32_v2i64)
  .value("UADDLv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::UADDLv8i16_v4i32)
  .value("UADDLv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::UADDLv8i8_v8i16)
  .value("UADDV_VPZ_B", LIEF::assembly::aarch64::OPCODE::UADDV_VPZ_B)
  .value("UADDV_VPZ_D", LIEF::assembly::aarch64::OPCODE::UADDV_VPZ_D)
  .value("UADDV_VPZ_H", LIEF::assembly::aarch64::OPCODE::UADDV_VPZ_H)
  .value("UADDV_VPZ_S", LIEF::assembly::aarch64::OPCODE::UADDV_VPZ_S)
  .value("UADDWB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UADDWB_ZZZ_D)
  .value("UADDWB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UADDWB_ZZZ_H)
  .value("UADDWB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UADDWB_ZZZ_S)
  .value("UADDWT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UADDWT_ZZZ_D)
  .value("UADDWT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UADDWT_ZZZ_H)
  .value("UADDWT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UADDWT_ZZZ_S)
  .value("UADDWv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::UADDWv16i8_v8i16)
  .value("UADDWv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::UADDWv2i32_v2i64)
  .value("UADDWv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::UADDWv4i16_v4i32)
  .value("UADDWv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::UADDWv4i32_v2i64)
  .value("UADDWv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::UADDWv8i16_v4i32)
  .value("UADDWv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::UADDWv8i8_v8i16)
  .value("UBFMWri", LIEF::assembly::aarch64::OPCODE::UBFMWri)
  .value("UBFMXri", LIEF::assembly::aarch64::OPCODE::UBFMXri)
  .value("UCLAMP_VG2_2Z2Z_B", LIEF::assembly::aarch64::OPCODE::UCLAMP_VG2_2Z2Z_B)
  .value("UCLAMP_VG2_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::UCLAMP_VG2_2Z2Z_D)
  .value("UCLAMP_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::UCLAMP_VG2_2Z2Z_H)
  .value("UCLAMP_VG2_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::UCLAMP_VG2_2Z2Z_S)
  .value("UCLAMP_VG4_4Z4Z_B", LIEF::assembly::aarch64::OPCODE::UCLAMP_VG4_4Z4Z_B)
  .value("UCLAMP_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::UCLAMP_VG4_4Z4Z_D)
  .value("UCLAMP_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::UCLAMP_VG4_4Z4Z_H)
  .value("UCLAMP_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::UCLAMP_VG4_4Z4Z_S)
  .value("UCLAMP_ZZZ_B", LIEF::assembly::aarch64::OPCODE::UCLAMP_ZZZ_B)
  .value("UCLAMP_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UCLAMP_ZZZ_D)
  .value("UCLAMP_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UCLAMP_ZZZ_H)
  .value("UCLAMP_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UCLAMP_ZZZ_S)
  .value("UCVTFDSr", LIEF::assembly::aarch64::OPCODE::UCVTFDSr)
  .value("UCVTFHDr", LIEF::assembly::aarch64::OPCODE::UCVTFHDr)
  .value("UCVTFHSr", LIEF::assembly::aarch64::OPCODE::UCVTFHSr)
  .value("UCVTFSDr", LIEF::assembly::aarch64::OPCODE::UCVTFSDr)
  .value("UCVTFSWDri", LIEF::assembly::aarch64::OPCODE::UCVTFSWDri)
  .value("UCVTFSWHri", LIEF::assembly::aarch64::OPCODE::UCVTFSWHri)
  .value("UCVTFSWSri", LIEF::assembly::aarch64::OPCODE::UCVTFSWSri)
  .value("UCVTFSXDri", LIEF::assembly::aarch64::OPCODE::UCVTFSXDri)
  .value("UCVTFSXHri", LIEF::assembly::aarch64::OPCODE::UCVTFSXHri)
  .value("UCVTFSXSri", LIEF::assembly::aarch64::OPCODE::UCVTFSXSri)
  .value("UCVTFUWDri", LIEF::assembly::aarch64::OPCODE::UCVTFUWDri)
  .value("UCVTFUWHri", LIEF::assembly::aarch64::OPCODE::UCVTFUWHri)
  .value("UCVTFUWSri", LIEF::assembly::aarch64::OPCODE::UCVTFUWSri)
  .value("UCVTFUXDri", LIEF::assembly::aarch64::OPCODE::UCVTFUXDri)
  .value("UCVTFUXHri", LIEF::assembly::aarch64::OPCODE::UCVTFUXHri)
  .value("UCVTFUXSri", LIEF::assembly::aarch64::OPCODE::UCVTFUXSri)
  .value("UCVTF_2Z2Z_StoS", LIEF::assembly::aarch64::OPCODE::UCVTF_2Z2Z_StoS)
  .value("UCVTF_4Z4Z_StoS", LIEF::assembly::aarch64::OPCODE::UCVTF_4Z4Z_StoS)
  .value("UCVTF_ZPmZ_DtoD", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPmZ_DtoD)
  .value("UCVTF_ZPmZ_DtoH", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPmZ_DtoH)
  .value("UCVTF_ZPmZ_DtoS", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPmZ_DtoS)
  .value("UCVTF_ZPmZ_HtoH", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPmZ_HtoH)
  .value("UCVTF_ZPmZ_StoD", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPmZ_StoD)
  .value("UCVTF_ZPmZ_StoH", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPmZ_StoH)
  .value("UCVTF_ZPmZ_StoS", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPmZ_StoS)
  .value("UCVTF_ZPzZ_DtoD", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPzZ_DtoD)
  .value("UCVTF_ZPzZ_DtoH", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPzZ_DtoH)
  .value("UCVTF_ZPzZ_DtoS", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPzZ_DtoS)
  .value("UCVTF_ZPzZ_HtoH", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPzZ_HtoH)
  .value("UCVTF_ZPzZ_StoD", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPzZ_StoD)
  .value("UCVTF_ZPzZ_StoH", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPzZ_StoH)
  .value("UCVTF_ZPzZ_StoS", LIEF::assembly::aarch64::OPCODE::UCVTF_ZPzZ_StoS)
  .value("UCVTFd", LIEF::assembly::aarch64::OPCODE::UCVTFd)
  .value("UCVTFh", LIEF::assembly::aarch64::OPCODE::UCVTFh)
  .value("UCVTFs", LIEF::assembly::aarch64::OPCODE::UCVTFs)
  .value("UCVTFv1i16", LIEF::assembly::aarch64::OPCODE::UCVTFv1i16)
  .value("UCVTFv1i32", LIEF::assembly::aarch64::OPCODE::UCVTFv1i32)
  .value("UCVTFv1i64", LIEF::assembly::aarch64::OPCODE::UCVTFv1i64)
  .value("UCVTFv2f32", LIEF::assembly::aarch64::OPCODE::UCVTFv2f32)
  .value("UCVTFv2f64", LIEF::assembly::aarch64::OPCODE::UCVTFv2f64)
  .value("UCVTFv2i32_shift", LIEF::assembly::aarch64::OPCODE::UCVTFv2i32_shift)
  .value("UCVTFv2i64_shift", LIEF::assembly::aarch64::OPCODE::UCVTFv2i64_shift)
  .value("UCVTFv4f16", LIEF::assembly::aarch64::OPCODE::UCVTFv4f16)
  .value("UCVTFv4f32", LIEF::assembly::aarch64::OPCODE::UCVTFv4f32)
  .value("UCVTFv4i16_shift", LIEF::assembly::aarch64::OPCODE::UCVTFv4i16_shift)
  .value("UCVTFv4i32_shift", LIEF::assembly::aarch64::OPCODE::UCVTFv4i32_shift)
  .value("UCVTFv8f16", LIEF::assembly::aarch64::OPCODE::UCVTFv8f16)
  .value("UCVTFv8i16_shift", LIEF::assembly::aarch64::OPCODE::UCVTFv8i16_shift)
  .value("UDF", LIEF::assembly::aarch64::OPCODE::UDF)
  .value("UDIVR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UDIVR_ZPmZ_D)
  .value("UDIVR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UDIVR_ZPmZ_S)
  .value("UDIVWr", LIEF::assembly::aarch64::OPCODE::UDIVWr)
  .value("UDIVXr", LIEF::assembly::aarch64::OPCODE::UDIVXr)
  .value("UDIV_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UDIV_ZPmZ_D)
  .value("UDIV_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UDIV_ZPmZ_S)
  .value("UDOT_VG2_M2Z2Z_BtoS", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2Z2Z_BtoS)
  .value("UDOT_VG2_M2Z2Z_HtoD", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2Z2Z_HtoD)
  .value("UDOT_VG2_M2Z2Z_HtoS", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2Z2Z_HtoS)
  .value("UDOT_VG2_M2ZZI_BToS", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2ZZI_BToS)
  .value("UDOT_VG2_M2ZZI_HToS", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2ZZI_HToS)
  .value("UDOT_VG2_M2ZZI_HtoD", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2ZZI_HtoD)
  .value("UDOT_VG2_M2ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2ZZ_BtoS)
  .value("UDOT_VG2_M2ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2ZZ_HtoD)
  .value("UDOT_VG2_M2ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::UDOT_VG2_M2ZZ_HtoS)
  .value("UDOT_VG4_M4Z4Z_BtoS", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4Z4Z_BtoS)
  .value("UDOT_VG4_M4Z4Z_HtoD", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4Z4Z_HtoD)
  .value("UDOT_VG4_M4Z4Z_HtoS", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4Z4Z_HtoS)
  .value("UDOT_VG4_M4ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4ZZI_BtoS)
  .value("UDOT_VG4_M4ZZI_HToS", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4ZZI_HToS)
  .value("UDOT_VG4_M4ZZI_HtoD", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4ZZI_HtoD)
  .value("UDOT_VG4_M4ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4ZZ_BtoS)
  .value("UDOT_VG4_M4ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4ZZ_HtoD)
  .value("UDOT_VG4_M4ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::UDOT_VG4_M4ZZ_HtoS)
  .value("UDOT_ZZZI_D", LIEF::assembly::aarch64::OPCODE::UDOT_ZZZI_D)
  .value("UDOT_ZZZI_HtoS", LIEF::assembly::aarch64::OPCODE::UDOT_ZZZI_HtoS)
  .value("UDOT_ZZZI_S", LIEF::assembly::aarch64::OPCODE::UDOT_ZZZI_S)
  .value("UDOT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UDOT_ZZZ_D)
  .value("UDOT_ZZZ_HtoS", LIEF::assembly::aarch64::OPCODE::UDOT_ZZZ_HtoS)
  .value("UDOT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UDOT_ZZZ_S)
  .value("UDOTlanev16i8", LIEF::assembly::aarch64::OPCODE::UDOTlanev16i8)
  .value("UDOTlanev8i8", LIEF::assembly::aarch64::OPCODE::UDOTlanev8i8)
  .value("UDOTv16i8", LIEF::assembly::aarch64::OPCODE::UDOTv16i8)
  .value("UDOTv8i8", LIEF::assembly::aarch64::OPCODE::UDOTv8i8)
  .value("UHADD_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UHADD_ZPmZ_B)
  .value("UHADD_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UHADD_ZPmZ_D)
  .value("UHADD_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UHADD_ZPmZ_H)
  .value("UHADD_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UHADD_ZPmZ_S)
  .value("UHADDv16i8", LIEF::assembly::aarch64::OPCODE::UHADDv16i8)
  .value("UHADDv2i32", LIEF::assembly::aarch64::OPCODE::UHADDv2i32)
  .value("UHADDv4i16", LIEF::assembly::aarch64::OPCODE::UHADDv4i16)
  .value("UHADDv4i32", LIEF::assembly::aarch64::OPCODE::UHADDv4i32)
  .value("UHADDv8i16", LIEF::assembly::aarch64::OPCODE::UHADDv8i16)
  .value("UHADDv8i8", LIEF::assembly::aarch64::OPCODE::UHADDv8i8)
  .value("UHSUBR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UHSUBR_ZPmZ_B)
  .value("UHSUBR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UHSUBR_ZPmZ_D)
  .value("UHSUBR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UHSUBR_ZPmZ_H)
  .value("UHSUBR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UHSUBR_ZPmZ_S)
  .value("UHSUB_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UHSUB_ZPmZ_B)
  .value("UHSUB_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UHSUB_ZPmZ_D)
  .value("UHSUB_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UHSUB_ZPmZ_H)
  .value("UHSUB_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UHSUB_ZPmZ_S)
  .value("UHSUBv16i8", LIEF::assembly::aarch64::OPCODE::UHSUBv16i8)
  .value("UHSUBv2i32", LIEF::assembly::aarch64::OPCODE::UHSUBv2i32)
  .value("UHSUBv4i16", LIEF::assembly::aarch64::OPCODE::UHSUBv4i16)
  .value("UHSUBv4i32", LIEF::assembly::aarch64::OPCODE::UHSUBv4i32)
  .value("UHSUBv8i16", LIEF::assembly::aarch64::OPCODE::UHSUBv8i16)
  .value("UHSUBv8i8", LIEF::assembly::aarch64::OPCODE::UHSUBv8i8)
  .value("UMADDLrrr", LIEF::assembly::aarch64::OPCODE::UMADDLrrr)
  .value("UMAXP_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UMAXP_ZPmZ_B)
  .value("UMAXP_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UMAXP_ZPmZ_D)
  .value("UMAXP_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UMAXP_ZPmZ_H)
  .value("UMAXP_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UMAXP_ZPmZ_S)
  .value("UMAXPv16i8", LIEF::assembly::aarch64::OPCODE::UMAXPv16i8)
  .value("UMAXPv2i32", LIEF::assembly::aarch64::OPCODE::UMAXPv2i32)
  .value("UMAXPv4i16", LIEF::assembly::aarch64::OPCODE::UMAXPv4i16)
  .value("UMAXPv4i32", LIEF::assembly::aarch64::OPCODE::UMAXPv4i32)
  .value("UMAXPv8i16", LIEF::assembly::aarch64::OPCODE::UMAXPv8i16)
  .value("UMAXPv8i8", LIEF::assembly::aarch64::OPCODE::UMAXPv8i8)
  .value("UMAXQV_VPZ_B", LIEF::assembly::aarch64::OPCODE::UMAXQV_VPZ_B)
  .value("UMAXQV_VPZ_D", LIEF::assembly::aarch64::OPCODE::UMAXQV_VPZ_D)
  .value("UMAXQV_VPZ_H", LIEF::assembly::aarch64::OPCODE::UMAXQV_VPZ_H)
  .value("UMAXQV_VPZ_S", LIEF::assembly::aarch64::OPCODE::UMAXQV_VPZ_S)
  .value("UMAXV_VPZ_B", LIEF::assembly::aarch64::OPCODE::UMAXV_VPZ_B)
  .value("UMAXV_VPZ_D", LIEF::assembly::aarch64::OPCODE::UMAXV_VPZ_D)
  .value("UMAXV_VPZ_H", LIEF::assembly::aarch64::OPCODE::UMAXV_VPZ_H)
  .value("UMAXV_VPZ_S", LIEF::assembly::aarch64::OPCODE::UMAXV_VPZ_S)
  .value("UMAXVv16i8v", LIEF::assembly::aarch64::OPCODE::UMAXVv16i8v)
  .value("UMAXVv4i16v", LIEF::assembly::aarch64::OPCODE::UMAXVv4i16v)
  .value("UMAXVv4i32v", LIEF::assembly::aarch64::OPCODE::UMAXVv4i32v)
  .value("UMAXVv8i16v", LIEF::assembly::aarch64::OPCODE::UMAXVv8i16v)
  .value("UMAXVv8i8v", LIEF::assembly::aarch64::OPCODE::UMAXVv8i8v)
  .value("UMAXWri", LIEF::assembly::aarch64::OPCODE::UMAXWri)
  .value("UMAXWrr", LIEF::assembly::aarch64::OPCODE::UMAXWrr)
  .value("UMAXXri", LIEF::assembly::aarch64::OPCODE::UMAXXri)
  .value("UMAXXrr", LIEF::assembly::aarch64::OPCODE::UMAXXrr)
  .value("UMAX_VG2_2Z2Z_B", LIEF::assembly::aarch64::OPCODE::UMAX_VG2_2Z2Z_B)
  .value("UMAX_VG2_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::UMAX_VG2_2Z2Z_D)
  .value("UMAX_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::UMAX_VG2_2Z2Z_H)
  .value("UMAX_VG2_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::UMAX_VG2_2Z2Z_S)
  .value("UMAX_VG2_2ZZ_B", LIEF::assembly::aarch64::OPCODE::UMAX_VG2_2ZZ_B)
  .value("UMAX_VG2_2ZZ_D", LIEF::assembly::aarch64::OPCODE::UMAX_VG2_2ZZ_D)
  .value("UMAX_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::UMAX_VG2_2ZZ_H)
  .value("UMAX_VG2_2ZZ_S", LIEF::assembly::aarch64::OPCODE::UMAX_VG2_2ZZ_S)
  .value("UMAX_VG4_4Z4Z_B", LIEF::assembly::aarch64::OPCODE::UMAX_VG4_4Z4Z_B)
  .value("UMAX_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::UMAX_VG4_4Z4Z_D)
  .value("UMAX_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::UMAX_VG4_4Z4Z_H)
  .value("UMAX_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::UMAX_VG4_4Z4Z_S)
  .value("UMAX_VG4_4ZZ_B", LIEF::assembly::aarch64::OPCODE::UMAX_VG4_4ZZ_B)
  .value("UMAX_VG4_4ZZ_D", LIEF::assembly::aarch64::OPCODE::UMAX_VG4_4ZZ_D)
  .value("UMAX_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::UMAX_VG4_4ZZ_H)
  .value("UMAX_VG4_4ZZ_S", LIEF::assembly::aarch64::OPCODE::UMAX_VG4_4ZZ_S)
  .value("UMAX_ZI_B", LIEF::assembly::aarch64::OPCODE::UMAX_ZI_B)
  .value("UMAX_ZI_D", LIEF::assembly::aarch64::OPCODE::UMAX_ZI_D)
  .value("UMAX_ZI_H", LIEF::assembly::aarch64::OPCODE::UMAX_ZI_H)
  .value("UMAX_ZI_S", LIEF::assembly::aarch64::OPCODE::UMAX_ZI_S)
  .value("UMAX_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UMAX_ZPmZ_B)
  .value("UMAX_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UMAX_ZPmZ_D)
  .value("UMAX_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UMAX_ZPmZ_H)
  .value("UMAX_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UMAX_ZPmZ_S)
  .value("UMAXv16i8", LIEF::assembly::aarch64::OPCODE::UMAXv16i8)
  .value("UMAXv2i32", LIEF::assembly::aarch64::OPCODE::UMAXv2i32)
  .value("UMAXv4i16", LIEF::assembly::aarch64::OPCODE::UMAXv4i16)
  .value("UMAXv4i32", LIEF::assembly::aarch64::OPCODE::UMAXv4i32)
  .value("UMAXv8i16", LIEF::assembly::aarch64::OPCODE::UMAXv8i16)
  .value("UMAXv8i8", LIEF::assembly::aarch64::OPCODE::UMAXv8i8)
  .value("UMINP_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UMINP_ZPmZ_B)
  .value("UMINP_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UMINP_ZPmZ_D)
  .value("UMINP_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UMINP_ZPmZ_H)
  .value("UMINP_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UMINP_ZPmZ_S)
  .value("UMINPv16i8", LIEF::assembly::aarch64::OPCODE::UMINPv16i8)
  .value("UMINPv2i32", LIEF::assembly::aarch64::OPCODE::UMINPv2i32)
  .value("UMINPv4i16", LIEF::assembly::aarch64::OPCODE::UMINPv4i16)
  .value("UMINPv4i32", LIEF::assembly::aarch64::OPCODE::UMINPv4i32)
  .value("UMINPv8i16", LIEF::assembly::aarch64::OPCODE::UMINPv8i16);
  opcodes.value("UMINPv8i8", LIEF::assembly::aarch64::OPCODE::UMINPv8i8)
  .value("UMINQV_VPZ_B", LIEF::assembly::aarch64::OPCODE::UMINQV_VPZ_B)
  .value("UMINQV_VPZ_D", LIEF::assembly::aarch64::OPCODE::UMINQV_VPZ_D)
  .value("UMINQV_VPZ_H", LIEF::assembly::aarch64::OPCODE::UMINQV_VPZ_H)
  .value("UMINQV_VPZ_S", LIEF::assembly::aarch64::OPCODE::UMINQV_VPZ_S)
  .value("UMINV_VPZ_B", LIEF::assembly::aarch64::OPCODE::UMINV_VPZ_B)
  .value("UMINV_VPZ_D", LIEF::assembly::aarch64::OPCODE::UMINV_VPZ_D)
  .value("UMINV_VPZ_H", LIEF::assembly::aarch64::OPCODE::UMINV_VPZ_H)
  .value("UMINV_VPZ_S", LIEF::assembly::aarch64::OPCODE::UMINV_VPZ_S)
  .value("UMINVv16i8v", LIEF::assembly::aarch64::OPCODE::UMINVv16i8v)
  .value("UMINVv4i16v", LIEF::assembly::aarch64::OPCODE::UMINVv4i16v)
  .value("UMINVv4i32v", LIEF::assembly::aarch64::OPCODE::UMINVv4i32v)
  .value("UMINVv8i16v", LIEF::assembly::aarch64::OPCODE::UMINVv8i16v)
  .value("UMINVv8i8v", LIEF::assembly::aarch64::OPCODE::UMINVv8i8v)
  .value("UMINWri", LIEF::assembly::aarch64::OPCODE::UMINWri)
  .value("UMINWrr", LIEF::assembly::aarch64::OPCODE::UMINWrr)
  .value("UMINXri", LIEF::assembly::aarch64::OPCODE::UMINXri)
  .value("UMINXrr", LIEF::assembly::aarch64::OPCODE::UMINXrr)
  .value("UMIN_VG2_2Z2Z_B", LIEF::assembly::aarch64::OPCODE::UMIN_VG2_2Z2Z_B)
  .value("UMIN_VG2_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::UMIN_VG2_2Z2Z_D)
  .value("UMIN_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::UMIN_VG2_2Z2Z_H)
  .value("UMIN_VG2_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::UMIN_VG2_2Z2Z_S)
  .value("UMIN_VG2_2ZZ_B", LIEF::assembly::aarch64::OPCODE::UMIN_VG2_2ZZ_B)
  .value("UMIN_VG2_2ZZ_D", LIEF::assembly::aarch64::OPCODE::UMIN_VG2_2ZZ_D)
  .value("UMIN_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::UMIN_VG2_2ZZ_H)
  .value("UMIN_VG2_2ZZ_S", LIEF::assembly::aarch64::OPCODE::UMIN_VG2_2ZZ_S)
  .value("UMIN_VG4_4Z4Z_B", LIEF::assembly::aarch64::OPCODE::UMIN_VG4_4Z4Z_B)
  .value("UMIN_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::UMIN_VG4_4Z4Z_D)
  .value("UMIN_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::UMIN_VG4_4Z4Z_H)
  .value("UMIN_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::UMIN_VG4_4Z4Z_S)
  .value("UMIN_VG4_4ZZ_B", LIEF::assembly::aarch64::OPCODE::UMIN_VG4_4ZZ_B)
  .value("UMIN_VG4_4ZZ_D", LIEF::assembly::aarch64::OPCODE::UMIN_VG4_4ZZ_D)
  .value("UMIN_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::UMIN_VG4_4ZZ_H)
  .value("UMIN_VG4_4ZZ_S", LIEF::assembly::aarch64::OPCODE::UMIN_VG4_4ZZ_S)
  .value("UMIN_ZI_B", LIEF::assembly::aarch64::OPCODE::UMIN_ZI_B)
  .value("UMIN_ZI_D", LIEF::assembly::aarch64::OPCODE::UMIN_ZI_D)
  .value("UMIN_ZI_H", LIEF::assembly::aarch64::OPCODE::UMIN_ZI_H)
  .value("UMIN_ZI_S", LIEF::assembly::aarch64::OPCODE::UMIN_ZI_S)
  .value("UMIN_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UMIN_ZPmZ_B)
  .value("UMIN_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UMIN_ZPmZ_D)
  .value("UMIN_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UMIN_ZPmZ_H)
  .value("UMIN_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UMIN_ZPmZ_S)
  .value("UMINv16i8", LIEF::assembly::aarch64::OPCODE::UMINv16i8)
  .value("UMINv2i32", LIEF::assembly::aarch64::OPCODE::UMINv2i32)
  .value("UMINv4i16", LIEF::assembly::aarch64::OPCODE::UMINv4i16)
  .value("UMINv4i32", LIEF::assembly::aarch64::OPCODE::UMINv4i32)
  .value("UMINv8i16", LIEF::assembly::aarch64::OPCODE::UMINv8i16)
  .value("UMINv8i8", LIEF::assembly::aarch64::OPCODE::UMINv8i8)
  .value("UMLALB_ZZZI_D", LIEF::assembly::aarch64::OPCODE::UMLALB_ZZZI_D)
  .value("UMLALB_ZZZI_S", LIEF::assembly::aarch64::OPCODE::UMLALB_ZZZI_S)
  .value("UMLALB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UMLALB_ZZZ_D)
  .value("UMLALB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UMLALB_ZZZ_H)
  .value("UMLALB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UMLALB_ZZZ_S)
  .value("UMLALL_MZZI_BtoS", LIEF::assembly::aarch64::OPCODE::UMLALL_MZZI_BtoS)
  .value("UMLALL_MZZI_HtoD", LIEF::assembly::aarch64::OPCODE::UMLALL_MZZI_HtoD)
  .value("UMLALL_MZZ_BtoS", LIEF::assembly::aarch64::OPCODE::UMLALL_MZZ_BtoS)
  .value("UMLALL_MZZ_HtoD", LIEF::assembly::aarch64::OPCODE::UMLALL_MZZ_HtoD)
  .value("UMLALL_VG2_M2Z2Z_BtoS", LIEF::assembly::aarch64::OPCODE::UMLALL_VG2_M2Z2Z_BtoS)
  .value("UMLALL_VG2_M2Z2Z_HtoD", LIEF::assembly::aarch64::OPCODE::UMLALL_VG2_M2Z2Z_HtoD)
  .value("UMLALL_VG2_M2ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::UMLALL_VG2_M2ZZI_BtoS)
  .value("UMLALL_VG2_M2ZZI_HtoD", LIEF::assembly::aarch64::OPCODE::UMLALL_VG2_M2ZZI_HtoD)
  .value("UMLALL_VG2_M2ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::UMLALL_VG2_M2ZZ_BtoS)
  .value("UMLALL_VG2_M2ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::UMLALL_VG2_M2ZZ_HtoD)
  .value("UMLALL_VG4_M4Z4Z_BtoS", LIEF::assembly::aarch64::OPCODE::UMLALL_VG4_M4Z4Z_BtoS)
  .value("UMLALL_VG4_M4Z4Z_HtoD", LIEF::assembly::aarch64::OPCODE::UMLALL_VG4_M4Z4Z_HtoD)
  .value("UMLALL_VG4_M4ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::UMLALL_VG4_M4ZZI_BtoS)
  .value("UMLALL_VG4_M4ZZI_HtoD", LIEF::assembly::aarch64::OPCODE::UMLALL_VG4_M4ZZI_HtoD)
  .value("UMLALL_VG4_M4ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::UMLALL_VG4_M4ZZ_BtoS)
  .value("UMLALL_VG4_M4ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::UMLALL_VG4_M4ZZ_HtoD)
  .value("UMLALT_ZZZI_D", LIEF::assembly::aarch64::OPCODE::UMLALT_ZZZI_D)
  .value("UMLALT_ZZZI_S", LIEF::assembly::aarch64::OPCODE::UMLALT_ZZZI_S)
  .value("UMLALT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UMLALT_ZZZ_D)
  .value("UMLALT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UMLALT_ZZZ_H)
  .value("UMLALT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UMLALT_ZZZ_S)
  .value("UMLAL_MZZI_HtoS", LIEF::assembly::aarch64::OPCODE::UMLAL_MZZI_HtoS)
  .value("UMLAL_MZZ_HtoS", LIEF::assembly::aarch64::OPCODE::UMLAL_MZZ_HtoS)
  .value("UMLAL_VG2_M2Z2Z_HtoS", LIEF::assembly::aarch64::OPCODE::UMLAL_VG2_M2Z2Z_HtoS)
  .value("UMLAL_VG2_M2ZZI_S", LIEF::assembly::aarch64::OPCODE::UMLAL_VG2_M2ZZI_S)
  .value("UMLAL_VG2_M2ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::UMLAL_VG2_M2ZZ_HtoS)
  .value("UMLAL_VG4_M4Z4Z_HtoS", LIEF::assembly::aarch64::OPCODE::UMLAL_VG4_M4Z4Z_HtoS)
  .value("UMLAL_VG4_M4ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::UMLAL_VG4_M4ZZI_HtoS)
  .value("UMLAL_VG4_M4ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::UMLAL_VG4_M4ZZ_HtoS)
  .value("UMLALv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::UMLALv16i8_v8i16)
  .value("UMLALv2i32_indexed", LIEF::assembly::aarch64::OPCODE::UMLALv2i32_indexed)
  .value("UMLALv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::UMLALv2i32_v2i64)
  .value("UMLALv4i16_indexed", LIEF::assembly::aarch64::OPCODE::UMLALv4i16_indexed)
  .value("UMLALv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::UMLALv4i16_v4i32)
  .value("UMLALv4i32_indexed", LIEF::assembly::aarch64::OPCODE::UMLALv4i32_indexed)
  .value("UMLALv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::UMLALv4i32_v2i64)
  .value("UMLALv8i16_indexed", LIEF::assembly::aarch64::OPCODE::UMLALv8i16_indexed)
  .value("UMLALv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::UMLALv8i16_v4i32)
  .value("UMLALv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::UMLALv8i8_v8i16)
  .value("UMLSLB_ZZZI_D", LIEF::assembly::aarch64::OPCODE::UMLSLB_ZZZI_D)
  .value("UMLSLB_ZZZI_S", LIEF::assembly::aarch64::OPCODE::UMLSLB_ZZZI_S)
  .value("UMLSLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UMLSLB_ZZZ_D)
  .value("UMLSLB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UMLSLB_ZZZ_H)
  .value("UMLSLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UMLSLB_ZZZ_S)
  .value("UMLSLL_MZZI_BtoS", LIEF::assembly::aarch64::OPCODE::UMLSLL_MZZI_BtoS)
  .value("UMLSLL_MZZI_HtoD", LIEF::assembly::aarch64::OPCODE::UMLSLL_MZZI_HtoD)
  .value("UMLSLL_MZZ_BtoS", LIEF::assembly::aarch64::OPCODE::UMLSLL_MZZ_BtoS)
  .value("UMLSLL_MZZ_HtoD", LIEF::assembly::aarch64::OPCODE::UMLSLL_MZZ_HtoD)
  .value("UMLSLL_VG2_M2Z2Z_BtoS", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG2_M2Z2Z_BtoS)
  .value("UMLSLL_VG2_M2Z2Z_HtoD", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG2_M2Z2Z_HtoD)
  .value("UMLSLL_VG2_M2ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG2_M2ZZI_BtoS)
  .value("UMLSLL_VG2_M2ZZI_HtoD", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG2_M2ZZI_HtoD)
  .value("UMLSLL_VG2_M2ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG2_M2ZZ_BtoS)
  .value("UMLSLL_VG2_M2ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG2_M2ZZ_HtoD)
  .value("UMLSLL_VG4_M4Z4Z_BtoS", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG4_M4Z4Z_BtoS)
  .value("UMLSLL_VG4_M4Z4Z_HtoD", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG4_M4Z4Z_HtoD)
  .value("UMLSLL_VG4_M4ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG4_M4ZZI_BtoS)
  .value("UMLSLL_VG4_M4ZZI_HtoD", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG4_M4ZZI_HtoD)
  .value("UMLSLL_VG4_M4ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG4_M4ZZ_BtoS)
  .value("UMLSLL_VG4_M4ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::UMLSLL_VG4_M4ZZ_HtoD)
  .value("UMLSLT_ZZZI_D", LIEF::assembly::aarch64::OPCODE::UMLSLT_ZZZI_D)
  .value("UMLSLT_ZZZI_S", LIEF::assembly::aarch64::OPCODE::UMLSLT_ZZZI_S)
  .value("UMLSLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UMLSLT_ZZZ_D)
  .value("UMLSLT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UMLSLT_ZZZ_H)
  .value("UMLSLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UMLSLT_ZZZ_S)
  .value("UMLSL_MZZI_HtoS", LIEF::assembly::aarch64::OPCODE::UMLSL_MZZI_HtoS)
  .value("UMLSL_MZZ_HtoS", LIEF::assembly::aarch64::OPCODE::UMLSL_MZZ_HtoS)
  .value("UMLSL_VG2_M2Z2Z_HtoS", LIEF::assembly::aarch64::OPCODE::UMLSL_VG2_M2Z2Z_HtoS)
  .value("UMLSL_VG2_M2ZZI_S", LIEF::assembly::aarch64::OPCODE::UMLSL_VG2_M2ZZI_S)
  .value("UMLSL_VG2_M2ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::UMLSL_VG2_M2ZZ_HtoS)
  .value("UMLSL_VG4_M4Z4Z_HtoS", LIEF::assembly::aarch64::OPCODE::UMLSL_VG4_M4Z4Z_HtoS)
  .value("UMLSL_VG4_M4ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::UMLSL_VG4_M4ZZI_HtoS)
  .value("UMLSL_VG4_M4ZZ_HtoS", LIEF::assembly::aarch64::OPCODE::UMLSL_VG4_M4ZZ_HtoS)
  .value("UMLSLv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::UMLSLv16i8_v8i16)
  .value("UMLSLv2i32_indexed", LIEF::assembly::aarch64::OPCODE::UMLSLv2i32_indexed)
  .value("UMLSLv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::UMLSLv2i32_v2i64)
  .value("UMLSLv4i16_indexed", LIEF::assembly::aarch64::OPCODE::UMLSLv4i16_indexed)
  .value("UMLSLv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::UMLSLv4i16_v4i32)
  .value("UMLSLv4i32_indexed", LIEF::assembly::aarch64::OPCODE::UMLSLv4i32_indexed)
  .value("UMLSLv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::UMLSLv4i32_v2i64)
  .value("UMLSLv8i16_indexed", LIEF::assembly::aarch64::OPCODE::UMLSLv8i16_indexed)
  .value("UMLSLv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::UMLSLv8i16_v4i32)
  .value("UMLSLv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::UMLSLv8i8_v8i16)
  .value("UMMLA", LIEF::assembly::aarch64::OPCODE::UMMLA)
  .value("UMMLA_ZZZ", LIEF::assembly::aarch64::OPCODE::UMMLA_ZZZ)
  .value("UMOP4A_M2Z2Z_BToS", LIEF::assembly::aarch64::OPCODE::UMOP4A_M2Z2Z_BToS)
  .value("UMOP4A_M2Z2Z_HToS", LIEF::assembly::aarch64::OPCODE::UMOP4A_M2Z2Z_HToS)
  .value("UMOP4A_M2Z2Z_HtoD", LIEF::assembly::aarch64::OPCODE::UMOP4A_M2Z2Z_HtoD)
  .value("UMOP4A_M2ZZ_BToS", LIEF::assembly::aarch64::OPCODE::UMOP4A_M2ZZ_BToS)
  .value("UMOP4A_M2ZZ_HToS", LIEF::assembly::aarch64::OPCODE::UMOP4A_M2ZZ_HToS)
  .value("UMOP4A_M2ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::UMOP4A_M2ZZ_HtoD)
  .value("UMOP4A_MZ2Z_BToS", LIEF::assembly::aarch64::OPCODE::UMOP4A_MZ2Z_BToS)
  .value("UMOP4A_MZ2Z_HToS", LIEF::assembly::aarch64::OPCODE::UMOP4A_MZ2Z_HToS)
  .value("UMOP4A_MZ2Z_HtoD", LIEF::assembly::aarch64::OPCODE::UMOP4A_MZ2Z_HtoD)
  .value("UMOP4A_MZZ_BToS", LIEF::assembly::aarch64::OPCODE::UMOP4A_MZZ_BToS)
  .value("UMOP4A_MZZ_HToS", LIEF::assembly::aarch64::OPCODE::UMOP4A_MZZ_HToS)
  .value("UMOP4A_MZZ_HtoD", LIEF::assembly::aarch64::OPCODE::UMOP4A_MZZ_HtoD)
  .value("UMOP4S_M2Z2Z_BToS", LIEF::assembly::aarch64::OPCODE::UMOP4S_M2Z2Z_BToS)
  .value("UMOP4S_M2Z2Z_HToS", LIEF::assembly::aarch64::OPCODE::UMOP4S_M2Z2Z_HToS)
  .value("UMOP4S_M2Z2Z_HtoD", LIEF::assembly::aarch64::OPCODE::UMOP4S_M2Z2Z_HtoD)
  .value("UMOP4S_M2ZZ_BToS", LIEF::assembly::aarch64::OPCODE::UMOP4S_M2ZZ_BToS)
  .value("UMOP4S_M2ZZ_HToS", LIEF::assembly::aarch64::OPCODE::UMOP4S_M2ZZ_HToS)
  .value("UMOP4S_M2ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::UMOP4S_M2ZZ_HtoD)
  .value("UMOP4S_MZ2Z_BToS", LIEF::assembly::aarch64::OPCODE::UMOP4S_MZ2Z_BToS)
  .value("UMOP4S_MZ2Z_HToS", LIEF::assembly::aarch64::OPCODE::UMOP4S_MZ2Z_HToS)
  .value("UMOP4S_MZ2Z_HtoD", LIEF::assembly::aarch64::OPCODE::UMOP4S_MZ2Z_HtoD)
  .value("UMOP4S_MZZ_BToS", LIEF::assembly::aarch64::OPCODE::UMOP4S_MZZ_BToS)
  .value("UMOP4S_MZZ_HToS", LIEF::assembly::aarch64::OPCODE::UMOP4S_MZZ_HToS)
  .value("UMOP4S_MZZ_HtoD", LIEF::assembly::aarch64::OPCODE::UMOP4S_MZZ_HtoD)
  .value("UMOPA_MPPZZ_D", LIEF::assembly::aarch64::OPCODE::UMOPA_MPPZZ_D)
  .value("UMOPA_MPPZZ_HtoS", LIEF::assembly::aarch64::OPCODE::UMOPA_MPPZZ_HtoS)
  .value("UMOPA_MPPZZ_S", LIEF::assembly::aarch64::OPCODE::UMOPA_MPPZZ_S)
  .value("UMOPS_MPPZZ_D", LIEF::assembly::aarch64::OPCODE::UMOPS_MPPZZ_D)
  .value("UMOPS_MPPZZ_HtoS", LIEF::assembly::aarch64::OPCODE::UMOPS_MPPZZ_HtoS)
  .value("UMOPS_MPPZZ_S", LIEF::assembly::aarch64::OPCODE::UMOPS_MPPZZ_S)
  .value("UMOVvi16", LIEF::assembly::aarch64::OPCODE::UMOVvi16)
  .value("UMOVvi16_idx0", LIEF::assembly::aarch64::OPCODE::UMOVvi16_idx0)
  .value("UMOVvi32", LIEF::assembly::aarch64::OPCODE::UMOVvi32)
  .value("UMOVvi32_idx0", LIEF::assembly::aarch64::OPCODE::UMOVvi32_idx0)
  .value("UMOVvi64", LIEF::assembly::aarch64::OPCODE::UMOVvi64)
  .value("UMOVvi64_idx0", LIEF::assembly::aarch64::OPCODE::UMOVvi64_idx0)
  .value("UMOVvi8", LIEF::assembly::aarch64::OPCODE::UMOVvi8)
  .value("UMOVvi8_idx0", LIEF::assembly::aarch64::OPCODE::UMOVvi8_idx0)
  .value("UMSUBLrrr", LIEF::assembly::aarch64::OPCODE::UMSUBLrrr)
  .value("UMULH_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UMULH_ZPmZ_B)
  .value("UMULH_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UMULH_ZPmZ_D)
  .value("UMULH_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UMULH_ZPmZ_H)
  .value("UMULH_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UMULH_ZPmZ_S)
  .value("UMULH_ZZZ_B", LIEF::assembly::aarch64::OPCODE::UMULH_ZZZ_B)
  .value("UMULH_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UMULH_ZZZ_D)
  .value("UMULH_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UMULH_ZZZ_H)
  .value("UMULH_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UMULH_ZZZ_S)
  .value("UMULHrr", LIEF::assembly::aarch64::OPCODE::UMULHrr)
  .value("UMULLB_ZZZI_D", LIEF::assembly::aarch64::OPCODE::UMULLB_ZZZI_D)
  .value("UMULLB_ZZZI_S", LIEF::assembly::aarch64::OPCODE::UMULLB_ZZZI_S)
  .value("UMULLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UMULLB_ZZZ_D)
  .value("UMULLB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UMULLB_ZZZ_H)
  .value("UMULLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UMULLB_ZZZ_S)
  .value("UMULLT_ZZZI_D", LIEF::assembly::aarch64::OPCODE::UMULLT_ZZZI_D)
  .value("UMULLT_ZZZI_S", LIEF::assembly::aarch64::OPCODE::UMULLT_ZZZI_S)
  .value("UMULLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UMULLT_ZZZ_D)
  .value("UMULLT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UMULLT_ZZZ_H)
  .value("UMULLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UMULLT_ZZZ_S)
  .value("UMULLv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::UMULLv16i8_v8i16)
  .value("UMULLv2i32_indexed", LIEF::assembly::aarch64::OPCODE::UMULLv2i32_indexed)
  .value("UMULLv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::UMULLv2i32_v2i64)
  .value("UMULLv4i16_indexed", LIEF::assembly::aarch64::OPCODE::UMULLv4i16_indexed)
  .value("UMULLv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::UMULLv4i16_v4i32)
  .value("UMULLv4i32_indexed", LIEF::assembly::aarch64::OPCODE::UMULLv4i32_indexed)
  .value("UMULLv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::UMULLv4i32_v2i64)
  .value("UMULLv8i16_indexed", LIEF::assembly::aarch64::OPCODE::UMULLv8i16_indexed)
  .value("UMULLv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::UMULLv8i16_v4i32)
  .value("UMULLv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::UMULLv8i8_v8i16)
  .value("UQADD_ZI_B", LIEF::assembly::aarch64::OPCODE::UQADD_ZI_B)
  .value("UQADD_ZI_D", LIEF::assembly::aarch64::OPCODE::UQADD_ZI_D)
  .value("UQADD_ZI_H", LIEF::assembly::aarch64::OPCODE::UQADD_ZI_H)
  .value("UQADD_ZI_S", LIEF::assembly::aarch64::OPCODE::UQADD_ZI_S)
  .value("UQADD_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UQADD_ZPmZ_B)
  .value("UQADD_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UQADD_ZPmZ_D)
  .value("UQADD_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UQADD_ZPmZ_H)
  .value("UQADD_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UQADD_ZPmZ_S)
  .value("UQADD_ZZZ_B", LIEF::assembly::aarch64::OPCODE::UQADD_ZZZ_B)
  .value("UQADD_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UQADD_ZZZ_D)
  .value("UQADD_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UQADD_ZZZ_H)
  .value("UQADD_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UQADD_ZZZ_S)
  .value("UQADDv16i8", LIEF::assembly::aarch64::OPCODE::UQADDv16i8)
  .value("UQADDv1i16", LIEF::assembly::aarch64::OPCODE::UQADDv1i16)
  .value("UQADDv1i32", LIEF::assembly::aarch64::OPCODE::UQADDv1i32)
  .value("UQADDv1i64", LIEF::assembly::aarch64::OPCODE::UQADDv1i64)
  .value("UQADDv1i8", LIEF::assembly::aarch64::OPCODE::UQADDv1i8)
  .value("UQADDv2i32", LIEF::assembly::aarch64::OPCODE::UQADDv2i32)
  .value("UQADDv2i64", LIEF::assembly::aarch64::OPCODE::UQADDv2i64)
  .value("UQADDv4i16", LIEF::assembly::aarch64::OPCODE::UQADDv4i16)
  .value("UQADDv4i32", LIEF::assembly::aarch64::OPCODE::UQADDv4i32)
  .value("UQADDv8i16", LIEF::assembly::aarch64::OPCODE::UQADDv8i16)
  .value("UQADDv8i8", LIEF::assembly::aarch64::OPCODE::UQADDv8i8)
  .value("UQCVTN_Z2Z_StoH", LIEF::assembly::aarch64::OPCODE::UQCVTN_Z2Z_StoH)
  .value("UQCVTN_Z4Z_DtoH", LIEF::assembly::aarch64::OPCODE::UQCVTN_Z4Z_DtoH)
  .value("UQCVTN_Z4Z_StoB", LIEF::assembly::aarch64::OPCODE::UQCVTN_Z4Z_StoB)
  .value("UQCVT_Z2Z_StoH", LIEF::assembly::aarch64::OPCODE::UQCVT_Z2Z_StoH)
  .value("UQCVT_Z4Z_DtoH", LIEF::assembly::aarch64::OPCODE::UQCVT_Z4Z_DtoH)
  .value("UQCVT_Z4Z_StoB", LIEF::assembly::aarch64::OPCODE::UQCVT_Z4Z_StoB)
  .value("UQDECB_WPiI", LIEF::assembly::aarch64::OPCODE::UQDECB_WPiI)
  .value("UQDECB_XPiI", LIEF::assembly::aarch64::OPCODE::UQDECB_XPiI)
  .value("UQDECD_WPiI", LIEF::assembly::aarch64::OPCODE::UQDECD_WPiI)
  .value("UQDECD_XPiI", LIEF::assembly::aarch64::OPCODE::UQDECD_XPiI)
  .value("UQDECD_ZPiI", LIEF::assembly::aarch64::OPCODE::UQDECD_ZPiI)
  .value("UQDECH_WPiI", LIEF::assembly::aarch64::OPCODE::UQDECH_WPiI)
  .value("UQDECH_XPiI", LIEF::assembly::aarch64::OPCODE::UQDECH_XPiI)
  .value("UQDECH_ZPiI", LIEF::assembly::aarch64::OPCODE::UQDECH_ZPiI)
  .value("UQDECP_WP_B", LIEF::assembly::aarch64::OPCODE::UQDECP_WP_B)
  .value("UQDECP_WP_D", LIEF::assembly::aarch64::OPCODE::UQDECP_WP_D)
  .value("UQDECP_WP_H", LIEF::assembly::aarch64::OPCODE::UQDECP_WP_H)
  .value("UQDECP_WP_S", LIEF::assembly::aarch64::OPCODE::UQDECP_WP_S)
  .value("UQDECP_XP_B", LIEF::assembly::aarch64::OPCODE::UQDECP_XP_B)
  .value("UQDECP_XP_D", LIEF::assembly::aarch64::OPCODE::UQDECP_XP_D)
  .value("UQDECP_XP_H", LIEF::assembly::aarch64::OPCODE::UQDECP_XP_H)
  .value("UQDECP_XP_S", LIEF::assembly::aarch64::OPCODE::UQDECP_XP_S)
  .value("UQDECP_ZP_D", LIEF::assembly::aarch64::OPCODE::UQDECP_ZP_D)
  .value("UQDECP_ZP_H", LIEF::assembly::aarch64::OPCODE::UQDECP_ZP_H)
  .value("UQDECP_ZP_S", LIEF::assembly::aarch64::OPCODE::UQDECP_ZP_S)
  .value("UQDECW_WPiI", LIEF::assembly::aarch64::OPCODE::UQDECW_WPiI)
  .value("UQDECW_XPiI", LIEF::assembly::aarch64::OPCODE::UQDECW_XPiI)
  .value("UQDECW_ZPiI", LIEF::assembly::aarch64::OPCODE::UQDECW_ZPiI)
  .value("UQINCB_WPiI", LIEF::assembly::aarch64::OPCODE::UQINCB_WPiI)
  .value("UQINCB_XPiI", LIEF::assembly::aarch64::OPCODE::UQINCB_XPiI)
  .value("UQINCD_WPiI", LIEF::assembly::aarch64::OPCODE::UQINCD_WPiI)
  .value("UQINCD_XPiI", LIEF::assembly::aarch64::OPCODE::UQINCD_XPiI)
  .value("UQINCD_ZPiI", LIEF::assembly::aarch64::OPCODE::UQINCD_ZPiI)
  .value("UQINCH_WPiI", LIEF::assembly::aarch64::OPCODE::UQINCH_WPiI)
  .value("UQINCH_XPiI", LIEF::assembly::aarch64::OPCODE::UQINCH_XPiI)
  .value("UQINCH_ZPiI", LIEF::assembly::aarch64::OPCODE::UQINCH_ZPiI)
  .value("UQINCP_WP_B", LIEF::assembly::aarch64::OPCODE::UQINCP_WP_B)
  .value("UQINCP_WP_D", LIEF::assembly::aarch64::OPCODE::UQINCP_WP_D)
  .value("UQINCP_WP_H", LIEF::assembly::aarch64::OPCODE::UQINCP_WP_H)
  .value("UQINCP_WP_S", LIEF::assembly::aarch64::OPCODE::UQINCP_WP_S)
  .value("UQINCP_XP_B", LIEF::assembly::aarch64::OPCODE::UQINCP_XP_B)
  .value("UQINCP_XP_D", LIEF::assembly::aarch64::OPCODE::UQINCP_XP_D)
  .value("UQINCP_XP_H", LIEF::assembly::aarch64::OPCODE::UQINCP_XP_H)
  .value("UQINCP_XP_S", LIEF::assembly::aarch64::OPCODE::UQINCP_XP_S)
  .value("UQINCP_ZP_D", LIEF::assembly::aarch64::OPCODE::UQINCP_ZP_D)
  .value("UQINCP_ZP_H", LIEF::assembly::aarch64::OPCODE::UQINCP_ZP_H)
  .value("UQINCP_ZP_S", LIEF::assembly::aarch64::OPCODE::UQINCP_ZP_S)
  .value("UQINCW_WPiI", LIEF::assembly::aarch64::OPCODE::UQINCW_WPiI)
  .value("UQINCW_XPiI", LIEF::assembly::aarch64::OPCODE::UQINCW_XPiI)
  .value("UQINCW_ZPiI", LIEF::assembly::aarch64::OPCODE::UQINCW_ZPiI)
  .value("UQRSHLR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UQRSHLR_ZPmZ_B)
  .value("UQRSHLR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UQRSHLR_ZPmZ_D)
  .value("UQRSHLR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UQRSHLR_ZPmZ_H)
  .value("UQRSHLR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UQRSHLR_ZPmZ_S)
  .value("UQRSHL_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UQRSHL_ZPmZ_B)
  .value("UQRSHL_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UQRSHL_ZPmZ_D)
  .value("UQRSHL_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UQRSHL_ZPmZ_H)
  .value("UQRSHL_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UQRSHL_ZPmZ_S)
  .value("UQRSHLv16i8", LIEF::assembly::aarch64::OPCODE::UQRSHLv16i8)
  .value("UQRSHLv1i16", LIEF::assembly::aarch64::OPCODE::UQRSHLv1i16)
  .value("UQRSHLv1i32", LIEF::assembly::aarch64::OPCODE::UQRSHLv1i32)
  .value("UQRSHLv1i64", LIEF::assembly::aarch64::OPCODE::UQRSHLv1i64)
  .value("UQRSHLv1i8", LIEF::assembly::aarch64::OPCODE::UQRSHLv1i8)
  .value("UQRSHLv2i32", LIEF::assembly::aarch64::OPCODE::UQRSHLv2i32)
  .value("UQRSHLv2i64", LIEF::assembly::aarch64::OPCODE::UQRSHLv2i64)
  .value("UQRSHLv4i16", LIEF::assembly::aarch64::OPCODE::UQRSHLv4i16)
  .value("UQRSHLv4i32", LIEF::assembly::aarch64::OPCODE::UQRSHLv4i32)
  .value("UQRSHLv8i16", LIEF::assembly::aarch64::OPCODE::UQRSHLv8i16)
  .value("UQRSHLv8i8", LIEF::assembly::aarch64::OPCODE::UQRSHLv8i8)
  .value("UQRSHRNB_ZZI_B", LIEF::assembly::aarch64::OPCODE::UQRSHRNB_ZZI_B)
  .value("UQRSHRNB_ZZI_H", LIEF::assembly::aarch64::OPCODE::UQRSHRNB_ZZI_H);
  opcodes.value("UQRSHRNB_ZZI_S", LIEF::assembly::aarch64::OPCODE::UQRSHRNB_ZZI_S)
  .value("UQRSHRNT_ZZI_B", LIEF::assembly::aarch64::OPCODE::UQRSHRNT_ZZI_B)
  .value("UQRSHRNT_ZZI_H", LIEF::assembly::aarch64::OPCODE::UQRSHRNT_ZZI_H)
  .value("UQRSHRNT_ZZI_S", LIEF::assembly::aarch64::OPCODE::UQRSHRNT_ZZI_S)
  .value("UQRSHRN_VG4_Z4ZI_B", LIEF::assembly::aarch64::OPCODE::UQRSHRN_VG4_Z4ZI_B)
  .value("UQRSHRN_VG4_Z4ZI_H", LIEF::assembly::aarch64::OPCODE::UQRSHRN_VG4_Z4ZI_H)
  .value("UQRSHRN_Z2ZI_StoH", LIEF::assembly::aarch64::OPCODE::UQRSHRN_Z2ZI_StoH)
  .value("UQRSHRNb", LIEF::assembly::aarch64::OPCODE::UQRSHRNb)
  .value("UQRSHRNh", LIEF::assembly::aarch64::OPCODE::UQRSHRNh)
  .value("UQRSHRNs", LIEF::assembly::aarch64::OPCODE::UQRSHRNs)
  .value("UQRSHRNv16i8_shift", LIEF::assembly::aarch64::OPCODE::UQRSHRNv16i8_shift)
  .value("UQRSHRNv2i32_shift", LIEF::assembly::aarch64::OPCODE::UQRSHRNv2i32_shift)
  .value("UQRSHRNv4i16_shift", LIEF::assembly::aarch64::OPCODE::UQRSHRNv4i16_shift)
  .value("UQRSHRNv4i32_shift", LIEF::assembly::aarch64::OPCODE::UQRSHRNv4i32_shift)
  .value("UQRSHRNv8i16_shift", LIEF::assembly::aarch64::OPCODE::UQRSHRNv8i16_shift)
  .value("UQRSHRNv8i8_shift", LIEF::assembly::aarch64::OPCODE::UQRSHRNv8i8_shift)
  .value("UQRSHR_VG2_Z2ZI_H", LIEF::assembly::aarch64::OPCODE::UQRSHR_VG2_Z2ZI_H)
  .value("UQRSHR_VG4_Z4ZI_B", LIEF::assembly::aarch64::OPCODE::UQRSHR_VG4_Z4ZI_B)
  .value("UQRSHR_VG4_Z4ZI_H", LIEF::assembly::aarch64::OPCODE::UQRSHR_VG4_Z4ZI_H)
  .value("UQSHLR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UQSHLR_ZPmZ_B)
  .value("UQSHLR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UQSHLR_ZPmZ_D)
  .value("UQSHLR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UQSHLR_ZPmZ_H)
  .value("UQSHLR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UQSHLR_ZPmZ_S)
  .value("UQSHL_ZPmI_B", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPmI_B)
  .value("UQSHL_ZPmI_D", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPmI_D)
  .value("UQSHL_ZPmI_H", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPmI_H)
  .value("UQSHL_ZPmI_S", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPmI_S)
  .value("UQSHL_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPmZ_B)
  .value("UQSHL_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPmZ_D)
  .value("UQSHL_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPmZ_H)
  .value("UQSHL_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UQSHL_ZPmZ_S)
  .value("UQSHLb", LIEF::assembly::aarch64::OPCODE::UQSHLb)
  .value("UQSHLd", LIEF::assembly::aarch64::OPCODE::UQSHLd)
  .value("UQSHLh", LIEF::assembly::aarch64::OPCODE::UQSHLh)
  .value("UQSHLs", LIEF::assembly::aarch64::OPCODE::UQSHLs)
  .value("UQSHLv16i8", LIEF::assembly::aarch64::OPCODE::UQSHLv16i8)
  .value("UQSHLv16i8_shift", LIEF::assembly::aarch64::OPCODE::UQSHLv16i8_shift)
  .value("UQSHLv1i16", LIEF::assembly::aarch64::OPCODE::UQSHLv1i16)
  .value("UQSHLv1i32", LIEF::assembly::aarch64::OPCODE::UQSHLv1i32)
  .value("UQSHLv1i64", LIEF::assembly::aarch64::OPCODE::UQSHLv1i64)
  .value("UQSHLv1i8", LIEF::assembly::aarch64::OPCODE::UQSHLv1i8)
  .value("UQSHLv2i32", LIEF::assembly::aarch64::OPCODE::UQSHLv2i32)
  .value("UQSHLv2i32_shift", LIEF::assembly::aarch64::OPCODE::UQSHLv2i32_shift)
  .value("UQSHLv2i64", LIEF::assembly::aarch64::OPCODE::UQSHLv2i64)
  .value("UQSHLv2i64_shift", LIEF::assembly::aarch64::OPCODE::UQSHLv2i64_shift)
  .value("UQSHLv4i16", LIEF::assembly::aarch64::OPCODE::UQSHLv4i16)
  .value("UQSHLv4i16_shift", LIEF::assembly::aarch64::OPCODE::UQSHLv4i16_shift)
  .value("UQSHLv4i32", LIEF::assembly::aarch64::OPCODE::UQSHLv4i32)
  .value("UQSHLv4i32_shift", LIEF::assembly::aarch64::OPCODE::UQSHLv4i32_shift)
  .value("UQSHLv8i16", LIEF::assembly::aarch64::OPCODE::UQSHLv8i16)
  .value("UQSHLv8i16_shift", LIEF::assembly::aarch64::OPCODE::UQSHLv8i16_shift)
  .value("UQSHLv8i8", LIEF::assembly::aarch64::OPCODE::UQSHLv8i8)
  .value("UQSHLv8i8_shift", LIEF::assembly::aarch64::OPCODE::UQSHLv8i8_shift)
  .value("UQSHRNB_ZZI_B", LIEF::assembly::aarch64::OPCODE::UQSHRNB_ZZI_B)
  .value("UQSHRNB_ZZI_H", LIEF::assembly::aarch64::OPCODE::UQSHRNB_ZZI_H)
  .value("UQSHRNB_ZZI_S", LIEF::assembly::aarch64::OPCODE::UQSHRNB_ZZI_S)
  .value("UQSHRNT_ZZI_B", LIEF::assembly::aarch64::OPCODE::UQSHRNT_ZZI_B)
  .value("UQSHRNT_ZZI_H", LIEF::assembly::aarch64::OPCODE::UQSHRNT_ZZI_H)
  .value("UQSHRNT_ZZI_S", LIEF::assembly::aarch64::OPCODE::UQSHRNT_ZZI_S)
  .value("UQSHRNb", LIEF::assembly::aarch64::OPCODE::UQSHRNb)
  .value("UQSHRNh", LIEF::assembly::aarch64::OPCODE::UQSHRNh)
  .value("UQSHRNs", LIEF::assembly::aarch64::OPCODE::UQSHRNs)
  .value("UQSHRNv16i8_shift", LIEF::assembly::aarch64::OPCODE::UQSHRNv16i8_shift)
  .value("UQSHRNv2i32_shift", LIEF::assembly::aarch64::OPCODE::UQSHRNv2i32_shift)
  .value("UQSHRNv4i16_shift", LIEF::assembly::aarch64::OPCODE::UQSHRNv4i16_shift)
  .value("UQSHRNv4i32_shift", LIEF::assembly::aarch64::OPCODE::UQSHRNv4i32_shift)
  .value("UQSHRNv8i16_shift", LIEF::assembly::aarch64::OPCODE::UQSHRNv8i16_shift)
  .value("UQSHRNv8i8_shift", LIEF::assembly::aarch64::OPCODE::UQSHRNv8i8_shift)
  .value("UQSUBR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UQSUBR_ZPmZ_B)
  .value("UQSUBR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UQSUBR_ZPmZ_D)
  .value("UQSUBR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UQSUBR_ZPmZ_H)
  .value("UQSUBR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UQSUBR_ZPmZ_S)
  .value("UQSUB_ZI_B", LIEF::assembly::aarch64::OPCODE::UQSUB_ZI_B)
  .value("UQSUB_ZI_D", LIEF::assembly::aarch64::OPCODE::UQSUB_ZI_D)
  .value("UQSUB_ZI_H", LIEF::assembly::aarch64::OPCODE::UQSUB_ZI_H)
  .value("UQSUB_ZI_S", LIEF::assembly::aarch64::OPCODE::UQSUB_ZI_S)
  .value("UQSUB_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::UQSUB_ZPmZ_B)
  .value("UQSUB_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UQSUB_ZPmZ_D)
  .value("UQSUB_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UQSUB_ZPmZ_H)
  .value("UQSUB_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UQSUB_ZPmZ_S)
  .value("UQSUB_ZZZ_B", LIEF::assembly::aarch64::OPCODE::UQSUB_ZZZ_B)
  .value("UQSUB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UQSUB_ZZZ_D)
  .value("UQSUB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UQSUB_ZZZ_H)
  .value("UQSUB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UQSUB_ZZZ_S)
  .value("UQSUBv16i8", LIEF::assembly::aarch64::OPCODE::UQSUBv16i8)
  .value("UQSUBv1i16", LIEF::assembly::aarch64::OPCODE::UQSUBv1i16)
  .value("UQSUBv1i32", LIEF::assembly::aarch64::OPCODE::UQSUBv1i32)
  .value("UQSUBv1i64", LIEF::assembly::aarch64::OPCODE::UQSUBv1i64)
  .value("UQSUBv1i8", LIEF::assembly::aarch64::OPCODE::UQSUBv1i8)
  .value("UQSUBv2i32", LIEF::assembly::aarch64::OPCODE::UQSUBv2i32)
  .value("UQSUBv2i64", LIEF::assembly::aarch64::OPCODE::UQSUBv2i64)
  .value("UQSUBv4i16", LIEF::assembly::aarch64::OPCODE::UQSUBv4i16)
  .value("UQSUBv4i32", LIEF::assembly::aarch64::OPCODE::UQSUBv4i32)
  .value("UQSUBv8i16", LIEF::assembly::aarch64::OPCODE::UQSUBv8i16)
  .value("UQSUBv8i8", LIEF::assembly::aarch64::OPCODE::UQSUBv8i8)
  .value("UQXTNB_ZZ_B", LIEF::assembly::aarch64::OPCODE::UQXTNB_ZZ_B)
  .value("UQXTNB_ZZ_H", LIEF::assembly::aarch64::OPCODE::UQXTNB_ZZ_H)
  .value("UQXTNB_ZZ_S", LIEF::assembly::aarch64::OPCODE::UQXTNB_ZZ_S)
  .value("UQXTNT_ZZ_B", LIEF::assembly::aarch64::OPCODE::UQXTNT_ZZ_B)
  .value("UQXTNT_ZZ_H", LIEF::assembly::aarch64::OPCODE::UQXTNT_ZZ_H)
  .value("UQXTNT_ZZ_S", LIEF::assembly::aarch64::OPCODE::UQXTNT_ZZ_S)
  .value("UQXTNv16i8", LIEF::assembly::aarch64::OPCODE::UQXTNv16i8)
  .value("UQXTNv1i16", LIEF::assembly::aarch64::OPCODE::UQXTNv1i16)
  .value("UQXTNv1i32", LIEF::assembly::aarch64::OPCODE::UQXTNv1i32)
  .value("UQXTNv1i8", LIEF::assembly::aarch64::OPCODE::UQXTNv1i8)
  .value("UQXTNv2i32", LIEF::assembly::aarch64::OPCODE::UQXTNv2i32)
  .value("UQXTNv4i16", LIEF::assembly::aarch64::OPCODE::UQXTNv4i16)
  .value("UQXTNv4i32", LIEF::assembly::aarch64::OPCODE::UQXTNv4i32)
  .value("UQXTNv8i16", LIEF::assembly::aarch64::OPCODE::UQXTNv8i16)
  .value("UQXTNv8i8", LIEF::assembly::aarch64::OPCODE::UQXTNv8i8)
  .value("URECPE_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::URECPE_ZPmZ_S)
  .value("URECPE_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::URECPE_ZPzZ_S)
  .value("URECPEv2i32", LIEF::assembly::aarch64::OPCODE::URECPEv2i32)
  .value("URECPEv4i32", LIEF::assembly::aarch64::OPCODE::URECPEv4i32)
  .value("URHADD_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::URHADD_ZPmZ_B)
  .value("URHADD_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::URHADD_ZPmZ_D)
  .value("URHADD_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::URHADD_ZPmZ_H)
  .value("URHADD_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::URHADD_ZPmZ_S)
  .value("URHADDv16i8", LIEF::assembly::aarch64::OPCODE::URHADDv16i8)
  .value("URHADDv2i32", LIEF::assembly::aarch64::OPCODE::URHADDv2i32)
  .value("URHADDv4i16", LIEF::assembly::aarch64::OPCODE::URHADDv4i16)
  .value("URHADDv4i32", LIEF::assembly::aarch64::OPCODE::URHADDv4i32)
  .value("URHADDv8i16", LIEF::assembly::aarch64::OPCODE::URHADDv8i16)
  .value("URHADDv8i8", LIEF::assembly::aarch64::OPCODE::URHADDv8i8)
  .value("URSHLR_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::URSHLR_ZPmZ_B)
  .value("URSHLR_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::URSHLR_ZPmZ_D)
  .value("URSHLR_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::URSHLR_ZPmZ_H)
  .value("URSHLR_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::URSHLR_ZPmZ_S)
  .value("URSHL_VG2_2Z2Z_B", LIEF::assembly::aarch64::OPCODE::URSHL_VG2_2Z2Z_B)
  .value("URSHL_VG2_2Z2Z_D", LIEF::assembly::aarch64::OPCODE::URSHL_VG2_2Z2Z_D)
  .value("URSHL_VG2_2Z2Z_H", LIEF::assembly::aarch64::OPCODE::URSHL_VG2_2Z2Z_H)
  .value("URSHL_VG2_2Z2Z_S", LIEF::assembly::aarch64::OPCODE::URSHL_VG2_2Z2Z_S)
  .value("URSHL_VG2_2ZZ_B", LIEF::assembly::aarch64::OPCODE::URSHL_VG2_2ZZ_B)
  .value("URSHL_VG2_2ZZ_D", LIEF::assembly::aarch64::OPCODE::URSHL_VG2_2ZZ_D)
  .value("URSHL_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::URSHL_VG2_2ZZ_H)
  .value("URSHL_VG2_2ZZ_S", LIEF::assembly::aarch64::OPCODE::URSHL_VG2_2ZZ_S)
  .value("URSHL_VG4_4Z4Z_B", LIEF::assembly::aarch64::OPCODE::URSHL_VG4_4Z4Z_B)
  .value("URSHL_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::URSHL_VG4_4Z4Z_D)
  .value("URSHL_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::URSHL_VG4_4Z4Z_H)
  .value("URSHL_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::URSHL_VG4_4Z4Z_S)
  .value("URSHL_VG4_4ZZ_B", LIEF::assembly::aarch64::OPCODE::URSHL_VG4_4ZZ_B)
  .value("URSHL_VG4_4ZZ_D", LIEF::assembly::aarch64::OPCODE::URSHL_VG4_4ZZ_D)
  .value("URSHL_VG4_4ZZ_H", LIEF::assembly::aarch64::OPCODE::URSHL_VG4_4ZZ_H)
  .value("URSHL_VG4_4ZZ_S", LIEF::assembly::aarch64::OPCODE::URSHL_VG4_4ZZ_S)
  .value("URSHL_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::URSHL_ZPmZ_B)
  .value("URSHL_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::URSHL_ZPmZ_D)
  .value("URSHL_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::URSHL_ZPmZ_H)
  .value("URSHL_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::URSHL_ZPmZ_S)
  .value("URSHLv16i8", LIEF::assembly::aarch64::OPCODE::URSHLv16i8)
  .value("URSHLv1i64", LIEF::assembly::aarch64::OPCODE::URSHLv1i64)
  .value("URSHLv2i32", LIEF::assembly::aarch64::OPCODE::URSHLv2i32)
  .value("URSHLv2i64", LIEF::assembly::aarch64::OPCODE::URSHLv2i64)
  .value("URSHLv4i16", LIEF::assembly::aarch64::OPCODE::URSHLv4i16)
  .value("URSHLv4i32", LIEF::assembly::aarch64::OPCODE::URSHLv4i32)
  .value("URSHLv8i16", LIEF::assembly::aarch64::OPCODE::URSHLv8i16)
  .value("URSHLv8i8", LIEF::assembly::aarch64::OPCODE::URSHLv8i8)
  .value("URSHR_ZPmI_B", LIEF::assembly::aarch64::OPCODE::URSHR_ZPmI_B)
  .value("URSHR_ZPmI_D", LIEF::assembly::aarch64::OPCODE::URSHR_ZPmI_D)
  .value("URSHR_ZPmI_H", LIEF::assembly::aarch64::OPCODE::URSHR_ZPmI_H)
  .value("URSHR_ZPmI_S", LIEF::assembly::aarch64::OPCODE::URSHR_ZPmI_S)
  .value("URSHRd", LIEF::assembly::aarch64::OPCODE::URSHRd)
  .value("URSHRv16i8_shift", LIEF::assembly::aarch64::OPCODE::URSHRv16i8_shift)
  .value("URSHRv2i32_shift", LIEF::assembly::aarch64::OPCODE::URSHRv2i32_shift)
  .value("URSHRv2i64_shift", LIEF::assembly::aarch64::OPCODE::URSHRv2i64_shift)
  .value("URSHRv4i16_shift", LIEF::assembly::aarch64::OPCODE::URSHRv4i16_shift)
  .value("URSHRv4i32_shift", LIEF::assembly::aarch64::OPCODE::URSHRv4i32_shift)
  .value("URSHRv8i16_shift", LIEF::assembly::aarch64::OPCODE::URSHRv8i16_shift)
  .value("URSHRv8i8_shift", LIEF::assembly::aarch64::OPCODE::URSHRv8i8_shift)
  .value("URSQRTE_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::URSQRTE_ZPmZ_S)
  .value("URSQRTE_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::URSQRTE_ZPzZ_S)
  .value("URSQRTEv2i32", LIEF::assembly::aarch64::OPCODE::URSQRTEv2i32)
  .value("URSQRTEv4i32", LIEF::assembly::aarch64::OPCODE::URSQRTEv4i32)
  .value("URSRA_ZZI_B", LIEF::assembly::aarch64::OPCODE::URSRA_ZZI_B)
  .value("URSRA_ZZI_D", LIEF::assembly::aarch64::OPCODE::URSRA_ZZI_D)
  .value("URSRA_ZZI_H", LIEF::assembly::aarch64::OPCODE::URSRA_ZZI_H)
  .value("URSRA_ZZI_S", LIEF::assembly::aarch64::OPCODE::URSRA_ZZI_S)
  .value("URSRAd", LIEF::assembly::aarch64::OPCODE::URSRAd)
  .value("URSRAv16i8_shift", LIEF::assembly::aarch64::OPCODE::URSRAv16i8_shift)
  .value("URSRAv2i32_shift", LIEF::assembly::aarch64::OPCODE::URSRAv2i32_shift)
  .value("URSRAv2i64_shift", LIEF::assembly::aarch64::OPCODE::URSRAv2i64_shift)
  .value("URSRAv4i16_shift", LIEF::assembly::aarch64::OPCODE::URSRAv4i16_shift)
  .value("URSRAv4i32_shift", LIEF::assembly::aarch64::OPCODE::URSRAv4i32_shift)
  .value("URSRAv8i16_shift", LIEF::assembly::aarch64::OPCODE::URSRAv8i16_shift)
  .value("URSRAv8i8_shift", LIEF::assembly::aarch64::OPCODE::URSRAv8i8_shift)
  .value("USDOT_VG2_M2Z2Z_BToS", LIEF::assembly::aarch64::OPCODE::USDOT_VG2_M2Z2Z_BToS)
  .value("USDOT_VG2_M2ZZI_BToS", LIEF::assembly::aarch64::OPCODE::USDOT_VG2_M2ZZI_BToS)
  .value("USDOT_VG2_M2ZZ_BToS", LIEF::assembly::aarch64::OPCODE::USDOT_VG2_M2ZZ_BToS)
  .value("USDOT_VG4_M4Z4Z_BToS", LIEF::assembly::aarch64::OPCODE::USDOT_VG4_M4Z4Z_BToS)
  .value("USDOT_VG4_M4ZZI_BToS", LIEF::assembly::aarch64::OPCODE::USDOT_VG4_M4ZZI_BToS)
  .value("USDOT_VG4_M4ZZ_BToS", LIEF::assembly::aarch64::OPCODE::USDOT_VG4_M4ZZ_BToS)
  .value("USDOT_ZZZ", LIEF::assembly::aarch64::OPCODE::USDOT_ZZZ)
  .value("USDOT_ZZZI", LIEF::assembly::aarch64::OPCODE::USDOT_ZZZI)
  .value("USDOTlanev16i8", LIEF::assembly::aarch64::OPCODE::USDOTlanev16i8)
  .value("USDOTlanev8i8", LIEF::assembly::aarch64::OPCODE::USDOTlanev8i8)
  .value("USDOTv16i8", LIEF::assembly::aarch64::OPCODE::USDOTv16i8)
  .value("USDOTv8i8", LIEF::assembly::aarch64::OPCODE::USDOTv8i8)
  .value("USHLLB_ZZI_D", LIEF::assembly::aarch64::OPCODE::USHLLB_ZZI_D)
  .value("USHLLB_ZZI_H", LIEF::assembly::aarch64::OPCODE::USHLLB_ZZI_H)
  .value("USHLLB_ZZI_S", LIEF::assembly::aarch64::OPCODE::USHLLB_ZZI_S)
  .value("USHLLT_ZZI_D", LIEF::assembly::aarch64::OPCODE::USHLLT_ZZI_D)
  .value("USHLLT_ZZI_H", LIEF::assembly::aarch64::OPCODE::USHLLT_ZZI_H)
  .value("USHLLT_ZZI_S", LIEF::assembly::aarch64::OPCODE::USHLLT_ZZI_S)
  .value("USHLLv16i8_shift", LIEF::assembly::aarch64::OPCODE::USHLLv16i8_shift)
  .value("USHLLv2i32_shift", LIEF::assembly::aarch64::OPCODE::USHLLv2i32_shift)
  .value("USHLLv4i16_shift", LIEF::assembly::aarch64::OPCODE::USHLLv4i16_shift)
  .value("USHLLv4i32_shift", LIEF::assembly::aarch64::OPCODE::USHLLv4i32_shift)
  .value("USHLLv8i16_shift", LIEF::assembly::aarch64::OPCODE::USHLLv8i16_shift)
  .value("USHLLv8i8_shift", LIEF::assembly::aarch64::OPCODE::USHLLv8i8_shift)
  .value("USHLv16i8", LIEF::assembly::aarch64::OPCODE::USHLv16i8)
  .value("USHLv1i64", LIEF::assembly::aarch64::OPCODE::USHLv1i64)
  .value("USHLv2i32", LIEF::assembly::aarch64::OPCODE::USHLv2i32)
  .value("USHLv2i64", LIEF::assembly::aarch64::OPCODE::USHLv2i64)
  .value("USHLv4i16", LIEF::assembly::aarch64::OPCODE::USHLv4i16)
  .value("USHLv4i32", LIEF::assembly::aarch64::OPCODE::USHLv4i32)
  .value("USHLv8i16", LIEF::assembly::aarch64::OPCODE::USHLv8i16)
  .value("USHLv8i8", LIEF::assembly::aarch64::OPCODE::USHLv8i8)
  .value("USHRd", LIEF::assembly::aarch64::OPCODE::USHRd)
  .value("USHRv16i8_shift", LIEF::assembly::aarch64::OPCODE::USHRv16i8_shift)
  .value("USHRv2i32_shift", LIEF::assembly::aarch64::OPCODE::USHRv2i32_shift)
  .value("USHRv2i64_shift", LIEF::assembly::aarch64::OPCODE::USHRv2i64_shift)
  .value("USHRv4i16_shift", LIEF::assembly::aarch64::OPCODE::USHRv4i16_shift)
  .value("USHRv4i32_shift", LIEF::assembly::aarch64::OPCODE::USHRv4i32_shift)
  .value("USHRv8i16_shift", LIEF::assembly::aarch64::OPCODE::USHRv8i16_shift)
  .value("USHRv8i8_shift", LIEF::assembly::aarch64::OPCODE::USHRv8i8_shift)
  .value("USMLALL_MZZI_BtoS", LIEF::assembly::aarch64::OPCODE::USMLALL_MZZI_BtoS)
  .value("USMLALL_MZZ_BtoS", LIEF::assembly::aarch64::OPCODE::USMLALL_MZZ_BtoS)
  .value("USMLALL_VG2_M2Z2Z_BtoS", LIEF::assembly::aarch64::OPCODE::USMLALL_VG2_M2Z2Z_BtoS)
  .value("USMLALL_VG2_M2ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::USMLALL_VG2_M2ZZI_BtoS)
  .value("USMLALL_VG2_M2ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::USMLALL_VG2_M2ZZ_BtoS)
  .value("USMLALL_VG4_M4Z4Z_BtoS", LIEF::assembly::aarch64::OPCODE::USMLALL_VG4_M4Z4Z_BtoS)
  .value("USMLALL_VG4_M4ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::USMLALL_VG4_M4ZZI_BtoS)
  .value("USMLALL_VG4_M4ZZ_BtoS", LIEF::assembly::aarch64::OPCODE::USMLALL_VG4_M4ZZ_BtoS)
  .value("USMMLA", LIEF::assembly::aarch64::OPCODE::USMMLA)
  .value("USMMLA_ZZZ", LIEF::assembly::aarch64::OPCODE::USMMLA_ZZZ)
  .value("USMOP4A_M2Z2Z_BToS", LIEF::assembly::aarch64::OPCODE::USMOP4A_M2Z2Z_BToS)
  .value("USMOP4A_M2Z2Z_HtoD", LIEF::assembly::aarch64::OPCODE::USMOP4A_M2Z2Z_HtoD)
  .value("USMOP4A_M2ZZ_BToS", LIEF::assembly::aarch64::OPCODE::USMOP4A_M2ZZ_BToS)
  .value("USMOP4A_M2ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::USMOP4A_M2ZZ_HtoD)
  .value("USMOP4A_MZ2Z_BToS", LIEF::assembly::aarch64::OPCODE::USMOP4A_MZ2Z_BToS)
  .value("USMOP4A_MZ2Z_HtoD", LIEF::assembly::aarch64::OPCODE::USMOP4A_MZ2Z_HtoD)
  .value("USMOP4A_MZZ_BToS", LIEF::assembly::aarch64::OPCODE::USMOP4A_MZZ_BToS)
  .value("USMOP4A_MZZ_HtoD", LIEF::assembly::aarch64::OPCODE::USMOP4A_MZZ_HtoD)
  .value("USMOP4S_M2Z2Z_BToS", LIEF::assembly::aarch64::OPCODE::USMOP4S_M2Z2Z_BToS)
  .value("USMOP4S_M2Z2Z_HtoD", LIEF::assembly::aarch64::OPCODE::USMOP4S_M2Z2Z_HtoD)
  .value("USMOP4S_M2ZZ_BToS", LIEF::assembly::aarch64::OPCODE::USMOP4S_M2ZZ_BToS)
  .value("USMOP4S_M2ZZ_HtoD", LIEF::assembly::aarch64::OPCODE::USMOP4S_M2ZZ_HtoD)
  .value("USMOP4S_MZ2Z_BToS", LIEF::assembly::aarch64::OPCODE::USMOP4S_MZ2Z_BToS)
  .value("USMOP4S_MZ2Z_HtoD", LIEF::assembly::aarch64::OPCODE::USMOP4S_MZ2Z_HtoD)
  .value("USMOP4S_MZZ_BToS", LIEF::assembly::aarch64::OPCODE::USMOP4S_MZZ_BToS)
  .value("USMOP4S_MZZ_HtoD", LIEF::assembly::aarch64::OPCODE::USMOP4S_MZZ_HtoD)
  .value("USMOPA_MPPZZ_D", LIEF::assembly::aarch64::OPCODE::USMOPA_MPPZZ_D)
  .value("USMOPA_MPPZZ_S", LIEF::assembly::aarch64::OPCODE::USMOPA_MPPZZ_S)
  .value("USMOPS_MPPZZ_D", LIEF::assembly::aarch64::OPCODE::USMOPS_MPPZZ_D)
  .value("USMOPS_MPPZZ_S", LIEF::assembly::aarch64::OPCODE::USMOPS_MPPZZ_S)
  .value("USQADD_ZPmZ_B", LIEF::assembly::aarch64::OPCODE::USQADD_ZPmZ_B)
  .value("USQADD_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::USQADD_ZPmZ_D)
  .value("USQADD_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::USQADD_ZPmZ_H)
  .value("USQADD_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::USQADD_ZPmZ_S)
  .value("USQADDv16i8", LIEF::assembly::aarch64::OPCODE::USQADDv16i8)
  .value("USQADDv1i16", LIEF::assembly::aarch64::OPCODE::USQADDv1i16)
  .value("USQADDv1i32", LIEF::assembly::aarch64::OPCODE::USQADDv1i32)
  .value("USQADDv1i64", LIEF::assembly::aarch64::OPCODE::USQADDv1i64)
  .value("USQADDv1i8", LIEF::assembly::aarch64::OPCODE::USQADDv1i8)
  .value("USQADDv2i32", LIEF::assembly::aarch64::OPCODE::USQADDv2i32)
  .value("USQADDv2i64", LIEF::assembly::aarch64::OPCODE::USQADDv2i64)
  .value("USQADDv4i16", LIEF::assembly::aarch64::OPCODE::USQADDv4i16)
  .value("USQADDv4i32", LIEF::assembly::aarch64::OPCODE::USQADDv4i32)
  .value("USQADDv8i16", LIEF::assembly::aarch64::OPCODE::USQADDv8i16)
  .value("USQADDv8i8", LIEF::assembly::aarch64::OPCODE::USQADDv8i8)
  .value("USRA_ZZI_B", LIEF::assembly::aarch64::OPCODE::USRA_ZZI_B)
  .value("USRA_ZZI_D", LIEF::assembly::aarch64::OPCODE::USRA_ZZI_D)
  .value("USRA_ZZI_H", LIEF::assembly::aarch64::OPCODE::USRA_ZZI_H)
  .value("USRA_ZZI_S", LIEF::assembly::aarch64::OPCODE::USRA_ZZI_S)
  .value("USRAd", LIEF::assembly::aarch64::OPCODE::USRAd)
  .value("USRAv16i8_shift", LIEF::assembly::aarch64::OPCODE::USRAv16i8_shift)
  .value("USRAv2i32_shift", LIEF::assembly::aarch64::OPCODE::USRAv2i32_shift)
  .value("USRAv2i64_shift", LIEF::assembly::aarch64::OPCODE::USRAv2i64_shift)
  .value("USRAv4i16_shift", LIEF::assembly::aarch64::OPCODE::USRAv4i16_shift)
  .value("USRAv4i32_shift", LIEF::assembly::aarch64::OPCODE::USRAv4i32_shift)
  .value("USRAv8i16_shift", LIEF::assembly::aarch64::OPCODE::USRAv8i16_shift)
  .value("USRAv8i8_shift", LIEF::assembly::aarch64::OPCODE::USRAv8i8_shift)
  .value("USTMOPA_M2ZZZI_BtoS", LIEF::assembly::aarch64::OPCODE::USTMOPA_M2ZZZI_BtoS)
  .value("USUBLB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::USUBLB_ZZZ_D)
  .value("USUBLB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::USUBLB_ZZZ_H)
  .value("USUBLB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::USUBLB_ZZZ_S)
  .value("USUBLT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::USUBLT_ZZZ_D)
  .value("USUBLT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::USUBLT_ZZZ_H)
  .value("USUBLT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::USUBLT_ZZZ_S)
  .value("USUBLv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::USUBLv16i8_v8i16)
  .value("USUBLv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::USUBLv2i32_v2i64)
  .value("USUBLv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::USUBLv4i16_v4i32)
  .value("USUBLv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::USUBLv4i32_v2i64)
  .value("USUBLv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::USUBLv8i16_v4i32)
  .value("USUBLv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::USUBLv8i8_v8i16)
  .value("USUBWB_ZZZ_D", LIEF::assembly::aarch64::OPCODE::USUBWB_ZZZ_D)
  .value("USUBWB_ZZZ_H", LIEF::assembly::aarch64::OPCODE::USUBWB_ZZZ_H)
  .value("USUBWB_ZZZ_S", LIEF::assembly::aarch64::OPCODE::USUBWB_ZZZ_S)
  .value("USUBWT_ZZZ_D", LIEF::assembly::aarch64::OPCODE::USUBWT_ZZZ_D)
  .value("USUBWT_ZZZ_H", LIEF::assembly::aarch64::OPCODE::USUBWT_ZZZ_H)
  .value("USUBWT_ZZZ_S", LIEF::assembly::aarch64::OPCODE::USUBWT_ZZZ_S);
  opcodes.value("USUBWv16i8_v8i16", LIEF::assembly::aarch64::OPCODE::USUBWv16i8_v8i16)
  .value("USUBWv2i32_v2i64", LIEF::assembly::aarch64::OPCODE::USUBWv2i32_v2i64)
  .value("USUBWv4i16_v4i32", LIEF::assembly::aarch64::OPCODE::USUBWv4i16_v4i32)
  .value("USUBWv4i32_v2i64", LIEF::assembly::aarch64::OPCODE::USUBWv4i32_v2i64)
  .value("USUBWv8i16_v4i32", LIEF::assembly::aarch64::OPCODE::USUBWv8i16_v4i32)
  .value("USUBWv8i8_v8i16", LIEF::assembly::aarch64::OPCODE::USUBWv8i8_v8i16)
  .value("USVDOT_VG4_M4ZZI_BToS", LIEF::assembly::aarch64::OPCODE::USVDOT_VG4_M4ZZI_BToS)
  .value("UTMOPA_M2ZZZI_BtoS", LIEF::assembly::aarch64::OPCODE::UTMOPA_M2ZZZI_BtoS)
  .value("UTMOPA_M2ZZZI_HtoS", LIEF::assembly::aarch64::OPCODE::UTMOPA_M2ZZZI_HtoS)
  .value("UUNPKHI_ZZ_D", LIEF::assembly::aarch64::OPCODE::UUNPKHI_ZZ_D)
  .value("UUNPKHI_ZZ_H", LIEF::assembly::aarch64::OPCODE::UUNPKHI_ZZ_H)
  .value("UUNPKHI_ZZ_S", LIEF::assembly::aarch64::OPCODE::UUNPKHI_ZZ_S)
  .value("UUNPKLO_ZZ_D", LIEF::assembly::aarch64::OPCODE::UUNPKLO_ZZ_D)
  .value("UUNPKLO_ZZ_H", LIEF::assembly::aarch64::OPCODE::UUNPKLO_ZZ_H)
  .value("UUNPKLO_ZZ_S", LIEF::assembly::aarch64::OPCODE::UUNPKLO_ZZ_S)
  .value("UUNPK_VG2_2ZZ_D", LIEF::assembly::aarch64::OPCODE::UUNPK_VG2_2ZZ_D)
  .value("UUNPK_VG2_2ZZ_H", LIEF::assembly::aarch64::OPCODE::UUNPK_VG2_2ZZ_H)
  .value("UUNPK_VG2_2ZZ_S", LIEF::assembly::aarch64::OPCODE::UUNPK_VG2_2ZZ_S)
  .value("UUNPK_VG4_4Z2Z_D", LIEF::assembly::aarch64::OPCODE::UUNPK_VG4_4Z2Z_D)
  .value("UUNPK_VG4_4Z2Z_H", LIEF::assembly::aarch64::OPCODE::UUNPK_VG4_4Z2Z_H)
  .value("UUNPK_VG4_4Z2Z_S", LIEF::assembly::aarch64::OPCODE::UUNPK_VG4_4Z2Z_S)
  .value("UVDOT_VG2_M2ZZI_HtoS", LIEF::assembly::aarch64::OPCODE::UVDOT_VG2_M2ZZI_HtoS)
  .value("UVDOT_VG4_M4ZZI_BtoS", LIEF::assembly::aarch64::OPCODE::UVDOT_VG4_M4ZZI_BtoS)
  .value("UVDOT_VG4_M4ZZI_HtoD", LIEF::assembly::aarch64::OPCODE::UVDOT_VG4_M4ZZI_HtoD)
  .value("UXTB_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UXTB_ZPmZ_D)
  .value("UXTB_ZPmZ_H", LIEF::assembly::aarch64::OPCODE::UXTB_ZPmZ_H)
  .value("UXTB_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UXTB_ZPmZ_S)
  .value("UXTB_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::UXTB_ZPzZ_D)
  .value("UXTB_ZPzZ_H", LIEF::assembly::aarch64::OPCODE::UXTB_ZPzZ_H)
  .value("UXTB_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::UXTB_ZPzZ_S)
  .value("UXTH_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UXTH_ZPmZ_D)
  .value("UXTH_ZPmZ_S", LIEF::assembly::aarch64::OPCODE::UXTH_ZPmZ_S)
  .value("UXTH_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::UXTH_ZPzZ_D)
  .value("UXTH_ZPzZ_S", LIEF::assembly::aarch64::OPCODE::UXTH_ZPzZ_S)
  .value("UXTW_ZPmZ_D", LIEF::assembly::aarch64::OPCODE::UXTW_ZPmZ_D)
  .value("UXTW_ZPzZ_D", LIEF::assembly::aarch64::OPCODE::UXTW_ZPzZ_D)
  .value("UZP1_PPP_B", LIEF::assembly::aarch64::OPCODE::UZP1_PPP_B)
  .value("UZP1_PPP_D", LIEF::assembly::aarch64::OPCODE::UZP1_PPP_D)
  .value("UZP1_PPP_H", LIEF::assembly::aarch64::OPCODE::UZP1_PPP_H)
  .value("UZP1_PPP_S", LIEF::assembly::aarch64::OPCODE::UZP1_PPP_S)
  .value("UZP1_ZZZ_B", LIEF::assembly::aarch64::OPCODE::UZP1_ZZZ_B)
  .value("UZP1_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UZP1_ZZZ_D)
  .value("UZP1_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UZP1_ZZZ_H)
  .value("UZP1_ZZZ_Q", LIEF::assembly::aarch64::OPCODE::UZP1_ZZZ_Q)
  .value("UZP1_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UZP1_ZZZ_S)
  .value("UZP1v16i8", LIEF::assembly::aarch64::OPCODE::UZP1v16i8)
  .value("UZP1v2i32", LIEF::assembly::aarch64::OPCODE::UZP1v2i32)
  .value("UZP1v2i64", LIEF::assembly::aarch64::OPCODE::UZP1v2i64)
  .value("UZP1v4i16", LIEF::assembly::aarch64::OPCODE::UZP1v4i16)
  .value("UZP1v4i32", LIEF::assembly::aarch64::OPCODE::UZP1v4i32)
  .value("UZP1v8i16", LIEF::assembly::aarch64::OPCODE::UZP1v8i16)
  .value("UZP1v8i8", LIEF::assembly::aarch64::OPCODE::UZP1v8i8)
  .value("UZP2_PPP_B", LIEF::assembly::aarch64::OPCODE::UZP2_PPP_B)
  .value("UZP2_PPP_D", LIEF::assembly::aarch64::OPCODE::UZP2_PPP_D)
  .value("UZP2_PPP_H", LIEF::assembly::aarch64::OPCODE::UZP2_PPP_H)
  .value("UZP2_PPP_S", LIEF::assembly::aarch64::OPCODE::UZP2_PPP_S)
  .value("UZP2_ZZZ_B", LIEF::assembly::aarch64::OPCODE::UZP2_ZZZ_B)
  .value("UZP2_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UZP2_ZZZ_D)
  .value("UZP2_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UZP2_ZZZ_H)
  .value("UZP2_ZZZ_Q", LIEF::assembly::aarch64::OPCODE::UZP2_ZZZ_Q)
  .value("UZP2_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UZP2_ZZZ_S)
  .value("UZP2v16i8", LIEF::assembly::aarch64::OPCODE::UZP2v16i8)
  .value("UZP2v2i32", LIEF::assembly::aarch64::OPCODE::UZP2v2i32)
  .value("UZP2v2i64", LIEF::assembly::aarch64::OPCODE::UZP2v2i64)
  .value("UZP2v4i16", LIEF::assembly::aarch64::OPCODE::UZP2v4i16)
  .value("UZP2v4i32", LIEF::assembly::aarch64::OPCODE::UZP2v4i32)
  .value("UZP2v8i16", LIEF::assembly::aarch64::OPCODE::UZP2v8i16)
  .value("UZP2v8i8", LIEF::assembly::aarch64::OPCODE::UZP2v8i8)
  .value("UZPQ1_ZZZ_B", LIEF::assembly::aarch64::OPCODE::UZPQ1_ZZZ_B)
  .value("UZPQ1_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UZPQ1_ZZZ_D)
  .value("UZPQ1_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UZPQ1_ZZZ_H)
  .value("UZPQ1_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UZPQ1_ZZZ_S)
  .value("UZPQ2_ZZZ_B", LIEF::assembly::aarch64::OPCODE::UZPQ2_ZZZ_B)
  .value("UZPQ2_ZZZ_D", LIEF::assembly::aarch64::OPCODE::UZPQ2_ZZZ_D)
  .value("UZPQ2_ZZZ_H", LIEF::assembly::aarch64::OPCODE::UZPQ2_ZZZ_H)
  .value("UZPQ2_ZZZ_S", LIEF::assembly::aarch64::OPCODE::UZPQ2_ZZZ_S)
  .value("UZP_VG2_2ZZZ_B", LIEF::assembly::aarch64::OPCODE::UZP_VG2_2ZZZ_B)
  .value("UZP_VG2_2ZZZ_D", LIEF::assembly::aarch64::OPCODE::UZP_VG2_2ZZZ_D)
  .value("UZP_VG2_2ZZZ_H", LIEF::assembly::aarch64::OPCODE::UZP_VG2_2ZZZ_H)
  .value("UZP_VG2_2ZZZ_Q", LIEF::assembly::aarch64::OPCODE::UZP_VG2_2ZZZ_Q)
  .value("UZP_VG2_2ZZZ_S", LIEF::assembly::aarch64::OPCODE::UZP_VG2_2ZZZ_S)
  .value("UZP_VG4_4Z4Z_B", LIEF::assembly::aarch64::OPCODE::UZP_VG4_4Z4Z_B)
  .value("UZP_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::UZP_VG4_4Z4Z_D)
  .value("UZP_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::UZP_VG4_4Z4Z_H)
  .value("UZP_VG4_4Z4Z_Q", LIEF::assembly::aarch64::OPCODE::UZP_VG4_4Z4Z_Q)
  .value("UZP_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::UZP_VG4_4Z4Z_S)
  .value("WFET", LIEF::assembly::aarch64::OPCODE::WFET)
  .value("WFIT", LIEF::assembly::aarch64::OPCODE::WFIT)
  .value("WHILEGE_2PXX_B", LIEF::assembly::aarch64::OPCODE::WHILEGE_2PXX_B)
  .value("WHILEGE_2PXX_D", LIEF::assembly::aarch64::OPCODE::WHILEGE_2PXX_D)
  .value("WHILEGE_2PXX_H", LIEF::assembly::aarch64::OPCODE::WHILEGE_2PXX_H)
  .value("WHILEGE_2PXX_S", LIEF::assembly::aarch64::OPCODE::WHILEGE_2PXX_S)
  .value("WHILEGE_CXX_B", LIEF::assembly::aarch64::OPCODE::WHILEGE_CXX_B)
  .value("WHILEGE_CXX_D", LIEF::assembly::aarch64::OPCODE::WHILEGE_CXX_D)
  .value("WHILEGE_CXX_H", LIEF::assembly::aarch64::OPCODE::WHILEGE_CXX_H)
  .value("WHILEGE_CXX_S", LIEF::assembly::aarch64::OPCODE::WHILEGE_CXX_S)
  .value("WHILEGE_PWW_B", LIEF::assembly::aarch64::OPCODE::WHILEGE_PWW_B)
  .value("WHILEGE_PWW_D", LIEF::assembly::aarch64::OPCODE::WHILEGE_PWW_D)
  .value("WHILEGE_PWW_H", LIEF::assembly::aarch64::OPCODE::WHILEGE_PWW_H)
  .value("WHILEGE_PWW_S", LIEF::assembly::aarch64::OPCODE::WHILEGE_PWW_S)
  .value("WHILEGE_PXX_B", LIEF::assembly::aarch64::OPCODE::WHILEGE_PXX_B)
  .value("WHILEGE_PXX_D", LIEF::assembly::aarch64::OPCODE::WHILEGE_PXX_D)
  .value("WHILEGE_PXX_H", LIEF::assembly::aarch64::OPCODE::WHILEGE_PXX_H)
  .value("WHILEGE_PXX_S", LIEF::assembly::aarch64::OPCODE::WHILEGE_PXX_S)
  .value("WHILEGT_2PXX_B", LIEF::assembly::aarch64::OPCODE::WHILEGT_2PXX_B)
  .value("WHILEGT_2PXX_D", LIEF::assembly::aarch64::OPCODE::WHILEGT_2PXX_D)
  .value("WHILEGT_2PXX_H", LIEF::assembly::aarch64::OPCODE::WHILEGT_2PXX_H)
  .value("WHILEGT_2PXX_S", LIEF::assembly::aarch64::OPCODE::WHILEGT_2PXX_S)
  .value("WHILEGT_CXX_B", LIEF::assembly::aarch64::OPCODE::WHILEGT_CXX_B)
  .value("WHILEGT_CXX_D", LIEF::assembly::aarch64::OPCODE::WHILEGT_CXX_D)
  .value("WHILEGT_CXX_H", LIEF::assembly::aarch64::OPCODE::WHILEGT_CXX_H)
  .value("WHILEGT_CXX_S", LIEF::assembly::aarch64::OPCODE::WHILEGT_CXX_S)
  .value("WHILEGT_PWW_B", LIEF::assembly::aarch64::OPCODE::WHILEGT_PWW_B)
  .value("WHILEGT_PWW_D", LIEF::assembly::aarch64::OPCODE::WHILEGT_PWW_D)
  .value("WHILEGT_PWW_H", LIEF::assembly::aarch64::OPCODE::WHILEGT_PWW_H)
  .value("WHILEGT_PWW_S", LIEF::assembly::aarch64::OPCODE::WHILEGT_PWW_S)
  .value("WHILEGT_PXX_B", LIEF::assembly::aarch64::OPCODE::WHILEGT_PXX_B)
  .value("WHILEGT_PXX_D", LIEF::assembly::aarch64::OPCODE::WHILEGT_PXX_D)
  .value("WHILEGT_PXX_H", LIEF::assembly::aarch64::OPCODE::WHILEGT_PXX_H)
  .value("WHILEGT_PXX_S", LIEF::assembly::aarch64::OPCODE::WHILEGT_PXX_S)
  .value("WHILEHI_2PXX_B", LIEF::assembly::aarch64::OPCODE::WHILEHI_2PXX_B)
  .value("WHILEHI_2PXX_D", LIEF::assembly::aarch64::OPCODE::WHILEHI_2PXX_D)
  .value("WHILEHI_2PXX_H", LIEF::assembly::aarch64::OPCODE::WHILEHI_2PXX_H)
  .value("WHILEHI_2PXX_S", LIEF::assembly::aarch64::OPCODE::WHILEHI_2PXX_S)
  .value("WHILEHI_CXX_B", LIEF::assembly::aarch64::OPCODE::WHILEHI_CXX_B)
  .value("WHILEHI_CXX_D", LIEF::assembly::aarch64::OPCODE::WHILEHI_CXX_D)
  .value("WHILEHI_CXX_H", LIEF::assembly::aarch64::OPCODE::WHILEHI_CXX_H)
  .value("WHILEHI_CXX_S", LIEF::assembly::aarch64::OPCODE::WHILEHI_CXX_S)
  .value("WHILEHI_PWW_B", LIEF::assembly::aarch64::OPCODE::WHILEHI_PWW_B)
  .value("WHILEHI_PWW_D", LIEF::assembly::aarch64::OPCODE::WHILEHI_PWW_D)
  .value("WHILEHI_PWW_H", LIEF::assembly::aarch64::OPCODE::WHILEHI_PWW_H)
  .value("WHILEHI_PWW_S", LIEF::assembly::aarch64::OPCODE::WHILEHI_PWW_S)
  .value("WHILEHI_PXX_B", LIEF::assembly::aarch64::OPCODE::WHILEHI_PXX_B)
  .value("WHILEHI_PXX_D", LIEF::assembly::aarch64::OPCODE::WHILEHI_PXX_D)
  .value("WHILEHI_PXX_H", LIEF::assembly::aarch64::OPCODE::WHILEHI_PXX_H)
  .value("WHILEHI_PXX_S", LIEF::assembly::aarch64::OPCODE::WHILEHI_PXX_S)
  .value("WHILEHS_2PXX_B", LIEF::assembly::aarch64::OPCODE::WHILEHS_2PXX_B)
  .value("WHILEHS_2PXX_D", LIEF::assembly::aarch64::OPCODE::WHILEHS_2PXX_D)
  .value("WHILEHS_2PXX_H", LIEF::assembly::aarch64::OPCODE::WHILEHS_2PXX_H)
  .value("WHILEHS_2PXX_S", LIEF::assembly::aarch64::OPCODE::WHILEHS_2PXX_S)
  .value("WHILEHS_CXX_B", LIEF::assembly::aarch64::OPCODE::WHILEHS_CXX_B)
  .value("WHILEHS_CXX_D", LIEF::assembly::aarch64::OPCODE::WHILEHS_CXX_D)
  .value("WHILEHS_CXX_H", LIEF::assembly::aarch64::OPCODE::WHILEHS_CXX_H)
  .value("WHILEHS_CXX_S", LIEF::assembly::aarch64::OPCODE::WHILEHS_CXX_S)
  .value("WHILEHS_PWW_B", LIEF::assembly::aarch64::OPCODE::WHILEHS_PWW_B)
  .value("WHILEHS_PWW_D", LIEF::assembly::aarch64::OPCODE::WHILEHS_PWW_D)
  .value("WHILEHS_PWW_H", LIEF::assembly::aarch64::OPCODE::WHILEHS_PWW_H)
  .value("WHILEHS_PWW_S", LIEF::assembly::aarch64::OPCODE::WHILEHS_PWW_S)
  .value("WHILEHS_PXX_B", LIEF::assembly::aarch64::OPCODE::WHILEHS_PXX_B)
  .value("WHILEHS_PXX_D", LIEF::assembly::aarch64::OPCODE::WHILEHS_PXX_D)
  .value("WHILEHS_PXX_H", LIEF::assembly::aarch64::OPCODE::WHILEHS_PXX_H)
  .value("WHILEHS_PXX_S", LIEF::assembly::aarch64::OPCODE::WHILEHS_PXX_S)
  .value("WHILELE_2PXX_B", LIEF::assembly::aarch64::OPCODE::WHILELE_2PXX_B)
  .value("WHILELE_2PXX_D", LIEF::assembly::aarch64::OPCODE::WHILELE_2PXX_D)
  .value("WHILELE_2PXX_H", LIEF::assembly::aarch64::OPCODE::WHILELE_2PXX_H)
  .value("WHILELE_2PXX_S", LIEF::assembly::aarch64::OPCODE::WHILELE_2PXX_S)
  .value("WHILELE_CXX_B", LIEF::assembly::aarch64::OPCODE::WHILELE_CXX_B)
  .value("WHILELE_CXX_D", LIEF::assembly::aarch64::OPCODE::WHILELE_CXX_D)
  .value("WHILELE_CXX_H", LIEF::assembly::aarch64::OPCODE::WHILELE_CXX_H)
  .value("WHILELE_CXX_S", LIEF::assembly::aarch64::OPCODE::WHILELE_CXX_S)
  .value("WHILELE_PWW_B", LIEF::assembly::aarch64::OPCODE::WHILELE_PWW_B)
  .value("WHILELE_PWW_D", LIEF::assembly::aarch64::OPCODE::WHILELE_PWW_D)
  .value("WHILELE_PWW_H", LIEF::assembly::aarch64::OPCODE::WHILELE_PWW_H)
  .value("WHILELE_PWW_S", LIEF::assembly::aarch64::OPCODE::WHILELE_PWW_S)
  .value("WHILELE_PXX_B", LIEF::assembly::aarch64::OPCODE::WHILELE_PXX_B)
  .value("WHILELE_PXX_D", LIEF::assembly::aarch64::OPCODE::WHILELE_PXX_D)
  .value("WHILELE_PXX_H", LIEF::assembly::aarch64::OPCODE::WHILELE_PXX_H)
  .value("WHILELE_PXX_S", LIEF::assembly::aarch64::OPCODE::WHILELE_PXX_S)
  .value("WHILELO_2PXX_B", LIEF::assembly::aarch64::OPCODE::WHILELO_2PXX_B)
  .value("WHILELO_2PXX_D", LIEF::assembly::aarch64::OPCODE::WHILELO_2PXX_D)
  .value("WHILELO_2PXX_H", LIEF::assembly::aarch64::OPCODE::WHILELO_2PXX_H)
  .value("WHILELO_2PXX_S", LIEF::assembly::aarch64::OPCODE::WHILELO_2PXX_S)
  .value("WHILELO_CXX_B", LIEF::assembly::aarch64::OPCODE::WHILELO_CXX_B)
  .value("WHILELO_CXX_D", LIEF::assembly::aarch64::OPCODE::WHILELO_CXX_D)
  .value("WHILELO_CXX_H", LIEF::assembly::aarch64::OPCODE::WHILELO_CXX_H)
  .value("WHILELO_CXX_S", LIEF::assembly::aarch64::OPCODE::WHILELO_CXX_S)
  .value("WHILELO_PWW_B", LIEF::assembly::aarch64::OPCODE::WHILELO_PWW_B)
  .value("WHILELO_PWW_D", LIEF::assembly::aarch64::OPCODE::WHILELO_PWW_D)
  .value("WHILELO_PWW_H", LIEF::assembly::aarch64::OPCODE::WHILELO_PWW_H)
  .value("WHILELO_PWW_S", LIEF::assembly::aarch64::OPCODE::WHILELO_PWW_S)
  .value("WHILELO_PXX_B", LIEF::assembly::aarch64::OPCODE::WHILELO_PXX_B)
  .value("WHILELO_PXX_D", LIEF::assembly::aarch64::OPCODE::WHILELO_PXX_D)
  .value("WHILELO_PXX_H", LIEF::assembly::aarch64::OPCODE::WHILELO_PXX_H)
  .value("WHILELO_PXX_S", LIEF::assembly::aarch64::OPCODE::WHILELO_PXX_S)
  .value("WHILELS_2PXX_B", LIEF::assembly::aarch64::OPCODE::WHILELS_2PXX_B)
  .value("WHILELS_2PXX_D", LIEF::assembly::aarch64::OPCODE::WHILELS_2PXX_D)
  .value("WHILELS_2PXX_H", LIEF::assembly::aarch64::OPCODE::WHILELS_2PXX_H)
  .value("WHILELS_2PXX_S", LIEF::assembly::aarch64::OPCODE::WHILELS_2PXX_S)
  .value("WHILELS_CXX_B", LIEF::assembly::aarch64::OPCODE::WHILELS_CXX_B)
  .value("WHILELS_CXX_D", LIEF::assembly::aarch64::OPCODE::WHILELS_CXX_D)
  .value("WHILELS_CXX_H", LIEF::assembly::aarch64::OPCODE::WHILELS_CXX_H)
  .value("WHILELS_CXX_S", LIEF::assembly::aarch64::OPCODE::WHILELS_CXX_S)
  .value("WHILELS_PWW_B", LIEF::assembly::aarch64::OPCODE::WHILELS_PWW_B)
  .value("WHILELS_PWW_D", LIEF::assembly::aarch64::OPCODE::WHILELS_PWW_D)
  .value("WHILELS_PWW_H", LIEF::assembly::aarch64::OPCODE::WHILELS_PWW_H)
  .value("WHILELS_PWW_S", LIEF::assembly::aarch64::OPCODE::WHILELS_PWW_S)
  .value("WHILELS_PXX_B", LIEF::assembly::aarch64::OPCODE::WHILELS_PXX_B)
  .value("WHILELS_PXX_D", LIEF::assembly::aarch64::OPCODE::WHILELS_PXX_D)
  .value("WHILELS_PXX_H", LIEF::assembly::aarch64::OPCODE::WHILELS_PXX_H)
  .value("WHILELS_PXX_S", LIEF::assembly::aarch64::OPCODE::WHILELS_PXX_S)
  .value("WHILELT_2PXX_B", LIEF::assembly::aarch64::OPCODE::WHILELT_2PXX_B)
  .value("WHILELT_2PXX_D", LIEF::assembly::aarch64::OPCODE::WHILELT_2PXX_D)
  .value("WHILELT_2PXX_H", LIEF::assembly::aarch64::OPCODE::WHILELT_2PXX_H)
  .value("WHILELT_2PXX_S", LIEF::assembly::aarch64::OPCODE::WHILELT_2PXX_S)
  .value("WHILELT_CXX_B", LIEF::assembly::aarch64::OPCODE::WHILELT_CXX_B)
  .value("WHILELT_CXX_D", LIEF::assembly::aarch64::OPCODE::WHILELT_CXX_D)
  .value("WHILELT_CXX_H", LIEF::assembly::aarch64::OPCODE::WHILELT_CXX_H)
  .value("WHILELT_CXX_S", LIEF::assembly::aarch64::OPCODE::WHILELT_CXX_S)
  .value("WHILELT_PWW_B", LIEF::assembly::aarch64::OPCODE::WHILELT_PWW_B)
  .value("WHILELT_PWW_D", LIEF::assembly::aarch64::OPCODE::WHILELT_PWW_D)
  .value("WHILELT_PWW_H", LIEF::assembly::aarch64::OPCODE::WHILELT_PWW_H)
  .value("WHILELT_PWW_S", LIEF::assembly::aarch64::OPCODE::WHILELT_PWW_S)
  .value("WHILELT_PXX_B", LIEF::assembly::aarch64::OPCODE::WHILELT_PXX_B)
  .value("WHILELT_PXX_D", LIEF::assembly::aarch64::OPCODE::WHILELT_PXX_D)
  .value("WHILELT_PXX_H", LIEF::assembly::aarch64::OPCODE::WHILELT_PXX_H)
  .value("WHILELT_PXX_S", LIEF::assembly::aarch64::OPCODE::WHILELT_PXX_S)
  .value("WHILERW_PXX_B", LIEF::assembly::aarch64::OPCODE::WHILERW_PXX_B)
  .value("WHILERW_PXX_D", LIEF::assembly::aarch64::OPCODE::WHILERW_PXX_D)
  .value("WHILERW_PXX_H", LIEF::assembly::aarch64::OPCODE::WHILERW_PXX_H)
  .value("WHILERW_PXX_S", LIEF::assembly::aarch64::OPCODE::WHILERW_PXX_S)
  .value("WHILEWR_PXX_B", LIEF::assembly::aarch64::OPCODE::WHILEWR_PXX_B)
  .value("WHILEWR_PXX_D", LIEF::assembly::aarch64::OPCODE::WHILEWR_PXX_D)
  .value("WHILEWR_PXX_H", LIEF::assembly::aarch64::OPCODE::WHILEWR_PXX_H)
  .value("WHILEWR_PXX_S", LIEF::assembly::aarch64::OPCODE::WHILEWR_PXX_S)
  .value("WRFFR", LIEF::assembly::aarch64::OPCODE::WRFFR)
  .value("XAFLAG", LIEF::assembly::aarch64::OPCODE::XAFLAG)
  .value("XAR", LIEF::assembly::aarch64::OPCODE::XAR)
  .value("XAR_ZZZI_B", LIEF::assembly::aarch64::OPCODE::XAR_ZZZI_B)
  .value("XAR_ZZZI_D", LIEF::assembly::aarch64::OPCODE::XAR_ZZZI_D)
  .value("XAR_ZZZI_H", LIEF::assembly::aarch64::OPCODE::XAR_ZZZI_H)
  .value("XAR_ZZZI_S", LIEF::assembly::aarch64::OPCODE::XAR_ZZZI_S)
  .value("XPACD", LIEF::assembly::aarch64::OPCODE::XPACD)
  .value("XPACI", LIEF::assembly::aarch64::OPCODE::XPACI)
  .value("XPACLRI", LIEF::assembly::aarch64::OPCODE::XPACLRI)
  .value("XTNv16i8", LIEF::assembly::aarch64::OPCODE::XTNv16i8)
  .value("XTNv2i32", LIEF::assembly::aarch64::OPCODE::XTNv2i32)
  .value("XTNv4i16", LIEF::assembly::aarch64::OPCODE::XTNv4i16)
  .value("XTNv4i32", LIEF::assembly::aarch64::OPCODE::XTNv4i32)
  .value("XTNv8i16", LIEF::assembly::aarch64::OPCODE::XTNv8i16)
  .value("XTNv8i8", LIEF::assembly::aarch64::OPCODE::XTNv8i8)
  .value("ZERO_M", LIEF::assembly::aarch64::OPCODE::ZERO_M)
  .value("ZERO_MXI_2Z", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_2Z)
  .value("ZERO_MXI_4Z", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_4Z)
  .value("ZERO_MXI_VG2_2Z", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_VG2_2Z)
  .value("ZERO_MXI_VG2_4Z", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_VG2_4Z)
  .value("ZERO_MXI_VG2_Z", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_VG2_Z)
  .value("ZERO_MXI_VG4_2Z", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_VG4_2Z)
  .value("ZERO_MXI_VG4_4Z", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_VG4_4Z)
  .value("ZERO_MXI_VG4_Z", LIEF::assembly::aarch64::OPCODE::ZERO_MXI_VG4_Z)
  .value("ZERO_T", LIEF::assembly::aarch64::OPCODE::ZERO_T)
  .value("ZIP1_PPP_B", LIEF::assembly::aarch64::OPCODE::ZIP1_PPP_B)
  .value("ZIP1_PPP_D", LIEF::assembly::aarch64::OPCODE::ZIP1_PPP_D)
  .value("ZIP1_PPP_H", LIEF::assembly::aarch64::OPCODE::ZIP1_PPP_H)
  .value("ZIP1_PPP_S", LIEF::assembly::aarch64::OPCODE::ZIP1_PPP_S)
  .value("ZIP1_ZZZ_B", LIEF::assembly::aarch64::OPCODE::ZIP1_ZZZ_B)
  .value("ZIP1_ZZZ_D", LIEF::assembly::aarch64::OPCODE::ZIP1_ZZZ_D)
  .value("ZIP1_ZZZ_H", LIEF::assembly::aarch64::OPCODE::ZIP1_ZZZ_H)
  .value("ZIP1_ZZZ_Q", LIEF::assembly::aarch64::OPCODE::ZIP1_ZZZ_Q)
  .value("ZIP1_ZZZ_S", LIEF::assembly::aarch64::OPCODE::ZIP1_ZZZ_S)
  .value("ZIP1v16i8", LIEF::assembly::aarch64::OPCODE::ZIP1v16i8)
  .value("ZIP1v2i32", LIEF::assembly::aarch64::OPCODE::ZIP1v2i32)
  .value("ZIP1v2i64", LIEF::assembly::aarch64::OPCODE::ZIP1v2i64)
  .value("ZIP1v4i16", LIEF::assembly::aarch64::OPCODE::ZIP1v4i16)
  .value("ZIP1v4i32", LIEF::assembly::aarch64::OPCODE::ZIP1v4i32)
  .value("ZIP1v8i16", LIEF::assembly::aarch64::OPCODE::ZIP1v8i16)
  .value("ZIP1v8i8", LIEF::assembly::aarch64::OPCODE::ZIP1v8i8)
  .value("ZIP2_PPP_B", LIEF::assembly::aarch64::OPCODE::ZIP2_PPP_B)
  .value("ZIP2_PPP_D", LIEF::assembly::aarch64::OPCODE::ZIP2_PPP_D)
  .value("ZIP2_PPP_H", LIEF::assembly::aarch64::OPCODE::ZIP2_PPP_H)
  .value("ZIP2_PPP_S", LIEF::assembly::aarch64::OPCODE::ZIP2_PPP_S)
  .value("ZIP2_ZZZ_B", LIEF::assembly::aarch64::OPCODE::ZIP2_ZZZ_B)
  .value("ZIP2_ZZZ_D", LIEF::assembly::aarch64::OPCODE::ZIP2_ZZZ_D)
  .value("ZIP2_ZZZ_H", LIEF::assembly::aarch64::OPCODE::ZIP2_ZZZ_H)
  .value("ZIP2_ZZZ_Q", LIEF::assembly::aarch64::OPCODE::ZIP2_ZZZ_Q)
  .value("ZIP2_ZZZ_S", LIEF::assembly::aarch64::OPCODE::ZIP2_ZZZ_S)
  .value("ZIP2v16i8", LIEF::assembly::aarch64::OPCODE::ZIP2v16i8)
  .value("ZIP2v2i32", LIEF::assembly::aarch64::OPCODE::ZIP2v2i32)
  .value("ZIP2v2i64", LIEF::assembly::aarch64::OPCODE::ZIP2v2i64)
  .value("ZIP2v4i16", LIEF::assembly::aarch64::OPCODE::ZIP2v4i16)
  .value("ZIP2v4i32", LIEF::assembly::aarch64::OPCODE::ZIP2v4i32)
  .value("ZIP2v8i16", LIEF::assembly::aarch64::OPCODE::ZIP2v8i16)
  .value("ZIP2v8i8", LIEF::assembly::aarch64::OPCODE::ZIP2v8i8)
  .value("ZIPQ1_ZZZ_B", LIEF::assembly::aarch64::OPCODE::ZIPQ1_ZZZ_B)
  .value("ZIPQ1_ZZZ_D", LIEF::assembly::aarch64::OPCODE::ZIPQ1_ZZZ_D)
  .value("ZIPQ1_ZZZ_H", LIEF::assembly::aarch64::OPCODE::ZIPQ1_ZZZ_H)
  .value("ZIPQ1_ZZZ_S", LIEF::assembly::aarch64::OPCODE::ZIPQ1_ZZZ_S)
  .value("ZIPQ2_ZZZ_B", LIEF::assembly::aarch64::OPCODE::ZIPQ2_ZZZ_B)
  .value("ZIPQ2_ZZZ_D", LIEF::assembly::aarch64::OPCODE::ZIPQ2_ZZZ_D)
  .value("ZIPQ2_ZZZ_H", LIEF::assembly::aarch64::OPCODE::ZIPQ2_ZZZ_H)
  .value("ZIPQ2_ZZZ_S", LIEF::assembly::aarch64::OPCODE::ZIPQ2_ZZZ_S)
  .value("ZIP_VG2_2ZZZ_B", LIEF::assembly::aarch64::OPCODE::ZIP_VG2_2ZZZ_B)
  .value("ZIP_VG2_2ZZZ_D", LIEF::assembly::aarch64::OPCODE::ZIP_VG2_2ZZZ_D)
  .value("ZIP_VG2_2ZZZ_H", LIEF::assembly::aarch64::OPCODE::ZIP_VG2_2ZZZ_H)
  .value("ZIP_VG2_2ZZZ_Q", LIEF::assembly::aarch64::OPCODE::ZIP_VG2_2ZZZ_Q)
  .value("ZIP_VG2_2ZZZ_S", LIEF::assembly::aarch64::OPCODE::ZIP_VG2_2ZZZ_S)
  .value("ZIP_VG4_4Z4Z_B", LIEF::assembly::aarch64::OPCODE::ZIP_VG4_4Z4Z_B)
  .value("ZIP_VG4_4Z4Z_D", LIEF::assembly::aarch64::OPCODE::ZIP_VG4_4Z4Z_D)
  .value("ZIP_VG4_4Z4Z_H", LIEF::assembly::aarch64::OPCODE::ZIP_VG4_4Z4Z_H)
  .value("ZIP_VG4_4Z4Z_Q", LIEF::assembly::aarch64::OPCODE::ZIP_VG4_4Z4Z_Q)
  .value("ZIP_VG4_4Z4Z_S", LIEF::assembly::aarch64::OPCODE::ZIP_VG4_4Z4Z_S);
  opcodes.value("INSTRUCTION_LIST_END", LIEF::assembly::aarch64::OPCODE::INSTRUCTION_LIST_END)
  ;
}
}
