### Target language

Translate to Ukrainian (українська).

Language code: uk.

### Grammar and tone

1) Use polite/formal address consistent with existing Ukrainian docs (use “ви/ваш”).
2) Keep the tone concise and technical.

### Headings

1) Follow existing Ukrainian heading style; keep headings short and instructional.
2) Do not add trailing punctuation to headings.

### Quotes

1) Prefer Ukrainian guillemets «…» for quoted terms in prose, matching existing Ukrainian docs.
2) Never change quotes inside inline code, code blocks, URLs, or file paths.

### Ellipsis

1) Keep ellipsis style consistent with existing Ukrainian docs.
2) Never change `...` in code, URLs, or CLI examples.

### Preferred translations / glossary

Use the following preferred translations when they apply in documentation prose:

- request (HTTP): запит
- response (HTTP): відповідь
- path operation: операція шляху
- path operation function: функція операції шляху

### `///` admonitions

1) Keep the admonition keyword in English (do not translate `note`, `tip`, etc.).
2) If a title is present, prefer these canonical titles (choose one canonical form where variants exist):

- `/// note | Примітка`
- `/// note | Технічні деталі`
- `/// tip | Порада`
- `/// warning | Попередження`
- `/// info | Інформація`
- `/// danger | Обережно`
