;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: foreach %s %t wasm-opt --remove-unused-module-elements -all -S -o - | filecheck %s

;; Test for precise handling of call_indirect types.

;; We have an indirect call of $A, but not of $B. This keeps alive segments with
;; relevant functions, but not other segments. It also does not keep alive other
;; functions in those segments (we refer to them, but can empty out their
;; contents). Specifically:
;;
;;  * elem $t1-withA contains $A, so it keeps alive func $A1 and $subA1, and
;;    emptied stubs for $B1 and $C1.
;;  * elem $t1-noA has no $A or a subtype, so the segment is removed entirely.
;;  * elem $t1-withSubA has a subtype of $A, so it is similar to $t1-withA.
;;  * elem $t2-withA has $A, but no call goes to that table.
;;
(module
 ;; CHECK:      (type $A (sub (func)))
 (type $A (sub (func)))

 ;; CHECK:      (type $B (sub (func (param f64))))
 (type $B (sub (func (param f64))))

 ;; CHECK:      (type $subA (sub $A (func)))
 (type $subA (sub $A (func)))

 ;; CHECK:      (type $3 (func (param f32)))

 ;; CHECK:      (type $4 (func))

 ;; CHECK:      (table $t1 60 60 funcref)
 (table $t1 60 60 funcref)

 (table $t2 60 60 funcref)

 ;; CHECK:      (elem $t1-withA (i32.const 0) $A1 $B1 $subA1 $C1)
 (elem $t1-withA (table $t1) (i32.const 0) func $A1 $B1 $subA1 $C1)

 (elem $t1-noA (table $t1) (i32.const 10) func $B2 $C2)

 ;; CHECK:      (elem $t1-withSubA (i32.const 20) $B3 $subA3 $C3)
 (elem $t1-withSubA (table $t1) (i32.const 20) func $B3 $subA3 $C3)

 (elem $t2-withA (table $t2) (i32.const 0) func $A2)

 ;; CHECK:      (export "export" (func $export))

 ;; CHECK:      (func $export (type $4)
 ;; CHECK-NEXT:  (call_indirect $t1 (type $A)
 ;; CHECK-NEXT:   (i32.const -1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $export (export "export")
  (call_indirect $t1 (type $A)
   (i32.const -1)
  )
 )

 ;; CHECK:      (func $A1 (type $A)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 10)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $A1 (type $A)
  (drop (i32.const 10))
 )

 ;; CHECK:      (func $B1 (type $B) (param $p f64)
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $B1 (type $B) (param $p f64)
  ;; We can empty this out, as while a segment references it, no call_indirect
  ;; exists.
  (drop (i32.const 20))
 )

 ;; CHECK:      (func $subA1 (type $subA)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 30)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $subA1 (type $subA)
  (drop (i32.const 30))
 )

 ;; CHECK:      (func $C1 (type $3) (param $p f32)
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $C1 (param $p f32)
  ;; We can empty this out, as while a segment references it, no call_indirect
  ;; exists.
  (drop (i32.const 40))
 )

 (func $B2 (type $B) (param $p f64)
  ;; No viable uses exist of this, it is in a segment with no uses.
  (drop (i32.const 50))
 )

 (func $C2 (param $p f32)
  ;; No viable uses exist of this, it is in a segment with no uses.
  (drop (i32.const 60))
 )

 ;; CHECK:      (func $B3 (type $B) (param $p f64)
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $B3 (type $B) (param $p f64)
  ;; We can empty this out, as while a segment references it, no call_indirect
  ;; exists.
  (drop (i32.const 70))
 )

 ;; CHECK:      (func $subA3 (type $subA)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 80)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $subA3 (type $subA)
  (drop (i32.const 80))
 )

 ;; CHECK:      (func $C3 (type $3) (param $p f32)
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $C3 (param $p f32)
  ;; We can empty this out, as while a segment references it, no call_indirect
  ;; exists. We can also remove the thing it calls.
  (drop (call $C3-called))
 )

 (func $C3-called (result i32)
  ;; The only caller of this is emptied out, so we don't need it.
  (i32.const 100)
 )

 (func $A2 (type $A)
  ;; No viable uses exist of this, it is in the wrong table.
  (drop (i32.const 110))
 )
)

;; Similar to above, but now the table is exported, and the test is a bit
;; simplified to focus on the changes from that. Given the export, we must
;; assume the outside can call anything in the table.
(module
 ;; CHECK:      (type $A (sub (func)))
 (type $A (sub (func)))

 ;; CHECK:      (type $B (sub (func (param f64))))
 (type $B (sub (func (param f64))))

 ;; CHECK:      (type $2 (func (param f32)))

 ;; CHECK:      (type $3 (func))

 ;; CHECK:      (type $subA (sub $A (func)))
 (type $subA (sub $A (func)))

 ;; CHECK:      (table $t1 60 60 funcref)
 (table $t1 60 60 funcref)

 ;; CHECK:      (elem $t1-withA (i32.const 0) $A1 $B1 $subA1 $C1)
 (elem $t1-withA (table $t1) (i32.const 0) func $A1 $B1 $subA1 $C1)

 ;; CHECK:      (elem $t1-noA (i32.const 10) $B2 $C2)
 (elem $t1-noA (table $t1) (i32.const 10) func $B2 $C2)

 ;; CHECK:      (export "export" (func $export))

 ;; CHECK:      (export "table" (table $t1))
 (export "table" (table $t1))

 ;; CHECK:      (func $export (type $3)
 ;; CHECK-NEXT:  (call_indirect $t1 (type $A)
 ;; CHECK-NEXT:   (i32.const -1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $export (export "export")
  (call_indirect $t1 (type $A)
   (i32.const -1)
  )
 )

 ;; CHECK:      (func $A1 (type $A)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 10)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $A1 (type $A)
  (drop (i32.const 10))
 )

 ;; CHECK:      (func $B1 (type $B) (param $p f64)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 20)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $B1 (type $B) (param $p f64)
  ;; The table export causes this to be kept in full.
  (drop (i32.const 20))
 )

 ;; CHECK:      (func $subA1 (type $subA)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 30)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $subA1 (type $subA)
  (drop (i32.const 30))
 )

 ;; CHECK:      (func $C1 (type $2) (param $p f32)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 40)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $C1 (param $p f32)
  ;; The table export causes this to be kept in full.
  (drop (i32.const 40))
 )

 ;; CHECK:      (func $B2 (type $B) (param $p f64)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 50)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $B2 (type $B) (param $p f64)
  ;; The table export causes this to be kept in full.
  (drop (i32.const 50))
 )

 ;; CHECK:      (func $C2 (type $2) (param $p f32)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 60)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $C2 (param $p f32)
  ;; The table export causes this to be kept in full.
  (drop (i32.const 60))
 )
)

;; As above, but the table is imported instead of exported. That still means it
;; is externally accessible, so we must root its contents.
(module
 ;; CHECK:      (type $A (sub (func)))
 (type $A (sub (func)))

 ;; CHECK:      (type $B (sub (func (param f64))))
 (type $B (sub (func (param f64))))

 ;; CHECK:      (type $2 (func (param f32)))

 ;; CHECK:      (type $3 (func))

 ;; CHECK:      (type $subA (sub $A (func)))
 (type $subA (sub $A (func)))

 ;; CHECK:      (import "a" "b" (table $t1 60 60 funcref))
 (import "a" "b" (table $t1 60 60 funcref))

 ;; CHECK:      (elem $t1-withA (i32.const 0) $A1 $B1 $subA1 $C1)
 (elem $t1-withA (table $t1) (i32.const 0) func $A1 $B1 $subA1 $C1)

 ;; CHECK:      (elem $t1-noA (i32.const 10) $B2 $C2)
 (elem $t1-noA (table $t1) (i32.const 10) func $B2 $C2)

 ;; CHECK:      (export "export" (func $export))

 ;; CHECK:      (func $export (type $3)
 ;; CHECK-NEXT:  (call_indirect $t1 (type $A)
 ;; CHECK-NEXT:   (i32.const -1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $export (export "export")
  (call_indirect $t1 (type $A)
   (i32.const -1)
  )
 )

 ;; CHECK:      (func $A1 (type $A)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 10)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $A1 (type $A)
  (drop (i32.const 10))
 )

 ;; CHECK:      (func $B1 (type $B) (param $p f64)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 20)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $B1 (type $B) (param $p f64)
  ;; The table import causes this to be kept in full.
  (drop (i32.const 20))
 )

 ;; CHECK:      (func $subA1 (type $subA)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 30)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $subA1 (type $subA)
  (drop (i32.const 30))
 )

 ;; CHECK:      (func $C1 (type $2) (param $p f32)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 40)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $C1 (param $p f32)
  ;; The table import causes this to be kept in full.
  (drop (i32.const 40))
 )

 ;; CHECK:      (func $B2 (type $B) (param $p f64)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 50)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $B2 (type $B) (param $p f64)
  ;; The table import causes this to be kept in full.
  (drop (i32.const 50))
 )

 ;; CHECK:      (func $C2 (type $2) (param $p f32)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 60)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $C2 (param $p f32)
  ;; The table import causes this to be kept in full.
  (drop (i32.const 60))
 )
)

;; A chain of indirect calls: an export calls type $A, and a function of type $A
;; calls $B, and $B calls $C. All those are used, but a final function of type
;; $D is not, and can be cleared out.
(module
 (rec
  ;; CHECK:      (rec
  ;; CHECK-NEXT:  (type $A (func))
  (type $A (func))
  ;; CHECK:       (type $B (func))
  (type $B (func))
  ;; CHECK:       (type $C (func))
  (type $C (func))
  ;; CHECK:       (type $D (func))
  (type $D (func))
 )

 ;; CHECK:      (type $4 (func))

 ;; CHECK:      (table $t 60 60 funcref)
 (table $t 60 60 funcref)

 ;; CHECK:      (elem $elem (i32.const 0) $A $B $C $D)
 (elem $elem (table $t) (i32.const 0) func $A $B $C $D)

 ;; CHECK:      (export "export" (func $export))

 ;; CHECK:      (func $export (type $4)
 ;; CHECK-NEXT:  (call_indirect $t (type $A)
 ;; CHECK-NEXT:   (i32.const -1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $export (export "export")
  (call_indirect $t (type $A)
   (i32.const -1)
  )
 )

 ;; CHECK:      (func $A (type $A)
 ;; CHECK-NEXT:  (call_indirect $t (type $B)
 ;; CHECK-NEXT:   (i32.const -1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $A (type $A)
  (call_indirect $t (type $B)
   (i32.const -1)
  )
 )

 ;; CHECK:      (func $B (type $B)
 ;; CHECK-NEXT:  (call_indirect $t (type $C)
 ;; CHECK-NEXT:   (i32.const -1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $B (type $B)
  (call_indirect $t (type $C)
   (i32.const -1)
  )
 )

 ;; CHECK:      (func $C (type $C)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 30)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $C (type $C)
  ;; Chain breaks here, no call to $D.
  (drop (i32.const 30))
 )

 ;; CHECK:      (func $D (type $D)
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $D (type $D)
  ;; Add calls to all types, to check unreached code does not confuse us.
  (call_indirect $t (type $A)
   (i32.const -1)
  )
  (call_indirect $t (type $B)
   (i32.const -1)
  )
  (call_indirect $t (type $C)
   (i32.const -1)
  )
  (call_indirect $t (type $D)
   (i32.const -1)
  )
 )
)

;; Check that functions applied using table.init are handled properly. The
;; function $A will be called after the table.init, so we cannot empty it or
;; remove it.
(module
 ;; CHECK:      (type $A (func))
 (type $A (func))

 ;; CHECK:      (table $table 22 funcref)
 (table $table 22 funcref)

 ;; CHECK:      (elem $later func $A)
 (elem $later $A)

 ;; CHECK:      (export "export" (func $export))

 ;; CHECK:      (func $export (type $A)
 ;; CHECK-NEXT:  (table.init $table $later
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call_indirect $table (type $A)
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $export (export "export")
  (table.init $table $later
   (i32.const 0)
   (i32.const 0)
   (i32.const 1)
  )
  (call_indirect $table (type $A)
   (i32.const 0)
  )
 )

 ;; CHECK:      (func $A (type $A)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 42)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $A (type $A)
  (drop (i32.const 42))
 )
)

;; As above, but without table.init. We could optimize here, but do not yet -
;; we would need to track table.* operations fully.
(module
 ;; CHECK:      (type $A (func))
 (type $A (func))

 ;; CHECK:      (table $table 22 funcref)
 (table $table 22 funcref)

 ;; CHECK:      (elem $later func $A)
 (elem $later $A)

 ;; CHECK:      (export "export" (func $export))

 ;; CHECK:      (func $export (type $A)
 ;; CHECK-NEXT:  (call_indirect $table (type $A)
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (elem.drop $later)
 ;; CHECK-NEXT: )
 (func $export (export "export")
  (call_indirect $table (type $A)
   (i32.const 0)
  )
  ;; No table.init, so that elem is never written. We do use it so it doesn't
  ;; vanish entirely.
  (elem.drop $later)
 )

 ;; CHECK:      (func $A (type $A)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 42)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $A (type $A)
  ;; TODO: optimize this
  (drop (i32.const 42))
 )
)

;; Test that table.get ensures that elements are kept around, so that their
;; data can be read.
(module
 ;; CHECK:      (type $0 (func (result i32)))

 ;; CHECK:      (table $t 354 354 i31ref)
 (table $t 354 354 i31ref)

 ;; CHECK:      (elem $e (table $t) (i32.const 0) i31ref (item (ref.i31
 ;; CHECK-NEXT:  (i32.const 0)
 ;; CHECK-NEXT: )))
 (elem $e (table $t) (i32.const 0) i31ref (item (ref.i31
  (i32.const 0)
 )))

 ;; CHECK:      (export "export" (func $export))

 ;; CHECK:      (func $export (type $0) (result i32)
 ;; CHECK-NEXT:  (i31.get_u
 ;; CHECK-NEXT:   (table.get $t
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $export (export "export") (result i32)
  (i31.get_u
   (table.get $t
    (i32.const 0)
   )
  )
 )
)
