;; NOTE: Assertions have been generated by update_lit_checks.py --output=fuzz-exec and should not be edited.

;; RUN: wasm-opt %s -all --fuzz-exec -q -o /dev/null 2>&1 | filecheck %s

;; Regression test for a bug where the vector operand to SIMDLoadStoreLane was
;; not evaluated if the preceding ptr operand was OOB.

(module
  (memory $mem 1 1)
  (global $g (mut i32) (i32.const 0))

  ;; CHECK:      [fuzz-exec] calling oob
  ;; CHECK-NEXT: [trap final > memory: 18446744073709551615 > 65536]
  (func $oob (export "oob")
    (drop
      ;; This should trap, but not until after setting the global.
      (v128.load64_lane 0
        (i32.const -1)
        (block (result v128)
          (global.set $g
            (i32.const 1)
          )
          (v128.const i32x4 0 0 0 0)
        )
      )
    )
  )

  ;; CHECK:      [fuzz-exec] calling get
  ;; CHECK-NEXT: [fuzz-exec] note result: get => 1
  (func $get (export "get") (result i32)
    ;; This should be 1
    (global.get $g)
  )
)
;; CHECK:      [fuzz-exec] calling oob
;; CHECK-NEXT: [trap final > memory: 18446744073709551615 > 65536]

;; CHECK:      [fuzz-exec] calling get
;; CHECK-NEXT: [fuzz-exec] note result: get => 1
;; CHECK-NEXT: [fuzz-exec] comparing get
;; CHECK-NEXT: [fuzz-exec] comparing oob
