# Copyright 2018 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: tensorflow_serving/apis/model_service.proto
# To regenerate run
# python -m grpc.tools.protoc --python_out=. --grpc_python_out=. -I. tensorflow_serving/apis/model_service.proto

import grpc

from tensorflow_serving.apis import get_model_status_pb2 as tensorflow__serving_dot_apis_dot_get__model__status__pb2
from tensorflow_serving.apis import model_management_pb2 as tensorflow__serving_dot_apis_dot_model__management__pb2


class ModelServiceStub(object):
  """ModelService provides methods to query and update the state of the server,
  e.g. which models/versions are being served.
  """

  def __init__(self, channel):
    """Constructor.

    Args:
      channel: A grpc.Channel.
    """
    self.GetModelStatus = channel.unary_unary(
        '/tensorflow.serving.ModelService/GetModelStatus',
        request_serializer=tensorflow__serving_dot_apis_dot_get__model__status__pb2.GetModelStatusRequest.SerializeToString,
        response_deserializer=tensorflow__serving_dot_apis_dot_get__model__status__pb2.GetModelStatusResponse.FromString,
        )
    self.HandleReloadConfigRequest = channel.unary_unary(
        '/tensorflow.serving.ModelService/HandleReloadConfigRequest',
        request_serializer=
        tensorflow__serving_dot_apis_dot_model__management__pb2.
        ReloadConfigRequest.SerializeToString,
        response_deserializer=
        tensorflow__serving_dot_apis_dot_model__management__pb2.
        ReloadConfigResponse.FromString,
    )


class ModelServiceServicer(object):
  """ModelService provides methods to query and update the state of the server,
  e.g. which models/versions are being served.
  """

  def GetModelStatus(self, request, context):
    """Gets status of model. If the ModelSpec in the request does not specify
    version, information about all versions of the model will be returned. If
    the ModelSpec in the request does specify a version, the status of only
    that version will be returned.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def HandleReloadConfigRequest(self, request, context):
    """Reloads the set of served models. The new config supersedes the old one,
    so if a model is omitted from the new config it will be unloaded and no
    longer served.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')


def add_ModelServiceServicer_to_server(servicer, server):
  rpc_method_handlers = {
      'GetModelStatus':
          grpc.unary_unary_rpc_method_handler(
              servicer.GetModelStatus,
              request_deserializer=
              tensorflow__serving_dot_apis_dot_get__model__status__pb2.
              GetModelStatusRequest.FromString,
              response_serializer=
              tensorflow__serving_dot_apis_dot_get__model__status__pb2.
              GetModelStatusResponse.SerializeToString,
          ),
      'HandleReloadConfigRequest':
          grpc.unary_unary_rpc_method_handler(
              servicer.HandleReloadConfigRequest,
              request_deserializer=
              tensorflow__serving_dot_apis_dot_model__management__pb2.
              ReloadConfigRequest.FromString,
              response_serializer=
              tensorflow__serving_dot_apis_dot_model__management__pb2.
              ReloadConfigResponse.SerializeToString,
          ),
  }
  generic_handler = grpc.method_handlers_generic_handler(
      'tensorflow.serving.ModelService', rpc_method_handlers)
  server.add_generic_rpc_handlers((generic_handler,))
