/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.tools.Hasher;

public final class SecurityUtils {
    protected static final Logger log = LogManager.getLogger(SecurityUtils.class);
    private static final String ENV_PATTERN_SUFFIX = "\\.([\\w=():\\-_]+?)(\\:\\-[\\w=():\\-_]*)?\\}";
    static final Pattern ENV_PATTERN = Pattern.compile("\\$\\{env\\.([\\w=():\\-_]+?)(\\:\\-[\\w=():\\-_]*)?\\}");
    static final Pattern ENVBC_PATTERN = Pattern.compile("\\$\\{envbc\\.([\\w=():\\-_]+?)(\\:\\-[\\w=():\\-_]*)?\\}");
    static final Pattern ENVBASE64_PATTERN = Pattern.compile("\\$\\{envbase64\\.([\\w=():\\-_]+?)(\\:\\-[\\w=():\\-_]*)?\\}");
    public static Locale EN_Locale = SecurityUtils.forEN();

    private SecurityUtils() {
    }

    private static Locale forEN() {
        if ("en".equalsIgnoreCase(Locale.getDefault().getLanguage())) {
            return Locale.getDefault();
        }
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i != locales.length; ++i) {
            if (!"en".equalsIgnoreCase(locales[i].getLanguage())) continue;
            return locales[i];
        }
        return Locale.getDefault();
    }

    public static String replaceEnvVars(String in, Settings settings) {
        if (in == null || in.isEmpty()) {
            return in;
        }
        if (settings == null || settings.getAsBoolean("plugins.security.disable_envvar_replacement", Boolean.valueOf(false)).booleanValue()) {
            return in;
        }
        return SecurityUtils.replaceEnvVarsBC(SecurityUtils.replaceEnvVarsNonBC(SecurityUtils.replaceEnvVarsBase64(in, settings), settings), settings);
    }

    private static String replaceEnvVarsNonBC(String in, Settings settings) {
        Matcher matcher = ENV_PATTERN.matcher(in);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = SecurityUtils.resolveEnvVar(matcher.group(1), matcher.group(2), false, settings);
            if (replacement == null) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String replaceEnvVarsBC(String in, Settings settings) {
        Matcher matcher = ENVBC_PATTERN.matcher(in);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = SecurityUtils.resolveEnvVar(matcher.group(1), matcher.group(2), true, settings);
            if (replacement == null) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String replaceEnvVarsBase64(String in, Settings settings) {
        Matcher matcher = ENVBASE64_PATTERN.matcher(in);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = SecurityUtils.resolveEnvVar(matcher.group(1), matcher.group(2), false, settings);
            if (replacement == null) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(new String(Base64.getDecoder().decode(replacement), StandardCharsets.UTF_8)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String resolveEnvVar(String envVarName, String mode, boolean bc, Settings settings) {
        String envVarValue = System.getenv(envVarName);
        if (envVarValue == null || envVarValue.isEmpty()) {
            if (mode != null && mode.startsWith(":-") && mode.length() > 2) {
                return bc ? Hasher.hash(mode.substring(2).toCharArray(), settings) : mode.substring(2);
            }
            return null;
        }
        return bc ? Hasher.hash(envVarValue.toCharArray(), settings) : envVarValue;
    }

    public static String escapePipe(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("|", "\\|");
    }
}

