/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.osmand.data.Amenity;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.TransportStop;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.MapRenderingTypes;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.osm.edit.OsmTransportRoute;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;

public class EntityParser {
    public static void parseMapObject(MapObject mo, Entity e, Map<String, String> tags) {
        mo.setId(e.getId());
        if (mo instanceof Amenity) {
            mo.setId((e.getId() << 1) + (long)(Entity.EntityType.valueOf(e) == Entity.EntityType.NODE ? 0 : 1));
        }
        if (mo.getName().length() == 0) {
            mo.setName(tags.get(OSMSettings.OSMTagKey.NAME.getValue()));
        }
        if (mo.getEnName(false).length() == 0) {
            mo.setEnName(tags.get(OSMSettings.OSMTagKey.NAME_EN.getValue()));
        }
        for (String ts : tags.keySet()) {
            if (!ts.startsWith("name:") || ts.equals(OSMSettings.OSMTagKey.NAME_EN.getValue())) continue;
            mo.setName(ts.substring("name:".length()), tags.get(ts));
        }
        if (mo.getName().length() == 0) {
            mo.setName(mo.getEnName(false));
        }
        if (mo.getLocation() == null) {
            LatLon l = null;
            if (mo instanceof Building) {
                l = EntityParser.findOnlyOneEntrance(e);
            }
            if (l == null) {
                l = OsmMapUtils.getCenter(e);
            }
            if (l != null) {
                mo.setLocation(l.getLatitude(), l.getLongitude());
            }
        }
        if (mo.getName().length() == 0) {
            EntityParser.setNameFromRef(mo, tags);
        }
    }

    private static LatLon findOnlyOneEntrance(Entity e) {
        if (e instanceof Node) {
            return e.getLatLon();
        }
        List<Node> nodes = null;
        if (e instanceof Way) {
            nodes = ((Way)e).getNodes();
        } else if (e instanceof Relation) {
            nodes = new ArrayList<Node>();
            for (Entity member : ((Relation)e).getMembers(null)) {
                if (!(member instanceof Way)) continue;
                nodes.addAll(((Way)member).getNodes());
            }
        }
        if (nodes != null) {
            int entrancesCount = 0;
            Node mainEntrance = null;
            Node lastEntrance = null;
            for (Node node : nodes) {
                String entrance = node.getTag(OSMSettings.OSMTagKey.ENTRANCE.getValue());
                if (entrance == null || "no".equals(entrance)) continue;
                if ("main".equals(entrance)) {
                    if (mainEntrance != null) {
                        return null;
                    }
                    mainEntrance = node;
                }
                ++entrancesCount;
                lastEntrance = node;
            }
            if (mainEntrance != null) {
                return mainEntrance.getLatLon();
            }
            if (entrancesCount == 1) {
                return lastEntrance.getLatLon();
            }
        }
        return null;
    }

    private static void setNameFromRef(MapObject mo, Map<String, String> tags) {
        String ref = tags.get(OSMSettings.OSMTagKey.REF.getValue());
        if (ref != null) {
            mo.setName(ref);
        }
    }

    private static void setNameFromOperator(MapObject mo, Map<String, String> tags) {
        String op = tags.get(OSMSettings.OSMTagKey.OPERATOR.getValue());
        if (op == null) {
            return;
        }
        String ref = tags.get(OSMSettings.OSMTagKey.REF.getValue());
        if (ref != null) {
            op = op + " [" + ref + "]";
        }
        mo.setName(op);
    }

    private static String getWebSiteURL(Map<String, String> tagValues) {
        String siteUrl = tagValues.get(OSMSettings.OSMTagKey.WIKIPEDIA.getValue());
        if (siteUrl != null) {
            if (!siteUrl.startsWith("http://")) {
                int i = siteUrl.indexOf(58);
                siteUrl = i == -1 ? "http://en.wikipedia.org/wiki/" + siteUrl : "http://" + siteUrl.substring(0, i) + ".wikipedia.org/wiki/" + siteUrl.substring(i + 1);
            }
        } else {
            siteUrl = tagValues.get(OSMSettings.OSMTagKey.WEBSITE.getValue());
            if (siteUrl == null && (siteUrl = tagValues.get(OSMSettings.OSMTagKey.URL.getValue())) == null) {
                siteUrl = tagValues.get(OSMSettings.OSMTagKey.CONTACT_WEBSITE.getValue());
            }
            if (siteUrl != null && !siteUrl.startsWith("http://") && !siteUrl.startsWith("https://")) {
                siteUrl = "http://" + siteUrl;
            }
        }
        return siteUrl;
    }

    public static List<Amenity> parseAmenities(MapPoiTypes poiTypes, Entity entity, Map<String, String> tags, List<Amenity> amenitiesList) {
        amenitiesList.clear();
        boolean relation = entity instanceof Relation;
        boolean purerelation = relation && !"multipolygon".equals(tags.get("type"));
        Collection<Map<String, String>> it = MapRenderingTypes.splitTagsIntoDifferentObjects(tags);
        for (Map<String, String> ts : it) {
            for (Map.Entry<String, String> e : ts.entrySet()) {
                Amenity am = poiTypes.parseAmenity(e.getKey(), e.getValue(), purerelation, ts);
                if (am == null) continue;
                EntityParser.parseMapObject(am, entity, ts);
                String wbs = EntityParser.getWebSiteURL(ts);
                if (wbs != null) {
                    am.setAdditionalInfo("website", wbs);
                }
                if (!EntityParser.checkAmenitiesToAdd(am, amenitiesList) || "no".equals(am.getSubType())) continue;
                amenitiesList.add(am);
            }
        }
        return amenitiesList;
    }

    private static boolean checkAmenitiesToAdd(Amenity a, List<Amenity> amenitiesList) {
        for (Amenity b : amenitiesList) {
            if (b.getType() != a.getType() || !Algorithms.objectEquals(a.getSubType(), b.getSubType())) continue;
            return false;
        }
        return true;
    }

    public static Building parseBuilding(Entity e) {
        Building b = new Building();
        EntityParser.parseMapObject(b, e, e.getTags());
        String p = e.getTag(OSMSettings.OSMTagKey.ADDR_POSTCODE.getValue());
        if (p == null) {
            p = e.getTag(OSMSettings.OSMTagKey.POSTAL_CODE.getValue());
        }
        b.setPostcode(p);
        return b;
    }

    public static City parseCity(Node el) {
        return EntityParser.parseCity(el, City.CityType.valueFromString(el.getTag(OSMSettings.OSMTagKey.PLACE.getValue())));
    }

    public static City parseCity(Entity el, City.CityType t) {
        if (t == null) {
            return null;
        }
        City c = new City(t);
        EntityParser.parseMapObject(c, el, el.getTags());
        String isin = el.getTag(OSMSettings.OSMTagKey.IS_IN.getValue());
        isin = isin != null ? isin.toLowerCase() : null;
        c.setIsin(isin);
        return c;
    }

    public static OsmTransportRoute parserRoute(Relation r, String ref) {
        OsmTransportRoute rt = new OsmTransportRoute();
        EntityParser.parseMapObject(rt, r, r.getTags());
        rt.setRef(ref);
        return rt;
    }

    public static TransportStop parseTransportStop(Entity e) {
        TransportStop st = new TransportStop();
        EntityParser.parseMapObject(st, e, e.getTags());
        return st;
    }
}

