/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;

public class SwingLazyValue
implements UIDefaults.LazyValue {
    private String className;
    private String methodName;
    private Object[] args;

    public SwingLazyValue(String c) {
        this(c, (String)null);
    }

    public SwingLazyValue(String c, String m) {
        this(c, m, null);
    }

    public SwingLazyValue(String c, Object[] o) {
        this(c, null, o);
    }

    public SwingLazyValue(String c, String m, Object[] o) {
        this.className = c;
        this.methodName = m;
        if (o != null) {
            this.args = (Object[])o.clone();
        }
    }

    @Override
    public Object createValue(UIDefaults table) {
        try {
            Class<?> c = Class.forName(this.className, true, null);
            if (this.methodName != null) {
                Class[] types = this.getClassArray(this.args);
                Method m = c.getMethod(this.methodName, types);
                return m.invoke(c, this.args);
            }
            Class[] types = this.getClassArray(this.args);
            Constructor<?> constructor = c.getConstructor(types);
            return constructor.newInstance(this.args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Class[] getClassArray(Object[] args) {
        Class[] types = null;
        if (args != null) {
            types = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                types[i] = args[i] instanceof Integer ? Integer.TYPE : (args[i] instanceof Boolean ? Boolean.TYPE : (args[i] instanceof ColorUIResource ? Color.class : args[i].getClass()));
            }
        }
        return types;
    }
}

