/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.juife.wizard.WizardPage;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.view.std.NewMidiInstrumentWizardModel;
import org.jsampler.view.std.StdI18n;
import org.jsampler.view.std.StdUtils;
import org.linuxsampler.lscp.MidiInstrumentEntry;

class InstrumentMappingWizardPage
extends WizardPage {
    private final JLabel lName = new JLabel(StdI18n.i18n.getLabel("InstrumentMappingWizardPage.lName"));
    private final JLabel lMap = new JLabel(StdI18n.i18n.getLabel("InstrumentMappingWizardPage.lMap"));
    private final JLabel lBank = new JLabel(StdI18n.i18n.getLabel("InstrumentMappingWizardPage.lBank"));
    private final JLabel lProgram = new JLabel(StdI18n.i18n.getLabel("InstrumentMappingWizardPage.lProgram"));
    private final JLabel lVolume = new JLabel(StdI18n.i18n.getLabel("InstrumentMappingWizardPage.lVolume"));
    private final JTextField tfName = new JTextField();
    private final JComboBox cbMap = new JComboBox();
    private final JSpinner spinnerBank;
    private final JComboBox cbProgram = new JComboBox();
    private final JSlider slVolume = StdUtils.createVolumeSlider();
    private final NewMidiInstrumentWizardModel wizardModel;
    private int mbBase;
    private int mpBase;
    private final Handler eventHandler = new Handler();

    InstrumentMappingWizardPage(NewMidiInstrumentWizardModel newMidiInstrumentWizardModel) {
        super(StdI18n.i18n.getLabel("InstrumentMappingWizardPage.subtitle"));
        this.wizardModel = newMidiInstrumentWizardModel;
        this.setPageType(WizardPage.Type.CONFIRMATION_PAGE);
        this.mbBase = CC.getViewConfig().getFirstMidiBankNumber();
        this.mpBase = CC.getViewConfig().getFirstMidiProgramNumber();
        this.spinnerBank = new JSpinner(new SpinnerNumberModel(this.mbBase, this.mbBase, 16383 + this.mbBase, 1));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(24, 3, 3, 0);
        gridBagLayout.setConstraints(this.lName, gridBagConstraints);
        this.add(this.lName);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        gridBagLayout.setConstraints(this.lMap, gridBagConstraints);
        this.add(this.lMap);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.lBank, gridBagConstraints);
        this.add(this.lBank);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.lProgram, gridBagConstraints);
        this.add(this.lProgram);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 24, 0);
        gridBagLayout.setConstraints(this.lVolume, gridBagConstraints);
        this.add(this.lVolume);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 12, 3, 36);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.tfName, gridBagConstraints);
        this.add(this.tfName);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 12, 3, 36);
        gridBagLayout.setConstraints(this.cbMap, gridBagConstraints);
        this.add(this.cbMap);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.spinnerBank, gridBagConstraints);
        this.add(this.spinnerBank);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.cbProgram, gridBagConstraints);
        this.add(this.cbProgram);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 12, 24, 36);
        gridBagLayout.setConstraints(this.slVolume, gridBagConstraints);
        this.add(this.slVolume);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        this.cbMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InstrumentMappingWizardPage.this.updateState();
            }
        });
        for (MidiInstrumentMap midiInstrumentMap : CC.getSamplerModel().getMidiInstrumentMaps()) {
            this.cbMap.addItem(midiInstrumentMap);
        }
        this.tfName.getDocument().addDocumentListener(this.getHandler());
        this.cbMap.setEnabled(this.cbMap.getItemCount() > 0);
        for (int i = 0; i < 128; ++i) {
            this.cbProgram.addItem(new Integer(i) + this.mpBase);
        }
        this.cbMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InstrumentMappingWizardPage.this.updateMapping();
            }
        });
        this.updateMapping();
    }

    protected JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    private void updateState() {
        this.cbMap.setEnabled(this.cbMap.getItemCount() > 0);
        boolean bl = this.cbMap.getSelectedItem() != null;
        this.spinnerBank.setEnabled(bl);
        this.cbProgram.setEnabled(bl);
        bl = this.tfName.getText().length() > 0 && this.cbMap.getSelectedItem() != null;
        boolean bl2 = bl = bl && this.cbProgram.getSelectedItem() != null;
        if (this.getWizard() != null) {
            this.getWizard().enableFinishButton(bl);
        }
    }

    private void updateMapping() {
        if (this.cbMap.getSelectedItem() == null) {
            return;
        }
        MidiInstrumentMap midiInstrumentMap = (MidiInstrumentMap)this.cbMap.getSelectedItem();
        MidiInstrumentEntry midiInstrumentEntry = midiInstrumentMap.getAvailableEntry();
        if (midiInstrumentEntry == null) {
            return;
        }
        this.setMidiBank(midiInstrumentEntry.getMidiBank());
        this.cbProgram.setSelectedIndex(midiInstrumentEntry.getMidiProgram());
    }

    @Override
    public void postinitPage() {
        String string = this.wizardModel.getInstrumentName();
        if (string != null) {
            this.tfName.setText(string);
        } else {
            this.tfName.setText("");
        }
        if (this.wizardModel.getDefaultMap() != null) {
            this.cbMap.setSelectedItem(this.wizardModel.getDefaultMap());
        }
        this.updateState();
    }

    @Override
    public boolean mayFinish() {
        ((NewMidiInstrumentWizardModel)this.getWizardModel()).mapInstrument();
        this.preferences().setIntProperty("lastUsedMidiBank", this.getMidiBank());
        this.preferences().setIntProperty("lastUsedMidiProgram", this.getMidiProgram());
        return true;
    }

    public int getMapId() {
        return ((MidiInstrumentMap)this.cbMap.getSelectedItem()).getMapId();
    }

    public int getMidiBank() {
        return Integer.parseInt(this.spinnerBank.getValue().toString()) - this.mbBase;
    }

    public void setMidiBank(int n) {
        this.spinnerBank.setValue(this.mbBase + n);
    }

    public int getMidiProgram() {
        return this.cbProgram.getSelectedIndex();
    }

    public String getInstrumentName() {
        return this.tfName.getText();
    }

    public float getVolume() {
        float f = this.slVolume.getValue();
        return f /= 100.0f;
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements DocumentListener {
        private Handler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            InstrumentMappingWizardPage.this.updateState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            InstrumentMappingWizardPage.this.updateState();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            InstrumentMappingWizardPage.this.updateState();
        }
    }
}

