/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import net.sf.juife.Wizard;
import net.sf.juife.plaf.WizardUI;
import net.sf.juife.plaf.basic.BasicWizardBottomPane;
import net.sf.juife.plaf.basic.BasicWizardLeftPane;
import net.sf.juife.plaf.basic.BasicWizardRightPane;
import net.sf.juife.wizard.WizardModel;
import net.sf.juife.wizard.WizardPage;

public class BasicWizardUI
extends WizardUI {
    private static final String propertyPrefix = "Wizard.";
    private Wizard wizard;
    private LayoutManager oldLayoutManager;
    private BasicWizardLeftPane leftPane;
    private BasicWizardRightPane rightPane;
    private JSeparator separator;
    private BasicWizardBottomPane bottomPane;
    private final Handler handler = new Handler();

    private BasicWizardUI() {
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicWizardUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.wizard = (Wizard)c;
        this.installDefaults();
        this.installListeners();
    }

    protected void installDefaults() {
        this.leftPane = new BasicWizardLeftPane();
        this.rightPane = new BasicWizardRightPane();
        this.bottomPane = new BasicWizardBottomPane();
        this.displayLastButton(false);
        this.displayHelpButton(false);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.oldLayoutManager = this.wizard.getLayout();
        this.wizard.setLayout(gridbag);
        this.leftPane.setPreferredSize(new Dimension(190, 300));
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag.setConstraints(this.leftPane, c);
        this.wizard.add(this.leftPane);
        this.rightPane.setPreferredSize(new Dimension(400, 300));
        c.gridx = 1;
        c.gridy = 0;
        gridbag.setConstraints(this.rightPane, c);
        this.wizard.add(this.rightPane);
        this.separator = new JSeparator();
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.fill = 2;
        gridbag.setConstraints(this.separator, c);
        this.wizard.add(this.separator);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 1;
        gridbag.setConstraints(this.bottomPane, c);
        this.wizard.add(this.bottomPane);
    }

    protected void installListeners() {
        this.wizard.addPropertyChangeListener(this.getHandler());
        this.bottomPane.nextButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardModel model = BasicWizardUI.this.wizard.getModel();
                if (!model.getCurrentPage().mayGoToNext()) {
                    return;
                }
                model.next();
            }
        });
        this.bottomPane.backButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardModel model = BasicWizardUI.this.wizard.getModel();
                if (!model.getCurrentPage().mayGoToPrevious()) {
                    return;
                }
                model.previous();
            }
        });
        this.bottomPane.lastButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardModel model = BasicWizardUI.this.wizard.getModel();
                if (!model.getCurrentPage().mayGoToLast()) {
                    return;
                }
                model.last();
            }
        });
        this.bottomPane.finishButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicWizardUI.this.wizard.finishWizard();
            }
        });
        this.bottomPane.cancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicWizardUI.this.wizard.cancelWizard();
            }
        });
        this.bottomPane.closeButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicWizardUI.this.wizard.closeWizard();
            }
        });
        this.bottomPane.helpButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicWizardUI.this.wizard.getModel().getCurrentPage().showHelp();
            }
        });
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
    }

    protected void uninstallDefaults() {
        this.wizard.remove(this.leftPane);
        this.wizard.remove(this.rightPane);
        this.wizard.remove(this.separator);
        this.wizard.remove(this.bottomPane);
        this.wizard.setLayout(this.oldLayoutManager);
        this.oldLayoutManager = null;
        this.leftPane = null;
        this.rightPane = null;
        this.separator = null;
        this.bottomPane = null;
    }

    protected void uninstallListeners() {
        this.wizard.removePropertyChangeListener(this.getHandler());
    }

    private Handler getHandler() {
        return this.handler;
    }

    public void setCurrentPage(WizardPage page) {
        WizardModel model = this.wizard.getModel();
        if (model.getSteps() != null) {
            this.leftPane.setSteps(model.getSteps(), model.getCurrentStep());
        }
        this.rightPane.setWizardPage(page);
        switch (page.getOptionalButtons()) {
            case NONE: {
                this.displayLastButton(false);
                this.displayHelpButton(false);
                break;
            }
            case HELP: {
                this.displayLastButton(false);
                this.enableHelpButton(true);
                this.displayHelpButton(true);
                break;
            }
            case LAST: {
                this.enableLastButton(true);
                this.displayLastButton(true);
                this.displayHelpButton(false);
                break;
            }
            case HELP_AND_LAST: {
                this.enableLastButton(true);
                this.displayLastButton(true);
                this.enableHelpButton(true);
                this.displayHelpButton(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown OptionalButtons value");
            }
        }
        switch (page.getPageType()) {
            case OVERVIEW_PAGE: {
                this.enableBackButton(false);
                this.displayBackButton(true);
                this.enableNextButton(true);
                this.displayNextButton(true);
                this.bottomPane.nextButton().requestFocus();
                this.displayFinishButton(false);
                this.displayCancelButton(true);
                this.enableCancelButton(true);
                this.displayCloseButton(false);
                break;
            }
            case REQUIREMENTS_PAGE: 
            case USER_INPUT_PAGE: {
                this.enableBackButton(true);
                this.displayBackButton(true);
                this.enableNextButton(true);
                this.displayNextButton(true);
                this.bottomPane.nextButton().requestFocus();
                this.displayFinishButton(false);
                this.displayCancelButton(true);
                this.enableCancelButton(true);
                this.displayCloseButton(false);
                break;
            }
            case CONFIRMATION_PAGE: {
                this.enableBackButton(true);
                this.displayBackButton(true);
                this.enableNextButton(false);
                this.displayNextButton(false);
                this.displayFinishButton(true);
                this.bottomPane.finishButton().requestFocus();
                this.displayCancelButton(true);
                this.enableCancelButton(true);
                this.displayCloseButton(false);
                break;
            }
            case CONFIRMATION_PAGE_EX: {
                this.enableBackButton(true);
                this.displayBackButton(true);
                this.enableNextButton(false);
                this.displayNextButton(true);
                this.displayFinishButton(true);
                this.bottomPane.finishButton().requestFocus();
                this.displayCancelButton(true);
                this.enableCancelButton(true);
                this.displayCloseButton(false);
                break;
            }
            case PROGRESS_PAGE: {
                this.enableBackButton(false);
                this.displayBackButton(true);
                this.enableNextButton(false);
                this.displayNextButton(true);
                this.displayFinishButton(false);
                this.displayCancelButton(true);
                this.enableCancelButton(false);
                this.displayCloseButton(false);
                break;
            }
            case SUMMARY_PAGE: {
                this.displayBackButton(false);
                this.displayNextButton(false);
                this.displayFinishButton(false);
                this.displayCancelButton(false);
                this.displayCloseButton(true);
                this.bottomPane.closeButton().requestFocus();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown wizard page type");
            }
        }
        this.enableBackButton(model.hasPrevious());
        this.enableNextButton(model.hasNext());
        this.enableLastButton(model.hasLast());
    }

    @Override
    public void displayBackButton(boolean b) {
        this.bottomPane.backButton().setVisible(b);
    }

    @Override
    public void displayNextButton(boolean b) {
        this.bottomPane.nextButton().setVisible(b);
    }

    @Override
    public void displayLastButton(boolean b) {
        this.bottomPane.lastButton().setVisible(b);
    }

    @Override
    public void displayFinishButton(boolean b) {
        this.bottomPane.finishButton().setVisible(b);
    }

    @Override
    public void displayCancelButton(boolean b) {
        this.bottomPane.cancelButton().setVisible(b);
    }

    @Override
    public void displayHelpButton(boolean b) {
        this.bottomPane.helpButton().setVisible(b);
    }

    @Override
    public void displayCloseButton(boolean b) {
        this.bottomPane.closeButton().setVisible(b);
    }

    @Override
    public void enableBackButton(boolean enabled) {
        this.bottomPane.backButton().setEnabled(enabled);
    }

    @Override
    public void enableNextButton(boolean enabled) {
        this.bottomPane.nextButton().setEnabled(enabled);
    }

    @Override
    public void enableLastButton(boolean enabled) {
        this.bottomPane.lastButton().setEnabled(enabled);
    }

    @Override
    public void enableFinishButton(boolean enabled) {
        this.bottomPane.finishButton().setEnabled(enabled);
    }

    @Override
    public void enableCancelButton(boolean enabled) {
        this.bottomPane.cancelButton().setEnabled(enabled);
    }

    @Override
    public void enableHelpButton(boolean enabled) {
        this.bottomPane.helpButton().setEnabled(enabled);
    }

    @Override
    public boolean mayCancelWizard() {
        return this.bottomPane.cancelButton().isVisible() && this.bottomPane.cancelButton().isEnabled();
    }

    private class Handler
    implements ActionListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicWizardUI.this.setCurrentPage(BasicWizardUI.this.wizard.getModel().getCurrentPage());
            BasicWizardUI.this.wizard.getCurrentPage().postinitPage();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (e.getPropertyName() == "model") {
                WizardModel old1 = (WizardModel)e.getOldValue();
                WizardModel new1 = (WizardModel)e.getNewValue();
                if (old1 != null) {
                    old1.removeActionListener(BasicWizardUI.this.getHandler());
                }
                if (new1 != null) {
                    new1.addActionListener(BasicWizardUI.this.getHandler());
                }
            } else if (e.getPropertyName() == "Wizard.backButtonIcon") {
                BasicWizardUI.this.bottomPane.backButton().setIcon((ImageIcon)e.getNewValue());
            } else if (e.getPropertyName() == "Wizard.nextButtonIcon") {
                BasicWizardUI.this.bottomPane.nextButton().setIcon((ImageIcon)e.getNewValue());
            } else if (e.getPropertyName() == "Wizard.leftPaneBackgroundColor") {
                BasicWizardUI.this.leftPane.setBackground((Color)e.getNewValue());
            } else if (e.getPropertyName() == "Wizard.leftPaneForegroundColor") {
                BasicWizardUI.this.leftPane.setForegroundColor((Color)e.getNewValue());
            }
        }
    }
}

