﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/devicefarm/DeviceFarm_EXPORTS.h>
#include <aws/devicefarm/model/DevicePoolType.h>
#include <aws/devicefarm/model/Rule.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DeviceFarm {
namespace Model {

/**
 * <p>Represents a collection of device types.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DevicePool">AWS
 * API Reference</a></p>
 */
class DevicePool {
 public:
  AWS_DEVICEFARM_API DevicePool() = default;
  AWS_DEVICEFARM_API DevicePool(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEVICEFARM_API DevicePool& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DEVICEFARM_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The device pool's ARN.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  DevicePool& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The device pool's name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  DevicePool& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The device pool's description.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  DevicePool& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The device pool's type.</p> <p>Allowed values include:</p> <ul> <li>
   * <p>CURATED: A device pool that is created and managed by AWS Device Farm.</p>
   * </li> <li> <p>PRIVATE: A device pool that is created and managed by the device
   * pool developer.</p> </li> </ul>
   */
  inline DevicePoolType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(DevicePoolType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline DevicePool& WithType(DevicePoolType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Information about the device pool's rules.</p>
   */
  inline const Aws::Vector<Rule>& GetRules() const { return m_rules; }
  inline bool RulesHasBeenSet() const { return m_rulesHasBeenSet; }
  template <typename RulesT = Aws::Vector<Rule>>
  void SetRules(RulesT&& value) {
    m_rulesHasBeenSet = true;
    m_rules = std::forward<RulesT>(value);
  }
  template <typename RulesT = Aws::Vector<Rule>>
  DevicePool& WithRules(RulesT&& value) {
    SetRules(std::forward<RulesT>(value));
    return *this;
  }
  template <typename RulesT = Rule>
  DevicePool& AddRules(RulesT&& value) {
    m_rulesHasBeenSet = true;
    m_rules.emplace_back(std::forward<RulesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of devices that Device Farm can add to your device pool. Device
   * Farm adds devices that are available and meet the criteria that you assign for
   * the <code>rules</code> parameter. Depending on how many devices meet these
   * constraints, your device pool might contain fewer devices than the value for
   * this parameter.</p> <p>By specifying the maximum number of devices, you can
   * control the costs that you incur by running tests.</p>
   */
  inline int GetMaxDevices() const { return m_maxDevices; }
  inline bool MaxDevicesHasBeenSet() const { return m_maxDevicesHasBeenSet; }
  inline void SetMaxDevices(int value) {
    m_maxDevicesHasBeenSet = true;
    m_maxDevices = value;
  }
  inline DevicePool& WithMaxDevices(int value) {
    SetMaxDevices(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::String m_name;

  Aws::String m_description;

  DevicePoolType m_type{DevicePoolType::NOT_SET};

  Aws::Vector<Rule> m_rules;

  int m_maxDevices{0};
  bool m_arnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_typeHasBeenSet = false;
  bool m_rulesHasBeenSet = false;
  bool m_maxDevicesHasBeenSet = false;
};

}  // namespace Model
}  // namespace DeviceFarm
}  // namespace Aws
