﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/securityhub/model/Ipv6CidrBlockAssociation.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p>Contains information about a subnet in Amazon EC2.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsEc2SubnetDetails">AWS
 * API Reference</a></p>
 */
class AwsEc2SubnetDetails {
 public:
  AWS_SECURITYHUB_API AwsEc2SubnetDetails() = default;
  AWS_SECURITYHUB_API AwsEc2SubnetDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API AwsEc2SubnetDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Whether to assign an IPV6 address to a network interface that is created in
   * this subnet.</p>
   */
  inline bool GetAssignIpv6AddressOnCreation() const { return m_assignIpv6AddressOnCreation; }
  inline bool AssignIpv6AddressOnCreationHasBeenSet() const { return m_assignIpv6AddressOnCreationHasBeenSet; }
  inline void SetAssignIpv6AddressOnCreation(bool value) {
    m_assignIpv6AddressOnCreationHasBeenSet = true;
    m_assignIpv6AddressOnCreation = value;
  }
  inline AwsEc2SubnetDetails& WithAssignIpv6AddressOnCreation(bool value) {
    SetAssignIpv6AddressOnCreation(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Availability Zone for the subnet.</p>
   */
  inline const Aws::String& GetAvailabilityZone() const { return m_availabilityZone; }
  inline bool AvailabilityZoneHasBeenSet() const { return m_availabilityZoneHasBeenSet; }
  template <typename AvailabilityZoneT = Aws::String>
  void SetAvailabilityZone(AvailabilityZoneT&& value) {
    m_availabilityZoneHasBeenSet = true;
    m_availabilityZone = std::forward<AvailabilityZoneT>(value);
  }
  template <typename AvailabilityZoneT = Aws::String>
  AwsEc2SubnetDetails& WithAvailabilityZone(AvailabilityZoneT&& value) {
    SetAvailabilityZone(std::forward<AvailabilityZoneT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the Availability Zone for the subnet.</p>
   */
  inline const Aws::String& GetAvailabilityZoneId() const { return m_availabilityZoneId; }
  inline bool AvailabilityZoneIdHasBeenSet() const { return m_availabilityZoneIdHasBeenSet; }
  template <typename AvailabilityZoneIdT = Aws::String>
  void SetAvailabilityZoneId(AvailabilityZoneIdT&& value) {
    m_availabilityZoneIdHasBeenSet = true;
    m_availabilityZoneId = std::forward<AvailabilityZoneIdT>(value);
  }
  template <typename AvailabilityZoneIdT = Aws::String>
  AwsEc2SubnetDetails& WithAvailabilityZoneId(AvailabilityZoneIdT&& value) {
    SetAvailabilityZoneId(std::forward<AvailabilityZoneIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of available IPV4 addresses in the subnet. Does not include
   * addresses for stopped instances.</p>
   */
  inline int GetAvailableIpAddressCount() const { return m_availableIpAddressCount; }
  inline bool AvailableIpAddressCountHasBeenSet() const { return m_availableIpAddressCountHasBeenSet; }
  inline void SetAvailableIpAddressCount(int value) {
    m_availableIpAddressCountHasBeenSet = true;
    m_availableIpAddressCount = value;
  }
  inline AwsEc2SubnetDetails& WithAvailableIpAddressCount(int value) {
    SetAvailableIpAddressCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The IPV4 CIDR block that is assigned to the subnet.</p>
   */
  inline const Aws::String& GetCidrBlock() const { return m_cidrBlock; }
  inline bool CidrBlockHasBeenSet() const { return m_cidrBlockHasBeenSet; }
  template <typename CidrBlockT = Aws::String>
  void SetCidrBlock(CidrBlockT&& value) {
    m_cidrBlockHasBeenSet = true;
    m_cidrBlock = std::forward<CidrBlockT>(value);
  }
  template <typename CidrBlockT = Aws::String>
  AwsEc2SubnetDetails& WithCidrBlock(CidrBlockT&& value) {
    SetCidrBlock(std::forward<CidrBlockT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether this subnet is the default subnet for the Availability Zone.</p>
   */
  inline bool GetDefaultForAz() const { return m_defaultForAz; }
  inline bool DefaultForAzHasBeenSet() const { return m_defaultForAzHasBeenSet; }
  inline void SetDefaultForAz(bool value) {
    m_defaultForAzHasBeenSet = true;
    m_defaultForAz = value;
  }
  inline AwsEc2SubnetDetails& WithDefaultForAz(bool value) {
    SetDefaultForAz(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Whether instances in this subnet receive a public IP address.</p>
   */
  inline bool GetMapPublicIpOnLaunch() const { return m_mapPublicIpOnLaunch; }
  inline bool MapPublicIpOnLaunchHasBeenSet() const { return m_mapPublicIpOnLaunchHasBeenSet; }
  inline void SetMapPublicIpOnLaunch(bool value) {
    m_mapPublicIpOnLaunchHasBeenSet = true;
    m_mapPublicIpOnLaunch = value;
  }
  inline AwsEc2SubnetDetails& WithMapPublicIpOnLaunch(bool value) {
    SetMapPublicIpOnLaunch(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the Amazon Web Services account that owns the subnet.</p>
   */
  inline const Aws::String& GetOwnerId() const { return m_ownerId; }
  inline bool OwnerIdHasBeenSet() const { return m_ownerIdHasBeenSet; }
  template <typename OwnerIdT = Aws::String>
  void SetOwnerId(OwnerIdT&& value) {
    m_ownerIdHasBeenSet = true;
    m_ownerId = std::forward<OwnerIdT>(value);
  }
  template <typename OwnerIdT = Aws::String>
  AwsEc2SubnetDetails& WithOwnerId(OwnerIdT&& value) {
    SetOwnerId(std::forward<OwnerIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current state of the subnet. Valid values are <code>available</code> or
   * <code>pending</code>.</p>
   */
  inline const Aws::String& GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  template <typename StateT = Aws::String>
  void SetState(StateT&& value) {
    m_stateHasBeenSet = true;
    m_state = std::forward<StateT>(value);
  }
  template <typename StateT = Aws::String>
  AwsEc2SubnetDetails& WithState(StateT&& value) {
    SetState(std::forward<StateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the subnet.</p>
   */
  inline const Aws::String& GetSubnetArn() const { return m_subnetArn; }
  inline bool SubnetArnHasBeenSet() const { return m_subnetArnHasBeenSet; }
  template <typename SubnetArnT = Aws::String>
  void SetSubnetArn(SubnetArnT&& value) {
    m_subnetArnHasBeenSet = true;
    m_subnetArn = std::forward<SubnetArnT>(value);
  }
  template <typename SubnetArnT = Aws::String>
  AwsEc2SubnetDetails& WithSubnetArn(SubnetArnT&& value) {
    SetSubnetArn(std::forward<SubnetArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the subnet.</p>
   */
  inline const Aws::String& GetSubnetId() const { return m_subnetId; }
  inline bool SubnetIdHasBeenSet() const { return m_subnetIdHasBeenSet; }
  template <typename SubnetIdT = Aws::String>
  void SetSubnetId(SubnetIdT&& value) {
    m_subnetIdHasBeenSet = true;
    m_subnetId = std::forward<SubnetIdT>(value);
  }
  template <typename SubnetIdT = Aws::String>
  AwsEc2SubnetDetails& WithSubnetId(SubnetIdT&& value) {
    SetSubnetId(std::forward<SubnetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the VPC that contains the subnet.</p>
   */
  inline const Aws::String& GetVpcId() const { return m_vpcId; }
  inline bool VpcIdHasBeenSet() const { return m_vpcIdHasBeenSet; }
  template <typename VpcIdT = Aws::String>
  void SetVpcId(VpcIdT&& value) {
    m_vpcIdHasBeenSet = true;
    m_vpcId = std::forward<VpcIdT>(value);
  }
  template <typename VpcIdT = Aws::String>
  AwsEc2SubnetDetails& WithVpcId(VpcIdT&& value) {
    SetVpcId(std::forward<VpcIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The IPV6 CIDR blocks that are associated with the subnet.</p>
   */
  inline const Aws::Vector<Ipv6CidrBlockAssociation>& GetIpv6CidrBlockAssociationSet() const { return m_ipv6CidrBlockAssociationSet; }
  inline bool Ipv6CidrBlockAssociationSetHasBeenSet() const { return m_ipv6CidrBlockAssociationSetHasBeenSet; }
  template <typename Ipv6CidrBlockAssociationSetT = Aws::Vector<Ipv6CidrBlockAssociation>>
  void SetIpv6CidrBlockAssociationSet(Ipv6CidrBlockAssociationSetT&& value) {
    m_ipv6CidrBlockAssociationSetHasBeenSet = true;
    m_ipv6CidrBlockAssociationSet = std::forward<Ipv6CidrBlockAssociationSetT>(value);
  }
  template <typename Ipv6CidrBlockAssociationSetT = Aws::Vector<Ipv6CidrBlockAssociation>>
  AwsEc2SubnetDetails& WithIpv6CidrBlockAssociationSet(Ipv6CidrBlockAssociationSetT&& value) {
    SetIpv6CidrBlockAssociationSet(std::forward<Ipv6CidrBlockAssociationSetT>(value));
    return *this;
  }
  template <typename Ipv6CidrBlockAssociationSetT = Ipv6CidrBlockAssociation>
  AwsEc2SubnetDetails& AddIpv6CidrBlockAssociationSet(Ipv6CidrBlockAssociationSetT&& value) {
    m_ipv6CidrBlockAssociationSetHasBeenSet = true;
    m_ipv6CidrBlockAssociationSet.emplace_back(std::forward<Ipv6CidrBlockAssociationSetT>(value));
    return *this;
  }
  ///@}
 private:
  bool m_assignIpv6AddressOnCreation{false};

  Aws::String m_availabilityZone;

  Aws::String m_availabilityZoneId;

  int m_availableIpAddressCount{0};

  Aws::String m_cidrBlock;

  bool m_defaultForAz{false};

  bool m_mapPublicIpOnLaunch{false};

  Aws::String m_ownerId;

  Aws::String m_state;

  Aws::String m_subnetArn;

  Aws::String m_subnetId;

  Aws::String m_vpcId;

  Aws::Vector<Ipv6CidrBlockAssociation> m_ipv6CidrBlockAssociationSet;
  bool m_assignIpv6AddressOnCreationHasBeenSet = false;
  bool m_availabilityZoneHasBeenSet = false;
  bool m_availabilityZoneIdHasBeenSet = false;
  bool m_availableIpAddressCountHasBeenSet = false;
  bool m_cidrBlockHasBeenSet = false;
  bool m_defaultForAzHasBeenSet = false;
  bool m_mapPublicIpOnLaunchHasBeenSet = false;
  bool m_ownerIdHasBeenSet = false;
  bool m_stateHasBeenSet = false;
  bool m_subnetArnHasBeenSet = false;
  bool m_subnetIdHasBeenSet = false;
  bool m_vpcIdHasBeenSet = false;
  bool m_ipv6CidrBlockAssociationSetHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
