/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.options;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import org.netbeans.core.output2.Controller;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColors;

public class OutputOptions {
    private static OutputOptions DEFAULT = null;
    private boolean initialized = false;
    private static final Logger LOG = Logger.getLogger(OutputOptions.class.getName());
    private static AtomicBoolean saveScheduled = new AtomicBoolean(false);
    private static final String PREFIX = "output.settings.";
    public static final String PROP_FONT = "font";
    private static final String PROP_FONT_FAMILY = "font.family";
    private static final String PROP_FONT_SIZE = "font.size";
    private static final String PROP_FONT_STYLE = "font.style";
    public static final String PROP_COLOR_STANDARD = "color.standard";
    public static final String PROP_COLOR_ERROR = "color.error";
    public static final String PROP_COLOR_INPUT = "color.input";
    public static final String PROP_COLOR_LINK = "color.link";
    public static final String PROP_COLOR_LINK_IMPORTANT = "color.link.important";
    public static final String PROP_COLOR_BACKGROUND = "color.backgorund";
    public static final String PROP_COLOR_WARNING = "color.warning";
    public static final String PROP_COLOR_FAILURE = "color.failure";
    public static final String PROP_COLOR_SUCCESS = "color.success";
    public static final String PROP_COLOR_DEBUG = "color.debug";
    public static final String PROP_STYLE_LINK = "style.link";
    public static final String PROP_FONT_SIZE_WRAP = "font.size.wrap";
    static final String PROP_INITIALIZED = "initialized";
    private static final int MIN_FONT_SIZE = 3;
    private static final int MAX_FONT_SIZE = 72;
    private static Font defaultFont = null;
    private Font font = null;
    private Font fontWrapped = null;
    private Color colorStandard;
    private Color colorError;
    private Color colorInput;
    private Color colorLink;
    private Color colorLinkImportant;
    private Color colorBackground;
    private Color colorWarning;
    private Color colorFailure;
    private Color colorSuccess;
    private Color colorDebug;
    private LinkStyle linkStyle = LinkStyle.UNDERLINE;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean defaultFontType = false;

    private OutputOptions(boolean bl) {
        this.resetToDefault();
        if (!bl) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                OutputOptions.this.loadFrom(NbPreferences.forModule(Controller.class));
            }
        });
    }

    final void resetToDefault() {
        this.setDefaultFont();
        this.setDefaultColors();
        this.setLinkStyle(LinkStyle.UNDERLINE);
    }

    boolean isChanged() {
        Preferences preferences = NbPreferences.forModule(Controller.class);
        if (!this.getFont().getFamily().equals(preferences.get("output.settings.font.family", OutputOptions.getDefaultFont().getFamily()))) {
            return true;
        }
        if (this.getFont().getSize() != preferences.getInt("output.settings.font.size", OutputOptions.getDefaultFont().getSize())) {
            return true;
        }
        if (this.getFont().getStyle() != preferences.getInt("output.settings.font.style", OutputOptions.getDefaultFont().getStyle())) {
            return true;
        }
        if (!this.getLinkStyle().name().equals(preferences.get("output.settings.style.link", "UNDERLINE"))) {
            return true;
        }
        if (this.getColorStandard().getRGB() != preferences.getInt("output.settings.color.standard", OutputOptions.getDefaultColorStandard().getRGB())) {
            return true;
        }
        if (this.getColorError().getRGB() != preferences.getInt("output.settings.color.error", OutputOptions.getDefaultColorError().getRGB())) {
            return true;
        }
        if (this.getColorInput().getRGB() != preferences.getInt("output.settings.color.input", OutputOptions.getDefaultColorInput().getRGB())) {
            return true;
        }
        if (this.getColorBackground().getRGB() != preferences.getInt("output.settings.color.backgorund", OutputOptions.getDefaultColorBackground().getRGB())) {
            return true;
        }
        if (this.getColorLink().getRGB() != preferences.getInt("output.settings.color.link", OutputOptions.getDefaultColorLink().getRGB())) {
            return true;
        }
        if (this.getColorLinkImportant().getRGB() != preferences.getInt("output.settings.color.link.important", OutputOptions.getDefaultColorLinkImportant().getRGB())) {
            return true;
        }
        if (this.getColorDebug().getRGB() != preferences.getInt("output.settings.color.debug", OutputOptions.getDefaultColorDebug().getRGB())) {
            return true;
        }
        if (this.getColorWarning().getRGB() != preferences.getInt("output.settings.color.warning", OutputOptions.getDefaultColorWarning().getRGB())) {
            return true;
        }
        if (this.getColorFailure().getRGB() != preferences.getInt("output.settings.color.failure", OutputOptions.getDefaultColorFailure().getRGB())) {
            return true;
        }
        return this.getColorSuccess().getRGB() != preferences.getInt("output.settings.color.success", OutputOptions.getDefaultColorSuccess().getRGB());
    }

    public void loadFrom(Preferences preferences) {
        assert (!EventQueue.isDispatchThread());
        final OutputOptions outputOptions = new OutputOptions(false);
        String string = preferences.get("output.settings.font.family", OutputOptions.getDefaultFont().getFamily());
        int n = preferences.getInt("output.settings.font.size", OutputOptions.getDefaultFont().getSize());
        int n2 = preferences.getInt("output.settings.font.style", OutputOptions.getDefaultFont().getStyle());
        outputOptions.setFont(new Font(string, n2, n));
        int n3 = preferences.getInt("output.settings.font.size.wrap", OutputOptions.getDefaultFont().getSize());
        outputOptions.setFontForWrappedMode(OutputOptions.getDefaultFont().deriveFont((float)n3));
        this.loadColors(preferences, outputOptions);
        String string2 = preferences.get("output.settings.style.link", "UNDERLINE");
        try {
            outputOptions.setLinkStyle(LinkStyle.valueOf(string2));
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, "Invalid link style {0}", string2);
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OutputOptions.this.assign(outputOptions);
                OutputOptions outputOptions2 = OutputOptions.this;
                synchronized (outputOptions2) {
                    OutputOptions.this.initialized = true;
                }
                OutputOptions.this.pcs.firePropertyChange(OutputOptions.PROP_INITIALIZED, false, true);
            }
        });
    }

    private void loadColors(Preferences preferences, OutputOptions outputOptions) {
        int n = preferences.getInt("output.settings.color.standard", OutputOptions.getDefaultColorStandard().getRGB());
        outputOptions.setColorStandard(new Color(n));
        int n2 = preferences.getInt("output.settings.color.error", OutputOptions.getDefaultColorError().getRGB());
        outputOptions.setColorError(new Color(n2));
        int n3 = preferences.getInt("output.settings.color.input", OutputOptions.getDefaultColorInput().getRGB());
        outputOptions.setColorInput(new Color(n3));
        int n4 = preferences.getInt("output.settings.color.backgorund", OutputOptions.getDefaultColorBackground().getRGB());
        outputOptions.setColorBackground(new Color(n4));
        int n5 = preferences.getInt("output.settings.color.link", OutputOptions.getDefaultColorLink().getRGB());
        outputOptions.setColorLink(new Color(n5));
        int n6 = preferences.getInt("output.settings.color.link.important", OutputOptions.getDefaultColorLinkImportant().getRGB());
        outputOptions.setColorLinkImportant(new Color(n6));
        int n7 = preferences.getInt("output.settings.color.debug", OutputOptions.getDefaultColorDebug().getRGB());
        outputOptions.setColorDebug(new Color(n7));
        int n8 = preferences.getInt("output.settings.color.warning", OutputOptions.getDefaultColorWarning().getRGB());
        outputOptions.setColorWarning(new Color(n8));
        int n9 = preferences.getInt("output.settings.color.failure", OutputOptions.getDefaultColorFailure().getRGB());
        outputOptions.setColorFailure(new Color(n9));
        int n10 = preferences.getInt("output.settings.color.success", OutputOptions.getDefaultColorSuccess().getRGB());
        outputOptions.setColorSuccess(new Color(n10));
    }

    public void saveTo(Preferences preferences) {
        assert (!EventQueue.isDispatchThread());
        this.saveColorsTo(preferences);
        this.saveFontsTo(preferences);
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            LOG.log(Level.INFO, null, backingStoreException);
        }
    }

    private void saveColorsTo(Preferences preferences) {
        this.saveIfNotDefault(preferences, PROP_COLOR_STANDARD, this.getColorStandard(), OutputOptions.getDefaultColorStandard());
        this.saveIfNotDefault(preferences, PROP_COLOR_ERROR, this.getColorError(), OutputOptions.getDefaultColorError());
        this.saveIfNotDefault(preferences, PROP_COLOR_INPUT, this.getColorInput(), OutputOptions.getDefaultColorInput());
        this.saveIfNotDefault(preferences, PROP_COLOR_BACKGROUND, this.getColorBackground(), OutputOptions.getDefaultColorBackground());
        this.saveIfNotDefault(preferences, PROP_COLOR_LINK, this.getColorLink(), OutputOptions.getDefaultColorLink());
        this.saveIfNotDefault(preferences, PROP_COLOR_WARNING, this.getColorWarning(), OutputOptions.getDefaultColorWarning());
        this.saveIfNotDefault(preferences, PROP_COLOR_FAILURE, this.getColorFailure(), OutputOptions.getDefaultColorFailure());
        this.saveIfNotDefault(preferences, PROP_COLOR_SUCCESS, this.getColorSuccess(), OutputOptions.getDefaultColorSuccess());
        this.saveIfNotDefault(preferences, PROP_COLOR_DEBUG, this.getColorDebug(), OutputOptions.getDefaultColorDebug());
        this.saveIfNotDefault(preferences, PROP_COLOR_LINK_IMPORTANT, this.getColorLinkImportant(), OutputOptions.getDefaultColorLinkImportant());
    }

    private void saveIfNotDefault(Preferences preferences, String string, Color color, Color color2) {
        if (color == null || color2.getRGB() == color.getRGB()) {
            preferences.remove(PREFIX + string);
        } else {
            preferences.putInt(PREFIX + string, color.getRGB());
        }
    }

    private void saveFontsTo(Preferences preferences) {
        preferences.putInt("output.settings.font.size", this.getFont().getSize());
        preferences.putInt("output.settings.font.style", this.getFont().getStyle());
        preferences.putInt("output.settings.font.size.wrap", this.getFontForWrappedMode().getSize());
        preferences.put("output.settings.font.family", this.getFont().getFamily());
        preferences.put("output.settings.style.link", this.getLinkStyle().name());
    }

    private void setDefaultColors() {
        this.setColorStandard(OutputOptions.getDefaultColorStandard());
        this.setColorError(OutputOptions.getDefaultColorError());
        this.setColorInput(OutputOptions.getDefaultColorInput());
        this.setColorLink(OutputOptions.getDefaultColorLink());
        this.setColorLinkImportant(OutputOptions.getDefaultColorLinkImportant());
        this.setColorBackground(OutputOptions.getDefaultColorBackground());
        this.setColorWarning(OutputOptions.getDefaultColorWarning());
        this.setColorFailure(OutputOptions.getDefaultColorFailure());
        this.setColorSuccess(OutputOptions.getDefaultColorSuccess());
        this.setColorDebug(OutputOptions.getDefaultColorDebug());
    }

    private void setDefaultFont() {
        this.setFont(OutputOptions.getDefaultFont());
        this.setFontForWrappedMode(OutputOptions.getDefaultFont());
    }

    public static Font getDefaultFont() {
        if (defaultFont == null) {
            Font font;
            int n = UIManager.getInt("uiFontSize");
            if (n < 3) {
                n = UIManager.getInt("customFontSize");
            }
            if (n < 3 && (font = (Font)UIManager.get("controlFont")) != null) {
                n = font.getSize();
            }
            if (n < 3) {
                n = 11;
            }
            defaultFont = new Font("Monospaced", 0, n);
        }
        return defaultFont;
    }

    public Font getFont() {
        return this.font;
    }

    public Font getFontForWrappedMode() {
        return this.fontWrapped;
    }

    public Font getFont(boolean bl) {
        return bl ? this.getFontForWrappedMode() : this.getFont();
    }

    public Color getColorStandard() {
        return this.colorStandard;
    }

    public Color getColorError() {
        return this.colorError;
    }

    public Color getColorInput() {
        return this.colorInput;
    }

    public Color getColorLink() {
        return this.colorLink;
    }

    public Color getColorLinkImportant() {
        return this.colorLinkImportant;
    }

    public Color getColorBackground() {
        return this.colorBackground;
    }

    public Color getColorWarning() {
        return this.colorWarning;
    }

    public Color getColorFailure() {
        return this.colorFailure;
    }

    public Color getColorSuccess() {
        return this.colorSuccess;
    }

    public Color getColorDebug() {
        return this.colorDebug;
    }

    public LinkStyle getLinkStyle() {
        return this.linkStyle;
    }

    public void setFont(Font font) {
        Font font2 = this.checkFontToSet(font);
        if (!font2.equals(this.font)) {
            Font font3 = this.font;
            this.font = font2;
            this.defaultFontType = this.checkDefaultFontType();
            this.pcs.firePropertyChange(PROP_FONT, font3, font2);
        }
    }

    private void setFontForWrappedMode(Font font) {
        Font font2 = this.checkFontToSet(font);
        if (!font2.equals(this.fontWrapped)) {
            int n = this.fontWrapped != null ? this.fontWrapped.getSize() : 0;
            this.fontWrapped = font2;
            this.pcs.firePropertyChange(PROP_FONT_SIZE_WRAP, n, font2.getSize());
        }
    }

    private Font checkFontToSet(Font font) {
        Font font2;
        Font font3 = font2 = font == null ? OutputOptions.getDefaultFont() : font;
        if (font2.getSize() < 3) {
            font2 = font2.deriveFont(3.0f);
        } else if (font2.getSize() > 72) {
            font2 = font2.deriveFont(72.0f);
        }
        return font2;
    }

    public void setFontSize(boolean bl, int n) {
        if (this.getFont() != null && (!bl || this.isDefaultFontType()) && n != this.getFont().getSize()) {
            this.setFont(this.getFont().deriveFont((float)n));
        }
        if (this.getFontForWrappedMode() != null && (bl || this.isDefaultFontType())) {
            this.setFontForWrappedMode(this.getFontForWrappedMode().deriveFont((float)n));
        }
    }

    public boolean isDefaultFontType() {
        return this.defaultFontType;
    }

    private boolean checkDefaultFontType() {
        Font font = OutputOptions.getDefaultFont();
        return font.getName().equals(this.font.getName()) && font.getStyle() == this.font.getStyle();
    }

    public void setColorStandard(Color color) {
        Parameters.notNull((CharSequence)"colorStandard", (Object)color);
        if (!color.equals(this.colorStandard)) {
            Color color2 = this.colorStandard;
            this.colorStandard = color;
            this.pcs.firePropertyChange(PROP_COLOR_STANDARD, color2, color);
        }
    }

    public void setColorError(Color color) {
        Parameters.notNull((CharSequence)"colorError", (Object)color);
        if (!color.equals(this.colorError)) {
            Color color2 = this.colorError;
            this.colorError = color;
            this.pcs.firePropertyChange(PROP_COLOR_ERROR, color2, color);
        }
    }

    public void setColorInput(Color color) {
        Parameters.notNull((CharSequence)"colorError", (Object)color);
        if (!color.equals(this.colorInput)) {
            Color color2 = this.colorInput;
            this.colorInput = color;
            this.pcs.firePropertyChange(PROP_COLOR_INPUT, color2, color);
        }
    }

    public void setColorLink(Color color) {
        Parameters.notNull((CharSequence)"colorLink", (Object)color);
        if (!color.equals(this.colorLink)) {
            Color color2 = this.colorLink;
            this.colorLink = color;
            this.pcs.firePropertyChange(PROP_COLOR_LINK, color2, color);
        }
    }

    public void setColorLinkImportant(Color color) {
        Parameters.notNull((CharSequence)"colorLinkImportant", (Object)color);
        if (!color.equals(this.colorLinkImportant)) {
            Color color2 = this.colorLinkImportant;
            this.colorLinkImportant = color;
            this.pcs.firePropertyChange(PROP_COLOR_LINK_IMPORTANT, color2, color);
        }
    }

    public void setColorBackground(Color color) {
        Parameters.notNull((CharSequence)"colorBackground", (Object)color);
        if (!color.equals(this.colorBackground)) {
            Color color2 = this.colorBackground;
            this.colorBackground = color;
            this.pcs.firePropertyChange(PROP_COLOR_BACKGROUND, color2, color);
        }
    }

    public void setColorWarning(Color color) {
        Parameters.notNull((CharSequence)"colorWarning", (Object)color);
        if (!color.equals(this.colorWarning)) {
            Color color2 = this.colorWarning;
            this.colorWarning = color;
            this.pcs.firePropertyChange(PROP_COLOR_WARNING, color2, color);
        }
    }

    public void setColorFailure(Color color) {
        Parameters.notNull((CharSequence)"colorFailure", (Object)color);
        if (!color.equals(this.colorFailure)) {
            Color color2 = this.colorFailure;
            this.colorFailure = color;
            this.pcs.firePropertyChange(PROP_COLOR_FAILURE, color2, color);
        }
    }

    public void setColorSuccess(Color color) {
        Parameters.notNull((CharSequence)"colorSuccess", (Object)color);
        if (!color.equals(this.colorSuccess)) {
            Color color2 = this.colorSuccess;
            this.colorSuccess = color;
            this.pcs.firePropertyChange(PROP_COLOR_SUCCESS, color2, color);
        }
    }

    public void setColorDebug(Color color) {
        Parameters.notNull((CharSequence)"colorDebug", (Object)color);
        if (!color.equals(this.colorDebug)) {
            Color color2 = this.colorDebug;
            this.colorDebug = color;
            this.pcs.firePropertyChange(PROP_COLOR_DEBUG, color2, color);
        }
    }

    public void setLinkStyle(LinkStyle linkStyle) {
        Parameters.notNull((CharSequence)"linkStyle", (Object)((Object)linkStyle));
        if (linkStyle != this.linkStyle) {
            LinkStyle linkStyle2 = this.linkStyle;
            this.linkStyle = linkStyle;
            this.pcs.firePropertyChange(PROP_STYLE_LINK, (Object)linkStyle2, (Object)linkStyle);
        }
    }

    public static synchronized OutputOptions getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new OutputOptions(true);
        }
        return DEFAULT;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized OutputOptions makeCopy() {
        final OutputOptions outputOptions = new OutputOptions(false);
        outputOptions.font = this.font;
        outputOptions.fontWrapped = this.fontWrapped;
        outputOptions.colorStandard = this.colorStandard;
        outputOptions.colorError = this.colorError;
        outputOptions.colorInput = this.colorInput;
        outputOptions.colorBackground = this.colorBackground;
        outputOptions.colorLink = this.colorLink;
        outputOptions.colorLinkImportant = this.colorLinkImportant;
        outputOptions.colorWarning = this.colorWarning;
        outputOptions.colorFailure = this.colorFailure;
        outputOptions.colorSuccess = this.colorSuccess;
        outputOptions.colorDebug = this.colorDebug;
        outputOptions.initialized = this.initialized;
        outputOptions.linkStyle = this.linkStyle;
        if (!this.initialized) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals(OutputOptions.PROP_INITIALIZED)) {
                        outputOptions.assign(OutputOptions.this);
                        OutputOptions outputOptions2 = outputOptions;
                        synchronized (outputOptions2) {
                            outputOptions.initialized = true;
                        }
                        outputOptions.pcs.firePropertyChange(OutputOptions.PROP_INITIALIZED, false, true);
                        OutputOptions.this.removePropertyChangeListener(this);
                    }
                }
            };
            this.addPropertyChangeListener(propertyChangeListener);
        } else {
            outputOptions.initialized = true;
        }
        return outputOptions;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public void assign(OutputOptions outputOptions) {
        this.setFont(outputOptions.getFont());
        this.setFontForWrappedMode(outputOptions.getFontForWrappedMode());
        this.setColorStandard(outputOptions.getColorStandard());
        this.setColorError(outputOptions.getColorError());
        this.setColorInput(outputOptions.getColorInput());
        this.setColorLink(outputOptions.getColorLink());
        this.setColorLinkImportant(outputOptions.getColorLinkImportant());
        this.setColorBackground(outputOptions.getColorBackground());
        this.setColorDebug(outputOptions.getColorDebug());
        this.setColorWarning(outputOptions.getColorWarning());
        this.setColorFailure(outputOptions.getColorFailure());
        this.setColorSuccess(outputOptions.getColorSuccess());
        this.setLinkStyle(outputOptions.getLinkStyle());
    }

    static Color getDefaultColorStandard() {
        Color color = UIManager.getColor("nb.output.foreground");
        if (color == null && (color = UIManager.getColor("TextField.foreground")) == null) {
            color = Color.BLACK;
        }
        return color;
    }

    static Color getDefaultColorBackground() {
        Color color = UIManager.getColor("nb.output.backgorund");
        if (color == null) {
            color = UIManager.getColor("TextField.background");
            if (color == null) {
                color = Color.WHITE;
            } else if ("Nimbus".equals(UIManager.getLookAndFeel().getName())) {
                color = new Color(color.getRGB());
            }
        }
        return color;
    }

    static Color getDefaultColorError() {
        Color color = UIManager.getColor("nb.output.err.foreground");
        if (color == null) {
            color = LFCustoms.shiftColor((Color)Color.red);
        }
        return color;
    }

    static Color getDefaultColorInput() {
        Color color = UIManager.getColor("nb.output.input");
        if (color == null) {
            color = OutputOptions.getDefaultColorStandard();
        }
        return color;
    }

    static Color getDefaultColorLink() {
        Color color = UIManager.getColor("nb.output.link.foreground");
        if (color == null) {
            color = LFCustoms.shiftColor((Color)Color.blue);
        }
        return color;
    }

    static Color getDefaultColorLinkImportant() {
        Color color = UIManager.getColor("nb.output.link.foreground.important");
        if (color == null) {
            return OutputOptions.getDefaultColorLink();
        }
        return color;
    }

    static Color getDefaultColorWarning() {
        Color color = UIManager.getColor("nb.output.warning.foreground");
        if (color == null) {
            color = OutputOptions.ensureContrastingColor(Color.ORANGE, OutputOptions.getDefaultColorBackground());
        }
        return color;
    }

    static Color getDefaultColorFailure() {
        Color color = UIManager.getColor("nb.output.failure.foreground");
        if (color == null) {
            color = OutputOptions.ensureContrastingColor(Color.RED, OutputOptions.getDefaultColorBackground());
        }
        return color;
    }

    static Color getDefaultColorSuccess() {
        Color color = UIManager.getColor("nb.output.success.foreground");
        if (color == null) {
            color = OutputOptions.ensureContrastingColor(Color.GREEN.darker().darker(), OutputOptions.getDefaultColorBackground());
        }
        return color;
    }

    static Color getDefaultColorDebug() {
        Color color = UIManager.getColor("nb.output.debug.foreground");
        if (color == null) {
            color = OutputOptions.ensureContrastingColor(Color.GRAY, OutputOptions.getDefaultColorBackground());
        }
        return color;
    }

    static Color ensureContrastingColor(Color color, Color color2) {
        if (color2 == null) {
            if (OutputOptions.isNimbus()) {
                color2 = UIManager.getColor("Tree.background");
                if (null == color2) {
                    color2 = Color.WHITE;
                }
            } else {
                color2 = UIManager.getColor("text");
                if (color2 == null) {
                    color2 = Color.WHITE;
                }
            }
        }
        if (color == null) {
            if (OutputOptions.isNimbus()) {
                color = UIManager.getColor("Tree.foreground");
                if (null == color) {
                    color = Color.BLACK;
                }
            } else {
                color = UIManager.getColor("textText");
                if (color == null) {
                    color = Color.BLACK;
                }
            }
        }
        if (Color.BLACK.equals(color) && Color.WHITE.equals(color)) {
            return color;
        }
        boolean bl = color.equals(color2);
        int n = 0;
        if (!bl) {
            n = OutputOptions.difference(color, color2);
            boolean bl2 = bl = n < 60;
        }
        if (bl) {
            int n2 = OutputOptions.luminance(color2);
            boolean bl3 = n2 >= 128;
            color = bl3 ? color.darker() : color.brighter();
        }
        return color;
    }

    private static int difference(Color color, Color color2) {
        return Math.abs(OutputOptions.luminance(color) - OutputOptions.luminance(color2));
    }

    private static int luminance(Color color) {
        return (299 * color.getRed() + 587 * color.getGreen() + 114 * color.getBlue()) / 1000;
    }

    static boolean isNimbus() {
        return "Nimbus".equals(UIManager.getLookAndFeel().getID());
    }

    public Color getColorForType(IOColors.OutputType outputType) {
        switch (outputType) {
            case OUTPUT: {
                return this.getColorStandard();
            }
            case ERROR: {
                return this.getColorError();
            }
            case INPUT: {
                return this.getColorInput();
            }
            case HYPERLINK: {
                return this.getColorLink();
            }
            case HYPERLINK_IMPORTANT: {
                return this.getColorLinkImportant();
            }
            case LOG_DEBUG: {
                return this.getColorDebug();
            }
            case LOG_WARNING: {
                return this.getColorWarning();
            }
            case LOG_FAILURE: {
                return this.getColorFailure();
            }
            case LOG_SUCCESS: {
                return this.getColorSuccess();
            }
        }
        return this.getColorStandard();
    }

    public static void storeDefault() {
        if (saveScheduled.compareAndSet(false, true)) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    OutputOptions.getDefault().saveTo(NbPreferences.forModule(Controller.class));
                    saveScheduled.set(false);
                }
            }, 100);
        }
    }

    public static enum LinkStyle {
        NONE,
        UNDERLINE;

    }
}

